"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def get(hub, ctx, certificate_authority_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the certificate and certificate chain for your private certificate authority (CA) or one that has been shared with you. Both the certificate and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the chain signs the one before it.

    Args:
        certificate_authority_arn(str): The Amazon Resource Name (ARN) of your private CA. This is of the form:  arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 . .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.certificate.authority.certificate.get(ctx, certificate_authority_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.certificate.authority.certificate.get certificate_authority_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="get_certificate_authority_certificate",
        op_kwargs={"CertificateAuthorityArn": certificate_authority_arn},
    )


async def import_(
    hub,
    ctx,
    certificate_authority_arn: str,
    certificate: bytes,
    certificate_chain: bytes = None,
) -> None:
    r"""
    **Autogenerated function**

    Imports a signed private CA certificate into ACM Private CA. This action is used when you are using a chain of trust whose root is located outside ACM Private CA. Before you can call this action, the following preparations must in place:   In ACM Private CA, call the CreateCertificateAuthority action to create the private CA that you plan to back with the imported certificate.   Call the GetCertificateAuthorityCsr action to generate a certificate signing request (CSR).   Sign the CSR using a root or intermediate CA hosted by either an on-premises PKI hierarchy or by a commercial CA.   Create a certificate chain and copy the signed certificate and the certificate chain to your working directory.   ACM Private CA supports three scenarios for installing a CA certificate:   Installing a certificate for a root CA hosted by ACM Private CA.   Installing a subordinate CA certificate whose parent authority is hosted by ACM Private CA.   Installing a subordinate CA certificate whose parent authority is externally hosted.   The following additional requirements apply when you import a CA certificate.   Only a self-signed certificate can be imported as a root CA.   A self-signed certificate cannot be imported as a subordinate CA.   Your certificate chain must not include the private CA certificate that you are importing.   Your root CA must be the last certificate in your chain. The subordinate certificate, if any, that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA must come next, and so on until your chain is built.    The chain must be PEM-encoded.   The maximum allowed size of a certificate is 32 KB.   The maximum allowed size of a certificate chain is 2 MB.    Enforcement of Critical Constraints  ACM Private CA allows the following extensions to be marked critical in the imported CA certificate or chain.   Basic constraints (must be marked critical)   Subject alternative names   Key usage   Extended key usage   Authority key identifier   Subject key identifier   Issuer alternative name   Subject directory attributes   Subject information access   Certificate policies   Policy mappings   Inhibit anyPolicy   ACM Private CA rejects the following extensions when they are marked critical in an imported CA certificate or chain.   Name constraints   Policy constraints   CRL distribution points   Authority information access   Freshest CRL   Any other extension

    Args:
        certificate_authority_arn(str): The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority. This must be of the form:   arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012  .
        certificate(bytes): The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.
        certificate_chain(bytes, optional): A PEM-encoded file that contains all of your certificates, other than the certificate you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding.  This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.certificate.authority.certificate.import(ctx, certificate_authority_arn=value, certificate=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.certificate.authority.certificate.import certificate_authority_arn=value, certificate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="import_certificate_authority_certificate",
        op_kwargs={
            "CertificateAuthorityArn": certificate_authority_arn,
            "Certificate": certificate,
            "CertificateChain": certificate_chain,
        },
    )
