"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    certificate_authority_arn: str,
    s3_bucket_name: str,
    audit_report_response_format: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon S3 bucket that you specify on input. The IssueCertificate and RevokeCertificate actions use the private key.   Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see Configure Access to ACM Private CA.  ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see Encrypting Your Audit Reports.

    Args:
        certificate_authority_arn(str): The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:  arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
        s3_bucket_name(str): The name of the S3 bucket that will contain the audit report.
        audit_report_response_format(str): The format in which to create the report. This can be either JSON or CSV.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.certificate.authority.audit_report.create(
                ctx,
                certificate_authority_arn=value,
                s3_bucket_name=value,
                audit_report_response_format=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.certificate.authority.audit_report.create certificate_authority_arn=value, s3_bucket_name=value, audit_report_response_format=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="create_certificate_authority_audit_report",
        op_kwargs={
            "CertificateAuthorityArn": certificate_authority_arn,
            "S3BucketName": s3_bucket_name,
            "AuditReportResponseFormat": audit_report_response_format,
        },
    )


async def describe(
    hub, ctx, certificate_authority_arn: str, audit_report_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about a specific audit report created by calling the CreateCertificateAuthorityAuditReport action. Audit information is created every time the certificate authority (CA) private key is used. The private key is used when you call the IssueCertificate action or the RevokeCertificate action.

    Args:
        certificate_authority_arn(str): The Amazon Resource Name (ARN) of the private CA. This must be of the form:  arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 . .
        audit_report_id(str): The report ID returned by calling the CreateCertificateAuthorityAuditReport action.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.certificate.authority.audit_report.describe(
                ctx, certificate_authority_arn=value, audit_report_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.certificate.authority.audit_report.describe certificate_authority_arn=value, audit_report_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="describe_certificate_authority_audit_report",
        op_kwargs={
            "CertificateAuthorityArn": certificate_authority_arn,
            "AuditReportId": audit_report_id,
        },
    )
