"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def resend(
    hub, ctx, certificate_arn: str, domain: str, validation_domain: str
) -> None:
    r"""
    **Autogenerated function**

    Resends the email that requests domain ownership validation. The domain owner or an authorized representative must approve the ACM certificate before it can be issued. The certificate can be approved by clicking a link in the mail to navigate to the Amazon certificate approval website and then clicking I Approve. However, the validation email can be blocked by spam filters. Therefore, if you do not receive the original mail, you can request that the mail be resent within 72 hours of requesting the ACM certificate. If more than 72 hours have elapsed since your original request or since your last attempt to resend validation mail, you must request a new certificate. For more information about setting up your contact email addresses, see Configure Email for your Domain.

    Args:
        certificate_arn(str): String that contains the ARN of the requested certificate. The certificate ARN is generated and returned by the RequestCertificate action as soon as the request is made. By default, using this parameter causes email to be sent to all top-level domains you specified in the certificate request. The ARN must be of the form:   arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012 .
        domain(str): The fully qualified domain name (FQDN) of the certificate that needs to be validated.
        validation_domain(str): The base validation domain that will act as the suffix of the email addresses that are used to send the emails. This must be the same as the Domain value or a superdomain of the Domain value. For example, if you requested a certificate for site.subdomain.example.com and specify a ValidationDomain of subdomain.example.com, ACM sends email to the domain registrant, technical contact, and administrative contact in WHOIS and the following five addresses:   admin@subdomain.example.com   administrator@subdomain.example.com   hostmaster@subdomain.example.com   postmaster@subdomain.example.com   webmaster@subdomain.example.com  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.validation_email.resend(
                ctx, certificate_arn=value, domain=value, validation_domain=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.validation_email.resend certificate_arn=value, domain=value, validation_domain=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="resend_validation_email",
        op_kwargs={
            "CertificateArn": certificate_arn,
            "Domain": domain,
            "ValidationDomain": validation_domain,
        },
    )
