"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, certificate_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags that have been applied to the ACM certificate. Use the certificate's Amazon Resource Name (ARN) to specify the certificate. To add a tag to an ACM certificate, use the AddTagsToCertificate action. To delete a tag, use the RemoveTagsFromCertificate action.

    Args:
        certificate_arn(str): String that contains the ARN of the ACM certificate for which you want to list the tags. This must have the following form:  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more information about ARNs, see Amazon Resource Names (ARNs).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.tags.for_certificate.list(ctx, certificate_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.tags.for_certificate.list certificate_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="list_tags_for_certificate",
        op_kwargs={"CertificateArn": certificate_arn},
    )
