"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def delete(hub, ctx, certificate_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a certificate and its associated private key. If this action succeeds, the certificate no longer appears in the list that can be displayed by calling the ListCertificates action or be retrieved by calling the GetCertificate action. The certificate will not be available for use by Amazon Web Services services integrated with ACM.   You cannot delete an ACM certificate that is being used by another Amazon Web Services service. To delete a certificate that is in use, the certificate association must first be removed.

    Args:
        certificate_arn(str): String that contains the ARN of the ACM certificate to be deleted. This must be of the form:  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more information about ARNs, see Amazon Resource Names (ARNs).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.certificate.init.delete(ctx, certificate_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.certificate.init.delete certificate_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="delete_certificate",
        op_kwargs={"CertificateArn": certificate_arn},
    )


async def describe(hub, ctx, certificate_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed metadata about the specified ACM certificate.

    Args:
        certificate_arn(str): The Amazon Resource Name (ARN) of the ACM certificate. The ARN must have the following form:  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more information about ARNs, see Amazon Resource Names (ARNs).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.certificate.init.describe(ctx, certificate_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.certificate.init.describe certificate_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="describe_certificate",
        op_kwargs={"CertificateArn": certificate_arn},
    )


async def export(hub, ctx, certificate_arn: str, passphrase: bytes) -> Dict:
    r"""
    **Autogenerated function**

    Exports a private certificate issued by a private certificate authority (CA) for use anywhere. The exported file contains the certificate, the certificate chain, and the encrypted private 2048-bit RSA key associated with the public key that is embedded in the certificate. For security, you must assign a passphrase for the private key when exporting it.  For information about exporting and formatting a certificate using the ACM console or CLI, see Export a Private Certificate.

    Args:
        certificate_arn(str): An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:  arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012 .
        passphrase(bytes): Passphrase to associate with the encrypted exported private key. If you want to later decrypt the private key, you must have the passphrase. You can use the following OpenSSL command to decrypt a private key:   openssl rsa -in encrypted_key.pem -out decrypted_key.pem .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.certificate.init.export(ctx, certificate_arn=value, passphrase=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.certificate.init.export certificate_arn=value, passphrase=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="export_certificate",
        op_kwargs={"CertificateArn": certificate_arn, "Passphrase": passphrase},
    )


async def get(hub, ctx, certificate_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an Amazon-issued certificate and its certificate chain. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs. All of the certificates are base64 encoded. You can use OpenSSL to decode the certificates and inspect individual fields.

    Args:
        certificate_arn(str): String that contains a certificate ARN in the following format:  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more information about ARNs, see Amazon Resource Names (ARNs).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.certificate.init.get(ctx, certificate_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.certificate.init.get certificate_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="get_certificate",
        op_kwargs={"CertificateArn": certificate_arn},
    )


async def import_(
    hub,
    ctx,
    certificate: bytes,
    private_key: bytes,
    certificate_arn: str = None,
    certificate_chain: bytes = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Imports a certificate into Amazon Web Services Certificate Manager (ACM) to use with services that are integrated with ACM. Note that integrated services allow only certificate types and keys they support to be associated with their resources. Further, their support differs depending on whether the certificate is imported into IAM or into ACM. For more information, see the documentation for each service. For more information about importing certificates into ACM, see Importing Certificates in the Amazon Web Services Certificate Manager User Guide.   ACM does not provide managed renewal for certificates that you import.  Note the following guidelines when importing third party certificates:   You must enter the private key that matches the certificate you are importing.   The private key must be unencrypted. You cannot import a private key that is protected by a password or a passphrase.   The private key must be no larger than 5 KB (5,120 bytes).   If the certificate you are importing is not self-signed, you must enter its certificate chain.   If a certificate chain is included, the issuer must be the subject of one of the certificates in the chain.   The certificate, private key, and certificate chain must be PEM-encoded.   The current time must be between the Not Before and Not After certificate fields.   The Issuer field must not be empty.   The OCSP authority URL, if present, must not exceed 1000 characters.   To import a new certificate, omit the CertificateArn argument. Include this argument only when you want to replace a previously imported certificate.   When you import a certificate by using the CLI, you must specify the certificate, the certificate chain, and the private key by their file names preceded by fileb://. For example, you can specify a certificate saved in the C:\temp folder as fileb://C:\temp\certificate_to_import.pem. If you are making an HTTP or HTTPS Query request, include these arguments as BLOBs.    When you import a certificate by using an SDK, you must specify the certificate, the certificate chain, and the private key files in the manner required by the programming language you're using.    The cryptographic algorithm of an imported certificate must match the algorithm of the signing CA. For example, if the signing CA key type is RSA, then the certificate key type must also be RSA.   This operation returns the Amazon Resource Name (ARN) of the imported certificate.

    Args:
        certificate_arn(str, optional): The Amazon Resource Name (ARN) of an imported certificate to replace. To import a new certificate, omit this field. . Defaults to None.
        certificate(bytes): The certificate to import.
        private_key(bytes): The private key that matches the public key in the certificate.
        certificate_chain(bytes, optional): The PEM encoded certificate chain. Defaults to None.
        tags(List, optional): One or more resource tags to associate with the imported certificate.  Note: You cannot apply tags when reimporting a certificate. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.certificate.init.import(ctx, certificate=value, private_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.certificate.init.import certificate=value, private_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="import_certificate",
        op_kwargs={
            "CertificateArn": certificate_arn,
            "Certificate": certificate,
            "PrivateKey": private_key,
            "CertificateChain": certificate_chain,
            "Tags": tags,
        },
    )


async def list_all(
    hub,
    ctx,
    certificate_statuses: List = None,
    includes: Dict = None,
    next_token: str = None,
    max_items: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of certificate ARNs and domain names. You can request that only certificates that match a specific status be listed. You can also filter by specific attributes of the certificate. Default filtering returns only RSA_2048 certificates. For more information, see Filters.

    Args:
        certificate_statuses(List, optional): Filter the certificate list by status value. Defaults to None.
        includes(Dict, optional): Filter the certificate list. For more information, see the Filters structure. Defaults to None.
        next_token(str, optional): Use this parameter only when paginating results and only in a subsequent request after you receive a response with truncated results. Set it to the value of NextToken from the response you just received. Defaults to None.
        max_items(int, optional): Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the NextToken element is sent in the response. Use this NextToken value in a subsequent request to retrieve additional items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.certificate.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.certificate.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="list_certificates",
        op_kwargs={
            "CertificateStatuses": certificate_statuses,
            "Includes": includes,
            "NextToken": next_token,
            "MaxItems": max_items,
        },
    )


async def renew(hub, ctx, certificate_arn: str) -> None:
    r"""
    **Autogenerated function**

    Renews an eligible ACM certificate. At this time, only exported private certificates can be renewed with this operation. In order to renew your ACM PCA certificates with ACM, you must first grant the ACM service principal permission to do so. For more information, see Testing Managed Renewal in the ACM User Guide.

    Args:
        certificate_arn(str): String that contains the ARN of the ACM certificate to be renewed. This must be of the form:  arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012  For more information about ARNs, see Amazon Resource Names (ARNs).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.certificate.init.renew(ctx, certificate_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.certificate.init.renew certificate_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="renew_certificate",
        op_kwargs={"CertificateArn": certificate_arn},
    )


async def request(
    hub,
    ctx,
    domain_name: str,
    validation_method: str = None,
    subject_alternative_names: List = None,
    idempotency_token: str = None,
    domain_validation_options: List = None,
    options: Dict = None,
    certificate_authority_arn: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Requests an ACM certificate for use with other Amazon Web Services services. To request an ACM certificate, you must specify a fully qualified domain name (FQDN) in the DomainName parameter. You can also specify additional FQDNs in the SubjectAlternativeNames parameter.  If you are requesting a private certificate, domain validation is not required. If you are requesting a public certificate, each domain name that you specify must be validated to verify that you own or control the domain. You can use DNS validation or email validation. We recommend that you use DNS validation. ACM issues public certificates after receiving approval from the domain owner.   ACM behavior differs from the https://tools.ietf.org/html/rfc6125#appendix-B.2RFC 6125 specification of the certificate validation process. first checks for a subject alternative name, and, if it finds one, ignores the common name (CN)

    Args:
        domain_name(str):  Fully qualified domain name (FQDN), such as www.example.com, that you want to secure with an ACM certificate. Use an asterisk (*) to create a wildcard certificate that protects several sites in the same domain. For example, *.example.com protects www.example.com, site.example.com, and images.example.com.   The first domain name you enter cannot exceed 64 octets, including periods. Each subsequent Subject Alternative Name (SAN), however, can be up to 253 octets in length. .
        validation_method(str, optional): The method you want to use if you are requesting a public certificate to validate that you own or control domain. You can validate with DNS or validate with email. We recommend that you use DNS validation. . Defaults to None.
        subject_alternative_names(List, optional): Additional FQDNs to be included in the Subject Alternative Name extension of the ACM certificate. For example, add the name www.example.net to a certificate for which the DomainName field is www.example.com if users can reach your site by using either name. The maximum number of domain names that you can add to an ACM certificate is 100. However, the initial quota is 10 domain names. If you need more than 10 names, you must request a quota increase. For more information, see Quotas.  The maximum length of a SAN DNS name is 253 octets. The name is made up of multiple labels separated by periods. No label can be longer than 63 octets. Consider the following examples:     (63 octets).(63 octets).(63 octets).(61 octets) is legal because the total length is 253 octets (63+1+63+1+63+1+61) and no label exceeds 63 octets.    (64 octets).(63 octets).(63 octets).(61 octets) is not legal because the total length exceeds 253 octets (64+1+63+1+63+1+61) and the first label exceeds 63 octets.    (63 octets).(63 octets).(63 octets).(62 octets) is not legal because the total length of the DNS name (63+1+63+1+63+1+62) exceeds 253 octets.  . Defaults to None.
        idempotency_token(str, optional): Customer chosen string that can be used to distinguish between calls to RequestCertificate. Idempotency tokens time out after one hour. Therefore, if you call RequestCertificate multiple times with the same idempotency token within one hour, ACM recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, ACM recognizes that you are requesting multiple certificates. Defaults to None.
        domain_validation_options(List, optional): The domain name that you want ACM to use to send you emails so that you can validate domain ownership. Defaults to None.
        options(Dict, optional): Currently, you can use this parameter to specify whether to add the certificate to a certificate transparency log. Certificate transparency makes it possible to detect SSL/TLS certificates that have been mistakenly or maliciously issued. Certificates that have not been logged typically produce an error message in a browser. For more information, see Opting Out of Certificate Transparency Logging. Defaults to None.
        certificate_authority_arn(str, optional): The Amazon Resource Name (ARN) of the private certificate authority (CA) that will be used to issue the certificate. If you do not provide an ARN and you are trying to request a private certificate, ACM will attempt to issue a public certificate. For more information about private CAs, see the Amazon Web Services Certificate Manager Private Certificate Authority (PCA) user guide. The ARN must have the following form:   arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 . Defaults to None.
        tags(List, optional): One or more resource tags to associate with the certificate. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.certificate.init.request(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.certificate.init.request domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="request_certificate",
        op_kwargs={
            "DomainName": domain_name,
            "ValidationMethod": validation_method,
            "SubjectAlternativeNames": subject_alternative_names,
            "IdempotencyToken": idempotency_token,
            "DomainValidationOptions": domain_validation_options,
            "Options": options,
            "CertificateAuthorityArn": certificate_authority_arn,
            "Tags": tags,
        },
    )
