"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the account configuration options associated with an Amazon Web Services account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.account_configuration.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.account_configuration.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="acm", operation="get_account_configuration", op_kwargs={}
    )


async def put(hub, ctx, idempotency_token: str, expiry_events: Dict = None) -> None:
    r"""
    **Autogenerated function**

    Adds or modifies account-level configurations in ACM.  The supported configuration option is DaysBeforeExpiry. This option specifies the number of days prior to certificate expiration when ACM starts generating EventBridge events. ACM sends one event per day per certificate until the certificate expires. By default, accounts receive events starting 45 days before certificate expiration.

    Args:
        expiry_events(Dict, optional): Specifies expiration events associated with an account. Defaults to None.
        idempotency_token(str): Customer-chosen string used to distinguish between calls to PutAccountConfiguration. Idempotency tokens time out after one hour. If you call PutAccountConfiguration multiple times with the same unexpired idempotency token, ACM treats it as the same request and returns the original result. If you change the idempotency token for each call, ACM treats each call as a new request.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm.account_configuration.put(ctx, idempotency_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm.account_configuration.put idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm",
        operation="put_account_configuration",
        op_kwargs={
            "ExpiryEvents": expiry_events,
            "IdempotencyToken": idempotency_token,
        },
    )
