"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def start(hub, ctx, analyzer_arn: str, resource_arn: str) -> None:
    r"""
    **Autogenerated function**

    Immediately starts a scan of the policies applied to the specified resource.

    Args:
        analyzer_arn(str): The ARN of the analyzer to use to scan the policies applied to the specified resource.
        resource_arn(str): The ARN of the resource to scan.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.resource.scan.start(
                ctx, analyzer_arn=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.resource.scan.start analyzer_arn=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="start_resource_scan",
        op_kwargs={"analyzerArn": analyzer_arn, "resourceArn": resource_arn},
    )
