"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def validate(
    hub,
    ctx,
    policy_document: str,
    policy_type: str,
    locale: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices.

    Args:
        locale(str, optional): The locale to use for localizing the findings. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned. Defaults to None.
        policy_document(str): The JSON policy document to use as the content for the policy.
        policy_type(str): The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include managed and inline policies for IAM roles, users, and groups. They also include service-control policies (SCPs) that are attached to an AWS organization, organizational unit (OU), or an account. Resource policies grant permissions on AWS resources. Resource policies include trust policies for IAM roles and bucket policies for S3 buckets. You can provide a generic input such as identity policy or resource policy or a specific input such as managed policy or S3 bucket policy. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.policy.init.validate(
                ctx, policy_document=value, policy_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.policy.init.validate policy_document=value, policy_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="validate_policy",
        op_kwargs={
            "locale": locale,
            "maxResults": max_results,
            "nextToken": next_token,
            "policyDocument": policy_document,
            "policyType": policy_type,
        },
    )
