"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the requested policy generation.

    Args:
        job_id(str): The JobId that is returned by the StartPolicyGeneration operation. The JobId can be used with GetGeneratedPolicy to retrieve the generated policies or used with CancelPolicyGeneration to cancel the policy generation request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.policy.generation.cancel(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.policy.generation.cancel job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="cancel_policy_generation",
        op_kwargs={"jobId": job_id},
    )


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, principal_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the policy generations requested in the last seven days.

    Args:
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned. Defaults to None.
        principal_arn(str, optional): The ARN of the IAM entity (user or role) for which you are generating a policy. Use this with ListGeneratedPolicies to filter the results to only include results for a specific principal. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.policy.generation.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.policy.generation.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="list_policy_generations",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "principalArn": principal_arn,
        },
    )


async def start(
    hub,
    ctx,
    policy_generation_details: Dict,
    client_token: str = None,
    cloud_trail_details: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the policy generation request.

    Args:
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries with the same client token return the result from the original successful request and they have no additional effect. If you do not specify a client token, one is automatically generated by the AWS SDK. Defaults to None.
        cloud_trail_details(Dict, optional): A CloudTrailDetails object that contains details about a Trail that you want to analyze to generate policies. Defaults to None.
        policy_generation_details(Dict): Contains the ARN of the IAM entity (user or role) for which you are generating a policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.policy.generation.start(
                ctx, policy_generation_details=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.policy.generation.start policy_generation_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="start_policy_generation",
        op_kwargs={
            "clientToken": client_token,
            "cloudTrailDetails": cloud_trail_details,
            "policyGenerationDetails": policy_generation_details,
        },
    )
