"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    job_id: str,
    include_resource_placeholders: bool = None,
    include_service_level_template: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the policy that was generated using StartPolicyGeneration.

    Args:
        include_resource_placeholders(bool, optional): The level of detail that you want to generate. You can specify whether to generate policies with placeholders for resource ARNs for actions that support resource level granularity in policies. For example, in the resource section of a policy, you can receive a placeholder such as "Resource":"arn:aws:s3:::${BucketName}" instead of "*". Defaults to None.
        include_service_level_template(bool, optional): The level of detail that you want to generate. You can specify whether to generate service-level policies.  Access Analyzer uses iam:servicelastaccessed to identify services that have been used recently to create this service-level template. Defaults to None.
        job_id(str): The JobId that is returned by the StartPolicyGeneration operation. The JobId can be used with GetGeneratedPolicy to retrieve the generated policies or used with CancelPolicyGeneration to cancel the policy generation request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.generated_policy.get(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.generated_policy.get job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="get_generated_policy",
        op_kwargs={
            "includeResourcePlaceholders": include_resource_placeholders,
            "includeServiceLevelTemplate": include_service_level_template,
            "jobId": job_id,
        },
    )
