"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, analyzer_arn: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the specified finding.

    Args:
        analyzer_arn(str): The ARN of the analyzer that generated the finding.
        id_(str): The ID of the finding to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.finding.get(ctx, analyzer_arn=value, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.finding.get analyzer_arn=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="get_finding",
        op_kwargs={"analyzerArn": analyzer_arn, "id": id_},
    )


async def list_all(
    hub,
    ctx,
    analyzer_arn: str,
    filter_: Dict = None,
    max_results: int = None,
    next_token: str = None,
    sort: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of findings generated by the specified analyzer. To learn about filter keys that you can use to retrieve a list of findings, see Access Analyzer filter keys in the IAM User Guide.

    Args:
        analyzer_arn(str): The ARN of the analyzer to retrieve findings from.
        filter_(Dict, optional): A filter to match for the findings to return. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned. Defaults to None.
        sort(Dict, optional): The sort order for the findings returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.finding.list_all(ctx, analyzer_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.finding.list_all analyzer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="list_findings",
        op_kwargs={
            "analyzerArn": analyzer_arn,
            "filter": filter_,
            "maxResults": max_results,
            "nextToken": next_token,
            "sort": sort,
        },
    )


async def update_multiple(
    hub,
    ctx,
    analyzer_arn: str,
    status: str,
    client_token: str = None,
    ids: List = None,
    resource_arn: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the status for the specified findings.

    Args:
        analyzer_arn(str): The ARN of the analyzer that generated the findings to update.
        client_token(str, optional): A client token. Defaults to None.
        ids(List, optional): The IDs of the findings to update. Defaults to None.
        resource_arn(str, optional): The ARN of the resource identified in the finding. Defaults to None.
        status(str): The state represents the action to take to update the finding Status. Use ARCHIVE to change an Active finding to an Archived finding. Use ACTIVE to change an Archived finding to an Active finding.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.finding.update_multiple(
                ctx, analyzer_arn=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.finding.update_multiple analyzer_arn=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="update_findings",
        op_kwargs={
            "analyzerArn": analyzer_arn,
            "clientToken": client_token,
            "ids": ids,
            "resourceArn": resource_arn,
            "status": status,
        },
    )
