"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def apply(
    hub, ctx, analyzer_arn: str, rule_name: str, client_token: str = None
) -> None:
    r"""
    **Autogenerated function**

    Retroactively applies the archive rule to existing findings that meet the archive rule criteria.

    Args:
        analyzer_arn(str): The Amazon resource name (ARN) of the analyzer.
        client_token(str, optional): A client token. Defaults to None.
        rule_name(str): The name of the rule to apply.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.archive_rule.apply(
                ctx, analyzer_arn=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.archive_rule.apply analyzer_arn=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="apply_archive_rule",
        op_kwargs={
            "analyzerArn": analyzer_arn,
            "clientToken": client_token,
            "ruleName": rule_name,
        },
    )


async def create(
    hub,
    ctx,
    analyzer_name: str,
    filter_: Dict,
    rule_name: str,
    client_token: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule. To learn about filter keys that you can use to create an archive rule, see Access Analyzer filter keys in the IAM User Guide.

    Args:
        analyzer_name(str): The name of the created analyzer.
        client_token(str, optional): A client token. Defaults to None.
        filter_(Dict): The criteria for the rule.
        rule_name(str): The name of the rule to create.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.archive_rule.create(
                ctx, analyzer_name=value, filter_=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.archive_rule.create analyzer_name=value, filter_=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="create_archive_rule",
        op_kwargs={
            "analyzerName": analyzer_name,
            "clientToken": client_token,
            "filter": filter_,
            "ruleName": rule_name,
        },
    )


async def delete(
    hub, ctx, analyzer_name: str, rule_name: str, client_token: str = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified archive rule.

    Args:
        analyzer_name(str): The name of the analyzer that associated with the archive rule to delete.
        client_token(str, optional): A client token. Defaults to None.
        rule_name(str): The name of the rule to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.archive_rule.delete(
                ctx, analyzer_name=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.archive_rule.delete analyzer_name=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="delete_archive_rule",
        op_kwargs={
            "analyzerName": analyzer_name,
            "clientToken": client_token,
            "ruleName": rule_name,
        },
    )


async def get(hub, ctx, analyzer_name: str, rule_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an archive rule. To learn about filter keys that you can use to create an archive rule, see Access Analyzer filter keys in the IAM User Guide.

    Args:
        analyzer_name(str): The name of the analyzer to retrieve rules from.
        rule_name(str): The name of the rule to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.archive_rule.get(
                ctx, analyzer_name=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.archive_rule.get analyzer_name=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="get_archive_rule",
        op_kwargs={"analyzerName": analyzer_name, "ruleName": rule_name},
    )


async def list_all(
    hub, ctx, analyzer_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of archive rules created for the specified analyzer.

    Args:
        analyzer_name(str): The name of the analyzer to retrieve rules from.
        max_results(int, optional): The maximum number of results to return in the request. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.archive_rule.list_all(ctx, analyzer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.archive_rule.list_all analyzer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="list_archive_rules",
        op_kwargs={
            "analyzerName": analyzer_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    analyzer_name: str,
    filter_: Dict,
    rule_name: str,
    client_token: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the criteria and values for the specified archive rule.

    Args:
        analyzer_name(str): The name of the analyzer to update the archive rules for.
        client_token(str, optional): A client token. Defaults to None.
        filter_(Dict): A filter to match for the rules to update. Only rules that match the filter are updated.
        rule_name(str): The name of the rule to update.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.archive_rule.update(
                ctx, analyzer_name=value, filter_=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.archive_rule.update analyzer_name=value, filter_=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="update_archive_rule",
        op_kwargs={
            "analyzerName": analyzer_name,
            "clientToken": client_token,
            "filter": filter_,
            "ruleName": rule_name,
        },
    )
