"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    analyzer_name: str,
    type_: str,
    archive_rules: List = None,
    client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an analyzer for your account.

    Args:
        analyzer_name(str): The name of the analyzer to create.
        archive_rules(List, optional): Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule. Defaults to None.
        client_token(str, optional): A client token. Defaults to None.
        tags(Dict, optional): The tags to apply to the analyzer. Defaults to None.
        type_(str): The type of analyzer to create. Only ACCOUNT and ORGANIZATION analyzers are supported. You can create only one analyzer per account per Region. You can create up to 5 analyzers per organization per Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.analyzer.create(
                ctx, analyzer_name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.analyzer.create analyzer_name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="create_analyzer",
        op_kwargs={
            "analyzerName": analyzer_name,
            "archiveRules": archive_rules,
            "clientToken": client_token,
            "tags": tags,
            "type": type_,
        },
    )


async def delete(hub, ctx, analyzer_name: str, client_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified analyzer. When you delete an analyzer, Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.

    Args:
        analyzer_name(str): The name of the analyzer to delete.
        client_token(str, optional): A client token. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.analyzer.delete(ctx, analyzer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.analyzer.delete analyzer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="delete_analyzer",
        op_kwargs={"analyzerName": analyzer_name, "clientToken": client_token},
    )


async def get(hub, ctx, analyzer_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the specified analyzer.

    Args:
        analyzer_name(str): The name of the analyzer retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.analyzer.get(ctx, analyzer_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.analyzer.get analyzer_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="get_analyzer",
        op_kwargs={"analyzerName": analyzer_name},
    )


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, type_: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of analyzers.

    Args:
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned. Defaults to None.
        type_(str, optional): The type of analyzer. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.analyzer.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.analyzer.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="list_analyzers",
        op_kwargs={"maxResults": max_results, "nextToken": next_token, "type": type_},
    )
