"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, analyzer_arn: str, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a resource that was analyzed.

    Args:
        analyzer_arn(str): The ARN of the analyzer to retrieve information from.
        resource_arn(str): The ARN of the resource to retrieve information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.analyzed_resource.get(
                ctx, analyzer_arn=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.analyzed_resource.get analyzer_arn=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="get_analyzed_resource",
        op_kwargs={"analyzerArn": analyzer_arn, "resourceArn": resource_arn},
    )


async def list_all(
    hub,
    ctx,
    analyzer_arn: str,
    max_results: int = None,
    next_token: str = None,
    resource_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..

    Args:
        analyzer_arn(str): The ARN of the analyzer to retrieve a list of analyzed resources from.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned. Defaults to None.
        resource_type(str, optional): The type of resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.analyzed_resource.list_all(
                ctx, analyzer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.analyzed_resource.list_all analyzer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="list_analyzed_resources",
        op_kwargs={
            "analyzerArn": analyzer_arn,
            "maxResults": max_results,
            "nextToken": next_token,
            "resourceType": resource_type,
        },
    )
