"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, analyzer_arn: str, configurations: Dict, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an access preview that allows you to preview Access Analyzer findings for your resource before deploying resource permissions.

    Args:
        analyzer_arn(str): The ARN of the account analyzer used to generate the access preview. You can only create an access preview for analyzers with an Account type and Active status.
        client_token(str, optional): A client token. Defaults to None.
        configurations(Dict): Access control configuration for your resource that is used to generate the access preview. The access preview includes findings for external access allowed to the resource with the proposed access control configuration. The configuration must contain exactly one element.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.access_preview.init.create(
                ctx, analyzer_arn=value, configurations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.access_preview.init.create analyzer_arn=value, configurations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="create_access_preview",
        op_kwargs={
            "analyzerArn": analyzer_arn,
            "clientToken": client_token,
            "configurations": configurations,
        },
    )


async def get(hub, ctx, access_preview_id: str, analyzer_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an access preview for the specified analyzer.

    Args:
        access_preview_id(str): The unique ID for the access preview.
        analyzer_arn(str): The ARN of the analyzer used to generate the access preview.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.access_preview.init.get(
                ctx, access_preview_id=value, analyzer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.access_preview.init.get access_preview_id=value, analyzer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="get_access_preview",
        op_kwargs={"accessPreviewId": access_preview_id, "analyzerArn": analyzer_arn},
    )


async def list_all(
    hub, ctx, analyzer_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of access previews for the specified analyzer.

    Args:
        analyzer_arn(str): The ARN of the analyzer used to generate the access preview.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.access_preview.init.list_all(
                ctx, analyzer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.access_preview.init.list_all analyzer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="list_access_previews",
        op_kwargs={
            "analyzerArn": analyzer_arn,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
