"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    access_preview_id: str,
    analyzer_arn: str,
    filter_: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of access preview findings generated by the specified access preview.

    Args:
        access_preview_id(str): The unique ID for the access preview.
        analyzer_arn(str): The ARN of the analyzer used to generate the access.
        filter_(Dict, optional): Criteria to filter the returned findings. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the response. Defaults to None.
        next_token(str, optional): A token used for pagination of results returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.accessanalyzer.access_preview.finding.list_all(
                ctx, access_preview_id=value, analyzer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.accessanalyzer.access_preview.finding.list_all access_preview_id=value, analyzer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="accessanalyzer",
        operation="list_access_preview_findings",
        op_kwargs={
            "accessPreviewId": access_preview_id,
            "analyzerArn": analyzer_arn,
            "filter": filter_,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
