/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils.graph;

import codeintelligence.codeanalysis.utils.StringUtils;
import codeintelligence.codeanalysis.utils.graph.Edge;
import codeintelligence.codeanalysis.utils.graph.Graph;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class GraphWriter {
    public static <V, E> void writeDOT(Graph<V, E> graph, String filePath) throws IOException {
        if (!filePath.toLowerCase().endsWith(".dot")) {
            throw new IllegalArgumentException("File-path does not end with .dot suffix!");
        }
        String filename = new File(filePath).getName();
        try (PrintWriter dot = new PrintWriter(filePath, "UTF-8");){
            String edgeSymbol;
            String graphName = filename.substring(0, filename.lastIndexOf(46));
            if (graph.isDirected()) {
                dot.println("digraph " + graphName + " {");
                edgeSymbol = " -> ";
            } else {
                dot.println("graph " + graphName + " {");
                edgeSymbol = " -- ";
            }
            dot.println("  // graph-vertices");
            LinkedHashMap<V, CallSite> nodeNames = new LinkedHashMap<V, CallSite>();
            int nodeCounter = 1;
            Iterator<V> vertices = graph.allVerticesIterator();
            while (vertices.hasNext()) {
                V node = vertices.next();
                String name = "v" + nodeCounter++;
                nodeNames.put(node, (CallSite)((Object)name));
                StringBuilder label = new StringBuilder("  [label=\"");
                if (!node.toString().trim().isEmpty()) {
                    label.append(StringUtils.escape(node.toString()));
                }
                dot.println("  " + name + label.append("\"];").toString());
            }
            dot.println("  // graph-edges");
            Iterator<Edge<V, E>> edges = graph.allEdgesIterator();
            while (edges.hasNext()) {
                Edge<V, E> edge = edges.next();
                String src = (String)nodeNames.get(edge.source);
                String trg = (String)nodeNames.get(edge.target);
                if (edge.label == null || edge.label.toString().trim().isEmpty()) {
                    dot.println("  " + src + edgeSymbol + trg + ";");
                    continue;
                }
                dot.println("  " + src + edgeSymbol + trg + "  [label=\"" + StringUtils.escape(edge.label.toString()) + "\"];");
            }
            dot.println("  // end-of-graph\n}");
        }
    }

    public static <V, E> void writeJSON(Graph<V, E> graph, String filePath) {
        throw new UnsupportedOperationException("Writing Graphs to JSON is NOT Implemented Yet!");
    }
}

