/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.dependence.cfg;

import codeintelligence.codeanalysis.extractors.antlrparser.JavaBaseVisitor;
import codeintelligence.codeanalysis.extractors.antlrparser.JavaLexer;
import codeintelligence.codeanalysis.extractors.antlrparser.JavaParser;
import codeintelligence.codeanalysis.extractors.dependence.DEPNode;
import codeintelligence.codeanalysis.extractors.dependence.cfg.CFEdge;
import codeintelligence.codeanalysis.extractors.dependence.cfg.ControlFlowGraph;
import codeintelligence.codeanalysis.utils.Logger;
import codeintelligence.codeanalysis.utils.graph.Digraph;
import codeintelligence.codeanalysis.utils.graph.Edge;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class CFGBuilder {
    public static List<ControlFlowGraph> buildWithCode(String code) throws IOException {
        Logger.info("Parsing source code ... ");
        ANTLRInputStream input = new ANTLRInputStream(code);
        JavaLexer lexer = new JavaLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavaParser parser = new JavaParser(tokens);
        JavaParser.CompilationUnitContext parseTree = parser.compilationUnit();
        return CFGBuilder.build(parseTree);
    }

    public static List<ControlFlowGraph> build(String file) throws IOException {
        Logger.info("Parsing source file ... ");
        FileInputStream inFile = new FileInputStream(file);
        ANTLRInputStream input = new ANTLRInputStream(inFile);
        JavaLexer lexer = new JavaLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavaParser parser = new JavaParser(tokens);
        JavaParser.CompilationUnitContext parseTree = parser.compilationUnit();
        return CFGBuilder.build(parseTree);
    }

    public static List<ControlFlowGraph> build(ParseTree tree) {
        Digraph<DEPNode, CFEdge> wholeCFG = new Digraph<DEPNode, CFEdge>();
        HashMap<DEPNode, List<DEPNode>> entry2params = new HashMap<DEPNode, List<DEPNode>>();
        ControlFlowVisitor visitor = new ControlFlowVisitor(wholeCFG, entry2params);
        visitor.visit(tree);
        return CFGBuilder.splitGraph(wholeCFG, entry2params);
    }

    public static List<ControlFlowGraph> splitGraph(Digraph<DEPNode, CFEdge> wholeCFG, Map<DEPNode, List<DEPNode>> entry2params) {
        ArrayList<ControlFlowGraph> cfgs = new ArrayList<ControlFlowGraph>();
        for (Map.Entry<DEPNode, List<DEPNode>> entry : entry2params.entrySet()) {
            DEPNode methodEntry = entry.getKey();
            List<DEPNode> params = entry.getValue();
            ControlFlowGraph cfg = new ControlFlowGraph(methodEntry.getCode());
            cfg.setEntry(methodEntry);
            cfgs.add(cfg);
            ArrayDeque<DEPNode> waiting = new ArrayDeque<DEPNode>();
            HashSet<DEPNode> visitedNodes = new HashSet<DEPNode>();
            cfg.addVertex(methodEntry);
            waiting.push(methodEntry);
            visitedNodes.add(methodEntry);
            while (!waiting.isEmpty()) {
                DEPNode current = (DEPNode)waiting.pop();
                Iterator outEdges = wholeCFG.outgoingEdgesIterator(current);
                while (outEdges.hasNext()) {
                    Edge edge = outEdges.next();
                    if (!visitedNodes.contains(edge.target)) {
                        cfg.addVertex((DEPNode)edge.target);
                        waiting.push((DEPNode)edge.target);
                        visitedNodes.add((DEPNode)edge.target);
                    }
                    if (!visitedNodes.contains(edge.target)) continue;
                    cfg.addEdge(edge);
                }
            }
        }
        return cfgs;
    }

    private static class ControlFlowVisitor
    extends JavaBaseVisitor<Void> {
        private Digraph<DEPNode, CFEdge> cfg;
        private Map<DEPNode, List<DEPNode>> entry2params;
        private Deque<DEPNode> preNodes = new ArrayDeque<DEPNode>();
        private Deque<String> preEdges = new ArrayDeque<String>();
        private Deque<Block> loopBlocks = new ArrayDeque<Block>();
        private List<Block> labeledBlocks = new ArrayList<Block>();
        private Deque<Block> tryBlocks = new ArrayDeque<Block>();
        private Queue<DEPNode> casesQueue = new ArrayDeque<DEPNode>();
        private boolean dontPop = false;
        private Deque<String> classNames = new ArrayDeque<String>();

        public ControlFlowVisitor(Digraph<DEPNode, CFEdge> cfg, Map<DEPNode, List<DEPNode>> entry2params) {
            this.cfg = cfg;
            this.entry2params = entry2params;
        }

        private void init() {
            this.preNodes.clear();
            this.preEdges.clear();
            this.loopBlocks.clear();
            this.labeledBlocks.clear();
            this.tryBlocks.clear();
            this.dontPop = false;
        }

        private void addContextualProperty(DEPNode node, ParserRuleContext ctx) {
            node.setRuleCtx(ctx);
        }

        @Override
        public Void visitPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
            return null;
        }

        @Override
        public Void visitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.classNames.push(ctx.Identifier().getText());
            this.visit(ctx.classBody());
            this.classNames.pop();
            return null;
        }

        @Override
        public Void visitEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            return null;
        }

        @Override
        public Void visitInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            return null;
        }

        @Override
        public Void visitClassBodyDeclaration(JavaParser.ClassBodyDeclarationContext ctx) {
            if (ctx.block() != null) {
                this.init();
                DEPNode block = new DEPNode();
                this.entry2params.put(block, new ArrayList());
                if (ctx.getChildCount() == 2 && ctx.getChild(0).getText().equals("static")) {
                    block.setLineOfCode(ctx.getStart().getLine());
                    block.setCode("static");
                } else {
                    block.setLineOfCode(-1);
                    block.setCode("block");
                }
                this.addContextualProperty(block, ctx);
                this.cfg.addVertex(block);
                block.setProperty("name", "static-block");
                block.setProperty("class", this.classNames.peek());
                this.preNodes.push(block);
                this.preEdges.push("");
            }
            return (Void)this.visitChildren(ctx);
        }

        @Override
        public Void visitConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            this.init();
            DEPNode entry = new DEPNode();
            ArrayList<DEPNode> params = new ArrayList<DEPNode>();
            this.entry2params.put(entry, params);
            entry.setLineOfCode(ctx.getStart().getLine());
            entry.setCode(ctx.Identifier().getText() + " " + this.getOriginalCodeText(ctx.formalParameters()));
            this.addContextualProperty(entry, ctx);
            this.cfg.addVertex(entry);
            entry.setProperty("name", ctx.Identifier().getText());
            entry.setProperty("class", this.classNames.peek());
            if (ctx.formalParameters().formalParameterList() != null) {
                for (JavaParser.FormalParameterContext prm : ctx.formalParameters().formalParameterList().formalParameter()) {
                    DEPNode param = new DEPNode();
                    param.setLineOfCode(prm.getStart().getLine());
                    param.setCode(this.getOriginalCodeText(prm));
                    this.addContextualProperty(param, prm);
                    param.setProperty("type", prm.typeType().getText());
                    param.setProperty("name", prm.variableDeclaratorId().Identifier().getText());
                    params.add(param);
                }
                JavaParser.LastFormalParameterContext lastParam = ctx.formalParameters().formalParameterList().lastFormalParameter();
                if (lastParam != null) {
                    DEPNode param = new DEPNode();
                    param.setLineOfCode(lastParam.getStart().getLine());
                    param.setCode(this.getOriginalCodeText(lastParam));
                    this.addContextualProperty(param, lastParam);
                    param.setProperty("type", lastParam.typeType().getText());
                    param.setProperty("name", lastParam.variableDeclaratorId().Identifier().getText());
                    params.add(param);
                }
            }
            this.preNodes.push(entry);
            this.preEdges.push("");
            return (Void)this.visitChildren(ctx);
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            this.init();
            DEPNode entry = new DEPNode();
            ArrayList<DEPNode> params = new ArrayList<DEPNode>();
            this.entry2params.put(entry, params);
            entry.setLineOfCode(ctx.getStart().getLine());
            String retType = "void";
            if (ctx.typeType() != null) {
                retType = ctx.typeType().getText();
            }
            String args = this.getOriginalCodeText(ctx.formalParameters());
            entry.setCode(retType + " " + ctx.Identifier() + args);
            this.addContextualProperty(entry, ctx);
            this.cfg.addVertex(entry);
            entry.setProperty("name", ctx.Identifier().getText());
            entry.setProperty("class", this.classNames.peek());
            entry.setProperty("type", retType);
            if (ctx.formalParameters().formalParameterList() != null) {
                for (JavaParser.FormalParameterContext prm : ctx.formalParameters().formalParameterList().formalParameter()) {
                    DEPNode param = new DEPNode();
                    param.setLineOfCode(prm.getStart().getLine());
                    param.setCode(this.getOriginalCodeText(prm));
                    this.addContextualProperty(param, prm);
                    param.setProperty("type", prm.typeType().getText());
                    param.setProperty("name", prm.variableDeclaratorId().Identifier().getText());
                    params.add(param);
                }
                JavaParser.LastFormalParameterContext lastParam = ctx.formalParameters().formalParameterList().lastFormalParameter();
                if (lastParam != null) {
                    DEPNode param = new DEPNode();
                    param.setLineOfCode(lastParam.getStart().getLine());
                    param.setCode(this.getOriginalCodeText(lastParam));
                    this.addContextualProperty(param, lastParam);
                    param.setProperty("type", lastParam.typeType().getText());
                    param.setProperty("name", lastParam.variableDeclaratorId().Identifier().getText());
                    params.add(param);
                }
            }
            this.preNodes.push(entry);
            this.preEdges.push("");
            return (Void)this.visitChildren(ctx);
        }

        @Override
        public Void visitStatementExpression(JavaParser.StatementExpressionContext ctx) {
            DEPNode expr = new DEPNode();
            expr.setLineOfCode(ctx.getStart().getLine());
            expr.setCode(this.getOriginalCodeText(ctx));
            Logger.debug(expr.getLineOfCode() + ": " + expr.getCode());
            this.addContextualProperty(expr, ctx);
            this.addNodeAndPreEdge(expr);
            this.preEdges.push("");
            this.preNodes.push(expr);
            return null;
        }

        @Override
        public Void visitLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
            DEPNode declr = new DEPNode();
            declr.setLineOfCode(ctx.getStart().getLine());
            declr.setCode(this.getOriginalCodeText(ctx));
            this.addContextualProperty(declr, ctx);
            this.addNodeAndPreEdge(declr);
            this.preEdges.push("");
            this.preNodes.push(declr);
            return null;
        }

        @Override
        public Void visitIfStatement(JavaParser.IfStatementContext ctx) {
            DEPNode ifNode = new DEPNode();
            ifNode.setLineOfCode(ctx.getStart().getLine());
            ifNode.setCode("if " + this.getOriginalCodeText(ctx.parExpression()));
            this.addContextualProperty(ifNode, ctx);
            this.addNodeAndPreEdge(ifNode);
            this.preEdges.push("True");
            this.preNodes.push(ifNode);
            this.visit(ctx.statement(0));
            DEPNode endif = new DEPNode();
            endif.setLineOfCode(-1);
            endif.setCode("endif");
            this.addNodeAndPreEdge(endif);
            if (ctx.statement().size() == 1) {
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(ifNode, new CFEdge("False"), endif));
            } else {
                this.preEdges.push("False");
                this.preNodes.push(ifNode);
                this.visit(ctx.statement(1));
                this.popAddPreEdgeTo(endif);
            }
            this.preEdges.push("");
            this.preNodes.push(endif);
            return null;
        }

        @Override
        public Void visitForStatement(JavaParser.ForStatementContext ctx) {
            if (ctx.forControl().enhancedForControl() != null) {
                DEPNode forExpr = new DEPNode();
                forExpr.setLineOfCode(ctx.forControl().getStart().getLine());
                forExpr.setCode("for (" + this.getOriginalCodeText(ctx.forControl()) + ")");
                this.addContextualProperty(forExpr, ctx.forControl().enhancedForControl());
                this.addNodeAndPreEdge(forExpr);
                DEPNode forEnd = new DEPNode();
                forEnd.setLineOfCode(-1);
                forEnd.setCode("endfor");
                this.cfg.addVertex(forEnd);
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(forExpr, new CFEdge("False"), forEnd));
                this.preEdges.push("True");
                this.preNodes.push(forExpr);
                this.loopBlocks.push(new Block(forExpr, forEnd));
                this.visit(ctx.statement());
                this.loopBlocks.pop();
                this.popAddPreEdgeTo(forExpr);
                this.preEdges.push("");
                this.preNodes.push(forEnd);
            } else {
                DEPNode forInit = null;
                if (ctx.forControl().forInit() != null) {
                    forInit = new DEPNode();
                    forInit.setLineOfCode(ctx.forControl().forInit().getStart().getLine());
                    forInit.setCode(this.getOriginalCodeText(ctx.forControl().forInit()));
                    this.addContextualProperty(forInit, ctx.forControl().forInit());
                    this.addNodeAndPreEdge(forInit);
                }
                DEPNode forExpr = new DEPNode();
                if (ctx.forControl().expression() == null) {
                    forExpr.setLineOfCode(ctx.forControl().getStart().getLine());
                    forExpr.setCode("for ( ; )");
                } else {
                    forExpr.setLineOfCode(ctx.forControl().expression().getStart().getLine());
                    forExpr.setCode("for (" + this.getOriginalCodeText(ctx.forControl().expression()) + ")");
                }
                this.addContextualProperty(forExpr, ctx.forControl().expression());
                this.cfg.addVertex(forExpr);
                if (forInit != null) {
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(forInit, new CFEdge(""), forExpr));
                } else {
                    this.popAddPreEdgeTo(forExpr);
                }
                DEPNode forUpdate = new DEPNode();
                if (ctx.forControl().forUpdate() == null) {
                    forUpdate.setCode(" ; ");
                    forUpdate.setLineOfCode(ctx.forControl().getStart().getLine());
                } else {
                    forUpdate.setCode(this.getOriginalCodeText(ctx.forControl().forUpdate()));
                    forUpdate.setLineOfCode(ctx.forControl().forUpdate().getStart().getLine());
                }
                this.addContextualProperty(forUpdate, ctx.forControl().forUpdate());
                this.cfg.addVertex(forUpdate);
                DEPNode forEnd = new DEPNode();
                forEnd.setLineOfCode(-1);
                forEnd.setCode("endfor");
                this.cfg.addVertex(forEnd);
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(forExpr, new CFEdge("False"), forEnd));
                this.preEdges.push("True");
                this.preNodes.push(forExpr);
                this.loopBlocks.push(new Block(forUpdate, forEnd));
                this.visit(ctx.statement());
                this.loopBlocks.pop();
                this.popAddPreEdgeTo(forUpdate);
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(forUpdate, new CFEdge(""), forExpr));
                this.preEdges.push("");
                this.preNodes.push(forEnd);
            }
            return null;
        }

        @Override
        public Void visitWhileStatement(JavaParser.WhileStatementContext ctx) {
            DEPNode whileNode = new DEPNode();
            whileNode.setLineOfCode(ctx.getStart().getLine());
            whileNode.setCode("while " + this.getOriginalCodeText(ctx.parExpression()));
            this.addContextualProperty(whileNode, ctx);
            this.addNodeAndPreEdge(whileNode);
            DEPNode endwhile = new DEPNode();
            endwhile.setLineOfCode(-1);
            endwhile.setCode("endwhile");
            this.cfg.addVertex(endwhile);
            this.cfg.addEdge(new Edge<DEPNode, CFEdge>(whileNode, new CFEdge("False"), endwhile));
            this.preEdges.push("True");
            this.preNodes.push(whileNode);
            this.loopBlocks.push(new Block(whileNode, endwhile));
            this.visit(ctx.statement());
            this.loopBlocks.pop();
            this.popAddPreEdgeTo(whileNode);
            this.preEdges.push("");
            this.preNodes.push(endwhile);
            return null;
        }

        @Override
        public Void visitDoWhileStatement(JavaParser.DoWhileStatementContext ctx) {
            DEPNode doNode = new DEPNode();
            doNode.setLineOfCode(ctx.getStart().getLine());
            doNode.setCode("do");
            this.addNodeAndPreEdge(doNode);
            DEPNode whileNode = new DEPNode();
            whileNode.setLineOfCode(ctx.parExpression().getStart().getLine());
            whileNode.setCode("while " + this.getOriginalCodeText(ctx.parExpression()));
            this.addContextualProperty(whileNode, ctx);
            this.cfg.addVertex(whileNode);
            DEPNode doWhileEnd = new DEPNode();
            doWhileEnd.setLineOfCode(-1);
            doWhileEnd.setCode("end-do-while");
            this.cfg.addVertex(doWhileEnd);
            this.preEdges.push("");
            this.preNodes.push(doNode);
            this.loopBlocks.push(new Block(whileNode, doWhileEnd));
            this.visit(ctx.statement());
            this.loopBlocks.pop();
            this.popAddPreEdgeTo(whileNode);
            this.cfg.addEdge(new Edge<DEPNode, CFEdge>(whileNode, new CFEdge("True"), doNode));
            this.cfg.addEdge(new Edge<DEPNode, CFEdge>(whileNode, new CFEdge("False"), doWhileEnd));
            this.preEdges.push("");
            this.preNodes.push(doWhileEnd);
            return null;
        }

        @Override
        public Void visitSwitchStatement(JavaParser.SwitchStatementContext ctx) {
            DEPNode switchNode = new DEPNode();
            switchNode.setLineOfCode(ctx.getStart().getLine());
            switchNode.setCode("switch " + this.getOriginalCodeText(ctx.parExpression()));
            this.addContextualProperty(switchNode, ctx);
            this.addNodeAndPreEdge(switchNode);
            DEPNode endSwitch = new DEPNode();
            endSwitch.setLineOfCode(-1);
            endSwitch.setCode("end-switch");
            this.cfg.addVertex(endSwitch);
            this.preEdges.push("");
            this.preNodes.push(switchNode);
            this.loopBlocks.push(new Block(switchNode, endSwitch));
            DEPNode preCase = null;
            for (JavaParser.SwitchBlockStatementGroupContext grp : ctx.switchBlockStatementGroup()) {
                preCase = this.visitSwitchLabels(grp.switchLabel(), preCase);
                for (JavaParser.BlockStatementContext blk : grp.blockStatement()) {
                    this.visit(blk);
                }
            }
            preCase = this.visitSwitchLabels(ctx.switchLabel(), preCase);
            this.loopBlocks.pop();
            this.popAddPreEdgeTo(endSwitch);
            if (preCase != null) {
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(preCase, new CFEdge("False"), endSwitch));
            }
            this.preEdges.push("");
            this.preNodes.push(endSwitch);
            return null;
        }

        private DEPNode visitSwitchLabels(List<JavaParser.SwitchLabelContext> list, DEPNode preCase) {
            DEPNode caseStmnt = preCase;
            for (JavaParser.SwitchLabelContext ctx : list) {
                caseStmnt = new DEPNode();
                caseStmnt.setLineOfCode(ctx.getStart().getLine());
                caseStmnt.setCode(this.getOriginalCodeText(ctx));
                this.cfg.addVertex(caseStmnt);
                if (this.dontPop) {
                    this.dontPop = false;
                } else {
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(this.preNodes.pop(), new CFEdge(this.preEdges.pop()), caseStmnt));
                }
                if (preCase != null) {
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(preCase, new CFEdge("False"), caseStmnt));
                }
                if (ctx.getStart().getText().equals("default")) {
                    this.preEdges.push("");
                    this.preNodes.push(caseStmnt);
                    caseStmnt = null;
                    continue;
                }
                this.dontPop = true;
                this.casesQueue.add(caseStmnt);
                preCase = caseStmnt;
            }
            return caseStmnt;
        }

        @Override
        public Void visitLabelStatement(JavaParser.LabelStatementContext ctx) {
            DEPNode labelNode = new DEPNode();
            labelNode.setLineOfCode(ctx.getStart().getLine());
            labelNode.setCode(ctx.Identifier() + ": ");
            this.addContextualProperty(labelNode, ctx);
            this.addNodeAndPreEdge(labelNode);
            DEPNode endLabelNode = new DEPNode();
            endLabelNode.setLineOfCode(-1);
            endLabelNode.setCode("end-label");
            this.cfg.addVertex(endLabelNode);
            this.preEdges.push("");
            this.preNodes.push(labelNode);
            this.labeledBlocks.add(new Block(labelNode, endLabelNode, ctx.Identifier().getText()));
            this.visit(ctx.statement());
            this.popAddPreEdgeTo(endLabelNode);
            this.preEdges.push("");
            this.preNodes.push(endLabelNode);
            return null;
        }

        @Override
        public Void visitReturnStatement(JavaParser.ReturnStatementContext ctx) {
            DEPNode ret = new DEPNode();
            ret.setLineOfCode(ctx.getStart().getLine());
            ret.setCode(this.getOriginalCodeText(ctx));
            this.addContextualProperty(ret, ctx);
            this.addNodeAndPreEdge(ret);
            this.dontPop = true;
            return null;
        }

        @Override
        public Void visitBreakStatement(JavaParser.BreakStatementContext ctx) {
            DEPNode breakNode = new DEPNode();
            breakNode.setLineOfCode(ctx.getStart().getLine());
            breakNode.setCode(this.getOriginalCodeText(ctx));
            this.addContextualProperty(breakNode, ctx);
            this.addNodeAndPreEdge(breakNode);
            if (ctx.Identifier() != null) {
                for (Block block : this.labeledBlocks) {
                    if (!block.label.equals(ctx.Identifier().getText())) continue;
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(breakNode, new CFEdge(""), block.end));
                    break;
                }
            } else {
                Block block = this.loopBlocks.peek();
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(breakNode, new CFEdge(""), block.end));
            }
            this.dontPop = true;
            return null;
        }

        @Override
        public Void visitContinueStatement(JavaParser.ContinueStatementContext ctx) {
            DEPNode continueNode = new DEPNode();
            continueNode.setLineOfCode(ctx.getStart().getLine());
            continueNode.setCode(this.getOriginalCodeText(ctx));
            this.addContextualProperty(continueNode, ctx);
            this.addNodeAndPreEdge(continueNode);
            if (ctx.Identifier() != null) {
                for (Block block : this.labeledBlocks) {
                    if (!block.label.equals(ctx.Identifier().getText())) continue;
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(continueNode, new CFEdge(""), block.start));
                    break;
                }
            } else {
                Block block = this.loopBlocks.peek();
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(continueNode, new CFEdge(""), block.start));
            }
            this.dontPop = true;
            return null;
        }

        @Override
        public Void visitSynchBlockStatement(JavaParser.SynchBlockStatementContext ctx) {
            DEPNode syncStmt = new DEPNode();
            syncStmt.setLineOfCode(ctx.getStart().getLine());
            syncStmt.setCode("synchronized " + this.getOriginalCodeText(ctx.parExpression()));
            this.addContextualProperty(syncStmt, ctx);
            this.addNodeAndPreEdge(syncStmt);
            this.preEdges.push("");
            this.preNodes.push(syncStmt);
            this.visit(ctx.block());
            DEPNode endSyncBlock = new DEPNode();
            endSyncBlock.setLineOfCode(-1);
            endSyncBlock.setCode("end-synchronized");
            this.addNodeAndPreEdge(endSyncBlock);
            this.preEdges.push("");
            this.preNodes.push(endSyncBlock);
            return null;
        }

        @Override
        public Void visitTryStatement(JavaParser.TryStatementContext ctx) {
            DEPNode tryNode = new DEPNode();
            tryNode.setLineOfCode(ctx.getStart().getLine());
            tryNode.setCode("try");
            this.addContextualProperty(tryNode, ctx);
            this.addNodeAndPreEdge(tryNode);
            DEPNode endTry = new DEPNode();
            endTry.setLineOfCode(-1);
            endTry.setCode("end-try");
            this.cfg.addVertex(endTry);
            this.preEdges.push("");
            this.preNodes.push(tryNode);
            this.tryBlocks.push(new Block(tryNode, endTry));
            this.visit(ctx.block());
            this.popAddPreEdgeTo(endTry);
            DEPNode finallyNode = null;
            DEPNode endFinally = null;
            if (ctx.finallyBlock() != null) {
                finallyNode = new DEPNode();
                finallyNode.setLineOfCode(ctx.finallyBlock().getStart().getLine());
                finallyNode.setCode("finally");
                this.addContextualProperty(finallyNode, ctx.finallyBlock());
                this.cfg.addVertex(finallyNode);
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(endTry, new CFEdge(""), finallyNode));
                this.preEdges.push("");
                this.preNodes.push(finallyNode);
                this.visit(ctx.finallyBlock().block());
                endFinally = new DEPNode();
                endFinally.setLineOfCode(-1);
                endFinally.setCode("end-finally");
                this.addNodeAndPreEdge(endFinally);
            }
            if (ctx.catchClause() != null && ctx.catchClause().size() > 0) {
                DEPNode endCatch = new DEPNode();
                endCatch.setLineOfCode(-1);
                endCatch.setCode("end-catch");
                this.cfg.addVertex(endCatch);
                for (JavaParser.CatchClauseContext cx : ctx.catchClause()) {
                    DEPNode catchNode = new DEPNode();
                    catchNode.setLineOfCode(cx.getStart().getLine());
                    catchNode.setCode("catch (" + cx.catchType().getText() + " " + cx.Identifier().getText() + ")");
                    this.addContextualProperty(catchNode, cx);
                    this.cfg.addVertex(catchNode);
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(endTry, new CFEdge("Throws"), catchNode));
                    this.preEdges.push("");
                    this.preNodes.push(catchNode);
                    this.visit(cx.block());
                    this.popAddPreEdgeTo(endCatch);
                }
                if (finallyNode != null) {
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(endCatch, new CFEdge(""), finallyNode));
                    this.preEdges.push("");
                    this.preNodes.push(endFinally);
                } else {
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(endCatch, new CFEdge(""), endTry));
                    this.preEdges.push("");
                    this.preNodes.push(endTry);
                }
            } else {
                this.preEdges.push("");
                this.preNodes.push(endFinally);
            }
            return null;
        }

        @Override
        public Void visitTryWithResourceStatement(JavaParser.TryWithResourceStatementContext ctx) {
            DEPNode tryNode = new DEPNode();
            tryNode.setLineOfCode(ctx.getStart().getLine());
            tryNode.setCode("try");
            this.addContextualProperty(tryNode, ctx);
            this.addNodeAndPreEdge(tryNode);
            this.preEdges.push("");
            this.preNodes.push(tryNode);
            for (JavaParser.ResourceContext rsrc : ctx.resourceSpecification().resources().resource()) {
                DEPNode resource = new DEPNode();
                resource.setLineOfCode(rsrc.getStart().getLine());
                resource.setCode(this.getOriginalCodeText(rsrc));
                this.addContextualProperty(resource, rsrc);
                this.addNodeAndPreEdge(resource);
                this.preEdges.push("");
                this.preNodes.push(resource);
            }
            DEPNode endTry = new DEPNode();
            endTry.setLineOfCode(-1);
            endTry.setCode("end-try");
            this.cfg.addVertex(endTry);
            this.tryBlocks.push(new Block(tryNode, endTry));
            this.visit(ctx.block());
            this.popAddPreEdgeTo(endTry);
            DEPNode finallyNode = null;
            DEPNode endFinally = null;
            if (ctx.finallyBlock() != null) {
                finallyNode = new DEPNode();
                finallyNode.setLineOfCode(ctx.finallyBlock().getStart().getLine());
                finallyNode.setCode("finally");
                this.addContextualProperty(finallyNode, ctx.finallyBlock());
                this.cfg.addVertex(finallyNode);
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(endTry, new CFEdge(""), finallyNode));
                this.preEdges.push("");
                this.preNodes.push(finallyNode);
                this.visit(ctx.finallyBlock().block());
                endFinally = new DEPNode();
                endFinally.setLineOfCode(-1);
                endFinally.setCode("end-finally");
                this.addNodeAndPreEdge(endFinally);
            }
            if (ctx.catchClause() != null && ctx.catchClause().size() > 0) {
                DEPNode endCatch = new DEPNode();
                endCatch.setLineOfCode(-1);
                endCatch.setCode("end-catch");
                this.cfg.addVertex(endCatch);
                for (JavaParser.CatchClauseContext cx : ctx.catchClause()) {
                    DEPNode catchNode = new DEPNode();
                    catchNode.setLineOfCode(cx.getStart().getLine());
                    catchNode.setCode("catch (" + cx.catchType().getText() + " " + cx.Identifier().getText() + ")");
                    this.addContextualProperty(catchNode, cx);
                    this.cfg.addVertex(catchNode);
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(endTry, new CFEdge("Throws"), catchNode));
                    this.preEdges.push("");
                    this.preNodes.push(catchNode);
                    this.visit(cx.block());
                    this.popAddPreEdgeTo(endCatch);
                }
                if (finallyNode != null) {
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(endCatch, new CFEdge(""), finallyNode));
                    this.preEdges.push("");
                    this.preNodes.push(endFinally);
                } else {
                    this.cfg.addEdge(new Edge<DEPNode, CFEdge>(endCatch, new CFEdge(""), endTry));
                    this.preEdges.push("");
                    this.preNodes.push(endTry);
                }
            } else if (finallyNode != null) {
                this.preEdges.push("");
                this.preNodes.push(endFinally);
            } else {
                this.preEdges.push("");
                this.preNodes.push(endTry);
            }
            return null;
        }

        @Override
        public Void visitThrowStatement(JavaParser.ThrowStatementContext ctx) {
            DEPNode throwNode = new DEPNode();
            throwNode.setLineOfCode(ctx.getStart().getLine());
            throwNode.setCode("throw " + this.getOriginalCodeText(ctx.expression()));
            this.addContextualProperty(throwNode, ctx);
            this.addNodeAndPreEdge(throwNode);
            if (!this.tryBlocks.isEmpty()) {
                Block tryBlock = this.tryBlocks.peek();
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(throwNode, new CFEdge("Throws"), tryBlock.end));
            }
            this.dontPop = true;
            return null;
        }

        private void addNodeAndPreEdge(DEPNode node) {
            this.cfg.addVertex(node);
            this.popAddPreEdgeTo(node);
        }

        private void popAddPreEdgeTo(DEPNode node) {
            if (this.dontPop) {
                this.dontPop = false;
            } else {
                Logger.debug("\nPRE-NODES = " + this.preNodes.size());
                Logger.debug("PRE-EDGES = " + this.preEdges.size() + "\n");
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(this.preNodes.pop(), new CFEdge(this.preEdges.pop()), node));
            }
            for (int i = this.casesQueue.size(); i > 0; --i) {
                this.cfg.addEdge(new Edge<DEPNode, CFEdge>(this.casesQueue.remove(), new CFEdge("True"), node));
            }
        }

        private String getOriginalCodeText(ParserRuleContext ctx) {
            int start = ctx.start.getStartIndex();
            int stop = ctx.stop.getStopIndex();
            Interval interval = new Interval(start, stop);
            return ctx.start.getInputStream().getText(interval);
        }

        private class Block {
            public final String label;
            public final DEPNode start;
            public final DEPNode end;

            Block(DEPNode start, DEPNode end, String label) {
                this.start = start;
                this.end = end;
                this.label = label;
            }

            Block(DEPNode start, DEPNode end) {
                this(start, end, "");
            }
        }
    }
}

