/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.ast;

import codeintelligence.codeanalysis.extractors.antlrparser.JavaBaseVisitor;
import codeintelligence.codeanalysis.extractors.antlrparser.JavaLexer;
import codeintelligence.codeanalysis.extractors.antlrparser.JavaParser;
import codeintelligence.codeanalysis.extractors.ast.ASNode;
import codeintelligence.codeanalysis.extractors.ast.AbstractSyntaxTree;
import codeintelligence.codeanalysis.utils.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ASTBuilder {
    public static AbstractSyntaxTree buildWithCode(String code) throws IOException {
        Logger.info("Parsing source code ... ");
        ANTLRInputStream input = new ANTLRInputStream(code);
        JavaLexer lexer = new JavaLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavaParser parser = new JavaParser(tokens);
        JavaParser.CompilationUnitContext parseTree = parser.compilationUnit();
        return ASTBuilder.build(parseTree, null, null);
    }

    public static AbstractSyntaxTree build(String file) throws IOException {
        FileInputStream inFile = new FileInputStream(file);
        ANTLRInputStream input = new ANTLRInputStream(inFile);
        JavaLexer lexer = new JavaLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavaParser parser = new JavaParser(tokens);
        JavaParser.CompilationUnitContext parseTree = parser.compilationUnit();
        return ASTBuilder.build(parseTree, null, null);
    }

    public static AbstractSyntaxTree build(ParseTree tree, String propKey, Map<ParserRuleContext, Object> ctxProps) {
        AbstractSyntaxVisitor visitor = new AbstractSyntaxVisitor(propKey, ctxProps);
        return visitor.build(tree);
    }

    private static class AbstractSyntaxVisitor
    extends JavaBaseVisitor<String> {
        private String propKey;
        private String typeModifier;
        private String memberModifier;
        private Deque<ASNode> parentStack = new ArrayDeque<ASNode>();
        private final AbstractSyntaxTree AST = new AbstractSyntaxTree();
        private Map<String, String> vars;
        private Map<String, String> fields;
        private Map<String, String> methods;
        private int varsCounter;
        private int fieldsCounter;
        private int methodsCounter;
        private Map<ParserRuleContext, Object> contexutalProperties;

        public AbstractSyntaxVisitor(String propKey, Map<ParserRuleContext, Object> ctxProps) {
            this.propKey = propKey;
            this.contexutalProperties = ctxProps;
            this.vars = new LinkedHashMap<String, String>();
            this.fields = new LinkedHashMap<String, String>();
            this.methods = new LinkedHashMap<String, String>();
            this.varsCounter = 0;
            this.fieldsCounter = 0;
            this.methodsCounter = 0;
        }

        public AbstractSyntaxTree build(ParseTree tree) {
            JavaParser.CompilationUnitContext rootCntx = (JavaParser.CompilationUnitContext)tree;
            this.AST.root.setCode("ROOT");
            this.parentStack.push(this.AST.root);
            if (rootCntx.packageDeclaration() != null) {
                this.visit(rootCntx.packageDeclaration());
            }
            if (rootCntx.importDeclaration() != null && rootCntx.importDeclaration().size() > 0) {
                ASNode imports = new ASNode(ASNode.Type.IMPORTS);
                imports.setLineOfCode(rootCntx.importDeclaration(0).getStart().getLine());
                Logger.debug("Adding imports");
                this.AST.addVertex(imports);
                this.AST.addEdge(this.AST.root, imports);
                this.parentStack.push(imports);
                for (JavaParser.ImportDeclarationContext importCtx : rootCntx.importDeclaration()) {
                    this.visit(importCtx);
                }
                this.parentStack.pop();
            }
            if (rootCntx.typeDeclaration() != null) {
                for (JavaParser.TypeDeclarationContext typeDecCtx : rootCntx.typeDeclaration()) {
                    this.visit(typeDecCtx);
                }
            }
            this.parentStack.pop();
            this.vars.clear();
            this.fields.clear();
            this.methods.clear();
            return this.AST;
        }

        @Override
        public String visitPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
            ASNode node = new ASNode(ASNode.Type.PACKAGE);
            node.setCode(ctx.qualifiedName().getText());
            node.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding package");
            this.AST.addVertex(node);
            this.AST.addEdge(this.parentStack.peek(), node);
            return "";
        }

        @Override
        public String visitImportDeclaration(JavaParser.ImportDeclarationContext ctx) {
            Object qualifiedName = ctx.qualifiedName().getText();
            int last = ctx.getChildCount() - 1;
            if (ctx.getChild(last - 1).getText().equals("*") && ctx.getChild(last - 2).getText().equals(".")) {
                qualifiedName = (String)qualifiedName + ".*";
            }
            ASNode node = new ASNode(ASNode.Type.IMPORT);
            node.setCode((String)qualifiedName);
            node.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding import " + (String)qualifiedName);
            this.AST.addVertex(node);
            this.AST.addEdge(this.parentStack.peek(), node);
            return "";
        }

        @Override
        public String visitTypeDeclaration(JavaParser.TypeDeclarationContext ctx) {
            this.typeModifier = "";
            for (JavaParser.ClassOrInterfaceModifierContext modifierCtx : ctx.classOrInterfaceModifier()) {
                this.typeModifier = this.typeModifier + modifierCtx.getText() + " ";
            }
            this.typeModifier = this.typeModifier.trim();
            this.visitChildren(ctx);
            return "";
        }

        @Override
        public String visitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            ASNode classNode = new ASNode(ASNode.Type.CLASS);
            classNode.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding class node");
            this.AST.addVertex(classNode);
            this.AST.addEdge(this.parentStack.peek(), classNode);
            ASNode modifierNode = new ASNode(ASNode.Type.MODIFIER);
            modifierNode.setCode(this.typeModifier);
            modifierNode.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding class modifier");
            this.AST.addVertex(modifierNode);
            this.AST.addEdge(classNode, modifierNode);
            ASNode nameNode = new ASNode(ASNode.Type.NAME);
            Object className = ctx.Identifier().getText();
            if (ctx.typeParameters() != null) {
                className = (String)className + ctx.typeParameters().getText();
            }
            nameNode.setCode((String)className);
            nameNode.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding class name: " + (String)className);
            this.AST.addVertex(nameNode);
            this.AST.addEdge(classNode, nameNode);
            if (ctx.typeType() != null) {
                ASNode extendsNode = new ASNode(ASNode.Type.EXTENDS);
                extendsNode.setCode(ctx.typeType().getText());
                extendsNode.setLineOfCode(ctx.typeType().getStart().getLine());
                Logger.debug("Adding extends " + ctx.typeType().getText());
                this.AST.addVertex(extendsNode);
                this.AST.addEdge(classNode, extendsNode);
            }
            if (ctx.typeList() != null) {
                ASNode implementsNode = new ASNode(ASNode.Type.IMPLEMENTS);
                implementsNode.setLineOfCode(ctx.typeList().getStart().getLine());
                Logger.debug("Adding implements node ");
                this.AST.addVertex(implementsNode);
                this.AST.addEdge(classNode, implementsNode);
                for (JavaParser.TypeTypeContext type : ctx.typeList().typeType()) {
                    ASNode node = new ASNode(ASNode.Type.INTERFACE);
                    node.setCode(type.getText());
                    node.setLineOfCode(type.getStart().getLine());
                    Logger.debug("Adding interface " + type.getText());
                    this.AST.addVertex(node);
                    this.AST.addEdge(implementsNode, node);
                }
            }
            this.parentStack.push(classNode);
            this.visit(ctx.classBody());
            this.parentStack.pop();
            return "";
        }

        @Override
        public String visitClassBodyDeclaration(JavaParser.ClassBodyDeclarationContext ctx) {
            if (ctx.block() != null) {
                ASNode staticBlock = new ASNode(ASNode.Type.STATIC_BLOCK);
                staticBlock.setLineOfCode(ctx.block().getStart().getLine());
                Logger.debug("Adding static block");
                this.AST.addVertex(staticBlock);
                this.AST.addEdge(this.parentStack.peek(), staticBlock);
                this.parentStack.push(staticBlock);
                this.visitChildren(ctx.block());
                this.parentStack.pop();
            } else if (ctx.memberDeclaration() != null) {
                this.memberModifier = "";
                for (JavaParser.ModifierContext modCtx : ctx.modifier()) {
                    this.memberModifier = this.memberModifier + modCtx.getText() + " ";
                }
                this.memberModifier = this.memberModifier.trim();
                if (ctx.memberDeclaration().fieldDeclaration() != null) {
                    ASNode fieldNode = new ASNode(ASNode.Type.FIELD);
                    fieldNode.setLineOfCode(ctx.memberDeclaration().fieldDeclaration().getStart().getLine());
                    Logger.debug("Adding field node");
                    this.AST.addVertex(fieldNode);
                    this.AST.addEdge(this.parentStack.peek(), fieldNode);
                    this.parentStack.push(fieldNode);
                    this.visit(ctx.memberDeclaration().fieldDeclaration());
                    this.parentStack.pop();
                } else if (ctx.memberDeclaration().constructorDeclaration() != null) {
                    ASNode constructorNode = new ASNode(ASNode.Type.CONSTRUCTOR);
                    constructorNode.setLineOfCode(ctx.memberDeclaration().constructorDeclaration().getStart().getLine());
                    Logger.debug("Adding constructor node");
                    this.AST.addVertex(constructorNode);
                    this.AST.addEdge(this.parentStack.peek(), constructorNode);
                    this.parentStack.push(constructorNode);
                    this.visit(ctx.memberDeclaration().constructorDeclaration());
                    this.parentStack.pop();
                } else if (ctx.memberDeclaration().methodDeclaration() != null) {
                    ASNode methodNode = new ASNode(ASNode.Type.METHOD);
                    methodNode.setLineOfCode(ctx.memberDeclaration().methodDeclaration().getStart().getLine());
                    Logger.debug("Adding method node");
                    this.AST.addVertex(methodNode);
                    this.AST.addEdge(this.parentStack.peek(), methodNode);
                    this.parentStack.push(methodNode);
                    this.visit(ctx.memberDeclaration().methodDeclaration());
                    this.parentStack.pop();
                } else if (ctx.memberDeclaration().classDeclaration() != null) {
                    this.visitChildren(ctx.memberDeclaration());
                }
            }
            return "";
        }

        @Override
        public String visitConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            ASNode modifierNode = new ASNode(ASNode.Type.MODIFIER);
            modifierNode.setLineOfCode(ctx.getStart().getLine());
            modifierNode.setCode(this.memberModifier);
            this.AST.addVertex(modifierNode);
            this.AST.addEdge(this.parentStack.peek(), modifierNode);
            if (ctx.formalParameters().formalParameterList() != null) {
                ASNode paramsNode = new ASNode(ASNode.Type.PARAMS);
                paramsNode.setLineOfCode(ctx.formalParameters().getStart().getLine());
                this.AST.addVertex(paramsNode);
                this.AST.addEdge(this.parentStack.peek(), paramsNode);
                this.parentStack.push(paramsNode);
                for (JavaParser.FormalParameterContext paramctx : ctx.formalParameters().formalParameterList().formalParameter()) {
                    ASNode varNode = new ASNode(ASNode.Type.VARIABLE);
                    varNode.setLineOfCode(paramctx.getStart().getLine());
                    this.AST.addVertex(varNode);
                    this.AST.addEdge(this.parentStack.peek(), varNode);
                    ASNode type = new ASNode(ASNode.Type.TYPE);
                    type.setCode(paramctx.typeType().getText());
                    type.setLineOfCode(paramctx.typeType().getStart().getLine());
                    this.AST.addVertex(type);
                    this.AST.addEdge(varNode, type);
                    ++this.varsCounter;
                    ASNode name = new ASNode(ASNode.Type.NAME);
                    String normalized = "$VARL_" + this.varsCounter;
                    this.vars.put(paramctx.variableDeclaratorId().Identifier().getText(), normalized);
                    name.setCode(paramctx.variableDeclaratorId().getText());
                    name.setNormalizedCode(normalized);
                    name.setLineOfCode(paramctx.variableDeclaratorId().getStart().getLine());
                    this.AST.addVertex(name);
                    this.AST.addEdge(varNode, name);
                }
                if (ctx.formalParameters().formalParameterList().lastFormalParameter() != null) {
                    ASNode varNode = new ASNode(ASNode.Type.VARIABLE);
                    varNode.setLineOfCode(ctx.formalParameters().formalParameterList().lastFormalParameter().getStart().getLine());
                    this.AST.addVertex(varNode);
                    this.AST.addEdge(this.parentStack.peek(), varNode);
                    ASNode type = new ASNode(ASNode.Type.TYPE);
                    type.setCode(ctx.formalParameters().formalParameterList().lastFormalParameter().typeType().getText());
                    type.setLineOfCode(ctx.formalParameters().formalParameterList().lastFormalParameter().typeType().getStart().getLine());
                    this.AST.addVertex(type);
                    this.AST.addEdge(varNode, type);
                    ++this.varsCounter;
                    ASNode name = new ASNode(ASNode.Type.NAME);
                    String normalized = "$VARL_" + this.varsCounter;
                    this.vars.put(ctx.formalParameters().formalParameterList().lastFormalParameter().variableDeclaratorId().Identifier().getText(), normalized);
                    name.setCode(ctx.formalParameters().formalParameterList().lastFormalParameter().variableDeclaratorId().getText());
                    name.setNormalizedCode(normalized);
                    name.setLineOfCode(ctx.formalParameters().formalParameterList().lastFormalParameter().variableDeclaratorId().getStart().getLine());
                    this.AST.addVertex(name);
                    this.AST.addEdge(varNode, name);
                }
                this.parentStack.pop();
            }
            ASNode bodyBlock = new ASNode(ASNode.Type.BLOCK);
            bodyBlock.setLineOfCode(ctx.constructorBody().block().getStart().getLine());
            this.AST.addVertex(bodyBlock);
            this.AST.addEdge(this.parentStack.peek(), bodyBlock);
            this.parentStack.push(bodyBlock);
            this.visitChildren(ctx.constructorBody().block());
            this.parentStack.pop();
            this.resetLocalVars();
            return "";
        }

        @Override
        public String visitFieldDeclaration(JavaParser.FieldDeclarationContext ctx) {
            for (JavaParser.VariableDeclaratorContext varctx : ctx.variableDeclarators().variableDeclarator()) {
                ASNode modifierNode = new ASNode(ASNode.Type.MODIFIER);
                modifierNode.setCode(this.memberModifier);
                modifierNode.setLineOfCode(ctx.getStart().getLine());
                this.AST.addVertex(modifierNode);
                this.AST.addEdge(this.parentStack.peek(), modifierNode);
                ASNode type = new ASNode(ASNode.Type.TYPE);
                type.setCode(ctx.typeType().getText());
                type.setLineOfCode(ctx.typeType().getStart().getLine());
                this.AST.addVertex(type);
                this.AST.addEdge(this.parentStack.peek(), type);
                ++this.fieldsCounter;
                ASNode name = new ASNode(ASNode.Type.NAME);
                String normalized = "$VARF_" + this.fieldsCounter;
                this.fields.put(varctx.variableDeclaratorId().Identifier().getText(), normalized);
                name.setCode(varctx.variableDeclaratorId().getText());
                name.setNormalizedCode(normalized);
                name.setLineOfCode(varctx.variableDeclaratorId().getStart().getLine());
                this.AST.addVertex(name);
                this.AST.addEdge(this.parentStack.peek(), name);
                if (varctx.variableInitializer() == null) continue;
                ASNode initNode = new ASNode(ASNode.Type.INIT_VALUE);
                initNode.setCode("= " + this.getOriginalCodeText(varctx.variableInitializer()));
                initNode.setNormalizedCode("= " + (String)this.visit(varctx.variableInitializer()));
                initNode.setLineOfCode(varctx.variableInitializer().getStart().getLine());
                this.AST.addVertex(initNode);
                this.AST.addEdge(this.parentStack.peek(), initNode);
            }
            return "";
        }

        @Override
        public String visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            ASNode modifierNode = new ASNode(ASNode.Type.MODIFIER);
            modifierNode.setCode(this.memberModifier);
            modifierNode.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding method modifier");
            this.AST.addVertex(modifierNode);
            this.AST.addEdge(this.parentStack.peek(), modifierNode);
            ASNode retNode = new ASNode(ASNode.Type.RETURN);
            retNode.setCode(ctx.getChild(0).getText());
            retNode.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding method type");
            this.AST.addVertex(retNode);
            this.AST.addEdge(this.parentStack.peek(), retNode);
            ++this.methodsCounter;
            ASNode nameNode = new ASNode(ASNode.Type.NAME);
            String methodName = ctx.Identifier().getText();
            String normalized = "$METHOD_" + this.methodsCounter;
            this.methods.put(methodName, normalized);
            nameNode.setCode(methodName);
            nameNode.setNormalizedCode(normalized);
            nameNode.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding method name");
            this.AST.addVertex(nameNode);
            this.AST.addEdge(this.parentStack.peek(), nameNode);
            if (ctx.formalParameters().formalParameterList() != null) {
                ASNode paramsNode = new ASNode(ASNode.Type.PARAMS);
                paramsNode.setLineOfCode(ctx.formalParameters().getStart().getLine());
                Logger.debug("Adding method params node");
                this.AST.addVertex(paramsNode);
                this.AST.addEdge(this.parentStack.peek(), paramsNode);
                this.parentStack.push(paramsNode);
                for (JavaParser.FormalParameterContext paramctx : ctx.formalParameters().formalParameterList().formalParameter()) {
                    ASNode varNode = new ASNode(ASNode.Type.VARIABLE);
                    varNode.setLineOfCode(paramctx.getStart().getLine());
                    this.AST.addVertex(varNode);
                    this.AST.addEdge(this.parentStack.peek(), varNode);
                    ASNode type = new ASNode(ASNode.Type.TYPE);
                    type.setCode(paramctx.typeType().getText());
                    type.setLineOfCode(paramctx.typeType().getStart().getLine());
                    this.AST.addVertex(type);
                    this.AST.addEdge(varNode, type);
                    ++this.varsCounter;
                    ASNode name = new ASNode(ASNode.Type.NAME);
                    normalized = "$VARL_" + this.varsCounter;
                    this.vars.put(paramctx.variableDeclaratorId().Identifier().getText(), normalized);
                    name.setCode(paramctx.variableDeclaratorId().getText());
                    name.setNormalizedCode(normalized);
                    name.setLineOfCode(paramctx.variableDeclaratorId().getStart().getLine());
                    this.AST.addVertex(name);
                    this.AST.addEdge(varNode, name);
                }
                if (ctx.formalParameters().formalParameterList().lastFormalParameter() != null) {
                    ASNode varNode = new ASNode(ASNode.Type.VARIABLE);
                    varNode.setLineOfCode(ctx.formalParameters().formalParameterList().lastFormalParameter().getStart().getLine());
                    this.AST.addVertex(varNode);
                    this.AST.addEdge(this.parentStack.peek(), varNode);
                    ASNode type = new ASNode(ASNode.Type.TYPE);
                    type.setCode(ctx.formalParameters().formalParameterList().lastFormalParameter().typeType().getText());
                    type.setLineOfCode(ctx.formalParameters().formalParameterList().lastFormalParameter().typeType().getStart().getLine());
                    this.AST.addVertex(type);
                    this.AST.addEdge(varNode, type);
                    ++this.varsCounter;
                    ASNode name = new ASNode(ASNode.Type.NAME);
                    normalized = "$VARL_" + this.varsCounter;
                    this.vars.put(ctx.formalParameters().formalParameterList().lastFormalParameter().variableDeclaratorId().Identifier().getText(), normalized);
                    name.setCode(ctx.formalParameters().formalParameterList().lastFormalParameter().variableDeclaratorId().getText());
                    name.setNormalizedCode(normalized);
                    name.setLineOfCode(ctx.formalParameters().formalParameterList().lastFormalParameter().variableDeclaratorId().getStart().getLine());
                    this.AST.addVertex(name);
                    this.AST.addEdge(varNode, name);
                }
                this.parentStack.pop();
            }
            if (ctx.methodBody() != null) {
                ASNode methodBody = new ASNode(ASNode.Type.BLOCK);
                methodBody.setLineOfCode(ctx.methodBody().getStart().getLine());
                Logger.debug("Adding method block");
                this.AST.addVertex(methodBody);
                this.AST.addEdge(this.parentStack.peek(), methodBody);
                this.parentStack.push(methodBody);
                this.visitChildren(ctx.methodBody());
                this.parentStack.pop();
                this.resetLocalVars();
            }
            return "";
        }

        @Override
        public String visitLocalVariableDeclaration(JavaParser.LocalVariableDeclarationContext ctx) {
            for (JavaParser.VariableDeclaratorContext varctx : ctx.variableDeclarators().variableDeclarator()) {
                ASNode varNode = new ASNode(ASNode.Type.VARIABLE);
                varNode.setLineOfCode(varctx.getStart().getLine());
                this.AST.addVertex(varNode);
                this.AST.addEdge(this.parentStack.peek(), varNode);
                ASNode typeNode = new ASNode(ASNode.Type.TYPE);
                typeNode.setCode(ctx.typeType().getText());
                typeNode.setLineOfCode(ctx.typeType().getStart().getLine());
                this.AST.addVertex(typeNode);
                this.AST.addEdge(varNode, typeNode);
                ++this.varsCounter;
                ASNode nameNode = new ASNode(ASNode.Type.NAME);
                String normalized = "$VARL_" + this.varsCounter;
                this.vars.put(varctx.variableDeclaratorId().Identifier().getText(), normalized);
                nameNode.setCode(varctx.variableDeclaratorId().getText());
                nameNode.setNormalizedCode(normalized);
                nameNode.setLineOfCode(varctx.variableDeclaratorId().getStart().getLine());
                this.AST.addVertex(nameNode);
                this.AST.addEdge(varNode, nameNode);
                if (varctx.variableInitializer() == null) continue;
                ASNode initNode = new ASNode(ASNode.Type.INIT_VALUE);
                initNode.setCode("= " + this.getOriginalCodeText(varctx.variableInitializer()));
                initNode.setNormalizedCode("= " + (String)this.visit(varctx.variableInitializer()));
                initNode.setLineOfCode(varctx.variableInitializer().getStart().getLine());
                this.AST.addVertex(initNode);
                this.AST.addEdge(varNode, initNode);
            }
            return "";
        }

        private void visitStatement(ParserRuleContext ctx, String normalized) {
            Logger.printf(Logger.Level.DEBUG, "Visiting: (%d)  %s", ctx.getStart().getLine(), this.getOriginalCodeText(ctx));
            ASNode statementNode = new ASNode(ASNode.Type.STATEMENT);
            statementNode.setCode(this.getOriginalCodeText(ctx));
            statementNode.setNormalizedCode(normalized);
            statementNode.setLineOfCode(ctx.getStart().getLine());
            Logger.debug("Adding statement " + ctx.getStart().getLine());
            this.AST.addVertex(statementNode);
            this.AST.addEdge(this.parentStack.peek(), statementNode);
        }

        @Override
        public String visitStatementExpression(JavaParser.StatementExpressionContext ctx) {
            this.visitStatement(ctx, (String)this.visit(ctx.expression()));
            return "";
        }

        @Override
        public String visitBreakStatement(JavaParser.BreakStatementContext ctx) {
            if (ctx.Identifier() == null) {
                this.visitStatement(ctx, null);
            } else {
                this.visitStatement(ctx, "break $LABEL");
            }
            return "";
        }

        @Override
        public String visitContinueStatement(JavaParser.ContinueStatementContext ctx) {
            if (ctx.Identifier() == null) {
                this.visitStatement(ctx, null);
            } else {
                this.visitStatement(ctx, "continue $LABEL");
            }
            return "";
        }

        @Override
        public String visitReturnStatement(JavaParser.ReturnStatementContext ctx) {
            if (ctx.expression() == null) {
                this.visitStatement(ctx, null);
            } else {
                this.visitStatement(ctx, "return " + (String)this.visit(ctx.expression()));
            }
            return "";
        }

        @Override
        public String visitThrowStatement(JavaParser.ThrowStatementContext ctx) {
            this.visitStatement(ctx, "throw " + (String)this.visit(ctx.expression()));
            return "";
        }

        @Override
        public String visitSynchBlockStatement(JavaParser.SynchBlockStatementContext ctx) {
            ASNode synchNode = new ASNode(ASNode.Type.SYNC);
            synchNode.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(synchNode);
            this.AST.addEdge(this.parentStack.peek(), synchNode);
            this.parentStack.push(synchNode);
            this.visitStatement(ctx.parExpression().expression(), (String)this.visit(ctx.parExpression().expression()));
            this.parentStack.pop();
            ASNode block = new ASNode(ASNode.Type.BLOCK);
            block.setLineOfCode(ctx.block().getStart().getLine());
            this.AST.addVertex(block);
            this.AST.addEdge(synchNode, block);
            this.parentStack.push(block);
            this.visit(ctx.block());
            this.parentStack.pop();
            return "";
        }

        @Override
        public String visitLabelStatement(JavaParser.LabelStatementContext ctx) {
            ASNode labelNode = new ASNode(ASNode.Type.LABELED);
            labelNode.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(labelNode);
            this.AST.addEdge(this.parentStack.peek(), labelNode);
            ASNode labelName = new ASNode(ASNode.Type.NAME);
            labelName.setCode(ctx.Identifier().getText());
            labelName.setNormalizedCode("$LABEL");
            labelName.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(labelName);
            this.AST.addEdge(labelNode, labelName);
            this.parentStack.push(labelNode);
            this.visit(ctx.statement());
            this.parentStack.pop();
            return "";
        }

        @Override
        public String visitIfStatement(JavaParser.IfStatementContext ctx) {
            ASNode ifNode = new ASNode(ASNode.Type.IF);
            ifNode.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(ifNode);
            this.AST.addEdge(this.parentStack.peek(), ifNode);
            ASNode cond = new ASNode(ASNode.Type.CONDITION);
            cond.setCode(this.getOriginalCodeText(ctx.parExpression().expression()));
            cond.setNormalizedCode((String)this.visit(ctx.parExpression().expression()));
            cond.setLineOfCode(ctx.parExpression().getStart().getLine());
            this.AST.addVertex(cond);
            this.AST.addEdge(ifNode, cond);
            ASNode thenNode = new ASNode(ASNode.Type.THEN);
            thenNode.setLineOfCode(ctx.statement(0).getStart().getLine());
            this.AST.addVertex(thenNode);
            this.AST.addEdge(ifNode, thenNode);
            this.parentStack.push(thenNode);
            this.visit(ctx.statement(0));
            this.parentStack.pop();
            if (ctx.statement(1) != null) {
                ASNode elseNode = new ASNode(ASNode.Type.ELSE);
                elseNode.setLineOfCode(ctx.statement(1).getStart().getLine());
                this.AST.addVertex(elseNode);
                this.AST.addEdge(ifNode, elseNode);
                this.parentStack.push(elseNode);
                this.visit(ctx.statement(1));
                this.parentStack.pop();
            }
            return "";
        }

        @Override
        public String visitForStatement(JavaParser.ForStatementContext ctx) {
            ASNode forNode;
            if (ctx.forControl().enhancedForControl() != null) {
                forNode = new ASNode(ASNode.Type.FOR_EACH);
                forNode.setLineOfCode(ctx.getStart().getLine());
                this.AST.addVertex(forNode);
                this.AST.addEdge(this.parentStack.peek(), forNode);
                ASNode varType = new ASNode(ASNode.Type.TYPE);
                varType.setCode(ctx.forControl().enhancedForControl().typeType().getText());
                varType.setLineOfCode(ctx.forControl().enhancedForControl().typeType().getStart().getLine());
                this.AST.addVertex(varType);
                this.AST.addEdge(forNode, varType);
                ++this.varsCounter;
                ASNode varID = new ASNode(ASNode.Type.NAME);
                String normalized = "$VARL_" + this.varsCounter;
                this.vars.put(ctx.forControl().enhancedForControl().variableDeclaratorId().Identifier().getText(), normalized);
                varID.setCode(ctx.forControl().enhancedForControl().variableDeclaratorId().getText());
                varID.setNormalizedCode(normalized);
                varID.setLineOfCode(ctx.forControl().enhancedForControl().variableDeclaratorId().getStart().getLine());
                this.AST.addVertex(varID);
                this.AST.addEdge(forNode, varID);
                ASNode expr = new ASNode(ASNode.Type.IN);
                expr.setCode(this.getOriginalCodeText(ctx.forControl().enhancedForControl().expression()));
                expr.setNormalizedCode((String)this.visit(ctx.forControl().enhancedForControl().expression()));
                expr.setLineOfCode(ctx.forControl().enhancedForControl().expression().getStart().getLine());
                this.AST.addVertex(expr);
                this.AST.addEdge(forNode, expr);
            } else {
                int i;
                int len;
                forNode = new ASNode(ASNode.Type.FOR);
                forNode.setLineOfCode(ctx.getStart().getLine());
                this.AST.addVertex(forNode);
                this.AST.addEdge(this.parentStack.peek(), forNode);
                if (ctx.forControl().forInit() != null) {
                    ASNode forInit = new ASNode(ASNode.Type.FOR_INIT);
                    this.AST.addVertex(forInit);
                    this.AST.addEdge(forNode, forInit);
                    if (ctx.forControl().forInit().localVariableDeclaration() != null) {
                        this.parentStack.push(forInit);
                        this.visit(ctx.forControl().forInit().localVariableDeclaration());
                        this.parentStack.pop();
                    } else {
                        ASNode expr = new ASNode(ASNode.Type.STATEMENT);
                        expr.setCode(this.getOriginalCodeText(ctx.forControl().forInit().expressionList().expression(0)));
                        expr.setNormalizedCode((String)this.visit(ctx.forControl().forInit().expressionList().expression(0)));
                        expr.setLineOfCode(ctx.forControl().forInit().expressionList().expression(0).getStart().getLine());
                        this.AST.addVertex(expr);
                        this.AST.addEdge(forInit, expr);
                        len = ctx.forControl().forInit().expressionList().expression().size();
                        for (i = 1; i < len; ++i) {
                            expr = new ASNode(ASNode.Type.STATEMENT);
                            expr.setCode(this.getOriginalCodeText(ctx.forControl().forInit().expressionList().expression(i)));
                            expr.setNormalizedCode((String)this.visit(ctx.forControl().forInit().expressionList().expression(i)));
                            expr.setLineOfCode(ctx.forControl().forInit().expressionList().expression(i).getStart().getLine());
                            this.AST.addVertex(expr);
                            this.AST.addEdge(forInit, expr);
                        }
                    }
                }
                if (ctx.forControl().expression() != null) {
                    ASNode forExpr = new ASNode(ASNode.Type.CONDITION);
                    forExpr.setCode(this.getOriginalCodeText(ctx.forControl().expression()));
                    forExpr.setNormalizedCode((String)this.visit(ctx.forControl().expression()));
                    forExpr.setLineOfCode(ctx.forControl().expression().getStart().getLine());
                    this.AST.addVertex(forExpr);
                    this.AST.addEdge(forNode, forExpr);
                }
                if (ctx.forControl().forUpdate() != null) {
                    ASNode forUpdate = new ASNode(ASNode.Type.FOR_UPDATE);
                    this.AST.addVertex(forUpdate);
                    this.AST.addEdge(forNode, forUpdate);
                    ASNode update = new ASNode(ASNode.Type.STATEMENT);
                    update.setCode(this.getOriginalCodeText(ctx.forControl().forUpdate().expressionList().expression(0)));
                    update.setNormalizedCode((String)this.visit(ctx.forControl().forUpdate().expressionList().expression(0)));
                    update.setLineOfCode(ctx.forControl().forUpdate().expressionList().expression(0).getStart().getLine());
                    this.AST.addVertex(update);
                    this.AST.addEdge(forUpdate, update);
                    len = ctx.forControl().forUpdate().expressionList().expression().size();
                    for (i = 1; i < len; ++i) {
                        update = new ASNode(ASNode.Type.STATEMENT);
                        update.setCode(this.getOriginalCodeText(ctx.forControl().forUpdate().expressionList().expression(i)));
                        update.setNormalizedCode((String)this.visit(ctx.forControl().forUpdate().expressionList().expression(i)));
                        update.setLineOfCode(ctx.forControl().forUpdate().expressionList().expression(i).getStart().getLine());
                        this.AST.addVertex(update);
                        this.AST.addEdge(forUpdate, update);
                    }
                }
            }
            ASNode block = new ASNode(ASNode.Type.BLOCK);
            block.setLineOfCode(ctx.statement().getStart().getLine());
            this.AST.addVertex(block);
            this.AST.addEdge(forNode, block);
            this.parentStack.push(block);
            this.visit(ctx.statement());
            this.parentStack.pop();
            return "";
        }

        @Override
        public String visitWhileStatement(JavaParser.WhileStatementContext ctx) {
            ASNode whileNode = new ASNode(ASNode.Type.WHILE);
            whileNode.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(whileNode);
            this.AST.addEdge(this.parentStack.peek(), whileNode);
            ASNode cond = new ASNode(ASNode.Type.CONDITION);
            cond.setCode(this.getOriginalCodeText(ctx.parExpression().expression()));
            cond.setNormalizedCode((String)this.visit(ctx.parExpression().expression()));
            cond.setLineOfCode(ctx.parExpression().expression().getStart().getLine());
            this.AST.addVertex(cond);
            this.AST.addEdge(whileNode, cond);
            ASNode block = new ASNode(ASNode.Type.BLOCK);
            block.setLineOfCode(ctx.statement().getStart().getLine());
            this.AST.addVertex(block);
            this.AST.addEdge(whileNode, block);
            this.parentStack.push(block);
            this.visit(ctx.statement());
            this.parentStack.pop();
            return "";
        }

        @Override
        public String visitDoWhileStatement(JavaParser.DoWhileStatementContext ctx) {
            ASNode doWhileNode = new ASNode(ASNode.Type.DO_WHILE);
            doWhileNode.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(doWhileNode);
            this.AST.addEdge(this.parentStack.peek(), doWhileNode);
            ASNode cond = new ASNode(ASNode.Type.CONDITION);
            cond.setCode(this.getOriginalCodeText(ctx.parExpression().expression()));
            cond.setNormalizedCode((String)this.visit(ctx.parExpression().expression()));
            cond.setLineOfCode(ctx.parExpression().expression().getStart().getLine());
            this.AST.addVertex(cond);
            this.AST.addEdge(doWhileNode, cond);
            ASNode block = new ASNode(ASNode.Type.BLOCK);
            block.setLineOfCode(ctx.statement().getStart().getLine());
            this.AST.addVertex(block);
            this.AST.addEdge(doWhileNode, block);
            this.parentStack.push(block);
            this.visit(ctx.statement());
            this.parentStack.pop();
            return "";
        }

        @Override
        public String visitTryStatement(JavaParser.TryStatementContext ctx) {
            ASNode tryNode = new ASNode(ASNode.Type.TRY);
            tryNode.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(tryNode);
            this.AST.addEdge(this.parentStack.peek(), tryNode);
            ASNode tryBlock = new ASNode(ASNode.Type.BLOCK);
            tryBlock.setLineOfCode(ctx.block().getStart().getLine());
            this.AST.addVertex(tryBlock);
            this.AST.addEdge(tryNode, tryBlock);
            this.parentStack.push(tryBlock);
            this.visit(ctx.block());
            this.parentStack.pop();
            if (ctx.catchClause() != null && ctx.catchClause().size() > 0) {
                for (JavaParser.CatchClauseContext catchx : ctx.catchClause()) {
                    ASNode catchNode = new ASNode(ASNode.Type.CATCH);
                    catchNode.setLineOfCode(catchx.getStart().getLine());
                    this.AST.addVertex(catchNode);
                    this.AST.addEdge(tryNode, catchNode);
                    ASNode catchType = new ASNode(ASNode.Type.TYPE);
                    catchType.setCode(catchx.catchType().getText());
                    catchType.setLineOfCode(catchx.catchType().getStart().getLine());
                    this.AST.addVertex(catchType);
                    this.AST.addEdge(catchNode, catchType);
                    ++this.varsCounter;
                    ASNode catchName = new ASNode(ASNode.Type.NAME);
                    String normalized = "$VARL_" + this.varsCounter;
                    this.vars.put(catchx.Identifier().getText(), normalized);
                    catchName.setCode(catchx.Identifier().getText());
                    catchName.setNormalizedCode(normalized);
                    catchName.setLineOfCode(catchx.getStart().getLine());
                    this.AST.addVertex(catchName);
                    this.AST.addEdge(catchNode, catchName);
                    ASNode catchBlock = new ASNode(ASNode.Type.BLOCK);
                    catchBlock.setLineOfCode(catchx.block().getStart().getLine());
                    this.AST.addVertex(catchBlock);
                    this.AST.addEdge(catchNode, catchBlock);
                    this.parentStack.push(catchBlock);
                    this.visit(catchx.block());
                    this.parentStack.pop();
                }
            }
            if (ctx.finallyBlock() != null) {
                ASNode finallyNode = new ASNode(ASNode.Type.FINALLY);
                finallyNode.setLineOfCode(ctx.finallyBlock().getStart().getLine());
                this.AST.addVertex(finallyNode);
                this.AST.addEdge(tryNode, finallyNode);
                this.parentStack.push(finallyNode);
                this.visit(ctx.finallyBlock().block());
                this.parentStack.pop();
            }
            return "";
        }

        @Override
        public String visitTryWithResourceStatement(JavaParser.TryWithResourceStatementContext ctx) {
            ASNode tryNode = new ASNode(ASNode.Type.TRY);
            tryNode.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(tryNode);
            this.AST.addEdge(this.parentStack.peek(), tryNode);
            ASNode resNode = new ASNode(ASNode.Type.RESOURCES);
            resNode.setLineOfCode(ctx.resourceSpecification().getStart().getLine());
            this.AST.addVertex(resNode);
            this.AST.addEdge(tryNode, resNode);
            for (JavaParser.ResourceContext resourceContext : ctx.resourceSpecification().resources().resource()) {
                ASNode varNode = new ASNode(ASNode.Type.VARIABLE);
                varNode.setLineOfCode(resourceContext.getStart().getLine());
                this.AST.addVertex(varNode);
                this.AST.addEdge(resNode, varNode);
                ASNode resType = new ASNode(ASNode.Type.TYPE);
                resType.setCode(resourceContext.classOrInterfaceType().getText());
                resType.setLineOfCode(resourceContext.classOrInterfaceType().getStart().getLine());
                this.AST.addVertex(resType);
                this.AST.addEdge(varNode, resType);
                ++this.varsCounter;
                ASNode resName = new ASNode(ASNode.Type.NAME);
                String normalized = "$VARL_" + this.varsCounter;
                this.vars.put(resourceContext.variableDeclaratorId().Identifier().getText(), normalized);
                resName.setCode(resourceContext.variableDeclaratorId().getText());
                resName.setNormalizedCode(normalized);
                resName.setLineOfCode(resourceContext.variableDeclaratorId().getStart().getLine());
                this.AST.addVertex(resName);
                this.AST.addEdge(varNode, resName);
                ASNode resInit = new ASNode(ASNode.Type.INIT_VALUE);
                resInit.setCode("= " + this.getOriginalCodeText(resourceContext.expression()));
                resInit.setNormalizedCode("= " + (String)this.visit(resourceContext.expression()));
                resInit.setLineOfCode(resourceContext.expression().getStart().getLine());
                this.AST.addVertex(resInit);
                this.AST.addEdge(varNode, resInit);
            }
            ASNode tryBlock = new ASNode(ASNode.Type.BLOCK);
            tryBlock.setLineOfCode(ctx.block().getStart().getLine());
            this.AST.addVertex(tryBlock);
            this.AST.addEdge(tryNode, tryBlock);
            this.parentStack.push(tryBlock);
            this.visit(ctx.block());
            this.parentStack.pop();
            if (ctx.catchClause().size() > 0 && ctx.catchClause() != null) {
                for (JavaParser.CatchClauseContext catchx : ctx.catchClause()) {
                    ASNode catchNode = new ASNode(ASNode.Type.CATCH);
                    catchNode.setLineOfCode(catchx.getStart().getLine());
                    this.AST.addVertex(catchNode);
                    this.AST.addEdge(tryNode, catchNode);
                    ASNode catchType = new ASNode(ASNode.Type.TYPE);
                    catchType.setCode(catchx.catchType().getText());
                    catchType.setLineOfCode(catchx.catchType().getStart().getLine());
                    this.AST.addVertex(catchType);
                    this.AST.addEdge(catchNode, catchType);
                    ++this.varsCounter;
                    ASNode catchName = new ASNode(ASNode.Type.NAME);
                    String normalized = "$VARL_" + this.varsCounter;
                    this.vars.put(catchx.Identifier().getText(), normalized);
                    catchName.setCode(catchx.Identifier().getText());
                    catchName.setNormalizedCode(normalized);
                    catchName.setLineOfCode(catchx.catchType().getStart().getLine());
                    this.AST.addVertex(catchName);
                    this.AST.addEdge(catchNode, catchName);
                    ASNode catchBlock = new ASNode(ASNode.Type.BLOCK);
                    catchBlock.setLineOfCode(catchx.block().getStart().getLine());
                    this.AST.addVertex(catchBlock);
                    this.AST.addEdge(catchNode, catchBlock);
                    this.parentStack.push(catchBlock);
                    this.visit(catchx.block());
                    this.parentStack.pop();
                }
            }
            if (ctx.finallyBlock() != null) {
                ASNode aSNode = new ASNode(ASNode.Type.FINALLY);
                aSNode.setLineOfCode(ctx.finallyBlock().getStart().getLine());
                this.AST.addVertex(aSNode);
                this.AST.addEdge(tryNode, aSNode);
                this.parentStack.push(aSNode);
                this.visit(ctx.finallyBlock().block());
                this.parentStack.pop();
            }
            return "";
        }

        @Override
        public String visitSwitchStatement(JavaParser.SwitchStatementContext ctx) {
            ASNode switchNode = new ASNode(ASNode.Type.SWITCH);
            switchNode.setLineOfCode(ctx.getStart().getLine());
            this.AST.addVertex(switchNode);
            this.AST.addEdge(this.parentStack.peek(), switchNode);
            ASNode varName = new ASNode(ASNode.Type.NAME);
            varName.setCode(this.getOriginalCodeText(ctx.parExpression().expression()));
            varName.setNormalizedCode((String)this.visit(ctx.parExpression().expression()));
            varName.setLineOfCode(ctx.parExpression().expression().getStart().getLine());
            this.AST.addVertex(varName);
            this.AST.addEdge(switchNode, varName);
            if (ctx.switchBlockStatementGroup() != null) {
                for (JavaParser.SwitchBlockStatementGroupContext grpx : ctx.switchBlockStatementGroup()) {
                    ASNode blockNode = new ASNode(ASNode.Type.BLOCK);
                    blockNode.setLineOfCode(grpx.blockStatement(0).getStart().getLine());
                    this.AST.addVertex(blockNode);
                    for (JavaParser.SwitchLabelContext lblctx : grpx.switchLabel()) {
                        this.visitSwitchLabel(lblctx, switchNode, blockNode);
                    }
                    this.parentStack.push(blockNode);
                    for (JavaParser.BlockStatementContext blk : grpx.blockStatement()) {
                        this.visit(blk);
                    }
                    this.parentStack.pop();
                }
            }
            if (ctx.switchLabel() != null && ctx.switchLabel().size() > 0) {
                ASNode blockNode = new ASNode(ASNode.Type.BLOCK);
                blockNode.setLineOfCode(ctx.switchLabel(0).getStart().getLine());
                this.AST.addVertex(blockNode);
                for (JavaParser.SwitchLabelContext lblctx : ctx.switchLabel()) {
                    this.visitSwitchLabel(lblctx, switchNode, blockNode);
                }
            }
            return "";
        }

        private void visitSwitchLabel(JavaParser.SwitchLabelContext lblctx, ASNode switchNode, ASNode blockNode) {
            ASNode caseNode;
            if (lblctx.constantExpression() != null) {
                caseNode = new ASNode(ASNode.Type.CASE);
                caseNode.setCode(lblctx.constantExpression().getText());
                caseNode.setLineOfCode(lblctx.getStart().getLine());
            } else if (lblctx.enumConstantName() != null) {
                caseNode = new ASNode(ASNode.Type.CASE);
                caseNode.setCode(lblctx.enumConstantName().getText());
                caseNode.setLineOfCode(lblctx.getStart().getLine());
            } else {
                caseNode = new ASNode(ASNode.Type.DEFAULT);
                caseNode.setLineOfCode(lblctx.getStart().getLine());
            }
            this.AST.addVertex(caseNode);
            this.AST.addEdge(switchNode, caseNode);
            this.AST.addEdge(caseNode, blockNode);
        }

        @Override
        public String visitExprPrimary(JavaParser.ExprPrimaryContext ctx) {
            JavaParser.PrimaryContext primary = ctx.primary();
            if (primary.expression() != null) {
                return "(" + (String)this.visit(primary.expression()) + ")";
            }
            if (primary.Identifier() != null) {
                return this.normalizedIdentifier(primary.Identifier());
            }
            if (primary.nonWildcardTypeArguments() != null) {
                if (primary.arguments() != null) {
                    return this.getOriginalCodeText(primary.nonWildcardTypeArguments()) + "this" + (String)this.visit(primary.arguments());
                }
                String suffix = primary.explicitGenericInvocationSuffix().Identifier() != null ? this.normalizedIdentifier(primary.explicitGenericInvocationSuffix().Identifier()) + (String)this.visit(primary.explicitGenericInvocationSuffix().arguments()) : "super" + (String)this.visit(primary.explicitGenericInvocationSuffix().superSuffix());
                return this.getOriginalCodeText(primary.nonWildcardTypeArguments()) + suffix;
            }
            return this.getOriginalCodeText(primary);
        }

        @Override
        public String visitExprDotID(JavaParser.ExprDotIDContext ctx) {
            return (String)this.visit(ctx.expression()) + "." + this.normalizedIdentifier(ctx.Identifier());
        }

        @Override
        public String visitExprDotThis(JavaParser.ExprDotThisContext ctx) {
            return (String)this.visit(ctx.expression()) + ".this";
        }

        @Override
        public String visitExprDotNewInnerCreator(JavaParser.ExprDotNewInnerCreatorContext ctx) {
            return (String)this.visit(ctx.expression()) + ".new " + this.getOriginalCodeText(ctx.nonWildcardTypeArguments()) + this.normalizedIdentifier(ctx.innerCreator().Identifier()) + this.getOriginalCodeText(ctx.innerCreator().nonWildcardTypeArgumentsOrDiamond()) + (String)this.visit(ctx.innerCreator().classCreatorRest().arguments()) + (String)this.visit(ctx.innerCreator().classCreatorRest().classBody());
        }

        @Override
        public String visitExprDotSuper(JavaParser.ExprDotSuperContext ctx) {
            return (String)this.visit(ctx.expression()) + ".super" + (String)this.visit(ctx.superSuffix());
        }

        @Override
        public String visitSuperSuffix(JavaParser.SuperSuffixContext ctx) {
            Object superSuffix = "";
            if (ctx.Identifier() != null) {
                superSuffix = "." + this.normalizedIdentifier(ctx.Identifier());
            }
            if (ctx.arguments() != null) {
                superSuffix = (String)superSuffix + (String)this.visit(ctx.arguments());
            }
            return superSuffix;
        }

        @Override
        public String visitArguments(JavaParser.ArgumentsContext ctx) {
            if (ctx.expressionList() == null) {
                return "()";
            }
            return "(" + (String)this.visit(ctx.expressionList()) + ")";
        }

        @Override
        public String visitExprDotGenInvok(JavaParser.ExprDotGenInvokContext ctx) {
            String suffix = ctx.explicitGenericInvocation().explicitGenericInvocationSuffix().Identifier() != null ? this.normalizedIdentifier(ctx.explicitGenericInvocation().explicitGenericInvocationSuffix().Identifier()) + (String)this.visit(ctx.explicitGenericInvocation().explicitGenericInvocationSuffix().arguments()) : "super" + (String)this.visit(ctx.explicitGenericInvocation().explicitGenericInvocationSuffix().superSuffix());
            return (String)this.visit(ctx.expression()) + "." + this.getOriginalCodeText(ctx.explicitGenericInvocation().nonWildcardTypeArguments()) + suffix;
        }

        @Override
        public String visitExprArrayIndexing(JavaParser.ExprArrayIndexingContext ctx) {
            return (String)this.visit(ctx.expression(0)) + "[" + (String)this.visit(ctx.expression(1)) + "]";
        }

        @Override
        public String visitExprMethodInvocation(JavaParser.ExprMethodInvocationContext ctx) {
            return (String)this.visit(ctx.expression()) + "(" + (ctx.expressionList() != null ? (String)this.visit(ctx.expressionList()) : "") + ")";
        }

        @Override
        public String visitExprNewCreator(JavaParser.ExprNewCreatorContext ctx) {
            return (String)this.visitChildren(ctx);
        }

        @Override
        public String visitExprCasting(JavaParser.ExprCastingContext ctx) {
            return "(" + this.getOriginalCodeText(ctx.typeType()) + ") " + (String)this.visit(ctx.expression());
        }

        @Override
        public String visitExprPostUnaryOp(JavaParser.ExprPostUnaryOpContext ctx) {
            return (String)this.visit(ctx.expression()) + (ctx.getText().endsWith("++") ? "++" : "--");
        }

        @Override
        public String visitExprPreUnaryOp(JavaParser.ExprPreUnaryOpContext ctx) {
            String op = ctx.getText().startsWith("+") ? (ctx.getText().startsWith("++") ? "++" : "+") : (ctx.getText().startsWith("--") ? "--" : "-");
            return op + (String)this.visit(ctx.expression());
        }

        @Override
        public String visitExprNegation(JavaParser.ExprNegationContext ctx) {
            return (ctx.getText().startsWith("~") ? "~" : "!") + (String)this.visit(ctx.expression());
        }

        @Override
        public String visitExprMulDivMod(JavaParser.ExprMulDivModContext ctx) {
            char op = ctx.getText().substring(ctx.expression(0).getText().length()).charAt(0);
            return (String)this.visit(ctx.expression(0)) + " " + op + " " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprAddSub(JavaParser.ExprAddSubContext ctx) {
            char op = ctx.getText().substring(ctx.expression(0).getText().length()).charAt(0);
            return (String)this.visit(ctx.expression(0)) + " " + op + " " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprBitShift(JavaParser.ExprBitShiftContext ctx) {
            String sub = ctx.getText().substring(ctx.expression(0).getText().length());
            String op = sub.startsWith(">>>") ? ">>>" : sub.substring(0, 2);
            return (String)this.visit(ctx.expression(0)) + " " + op + " " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprComparison(JavaParser.ExprComparisonContext ctx) {
            String sub = ctx.getText().substring(ctx.expression(0).getText().length());
            String op = sub.startsWith(">") ? (sub.startsWith(">=") ? " >= " : " > ") : (sub.startsWith("<=") ? " <= " : " < ");
            return (String)this.visit(ctx.expression(0)) + op + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprInstanceOf(JavaParser.ExprInstanceOfContext ctx) {
            return (String)this.visit(ctx.expression()) + " instanceof " + this.getOriginalCodeText(ctx.typeType());
        }

        @Override
        public String visitExprEquality(JavaParser.ExprEqualityContext ctx) {
            String sub = ctx.getText().substring(ctx.expression(0).getText().length());
            String op = sub.startsWith("==") ? " == " : " != ";
            return (String)this.visit(ctx.expression(0)) + op + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprBitAnd(JavaParser.ExprBitAndContext ctx) {
            return (String)this.visit(ctx.expression(0)) + " & " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprBitXOR(JavaParser.ExprBitXORContext ctx) {
            return (String)this.visit(ctx.expression(0)) + " ^ " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprBitOr(JavaParser.ExprBitOrContext ctx) {
            return (String)this.visit(ctx.expression(0)) + " | " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprLogicAnd(JavaParser.ExprLogicAndContext ctx) {
            return (String)this.visit(ctx.expression(0)) + " && " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprLogicOr(JavaParser.ExprLogicOrContext ctx) {
            return (String)this.visit(ctx.expression(0)) + " || " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitExprConditional(JavaParser.ExprConditionalContext ctx) {
            return (String)this.visit(ctx.expression(0)) + " ? " + (String)this.visit(ctx.expression(1)) + " : " + (String)this.visit(ctx.expression(2));
        }

        @Override
        public String visitExprAssignment(JavaParser.ExprAssignmentContext ctx) {
            return (String)this.visit(ctx.expression(0)) + " ?= " + (String)this.visit(ctx.expression(1));
        }

        @Override
        public String visitVariableInitializer(JavaParser.VariableInitializerContext ctx) {
            if (ctx.expression() != null) {
                return (String)this.visit(ctx.expression());
            }
            return (String)this.visit(ctx.arrayInitializer());
        }

        @Override
        public String visitArrayInitializer(JavaParser.ArrayInitializerContext ctx) {
            if (ctx.variableInitializer().size() > 0) {
                StringBuilder normalized = new StringBuilder("{" + (String)this.visit(ctx.variableInitializer(0)));
                for (int i = 1; i < ctx.variableInitializer().size(); ++i) {
                    normalized.append(", ").append((String)this.visit(ctx.variableInitializer(i)));
                }
                return normalized.append("}").toString();
            }
            return "{ }";
        }

        @Override
        public String visitExpressionList(JavaParser.ExpressionListContext ctx) {
            StringBuilder normalized = new StringBuilder((String)this.visit(ctx.expression(0)));
            for (int i = 1; i < ctx.expression().size(); ++i) {
                normalized.append(", ").append((String)this.visit(ctx.expression(i)));
            }
            return normalized.toString();
        }

        private String getOriginalCodeText(ParserRuleContext ctx) {
            if (ctx == null) {
                return "";
            }
            int start = ctx.start.getStartIndex();
            int stop = ctx.stop.getStopIndex();
            Interval interval = new Interval(start, stop);
            return ctx.start.getInputStream().getText(interval);
        }

        private void resetLocalVars() {
            this.vars.clear();
            this.varsCounter = 0;
        }

        private String normalizedIdentifier(TerminalNode id) {
            String normalized = this.vars.get(id.getText());
            if (normalized == null || normalized.isEmpty()) {
                normalized = this.fields.get(id.getText());
            }
            if (normalized == null || normalized.isEmpty()) {
                normalized = this.methods.get(id.getText());
            }
            if (normalized == null || normalized.isEmpty()) {
                normalized = id.getText();
            }
            return normalized;
        }
    }
}

