/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors;

import codeintelligence.codeanalysis.utils.Logger;
import codeintelligence.codeanalysis.utils.graph.Digraph;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class AbstractProgramGraph<N, E>
extends Digraph<N, E> {
    public AbstractProgramGraph() {
    }

    public AbstractProgramGraph(AbstractProgramGraph g) {
        super(g);
    }

    public String export(String format) {
        String output = "";
        switch (format) {
            case "DOT": {
                output = this.exportDOT();
                break;
            }
            case "JSON": {
                output = this.exportJSON();
            }
        }
        return output;
    }

    public void export(String format, String filepath) throws IOException {
        String output = this.export(format);
        try (FileWriter writer = new FileWriter(filepath);){
            writer.write(output);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("Graph exported to: " + filepath);
    }

    public void exportDOT(String filepath) throws IOException {
        String dot = this.exportDOT();
        try (FileWriter writer = new FileWriter(filepath);){
            writer.write(dot);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("Graph exported to: " + filepath);
    }

    public abstract String exportDOT();

    public void exportJSON(String filepath) throws IOException {
        String json = this.exportJSON();
        try (FileWriter writer = new FileWriter(filepath);){
            writer.write(json);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("Graph exported to: " + filepath);
    }

    public abstract String exportJSON();
}

