/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis;

import codeintelligence.codeanalysis.extractors.ast.ASTBuilder;
import codeintelligence.codeanalysis.extractors.ast.AbstractSyntaxTree;
import codeintelligence.codeanalysis.extractors.dependence.cfg.CFGBuilder;
import codeintelligence.codeanalysis.extractors.dependence.cfg.ControlFlowGraph;
import codeintelligence.codeanalysis.extractors.dependence.pdg.JavaClass;
import codeintelligence.codeanalysis.extractors.dependence.pdg.JavaClassExtractor;
import codeintelligence.codeanalysis.extractors.dependence.pdg.PDGBuilder;
import codeintelligence.codeanalysis.extractors.dependence.pdg.ProgramDependenceGraph;
import codeintelligence.codeanalysis.utils.FileUtils;
import codeintelligence.codeanalysis.utils.Logger;
import codeintelligence.codeanalysis.utils.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Execution {
    private final ArrayList<Analysis> analysisTypes = new ArrayList();
    private final ArrayList<String> inputPaths = new ArrayList();
    private boolean debugMode = false;
    private String outputDir;
    private Formats format = Formats.DOT;

    public Execution() {
        this.outputDir = System.getProperty("user.dir");
        if (!this.outputDir.endsWith(File.separator)) {
            this.outputDir = this.outputDir + File.separator;
        }
    }

    public void addAnalysisOption(Analysis opt) {
        this.analysisTypes.add(opt);
    }

    public void addInputPath(String path) {
        this.inputPaths.add(path);
    }

    public void setDebugMode(boolean isDebug) {
        this.debugMode = isDebug;
    }

    public void setOutputFormat(Formats fmt) {
        this.format = fmt;
    }

    public boolean setOutputDirectory(String outPath) {
        if (!((String)outPath).endsWith(File.separator)) {
            outPath = (String)outPath + File.separator;
        }
        File outDir = new File((String)outPath);
        outDir.mkdirs();
        if (outDir.exists() && outDir.canWrite() && outDir.isDirectory()) {
            this.outputDir = outPath;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("execution config:");
        str.append("\n  Output format = ").append((Object)this.format);
        str.append("\n  Output directory = ").append(this.outputDir);
        str.append("\n  Analysis types = ").append(Arrays.toString(this.analysisTypes.toArray()));
        str.append("\n  Input paths = \n");
        for (String path : this.inputPaths) {
            str.append("        ").append(path).append('\n');
        }
        return str.toString();
    }

    public void execute() {
        if (this.inputPaths.isEmpty()) {
            Logger.info("No input path provided!\nAbort.");
            System.exit(0);
        }
        if (this.analysisTypes.isEmpty()) {
            Logger.info("No analysis type provided!\nAbort.");
            System.exit(0);
        }
        Logger.info(this.toString());
        String[] paths = this.inputPaths.toArray(new String[this.inputPaths.size()]);
        String[] filePaths = new String[]{};
        if (paths.length > 0) {
            filePaths = FileUtils.listFilesWithSuffix(paths, ".java");
        }
        Logger.info("#  source files = " + filePaths.length + "\n");
        if (!this.outputDir.endsWith(File.separator)) {
            this.outputDir = this.outputDir + File.separator;
        }
        File outDirFile = new File(this.outputDir);
        outDirFile.mkdirs();
        for (Analysis analysis : this.analysisTypes) {
            Logger.debug("\nMemory Status");
            Logger.debug("=============");
            Logger.debug(SystemUtils.getMemoryStats());
            switch (analysis.type) {
                case "AST": {
                    Logger.info("===== Abstract Syntax Analysis ======");
                    Logger.debug("START: " + Logger.time() + "\n");
                    for (String srcFile : filePaths) {
                        try {
                            AbstractSyntaxTree ast = ASTBuilder.build(srcFile);
                            String outputPath = srcFile.substring(0, srcFile.indexOf(46)) + "-AST." + this.format.toString().toLowerCase();
                            ast.export(this.format.toString(), outputPath);
                            if (this.format != Formats.DOT) continue;
                            String pngPath = srcFile.substring(0, srcFile.indexOf(46)) + "-AST.png";
                            Runtime.getRuntime().exec("dot -Tpng -o \"" + pngPath + "\" \"" + outputPath + "\"");
                        }
                        catch (IOException ex) {
                            Logger.error(ex);
                        }
                    }
                    break;
                }
                case "CFG": {
                    String pngPath;
                    String outputPath;
                    Logger.info("===== Control-Flow Analysis ======");
                    Logger.debug("START: " + Logger.time() + "\n");
                    for (String srcFile : filePaths) {
                        try {
                            List<ControlFlowGraph> cfgs = CFGBuilder.build(srcFile);
                            for (ControlFlowGraph cfg : cfgs) {
                                outputPath = srcFile.substring(0, srcFile.indexOf(46)) + "-CFG-" + cfg.getName().hashCode() + "." + this.format.toString().toLowerCase();
                                cfg.export(this.format.toString(), outputPath);
                                if (this.format != Formats.DOT) continue;
                                pngPath = srcFile.substring(0, srcFile.indexOf(46)) + "-CFG-" + cfg.getName().hashCode() + ".png";
                                Runtime.getRuntime().exec("dot -Tpng -o \"" + pngPath + "\" \"" + outputPath + "\"");
                            }
                        }
                        catch (IOException ex) {
                            Logger.error(ex);
                        }
                    }
                    break;
                }
                case "PDG": {
                    String pngPath;
                    String outputPath;
                    Logger.info("===== Program-Dependence Analysis =====");
                    Logger.debug("START: " + Logger.time() + "\n");
                    for (String srcFile : filePaths) {
                        try {
                            List<ProgramDependenceGraph> pdgs = PDGBuilder.build(srcFile);
                            for (ProgramDependenceGraph pdg : pdgs) {
                                outputPath = srcFile.substring(0, srcFile.indexOf(46)) + "-PDG-" + pdg.getName().hashCode() + "." + this.format.toString().toLowerCase();
                                pdg.export(this.format.toString(), outputPath);
                                if (this.format == Formats.DOT) {
                                    pngPath = srcFile.substring(0, srcFile.indexOf(46)) + "-PDG-" + pdg.getName().hashCode() + ".png";
                                    System.out.println(pdg.getName().hashCode());
                                    System.out.println("dot -Tpng -o \"" + pngPath + "\" \"" + outputPath + "\"");
                                    Process p = Runtime.getRuntime().exec("dot -Tpng -o \"" + pngPath + "\" \"" + outputPath + "\"");
                                    p.waitFor();
                                }
                                if (!this.debugMode) continue;
                                pdg.printAllNodesUseDefs(Logger.Level.DEBUG);
                            }
                        }
                        catch (IOException | InterruptedException ex) {
                            Logger.error(ex);
                        }
                    }
                    break;
                }
                case "INFO": {
                    Logger.info("Code Information Analysis");
                    Logger.info("=========================");
                    Logger.debug("START: " + Logger.time() + "\n");
                    for (String srcFile : filePaths) {
                        this.analyzeInfo(srcFile);
                    }
                    break;
                }
                default: {
                    Logger.info("'" + analysis.type + "' analysis is not supported!\n");
                }
            }
            Logger.debug("\nFINISH: " + Logger.time());
        }
        Logger.debug("\nMemory Status");
        Logger.debug("=============");
        Logger.debug(SystemUtils.getMemoryStats());
    }

    private void analyzeInfo(String srcFilePath) {
        try {
            Logger.info("========================================\n");
            Logger.info("FILE: " + srcFilePath);
            List<JavaClass> classInfoList = JavaClassExtractor.extractInfo(srcFilePath);
            for (JavaClass classInfo : classInfoList) {
                Logger.info("" + classInfo);
            }
            if (classInfoList.size() > 0) {
                Logger.info("- - - - - - - - - - - - - - - - - - - - -");
                String[] imports = classInfoList.get((int)0).IMPORTS;
                for (JavaClass importInfo : JavaClassExtractor.extractImportsInfo(imports)) {
                    Logger.info("" + importInfo);
                }
            }
        }
        catch (IOException ex) {
            Logger.error(ex);
        }
    }

    public static enum Formats {
        DOT,
        JSON;

    }

    public static enum Analysis {
        CFG("CFG"),
        PDG("PDG"),
        AST("AST"),
        SRC_INFO("INFO");

        public final String type;

        private Analysis(String str) {
            this.type = str;
        }

        public String toString() {
            return this.type;
        }
    }
}

