"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import grpc
import spot.v1.query_pb2

class QueryStub:
    """Query defines the gRPC querier service."""

    def __init__(self, channel: grpc.Channel) -> None: ...
    Params: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryParamsRequest,
        spot.v1.query_pb2.QueryParamsResponse,
    ]
    """Parameters of the spot module."""
    PoolNumber: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryPoolNumberRequest,
        spot.v1.query_pb2.QueryPoolNumberResponse,
    ]
    """Next available pool id number."""
    Pool: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryPoolRequest,
        spot.v1.query_pb2.QueryPoolResponse,
    ]
    """Fetch a pool by id."""
    Pools: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryPoolsRequest,
        spot.v1.query_pb2.QueryPoolsResponse,
    ]
    """Returns all pools."""
    PoolParams: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryPoolParamsRequest,
        spot.v1.query_pb2.QueryPoolParamsResponse,
    ]
    """Parameters of a single pool."""
    NumPools: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryNumPoolsRequest,
        spot.v1.query_pb2.QueryNumPoolsResponse,
    ]
    """Number of pools."""
    TotalLiquidity: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryTotalLiquidityRequest,
        spot.v1.query_pb2.QueryTotalLiquidityResponse,
    ]
    """Total liquidity across all pools."""
    TotalPoolLiquidity: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryTotalPoolLiquidityRequest,
        spot.v1.query_pb2.QueryTotalPoolLiquidityResponse,
    ]
    """Total liquidity in a single pool."""
    TotalShares: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryTotalSharesRequest,
        spot.v1.query_pb2.QueryTotalSharesResponse,
    ]
    """Total shares in a single pool."""
    SpotPrice: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QuerySpotPriceRequest,
        spot.v1.query_pb2.QuerySpotPriceResponse,
    ]
    """Instantaneous price of an asset in a pool."""
    EstimateSwapExactAmountIn: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QuerySwapExactAmountInRequest,
        spot.v1.query_pb2.QuerySwapExactAmountInResponse,
    ]
    """Estimates the amount of assets returned given an exact amount of tokens to
    swap.
    """
    EstimateSwapExactAmountOut: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QuerySwapExactAmountOutRequest,
        spot.v1.query_pb2.QuerySwapExactAmountOutResponse,
    ]
    """Estimates the amount of tokens required to return the exact amount of
    assets requested.
    """
    EstimateJoinExactAmountIn: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryJoinExactAmountInRequest,
        spot.v1.query_pb2.QueryJoinExactAmountInResponse,
    ]
    """Estimates the amount of pool shares returned given an amount of tokens to
    join.
    """
    EstimateJoinExactAmountOut: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryJoinExactAmountOutRequest,
        spot.v1.query_pb2.QueryJoinExactAmountOutResponse,
    ]
    """Estimates the amount of tokens required to obtain an exact amount of pool
    shares.
    """
    EstimateExitExactAmountIn: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryExitExactAmountInRequest,
        spot.v1.query_pb2.QueryExitExactAmountInResponse,
    ]
    """Estimates the amount of tokens returned to the user given an exact amount
    of pool shares.
    """
    EstimateExitExactAmountOut: grpc.UnaryUnaryMultiCallable[
        spot.v1.query_pb2.QueryExitExactAmountOutRequest,
        spot.v1.query_pb2.QueryExitExactAmountOutResponse,
    ]
    """Estimates the amount of pool shares required to extract an exact amount of
    tokens from the pool.
    """

class QueryServicer(metaclass=abc.ABCMeta):
    """Query defines the gRPC querier service."""

    @abc.abstractmethod
    def Params(
        self,
        request: spot.v1.query_pb2.QueryParamsRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryParamsResponse:
        """Parameters of the spot module."""
    @abc.abstractmethod
    def PoolNumber(
        self,
        request: spot.v1.query_pb2.QueryPoolNumberRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryPoolNumberResponse:
        """Next available pool id number."""
    @abc.abstractmethod
    def Pool(
        self,
        request: spot.v1.query_pb2.QueryPoolRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryPoolResponse:
        """Fetch a pool by id."""
    @abc.abstractmethod
    def Pools(
        self,
        request: spot.v1.query_pb2.QueryPoolsRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryPoolsResponse:
        """Returns all pools."""
    @abc.abstractmethod
    def PoolParams(
        self,
        request: spot.v1.query_pb2.QueryPoolParamsRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryPoolParamsResponse:
        """Parameters of a single pool."""
    @abc.abstractmethod
    def NumPools(
        self,
        request: spot.v1.query_pb2.QueryNumPoolsRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryNumPoolsResponse:
        """Number of pools."""
    @abc.abstractmethod
    def TotalLiquidity(
        self,
        request: spot.v1.query_pb2.QueryTotalLiquidityRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryTotalLiquidityResponse:
        """Total liquidity across all pools."""
    @abc.abstractmethod
    def TotalPoolLiquidity(
        self,
        request: spot.v1.query_pb2.QueryTotalPoolLiquidityRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryTotalPoolLiquidityResponse:
        """Total liquidity in a single pool."""
    @abc.abstractmethod
    def TotalShares(
        self,
        request: spot.v1.query_pb2.QueryTotalSharesRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryTotalSharesResponse:
        """Total shares in a single pool."""
    @abc.abstractmethod
    def SpotPrice(
        self,
        request: spot.v1.query_pb2.QuerySpotPriceRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QuerySpotPriceResponse:
        """Instantaneous price of an asset in a pool."""
    @abc.abstractmethod
    def EstimateSwapExactAmountIn(
        self,
        request: spot.v1.query_pb2.QuerySwapExactAmountInRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QuerySwapExactAmountInResponse:
        """Estimates the amount of assets returned given an exact amount of tokens to
        swap.
        """
    @abc.abstractmethod
    def EstimateSwapExactAmountOut(
        self,
        request: spot.v1.query_pb2.QuerySwapExactAmountOutRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QuerySwapExactAmountOutResponse:
        """Estimates the amount of tokens required to return the exact amount of
        assets requested.
        """
    @abc.abstractmethod
    def EstimateJoinExactAmountIn(
        self,
        request: spot.v1.query_pb2.QueryJoinExactAmountInRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryJoinExactAmountInResponse:
        """Estimates the amount of pool shares returned given an amount of tokens to
        join.
        """
    @abc.abstractmethod
    def EstimateJoinExactAmountOut(
        self,
        request: spot.v1.query_pb2.QueryJoinExactAmountOutRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryJoinExactAmountOutResponse:
        """Estimates the amount of tokens required to obtain an exact amount of pool
        shares.
        """
    @abc.abstractmethod
    def EstimateExitExactAmountIn(
        self,
        request: spot.v1.query_pb2.QueryExitExactAmountInRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryExitExactAmountInResponse:
        """Estimates the amount of tokens returned to the user given an exact amount
        of pool shares.
        """
    @abc.abstractmethod
    def EstimateExitExactAmountOut(
        self,
        request: spot.v1.query_pb2.QueryExitExactAmountOutRequest,
        context: grpc.ServicerContext,
    ) -> spot.v1.query_pb2.QueryExitExactAmountOutResponse:
        """Estimates the amount of pool shares required to extract an exact amount of
        tokens from the pool.
        """

def add_QueryServicer_to_server(servicer: QueryServicer, server: grpc.Server) -> None: ...
