"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class PageRequest(google.protobuf.message.Message):
    """PageRequest is to be embedded in gRPC request messages for efficient
    pagination. Ex:

     message SomeRequest {
             Foo some_parameter = 1;
             PageRequest pagination = 2;
     }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    COUNT_TOTAL_FIELD_NUMBER: builtins.int
    REVERSE_FIELD_NUMBER: builtins.int
    key: builtins.bytes
    """key is a value returned in PageResponse.next_key to begin
    querying the next page most efficiently. Only one of offset or key
    should be set.
    """
    offset: builtins.int
    """offset is a numeric offset that can be used when key is unavailable.
    It is less efficient than using key. Only one of offset or key should
    be set.
    """
    limit: builtins.int
    """limit is the total number of results to be returned in the result page.
    If left empty it will default to a value to be set by each app.
    """
    count_total: builtins.bool
    """count_total is set to true  to indicate that the result set should include
    a count of the total number of items available for pagination in UIs.
    count_total is only respected when offset is used. It is ignored when key
    is set.
    """
    reverse: builtins.bool
    """reverse is set to true if results are to be returned in the descending order.

    Since: cosmos-sdk 0.43
    """
    def __init__(
        self,
        *,
        key: builtins.bytes = ...,
        offset: builtins.int = ...,
        limit: builtins.int = ...,
        count_total: builtins.bool = ...,
        reverse: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["count_total", b"count_total", "key", b"key", "limit", b"limit", "offset", b"offset", "reverse", b"reverse"]) -> None: ...

global___PageRequest = PageRequest

@typing_extensions.final
class PageResponse(google.protobuf.message.Message):
    """PageResponse is to be embedded in gRPC response messages where the
    corresponding request message has used PageRequest.

     message SomeResponse {
             repeated Bar results = 1;
             PageResponse page = 2;
     }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEXT_KEY_FIELD_NUMBER: builtins.int
    TOTAL_FIELD_NUMBER: builtins.int
    next_key: builtins.bytes
    """next_key is the key to be passed to PageRequest.key to
    query the next page most efficiently
    """
    total: builtins.int
    """total is total number of results available if PageRequest.count_total
    was set, its value is undefined otherwise
    """
    def __init__(
        self,
        *,
        next_key: builtins.bytes = ...,
        total: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_key", b"next_key", "total", b"total"]) -> None: ...

global___PageResponse = PageResponse
