# Piday

Piday — это утилита для вычисления оценки числа $\pi$ методами Монте-Карло. Изначально метод был придуман для вычисления оченок ручками во время дня $\pi$ (03.14.2025).

Основная идея представить $\pi$ как площадь круга еденичного радиуса. В данном случае вычисляется интеграл
$$ \int_0^1 \sqrt{1 - x^2}\,dx. $$
Верхняя и нижняя оценки получаются из верхних и нижней суммы Дарбу. Подразбиение отрезка происходит на $n$ частей, распределение точек подразбиения полуучается по формуле 
$$ \xi_m = \frac{n^2 - m^2}{n^2 + m^2}. $$
Эта формула получается из общего вида Пифагоровых троек. Она необходима для простоты вычисления значения функции в этих точках, а именно
$$ \sqrt{1 - \xi_m^2} = \frac{2mn}{n^2 + m^2}. $$

## Установка

```sh
pip install cat_piday
```

## Искользование
```sh
piday --n="количество точек подразбиения"
```

Вывод имеет вид
```sh
Time taken: # затраченое время

pi is between: # значение нижней суммы Драбу * 4" and "значение верхней суммы Дарбу * 4
               # зеленый цвет означает совпадение цифр - в данном случае - теоретически достоверные значения

Approximation: # среднее арифметическое полученых оценок
               # зеленый цвет - теоретически верные цифры
               # желтый цвет  - совпадеие с истенным значением числа pi без теоретического обоснования
               # красный цвет - несовпавшие цифры
true value   : # настоящее значение числа pi
Error        : # абсолютная ошибка
```