# Mass absoption coefficient Chantler2005
# See https://dx.doi.org/10.18434/T4HS32
# Chantler, C.T., Olsen, K., Dragoset, R.A., Kishore, A.R., Kotochigova,
# S.A., and Zucker, D.S. (2005), X-Ray Form Factor, Attenuation and
# Scattering Tables (version 2.1).
# units cm^2/g

from hyperspy.misc import utils

ffast_mac = {'Ru': {'mass_absorption_coefficient (cm2/g)': [199360.0, 198330.0, 196750.0, 194530.0, 191680.0, 188160.0, 184010.0, 179240.0, 173900.0, 168030.0, 161720.0, 155050.0, 148080.0, 140920.0, 133640.0, 126320.0, 119050.0, 111890.0, 104900.0, 97628.0, 88273.0, 83018.0, 81057.0, 80545.0, 137480.0, 136560.0, 130800.0, 109930.0, 90227.0, 75783.0, 64664.0, 55753.0, 48403.0, 42219.0, 37562.0, 36946.0, 36449.0, 36161.0, 36630.0, 35616.0, 33344.0, 29474.0, 26109.0, 23171.0, 20599.0, 18343.0, 16360.0, 14614.0, 13075.0, 11715.0, 10512.0, 9444.8, 8496.1, 7649.7, 6892.5, 6213.3, 5602.6, 5052.5, 4555.9, 4278.7, 4180.5, 4178.8, 4152.7, 7745.7, 7761.5, 7815.4, 7874.5, 10454.0, 10911.0, 12318.0, 15520.0, 18498.0, 20594.0, 21565.0, 21450.0, 20470.0, 20339.0, 20012.0, 19922.0, 22293.0, 21909.0, 21719.0, 21356.0, 21298.0, 21185.0, 22047.0, 21606.0, 20374.0, 18244.0, 16804.0, 16331.0, 16208.0, 16850.0, 16729.0, 16268.0, 14825.0, 12973.0, 11310.0, 9838.6, 8535.4, 7382.2, 6377.9, 5506.7, 4716.8, 4026.6, 3408.9, 2890.5, 2454.9, 2088.2, 1779.2, 1518.4, 1298.1, 1105.5, 938.86, 798.41, 679.61, 578.54, 493.06, 466.46, 449.9, 445.63, 1595.9, 1538.7, 1525.6, 1521.9, 1466.0, 1451.6, 1995.6, 1946.9, 1782.6, 1678.5, 1592.8, 1571.1, 1780.3, 1700.5, 1653.6, 1391.4, 1212.5, 1030.3, 866.03, 727.75, 611.86, 514.7, 433.08, 362.71, 303.45, 253.57, 212.08, 177.55, 148.78, 124.42, 103.21, 85.697, 71.222, 59.217, 49.218, 40.811, 33.786, 27.923, 23.098, 19.124, 15.848, 13.145, 10.912, 10.668, 10.227, 10.114, 67.868, 65.103, 61.789, 51.765, 43.567, 36.492, 30.434, 25.355, 21.127, 17.605, 14.672, 12.229, 10.18, 8.4239, 6.9713, 5.7697, 4.7756, 3.9528, 3.2718, 2.7068, 2.2387, 1.8492, 1.523, 1.2543, 1.0321, 0.84874, 0.69797, 0.57402, 0.4721, 0.38829, 0.31938, 0.2627, 0.2161, 0.17777, 0.14624, 0.12031, 0.098979, 0.081433, 0.067001, 0.055128, 0.04536, 0.037324, 0.030713, 0.025274, 0.020798, 0.017116, 0.014085, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.042238, 0.0428845, 0.0430569, 0.0433155, 0.04340198, 0.043962, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.073402, 0.07401695, 0.0745255, 0.0748251, 0.0752745, 0.076398, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.273812, 0.277928, 0.278003, 0.2791206, 0.280797, 0.2811158, 0.282182, 0.2833164, 0.285018, 0.289272, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.451388, 0.458297, 0.4601394, 0.462903, 0.469812, 0.473144, 0.4794098, 0.480386, 0.4823172, 0.485214, 0.492456, 0.5124891, 0.5478508, 0.5733, 0.582075, 0.584415, 0.5856525, 0.587925, 0.5967, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.781142, 2.82371, 2.835062, 2.852089, 2.894658, 2.904724, 2.907562, 2.952066, 2.963933, 2.981735, 3.026238, 3.10515, 3.15952, 3.20788, 3.220776, 3.24012, 3.28848, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 21.67486, 22.00661, 22.09508, 22.22779, 22.55954, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Re': {'mass_absorption_coefficient (cm2/g)': [12574.0, 12380.0, 11100.0, 11011.0, 10992.0, 50183.0, 49391.0, 72464.0, 79935.0, 87210.0, 93764.0, 99067.0, 102640.0, 104140.0, 103380.0, 100380.0, 95333.0, 88613.0, 80669.0, 71997.0, 63066.0, 54267.0, 45970.0, 38422.0, 31754.0, 29930.0, 28604.0, 28261.0, 56187.0, 54035.0, 53089.0, 44443.0, 39056.0, 37365.0, 36924.0, 41471.0, 40847.0, 39026.0, 33631.0, 30574.0, 29084.0, 28704.0, 38917.0, 37638.0, 37387.0, 31553.0, 26528.0, 22170.0, 18547.0, 15680.0, 13540.0, 12064.0, 11178.0, 10981.0, 10896.0, 10878.0, 11042.0, 10999.0, 10996.0, 11076.0, 11536.0, 12319.0, 13355.0, 14586.0, 15934.0, 17315.0, 18651.0, 19871.0, 20906.0, 21641.0, 22028.0, 22071.0, 21799.0, 21253.0, 20484.0, 19981.0, 19742.0, 19677.0, 20266.0, 20174.0, 20020.0, 19840.0, 19575.0, 19504.0, 19900.0, 19629.0, 19500.0, 18216.0, 16910.0, 15622.0, 14377.0, 13192.0, 12079.0, 11487.0, 11254.0, 11193.0, 11860.0, 11797.0, 11633.0, 10808.0, 10223.0, 10156.0, 10089.0, 10022.0, 9955.6, 9889.6, 9824.0, 9773.6, 9758.7, 9894.0, 9850.8, 9786.3, 9722.1, 9658.3, 9594.8, 9531.7, 9469.0, 9406.6, 9344.5, 9282.8, 9221.4, 9160.4, 9099.7, 9039.4, 8979.3, 8919.6, 8860.3, 8801.2, 8742.5, 8684.1, 8626.1, 8568.3, 8510.8, 8453.7, 8396.9, 8340.3, 8284.1, 8228.2, 8172.5, 8117.2, 8062.2, 8007.4, 7952.9, 7898.8, 7844.9, 7791.3, 7738.0, 7715.0, 7877.4, 7874.9, 7824.1, 7771.0, 7718.2, 7665.6, 7613.4, 7561.4, 7509.7, 7458.2, 7407.0, 7356.0, 7305.4, 7254.9, 7204.8, 7154.9, 7105.3, 7055.9, 7006.8, 6958.0, 6909.4, 6861.1, 6813.0, 6765.2, 6717.6, 6670.2, 6623.1, 6576.3, 6529.7, 6483.3, 6437.2, 6391.3, 6345.7, 6300.3, 6255.1, 6210.2, 6165.5, 6121.1, 6076.7, 6032.4, 5988.3, 5941.6, 5891.2, 5841.1, 5791.4, 5742.0, 5692.9, 5644.1, 5595.7, 5547.7, 5499.9, 5452.5, 5405.5, 5358.7, 5312.3, 5266.3, 5220.5, 5175.1, 5130.1, 5085.3, 5040.9, 4996.8, 4953.1, 4909.7, 4866.6, 4823.8, 4781.3, 4739.2, 4697.4, 4655.8, 4614.5, 4573.6, 4532.9, 4492.6, 4452.6, 4412.9, 4373.5, 4334.4, 4295.7, 4257.2, 4219.0, 4181.2, 4143.6, 4106.4, 4069.5, 4032.8, 3996.5, 3960.4, 3924.7, 3889.3, 3854.1, 3819.2, 3784.7, 3750.4, 3716.4, 3682.6, 3644.1, 3606.0, 3568.3, 3531.0, 3494.1, 3457.7, 3421.7, 3386.0, 3348.4, 3311.3, 3274.6, 3238.2, 3202.3, 3166.9, 3131.8, 3097.3, 3063.1, 3029.3, 2994.7, 2960.4, 2926.5, 2893.0, 2860.0, 2827.3, 2795.1, 2763.3, 2731.9, 2700.9, 2670.2, 2640.0, 2610.1, 2580.6, 2551.5, 2522.8, 2494.4, 2466.3, 2438.6, 2411.3, 2384.3, 2357.6, 2331.3, 2305.2, 2279.5, 2254.2, 2229.1, 2204.3, 2179.9, 2155.7, 2131.9, 2108.3, 2085.1, 2062.1, 2039.4, 2017.0, 1994.8, 1972.9, 1951.3, 1929.9, 1908.9, 1888.0, 1867.4, 1847.1, 1827.0, 1807.2, 1787.5, 1768.2, 1749.0, 1730.1, 1711.4, 1693.0, 1674.8, 1656.7, 1638.9, 1621.3, 1604.0, 1586.8, 1569.8, 1553.0, 1536.5, 1520.1, 1503.9, 1487.9, 1472.1, 1456.5, 1441.1, 1425.9, 1410.8, 1395.9, 1381.2, 1366.6, 1352.2, 1338.0, 1324.0, 1310.1, 1296.4, 1282.8, 1269.4, 1256.2, 1243.1, 1230.1, 1217.3, 1204.7, 1192.2, 1179.8, 1167.6, 1155.5, 1143.6, 1131.8, 1120.2, 1108.6, 1097.2, 1086.0, 1074.8, 1063.8, 1052.9, 1042.0, 1031.1, 1020.4, 1009.7, 999.2, 988.8, 978.52, 968.36, 958.32, 948.39, 938.57, 930.67, 3066.5, 3062.7, 3026.1, 2989.9, 2954.1, 2918.8, 2884.0, 2849.5, 2826.2, 4180.9, 4172.8, 4122.3, 4072.5, 4023.3, 3974.7, 3926.7, 3879.3, 3832.5, 3786.2, 3740.6, 3695.4, 3650.9, 3606.9, 3563.3, 3520.2, 3477.7, 3435.7, 3394.3, 3353.3, 3312.8, 3272.9, 3233.4, 3194.4, 3155.9, 3117.9, 3080.3, 3043.2, 3006.6, 2970.4, 2934.6, 2899.3, 2864.4, 2829.9, 2795.9, 2762.3, 2729.1, 2696.3, 2663.9, 2631.9, 2614.2, 3051.7, 3050.0, 3012.4, 2975.4, 2938.8, 2902.7, 2867.0, 2831.8, 2796.6, 2761.5, 2726.9, 2693.6, 2661.3, 2629.6, 2598.3, 2567.1, 2536.3, 2505.8, 2475.8, 2446.2, 2417.1, 2388.3, 2359.9, 2331.8, 2304.2, 2276.9, 2263.7, 2405.5, 2405.0, 2376.3, 2347.6, 2319.2, 2291.2, 2263.5, 2236.2, 2209.2, 2182.6, 2156.2, 2130.9, 2106.3, 2082.1, 2058.3, 2034.8, 2011.6, 1988.8, 1966.2, 1961.1, 2030.6, 2029.9, 2007.8, 1985.2, 1962.9, 1940.8, 1917.9, 1894.9, 1872.2, 1849.8, 1827.6, 1805.6, 1783.8, 1762.2, 1740.9, 1719.9, 1699.1, 1678.5, 1658.2, 1638.2, 1618.4, 1598.8, 1579.5, 1560.3, 1541.5, 1522.8, 1504.4, 1486.1, 1468.1, 1450.3, 1432.8, 1415.4, 1398.2, 1381.3, 1364.5, 1348.0, 1331.6, 1315.4, 1299.5, 1283.7, 1268.1, 1252.7, 1237.4, 1222.4, 1207.6, 1192.9, 1178.5, 1164.2, 1150.1, 1136.1, 1122.4, 1108.7, 1094.8, 1081.1, 1067.6, 1054.3, 1041.1, 1028.1, 1015.2, 1002.3, 989.48, 976.89, 964.46, 952.2, 940.11, 928.18, 916.42, 904.82, 893.37, 882.08, 870.94, 859.95, 849.11, 838.42, 827.87, 817.46, 807.2, 797.07, 787.08, 777.22, 767.5, 757.91, 748.44, 739.1, 729.89, 720.8, 711.84, 702.99, 694.26, 685.65, 677.15, 668.76, 660.49, 652.33, 644.27, 636.33, 628.48, 620.69, 612.84, 605.1, 597.46, 589.92, 582.49, 575.15, 567.87, 560.68, 553.59, 546.59, 539.69, 532.88, 526.17, 519.54, 513.0, 506.55, 500.17, 493.86, 487.64, 481.5, 475.44, 469.47, 463.58, 457.76, 452.0, 446.24, 440.57, 434.97, 429.44, 423.99, 418.61, 413.31, 408.07, 402.91, 397.81, 392.78, 387.82, 382.93, 378.1, 373.34, 368.63, 364.0, 359.41, 354.86, 350.37, 345.95, 341.58, 337.27, 333.02, 328.83, 324.69, 320.6, 316.57, 312.59, 308.67, 304.79, 300.97, 297.2, 293.48, 289.8, 286.18, 282.6, 279.07, 275.59, 272.15, 268.76, 265.41, 262.11, 258.85, 255.63, 252.45, 249.32, 246.22, 243.17, 240.16, 237.18, 234.25, 231.35, 228.49, 225.67, 222.88, 220.14, 217.42, 214.74, 212.1, 209.49, 206.92, 204.37, 201.86, 199.39, 196.94, 194.53, 192.15, 189.8, 187.48, 185.18, 182.92, 180.69, 178.49, 176.31, 174.16, 172.04, 169.95, 167.88, 165.84, 163.83, 161.84, 159.88, 157.94, 155.99, 154.07, 152.18, 150.31, 148.46, 146.63, 144.82, 143.01, 141.23, 122.4, 102.1, 85.275, 85.171, 81.694, 80.801, 215.03, 206.47, 192.12, 162.68, 159.87, 155.98, 154.26, 211.96, 203.57, 200.05, 191.94, 189.86, 216.47, 215.7, 208.44, 181.84, 152.93, 128.55, 107.92, 90.543, 75.994, 63.816, 53.585, 44.958, 37.732, 31.639, 26.324, 21.86, 18.169, 15.114, 12.583, 10.484, 8.7415, 7.2943, 6.0809, 5.0699, 4.2218, 3.5035, 2.9089, 2.4151, 2.1041, 2.0173, 2.0065, 1.9949, 10.048, 9.6829, 8.6629, 7.2598, 6.089, 5.1151, 4.2756, 3.5744, 2.9885, 2.4991, 2.0901, 1.7482, 1.4597, 1.2173, 1.0153, 0.84684, 0.70641, 0.58933, 0.49169, 0.41027, 0.34236, 0.28571, 0.23846, 0.19903, 0.16744, 0.1409, 0.11858, 0.0998, 0.084002, 0.0],
                    'energies (keV)': [0.005235171, 0.005313308, 0.005941418, 0.006032358, 0.006056608, 0.006092984, 0.006183924, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.033908, 0.034427, 0.0345654, 0.034773, 0.035292, 0.03552846, 0.03797993, 0.039788, 0.040397, 0.0405594, 0.04060054, 0.040803, 0.041412, 0.04340198, 0.044688, 0.045372, 0.0455544, 0.045828, 0.04639671, 0.046512, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.081144, 0.082386, 0.0827172, 0.083214, 0.084456, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.254996, 0.258899, 0.2599398, 0.261501, 0.2629708, 0.265404, 0.268226, 0.2723315, 0.2734263, 0.2750685, 0.279174, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.435512, 0.442178, 0.4439556, 0.446622, 0.4484657, 0.453288, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.51717493, 0.5177647, 0.51862505, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62404375, 0.62581041, 0.62595625, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.8825065, 1.8832935, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9481516, 1.9496484, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3649801, 2.36962, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6780604, 2.6849291, 2.6851398, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9258366, 2.9371216, 2.9375634, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 10.32459, 10.48262, 10.52476, 10.58798, 10.74601, 11.03212, 11.71953, 11.79334, 11.89891, 11.94674, 12.01849, 12.19787, 12.27617, 12.46407, 12.51417, 12.58933, 12.60708, 12.77723, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 70.24287, 71.31802, 71.45536, 71.60472, 72.03478, 73.10993, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ra': {'mass_absorption_coefficient (cm2/g)': [210240.0, 195520.0, 180640.0, 130300.0, 95222.0, 70955.0, 53769.0, 41353.0, 32220.0, 25389.0, 20197.0, 16194.0, 13066.0, 10593.0, 9108.4, 8693.0, 8619.8, 8586.7, 9572.7, 9110.2, 7857.9, 6328.5, 5137.7, 4197.5, 3447.3, 2844.8, 2713.9, 2600.2, 2571.1, 249970.0, 239310.0, 232330.0, 191230.0, 147860.0, 103470.0, 67758.0, 42713.0, 26528.0, 16540.0, 10506.0, 6873.6, 4665.9, 3299.3, 2767.2, 2586.1, 2541.2, 3858.8, 3801.6, 3659.9, 3033.4, 2487.5, 2101.6, 1916.8, 1857.8, 1842.9, 2526.4, 2525.4, 2430.9, 2144.1, 1856.7, 1643.4, 1607.4, 1568.9, 1559.1, 1682.6, 1648.0, 1618.5, 1490.9, 1425.9, 1403.9, 1398.3, 1571.9, 1598.6, 1822.9, 2616.4, 4076.0, 6070.3, 8227.2, 10108.0, 11399.0, 11852.0, 11887.0, 11919.0, 11947.0, 11971.0, 11991.0, 12008.0, 12022.0, 12032.0, 12038.0, 12041.0, 12041.0, 12038.0, 12032.0, 12022.0, 12009.0, 11994.0, 11975.0, 11954.0, 11930.0, 11904.0, 11875.0, 11843.0, 11809.0, 11773.0, 11734.0, 11693.0, 11650.0, 11605.0, 11558.0, 11510.0, 11459.0, 11406.0, 11352.0, 11297.0, 11239.0, 11181.0, 11120.0, 11100.0, 11945.0, 11920.0, 11860.0, 11799.0, 11736.0, 11672.0, 11608.0, 11542.0, 11475.0, 11408.0, 11340.0, 11271.0, 11265.0, 11737.0, 11691.0, 11623.0, 11554.0, 11485.0, 11415.0, 11344.0, 11273.0, 11202.0, 11130.0, 11058.0, 10986.0, 10913.0, 10840.0, 10767.0, 10693.0, 10619.0, 10545.0, 10471.0, 10397.0, 10322.0, 10248.0, 10173.0, 10098.0, 10024.0, 9948.9, 9874.1, 9799.4, 9724.6, 9649.9, 9575.3, 9500.7, 9426.3, 9352.0, 9277.9, 9204.0, 9130.2, 9056.7, 8983.5, 8910.4, 8837.7, 8765.2, 8693.1, 8621.2, 8549.7, 8478.5, 8407.6, 8337.1, 8267.0, 8197.3, 8127.9, 8059.0, 7990.4, 7922.3, 7854.6, 7787.3, 7720.4, 7654.0, 7588.1, 7522.6, 7457.5, 7393.0, 7328.9, 7265.2, 7202.1, 7144.4, 7139.4, 7567.2, 7526.2, 7462.3, 7398.6, 7335.3, 7272.5, 7210.2, 7148.4, 7087.1, 7026.3, 6965.9, 6906.0, 6846.6, 6787.7, 6729.3, 6671.4, 6613.9, 6557.0, 6500.5, 6444.5, 6389.0, 6334.0, 6279.5, 6225.4, 6171.8, 6118.6, 6065.9, 6010.7, 5955.9, 5901.5, 5846.8, 5791.3, 5736.2, 5681.5, 5627.4, 5573.6, 5520.3, 5469.3, 5467.5, 5522.3, 5492.9, 5440.5, 5388.5, 5336.2, 5283.9, 5231.9, 5180.5, 5129.5, 5078.9, 5028.9, 4979.5, 4930.5, 4882.0, 4834.0, 4786.4, 4739.3, 4692.7, 4646.4, 4600.7, 4555.4, 4510.5, 4466.0, 4422.0, 4378.5, 4334.1, 4285.4, 4251.9, 4323.1, 4315.2, 4275.1, 4227.6, 4180.8, 4134.5, 4088.8, 4043.7, 3999.1, 3955.1, 3911.4, 3868.0, 3825.3, 3783.1, 3741.4, 3700.2, 3659.5, 3619.4, 3579.7, 3540.6, 3501.9, 3463.7, 3426.0, 3388.7, 3351.9, 3315.6, 3279.7, 3244.2, 3209.0, 3174.2, 3139.9, 3106.0, 3072.5, 3039.4, 3006.7, 2974.4, 2942.5, 2911.0, 2879.9, 2849.1, 2818.7, 2788.6, 2759.0, 2729.4, 2700.1, 2671.2, 2642.6, 2614.3, 2586.4, 2558.8, 2531.6, 2504.6, 2478.0, 2451.7, 2425.6, 2399.8, 2374.3, 2349.1, 2324.3, 2299.7, 2275.3, 2251.3, 2227.5, 2204.1, 2180.9, 2157.9, 2135.3, 2112.8, 2090.7, 2068.8, 2047.2, 2025.8, 2004.6, 1983.7, 1963.1, 1942.6, 1922.4, 1902.5, 1882.7, 1863.2, 1844.0, 1824.9, 1806.1, 1787.4, 1769.0, 1750.8, 1732.8, 1715.0, 1697.4, 1680.1, 1662.9, 1645.9, 1629.1, 1612.4, 1596.0, 1579.8, 1563.7, 1547.9, 1532.2, 1516.6, 1501.3, 1486.1, 1471.1, 1456.3, 1441.7, 1427.2, 1412.8, 1398.6, 1384.6, 1370.8, 1357.1, 1343.5, 1330.1, 1316.9, 1303.7, 1290.7, 1277.8, 1265.0, 1252.4, 1239.9, 1227.6, 1215.4, 1203.3, 1191.4, 1179.6, 1167.9, 1156.3, 1144.9, 1133.6, 1122.5, 1111.4, 1100.5, 1089.7, 1079.0, 1068.5, 1058.0, 1047.7, 1037.4, 1027.3, 1017.3, 1007.1, 996.65, 986.36, 976.18, 966.11, 956.16, 946.32, 936.59, 926.97, 917.45, 908.05, 898.44, 888.88, 879.43, 870.09, 860.86, 851.73, 842.71, 833.79, 824.97, 816.25, 807.63, 799.11, 790.69, 782.36, 774.13, 765.99, 757.94, 749.98, 742.12, 734.34, 726.65, 719.05, 711.54, 704.11, 696.75, 689.46, 682.26, 675.14, 668.09, 661.13, 654.25, 647.44, 640.71, 632.95, 624.93, 617.01, 609.21, 601.51, 593.92, 586.43, 585.83, 1532.0, 1515.6, 1495.4, 1475.5, 1455.8, 1436.4, 1417.3, 1398.5, 1379.9, 1361.6, 1359.1, 1959.4, 1940.0, 1914.2, 1888.7, 1863.5, 1838.7, 1814.2, 1790.1, 1766.3, 1742.8, 1719.6, 1696.8, 1674.2, 1652.0, 1630.1, 1608.4, 1587.1, 1565.9, 1545.1, 1524.5, 1504.2, 1484.2, 1464.4, 1444.9, 1425.7, 1406.8, 1388.1, 1369.6, 1351.4, 1333.5, 1315.8, 1299.0, 1298.3, 1510.3, 1500.0, 1481.2, 1462.6, 1444.3, 1426.2, 1408.4, 1390.7, 1373.4, 1356.2, 1339.2, 1322.5, 1305.9, 1289.6, 1273.2, 1257.1, 1241.2, 1225.5, 1210.0, 1194.7, 1179.5, 1164.6, 1149.9, 1135.2, 1120.7, 1106.4, 1092.3, 1078.3, 1064.6, 1051.0, 1037.6, 1024.3, 1011.2, 998.34, 988.4, 985.61, 1044.7, 1036.5, 1023.6, 1010.9, 998.4, 986.01, 973.76, 961.67, 949.73, 937.95, 926.32, 914.85, 903.54, 892.36, 881.66, 881.33, 910.8, 908.9, 897.94, 887.11, 876.42, 865.84, 855.31, 844.92, 834.65, 824.52, 814.51, 804.6, 794.82, 785.17, 775.63, 766.21, 756.91, 747.72, 738.64, 729.67, 720.82, 712.07, 703.44, 694.91, 686.49, 678.17, 669.96, 661.85, 653.84, 645.94, 638.13, 630.41, 622.77, 615.23, 607.78, 600.43, 593.17, 586.0, 578.92, 571.91, 564.95, 558.07, 551.28, 544.58, 537.96, 531.42, 524.97, 518.6, 512.3, 506.09, 499.96, 493.9, 487.83, 481.82, 475.88, 470.01, 464.22, 458.5, 452.86, 447.29, 441.79, 436.31, 430.89, 425.54, 420.26, 415.05, 409.9, 404.83, 399.81, 394.86, 389.98, 385.16, 380.4, 375.7, 371.06, 366.49, 361.97, 357.51, 353.1, 348.76, 344.47, 340.23, 336.05, 331.93, 327.86, 323.84, 319.87, 315.95, 312.08, 308.27, 304.5, 300.78, 297.07, 293.4, 289.78, 286.21, 282.68, 279.2, 275.76, 272.37, 269.02, 265.72, 262.46, 259.24, 256.06, 252.92, 249.83, 246.77, 243.76, 240.78, 237.84, 234.94, 232.08, 229.25, 226.46, 223.71, 194.51, 162.71, 136.21, 114.22, 95.879, 80.554, 67.779, 56.935, 50.072, 48.141, 47.869, 47.644, 117.99, 113.5, 101.05, 84.282, 77.895, 74.726, 73.91, 102.87, 99.499, 98.973, 98.945, 95.101, 94.104, 107.2, 103.3, 97.085, 81.871, 68.987, 58.142, 49.014, 41.071, 34.373, 28.745, 24.032, 20.113, 16.798, 14.002, 11.68, 9.7504, 8.146, 6.8107, 5.6985, 4.7716, 3.9983, 3.3462, 2.8028, 2.3426, 1.942, 1.6096, 1.3351, 1.2598, 1.2075, 1.194, 5.3627, 5.1646, 5.0868, 4.2898, 3.6138, 3.0412, 2.5585, 2.1518, 1.8075, 1.5183, 1.2755, 1.0715, 0.9003, 0.7567, 0.63628, 0.53509, 0.45004, 0.37855, 0.31845, 0.26792, 0.22543, 0.1897, 0.15964, 0.13436, 0.0],
                    'energies (keV)': [0.018894, 0.019176, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04263, 0.0432825, 0.04340198, 0.0434565, 0.0437175, 0.04437, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.065856, 0.066864, 0.0671328, 0.067536, 0.068544, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.149744, 0.152036, 0.1526472, 0.153564, 0.1542005, 0.155856, 0.1648404, 0.1762144, 0.1883732, 0.196392, 0.199398, 0.2001996, 0.2013709, 0.201402, 0.204408, 0.2152655, 0.2301188, 0.245997, 0.249312, 0.253128, 0.2541456, 0.255672, 0.259488, 0.2629708, 0.2811158, 0.292922, 0.2974055, 0.2986011, 0.3005128, 0.304878, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60233476, 0.60306523, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.63551339, 0.63628665, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87813301, 0.87848628, 0.88006703, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0563415, 1.0565238, 1.0588586, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2069862, 1.2088236, 1.2098138, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1040119, 3.1057879, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2473832, 3.2494167, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7870982, 3.7878352, 3.7965019, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4829005, 4.4878381, 4.4960996, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8116809, 4.8124036, 4.8323191, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.13551, 15.36718, 15.40095, 15.42896, 15.52162, 15.75329, 16.46362, 17.59961, 18.11461, 18.39188, 18.46582, 18.57672, 18.81398, 18.85197, 18.85399, 19.14052, 19.21746, 19.33288, 19.62143, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 101.8435, 103.4023, 103.818, 104.4415, 106.0003, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Rb': {'mass_absorption_coefficient (cm2/g)': [1155.1, 1197.9, 1241.7, 1293.7, 2177.5, 2206.8, 2533.4, 3616.9, 7005.6, 11952.0, 18002.0, 24420.0, 30356.0, 35096.0, 38217.0, 39620.0, 39459.0, 38040.0, 37567.0, 37062.0, 36922.0, 39341.0, 38941.0, 38820.0, 38408.0, 38383.0, 38230.0, 39094.0, 38523.0, 36832.0, 33878.0, 30792.0, 28524.0, 27833.0, 27726.0, 27651.0, 28648.0, 27968.0, 25985.0, 23154.0, 20536.0, 18144.0, 15977.0, 14023.0, 12269.0, 10705.0, 9318.2, 8093.3, 7015.6, 6070.6, 5244.5, 4524.3, 3897.8, 3354.1, 2883.2, 2425.2, 2042.0, 1721.9, 1453.7, 1227.6, 1038.1, 879.02, 745.38, 679.83, 655.01, 648.62, 3109.1, 3068.7, 3037.3, 2964.2, 2892.3, 2855.2, 3979.8, 3797.3, 3543.2, 3184.6, 3059.8, 3027.9, 3435.0, 3413.0, 3310.1, 2897.9, 2470.0, 2095.0, 1774.1, 1500.6, 1264.5, 1062.0, 892.76, 747.35, 623.99, 520.11, 433.24, 360.87, 300.85, 251.04, 209.67, 175.18, 146.5, 122.62, 102.67, 85.691, 71.32, 58.603, 48.201, 39.683, 32.703, 26.976, 22.274, 18.409, 16.742, 16.035, 15.853, 120.04, 117.14, 114.83, 96.694, 81.066, 68.293, 57.49, 48.106, 40.198, 33.564, 28.02, 23.316, 19.381, 16.029, 13.243, 10.942, 9.0405, 7.4694, 6.1706, 5.0953, 4.2076, 3.4749, 2.8699, 2.3704, 1.9558, 1.6074, 1.3212, 1.0848, 0.88866, 0.72801, 0.59643, 0.48865, 0.40036, 0.32804, 0.26879, 0.22026, 0.18049, 0.14791, 0.12121, 0.099338, 0.081414, 0.066726, 0.05469, 0.044826, 0.036743, 0.030118, 0.024688, 0.020238, 0.01659, 0.0136, 0.01115, 0.009141, 0.0074943, 0.0],
                    'energies (keV)': [0.1104581, 0.1108515, 0.111241, 0.1116882, 0.112359, 0.112506, 0.114036, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.23373, 0.2373075, 0.2382615, 0.2396925, 0.242452, 0.24327, 0.245997, 0.246163, 0.2471526, 0.248637, 0.252348, 0.2629708, 0.2811158, 0.3005128, 0.315658, 0.3204895, 0.3212482, 0.3217779, 0.3237105, 0.328542, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.768312, 1.795378, 1.802596, 1.813422, 1.820795, 1.826622, 1.840488, 1.85458, 1.862036, 1.873219, 1.901178, 1.94643, 2.023798, 2.054774, 2.063035, 2.075425, 2.080733, 2.106402, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 14.89571, 15.1237, 15.1845, 15.2757, 15.40095, 15.50369, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Rn': {'mass_absorption_coefficient (cm2/g)': [215510.0, 210090.0, 112670.0, 109430.0, 108580.0, 188900.0, 187050.0, 184380.0, 167450.0, 149260.0, 132160.0, 116160.0, 101300.0, 87647.0, 75226.0, 64058.0, 54131.0, 45409.0, 41689.0, 39986.0, 39546.0, 44411.0, 43067.0, 42431.0, 35016.0, 28410.0, 23027.0, 18642.0, 15078.0, 12191.0, 9856.0, 7972.9, 6457.3, 5239.7, 5009.7, 4947.7, 8098.8, 8661.2, 10260.0, 12934.0, 14989.0, 15620.0, 18905.0, 21844.0, 22158.0, 41339.0, 65421.0, 84201.0, 90662.0, 84419.0, 70172.0, 53600.0, 38601.0, 26797.0, 18271.0, 12424.0, 8528.8, 6416.6, 5964.6, 5927.3, 5805.7, 7910.0, 7395.5, 6182.6, 4698.3, 3684.5, 3330.0, 3174.5, 3135.5, 4362.5, 4208.5, 4154.9, 3418.2, 2834.7, 2402.1, 2179.2, 2111.3, 2094.1, 2228.2, 2218.6, 2158.9, 2095.2, 2041.4, 2027.8, 2150.6, 2140.3, 2132.3, 2126.1, 2123.9, 2223.1, 2246.3, 2329.9, 2845.6, 3840.7, 5292.0, 7062.2, 8923.8, 10631.0, 11986.0, 12879.0, 13283.0, 13242.0, 12836.0, 12436.0, 12382.0, 12327.0, 12272.0, 12215.0, 12157.0, 12098.0, 12039.0, 11978.0, 11916.0, 11854.0, 11791.0, 11727.0, 11662.0, 11596.0, 11585.0, 12342.0, 12309.0, 12246.0, 12183.0, 12119.0, 12054.0, 11989.0, 11924.0, 11858.0, 11792.0, 11725.0, 11663.0, 11658.0, 12090.0, 12039.0, 11974.0, 11909.0, 11843.0, 11777.0, 11711.0, 11645.0, 11579.0, 11513.0, 11446.0, 11379.0, 11312.0, 11245.0, 11177.0, 11110.0, 11042.0, 10974.0, 10906.0, 10838.0, 10770.0, 10701.0, 10633.0, 10564.0, 10496.0, 10427.0, 10358.0, 10288.0, 10219.0, 10150.0, 10081.0, 10012.0, 9942.3, 9873.1, 9803.9, 9734.7, 9665.6, 9596.6, 9527.7, 9458.9, 9390.2, 9321.6, 9253.1, 9184.8, 9116.7, 9048.7, 8980.9, 8913.4, 8845.8, 8778.5, 8711.4, 8644.5, 8577.8, 8511.4, 8445.3, 8379.4, 8313.8, 8248.5, 8183.4, 8118.7, 8054.3, 8007.8, 7990.1, 8467.4, 8426.4, 8360.8, 8295.6, 8230.7, 8166.2, 8102.0, 8038.2, 7974.8, 7911.7, 7849.0, 7786.7, 7724.7, 7663.2, 7602.0, 7541.3, 7480.9, 7420.8, 7361.1, 7301.8, 7242.9, 7184.5, 7126.3, 7068.6, 7011.3, 6954.3, 6897.8, 6841.7, 6785.9, 6730.6, 6675.6, 6621.1, 6567.0, 6513.3, 6459.0, 6404.1, 6349.5, 6295.3, 6248.6, 6241.4, 6296.2, 6272.3, 6219.2, 6166.6, 6114.4, 6062.6, 6011.3, 5959.6, 5907.9, 5856.7, 5805.9, 5755.6, 5705.6, 5656.2, 5607.1, 5558.2, 5496.1, 5434.8, 5374.3, 5314.4, 5255.3, 5196.9, 5139.2, 5082.2, 5025.9, 4970.2, 4915.3, 4861.0, 4807.3, 4754.4, 4702.0, 4650.3, 4599.2, 4548.7, 4534.1, 4604.4, 4593.6, 4543.8, 4494.7, 4446.2, 4398.2, 4350.8, 4304.0, 4257.7, 4212.0, 4166.8, 4122.2, 4078.1, 4034.5, 3991.5, 3948.9, 3906.9, 3865.4, 3824.3, 3783.8, 3743.7, 3704.1, 3665.0, 3626.3, 3588.1, 3550.4, 3513.0, 3476.2, 3439.7, 3403.7, 3368.1, 3332.9, 3298.2, 3263.8, 3229.8, 3196.0, 3162.5, 3129.4, 3096.6, 3064.3, 3032.3, 3000.6, 2969.4, 2938.5, 2908.0, 2877.8, 2847.9, 2818.4, 2789.3, 2760.5, 2732.0, 2703.8, 2676.0, 2648.5, 2621.2, 2594.2, 2567.5, 2541.2, 2515.1, 2489.3, 2463.9, 2438.7, 2413.8, 2389.2, 2364.8, 2340.7, 2317.0, 2293.4, 2270.2, 2247.2, 2224.4, 2201.9, 2179.7, 2157.7, 2135.8, 2114.1, 2092.7, 2071.6, 2050.7, 2030.0, 2009.5, 1989.3, 1969.3, 1949.5, 1929.9, 1910.6, 1891.4, 1872.5, 1853.8, 1835.3, 1817.0, 1798.9, 1780.9, 1763.2, 1745.7, 1728.4, 1711.3, 1694.3, 1677.6, 1661.0, 1644.6, 1628.4, 1612.3, 1596.5, 1580.8, 1565.2, 1549.9, 1534.7, 1519.7, 1504.8, 1490.1, 1475.6, 1461.2, 1447.0, 1432.9, 1419.0, 1405.2, 1391.6, 1378.1, 1364.8, 1351.6, 1338.5, 1325.6, 1312.9, 1300.2, 1287.7, 1275.4, 1263.1, 1251.0, 1239.1, 1227.2, 1215.5, 1203.9, 1192.4, 1181.1, 1169.9, 1158.2, 1146.5, 1134.9, 1123.4, 1112.0, 1100.7, 1089.6, 1078.6, 1067.7, 1056.8, 1046.2, 1035.1, 1024.2, 1013.4, 1002.7, 992.11, 981.66, 971.33, 961.11, 951.01, 941.03, 931.15, 921.39, 911.74, 902.19, 892.76, 883.42, 874.2, 865.07, 856.05, 847.13, 838.31, 829.59, 820.96, 812.44, 804.0, 795.66, 787.41, 779.26, 771.19, 763.22, 755.33, 747.53, 739.82, 732.19, 724.65, 717.19, 709.81, 702.52, 695.3, 688.17, 681.11, 674.13, 667.23, 660.4, 653.65, 646.97, 640.36, 633.82, 628.2, 1743.8, 1716.6, 1690.0, 1663.7, 1637.9, 1612.6, 1587.6, 1563.1, 1538.0, 1522.5, 2198.2, 2189.3, 2156.5, 2125.5, 2095.1, 2065.2, 2036.0, 2007.3, 1979.2, 1951.6, 1924.6, 1898.1, 1872.0, 1846.5, 1821.4, 1796.8, 1772.6, 1748.8, 1725.4, 1702.5, 1679.9, 1657.6, 1635.8, 1614.3, 1593.1, 1572.3, 1551.8, 1531.6, 1511.7, 1492.1, 1472.8, 1453.8, 1435.0, 1433.5, 1681.9, 1672.0, 1649.9, 1628.0, 1606.5, 1585.2, 1564.3, 1543.6, 1523.3, 1503.2, 1483.4, 1464.7, 1446.2, 1427.8, 1409.4, 1391.3, 1373.4, 1355.8, 1338.5, 1321.4, 1304.6, 1288.0, 1271.6, 1255.3, 1239.3, 1223.5, 1207.9, 1192.5, 1177.3, 1162.4, 1147.6, 1133.1, 1118.7, 1112.1, 1184.2, 1183.9, 1168.7, 1153.5, 1138.4, 1123.6, 1108.9, 1094.5, 1080.3, 1066.2, 1052.4, 1039.0, 1026.0, 1013.2, 1000.5, 988.09, 983.98, 1018.9, 1017.1, 1006.5, 994.4, 982.43, 970.63, 958.97, 947.25, 935.69, 924.28, 913.03, 901.92, 890.94, 880.1, 869.4, 858.83, 848.41, 838.12, 827.97, 817.95, 808.05, 798.29, 788.65, 779.14, 769.74, 760.47, 751.32, 742.28, 733.36, 724.55, 715.85, 707.27, 698.79, 690.42, 682.15, 673.98, 665.92, 657.96, 650.1, 642.25, 634.44, 626.74, 619.12, 611.6, 604.18, 596.84, 589.6, 582.44, 575.37, 568.39, 561.5, 554.69, 547.95, 541.17, 534.46, 527.83, 521.29, 514.83, 508.45, 502.16, 495.94, 489.78, 483.64, 477.59, 471.61, 465.72, 459.89, 454.15, 448.47, 442.88, 437.35, 431.89, 426.51, 421.2, 415.95, 410.77, 405.66, 400.62, 395.64, 390.73, 385.88, 381.09, 376.37, 371.71, 367.11, 362.57, 358.09, 353.67, 349.3, 344.99, 340.74, 336.55, 332.41, 328.29, 324.2, 320.18, 316.2, 312.28, 308.4, 304.58, 300.81, 297.09, 293.42, 289.79, 286.21, 282.68, 279.2, 275.76, 272.37, 269.02, 265.71, 262.45, 259.23, 256.05, 252.92, 249.82, 246.77, 243.75, 240.78, 237.84, 234.94, 232.08, 229.26, 226.48, 223.73, 221.01, 218.31, 215.64, 213.01, 210.42, 207.86, 180.67, 151.14, 126.6, 106.13, 89.098, 74.904, 62.865, 53.584, 52.817, 51.508, 50.973, 127.53, 122.65, 112.64, 93.939, 86.191, 82.682, 81.779, 113.61, 110.61, 109.14, 104.82, 103.7, 118.13, 113.79, 107.71, 90.775, 76.447, 64.39, 54.221, 45.678, 38.26, 31.974, 26.702, 22.323, 18.631, 15.517, 12.933, 10.788, 9.005, 7.5226, 6.289, 5.2614, 4.4049, 3.6839, 3.0823, 2.5802, 2.1491, 1.7791, 1.4738, 1.3435, 1.2874, 1.2729, 5.8258, 5.6994, 5.6102, 4.8053, 4.047, 3.4038, 2.8618, 2.4058, 2.0191, 1.6945, 1.4221, 1.1936, 1.0019, 0.84108, 0.70627, 0.59314, 0.49819, 0.41849, 0.35157, 0.29539, 0.24821, 0.20858, 0.1753, 0.14734, 0.12385, 0.0],
                    'energies (keV)': [0.007161505, 0.007268393, 0.01036116, 0.01051975, 0.01056204, 0.01062547, 0.01069, 0.01078406, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02150088, 0.02182997, 0.02191773, 0.02204937, 0.02227063, 0.02237846, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04403377, 0.04421079, 0.04447632, 0.04514014, 0.04639671, 0.04771733, 0.04844769, 0.04864246, 0.04893461, 0.04959809, 0.04966497, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1164403, 0.1180797, 0.1182225, 0.1186978, 0.1194107, 0.1211929, 0.1262272, 0.1349368, 0.1442475, 0.1487358, 0.1510123, 0.1516194, 0.1525301, 0.1542005, 0.1548066, 0.1648404, 0.1762144, 0.1883732, 0.1968143, 0.1998268, 0.2006301, 0.2013709, 0.2018351, 0.2048475, 0.2083358, 0.2115247, 0.212375, 0.2136505, 0.2152655, 0.2168393, 0.2185326, 0.2194112, 0.2207289, 0.2240234, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53662464, 0.53737536, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56620227, 0.56639779, 0.56699778, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76674817, 0.76780567, 0.76925185, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92741143, 0.92802924, 0.93058861, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0956507, 1.0983493, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8915873, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.0205816, 3.0224186, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5337899, 3.5422103, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1532189, 4.1643407, 4.1647809, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4729462, 4.4878381, 4.4910535, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.32701, 14.40688, 14.5463, 14.60478, 14.6925, 14.91179, 15.40095, 16.46362, 16.99036, 17.25041, 17.31976, 17.42378, 17.59961, 17.68802, 17.95875, 18.03095, 18.13924, 18.40998, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 96.43592, 97.91198, 98.3056, 98.89602, 99.75239, 100.3721, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Rh': {'mass_absorption_coefficient (cm2/g)': [183820.0, 182600.0, 180820.0, 178480.0, 175550.0, 172040.0, 167970.0, 163370.0, 158280.0, 152760.0, 146870.0, 140670.0, 134240.0, 127650.0, 120970.0, 114270.0, 107620.0, 101060.0, 94666.0, 88465.0, 82495.0, 76786.0, 71357.0, 70436.0, 68835.0, 68416.0, 114820.0, 109170.0, 103840.0, 84209.0, 70124.0, 59751.0, 51656.0, 45072.0, 39564.0, 34870.0, 34660.0, 33693.0, 33443.0, 33941.0, 33058.0, 31715.0, 28242.0, 25205.0, 22532.0, 20173.0, 18085.0, 16234.0, 14589.0, 13126.0, 11821.0, 10656.0, 9612.8, 8677.9, 7837.6, 7079.5, 6394.4, 5774.2, 5212.0, 4701.8, 4238.5, 4230.9, 4131.7, 4105.8, 7982.5, 8053.2, 8109.8, 10891.0, 11327.0, 11657.0, 14325.0, 17121.0, 19132.0, 20099.0, 20039.0, 19151.0, 18880.0, 18566.0, 18479.0, 20753.0, 20382.0, 20155.0, 20057.0, 19749.0, 19640.0, 20464.0, 20039.0, 19143.0, 17126.0, 15682.0, 15236.0, 15139.0, 15120.0, 15606.0, 15171.0, 13888.0, 12138.0, 10570.0, 9183.4, 7961.7, 6884.3, 5947.1, 5099.7, 4365.9, 3733.7, 3166.1, 2683.5, 2278.2, 1937.1, 1649.9, 1407.6, 1202.9, 1025.3, 870.81, 740.49, 630.32, 536.61, 457.36, 443.04, 427.3, 423.2, 1466.2, 1415.2, 1394.2, 1370.7, 1344.6, 1331.8, 1809.8, 1744.7, 1602.4, 1572.4, 1511.1, 1495.2, 1694.5, 1632.0, 1553.1, 1308.5, 1101.0, 925.65, 777.95, 653.82, 549.76, 462.46, 388.9, 325.69, 272.57, 227.95, 190.81, 159.88, 133.76, 111.01, 92.148, 76.564, 63.677, 52.979, 44.041, 36.537, 30.246, 25.013, 20.705, 17.154, 14.225, 11.807, 10.082, 9.8071, 9.666, 9.5591, 63.274, 60.708, 54.861, 46.131, 38.694, 32.375, 26.979, 22.478, 18.731, 15.61, 13.01, 10.845, 9.011, 7.4593, 6.1754, 5.1129, 4.2335, 3.5054, 2.9024, 2.4022, 1.9853, 1.636, 1.3482, 1.1111, 0.91456, 0.75268, 0.61949, 0.50989, 0.41971, 0.34549, 0.28441, 0.23414, 0.19276, 0.15871, 0.13067, 0.10759, 0.088596, 0.072955, 0.060078, 0.049476, 0.040746, 0.033557, 0.027638, 0.022764, 0.01875, 0.015444, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.046942, 0.0476605, 0.0478521, 0.0481395, 0.048858, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.07938, 0.080595, 0.080919, 0.081405, 0.08262, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.30086, 0.305466, 0.306693, 0.308535, 0.3101415, 0.3113883, 0.3132585, 0.317934, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.486276, 0.493719, 0.4957038, 0.498681, 0.506124, 0.51058, 0.5124891, 0.518395, 0.520479, 0.523605, 0.53142, 0.5478508, 0.5856525, 0.614558, 0.6239645, 0.6260625, 0.6264729, 0.6302355, 0.639642, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 2.943724, 2.988781, 3.000796, 3.018819, 3.063876, 3.083178, 3.10515, 3.13037, 3.142954, 3.161831, 3.209022, 3.319406, 3.343662, 3.394841, 3.408488, 3.42896, 3.480138, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.7555, 22.98338, 23.1038, 23.19668, 23.336, 23.6843, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Be': {'mass_absorption_coefficient (cm2/g)': [53699.0, 55921.0, 92803.0, 100900.0, 106530.0, 109620.0, 110340.0, 108950.0, 105810.0, 101320.0, 95856.0, 89757.0, 83316.0, 76767.0, 70294.0, 64030.0, 58066.0, 52462.0, 47249.0, 42439.0, 38024.0, 33983.0, 30305.0, 26970.0, 23959.0, 21247.0, 18811.0, 16628.0, 14676.0, 12933.0, 11381.0, 9999.1, 8772.3, 7684.7, 6722.0, 5871.5, 5121.4, 4605.1, 4461.0, 4425.0, 170490.0, 165250.0, 151250.0, 131350.0, 113670.0, 98012.0, 84219.0, 72122.0, 61572.0, 52422.0, 44519.0, 37718.0, 31887.0, 26902.0, 22654.0, 19042.0, 15980.0, 13389.0, 11202.0, 9358.5, 7808.2, 6506.5, 5415.2, 4500.8, 3735.9, 3097.1, 2564.7, 2121.6, 1753.5, 1448.1, 1194.9, 985.37, 812.1, 668.96, 550.81, 450.31, 368.1, 300.9, 245.96, 201.06, 164.35, 134.35, 109.82, 89.769, 73.38, 59.983, 48.71, 39.548, 32.11, 26.07, 21.167, 17.124, 13.806, 11.132, 8.9752, 7.2353, 5.8325, 4.7018, 3.7902, 3.0554, 2.463, 1.9855, 1.6006, 1.2903, 1.0401, 0.83845, 0.6759, 0.54417, 0.43616, 0.34958, 0.28019, 0.22457, 0.18, 0.14427, 0.11563, 0.092679, 0.074282, 0.059538, 0.04772, 0.038248, 0.030656, 0.024571, 0.019694, 0.015785, 0.012629, 0.010099, 0.0080753, 0.0064573, 0.0051635, 0.0041289, 0.0033017, 0.0026401, 0.0021112, 0.0016887, 0.0013522, 0.0010827, 0.00086693, 0.00069417, 0.00055584, 0.00044507, 0.00035638, 0.00028536, 0.00022849, 0.00018296, 0.0001465, 0.00011731, 9.3931e-05, 7.5214e-05, 6.0226e-05, 4.8225e-05, 3.8615e-05, 3.092e-05, 2.4759e-05, 1.9825e-05, 1.5875e-05, 1.2712e-05, 1.0179e-05, 8.1504e-06, 6.5264e-06, 5.2259e-06, 4.1846e-06, 3.3508e-06, 2.6832e-06, 2.1485e-06, 1.7204e-06, 1.3776e-06, 0.0],
                    'energies (keV)': [0.0084621, 0.0085884, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.10878, 0.1104581, 0.110889, 0.111555, 0.11322, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ba': {'mass_absorption_coefficient (cm2/g)': [183230.0, 174420.0, 173200.0, 138730.0, 129950.0, 123370.0, 121670.0, 201640.0, 191750.0, 187110.0, 148210.0, 116210.0, 90144.0, 69458.0, 53349.0, 40970.0, 31539.0, 24390.0, 18982.0, 14889.0, 11783.0, 9416.2, 9146.9, 8707.0, 8595.1, 8572.5, 8192.7, 7764.7, 6418.3, 5392.1, 4602.9, 3990.4, 3509.0, 3125.1, 2814.5, 2557.9, 2341.9, 2155.8, 1992.4, 1901.4, 1868.9, 1860.5, 199610.0, 190310.0, 153370.0, 143110.0, 132750.0, 240840.0, 182760.0, 116660.0, 35704.0, 14504.0, 7826.1, 5216.3, 4024.6, 3427.4, 3123.7, 2988.4, 2962.9, 2968.5, 2970.7, 4439.0, 4446.5, 4466.6, 4468.7, 4482.8, 4487.6, 4986.3, 5005.0, 5047.8, 5170.1, 5311.5, 5454.5, 5470.6, 5501.0, 5508.8, 6116.2, 6139.4, 6166.8, 6240.4, 6263.9, 6226.6, 6124.3, 5957.2, 5724.7, 5434.8, 5102.8, 4744.2, 4373.2, 4001.6, 3639.1, 3292.4, 2966.2, 2663.2, 2384.1, 2382.7, 2322.5, 2305.6, 10082.0, 9846.7, 9749.4, 14829.0, 14652.0, 14109.0, 13866.0, 11703.0, 9942.0, 8486.5, 7679.4, 7403.4, 7332.2, 8401.6, 8099.5, 7557.3, 7292.2, 7224.4, 7613.0, 7596.6, 7335.8, 6530.3, 6017.4, 5825.4, 5776.0, 5974.5, 5926.5, 5792.7, 5117.3, 4393.3, 3762.6, 3219.5, 2747.6, 2344.9, 2002.8, 1709.2, 1457.4, 1243.5, 1061.8, 907.57, 770.18, 645.56, 541.05, 454.08, 381.79, 321.61, 271.27, 227.96, 206.61, 198.53, 196.45, 615.13, 606.95, 586.83, 534.85, 511.99, 506.18, 693.98, 690.66, 664.27, 621.32, 595.35, 588.82, 670.59, 661.33, 645.67, 559.24, 473.75, 399.81, 336.51, 283.03, 237.74, 198.55, 165.97, 138.44, 115.28, 95.763, 79.553, 66.143, 55.031, 45.823, 38.19, 31.858, 26.599, 22.229, 18.582, 15.501, 12.917, 10.647, 8.7545, 7.2043, 5.9336, 4.8911, 4.881, 4.6715, 4.6177, 27.944, 26.889, 25.133, 21.084, 17.67, 14.801, 12.367, 10.323, 8.6151, 7.1886, 5.9975, 5.0034, 4.1703, 3.4635, 2.8667, 2.373, 1.9645, 1.6264, 1.3466, 1.1151, 0.92341, 0.76474, 0.63338, 0.52462, 0.43491, 0.36068, 0.29914, 0.24811, 0.2058, 0.17071, 0.14162, 0.11749, 0.097474, 0.080874, 0.067104, 0.055682, 0.046206, 0.038344, 0.031822, 0.0],
                    'energies (keV)': [0.014673, 0.014892, 0.01492335, 0.01595306, 0.016268, 0.016517, 0.0165834, 0.016683, 0.016932, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.038318, 0.0389045, 0.0390609, 0.0392955, 0.039882, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.088102, 0.0894505, 0.0898101, 0.09041995, 0.09065, 0.091698, 0.0920375, 0.0924075, 0.0929625, 0.09435, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1788015, 0.1795203, 0.1805985, 0.183294, 0.187964, 0.1883732, 0.190841, 0.1916082, 0.192759, 0.195636, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.24794, 0.251735, 0.252747, 0.254265, 0.25806, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.765086, 0.7767965, 0.780178, 0.7846035, 0.7921195, 0.7953039, 0.796314, 0.8000805, 0.812022, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.040956, 1.056889, 1.061138, 1.067676, 1.083444, 1.113966, 1.131017, 1.135563, 1.141345, 1.142384, 1.159434, 1.220098, 1.266944, 1.286336, 1.291507, 1.299264, 1.304285, 1.318656, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.14206, 5.220765, 5.241753, 5.273235, 5.295467, 5.35194, 5.511128, 5.595482, 5.617976, 5.651718, 5.660855, 5.736072, 5.869024, 5.958856, 5.982811, 6.018744, 6.051453, 6.108576, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 36.69179, 37.2534, 37.40316, 37.6278, 38.18941, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Bi': {'mass_absorption_coefficient (cm2/g)': [110470.0, 107560.0, 42995.0, 38053.0, 33528.0, 29394.0, 25635.0, 24872.0, 24662.0, 37244.0, 35711.0, 33031.0, 27337.0, 22546.0, 18544.0, 15234.0, 12509.0, 10271.0, 8432.6, 8323.9, 7958.4, 7864.5, 14012.0, 14591.0, 15744.0, 17130.0, 18420.0, 18801.0, 22530.0, 24712.0, 25760.0, 39804.0, 59723.0, 83345.0, 107230.0, 127320.0, 140210.0, 144190.0, 139480.0, 127900.0, 112000.0, 94344.0, 76968.0, 61207.0, 47726.0, 36688.0, 27942.0, 21176.0, 16033.0, 15652.0, 14695.0, 14453.0, 18277.0, 17201.0, 15792.0, 12072.0, 9342.4, 8202.5, 7771.2, 7662.3, 9629.4, 9436.1, 9153.9, 7559.3, 6129.2, 5020.3, 4160.9, 4157.2, 4024.7, 3990.4, 3948.0, 4220.8, 4197.1, 4173.7, 4286.3, 4266.0, 4242.1, 4214.6, 4420.3, 4413.7, 4357.3, 4350.4, 4250.3, 4445.6, 4926.1, 5675.8, 6658.6, 7813.8, 9058.6, 10297.0, 11430.0, 12372.0, 13056.0, 13444.0, 13526.0, 13318.0, 13156.0, 13048.0, 13018.0, 13531.0, 13434.0, 13429.0, 13337.0, 13215.0, 13182.0, 13477.0, 13358.0, 13241.0, 12848.0, 12798.0, 12747.0, 12696.0, 12644.0, 12591.0, 12537.0, 12483.0, 12428.0, 12373.0, 12316.0, 12259.0, 12202.0, 12144.0, 12085.0, 12026.0, 11966.0, 11906.0, 11845.0, 11783.0, 11722.0, 11659.0, 11597.0, 11534.0, 11470.0, 11406.0, 11342.0, 11278.0, 11213.0, 11148.0, 11082.0, 11017.0, 10951.0, 10885.0, 10818.0, 10752.0, 10685.0, 10618.0, 10551.0, 10484.0, 10417.0, 10350.0, 10283.0, 10215.0, 10148.0, 10081.0, 10013.0, 9945.8, 9878.3, 9810.9, 9743.4, 9676.0, 9608.5, 9541.2, 9473.8, 9406.5, 9339.3, 9272.1, 9205.1, 9138.2, 9071.4, 9004.7, 8998.9, 9528.8, 9499.0, 9430.6, 9362.4, 9294.5, 9226.8, 9159.3, 9092.1, 9025.2, 8958.6, 8892.3, 8826.3, 8760.6, 8695.3, 8630.3, 8565.7, 8501.5, 8437.6, 8374.1, 8309.7, 8243.8, 8178.2, 8113.0, 8048.1, 7983.5, 7919.4, 7855.5, 7792.1, 7729.1, 7666.4, 7602.4, 7538.7, 7475.3, 7412.3, 7349.7, 7332.2, 7398.2, 7388.2, 7326.3, 7264.8, 7203.7, 7143.0, 7082.7, 7022.8, 6963.4, 6904.3, 6845.7, 6787.5, 6729.7, 6672.3, 6615.4, 6558.9, 6502.8, 6447.2, 6392.0, 6337.2, 6282.9, 6229.0, 6175.5, 6122.5, 6069.9, 6017.8, 5966.1, 5914.8, 5864.0, 5813.6, 5763.7, 5719.0, 5714.2, 5806.9, 5780.7, 5731.7, 5683.1, 5635.0, 5587.4, 5540.1, 5493.3, 5447.0, 5401.0, 5355.6, 5310.5, 5265.9, 5221.3, 5164.0, 5107.5, 5051.6, 4996.4, 4941.8, 4887.9, 4834.7, 4782.0, 4730.0, 4678.6, 4627.9, 4577.7, 4528.1, 4479.2, 4430.8, 4383.1, 4335.8, 4289.2, 4243.1, 4197.6, 4152.6, 4108.2, 4064.3, 4020.9, 3978.1, 3935.7, 3893.9, 3852.4, 3811.1, 3770.4, 3730.1, 3690.4, 3651.1, 3612.2, 3573.8, 3535.9, 3498.4, 3461.4, 3424.8, 3388.6, 3352.9, 3317.6, 3282.7, 3248.2, 3214.1, 3180.4, 3147.1, 3114.2, 3081.7, 3049.5, 3017.8, 2986.4, 2955.4, 2924.7, 2894.4, 2864.4, 2834.8, 2805.6, 2776.6, 2748.1, 2719.8, 2691.8, 2664.1, 2636.6, 2609.4, 2582.6, 2556.1, 2529.9, 2503.9, 2478.3, 2453.0, 2427.9, 2403.2, 2378.7, 2354.5, 2330.6, 2306.9, 2283.6, 2260.5, 2237.6, 2215.0, 2192.7, 2170.6, 2148.8, 2127.2, 2105.8, 2084.7, 2063.9, 2043.2, 2022.8, 2002.7, 1982.7, 1963.0, 1943.4, 1924.0, 1904.9, 1886.0, 1867.3, 1848.8, 1830.5, 1812.4, 1794.5, 1776.8, 1759.3, 1742.0, 1724.9, 1708.0, 1691.3, 1674.7, 1658.3, 1642.2, 1626.1, 1610.2, 1593.8, 1577.2, 1560.8, 1544.6, 1528.6, 1512.7, 1497.1, 1481.6, 1466.3, 1451.2, 1436.1, 1420.6, 1405.3, 1390.1, 1375.2, 1360.4, 1345.8, 1331.4, 1317.1, 1303.0, 1289.1, 1275.3, 1261.7, 1248.2, 1234.9, 1221.7, 1208.7, 1195.9, 1183.2, 1170.6, 1158.2, 1145.9, 1133.8, 1121.8, 1109.9, 1098.2, 1086.6, 1075.1, 1063.8, 1052.6, 1041.5, 1030.6, 1019.8, 1009.1, 998.49, 988.01, 977.66, 967.42, 957.3, 947.29, 937.39, 927.61, 917.94, 908.37, 898.91, 889.56, 880.31, 871.17, 862.13, 853.19, 844.35, 835.61, 826.97, 818.42, 809.97, 801.61, 793.35, 785.18, 777.09, 769.1, 761.2, 753.38, 745.66, 738.01, 730.45, 722.98, 716.17, 2035.0, 2034.2, 2009.8, 1984.9, 1960.3, 1936.0, 1912.1, 1888.4, 1865.1, 1842.0, 1838.8, 2672.9, 2647.8, 2614.3, 2581.2, 2548.5, 2516.3, 2484.4, 2452.9, 2421.9, 2391.3, 2361.0, 2331.2, 2301.7, 2272.6, 2243.9, 2215.6, 2187.6, 2160.0, 2132.8, 2105.9, 2079.2, 2052.9, 2026.9, 2000.3, 1973.7, 1947.5, 1921.6, 1896.0, 1870.8, 1845.9, 1821.3, 1797.1, 1773.2, 1749.6, 1737.5, 2031.8, 2030.4, 2002.9, 1975.7, 1948.9, 1922.4, 1896.3, 1870.5, 1845.1, 1820.0, 1795.3, 1771.6, 1748.4, 1725.5, 1702.9, 1680.7, 1658.8, 1637.3, 1616.1, 1595.2, 1574.6, 1554.2, 1534.0, 1514.2, 1494.6, 1475.3, 1456.4, 1437.7, 1419.2, 1401.1, 1383.2, 1369.0, 1365.5, 1456.6, 1444.8, 1425.9, 1407.2, 1388.7, 1370.6, 1352.7, 1335.0, 1317.6, 1300.5, 1283.7, 1267.6, 1251.8, 1236.2, 1220.8, 1205.7, 1199.0, 1243.5, 1238.7, 1228.5, 1213.8, 1199.2, 1184.9, 1170.8, 1156.8, 1142.9, 1129.1, 1115.4, 1102.0, 1088.6, 1075.5, 1062.6, 1049.8, 1037.2, 1024.7, 1012.4, 1000.3, 988.33, 976.51, 964.85, 953.33, 941.96, 930.74, 919.66, 908.72, 897.91, 887.24, 876.71, 866.3, 856.03, 845.88, 835.86, 825.96, 816.18, 806.52, 796.93, 787.34, 777.87, 768.52, 759.27, 750.14, 741.12, 732.2, 723.4, 714.7, 706.1, 697.61, 689.23, 680.94, 672.74, 664.41, 656.17, 648.02, 639.98, 632.04, 624.2, 616.47, 608.83, 601.16, 593.58, 586.09, 578.7, 571.4, 564.2, 557.1, 550.09, 543.17, 536.34, 529.6, 522.95, 516.39, 509.91, 503.52, 497.21, 490.98, 484.84, 478.77, 472.79, 466.89, 461.06, 455.31, 449.64, 444.04, 438.51, 433.06, 427.68, 422.37, 417.13, 411.96, 406.86, 401.83, 396.84, 391.87, 386.96, 382.12, 377.34, 372.63, 367.97, 363.38, 358.85, 354.38, 349.97, 345.62, 341.32, 337.09, 332.9, 328.78, 324.7, 320.68, 316.72, 312.8, 308.94, 305.13, 301.37, 297.66, 294.0, 290.38, 286.81, 283.29, 279.82, 276.39, 273.01, 269.65, 266.32, 263.04, 259.81, 256.61, 253.46, 250.35, 247.28, 244.25, 241.25, 238.3, 235.39, 232.51, 229.67, 226.87, 224.1, 221.36, 218.65, 215.98, 213.34, 210.74, 208.17, 205.62, 203.11, 200.62, 198.17, 195.74, 193.35, 190.99, 165.91, 138.79, 116.3, 97.614, 81.833, 68.593, 61.391, 58.995, 58.379, 148.98, 148.72, 142.89, 124.25, 103.51, 99.364, 98.278, 136.14, 130.85, 130.09, 124.88, 123.54, 140.95, 140.82, 135.63, 118.95, 100.1, 84.236, 70.854, 59.586, 50.137, 42.212, 35.283, 29.436, 24.568, 20.453, 17.025, 14.182, 11.823, 9.8638, 8.2354, 6.8811, 5.7538, 4.8133, 4.0207, 3.3618, 2.8085, 2.3398, 1.9453, 1.6086, 1.5363, 1.4714, 1.4548, 6.8261, 6.573, 6.3986, 5.3905, 4.5349, 3.8102, 3.2001, 2.6861, 2.2512, 1.8866, 1.5811, 1.3251, 1.1106, 0.93081, 0.78, 0.65369, 0.54789, 0.45927, 0.38502, 0.3228, 0.27066, 0.22697, 0.19034, 0.15964, 0.1339, 0.11232, 0.0],
                    'energies (keV)': [0.006200758, 0.006293306, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01416222, 0.01421916, 0.01430456, 0.01451806, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.023912, 0.024278, 0.0243756, 0.024522, 0.024888, 0.02545001, 0.02597, 0.0263675, 0.0264735, 0.0266325, 0.02703, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.090944, 0.092336, 0.0927072, 0.093264, 0.094656, 0.09665893, 0.1033284, 0.1104581, 0.114464, 0.116216, 0.1166832, 0.117384, 0.1180797, 0.119136, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.154252, 0.156114, 0.156613, 0.1572426, 0.158187, 0.158662, 0.1591407, 0.1600965, 0.160548, 0.1610905, 0.1617381, 0.162486, 0.1627095, 0.1648404, 0.165138, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4312, 0.4378, 0.43956, 0.4422, 0.4484657, 0.4488, 0.454328, 0.461282, 0.4631364, 0.465918, 0.472872, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.67809211, 0.67970789, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80418063, 0.80641936, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93687713, 0.93733274, 0.93952286, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5788933, 2.5799086, 2.5803069, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6868259, 2.6883739, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1735006, 3.1802992, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6909034, 3.6945434, 3.7016966, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 3.9904219, 4.0014533, 4.007778, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.15023, 13.35151, 13.40518, 13.47697, 13.48569, 13.68697, 14.40688, 15.40095, 15.63254, 15.69539, 15.78966, 16.02532, 16.05975, 16.30556, 16.37111, 16.46362, 16.46944, 16.71525, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 88.71538, 90.07327, 90.43538, 90.97853, 92.33642, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Br': {'mass_absorption_coefficient (cm2/g)': [2138.5, 2162.8, 2258.3, 2326.6, 3809.4, 3837.9, 4286.1, 5546.1, 9006.6, 13592.0, 19048.0, 25012.0, 31029.0, 36629.0, 41409.0, 45083.0, 47502.0, 48649.0, 48610.0, 47544.0, 45645.0, 45324.0, 44778.0, 44629.0, 46760.0, 46235.0, 46160.0, 45592.0, 45443.0, 46188.0, 45630.0, 43969.0, 41123.0, 38101.0, 35007.0, 34005.0, 33302.0, 33117.0, 34255.0, 33567.0, 33331.0, 30295.0, 27361.0, 24559.0, 21925.0, 19479.0, 17233.0, 15188.0, 13342.0, 11686.0, 10208.0, 8896.8, 7737.6, 6717.0, 5821.2, 5037.3, 4352.5, 3755.2, 3236.0, 3030.3, 2996.6, 2963.3, 2930.3, 2897.7, 2865.4, 2833.5, 2802.0, 2770.8, 2739.9, 2709.4, 2679.2, 2649.3, 2619.8, 2590.6, 2561.7, 2533.2, 2504.9, 2477.0, 2449.4, 2422.1, 2395.1, 2365.2, 2335.3, 2305.8, 2276.7, 2248.0, 2219.4, 2191.1, 2163.2, 2135.7, 2108.6, 2081.8, 2055.3, 2029.3, 2003.5, 1978.1, 1953.0, 1928.3, 1903.9, 1879.8, 1856.0, 1832.5, 1809.4, 1786.5, 1764.0, 1741.7, 1719.7, 1698.1, 1676.7, 1655.6, 1634.7, 1614.2, 1593.9, 1573.8, 1554.1, 1534.6, 1515.3, 1496.3, 1477.5, 1459.0, 1440.8, 1422.7, 1404.9, 1387.4, 1370.0, 1352.9, 1336.0, 1319.3, 1302.9, 1286.7, 1270.6, 1254.8, 1239.2, 1223.4, 1207.8, 1192.4, 1177.0, 1161.7, 1146.7, 1131.9, 1117.3, 1102.8, 1088.6, 1074.6, 1060.7, 1047.1, 1033.6, 1020.4, 1007.3, 994.34, 981.6, 969.03, 956.63, 944.4, 932.33, 920.43, 908.69, 897.11, 885.69, 874.42, 863.3, 852.33, 841.51, 830.84, 820.31, 809.92, 799.67, 789.56, 779.98, 3891.6, 3891.4, 3841.3, 3791.7, 3742.7, 3694.4, 3646.7, 3607.3, 5097.4, 5089.6, 5024.0, 4959.4, 4895.5, 4832.5, 4770.3, 4709.0, 4648.4, 4588.6, 4529.6, 4471.3, 4413.8, 4357.0, 4301.0, 4245.7, 4191.2, 4137.3, 4084.1, 4031.6, 3979.8, 3928.7, 3878.2, 3838.8, 4397.6, 4390.4, 4342.8, 4288.7, 4235.3, 4182.5, 4130.5, 4079.0, 4028.3, 3978.1, 3928.7, 3880.0, 3832.4, 3785.4, 3739.0, 3693.3, 3648.1, 3603.6, 3559.6, 3516.2, 3473.4, 3431.1, 3389.4, 3348.2, 3307.6, 3267.5, 3227.7, 3188.1, 3149.0, 3110.5, 3072.4, 3034.8, 2997.5, 2960.6, 2924.1, 2888.1, 2852.6, 2817.4, 2782.8, 2748.5, 2714.7, 2681.3, 2648.3, 2615.7, 2583.6, 2551.8, 2520.4, 2489.4, 2458.8, 2428.6, 2398.7, 2369.2, 2340.0, 2311.3, 2282.7, 2254.4, 2226.4, 2198.7, 2171.4, 2144.4, 2117.7, 2091.4, 2065.4, 2039.7, 2014.3, 1989.3, 1964.5, 1940.1, 1916.0, 1892.1, 1868.6, 1845.3, 1822.3, 1799.6, 1777.2, 1755.1, 1733.3, 1711.7, 1690.4, 1669.3, 1648.5, 1628.0, 1607.7, 1587.7, 1568.0, 1548.5, 1529.2, 1510.1, 1491.4, 1472.8, 1454.5, 1436.4, 1418.5, 1400.9, 1383.4, 1366.2, 1349.3, 1332.5, 1315.9, 1299.6, 1283.4, 1267.5, 1251.8, 1236.2, 1220.9, 1205.8, 1190.4, 1175.0, 1159.8, 1144.8, 1130.0, 1115.3, 1100.9, 1086.3, 1071.8, 1057.6, 1043.6, 1029.7, 1016.0, 1002.4, 988.9, 975.61, 962.51, 949.59, 936.85, 924.28, 911.89, 899.67, 887.62, 875.74, 864.02, 852.47, 841.02, 829.73, 818.59, 807.61, 796.79, 786.11, 775.58, 765.2, 754.93, 744.63, 734.46, 724.44, 714.56, 704.82, 695.22, 685.74, 676.4, 667.19, 658.11, 649.16, 640.33, 631.62, 623.04, 614.57, 606.23, 597.99, 589.88, 581.87, 573.98, 566.2, 558.52, 550.96, 543.49, 536.14, 528.88, 521.72, 514.67, 507.71, 500.85, 494.08, 487.41, 480.82, 474.34, 467.94, 461.62, 455.4, 449.26, 443.21, 437.24, 431.36, 425.55, 419.83, 414.18, 408.61, 403.12, 397.71, 392.36, 387.1, 381.9, 376.78, 371.73, 366.75, 361.83, 356.99, 352.21, 347.49, 342.84, 338.26, 333.74, 329.27, 324.86, 320.51, 316.22, 311.98, 307.81, 303.7, 299.64, 295.63, 291.68, 287.79, 283.95, 280.16, 276.42, 272.74, 269.1, 265.52, 261.98, 258.49, 255.05, 251.66, 248.31, 245.01, 241.76, 238.55, 235.38, 232.25, 229.17, 226.13, 223.13, 220.18, 217.26, 214.38, 211.54, 208.74, 205.98, 203.26, 200.57, 197.92, 195.31, 192.73, 190.18, 187.67, 185.2, 182.76, 180.35, 177.97, 175.63, 173.31, 171.03, 168.78, 166.56, 164.38, 162.22, 160.08, 157.98, 155.91, 153.86, 151.85, 149.86, 147.89, 145.95, 144.04, 126.32, 105.34, 87.827, 73.078, 60.665, 49.821, 40.956, 33.7, 27.757, 22.884, 20.027, 19.172, 18.952, 148.58, 146.45, 139.98, 121.84, 101.91, 85.828, 72.416, 60.601, 50.63, 42.244, 35.223, 29.365, 24.489, 20.294, 16.765, 13.851, 11.444, 9.4547, 7.8092, 6.4479, 5.3244, 4.3969, 3.6312, 2.999, 2.4766, 2.0331, 1.669, 1.3702, 1.125, 0.92273, 0.7551, 0.61795, 0.50573, 0.41391, 0.33877, 0.27728, 0.22696, 0.18578, 0.15207, 0.12449, 0.10191, 0.083427, 0.0683, 0.055917, 0.045781, 0.037483, 0.030691, 0.025129, 0.020576, 0.016849, 0.013797, 0.011298, 0.0092522, 0.007577, 0.0062052, 0.0],
                    'energies (keV)': [0.06923942, 0.069345, 0.0697495, 0.0700299, 0.07038, 0.0704505, 0.071502, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.17787, 0.1805925, 0.1813185, 0.1824075, 0.18513, 0.185514, 0.1883732, 0.1891107, 0.1902465, 0.193086, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.25137, 0.2552175, 0.2562435, 0.2577825, 0.26163, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5497311, 1.5500412, 1.550069, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5958196, 1.5961803, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7804852, 1.7823499, 1.7835146, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.20423, 13.40633, 13.46023, 13.47697, 13.54107, 13.74317, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'P': {'mass_absorption_coefficient (cm2/g)': [201910.0, 203980.0, 205360.0, 618080.0, 637190.0, 657870.0, 390540.0, 266220.0, 178300.0, 118750.0, 79430.0, 72633.0, 66423.0, 64882.0, 62678.0, 57530.0, 53820.0, 37199.0, 26450.0, 19559.0, 15262.0, 12752.0, 11484.0, 11050.0, 11132.0, 11479.0, 11904.0, 12270.0, 12503.0, 12575.0, 12496.0, 12288.0, 11980.0, 11603.0, 11189.0, 10764.0, 10342.0, 9930.7, 9532.5, 9148.6, 8777.3, 8415.3, 8058.9, 7704.4, 7349.3, 6991.7, 6631.2, 6268.2, 5781.0, 5582.5, 5467.8, 5437.6, 107530.0, 106230.0, 100820.0, 95065.0, 88257.0, 80809.0, 74867.0, 73090.0, 72637.0, 79834.0, 78054.0, 73050.0, 65334.0, 57988.0, 51119.0, 44799.0, 39056.0, 33895.0, 29302.0, 25245.0, 21686.0, 18580.0, 15883.0, 13549.0, 11538.0, 9809.1, 8326.4, 7056.2, 5971.2, 5046.9, 4261.4, 3595.2, 3030.9, 2553.6, 2150.9, 1811.7, 1502.3, 1246.7, 1035.6, 861.06, 716.69, 597.14, 498.03, 415.79, 347.48, 290.68, 243.41, 236.76, 227.42, 225.02, 2569.8, 2490.6, 2406.5, 2048.9, 1722.0, 1443.5, 1213.1, 1017.8, 851.56, 712.57, 595.97, 498.49, 416.34, 344.81, 285.58, 236.54, 195.93, 162.3, 134.45, 111.38, 92.268, 76.44, 63.33, 52.391, 42.962, 35.135, 28.735, 23.502, 19.222, 15.722, 12.86, 10.519, 8.6043, 7.0383, 5.7575, 4.7098, 3.8528, 3.1519, 2.5785, 2.1094, 1.7155, 1.3925, 1.1303, 0.91751, 0.74477, 0.60456, 0.49075, 0.39837, 0.32254, 0.26084, 0.21094, 0.17059, 0.13796, 0.11157, 0.090229, 0.072971, 0.059019, 0.047742, 0.038621, 0.031242, 0.025274, 0.020446, 0.01654, 0.013381, 0.010825, 0.0087573, 0.0070847, 0.0057316, 0.004637, 0.0037514, 0.003035, 0.0024555, 0.0019866, 0.0016073, 0.0013004, 0.0010521, 0.00085122, 0.0006887, 0.00055722, 0.00045084, 0.00036478, 0.00029514, 0.0],
                   'energies (keV)': [0.006353005, 0.006368374, 0.006378545, 0.006416855, 0.006463425, 0.006512629, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01417226, 0.01438918, 0.01444703, 0.0145338, 0.01475072, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.129556, 0.131539, 0.1320678, 0.132861, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.185514, 0.1883732, 0.1891107, 0.1902465, 0.193086, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.10259, 2.134772, 2.143354, 2.156227, 2.18841, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Os': {'mass_absorption_coefficient (cm2/g)': [20049.0, 19575.0, 16452.0, 16262.0, 16222.0, 48882.0, 47807.0, 59114.0, 67564.0, 77132.0, 87344.0, 97565.0, 107030.0, 114910.0, 120440.0, 123030.0, 122350.0, 118430.0, 111600.0, 102460.0, 91742.0, 80230.0, 68657.0, 57586.0, 47467.0, 38564.0, 30967.0, 24644.0, 19486.0, 17837.0, 16892.0, 16625.0, 36179.0, 35022.0, 34551.0, 38679.0, 38427.0, 38048.0, 36171.0, 30593.0, 24331.0, 19455.0, 19275.0, 18345.0, 18109.0, 25321.0, 24325.0, 22831.0, 19311.0, 16406.0, 14038.0, 12246.0, 11519.0, 11261.0, 11197.0, 11311.0, 11231.0, 11105.0, 10550.0, 10354.0, 10585.0, 11182.0, 12085.0, 13222.0, 14516.0, 15893.0, 17257.0, 18528.0, 19631.0, 20500.0, 21034.0, 21201.0, 21023.0, 20543.0, 19806.0, 19580.0, 19359.0, 19299.0, 19743.0, 19522.0, 19365.0, 19226.0, 18981.0, 18915.0, 19202.0, 18956.0, 18651.0, 17459.0, 16224.0, 14988.0, 13782.0, 12625.0, 11532.0, 11174.0, 10941.0, 10879.0, 11519.0, 11290.0, 11232.0, 10606.0, 10534.0, 10462.0, 10391.0, 10320.0, 10249.0, 10179.0, 10109.0, 10039.0, 9970.4, 9901.7, 9833.3, 9765.4, 9697.8, 9630.6, 9563.8, 9497.3, 9431.2, 9395.5, 9513.5, 9505.9, 9448.2, 9383.2, 9318.5, 9254.3, 9190.4, 9126.8, 9063.6, 9000.8, 8938.3, 8876.1, 8814.4, 8752.9, 8691.8, 8631.1, 8570.7, 8510.6, 8450.9, 8391.5, 8332.4, 8273.7, 8215.3, 8157.2, 8099.5, 8042.0, 7984.9, 7928.2, 7871.7, 7815.6, 7759.7, 7704.2, 7649.0, 7594.1, 7539.5, 7485.2, 7431.3, 7398.4, 7558.5, 7545.5, 7504.5, 7450.9, 7397.5, 7344.5, 7291.7, 7239.3, 7187.1, 7135.3, 7083.7, 7032.5, 6981.5, 6930.8, 6880.4, 6830.3, 6780.5, 6731.0, 6681.7, 6632.8, 6584.1, 6535.7, 6487.6, 6439.7, 6392.2, 6344.9, 6297.8, 6251.1, 6204.6, 6158.3, 6112.4, 6066.7, 6021.3, 5976.1, 5931.2, 5886.6, 5842.2, 5798.1, 5754.2, 5710.7, 5667.0, 5623.7, 5580.6, 5537.7, 5495.1, 5452.8, 5410.7, 5368.8, 5327.3, 5285.9, 5244.8, 5204.0, 5163.4, 5123.1, 5083.0, 5043.1, 5003.5, 4964.1, 4924.6, 4881.0, 4837.6, 4794.6, 4751.9, 4709.6, 4667.5, 4625.8, 4584.4, 4543.3, 4502.6, 4462.1, 4422.0, 4382.1, 4342.6, 4303.3, 4264.4, 4225.8, 4187.5, 4149.5, 4111.8, 4074.5, 4037.4, 4000.7, 3964.3, 3928.2, 3892.4, 3856.9, 3821.6, 3781.5, 3741.8, 3702.6, 3663.8, 3625.4, 3587.5, 3549.9, 3512.8, 3476.1, 3439.8, 3403.9, 3368.4, 3333.4, 3298.7, 3264.4, 3230.5, 3196.9, 3162.7, 3127.8, 3093.3, 3059.2, 3025.4, 2992.1, 2959.2, 2926.7, 2894.5, 2862.8, 2831.4, 2800.5, 2769.0, 2737.6, 2706.5, 2675.8, 2645.5, 2615.5, 2586.0, 2556.8, 2528.0, 2499.5, 2471.4, 2443.7, 2416.3, 2389.2, 2362.4, 2336.0, 2309.9, 2284.2, 2258.7, 2233.6, 2208.8, 2184.3, 2160.1, 2136.1, 2112.5, 2089.2, 2066.1, 2043.4, 2020.9, 1998.6, 1976.7, 1955.0, 1933.6, 1912.4, 1891.5, 1870.9, 1850.5, 1830.3, 1810.4, 1790.7, 1771.3, 1752.1, 1733.1, 1714.4, 1695.9, 1677.6, 1659.5, 1641.6, 1624.0, 1606.5, 1589.3, 1572.3, 1555.4, 1538.8, 1522.4, 1506.1, 1490.1, 1474.2, 1458.6, 1443.1, 1427.8, 1412.6, 1397.7, 1382.9, 1368.3, 1353.9, 1339.6, 1325.5, 1311.6, 1297.8, 1284.2, 1270.7, 1257.4, 1244.3, 1231.3, 1218.4, 1205.8, 1193.2, 1180.8, 1168.5, 1156.4, 1144.4, 1132.6, 1120.9, 1109.3, 1097.9, 1086.6, 1075.4, 1064.3, 1053.4, 1042.6, 1031.9, 1021.4, 1010.9, 1000.6, 990.39, 980.25, 970.05, 959.96, 949.99, 940.13, 930.38, 920.74, 911.21, 901.79, 893.72, 2879.3, 2877.8, 2843.5, 2809.5, 2776.0, 2742.9, 2710.2, 2677.9, 2648.1, 2646.0, 3909.3, 3866.7, 3820.0, 3773.9, 3728.3, 3683.3, 3638.8, 3594.9, 3551.6, 3508.7, 3466.4, 3424.6, 3383.4, 3342.6, 3302.3, 3262.5, 3223.2, 3184.3, 3145.9, 3107.9, 3070.4, 3033.4, 2996.8, 2960.7, 2925.1, 2889.8, 2855.0, 2820.6, 2786.7, 2753.2, 2720.0, 2687.3, 2655.0, 2623.1, 2591.6, 2560.4, 2529.6, 2499.3, 2469.3, 2468.0, 2879.0, 2858.5, 2823.7, 2789.3, 2755.3, 2721.8, 2688.7, 2656.0, 2623.3, 2590.7, 2558.6, 2528.1, 2498.1, 2468.5, 2439.3, 2410.3, 2381.5, 2353.1, 2325.0, 2297.4, 2270.1, 2243.2, 2216.6, 2190.3, 2164.4, 2138.9, 2124.3, 2258.7, 2255.0, 2231.4, 2204.6, 2178.0, 2151.8, 2125.9, 2100.3, 2075.1, 2050.1, 2025.5, 2001.7, 1978.8, 1956.3, 1934.1, 1912.1, 1889.2, 1866.0, 1843.2, 1842.0, 1904.4, 1901.4, 1878.6, 1856.1, 1833.8, 1811.8, 1790.0, 1768.6, 1747.3, 1726.4, 1705.6, 1684.9, 1664.5, 1644.3, 1624.4, 1604.7, 1585.2, 1566.0, 1547.0, 1528.2, 1509.6, 1491.3, 1473.2, 1455.3, 1437.6, 1420.1, 1402.8, 1385.8, 1368.9, 1352.3, 1335.9, 1319.6, 1303.6, 1287.8, 1272.1, 1256.7, 1241.4, 1226.4, 1211.5, 1196.8, 1182.3, 1168.0, 1153.9, 1139.9, 1126.2, 1112.6, 1099.1, 1085.9, 1072.8, 1059.9, 1047.1, 1034.5, 1021.6, 1008.8, 996.24, 983.81, 971.54, 959.43, 947.48, 935.4, 923.49, 911.74, 900.15, 888.71, 877.44, 866.31, 855.33, 844.51, 833.83, 823.29, 812.9, 802.65, 792.53, 782.56, 772.71, 763.0, 753.42, 743.97, 734.65, 725.45, 716.37, 707.42, 698.58, 689.87, 681.27, 672.78, 664.41, 656.15, 648.0, 639.96, 632.03, 624.2, 616.48, 608.85, 601.33, 593.91, 586.59, 579.21, 571.89, 564.67, 557.54, 550.51, 543.57, 536.73, 529.98, 523.3, 516.68, 510.15, 503.71, 497.36, 491.09, 484.91, 478.81, 472.79, 466.85, 460.99, 455.21, 449.49, 443.83, 438.26, 432.75, 427.33, 421.95, 416.59, 411.29, 406.06, 400.91, 395.82, 390.81, 385.85, 380.97, 376.15, 371.4, 366.7, 362.08, 357.51, 353.0, 348.56, 344.17, 339.84, 335.56, 331.32, 327.14, 323.01, 318.94, 314.93, 310.96, 307.05, 303.19, 299.39, 295.63, 291.92, 288.26, 284.65, 281.09, 277.57, 274.1, 270.68, 267.3, 263.97, 260.67, 257.43, 254.22, 251.06, 247.94, 244.86, 241.82, 238.82, 235.86, 232.94, 230.05, 227.2, 224.4, 221.62, 218.89, 216.19, 213.52, 210.89, 208.29, 205.73, 203.2, 200.7, 198.24, 195.8, 193.4, 191.03, 188.69, 186.38, 184.1, 181.85, 179.63, 177.44, 175.27, 173.14, 171.03, 168.95, 166.89, 164.86, 162.86, 160.88, 158.93, 157.0, 155.1, 153.22, 151.37, 149.54, 147.73, 145.91, 126.56, 105.54, 88.196, 80.999, 77.703, 76.857, 203.6, 198.26, 195.53, 165.18, 152.63, 146.35, 144.73, 199.05, 192.23, 191.17, 188.07, 180.44, 178.48, 203.52, 195.96, 186.82, 157.3, 132.25, 111.15, 93.289, 78.304, 65.755, 55.245, 46.364, 38.927, 32.67, 27.183, 22.575, 18.764, 15.609, 12.995, 10.828, 9.0297, 7.5352, 6.2892, 5.2441, 4.3734, 3.6364, 3.0197, 2.5084, 2.0841, 2.0102, 1.9274, 1.9061, 9.5082, 9.1617, 8.8532, 7.439, 6.235, 5.2351, 4.3871, 3.6684, 3.0679, 2.5661, 2.1466, 1.7959, 1.5022, 1.2533, 1.0458, 0.87269, 0.72832, 0.6079, 0.50743, 0.42361, 0.35366, 0.29529, 0.24657, 0.2059, 0.17271, 0.14544, 0.1225, 0.10318, 0.08691, 0.0],
                    'energies (keV)': [0.006058082, 0.006148501, 0.006911593, 0.007017383, 0.007045593, 0.007087909, 0.007193699, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.044492, 0.045173, 0.045374, 0.045627, 0.0460685, 0.0462537, 0.046308, 0.04639671, 0.0465315, 0.047226, 0.04959809, 0.05302035, 0.05667876, 0.05684, 0.05771, 0.057942, 0.05829, 0.05916, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.082026, 0.0832815, 0.0836163, 0.0841185, 0.08458368, 0.085374, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.267344, 0.271436, 0.2725272, 0.274164, 0.278256, 0.2811158, 0.283612, 0.287953, 0.2891106, 0.290847, 0.295188, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.458836, 0.465859, 0.4677318, 0.470541, 0.477564, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54571853, 0.54696447, 0.54728152, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65327272, 0.65454173, 0.65532723, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.959659, 1.9605411, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.0299512, 2.030642, 2.031649, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.454905, 2.4594951, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7883189, 2.7942246, 2.7960812, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0422811, 3.054719, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 10.65348, 10.81655, 10.86003, 10.92525, 11.03212, 11.08832, 11.79334, 12.1373, 12.32308, 12.37262, 12.44693, 12.60708, 12.6327, 12.70864, 12.90316, 12.95503, 13.03284, 13.22736, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 72.39338, 73.50144, 73.79693, 74.24015, 75.34821, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ge': {'mass_absorption_coefficient (cm2/g)': [17290.0, 17459.0, 17594.0, 18885.0, 20524.0, 22602.0, 25110.0, 28023.0, 31304.0, 34899.0, 38731.0, 42704.0, 46702.0, 50596.0, 54248.0, 57524.0, 60297.0, 62462.0, 63938.0, 64674.0, 64653.0, 63890.0, 62430.0, 60330.0, 60236.0, 59660.0, 59502.0, 61149.0, 60595.0, 59922.0, 59635.0, 59297.0, 59128.0, 59686.0, 59065.0, 57580.0, 54388.0, 50940.0, 47345.0, 43699.0, 43641.0, 42813.0, 42594.0, 44041.0, 43234.0, 41845.0, 38305.0, 34893.0, 31642.0, 28577.0, 25714.0, 23060.0, 20616.0, 18380.0, 16345.0, 14500.0, 12835.0, 11338.0, 9996.5, 8797.5, 7728.0, 6755.7, 5842.7, 5044.4, 4349.0, 3745.4, 3222.8, 2771.5, 2382.7, 2229.5, 2204.5, 2179.7, 2155.2, 2131.0, 2107.1, 2083.4, 2060.0, 2036.9, 2014.0, 1991.4, 1969.1, 1947.0, 1925.1, 1903.5, 1882.2, 1861.1, 1840.2, 1819.6, 1799.2, 1779.0, 1759.1, 1736.7, 1714.1, 1691.9, 1669.9, 1648.3, 1627.0, 1605.9, 1585.2, 1564.7, 1544.5, 1524.6, 1504.9, 1485.5, 1466.4, 1447.6, 1429.0, 1410.6, 1392.5, 1374.7, 1357.0, 1339.7, 1322.5, 1305.6, 1289.0, 1272.5, 1256.3, 1240.3, 1224.5, 1208.9, 1193.5, 1178.3, 1163.4, 1148.6, 1134.0, 1119.7, 1105.5, 1091.5, 1077.7, 1064.1, 1058.2, 5672.7, 5633.3, 5560.1, 5487.8, 5416.4, 5346.0, 5311.5, 7529.5, 7483.3, 7386.2, 7290.4, 7195.9, 7102.5, 7010.4, 6919.5, 6829.8, 6741.2, 6653.9, 6567.6, 6482.5, 6398.5, 6315.5, 6233.7, 6152.9, 6073.2, 5994.6, 5916.9, 5840.3, 5764.6, 5690.0, 5616.3, 5543.6, 5471.8, 5440.4, 6177.4, 6162.8, 6087.5, 6013.0, 5939.5, 5867.0, 5795.3, 5724.6, 5654.7, 5585.7, 5517.6, 5450.2, 5383.6, 5317.9, 5253.0, 5188.8, 5125.5, 5063.0, 5001.2, 4940.2, 4880.0, 4820.5, 4761.8, 4703.8, 4646.2, 4589.3, 4533.1, 4477.7, 4422.9, 4368.6, 4315.0, 4262.0, 4209.7, 4158.0, 4107.0, 4056.6, 4006.8, 3957.7, 3909.1, 3861.2, 3813.8, 3767.0, 3720.8, 3675.2, 3630.1, 3585.6, 3541.6, 3498.2, 3455.3, 3413.0, 3371.1, 3329.8, 3289.0, 3248.7, 3208.6, 3169.0, 3129.8, 3091.1, 3052.9, 3015.1, 2977.9, 2941.0, 2904.7, 2868.8, 2833.3, 2798.2, 2763.6, 2729.5, 2695.7, 2662.4, 2629.4, 2596.9, 2564.8, 2533.1, 2501.7, 2470.8, 2440.2, 2410.0, 2380.2, 2350.8, 2321.7, 2293.0, 2264.6, 2236.6, 2209.0, 2181.6, 2154.7, 2128.0, 2101.7, 2075.7, 2050.0, 2024.7, 1999.6, 1974.9, 1950.5, 1926.4, 1902.5, 1878.8, 1855.4, 1832.4, 1809.6, 1787.1, 1764.8, 1742.9, 1721.2, 1699.8, 1678.7, 1657.8, 1637.2, 1616.8, 1596.4, 1576.1, 1556.1, 1536.3, 1516.8, 1497.5, 1478.3, 1459.3, 1440.6, 1422.1, 1403.9, 1385.9, 1368.2, 1350.6, 1333.3, 1316.3, 1299.4, 1282.8, 1266.3, 1250.1, 1234.1, 1218.3, 1202.8, 1187.4, 1172.2, 1157.2, 1142.4, 1127.8, 1113.4, 1099.2, 1085.1, 1071.2, 1057.4, 1043.8, 1030.3, 1017.1, 1004.0, 991.11, 978.37, 965.8, 953.4, 941.16, 928.6, 915.9, 903.37, 891.02, 878.84, 866.83, 854.99, 843.32, 831.81, 820.46, 809.28, 798.24, 787.36, 776.64, 766.06, 755.63, 745.35, 735.21, 725.21, 715.36, 705.64, 696.05, 686.6, 677.28, 668.08, 658.99, 650.04, 641.21, 632.5, 623.91, 615.45, 607.1, 598.86, 590.75, 582.74, 574.85, 567.06, 559.39, 551.82, 544.35, 536.99, 529.73, 522.58, 515.52, 508.56, 501.69, 494.93, 488.25, 481.67, 475.18, 468.78, 462.46, 456.24, 450.1, 444.04, 438.07, 432.18, 426.38, 420.65, 415.0, 409.43, 403.94, 398.52, 393.18, 387.91, 382.71, 377.59, 372.53, 367.55, 362.63, 357.78, 353.0, 348.28, 343.63, 339.05, 334.52, 330.06, 325.66, 321.32, 317.03, 312.81, 308.65, 304.54, 300.49, 296.49, 292.55, 288.66, 284.83, 281.05, 277.32, 273.64, 270.01, 266.43, 262.9, 259.42, 255.98, 252.59, 249.25, 245.95, 242.7, 239.49, 236.33, 233.21, 230.13, 227.1, 224.1, 221.15, 218.23, 215.36, 212.52, 209.72, 206.97, 204.24, 201.52, 198.8, 196.12, 193.48, 190.88, 188.29, 185.73, 183.2, 180.7, 178.24, 175.82, 173.43, 171.07, 168.75, 166.46, 164.2, 161.98, 159.78, 157.62, 155.49, 153.39, 151.31, 149.27, 147.25, 145.27, 143.31, 141.38, 139.47, 137.59, 135.74, 133.9, 132.04, 130.22, 128.42, 126.64, 124.89, 123.16, 121.46, 119.79, 118.13, 116.5, 114.9, 113.31, 111.75, 110.21, 96.18, 79.991, 66.59, 55.488, 46.108, 37.839, 31.083, 26.61, 25.557, 25.452, 25.155, 198.84, 189.9, 168.04, 140.32, 118.17, 99.832, 83.619, 69.892, 58.321, 48.611, 40.497, 33.739, 28.064, 23.305, 19.353, 15.993, 13.195, 10.882, 8.9736, 7.4007, 6.1039, 5.0346, 4.1529, 3.4258, 2.8102, 2.3043, 1.8896, 1.5495, 1.2707, 1.0421, 0.85469, 0.70022, 0.57226, 0.4677, 0.38226, 0.31244, 0.25538, 0.20875, 0.17064, 0.13949, 0.11403, 0.093225, 0.076216, 0.062312, 0.050946, 0.041655, 0.03406, 0.02785, 0.022773, 0.018622, 0.015228, 0.012454, 0.010185, 0.0083292, 0.0068121, 0.0055715, 0.0045569, 0.0],
                    'energies (keV)': [0.0288435, 0.02908327, 0.029274, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.118384, 0.120196, 0.1206792, 0.121404, 0.123216, 0.125342, 0.1262272, 0.1272605, 0.1277721, 0.1285395, 0.130458, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1764, 0.1791, 0.17982, 0.1809, 0.1836, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.2165985, 1.2168014, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2476951, 1.2479049, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4130073, 1.4155926, 1.4169487, 1.4240335, 1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 10.88104, 11.03212, 11.04758, 11.092, 11.15862, 11.32516, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Gd': {'mass_absorption_coefficient (cm2/g)': [614.34, 594.76, 539.18, 521.58, 517.02, 3841.9, 3719.3, 2914.2, 2690.6, 2590.0, 2582.7, 2652.5, 2791.7, 2997.2, 3269.4, 3610.7, 4024.7, 4167.8, 4278.1, 4307.9, 143590.0, 138420.0, 136340.0, 115820.0, 97536.0, 80717.0, 66274.0, 54491.0, 45259.0, 38268.0, 33419.0, 33141.0, 32451.0, 32208.0, 32095.0, 31273.0, 29756.0, 27272.0, 25621.0, 24533.0, 23842.0, 23407.0, 23121.0, 22909.0, 22714.0, 22501.0, 22245.0, 21935.0, 21566.0, 21141.0, 20662.0, 20400.0, 20360.0, 20320.0, 20281.0, 20240.0, 20200.0, 20160.0, 20119.0, 20078.0, 20037.0, 19995.0, 19954.0, 19912.0, 19870.0, 19828.0, 19785.0, 19743.0, 19700.0, 19657.0, 19614.0, 19571.0, 19527.0, 19484.0, 19440.0, 19396.0, 19352.0, 19308.0, 19264.0, 19219.0, 19175.0, 19130.0, 19085.0, 19040.0, 18995.0, 18950.0, 18905.0, 18860.0, 18814.0, 18769.0, 18723.0, 18677.0, 18631.0, 18586.0, 18540.0, 18493.0, 18447.0, 18401.0, 18355.0, 18309.0, 18262.0, 18216.0, 18169.0, 18123.0, 18076.0, 18029.0, 17983.0, 17936.0, 17889.0, 17843.0, 17796.0, 17749.0, 17702.0, 17655.0, 17609.0, 17562.0, 17515.0, 17468.0, 17421.0, 17374.0, 17368.0, 35770.0, 35003.0, 34051.0, 33146.0, 32284.0, 31464.0, 30684.0, 29942.0, 29235.0, 28562.0, 27921.0, 27310.0, 26729.0, 26174.0, 25646.0, 25143.0, 24663.0, 24205.0, 23769.0, 23352.0, 22956.0, 22585.0, 22238.0, 21912.0, 21607.0, 21320.0, 21050.0, 20789.0, 20538.0, 20300.0, 20075.0, 19861.0, 19657.0, 19463.0, 19278.0, 19101.0, 18931.0, 18769.0, 18613.0, 18464.0, 18320.0, 18182.0, 18049.0, 17921.0, 17758.0, 17579.0, 17404.0, 17233.0, 17066.0, 16902.0, 16742.0, 16585.0, 16431.0, 16280.0, 16131.0, 15985.0, 15842.0, 15701.0, 15562.0, 15426.0, 15291.0, 15159.0, 15028.0, 14900.0, 14773.0, 14648.0, 14525.0, 14404.0, 14284.0, 14165.0, 14048.0, 13933.0, 13819.0, 13706.0, 13595.0, 13485.0, 13377.0, 13270.0, 13164.0, 13059.0, 12955.0, 12853.0, 12751.0, 12651.0, 12552.0, 12454.0, 12357.0, 12262.0, 12167.0, 12073.0, 11981.0, 11889.0, 11798.0, 11709.0, 11620.0, 11532.0, 11445.0, 11360.0, 11275.0, 11191.0, 11107.0, 11025.0, 10944.0, 10864.0, 10784.0, 10705.0, 10628.0, 10551.0, 10474.0, 10399.0, 10325.0, 10251.0, 10178.0, 10106.0, 10035.0, 9964.6, 9895.0, 9826.1, 9758.1, 9690.8, 9624.2, 9558.4, 9493.4, 9429.1, 9365.5, 9302.7, 9240.5, 9179.1, 9118.4, 9058.4, 8999.1, 8940.5, 8902.5, 10018.0, 10016.0, 9956.8, 9898.4, 9840.6, 9783.5, 9727.0, 9671.1, 9615.9, 9561.3, 9507.4, 9454.0, 9401.3, 9349.1, 9336.1, 9638.1, 9618.3, 9567.2, 9516.7, 9466.7, 9417.3, 9368.4, 9320.1, 9272.3, 9225.0, 9178.2, 9131.9, 9086.1, 9040.7, 8995.8, 8951.4, 8907.4, 8863.8, 8820.7, 8778.0, 8735.8, 8693.9, 8652.4, 8611.3, 8570.6, 8530.3, 8490.3, 8450.7, 8411.5, 8372.5, 8334.0, 8295.7, 8257.7, 8220.1, 8182.7, 8145.7, 8108.9, 8072.4, 8036.2, 8000.2, 7964.5, 7929.1, 7893.8, 7858.8, 7824.0, 7789.5, 7755.1, 7721.0, 7687.0, 7653.2, 7619.6, 7586.2, 7552.9, 7519.8, 7513.3, 7876.5, 7865.6, 7831.7, 7797.9, 7764.2, 7730.6, 7697.2, 7663.9, 7630.7, 7597.6, 7564.6, 7531.8, 7499.0, 7466.3, 7433.6, 7401.1, 7368.6, 7336.2, 7303.9, 7271.6, 7239.4, 7207.2, 7175.1, 7143.0, 7110.9, 7078.9, 7046.8, 7014.8, 6982.8, 6950.9, 6918.9, 6886.9, 6855.0, 6823.0, 6791.1, 6759.1, 6727.2, 6695.2, 6663.2, 6631.3, 6599.3, 6567.3, 6535.3, 6503.3, 6471.3, 6439.3, 6407.3, 6375.2, 6343.2, 6311.1, 6279.0, 6246.9, 6214.8, 6182.7, 6150.5, 6118.4, 6086.2, 6054.0, 6021.9, 5989.7, 5957.5, 5925.2, 5893.0, 5860.8, 5828.6, 5796.3, 5764.1, 5731.8, 5699.6, 5667.3, 5635.1, 5602.9, 5570.6, 5538.4, 5506.2, 5474.0, 5441.8, 5409.6, 5377.5, 5345.3, 5313.2, 5281.1, 5249.0, 5216.9, 5184.8, 5152.6, 5120.5, 5088.4, 5056.2, 5024.1, 4992.0, 4959.9, 4927.8, 4895.7, 4863.7, 4831.7, 4799.8, 4767.8, 4735.9, 4704.1, 4672.3, 4640.6, 4608.9, 4577.3, 4545.7, 4514.2, 4482.8, 4451.4, 4420.2, 4389.0, 4357.9, 4326.8, 4295.9, 4265.1, 4234.3, 4203.6, 4173.1, 4142.6, 4112.3, 4082.0, 4051.9, 4021.8, 3991.9, 3962.1, 3932.4, 3902.8, 3873.4, 3844.1, 3814.9, 3785.8, 3756.9, 3728.1, 3699.4, 3670.9, 3642.5, 3614.3, 3586.2, 3558.2, 3530.4, 3502.7, 3475.2, 3447.8, 3420.6, 3393.5, 3366.5, 3339.8, 3313.1, 3286.7, 3260.3, 3234.2, 3208.2, 3182.3, 3156.6, 3131.1, 3105.7, 3080.5, 3055.4, 3030.5, 3005.8, 2981.2, 2956.8, 2932.5, 2908.4, 2884.5, 2860.7, 2837.1, 2813.6, 2790.3, 2767.2, 2744.2, 2721.4, 2698.8, 2676.3, 2654.0, 2631.8, 2609.8, 2587.9, 2566.3, 2544.7, 2523.4, 2502.1, 2481.1, 2460.2, 2439.5, 2418.9, 2398.5, 2378.2, 2358.1, 2338.1, 2318.3, 2298.6, 2279.1, 2259.8, 2240.6, 2221.6, 2202.7, 2183.9, 2163.9, 2141.2, 2118.7, 2096.5, 2074.5, 2052.7, 2031.2, 2010.0, 1989.0, 1968.2, 1947.6, 1927.3, 1907.1, 1887.3, 1867.6, 1848.1, 1828.8, 1809.3, 1790.0, 1771.0, 1752.1, 1733.5, 1715.1, 1696.9, 1678.9, 1661.1, 1643.5, 1626.1, 1608.9, 1591.7, 1574.7, 1557.9, 1541.2, 1524.8, 1513.2, 5847.2, 5829.7, 5757.7, 5686.6, 5616.4, 5547.1, 5478.6, 5476.1, 8244.3, 8153.4, 8051.9, 7951.6, 7852.6, 7754.9, 7658.4, 7563.1, 7469.0, 7376.0, 7284.3, 7193.7, 7104.2, 7015.9, 6928.7, 6842.6, 6757.5, 6673.6, 6590.7, 6508.8, 6428.0, 6348.1, 6269.3, 6191.5, 6114.6, 6038.8, 5963.8, 5889.8, 5816.8, 5744.6, 5673.4, 5603.0, 5533.6, 5465.0, 5397.3, 5330.4, 5264.4, 5199.1, 5134.8, 5071.2, 5008.4, 4946.4, 4885.2, 4824.7, 4764.9, 4705.9, 4647.7, 4590.1, 4556.3, 5323.8, 5318.7, 5249.4, 5180.9, 5113.4, 5046.7, 4980.8, 4915.5, 4851.1, 4787.5, 4724.8, 4665.0, 4607.4, 4550.7, 4495.0, 4440.1, 4386.0, 4332.8, 4280.4, 4254.7, 4534.3, 4525.9, 4470.0, 4415.0, 4360.8, 4307.3, 4254.7, 4202.8, 4151.7, 4101.3, 4051.6, 4003.7, 3957.0, 3911.1, 3865.8, 3821.2, 3777.4, 3734.1, 3691.5, 3649.5, 3608.1, 3567.3, 3527.1, 3526.8, 3668.7, 3653.8, 3613.3, 3573.3, 3533.8, 3494.9, 3456.4, 3418.4, 3381.0, 3344.0, 3307.4, 3271.5, 3236.0, 3201.0, 3165.7, 3130.5, 3095.7, 3061.3, 3027.3, 2993.7, 2960.5, 2927.7, 2895.3, 2863.2, 2831.5, 2800.2, 2769.2, 2738.5, 2708.2, 2678.3, 2648.7, 2619.4, 2590.1, 2561.0, 2532.2, 2503.8, 2475.6, 2447.8, 2420.3, 2393.0, 2366.1, 2339.5, 2313.2, 2287.1, 2261.4, 2235.9, 2210.7, 2185.7, 2160.5, 2135.6, 2111.0, 2086.7, 2062.7, 2038.6, 2014.7, 1991.0, 1967.7, 1944.6, 1921.8, 1899.3, 1877.0, 1855.0, 1833.2, 1811.7, 1790.5, 1769.5, 1748.8, 1728.3, 1708.1, 1687.9, 1667.9, 1648.1, 1628.5, 1609.2, 1590.2, 1571.4, 1552.8, 1534.4, 1516.3, 1498.4, 1480.7, 1463.2, 1446.0, 1429.0, 1412.1, 1395.5, 1379.1, 1362.9, 1347.0, 1331.2, 1315.6, 1300.2, 1285.0, 1270.0, 1255.1, 1239.2, 1223.4, 1207.9, 1192.6, 1177.5, 1162.6, 1147.6, 1132.8, 1118.3, 1103.9, 1089.7, 1075.7, 1061.9, 1048.3, 1034.9, 1021.6, 1008.6, 995.68, 982.97, 970.42, 958.05, 945.84, 933.8, 921.86, 909.99, 898.28, 886.72, 875.32, 864.07, 852.98, 842.03, 831.24, 820.59, 810.08, 799.71, 789.48, 779.39, 769.44, 759.61, 749.92, 740.36, 730.93, 721.63, 712.45, 703.39, 694.41, 685.53, 676.78, 668.14, 659.62, 651.21, 642.91, 634.72, 626.65, 618.68, 610.81, 603.05, 577.74, 487.44, 411.81, 348.39, 294.41, 247.92, 209.14, 176.75, 149.25, 139.63, 134.32, 132.95, 384.35, 366.06, 315.09, 302.24, 301.0, 298.97, 407.1, 391.17, 376.14, 361.2, 357.4, 407.12, 403.51, 392.49, 341.48, 286.42, 239.92, 200.74, 167.95, 140.64, 117.87, 98.875, 82.687, 69.104, 57.618, 48.045, 40.097, 33.494, 28.004, 23.434, 19.626, 16.322, 13.552, 11.252, 9.332, 7.7302, 6.3835, 5.273, 4.358, 3.6045, 3.3307, 3.1904, 3.1543, 17.679, 17.071, 17.021, 14.364, 12.052, 10.103, 8.4624, 7.0807, 5.9244, 4.9501, 4.1234, 3.4352, 2.8622, 2.3763, 1.9723, 1.6371, 1.3589, 1.1282, 0.93668, 0.77775, 0.64585, 0.53635, 0.44545, 0.36999, 0.30772, 0.2567, 0.21415, 0.17866, 0.14907, 0.12438, 0.10379, 0.086616, 0.072286, 0.060329, 0.050353, 0.0],
                    'energies (keV)': [0.008566815, 0.008694678, 0.009093814, 0.009233005, 0.009270123, 0.009325799, 0.00946499, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.019894, 0.0201985, 0.0202797, 0.0204015, 0.020706, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.035378, 0.03552846, 0.0359195, 0.0360639, 0.0362805, 0.036822, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14046403, 0.14053596, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27068519, 0.27111483, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28823661, 0.28876341, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37534905, 0.37625097, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1850578, 1.1853422, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.216959, 1.217441, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.5427108, 1.5452893, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6868076, 1.6897925, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8778472, 1.8837529, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.097944, 7.206586, 7.235557, 7.279014, 7.392525, 7.771694, 7.890649, 7.902609, 7.92237, 7.969952, 8.088906, 8.208088, 8.333722, 8.367224, 8.417478, 8.44789, 8.543112, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 49.23432, 49.98791, 50.18886, 50.4903, 51.18542, 51.24388, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ga': {'mass_absorption_coefficient (cm2/g)': [33658.0, 33313.0, 32698.0, 31256.0, 30645.0, 30944.0, 31981.0, 33647.0, 35869.0, 38585.0, 41738.0, 45264.0, 49089.0, 53124.0, 57267.0, 61401.0, 65403.0, 69146.0, 72505.0, 75364.0, 77623.0, 79203.0, 80050.0, 80061.0, 79152.0, 77393.0, 74879.0, 71726.0, 69450.0, 68590.0, 68359.0, 70857.0, 70810.0, 70117.0, 69953.0, 69224.0, 68985.0, 69934.0, 69041.0, 68192.0, 63982.0, 59676.0, 55375.0, 51152.0, 47066.0, 46780.0, 45876.0, 45639.0, 47231.0, 46364.0, 45098.0, 41391.0, 37895.0, 34612.0, 31545.0, 28690.0, 26043.0, 23593.0, 21331.0, 19246.0, 17330.0, 15346.0, 13490.0, 11834.0, 10359.0, 9047.7, 7883.9, 6855.3, 5949.7, 5155.2, 4460.7, 3855.1, 3328.5, 2871.7, 2476.4, 2135.0, 2000.2, 1978.1, 1956.3, 1934.7, 1913.4, 1892.3, 1871.4, 1850.8, 1830.4, 1810.2, 1790.2, 1770.5, 1751.0, 1731.7, 1712.6, 1693.7, 1675.1, 1656.6, 1638.4, 1620.3, 1602.5, 1584.9, 1564.9, 1544.9, 1525.2, 1505.7, 1486.5, 1467.5, 1448.8, 1430.4, 1412.1, 1394.2, 1376.5, 1359.0, 1341.7, 1324.7, 1308.0, 1291.4, 1275.1, 1258.9, 1243.0, 1227.3, 1211.9, 1196.6, 1196.5, 6577.7, 6494.4, 6409.1, 6324.9, 6241.8, 6177.4, 8765.7, 8744.3, 8629.6, 8516.5, 8404.8, 8294.6, 8185.9, 8078.6, 7972.7, 7868.2, 7765.1, 7663.3, 7562.9, 7463.8, 7366.0, 7269.6, 7174.3, 7080.4, 6987.7, 6896.2, 6805.9, 6716.8, 6628.8, 6542.1, 6456.4, 6372.0, 6288.6, 6273.2, 7087.7, 7049.8, 6964.0, 6879.4, 6795.8, 6713.3, 6631.8, 6551.4, 6471.9, 6393.6, 6316.2, 6238.9, 6162.5, 6087.0, 6012.4, 5938.8, 5866.0, 5794.1, 5723.0, 5652.9, 5583.5, 5515.0, 5447.4, 5380.6, 5314.7, 5249.6, 5185.2, 5121.7, 5058.9, 4996.9, 4935.7, 4875.2, 4815.4, 4756.4, 4698.1, 4640.5, 4583.6, 4527.5, 4472.0, 4417.2, 4363.0, 4309.6, 4256.7, 4204.6, 4153.1, 4102.2, 4052.0, 4002.3, 3953.3, 3904.9, 3857.1, 3809.9, 3763.3, 3717.3, 3671.5, 3626.2, 3581.5, 3537.4, 3493.8, 3450.8, 3408.3, 3366.3, 3324.9, 3283.9, 3243.5, 3203.5, 3164.1, 3125.2, 3086.7, 3048.7, 3011.2, 2974.1, 2937.5, 2901.3, 2865.6, 2830.4, 2795.6, 2761.2, 2727.2, 2693.7, 2660.5, 2627.6, 2595.1, 2563.0, 2531.3, 2500.0, 2469.0, 2438.5, 2408.3, 2378.4, 2348.9, 2319.8, 2291.0, 2262.6, 2234.5, 2206.8, 2179.4, 2152.4, 2125.7, 2099.3, 2073.3, 2047.6, 2022.2, 1997.2, 1972.4, 1948.0, 1923.8, 1900.0, 1876.5, 1853.2, 1829.7, 1806.6, 1783.7, 1761.1, 1738.7, 1716.4, 1694.4, 1672.7, 1651.3, 1630.2, 1609.3, 1588.7, 1568.3, 1548.2, 1528.4, 1508.8, 1489.5, 1470.5, 1451.6, 1433.1, 1414.7, 1396.6, 1378.8, 1361.1, 1343.7, 1326.6, 1309.6, 1292.9, 1276.3, 1260.0, 1243.8, 1227.8, 1211.9, 1196.3, 1180.9, 1165.6, 1150.6, 1135.8, 1121.1, 1106.7, 1092.4, 1078.3, 1064.5, 1050.7, 1037.2, 1023.9, 1010.7, 997.71, 984.88, 972.22, 959.73, 947.4, 935.24, 923.23, 911.39, 899.7, 888.16, 876.75, 865.49, 853.93, 842.25, 830.73, 819.38, 808.18, 797.14, 786.26, 775.52, 764.94, 754.51, 744.22, 734.07, 724.07, 714.21, 704.48, 694.89, 685.43, 676.11, 666.92, 657.85, 648.91, 640.1, 631.41, 622.84, 614.39, 606.05, 597.84, 589.73, 581.74, 573.86, 566.1, 558.43, 550.88, 543.43, 536.08, 528.84, 521.69, 514.65, 507.7, 500.85, 494.09, 487.43, 480.86, 474.38, 467.99, 461.69, 455.48, 449.35, 443.31, 437.35, 431.47, 425.68, 419.96, 414.32, 408.76, 403.28, 397.87, 392.54, 387.28, 382.09, 376.98, 371.93, 366.96, 362.05, 357.21, 352.44, 347.73, 343.09, 338.51, 333.99, 329.54, 325.15, 320.82, 316.54, 312.33, 308.17, 304.07, 300.03, 296.04, 292.1, 288.22, 284.4, 280.62, 276.9, 273.23, 269.6, 266.03, 262.51, 259.03, 255.6, 252.22, 248.89, 245.59, 242.35, 239.15, 235.99, 232.8, 229.64, 226.54, 223.47, 220.44, 217.42, 214.45, 211.52, 208.63, 205.77, 202.97, 200.2, 197.46, 194.77, 192.12, 189.5, 186.92, 184.38, 181.88, 179.4, 176.97, 174.57, 172.2, 169.86, 167.56, 165.29, 163.06, 160.85, 158.68, 156.53, 154.38, 152.24, 150.12, 148.04, 145.98, 143.96, 141.96, 139.99, 138.05, 136.14, 134.26, 132.4, 130.57, 128.76, 126.98, 125.23, 123.5, 121.79, 120.11, 118.45, 116.82, 115.21, 113.62, 112.05, 110.51, 108.99, 107.49, 106.01, 104.55, 103.12, 101.7, 100.3, 87.567, 72.866, 60.692, 50.6, 42.063, 34.52, 29.693, 28.356, 28.062, 222.63, 212.71, 187.43, 156.62, 131.89, 111.4, 93.277, 77.963, 65.056, 54.223, 45.17, 37.627, 31.282, 25.962, 21.546, 17.88, 14.767, 12.171, 10.032, 8.2698, 6.8174, 5.6205, 4.634, 3.8208, 3.1326, 2.5677, 2.1048, 1.7254, 1.4144, 1.1596, 0.95066, 0.77942, 0.63828, 0.52132, 0.42581, 0.34782, 0.28412, 0.23209, 0.1896, 0.15489, 0.12654, 0.10338, 0.084467, 0.069014, 0.05639, 0.046077, 0.037651, 0.030767, 0.025142, 0.020546, 0.016791, 0.013723, 0.011215, 0.0091665, 0.0074921, 0.0061237, 0.0050054, 0.0040914, 0.0],
                    'energies (keV)': [0.017487, 0.017748, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.100842, 0.1023855, 0.1027971, 0.1033284, 0.1034145, 0.104664, 0.104958, 0.106266, 0.1066932, 0.107334, 0.108936, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.154938, 0.1573095, 0.1579419, 0.1588905, 0.161262, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.115315, 1.115485, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.142213, 1.1423871, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.2964841, 1.298916, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.15976, 10.32004, 10.35673, 10.41894, 10.57444, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Pr': {'mass_absorption_coefficient (cm2/g)': [6628.8, 6856.4, 7108.0, 7383.7, 7683.6, 8005.8, 8347.0, 8705.0, 9077.4, 9461.2, 9852.8, 10136.0, 10226.0, 10248.0, 10250.0, 177410.0, 168510.0, 144050.0, 114780.0, 90748.0, 71673.0, 57019.0, 46020.0, 37889.0, 34878.0, 33561.0, 33229.0, 32914.0, 32111.0, 31781.0, 27808.0, 24683.0, 22399.0, 20694.0, 19408.0, 18421.0, 17645.0, 17015.0, 15944.0, 14793.0, 13700.0, 12656.0, 11658.0, 10704.0, 9796.4, 8934.9, 8880.8, 8692.0, 8642.5, 92570.0, 74804.0, 54680.0, 23614.0, 13571.0, 9768.5, 7891.4, 6765.4, 6003.0, 5455.1, 5056.0, 4806.1, 4772.2, 4752.3, 4738.9, 6054.5, 6005.8, 5904.3, 5889.0, 5854.8, 5846.4, 6243.8, 6215.9, 6182.1, 6103.4, 6057.9, 6029.1, 6025.8, 6021.8, 6019.8, 6521.6, 6509.4, 6478.7, 6398.4, 6278.5, 6110.7, 5892.5, 5625.8, 5315.2, 4967.4, 4597.5, 4219.4, 3845.0, 3483.3, 3140.5, 2820.6, 2525.8, 2256.6, 2096.5, 2042.3, 2028.2, 8590.4, 8533.6, 8499.1, 8234.1, 8142.5, 12224.0, 11705.0, 10751.0, 8926.0, 7511.2, 6392.5, 6357.1, 6157.6, 6097.2, 7034.1, 6771.9, 6290.3, 6217.5, 5997.9, 5941.7, 6263.1, 6045.8, 5742.9, 5026.2, 4956.1, 4865.1, 4823.6, 4991.8, 4839.1, 4510.2, 3876.6, 3321.3, 2841.2, 2427.7, 2071.4, 1767.5, 1509.0, 1287.7, 1099.3, 931.5, 783.77, 660.38, 556.52, 467.07, 392.44, 330.23, 278.37, 235.08, 198.05, 182.31, 175.2, 173.38, 524.03, 508.54, 500.13, 446.5, 427.69, 422.91, 576.75, 575.86, 552.63, 523.81, 502.61, 497.22, 566.42, 556.89, 545.7, 471.36, 398.54, 335.95, 282.36, 235.8, 197.09, 164.88, 138.06, 115.27, 96.105, 79.904, 66.439, 55.292, 46.054, 38.386, 32.023, 26.74, 22.349, 18.697, 15.648, 12.975, 10.718, 8.831, 7.2766, 6.0004, 4.952, 4.3067, 4.1235, 4.09, 4.0765, 24.014, 23.113, 20.58, 17.266, 14.47, 12.121, 10.126, 8.4571, 7.0626, 5.8973, 4.9238, 4.1057, 3.4067, 2.8227, 2.339, 1.9383, 1.6065, 1.3315, 1.1037, 0.91499, 0.75857, 0.62894, 0.5215, 0.43245, 0.35938, 0.29869, 0.24826, 0.20635, 0.17154, 0.1426, 0.11855, 0.098564, 0.081951, 0.068142, 0.056662, 0.047119, 0.039184, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.021854, 0.0221885, 0.02227063, 0.0222777, 0.0224115, 0.022746, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.036652, 0.037213, 0.0373626, 0.037587, 0.03797993, 0.038148, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.110936, 0.112634, 0.1130868, 0.113766, 0.115464, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.213248, 0.2152655, 0.216512, 0.2173824, 0.218688, 0.221952, 0.2301188, 0.231574, 0.2351185, 0.2360637, 0.2374815, 0.241026, 0.245997, 0.2629708, 0.2811158, 0.29841, 0.3005128, 0.3029775, 0.3041955, 0.3060225, 0.31059, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.91238, 0.926345, 0.930069, 0.932078, 0.9342948, 0.935655, 0.9463445, 0.9501489, 0.9558555, 0.970122, 0.9987612, 1.067676, 1.141345, 1.217356, 1.220098, 1.235989, 1.240958, 1.248411, 1.267044, 1.304285, 1.310652, 1.330713, 1.336063, 1.344087, 1.364148, 1.394281, 1.48078, 1.490486, 1.503445, 1.509489, 1.518555, 1.54122, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 5.845014, 5.934479, 5.958336, 5.994122, 6.051453, 6.083586, 6.311592, 6.408198, 6.43396, 6.469004, 6.472602, 6.569208, 6.698104, 6.800626, 6.827965, 6.868974, 6.915365, 6.971496, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.15079, 41.78065, 41.89992, 41.94861, 42.20055, 42.83041, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Pt': {'mass_absorption_coefficient (cm2/g)': [40474.0, 39638.0, 33428.0, 33345.0, 33339.0, 60636.0, 59765.0, 74256.0, 83433.0, 93785.0, 104840.0, 115990.0, 126540.0, 135690.0, 142680.0, 146850.0, 147750.0, 145200.0, 139350.0, 130620.0, 119650.0, 107170.0, 94012.0, 80908.0, 68426.0, 57012.0, 46920.0, 38238.0, 30932.0, 24894.0, 19973.0, 18611.0, 17696.0, 17462.0, 34762.0, 33023.0, 32410.0, 25731.0, 20414.0, 16878.0, 16187.0, 16013.0, 15792.0, 21854.0, 20937.0, 18742.0, 18411.0, 17642.0, 17446.0, 19026.0, 18234.0, 18023.0, 17241.0, 17181.0, 17039.0, 17927.0, 17148.0, 15026.0, 12274.0, 10177.0, 8631.1, 8083.3, 7846.5, 7787.6, 7888.1, 7742.2, 7692.4, 7079.1, 6792.6, 6853.7, 7223.6, 7889.4, 8822.7, 9975.7, 11292.0, 12699.0, 14107.0, 15424.0, 16559.0, 17435.0, 17997.0, 18218.0, 18084.0, 17962.0, 17854.0, 17822.0, 18161.0, 18045.0, 18000.0, 17919.0, 17771.0, 17729.0, 17944.0, 17788.0, 17588.0, 16707.0, 15674.0, 14554.0, 13398.0, 12248.0, 11539.0, 11457.0, 11374.0, 11292.0, 11210.0, 11129.0, 11047.0, 10966.0, 10948.0, 11596.0, 11574.0, 11491.0, 11409.0, 11327.0, 11245.0, 11164.0, 11083.0, 11003.0, 10922.0, 10843.0, 10763.0, 10684.0, 10606.0, 10527.0, 10449.0, 10372.0, 10295.0, 10218.0, 10142.0, 10066.0, 9990.5, 9915.4, 9840.7, 9766.4, 9692.4, 9618.9, 9545.8, 9473.1, 9400.8, 9328.9, 9257.4, 9186.3, 9163.7, 9256.9, 9249.3, 9179.0, 9109.1, 9039.6, 8970.4, 8901.7, 8833.4, 8765.6, 8698.1, 8631.0, 8564.3, 8498.0, 8432.2, 8366.7, 8301.7, 8237.0, 8172.8, 8108.9, 8045.5, 7982.4, 7919.8, 7857.5, 7795.7, 7734.2, 7673.2, 7612.5, 7552.2, 7492.3, 7432.8, 7373.7, 7315.0, 7256.6, 7198.7, 7141.1, 7121.1, 7243.6, 7186.3, 7129.3, 7072.8, 7016.6, 6960.7, 6905.3, 6850.2, 6795.5, 6741.2, 6687.2, 6633.6, 6580.4, 6527.5, 6475.0, 6422.9, 6371.1, 6319.7, 6268.6, 6217.9, 6167.6, 6117.6, 6067.9, 6018.6, 5969.6, 5920.9, 5872.6, 5824.7, 5777.0, 5729.7, 5682.8, 5636.1, 5589.8, 5543.8, 5498.2, 5452.9, 5407.9, 5363.2, 5318.8, 5274.7, 5230.8, 5187.2, 5143.9, 5100.9, 5058.2, 5015.8, 4973.8, 4932.0, 4890.6, 4849.4, 4808.6, 4768.0, 4727.8, 4687.8, 4648.2, 4608.9, 4569.8, 4531.1, 4492.6, 4454.4, 4416.5, 4378.9, 4341.6, 4304.5, 4267.7, 4231.1, 4189.8, 4148.9, 4108.3, 4068.2, 4028.4, 3989.0, 3949.7, 3910.9, 3872.4, 3834.4, 3796.6, 3759.3, 3722.3, 3685.6, 3649.4, 3613.4, 3577.8, 3542.6, 3507.7, 3473.2, 3439.0, 3405.1, 3371.6, 3338.4, 3305.5, 3273.0, 3240.8, 3208.9, 3177.3, 3146.1, 3115.1, 3084.5, 3054.2, 3024.2, 2994.5, 2965.1, 2936.0, 2907.2, 2878.6, 2850.4, 2822.4, 2794.6, 2767.1, 2739.9, 2713.0, 2685.1, 2657.2, 2629.5, 2602.2, 2575.2, 2548.4, 2522.0, 2495.8, 2470.0, 2444.4, 2419.1, 2393.2, 2367.5, 2341.0, 2314.8, 2288.9, 2263.3, 2238.1, 2213.1, 2188.5, 2164.2, 2139.9, 2115.4, 2091.2, 2067.3, 2043.7, 2020.4, 1997.4, 1974.7, 1952.3, 1930.1, 1908.3, 1886.7, 1865.4, 1844.3, 1823.6, 1803.0, 1782.8, 1762.8, 1743.0, 1723.5, 1704.2, 1685.2, 1666.4, 1647.8, 1629.5, 1611.4, 1593.5, 1575.9, 1558.4, 1541.2, 1524.2, 1507.4, 1490.8, 1474.4, 1458.2, 1442.2, 1426.4, 1410.8, 1395.4, 1380.1, 1365.1, 1350.2, 1335.5, 1321.0, 1306.7, 1292.6, 1278.6, 1264.8, 1251.1, 1237.6, 1224.3, 1211.1, 1198.1, 1185.3, 1172.6, 1160.0, 1147.6, 1135.4, 1123.3, 1111.3, 1099.5, 1087.8, 1076.3, 1064.9, 1053.6, 1042.5, 1031.5, 1020.6, 1009.8, 999.21, 988.71, 978.33, 968.07, 957.94, 947.92, 938.01, 928.23, 918.55, 908.99, 899.54, 890.09, 880.66, 871.35, 862.14, 855.44, 2614.5, 2609.3, 2577.9, 2546.9, 2516.2, 2486.0, 2456.1, 2426.6, 2397.4, 2392.5, 3510.9, 3480.9, 3438.5, 3396.7, 3355.3, 3314.5, 3274.2, 3234.4, 3195.1, 3156.3, 3118.0, 3080.1, 3042.7, 3005.8, 2969.4, 2933.3, 2897.8, 2862.7, 2828.0, 2793.7, 2759.9, 2726.4, 2693.3, 2660.7, 2628.4, 2596.5, 2565.0, 2533.9, 2503.2, 2472.9, 2443.0, 2413.4, 2384.2, 2355.3, 2326.8, 2298.7, 2270.9, 2247.9, 2243.5, 2617.7, 2592.8, 2561.4, 2530.5, 2499.9, 2469.7, 2439.9, 2410.4, 2381.3, 2352.2, 2323.5, 2296.0, 2268.8, 2242.1, 2215.7, 2189.7, 2164.0, 2138.3, 2113.0, 2088.0, 2063.3, 2038.9, 2014.8, 1991.0, 1967.5, 1944.3, 1920.0, 1902.3, 1895.6, 2014.5, 1996.4, 1970.9, 1945.8, 1921.0, 1896.4, 1872.2, 1848.3, 1824.7, 1801.4, 1778.5, 1756.2, 1734.2, 1712.5, 1691.1, 1670.0, 1649.2, 1634.8, 1628.6, 1689.8, 1680.0, 1659.5, 1639.3, 1619.3, 1599.6, 1580.2, 1561.0, 1542.1, 1523.4, 1504.8, 1486.5, 1468.4, 1450.6, 1433.0, 1415.6, 1398.5, 1381.5, 1364.9, 1348.4, 1332.1, 1316.1, 1300.3, 1284.6, 1269.2, 1254.0, 1238.9, 1224.1, 1209.4, 1195.0, 1180.7, 1166.6, 1152.7, 1139.0, 1125.4, 1112.0, 1098.7, 1085.5, 1072.4, 1059.5, 1046.8, 1034.2, 1021.8, 1009.6, 997.45, 985.49, 973.67, 962.01, 950.49, 939.11, 927.87, 916.67, 905.3, 894.06, 882.95, 871.98, 861.15, 850.46, 839.91, 829.3, 818.78, 808.39, 798.15, 788.04, 778.07, 768.23, 758.52, 748.95, 739.5, 730.17, 720.97, 711.89, 702.93, 694.1, 685.38, 676.77, 668.28, 659.9, 651.63, 643.48, 635.43, 627.49, 619.65, 611.92, 604.28, 596.75, 589.32, 581.99, 574.76, 567.62, 560.57, 553.62, 546.76, 539.99, 533.31, 526.72, 520.05, 513.47, 506.98, 500.58, 494.26, 488.03, 481.88, 475.81, 469.82, 463.91, 458.08, 452.33, 446.66, 441.06, 435.53, 430.08, 424.7, 419.39, 414.16, 408.99, 403.89, 398.83, 393.84, 388.91, 384.04, 379.24, 374.51, 369.78, 365.12, 360.52, 355.98, 351.51, 347.07, 342.69, 338.37, 334.11, 329.91, 325.76, 321.66, 317.62, 313.64, 309.7, 305.82, 301.99, 298.2, 294.45, 290.75, 287.1, 283.5, 279.95, 276.45, 272.99, 269.57, 266.2, 262.88, 259.6, 256.36, 253.17, 250.02, 246.91, 243.84, 240.81, 237.82, 234.87, 231.95, 229.08, 226.24, 223.44, 220.68, 217.95, 215.26, 212.61, 209.99, 207.4, 204.84, 202.32, 199.84, 197.38, 194.96, 192.57, 190.21, 187.87, 185.57, 183.3, 181.06, 178.85, 176.67, 174.51, 172.38, 170.28, 168.21, 166.16, 164.14, 162.15, 160.18, 158.24, 137.63, 115.04, 96.047, 80.347, 74.82, 71.853, 71.074, 186.34, 178.99, 178.92, 149.05, 136.79, 131.18, 129.73, 178.88, 173.91, 171.78, 169.57, 162.67, 160.9, 183.48, 176.65, 168.93, 142.24, 119.63, 100.6, 84.474, 70.936, 59.594, 50.091, 42.061, 35.34, 29.461, 24.467, 20.337, 16.917, 14.084, 11.735, 9.7858, 8.167, 6.8207, 5.696, 4.7532, 3.9674, 3.3016, 2.7441, 2.2816, 1.8974, 1.8675, 1.791, 1.7713, 8.6561, 8.3267, 7.9141, 6.6997, 5.6344, 4.6996, 3.9234, 3.2827, 2.747, 2.2991, 1.9244, 1.611, 1.3481, 1.126, 0.94065, 0.78587, 0.65662, 0.54868, 0.45853, 0.38323, 0.32032, 0.26776, 0.22384, 0.18715, 0.15737, 0.13277, 0.11203, 0.094541, 0.0],
                    'energies (keV)': [0.006156007, 0.006247887, 0.007291108, 0.007402706, 0.007432466, 0.007477105, 0.007588704, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.050666, 0.0514415, 0.0516483, 0.0519585, 0.052734, 0.05302035, 0.05667876, 0.06058959, 0.063994, 0.06477028, 0.0649735, 0.0652347, 0.0656265, 0.066606, 0.06923942, 0.069678, 0.0707445, 0.0710289, 0.0714555, 0.072522, 0.072814, 0.0739285, 0.07401695, 0.0742257, 0.0746715, 0.075786, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.099666, 0.1011915, 0.1015983, 0.1022085, 0.1033284, 0.103734, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.307034, 0.3117335, 0.3129867, 0.3148665, 0.319566, 0.3212482, 0.324184, 0.329146, 0.3304692, 0.332454, 0.337416, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.51833567, 0.51966431, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.60832884, 0.61007116, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72085202, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1210653, 2.1221346, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2011954, 2.2026046, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6429266, 2.6450545, 2.6478735, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.0221418, 3.026344, 3.0308581, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2891773, 3.2941347, 3.3028227, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.33243, 11.50588, 11.55214, 11.62152, 11.79334, 11.79497, 12.60708, 13.00715, 13.20624, 13.25933, 13.33896, 13.47697, 13.53805, 13.6023, 13.8105, 13.86602, 13.9493, 14.1575, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 76.8269, 78.00282, 78.3164, 78.78677, 79.96269, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'C': {'mass_absorption_coefficient (cm2/g)': [1072900.0, 1051800.0, 569990.0, 525300.0, 483160.0, 443300.0, 405580.0, 369920.0, 336260.0, 304590.0, 274890.0, 254910.0, 248740.0, 247180.0, 247130.0, 272340.0, 267450.0, 253120.0, 234370.0, 217230.0, 201340.0, 186430.0, 172270.0, 158790.0, 145940.0, 133690.0, 122040.0, 111000.0, 100590.0, 90829.0, 81721.0, 73276.0, 65488.0, 58347.0, 51834.0, 45922.0, 40582.0, 35777.0, 31461.0, 27596.0, 24151.0, 21091.0, 18383.0, 15995.0, 13846.0, 11955.0, 10309.0, 8879.9, 7640.8, 6568.4, 5641.6, 4841.7, 4152.3, 3558.7, 3048.1, 2609.5, 2289.4, 2232.9, 2209.5, 2188.9, 48381.0, 46931.0, 43461.0, 37871.0, 32792.0, 28212.0, 24134.0, 20554.0, 17441.0, 14755.0, 12450.0, 10482.0, 8808.1, 7389.0, 6188.9, 5176.5, 4323.9, 3607.2, 3005.7, 2501.5, 2079.5, 1725.5, 1429.6, 1176.0, 967.44, 795.85, 654.69, 538.58, 443.06, 364.48, 299.84, 246.67, 202.92, 166.94, 137.33, 112.98, 92.946, 76.069, 61.956, 50.461, 41.099, 33.474, 27.264, 22.206, 18.086, 14.731, 11.938, 9.6701, 7.8329, 6.3448, 5.1394, 4.163, 3.3722, 2.7278, 2.1961, 1.768, 1.4234, 1.1459, 0.92254, 0.74271, 0.59793, 0.48138, 0.38755, 0.312, 0.25119, 0.20222, 0.16281, 0.13107, 0.10552, 0.084954, 0.068184, 0.054669, 0.043834, 0.035146, 0.02818, 0.022594, 0.018116, 0.014525, 0.011646, 0.0093381, 0.0074873, 0.0060033, 0.0048135, 0.0038595, 0.0030945, 0.0024812, 0.00199, 0.001597, 0.0012816, 0.0010286, 0.00082544, 0.00066244, 0.00053162, 0.00042664, 0.00034239, 0.00027478, 0.00022052, 0.00017697, 0.00014203, 0.00011398, 9.1472e-05, 7.3409e-05, 5.8913e-05, 4.728e-05, 3.7944e-05, 3.0451e-05, 2.4438e-05, 1.9612e-05, 1.574e-05, 1.2632e-05, 1.0137e-05, 8.1356e-06, 0.0],
                   'energies (keV)': [0.006432, 0.006528, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.0191198, 0.01941245, 0.01948844, 0.01949049, 0.01960755, 0.0199002, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.278124, 0.2811158, 0.282381, 0.2835162, 0.285219, 0.289476, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Pb': {'mass_absorption_coefficient (cm2/g)': [117820.0, 114210.0, 25787.0, 22557.0, 22441.0, 21759.0, 21582.0, 38679.0, 37273.0, 35086.0, 29667.0, 24757.0, 20394.0, 16685.0, 13619.0, 11122.0, 10112.0, 9661.3, 9546.0, 23132.0, 23207.0, 23251.0, 24168.0, 24742.0, 25182.0, 25312.0, 31797.0, 32783.0, 32892.0, 38692.0, 46736.0, 56937.0, 68839.0, 81576.0, 93901.0, 104370.0, 111600.0, 114620.0, 113060.0, 107210.0, 97922.0, 86389.0, 73850.0, 61393.0, 49824.0, 39629.0, 31017.0, 23985.0, 18677.0, 18411.0, 17576.0, 17295.0, 22049.0, 20771.0, 18381.0, 14065.0, 11105.0, 10852.0, 10482.0, 10325.0, 12561.0, 11921.0, 10637.0, 8500.5, 6833.0, 5529.8, 5479.1, 5228.3, 5164.4, 5528.2, 5410.1, 5336.1, 5222.2, 5175.1, 5427.2, 5385.0, 5378.0, 5290.2, 5243.0, 5210.0, 5322.5, 5215.8, 5062.8, 4866.0, 4940.7, 5274.8, 5854.5, 6655.7, 7638.2, 8743.6, 9896.8, 11012.0, 12005.0, 12797.0, 13334.0, 13585.0, 13550.0, 13440.0, 13365.0, 13343.0, 13765.0, 13714.0, 13694.0, 13625.0, 13532.0, 13506.0, 13758.0, 13665.0, 13595.0, 13051.0, 12628.0, 12574.0, 12519.0, 12464.0, 12408.0, 12351.0, 12294.0, 12236.0, 12177.0, 12118.0, 12058.0, 11998.0, 11937.0, 11876.0, 11814.0, 11752.0, 11689.0, 11626.0, 11562.0, 11499.0, 11434.0, 11370.0, 11305.0, 11239.0, 11174.0, 11107.0, 11041.0, 10974.0, 10907.0, 10840.0, 10773.0, 10705.0, 10637.0, 10569.0, 10501.0, 10432.0, 10364.0, 10295.0, 10226.0, 10157.0, 10089.0, 10020.0, 9951.1, 9882.3, 9813.6, 9745.0, 9676.4, 9608.0, 9539.7, 9471.6, 9403.6, 9359.0, 9914.2, 9904.2, 9844.6, 9775.2, 9706.1, 9637.2, 9568.6, 9500.3, 9432.2, 9364.5, 9297.1, 9230.0, 9163.3, 9097.0, 9031.0, 8965.4, 8900.1, 8834.7, 8766.3, 8698.2, 8630.4, 8563.1, 8496.0, 8429.3, 8363.0, 8297.0, 8231.4, 8166.2, 8100.0, 8033.2, 7966.9, 7900.9, 7835.3, 7770.0, 7705.1, 7660.1, 7746.3, 7729.7, 7682.2, 7618.4, 7555.0, 7492.0, 7429.4, 7367.3, 7305.5, 7244.2, 7183.2, 7122.7, 7062.6, 7003.0, 6943.7, 6884.9, 6826.6, 6768.6, 6711.1, 6654.1, 6597.4, 6541.3, 6485.5, 6430.2, 6375.3, 6320.9, 6266.9, 6213.3, 6160.2, 6107.5, 6055.3, 6003.5, 5952.2, 5945.6, 6038.9, 6024.1, 5973.2, 5922.7, 5872.7, 5823.2, 5774.0, 5725.4, 5677.1, 5629.3, 5581.9, 5534.9, 5488.4, 5442.3, 5396.7, 5351.4, 5306.6, 5262.2, 5218.3, 5174.7, 5131.6, 5088.9, 5046.6, 5004.4, 4950.2, 4896.7, 4843.9, 4791.7, 4740.1, 4689.1, 4638.7, 4589.0, 4539.8, 4491.2, 4443.2, 4395.7, 4348.9, 4302.5, 4256.8, 4211.6, 4166.9, 4122.4, 4078.4, 4034.9, 3991.9, 3949.4, 3907.4, 3866.0, 3825.0, 3784.5, 3744.4, 3704.9, 3665.8, 3627.1, 3589.0, 3551.2, 3513.9, 3477.1, 3440.6, 3404.6, 3369.1, 3333.9, 3299.1, 3264.8, 3230.8, 3197.3, 3164.1, 3131.3, 3098.9, 3066.9, 3035.2, 3004.0, 2973.0, 2942.5, 2912.2, 2882.2, 2852.5, 2823.2, 2794.1, 2765.4, 2737.1, 2709.0, 2681.3, 2653.9, 2626.8, 2600.0, 2573.5, 2547.3, 2521.4, 2495.9, 2470.6, 2445.5, 2420.8, 2396.4, 2372.2, 2348.3, 2324.7, 2301.3, 2278.2, 2255.4, 2232.8, 2210.5, 2188.4, 2166.6, 2145.0, 2123.6, 2102.5, 2081.6, 2060.9, 2040.4, 2020.1, 2000.1, 1980.3, 1960.7, 1941.4, 1922.2, 1903.3, 1884.5, 1866.0, 1847.7, 1829.6, 1811.6, 1793.8, 1776.3, 1758.4, 1740.0, 1721.9, 1704.0, 1686.2, 1668.7, 1651.4, 1634.2, 1617.3, 1600.5, 1584.0, 1566.9, 1550.0, 1533.3, 1516.7, 1500.4, 1484.2, 1468.3, 1452.5, 1436.9, 1421.4, 1406.2, 1391.1, 1376.2, 1361.5, 1347.0, 1332.6, 1318.4, 1304.3, 1290.4, 1276.7, 1263.1, 1249.7, 1236.4, 1223.3, 1210.3, 1197.5, 1184.8, 1172.3, 1159.9, 1147.6, 1135.5, 1123.5, 1111.7, 1099.9, 1088.4, 1076.9, 1065.6, 1054.4, 1043.4, 1032.4, 1021.6, 1010.9, 1000.3, 989.89, 979.56, 969.34, 959.24, 949.25, 939.37, 929.6, 919.95, 910.4, 900.95, 891.62, 882.38, 873.25, 864.23, 855.3, 846.47, 837.74, 829.11, 820.57, 812.13, 803.78, 795.53, 787.36, 779.29, 771.3, 763.41, 755.6, 747.88, 745.2, 2132.8, 2118.6, 2092.6, 2067.0, 2041.7, 2016.7, 1992.0, 1967.7, 1943.6, 1934.4, 2816.8, 2799.1, 2763.8, 2729.0, 2694.7, 2660.7, 2627.3, 2594.2, 2561.6, 2529.2, 2497.3, 2465.8, 2434.7, 2404.0, 2373.8, 2343.9, 2314.3, 2285.2, 2256.4, 2228.1, 2200.0, 2172.4, 2145.1, 2118.1, 2091.5, 2065.3, 2039.4, 2013.8, 1988.5, 1963.6, 1939.0, 1913.6, 1888.2, 1863.1, 1838.4, 1827.8, 2136.9, 2132.2, 2103.2, 2074.5, 2046.3, 2018.4, 1990.9, 1963.7, 1937.0, 1910.6, 1884.5, 1859.7, 1835.2, 1811.1, 1787.4, 1764.0, 1741.0, 1718.4, 1696.1, 1674.2, 1652.4, 1631.0, 1609.8, 1589.0, 1568.5, 1548.3, 1528.4, 1508.8, 1489.4, 1470.4, 1452.7, 1451.6, 1543.7, 1534.1, 1514.2, 1494.5, 1475.0, 1455.9, 1437.1, 1418.5, 1400.1, 1382.1, 1364.3, 1347.3, 1330.5, 1313.9, 1297.7, 1281.6, 1267.9, 1265.8, 1310.2, 1305.9, 1290.2, 1274.8, 1259.6, 1244.5, 1229.7, 1215.1, 1200.5, 1186.0, 1171.7, 1157.6, 1143.6, 1129.8, 1116.3, 1102.8, 1089.6, 1076.6, 1063.7, 1050.9, 1038.4, 1026.0, 1013.7, 1001.7, 989.72, 977.93, 966.3, 954.81, 943.46, 932.26, 921.19, 910.27, 899.47, 888.81, 878.28, 867.88, 857.61, 847.43, 837.25, 827.19, 817.25, 807.43, 797.73, 788.15, 778.68, 769.33, 760.09, 750.96, 741.94, 733.03, 724.22, 715.53, 706.76, 698.0, 689.33, 680.76, 672.31, 663.96, 655.72, 647.59, 639.46, 631.37, 623.39, 615.51, 607.74, 600.06, 592.49, 585.02, 577.64, 570.36, 563.18, 556.09, 549.1, 542.19, 535.38, 528.66, 522.02, 515.48, 509.02, 502.64, 496.35, 490.14, 484.02, 477.97, 472.01, 466.12, 460.31, 454.58, 448.93, 443.34, 437.84, 432.4, 427.04, 421.75, 416.5, 411.27, 406.11, 401.01, 395.99, 391.03, 386.14, 381.31, 376.55, 371.85, 367.21, 362.63, 358.12, 353.66, 349.26, 344.93, 340.64, 336.42, 332.25, 328.13, 324.07, 320.07, 316.11, 312.21, 308.36, 304.56, 300.81, 297.11, 293.46, 289.86, 286.28, 282.74, 279.24, 275.8, 272.39, 269.03, 265.72, 262.45, 259.22, 256.03, 252.88, 249.78, 246.72, 243.69, 240.71, 237.76, 234.84, 231.95, 229.09, 226.27, 223.48, 220.72, 218.01, 215.33, 212.68, 210.07, 207.49, 204.95, 202.43, 199.94, 197.48, 195.06, 192.66, 190.3, 187.97, 185.67, 183.4, 159.31, 133.31, 111.74, 93.698, 78.453, 65.761, 63.517, 61.034, 60.396, 154.61, 148.58, 143.25, 119.42, 108.97, 104.53, 103.38, 143.07, 139.96, 137.45, 136.51, 131.0, 129.58, 147.71, 142.24, 136.05, 114.58, 96.409, 81.116, 68.193, 57.342, 48.243, 40.607, 33.92, 28.297, 23.581, 19.613, 16.325, 13.6, 11.337, 9.4586, 7.8974, 6.5988, 5.5177, 4.6109, 3.8521, 3.2195, 2.6838, 2.2356, 1.8581, 1.5898, 1.5362, 1.5225, 1.5053, 7.1232, 6.8582, 6.208, 5.2253, 4.3907, 3.6871, 3.0954, 2.5951, 2.1741, 1.8212, 1.5256, 1.2781, 1.0709, 0.8968, 0.75105, 0.62905, 0.52693, 0.44143, 0.36984, 0.30989, 0.25968, 0.21762, 0.18239, 0.15288, 0.12815, 0.10743, 0.0],
                    'energies (keV)': [0.004936221, 0.005009896, 0.01069, 0.01142761, 0.01145657, 0.01163193, 0.01167869, 0.01174883, 0.01192419, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.018816, 0.019104, 0.0191808, 0.019296, 0.01948844, 0.019584, 0.02083314, 0.021364, 0.021691, 0.0217782, 0.021909, 0.022236, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08428, 0.08458368, 0.08557, 0.085914, 0.08643, 0.08772, 0.09041995, 0.09665893, 0.102704, 0.1033284, 0.104276, 0.1046952, 0.105324, 0.106896, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.135338, 0.1374095, 0.1379619, 0.1387905, 0.140042, 0.140862, 0.1421855, 0.1427571, 0.1436145, 0.1442475, 0.144354, 0.145758, 0.1465635, 0.1471527, 0.1480365, 0.150246, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.404642, 0.4108355, 0.4124871, 0.4149645, 0.4195189, 0.421158, 0.426496, 0.433024, 0.4347648, 0.437376, 0.443904, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64372017, 0.64482097, 0.64527986, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76283052, 0.76398574, 0.76496944, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89230427, 0.89489571, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.4833243, 2.4846756, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5848604, 2.5863394, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0632417, 3.0695584, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5490108, 3.5500321, 3.5593891, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8424209, 3.8449373, 3.8589789, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 12.7745, 12.97002, 13.02216, 13.10038, 13.2959, 13.47697, 14.40688, 14.896, 15.124, 15.1848, 15.276, 15.40095, 15.504, 15.54358, 15.7815, 15.84494, 15.9401, 16.17802, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 86.24441, 87.29069, 87.56448, 87.9165, 88.44452, 89.76459, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Pa': {'mass_absorption_coefficient (cm2/g)': [76785.0, 72702.0, 71344.0, 55780.0, 43536.0, 33887.0, 26354.0, 23733.0, 22416.0, 22081.0, 53980.0, 51096.0, 50867.0, 39131.0, 30222.0, 23768.0, 18962.0, 15297.0, 12445.0, 11501.0, 10989.0, 10859.0, 11754.0, 11204.0, 9130.3, 7477.3, 6156.1, 5087.8, 4217.5, 3505.3, 2921.2, 2441.7, 2048.1, 1878.7, 1807.0, 1788.6, 22261.0, 21839.0, 21499.0, 19570.0, 18885.0, 18673.0, 30263.0, 29360.0, 26358.0, 21817.0, 17066.0, 12831.0, 9450.7, 6928.1, 5117.6, 3843.3, 2951.5, 2761.9, 2614.0, 2576.9, 3568.5, 3415.2, 3328.3, 2773.6, 2361.2, 2073.8, 2053.3, 2013.7, 1998.4, 2479.3, 2397.8, 2238.0, 1960.1, 1747.6, 1582.9, 1562.3, 1531.1, 1523.1, 1635.2, 1606.3, 1574.6, 1465.6, 1429.0, 1408.4, 1403.0, 1523.6, 1529.1, 1537.8, 1539.3, 1548.0, 1554.7, 1665.4, 1727.7, 1976.5, 2977.3, 4659.7, 6726.1, 8683.2, 10102.0, 10792.0, 10795.0, 10284.0, 9862.4, 9665.9, 9612.5, 10427.0, 10357.0, 10225.0, 10105.0, 9888.7, 9830.8, 10265.0, 10051.0, 9925.4, 8948.9, 7997.5, 7108.6, 6445.7, 6304.1, 6270.2, 6222.7, 6592.7, 6402.1, 5928.6, 5222.6, 4755.3, 4616.9, 4602.8, 4581.1, 4596.4, 4465.8, 4095.4, 3767.5, 3653.6, 3624.1, 3648.3, 3543.5, 3178.3, 2744.2, 2371.7, 2051.8, 1777.0, 1541.3, 1338.6, 1165.0, 1015.6, 886.8, 773.82, 661.91, 558.71, 536.64, 516.58, 511.41, 1143.1, 1146.8, 1149.4, 1150.3, 1155.5, 1157.4, 1664.5, 1615.4, 1509.9, 1263.6, 1232.3, 1178.4, 1164.4, 1339.0, 1283.9, 1219.6, 1014.9, 874.89, 850.64, 840.74, 831.97, 872.57, 840.78, 779.2, 766.21, 750.49, 743.1, 764.81, 737.9, 680.49, 579.61, 493.96, 420.51, 356.29, 302.02, 256.41, 217.01, 181.68, 152.23, 127.57, 107.0, 89.897, 75.631, 63.672, 53.605, 45.554, 45.089, 43.802, 43.351, 105.89, 101.89, 94.072, 78.598, 67.39, 65.536, 64.656, 63.952, 89.453, 86.462, 86.054, 83.096, 82.229, 93.62, 90.52, 90.24, 76.485, 64.52, 54.45, 45.69, 38.263, 32.07, 26.873, 22.496, 18.852, 15.795, 13.186, 11.013, 9.2053, 7.7001, 6.4458, 5.4, 4.5272, 3.7983, 3.1848, 2.6644, 2.218, 1.8437, 1.5304, 1.2713, 1.1562, 1.1085, 1.0963, 4.7711, 4.6837, 4.5953, 3.9531, 3.3336, 2.8084, 2.3654, 1.9921, 1.6759, 1.4099, 1.1862, 0.99811, 0.83994, 0.70707, 0.59578, 0.50207, 0.42315, 0.35668, 0.30068, 0.2535, 0.21374, 0.18024, 0.152, 0.0],
                    'energies (keV)': [0.02042217, 0.02072698, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02797422, 0.0284024, 0.02851658, 0.02868785, 0.02908327, 0.02911602, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04454936, 0.04523124, 0.04541307, 0.04568582, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.08745598, 0.08879459, 0.08915156, 0.089687, 0.09041995, 0.09102561, 0.09474531, 0.0961955, 0.09665893, 0.09716228, 0.09861247, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1793891, 0.1821348, 0.182867, 0.1839653, 0.1867111, 0.1883732, 0.2013709, 0.2152655, 0.2289513, 0.2301188, 0.2324557, 0.2333902, 0.2347919, 0.2382963, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.303408, 0.308052, 0.3092904, 0.311148, 0.315792, 0.3212482, 0.3434143, 0.35231, 0.3577025, 0.3591405, 0.3612975, 0.363776, 0.36669, 0.3671099, 0.369344, 0.3708288, 0.373056, 0.378624, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.694036, 0.704659, 0.7074918, 0.711741, 0.7154399, 0.722364, 0.728532, 0.739683, 0.7426566, 0.747117, 0.758268, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.986566, 0.9987612, 1.001667, 1.005693, 1.011734, 1.026834, 1.067676, 1.141345, 1.199814, 1.218179, 1.220098, 1.223076, 1.230422, 1.248786, 1.304285, 1.359358, 1.380164, 1.385713, 1.394281, 1.414842, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.372964, 3.424591, 3.438358, 3.459009, 3.510636, 3.538976, 3.548445, 3.593144, 3.607589, 3.629256, 3.683424, 3.793288, 4.055024, 4.090324, 4.152931, 4.169626, 4.194669, 4.257276, 4.334821, 4.633924, 4.900882, 4.953664, 4.975895, 4.995899, 5.025904, 5.100918, 5.259562, 5.295467, 5.340065, 5.361533, 5.393734, 5.474238, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.39844, 16.46362, 16.64944, 16.71637, 16.81677, 17.06776, 17.59961, 18.81398, 19.90743, 20.11215, 20.21213, 20.29339, 20.41527, 20.68251, 20.71997, 20.99908, 21.0835, 21.21012, 21.49988, 21.52669, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 110.3494, 112.0384, 112.4888, 113.1644, 113.9931, 114.8534, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Pd': {'mass_absorption_coefficient (cm2/g)': [101340.0, 96767.0, 84925.0, 80997.0, 79991.0, 141020.0, 134070.0, 218340.0, 240760.0, 258860.0, 270570.0, 274410.0, 269810.0, 257200.0, 237890.0, 213790.0, 187050.0, 159690.0, 133380.0, 109340.0, 88284.0, 70467.0, 55791.0, 43953.0, 34557.0, 27186.0, 21449.0, 17005.0, 13570.0, 10915.0, 8856.6, 8600.2, 8214.1, 8115.8, 59666.0, 54426.0, 48980.0, 32687.0, 22771.0, 16760.0, 12911.0, 10329.0, 8527.6, 7229.1, 7211.8, 6968.7, 6907.1, 7506.4, 7307.6, 6993.9, 6347.5, 5885.6, 5542.5, 5265.4, 5033.6, 4832.7, 4652.6, 4486.1, 4328.0, 4174.6, 4023.2, 3872.0, 3719.2, 3563.1, 3403.4, 3240.8, 3075.7, 2909.0, 2741.8, 2689.7, 2650.4, 2641.7, 5521.1, 5606.2, 5668.0, 7782.3, 7923.2, 8212.8, 10293.0, 13270.0, 15727.0, 17229.0, 17671.0, 17198.0, 16974.0, 16732.0, 16664.0, 18821.0, 18516.0, 18287.0, 18284.0, 17938.0, 17843.0, 18624.0, 18253.0, 17561.0, 15745.0, 14442.0, 14032.0, 13923.0, 14367.0, 13966.0, 12764.0, 11148.0, 9700.2, 8422.7, 7300.7, 6315.5, 5411.8, 4632.7, 3961.7, 3387.3, 2881.5, 2442.5, 2073.8, 1763.6, 1502.3, 1281.8, 1095.6, 934.21, 793.58, 674.67, 574.1, 488.65, 410.93, 409.22, 392.36, 388.03, 1266.9, 1244.6, 1232.4, 1210.5, 1208.1, 1204.9, 1614.1, 1572.5, 1453.8, 1438.1, 1401.4, 1387.5, 1569.4, 1512.9, 1395.2, 1163.5, 969.95, 812.54, 682.1, 573.89, 483.58, 407.73, 343.24, 287.6, 240.78, 201.54, 168.85, 141.25, 117.24, 97.364, 80.88, 67.247, 55.966, 46.594, 38.737, 32.152, 26.611, 22.021, 18.24, 15.122, 12.548, 10.421, 9.3898, 9.003, 8.9036, 58.117, 57.488, 55.802, 48.085, 40.368, 33.786, 28.215, 23.507, 19.587, 16.324, 13.605, 11.34, 9.4536, 7.8418, 6.4942, 5.3787, 4.4551, 3.6905, 3.0569, 2.5322, 2.0936, 1.7259, 1.4229, 1.1731, 0.96708, 0.79636, 0.65582, 0.54011, 0.44484, 0.3664, 0.3018, 0.2486, 0.20479, 0.16871, 0.13899, 0.11451, 0.094349, 0.077739, 0.064056, 0.052783, 0.043496, 0.035844, 0.029539, 0.024344, 0.020064, 0.016536, 0.0],
                    'energies (keV)': [0.005043505, 0.005118781, 0.005337699, 0.005419399, 0.005441185, 0.005473865, 0.005555565, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.050078, 0.0508445, 0.0510489, 0.0513555, 0.052122, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.084672, 0.085968, 0.0863136, 0.086832, 0.088128, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.328006, 0.3332, 0.3343653, 0.3363735, 0.3383, 0.33966, 0.3417, 0.3434143, 0.3468, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.52087, 0.5288425, 0.5309685, 0.5341575, 0.54213, 0.5478508, 0.547918, 0.5563045, 0.5585409, 0.5618955, 0.570282, 0.5856525, 0.6260625, 0.656502, 0.6665505, 0.6692609, 0.6732495, 0.683298, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.109834, 3.157434, 3.170127, 3.189167, 3.236766, 3.263694, 3.313649, 3.319406, 3.32697, 3.346952, 3.396906, 3.532214, 3.548445, 3.586279, 3.600696, 3.622322, 3.676386, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 23.86329, 24.22855, 24.32595, 24.47205, 24.56923, 24.83731, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Cd': {'mass_absorption_coefficient (cm2/g)': [99114.0, 92377.0, 54375.0, 47747.0, 47432.0, 51600.0, 59801.0, 72145.0, 88882.0, 110090.0, 135380.0, 163670.0, 193100.0, 221140.0, 244940.0, 261880.0, 270030.0, 268640.0, 258140.0, 240050.0, 216540.0, 190010.0, 162610.0, 136230.0, 112180.0, 91154.0, 73356.0, 58663.0, 46761.0, 37256.0, 35751.0, 33958.0, 33500.0, 51853.0, 48611.0, 45642.0, 34421.0, 26579.0, 21090.0, 17104.0, 14136.0, 11884.0, 11309.0, 10907.0, 10805.0, 11472.0, 11120.0, 10974.0, 9644.5, 8594.9, 7749.3, 7056.6, 6478.6, 5986.9, 5571.4, 5273.3, 5002.6, 4751.5, 4514.3, 4286.7, 4065.9, 3849.3, 3634.7, 3422.2, 3212.3, 3005.6, 2802.9, 2778.7, 2733.4, 2728.9, 2721.5, 9860.0, 9920.8, 9957.7, 14875.0, 14907.0, 15157.0, 15191.0, 16413.0, 17189.0, 17083.0, 16356.0, 15193.0, 14561.0, 14242.0, 14157.0, 15999.0, 15756.0, 15653.0, 15325.0, 14968.0, 14874.0, 15529.0, 15175.0, 14977.0, 13350.0, 12041.0, 11732.0, 11685.0, 11592.0, 11970.0, 11627.0, 10740.0, 9382.3, 8178.0, 7120.8, 6125.7, 5249.4, 4492.2, 3840.9, 3279.9, 2800.8, 2392.3, 2032.1, 1723.9, 1464.9, 1246.7, 1062.8, 907.47, 774.22, 658.27, 559.84, 470.84, 391.53, 347.52, 333.37, 329.74, 1120.3, 1115.2, 1076.6, 1045.9, 1008.9, 998.77, 1356.7, 1314.9, 1307.8, 1196.7, 1150.2, 1138.2, 1291.9, 1278.4, 1244.6, 1078.8, 908.63, 763.98, 642.2, 539.55, 453.55, 381.42, 320.91, 269.57, 226.03, 189.41, 158.41, 131.42, 109.13, 90.706, 75.447, 62.766, 52.257, 43.551, 36.299, 30.175, 25.061, 20.747, 17.192, 14.258, 11.836, 9.8338, 8.2533, 8.1777, 7.9149, 7.8279, 49.766, 47.787, 44.016, 36.824, 30.857, 25.874, 21.618, 18.035, 15.037, 12.53, 10.438, 8.6932, 7.2273, 5.99, 4.9649, 4.1156, 3.4119, 2.8287, 2.3415, 1.9318, 1.5938, 1.3151, 1.0851, 0.89548, 0.73849, 0.60893, 0.50213, 0.41408, 0.34149, 0.28164, 0.23229, 0.19159, 0.15803, 0.13036, 0.10754, 0.088712, 0.073187, 0.06038, 0.049817, 0.041103, 0.033914, 0.027984, 0.023092, 0.019055, 0.0],
                    'energies (keV)': [0.0093465, 0.009486, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.065562, 0.0665655, 0.0668331, 0.0672345, 0.068238, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.105448, 0.107062, 0.1074924, 0.108138, 0.109752, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.395626, 0.4016815, 0.40229, 0.4032963, 0.4057185, 0.4084475, 0.4100895, 0.411774, 0.4125525, 0.41871, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.60417, 0.6134175, 0.6158835, 0.6195825, 0.6260625, 0.62883, 0.637686, 0.6474465, 0.6500493, 0.6539535, 0.663714, 0.6692609, 0.7154399, 0.754796, 0.7648052, 0.766349, 0.7694298, 0.774051, 0.785604, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.46675, 3.519812, 3.533962, 3.548445, 3.555187, 3.60825, 3.65246, 3.708365, 3.723273, 3.745635, 3.793288, 3.80154, 3.93764, 3.99791, 4.013982, 4.03809, 4.055024, 4.09836, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.17698, 26.2645, 26.57764, 26.68449, 26.84476, 27.24542, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Po': {'mass_absorption_coefficient (cm2/g)': [126860.0, 122300.0, 63243.0, 61432.0, 60965.0, 160760.0, 156920.0, 91275.0, 80886.0, 71265.0, 62391.0, 54260.0, 46870.0, 40212.0, 37436.0, 36094.0, 35746.0, 44854.0, 43380.0, 42937.0, 35615.0, 29205.0, 23924.0, 19578.0, 16005.0, 13072.0, 10668.0, 8701.4, 7321.7, 7095.1, 6989.4, 6904.1, 12346.0, 13327.0, 17275.0, 33293.0, 61867.0, 98350.0, 133170.0, 156430.0, 162990.0, 153940.0, 134370.0, 110290.0, 86400.0, 65438.0, 48446.0, 35388.0, 25704.0, 18685.0, 13870.0, 13665.0, 12932.0, 12696.0, 15872.0, 14878.0, 13076.0, 9889.9, 7616.6, 6523.2, 6182.7, 6096.8, 7854.1, 7833.3, 7444.4, 6285.6, 5115.0, 4226.6, 3547.8, 3487.7, 3410.5, 3360.1, 3327.7, 3555.4, 3538.5, 3664.1, 3638.1, 3593.4, 3576.6, 3746.9, 3746.8, 3723.4, 3769.7, 4135.3, 4829.1, 5826.6, 7067.4, 8455.8, 9873.5, 11198.0, 12321.0, 13162.0, 13674.0, 13848.0, 13703.0, 13278.0, 12973.0, 12820.0, 12778.0, 13378.0, 13304.0, 13232.0, 13076.0, 12911.0, 12867.0, 12860.0, 13240.0, 13200.0, 13147.0, 13093.0, 13039.0, 12984.0, 12929.0, 12874.0, 12818.0, 12761.0, 12704.0, 12646.0, 12588.0, 12529.0, 12470.0, 12410.0, 12350.0, 12289.0, 12228.0, 12166.0, 12104.0, 12042.0, 11979.0, 11915.0, 11851.0, 11787.0, 11723.0, 11657.0, 11592.0, 11526.0, 11460.0, 11394.0, 11327.0, 11260.0, 11193.0, 11126.0, 11059.0, 10991.0, 10924.0, 10856.0, 10788.0, 10720.0, 10651.0, 10583.0, 10514.0, 10446.0, 10377.0, 10308.0, 10240.0, 10171.0, 10102.0, 10033.0, 9964.8, 9896.1, 9827.5, 9758.9, 9690.4, 9622.0, 9553.7, 9485.5, 9417.4, 9349.5, 9281.7, 9214.0, 9146.4, 9079.0, 9011.7, 8944.5, 8877.6, 8835.9, 9365.6, 9355.0, 9296.9, 9228.3, 9159.9, 9091.8, 9023.8, 8956.2, 8888.8, 8821.6, 8754.8, 8688.2, 8622.0, 8556.1, 8490.5, 8425.2, 8360.3, 8295.8, 8231.6, 8167.8, 8104.4, 8041.4, 7978.7, 7916.5, 7854.7, 7793.2, 7732.2, 7669.7, 7606.9, 7544.5, 7482.5, 7420.9, 7359.6, 7298.8, 7238.4, 7178.4, 7118.8, 7059.6, 6999.8, 6980.2, 7040.8, 7036.3, 6976.8, 6917.8, 6859.1, 6800.9, 6743.0, 6685.6, 6628.6, 6572.1, 6515.9, 6460.2, 6404.9, 6350.1, 6295.7, 6241.7, 6188.1, 6135.0, 6082.4, 6030.2, 5978.4, 5927.0, 5876.1, 5825.7, 5775.7, 5726.1, 5676.9, 5628.3, 5580.0, 5532.2, 5484.8, 5437.9, 5402.5, 5391.4, 5494.4, 5461.4, 5401.1, 5341.5, 5282.7, 5224.6, 5167.2, 5110.5, 5054.4, 4999.1, 4944.4, 4890.4, 4837.0, 4784.3, 4732.2, 4680.8, 4630.0, 4579.7, 4530.1, 4481.1, 4432.7, 4385.0, 4337.8, 4291.2, 4245.1, 4199.6, 4154.7, 4110.3, 4066.4, 4023.1, 3980.2, 3937.9, 3896.1, 3854.8, 3814.0, 3773.7, 3733.8, 3694.1, 3654.8, 3616.0, 3577.6, 3539.7, 3502.3, 3465.3, 3428.7, 3392.5, 3356.8, 3321.5, 3286.6, 3252.2, 3218.1, 3184.4, 3151.1, 3118.2, 3085.7, 3053.6, 3021.9, 2990.5, 2959.5, 2928.8, 2898.5, 2868.6, 2839.0, 2809.7, 2780.8, 2752.2, 2724.0, 2696.0, 2668.4, 2641.2, 2614.2, 2587.5, 2561.2, 2535.1, 2509.3, 2483.7, 2458.4, 2433.3, 2408.6, 2384.1, 2359.9, 2335.9, 2312.3, 2288.9, 2265.7, 2242.9, 2220.3, 2197.9, 2175.8, 2153.9, 2132.3, 2110.9, 2089.8, 2068.9, 2048.3, 2027.8, 2007.6, 1987.7, 1967.9, 1948.4, 1929.0, 1909.9, 1891.0, 1872.4, 1853.9, 1835.6, 1817.5, 1799.5, 1781.8, 1764.2, 1746.8, 1729.6, 1712.6, 1695.8, 1679.2, 1662.8, 1646.5, 1630.4, 1614.5, 1598.8, 1583.2, 1567.8, 1552.6, 1537.5, 1522.6, 1507.8, 1493.2, 1478.8, 1464.5, 1450.3, 1435.4, 1420.6, 1405.9, 1391.5, 1377.2, 1363.0, 1349.1, 1335.2, 1321.6, 1308.1, 1294.7, 1280.9, 1267.2, 1253.7, 1240.3, 1227.1, 1214.1, 1201.2, 1188.4, 1175.8, 1163.3, 1151.0, 1138.8, 1126.7, 1114.8, 1103.0, 1091.4, 1079.9, 1068.5, 1057.2, 1046.1, 1035.1, 1024.2, 1013.5, 1002.8, 992.34, 981.94, 971.67, 961.51, 951.46, 941.53, 931.71, 921.99, 912.39, 902.89, 893.48, 884.19, 874.99, 865.9, 856.91, 848.03, 839.24, 830.54, 821.95, 813.45, 805.05, 796.73, 788.51, 780.39, 772.35, 764.4, 756.54, 748.76, 741.08, 733.47, 725.96, 718.52, 711.17, 703.89, 698.13, 1953.3, 1951.1, 1926.7, 1902.6, 1878.8, 1855.3, 1832.1, 1809.2, 1786.6, 1764.3, 1759.6, 2558.1, 2535.8, 2502.8, 2470.2, 2438.0, 2406.2, 2374.9, 2344.0, 2313.5, 2283.4, 2253.7, 2224.4, 2195.5, 2167.0, 2138.9, 2110.4, 2082.1, 2054.3, 2026.8, 1999.8, 1973.1, 1946.8, 1920.9, 1895.4, 1870.2, 1845.4, 1821.0, 1796.8, 1772.9, 1749.4, 1726.2, 1703.4, 1680.8, 1658.6, 1653.1, 1937.2, 1929.1, 1902.9, 1877.0, 1851.5, 1826.3, 1801.5, 1777.0, 1752.9, 1729.1, 1705.6, 1683.3, 1661.4, 1639.6, 1618.2, 1597.2, 1576.5, 1556.1, 1536.0, 1516.2, 1496.7, 1477.3, 1458.1, 1439.3, 1420.7, 1402.4, 1384.4, 1366.6, 1349.1, 1331.9, 1314.9, 1298.1, 1295.0, 1378.6, 1374.3, 1356.3, 1338.5, 1321.0, 1303.7, 1286.7, 1269.9, 1253.4, 1237.1, 1221.0, 1205.6, 1190.5, 1175.7, 1161.0, 1148.7, 1146.6, 1187.3, 1183.0, 1168.7, 1154.6, 1140.7, 1127.0, 1113.5, 1100.2, 1086.8, 1073.6, 1060.5, 1047.6, 1034.9, 1022.4, 1010.1, 997.86, 985.83, 973.95, 962.23, 950.67, 939.25, 927.99, 916.87, 905.89, 895.06, 884.36, 873.8, 863.38, 853.08, 842.92, 832.88, 822.97, 813.19, 803.53, 793.98, 784.56, 775.25, 766.06, 756.98, 747.86, 738.85, 729.94, 721.15, 712.45, 703.87, 695.39, 687.01, 678.73, 670.56, 662.48, 654.5, 646.62, 638.8, 630.88, 623.05, 615.31, 607.68, 600.14, 592.69, 585.35, 578.09, 570.83, 563.64, 556.54, 549.53, 542.62, 535.79, 529.06, 522.41, 515.85, 509.37, 502.98, 496.68, 490.45, 484.31, 478.25, 472.27, 466.36, 460.54, 454.79, 449.11, 443.51, 437.99, 432.53, 427.15, 421.84, 416.6, 411.43, 406.33, 401.29, 396.32, 391.42, 386.58, 381.8, 377.06, 372.34, 367.69, 363.1, 358.57, 354.1, 349.69, 345.34, 341.05, 336.81, 332.63, 328.5, 324.43, 320.41, 316.45, 312.53, 308.67, 304.86, 301.1, 297.39, 293.73, 290.11, 286.55, 283.03, 279.55, 276.13, 272.74, 269.41, 266.11, 262.86, 259.65, 256.47, 253.32, 250.21, 247.14, 244.11, 241.12, 238.17, 235.26, 232.38, 229.55, 226.75, 223.98, 221.25, 218.56, 215.9, 213.27, 210.67, 208.1, 205.57, 203.07, 200.6, 174.36, 145.84, 122.15, 102.48, 86.059, 72.153, 60.558, 59.851, 57.521, 56.922, 144.11, 138.51, 130.5, 108.78, 99.363, 95.313, 94.271, 130.65, 127.75, 125.59, 124.96, 119.99, 118.71, 135.3, 130.32, 124.38, 104.8, 88.203, 74.233, 62.451, 52.559, 44.26, 37.038, 30.899, 25.804, 21.521, 17.912, 14.919, 12.436, 10.375, 8.6609, 7.2357, 6.0496, 5.0616, 4.2312, 3.5372, 2.9586, 2.4686, 2.053, 1.6981, 1.4977, 1.4347, 1.4185, 6.6541, 6.6076, 6.3622, 5.6085, 4.7218, 3.969, 3.3347, 2.8013, 2.3495, 1.9699, 1.6515, 1.3847, 1.161, 0.9736, 0.81633, 0.68455, 0.57411, 0.48153, 0.40392, 0.33886, 0.2843, 0.23855, 0.20018, 0.16799, 0.14099, 0.11834, 0.0],
                    'energies (keV)': [0.005421745, 0.005502667, 0.007408549, 0.007521945, 0.007552184, 0.007597543, 0.007710939, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01644213, 0.01669379, 0.0167609, 0.01686157, 0.01705382, 0.01711323, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.030772, 0.03109002, 0.031243, 0.0313686, 0.031557, 0.032028, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09634786, 0.09665893, 0.09782257, 0.09821583, 0.09880571, 0.1002804, 0.1033284, 0.1104581, 0.1180797, 0.1231813, 0.1250667, 0.1255695, 0.1262272, 0.1263237, 0.1282091, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1659746, 0.1674882, 0.168515, 0.1691924, 0.1702086, 0.1707354, 0.1718369, 0.172749, 0.1744671, 0.1751685, 0.1762144, 0.1762205, 0.1788507, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.463932, 0.471033, 0.4729266, 0.475767, 0.4794098, 0.482868, 0.490196, 0.497699, 0.4996998, 0.5, 0.50056912, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70406938, 0.70538832, 0.70593058, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.84973202, 0.852268, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99395634, 0.99514537, 0.99664365, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6822596, 2.6837406, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.7971803, 2.7988199, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.2982348, 3.305565, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.8485501, 3.8596499, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1406035, 4.1436226, 4.158197, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 13.53752, 13.74473, 13.79999, 13.88287, 14.09008, 14.40688, 15.40095, 15.91941, 16.16308, 16.22806, 16.32552, 16.46362, 16.56919, 16.60051, 16.8546, 16.92236, 17.024, 17.27809, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 91.2429, 92.63948, 93.0119, 93.31374, 93.57053, 94.9671, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Pm': {'mass_absorption_coefficient (cm2/g)': [6580.8, 6918.1, 7277.5, 7661.6, 8072.6, 8512.4, 8982.6, 9481.4, 10006.0, 10554.0, 11060.0, 11124.0, 11192.0, 11227.0, 214750.0, 204070.0, 181600.0, 145040.0, 114960.0, 90865.0, 72251.0, 58252.0, 47927.0, 40418.0, 37455.0, 36277.0, 35981.0, 35715.0, 35180.0, 34709.0, 31348.0, 28632.0, 26709.0, 25343.0, 24365.0, 23648.0, 23105.0, 22671.0, 22301.0, 21962.0, 20889.0, 19608.0, 18337.0, 17078.0, 16444.0, 16351.0, 16258.0, 16166.0, 16074.0, 15982.0, 15890.0, 15798.0, 15707.0, 15615.0, 15524.0, 15433.0, 15342.0, 15251.0, 15160.0, 15070.0, 14979.0, 14889.0, 14799.0, 14709.0, 14620.0, 14530.0, 14441.0, 14352.0, 14263.0, 14175.0, 14086.0, 13998.0, 13910.0, 13822.0, 13735.0, 13647.0, 13560.0, 13473.0, 13387.0, 13300.0, 13214.0, 13128.0, 13111.0, 73387.0, 70092.0, 65987.0, 62165.0, 58607.0, 55294.0, 52209.0, 49335.0, 46658.0, 44164.0, 41841.0, 39675.0, 37656.0, 35774.0, 34019.0, 32382.0, 30855.0, 29430.0, 28100.0, 26859.0, 25702.0, 24641.0, 23669.0, 22775.0, 21953.0, 21196.0, 20495.0, 19847.0, 19247.0, 18689.0, 18169.0, 17685.0, 17232.0, 16809.0, 16412.0, 16039.0, 15689.0, 15358.0, 15047.0, 14752.0, 14473.0, 14208.0, 13957.0, 13718.0, 13490.0, 13273.0, 13066.0, 12867.0, 12677.0, 12495.0, 12320.0, 12151.0, 11989.0, 11833.0, 11683.0, 11537.0, 11397.0, 11261.0, 11129.0, 11001.0, 10878.0, 10757.0, 10641.0, 10527.0, 10416.0, 10309.0, 10204.0, 10101.0, 10002.0, 9904.3, 9809.1, 9716.1, 9625.2, 9536.3, 9449.2, 9364.0, 9280.6, 9198.8, 9118.7, 9040.1, 8963.0, 8887.5, 8813.3, 8740.5, 8669.0, 8598.8, 8529.9, 8462.2, 8395.6, 8330.2, 8266.0, 8202.8, 8140.7, 8079.6, 8019.6, 7960.5, 7902.4, 7845.3, 7789.1, 7733.9, 7679.5, 7626.0, 7573.4, 7521.6, 7470.7, 7420.6, 7371.3, 7322.8, 7275.1, 7228.2, 7182.0, 7136.6, 7092.0, 7048.0, 7004.8, 6962.3, 6920.5, 6879.4, 6839.0, 6799.3, 6760.2, 6721.8, 6684.1, 6647.0, 6610.5, 6574.7, 6539.5, 6504.9, 6470.9, 6437.6, 6404.8, 6372.6, 6341.0, 6309.9, 6279.5, 6249.6, 6248.3, 7506.9, 7484.9, 7454.7, 7425.1, 7396.0, 7367.4, 7339.3, 7311.8, 7284.7, 7258.2, 7232.1, 7206.6, 7181.5, 7156.9, 7132.7, 7109.0, 7107.1, 7477.3, 7462.1, 7439.1, 7416.6, 7394.6, 7372.9, 7351.6, 7330.7, 7310.2, 7290.0, 7270.1, 7250.6, 7231.4, 7212.6, 7194.0, 7175.8, 7157.8, 7140.2, 7122.8, 7105.7, 7088.9, 7072.3, 7056.0, 7039.9, 7024.0, 7008.3, 6992.9, 6977.7, 6962.6, 6947.8, 6933.1, 6918.6, 6904.3, 6890.1, 6876.0, 6862.1, 6848.3, 6834.7, 6821.1, 6807.7, 6794.3, 6781.1, 6767.9, 6754.8, 6741.7, 6728.7, 6715.8, 6702.9, 6690.0, 6677.2, 6664.3, 6651.5, 6638.7, 6633.3, 7086.4, 7084.0, 7069.9, 7055.7, 7041.5, 7027.3, 7013.0, 6998.7, 6984.4, 6970.0, 6955.5, 6940.9, 6926.3, 6911.6, 6896.8, 6881.9, 6867.0, 6851.9, 6836.7, 6821.4, 6806.0, 6790.4, 6774.7, 6758.8, 6742.8, 6726.7, 6710.3, 6693.8, 6677.2, 6660.4, 6643.4, 6626.2, 6608.8, 6591.3, 6573.5, 6555.6, 6537.5, 6519.2, 6500.7, 6482.0, 6463.0, 6443.9, 6424.6, 6405.0, 6385.3, 6365.4, 6345.3, 6324.9, 6304.4, 6283.7, 6262.8, 6241.7, 6220.4, 6198.8, 6177.1, 6155.2, 6133.1, 6110.9, 6088.4, 6065.7, 6042.9, 6019.8, 5996.6, 5973.2, 5949.6, 5925.8, 5901.8, 5877.7, 5853.4, 5829.0, 5804.3, 5779.5, 5754.6, 5729.4, 5704.2, 5678.7, 5653.1, 5627.4, 5601.5, 5575.3, 5549.0, 5522.5, 5495.8, 5469.0, 5441.9, 5414.8, 5387.4, 5360.0, 5332.3, 5304.6, 5276.7, 5248.7, 5220.5, 5192.3, 5163.9, 5135.5, 5106.9, 5078.3, 5049.5, 5020.7, 4991.8, 4962.8, 4933.8, 4904.7, 4875.6, 4846.4, 4817.2, 4787.9, 4758.6, 4729.3, 4699.9, 4670.5, 4641.1, 4611.8, 4582.4, 4553.0, 4523.6, 4494.2, 4464.8, 4435.5, 4406.1, 4376.8, 4347.6, 4318.3, 4289.2, 4260.0, 4230.9, 4201.9, 4172.9, 4143.9, 4115.1, 4086.2, 4057.5, 4028.8, 4000.2, 3971.7, 3943.3, 3914.9, 3886.7, 3858.5, 3830.4, 3802.4, 3774.5, 3746.8, 3719.1, 3691.5, 3664.0, 3636.7, 3609.4, 3582.3, 3555.2, 3528.3, 3501.6, 3474.9, 3448.3, 3421.9, 3395.6, 3369.4, 3343.3, 3317.4, 3291.6, 3266.0, 3240.4, 3215.0, 3189.8, 3164.7, 3139.7, 3114.9, 3090.2, 3065.6, 3041.2, 3016.9, 2992.8, 2968.8, 2945.0, 2921.3, 2897.7, 2874.3, 2851.1, 2827.9, 2805.0, 2782.2, 2759.5, 2737.0, 2714.6, 2692.4, 2670.3, 2648.3, 2626.6, 2604.9, 2583.4, 2562.1, 2540.9, 2519.8, 2498.9, 2478.2, 2457.6, 2437.1, 2416.8, 2396.6, 2376.6, 2356.7, 2337.0, 2317.4, 2298.0, 2278.7, 2259.5, 2240.5, 2221.6, 2202.9, 2184.3, 2165.8, 2147.5, 2129.4, 2111.3, 2093.4, 2075.7, 2058.1, 2040.6, 2023.2, 2006.0, 1989.0, 1972.0, 1954.0, 1933.6, 1913.4, 1893.4, 1873.5, 1854.3, 7497.3, 7496.3, 7402.5, 7309.0, 7216.7, 7125.5, 7061.9, 10677.0, 10645.0, 10509.0, 10375.0, 10242.0, 10111.0, 9982.3, 9854.9, 9729.1, 9604.9, 9482.3, 9361.3, 9241.9, 9124.0, 9007.6, 8892.8, 8779.4, 8667.4, 8556.9, 8447.9, 8340.2, 8234.0, 8129.0, 8025.5, 7923.3, 7822.4, 7722.8, 7624.5, 7527.4, 7431.6, 7337.0, 7243.7, 7151.5, 7060.5, 6970.7, 6882.1, 6794.6, 6708.2, 6623.0, 6538.8, 6455.7, 6373.7, 6292.7, 6212.8, 6133.9, 6056.0, 5979.2, 5903.2, 5828.2, 5754.4, 5681.9, 5610.3, 5559.5, 6485.4, 6485.1, 6400.4, 6316.6, 6234.1, 6152.6, 6072.3, 5993.0, 5914.8, 5837.7, 5761.5, 5688.5, 5618.6, 5549.8, 5482.2, 5415.6, 5350.0, 5288.2, 5285.5, 5635.2, 5582.9, 5514.4, 5446.9, 5380.5, 5315.0, 5250.6, 5187.0, 5124.4, 5062.8, 5002.4, 4944.4, 4887.2, 4831.0, 4775.6, 4721.1, 4667.3, 4614.4, 4562.3, 4510.9, 4460.3, 4410.4, 4361.2, 4342.9, 4523.5, 4519.4, 4469.8, 4420.8, 4372.5, 4324.9, 4277.9, 4231.4, 4185.6, 4140.4, 4095.7, 4051.7, 4008.3, 3965.5, 3923.2, 3880.7, 3838.1, 3796.0, 3754.4, 3713.3, 3672.7, 3632.6, 3592.8, 3553.6, 3514.8, 3476.4, 3438.4, 3400.9, 3363.8, 3327.1, 3290.8, 3254.7, 3218.6, 3182.9, 3147.5, 3112.6, 3078.0, 3043.8, 3009.9, 2976.5, 2943.4, 2910.6, 2878.2, 2846.2, 2814.5, 2783.1, 2751.2, 2719.6, 2688.3, 2657.5, 2626.8, 2596.0, 2565.6, 2535.6, 2505.8, 2476.3, 2447.1, 2418.3, 2389.9, 2361.7, 2333.9, 2306.5, 2279.3, 2252.5, 2225.9, 2199.4, 2173.2, 2147.3, 2121.6, 2096.3, 2071.3, 2046.6, 2022.2, 1998.1, 1974.3, 1950.8, 1927.5, 1904.6, 1881.9, 1859.5, 1837.4, 1815.6, 1794.0, 1772.7, 1751.7, 1730.9, 1710.4, 1690.1, 1670.1, 1650.3, 1630.8, 1611.5, 1592.5, 1573.7, 1555.2, 1536.8, 1518.7, 1500.9, 1483.2, 1465.8, 1448.6, 1431.6, 1414.6, 1397.8, 1381.2, 1364.9, 1348.7, 1332.7, 1317.0, 1301.4, 1286.1, 1270.9, 1255.9, 1241.1, 1226.5, 1212.1, 1197.8, 1183.8, 1169.8, 1156.0, 1142.3, 1128.8, 1114.1, 1099.7, 1085.4, 1071.4, 1057.5, 1043.8, 1030.3, 1017.0, 1003.9, 990.93, 978.15, 965.55, 953.12, 940.86, 928.76, 916.82, 905.05, 893.43, 881.95, 870.59, 859.38, 848.32, 837.41, 826.65, 816.04, 805.56, 795.23, 785.03, 774.97, 765.05, 755.26, 745.6, 736.07, 726.67, 717.39, 708.24, 699.21, 690.3, 681.51, 672.84, 664.28, 655.84, 647.51, 639.29, 631.18, 623.18, 615.28, 607.49, 599.8, 592.21, 584.73, 577.34, 570.05, 562.86, 555.77, 548.76, 541.85, 519.31, 438.81, 369.95, 311.2, 262.23, 221.39, 186.82, 166.39, 159.98, 158.31, 472.57, 467.56, 446.88, 394.16, 387.37, 377.83, 373.66, 512.03, 490.46, 466.28, 446.33, 441.76, 503.14, 484.56, 435.94, 368.82, 310.67, 259.76, 217.08, 181.56, 152.0, 127.36, 106.5, 88.903, 74.037, 61.614, 51.32, 42.784, 35.699, 29.814, 24.919, 20.845, 17.454, 14.516, 12.019, 9.9491, 8.2058, 6.7684, 5.5857, 4.6133, 3.9399, 3.8132, 3.773, 3.7301, 21.537, 20.734, 18.793, 15.773, 13.221, 11.076, 9.2594, 7.7388, 6.4675, 5.4046, 4.5102, 3.7529, 3.1174, 2.5845, 2.1429, 1.7769, 1.4736, 1.2221, 1.0136, 0.8408, 0.69749, 0.57865, 0.48009, 0.39835, 0.33143, 0.27586, 0.22962, 0.19114, 0.15912, 0.13247, 0.11029, 0.091832, 0.076466, 0.063674, 0.053024, 0.044158, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.020678, 0.02083314, 0.0209945, 0.0210789, 0.0212055, 0.021522, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03675, 0.0373125, 0.0374625, 0.0376875, 0.03797993, 0.03825, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12038579, 0.1204142, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23585864, 0.23614137, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25423287, 0.25456716, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33005637, 0.33074361, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0267933, 1.0269536, 1.0270069, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0513391, 1.0516608, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3559325, 1.3578453, 1.3578674, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4703391, 1.4706431, 1.4724609, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6442772, 1.6487228, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.330114, 6.427004, 6.452841, 6.469004, 6.491597, 6.588486, 6.872544, 6.915365, 6.977736, 7.005787, 7.047864, 7.153056, 7.279342, 7.392525, 7.420472, 7.465039, 7.576458, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.28032, 44.79101, 44.95808, 45.13881, 45.40992, 46.08768, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ho': {'mass_absorption_coefficient (cm2/g)': [7039.2, 7283.1, 7559.6, 7870.1, 8216.2, 8599.5, 9021.5, 9483.1, 9985.1, 10528.0, 10703.0, 10835.0, 10871.0, 321370.0, 302910.0, 295610.0, 227140.0, 174640.0, 134230.0, 103870.0, 81485.0, 65200.0, 53485.0, 45140.0, 39258.0, 35165.0, 32368.0, 30509.0, 29328.0, 29177.0, 29000.0, 28957.0, 29040.0, 28905.0, 28787.0, 28462.0, 28387.0, 28485.0, 28698.0, 27892.0, 27010.0, 26095.0, 25140.0, 24141.0, 23615.0, 23536.0, 23458.0, 23379.0, 23301.0, 23221.0, 23142.0, 23062.0, 22983.0, 22903.0, 22822.0, 22742.0, 22661.0, 22580.0, 22499.0, 22418.0, 22336.0, 22254.0, 22172.0, 22090.0, 22008.0, 21925.0, 21842.0, 21759.0, 21676.0, 21593.0, 21510.0, 21426.0, 21342.0, 21258.0, 21174.0, 21090.0, 21005.0, 20920.0, 20836.0, 20751.0, 20666.0, 20580.0, 20495.0, 20410.0, 20324.0, 20238.0, 20152.0, 20066.0, 19980.0, 19894.0, 19808.0, 19722.0, 19635.0, 19549.0, 19462.0, 19375.0, 19288.0, 19201.0, 19114.0, 19027.0, 18940.0, 18853.0, 18766.0, 18679.0, 18591.0, 18504.0, 18417.0, 18329.0, 18242.0, 18154.0, 18067.0, 17979.0, 17892.0, 17804.0, 17717.0, 17629.0, 17542.0, 17454.0, 17367.0, 17279.0, 17192.0, 17105.0, 17017.0, 16930.0, 16842.0, 16755.0, 16668.0, 16581.0, 16494.0, 16407.0, 16320.0, 16233.0, 16146.0, 16059.0, 15972.0, 15886.0, 15799.0, 15713.0, 15626.0, 15540.0, 15506.0, 38113.0, 37489.0, 36090.0, 34770.0, 33524.0, 32347.0, 31235.0, 30184.0, 29191.0, 28252.0, 27364.0, 26524.0, 25729.0, 24976.0, 24264.0, 23589.0, 22949.0, 22343.0, 21768.0, 21222.0, 20704.0, 20220.0, 19768.0, 19346.0, 18952.0, 18582.0, 18234.0, 17907.0, 17598.0, 17307.0, 17030.0, 16768.0, 16520.0, 16283.0, 16057.0, 15841.0, 15635.0, 15437.0, 15247.0, 15065.0, 14890.0, 14721.0, 14558.0, 14400.0, 14248.0, 14100.0, 13957.0, 13818.0, 13683.0, 13552.0, 13424.0, 13299.0, 13178.0, 13059.0, 12943.0, 12830.0, 12719.0, 12611.0, 12505.0, 12400.0, 12298.0, 12198.0, 12100.0, 12003.0, 11908.0, 11815.0, 11723.0, 11632.0, 11543.0, 11456.0, 11369.0, 11284.0, 11201.0, 11118.0, 11036.0, 10956.0, 10877.0, 10799.0, 10721.0, 10645.0, 10570.0, 10495.0, 10422.0, 10350.0, 10278.0, 10207.0, 10137.0, 10068.0, 9999.8, 9932.3, 9865.6, 9799.6, 9734.4, 9669.9, 9606.2, 9543.1, 9480.8, 9419.2, 9358.3, 9298.0, 9238.4, 9179.5, 9121.2, 9063.6, 9006.5, 8950.2, 8894.4, 8839.3, 8784.8, 8730.8, 8677.5, 8624.8, 8572.6, 8521.0, 8470.0, 8419.6, 8369.7, 8320.4, 8271.6, 8223.3, 8175.6, 8128.5, 8081.8, 8035.7, 7990.1, 7945.0, 7900.4, 7856.3, 7812.7, 7769.6, 7750.9, 8702.5, 8695.1, 8651.6, 8608.6, 8566.1, 8524.0, 8482.4, 8441.3, 8400.5, 8360.3, 8320.4, 8281.0, 8242.1, 8203.5, 8165.4, 8127.6, 8090.3, 8053.4, 8016.8, 7980.7, 7944.9, 7909.5, 7874.4, 7839.6, 7832.9, 8064.0, 8051.8, 8017.7, 7983.9, 7950.5, 7917.3, 7884.5, 7851.9, 7819.7, 7787.7, 7756.0, 7724.5, 7693.3, 7662.4, 7631.7, 7601.3, 7571.0, 7541.0, 7511.3, 7481.7, 7452.4, 7423.2, 7394.3, 7365.5, 7336.9, 7308.5, 7280.3, 7252.2, 7224.3, 7196.5, 7168.9, 7141.4, 7114.0, 7086.8, 7059.7, 7032.6, 7005.7, 6978.9, 6952.2, 6925.6, 6899.0, 6872.5, 6846.1, 6819.8, 6793.5, 6767.3, 6741.2, 6715.0, 6694.3, 6689.0, 6983.6, 6967.1, 6940.3, 6913.5, 6886.7, 6859.9, 6833.1, 6806.4, 6779.7, 6752.9, 6726.2, 6699.5, 6672.7, 6646.0, 6619.2, 6592.5, 6565.7, 6538.9, 6512.1, 6485.2, 6458.3, 6431.4, 6404.4, 6377.4, 6350.3, 6323.2, 6296.0, 6268.8, 6241.5, 6214.2, 6186.8, 6159.3, 6131.8, 6104.2, 6076.6, 6048.9, 6021.2, 5993.4, 5965.5, 5937.6, 5909.6, 5881.5, 5853.4, 5825.3, 5797.1, 5768.8, 5740.5, 5712.1, 5683.7, 5655.2, 5626.7, 5598.1, 5569.5, 5540.8, 5512.1, 5483.3, 5454.5, 5425.7, 5396.8, 5367.9, 5339.0, 5310.0, 5281.0, 5251.9, 5222.9, 5193.8, 5164.7, 5135.6, 5106.4, 5077.3, 5048.1, 5018.9, 4989.7, 4960.5, 4931.3, 4902.1, 4872.9, 4843.7, 4814.5, 4785.4, 4756.2, 4726.9, 4697.7, 4668.4, 4639.1, 4609.9, 4580.6, 4551.3, 4522.1, 4492.8, 4463.6, 4434.4, 4405.2, 4376.1, 4346.9, 4317.9, 4288.8, 4259.8, 4230.9, 4202.0, 4173.2, 4144.4, 4115.7, 4087.1, 4058.5, 4030.1, 4001.6, 3973.1, 3944.7, 3916.4, 3888.2, 3860.1, 3832.1, 3804.1, 3776.3, 3748.6, 3721.0, 3693.5, 3666.1, 3638.8, 3611.6, 3584.6, 3557.6, 3530.8, 3504.1, 3477.6, 3451.1, 3424.8, 3398.6, 3372.6, 3346.7, 3320.9, 3295.2, 3269.7, 3244.4, 3219.1, 3194.0, 3169.1, 3144.3, 3119.6, 3095.1, 3070.8, 3046.5, 3022.5, 2998.5, 2974.8, 2951.1, 2927.6, 2904.3, 2881.1, 2858.1, 2835.2, 2812.5, 2789.9, 2767.5, 2745.2, 2723.1, 2701.2, 2679.4, 2657.7, 2636.2, 2614.8, 2593.6, 2572.6, 2551.7, 2530.9, 2510.3, 2487.7, 2460.8, 2434.3, 2408.1, 2382.2, 2356.6, 2331.2, 2306.2, 2281.4, 2257.0, 2232.8, 2208.8, 2185.2, 2161.8, 2138.7, 2115.8, 2093.2, 2070.9, 2048.8, 2027.0, 2005.4, 1984.0, 1962.9, 1942.1, 1921.4, 1901.0, 1880.9, 1860.9, 1841.2, 1821.7, 1802.4, 1783.4, 1764.5, 1745.9, 1727.5, 1709.3, 1691.3, 1673.5, 1655.9, 1638.5, 1621.2, 1604.1, 1586.9, 1569.9, 1553.1, 1536.4, 1520.0, 1503.8, 1487.7, 1471.8, 1456.1, 1440.6, 1425.3, 1410.1, 1395.1, 1380.3, 1365.6, 1351.1, 1336.8, 1322.6, 1308.6, 1308.4, 5003.5, 4945.1, 4882.8, 4821.4, 4760.6, 4700.6, 4649.5, 6997.1, 6993.2, 6904.1, 6816.1, 6729.3, 6643.6, 6559.0, 6475.5, 6393.0, 6311.7, 6231.3, 6152.0, 6073.8, 5996.5, 5920.3, 5845.0, 5770.7, 5697.3, 5624.9, 5553.5, 5482.9, 5413.3, 5344.5, 5276.7, 5209.7, 5143.6, 5078.3, 5013.9, 4950.3, 4887.5, 4825.5, 4764.4, 4704.0, 4644.4, 4585.5, 4527.4, 4470.1, 4413.5, 4357.6, 4302.4, 4247.8, 4193.9, 4140.7, 4088.2, 4036.3, 3985.1, 3952.0, 4622.4, 4618.4, 4560.6, 4499.6, 4439.4, 4380.0, 4321.4, 4263.6, 4206.6, 4150.3, 4094.8, 4041.6, 3990.9, 3941.0, 3891.9, 3843.6, 3796.1, 3749.4, 3703.4, 3658.1, 3613.6, 3589.7, 3824.7, 3822.7, 3774.9, 3727.8, 3681.4, 3635.8, 3590.8, 3546.5, 3502.8, 3459.7, 3417.3, 3376.4, 3336.7, 3297.6, 3259.2, 3221.3, 3184.0, 3147.3, 3111.1, 3075.4, 3040.2, 3014.5, 3005.6, 3130.7, 3112.2, 3077.2, 3042.6, 3008.6, 2974.9, 2941.7, 2909.0, 2876.6, 2844.7, 2813.2, 2782.2, 2751.6, 2721.0, 2690.4, 2660.2, 2630.4, 2600.8, 2571.7, 2542.9, 2514.4, 2486.2, 2458.4, 2430.9, 2403.7, 2376.9, 2350.3, 2324.0, 2298.0, 2272.3, 2246.9, 2221.8, 2197.0, 2172.2, 2147.6, 2123.3, 2099.2, 2075.4, 2051.9, 2028.7, 2005.7, 1982.9, 1960.4, 1938.2, 1916.2, 1894.5, 1873.0, 1851.7, 1830.7, 1809.6, 1788.7, 1768.1, 1747.7, 1727.5, 1707.5, 1687.5, 1667.8, 1648.3, 1629.1, 1610.1, 1591.3, 1572.7, 1554.4, 1536.3, 1518.4, 1500.7, 1483.3, 1466.0, 1449.0, 1432.1, 1413.9, 1395.9, 1378.0, 1360.3, 1342.9, 1325.8, 1308.8, 1292.1, 1275.6, 1259.4, 1243.4, 1227.6, 1212.0, 1196.6, 1181.4, 1166.4, 1151.6, 1137.1, 1122.7, 1108.5, 1094.5, 1080.7, 1067.1, 1053.7, 1040.4, 1027.3, 1014.5, 1001.7, 989.17, 976.74, 964.23, 951.9, 939.73, 927.72, 915.88, 904.2, 892.67, 881.31, 870.09, 859.02, 848.11, 837.34, 826.71, 816.23, 805.89, 795.69, 785.62, 775.69, 765.89, 756.18, 746.5, 736.94, 727.51, 718.2, 709.03, 699.97, 691.04, 661.9, 557.85, 470.38, 397.16, 335.78, 284.26, 240.32, 202.57, 170.99, 144.59, 122.08, 121.8, 117.19, 116.0, 328.76, 313.6, 288.83, 263.37, 253.18, 250.52, 343.74, 336.17, 329.15, 317.74, 303.86, 300.4, 341.94, 328.8, 322.38, 270.49, 227.19, 190.91, 160.07, 134.15, 112.43, 94.263, 78.985, 66.063, 55.244, 46.116, 38.53, 32.22, 26.967, 22.59, 18.79, 15.6, 12.962, 10.78, 8.9566, 7.4375, 6.1627, 5.0968, 4.2158, 3.4893, 2.9219, 2.8902, 2.7996, 2.7681, 15.069, 14.514, 13.43, 11.282, 9.4613, 7.9308, 6.6437, 5.5572, 4.6344, 3.8653, 3.2243, 2.6899, 2.2408, 1.8618, 1.5471, 1.2857, 1.0685, 0.88815, 0.73828, 0.61375, 0.51027, 0.42427, 0.35279, 0.29337, 0.245, 0.20485, 0.1713, 0.14325, 0.1198, 0.1002, 0.083811, 0.070106, 0.058645, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.019894, 0.0201985, 0.0202797, 0.0204015, 0.020706, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.050176, 0.050944, 0.0511488, 0.051456, 0.052224, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16093012, 0.16106987, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.3062977, 0.30690231, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34311527, 0.34388471, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43505516, 0.43550006, 0.43634484, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3512135, 1.3515865, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3911646, 1.3918353, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7394239, 1.7424222, 1.742976, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9208002, 1.9247997, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1244052, 2.1271389, 2.1321947, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 7.909678, 8.030745, 8.063029, 8.111456, 8.232522, 8.44789, 8.739444, 8.873211, 8.908882, 8.962389, 9.030794, 9.096156, 9.206316, 9.347229, 9.384806, 9.441171, 9.582084, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.50534, 54.71721, 55.33961, 55.56208, 55.89579, 56.73005, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Hf': {'mass_absorption_coefficient (cm2/g)': [47938.0, 46879.0, 42624.0, 42740.0, 42314.0, 41310.0, 39738.0, 37645.0, 35117.0, 33036.0, 32365.0, 32263.0, 32186.0, 39787.0, 38711.0, 35577.0, 31132.0, 27222.0, 23752.0, 20691.0, 18035.0, 15782.0, 13926.0, 13203.0, 12873.0, 12790.0, 68213.0, 66178.0, 65464.0, 55158.0, 45911.0, 39752.0, 38026.0, 37821.0, 37584.0, 58709.0, 56445.0, 50347.0, 42569.0, 36054.0, 30862.0, 26982.0, 24283.0, 22579.0, 21849.0, 21696.0, 21669.0, 21661.0, 21788.0, 21690.0, 21550.0, 21649.0, 21972.0, 22403.0, 22853.0, 23259.0, 23435.0, 23458.0, 23481.0, 23503.0, 23524.0, 23545.0, 23565.0, 23584.0, 23603.0, 23621.0, 23638.0, 23654.0, 23670.0, 23685.0, 23699.0, 23713.0, 23726.0, 23738.0, 23749.0, 23759.0, 23769.0, 23778.0, 23786.0, 23793.0, 23800.0, 23805.0, 23810.0, 23814.0, 23818.0, 23820.0, 23822.0, 23823.0, 23823.0, 23822.0, 23821.0, 23818.0, 23815.0, 23811.0, 23807.0, 23801.0, 23795.0, 23788.0, 23780.0, 23771.0, 23762.0, 23751.0, 23740.0, 23728.0, 23716.0, 23702.0, 23688.0, 23673.0, 23658.0, 23641.0, 23624.0, 23606.0, 23587.0, 23568.0, 23548.0, 23527.0, 23505.0, 23483.0, 23460.0, 23436.0, 23412.0, 23387.0, 23361.0, 23334.0, 23307.0, 23279.0, 23251.0, 23222.0, 23192.0, 23161.0, 23130.0, 23098.0, 23066.0, 23033.0, 22999.0, 22965.0, 22930.0, 22895.0, 22859.0, 22822.0, 22785.0, 22747.0, 22709.0, 22670.0, 22631.0, 22591.0, 22550.0, 22509.0, 22468.0, 22426.0, 22383.0, 22340.0, 22297.0, 22253.0, 22209.0, 22164.0, 22119.0, 22073.0, 22027.0, 21980.0, 21933.0, 21886.0, 21838.0, 21790.0, 21741.0, 21692.0, 21643.0, 21593.0, 21543.0, 21492.0, 21442.0, 21390.0, 21339.0, 21287.0, 21235.0, 21183.0, 21130.0, 21077.0, 21024.0, 20970.0, 20916.0, 20862.0, 20808.0, 20753.0, 20698.0, 20643.0, 20588.0, 20532.0, 20477.0, 20421.0, 20365.0, 20308.0, 20252.0, 20195.0, 20138.0, 20081.0, 20024.0, 19966.0, 19909.0, 19851.0, 19793.0, 19735.0, 19677.0, 19619.0, 19560.0, 19502.0, 19443.0, 19385.0, 19326.0, 19320.0, 21973.0, 21891.0, 21755.0, 21621.0, 21489.0, 21359.0, 21231.0, 21105.0, 20981.0, 20859.0, 20816.0, 22603.0, 22547.0, 22373.0, 22202.0, 22035.0, 21871.0, 21710.0, 21552.0, 21397.0, 21245.0, 21095.0, 20949.0, 20806.0, 20667.0, 20532.0, 20400.0, 20271.0, 20146.0, 20023.0, 19903.0, 19786.0, 19671.0, 19561.0, 19453.0, 19348.0, 19245.0, 19145.0, 19048.0, 18953.0, 18860.0, 18769.0, 18680.0, 18593.0, 18507.0, 18423.0, 18341.0, 18260.0, 18181.0, 18103.0, 18026.0, 17950.0, 17876.0, 17803.0, 17730.0, 17659.0, 17589.0, 17520.0, 17452.0, 17385.0, 17318.0, 17253.0, 17181.0, 17105.0, 17030.0, 16955.0, 16882.0, 16809.0, 16736.0, 16665.0, 16594.0, 16523.0, 16454.0, 16384.0, 16316.0, 16242.0, 16166.0, 16090.0, 16015.0, 15940.0, 15866.0, 15792.0, 15719.0, 15646.0, 15570.0, 15453.0, 15337.0, 15222.0, 15108.0, 14995.0, 14882.0, 14771.0, 14660.0, 14550.0, 14440.0, 14332.0, 14224.0, 14117.0, 14010.0, 13905.0, 13800.0, 13696.0, 13593.0, 13490.0, 13388.0, 13288.0, 13187.0, 13088.0, 12989.0, 12891.0, 12794.0, 12697.0, 12602.0, 12506.0, 12412.0, 12319.0, 12226.0, 12134.0, 12076.0, 12865.0, 12853.0, 12772.0, 12681.0, 12590.0, 12499.0, 12410.0, 12321.0, 12232.0, 12145.0, 12058.0, 11972.0, 11886.0, 11801.0, 11717.0, 11634.0, 11551.0, 11469.0, 11387.0, 11306.0, 11226.0, 11146.0, 11067.0, 10989.0, 10911.0, 10833.0, 10757.0, 10681.0, 10605.0, 10575.0, 10716.0, 10714.0, 10640.0, 10566.0, 10493.0, 10420.0, 10348.0, 10277.0, 10206.0, 10135.0, 10065.0, 9995.9, 9927.0, 9858.6, 9790.7, 9723.4, 9656.5, 9590.0, 9524.1, 9458.7, 9393.7, 9329.2, 9265.1, 9201.5, 9138.3, 9075.6, 9013.3, 8951.4, 8889.9, 8828.9, 8768.3, 8708.1, 8648.2, 8588.8, 8529.8, 8471.1, 8412.9, 8355.0, 8297.5, 8240.3, 8183.5, 8127.1, 8071.0, 8065.6, 8260.3, 8245.3, 8189.2, 8133.4, 8077.9, 8022.8, 7968.0, 7913.5, 7859.3, 7805.5, 7752.0, 7698.8, 7645.8, 7593.2, 7540.9, 7488.8, 7437.1, 7385.6, 7334.4, 7283.5, 7232.9, 7182.5, 7132.4, 7082.6, 7033.0, 6983.7, 6934.6, 6885.8, 6837.3, 6789.0, 6741.0, 6693.2, 6645.6, 6598.3, 6551.2, 6504.4, 6457.8, 6411.4, 6365.3, 6319.4, 6273.7, 6228.3, 6183.1, 6138.1, 6093.4, 6048.9, 6004.6, 5960.5, 5916.7, 5873.1, 5829.7, 5786.5, 5743.5, 5700.8, 5658.3, 5616.0, 5573.9, 5532.0, 5490.4, 5448.9, 5407.7, 5366.7, 5325.9, 5285.4, 5245.0, 5204.7, 5164.6, 5124.8, 5085.1, 5045.7, 5006.4, 4967.4, 4928.6, 4890.0, 4851.6, 4813.4, 4775.4, 4737.7, 4700.1, 4662.8, 4625.6, 4588.7, 4552.0, 4515.5, 4479.2, 4443.1, 4407.3, 4371.6, 4336.2, 4300.9, 4265.9, 4231.1, 4196.5, 4162.1, 4127.9, 4093.9, 4060.1, 4026.5, 3993.1, 3959.9, 3926.9, 3894.1, 3861.5, 3829.1, 3796.9, 3764.9, 3733.1, 3701.5, 3670.1, 3638.9, 3607.9, 3577.1, 3546.5, 3516.1, 3486.0, 3456.1, 3426.4, 3396.9, 3367.7, 3338.7, 3309.9, 3281.4, 3253.0, 3225.0, 3197.1, 3166.4, 3130.0, 3094.1, 3058.6, 3023.5, 2988.9, 2954.7, 2921.0, 2887.7, 2854.8, 2822.3, 2790.2, 2758.5, 2727.3, 2696.4, 2665.9, 2635.8, 2606.0, 2576.6, 2547.6, 2519.0, 2490.7, 2462.7, 2435.1, 2407.9, 2380.9, 2354.3, 2328.1, 2302.1, 2276.5, 2251.2, 2226.2, 2201.5, 2177.1, 2153.0, 2129.2, 2105.7, 2082.5, 2059.5, 2036.9, 2014.5, 1992.3, 1970.5, 1948.9, 1927.6, 1906.5, 1885.6, 1865.1, 1844.7, 1824.7, 1804.8, 1785.2, 1765.8, 1746.7, 1727.8, 1709.1, 1690.6, 1672.4, 1654.4, 1636.6, 1619.0, 1601.6, 1584.4, 1567.4, 1550.6, 1534.0, 1517.6, 1501.5, 1485.4, 1469.6, 1454.0, 1438.6, 1423.3, 1408.2, 1393.3, 1378.6, 1364.0, 1349.6, 1335.4, 1321.3, 1307.4, 1293.7, 1280.1, 1266.7, 1253.4, 1240.0, 1226.8, 1213.8, 1200.9, 1188.1, 1175.5, 1163.1, 1150.8, 1138.6, 1126.6, 1114.7, 1103.0, 1091.4, 1079.9, 1068.6, 1057.4, 1046.3, 1041.3, 3693.8, 3672.2, 3627.1, 3582.7, 3538.8, 3495.5, 3452.7, 3413.8, 5094.3, 5091.4, 5031.3, 4969.1, 4907.7, 4847.0, 4787.0, 4727.7, 4669.2, 4611.5, 4554.4, 4498.1, 4442.4, 4387.5, 4333.3, 4279.7, 4226.9, 4174.6, 4123.1, 4072.2, 4021.9, 3972.3, 3923.3, 3874.9, 3827.1, 3779.9, 3733.3, 3687.3, 3641.8, 3597.0, 3552.7, 3508.9, 3465.7, 3423.1, 3381.0, 3339.4, 3298.3, 3257.7, 3217.7, 3178.1, 3139.1, 3100.5, 3065.2, 3062.4, 3578.1, 3549.4, 3504.1, 3459.4, 3415.3, 3371.7, 3328.2, 3285.2, 3242.8, 3200.9, 3160.0, 3121.4, 3083.2, 3045.4, 3008.2, 2971.6, 2935.4, 2899.9, 2864.8, 2830.3, 2796.2, 2762.7, 2729.6, 2696.9, 2695.4, 2867.5, 2850.7, 2815.8, 2781.3, 2747.3, 2713.8, 2680.8, 2648.1, 2615.9, 2584.2, 2552.9, 2523.1, 2493.8, 2464.9, 2436.4, 2408.3, 2380.6, 2353.3, 2326.3, 2301.9, 2299.7, 2385.6, 2377.9, 2351.1, 2324.6, 2298.5, 2272.7, 2247.2, 2222.1, 2197.2, 2172.6, 2148.3, 2124.3, 2100.4, 2076.8, 2053.5, 2030.4, 2007.6, 1985.1, 1962.8, 1940.8, 1919.1, 1897.5, 1876.3, 1855.2, 1834.4, 1813.9, 1793.5, 1773.4, 1753.5, 1733.7, 1712.7, 1692.0, 1671.5, 1651.2, 1631.2, 1611.3, 1591.7, 1572.3, 1553.2, 1534.3, 1515.6, 1497.2, 1478.9, 1461.0, 1443.2, 1425.7, 1408.4, 1391.3, 1374.4, 1357.8, 1341.0, 1324.3, 1307.7, 1291.4, 1275.2, 1259.3, 1243.6, 1227.7, 1212.1, 1196.6, 1181.4, 1166.4, 1151.6, 1137.0, 1122.6, 1108.4, 1094.4, 1080.5, 1066.9, 1053.4, 1040.1, 1027.0, 1014.1, 1001.4, 988.79, 976.38, 964.14, 952.06, 940.15, 928.39, 916.79, 905.35, 894.06, 882.92, 871.93, 861.08, 850.38, 815.35, 688.51, 580.67, 489.56, 412.86, 348.37, 294.37, 249.08, 211.05, 178.76, 150.98, 127.69, 107.76, 97.317, 93.298, 92.265, 254.52, 250.63, 242.51, 203.45, 192.26, 184.15, 182.08, 252.22, 241.4, 236.41, 235.58, 225.32, 222.69, 253.98, 244.4, 228.96, 193.28, 162.9, 137.08, 115.01, 96.414, 80.819, 67.775, 56.791, 47.607, 39.878, 33.39, 27.981, 23.278, 19.329, 16.064, 13.362, 11.122, 9.2652, 7.7215, 6.4274, 5.349, 4.4377, 3.6785, 3.0496, 2.5298, 2.3661, 2.2679, 2.2427, 11.637, 11.21, 11.132, 9.3777, 7.8727, 6.6035, 5.5254, 4.6153, 3.8556, 3.2214, 2.6919, 2.2497, 1.8804, 1.566, 1.3041, 1.086, 0.90456, 0.75347, 0.62768, 0.52293, 0.4357, 0.36305, 0.30254, 0.25214, 0.21068, 0.17684, 0.14845, 0.12463, 0.10464, 0.087857, 0.073773, 0.0],
                    'energies (keV)': [0.005025, 0.0051, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.016758, 0.0170145, 0.01705382, 0.0170829, 0.0171855, 0.017442, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.029988, 0.030447, 0.0305694, 0.030753, 0.03109002, 0.031212, 0.03323523, 0.03552846, 0.037338, 0.0379095, 0.03797993, 0.0380619, 0.0382905, 0.038862, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.063602, 0.0645755, 0.06477028, 0.0648351, 0.0652245, 0.066198, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.21354015, 0.21385984, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22361559, 0.22398441, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.3799207, 0.38063135, 0.38087931, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.4363751, 0.43762492, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53724443, 0.53895558, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.6614142, 1.6619858, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.7158508, 1.716545, 1.7169493, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.1052605, 2.106026, 2.1099394, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3625852, 2.3682149, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.5957502, 2.596799, 2.6060497, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.369486, 9.512897, 9.55114, 9.608504, 9.653919, 9.751914, 10.32004, 10.52461, 10.6857, 10.72866, 10.7931, 10.95419, 11.03212, 11.04529, 11.21435, 11.25943, 11.32705, 11.49611, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 64.04378, 65.02405, 65.28545, 65.67755, 66.65782, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Hg': {'mass_absorption_coefficient (cm2/g)': [77863.0, 75086.0, 55092.0, 54292.0, 54117.0, 75150.0, 74100.0, 81377.0, 88928.0, 98272.0, 108890.0, 120060.0, 130960.0, 140690.0, 148390.0, 153350.0, 155100.0, 153450.0, 148520.0, 140700.0, 130570.0, 118750.0, 105890.0, 92780.0, 80058.0, 68179.0, 57425.0, 47935.0, 39731.0, 32760.0, 26915.0, 22068.0, 18303.0, 18082.0, 17492.0, 17284.0, 28308.0, 27044.0, 24597.0, 20044.0, 16337.0, 13341.0, 11030.0, 10935.0, 10549.0, 10426.0, 14201.0, 13676.0, 12692.0, 10767.0, 9094.5, 9062.3, 8732.9, 8639.3, 9499.3, 9222.2, 9149.2, 8872.4, 8782.0, 9307.4, 9173.6, 8980.1, 7814.8, 6784.6, 6763.8, 6591.2, 6543.0, 6660.8, 6511.1, 6265.1, 5881.2, 5759.0, 5889.1, 6267.5, 6888.1, 7735.5, 8778.5, 9965.9, 11226.0, 12473.0, 13614.0, 14562.0, 15245.0, 15617.0, 15662.0, 15591.0, 15528.0, 15509.0, 15830.0, 15763.0, 15713.0, 15623.0, 15598.0, 15801.0, 15707.0, 15587.0, 14983.0, 14181.0, 13241.0, 12604.0, 12527.0, 12450.0, 12373.0, 12296.0, 12218.0, 12140.0, 12062.0, 11984.0, 11906.0, 11828.0, 11749.0, 11671.0, 11593.0, 11514.0, 11436.0, 11358.0, 11279.0, 11201.0, 11123.0, 11045.0, 10967.0, 10889.0, 10811.0, 10733.0, 10656.0, 10578.0, 10550.0, 11159.0, 11149.0, 11069.0, 10990.0, 10911.0, 10832.0, 10753.0, 10675.0, 10596.0, 10518.0, 10441.0, 10363.0, 10286.0, 10209.0, 10132.0, 10056.0, 9980.0, 9904.2, 9828.8, 9753.7, 9678.9, 9604.5, 9530.3, 9456.5, 9383.1, 9310.0, 9237.2, 9164.8, 9092.7, 9021.1, 8949.7, 8878.8, 8808.2, 8737.9, 8668.1, 8636.7, 8718.6, 8717.4, 8649.5, 8580.7, 8512.4, 8444.4, 8376.9, 8309.7, 8242.9, 8176.5, 8110.5, 8044.9, 7979.7, 7914.9, 7850.5, 7786.5, 7723.0, 7659.8, 7597.0, 7534.6, 7472.6, 7411.1, 7349.9, 7289.2, 7228.8, 7168.8, 7109.3, 7050.1, 6991.4, 6933.0, 6875.1, 6817.5, 6760.4, 6703.6, 6647.3, 6647.2, 6754.8, 6733.4, 6677.3, 6621.6, 6566.3, 6511.4, 6456.9, 6402.8, 6349.1, 6295.8, 6242.9, 6190.3, 6138.2, 6086.4, 6035.0, 5984.0, 5933.4, 5883.1, 5833.3, 5783.8, 5734.7, 5685.9, 5637.5, 5589.5, 5541.9, 5494.6, 5447.7, 5401.1, 5354.9, 5309.0, 5263.6, 5218.4, 5173.6, 5129.2, 5085.1, 5041.3, 4997.9, 4954.9, 4912.1, 4869.6, 4827.4, 4785.5, 4744.0, 4702.8, 4662.0, 4621.3, 4574.5, 4528.2, 4482.4, 4437.1, 4392.3, 4347.9, 4303.9, 4260.4, 4217.4, 4174.8, 4132.6, 4090.9, 4049.6, 4008.7, 3968.2, 3928.2, 3888.5, 3849.2, 3810.3, 3771.8, 3733.7, 3696.0, 3658.7, 3621.8, 3585.3, 3549.2, 3513.4, 3477.8, 3442.6, 3407.7, 3373.2, 3339.1, 3305.3, 3271.8, 3238.7, 3206.0, 3173.6, 3141.5, 3109.8, 3078.4, 3047.3, 3016.6, 2986.1, 2956.0, 2926.2, 2896.7, 2867.5, 2838.7, 2810.1, 2781.8, 2753.8, 2726.2, 2698.8, 2671.7, 2644.9, 2618.3, 2592.1, 2566.1, 2540.4, 2514.9, 2489.7, 2464.7, 2440.0, 2415.5, 2391.3, 2367.4, 2343.7, 2320.2, 2297.0, 2274.1, 2251.4, 2228.9, 2206.6, 2183.4, 2160.5, 2137.8, 2115.4, 2093.2, 2071.3, 2049.7, 2028.2, 2007.0, 1986.1, 1964.6, 1943.4, 1922.5, 1901.7, 1881.2, 1861.0, 1841.0, 1821.2, 1801.6, 1782.3, 1763.2, 1744.3, 1725.6, 1707.2, 1688.9, 1670.9, 1653.0, 1635.4, 1618.0, 1600.8, 1583.7, 1566.9, 1550.2, 1533.8, 1517.5, 1501.4, 1485.5, 1469.8, 1454.3, 1438.9, 1423.7, 1408.7, 1393.8, 1379.2, 1364.6, 1350.3, 1336.1, 1322.1, 1308.2, 1294.5, 1280.6, 1266.7, 1253.0, 1239.5, 1226.1, 1212.9, 1199.8, 1186.8, 1173.7, 1160.8, 1148.0, 1135.4, 1123.0, 1110.7, 1098.5, 1086.5, 1074.7, 1062.9, 1051.4, 1040.0, 1028.7, 1017.5, 1006.5, 995.63, 984.88, 974.26, 963.77, 953.41, 943.17, 933.06, 923.06, 913.19, 903.43, 893.79, 884.27, 874.86, 865.56, 856.38, 847.3, 838.33, 829.46, 820.7, 811.96, 807.81, 2378.7, 2366.5, 2337.3, 2308.6, 2280.2, 2252.2, 2224.6, 2197.3, 2170.3, 2165.4, 3163.1, 3135.5, 3096.5, 3058.1, 3020.1, 2982.7, 2945.7, 2909.1, 2873.1, 2837.5, 2802.3, 2767.6, 2733.3, 2699.5, 2666.1, 2633.1, 2600.5, 2568.4, 2536.7, 2505.3, 2474.4, 2443.8, 2413.7, 2383.9, 2354.5, 2325.4, 2296.8, 2268.4, 2240.4, 2212.7, 2185.4, 2158.5, 2131.8, 2105.6, 2079.6, 2054.0, 2039.7, 2362.7, 2361.3, 2333.5, 2306.0, 2278.8, 2252.0, 2225.4, 2199.2, 2173.3, 2147.7, 2122.4, 2097.3, 2071.1, 2044.8, 2018.9, 1993.4, 1968.1, 1943.2, 1918.6, 1894.1, 1869.9, 1846.0, 1822.5, 1799.3, 1776.3, 1753.6, 1731.3, 1709.2, 1687.4, 1671.2, 1665.8, 1772.4, 1757.3, 1734.6, 1712.1, 1690.0, 1668.2, 1646.6, 1625.4, 1604.4, 1583.7, 1563.4, 1543.7, 1524.3, 1505.2, 1486.4, 1467.8, 1449.5, 1445.3, 1495.1, 1493.8, 1476.9, 1458.9, 1441.2, 1423.7, 1406.4, 1389.4, 1372.6, 1355.9, 1339.3, 1323.0, 1306.9, 1291.0, 1275.4, 1259.9, 1244.6, 1229.6, 1214.8, 1200.1, 1185.7, 1171.4, 1157.3, 1143.4, 1129.7, 1116.2, 1102.8, 1089.6, 1076.6, 1063.8, 1051.1, 1038.6, 1026.2, 1014.0, 1002.0, 990.1, 978.36, 966.71, 955.1, 943.64, 932.31, 921.13, 910.09, 899.18, 888.41, 877.77, 867.26, 856.88, 846.64, 836.51, 826.52, 816.64, 806.71, 796.73, 786.86, 777.1, 767.47, 757.97, 748.58, 739.32, 730.02, 720.79, 711.68, 702.7, 693.83, 685.08, 676.45, 667.93, 659.53, 651.23, 643.05, 634.97, 627.01, 619.14, 611.38, 603.73, 596.17, 588.71, 581.36, 574.1, 566.93, 559.86, 552.88, 546.0, 539.21, 532.5, 525.89, 519.36, 512.91, 506.56, 500.28, 494.09, 487.98, 481.95, 476.0, 470.09, 464.16, 458.32, 452.55, 446.85, 441.23, 435.69, 430.22, 424.82, 419.5, 414.24, 409.06, 403.94, 398.89, 393.91, 388.99, 384.14, 379.36, 374.64, 369.98, 365.38, 360.84, 356.36, 351.94, 347.58, 343.28, 339.04, 334.85, 330.71, 326.59, 322.53, 318.52, 314.56, 310.65, 306.79, 302.96, 299.19, 295.46, 291.78, 288.14, 284.56, 281.02, 277.53, 274.09, 270.69, 267.32, 263.98, 260.68, 257.43, 254.22, 251.06, 247.93, 244.85, 241.8, 238.8, 235.84, 232.91, 230.02, 227.18, 224.36, 221.59, 218.85, 216.15, 213.48, 210.85, 208.25, 205.69, 203.15, 200.66, 198.19, 195.76, 193.36, 190.98, 188.64, 186.34, 184.06, 181.81, 179.58, 177.39, 175.23, 173.09, 170.98, 148.63, 124.47, 104.23, 87.126, 72.945, 69.09, 66.38, 65.683, 170.41, 163.57, 160.81, 133.78, 122.3, 117.3, 116.02, 160.24, 156.44, 153.93, 152.51, 146.36, 144.77, 165.07, 158.96, 152.1, 128.11, 107.77, 90.639, 76.151, 63.986, 53.791, 45.246, 38.026, 31.759, 26.439, 21.974, 18.277, 15.215, 12.675, 10.567, 8.8175, 7.3631, 6.153, 5.1401, 4.2916, 3.5844, 2.9855, 2.4844, 2.0683, 1.7309, 1.7178, 1.6572, 1.6383, 7.8704, 7.5771, 7.0257, 5.9118, 4.9665, 4.1685, 3.4978, 2.9314, 2.454, 2.0541, 1.7194, 1.4393, 1.2049, 1.008, 0.84311, 0.70527, 0.59002, 0.49366, 0.41307, 0.34567, 0.28929, 0.24213, 0.20268, 0.16966, 0.14204, 0.11892, 0.099576, 0.0],
                    'energies (keV)': [0.006432, 0.006528, 0.007559334, 0.007675038, 0.007705893, 0.007752174, 0.007867878, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.056448, 0.05667876, 0.057312, 0.0575424, 0.057888, 0.058752, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07889, 0.07912411, 0.0800975, 0.0804195, 0.0809025, 0.08211, 0.08458368, 0.09041995, 0.09653, 0.09665893, 0.0980075, 0.0984015, 0.0989925, 0.100156, 0.10047, 0.101689, 0.1020978, 0.102711, 0.1033284, 0.104244, 0.1104581, 0.117894, 0.1180797, 0.1196985, 0.1201797, 0.1209015, 0.122706, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.352604, 0.358001, 0.3594402, 0.361599, 0.3671099, 0.370734, 0.3764085, 0.3779217, 0.3801915, 0.385866, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57028052, 0.57171944, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6759456, 0.6777972, 0.67785446, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.79906754, 0.80153246, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.2942849, 2.295515, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3842276, 2.3855726, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8443469, 2.8498532, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2736807, 3.2777459, 3.2833195, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.554085, 3.5677822, 3.5691149, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.03822, 12.22248, 12.27162, 12.34532, 12.52958, 12.60708, 13.47697, 13.92453, 14.13766, 14.19449, 14.27974, 14.40688, 14.49287, 14.54251, 14.7651, 14.82446, 14.9135, 15.13609, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.44026, 81.6564, 82.68679, 83.0192, 83.51781, 84.76435, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Mg': {'mass_absorption_coefficient (cm2/g)': [57335.0, 60975.0, 63888.0, 84293.0, 107110.0, 127540.0, 143650.0, 154280.0, 159140.0, 158620.0, 156480.0, 155200.0, 154830.0, 165880.0, 165270.0, 164410.0, 157200.0, 146810.0, 134920.0, 122370.0, 109790.0, 97637.0, 86210.0, 75677.0, 66114.0, 57534.0, 49905.0, 43171.0, 37254.0, 32069.0, 27544.0, 23612.0, 20205.0, 17262.0, 14725.0, 12543.0, 10670.0, 9063.3, 7688.2, 6513.5, 5511.8, 4659.1, 3934.6, 3320.0, 2799.3, 2359.0, 1987.0, 1673.1, 1408.6, 1185.8, 998.26, 838.99, 695.61, 577.37, 479.85, 421.47, 404.25, 399.32, 5226.5, 5191.5, 4966.1, 4264.5, 3536.5, 2898.1, 2414.9, 2022.0, 1699.3, 1430.5, 1204.2, 1012.6, 846.87, 706.29, 586.7, 485.54, 401.84, 332.58, 275.27, 227.85, 188.6, 156.12, 129.24, 106.97, 87.889, 72.21, 59.33, 48.749, 40.055, 32.913, 26.991, 21.977, 17.894, 14.571, 11.864, 9.6609, 7.8668, 6.406, 5.2165, 4.2479, 3.4592, 2.817, 2.294, 1.8682, 1.5214, 1.239, 1.009, 0.81823, 0.66071, 0.53352, 0.43082, 0.34789, 0.28092, 0.22682, 0.18311, 0.14783, 0.11934, 0.096344, 0.07778, 0.062793, 0.050693, 0.040926, 0.03304, 0.026674, 0.021534, 0.017385, 0.014036, 0.011331, 0.0091482, 0.0073856, 0.0059627, 0.0048139, 0.0038864, 0.0031376, 0.0025331, 0.0020451, 0.0016511, 0.001333, 0.0010762, 0.00086886, 0.00070147, 0.00056633, 0.00045722, 0.00036914, 0.00029802, 0.00024061, 0.00019426, 0.00015683, 0.00012662, 0.0],
                    'energies (keV)': [0.051657, 0.052428, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.087612, 0.088953, 0.0893106, 0.089847, 0.09041995, 0.091188, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.2789, 1.298475, 1.304285, 1.311525, 1.3311, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'K': {'mass_absorption_coefficient (cm2/g)': [2555100.0, 2265800.0, 2191700.0, 1275600.0, 758240.0, 472940.0, 308750.0, 210380.0, 149200.0, 109810.0, 83640.0, 65743.0, 62575.0, 61757.0, 62832.0, 60155.0, 55782.0, 47388.0, 41425.0, 37087.0, 33856.0, 31378.0, 29412.0, 27790.0, 26399.0, 25161.0, 24026.0, 22955.0, 21916.0, 20893.0, 19878.0, 18864.0, 17850.0, 16836.0, 15826.0, 14823.0, 13831.0, 12855.0, 11900.0, 10972.0, 10078.0, 9221.2, 8406.6, 7637.3, 6915.8, 6243.2, 5620.2, 5046.3, 4857.7, 4785.0, 4737.6, 4706.3, 39275.0, 39210.0, 38965.0, 55490.0, 54870.0, 54494.0, 53882.0, 47733.0, 41700.0, 36216.0, 35702.0, 34548.0, 34248.0, 38186.0, 37028.0, 35506.0, 30817.0, 26662.0, 22996.0, 19779.0, 16968.0, 14523.0, 12403.0, 10570.0, 8990.9, 7634.7, 6472.8, 5479.8, 4632.9, 3912.1, 3293.3, 2769.4, 2317.8, 1933.3, 1613.9, 1348.5, 1124.1, 937.26, 782.21, 653.43, 546.36, 457.28, 383.09, 321.25, 269.65, 226.55, 188.58, 155.62, 129.91, 128.54, 124.4, 122.98, 1195.0, 1148.8, 1059.5, 890.25, 749.0, 630.45, 528.56, 442.46, 370.12, 309.4, 258.57, 216.07, 180.13, 149.66, 124.35, 103.17, 85.137, 70.262, 57.99, 47.864, 39.508, 32.613, 26.922, 22.226, 18.252, 14.967, 12.273, 10.065, 8.2542, 6.7694, 5.552, 4.5536, 3.7114, 3.0189, 2.4556, 1.9975, 1.6249, 1.3218, 1.0753, 0.87475, 0.71163, 0.57893, 0.47099, 0.38317, 0.31174, 0.25362, 0.20635, 0.16788, 0.13624, 0.11049, 0.089608, 0.072673, 0.05894, 0.047802, 0.038769, 0.031443, 0.025502, 0.020683, 0.016775, 0.013606, 0.011035, 0.0089503, 0.0072593, 0.0058879, 0.0047756, 0.0038734, 0.0031417, 0.0025482, 0.0020668, 0.0016764, 0.0013597, 0.0011029, 0.00089458, 0.0007256, 0.0],
                   'energies (keV)': [0.017889, 0.018156, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.0337305, 0.0338661, 0.0340695, 0.034578, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.287728, 0.290374, 0.292132, 0.2933064, 0.2948185, 0.295068, 0.2960037, 0.2977815, 0.299472, 0.3005128, 0.302226, 0.3212482, 0.3434143, 0.3671099, 0.369558, 0.3752145, 0.3767229, 0.3789855, 0.384642, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.535252, 3.548445, 3.589363, 3.603793, 3.625437, 3.679548, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Mn': {'mass_absorption_coefficient (cm2/g)': [9237.2, 9298.5, 9337.4, 45441.0, 45514.0, 46220.0, 64199.0, 67239.0, 70201.0, 73081.0, 75867.0, 78543.0, 81089.0, 83479.0, 85683.0, 87669.0, 89401.0, 90842.0, 91957.0, 92709.0, 93068.0, 93005.0, 92415.0, 91232.0, 89479.0, 87191.0, 84415.0, 81205.0, 77628.0, 76138.0, 75254.0, 75018.0, 110990.0, 106940.0, 92074.0, 81167.0, 73253.0, 66892.0, 61443.0, 56611.0, 52253.0, 49929.0, 49044.0, 48814.0, 52172.0, 51996.0, 51343.0, 48412.0, 45145.0, 42140.0, 39371.0, 36811.0, 34431.0, 32191.0, 29528.0, 27009.0, 24689.0, 22540.0, 20540.0, 18670.0, 16908.0, 15250.0, 13698.0, 12253.0, 10918.0, 9691.4, 8573.2, 7560.2, 6647.8, 5830.7, 5102.7, 4457.1, 3886.9, 3385.1, 2944.8, 2559.4, 2222.9, 2212.2, 2142.1, 2133.1, 2124.0, 13730.0, 13492.0, 13360.0, 18937.0, 18828.0, 18157.0, 17838.0, 15151.0, 13345.0, 12874.0, 12860.0, 12734.0, 14286.0, 13805.0, 12542.0, 10746.0, 9196.0, 7860.1, 6686.5, 5654.3, 4769.5, 4022.7, 3384.7, 2847.7, 2395.7, 2015.0, 1695.2, 1426.6, 1201.0, 1011.5, 852.45, 718.84, 603.36, 506.29, 421.86, 347.98, 287.31, 237.46, 196.45, 162.69, 134.86, 111.91, 92.957, 77.292, 64.331, 54.996, 53.597, 52.763, 52.189, 455.4, 436.04, 392.88, 329.79, 278.25, 234.69, 196.7, 164.09, 136.9, 114.23, 95.325, 79.543, 66.107, 54.675, 45.194, 37.359, 30.884, 25.533, 21.111, 17.455, 14.433, 11.935, 9.8703, 8.1245, 6.6465, 5.4337, 4.4423, 3.632, 2.9695, 2.4278, 1.985, 1.623, 1.3271, 1.0852, 0.88734, 0.72561, 0.59337, 0.48524, 0.39683, 0.32399, 0.26353, 0.21436, 0.17436, 0.14183, 0.11537, 0.093852, 0.076346, 0.062106, 0.050522, 0.0411, 0.033435, 0.0272, 0.022128, 0.018002, 0.014646, 0.011915, 0.0096937, 0.0078865, 0.0064163, 0.0052202, 0.0042471, 0.0034554, 0.0028113, 0.0022873, 0.001861, 0.0],
                    'energies (keV)': [0.007179501, 0.007225283, 0.007254329, 0.007286658, 0.007297899, 0.007406823, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.047628, 0.048357, 0.0485514, 0.048843, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.082222, 0.0834805, 0.0838161, 0.0843195, 0.08458368, 0.085578, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.627494, 0.6370985, 0.638372, 0.6396597, 0.6435015, 0.648143, 0.6507486, 0.653106, 0.654657, 0.664428, 0.6692609, 0.7154399, 0.75362, 0.7648052, 0.765155, 0.768231, 0.772845, 0.78438, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.40822, 6.469004, 6.506305, 6.532461, 6.571695, 6.66978, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'O': {'mass_absorption_coefficient (cm2/g)': [806800.0, 806010.0, 704530.0, 673130.0, 640970.0, 608780.0, 577060.0, 546130.0, 516170.0, 487270.0, 459430.0, 432620.0, 406790.0, 381870.0, 366620.0, 361190.0, 359760.0, 371670.0, 371520.0, 366830.0, 350980.0, 331410.0, 312450.0, 293700.0, 275090.0, 256670.0, 238490.0, 220640.0, 203220.0, 186350.0, 170120.0, 154620.0, 139940.0, 126140.0, 113260.0, 101320.0, 90338.0, 80288.0, 71150.0, 62884.0, 55445.0, 48768.0, 42799.0, 37485.0, 32772.0, 28527.0, 24487.0, 20989.0, 17970.0, 15369.0, 13134.0, 11216.0, 9573.5, 8167.9, 6966.6, 5940.8, 5065.6, 4319.2, 3683.1, 3141.0, 2679.3, 2286.0, 1951.1, 1664.1, 1407.8, 1190.2, 1139.7, 1096.9, 1085.8, 20202.0, 19562.0, 19160.0, 16577.0, 14271.0, 12192.0, 10362.0, 8777.3, 7420.9, 6268.8, 5279.1, 4433.1, 3699.0, 3084.5, 2570.8, 2141.7, 1783.6, 1484.9, 1235.8, 1028.3, 855.38, 711.45, 591.67, 489.48, 403.88, 333.25, 274.98, 226.9, 186.3, 152.24, 124.4, 101.66, 83.077, 67.89, 55.48, 45.339, 37.052, 30.28, 24.746, 20.223, 16.527, 13.507, 11.038, 9.0211, 7.3617, 5.976, 4.8409, 3.9125, 3.1618, 2.5551, 2.0649, 1.6687, 1.3485, 1.0898, 0.88072, 0.71175, 0.57519, 0.46484, 0.37566, 0.30359, 0.24535, 0.19746, 0.1587, 0.12755, 0.10251, 0.08239, 0.066219, 0.053221, 0.042775, 0.034379, 0.027631, 0.022208, 0.017849, 0.014346, 0.01153, 0.009267, 0.0074482, 0.0059845, 0.0048053, 0.0038584, 0.0030981, 0.0024876, 0.0019974, 0.0016038, 0.0012878, 0.001034, 0.00083029, 0.00066669, 0.00053533, 0.00042985, 0.00034515, 0.00027714, 0.00022254, 0.00017869, 0.00014348, 0.00011521, 9.2511e-05, 7.4284e-05, 5.9648e-05, 4.7896e-05, 3.8459e-05, 3.0882e-05, 2.4798e-05, 0.0],
                   'energies (keV)': [0.0071355, 0.007242, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.023226, 0.0235815, 0.0236763, 0.0238073, 0.0238185, 0.024174, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.52136, 0.52934, 0.531468, 0.53466, 0.54264, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'S': {'mass_absorption_coefficient (cm2/g)': [302010.0, 308730.0, 617060.0, 633200.0, 669540.0, 1233400.0, 992700.0, 738180.0, 518810.0, 351340.0, 233000.0, 153380.0, 101320.0, 91697.0, 83627.0, 81627.0, 78762.0, 72101.0, 67804.0, 46314.0, 32566.0, 23830.0, 18410.0, 15237.0, 13592.0, 12951.0, 12906.0, 13153.0, 13469.0, 13709.0, 13800.0, 13733.0, 13521.0, 13195.0, 12794.0, 12351.0, 11894.0, 11454.0, 11038.0, 10645.0, 10274.0, 9919.8, 9577.0, 9238.4, 8897.7, 8549.7, 8191.0, 7820.0, 7437.0, 7043.6, 6483.1, 6076.3, 5944.5, 5909.8, 105830.0, 105090.0, 102800.0, 95814.0, 86606.0, 77717.0, 69225.0, 64072.0, 62285.0, 61818.0, 68112.0, 67994.0, 66233.0, 60411.0, 53330.0, 46840.0, 40946.0, 35641.0, 30900.0, 26694.0, 22986.0, 19737.0, 16904.0, 14443.0, 12315.0, 10480.0, 8904.1, 7553.1, 6398.0, 5411.3, 4570.7, 3856.7, 3251.8, 2740.2, 2308.3, 1913.2, 1586.9, 1317.6, 1095.2, 911.27, 759.06, 632.96, 528.38, 441.55, 369.39, 309.35, 259.35, 217.66, 207.29, 199.22, 197.15, 2150.3, 2078.4, 2040.3, 1731.5, 1455.7, 1223.9, 1027.0, 859.53, 719.43, 602.24, 504.15, 421.83, 352.89, 292.5, 242.47, 201.0, 166.63, 138.15, 114.54, 94.97, 78.743, 65.193, 53.687, 44.214, 36.312, 29.718, 24.322, 19.906, 16.293, 13.335, 10.915, 8.9346, 7.3136, 5.9867, 4.9007, 4.0118, 3.2842, 2.6886, 2.1875, 1.7762, 1.4423, 1.1711, 0.95097, 0.77221, 0.62706, 0.5092, 0.4135, 0.33578, 0.27218, 0.22031, 0.17832, 0.14434, 0.11684, 0.094576, 0.076544, 0.061926, 0.0501, 0.040533, 0.032792, 0.02653, 0.021464, 0.017366, 0.01405, 0.011367, 0.0091967, 0.0074407, 0.00602, 0.0048706, 0.0039407, 0.0031883, 0.0025796, 0.0020871, 0.0016886, 0.0013662, 0.0011054, 0.00089438, 0.00072364, 0.00058549, 0.00047372, 0.00038329, 0.0],
                   'energies (keV)': [0.007774563, 0.007805818, 0.0078527, 0.007889576, 0.007969904, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01733447, 0.01759979, 0.01767054, 0.01777667, 0.01804199, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.161504, 0.163976, 0.1646352, 0.1648404, 0.165624, 0.168096, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.224616, 0.228054, 0.2289708, 0.2301188, 0.230346, 0.233784, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.42256, 2.45964, 2.469528, 2.48436, 2.52144, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'W': {'mass_absorption_coefficient (cm2/g)': [47191.0, 46237.0, 60149.0, 66397.0, 72486.0, 77928.0, 82236.0, 84987.0, 85881.0, 84786.0, 81755.0, 77013.0, 70918.0, 63904.0, 56419.0, 48864.0, 41553.0, 34775.0, 28709.0, 24120.0, 23434.0, 23006.0, 22719.0, 25354.0, 24172.0, 22813.0, 21707.0, 21494.0, 21422.0, 53789.0, 53753.0, 51413.0, 50802.0, 51821.0, 49573.0, 46708.0, 38241.0, 30999.0, 25971.0, 25028.0, 24738.0, 24424.0, 36197.0, 34788.0, 31454.0, 26559.0, 22375.0, 18932.0, 16286.0, 14416.0, 13255.0, 13025.0, 12892.0, 12862.0, 13002.0, 12920.0, 12894.0, 12877.0, 13288.0, 14041.0, 14528.0, 14605.0, 14683.0, 14761.0, 14841.0, 14922.0, 15004.0, 15087.0, 15171.0, 15256.0, 15341.0, 15428.0, 15515.0, 15603.0, 15692.0, 15782.0, 15872.0, 15963.0, 16055.0, 16147.0, 16240.0, 16333.0, 16426.0, 16521.0, 16615.0, 16710.0, 16806.0, 16901.0, 16998.0, 17096.0, 17193.0, 17291.0, 17389.0, 17487.0, 17585.0, 17683.0, 17781.0, 17880.0, 17978.0, 18076.0, 18173.0, 18271.0, 18369.0, 18466.0, 18563.0, 18660.0, 18756.0, 18852.0, 18948.0, 19044.0, 19138.0, 19233.0, 19327.0, 19420.0, 19513.0, 19606.0, 19698.0, 19789.0, 19879.0, 19969.0, 20058.0, 20146.0, 20233.0, 20319.0, 20403.0, 20487.0, 20569.0, 20650.0, 20730.0, 20809.0, 20886.0, 20963.0, 21037.0, 21111.0, 21183.0, 21254.0, 21323.0, 21391.0, 21458.0, 21522.0, 21585.0, 21647.0, 21706.0, 21764.0, 21820.0, 21875.0, 21927.0, 21978.0, 22028.0, 22075.0, 22121.0, 22165.0, 22207.0, 22247.0, 22286.0, 22323.0, 22358.0, 22391.0, 22423.0, 22453.0, 22481.0, 22507.0, 22531.0, 22554.0, 22575.0, 22594.0, 22611.0, 22627.0, 22641.0, 22653.0, 22663.0, 22672.0, 22679.0, 22684.0, 22687.0, 22689.0, 22689.0, 22688.0, 22685.0, 22680.0, 22673.0, 22665.0, 22655.0, 22644.0, 22631.0, 22616.0, 22600.0, 22583.0, 22564.0, 22543.0, 22521.0, 22497.0, 22472.0, 22445.0, 22417.0, 22388.0, 22357.0, 22325.0, 22291.0, 22256.0, 22220.0, 22183.0, 22144.0, 22104.0, 22062.0, 22020.0, 21976.0, 21931.0, 21885.0, 21837.0, 21789.0, 21739.0, 21688.0, 21636.0, 21583.0, 21529.0, 21474.0, 21418.0, 21361.0, 21303.0, 21245.0, 21185.0, 21124.0, 21062.0, 21000.0, 20936.0, 20872.0, 20807.0, 20741.0, 20675.0, 20608.0, 20539.0, 20471.0, 20401.0, 20331.0, 20260.0, 20189.0, 20117.0, 20044.0, 19971.0, 19908.0, 20879.0, 20866.0, 20791.0, 20700.0, 20608.0, 20515.0, 20421.0, 20327.0, 20233.0, 20138.0, 20042.0, 19946.0, 19898.0, 20574.0, 20554.0, 20450.0, 20345.0, 20240.0, 20134.0, 20028.0, 19922.0, 19816.0, 19709.0, 19602.0, 19495.0, 19388.0, 19281.0, 19175.0, 19068.0, 18961.0, 18855.0, 18749.0, 18642.0, 18536.0, 18430.0, 18325.0, 18220.0, 18115.0, 18011.0, 17906.0, 17803.0, 17700.0, 17597.0, 17494.0, 17392.0, 17290.0, 17188.0, 17087.0, 16986.0, 16886.0, 16785.0, 16686.0, 16586.0, 16487.0, 16388.0, 16290.0, 16192.0, 16094.0, 15997.0, 15900.0, 15803.0, 15707.0, 15611.0, 15516.0, 15421.0, 15326.0, 15232.0, 15138.0, 15045.0, 14952.0, 14859.0, 14767.0, 14675.0, 14584.0, 14493.0, 14403.0, 14313.0, 14223.0, 14134.0, 14045.0, 13957.0, 13869.0, 13781.0, 13694.0, 13608.0, 13521.0, 13436.0, 13351.0, 13266.0, 13181.0, 13098.0, 13014.0, 12931.0, 12849.0, 12767.0, 12685.0, 12604.0, 12523.0, 12443.0, 12363.0, 12284.0, 12205.0, 12127.0, 12049.0, 11972.0, 11895.0, 11818.0, 11742.0, 11666.0, 11591.0, 11516.0, 11442.0, 11368.0, 11295.0, 11295.0, 12032.0, 11994.0, 11920.0, 11846.0, 11772.0, 11699.0, 11626.0, 11554.0, 11482.0, 11411.0, 11340.0, 11270.0, 11200.0, 11130.0, 11061.0, 10992.0, 10924.0, 10856.0, 10788.0, 10721.0, 10655.0, 10588.0, 10522.0, 10457.0, 10392.0, 10327.0, 10262.0, 10198.0, 10135.0, 10071.0, 10070.0, 10200.0, 10173.0, 10110.0, 10048.0, 9986.0, 9924.4, 9863.1, 9802.2, 9741.6, 9681.4, 9621.5, 9561.9, 9502.6, 9443.7, 9385.1, 9326.8, 9268.8, 9211.1, 9153.7, 9096.6, 9039.8, 8983.4, 8927.2, 8871.3, 8815.6, 8760.3, 8705.3, 8650.5, 8596.0, 8541.8, 8487.8, 8434.1, 8380.7, 8327.5, 8274.6, 8222.0, 8169.6, 8117.5, 8065.6, 8051.7, 8225.3, 8218.5, 8166.4, 8114.6, 8063.0, 8011.7, 7960.6, 7909.8, 7859.2, 7808.8, 7758.7, 7708.8, 7659.1, 7605.5, 7550.0, 7494.9, 7440.0, 7385.5, 7331.3, 7277.5, 7223.9, 7170.6, 7117.7, 7065.0, 7012.7, 6960.6, 6908.8, 6857.2, 6806.0, 6754.9, 6700.4, 6646.3, 6592.5, 6539.1, 6486.0, 6433.3, 6380.9, 6328.8, 6277.1, 6225.6, 6174.2, 6123.1, 6072.3, 6021.9, 5971.9, 5922.1, 5872.7, 5823.7, 5774.9, 5726.5, 5678.4, 5630.7, 5583.2, 5536.1, 5489.4, 5442.9, 5396.8, 5351.0, 5305.5, 5260.3, 5215.4, 5170.9, 5126.7, 5082.8, 5039.2, 4995.9, 4953.0, 4910.3, 4867.9, 4825.8, 4783.9, 4742.4, 4701.1, 4660.2, 4619.6, 4579.2, 4539.2, 4499.5, 4460.0, 4420.9, 4382.1, 4343.5, 4305.2, 4267.3, 4229.6, 4192.2, 4155.1, 4118.3, 4081.8, 4045.5, 4009.6, 3973.9, 3938.5, 3903.4, 3868.6, 3834.0, 3799.7, 3765.7, 3732.0, 3698.6, 3665.4, 3632.5, 3599.8, 3567.4, 3535.3, 3501.0, 3461.9, 3423.3, 3385.1, 3347.4, 3310.2, 3273.4, 3236.4, 3198.9, 3161.9, 3125.4, 3089.3, 3053.7, 3018.6, 2983.9, 2949.7, 2915.8, 2882.5, 2849.5, 2817.0, 2784.8, 2753.1, 2721.8, 2690.9, 2660.3, 2630.2, 2600.4, 2571.0, 2542.0, 2513.3, 2485.0, 2457.1, 2429.5, 2402.2, 2375.3, 2348.7, 2322.5, 2296.6, 2271.0, 2245.7, 2220.7, 2196.1, 2171.7, 2147.7, 2123.9, 2100.4, 2077.3, 2054.4, 2031.8, 2009.4, 1987.4, 1965.6, 1944.0, 1922.8, 1901.8, 1881.0, 1860.5, 1840.3, 1820.3, 1800.5, 1781.0, 1761.7, 1742.7, 1723.8, 1705.2, 1686.9, 1668.7, 1650.8, 1633.0, 1615.5, 1598.2, 1581.1, 1564.3, 1547.6, 1531.1, 1514.8, 1498.7, 1482.7, 1467.0, 1451.5, 1436.1, 1420.9, 1405.9, 1391.1, 1376.4, 1362.0, 1347.6, 1333.5, 1319.5, 1305.7, 1292.1, 1278.6, 1265.2, 1252.0, 1239.0, 1226.1, 1213.4, 1200.8, 1188.4, 1176.1, 1164.0, 1151.9, 1140.1, 1128.3, 1116.7, 1105.3, 1093.9, 1082.5, 1071.2, 1060.0, 1048.9, 1037.9, 1027.1, 1016.4, 1005.8, 995.34, 984.99, 974.77, 964.66, 959.64, 3241.3, 3224.9, 3186.1, 3147.9, 3110.1, 3072.8, 3035.9, 2999.5, 2989.8, 4437.5, 4405.6, 4352.1, 4299.3, 4247.1, 4195.6, 4144.7, 4094.5, 4044.9, 3995.8, 3947.4, 3899.5, 3852.2, 3805.4, 3759.3, 3713.7, 3668.6, 3624.1, 3580.2, 3536.8, 3493.9, 3451.6, 3409.8, 3368.5, 3327.7, 3287.5, 3247.7, 3208.4, 3169.6, 3131.3, 3093.4, 3056.0, 3019.1, 2982.6, 2946.6, 2911.0, 2875.9, 2841.1, 2806.9, 2773.0, 2746.4, 2739.6, 3216.7, 3184.1, 3143.5, 3103.4, 3063.8, 3024.7, 2986.2, 2947.5, 2909.2, 2871.4, 2834.9, 2800.4, 2766.4, 2733.0, 2699.7, 2666.9, 2634.6, 2602.8, 2571.4, 2540.5, 2510.1, 2480.1, 2450.5, 2421.4, 2392.6, 2391.2, 2544.9, 2530.9, 2499.8, 2469.2, 2439.0, 2409.2, 2379.8, 2350.7, 2322.1, 2293.9, 2266.0, 2239.7, 2213.9, 2188.4, 2163.3, 2138.5, 2114.1, 2090.0, 2066.3, 2063.7, 2137.4, 2135.0, 2111.1, 2087.5, 2064.2, 2041.2, 2018.4, 1995.9, 1973.6, 1951.6, 1929.8, 1908.3, 1887.1, 1866.0, 1843.5, 1821.2, 1799.1, 1777.4, 1755.9, 1734.6, 1713.6, 1692.9, 1672.4, 1652.2, 1632.2, 1612.4, 1592.9, 1573.6, 1554.5, 1535.7, 1517.0, 1498.7, 1480.5, 1462.5, 1444.8, 1427.3, 1409.9, 1392.8, 1375.8, 1359.1, 1342.5, 1326.2, 1310.1, 1294.2, 1278.4, 1262.9, 1247.6, 1232.5, 1217.5, 1202.7, 1188.2, 1173.5, 1158.8, 1144.3, 1130.0, 1115.9, 1102.0, 1088.2, 1074.4, 1060.7, 1047.2, 1033.9, 1020.7, 1007.8, 994.97, 982.35, 969.9, 957.62, 945.51, 933.57, 921.78, 883.36, 746.53, 631.46, 532.55, 449.18, 378.84, 319.67, 270.13, 228.6, 193.74, 164.37, 139.04, 117.3, 97.842, 88.837, 85.196, 84.261, 230.35, 225.87, 219.52, 183.58, 170.84, 163.68, 161.85, 222.69, 213.84, 212.92, 209.78, 201.31, 199.13, 227.25, 218.91, 207.51, 175.26, 147.5, 123.99, 104.01, 87.212, 73.15, 61.393, 51.491, 43.203, 36.224, 30.36, 25.257, 20.973, 17.431, 14.499, 12.069, 10.055, 8.3832, 6.9916, 5.8244, 4.8521, 4.0302, 3.3437, 2.7749, 2.3038, 2.1844, 2.0941, 2.0709, 10.536, 10.151, 9.9591, 8.3857, 7.0346, 5.8989, 4.9397, 4.1282, 3.4505, 2.8844, 2.4115, 2.0164, 1.6861, 1.4053, 1.1714, 0.97654, 0.81416, 0.67884, 0.56606, 0.47206, 0.39371, 0.32838, 0.27392, 0.22851, 0.19127, 0.16081, 0.13522, 0.1137, 0.095617, 0.080415, 0.0],
                   'energies (keV)': [0.0061305, 0.006222, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.032928, 0.03323523, 0.033432, 0.0335664, 0.033768, 0.034272, 0.034888, 0.035422, 0.03552846, 0.0355644, 0.03577, 0.035778, 0.0363175, 0.0364635, 0.0366825, 0.03723, 0.03797993, 0.04060054, 0.04340198, 0.045864, 0.04639671, 0.046566, 0.0467532, 0.047034, 0.047736, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.075558, 0.0767145, 0.0770229, 0.0774855, 0.078642, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24521055, 0.24540936, 0.24558945, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25859581, 0.25900419, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42477688, 0.42582312, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.4909216, 0.49227841, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59410753, 0.59589253, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.8088491, 1.809551, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8709394, 1.8722607, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.2786505, 2.280976, 2.2833493, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5716555, 2.5781443, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8140455, 2.8251547, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.00266, 10.15577, 10.19659, 10.25783, 10.32004, 10.41094, 11.03212, 11.31312, 11.48628, 11.53246, 11.60172, 11.77488, 11.79334, 11.8578, 12.0393, 12.0877, 12.1603, 12.3418, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 68.1345, 69.17738, 69.45548, 69.87263, 70.9155, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Zn': {'mass_absorption_coefficient (cm2/g)': [52275.0, 52416.0, 55176.0, 56102.0, 57145.0, 58313.0, 59612.0, 61041.0, 62600.0, 64283.0, 66081.0, 67982.0, 69969.0, 72024.0, 74123.0, 76237.0, 78335.0, 80383.0, 82341.0, 84158.0, 85679.0, 86845.0, 87636.0, 88040.0, 88054.0, 87682.0, 86937.0, 85841.0, 84420.0, 82586.0, 80271.0, 77641.0, 74738.0, 71607.0, 71444.0, 70702.0, 70505.0, 80620.0, 79386.0, 77473.0, 72228.0, 67553.0, 63343.0, 59437.0, 55764.0, 52958.0, 52292.0, 52186.0, 51984.0, 53860.0, 53124.0, 51189.0, 47737.0, 43222.0, 39068.0, 35262.0, 31784.0, 28611.0, 25720.0, 23087.0, 20689.0, 18505.0, 16518.0, 14711.0, 13070.0, 11580.0, 10228.0, 9006.2, 7907.7, 6925.0, 6050.1, 5274.9, 4590.5, 3988.8, 3461.4, 3000.8, 2599.5, 2250.7, 1948.0, 1828.2, 1808.5, 1789.1, 1769.8, 1750.8, 1732.0, 1713.4, 1695.0, 1676.8, 1658.8, 1640.9, 1623.3, 1605.9, 1588.6, 1571.5, 1554.7, 1538.0, 1521.4, 1505.1, 1488.9, 1472.9, 1457.1, 1439.2, 1421.1, 1403.3, 1385.7, 1385.3, 7934.7, 7832.8, 7727.0, 7622.6, 7519.6, 7467.3, 10616.0, 10550.0, 10408.0, 10267.0, 10129.0, 9992.1, 9857.2, 9724.1, 9592.9, 9463.4, 9335.7, 9209.7, 9085.5, 8962.9, 8842.0, 8722.7, 8605.1, 8489.0, 8374.6, 8261.6, 8150.3, 8040.4, 7932.0, 7825.1, 7719.6, 7615.6, 7513.0, 7411.8, 7370.2, 8317.7, 8296.4, 8190.2, 8085.4, 7982.0, 7880.0, 7779.3, 7679.9, 7581.9, 7485.1, 7389.6, 7295.6, 7203.0, 7111.6, 7021.4, 6932.5, 6844.7, 6758.1, 6672.6, 6588.3, 6505.1, 6423.0, 6342.5, 6263.8, 6186.2, 6109.6, 6034.0, 5959.8, 5886.7, 5814.6, 5743.4, 5673.1, 5603.8, 5535.4, 5467.8, 5401.2, 5335.3, 5270.4, 5206.3, 5143.0, 5080.5, 5018.8, 4957.9, 4897.8, 4838.5, 4779.9, 4722.0, 4664.9, 4608.5, 4552.9, 4497.9, 4443.6, 4390.0, 4337.0, 4284.2, 4231.8, 4180.1, 4129.0, 4078.6, 4028.8, 3979.6, 3931.0, 3883.0, 3835.4, 3788.1, 3741.5, 3695.4, 3649.9, 3604.9, 3560.5, 3516.6, 3473.3, 3430.6, 3388.3, 3346.6, 3305.4, 3264.7, 3224.5, 3184.8, 3145.6, 3106.9, 3068.6, 3030.8, 2993.5, 2956.7, 2920.3, 2884.3, 2848.8, 2813.8, 2779.1, 2744.9, 2711.1, 2677.8, 2644.8, 2612.3, 2580.1, 2548.4, 2517.0, 2486.0, 2455.4, 2425.2, 2395.4, 2365.9, 2336.8, 2308.0, 2279.6, 2251.6, 2223.9, 2196.5, 2168.8, 2141.4, 2114.3, 2087.6, 2061.0, 2034.6, 2008.5, 1982.8, 1957.4, 1932.3, 1907.5, 1883.1, 1859.0, 1835.2, 1811.7, 1788.5, 1765.5, 1742.9, 1720.6, 1698.6, 1676.9, 1655.4, 1634.2, 1613.3, 1592.7, 1572.3, 1552.2, 1532.3, 1512.8, 1493.4, 1474.3, 1455.4, 1436.6, 1418.0, 1399.7, 1381.6, 1363.7, 1346.1, 1328.7, 1311.6, 1294.6, 1277.9, 1261.4, 1245.1, 1229.1, 1213.2, 1197.5, 1182.0, 1166.7, 1151.7, 1136.8, 1122.1, 1107.6, 1093.3, 1079.2, 1065.3, 1051.6, 1038.0, 1024.6, 1011.4, 998.38, 985.52, 972.83, 960.3, 947.95, 935.75, 923.72, 911.84, 900.12, 888.55, 877.14, 865.88, 854.76, 843.79, 832.97, 822.29, 811.75, 800.94, 790.01, 779.24, 768.61, 758.14, 747.81, 737.62, 727.58, 717.68, 707.91, 698.28, 688.79, 679.43, 670.2, 661.1, 652.12, 643.27, 634.54, 625.94, 617.45, 609.08, 600.83, 592.69, 584.67, 576.76, 568.96, 561.26, 553.68, 546.19, 538.82, 531.54, 524.37, 517.29, 510.31, 503.43, 496.65, 489.96, 483.36, 476.85, 470.43, 464.1, 457.86, 451.7, 445.63, 439.64, 433.73, 427.91, 422.16, 416.5, 410.91, 405.4, 399.97, 394.61, 389.32, 384.11, 378.97, 373.9, 368.9, 363.97, 359.11, 354.31, 349.58, 344.91, 340.31, 335.77, 331.3, 326.88, 322.53, 318.23, 314.0, 309.82, 305.7, 301.64, 297.63, 293.67, 289.78, 285.93, 282.14, 278.3, 274.51, 270.78, 267.1, 263.45, 259.82, 256.25, 252.73, 249.26, 245.84, 242.46, 239.14, 235.86, 232.63, 229.44, 226.3, 223.21, 220.16, 217.15, 214.19, 211.26, 208.38, 205.54, 202.74, 199.98, 197.26, 194.58, 191.93, 189.32, 186.75, 184.22, 181.69, 179.16, 176.66, 174.2, 171.77, 169.38, 167.02, 164.7, 162.4, 160.15, 157.92, 155.72, 153.56, 151.43, 149.33, 147.26, 145.21, 143.2, 141.21, 139.26, 137.33, 135.43, 133.55, 131.71, 129.89, 128.09, 126.32, 124.58, 122.86, 121.16, 119.49, 117.84, 116.22, 114.62, 113.04, 111.48, 109.95, 108.43, 106.94, 105.47, 104.02, 102.59, 101.19, 99.797, 98.427, 97.077, 95.746, 94.434, 93.141, 81.343, 67.719, 56.432, 47.072, 39.148, 34.062, 32.568, 32.135, 255.48, 244.34, 213.41, 178.58, 150.39, 126.87, 106.2, 88.753, 74.058, 61.73, 51.427, 42.84, 35.595, 29.524, 24.487, 20.309, 16.84, 13.894, 11.447, 9.4315, 7.7713, 6.4038, 5.2772, 4.3486, 3.5629, 2.9194, 2.3922, 1.9603, 1.6064, 1.3164, 1.0787, 0.88398, 0.72441, 0.59292, 0.48392, 0.39498, 0.32239, 0.26315, 0.21481, 0.17535, 0.14314, 0.11686, 0.0954, 0.077886, 0.063588, 0.051917, 0.042389, 0.034611, 0.028261, 0.023076, 0.018843, 0.015387, 0.012566, 0.010262, 0.0083802, 0.0068439, 0.0055894, 0.004565, 0.0037285, 0.0],
                    'energies (keV)': [0.0081405, 0.008262, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.084868, 0.086167, 0.0865134, 0.087033, 0.088332, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.133182, 0.1349368, 0.1352205, 0.1357641, 0.1365795, 0.138618, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.019629, 1.0197711, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0427279, 1.042872, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1924542, 1.1947459, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.465428, 9.610307, 9.653919, 9.706893, 9.851772, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Eu': {'mass_absorption_coefficient (cm2/g)': [6492.8, 6808.1, 7151.3, 7523.2, 7924.7, 8356.1, 8817.7, 9309.1, 9830.0, 10379.0, 10955.0, 11261.0, 11398.0, 11435.0, 226460.0, 220600.0, 214640.0, 173780.0, 137060.0, 107400.0, 84375.0, 67035.0, 66508.0, 63276.0, 62460.0, 61474.0, 58676.0, 54490.0, 45285.0, 38724.0, 34105.0, 30890.0, 28681.0, 27188.0, 26199.0, 25052.0, 23682.0, 22443.0, 21287.0, 20181.0, 19105.0, 18048.0, 17003.0, 15970.0, 15448.0, 15372.0, 15296.0, 15220.0, 15144.0, 15068.0, 14992.0, 14917.0, 14841.0, 14765.0, 14690.0, 14615.0, 14539.0, 14464.0, 14389.0, 14314.0, 14239.0, 14164.0, 14090.0, 14015.0, 13940.0, 13866.0, 13792.0, 13718.0, 13644.0, 13570.0, 13496.0, 13422.0, 13349.0, 13275.0, 13202.0, 13129.0, 13056.0, 12983.0, 12910.0, 12837.0, 12765.0, 12692.0, 12620.0, 12548.0, 12476.0, 12404.0, 12333.0, 12261.0, 12190.0, 12119.0, 12048.0, 11977.0, 11906.0, 11835.0, 11765.0, 11695.0, 11625.0, 11555.0, 11485.0, 11416.0, 11346.0, 11277.0, 11247.0, 52145.0, 50796.0, 48115.0, 45606.0, 43258.0, 41061.0, 39004.0, 37080.0, 35277.0, 33590.0, 32009.0, 30529.0, 29142.0, 27843.0, 26625.0, 25483.0, 24412.0, 23408.0, 22466.0, 21582.0, 20753.0, 19987.0, 19281.0, 18630.0, 18029.0, 17473.0, 16956.0, 16477.0, 16031.0, 15615.0, 15226.0, 14863.0, 14522.0, 14202.0, 13901.0, 13617.0, 13350.0, 13097.0, 12858.0, 12631.0, 12416.0, 12211.0, 12016.0, 11830.0, 11652.0, 11482.0, 11320.0, 11164.0, 11014.0, 10871.0, 10732.0, 10599.0, 10471.0, 10347.0, 10227.0, 10111.0, 9999.3, 9890.7, 9785.4, 9683.2, 9584.0, 9487.5, 9393.6, 9302.3, 9213.3, 9126.5, 9042.0, 8959.4, 8878.8, 8800.1, 8723.1, 8647.9, 8574.2, 8502.2, 8431.6, 8362.5, 8294.8, 8228.4, 8163.4, 8099.6, 8036.9, 7975.5, 7915.2, 7856.0, 7797.8, 7740.7, 7684.6, 7629.5, 7575.3, 7522.0, 7469.7, 7418.2, 7367.6, 7317.8, 7268.9, 7220.8, 7173.4, 7126.9, 7081.1, 7036.0, 6991.7, 6948.1, 6905.2, 6863.0, 6821.4, 6780.6, 6740.4, 6700.9, 6662.0, 6623.7, 6586.0, 6549.0, 6512.6, 6476.8, 6441.5, 6406.9, 6372.8, 6339.3, 6306.3, 6273.9, 6242.0, 6210.7, 6179.9, 6149.6, 6119.9, 6090.7, 6061.9, 6033.7, 6006.0, 5978.7, 5951.9, 5925.6, 5905.0, 7063.3, 7061.1, 7036.6, 7010.3, 6984.5, 6959.1, 6934.2, 6909.7, 6885.6, 6862.0, 6838.7, 6815.9, 6793.4, 6771.4, 6749.8, 6728.5, 6707.6, 6687.1, 6666.9, 6647.1, 6627.6, 6608.5, 6607.6, 6925.6, 6913.9, 6895.4, 6877.1, 6859.1, 6841.4, 6823.9, 6806.8, 6789.8, 6773.1, 6756.7, 6740.5, 6724.5, 6708.7, 6693.2, 6677.8, 6662.7, 6647.7, 6633.0, 6618.4, 6603.9, 6589.7, 6575.5, 6561.6, 6547.7, 6534.0, 6520.4, 6506.9, 6493.5, 6480.3, 6467.1, 6454.0, 6441.0, 6428.0, 6415.1, 6402.3, 6389.5, 6376.8, 6364.1, 6351.4, 6338.7, 6326.1, 6313.4, 6300.8, 6288.2, 6275.5, 6262.8, 6250.1, 6241.1, 6640.4, 6638.1, 6626.5, 6612.5, 6598.5, 6584.5, 6570.4, 6556.2, 6542.0, 6527.7, 6513.3, 6498.8, 6484.3, 6469.6, 6454.9, 6440.0, 6425.1, 6410.0, 6394.8, 6379.5, 6364.1, 6348.5, 6332.8, 6317.0, 6301.0, 6284.8, 6268.5, 6252.0, 6235.4, 6218.5, 6201.5, 6184.3, 6167.0, 6149.4, 6131.7, 6113.8, 6095.8, 6077.5, 6059.1, 6040.5, 6021.8, 6002.8, 5983.7, 5964.4, 5944.9, 5925.2, 5905.4, 5885.3, 5865.1, 5844.7, 5824.1, 5803.4, 5782.5, 5761.4, 5740.1, 5718.6, 5697.0, 5675.2, 5653.3, 5631.1, 5608.8, 5586.4, 5563.8, 5541.0, 5518.0, 5495.0, 5471.7, 5448.3, 5424.8, 5401.1, 5377.3, 5353.3, 5329.2, 5304.9, 5280.6, 5256.1, 5231.5, 5206.7, 5181.8, 5156.9, 5131.8, 5106.5, 5081.1, 5055.6, 5029.9, 5004.0, 4978.1, 4952.0, 4925.8, 4899.5, 4873.0, 4846.5, 4819.9, 4793.1, 4766.3, 4739.4, 4712.5, 4685.4, 4658.3, 4631.2, 4603.9, 4576.7, 4549.3, 4522.0, 4494.5, 4467.1, 4439.6, 4412.1, 4384.6, 4357.0, 4329.5, 4302.0, 4274.4, 4246.9, 4219.4, 4191.9, 4164.4, 4136.9, 4109.5, 4082.1, 4054.7, 4027.4, 4000.1, 3972.8, 3945.6, 3918.5, 3891.4, 3864.4, 3837.4, 3810.5, 3783.7, 3756.9, 3730.2, 3703.6, 3677.1, 3650.7, 3624.3, 3598.0, 3571.9, 3545.8, 3519.8, 3493.9, 3468.1, 3442.4, 3416.8, 3391.4, 3366.0, 3340.7, 3315.6, 3290.5, 3265.6, 3240.8, 3216.1, 3191.6, 3167.1, 3142.8, 3118.6, 3094.5, 3070.6, 3046.8, 3023.1, 2999.5, 2976.1, 2952.8, 2929.6, 2906.6, 2883.7, 2860.9, 2838.2, 2815.7, 2793.4, 2771.1, 2749.0, 2727.1, 2705.3, 2683.6, 2662.0, 2640.6, 2619.3, 2598.2, 2577.2, 2556.4, 2535.6, 2515.1, 2494.6, 2474.3, 2454.2, 2434.1, 2414.3, 2394.5, 2374.9, 2355.4, 2336.1, 2316.9, 2297.8, 2278.9, 2260.1, 2241.5, 2223.0, 2204.6, 2186.4, 2168.3, 2150.3, 2132.4, 2114.7, 2097.2, 2078.4, 2057.2, 2036.3, 2015.5, 1995.0, 1974.6, 1954.0, 1933.6, 1913.4, 1893.4, 1873.7, 1854.1, 1834.8, 1815.7, 1796.8, 1778.1, 1759.6, 1741.3, 1723.2, 1705.3, 1687.5, 1670.0, 1652.7, 1635.5, 1618.6, 1613.4, 6465.4, 6412.8, 6331.9, 6252.1, 6173.3, 6095.5, 6057.6, 9159.0, 9108.1, 8991.9, 8877.2, 8764.0, 8652.2, 8541.9, 8433.0, 8325.5, 8219.4, 8114.7, 8011.3, 7909.2, 7808.5, 7709.0, 7610.9, 7514.0, 7418.3, 7323.9, 7230.7, 7138.7, 7047.8, 6958.2, 6869.7, 6782.3, 6696.1, 6611.0, 6526.9, 6443.8, 6361.9, 6280.9, 6201.0, 6122.1, 6044.3, 5967.4, 5891.6, 5816.7, 5742.8, 5669.8, 5597.8, 5526.7, 5456.5, 5387.2, 5318.8, 5251.3, 5184.6, 5118.8, 5053.8, 4989.7, 4926.6, 4914.3, 5733.2, 5696.3, 5621.7, 5548.2, 5475.6, 5404.0, 5333.4, 5263.8, 5195.0, 5127.2, 5060.3, 4997.8, 4936.2, 4875.6, 4816.0, 4757.3, 4699.5, 4642.6, 4616.2, 4918.2, 4906.2, 4845.8, 4786.2, 4727.5, 4669.6, 4612.7, 4556.5, 4501.2, 4446.7, 4392.9, 4341.1, 4290.5, 4240.8, 4191.8, 4143.5, 4096.0, 4049.1, 4003.0, 3957.5, 3912.7, 3868.5, 3825.0, 3815.6, 3971.1, 3963.1, 3919.1, 3875.7, 3832.9, 3790.7, 3749.0, 3707.9, 3667.3, 3627.2, 3587.6, 3548.6, 3510.2, 3472.3, 3434.8, 3396.7, 3359.0, 3321.8, 3285.1, 3248.7, 3212.8, 3177.3, 3142.3, 3107.6, 3073.3, 3039.4, 3005.9, 2972.8, 2940.0, 2907.7, 2875.6, 2844.0, 2812.3, 2780.8, 2749.7, 2718.9, 2688.4, 2658.3, 2628.5, 2599.1, 2569.9, 2541.1, 2512.6, 2484.4, 2456.6, 2429.0, 2401.7, 2374.3, 2347.0, 2319.9, 2293.2, 2266.8, 2240.5, 2214.3, 2188.3, 2162.6, 2137.1, 2112.0, 2087.2, 2062.7, 2038.4, 2014.5, 1990.8, 1967.4, 1944.3, 1921.4, 1898.9, 1876.4, 1854.0, 1832.0, 1810.2, 1788.6, 1767.3, 1746.3, 1725.6, 1705.1, 1684.8, 1664.8, 1645.1, 1625.6, 1606.3, 1587.3, 1568.5, 1549.9, 1531.6, 1513.5, 1495.6, 1478.0, 1460.6, 1443.4, 1426.4, 1409.6, 1393.0, 1376.7, 1360.5, 1344.6, 1328.8, 1313.3, 1297.9, 1282.7, 1267.8, 1252.9, 1238.1, 1223.5, 1207.7, 1192.1, 1176.7, 1161.6, 1146.6, 1131.9, 1117.3, 1103.0, 1088.8, 1074.8, 1061.1, 1047.5, 1034.1, 1020.8, 1007.7, 994.7, 981.85, 969.18, 956.67, 944.34, 932.17, 920.17, 908.33, 896.65, 885.12, 873.76, 862.54, 851.48, 840.57, 829.8, 819.18, 808.7, 798.36, 788.16, 778.1, 768.17, 758.35, 748.63, 739.04, 729.57, 720.24, 711.03, 701.94, 692.98, 684.13, 675.41, 666.8, 658.3, 649.92, 641.65, 633.49, 625.44, 617.5, 609.66, 601.92, 594.29, 586.76, 562.2, 474.55, 401.13, 339.19, 285.6, 240.7, 203.23, 171.8, 149.03, 144.77, 143.35, 141.89, 414.1, 394.93, 350.88, 341.38, 327.3, 323.72, 443.99, 425.49, 407.05, 405.35, 390.01, 385.82, 439.52, 423.54, 395.05, 333.79, 279.54, 234.04, 195.76, 163.83, 137.22, 115.03, 96.31, 80.495, 67.136, 55.926, 46.628, 38.911, 32.5, 27.169, 22.733, 19.035, 15.831, 13.145, 10.898, 9.0314, 7.4611, 6.1603, 5.0873, 4.2045, 3.5472, 3.4776, 3.3975, 3.359, 19.008, 18.303, 16.792, 14.099, 11.819, 9.9026, 8.2843, 6.9285, 5.7946, 4.8396, 4.03, 3.3562, 2.7907, 2.3152, 1.9209, 1.5939, 1.3227, 1.0977, 0.91107, 0.75623, 0.62776, 0.52115, 0.43268, 0.35926, 0.29925, 0.24945, 0.20795, 0.17336, 0.14454, 0.12051, 0.10049, 0.083796, 0.069879, 0.058277, 0.048604, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02156, 0.02189, 0.021978, 0.02211, 0.02227063, 0.02244, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.031164, 0.031641, 0.0317682, 0.031959, 0.032436, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13317243, 0.13322758, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25641678, 0.25667624, 0.2567832, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28366578, 0.28413421, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.35978936, 0.36031129, 0.36061062, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1307711, 1.1310289, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1603841, 1.1608158, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4794437, 1.4817563, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6125491, 1.6152508, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.7973, 1.8027, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.837362, 6.915365, 6.942016, 6.969923, 7.011785, 7.116438, 7.392525, 7.464758, 7.579014, 7.609483, 7.655185, 7.769442, 7.89096, 7.902609, 8.01174, 8.043948, 8.09226, 8.21304, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.54862, 47.88159, 48.27641, 48.47048, 48.7616, 49.48938, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Zr': {'mass_absorption_coefficient (cm2/g)': [162020.0, 156300.0, 145190.0, 129980.0, 112320.0, 93901.0, 76157.0, 60092.0, 46295.0, 34973.0, 26017.0, 19137.0, 13972.0, 10161.0, 7384.1, 6302.3, 5864.0, 5753.6, 126350.0, 121920.0, 118530.0, 91486.0, 68632.0, 51432.0, 38671.0, 29287.0, 22413.0, 17374.0, 13666.0, 13041.0, 12384.0, 12217.0, 12989.0, 12433.0, 11970.0, 10007.0, 8545.8, 7437.9, 6584.9, 5916.4, 5388.7, 4960.7, 4603.7, 4299.5, 4034.8, 3800.3, 3588.9, 3395.5, 3216.0, 3047.3, 2887.2, 2734.0, 2586.6, 2584.4, 2555.7, 2551.5, 2542.9, 5906.4, 5974.4, 6060.8, 8461.6, 8521.7, 9056.0, 9604.8, 13506.0, 18339.0, 23003.0, 26796.0, 29274.0, 30306.0, 30022.0, 28702.0, 28485.0, 28056.0, 27937.0, 30635.0, 30142.0, 29631.0, 29537.0, 29493.0, 30485.0, 29955.0, 28278.0, 25637.0, 22973.0, 22769.0, 22174.0, 22018.0, 22762.0, 22179.0, 21346.0, 18887.0, 16629.0, 14584.0, 12747.0, 11114.0, 9669.7, 8398.1, 7277.7, 6294.0, 5435.1, 4687.9, 4040.0, 3427.8, 2910.1, 2473.0, 2104.1, 1783.5, 1508.5, 1277.9, 1084.1, 919.86, 781.28, 664.43, 595.2, 573.86, 568.36, 2350.8, 2322.6, 2241.3, 2223.4, 2143.2, 2118.1, 2919.1, 2798.1, 2717.4, 2424.8, 2331.0, 2307.0, 2621.8, 2615.6, 2521.4, 2226.2, 1894.1, 1599.3, 1344.4, 1129.3, 949.21, 798.51, 672.3, 564.18, 471.36, 393.31, 328.1, 273.94, 228.81, 191.13, 159.8, 133.74, 112.0, 93.641, 77.7, 64.262, 53.142, 43.798, 36.131, 29.833, 24.654, 20.393, 16.884, 13.991, 13.907, 13.326, 13.177, 93.892, 89.92, 83.703, 69.936, 58.803, 49.506, 41.511, 34.728, 28.934, 24.079, 20.041, 16.682, 13.859, 11.452, 9.4637, 7.8213, 6.4643, 5.3425, 4.415, 3.6467, 3.0124, 2.4885, 2.0559, 1.6986, 1.3983, 1.1475, 0.94179, 0.77296, 0.63443, 0.52075, 0.42747, 0.3509, 0.28807, 0.23649, 0.19416, 0.15941, 0.13089, 0.10747, 0.088246, 0.072464, 0.059506, 0.048867, 0.040131, 0.032959, 0.027069, 0.022232, 0.01826, 0.014998, 0.012319, 0.010119, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.028126, 0.0285565, 0.0286713, 0.0288435, 0.02908327, 0.029274, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.050274, 0.0510435, 0.0512487, 0.0515565, 0.052326, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1764, 0.178752, 0.1791, 0.17982, 0.1809, 0.181488, 0.1822176, 0.183312, 0.1836, 0.186048, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.32389, 0.3288475, 0.3301695, 0.3321525, 0.337316, 0.342479, 0.3434143, 0.3438558, 0.345921, 0.351084, 0.3671099, 0.3924405, 0.4195189, 0.421694, 0.4281485, 0.4298697, 0.4324515, 0.438906, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.177854, 2.211189, 2.220078, 2.224304, 2.233412, 2.260566, 2.266746, 2.295166, 2.304393, 2.318233, 2.352834, 2.377781, 2.480968, 2.518942, 2.529068, 2.541848, 2.544258, 2.582232, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 17.63765, 17.90761, 17.9796, 18.08759, 18.35755, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Er': {'mass_absorption_coefficient (cm2/g)': [7238.3, 7163.2, 6646.7, 6854.8, 7094.9, 7368.3, 7676.3, 8020.3, 8402.0, 8822.8, 9284.0, 9785.8, 10328.0, 10912.0, 11536.0, 12200.0, 12902.0, 13535.0, 13641.0, 13707.0, 13752.0, 208900.0, 196000.0, 168170.0, 127700.0, 97355.0, 75159.0, 59391.0, 48441.0, 40984.0, 36002.0, 32748.0, 30688.0, 29983.0, 29720.0, 29656.0, 29692.0, 29576.0, 29488.0, 28907.0, 28614.0, 28567.0, 28678.0, 28065.0, 27099.0, 26105.0, 25585.0, 25507.0, 25430.0, 25352.0, 25274.0, 25196.0, 25117.0, 25038.0, 24959.0, 24880.0, 24801.0, 24721.0, 24641.0, 24561.0, 24480.0, 24399.0, 24318.0, 24237.0, 24156.0, 24074.0, 23992.0, 23910.0, 23828.0, 23745.0, 23662.0, 23579.0, 23496.0, 23412.0, 23328.0, 23244.0, 23160.0, 23076.0, 22991.0, 22906.0, 22821.0, 22736.0, 22650.0, 22565.0, 22479.0, 22393.0, 22307.0, 22220.0, 22134.0, 22047.0, 21960.0, 21873.0, 21786.0, 21698.0, 21611.0, 21523.0, 21435.0, 21347.0, 21258.0, 21170.0, 21082.0, 20993.0, 20904.0, 20815.0, 20726.0, 20637.0, 20548.0, 20458.0, 20369.0, 20279.0, 20190.0, 20100.0, 20010.0, 19920.0, 19830.0, 19740.0, 19650.0, 19559.0, 19469.0, 19378.0, 19288.0, 19197.0, 19107.0, 19016.0, 18926.0, 18835.0, 18744.0, 18653.0, 18563.0, 18472.0, 18381.0, 18290.0, 18199.0, 18109.0, 18018.0, 17927.0, 17836.0, 17745.0, 17655.0, 17564.0, 17473.0, 17383.0, 17292.0, 17201.0, 17111.0, 17020.0, 16930.0, 16840.0, 16749.0, 16659.0, 16620.0, 28823.0, 28531.0, 27740.0, 26991.0, 26281.0, 25607.0, 24967.0, 24359.0, 23782.0, 23234.0, 22712.0, 22216.0, 22203.0, 29547.0, 28877.0, 28021.0, 27209.0, 26438.0, 25708.0, 25014.0, 24356.0, 23730.0, 23136.0, 22575.0, 22047.0, 21548.0, 21077.0, 20632.0, 20211.0, 19811.0, 19432.0, 19071.0, 18729.0, 18403.0, 18095.0, 17805.0, 17530.0, 17269.0, 17021.0, 16784.0, 16559.0, 16344.0, 16138.0, 15940.0, 15751.0, 15568.0, 15393.0, 15223.0, 15060.0, 14901.0, 14748.0, 14600.0, 14456.0, 14316.0, 14179.0, 14047.0, 13917.0, 13791.0, 13668.0, 13548.0, 13430.0, 13315.0, 13203.0, 13092.0, 12984.0, 12878.0, 12773.0, 12671.0, 12570.0, 12471.0, 12374.0, 12278.0, 12184.0, 12091.0, 11999.0, 11909.0, 11820.0, 11732.0, 11646.0, 11561.0, 11476.0, 11393.0, 11311.0, 11230.0, 11150.0, 11071.0, 10993.0, 10916.0, 10840.0, 10764.0, 10690.0, 10616.0, 10543.0, 10471.0, 10400.0, 10329.0, 10260.0, 10191.0, 10123.0, 10055.0, 9988.4, 9922.3, 9857.0, 9792.4, 9728.5, 9665.2, 9602.6, 9540.7, 9479.4, 9418.7, 9358.7, 9299.3, 9240.6, 9182.4, 9124.9, 9067.9, 9011.6, 8955.8, 8900.7, 8846.1, 8792.0, 8738.6, 8685.7, 8633.4, 8581.6, 8530.3, 8479.6, 8429.4, 8379.8, 8330.7, 8282.0, 8234.0, 8186.4, 9096.1, 9068.3, 9020.4, 8972.9, 8926.0, 8879.5, 8833.5, 8788.0, 8743.0, 8698.4, 8654.3, 8610.6, 8567.3, 8524.5, 8482.2, 8440.2, 8398.7, 8357.6, 8316.9, 8276.6, 8236.7, 8197.2, 8158.0, 8119.2, 8080.7, 8042.6, 8004.9, 7967.4, 7967.1, 8176.2, 8157.4, 8120.6, 8084.2, 8048.1, 8012.2, 7976.7, 7941.5, 7906.5, 7871.9, 7837.5, 7803.3, 7769.4, 7735.8, 7702.4, 7669.2, 7636.3, 7603.6, 7571.1, 7538.9, 7506.8, 7475.0, 7443.3, 7411.8, 7380.5, 7349.4, 7318.4, 7287.6, 7257.0, 7226.5, 7196.1, 7165.9, 7135.8, 7105.9, 7076.0, 7046.3, 7016.7, 6987.2, 6957.8, 6928.5, 6899.2, 6874.0, 6870.1, 7146.9, 7130.9, 7101.1, 7071.4, 7041.7, 7012.2, 6982.6, 6953.1, 6923.7, 6894.3, 6865.0, 6835.7, 6806.4, 6777.2, 6747.9, 6718.8, 6689.6, 6660.4, 6631.3, 6602.2, 6573.0, 6543.9, 6514.8, 6485.6, 6456.5, 6427.3, 6398.1, 6368.8, 6339.6, 6310.3, 6281.0, 6251.7, 6222.4, 6193.0, 6163.6, 6134.2, 6104.7, 6075.3, 6045.8, 6016.2, 5986.6, 5957.0, 5927.4, 5897.7, 5868.0, 5838.2, 5808.4, 5778.6, 5748.8, 5718.9, 5689.0, 5659.1, 5629.1, 5599.2, 5569.2, 5539.2, 5509.2, 5479.1, 5449.0, 5419.0, 5388.9, 5358.8, 5328.7, 5298.6, 5268.4, 5238.3, 5208.2, 5178.1, 5147.9, 5117.8, 5087.7, 5057.6, 5027.4, 4997.4, 4967.3, 4937.2, 4907.1, 4877.1, 4847.1, 4817.1, 4787.2, 4757.2, 4727.3, 4697.4, 4667.5, 4637.6, 4607.8, 4577.9, 4548.1, 4518.4, 4488.6, 4458.9, 4429.3, 4399.7, 4370.1, 4340.5, 4311.0, 4281.6, 4252.2, 4222.8, 4193.6, 4164.4, 4135.2, 4106.1, 4077.1, 4048.2, 4019.3, 3990.4, 3961.6, 3932.9, 3904.3, 3875.8, 3847.4, 3819.1, 3790.9, 3762.8, 3734.8, 3706.9, 3679.1, 3651.5, 3624.0, 3596.6, 3569.3, 3542.1, 3515.1, 3488.2, 3461.4, 3434.8, 3408.3, 3382.0, 3355.8, 3329.7, 3303.8, 3278.0, 3252.3, 3226.8, 3201.5, 3176.3, 3151.2, 3126.3, 3101.6, 3077.0, 3052.5, 3028.2, 3004.1, 2980.1, 2956.3, 2932.6, 2909.1, 2885.7, 2862.5, 2839.4, 2816.6, 2793.8, 2771.2, 2748.8, 2726.6, 2704.5, 2682.5, 2660.8, 2639.1, 2615.2, 2586.7, 2558.5, 2530.6, 2503.0, 2475.8, 2448.8, 2422.2, 2395.9, 2369.9, 2344.2, 2318.8, 2293.7, 2268.9, 2244.4, 2220.2, 2196.2, 2172.5, 2149.1, 2125.9, 2103.1, 2080.5, 2058.1, 2036.0, 2014.2, 1992.5, 1971.2, 1950.1, 1929.2, 1908.6, 1888.2, 1868.0, 1848.1, 1828.4, 1808.9, 1789.7, 1770.6, 1751.8, 1733.2, 1714.8, 1696.6, 1678.7, 1660.9, 1643.3, 1625.9, 1608.8, 1591.8, 1575.0, 1558.4, 1542.0, 1525.5, 1509.1, 1492.9, 1476.9, 1461.1, 1445.4, 1430.0, 1414.7, 1399.6, 1384.7, 1369.9, 1355.3, 1340.9, 1326.6, 1312.5, 1298.5, 1284.8, 1271.1, 1257.7, 1251.9, 4743.6, 4712.8, 4653.3, 4594.7, 4536.7, 4479.6, 4423.1, 4391.3, 6600.7, 6573.2, 6489.5, 6406.8, 6325.1, 6244.5, 6164.9, 6086.3, 6008.8, 5932.3, 5856.7, 5782.2, 5708.6, 5635.9, 5564.2, 5493.4, 5423.5, 5354.5, 5286.5, 5219.3, 5152.9, 5087.4, 5022.8, 4959.0, 4896.0, 4833.8, 4772.5, 4711.9, 4652.1, 4593.1, 4534.8, 4477.3, 4420.5, 4364.5, 4309.2, 4254.6, 4200.7, 4147.5, 4094.9, 4043.1, 3991.9, 3941.4, 3891.5, 3842.3, 3793.6, 3764.0, 4405.3, 4402.8, 4346.0, 4287.6, 4229.8, 4172.9, 4116.7, 4061.4, 4006.8, 3952.9, 3899.7, 3848.9, 3800.5, 3752.9, 3706.1, 3660.1, 3614.9, 3570.2, 3526.3, 3483.0, 3440.5, 3398.6, 3398.3, 3621.1, 3595.6, 3550.4, 3506.0, 3462.3, 3419.2, 3376.8, 3335.0, 3293.8, 3253.2, 3213.4, 3175.5, 3138.2, 3101.4, 3065.3, 3029.7, 2994.7, 2960.1, 2926.1, 2893.9, 2892.6, 3002.9, 2993.6, 2959.8, 2926.4, 2893.5, 2861.0, 2829.0, 2797.3, 2766.1, 2735.3, 2704.8, 2675.0, 2645.5, 2616.4, 2587.2, 2558.1, 2529.3, 2500.9, 2472.8, 2445.0, 2417.6, 2390.4, 2363.6, 2337.1, 2310.9, 2285.0, 2259.4, 2234.1, 2209.1, 2184.3, 2159.8, 2135.6, 2111.7, 2088.0, 2064.6, 2041.1, 2018.0, 1995.1, 1972.4, 1950.0, 1927.9, 1906.0, 1884.3, 1862.9, 1841.7, 1820.8, 1800.1, 1779.6, 1759.4, 1739.4, 1719.5, 1699.6, 1680.0, 1660.7, 1641.5, 1622.5, 1603.7, 1585.0, 1566.5, 1548.3, 1530.3, 1512.5, 1494.8, 1475.8, 1457.0, 1438.4, 1420.1, 1402.1, 1384.3, 1366.7, 1349.4, 1332.3, 1315.4, 1298.7, 1282.1, 1265.9, 1249.8, 1233.9, 1218.3, 1202.9, 1187.7, 1172.7, 1157.8, 1143.2, 1128.7, 1114.4, 1100.3, 1086.5, 1072.7, 1059.2, 1045.9, 1032.7, 1019.7, 1006.9, 994.29, 981.83, 969.53, 957.39, 945.42, 933.61, 921.9, 910.12, 898.49, 887.03, 875.72, 864.56, 853.56, 842.7, 831.99, 821.42, 810.99, 800.71, 790.56, 780.55, 770.67, 760.93, 751.31, 741.83, 732.47, 723.24, 692.8, 583.7, 492.02, 415.17, 350.78, 296.77, 251.38, 212.14, 178.98, 151.2, 127.9, 116.74, 112.33, 111.19, 312.82, 307.2, 298.5, 252.75, 249.17, 239.23, 236.67, 324.85, 311.27, 301.31, 292.51, 288.23, 284.93, 324.18, 311.69, 282.6, 236.62, 198.87, 166.96, 139.95, 117.3, 98.349, 82.495, 69.051, 57.787, 48.302, 40.36, 33.752, 28.251, 23.668, 19.687, 16.347, 13.583, 11.296, 9.3978, 7.8085, 6.4856, 5.3673, 4.4414, 3.6759, 3.0447, 2.8047, 2.6875, 2.6573, 14.33, 13.885, 13.8, 11.693, 9.8139, 8.2298, 6.9001, 5.7745, 4.8172, 4.0192, 3.3538, 2.7989, 2.3362, 1.9428, 1.615, 1.3426, 1.1163, 0.92817, 0.77183, 0.64189, 0.53386, 0.44405, 0.36938, 0.30729, 0.25607, 0.21427, 0.1793, 0.15006, 0.12559, 0.10512, 0.087988, 0.073654, 0.061659, 0.0],
                    'energies (keV)': [0.0043215, 0.004386, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.028812, 0.02908327, 0.029253, 0.0293706, 0.029547, 0.029988, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.058604, 0.059501, 0.0597402, 0.060099, 0.06058959, 0.060996, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16751369, 0.16768632, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17660087, 0.17679912, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32033919, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36576056, 0.36663944, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44843083, 0.44872947, 0.44976915, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.409097, 1.4095029, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4529192, 1.4536808, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.8098795, 1.813351, 1.8137205, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0036337, 2.0079663, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2022856, 2.2027149, 2.2107145, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.190742, 8.31611, 8.349542, 8.399689, 8.44789, 8.525058, 9.030794, 9.079014, 9.217979, 9.255036, 9.310622, 9.449586, 9.556274, 9.653919, 9.702543, 9.741549, 9.800056, 9.946326, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 56.33579, 57.19807, 57.42801, 57.77293, 58.4927, 58.63521, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ni': {'mass_absorption_coefficient (cm2/g)': [96199.0, 96924.0, 97839.0, 98922.0, 100150.0, 101490.0, 102850.0, 104180.0, 105440.0, 106600.0, 107620.0, 108490.0, 109170.0, 109650.0, 109900.0, 109910.0, 109670.0, 109200.0, 108470.0, 107520.0, 106340.0, 104950.0, 103380.0, 101640.0, 99415.0, 96684.0, 93751.0, 90650.0, 89212.0, 88337.0, 87907.0, 104810.0, 102720.0, 102150.0, 91562.0, 81936.0, 73820.0, 66710.0, 60352.0, 54620.0, 50042.0, 49438.0, 48920.0, 48628.0, 51047.0, 49994.0, 47611.0, 43391.0, 39571.0, 36110.0, 32972.0, 30121.0, 27523.0, 25145.0, 22958.0, 20938.0, 19063.0, 17319.0, 15694.0, 14179.0, 12761.0, 11439.0, 10215.0, 9086.9, 8055.6, 7118.4, 6272.0, 5511.7, 4832.2, 4227.8, 3692.4, 3220.1, 2804.7, 2440.4, 2121.7, 1843.5, 1751.6, 1696.2, 1679.3, 9947.9, 9698.7, 9599.8, 9578.2, 13543.0, 13453.0, 12953.0, 11417.0, 9905.5, 9636.5, 9531.5, 9434.0, 10568.0, 10191.0, 9295.0, 7914.5, 6749.1, 5758.5, 4898.8, 4152.5, 3498.9, 2947.2, 2482.4, 2091.4, 1760.7, 1480.2, 1244.9, 1047.6, 882.12, 743.34, 623.01, 519.58, 432.25, 358.57, 297.83, 247.71, 205.31, 170.23, 141.27, 117.34, 97.561, 81.191, 67.631, 56.388, 47.057, 43.068, 41.34, 40.895, 332.05, 323.6, 317.83, 270.07, 228.08, 191.01, 159.13, 132.76, 110.78, 92.441, 77.148, 64.391, 53.744, 44.579, 36.929, 30.595, 25.349, 20.989, 17.381, 14.393, 11.865, 9.7658, 8.0386, 6.6173, 5.4404, 4.4537, 3.646, 2.985, 2.4439, 2.0009, 1.6382, 1.3413, 1.0983, 0.89927, 0.73636, 0.60298, 0.49308, 0.40193, 0.32765, 0.2671, 0.21775, 0.17752, 0.14473, 0.118, 0.096207, 0.078442, 0.063959, 0.052152, 0.042525, 0.034677, 0.028277, 0.023059, 0.018805, 0.015336, 0.012507, 0.0102, 0.008319, 0.0067849, 0.0055339, 0.0045136, 0.0036816, 0.003003, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.066738, 0.0677595, 0.0680319, 0.0684405, 0.06923942, 0.069462, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.109564, 0.1104581, 0.111241, 0.1116882, 0.112359, 0.114036, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.837606, 0.8504265, 0.854462, 0.8589735, 0.8675405, 0.8710281, 0.871794, 0.8739896, 0.8762595, 0.889338, 0.9342948, 0.987938, 0.9987612, 1.00306, 1.007092, 1.013141, 1.028262, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.166144, 8.291136, 8.324467, 8.374464, 8.44789, 8.499456, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Na': {'mass_absorption_coefficient (cm2/g)': [86393.0, 89898.0, 101880.0, 121220.0, 140000.0, 156860.0, 170960.0, 181720.0, 188790.0, 192120.0, 191860.0, 188360.0, 186440.0, 185020.0, 184630.0, 191510.0, 190190.0, 189900.0, 182730.0, 173920.0, 163720.0, 152550.0, 140810.0, 128850.0, 116980.0, 105430.0, 94384.0, 83986.0, 74278.0, 65318.0, 57149.0, 49779.0, 43189.0, 37342.0, 32190.0, 27675.0, 23739.0, 20322.0, 17366.0, 14816.0, 12621.0, 10738.0, 9125.5, 7747.4, 6571.8, 5570.4, 4718.6, 3994.8, 3380.4, 2859.4, 2417.2, 2030.7, 1705.4, 1431.9, 1202.2, 1009.5, 847.9, 712.4, 598.84, 520.58, 498.01, 493.73, 5685.5, 6033.1, 6770.9, 6135.4, 4951.7, 3829.1, 3125.5, 2592.6, 2181.0, 1851.0, 1575.8, 1339.6, 1124.8, 936.91, 780.44, 650.13, 541.6, 449.39, 371.49, 307.11, 253.9, 209.91, 173.55, 143.49, 117.81, 96.698, 79.372, 65.153, 53.482, 43.902, 36.039, 29.585, 24.287, 19.898, 16.185, 13.165, 10.709, 8.7112, 7.0861, 5.7642, 4.689, 3.8143, 3.1029, 2.5241, 2.0533, 1.6704, 1.3589, 1.105, 0.89501, 0.72491, 0.58543, 0.47222, 0.38086, 0.30717, 0.24775, 0.19982, 0.16116, 0.12998, 0.10484, 0.084554, 0.068197, 0.055004, 0.044364, 0.035782, 0.02886, 0.023278, 0.018775, 0.015143, 0.012214, 0.0098513, 0.0079457, 0.0064088, 0.0051691, 0.0041693, 0.0033628, 0.0027124, 0.0021877, 0.0017646, 0.0014233, 0.001148, 0.00092595, 0.00074686, 0.0006024, 0.00048589, 0.00039191, 0.00031611, 0.00025497, 0.00020566, 0.00016588, 0.0001338, 0.00010792, 8.7048e-05, 0.0],
                    'energies (keV)': [0.0312555, 0.031722, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.062034, 0.0629835, 0.0632367, 0.0636165, 0.064566, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.050658, 1.067676, 1.071028, 1.077461, 1.093542, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Nb': {'mass_absorption_coefficient (cm2/g)': [187540.0, 170140.0, 151630.0, 132900.0, 114680.0, 97604.0, 82109.0, 68422.0, 56593.0, 46553.0, 38153.0, 31207.0, 25514.0, 20877.0, 17119.0, 14080.0, 11627.0, 9644.9, 9259.8, 9158.5, 125020.0, 115480.0, 99903.0, 70207.0, 50270.0, 36867.0, 27684.0, 21273.0, 16713.0, 13409.0, 13219.0, 12611.0, 12458.0, 13137.0, 12625.0, 11929.0, 10239.0, 8967.2, 7987.4, 7216.2, 6595.4, 6084.0, 5653.0, 5281.8, 4955.4, 4663.0, 4396.9, 4151.3, 3921.6, 3704.3, 3496.9, 3297.8, 3105.7, 2931.6, 2919.8, 2894.4, 2890.0, 2879.1, 5825.7, 5892.1, 5968.5, 8091.1, 8133.2, 8628.3, 9341.8, 13060.0, 17572.0, 21814.0, 25104.0, 27052.0, 27601.0, 26943.0, 26213.0, 25834.0, 25729.0, 28398.0, 28217.0, 27963.0, 27916.0, 27441.0, 27311.0, 28295.0, 27795.0, 27213.0, 24745.0, 22189.0, 21305.0, 20734.0, 20585.0, 21260.0, 20702.0, 20574.0, 18172.0, 15966.0, 13971.0, 12189.0, 10605.0, 9208.4, 7982.8, 6908.8, 5968.0, 5147.9, 4436.1, 3764.0, 3195.1, 2714.5, 2308.3, 1965.1, 1671.3, 1415.6, 1199.9, 1018.6, 865.13, 735.23, 625.61, 563.53, 543.38, 538.19, 2147.6, 2135.4, 2050.1, 2043.8, 1960.0, 1936.9, 2665.0, 2555.1, 2478.4, 2231.4, 2145.6, 2123.6, 2407.4, 2394.3, 2321.3, 2035.5, 1724.7, 1450.0, 1218.2, 1023.5, 860.31, 723.62, 609.16, 511.09, 427.14, 356.52, 297.56, 248.57, 207.81, 173.71, 145.32, 121.68, 101.73, 84.401, 70.071, 57.992, 47.978, 39.569, 32.663, 26.988, 22.319, 18.473, 15.304, 13.092, 12.69, 12.547, 12.407, 86.967, 83.372, 74.955, 62.803, 52.799, 44.392, 37.185, 30.997, 25.805, 21.485, 17.891, 14.9, 12.364, 10.22, 8.4478, 6.9837, 5.7736, 4.773, 3.9453, 3.2596, 2.6933, 2.2255, 1.8391, 1.5179, 1.2467, 1.0237, 0.84063, 0.69034, 0.56695, 0.46564, 0.38245, 0.31413, 0.25803, 0.21196, 0.17412, 0.14304, 0.11751, 0.096546, 0.079322, 0.065174, 0.053551, 0.044002, 0.036157, 0.029712, 0.024416, 0.020065, 0.01649, 0.013552, 0.011138, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.0337305, 0.0338661, 0.0340695, 0.034578, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.056938, 0.0578095, 0.0580419, 0.0583905, 0.059262, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.200508, 0.2013709, 0.203252, 0.203577, 0.2043954, 0.205623, 0.206363, 0.2071926, 0.208437, 0.208692, 0.211548, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.35574, 0.361185, 0.362637, 0.364815, 0.3671099, 0.37026, 0.370832, 0.376508, 0.3780216, 0.380292, 0.385968, 0.3924405, 0.4195189, 0.4484657, 0.459032, 0.466058, 0.4679316, 0.470742, 0.477768, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.32309, 2.358648, 2.36813, 2.377781, 2.382353, 2.415406, 2.41791, 2.452376, 2.462235, 2.477023, 2.513994, 2.541848, 2.643746, 2.684212, 2.695002, 2.711189, 2.717235, 2.751654, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.60589, 18.81398, 18.89067, 18.96661, 19.08053, 19.36531, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Nd': {'mass_absorption_coefficient (cm2/g)': [7394.4, 7692.6, 8017.8, 8369.8, 8748.0, 9152.0, 9580.6, 10032.0, 10505.0, 10996.0, 11445.0, 11502.0, 11562.0, 11593.0, 200770.0, 190960.0, 170280.0, 136570.0, 108690.0, 86231.0, 68802.0, 55632.0, 45868.0, 38726.0, 35892.0, 34762.0, 34478.0, 34227.0, 33714.0, 33260.0, 30012.0, 27361.0, 25457.0, 24083.0, 23078.0, 22250.0, 20810.0, 19480.0, 18227.0, 17031.0, 15878.0, 14763.0, 13684.0, 12643.0, 12127.0, 12052.0, 11978.0, 11903.0, 11829.0, 11755.0, 11682.0, 11608.0, 11535.0, 11462.0, 11389.0, 11317.0, 11244.0, 11172.0, 11100.0, 11029.0, 10957.0, 10886.0, 10815.0, 10745.0, 10674.0, 10604.0, 10534.0, 10465.0, 10395.0, 10326.0, 10257.0, 10189.0, 10120.0, 10052.0, 9984.2, 9916.6, 9849.2, 9827.9, 81489.0, 81489.0, 78014.0, 72970.0, 68290.0, 63946.0, 59915.0, 56173.0, 52700.0, 49475.0, 46481.0, 43701.0, 41120.0, 38722.0, 36495.0, 34425.0, 32503.0, 30716.0, 29055.0, 27511.0, 26076.0, 24742.0, 23524.0, 22412.0, 21395.0, 20465.0, 19611.0, 18826.0, 18104.0, 17438.0, 16822.0, 16252.0, 15724.0, 15233.0, 14777.0, 14351.0, 13954.0, 13583.0, 13235.0, 12909.0, 12602.0, 12313.0, 12042.0, 11785.0, 11543.0, 11313.0, 11095.0, 10889.0, 10693.0, 10506.0, 10328.0, 10158.0, 9995.4, 9840.2, 9691.6, 9549.1, 9412.4, 9281.0, 9154.7, 9033.1, 8915.9, 8802.9, 8693.8, 8588.5, 8486.6, 8388.0, 8292.5, 8200.0, 8110.2, 8023.1, 7938.6, 7856.4, 7776.5, 7698.8, 7623.2, 7549.5, 7477.7, 7407.8, 7339.6, 7273.1, 7208.1, 7144.7, 7082.8, 7022.4, 6963.3, 6905.5, 6849.0, 6793.8, 6739.8, 6686.9, 6635.2, 6584.6, 6535.0, 6486.5, 6439.0, 6392.5, 6346.9, 6302.3, 6258.5, 6215.7, 6173.8, 6132.7, 6092.4, 6052.9, 6014.3, 5976.4, 5939.3, 5903.0, 5867.4, 5832.5, 5798.4, 5764.9, 5732.2, 5700.1, 5668.7, 5637.9, 5607.8, 5578.4, 5549.6, 5521.3, 5493.8, 5466.8, 5440.4, 5414.6, 5389.3, 5364.7, 5340.6, 5317.0, 5294.0, 5271.6, 5249.6, 5228.3, 5225.6, 6523.5, 6508.9, 6487.2, 6465.9, 6445.2, 6424.9, 6405.1, 6385.8, 6367.0, 6348.6, 6330.7, 6313.2, 6296.2, 6279.6, 6263.5, 6247.8, 6232.5, 6230.2, 6619.6, 6610.5, 6595.8, 6581.5, 6567.7, 6554.2, 6541.0, 6528.1, 6515.6, 6503.4, 6491.5, 6479.9, 6468.6, 6457.5, 6446.8, 6436.3, 6426.1, 6416.2, 6406.5, 6397.0, 6387.8, 6378.8, 6370.0, 6361.4, 6353.0, 6344.9, 6336.9, 6329.0, 6321.4, 6313.9, 6306.5, 6299.3, 6292.2, 6285.3, 6278.5, 6271.7, 6265.1, 6258.6, 6252.1, 6245.8, 6239.5, 6233.2, 6227.1, 6220.9, 6214.8, 6208.7, 6202.7, 6196.6, 6190.6, 6184.5, 6178.5, 6172.4, 6166.3, 6644.9, 6640.2, 6632.7, 6625.1, 6617.4, 6609.7, 6601.9, 6594.1, 6586.2, 6578.2, 6570.1, 6561.8, 6553.5, 6545.1, 6536.6, 6527.9, 6519.1, 6510.1, 6501.1, 6491.8, 6482.4, 6472.9, 6463.1, 6453.2, 6443.1, 6432.7, 6422.2, 6411.5, 6400.6, 6389.4, 6378.1, 6366.5, 6354.7, 6342.7, 6330.4, 6317.9, 6305.2, 6292.3, 6279.1, 6265.7, 6252.0, 6238.1, 6224.0, 6209.6, 6195.0, 6180.1, 6165.0, 6149.5, 6133.8, 6117.8, 6101.6, 6085.2, 6068.5, 6051.6, 6034.4, 6016.9, 5999.2, 5981.3, 5963.1, 5944.7, 5926.1, 5907.2, 5888.0, 5868.7, 5849.0, 5829.2, 5809.1, 5788.8, 5768.3, 5747.6, 5726.6, 5705.4, 5684.0, 5662.4, 5640.5, 5618.5, 5596.3, 5573.8, 5551.2, 5528.3, 5505.3, 5482.1, 5458.6, 5434.9, 5411.0, 5386.9, 5362.5, 5337.9, 5313.2, 5288.2, 5263.0, 5237.7, 5212.1, 5186.4, 5160.6, 5134.5, 5108.3, 5082.0, 5055.5, 5028.9, 5002.1, 4975.3, 4948.3, 4921.2, 4893.9, 4866.6, 4839.2, 4811.7, 4784.1, 4756.5, 4728.7, 4700.9, 4673.0, 4645.1, 4617.2, 4589.1, 4561.1, 4533.0, 4504.9, 4476.7, 4448.5, 4420.4, 4392.2, 4364.0, 4335.8, 4307.6, 4279.4, 4251.2, 4223.1, 4195.0, 4166.9, 4138.8, 4110.7, 4082.7, 4054.8, 4026.9, 3999.0, 3971.2, 3943.5, 3915.8, 3888.1, 3860.6, 3833.1, 3805.7, 3778.3, 3751.1, 3723.9, 3696.8, 3669.8, 3642.9, 3616.1, 3589.4, 3562.7, 3536.2, 3509.8, 3483.5, 3457.2, 3431.1, 3405.2, 3379.3, 3353.5, 3327.9, 3302.3, 3276.9, 3251.6, 3226.4, 3201.3, 3176.4, 3151.6, 3126.9, 3102.4, 3077.9, 3053.7, 3029.5, 3005.5, 2981.6, 2957.8, 2934.2, 2910.7, 2887.4, 2864.2, 2841.1, 2818.2, 2795.4, 2772.8, 2750.3, 2727.9, 2705.7, 2683.6, 2661.7, 2639.9, 2618.2, 2596.7, 2575.3, 2554.1, 2533.0, 2512.1, 2491.3, 2470.6, 2450.1, 2429.7, 2409.5, 2389.4, 2369.4, 2349.6, 2330.0, 2310.5, 2291.1, 2271.8, 2252.7, 2233.8, 2214.9, 2196.2, 2177.7, 2159.3, 2141.0, 2122.9, 2104.9, 2087.0, 2069.3, 2051.7, 2034.2, 2016.9, 1999.7, 1982.6, 1965.7, 1948.9, 1932.3, 1930.2, 7714.0, 7640.3, 7552.9, 7466.5, 7381.2, 7335.6, 11059.0, 11070.0, 10933.0, 10798.0, 10664.0, 10532.0, 10402.0, 10273.0, 10146.0, 10020.0, 9896.5, 9774.1, 9653.3, 9533.9, 9416.0, 9299.6, 9184.7, 9071.1, 8959.0, 8848.3, 8739.0, 8631.0, 8524.4, 8419.1, 8315.1, 8212.4, 8111.0, 8010.9, 7912.0, 7814.3, 7717.9, 7622.6, 7528.6, 7435.7, 7343.9, 7253.3, 7163.9, 7075.5, 6988.3, 6902.1, 6817.0, 6733.0, 6650.0, 6568.0, 6487.1, 6407.2, 6328.2, 6250.3, 6173.2, 6097.1, 6022.0, 5947.8, 5874.5, 5821.3, 6798.5, 6797.9, 6709.6, 6622.0, 6535.5, 6450.1, 6365.9, 6282.8, 6200.9, 6120.0, 6040.2, 5964.0, 5891.4, 5819.9, 5749.7, 5680.6, 5612.5, 5585.9, 5950.1, 5925.7, 5853.8, 5782.9, 5713.2, 5644.5, 5576.9, 5510.2, 5444.6, 5380.0, 5316.3, 5255.1, 5195.2, 5136.2, 5078.1, 5021.0, 4964.7, 4909.3, 4854.7, 4800.9, 4747.9, 4695.7, 4644.2, 4593.5, 4567.2, 4760.4, 4758.3, 4709.2, 4658.7, 4608.9, 4559.7, 4511.2, 4463.3, 4416.0, 4369.3, 4323.2, 4276.8, 4230.5, 4184.8, 4139.7, 4094.1, 4047.6, 4001.7, 3956.3, 3911.4, 3867.1, 3823.3, 3780.0, 3737.2, 3694.8, 3653.0, 3611.6, 3570.8, 3530.3, 3490.4, 3450.8, 3411.2, 3371.9, 3333.1, 3294.7, 3256.7, 3219.1, 3182.0, 3145.3, 3108.9, 3073.0, 3037.5, 3002.4, 2967.6, 2933.3, 2899.4, 2865.8, 2832.6, 2799.8, 2767.3, 2735.2, 2703.5, 2672.1, 2641.1, 2610.4, 2580.0, 2549.9, 2520.1, 2490.7, 2461.6, 2432.9, 2404.5, 2376.4, 2348.7, 2321.2, 2294.1, 2267.3, 2240.8, 2214.7, 2188.6, 2162.7, 2137.1, 2111.8, 2086.8, 2062.1, 2037.7, 2013.6, 1989.8, 1966.3, 1943.0, 1920.1, 1897.4, 1875.0, 1852.9, 1831.0, 1809.5, 1788.1, 1767.1, 1746.3, 1725.7, 1705.5, 1685.4, 1665.6, 1646.1, 1626.8, 1607.7, 1588.9, 1570.3, 1551.9, 1533.8, 1515.8, 1498.1, 1480.4, 1462.9, 1445.6, 1428.5, 1411.7, 1395.0, 1378.6, 1362.3, 1346.3, 1330.4, 1314.8, 1299.4, 1284.1, 1269.0, 1254.1, 1239.4, 1224.8, 1210.3, 1196.0, 1181.9, 1168.0, 1154.3, 1140.7, 1127.3, 1114.0, 1101.0, 1088.0, 1075.3, 1062.6, 1049.0, 1035.5, 1022.2, 1009.1, 996.2, 983.43, 970.84, 958.41, 946.15, 934.03, 922.03, 910.19, 898.51, 886.98, 875.6, 864.38, 853.3, 842.37, 831.58, 820.94, 810.43, 800.07, 789.84, 779.75, 769.79, 759.96, 750.27, 740.7, 731.26, 721.94, 712.75, 703.67, 694.72, 685.89, 677.17, 668.57, 660.08, 651.7, 643.43, 635.28, 627.23, 619.28, 611.45, 603.71, 596.08, 588.55, 581.11, 573.78, 566.54, 559.4, 552.35, 545.39, 538.53, 531.61, 524.76, 518.01, 511.35, 489.38, 411.02, 345.67, 291.16, 245.7, 207.61, 174.83, 172.46, 165.75, 164.03, 489.89, 467.96, 438.05, 415.41, 398.1, 393.69, 539.41, 516.72, 503.99, 489.98, 469.42, 464.31, 528.8, 509.29, 488.1, 413.14, 348.97, 293.61, 245.31, 205.03, 171.51, 143.61, 120.22, 100.38, 83.627, 69.532, 57.863, 48.194, 40.174, 33.513, 27.982, 23.386, 19.563, 16.381, 13.601, 11.254, 9.29, 7.6591, 6.3161, 5.2127, 4.3056, 4.0797, 3.9065, 3.862, 22.521, 21.685, 21.255, 17.874, 14.987, 12.554, 10.501, 8.774, 7.3302, 6.1236, 5.1153, 4.2671, 3.5491, 2.9413, 2.4379, 2.0208, 1.6752, 1.3889, 1.1515, 0.95486, 0.79183, 0.65668, 0.54464, 0.45175, 0.37514, 0.312, 0.2595, 0.21585, 0.17955, 0.14937, 0.12426, 0.10339, 0.086019, 0.071574, 0.059557, 0.049561, 0.041244, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.020678, 0.02083314, 0.0209945, 0.0210789, 0.0212055, 0.021522, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03675, 0.0373125, 0.0374625, 0.0376875, 0.03797993, 0.03825, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11748954, 0.11751046, 0.11751048, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22447692, 0.22472308, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24315743, 0.24344258, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3155152, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.97760223, 0.97779777, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 0.99936105, 0.99963891, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2965165, 1.2982423, 1.2982835, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4018615, 1.4037384, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5732678, 1.5770017, 1.5773321, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.083742, 6.176861, 6.201692, 6.23894, 6.332058, 6.469004, 6.58707, 6.687892, 6.714778, 6.755107, 6.85593, 6.915365, 6.98348, 7.09037, 7.118874, 7.16163, 7.26852, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 42.69752, 43.35106, 43.52533, 43.78675, 44.44028, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ne': {'mass_absorption_coefficient (cm2/g)': [250390.0, 251630.0, 255270.0, 260940.0, 266170.0, 270600.0, 273930.0, 275900.0, 276320.0, 275050.0, 272000.0, 267150.0, 260550.0, 252310.0, 242560.0, 240030.0, 237550.0, 236890.0, 241260.0, 239000.0, 237340.0, 226590.0, 215160.0, 203110.0, 190620.0, 177840.0, 164950.0, 152090.0, 139320.0, 126760.0, 114600.0, 103000.0, 92050.0, 81840.0, 72414.0, 63791.0, 55968.0, 48925.0, 42627.0, 37029.0, 32081.0, 27728.0, 23910.0, 20577.0, 17677.0, 15162.0, 12988.0, 11112.0, 9498.4, 8112.2, 6923.5, 5844.0, 4928.6, 4154.1, 3499.8, 2947.6, 2482.1, 2089.9, 1759.8, 1481.9, 1248.2, 1051.6, 886.32, 747.31, 677.32, 650.76, 643.92, 10215.0, 10143.0, 9881.3, 8733.9, 7500.6, 6357.9, 5366.6, 4516.3, 3793.1, 3182.1, 2665.1, 2223.4, 1854.5, 1546.4, 1289.2, 1074.5, 895.25, 745.72, 621.01, 517.03, 430.39, 356.85, 294.8, 242.97, 199.32, 163.53, 134.16, 110.07, 90.306, 74.093, 60.791, 49.879, 40.925, 33.58, 27.553, 22.608, 18.551, 15.192, 12.353, 10.045, 8.1677, 6.6416, 5.4007, 4.3917, 3.5712, 2.904, 2.3598, 1.9106, 1.5469, 1.2525, 1.0139, 0.82082, 0.66448, 0.53792, 0.43387, 0.34953, 0.28158, 0.22684, 0.18275, 0.14722, 0.1186, 0.095549, 0.076976, 0.062013, 0.049959, 0.040248, 0.032425, 0.026122, 0.021045, 0.016954, 0.013667, 0.011031, 0.0089035, 0.0071863, 0.0058003, 0.0046816, 0.0037787, 0.0030499, 0.0024617, 0.001987, 0.0016037, 0.0012945, 0.0010448, 0.00084331, 0.00068067, 0.0005494, 0.00044344, 0.00035792, 0.0002889, 0.00023318, 0.00018821, 0.00015191, 0.00012262, 9.897e-05, 7.9883e-05, 6.4478e-05, 0.0],
                    'energies (keV)': [0.0183915, 0.018666, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.0441, 0.044775, 0.044955, 0.045225, 0.0459, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.849562, 0.8625655, 0.8660331, 0.8712345, 0.8739896, 0.884238, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Fr': {'mass_absorption_coefficient (cm2/g)': [258930.0, 257090.0, 247360.0, 209240.0, 170230.0, 138270.0, 112060.0, 91808.0, 90598.0, 87442.0, 86322.0, 207310.0, 195480.0, 172970.0, 132970.0, 103760.0, 82163.0, 65763.0, 53048.0, 43030.0, 35038.0, 28601.0, 28270.0, 27000.0, 26674.0, 28550.0, 27240.0, 25338.0, 20536.0, 16682.0, 13576.0, 11060.0, 9017.1, 7356.3, 6008.9, 4916.9, 4032.3, 3934.9, 3762.8, 3718.8, 32358.0, 34772.0, 38107.0, 44199.0, 47848.0, 48870.0, 81488.0, 86336.0, 87206.0, 107820.0, 115640.0, 104420.0, 82662.0, 59546.0, 40300.0, 26327.0, 16975.0, 10998.0, 7258.7, 4929.6, 4150.1, 3833.2, 3754.8, 5525.4, 5296.0, 5183.3, 4032.0, 3163.0, 2568.1, 2533.2, 2427.7, 2401.2, 3345.8, 3198.0, 2996.9, 2494.5, 2123.3, 1848.2, 1842.1, 1790.0, 1776.7, 1913.3, 1866.5, 1793.7, 1747.8, 1709.5, 1699.7, 1791.5, 1787.1, 1783.1, 1781.8, 1781.8, 1781.9, 1860.5, 1889.5, 2089.6, 2826.8, 4155.4, 6003.2, 8114.0, 10141.0, 11777.0, 12843.0, 13300.0, 13214.0, 12935.0, 12893.0, 12848.0, 12802.0, 12754.0, 12705.0, 12653.0, 12601.0, 12547.0, 12491.0, 12434.0, 12376.0, 12316.0, 12255.0, 12193.0, 12130.0, 12066.0, 12001.0, 11934.0, 11867.0, 11799.0, 11730.0, 11660.0, 11590.0, 11519.0, 11447.0, 11374.0, 11301.0, 11227.0, 11183.0, 11973.0, 11963.0, 11891.0, 11819.0, 11747.0, 11675.0, 11602.0, 11528.0, 11455.0, 11381.0, 11342.0, 11792.0, 11776.0, 11705.0, 11633.0, 11560.0, 11488.0, 11416.0, 11343.0, 11271.0, 11198.0, 11126.0, 11054.0, 10981.0, 10909.0, 10836.0, 10764.0, 10691.0, 10618.0, 10546.0, 10473.0, 10400.0, 10328.0, 10255.0, 10183.0, 10110.0, 10038.0, 9965.6, 9893.4, 9821.2, 9749.1, 9677.1, 9605.3, 9533.6, 9462.1, 9390.8, 9319.6, 9248.5, 9177.6, 9106.9, 9036.5, 8966.3, 8896.3, 8826.6, 8757.2, 8688.0, 8619.1, 8550.5, 8482.2, 8414.2, 8346.6, 8279.2, 8212.2, 8145.5, 8079.2, 8013.2, 7947.6, 7882.4, 7817.5, 7753.0, 7688.8, 7659.6, 8109.3, 8043.8, 7978.8, 7914.2, 7850.0, 7786.2, 7722.8, 7659.9, 7597.3, 7535.2, 7473.5, 7412.3, 7351.5, 7291.1, 7231.2, 7171.7, 7112.7, 7054.1, 6995.9, 6938.2, 6881.0, 6824.1, 6767.7, 6711.8, 6656.3, 6601.2, 6546.5, 6492.4, 6438.6, 6385.3, 6332.4, 6280.0, 6228.0, 6176.5, 6125.3, 6074.7, 6024.4, 5974.5, 5941.7, 6003.1, 5992.2, 5952.1, 5901.6, 5851.6, 5801.7, 5738.8, 5676.7, 5615.4, 5554.6, 5493.3, 5432.5, 5372.4, 5313.0, 5254.4, 5196.4, 5139.2, 5082.7, 5026.8, 4971.6, 4917.1, 4863.2, 4809.9, 4757.3, 4705.3, 4653.9, 4603.1, 4552.9, 4503.2, 4454.0, 4405.4, 4357.4, 4309.9, 4263.0, 4250.0, 4318.8, 4307.6, 4261.2, 4215.4, 4170.1, 4125.4, 4081.1, 4037.4, 3994.2, 3951.5, 3909.4, 3867.8, 3826.7, 3786.0, 3745.9, 3706.3, 3667.1, 3628.3, 3590.1, 3552.2, 3514.9, 3477.9, 3441.4, 3405.4, 3369.7, 3334.5, 3299.7, 3265.3, 3231.3, 3197.6, 3164.4, 3131.6, 3099.1, 3067.1, 3035.3, 3004.0, 2972.7, 2941.7, 2911.1, 2880.9, 2851.0, 2821.5, 2792.2, 2763.4, 2734.8, 2706.6, 2678.7, 2651.1, 2623.9, 2596.9, 2570.3, 2543.9, 2517.9, 2492.1, 2466.6, 2441.3, 2416.3, 2391.6, 2367.2, 2343.1, 2319.2, 2295.6, 2272.3, 2249.2, 2226.4, 2203.8, 2181.5, 2159.5, 2137.6, 2116.1, 2094.7, 2073.7, 2052.8, 2032.2, 2011.7, 1991.4, 1971.3, 1951.4, 1931.8, 1912.4, 1893.2, 1874.2, 1855.4, 1836.8, 1818.4, 1800.2, 1782.3, 1764.5, 1746.9, 1729.5, 1712.3, 1695.3, 1678.4, 1661.8, 1645.3, 1629.0, 1612.9, 1597.0, 1581.2, 1565.6, 1550.2, 1534.9, 1519.9, 1504.9, 1490.2, 1475.5, 1461.1, 1446.8, 1432.7, 1418.7, 1404.8, 1391.1, 1377.6, 1364.2, 1351.0, 1337.8, 1324.9, 1312.0, 1299.3, 1286.8, 1274.4, 1262.1, 1249.9, 1237.9, 1226.0, 1214.2, 1202.5, 1191.0, 1179.6, 1168.3, 1157.2, 1146.1, 1135.2, 1124.4, 1113.7, 1103.1, 1092.6, 1082.2, 1072.0, 1061.8, 1051.5, 1040.9, 1030.4, 1020.0, 1009.7, 999.48, 989.41, 979.46, 969.6, 959.69, 949.62, 939.67, 929.83, 920.09, 910.47, 900.95, 891.53, 882.2, 872.98, 863.86, 854.84, 845.92, 837.1, 828.38, 819.76, 811.23, 802.8, 794.46, 786.21, 778.06, 770.0, 762.02, 754.14, 746.34, 738.63, 731.0, 723.46, 716.0, 708.62, 701.33, 694.12, 686.98, 679.92, 672.95, 666.04, 659.22, 652.47, 645.79, 639.19, 632.66, 626.2, 619.81, 613.49, 612.43, 1622.8, 1607.3, 1585.9, 1564.7, 1543.9, 1523.3, 1503.0, 1483.0, 1463.3, 1443.9, 1442.2, 2079.5, 2057.6, 2030.2, 2003.2, 1976.5, 1950.2, 1924.2, 1898.6, 1873.2, 1848.2, 1823.6, 1799.2, 1775.2, 1751.5, 1728.2, 1705.1, 1682.4, 1660.0, 1637.9, 1616.1, 1594.5, 1573.3, 1552.4, 1531.7, 1511.3, 1491.2, 1471.4, 1451.8, 1432.6, 1413.5, 1394.7, 1376.2, 1375.5, 1614.9, 1604.3, 1582.4, 1560.8, 1539.4, 1518.4, 1497.6, 1477.2, 1457.0, 1437.1, 1417.6, 1399.2, 1381.0, 1363.1, 1345.4, 1327.8, 1310.6, 1293.6, 1276.8, 1260.4, 1244.1, 1228.2, 1212.4, 1196.7, 1181.3, 1166.1, 1151.2, 1136.4, 1121.9, 1107.6, 1093.4, 1079.5, 1065.8, 1052.3, 1047.0, 1106.6, 1106.2, 1092.6, 1079.2, 1066.0, 1053.0, 1040.1, 1027.4, 1014.9, 1002.5, 990.32, 978.26, 966.36, 954.62, 943.02, 934.01, 931.56, 965.53, 961.15, 949.73, 938.45, 927.31, 916.28, 905.18, 894.22, 883.39, 872.69, 862.13, 851.68, 841.36, 831.17, 821.1, 811.15, 801.32, 791.6, 782.01, 772.53, 763.17, 753.92, 744.78, 735.76, 726.85, 718.05, 709.35, 700.76, 692.28, 683.9, 675.63, 667.45, 659.38, 651.41, 643.53, 635.75, 628.07, 620.49, 612.99, 605.55, 598.18, 590.9, 583.72, 576.62, 569.61, 562.68, 555.85, 549.09, 542.42, 535.84, 529.33, 522.91, 516.48, 510.1, 503.79, 497.56, 491.41, 485.33, 479.34, 473.42, 467.58, 461.75, 455.99, 450.3, 444.69, 439.15, 433.68, 428.29, 422.96, 417.7, 412.51, 407.38, 402.33, 397.34, 392.41, 387.55, 382.75, 378.01, 373.33, 368.72, 364.16, 359.67, 355.23, 350.85, 346.53, 342.26, 338.05, 333.89, 329.79, 325.74, 321.75, 317.8, 313.88, 309.99, 306.15, 302.37, 298.63, 294.94, 291.3, 287.71, 284.16, 280.66, 277.21, 273.8, 270.43, 267.11, 263.83, 260.6, 257.4, 254.25, 251.14, 248.07, 245.03, 242.04, 239.09, 236.17, 233.29, 230.45, 227.65, 224.88, 222.15, 219.45, 216.79, 188.41, 157.6, 132.0, 110.71, 92.914, 78.095, 65.646, 55.128, 52.034, 50.026, 49.51, 123.16, 118.48, 117.09, 97.977, 82.32, 81.666, 78.968, 78.105, 108.61, 104.41, 100.3, 99.236, 113.05, 111.82, 108.91, 94.398, 79.518, 66.988, 56.436, 47.555, 39.84, 33.335, 27.842, 23.276, 19.463, 16.223, 13.522, 11.278, 9.4146, 7.8647, 6.5749, 5.5007, 4.6053, 3.8553, 3.2258, 2.7015, 2.2546, 1.8662, 1.5459, 1.3048, 1.2815, 1.2504, 1.2364, 5.6165, 5.4082, 4.9688, 4.1864, 3.5229, 2.9629, 2.4915, 2.0932, 1.7574, 1.4754, 1.2388, 1.0402, 0.8735, 0.73385, 0.61664, 0.51821, 0.43554, 0.3661, 0.30777, 0.25875, 0.21756, 0.18295, 0.15385, 0.1294, 0.0],
                    'energies (keV)': [0.01066532, 0.01069, 0.0108245, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01486167, 0.01492335, 0.01508915, 0.01514981, 0.0152408, 0.01546827, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02731051, 0.02772853, 0.02784, 0.02800721, 0.02842523, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05346183, 0.05428013, 0.05449834, 0.05482565, 0.05564395, 0.05667876, 0.05834708, 0.05924014, 0.05947829, 0.05983552, 0.06058959, 0.06072859, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1302983, 0.1322926, 0.1328244, 0.1336222, 0.1349368, 0.1356165, 0.1442475, 0.1542005, 0.1648404, 0.1656291, 0.1681643, 0.1688403, 0.1698543, 0.1723895, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2156348, 0.2189353, 0.2198155, 0.2211357, 0.2244362, 0.2301188, 0.2340857, 0.2376687, 0.2386241, 0.2400573, 0.2415586, 0.2436403, 0.245256, 0.245997, 0.2462419, 0.2477208, 0.2514182, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57662439, 0.57737565, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60290602, 0.60369393, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.8089146, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.97859862, 0.98036623, 0.98140142, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1516164, 1.1543836, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 2.9988482, 3.000552, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.135234, 3.1371659, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6585679, 3.6674323, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3208125, 4.3331878, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6423238, 4.6472882, 4.6616761, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 14.73058, 14.95604, 15.01617, 15.10636, 15.33182, 15.40095, 16.46362, 17.54837, 17.59961, 17.81697, 17.88859, 17.99603, 18.26622, 18.5458, 18.62036, 18.73219, 18.81398, 19.01178, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.11426, 99.75239, 100.6313, 101.0359, 101.6427, 103.1597, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Fe': {'mass_absorption_coefficient (cm2/g)': [100370.0, 101300.0, 102340.0, 103460.0, 104640.0, 105830.0, 106910.0, 107850.0, 108610.0, 109170.0, 109490.0, 109560.0, 109370.0, 108910.0, 108180.0, 107180.0, 105920.0, 104270.0, 102160.0, 99741.0, 97039.0, 94080.0, 90896.0, 87520.0, 84092.0, 83990.0, 83272.0, 83054.0, 111210.0, 108240.0, 102960.0, 92554.0, 84927.0, 77903.0, 70070.0, 63163.0, 57003.0, 51487.0, 50954.0, 49795.0, 49494.0, 52465.0, 51383.0, 49973.0, 45571.0, 41626.0, 38081.0, 34893.0, 32018.0, 29413.0, 27037.0, 24853.0, 22831.0, 20946.0, 19178.0, 17513.0, 15938.0, 14442.0, 13030.0, 11704.0, 10468.0, 9325.7, 8277.0, 7321.3, 6455.9, 5676.8, 4979.4, 4358.3, 3807.5, 3321.1, 2893.0, 2517.2, 2188.2, 2027.4, 1963.4, 1951.0, 1946.8, 12343.0, 12180.0, 12093.0, 11973.0, 16996.0, 16853.0, 16240.0, 14728.0, 12470.0, 12043.0, 11599.0, 11485.0, 12901.0, 12461.0, 12098.0, 10351.0, 8856.6, 7541.9, 6418.8, 5453.7, 4600.1, 3880.1, 3267.6, 2748.7, 2311.9, 1944.2, 1635.1, 1375.5, 1157.6, 974.76, 821.25, 692.39, 583.2, 486.11, 402.95, 333.27, 275.51, 227.98, 188.83, 156.56, 129.93, 107.93, 89.748, 74.699, 62.234, 51.899, 50.807, 48.757, 48.23, 411.05, 393.42, 372.05, 311.31, 262.89, 221.49, 185.01, 154.39, 128.85, 107.54, 89.77, 74.939, 62.448, 51.676, 42.751, 35.358, 29.245, 24.191, 20.012, 16.556, 13.697, 11.333, 9.333, 7.6746, 6.2905, 5.145, 4.2083, 3.4423, 2.8158, 2.3032, 1.884, 1.5411, 1.2607, 1.0313, 0.84372, 0.69026, 0.56472, 0.46203, 0.37736, 0.30699, 0.24975, 0.20319, 0.16531, 0.1345, 0.10943, 0.089031, 0.072438, 0.058938, 0.047955, 0.039019, 0.031749, 0.025833, 0.02102, 0.017104, 0.013918, 0.011325, 0.0092156, 0.0074991, 0.0061023, 0.0049658, 0.0040409, 0.0032883, 0.002676, 0.0021776, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05292, 0.05302035, 0.05373, 0.053946, 0.05427, 0.05508, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.091042, 0.0924355, 0.0928071, 0.0933645, 0.094758, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.693938, 0.7045595, 0.706678, 0.7073919, 0.7116405, 0.7154399, 0.7174945, 0.7203789, 0.722262, 0.7247055, 0.735522, 0.7648052, 0.8175768, 0.829178, 0.8418695, 0.8452539, 0.8503305, 0.863022, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 6.96976, 7.07644, 7.104888, 7.14756, 7.25424, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'B': {'mass_absorption_coefficient (cm2/g)': [965910.0, 937690.0, 232720.0, 206500.0, 182670.0, 161080.0, 157790.0, 153250.0, 152070.0, 189340.0, 186480.0, 183580.0, 173290.0, 164970.0, 157460.0, 150370.0, 143350.0, 136200.0, 128820.0, 121210.0, 113420.0, 105530.0, 97639.0, 89854.0, 82270.0, 74970.0, 68019.0, 61464.0, 55338.0, 49655.0, 44421.0, 39627.0, 35255.0, 31276.0, 27673.0, 24428.0, 21515.0, 18912.0, 16592.0, 14520.0, 12670.0, 11040.0, 9606.0, 8347.5, 7244.8, 6280.4, 5438.3, 4704.1, 4064.9, 3509.3, 3179.7, 3074.3, 3047.0, 81883.0, 81378.0, 78936.0, 71382.0, 62155.0, 53819.0, 46354.0, 39731.0, 33914.0, 28848.0, 24464.0, 20692.0, 17460.0, 14702.0, 12356.0, 10366.0, 8683.2, 7262.8, 6066.3, 5060.4, 4216.0, 3508.3, 2916.1, 2421.1, 2007.6, 1663.0, 1376.3, 1138.4, 933.38, 765.2, 627.32, 514.28, 421.62, 345.65, 283.37, 232.31, 190.45, 156.14, 128.01, 104.94, 86.034, 70.532, 57.824, 47.406, 38.702, 31.473, 25.583, 20.693, 16.737, 13.538, 10.95, 8.8568, 7.1638, 5.7945, 4.6868, 3.7902, 3.0649, 2.4785, 2.0042, 1.6207, 1.3087, 1.0512, 0.84441, 0.67829, 0.54485, 0.43766, 0.35156, 0.2824, 0.22684, 0.18221, 0.14637, 0.11757, 0.094443, 0.075864, 0.06094, 0.048951, 0.039321, 0.031514, 0.025239, 0.020213, 0.016188, 0.012965, 0.010383, 0.0083155, 0.0066597, 0.0053336, 0.0042715, 0.003421, 0.0027398, 0.0021942, 0.0017573, 0.0014074, 0.0011272, 0.0009045, 0.00072902, 0.00058758, 0.00047359, 0.00038171, 0.00030765, 0.00024797, 0.00019986, 0.00016108, 0.00012983, 0.00010464, 8.4342e-05, 6.7979e-05, 5.479e-05, 4.4161e-05, 3.5593e-05, 2.8688e-05, 2.3122e-05, 1.8636e-05, 1.5021e-05, 1.2107e-05, 9.7578e-06, 7.8647e-06, 6.3389e-06, 5.1091e-06, 4.1179e-06, 0.0],
                   'energies (keV)': [0.0047235, 0.004794, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0132006, 0.01340265, 0.01345653, 0.01353735, 0.0137394, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.18424, 0.18706, 0.187812, 0.1883732, 0.18894, 0.19176, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'F': {'mass_absorption_coefficient (cm2/g)': [545850.0, 546560.0, 548490.0, 542100.0, 532700.0, 520870.0, 507110.0, 491860.0, 475460.0, 458220.0, 440350.0, 422050.0, 403450.0, 384680.0, 365820.0, 346960.0, 328160.0, 309480.0, 297360.0, 293160.0, 292060.0, 299340.0, 298810.0, 295100.0, 282800.0, 266810.0, 250940.0, 235190.0, 219630.0, 204310.0, 189300.0, 174680.0, 160530.0, 146900.0, 133880.0, 121510.0, 109850.0, 98922.0, 88755.0, 79355.0, 70717.0, 62825.0, 55655.0, 49173.0, 43341.0, 38109.0, 33434.0, 29274.0, 25448.0, 21812.0, 18660.0, 15938.0, 13594.0, 11580.0, 9854.1, 8378.3, 7118.5, 6044.9, 5131.1, 4354.1, 3694.2, 3134.2, 2659.1, 2256.3, 1914.9, 1625.7, 1380.6, 1172.1, 988.52, 833.22, 825.51, 793.95, 785.82, 13724.0, 13244.0, 12529.0, 10673.0, 9080.5, 7712.4, 6541.2, 5542.4, 4675.7, 3940.7, 3299.0, 2754.7, 2298.5, 1916.7, 1597.4, 1330.6, 1108.0, 922.31, 767.55, 638.62, 531.27, 441.92, 367.58, 303.96, 250.05, 204.87, 167.85, 137.53, 112.68, 92.321, 75.642, 61.977, 50.782, 41.609, 34.093, 27.936, 22.89, 18.757, 15.369, 12.594, 10.301, 8.3693, 6.8001, 5.5252, 4.4893, 3.6477, 2.955, 2.3905, 1.9337, 1.5641, 1.2652, 1.0234, 0.82787, 0.66967, 0.5417, 0.43819, 0.35446, 0.28559, 0.22981, 0.18492, 0.1488, 0.11974, 0.096351, 0.077532, 0.062389, 0.050203, 0.040398, 0.032508, 0.026159, 0.02105, 0.016939, 0.01363, 0.010968, 0.008827, 0.007105, 0.005719, 0.0046033, 0.0037053, 0.0029825, 0.0024007, 0.0019324, 0.0015554, 0.001252, 0.0010078, 0.00081119, 0.00065295, 0.00052558, 0.00042306, 0.00034053, 0.00027411, 0.00022064, 0.0001776, 0.00014296, 0.00011507, 9.2625e-05, 7.4558e-05, 6.0014e-05, 4.8308e-05, 3.8885e-05, 0.0],
                   'energies (keV)': [0.008643, 0.008772, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03038, 0.030845, 0.030969, 0.03109002, 0.031155, 0.03162, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.671692, 0.681973, 0.6847146, 0.688827, 0.699108, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Sr': {'mass_absorption_coefficient (cm2/g)': [449530.0, 425200.0, 385630.0, 299840.0, 226370.0, 165710.0, 118950.0, 84538.0, 59956.0, 42709.0, 30716.0, 25473.0, 23721.0, 23281.0, 23186.0, 22940.0, 21720.0, 17271.0, 13356.0, 10626.0, 8701.4, 7325.5, 6324.6, 5580.6, 5013.5, 4569.0, 4210.4, 3912.8, 3660.2, 3441.6, 3248.1, 3073.6, 2913.7, 2765.5, 2626.5, 2561.1, 2533.3, 2531.3, 2523.5, 4477.7, 4542.9, 4616.9, 6030.7, 6049.4, 6492.4, 8425.9, 12730.0, 18150.0, 23927.0, 29232.0, 33377.0, 35969.0, 36940.0, 36464.0, 34858.0, 34770.0, 34276.0, 34140.0, 36746.0, 36261.0, 36224.0, 35699.0, 35546.0, 36503.0, 36492.0, 35915.0, 33776.0, 30827.0, 27819.0, 26928.0, 26257.0, 26081.0, 26955.0, 26298.0, 26003.0, 23163.0, 20528.0, 18117.0, 15935.0, 13976.0, 12226.0, 10667.0, 9283.8, 8063.1, 6989.8, 6049.1, 5227.4, 4511.5, 3889.4, 3349.8, 2847.4, 2406.2, 2029.8, 1714.7, 1450.7, 1228.2, 1040.7, 883.1, 750.36, 676.05, 651.69, 645.41, 2789.0, 2777.8, 2711.3, 2667.7, 2601.2, 2572.8, 3552.3, 3413.2, 3268.2, 2921.3, 2808.7, 2779.7, 3159.9, 3149.0, 3034.6, 2678.1, 2275.8, 1929.1, 1634.5, 1377.6, 1156.9, 972.35, 817.94, 685.57, 572.5, 477.39, 397.92, 331.75, 276.64, 230.9, 192.9, 161.27, 134.91, 112.96, 94.649, 78.87, 65.108, 53.571, 44.12, 36.37, 30.011, 24.787, 20.491, 16.956, 15.822, 15.157, 14.987, 110.22, 105.47, 104.77, 86.799, 72.853, 61.375, 51.601, 43.175, 36.083, 30.142, 25.091, 20.864, 17.351, 14.34, 11.848, 9.7903, 8.0901, 6.6849, 5.5233, 4.5612, 3.767, 3.1112, 2.5698, 2.1227, 1.7506, 1.4393, 1.1824, 0.96916, 0.79445, 0.65126, 0.5339, 0.43771, 0.35886, 0.29423, 0.24125, 0.19782, 0.16221, 0.13302, 0.10908, 0.089454, 0.073362, 0.060167, 0.049347, 0.040474, 0.033197, 0.027229, 0.022335, 0.018321, 0.015029, 0.012329, 0.010114, 0.0082974, 0.0],
                    'energies (keV)': [0.0199995, 0.020298, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.036946, 0.0375115, 0.0376623, 0.0378885, 0.03797993, 0.038454, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.130438, 0.1323, 0.1324345, 0.1329669, 0.1337655, 0.134325, 0.1349368, 0.135675, 0.135762, 0.1377, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.263718, 0.2677545, 0.2688309, 0.2704455, 0.274204, 0.274482, 0.278401, 0.2795202, 0.2811158, 0.281199, 0.285396, 0.3005128, 0.3212482, 0.3434143, 0.35035, 0.3557125, 0.3571425, 0.3592875, 0.36465, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.900808, 1.929902, 1.93766, 1.94643, 1.949298, 1.966664, 1.978392, 1.996766, 2.004793, 2.016834, 2.046936, 2.080733, 2.171974, 2.205219, 2.214084, 2.224304, 2.227382, 2.260626, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 15.78251, 16.02408, 16.0885, 16.18512, 16.42669, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'N': {'mass_absorption_coefficient (cm2/g)': [741310.0, 732860.0, 662550.0, 628910.0, 596430.0, 564860.0, 534020.0, 503770.0, 474030.0, 444790.0, 416030.0, 387820.0, 360190.0, 333250.0, 307080.0, 281780.0, 276950.0, 271370.0, 269900.0, 285170.0, 280460.0, 276180.0, 256290.0, 237700.0, 220020.0, 203170.0, 187060.0, 171530.0, 156630.0, 142410.0, 128920.0, 116220.0, 104340.0, 93299.0, 83116.0, 73783.0, 65282.0, 57584.0, 50650.0, 44437.0, 38894.0, 33969.0, 29607.0, 25749.0, 22349.0, 19363.0, 16748.0, 14466.0, 12477.0, 10729.0, 9175.6, 7839.8, 6693.3, 5710.5, 4869.1, 4149.5, 3534.7, 3009.8, 2562.1, 2180.4, 1855.1, 1578.2, 1567.3, 1510.6, 1496.0, 30008.0, 29062.0, 27602.0, 23891.0, 20592.0, 17651.0, 15058.0, 12796.0, 10837.0, 9152.1, 7709.9, 6480.8, 5437.2, 4553.8, 3808.0, 3179.8, 2649.6, 2204.7, 1832.3, 1521.2, 1261.9, 1046.1, 866.68, 714.38, 588.46, 484.73, 399.29, 328.92, 270.95, 223.2, 183.87, 151.47, 124.13, 101.23, 82.553, 67.324, 54.905, 44.776, 36.516, 29.78, 24.287, 19.807, 16.153, 13.174, 10.744, 8.762, 7.1183, 5.7735, 4.6775, 3.7741, 3.0452, 2.4571, 1.9825, 1.5995, 1.2905, 1.0411, 0.83998, 0.67769, 0.54676, 0.44112, 0.35589, 0.28713, 0.23166, 0.1869, 0.15079, 0.1212, 0.097291, 0.0781, 0.062695, 0.050328, 0.040401, 0.032432, 0.026035, 0.0209, 0.016777, 0.013468, 0.010812, 0.008679, 0.0069672, 0.005593, 0.0044898, 0.0036038, 0.0028918, 0.0023205, 0.0018621, 0.0014942, 0.001199, 0.00096212, 0.00077205, 0.00061953, 0.00049713, 0.00039892, 0.00032011, 0.00025688, 0.00020613, 0.00016541, 0.00013273, 0.00010651, 8.547e-05, 6.8586e-05, 5.5037e-05, 4.4165e-05, 3.5441e-05, 2.844e-05, 2.2822e-05, 1.8313e-05, 1.4696e-05, 0.0],
                   'energies (keV)': [0.009246, 0.009384, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.0257838, 0.02617845, 0.02628369, 0.02644155, 0.0268362, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.393568, 0.399592, 0.4011984, 0.403608, 0.409632, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Kr': {'mass_absorption_coefficient (cm2/g)': [2312.4, 2579.6, 2647.6, 4746.7, 8387.9, 13269.0, 19054.0, 25187.0, 31027.0, 36001.0, 39709.0, 41968.0, 42790.0, 42333.0, 40838.0, 39566.0, 39019.0, 38870.0, 41125.0, 41059.0, 40556.0, 39978.0, 39822.0, 40609.0, 40034.0, 39518.0, 36724.0, 33772.0, 30777.0, 30548.0, 29872.0, 29694.0, 30706.0, 30045.0, 29091.0, 26229.0, 23521.0, 20988.0, 18633.0, 16469.0, 14499.0, 12721.0, 11127.0, 9706.0, 8446.1, 7333.9, 6355.9, 5498.7, 4749.8, 4097.2, 3529.7, 3304.5, 3267.6, 3231.1, 3194.9, 3159.1, 3123.8, 3088.8, 3054.1, 3019.9, 2986.0, 2952.5, 2919.4, 2886.6, 2854.2, 2822.1, 2790.4, 2759.0, 2728.0, 2697.4, 2667.0, 2637.1, 2607.4, 2574.5, 2541.6, 2509.1, 2477.0, 2445.4, 2414.2, 2383.4, 2353.0, 2323.0, 2293.4, 2264.2, 2235.4, 2207.0, 2179.0, 2151.3, 2124.0, 2097.0, 2070.5, 2044.2, 2018.3, 1992.8, 1967.6, 1942.7, 1918.2, 1893.9, 1870.0, 1846.5, 1823.2, 1800.2, 1777.3, 1754.7, 1732.5, 1710.5, 1688.8, 1667.4, 1646.3, 1625.5, 1604.9, 1584.6, 1564.6, 1544.8, 1525.3, 1506.1, 1487.1, 1468.4, 1449.9, 1431.7, 1413.6, 1395.9, 1378.3, 1361.0, 1344.0, 1327.1, 1310.5, 1294.1, 1277.9, 1261.9, 1246.1, 1230.5, 1215.1, 1200.0, 1185.0, 1170.2, 1155.6, 1141.2, 1127.0, 1113.0, 1099.2, 1085.5, 1072.0, 1058.7, 1045.6, 1032.6, 1019.8, 1007.2, 994.72, 982.42, 970.27, 958.28, 946.44, 934.76, 923.23, 911.84, 900.6, 889.51, 878.56, 867.75, 857.08, 846.55, 836.15, 825.88, 815.75, 805.75, 795.87, 786.12, 776.5, 767.0, 757.62, 748.36, 739.22, 730.19, 721.28, 712.44, 707.83, 3414.7, 3395.0, 3351.0, 3307.5, 3264.7, 3222.4, 3180.6, 3152.8, 4447.1, 4431.2, 4373.9, 4317.4, 4261.7, 4206.7, 4152.4, 4098.8, 4045.9, 3993.7, 3942.1, 3891.3, 3841.1, 3791.5, 3742.6, 3694.4, 3646.7, 3599.7, 3553.3, 3507.5, 3462.3, 3417.7, 3379.8, 3373.7, 3870.2, 3830.3, 3782.4, 3735.0, 3688.2, 3642.1, 3596.5, 3551.5, 3507.0, 3463.2, 3420.1, 3377.9, 3336.3, 3295.3, 3254.8, 3214.9, 3175.5, 3136.7, 3098.3, 3060.5, 3023.1, 2986.3, 2949.9, 2914.0, 2878.6, 2843.6, 2808.7, 2774.2, 2740.2, 2706.6, 2673.4, 2640.7, 2608.2, 2576.0, 2544.3, 2512.9, 2482.0, 2451.4, 2421.2, 2391.4, 2362.0, 2332.9, 2304.2, 2275.8, 2247.8, 2220.1, 2192.8, 2165.8, 2139.1, 2112.8, 2086.8, 2061.1, 2035.7, 2010.6, 1985.6, 1960.9, 1936.6, 1912.5, 1888.7, 1865.3, 1842.1, 1819.2, 1796.6, 1774.2, 1752.2, 1730.4, 1708.8, 1687.6, 1666.6, 1645.9, 1625.4, 1605.2, 1585.2, 1565.5, 1546.0, 1526.8, 1507.8, 1489.1, 1470.6, 1452.3, 1434.2, 1416.4, 1398.8, 1381.5, 1364.3, 1347.4, 1330.6, 1314.1, 1297.8, 1281.7, 1265.4, 1249.0, 1232.8, 1216.8, 1201.0, 1185.5, 1170.1, 1154.9, 1140.0, 1125.2, 1110.6, 1096.3, 1082.1, 1068.1, 1054.2, 1040.6, 1027.1, 1013.9, 1000.7, 987.81, 975.04, 962.44, 949.84, 937.21, 924.76, 912.49, 900.38, 888.43, 876.59, 864.79, 853.15, 841.68, 830.37, 819.21, 808.21, 797.36, 786.66, 776.11, 765.71, 755.45, 745.34, 735.36, 725.52, 715.82, 706.26, 696.82, 687.52, 678.35, 669.3, 660.37, 651.4, 642.55, 633.82, 625.21, 616.73, 608.36, 600.11, 591.97, 583.94, 575.99, 568.15, 560.42, 552.8, 545.28, 537.87, 530.56, 523.36, 516.23, 509.21, 502.28, 495.45, 488.72, 482.08, 475.53, 469.07, 462.71, 456.43, 450.24, 444.13, 438.11, 432.18, 426.32, 420.55, 414.86, 409.25, 403.71, 398.25, 392.87, 387.56, 382.33, 377.17, 372.08, 367.06, 362.11, 357.23, 352.41, 347.67, 342.98, 338.37, 333.81, 329.32, 324.9, 320.53, 316.22, 311.98, 307.79, 303.66, 299.58, 295.56, 291.6, 287.69, 283.84, 280.04, 276.29, 272.59, 268.95, 265.35, 261.8, 258.3, 254.84, 251.43, 248.07, 244.75, 241.48, 238.25, 235.06, 231.92, 228.83, 225.77, 222.76, 219.79, 216.86, 213.96, 211.11, 208.3, 205.53, 202.79, 200.09, 197.43, 194.81, 192.22, 189.67, 187.15, 184.66, 182.21, 179.79, 177.41, 175.06, 172.74, 170.45, 168.19, 165.97, 163.77, 161.61, 159.47, 157.36, 155.28, 153.23, 134.48, 112.58, 93.918, 78.347, 65.009, 53.402, 43.91, 36.14, 29.774, 24.553, 20.267, 18.029, 17.263, 17.067, 130.34, 124.89, 107.23, 89.793, 75.63, 63.738, 53.337, 44.563, 37.194, 31.03, 25.89, 21.533, 17.818, 14.72, 12.162, 10.048, 8.3016, 6.8575, 5.6625, 4.6761, 3.8617, 3.1894, 2.6343, 2.1746, 1.7862, 1.4673, 1.2053, 0.98918, 0.80991, 0.66316, 0.54302, 0.44466, 0.36414, 0.29821, 0.24422, 0.20002, 0.16382, 0.13418, 0.10991, 0.090025, 0.073744, 0.060409, 0.049487, 0.040541, 0.033214, 0.027211, 0.022294, 0.018266, 0.014966, 0.012263, 0.010048, 0.0082338, 0.0067471, 0.0],
                    'energies (keV)': [0.0893445, 0.09041995, 0.090678, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.209524, 0.212731, 0.2135862, 0.214869, 0.2152655, 0.218246, 0.2215865, 0.2224773, 0.2238135, 0.227154, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.2825634, 0.2868883, 0.2880417, 0.2897716, 0.2940966, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6747007, 1.6750994, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7269841, 1.7274159, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9194747, 1.9208077, 1.9225253, 1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.03909, 14.25397, 14.31127, 14.40688, 14.61211, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Si': {'mass_absorption_coefficient (cm2/g)': [540640.0, 562830.0, 69340.0, 55167.0, 50670.0, 49550.0, 49471.0, 49156.0, 45733.0, 34829.0, 25351.0, 19091.0, 14960.0, 12246.0, 10487.0, 9381.1, 8729.0, 8395.1, 8291.3, 8344.5, 8497.9, 8707.5, 8938.9, 9164.4, 9362.4, 9516.5, 9615.3, 9651.8, 9623.2, 9529.1, 9365.6, 9138.5, 8857.2, 8531.7, 8171.7, 7786.0, 7382.9, 6969.4, 6551.8, 6135.3, 5704.9, 5661.1, 5545.8, 5515.5, 108300.0, 108850.0, 109630.0, 112150.0, 112570.0, 110040.0, 105130.0, 98468.0, 97336.0, 95604.0, 95138.0, 104350.0, 102520.0, 100450.0, 91788.0, 82924.0, 74171.0, 65785.0, 57933.0, 50706.0, 44156.0, 38289.0, 33081.0, 28494.0, 24478.0, 20980.0, 17945.0, 15322.0, 13060.0, 11111.0, 9438.5, 8006.3, 6783.0, 5740.5, 4853.3, 4099.3, 3459.5, 2917.8, 2459.7, 2073.0, 1746.9, 1472.2, 1222.8, 1016.3, 845.49, 704.03, 586.78, 489.51, 408.74, 341.61, 293.74, 285.77, 282.07, 279.07, 3309.3, 3219.5, 2994.1, 2540.7, 2129.5, 1778.5, 1492.8, 1255.1, 1055.3, 884.13, 738.59, 617.06, 513.45, 425.24, 352.2, 291.72, 241.64, 200.16, 165.8, 137.35, 113.79, 94.267, 78.099, 64.707, 53.312, 43.815, 35.789, 29.233, 23.879, 19.507, 15.935, 13.017, 10.634, 8.6877, 7.0976, 5.7986, 4.7374, 3.8705, 3.1623, 2.5837, 2.111, 1.7248, 1.4022, 1.138, 0.92365, 0.74966, 0.60846, 0.49385, 0.39906, 0.32246, 0.26057, 0.21056, 0.17015, 0.13749, 0.1111, 0.089782, 0.072561, 0.058646, 0.047399, 0.038309, 0.030963, 0.025026, 0.020227, 0.016349, 0.013214, 0.01068, 0.0086327, 0.0069776, 0.0056398, 0.0045586, 0.0036847, 0.0029783, 0.0024074, 0.0019459, 0.0015729, 0.0012714, 0.0010277, 0.0008307, 0.00067147, 0.00054277, 0.00043874, 0.00035465, 0.00028668, 0.00023174, 0.0],
                    'energies (keV)': [0.005108469, 0.005184715, 0.01069, 0.01113003, 0.01130038, 0.01134581, 0.01141396, 0.01142761, 0.01158431, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.097216, 0.098704, 0.0991008, 0.099696, 0.101184, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.145726, 0.1479565, 0.1485513, 0.1494435, 0.151674, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.802122, 1.820795, 1.829705, 1.837061, 1.848094, 1.875678, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Sn': {'mass_absorption_coefficient (cm2/g)': [10525.0, 12539.0, 20856.0, 44523.0, 78007.0, 113010.0, 140150.0, 153340.0, 151940.0, 139420.0, 120770.0, 100350.0, 81072.0, 64398.0, 50753.0, 39976.0, 31650.0, 25296.0, 20474.0, 16819.0, 14040.0, 13139.0, 12658.0, 12536.0, 19059.0, 18236.0, 15178.0, 12907.0, 11294.0, 10115.0, 9232.1, 8634.8, 8556.2, 8499.0, 8464.4, 9182.0, 9063.5, 8804.2, 8390.3, 8041.3, 7733.3, 7450.1, 7179.5, 6912.9, 6643.9, 6368.6, 6084.8, 5791.9, 5490.6, 5182.4, 4869.8, 4555.3, 4241.1, 3930.5, 3627.0, 3340.0, 3296.1, 3266.2, 3255.7, 3246.9, 18042.0, 17765.0, 17616.0, 27303.0, 27152.0, 26296.0, 25273.0, 21880.0, 18991.0, 16507.0, 14341.0, 13030.0, 12613.0, 12505.0, 14133.0, 14033.0, 13620.0, 13157.0, 12759.0, 12656.0, 13185.0, 13029.0, 12807.0, 11423.0, 10154.0, 9966.2, 9840.1, 9758.7, 10075.0, 9775.8, 9087.4, 7927.9, 6811.9, 5849.7, 5021.6, 4297.0, 3672.2, 3139.0, 2682.1, 2291.8, 1957.9, 1673.2, 1419.6, 1205.3, 1025.0, 872.99, 744.61, 635.4, 534.37, 444.53, 370.41, 308.73, 296.49, 284.53, 281.46, 971.58, 925.9, 891.03, 878.34, 836.93, 827.17, 1138.1, 1088.7, 1019.4, 992.48, 951.59, 941.18, 1071.5, 1031.5, 987.05, 836.98, 709.51, 598.43, 503.31, 422.74, 355.01, 298.26, 250.75, 210.53, 176.31, 146.22, 121.37, 100.84, 83.852, 69.794, 58.144, 48.446, 40.39, 33.708, 28.096, 23.375, 19.401, 16.083, 13.344, 11.082, 9.2116, 7.583, 7.1678, 6.853, 6.7722, 42.681, 41.0, 40.153, 33.571, 28.124, 23.577, 19.727, 16.463, 13.731, 11.446, 9.5388, 7.9476, 6.6212, 5.4924, 4.5563, 3.7801, 3.1364, 2.5985, 2.1453, 1.7713, 1.4626, 1.2078, 0.99745, 0.82378, 0.68027, 0.56166, 0.46375, 0.38294, 0.31622, 0.26114, 0.21566, 0.17812, 0.14711, 0.12151, 0.10037, 0.082909, 0.068489, 0.05658, 0.046743, 0.038618, 0.031906, 0.026362, 0.021782, 0.0],
                    'energies (keV)': [0.0240195, 0.024378, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.086828, 0.088157, 0.0885114, 0.089043, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.13377, 0.1349368, 0.1358175, 0.1363635, 0.1371825, 0.13923, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.475104, 0.4794098, 0.482376, 0.483434, 0.4843152, 0.487224, 0.4908335, 0.4928067, 0.494496, 0.4957665, 0.503166, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.700112, 0.710828, 0.7136856, 0.7154399, 0.717972, 0.728688, 0.741272, 0.752618, 0.7556436, 0.760182, 0.7648052, 0.771528, 0.8175768, 0.866124, 0.8739896, 0.879381, 0.8829162, 0.888219, 0.901476, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 3.850224, 3.909156, 3.924871, 3.948444, 4.007376, 4.055024, 4.072978, 4.135319, 4.151944, 4.17688, 4.239222, 4.334821, 4.375406, 4.442377, 4.460236, 4.487024, 4.553994, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 28.6161, 29.0541, 29.1709, 29.3461, 29.7841, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Sm': {'mass_absorption_coefficient (cm2/g)': [1692.5, 1749.4, 4991.2, 5381.7, 5789.3, 6216.8, 6666.6, 7141.3, 7643.0, 8173.5, 8734.2, 9326.0, 9948.9, 9967.7, 10114.0, 10153.0, 219940.0, 208740.0, 191390.0, 151980.0, 119940.0, 94305.0, 74545.0, 59727.0, 48839.0, 40958.0, 38087.0, 36842.0, 36529.0, 36238.0, 35484.0, 35176.0, 31510.0, 28716.0, 26760.0, 25388.0, 24410.0, 23649.0, 23068.0, 22601.0, 22203.0, 21842.0, 21498.0, 21158.0, 20813.0, 20462.0, 20279.0, 20252.0, 20225.0, 20198.0, 20170.0, 20143.0, 20116.0, 20048.0, 19945.0, 19841.0, 19737.0, 19634.0, 19530.0, 19426.0, 19323.0, 19219.0, 19115.0, 19012.0, 18908.0, 18804.0, 18701.0, 18597.0, 18494.0, 18390.0, 18287.0, 18184.0, 18080.0, 17977.0, 17874.0, 17771.0, 17668.0, 17566.0, 17463.0, 17360.0, 17258.0, 17155.0, 17053.0, 16951.0, 16849.0, 16747.0, 16645.0, 16544.0, 16443.0, 16341.0, 16240.0, 16139.0, 16039.0, 15938.0, 15838.0, 15738.0, 15638.0, 15538.0, 15535.0, 63193.0, 60137.0, 57000.0, 54071.0, 51333.0, 48776.0, 46385.0, 44151.0, 42062.0, 40108.0, 38281.0, 36571.0, 34972.0, 33475.0, 32073.0, 30760.0, 29530.0, 28377.0, 27297.0, 26283.0, 25337.0, 24466.0, 23663.0, 22922.0, 22236.0, 21600.0, 21009.0, 20459.0, 19946.0, 19467.0, 19018.0, 18597.0, 18202.0, 17829.0, 17478.0, 17146.0, 16832.0, 16533.0, 16250.0, 15981.0, 15724.0, 15479.0, 15245.0, 15021.0, 14806.0, 14600.0, 14402.0, 14211.0, 14027.0, 13850.0, 13679.0, 13513.0, 13353.0, 13197.0, 13046.0, 12900.0, 12758.0, 12620.0, 12485.0, 12354.0, 12226.0, 12101.0, 11979.0, 11860.0, 11744.0, 11630.0, 11518.0, 11409.0, 11302.0, 11198.0, 11095.0, 10994.0, 10895.0, 10798.0, 10703.0, 10609.0, 10517.0, 10427.0, 10338.0, 10250.0, 10164.0, 10079.0, 9995.8, 9913.6, 9832.8, 9753.2, 9674.8, 9597.5, 9521.4, 9446.4, 9372.5, 9299.7, 9227.9, 9157.1, 9087.4, 9018.6, 8950.8, 8884.0, 8818.1, 8753.1, 8689.0, 8625.8, 8563.5, 8502.1, 8441.5, 8381.8, 8322.8, 8264.8, 8207.5, 8151.0, 8095.3, 8040.4, 7986.2, 7932.9, 7880.2, 7828.4, 7777.2, 7726.8, 7677.1, 7628.1, 7579.8, 7532.2, 7485.3, 7439.1, 7393.6, 7348.7, 7304.5, 7261.0, 7218.1, 7175.8, 7134.1, 7114.0, 8295.5, 8285.0, 8243.3, 8202.2, 8161.7, 8121.9, 8082.6, 8043.9, 8005.7, 7968.2, 7931.2, 7894.8, 7858.9, 7823.5, 7788.7, 7764.5, 8103.9, 8070.1, 8036.8, 8003.9, 7971.6, 7939.8, 7908.4, 7877.5, 7847.0, 7817.0, 7787.3, 7758.1, 7729.3, 7700.9, 7672.8, 7645.2, 7617.9, 7591.0, 7564.4, 7538.2, 7512.4, 7486.8, 7461.6, 7436.7, 7412.1, 7387.9, 7363.9, 7340.1, 7316.7, 7293.5, 7270.6, 7247.9, 7225.5, 7203.2, 7181.3, 7159.5, 7137.9, 7116.6, 7095.4, 7074.4, 7053.5, 7032.9, 7012.4, 6992.0, 6971.8, 6951.7, 6931.7, 6911.9, 6892.2, 6872.5, 6853.0, 6833.5, 6814.1, 6804.8, 7219.9, 7218.2, 7197.8, 7177.4, 7157.0, 7136.7, 7116.5, 7096.3, 7076.1, 7055.9, 7035.7, 7015.6, 6995.4, 6975.2, 6955.0, 6934.8, 6914.6, 6894.4, 6874.1, 6853.7, 6833.4, 6812.9, 6792.4, 6771.8, 6751.2, 6730.4, 6709.6, 6688.6, 6667.6, 6646.5, 6625.2, 6603.8, 6582.3, 6560.7, 6539.0, 6517.1, 6495.2, 6473.1, 6450.9, 6428.5, 6406.0, 6383.4, 6360.7, 6337.9, 6314.9, 6291.7, 6268.5, 6245.1, 6221.6, 6197.9, 6174.1, 6150.1, 6126.1, 6101.9, 6077.5, 6053.0, 6028.4, 6003.6, 5978.7, 5953.7, 5928.6, 5903.3, 5877.9, 5852.3, 5826.6, 5800.8, 5774.9, 5748.9, 5722.7, 5696.4, 5670.0, 5643.5, 5616.9, 5590.2, 5563.3, 5536.4, 5509.3, 5482.2, 5454.9, 5427.6, 5400.2, 5372.6, 5345.0, 5317.2, 5289.4, 5261.3, 5233.2, 5205.0, 5176.6, 5148.2, 5119.6, 5091.0, 5062.2, 5033.4, 5004.5, 4975.6, 4946.6, 4917.5, 4888.3, 4859.1, 4829.9, 4800.6, 4771.3, 4742.0, 4712.6, 4683.2, 4653.8, 4624.4, 4594.9, 4565.5, 4536.1, 4506.7, 4477.2, 4447.8, 4418.5, 4389.1, 4359.8, 4330.5, 4301.2, 4272.0, 4242.8, 4213.7, 4184.6, 4155.6, 4126.6, 4097.7, 4068.9, 4040.1, 4011.4, 3982.8, 3954.3, 3925.8, 3897.4, 3869.2, 3841.0, 3812.9, 3784.8, 3756.9, 3729.1, 3701.4, 3673.8, 3646.3, 3618.9, 3591.7, 3564.5, 3537.4, 3510.5, 3483.6, 3456.9, 3430.4, 3403.9, 3377.6, 3351.4, 3325.3, 3299.4, 3273.6, 3247.9, 3222.4, 3197.0, 3171.8, 3146.6, 3121.7, 3096.8, 3072.1, 3047.6, 3023.2, 2998.9, 2974.8, 2950.8, 2927.0, 2903.3, 2879.8, 2856.4, 2833.1, 2810.0, 2787.1, 2764.3, 2741.6, 2719.1, 2696.8, 2674.6, 2652.5, 2630.6, 2608.9, 2587.3, 2565.8, 2544.5, 2523.4, 2502.4, 2481.5, 2460.8, 2440.3, 2419.8, 2399.6, 2379.5, 2359.5, 2339.7, 2320.0, 2300.5, 2281.1, 2261.9, 2242.8, 2223.8, 2205.0, 2186.3, 2167.8, 2149.5, 2131.2, 2113.1, 2095.2, 2077.4, 2059.7, 2042.2, 2024.8, 2006.1, 1984.9, 1963.9, 1943.2, 1922.6, 1902.3, 1882.3, 1862.4, 1842.8, 1823.3, 1804.1, 1785.2, 1766.3, 1747.5, 1728.9, 1710.5, 1708.4, 6859.7, 6786.4, 6700.6, 6615.8, 6532.1, 6463.2, 9764.2, 9751.9, 9627.2, 9504.1, 9382.6, 9262.7, 9144.3, 9027.5, 8912.1, 8798.3, 8685.9, 8575.0, 8465.5, 8357.4, 8250.8, 8145.5, 8041.5, 7938.9, 7837.7, 7737.7, 7639.0, 7541.6, 7445.5, 7350.6, 7256.9, 7164.4, 7073.1, 6983.0, 6894.1, 6806.3, 6719.6, 6634.1, 6549.6, 6466.3, 6384.0, 6302.8, 6222.6, 6143.5, 6065.3, 5988.2, 5912.1, 5837.0, 5762.8, 5689.6, 5617.3, 5545.9, 5475.5, 5405.9, 5337.2, 5269.5, 5202.9, 5150.5, 6011.8, 6004.3, 5933.6, 5856.3, 5780.2, 5705.1, 5631.0, 5557.9, 5485.8, 5414.6, 5344.3, 5276.5, 5211.6, 5147.7, 5084.9, 5023.0, 4962.1, 4902.1, 4891.8, 5213.7, 5180.5, 5116.5, 5053.4, 4991.4, 4930.2, 4869.9, 4810.5, 4752.0, 4694.3, 4637.6, 4583.3, 4530.0, 4477.5, 4425.8, 4374.9, 4324.7, 4275.3, 4226.6, 4178.7, 4131.4, 4084.9, 4038.9, 4018.7, 4184.9, 4184.3, 4138.6, 4092.9, 4047.8, 4003.3, 3959.4, 3916.0, 3873.2, 3831.0, 3789.3, 3748.2, 3707.8, 3667.8, 3628.4, 3588.9, 3549.3, 3510.1, 3471.5, 3433.2, 3395.4, 3358.1, 3321.2, 3284.7, 3248.6, 3213.0, 3177.7, 3142.9, 3108.4, 3074.3, 3040.7, 3007.3, 2973.8, 2940.6, 2907.8, 2875.3, 2843.2, 2811.5, 2780.1, 2749.0, 2718.3, 2687.9, 2657.9, 2628.2, 2598.8, 2569.7, 2540.9, 2511.8, 2482.9, 2454.4, 2426.1, 2398.1, 2370.1, 2342.3, 2314.8, 2287.5, 2260.6, 2234.0, 2207.7, 2181.8, 2156.1, 2130.7, 2105.6, 2080.8, 2056.3, 2032.1, 2008.2, 1984.6, 1961.3, 1938.2, 1915.1, 1892.3, 1869.7, 1847.4, 1825.4, 1803.7, 1782.2, 1761.0, 1740.1, 1719.4, 1699.0, 1678.8, 1658.8, 1639.2, 1619.7, 1600.5, 1581.6, 1562.8, 1544.4, 1526.1, 1508.1, 1490.3, 1472.7, 1455.3, 1438.2, 1421.3, 1404.5, 1388.0, 1371.7, 1355.7, 1339.8, 1324.1, 1308.4, 1292.9, 1277.6, 1262.5, 1247.6, 1232.9, 1218.3, 1204.0, 1189.8, 1175.8, 1161.9, 1147.0, 1132.2, 1117.6, 1103.3, 1089.1, 1075.0, 1061.1, 1047.3, 1033.8, 1020.4, 1007.2, 994.16, 981.32, 968.65, 956.15, 943.82, 931.66, 919.67, 907.83, 896.16, 884.64, 873.28, 862.07, 851.01, 840.11, 829.35, 818.73, 808.24, 797.85, 787.6, 777.49, 767.51, 757.67, 747.96, 738.38, 728.93, 719.6, 710.4, 701.33, 692.37, 683.54, 674.82, 666.22, 657.73, 649.36, 641.1, 632.95, 624.91, 616.97, 609.14, 601.42, 593.8, 586.27, 578.85, 571.53, 564.3, 557.17, 533.91, 450.89, 381.31, 321.17, 270.39, 228.07, 192.73, 162.49, 155.44, 149.5, 147.95, 434.78, 414.88, 402.71, 361.83, 346.8, 342.98, 470.29, 462.16, 450.49, 429.57, 411.47, 407.01, 463.72, 446.7, 445.13, 377.0, 318.09, 266.21, 222.66, 186.21, 155.86, 130.57, 109.46, 91.45, 76.33, 63.541, 52.927, 44.125, 36.82, 30.751, 25.706, 21.505, 18.006, 14.976, 12.421, 10.289, 8.5091, 7.022, 5.7947, 4.7856, 3.9553, 3.6898, 3.5338, 3.4937, 19.963, 19.226, 19.113, 16.088, 13.493, 11.303, 9.4604, 7.9093, 6.6124, 5.5281, 4.6153, 3.8418, 3.1983, 2.653, 2.2003, 1.825, 1.5139, 1.2559, 1.042, 0.86458, 0.71742, 0.59536, 0.49411, 0.4101, 0.34081, 0.28387, 0.23646, 0.19698, 0.1641, 0.13672, 0.11391, 0.094913, 0.079088, 0.065906, 0.054923, 0.045773, 0.0],
                    'energies (keV)': [0.0055275, 0.00561, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.020874, 0.0211935, 0.0212787, 0.0214065, 0.021726, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.036652, 0.037213, 0.0373626, 0.037587, 0.03797993, 0.038148, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12897987, 0.12902012, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.2472382, 0.2475618, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26540451, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34532318, 0.34607681, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0800822, 1.0803177, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.105813, 1.1061869, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4187409, 1.4201848, 1.4208592, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.5395028, 1.5418971, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7203536, 1.7251278, 1.7252464, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.581876, 6.682619, 6.709484, 6.749781, 6.850524, 6.915365, 7.165564, 7.275241, 7.304488, 7.348359, 7.392525, 7.458036, 7.582064, 7.698116, 7.729063, 7.775484, 7.891536, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 45.89752, 46.60003, 46.78737, 47.06837, 47.77089, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'V': {'mass_absorption_coefficient (cm2/g)': [107610.0, 107130.0, 106530.0, 105760.0, 104820.0, 103670.0, 102300.0, 100710.0, 98873.0, 96802.0, 94499.0, 91974.0, 89242.0, 86323.0, 83240.0, 80018.0, 76686.0, 73272.0, 69808.0, 67625.0, 66831.0, 66621.0, 140470.0, 140320.0, 131650.0, 107460.0, 85002.0, 70730.0, 60848.0, 53352.0, 47341.0, 42369.0, 38195.0, 37844.0, 37002.0, 36784.0, 40957.0, 40195.0, 39185.0, 36250.0, 33751.0, 31604.0, 29746.0, 28119.0, 26668.0, 25340.0, 24091.0, 22882.0, 21685.0, 20480.0, 19256.0, 17995.0, 16704.0, 15400.0, 14105.0, 12836.0, 11613.0, 10450.0, 9357.4, 8342.3, 7408.1, 6556.1, 5785.1, 5092.0, 4472.5, 3921.4, 3433.3, 3002.3, 2728.2, 2648.0, 2645.4, 2622.9, 18070.0, 17874.0, 17708.0, 25016.0, 25010.0, 24167.0, 22462.0, 19223.0, 17091.0, 16487.0, 16424.0, 16331.0, 18304.0, 17704.0, 16045.0, 13784.0, 11812.0, 10110.0, 8643.6, 7363.5, 6269.5, 5287.7, 4449.8, 3744.0, 3149.3, 2648.9, 2228.3, 1875.1, 1578.4, 1329.3, 1120.1, 943.43, 790.09, 662.45, 555.67, 464.85, 389.23, 323.23, 266.38, 219.75, 181.47, 150.01, 124.12, 102.81, 85.246, 70.752, 68.556, 65.72, 64.991, 592.13, 567.17, 542.35, 452.57, 381.09, 321.7, 270.56, 226.73, 189.84, 158.75, 132.26, 110.18, 91.698, 75.812, 62.642, 51.764, 42.778, 35.354, 29.22, 24.152, 19.964, 16.503, 13.643, 11.279, 9.2949, 7.6406, 6.248, 5.1006, 4.1637, 3.399, 2.7748, 2.2653, 1.8494, 1.5099, 1.2328, 1.0065, 0.82184, 0.67105, 0.54793, 0.44742, 0.36535, 0.29834, 0.24321, 0.19753, 0.16043, 0.1303, 0.10583, 0.08596, 0.06982, 0.05671, 0.046063, 0.037415, 0.030391, 0.024686, 0.020052, 0.016288, 0.013231, 0.010747, 0.0087303, 0.0070918, 0.0057609, 0.0046797, 0.0038015, 0.0030881, 0.0025087, 0.0020379, 0.0016555, 0.0013449, 0.0],
                   'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.037044, 0.037611, 0.0377622, 0.03797993, 0.037989, 0.038556, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06517, 0.0661675, 0.0664335, 0.0668325, 0.06783, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.502642, 0.51009, 0.5103355, 0.5124891, 0.5154645, 0.5178975, 0.5199795, 0.5231025, 0.523158, 0.53091, 0.5478508, 0.5856525, 0.615636, 0.625059, 0.6260625, 0.6275718, 0.631341, 0.640764, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.355798, 5.437774, 5.459635, 5.492425, 5.574402, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Sc': {'mass_absorption_coefficient (cm2/g)': [186430.0, 160500.0, 146920.0, 74830.0, 41275.0, 26322.0, 18922.0, 14996.0, 12854.0, 11788.0, 11720.0, 11615.0, 11574.0, 16562.0, 16477.0, 16372.0, 16439.0, 16735.0, 17161.0, 17655.0, 18167.0, 18651.0, 19063.0, 19365.0, 19521.0, 19508.0, 19309.0, 18921.0, 18341.0, 17569.0, 16635.0, 15582.0, 14450.0, 13278.0, 12102.0, 10950.0, 9843.8, 8799.8, 7828.6, 6936.1, 6124.3, 5392.2, 4736.5, 4152.6, 3635.3, 3603.6, 3524.1, 3495.4, 3467.3, 25522.0, 25459.0, 25234.0, 35733.0, 35442.0, 34579.0, 33728.0, 29089.0, 25038.0, 23779.0, 22966.0, 22755.0, 25433.0, 24623.0, 24405.0, 21064.0, 18141.0, 15578.0, 13339.0, 11398.0, 9721.9, 8279.3, 7037.7, 5970.5, 5059.3, 4265.1, 3590.5, 3019.6, 2537.8, 2132.1, 1791.1, 1504.8, 1258.8, 1053.0, 881.86, 737.36, 615.88, 514.89, 430.88, 360.91, 302.6, 251.42, 207.14, 170.83, 141.02, 116.52, 96.373, 92.203, 88.319, 87.321, 824.43, 790.36, 765.7, 638.98, 537.52, 453.4, 381.25, 319.24, 267.02, 223.19, 186.45, 155.73, 129.92, 107.39, 88.735, 73.33, 60.603, 50.088, 41.401, 34.222, 28.289, 23.386, 19.334, 15.985, 13.171, 10.815, 8.88, 7.2916, 5.9873, 4.8878, 3.9828, 3.2454, 2.6446, 2.1551, 1.7562, 1.4312, 1.1664, 0.95055, 0.7747, 0.63138, 0.51459, 0.41941, 0.34184, 0.27863, 0.2271, 0.18491, 0.1502, 0.122, 0.099096, 0.080495, 0.065385, 0.053113, 0.043144, 0.035047, 0.02847, 0.023127, 0.018787, 0.015261, 0.012398, 0.010071, 0.0081817, 0.0066466, 0.0053995, 0.0043865, 0.0035635, 0.002895, 0.0023519, 0.0019107, 0.0015522, 0.0012611, 0.0010245, 0.0],
                    'energies (keV)': [0.0324615, 0.032946, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.052724, 0.05302035, 0.053531, 0.0537462, 0.054069, 0.054876, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.394156, 0.398566, 0.400189, 0.4017978, 0.404211, 0.4046665, 0.4062933, 0.4087335, 0.410244, 0.414834, 0.4195189, 0.4484657, 0.4794098, 0.490392, 0.497898, 0.4998996, 0.502902, 0.510408, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.402944, 4.470336, 4.488307, 4.515264, 4.582656, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Sb': {'mass_absorption_coefficient (cm2/g)': [2821.5, 3996.2, 9531.6, 43573.0, 129290.0, 248730.0, 339460.0, 354960.0, 303590.0, 224380.0, 150030.0, 94243.0, 57344.0, 34632.0, 21158.0, 13266.0, 8624.2, 5854.8, 4214.7, 4168.0, 3926.3, 3855.1, 8412.2, 7989.1, 7245.9, 5895.2, 4986.6, 4386.0, 3989.1, 3732.7, 3645.8, 3611.4, 3603.0, 4327.0, 4310.2, 4301.1, 4225.1, 4184.3, 4166.9, 4163.3, 4170.6, 4181.5, 4184.3, 4170.3, 4139.2, 4089.1, 4018.3, 3926.2, 3813.7, 3682.6, 3535.0, 3374.0, 3203.9, 3022.4, 2998.1, 2955.3, 2948.4, 2944.0, 18669.0, 18285.0, 18087.0, 28226.0, 28001.0, 26829.0, 22253.0, 18624.0, 15812.0, 13528.0, 12129.0, 11715.0, 11609.0, 11608.0, 13021.0, 12615.0, 12120.0, 11733.0, 11633.0, 12118.0, 12068.0, 11751.0, 10507.0, 9338.8, 9142.5, 9047.5, 8971.9, 9258.3, 8982.1, 8329.4, 7160.5, 6149.4, 5280.3, 4533.3, 3879.0, 3314.3, 2832.5, 2420.0, 2068.4, 1767.5, 1510.9, 1284.9, 1091.1, 928.07, 790.61, 674.54, 569.68, 474.77, 395.57, 330.11, 276.55, 275.54, 265.46, 262.61, 897.66, 854.87, 804.82, 779.44, 766.95, 757.97, 1043.7, 997.97, 912.95, 896.72, 875.13, 865.52, 985.82, 948.96, 872.93, 741.19, 627.71, 529.0, 444.68, 373.49, 313.71, 263.66, 221.68, 185.81, 154.34, 128.09, 106.39, 88.44, 73.589, 61.288, 51.089, 42.591, 35.528, 29.665, 24.718, 20.568, 17.062, 14.154, 11.752, 9.7664, 8.0405, 6.6897, 6.603, 6.397, 6.3219, 39.64, 38.091, 35.031, 29.334, 24.581, 20.604, 17.212, 14.361, 11.977, 9.984, 8.321, 6.9344, 5.7698, 4.7884, 3.9743, 3.2989, 2.734, 2.2578, 1.8647, 1.5401, 1.2722, 1.0509, 0.86813, 0.71721, 0.59248, 0.48945, 0.40436, 0.33407, 0.27602, 0.22807, 0.18846, 0.15573, 0.12869, 0.10635, 0.087897, 0.072646, 0.060043, 0.049629, 0.041022, 0.033909, 0.02803, 0.023172, 0.0],
                    'energies (keV)': [0.031557, 0.032028, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.096432, 0.09665893, 0.097908, 0.0983016, 0.098892, 0.100368, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.14896, 0.15124, 0.151848, 0.15276, 0.1542005, 0.15504, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.51695, 0.5248625, 0.526162, 0.5269725, 0.5301375, 0.5342155, 0.5363631, 0.53805, 0.5395845, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.750288, 0.761772, 0.7648052, 0.7648344, 0.769428, 0.780912, 0.795662, 0.8078405, 0.8110881, 0.8159595, 0.8175768, 0.828138, 0.8739896, 0.924826, 0.9342948, 0.9389815, 0.9427563, 0.9484185, 0.962574, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.049556, 4.055024, 4.111539, 4.128068, 4.152861, 4.214844, 4.292792, 4.334821, 4.358498, 4.37602, 4.402302, 4.468008, 4.604334, 4.633924, 4.674808, 4.693602, 4.721791, 4.792266, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 29.88138, 30.01405, 30.33874, 30.46071, 30.64366, 31.10102, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Se': {'mass_absorption_coefficient (cm2/g)': [5074.1, 5549.7, 7353.9, 10905.0, 15328.0, 20417.0, 25916.0, 31507.0, 36854.0, 41645.0, 45631.0, 48640.0, 50587.0, 51468.0, 51345.0, 50331.0, 48565.0, 47619.0, 47075.0, 46927.0, 48708.0, 48261.0, 48198.0, 47721.0, 47575.0, 48195.0, 47666.0, 46675.0, 44032.0, 41176.0, 38192.0, 35806.0, 35158.0, 35113.0, 34930.0, 36139.0, 35456.0, 33572.0, 30547.0, 27614.0, 24815.0, 22184.0, 19738.0, 17488.0, 15437.0, 13581.0, 11913.0, 10423.0, 9097.3, 7923.9, 6888.9, 5979.0, 5181.1, 4482.1, 3871.5, 3340.1, 2879.1, 2696.6, 2666.7, 2637.1, 2607.9, 2578.9, 2550.3, 2522.0, 2494.1, 2466.4, 2439.0, 2411.9, 2385.2, 2358.7, 2332.5, 2306.6, 2281.0, 2255.6, 2230.6, 2205.8, 2181.3, 2157.1, 2133.2, 2106.5, 2079.8, 2053.4, 2027.3, 2001.6, 1976.3, 1951.3, 1926.6, 1902.2, 1878.1, 1854.4, 1831.0, 1807.5, 1783.7, 1760.2, 1737.0, 1714.1, 1691.6, 1669.3, 1647.4, 1625.8, 1604.4, 1583.4, 1562.7, 1542.2, 1522.0, 1502.1, 1482.5, 1463.2, 1444.1, 1425.3, 1406.7, 1388.4, 1370.4, 1352.6, 1335.0, 1317.7, 1300.6, 1283.7, 1267.1, 1250.7, 1234.6, 1218.6, 1202.9, 1187.4, 1172.1, 1157.0, 1142.1, 1127.4, 1112.9, 1098.6, 1084.5, 1070.6, 1056.9, 1043.4, 1030.0, 1016.9, 1003.9, 991.05, 978.41, 965.94, 953.63, 941.49, 929.52, 917.7, 906.05, 894.55, 883.2, 872.0, 860.96, 850.06, 839.31, 832.61, 4283.7, 4265.3, 4210.3, 4155.9, 4102.2, 4049.3, 3997.0, 3987.0, 5643.7, 5587.9, 5516.0, 5445.0, 5374.9, 5305.7, 5237.5, 5170.1, 5103.6, 5037.9, 4973.1, 4909.1, 4846.0, 4783.7, 4722.2, 4661.5, 4601.5, 4542.4, 4484.0, 4426.4, 4369.5, 4313.3, 4257.9, 4212.6, 4203.2, 4809.9, 4760.8, 4701.7, 4643.4, 4585.8, 4529.0, 4472.8, 4417.4, 4362.7, 4308.6, 4255.5, 4203.3, 4151.8, 4101.0, 4050.9, 4001.4, 3952.6, 3904.4, 3856.9, 3809.9, 3763.6, 3717.8, 3672.7, 3628.1, 3584.1, 3540.3, 3496.9, 3454.0, 3411.7, 3369.9, 3328.6, 3287.6, 3247.1, 3207.1, 3167.6, 3128.6, 3090.1, 3052.1, 3014.5, 2977.4, 2940.8, 2904.6, 2868.9, 2833.6, 2798.8, 2764.3, 2730.3, 2696.8, 2663.6, 2630.8, 2598.5, 2566.5, 2535.0, 2503.7, 2472.6, 2441.8, 2411.5, 2381.5, 2351.9, 2322.7, 2293.8, 2265.2, 2237.1, 2209.2, 2181.7, 2154.6, 2127.8, 2101.3, 2075.1, 2049.3, 2023.7, 1998.5, 1973.6, 1949.1, 1924.8, 1900.8, 1877.1, 1853.7, 1830.6, 1807.8, 1785.3, 1763.0, 1741.0, 1719.3, 1697.9, 1676.8, 1655.9, 1635.2, 1614.8, 1594.7, 1574.9, 1555.2, 1535.9, 1516.7, 1497.8, 1479.2, 1460.7, 1442.5, 1424.6, 1406.8, 1389.3, 1372.0, 1355.0, 1338.1, 1321.5, 1305.0, 1288.8, 1272.8, 1256.9, 1241.3, 1225.9, 1210.6, 1195.4, 1180.3, 1165.5, 1150.8, 1136.3, 1122.0, 1107.8, 1093.8, 1079.4, 1064.9, 1050.6, 1036.4, 1022.4, 1008.6, 994.98, 981.56, 968.34, 955.29, 942.42, 929.71, 917.18, 904.81, 892.63, 880.61, 868.76, 857.07, 845.55, 834.18, 822.79, 811.56, 800.48, 789.56, 778.79, 768.17, 757.71, 747.38, 737.2, 727.17, 717.27, 707.51, 697.89, 688.4, 679.05, 669.82, 660.72, 651.75, 642.91, 634.19, 625.58, 617.1, 608.74, 600.49, 592.36, 584.34, 576.43, 568.63, 560.94, 553.36, 545.88, 538.51, 531.24, 524.06, 516.99, 510.02, 503.14, 496.36, 489.67, 483.07, 476.57, 470.16, 463.83, 457.59, 451.44, 445.37, 439.39, 433.49, 427.67, 421.93, 416.27, 410.68, 405.18, 399.75, 394.39, 389.09, 383.87, 378.72, 373.64, 368.63, 363.69, 358.82, 354.02, 349.28, 344.6, 339.99, 335.45, 330.96, 326.54, 322.18, 317.88, 313.63, 309.45, 305.32, 301.25, 297.24, 293.28, 289.37, 285.52, 281.72, 277.97, 274.27, 270.63, 267.03, 263.48, 259.98, 256.53, 253.13, 249.77, 246.46, 243.19, 239.97, 236.79, 233.66, 230.57, 227.52, 224.51, 221.54, 218.61, 215.72, 212.88, 210.07, 207.29, 204.56, 201.86, 199.2, 196.58, 193.99, 191.44, 188.92, 186.43, 183.98, 181.56, 179.18, 176.83, 174.5, 172.21, 169.96, 167.73, 165.53, 163.36, 161.22, 159.11, 157.03, 154.97, 152.95, 150.93, 148.91, 146.91, 144.94, 143.0, 141.09, 139.18, 137.3, 135.44, 133.61, 131.8, 130.02, 113.78, 94.78, 78.825, 65.619, 54.49, 44.737, 36.766, 30.244, 24.903, 21.508, 20.524, 20.346, 158.64, 151.57, 133.35, 111.43, 93.833, 79.237, 66.327, 55.422, 46.243, 38.55, 32.128, 26.782, 22.295, 18.442, 15.23, 12.577, 10.386, 8.5742, 7.0768, 5.8412, 4.8217, 3.9804, 3.2861, 2.7131, 2.2269, 1.8275, 1.4998, 1.231, 1.0103, 0.82837, 0.67749, 0.55411, 0.45322, 0.37071, 0.30323, 0.24804, 0.20291, 0.16599, 0.1358, 0.1111, 0.090892, 0.074365, 0.060845, 0.049784, 0.040735, 0.033332, 0.027275, 0.02232, 0.018265, 0.014947, 0.012232, 0.010011, 0.0081932, 0.0067056, 0.0054883, 0.0],
                    'energies (keV)': [0.0569835, 0.057834, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.158662, 0.1610905, 0.1617381, 0.1627095, 0.1648404, 0.165138, 0.167359, 0.1680318, 0.169041, 0.171564, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.22687, 0.2301188, 0.2303425, 0.2312685, 0.2326575, 0.23613, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4356568, 1.4359431, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4760494, 1.4763506, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5270212, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6524595, 1.6538726, 1.6553406, 1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.40464, 12.60708, 12.64514, 12.72109, 12.91096, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Co': {'mass_absorption_coefficient (cm2/g)': [103950.0, 104850.0, 105880.0, 106960.0, 108040.0, 109100.0, 110090.0, 110990.0, 111770.0, 112390.0, 112840.0, 113090.0, 113140.0, 112970.0, 112580.0, 111960.0, 111120.0, 110080.0, 108830.0, 107400.0, 105810.0, 103720.0, 101160.0, 98394.0, 95446.0, 89904.0, 86874.0, 85265.0, 84842.0, 106560.0, 103790.0, 103440.0, 91080.0, 80619.0, 72160.0, 64948.0, 58619.0, 52987.0, 47948.0, 46490.0, 45454.0, 45185.0, 47867.0, 46898.0, 46514.0, 42475.0, 38853.0, 35591.0, 32649.0, 29987.0, 27568.0, 25356.0, 23318.0, 21428.0, 19664.0, 18007.0, 16448.0, 14977.0, 13581.0, 12261.0, 11022.0, 9866.0, 8796.6, 7814.1, 6917.9, 6105.8, 5373.9, 4718.1, 4133.4, 3614.5, 3155.8, 2751.5, 2396.4, 2085.2, 1821.9, 1813.0, 1764.6, 1750.3, 1749.8, 10776.0, 10529.0, 10422.0, 14818.0, 14657.0, 14110.0, 13753.0, 11589.0, 10549.0, 10154.0, 10053.0, 11238.0, 11125.0, 10858.0, 9536.7, 8147.3, 6949.9, 5919.9, 5040.8, 4258.3, 3587.8, 3021.1, 2540.5, 2136.5, 1796.7, 1511.1, 1271.3, 1070.1, 901.21, 759.47, 640.46, 537.2, 445.57, 369.65, 306.51, 253.61, 210.04, 174.12, 144.48, 120.0, 99.765, 83.02, 69.152, 57.656, 48.116, 45.376, 43.554, 43.086, 358.64, 343.19, 338.11, 282.0, 238.37, 199.9, 167.08, 139.42, 116.35, 97.104, 81.052, 67.66, 56.477, 46.767, 38.72, 32.041, 26.517, 21.946, 18.165, 15.036, 12.447, 10.255, 8.4373, 6.942, 5.6994, 4.6638, 3.8165, 3.1232, 2.556, 2.0917, 1.7118, 1.4009, 1.1465, 0.93833, 0.76799, 0.62858, 0.5145, 0.42042, 0.34226, 0.27864, 0.22685, 0.18468, 0.15036, 0.12242, 0.09967, 0.081151, 0.066073, 0.053798, 0.043803, 0.035666, 0.029041, 0.023647, 0.019255, 0.015679, 0.012767, 0.010396, 0.0084657, 0.0068937, 0.0056137, 0.0045714, 0.0037226, 0.0030315, 0.0024687, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.05831, 0.0592025, 0.0594405, 0.0597975, 0.06058959, 0.06069, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.098686, 0.1001965, 0.1005993, 0.1012035, 0.102714, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.763028, 0.7648052, 0.774707, 0.777728, 0.7778214, 0.782493, 0.789632, 0.7928064, 0.794172, 0.797568, 0.809472, 0.8175768, 0.8739896, 0.907088, 0.920972, 0.9246744, 0.930228, 0.9342948, 0.944112, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.554722, 7.670355, 7.701191, 7.747444, 7.863078, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Cl': {'mass_absorption_coefficient (cm2/g)': [732110.0, 795320.0, 1180500.0, 890660.0, 646820.0, 458590.0, 321200.0, 224450.0, 157740.0, 112200.0, 109100.0, 101220.0, 99249.0, 96518.0, 89881.0, 81361.0, 60339.0, 46049.0, 36355.0, 29830.0, 25504.0, 22694.0, 20939.0, 19888.0, 19268.0, 18890.0, 18633.0, 18418.0, 18205.0, 17971.0, 17711.0, 17423.0, 17110.0, 16774.0, 16416.0, 16036.0, 15630.0, 15196.0, 14731.0, 14235.0, 13707.0, 13149.0, 12562.0, 11951.0, 11321.0, 10455.0, 9557.2, 8687.2, 7853.0, 7061.5, 6318.2, 5900.5, 5818.9, 5745.7, 5705.2, 63321.0, 63065.0, 62834.0, 62817.0, 90257.0, 89034.0, 87632.0, 79989.0, 69995.0, 61145.0, 53290.0, 52528.0, 50887.0, 50461.0, 55507.0, 53911.0, 51842.0, 45380.0, 39620.0, 34481.0, 29914.0, 25875.0, 22316.0, 19195.0, 16467.0, 14092.0, 12033.0, 10254.0, 8720.9, 7404.3, 6276.6, 5313.1, 4491.5, 3791.9, 3198.0, 2695.6, 2246.7, 1866.5, 1550.7, 1289.6, 1073.6, 894.66, 746.32, 623.21, 520.96, 435.93, 365.16, 306.2, 257.02, 215.97, 181.65, 173.5, 166.83, 165.12, 1700.0, 1640.3, 1605.3, 1353.5, 1136.9, 957.38, 804.13, 672.76, 562.91, 471.05, 394.22, 329.81, 275.78, 228.78, 189.8, 157.47, 130.66, 108.41, 89.957, 74.532, 61.423, 50.622, 41.722, 34.389, 28.262, 23.145, 18.956, 15.525, 12.716, 10.415, 8.5307, 6.9876, 5.7238, 4.6887, 3.8408, 3.1464, 2.5618, 2.0816, 1.6915, 1.3745, 1.1169, 0.90764, 0.73757, 0.59939, 0.48709, 0.39584, 0.32169, 0.26143, 0.21201, 0.17166, 0.13899, 0.11254, 0.091112, 0.073749, 0.059695, 0.04832, 0.039113, 0.03166, 0.025627, 0.020744, 0.016792, 0.013592, 0.011003, 0.0089064, 0.0072096, 0.005836, 0.0047242, 0.0038242, 0.0030956, 0.0025059, 0.0020285, 0.0016421, 0.0013293, 0.0010761, 0.00087107, 0.00070514, 0.00057082, 0.00046209, 0.0],
                    'energies (keV)': [0.006834, 0.006936, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01715, 0.0174125, 0.0174825, 0.0175875, 0.01785, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.196, 0.197568, 0.199, 0.1998, 0.200592, 0.201, 0.2013709, 0.2013984, 0.202608, 0.204, 0.205632, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.264796, 0.268849, 0.2699298, 0.271551, 0.275604, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.765952, 2.808288, 2.819578, 2.836512, 2.878848, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ca': {'mass_absorption_coefficient (cm2/g)': [685160.0, 659290.0, 545890.0, 292820.0, 129380.0, 67275.0, 40688.0, 27905.0, 21224.0, 17558.0, 15847.0, 15535.0, 15495.0, 15411.0, 20554.0, 20365.0, 20045.0, 19991.0, 20284.0, 20776.0, 21379.0, 22024.0, 22654.0, 23216.0, 23663.0, 23954.0, 24055.0, 23942.0, 23603.0, 23008.0, 22168.0, 21121.0, 19910.0, 18582.0, 17186.0, 15763.0, 14351.0, 12979.0, 11670.0, 10441.0, 9301.4, 8256.3, 7306.7, 6450.4, 5683.1, 4999.1, 4491.8, 4402.3, 4391.9, 4360.9, 4326.9, 33163.0, 32876.0, 46641.0, 46191.0, 45167.0, 42515.0, 36782.0, 31740.0, 30183.0, 29167.0, 28904.0, 32219.0, 31211.0, 30926.0, 26761.0, 23078.0, 19849.0, 17031.0, 14581.0, 12460.0, 10631.0, 9050.9, 7688.7, 6521.5, 5525.0, 4676.4, 3937.9, 3312.2, 2784.1, 2339.4, 1964.9, 1640.7, 1371.3, 1147.6, 958.76, 800.11, 668.34, 558.8, 467.65, 391.75, 328.48, 275.69, 229.25, 189.0, 155.96, 128.81, 114.15, 109.32, 108.08, 1039.0, 1036.6, 994.05, 863.21, 724.83, 610.83, 514.93, 431.46, 361.1, 301.95, 252.28, 210.72, 176.02, 146.61, 121.73, 100.52, 83.02, 68.568, 56.635, 46.781, 38.644, 31.924, 26.374, 21.79, 17.993, 14.765, 12.116, 9.9419, 8.1585, 6.6953, 5.4947, 4.482, 3.6488, 2.9705, 2.4184, 1.9689, 1.6031, 1.3052, 1.0627, 0.86527, 0.70454, 0.57367, 0.46712, 0.38037, 0.30973, 0.25221, 0.20538, 0.16708, 0.13561, 0.11006, 0.089334, 0.072509, 0.058853, 0.04777, 0.038774, 0.031473, 0.025547, 0.020736, 0.016832, 0.013663, 0.01109, 0.0090025, 0.0073076, 0.0059319, 0.0048152, 0.0039087, 0.0031729, 0.0025756, 0.0020908, 0.0016973, 0.0013778, 0.0011184, 0.00090793, 0.0],
                    'energies (keV)': [0.02545001, 0.025527, 0.025908, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.042826, 0.04340198, 0.0434815, 0.0436563, 0.0439185, 0.044574, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.339472, 0.343, 0.3434143, 0.344668, 0.3460536, 0.34825, 0.34965, 0.35175, 0.353328, 0.357, 0.3671099, 0.3924405, 0.4195189, 0.429044, 0.435611, 0.4373622, 0.439989, 0.446556, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 3.957338, 4.017909, 4.034062, 4.055024, 4.05829, 4.118862, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ce': {'mass_absorption_coefficient (cm2/g)': [172420.0, 164130.0, 148030.0, 118470.0, 93174.0, 72048.0, 55102.0, 41894.0, 31801.0, 24187.0, 18487.0, 15680.0, 14781.0, 14553.0, 14409.0, 14396.0, 13619.0, 11278.0, 8954.3, 7221.5, 5921.5, 4938.6, 4188.1, 3608.0, 3153.2, 2791.0, 2497.4, 2255.2, 2066.1, 2052.8, 2024.1, 2013.3, 2345.2, 2353.5, 2397.5, 2639.3, 3050.2, 3368.7, 3489.5, 3521.8, 111360.0, 109880.0, 86781.0, 39626.0, 17039.0, 10662.0, 8465.7, 7499.1, 6931.1, 6501.1, 6129.9, 5800.9, 5762.9, 5695.5, 5678.1, 7018.3, 6952.9, 6875.2, 6809.0, 6750.8, 6735.8, 7144.4, 7091.6, 7056.4, 6854.5, 6693.5, 6562.2, 6545.0, 6518.1, 6511.1, 7029.0, 6999.0, 6964.4, 6826.1, 6667.2, 6473.9, 6238.4, 5960.4, 5643.1, 5287.7, 4905.3, 4510.4, 4115.6, 3731.3, 3365.0, 3021.9, 2704.5, 2414.3, 2187.2, 2150.9, 2130.0, 2111.5, 8836.7, 8606.0, 8516.7, 8502.7, 12763.0, 12263.0, 11742.0, 9822.7, 8281.8, 7015.1, 6717.3, 6472.1, 6409.0, 7380.8, 7108.5, 6947.4, 6573.2, 6341.4, 6282.1, 6622.2, 6391.3, 6321.2, 5433.7, 5336.6, 5164.8, 5120.7, 5297.3, 5135.0, 4941.5, 4255.8, 3649.6, 3122.8, 2669.2, 2279.9, 1944.7, 1660.6, 1416.4, 1208.1, 1031.7, 874.3, 735.99, 620.24, 520.29, 436.79, 367.2, 309.21, 260.86, 219.92, 189.41, 184.88, 182.01, 180.11, 549.96, 524.96, 472.31, 469.96, 452.35, 447.27, 608.4, 584.0, 552.12, 540.34, 529.9, 524.22, 596.87, 575.13, 527.6, 446.51, 376.52, 317.01, 266.36, 222.42, 185.9, 155.51, 129.96, 108.36, 90.138, 74.894, 62.282, 51.838, 43.175, 35.991, 30.03, 25.079, 20.964, 17.54, 14.654, 12.138, 9.9985, 8.2327, 6.7828, 5.5928, 4.6154, 4.4702, 4.2795, 4.2305, 25.154, 24.214, 23.263, 19.54, 16.379, 13.719, 11.469, 9.5765, 7.995, 6.6739, 5.5705, 4.6491, 3.8732, 3.2082, 2.6577, 2.2018, 1.8243, 1.5117, 1.2527, 1.0382, 0.86047, 0.71323, 0.59123, 0.49013, 0.40673, 0.3378, 0.28057, 0.23305, 0.19359, 0.16082, 0.13361, 0.11101, 0.092231, 0.076636, 0.063681, 0.052919, 0.043978, 0.036549, 0.0],
                    'energies (keV)': [0.019899, 0.020196, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.037044, 0.037611, 0.0377622, 0.03797993, 0.037989, 0.038556, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.084182, 0.08458368, 0.0854705, 0.0858141, 0.0863295, 0.087618, 0.09041995, 0.09665893, 0.1033284, 0.1078, 0.10945, 0.10989, 0.1104581, 0.11055, 0.1122, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.203056, 0.206164, 0.2069928, 0.208236, 0.211344, 0.2152655, 0.218834, 0.2221835, 0.2230767, 0.2244165, 0.227766, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.283808, 0.288152, 0.2893104, 0.291048, 0.295392, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.865634, 0.8739896, 0.8788835, 0.883274, 0.8877165, 0.8967935, 0.9003987, 0.900966, 0.9058065, 0.919326, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.161692, 1.179473, 1.184215, 1.191327, 1.209108, 1.220098, 1.247344, 1.266436, 1.271527, 1.279164, 1.298256, 1.304285, 1.394281, 1.405908, 1.427427, 1.433165, 1.441773, 1.463292, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.608932, 5.660855, 5.694783, 5.717677, 5.752017, 5.837868, 6.040916, 6.051453, 6.133379, 6.158036, 6.195021, 6.287484, 6.417824, 6.469004, 6.516056, 6.542251, 6.581544, 6.679776, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 39.63414, 40.24079, 40.40256, 40.64522, 41.25186, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Xe': {'mass_absorption_coefficient (cm2/g)': [13641.0, 14194.0, 14842.0, 20764.0, 28929.0, 34579.0, 36531.0, 35170.0, 31653.0, 27195.0, 22687.0, 18628.0, 15214.0, 12459.0, 10386.0, 10290.0, 9958.7, 9849.8, 11975.0, 11574.0, 10826.0, 9435.3, 8359.2, 7525.0, 6872.6, 6765.3, 6642.7, 6611.3, 7196.4, 7085.3, 6984.9, 6564.2, 6213.0, 5908.2, 5633.6, 5377.4, 5130.9, 4888.2, 4645.1, 4399.1, 4149.2, 3895.5, 3639.3, 3382.5, 3127.2, 2876.1, 2631.4, 2449.8, 2395.3, 2382.8, 13073.0, 12746.0, 12607.0, 19577.0, 19330.0, 18538.0, 17368.0, 14416.0, 12141.0, 10331.0, 9191.9, 8869.1, 8824.9, 8785.8, 9904.7, 9589.6, 9099.3, 8802.7, 8711.5, 9180.3, 8883.5, 8006.9, 7178.6, 6942.7, 6908.3, 6879.2, 7103.3, 6866.3, 6196.1, 5302.1, 4541.4, 3893.6, 3338.2, 2854.0, 2434.4, 2077.0, 1772.9, 1514.3, 1294.0, 1106.4, 946.31, 805.08, 678.97, 568.52, 477.03, 400.68, 335.37, 280.44, 234.87, 227.96, 219.0, 216.69, 707.71, 674.88, 642.36, 622.82, 595.37, 588.55, 809.03, 774.23, 736.39, 717.21, 687.49, 679.97, 775.07, 746.24, 713.69, 604.87, 512.09, 431.73, 363.12, 305.21, 256.64, 215.6, 180.02, 149.92, 124.68, 103.51, 86.011, 71.513, 59.51, 49.566, 41.322, 34.48, 28.774, 24.024, 20.045, 16.705, 13.893, 11.538, 9.5022, 7.8085, 6.4221, 5.4835, 5.2863, 5.2462, 5.1853, 31.958, 30.73, 27.698, 23.214, 19.454, 16.302, 13.612, 11.36, 9.4768, 7.904, 6.5913, 5.4963, 4.5753, 3.8022, 3.1551, 2.6091, 2.1577, 1.7846, 1.4761, 1.221, 1.0101, 0.83571, 0.69146, 0.57216, 0.47372, 0.39226, 0.32483, 0.26901, 0.2228, 0.18453, 0.15285, 0.12661, 0.10488, 0.08689, 0.071986, 0.059642, 0.049417, 0.040947, 0.03393, 0.028117, 0.0],
                    'energies (keV)': [0.06432, 0.06477028, 0.06528, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.143766, 0.1442475, 0.1459665, 0.1465533, 0.1474335, 0.149634, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.203938, 0.2070595, 0.2078919, 0.2091405, 0.212262, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.658854, 0.6692609, 0.671692, 0.6756615, 0.681973, 0.6847146, 0.685746, 0.688827, 0.699108, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.91826, 0.932315, 0.9342948, 0.936063, 0.941685, 0.95574, 0.97902, 0.994005, 0.9987612, 1.003995, 1.01898, 1.067676, 1.121708, 1.138877, 1.141345, 1.143455, 1.150323, 1.167492, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.686556, 4.758289, 4.777418, 4.806111, 4.877844, 4.953664, 5.001626, 5.078182, 5.098596, 5.129219, 5.205774, 5.295467, 5.343744, 5.425536, 5.447347, 5.480064, 5.561856, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 33.87017, 34.29889, 34.38859, 34.52684, 34.73421, 35.25263, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Tm': {'mass_absorption_coefficient (cm2/g)': [6683.5, 6609.5, 6036.3, 6210.0, 6416.7, 6657.0, 6931.9, 7242.5, 7590.2, 7976.3, 8402.6, 8870.4, 9381.1, 9935.2, 10531.0, 11167.0, 11843.0, 12557.0, 13306.0, 13514.0, 13692.0, 13739.0, 196250.0, 183540.0, 176480.0, 131800.0, 99372.0, 75863.0, 59323.0, 47956.0, 40296.0, 36314.0, 35334.0, 35234.0, 35091.0, 34903.0, 34093.0, 32134.0, 30093.0, 28878.0, 28215.0, 27917.0, 27852.0, 27931.0, 28090.0, 28286.0, 28304.0, 28230.0, 28155.0, 28080.0, 28005.0, 27929.0, 27853.0, 27776.0, 27699.0, 27622.0, 27545.0, 27467.0, 27389.0, 27311.0, 27232.0, 27153.0, 27073.0, 26994.0, 26913.0, 26833.0, 26752.0, 26671.0, 26589.0, 26508.0, 26425.0, 26343.0, 26260.0, 26177.0, 26093.0, 26009.0, 25925.0, 25841.0, 25756.0, 25671.0, 25585.0, 25499.0, 25413.0, 25327.0, 25240.0, 25153.0, 25066.0, 24978.0, 24890.0, 24802.0, 24713.0, 24624.0, 24535.0, 24446.0, 24356.0, 24266.0, 24176.0, 24085.0, 23994.0, 23903.0, 23812.0, 23720.0, 23629.0, 23537.0, 23444.0, 23352.0, 23259.0, 23166.0, 23073.0, 22980.0, 22886.0, 22792.0, 22698.0, 22604.0, 22510.0, 22415.0, 22320.0, 22225.0, 22130.0, 22035.0, 21940.0, 21844.0, 21748.0, 21652.0, 21556.0, 21460.0, 21364.0, 21268.0, 21171.0, 21075.0, 20978.0, 20881.0, 20784.0, 20687.0, 20590.0, 20493.0, 20395.0, 20298.0, 20201.0, 20103.0, 20006.0, 19908.0, 19810.0, 19713.0, 19615.0, 19517.0, 19420.0, 19322.0, 19224.0, 19126.0, 19028.0, 18931.0, 18833.0, 18735.0, 18637.0, 18540.0, 18442.0, 18344.0, 18247.0, 18149.0, 18051.0, 17954.0, 17857.0, 17759.0, 17734.0, 17732.0, 35276.0, 35251.0, 34752.0, 33686.0, 32675.0, 31716.0, 30805.0, 29941.0, 29121.0, 28341.0, 27601.0, 26897.0, 26228.0, 25591.0, 24985.0, 24408.0, 23859.0, 23335.0, 22836.0, 22360.0, 21905.0, 21472.0, 21064.0, 20681.0, 20321.0, 19982.0, 19662.0, 19359.0, 19071.0, 18798.0, 18538.0, 18291.0, 18054.0, 17827.0, 17610.0, 17402.0, 17202.0, 17009.0, 16823.0, 16643.0, 16469.0, 16301.0, 16137.0, 15979.0, 15825.0, 15675.0, 15529.0, 15387.0, 15248.0, 15113.0, 14980.0, 14850.0, 14723.0, 14599.0, 14477.0, 14357.0, 14240.0, 14125.0, 14011.0, 13900.0, 13790.0, 13682.0, 13576.0, 13471.0, 13368.0, 13266.0, 13166.0, 13067.0, 12969.0, 12873.0, 12778.0, 12684.0, 12591.0, 12499.0, 12408.0, 12319.0, 12230.0, 12143.0, 12056.0, 11970.0, 11886.0, 11802.0, 11719.0, 11637.0, 11556.0, 11475.0, 11396.0, 11317.0, 11239.0, 11162.0, 11086.0, 11010.0, 10935.0, 10861.0, 10788.0, 10715.0, 10643.0, 10572.0, 10502.0, 10432.0, 10363.0, 10294.0, 10226.0, 10159.0, 10093.0, 10027.0, 9961.5, 9896.9, 9833.0, 9769.6, 9706.9, 9644.7, 9583.2, 9522.3, 9462.0, 9402.2, 9343.1, 9284.5, 9226.5, 9169.0, 9112.2, 9055.9, 9000.1, 8944.9, 8890.2, 8836.0, 8782.4, 8729.4, 8722.8, 9587.3, 9564.6, 9511.3, 9458.4, 9406.1, 9354.3, 9303.0, 9252.2, 9201.9, 9152.0, 9102.7, 9053.8, 9005.3, 8957.4, 8909.8, 8862.8, 8816.1, 8769.9, 8724.2, 8678.8, 8633.9, 8589.4, 8545.2, 8501.5, 8458.1, 8415.1, 8372.4, 8330.1, 8309.1, 8500.3, 8499.8, 8458.8, 8417.6, 8376.7, 8336.1, 8295.9, 8255.9, 8216.3, 8177.0, 8138.0, 8099.2, 8060.7, 8022.5, 7984.6, 7946.9, 7909.5, 7872.4, 7835.4, 7798.7, 7762.3, 7726.0, 7690.0, 7654.2, 7618.6, 7583.2, 7548.0, 7512.9, 7478.1, 7443.4, 7408.9, 7374.5, 7340.4, 7306.3, 7272.4, 7238.7, 7205.0, 7171.5, 7138.2, 7104.9, 7071.8, 7048.4, 7038.8, 7300.9, 7277.7, 7244.2, 7210.7, 7177.3, 7144.0, 7110.9, 7077.7, 7044.7, 7011.8, 6978.9, 6946.0, 6913.3, 6880.6, 6847.9, 6815.4, 6782.8, 6750.3, 6717.9, 6685.5, 6653.1, 6620.8, 6588.4, 6556.1, 6523.8, 6491.6, 6459.3, 6427.1, 6394.8, 6362.6, 6330.4, 6298.2, 6266.0, 6233.8, 6201.6, 6169.4, 6137.2, 6105.1, 6072.9, 6040.7, 6008.6, 5976.4, 5944.3, 5912.1, 5880.0, 5847.9, 5815.7, 5783.6, 5751.5, 5719.4, 5687.3, 5655.2, 5623.1, 5591.0, 5558.9, 5526.8, 5494.7, 5462.7, 5430.7, 5398.7, 5366.7, 5334.7, 5302.8, 5270.8, 5239.0, 5207.1, 5175.3, 5143.5, 5111.7, 5080.0, 5048.3, 5016.6, 4985.0, 4953.5, 4921.9, 4890.5, 4859.0, 4827.7, 4796.3, 4765.1, 4733.9, 4702.7, 4671.6, 4640.6, 4609.6, 4578.7, 4547.8, 4517.0, 4486.2, 4455.5, 4424.8, 4394.2, 4363.6, 4333.1, 4302.6, 4272.3, 4242.0, 4211.8, 4181.6, 4151.6, 4121.6, 4091.8, 4062.0, 4032.3, 4002.8, 3973.3, 3943.9, 3914.5, 3885.3, 3856.2, 3827.2, 3798.3, 3769.5, 3740.9, 3712.4, 3684.0, 3655.8, 3627.7, 3599.7, 3571.9, 3544.2, 3516.7, 3489.3, 3462.1, 3435.0, 3408.0, 3381.2, 3354.6, 3328.1, 3301.8, 3275.6, 3249.6, 3223.7, 3198.0, 3172.5, 3147.1, 3121.9, 3096.8, 3072.0, 3047.2, 3022.7, 2998.3, 2974.1, 2950.0, 2926.1, 2902.4, 2878.8, 2855.5, 2832.2, 2809.2, 2786.3, 2760.8, 2730.2, 2699.9, 2669.9, 2640.4, 2611.1, 2582.3, 2553.7, 2525.5, 2497.7, 2470.2, 2443.0, 2416.1, 2389.5, 2363.3, 2337.4, 2311.8, 2286.5, 2261.4, 2236.7, 2212.3, 2188.1, 2164.3, 2140.7, 2117.4, 2094.4, 2071.6, 2049.2, 2026.9, 2005.0, 1983.3, 1961.8, 1940.6, 1919.7, 1898.9, 1878.5, 1858.2, 1838.3, 1818.5, 1799.0, 1779.7, 1760.6, 1741.7, 1723.1, 1704.6, 1686.4, 1668.4, 1650.6, 1633.0, 1615.7, 1598.5, 1581.5, 1564.7, 1548.1, 1531.7, 1515.5, 1499.4, 1483.6, 1467.9, 1452.4, 1436.9, 1421.4, 1406.2, 1391.1, 1376.1, 1361.4, 1346.8, 1332.4, 1318.2, 1304.1, 1290.2, 1276.4, 1262.8, 1249.4, 1236.1, 1222.9, 1210.0, 1202.6, 4515.2, 4494.0, 4437.3, 4381.3, 4326.1, 4271.6, 4217.7, 4172.7, 6263.3, 6260.3, 6180.7, 6102.0, 6024.4, 5947.8, 5872.1, 5797.3, 5723.5, 5650.7, 5578.8, 5507.8, 5437.8, 5368.6, 5300.4, 5233.0, 5166.5, 5100.9, 5036.1, 4972.1, 4909.0, 4846.7, 4785.1, 4724.4, 4664.5, 4605.3, 4546.9, 4489.3, 4432.4, 4376.2, 4320.8, 4266.0, 4212.0, 4158.7, 4106.0, 4054.0, 4002.7, 3952.1, 3902.1, 3852.8, 3804.1, 3756.0, 3708.5, 3661.7, 3615.4, 3592.8, 4194.2, 4190.8, 4135.5, 4081.1, 4027.2, 3974.0, 3921.5, 3869.8, 3818.7, 3768.3, 3718.5, 3671.1, 3625.3, 3580.2, 3535.9, 3492.2, 3449.3, 3407.0, 3365.4, 3324.4, 3284.0, 3244.2, 3235.4, 3443.7, 3429.8, 3387.2, 3345.3, 3304.0, 3263.2, 3223.1, 3183.5, 3144.5, 3106.1, 3068.1, 3031.9, 2996.4, 2961.4, 2926.9, 2893.0, 2859.5, 2826.5, 2794.0, 2762.0, 2734.8, 2730.4, 2837.0, 2825.9, 2793.9, 2762.4, 2731.3, 2700.6, 2670.2, 2640.3, 2610.7, 2581.5, 2552.6, 2524.2, 2496.2, 2468.2, 2440.3, 2412.7, 2385.5, 2358.6, 2332.0, 2305.7, 2279.7, 2254.1, 2228.7, 2203.6, 2178.8, 2154.3, 2130.0, 2106.1, 2082.4, 2058.9, 2035.8, 2012.9, 1990.2, 1967.8, 1945.4, 1923.3, 1901.4, 1879.8, 1858.5, 1837.3, 1816.4, 1795.8, 1775.3, 1755.2, 1735.2, 1715.5, 1696.0, 1676.7, 1657.6, 1638.7, 1619.8, 1601.2, 1582.7, 1564.4, 1544.8, 1525.4, 1505.9, 1486.7, 1467.7, 1449.0, 1430.6, 1412.4, 1394.4, 1376.7, 1359.2, 1342.0, 1325.0, 1308.2, 1291.7, 1275.4, 1259.3, 1243.4, 1227.7, 1212.3, 1197.0, 1182.0, 1167.1, 1152.4, 1137.8, 1123.4, 1109.1, 1095.1, 1081.3, 1067.6, 1054.2, 1040.9, 1027.8, 1014.9, 1002.1, 989.53, 977.12, 964.88, 952.8, 940.88, 929.12, 917.52, 906.07, 894.78, 883.63, 872.55, 861.43, 850.45, 839.62, 828.94, 818.4, 808.0, 797.75, 787.63, 777.64, 767.8, 758.08, 726.39, 612.42, 516.38, 435.47, 367.73, 310.93, 263.25, 222.89, 187.99, 158.74, 134.23, 113.45, 112.53, 108.28, 107.19, 298.6, 282.34, 263.4, 237.96, 229.53, 227.32, 312.35, 311.38, 298.99, 290.27, 277.86, 274.66, 311.89, 299.49, 248.28, 207.62, 174.59, 146.46, 122.8, 102.96, 86.362, 72.41, 60.607, 50.732, 42.402, 35.463, 29.686, 24.871, 20.687, 17.177, 14.273, 11.869, 9.8791, 8.2156, 6.8299, 5.6671, 4.6906, 3.8834, 3.2165, 2.7038, 2.6662, 2.5909, 2.5619, 13.682, 13.179, 12.162, 10.217, 8.5696, 7.1865, 6.0174, 5.0217, 4.1914, 3.4988, 2.9211, 2.439, 2.0334, 1.6909, 1.4063, 1.1696, 0.97292, 0.80936, 0.67336, 0.56025, 0.46619, 0.38795, 0.32286, 0.26871, 0.22474, 0.18821, 0.15763, 0.13203, 0.11059, 0.092641, 0.077609, 0.06502, 0.0],
                    'energies (keV)': [0.0053265, 0.005406, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.031654, 0.0321385, 0.0322677, 0.0324615, 0.032946, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.052136, 0.052934, 0.05302035, 0.0531468, 0.053466, 0.054264, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.17946997, 0.17949044, 0.17970956, 0.17973003, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33621965, 0.33698036, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38540604, 0.38636941, 0.38639394, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47099246, 0.47167755, 0.47240756, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4674798, 1.4679202, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5141684, 1.5150317, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8824082, 1.8865918, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0874384, 2.0921614, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3022094, 2.3038428, 2.3113904, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 8.47504, 8.60476, 8.639352, 8.69124, 8.82096, 9.030794, 9.424561, 9.568814, 9.607282, 9.653919, 9.664983, 9.809237, 9.913386, 10.06512, 10.10558, 10.16628, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.20181, 58.4927, 59.09265, 59.33021, 59.68655, 60.57739, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Cs': {'mass_absorption_coefficient (cm2/g)': [460090.0, 456310.0, 435160.0, 371510.0, 316430.0, 300680.0, 298760.0, 296600.0, 512590.0, 485960.0, 413820.0, 321410.0, 247200.0, 188770.0, 143520.0, 108910.0, 82651.0, 63135.0, 62851.0, 59345.0, 58384.0, 57125.0, 53809.0, 48124.0, 36972.0, 28601.0, 22306.0, 17559.0, 13965.0, 11231.0, 9140.6, 7532.2, 6286.1, 5313.4, 4550.3, 3946.2, 3463.2, 3072.2, 2750.7, 2482.1, 2254.2, 2214.4, 2168.5, 2156.6, 953770.0, 880410.0, 729930.0, 669280.0, 622540.0, 1459000.0, 1434900.0, 1085600.0, 416170.0, 130950.0, 52538.0, 26098.0, 15436.0, 10480.0, 7910.8, 6467.4, 5612.5, 5092.4, 4946.5, 4875.6, 4858.2, 6439.1, 6372.2, 6277.2, 6224.8, 6211.9, 6770.6, 6721.7, 6713.4, 6544.7, 6434.4, 6359.9, 6316.1, 6303.1, 6301.3, 6299.7, 6945.4, 6927.4, 6871.7, 6774.6, 6650.2, 6492.2, 6296.3, 6057.1, 5778.7, 5468.4, 5134.8, 4786.2, 4431.2, 4077.4, 3731.3, 3397.8, 3080.6, 2782.3, 2529.3, 2504.2, 2468.5, 2452.9, 2452.6, 11637.0, 11365.0, 11247.0, 17211.0, 17014.0, 16353.0, 15758.0, 13195.0, 11162.0, 9515.1, 8549.2, 8248.4, 8170.6, 9432.3, 9346.9, 9024.2, 8498.4, 8199.0, 8121.8, 8581.7, 8530.3, 8229.2, 7331.6, 6646.3, 6428.4, 6372.3, 6624.3, 6588.2, 6372.9, 5689.0, 4888.7, 4193.7, 3594.8, 3078.3, 2625.6, 2239.8, 1911.7, 1631.2, 1392.2, 1188.9, 1016.2, 869.52, 734.1, 614.67, 515.56, 433.29, 364.37, 305.68, 256.77, 220.23, 215.36, 211.62, 209.4, 667.75, 636.88, 584.26, 570.31, 558.93, 552.55, 758.38, 725.65, 676.02, 655.65, 647.75, 640.63, 729.76, 702.56, 639.23, 542.04, 458.18, 385.94, 324.56, 272.95, 229.29, 191.52, 159.85, 133.13, 110.66, 91.903, 76.389, 63.536, 52.89, 44.067, 36.749, 30.673, 25.606, 21.396, 17.851, 14.88, 12.369, 10.189, 8.3754, 6.8907, 5.6739, 5.2343, 5.0088, 4.9509, 30.177, 29.117, 29.038, 24.452, 20.494, 17.166, 14.359, 11.985, 10.001, 8.3441, 6.9608, 5.8063, 4.843, 4.0277, 3.3437, 2.7662, 2.2888, 1.8939, 1.5672, 1.297, 1.0735, 0.88858, 0.73556, 0.60894, 0.50427, 0.41788, 0.3463, 0.28701, 0.23788, 0.19717, 0.16344, 0.13549, 0.11232, 0.093121, 0.077207, 0.064016, 0.053081, 0.044016, 0.036501, 0.03027, 0.0],
                    'energies (keV)': [0.01142761, 0.011457, 0.011628, 0.01221612, 0.012838, 0.0130345, 0.01305903, 0.0130869, 0.0131655, 0.013362, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.022246, 0.02227063, 0.0225865, 0.0226773, 0.0228135, 0.023154, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07497, 0.0761175, 0.0764235, 0.0768825, 0.077224, 0.07803, 0.078406, 0.0787212, 0.07912411, 0.079194, 0.080376, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.158368, 0.160792, 0.1614384, 0.162408, 0.1648404, 0.168854, 0.1714385, 0.1721277, 0.1731615, 0.175746, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.226184, 0.229646, 0.2301188, 0.2305692, 0.231954, 0.235416, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.71099, 0.7154399, 0.7218725, 0.72471, 0.7247745, 0.7291275, 0.7358025, 0.7387605, 0.74001, 0.7431975, 0.75429, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.977648, 0.992612, 0.9966024, 0.9987612, 1.002588, 1.017552, 1.0437, 1.059675, 1.063935, 1.067676, 1.070325, 1.0863, 1.141345, 1.192758, 1.211015, 1.215883, 1.220098, 1.223186, 1.241442, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.911662, 4.953664, 4.98684, 5.006888, 5.036959, 5.112138, 5.252212, 5.295467, 5.332603, 5.35404, 5.386197, 5.466588, 5.600014, 5.660855, 5.685729, 5.708586, 5.742872, 5.828586, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 35.26491, 35.80468, 35.94862, 36.16452, 36.66551, 36.70429, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Cr': {'mass_absorption_coefficient (cm2/g)': [154920.0, 152420.0, 149980.0, 147550.0, 145100.0, 142570.0, 139940.0, 137180.0, 134270.0, 131180.0, 127910.0, 124460.0, 120820.0, 117010.0, 113030.0, 108910.0, 104660.0, 100320.0, 95907.0, 91450.0, 86981.0, 85274.0, 84260.0, 83992.0, 191640.0, 176080.0, 174860.0, 123310.0, 94676.0, 78301.0, 67227.0, 58853.0, 52095.0, 46448.0, 42946.0, 41910.0, 41651.0, 41643.0, 44808.0, 43882.0, 41220.0, 37830.0, 34906.0, 32374.0, 30175.0, 28248.0, 26536.0, 24985.0, 23549.0, 22185.0, 20863.0, 19560.0, 18261.0, 16947.0, 15626.0, 14313.0, 13027.0, 11784.0, 10599.0, 9483.9, 8446.9, 7492.2, 6621.2, 5833.3, 5125.7, 4494.0, 3933.0, 3437.0, 3000.0, 2616.0, 2472.9, 2393.2, 2376.8, 16383.0, 16146.0, 15986.0, 22671.0, 22638.0, 22578.0, 21761.0, 19203.0, 16279.0, 15614.0, 15043.0, 14895.0, 16661.0, 16099.0, 15739.0, 13490.0, 11554.0, 9880.0, 8441.4, 7204.6, 6081.1, 5130.3, 4322.1, 3637.0, 3060.2, 2574.0, 2165.3, 1821.9, 1533.5, 1291.3, 1087.9, 917.14, 771.17, 646.31, 542.3, 454.35, 377.25, 311.01, 256.67, 212.03, 175.33, 145.14, 120.26, 99.752, 82.824, 68.838, 62.295, 59.743, 59.086, 526.58, 518.54, 504.62, 430.52, 362.03, 305.41, 257.33, 215.78, 180.61, 150.57, 125.54, 104.67, 87.268, 72.289, 59.747, 49.367, 40.794, 33.712, 27.861, 23.027, 19.032, 15.732, 13.004, 10.75, 8.879, 7.2662, 5.9369, 4.851, 3.9638, 3.2386, 2.6462, 2.1623, 1.7669, 1.4438, 1.1798, 0.96417, 0.78795, 0.64394, 0.52627, 0.43011, 0.35153, 0.28682, 0.23312, 0.18948, 0.15401, 0.12518, 0.10175, 0.082707, 0.067228, 0.054647, 0.044421, 0.036109, 0.029352, 0.02386, 0.019396, 0.015767, 0.012818, 0.01042, 0.0084706, 0.0068861, 0.005598, 0.0045509, 0.0036997, 0.0030077, 0.0024452, 0.0019879, 0.0016161, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04165, 0.0422875, 0.0424575, 0.0427125, 0.04335, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.072618, 0.0737295, 0.07401695, 0.0740259, 0.0744705, 0.075582, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.56301, 0.572026, 0.5739255, 0.5773725, 0.5807815, 0.5831163, 0.5856525, 0.58599, 0.5866185, 0.595374, 0.6260625, 0.6692609, 0.680708, 0.691127, 0.6939054, 0.698073, 0.708492, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 5.869416, 5.959254, 5.983211, 6.019146, 6.051453, 6.108984, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Cu': {'mass_absorption_coefficient (cm2/g)': [134630.0, 132640.0, 130780.0, 129050.0, 127430.0, 125910.0, 124470.0, 123100.0, 121770.0, 120490.0, 119220.0, 117950.0, 116670.0, 115360.0, 114000.0, 112590.0, 109540.0, 104990.0, 100450.0, 95904.0, 91369.0, 86848.0, 82351.0, 77886.0, 73465.0, 69102.0, 64809.0, 60600.0, 56490.0, 54027.0, 53123.0, 52886.0, 77537.0, 74465.0, 64727.0, 55532.0, 49158.0, 44255.0, 40201.0, 36710.0, 33890.0, 33640.0, 33234.0, 33064.0, 34962.0, 34361.0, 33098.0, 30710.0, 28549.0, 26579.0, 24773.0, 23106.0, 21553.0, 20093.0, 18707.0, 17381.0, 16103.0, 14869.0, 13676.0, 12525.0, 11412.0, 10342.0, 9325.6, 8368.7, 7477.1, 6654.0, 5900.6, 5215.9, 4598.0, 4043.6, 3548.9, 3109.4, 2720.6, 2348.3, 2019.9, 1738.7, 1578.9, 1526.2, 1512.6, 9321.5, 9244.7, 9196.7, 8861.4, 8743.8, 12332.0, 11718.0, 10598.0, 8597.6, 8449.0, 8092.4, 8001.6, 8807.3, 8519.1, 8146.3, 6980.6, 5956.2, 5076.1, 4329.5, 3693.4, 3117.4, 2629.6, 2218.0, 1870.7, 1576.6, 1325.1, 1114.2, 937.54, 789.54, 661.4, 551.34, 460.01, 383.63, 318.38, 264.55, 220.1, 182.75, 151.58, 125.84, 104.57, 86.981, 72.416, 60.347, 50.336, 42.025, 37.656, 36.113, 35.687, 282.91, 271.43, 233.59, 195.73, 164.84, 138.89, 116.23, 97.122, 81.041, 67.557, 56.288, 46.894, 38.925, 32.262, 26.743, 22.169, 18.37, 15.219, 12.551, 10.336, 8.512, 7.0103, 5.7738, 4.7527, 3.8924, 3.1879, 2.6111, 2.1387, 1.7519, 1.4349, 1.1754, 0.96279, 0.78869, 0.64609, 0.52858, 0.43116, 0.3517, 0.28689, 0.23403, 0.19092, 0.15576, 0.12707, 0.10367, 0.084585, 0.069013, 0.05631, 0.045946, 0.037491, 0.030592, 0.024964, 0.020372, 0.016625, 0.013567, 0.011072, 0.0090362, 0.0073748, 0.0060191, 0.0049127, 0.0040098, 0.0032729, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.072128, 0.073232, 0.0735264, 0.07401695, 0.075072, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.117404, 0.1180797, 0.119201, 0.1196802, 0.120399, 0.122196, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.912478, 0.9264445, 0.9301689, 0.93198, 0.9342948, 0.9357555, 0.946245, 0.950049, 0.955755, 0.97002, 0.9987612, 1.067676, 1.074178, 1.090619, 1.095004, 1.10158, 1.118022, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 8.799322, 8.934005, 8.969921, 9.030794, 9.158478, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'La': {'mass_absorption_coefficient (cm2/g)': [177890.0, 171900.0, 165690.0, 141980.0, 119920.0, 99244.0, 80886.0, 65208.0, 52195.0, 41616.0, 33142.0, 26424.0, 21132.0, 16978.0, 16021.0, 15260.0, 15066.0, 15071.0, 14404.0, 14027.0, 11523.0, 9567.9, 8034.4, 6825.4, 5866.0, 5098.5, 4478.7, 3972.6, 3555.6, 3209.5, 2917.7, 2668.0, 2451.1, 2260.4, 2090.4, 1937.5, 1931.6, 1899.0, 1890.5, 73550.0, 59572.0, 42453.0, 17115.0, 8618.1, 5499.3, 4131.8, 3458.2, 3111.8, 2946.5, 2897.1, 2926.3, 2930.5, 2942.4, 2947.2, 4449.5, 4465.0, 4506.0, 4508.4, 4532.5, 4539.3, 5028.8, 5054.9, 5103.2, 5246.3, 5398.1, 5540.9, 5556.0, 5584.6, 5592.0, 6176.9, 6197.2, 6220.6, 6273.7, 6270.5, 6202.4, 6067.6, 5869.3, 5611.2, 5300.3, 4953.0, 4584.9, 4209.9, 3839.1, 3481.1, 3141.5, 2824.3, 2531.5, 2275.1, 2263.2, 2217.2, 2199.1, 9135.3, 8918.6, 8833.1, 8816.0, 13211.0, 12737.0, 12433.0, 10550.0, 8992.3, 7652.7, 7107.6, 6852.5, 6786.7, 7801.5, 7593.0, 7518.5, 6985.1, 6740.7, 6678.0, 7032.3, 6900.8, 6790.0, 5925.2, 5641.1, 5459.9, 5413.3, 5598.3, 5427.6, 5381.1, 4643.2, 3984.9, 3411.8, 2918.6, 2491.6, 2126.6, 1816.9, 1550.6, 1322.8, 1129.5, 965.16, 818.7, 689.86, 578.63, 485.42, 407.81, 343.22, 289.39, 244.11, 205.23, 197.54, 189.83, 187.85, 570.51, 547.39, 529.11, 501.09, 480.77, 475.55, 647.32, 621.57, 609.55, 585.59, 561.97, 555.93, 632.82, 609.59, 591.4, 499.82, 421.76, 355.25, 299.02, 251.27, 209.85, 175.41, 146.7, 122.34, 101.83, 84.567, 70.288, 58.469, 48.671, 40.549, 33.812, 28.221, 23.575, 19.712, 16.472, 13.745, 11.356, 9.3433, 7.6906, 6.3355, 5.2235, 4.6602, 4.4609, 4.4097, 26.467, 26.334, 25.467, 22.124, 18.553, 15.548, 13.019, 10.871, 9.0752, 7.5744, 6.3207, 5.2741, 4.4005, 3.659, 3.0298, 2.509, 2.0779, 1.721, 1.4256, 1.1809, 0.97836, 0.81059, 0.67164, 0.55655, 0.46129, 0.38282, 0.31772, 0.26371, 0.21889, 0.1817, 0.15084, 0.12523, 0.10397, 0.086323, 0.071676, 0.059518, 0.049424, 0.041044, 0.034086, 0.0],
                    'energies (keV)': [0.014472, 0.014688, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.031654, 0.0321385, 0.0322677, 0.0324615, 0.032946, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.096922, 0.0984055, 0.0988011, 0.0993945, 0.100878, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.187572, 0.1883732, 0.190443, 0.1912086, 0.192357, 0.195228, 0.2013709, 0.201684, 0.204771, 0.2055942, 0.206829, 0.209916, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.264992, 0.269048, 0.2701296, 0.271752, 0.275808, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.815066, 0.8175768, 0.8275415, 0.83153, 0.8358585, 0.8442575, 0.8476515, 0.848334, 0.8527425, 0.86547, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.100932, 1.117783, 1.122277, 1.129017, 1.141345, 1.145868, 1.180312, 1.198378, 1.203196, 1.210422, 1.220098, 1.228488, 1.304285, 1.334074, 1.354493, 1.359939, 1.368106, 1.388526, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.373046, 5.455286, 5.477217, 5.510113, 5.592354, 5.660855, 5.772788, 5.861147, 5.88471, 5.920053, 6.008412, 6.051453, 6.140974, 6.234969, 6.260034, 6.297632, 6.391626, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 38.14611, 38.72998, 38.88567, 39.11922, 39.19543, 39.70309, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Li': {'mass_absorption_coefficient (cm2/g)': [121650.0, 122300.0, 100640.0, 94014.0, 87249.0, 80477.0, 73813.0, 67348.0, 61155.0, 55284.0, 49772.0, 44641.0, 39900.0, 35543.0, 31553.0, 27922.0, 24637.0, 21683.0, 19037.0, 16678.0, 14583.0, 12729.0, 11092.0, 9650.9, 8385.6, 7277.0, 6307.6, 6148.2, 5950.1, 5898.8, 285130.0, 282100.0, 279090.0, 265970.0, 250690.0, 232170.0, 211710.0, 190470.0, 169350.0, 149040.0, 130010.0, 112540.0, 96781.0, 82763.0, 70439.0, 59708.0, 50439.0, 42485.0, 35697.0, 29930.0, 25050.0, 20934.0, 17470.0, 14561.0, 12120.0, 10077.0, 8368.7, 6943.0, 5754.6, 4765.3, 3942.4, 3258.8, 2691.5, 2221.0, 1831.3, 1508.8, 1242.1, 1021.7, 839.84, 689.86, 566.28, 464.55, 380.86, 312.08, 255.6, 209.24, 169.97, 137.66, 111.49, 90.296, 73.13, 59.228, 47.968, 38.85, 31.464, 25.483, 20.638, 16.715, 13.537, 10.963, 8.8782, 7.1897, 5.7955, 4.6515, 3.7333, 2.9963, 2.4048, 1.9301, 1.5491, 1.2433, 0.99788, 0.8009, 0.6428, 0.51591, 0.41407, 0.33233, 0.26673, 0.21408, 0.17168, 0.1373, 0.1098, 0.087811, 0.070225, 0.056161, 0.044913, 0.035918, 0.028725, 0.022972, 0.018371, 0.014692, 0.01175, 0.0093966, 0.0075147, 0.0060097, 0.0048144, 0.0038515, 0.0030794, 0.0024621, 0.0019686, 0.0015739, 0.0012584, 0.0010062, 0.00080446, 0.00064319, 0.00051426, 0.00041117, 0.00032875, 0.00026285, 0.00021016, 0.00016803, 0.00013435, 0.00010742, 8.5885e-05, 6.8669e-05, 5.4904e-05, 4.3899e-05, 3.5099e-05, 2.8064e-05, 2.2438e-05, 1.7941e-05, 1.4344e-05, 1.1469e-05, 9.1702e-06, 7.3321e-06, 5.8624e-06, 4.6873e-06, 3.7478e-06, 2.9966e-06, 2.3959e-06, 1.9157e-06, 1.5317e-06, 1.2247e-06, 9.7922e-07, 7.8295e-07, 6.2602e-07, 5.0054e-07, 4.0022e-07, 0.0],
                    'energies (keV)': [0.0053667, 0.0054468, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.053655, 0.05447625, 0.05469525, 0.05502375, 0.055845, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Tl': {'mass_absorption_coefficient (cm2/g)': [20294.0, 19652.0, 16481.0, 13758.0, 10897.0, 8925.4, 8366.6, 8299.1, 8222.9, 39884.0, 37665.0, 31765.0, 24948.0, 24632.0, 23756.0, 23558.0, 39304.0, 38150.0, 36757.0, 34556.0, 36079.0, 41184.0, 49647.0, 61437.0, 76334.0, 93643.0, 112050.0, 129630.0, 144190.0, 153630.0, 156560.0, 152560.0, 142300.0, 127300.0, 109530.0, 90947.0, 73154.0, 57258.0, 43821.0, 32956.0, 24485.0, 18198.0, 18058.0, 16970.0, 16660.0, 23166.0, 21696.0, 19133.0, 14261.0, 10718.0, 8154.1, 7843.1, 7387.4, 7272.5, 9997.1, 9494.7, 8957.4, 7175.8, 6096.0, 5802.1, 5774.7, 5727.0, 6264.6, 6089.5, 6018.4, 5847.2, 5785.6, 6141.7, 5942.1, 5843.2, 5223.1, 5132.2, 5089.4, 5056.6, 5174.2, 5068.1, 4864.2, 4703.4, 4796.9, 5134.4, 5706.1, 6495.2, 7471.5, 8586.8, 9774.6, 10964.0, 12058.0, 12979.0, 13656.0, 14045.0, 14127.0, 14065.0, 14011.0, 13994.0, 14352.0, 14313.0, 14299.0, 14249.0, 14172.0, 14150.0, 14372.0, 14292.0, 14224.0, 13725.0, 13062.0, 12570.0, 12509.0, 12446.0, 12383.0, 12319.0, 12255.0, 12190.0, 12125.0, 12059.0, 11993.0, 11926.0, 11859.0, 11791.0, 11723.0, 11654.0, 11586.0, 11517.0, 11447.0, 11377.0, 11307.0, 11237.0, 11167.0, 11096.0, 11025.0, 10954.0, 10883.0, 10811.0, 10740.0, 10668.0, 10597.0, 10525.0, 10453.0, 10382.0, 10310.0, 10238.0, 10166.0, 10094.0, 10023.0, 9950.9, 9879.3, 9858.4, 10429.0, 10414.0, 10340.0, 10267.0, 10193.0, 10120.0, 10047.0, 9974.2, 9901.5, 9829.0, 9756.7, 9684.6, 9612.6, 9540.9, 9469.5, 9398.2, 9327.2, 9256.5, 9186.0, 9115.8, 9045.8, 8976.1, 8906.7, 8837.6, 8768.7, 8700.2, 8631.9, 8563.9, 8496.2, 8428.9, 8361.8, 8295.1, 8228.7, 8162.7, 8096.9, 8084.4, 8159.4, 8143.3, 8078.2, 8013.5, 7949.1, 7885.1, 7821.4, 7758.1, 7695.1, 7632.5, 7570.3, 7508.5, 7447.0, 7385.9, 7325.1, 7264.8, 7204.8, 7145.2, 7086.0, 7027.1, 6968.6, 6910.6, 6852.9, 6795.5, 6738.6, 6682.1, 6625.9, 6570.1, 6514.7, 6459.7, 6405.0, 6350.8, 6296.9, 6295.5, 6396.2, 6376.1, 6322.4, 6269.2, 6216.3, 6163.9, 6111.8, 6060.1, 6008.8, 5957.8, 5907.2, 5857.1, 5807.2, 5757.8, 5708.7, 5660.1, 5611.7, 5563.8, 5516.2, 5469.0, 5422.2, 5375.7, 5329.6, 5283.8, 5238.4, 5193.3, 5148.7, 5104.3, 5060.3, 5016.7, 4973.4, 4930.5, 4887.9, 4845.6, 4803.5, 4754.2, 4705.4, 4657.2, 4609.4, 4562.2, 4515.3, 4468.7, 4422.6, 4376.9, 4331.8, 4287.1, 4242.9, 4199.2, 4155.9, 4113.1, 4070.8, 4028.9, 3987.4, 3946.4, 3905.9, 3865.7, 3826.0, 3786.8, 3747.9, 3709.4, 3671.4, 3633.8, 3596.5, 3559.7, 3523.3, 3487.2, 3451.5, 3416.2, 3381.3, 3346.8, 3312.6, 3278.8, 3245.3, 3212.3, 3179.5, 3146.9, 3114.7, 3082.8, 3051.2, 3020.0, 2989.1, 2958.6, 2928.3, 2898.4, 2868.8, 2839.6, 2810.6, 2782.0, 2753.6, 2725.6, 2697.8, 2670.4, 2643.2, 2616.4, 2589.8, 2563.5, 2537.5, 2511.7, 2486.3, 2461.1, 2436.1, 2411.5, 2387.1, 2363.0, 2339.1, 2315.4, 2292.0, 2268.7, 2245.7, 2223.0, 2200.4, 2178.2, 2156.1, 2134.3, 2112.8, 2091.4, 2070.3, 2049.5, 2028.8, 2008.4, 1988.2, 1968.2, 1947.5, 1927.0, 1906.7, 1886.6, 1866.7, 1847.1, 1827.6, 1808.4, 1789.5, 1770.7, 1751.8, 1732.9, 1714.1, 1695.6, 1677.3, 1659.2, 1641.4, 1623.7, 1606.2, 1589.0, 1571.9, 1555.0, 1538.3, 1521.9, 1505.6, 1489.5, 1473.6, 1457.8, 1442.3, 1426.9, 1411.7, 1396.7, 1381.8, 1367.1, 1352.6, 1338.3, 1324.1, 1310.1, 1296.2, 1282.5, 1268.9, 1255.5, 1242.2, 1229.1, 1216.2, 1203.4, 1190.7, 1178.2, 1165.8, 1153.5, 1141.4, 1129.5, 1117.6, 1105.9, 1094.4, 1082.9, 1071.6, 1060.4, 1049.4, 1038.5, 1027.6, 1017.0, 1006.4, 995.94, 985.61, 975.39, 965.28, 955.29, 945.42, 935.65, 925.99, 916.43, 906.99, 897.46, 887.95, 878.55, 869.27, 860.09, 851.01, 842.05, 833.08, 824.13, 815.29, 806.55, 797.92, 789.39, 780.97, 776.32, 2249.3, 2240.0, 2212.3, 2185.1, 2158.1, 2131.4, 2105.0, 2079.0, 2053.3, 2042.1, 2978.3, 2961.5, 2924.3, 2887.6, 2851.4, 2815.7, 2780.4, 2745.6, 2711.2, 2677.3, 2643.8, 2610.7, 2578.0, 2545.8, 2514.0, 2482.6, 2451.6, 2421.0, 2390.7, 2360.9, 2331.5, 2302.4, 2273.7, 2245.4, 2217.4, 2189.8, 2162.5, 2135.6, 2109.0, 2082.8, 2056.9, 2031.3, 2006.0, 1981.1, 1956.4, 1932.1, 1929.1, 2252.6, 2238.5, 2209.0, 2180.0, 2150.7, 2121.7, 2093.4, 2065.5, 2038.1, 2011.1, 1984.5, 1959.0, 1933.9, 1909.1, 1884.7, 1860.7, 1837.0, 1813.6, 1790.6, 1767.6, 1745.0, 1722.7, 1700.7, 1679.0, 1657.6, 1636.5, 1615.7, 1595.1, 1574.8, 1555.2, 1554.7, 1652.4, 1642.9, 1621.4, 1600.2, 1579.4, 1558.8, 1538.4, 1518.4, 1498.6, 1479.0, 1459.8, 1441.3, 1423.2, 1405.3, 1387.6, 1370.2, 1353.1, 1351.5, 1396.7, 1395.7, 1378.7, 1361.8, 1345.3, 1328.9, 1312.8, 1296.9, 1281.2, 1265.5, 1250.0, 1234.8, 1219.7, 1204.9, 1190.2, 1175.8, 1161.6, 1147.5, 1133.7, 1120.0, 1106.5, 1093.2, 1080.1, 1067.1, 1054.3, 1041.7, 1029.3, 1017.0, 1004.8, 992.87, 981.05, 969.38, 957.86, 946.49, 935.26, 924.18, 913.23, 902.41, 891.56, 880.86, 870.28, 859.84, 849.53, 839.34, 829.28, 819.35, 809.54, 799.84, 790.27, 780.82, 771.48, 762.25, 753.01, 743.71, 734.5, 725.4, 716.42, 707.55, 698.8, 690.17, 681.54, 672.94, 664.46, 656.09, 647.83, 639.67, 631.63, 623.69, 615.86, 608.13, 600.5, 592.97, 585.54, 578.21, 570.98, 563.84, 556.79, 549.84, 542.98, 536.21, 529.52, 522.93, 516.42, 510.0, 503.66, 497.41, 491.24, 485.15, 479.14, 473.21, 467.35, 461.58, 455.88, 450.25, 444.7, 439.14, 433.61, 428.15, 422.77, 417.46, 412.22, 407.05, 401.94, 396.91, 391.94, 387.04, 382.2, 377.43, 372.72, 368.07, 363.49, 358.96, 354.5, 350.09, 345.74, 341.45, 337.22, 333.04, 328.92, 324.85, 320.84, 316.88, 312.97, 309.11, 305.28, 301.49, 297.75, 294.06, 290.42, 286.82, 283.27, 279.77, 276.31, 272.9, 269.53, 266.21, 262.91, 259.65, 256.44, 253.26, 250.13, 247.02, 243.96, 240.94, 237.96, 235.01, 232.1, 229.22, 226.38, 223.57, 220.81, 218.07, 215.38, 212.72, 210.09, 207.5, 204.94, 202.42, 199.93, 197.47, 195.04, 192.65, 190.28, 187.95, 185.64, 183.37, 181.13, 178.91, 176.73, 153.56, 128.54, 107.77, 90.191, 75.498, 66.055, 63.468, 63.299, 62.803, 161.78, 155.39, 138.2, 115.08, 110.45, 109.24, 150.98, 145.07, 143.82, 138.05, 136.57, 156.27, 155.69, 149.94, 131.85, 110.92, 93.302, 78.435, 65.913, 55.417, 46.619, 39.212, 32.753, 27.305, 22.715, 18.893, 15.726, 13.101, 10.922, 9.1128, 7.609, 6.3582, 5.3166, 4.4386, 3.7088, 3.096, 2.5767, 2.1456, 1.7827, 1.6543, 1.5841, 1.5661, 7.4619, 7.1742, 6.0431, 5.083, 4.2687, 3.5833, 3.0067, 2.5181, 2.1086, 1.7656, 1.4785, 1.2382, 1.0368, 0.86765, 0.72621, 0.60788, 0.50889, 0.42606, 0.35674, 0.29873, 0.25018, 0.20953, 0.1755, 0.14701, 0.12316, 0.10318, 0.0],
                    'energies (keV)': [0.009713156, 0.009858128, 0.01069, 0.01142761, 0.01221612, 0.012838, 0.0130345, 0.01305903, 0.0130869, 0.0131655, 0.013362, 0.0139601, 0.01492335, 0.014994, 0.0152235, 0.0152847, 0.0153765, 0.015606, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.073892, 0.07401695, 0.075023, 0.0753246, 0.075777, 0.076908, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.097608, 0.099102, 0.0995004, 0.100098, 0.101592, 0.1033284, 0.1104581, 0.11613, 0.1179075, 0.1180797, 0.1183815, 0.1190925, 0.120344, 0.12087, 0.122186, 0.1226772, 0.123414, 0.125256, 0.1262272, 0.133574, 0.1349368, 0.1356185, 0.1361637, 0.1369815, 0.139026, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.378476, 0.384269, 0.3858138, 0.388131, 0.3924405, 0.393924, 0.398468, 0.404567, 0.4061934, 0.408633, 0.414732, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.60824487, 0.60975519, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72029019, 0.72230983, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84423174, 0.84676824, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.388655, 2.3899452, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.4843943, 2.4858058, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9536434, 2.9595566, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.410713, 3.4111733, 3.4206869, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.6962102, 3.7119896, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.40435, 12.59421, 12.60708, 12.64484, 12.72079, 12.91065, 13.47697, 14.40688, 14.62441, 14.6832, 14.77139, 14.99186, 15.03977, 15.26997, 15.33135, 15.40095, 15.42343, 15.65363, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 83.8198, 85.10275, 85.44487, 85.95806, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Lu': {'mass_absorption_coefficient (cm2/g)': [14520.0, 13954.0, 6259.5, 5932.8, 5717.2, 5593.3, 5547.8, 5571.3, 5657.7, 5803.0, 6005.0, 6262.8, 6576.1, 6945.6, 7372.4, 7857.6, 8402.5, 8476.8, 8611.1, 8647.0, 135460.0, 129620.0, 122860.0, 101270.0, 82827.0, 67202.0, 54709.0, 45144.0, 38072.0, 33006.0, 29490.0, 27143.0, 25990.0, 25708.0, 25659.0, 25640.0, 25725.0, 25503.0, 24991.0, 24589.0, 24502.0, 24631.0, 24898.0, 25249.0, 25638.0, 26034.0, 26230.0, 26258.0, 26286.0, 26314.0, 26342.0, 26369.0, 26396.0, 26424.0, 26450.0, 26477.0, 26504.0, 26530.0, 26556.0, 26582.0, 26607.0, 26633.0, 26658.0, 26682.0, 26707.0, 26731.0, 26755.0, 26779.0, 26802.0, 26825.0, 26848.0, 26871.0, 26893.0, 26915.0, 26937.0, 26958.0, 26979.0, 27000.0, 27021.0, 27041.0, 27061.0, 27080.0, 27099.0, 27118.0, 27137.0, 27155.0, 27173.0, 27190.0, 27207.0, 27224.0, 27241.0, 27257.0, 27273.0, 27288.0, 27303.0, 27318.0, 27332.0, 27346.0, 27355.0, 27276.0, 27196.0, 27116.0, 27035.0, 26953.0, 26871.0, 26789.0, 26706.0, 26622.0, 26538.0, 26453.0, 26368.0, 26282.0, 26196.0, 26109.0, 26022.0, 25934.0, 25846.0, 25757.0, 25668.0, 25578.0, 25488.0, 25397.0, 25306.0, 25215.0, 25123.0, 25030.0, 24937.0, 24844.0, 24751.0, 24657.0, 24562.0, 24467.0, 24372.0, 24277.0, 24181.0, 24084.0, 23988.0, 23891.0, 23793.0, 23696.0, 23598.0, 23500.0, 23401.0, 23302.0, 23203.0, 23104.0, 23004.0, 22904.0, 22804.0, 22703.0, 22603.0, 22502.0, 22401.0, 22299.0, 22198.0, 22096.0, 21994.0, 21892.0, 21789.0, 21687.0, 21584.0, 21481.0, 21378.0, 21275.0, 21172.0, 21068.0, 20965.0, 20861.0, 20757.0, 20654.0, 20550.0, 20446.0, 20342.0, 20237.0, 20133.0, 20029.0, 19925.0, 19820.0, 19716.0, 19612.0, 19533.0, 24710.0, 24695.0, 24380.0, 24060.0, 23749.0, 23447.0, 23153.0, 22868.0, 22591.0, 22321.0, 22058.0, 21916.0, 25183.0, 25145.0, 24752.0, 24371.0, 24002.0, 23644.0, 23298.0, 22962.0, 22637.0, 22321.0, 22014.0, 21717.0, 21432.0, 21156.0, 20890.0, 20633.0, 20385.0, 20145.0, 19912.0, 19686.0, 19466.0, 19254.0, 19049.0, 18852.0, 18660.0, 18475.0, 18295.0, 18120.0, 17950.0, 17784.0, 17623.0, 17466.0, 17312.0, 17162.0, 17015.0, 16871.0, 16730.0, 16591.0, 16456.0, 16322.0, 16191.0, 16063.0, 15936.0, 15811.0, 15688.0, 15568.0, 15448.0, 15331.0, 15215.0, 15100.0, 14987.0, 14876.0, 14766.0, 14657.0, 14549.0, 14443.0, 14338.0, 14234.0, 14131.0, 14029.0, 13928.0, 13829.0, 13730.0, 13632.0, 13536.0, 13440.0, 13345.0, 13251.0, 13158.0, 13066.0, 12975.0, 12884.0, 12795.0, 12706.0, 12618.0, 12530.0, 12444.0, 12358.0, 12273.0, 12189.0, 12106.0, 12023.0, 11941.0, 11860.0, 11779.0, 11699.0, 11620.0, 11542.0, 11464.0, 11387.0, 11310.0, 11234.0, 11159.0, 11085.0, 11011.0, 10938.0, 10865.0, 10793.0, 10722.0, 10651.0, 10581.0, 10511.0, 10442.0, 10374.0, 10306.0, 10239.0, 10173.0, 10107.0, 10041.0, 9976.3, 9912.1, 9848.3, 9785.2, 9722.6, 9710.9, 10533.0, 10513.0, 10450.0, 10387.0, 10325.0, 10264.0, 10203.0, 10142.0, 10082.0, 10023.0, 9963.5, 9905.0, 9847.0, 9789.4, 9732.4, 9675.8, 9619.7, 9564.0, 9508.8, 9454.1, 9399.8, 9345.9, 9292.5, 9239.5, 9186.9, 9134.7, 9082.9, 9048.4, 9227.9, 9216.0, 9176.8, 9126.2, 9076.0, 9026.1, 8976.6, 8927.4, 8878.6, 8830.1, 8782.0, 8734.3, 8686.8, 8639.7, 8592.9, 8546.4, 8500.2, 8454.4, 8408.8, 8363.5, 8318.5, 8273.8, 8229.3, 8185.1, 8141.2, 8097.6, 8054.1, 8011.0, 7968.0, 7925.3, 7882.9, 7840.6, 7798.6, 7756.8, 7715.2, 7673.8, 7632.6, 7591.6, 7550.8, 7510.1, 7469.7, 7429.4, 7389.3, 7355.3, 7349.4, 7578.0, 7556.7, 7516.3, 7476.1, 7436.0, 7396.1, 7356.4, 7316.8, 7277.3, 7237.9, 7198.7, 7159.6, 7120.7, 7081.8, 7043.1, 7004.5, 6966.0, 6927.7, 6889.4, 6851.3, 6813.2, 6775.3, 6737.4, 6699.7, 6662.0, 6624.5, 6587.0, 6549.6, 6512.3, 6475.0, 6437.9, 6400.8, 6363.8, 6326.9, 6290.1, 6253.4, 6216.7, 6180.1, 6143.6, 6107.2, 6070.9, 6034.6, 5998.4, 5962.3, 5926.2, 5890.3, 5854.4, 5818.6, 5782.9, 5747.2, 5711.7, 5676.2, 5640.8, 5605.5, 5570.2, 5535.1, 5500.0, 5465.0, 5430.1, 5395.3, 5360.6, 5325.9, 5291.4, 5256.9, 5222.4, 5188.0, 5153.6, 5119.3, 5085.2, 5051.1, 5017.1, 4983.2, 4949.4, 4915.7, 4882.1, 4848.6, 4815.2, 4782.0, 4748.8, 4715.7, 4682.8, 4649.9, 4617.2, 4584.6, 4552.0, 4519.7, 4487.4, 4455.2, 4423.2, 4391.2, 4359.4, 4327.6, 4296.0, 4264.5, 4233.1, 4201.9, 4170.7, 4139.7, 4108.8, 4078.0, 4047.3, 4016.8, 3986.4, 3956.1, 3926.0, 3896.0, 3866.1, 3836.3, 3806.6, 3777.1, 3747.7, 3718.5, 3689.4, 3660.5, 3631.8, 3603.2, 3574.8, 3546.5, 3518.4, 3490.5, 3462.8, 3435.2, 3407.8, 3380.6, 3353.5, 3326.6, 3299.9, 3273.4, 3247.0, 3220.9, 3194.9, 3169.1, 3143.5, 3118.0, 3092.8, 3067.7, 3042.8, 3014.8, 2980.3, 2946.3, 2912.8, 2879.6, 2846.9, 2814.6, 2782.6, 2751.1, 2720.0, 2689.2, 2658.9, 2628.9, 2599.3, 2570.0, 2541.1, 2512.6, 2484.4, 2456.5, 2429.0, 2401.9, 2375.1, 2348.6, 2322.4, 2296.5, 2271.0, 2245.8, 2220.9, 2196.3, 2172.0, 2147.9, 2124.2, 2100.8, 2077.6, 2054.8, 2032.2, 2009.9, 1987.8, 1966.0, 1944.5, 1923.3, 1902.3, 1881.5, 1861.0, 1840.7, 1820.7, 1801.0, 1781.4, 1762.1, 1743.0, 1724.2, 1705.6, 1687.2, 1669.0, 1651.0, 1633.3, 1615.7, 1598.4, 1581.3, 1564.3, 1547.6, 1531.1, 1514.7, 1498.6, 1482.6, 1466.9, 1451.3, 1435.9, 1420.7, 1405.6, 1390.8, 1376.1, 1361.6, 1347.0, 1332.6, 1318.3, 1304.2, 1290.2, 1276.4, 1262.8, 1249.3, 1236.0, 1222.8, 1209.8, 1197.0, 1184.3, 1171.7, 1159.3, 1147.1, 1134.9, 1123.0, 1111.1, 1099.4, 1094.5, 3986.0, 3960.7, 3911.5, 3862.9, 3814.9, 3767.6, 3720.8, 3687.7, 5515.7, 5504.8, 5435.7, 5367.4, 5300.0, 5233.5, 5167.8, 5103.0, 5038.9, 4975.7, 4913.3, 4851.8, 4790.9, 4730.9, 4671.6, 4613.1, 4555.4, 4498.3, 4442.0, 4386.4, 4331.5, 4277.4, 4223.9, 4171.1, 4118.9, 4067.4, 4016.6, 3966.5, 3916.9, 3868.0, 3819.7, 3772.1, 3725.0, 3678.5, 3632.6, 3587.3, 3542.6, 3498.5, 3454.9, 3411.8, 3369.4, 3327.4, 3286.0, 3254.5, 3819.8, 3808.5, 3769.1, 3719.2, 3669.9, 3621.3, 3573.0, 3525.4, 3478.4, 3432.1, 3386.3, 3342.3, 3300.6, 3259.5, 3219.1, 3179.4, 3140.3, 3101.8, 3063.9, 3026.6, 2989.9, 2953.8, 2918.2, 2883.1, 2875.5, 3062.3, 3050.7, 3012.8, 2975.5, 2938.7, 2902.5, 2866.8, 2831.6, 2796.9, 2762.7, 2728.9, 2696.9, 2665.4, 2634.5, 2604.0, 2573.9, 2544.3, 2515.2, 2486.4, 2458.1, 2450.5, 2542.7, 2540.3, 2514.1, 2485.8, 2457.9, 2430.4, 2403.2, 2376.4, 2349.9, 2323.7, 2297.8, 2272.3, 2247.0, 2221.7, 2196.8, 2172.1, 2147.8, 2123.7, 2099.9, 2076.3, 2053.1, 2030.1, 2007.3, 1984.8, 1962.6, 1940.6, 1918.9, 1897.3, 1876.1, 1855.0, 1834.2, 1813.6, 1793.2, 1773.1, 1753.2, 1733.3, 1713.8, 1694.4, 1675.2, 1654.8, 1634.7, 1614.8, 1595.2, 1575.9, 1556.7, 1537.8, 1519.2, 1500.7, 1482.5, 1464.5, 1446.4, 1428.4, 1410.5, 1392.9, 1375.5, 1358.3, 1341.3, 1324.2, 1307.3, 1290.7, 1274.3, 1258.1, 1242.1, 1226.4, 1210.9, 1195.5, 1180.4, 1165.5, 1150.8, 1136.3, 1122.0, 1107.9, 1093.9, 1080.2, 1066.6, 1053.2, 1040.0, 1027.0, 1014.2, 1001.4, 988.8, 976.38, 964.13, 952.04, 940.12, 928.35, 916.75, 905.3, 893.98, 882.79, 871.74, 860.84, 850.09, 839.49, 829.02, 818.7, 784.92, 661.67, 558.18, 470.67, 397.01, 335.3, 283.56, 240.14, 203.51, 171.83, 145.18, 122.84, 103.53, 102.62, 98.368, 97.275, 269.44, 256.62, 237.49, 205.15, 196.46, 195.22, 194.25, 268.78, 257.25, 250.39, 239.5, 236.72, 270.03, 263.25, 259.84, 222.09, 187.32, 157.87, 132.55, 111.12, 93.125, 78.055, 65.429, 54.805, 45.919, 38.426, 32.172, 26.96, 22.427, 18.622, 15.476, 12.872, 10.714, 8.9249, 7.4285, 6.1818, 5.1354, 4.2538, 3.525, 2.922, 2.4769, 2.424, 2.3739, 2.3475, 12.298, 11.848, 10.86, 9.123, 7.6531, 6.4189, 5.3623, 4.4784, 3.7407, 3.1249, 2.6108, 2.1816, 1.82, 1.5148, 1.261, 1.0497, 0.87398, 0.72772, 0.60599, 0.50466, 0.42032, 0.35009, 0.29163, 0.24294, 0.20354, 0.17073, 0.14322, 0.12015, 0.1008, 0.084576, 0.070966, 0.0],
                    'energies (keV)': [0.0069345, 0.007038, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02744, 0.02786, 0.027972, 0.02814, 0.02856, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.055664, 0.056516, 0.05667876, 0.0567432, 0.057084, 0.057936, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19485647, 0.19509776, 0.19514351, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20462018, 0.20497981, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.35885446, 0.35974552, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.40952587, 0.41019983, 0.41067415, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.50541541, 0.5057898, 0.50698463, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5882395, 1.5887605, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6388836, 1.6399164, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0213134, 2.0236492, 2.0258868, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2608064, 2.2661935, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4861428, 2.4952257, 2.4962571, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.059218, 9.197879, 9.234856, 9.29032, 9.428982, 9.653919, 10.14163, 10.29686, 10.32004, 10.33825, 10.40034, 10.55557, 10.65299, 10.81605, 10.85953, 10.92475, 11.03212, 11.08781, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.04752, 62.5287, 62.99723, 63.25049, 63.63037, 64.58008, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Th': {'mass_absorption_coefficient (cm2/g)': [26113.0, 25526.0, 24152.0, 17961.0, 14989.0, 13848.0, 13563.0, 26767.0, 25896.0, 24995.0, 19089.0, 14190.0, 12551.0, 11762.0, 11563.0, 11958.0, 11310.0, 11231.0, 8573.5, 6564.9, 5082.9, 3976.4, 3142.1, 2951.0, 2802.6, 2764.8, 21513.0, 20767.0, 20353.0, 19327.0, 18645.0, 18469.0, 29390.0, 28528.0, 28249.0, 24230.0, 19799.0, 15330.0, 11481.0, 8466.5, 6237.1, 4640.9, 3515.4, 2724.1, 2618.2, 2481.6, 2447.2, 3417.0, 3273.5, 3131.4, 2625.3, 2247.6, 2054.5, 1994.7, 1979.5, 2468.2, 2457.6, 2375.9, 2132.7, 1874.7, 1678.3, 1649.1, 1612.6, 1603.3, 1718.8, 1685.5, 1653.3, 1528.5, 1492.2, 1468.8, 1462.8, 1613.2, 1614.8, 1630.0, 1633.4, 1636.9, 1640.1, 1774.3, 1840.2, 2181.2, 3282.8, 5024.0, 7096.9, 9038.9, 10459.0, 11181.0, 11235.0, 10775.0, 10113.0, 9986.4, 9910.7, 9855.8, 10664.0, 10458.0, 10255.0, 10035.0, 9975.8, 10438.0, 10393.0, 10178.0, 9465.3, 8504.4, 7589.3, 6745.8, 6573.3, 6397.3, 6351.5, 6697.3, 6527.0, 6390.1, 5650.9, 4988.0, 4958.9, 4813.8, 4776.2, 4789.0, 4652.7, 4439.8, 3890.8, 3882.6, 3773.7, 3743.4, 3771.0, 3656.2, 3443.8, 2975.0, 2575.0, 2230.0, 1931.8, 1675.9, 1456.6, 1268.5, 1106.7, 966.76, 845.64, 735.37, 628.75, 553.55, 532.81, 531.17, 527.47, 1257.6, 1236.3, 1227.1, 1206.3, 1200.9, 1744.5, 1691.7, 1675.8, 1406.4, 1243.3, 1191.4, 1178.0, 1369.1, 1358.9, 1306.2, 1146.7, 965.79, 913.83, 878.64, 869.59, 912.18, 879.14, 867.43, 815.45, 785.33, 777.57, 799.99, 771.87, 768.5, 653.52, 555.88, 472.81, 401.12, 339.66, 288.06, 244.47, 206.98, 173.37, 145.17, 121.63, 102.07, 85.796, 72.173, 60.776, 51.104, 46.479, 44.691, 44.231, 108.36, 106.97, 104.28, 89.813, 74.92, 69.883, 67.039, 66.307, 92.578, 89.33, 89.045, 88.754, 85.838, 84.939, 96.723, 93.221, 86.632, 73.089, 61.636, 52.003, 43.603, 36.507, 30.593, 25.602, 21.431, 17.959, 15.01, 12.525, 10.459, 8.7406, 7.3101, 6.1184, 5.1248, 4.2957, 3.6023, 3.0185, 2.5247, 2.0997, 1.742, 1.4453, 1.2, 1.1747, 1.1261, 1.1136, 4.899, 4.7186, 4.4961, 3.7931, 3.1965, 2.6916, 2.266, 1.9068, 1.6032, 1.3481, 1.1336, 0.95331, 0.80183, 0.67486, 0.56826, 0.47856, 0.40306, 0.33951, 0.28602, 0.24097, 0.20304, 0.1711, 0.1442, 0.0],
                    'energies (keV)': [0.043215, 0.04340198, 0.04386, 0.04639671, 0.04802, 0.048755, 0.048951, 0.049245, 0.04959809, 0.04998, 0.05302035, 0.05667876, 0.05831, 0.0592025, 0.0594405, 0.0597975, 0.06058959, 0.06069, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.086142, 0.0874605, 0.0878121, 0.0883395, 0.089658, 0.09041995, 0.092414, 0.0938285, 0.0942057, 0.0947715, 0.096186, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.178164, 0.180891, 0.1816182, 0.182709, 0.185436, 0.1883732, 0.2013709, 0.2152655, 0.224812, 0.228253, 0.2291706, 0.2301188, 0.230547, 0.233988, 0.245997, 0.2629708, 0.2811158, 0.284396, 0.288749, 0.2899098, 0.291651, 0.296004, 0.3005128, 0.3212482, 0.328496, 0.333524, 0.3348648, 0.336876, 0.337512, 0.341904, 0.342678, 0.3434143, 0.3440556, 0.346122, 0.351288, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.662872, 0.6692609, 0.673018, 0.6757236, 0.679782, 0.689928, 0.699818, 0.7105295, 0.7133859, 0.7154399, 0.7176705, 0.728382, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.947954, 0.9624635, 0.9663327, 0.9721365, 0.986646, 0.9987612, 1.067676, 1.141345, 1.144836, 1.162359, 1.167032, 1.174041, 1.191564, 1.220098, 1.30291, 1.304285, 1.322852, 1.32817, 1.336147, 1.35609, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.26536, 3.31534, 3.319406, 3.328668, 3.34866, 3.39864, 3.420984, 3.473346, 3.487309, 3.508254, 3.548445, 3.560616, 3.793288, 3.965178, 4.02587, 4.042054, 4.055024, 4.066331, 4.127022, 4.334821, 4.633924, 4.733792, 4.806248, 4.82557, 4.854552, 4.927008, 4.953664, 5.078654, 5.156389, 5.177118, 5.208212, 5.285946, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 15.97429, 16.2188, 16.284, 16.3818, 16.46362, 16.62631, 17.59961, 18.81398, 19.29934, 19.59473, 19.67351, 19.79167, 20.06266, 20.08706, 20.11215, 20.36974, 20.45163, 20.57446, 20.88154, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 107.4579, 109.1026, 109.5413, 110.1992, 111.8439, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ti': {'mass_absorption_coefficient (cm2/g)': [111400.0, 98018.0, 92523.0, 51992.0, 31199.0, 21267.0, 16102.0, 13276.0, 11718.0, 10910.0, 10661.0, 10607.0, 10596.0, 15404.0, 15403.0, 15399.0, 15493.0, 15797.0, 16205.0, 16658.0, 17114.0, 17531.0, 17872.0, 18104.0, 18200.0, 18139.0, 17912.0, 17516.0, 16955.0, 16226.0, 15360.0, 14391.0, 13356.0, 12289.0, 11219.0, 10172.0, 9165.7, 8214.5, 7327.3, 6509.6, 5763.4, 5088.1, 4481.1, 3938.6, 3456.2, 3056.8, 3028.8, 2978.3, 2965.9, 2942.3, 21324.0, 21175.0, 20984.0, 29708.0, 29591.0, 28727.0, 27563.0, 23693.0, 20317.0, 19928.0, 19233.0, 19053.0, 21351.0, 20658.0, 19825.0, 17060.0, 14652.0, 12559.0, 10756.0, 9172.5, 7808.9, 6644.9, 5650.9, 4755.7, 4000.6, 3364.1, 2828.9, 2379.3, 2001.7, 1684.7, 1418.6, 1195.2, 1000.5, 837.97, 702.72, 587.72, 491.51, 411.44, 344.73, 286.33, 235.89, 194.54, 160.6, 132.71, 109.78, 90.896, 79.162, 75.855, 75.337, 75.006, 695.81, 666.98, 589.19, 494.51, 416.81, 351.68, 294.79, 246.81, 206.48, 172.69, 144.26, 120.08, 99.571, 82.293, 68.002, 56.196, 46.444, 38.386, 31.728, 26.226, 21.679, 17.922, 14.816, 12.25, 10.064, 8.2686, 6.7934, 5.5507, 4.5269, 3.6921, 3.0113, 2.4561, 2.0034, 1.6341, 1.3329, 1.0873, 0.88697, 0.72355, 0.59026, 0.48153, 0.39284, 0.32048, 0.26146, 0.21297, 0.17282, 0.14025, 0.11382, 0.092368, 0.074961, 0.060836, 0.049372, 0.040069, 0.03252, 0.026393, 0.02142, 0.017385, 0.01411, 0.011452, 0.0092946, 0.0075438, 0.0061229, 0.0049696, 0.0040336, 0.0032739, 0.0026573, 0.0021568, 0.0017506, 0.0014209, 0.0011534, 0.0],
                    'energies (keV)': [0.034773, 0.035292, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.059094, 0.0599985, 0.0602397, 0.06058959, 0.0606015, 0.061506, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.44639, 0.4484657, 0.45227, 0.4532225, 0.4550445, 0.4577775, 0.4591925, 0.4610385, 0.4638075, 0.46461, 0.47073, 0.4794098, 0.5124891, 0.5478508, 0.552426, 0.5608815, 0.5631363, 0.5665185, 0.574974, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.867072, 4.941568, 4.953664, 4.961434, 4.991232, 5.065728, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Te': {'mass_absorption_coefficient (cm2/g)': [2221.0, 3181.0, 15848.0, 64072.0, 157560.0, 259590.0, 312900.0, 297280.0, 237040.0, 167130.0, 108780.0, 67671.0, 41375.0, 25407.0, 15929.0, 10319.0, 7913.9, 7256.2, 7094.6, 10363.0, 10245.0, 9623.1, 7934.7, 6338.4, 5298.0, 4609.3, 4146.9, 3835.1, 3833.0, 3778.1, 3764.5, 4435.9, 4390.6, 4320.4, 4187.2, 4097.1, 4033.4, 3986.3, 3948.5, 3913.6, 3876.4, 3831.8, 3775.7, 3704.3, 3615.0, 3506.3, 3378.1, 3231.2, 3067.4, 2890.0, 2703.1, 2636.9, 2593.2, 2585.1, 2581.7, 16804.0, 16416.0, 16226.0, 25348.0, 25074.0, 24011.0, 20522.0, 16961.0, 14304.0, 12193.0, 10893.0, 10513.0, 10424.0, 10415.0, 11700.0, 11328.0, 10836.0, 10484.0, 10393.0, 10832.0, 10831.0, 10498.0, 9411.3, 8400.3, 8175.3, 8135.8, 8060.4, 8317.4, 8040.1, 7341.5, 6303.8, 5413.5, 4650.5, 3992.4, 3416.1, 2918.6, 2494.1, 2132.3, 1824.0, 1560.6, 1334.3, 1137.2, 966.18, 822.17, 700.75, 592.07, 495.82, 413.8, 345.19, 288.44, 253.7, 243.66, 241.41, 241.08, 811.0, 772.63, 722.68, 689.38, 681.37, 938.61, 937.92, 896.96, 824.31, 790.17, 781.49, 895.14, 890.36, 857.04, 756.22, 642.24, 542.78, 457.04, 384.05, 322.6, 271.07, 227.97, 191.31, 159.13, 132.16, 109.74, 91.188, 75.838, 63.13, 52.599, 43.864, 36.583, 30.528, 25.499, 21.246, 17.689, 14.67, 12.177, 10.117, 8.3299, 6.842, 6.1184, 5.8517, 5.7833, 36.046, 35.714, 34.662, 29.937, 25.082, 21.01, 17.586, 14.675, 12.242, 10.209, 8.5123, 7.0963, 5.9157, 4.9167, 4.0824, 3.3899, 2.8108, 2.3227, 1.9195, 1.5864, 1.3112, 1.0838, 0.89596, 0.7407, 0.6124, 0.50639, 0.41875, 0.3463, 0.28641, 0.23689, 0.19594, 0.16208, 0.13407, 0.11092, 0.091763, 0.075921, 0.062817, 0.051977, 0.04301, 0.035591, 0.029454, 0.024376, 0.0],
                    'energies (keV)': [0.039999, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.107996, 0.109649, 0.1100898, 0.1104581, 0.110751, 0.112404, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.164934, 0.1674585, 0.1681317, 0.1691415, 0.171666, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.560658, 0.5692395, 0.57085, 0.5715279, 0.5749605, 0.5795875, 0.5819175, 0.583542, 0.5856525, 0.59415, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.802326, 0.8146065, 0.8175768, 0.8178813, 0.8227935, 0.835074, 0.852306, 0.8653515, 0.8688303, 0.8739896, 0.8740485, 0.887094, 0.9342948, 0.98588, 0.9987612, 1.00097, 1.004994, 1.01103, 1.02612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.254572, 4.319693, 4.334821, 4.337059, 4.363107, 4.428228, 4.51976, 4.58894, 4.607388, 4.633924, 4.63506, 4.70424, 4.840416, 4.914504, 4.934261, 4.953664, 4.963896, 5.037984, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 31.17752, 31.65473, 31.78199, 31.97287, 32.08502, 32.45008, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Tb': {'mass_absorption_coefficient (cm2/g)': [1353.5, 1305.3, 1157.7, 1115.4, 1104.5, 4760.4, 4590.3, 3591.1, 3244.6, 3058.9, 2989.9, 3013.2, 3115.2, 3289.4, 3533.6, 3848.2, 4235.6, 4699.1, 5242.1, 5868.1, 6333.4, 6500.8, 6545.8, 123840.0, 122780.0, 117750.0, 102810.0, 85574.0, 70367.0, 57703.0, 47723.0, 40199.0, 39601.0, 38233.0, 37888.0, 37608.0, 36435.0, 34958.0, 31126.0, 28525.0, 26789.0, 25638.0, 24895.0, 24407.0, 24067.0, 23796.0, 23544.0, 23275.0, 22968.0, 22615.0, 22210.0, 21985.0, 21951.0, 21917.0, 21882.0, 21847.0, 21812.0, 21777.0, 21741.0, 21705.0, 21669.0, 21633.0, 21597.0, 21560.0, 21523.0, 21486.0, 21448.0, 21411.0, 21373.0, 21335.0, 21296.0, 21258.0, 21219.0, 21180.0, 21141.0, 21102.0, 21062.0, 21023.0, 20983.0, 20943.0, 20903.0, 20862.0, 20822.0, 20781.0, 20740.0, 20699.0, 20658.0, 20616.0, 20575.0, 20533.0, 20491.0, 20449.0, 20407.0, 20365.0, 20323.0, 20280.0, 20238.0, 20195.0, 20152.0, 20109.0, 20066.0, 20023.0, 19979.0, 19936.0, 19892.0, 19849.0, 19805.0, 19761.0, 19717.0, 19673.0, 19629.0, 19585.0, 19541.0, 19497.0, 19453.0, 19408.0, 19364.0, 19319.0, 19275.0, 19230.0, 19185.0, 19141.0, 19096.0, 19051.0, 19006.0, 18962.0, 18917.0, 18872.0, 18827.0, 18819.0, 48209.0, 46899.0, 45104.0, 43418.0, 41833.0, 40345.0, 38946.0, 37632.0, 36397.0, 35236.0, 34144.0, 33118.0, 32152.0, 31244.0, 30390.0, 29586.0, 28829.0, 28117.0, 27446.0, 26815.0, 26203.0, 25634.0, 25107.0, 24618.0, 24164.0, 23741.0, 23347.0, 22978.0, 22632.0, 22308.0, 22003.0, 21717.0, 21446.0, 21190.0, 20948.0, 20719.0, 20501.0, 20290.0, 20036.0, 19791.0, 19555.0, 19326.0, 19105.0, 18891.0, 18683.0, 18481.0, 18285.0, 18094.0, 17908.0, 17727.0, 17550.0, 17377.0, 17208.0, 17042.0, 16880.0, 16721.0, 16566.0, 16413.0, 16263.0, 16115.0, 15971.0, 15828.0, 15688.0, 15550.0, 15414.0, 15281.0, 15149.0, 15019.0, 14891.0, 14765.0, 14640.0, 14517.0, 14396.0, 14276.0, 14157.0, 14040.0, 13925.0, 13811.0, 13698.0, 13587.0, 13477.0, 13368.0, 13260.0, 13154.0, 13048.0, 12944.0, 12841.0, 12740.0, 12639.0, 12539.0, 12441.0, 12343.0, 12247.0, 12151.0, 12057.0, 11963.0, 11871.0, 11780.0, 11689.0, 11599.0, 11511.0, 11423.0, 11336.0, 11251.0, 11166.0, 11082.0, 10998.0, 10916.0, 10835.0, 10754.0, 10675.0, 10596.0, 10518.0, 10441.0, 10364.0, 10289.0, 10214.0, 10140.0, 10067.0, 9995.0, 9923.6, 9852.9, 9783.0, 9713.9, 9645.5, 9578.0, 9511.1, 9445.0, 9379.7, 9315.1, 9251.2, 9188.1, 9125.6, 9075.6, 10107.0, 10097.0, 10045.0, 9983.6, 9922.7, 9862.5, 9802.9, 9744.1, 9685.9, 9628.3, 9571.4, 9515.2, 9459.6, 9404.6, 9350.3, 9296.5, 9243.4, 9190.9, 9150.7, 9423.4, 9414.2, 9372.0, 9321.3, 9271.1, 9221.4, 9172.2, 9123.6, 9075.5, 9027.9, 8980.8, 8934.2, 8888.0, 8842.4, 8797.1, 8752.4, 8708.1, 8664.2, 8620.8, 8577.8, 8535.2, 8493.0, 8451.2, 8409.8, 8368.8, 8328.2, 8287.9, 8248.0, 8208.4, 8169.2, 8130.3, 8091.7, 8053.4, 8015.5, 7977.8, 7940.4, 7903.3, 7866.5, 7830.0, 7793.7, 7757.7, 7721.9, 7686.3, 7651.0, 7615.9, 7581.0, 7546.3, 7511.8, 7477.5, 7443.4, 7409.5, 7387.8, 7724.2, 7719.1, 7689.6, 7655.2, 7621.0, 7586.8, 7552.9, 7519.0, 7485.3, 7451.8, 7418.3, 7384.9, 7351.7, 7318.6, 7285.5, 7252.6, 7219.7, 7186.9, 7154.2, 7121.6, 7089.1, 7056.6, 7024.1, 6991.7, 6959.3, 6927.0, 6894.7, 6862.4, 6830.2, 6797.9, 6765.7, 6733.6, 6701.4, 6669.2, 6637.1, 6605.0, 6572.8, 6540.7, 6508.6, 6476.4, 6444.2, 6412.0, 6379.9, 6347.7, 6315.5, 6283.3, 6251.1, 6218.9, 6186.7, 6154.5, 6122.3, 6090.1, 6057.8, 6025.6, 5993.4, 5961.1, 5928.9, 5896.6, 5864.3, 5832.1, 5799.8, 5767.5, 5735.3, 5703.0, 5670.7, 5638.5, 5606.2, 5574.0, 5541.7, 5509.5, 5477.2, 5445.0, 5412.8, 5380.6, 5348.4, 5316.3, 5284.1, 5252.0, 5219.9, 5187.8, 5155.7, 5123.7, 5091.6, 5059.5, 5027.4, 4995.3, 4963.2, 4931.1, 4899.1, 4867.0, 4835.0, 4803.0, 4771.1, 4739.1, 4707.2, 4675.4, 4643.6, 4611.8, 4580.1, 4548.5, 4516.9, 4485.4, 4454.0, 4422.6, 4391.3, 4360.1, 4328.9, 4297.9, 4266.9, 4236.0, 4205.2, 4174.5, 4143.9, 4113.5, 4083.1, 4052.8, 4022.6, 3992.6, 3962.7, 3932.9, 3903.2, 3873.6, 3844.1, 3814.8, 3785.6, 3756.5, 3727.6, 3698.8, 3670.1, 3641.6, 3613.2, 3585.0, 3556.9, 3528.9, 3501.1, 3473.4, 3445.9, 3418.5, 3391.3, 3364.3, 3337.4, 3310.6, 3284.0, 3257.6, 3231.3, 3205.2, 3179.2, 3153.4, 3127.8, 3102.3, 3077.0, 3051.8, 3026.9, 3002.0, 2977.4, 2952.9, 2928.5, 2904.3, 2880.3, 2856.5, 2832.8, 2809.3, 2786.0, 2762.8, 2739.7, 2716.9, 2694.2, 2671.7, 2649.3, 2627.1, 2605.1, 2583.2, 2561.5, 2539.9, 2518.6, 2497.3, 2476.3, 2455.4, 2434.6, 2414.0, 2393.6, 2373.4, 2353.2, 2333.3, 2313.5, 2293.9, 2272.8, 2248.6, 2224.8, 2201.2, 2177.8, 2154.7, 2131.9, 2109.3, 2087.0, 2065.0, 2043.2, 2021.6, 2000.3, 1979.2, 1958.3, 1937.7, 1917.3, 1897.1, 1877.2, 1857.5, 1838.0, 1818.7, 1799.6, 1780.8, 1762.2, 1743.7, 1725.5, 1707.0, 1688.8, 1670.7, 1652.9, 1635.3, 1617.8, 1600.6, 1583.6, 1566.7, 1550.1, 1533.6, 1517.3, 1501.2, 1485.3, 1469.6, 1454.0, 1439.2, 5641.9, 5640.7, 5570.5, 5500.0, 5430.4, 5361.7, 5293.8, 5271.3, 7947.4, 7888.4, 7787.6, 7688.1, 7590.0, 7493.0, 7397.4, 7303.0, 7209.8, 7117.8, 7027.0, 6937.4, 6848.9, 6761.6, 6675.4, 6590.3, 6506.3, 6423.4, 6341.6, 6260.8, 6181.1, 6102.4, 6024.7, 5948.0, 5872.3, 5797.6, 5723.8, 5651.0, 5579.2, 5508.2, 5438.2, 5369.1, 5300.9, 5233.5, 5167.0, 5101.4, 5036.6, 4972.7, 4909.6, 4847.3, 4785.8, 4725.0, 4665.1, 4605.9, 4547.5, 4489.9, 4432.9, 4376.7, 4369.2, 5097.5, 5063.5, 4997.2, 4931.7, 4867.1, 4803.4, 4740.6, 4678.5, 4617.2, 4556.7, 4497.2, 4441.4, 4386.4, 4332.3, 4279.1, 4226.7, 4175.1, 4124.3, 4074.3, 4039.6, 4310.3, 4306.2, 4256.6, 4203.7, 4151.6, 4100.3, 4049.7, 3999.8, 3950.7, 3902.3, 3854.6, 3808.3, 3763.6, 3719.6, 3676.3, 3633.7, 3591.6, 3550.3, 3509.5, 3469.3, 3429.8, 3390.7, 3352.3, 3351.2, 3485.0, 3472.8, 3433.9, 3395.6, 3357.8, 3320.4, 3283.6, 3247.3, 3211.4, 3175.9, 3140.9, 3106.6, 3072.6, 3039.1, 3005.1, 2971.5, 2938.4, 2905.6, 2873.2, 2841.2, 2809.6, 2778.4, 2747.5, 2717.0, 2686.8, 2657.0, 2627.5, 2598.3, 2569.5, 2541.0, 2512.8, 2484.9, 2457.1, 2429.5, 2402.1, 2375.0, 2348.3, 2321.8, 2295.6, 2269.7, 2244.1, 2218.8, 2193.8, 2169.0, 2144.6, 2120.4, 2096.4, 2072.7, 2048.8, 2025.2, 2001.9, 1978.8, 1956.0, 1933.2, 1910.6, 1888.2, 1866.0, 1844.2, 1822.6, 1801.2, 1780.1, 1759.3, 1738.6, 1718.3, 1698.2, 1678.3, 1658.7, 1639.3, 1620.1, 1601.0, 1582.0, 1563.3, 1544.8, 1526.5, 1508.5, 1490.7, 1473.1, 1455.7, 1438.5, 1421.6, 1404.9, 1388.4, 1372.0, 1355.9, 1340.0, 1324.3, 1307.4, 1290.7, 1274.3, 1258.1, 1242.1, 1226.3, 1210.7, 1195.4, 1180.2, 1165.3, 1150.6, 1136.0, 1121.7, 1107.5, 1093.4, 1079.3, 1065.4, 1051.8, 1038.3, 1024.9, 1011.8, 998.86, 986.08, 973.48, 961.04, 948.77, 936.67, 924.73, 912.95, 901.33, 889.87, 878.56, 867.38, 856.22, 845.21, 834.35, 823.63, 813.06, 802.63, 792.34, 782.19, 772.18, 762.3, 752.55, 742.94, 733.45, 724.09, 714.85, 705.74, 696.76, 687.89, 679.14, 670.51, 661.99, 653.55, 645.2, 636.96, 610.09, 514.29, 434.11, 366.94, 310.57, 262.02, 220.8, 186.37, 157.6, 134.25, 132.92, 129.15, 127.84, 366.89, 350.07, 317.87, 298.17, 286.18, 283.12, 388.47, 372.51, 368.63, 358.27, 343.33, 339.76, 386.94, 372.96, 357.75, 301.87, 253.03, 211.22, 176.52, 147.76, 123.79, 103.81, 86.989, 72.778, 60.787, 50.689, 42.305, 35.34, 29.547, 24.726, 20.71, 17.224, 14.3, 11.883, 9.8632, 8.1814, 6.7694, 5.5943, 4.6233, 3.8238, 3.2055, 3.165, 3.0707, 3.0361, 16.845, 16.223, 14.984, 12.584, 10.551, 8.8423, 7.4025, 6.196, 5.179, 4.3157, 3.5967, 2.9979, 2.4951, 2.0715, 1.72, 1.4282, 1.1861, 0.98506, 0.81819, 0.67965, 0.56461, 0.46907, 0.38974, 0.32384, 0.27008, 0.22548, 0.18825, 0.15719, 0.13126, 0.10961, 0.091536, 0.076449, 0.063851, 0.053333, 0.0],
                    'energies (keV)': [0.008643, 0.008772, 0.009212, 0.009353, 0.0093906, 0.009447, 0.009588, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.024892, 0.025273, 0.0253746, 0.02545001, 0.025527, 0.025908, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.03822, 0.038805, 0.038961, 0.039195, 0.03978, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14695355, 0.14704645, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.2847492, 0.28501845, 0.2852508, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.3098867, 0.31023873, 0.31051331, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39739863, 0.39810635, 0.39840134, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2410448, 1.2412555, 1.2413551, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2747297, 1.2752703, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6098611, 1.6127389, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7660507, 1.7686894, 1.7693492, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9642536, 1.9707463, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.36372, 7.392525, 7.47643, 7.506486, 7.55157, 7.66428, 7.902609, 8.086568, 8.210342, 8.243349, 8.292858, 8.416632, 8.44789, 8.53384, 8.66446, 8.699292, 8.75154, 8.88216, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 50.95579, 51.18542, 51.73572, 51.94371, 52.25568, 53.03561, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Tc': {'mass_absorption_coefficient (cm2/g)': [17960.0, 17147.0, 17090.0, 16297.0, 16094.0, 82638.0, 79014.0, 77220.0, 92123.0, 110490.0, 131680.0, 154530.0, 177310.0, 197920.0, 214160.0, 224150.0, 226730.0, 221630.0, 209570.0, 191970.0, 170710.0, 147730.0, 124740.0, 103070.0, 83640.0, 66912.0, 52957.0, 52256.0, 49484.0, 48775.0, 101290.0, 94900.0, 85773.0, 64011.0, 48345.0, 37096.0, 28898.0, 22848.0, 18335.0, 14934.0, 13516.0, 12948.0, 12804.0, 13698.0, 13455.0, 13206.0, 11508.0, 10005.0, 8823.5, 7881.2, 7117.9, 6489.4, 5962.5, 5513.0, 5122.3, 4797.6, 4525.2, 4275.1, 4041.8, 3820.8, 3609.5, 3406.2, 3209.5, 3018.9, 2833.8, 2813.4, 2776.1, 2772.2, 2761.3, 7572.9, 7649.8, 7734.0, 11122.0, 11162.0, 11693.0, 11917.0, 15169.0, 18694.0, 21444.0, 23088.0, 23570.0, 23038.0, 21916.0, 21748.0, 21557.0, 21458.0, 23941.0, 23531.0, 23368.0, 22924.0, 22804.0, 23713.0, 23621.0, 23253.0, 21477.0, 19257.0, 17743.0, 17254.0, 17126.0, 17853.0, 17706.0, 17228.0, 15752.0, 13825.0, 12089.0, 10546.0, 9162.0, 7937.3, 6868.0, 5938.3, 5131.2, 4357.2, 3691.7, 3132.6, 2662.3, 2265.9, 1931.7, 1649.6, 1410.7, 1199.5, 1019.0, 866.73, 737.91, 628.27, 535.51, 496.73, 479.12, 474.58, 1773.5, 1723.8, 1700.1, 1687.9, 1616.3, 1598.0, 2190.1, 2104.9, 2000.4, 1872.4, 1800.6, 1781.6, 2017.7, 1940.4, 1636.5, 1377.8, 1158.5, 974.14, 818.74, 688.48, 579.1, 487.32, 408.38, 341.52, 285.25, 238.42, 199.46, 167.03, 139.87, 116.91, 97.003, 80.563, 66.936, 55.619, 46.092, 38.155, 31.512, 26.05, 21.554, 17.85, 14.794, 12.273, 11.443, 10.969, 10.847, 73.809, 70.796, 70.472, 58.778, 49.395, 41.529, 34.707, 28.912, 24.088, 20.071, 16.726, 13.94, 11.62, 9.6163, 7.9548, 6.581, 5.4449, 4.5051, 3.7273, 3.083, 2.549, 2.1077, 1.7405, 1.433, 1.1791, 0.96919, 0.79669, 0.65493, 0.53841, 0.44265, 0.36393, 0.29923, 0.24604, 0.20231, 0.16636, 0.1368, 0.1125, 0.092523, 0.076093, 0.062583, 0.051474, 0.042338, 0.034824, 0.028645, 0.023563, 0.019383, 0.015945, 0.013117, 0.0],
                    'energies (keV)': [0.006763068, 0.00686401, 0.006871351, 0.006976524, 0.007004571, 0.00704664, 0.007151814, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.038122, 0.0387055, 0.0388611, 0.0390945, 0.039678, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.067032, 0.068058, 0.0683316, 0.068742, 0.06923942, 0.069768, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.247842, 0.251272, 0.2516355, 0.2526471, 0.2541645, 0.255118, 0.2561436, 0.257682, 0.257958, 0.261528, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4165, 0.4195189, 0.422875, 0.424575, 0.427125, 0.4335, 0.436002, 0.4426755, 0.4444551, 0.4471245, 0.4484657, 0.453798, 0.4794098, 0.5124891, 0.536648, 0.544862, 0.5470524, 0.5478508, 0.550338, 0.558552, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.623362, 2.663515, 2.674223, 2.690284, 2.717235, 2.730438, 2.737336, 2.779234, 2.790407, 2.807166, 2.849064, 2.904724, 2.98165, 3.027288, 3.039458, 3.057713, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 20.62312, 20.93878, 21.02296, 21.14922, 21.46488, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ta': {'mass_absorption_coefficient (cm2/g)': [47371.0, 46396.0, 55425.0, 58905.0, 61782.0, 63767.0, 64634.0, 64246.0, 62577.0, 59707.0, 55814.0, 51143.0, 45972.0, 40582.0, 35215.0, 32961.0, 31788.0, 31481.0, 37323.0, 36071.0, 35883.0, 30020.0, 24845.0, 20628.0, 17211.0, 14483.0, 14338.0, 13811.0, 13677.0, 51572.0, 49299.0, 46036.0, 37794.0, 30936.0, 29681.0, 28358.0, 28020.0, 42452.0, 40830.0, 39472.0, 33413.0, 28442.0, 24373.0, 21288.0, 19149.0, 17850.0, 17766.0, 17588.0, 17547.0, 17668.0, 17550.0, 17436.0, 17407.0, 17804.0, 18508.0, 19411.0, 19916.0, 19992.0, 20067.0, 20142.0, 20217.0, 20291.0, 20366.0, 20439.0, 20513.0, 20585.0, 20658.0, 20730.0, 20801.0, 20872.0, 20942.0, 21013.0, 21083.0, 21152.0, 21220.0, 21288.0, 21354.0, 21420.0, 21486.0, 21550.0, 21613.0, 21676.0, 21738.0, 21798.0, 21858.0, 21917.0, 21975.0, 22031.0, 22087.0, 22142.0, 22195.0, 22248.0, 22300.0, 22350.0, 22399.0, 22447.0, 22494.0, 22540.0, 22585.0, 22628.0, 22670.0, 22711.0, 22751.0, 22790.0, 22827.0, 22863.0, 22898.0, 22932.0, 22964.0, 22995.0, 23025.0, 23054.0, 23081.0, 23107.0, 23132.0, 23155.0, 23178.0, 23199.0, 23218.0, 23237.0, 23254.0, 23269.0, 23284.0, 23297.0, 23309.0, 23320.0, 23329.0, 23337.0, 23344.0, 23349.0, 23354.0, 23357.0, 23358.0, 23359.0, 23358.0, 23356.0, 23353.0, 23348.0, 23343.0, 23336.0, 23328.0, 23318.0, 23308.0, 23296.0, 23283.0, 23269.0, 23254.0, 23238.0, 23220.0, 23201.0, 23182.0, 23161.0, 23139.0, 23116.0, 23091.0, 23066.0, 23040.0, 23013.0, 22984.0, 22955.0, 22924.0, 22893.0, 22860.0, 22827.0, 22792.0, 22757.0, 22721.0, 22683.0, 22645.0, 22606.0, 22566.0, 22525.0, 22483.0, 22441.0, 22397.0, 22353.0, 22308.0, 22262.0, 22215.0, 22168.0, 22119.0, 22070.0, 22020.0, 21970.0, 21919.0, 21867.0, 21814.0, 21761.0, 21706.0, 21652.0, 21596.0, 21540.0, 21484.0, 21427.0, 21369.0, 21311.0, 21252.0, 21192.0, 21132.0, 21072.0, 21011.0, 20949.0, 20887.0, 20824.0, 20761.0, 20698.0, 20634.0, 20570.0, 20505.0, 20440.0, 20374.0, 20308.0, 20242.0, 20175.0, 20108.0, 20041.0, 19973.0, 19905.0, 19837.0, 19768.0, 19699.0, 19630.0, 19561.0, 19544.0, 21077.0, 21032.0, 20935.0, 20838.0, 20741.0, 20644.0, 20548.0, 20452.0, 20356.0, 20260.0, 20165.0, 20122.0, 21186.0, 21159.0, 21043.0, 20927.0, 20812.0, 20698.0, 20585.0, 20472.0, 20360.0, 20248.0, 20137.0, 20018.0, 19901.0, 19785.0, 19670.0, 19556.0, 19444.0, 19332.0, 19215.0, 19098.0, 18983.0, 18868.0, 18755.0, 18643.0, 18532.0, 18422.0, 18314.0, 18206.0, 18100.0, 17994.0, 17889.0, 17786.0, 17683.0, 17581.0, 17479.0, 17379.0, 17279.0, 17180.0, 17081.0, 16984.0, 16887.0, 16790.0, 16695.0, 16600.0, 16505.0, 16411.0, 16318.0, 16225.0, 16133.0, 16042.0, 15951.0, 15861.0, 15771.0, 15681.0, 15593.0, 15504.0, 15417.0, 15329.0, 15243.0, 15157.0, 15071.0, 14986.0, 14901.0, 14817.0, 14733.0, 14650.0, 14567.0, 14485.0, 14403.0, 14322.0, 14241.0, 14161.0, 14081.0, 14002.0, 13923.0, 13845.0, 13767.0, 13689.0, 13612.0, 13536.0, 13460.0, 13384.0, 13309.0, 13234.0, 13160.0, 13086.0, 13013.0, 12940.0, 12867.0, 12795.0, 12724.0, 12653.0, 12582.0, 12512.0, 12442.0, 12372.0, 12303.0, 12235.0, 12167.0, 12099.0, 12031.0, 11965.0, 11898.0, 11832.0, 11771.0, 11766.0, 12531.0, 12494.0, 12427.0, 12361.0, 12295.0, 12229.0, 12164.0, 12100.0, 12035.0, 11971.0, 11908.0, 11845.0, 11782.0, 11719.0, 11657.0, 11595.0, 11534.0, 11473.0, 11412.0, 11352.0, 11292.0, 11232.0, 11173.0, 11114.0, 11055.0, 10997.0, 10939.0, 10881.0, 10837.0, 10823.0, 10977.0, 10940.0, 10883.0, 10805.0, 10726.0, 10648.0, 10570.0, 10493.0, 10417.0, 10340.0, 10265.0, 10190.0, 10115.0, 10041.0, 9967.5, 9894.4, 9821.8, 9749.7, 9678.1, 9607.0, 9536.4, 9466.2, 9396.5, 9327.2, 9258.4, 9190.1, 9122.2, 9054.8, 8987.8, 8921.2, 8855.1, 8789.4, 8724.2, 8659.3, 8594.9, 8530.9, 8467.4, 8404.2, 8341.4, 8279.1, 8276.2, 8453.6, 8434.9, 8372.6, 8310.6, 8249.1, 8188.0, 8127.2, 8066.9, 8006.9, 7947.3, 7888.0, 7829.2, 7770.7, 7712.5, 7654.8, 7597.3, 7540.3, 7483.6, 7427.2, 7371.2, 7315.6, 7260.2, 7205.3, 7150.6, 7096.3, 7042.3, 6988.6, 6935.3, 6882.2, 6829.5, 6777.1, 6725.1, 6673.3, 6621.8, 6570.7, 6519.9, 6469.3, 6419.1, 6369.2, 6319.6, 6270.2, 6221.1, 6172.4, 6123.9, 6075.7, 6027.8, 5980.2, 5932.9, 5885.9, 5839.2, 5792.8, 5746.6, 5700.7, 5655.2, 5609.8, 5564.8, 5520.1, 5475.6, 5431.4, 5387.5, 5343.9, 5300.5, 5257.5, 5214.7, 5172.1, 5129.9, 5087.9, 5046.0, 5004.4, 4963.1, 4922.1, 4881.3, 4840.7, 4800.4, 4760.4, 4720.7, 4681.2, 4642.0, 4603.0, 4564.3, 4525.8, 4487.6, 4449.7, 4412.0, 4374.6, 4337.4, 4300.5, 4263.8, 4227.4, 4191.2, 4155.3, 4119.6, 4084.2, 4049.0, 4014.1, 3979.4, 3944.9, 3910.7, 3876.8, 3843.1, 3809.6, 3776.4, 3743.4, 3710.6, 3678.1, 3645.8, 3613.7, 3581.8, 3550.2, 3518.8, 3487.7, 3456.8, 3426.2, 3395.8, 3365.7, 3332.8, 3294.3, 3256.2, 3218.7, 3181.6, 3145.1, 3108.9, 3073.3, 3038.0, 3003.3, 2968.9, 2935.0, 2901.6, 2868.5, 2835.9, 2803.6, 2771.8, 2740.4, 2709.3, 2678.7, 2648.4, 2618.5, 2589.0, 2559.9, 2531.1, 2502.7, 2474.6, 2446.9, 2419.5, 2392.4, 2365.7, 2339.3, 2313.3, 2287.5, 2262.1, 2237.0, 2212.2, 2187.7, 2163.4, 2139.5, 2115.9, 2092.6, 2069.5, 2046.8, 2024.3, 2002.1, 1980.1, 1958.4, 1937.0, 1915.8, 1894.9, 1874.3, 1853.8, 1833.7, 1813.8, 1794.1, 1774.6, 1755.4, 1736.4, 1717.6, 1699.1, 1680.8, 1662.7, 1644.8, 1627.1, 1609.6, 1592.3, 1575.3, 1558.4, 1541.7, 1525.3, 1509.0, 1492.9, 1477.0, 1461.3, 1445.8, 1430.5, 1415.3, 1400.3, 1385.5, 1370.9, 1356.4, 1342.1, 1328.0, 1314.0, 1300.2, 1286.6, 1273.1, 1259.8, 1246.6, 1233.6, 1220.7, 1208.0, 1195.4, 1182.9, 1170.7, 1158.5, 1146.3, 1134.2, 1122.3, 1110.5, 1098.8, 1087.3, 1075.9, 1064.6, 1053.4, 1042.4, 1031.5, 1020.8, 1010.1, 999.62, 998.37, 3453.9, 3420.0, 3378.6, 3337.8, 3297.4, 3257.5, 3218.1, 3191.1, 4749.6, 4739.3, 4681.4, 4624.2, 4567.6, 4511.8, 4456.7, 4402.3, 4348.6, 4295.3, 4242.8, 4190.9, 4139.7, 4089.1, 4039.1, 3989.7, 3941.0, 3892.9, 3845.3, 3798.4, 3752.0, 3706.2, 3661.0, 3616.4, 3572.3, 3528.7, 3485.7, 3443.2, 3401.3, 3359.9, 3318.9, 3278.5, 3238.6, 3199.2, 3160.3, 3121.8, 3083.9, 3046.4, 3009.4, 2972.8, 2936.7, 2901.0, 3389.1, 3364.3, 3321.8, 3279.8, 3238.4, 3197.6, 3157.1, 3116.6, 3076.5, 3037.0, 2998.4, 2961.9, 2926.0, 2890.4, 2855.2, 2820.5, 2786.4, 2752.7, 2719.5, 2686.8, 2654.6, 2622.8, 2591.5, 2560.6, 2541.7, 2709.0, 2705.8, 2675.7, 2642.8, 2610.3, 2578.3, 2546.8, 2515.6, 2484.9, 2454.6, 2424.6, 2395.7, 2367.8, 2340.3, 2313.2, 2286.6, 2260.3, 2234.3, 2208.8, 2183.5, 2183.1, 2261.9, 2256.7, 2231.3, 2206.3, 2181.6, 2157.2, 2133.0, 2109.2, 2085.6, 2062.3, 2039.3, 2016.6, 1994.0, 1971.7, 1949.6, 1927.8, 1906.3, 1885.0, 1863.9, 1843.1, 1822.5, 1802.0, 1780.2, 1758.6, 1737.3, 1716.2, 1695.4, 1674.9, 1654.6, 1634.5, 1614.7, 1595.1, 1575.8, 1556.7, 1537.8, 1519.1, 1500.6, 1482.3, 1464.3, 1446.4, 1428.8, 1411.5, 1394.3, 1377.4, 1360.6, 1344.1, 1327.8, 1311.7, 1295.8, 1280.1, 1264.6, 1248.8, 1233.2, 1217.8, 1202.5, 1187.5, 1172.7, 1157.9, 1143.2, 1128.6, 1114.2, 1100.1, 1086.1, 1072.3, 1058.7, 1045.3, 1032.0, 1019.0, 1006.1, 993.38, 980.85, 968.48, 956.28, 944.25, 932.38, 920.66, 909.11, 897.71, 886.46, 849.79, 719.01, 606.46, 511.7, 431.28, 363.78, 307.16, 259.73, 219.93, 186.49, 157.83, 133.46, 112.61, 93.837, 93.045, 89.217, 88.234, 242.33, 230.87, 213.71, 181.31, 175.84, 173.69, 171.75, 235.99, 226.64, 221.89, 212.97, 210.69, 240.41, 237.68, 231.62, 201.03, 169.4, 142.47, 119.55, 100.22, 84.024, 70.48, 59.135, 49.583, 41.583, 34.833, 29.192, 24.285, 20.166, 16.759, 13.94, 11.604, 9.6663, 8.0587, 6.7128, 5.5913, 4.6506, 3.8557, 3.1983, 2.6533, 2.2755, 2.2028, 2.1813, 2.1571, 11.082, 10.678, 9.6904, 8.1411, 6.8291, 5.7232, 4.7823, 3.9959, 3.3392, 2.7909, 2.3328, 1.9502, 1.6277, 1.356, 1.1298, 0.94142, 0.78453, 0.65384, 0.54497, 0.45427, 0.37869, 0.31572, 0.26323, 0.21949, 0.18424, 0.15479, 0.13005, 0.10928, 0.091825, 0.077167, 0.0],
                    'energies (keV)': [0.0057285, 0.005814, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.0245, 0.024875, 0.024975, 0.025125, 0.02545001, 0.0255, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.035672, 0.036218, 0.0363636, 0.036582, 0.037128, 0.03797993, 0.04060054, 0.04340198, 0.044002, 0.0446755, 0.0448551, 0.0451245, 0.045798, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.069678, 0.0707445, 0.0710289, 0.0714555, 0.072522, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.22912551, 0.2294745, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24111348, 0.24148653, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.4039782, 0.40410785, 0.40502181, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46412139, 0.46467255, 0.46547861, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56457826, 0.56642179, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7347877, 1.7354123, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7926172, 1.7937828, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.1963695, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4657375, 2.4704593, 2.4716624, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7027735, 2.7132264, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 9.683478, 9.831694, 9.871219, 9.930505, 10.07872, 10.32004, 10.91338, 11.03212, 11.08042, 11.12496, 11.19178, 11.35882, 11.44787, 11.62309, 11.66982, 11.73991, 11.79334, 11.91513, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.06807, 66.84318, 67.07932, 67.34898, 67.75348, 68.76473, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Yb': {'mass_absorption_coefficient (cm2/g)': [6144.2, 6073.0, 5466.0, 5601.3, 5772.6, 5979.0, 6220.6, 6497.8, 6811.6, 7163.0, 7553.3, 7983.9, 8456.2, 8971.6, 9211.5, 9339.4, 9373.6, 319480.0, 302630.0, 299260.0, 226030.0, 169290.0, 127030.0, 96207.0, 74097.0, 58430.0, 47437.0, 39792.0, 34532.0, 30963.0, 28594.0, 27075.0, 26821.0, 26759.0, 26845.0, 26642.0, 26335.0, 25846.0, 25653.0, 25665.0, 25811.0, 26039.0, 26309.0, 26593.0, 26866.0, 26997.0, 27015.0, 27034.0, 27052.0, 27070.0, 27087.0, 27105.0, 27122.0, 27139.0, 27156.0, 27172.0, 27189.0, 27205.0, 27221.0, 27236.0, 27252.0, 27267.0, 27282.0, 27296.0, 27310.0, 27325.0, 27338.0, 27352.0, 27365.0, 27378.0, 27391.0, 27403.0, 27415.0, 27427.0, 27438.0, 27450.0, 27461.0, 27471.0, 27481.0, 27465.0, 27387.0, 27308.0, 27229.0, 27149.0, 27069.0, 26988.0, 26907.0, 26825.0, 26743.0, 26660.0, 26577.0, 26493.0, 26409.0, 26325.0, 26240.0, 26154.0, 26068.0, 25982.0, 25895.0, 25808.0, 25721.0, 25633.0, 25544.0, 25456.0, 25366.0, 25277.0, 25187.0, 25097.0, 25006.0, 24915.0, 24823.0, 24732.0, 24639.0, 24547.0, 24454.0, 24361.0, 24268.0, 24174.0, 24080.0, 23985.0, 23891.0, 23796.0, 23700.0, 23605.0, 23509.0, 23413.0, 23316.0, 23220.0, 23123.0, 23026.0, 22928.0, 22831.0, 22733.0, 22635.0, 22537.0, 22438.0, 22339.0, 22241.0, 22142.0, 22042.0, 21943.0, 21843.0, 21744.0, 21644.0, 21544.0, 21444.0, 21343.0, 21243.0, 21142.0, 21042.0, 20941.0, 20840.0, 20739.0, 20638.0, 20537.0, 20436.0, 20334.0, 20233.0, 20132.0, 20030.0, 19929.0, 19827.0, 19725.0, 19624.0, 19522.0, 19421.0, 19319.0, 19217.0, 19116.0, 19106.0, 28782.0, 28378.0, 27749.0, 27151.0, 26580.0, 26036.0, 25517.0, 25021.0, 24548.0, 24095.0, 23663.0, 23249.0, 22852.0, 22473.0, 22154.0, 22109.0, 27716.0, 27223.0, 26593.0, 25992.0, 25418.0, 24871.0, 24349.0, 23854.0, 23385.0, 22940.0, 22517.0, 22115.0, 21732.0, 21366.0, 21017.0, 20684.0, 20365.0, 20059.0, 19766.0, 19485.0, 19215.0, 18958.0, 18713.0, 18479.0, 18255.0, 18040.0, 17833.0, 17634.0, 17442.0, 17257.0, 17078.0, 16905.0, 16737.0, 16574.0, 16415.0, 16261.0, 16111.0, 15964.0, 15821.0, 15681.0, 15545.0, 15411.0, 15280.0, 15152.0, 15026.0, 14902.0, 14781.0, 14661.0, 14544.0, 14429.0, 14315.0, 14203.0, 14093.0, 13984.0, 13877.0, 13771.0, 13667.0, 13564.0, 13462.0, 13362.0, 13263.0, 13165.0, 13068.0, 12972.0, 12878.0, 12784.0, 12691.0, 12600.0, 12509.0, 12420.0, 12331.0, 12243.0, 12156.0, 12070.0, 11985.0, 11901.0, 11817.0, 11734.0, 11652.0, 11571.0, 11491.0, 11411.0, 11333.0, 11255.0, 11177.0, 11101.0, 11025.0, 10950.0, 10875.0, 10801.0, 10728.0, 10656.0, 10584.0, 10513.0, 10443.0, 10373.0, 10304.0, 10235.0, 10167.0, 10100.0, 10033.0, 9967.5, 9902.1, 9837.4, 9773.2, 9709.6, 9646.7, 9584.3, 9522.5, 9461.3, 9400.6, 9389.9, 10222.0, 10202.0, 10141.0, 10081.0, 10021.0, 9961.7, 9903.0, 9844.9, 9787.3, 9730.3, 9673.8, 9617.8, 9562.3, 9507.3, 9452.8, 9398.8, 9345.3, 9292.3, 9239.8, 9187.7, 9136.1, 9085.0, 9034.3, 8984.0, 8934.2, 8884.8, 8835.8, 8787.2, 8739.0, 8691.2, 8690.5, 8864.8, 8844.2, 8797.3, 8750.7, 8704.5, 8658.6, 8613.2, 8568.0, 8523.3, 8478.8, 8434.8, 8391.0, 8347.6, 8304.4, 8261.6, 8219.2, 8177.0, 8135.1, 8093.5, 8052.1, 8011.1, 7970.3, 7929.8, 7889.5, 7849.5, 7809.8, 7770.3, 7731.0, 7692.0, 7653.1, 7614.5, 7576.1, 7537.9, 7499.9, 7462.1, 7424.5, 7387.0, 7349.8, 7312.7, 7275.8, 7239.0, 7202.4, 7195.5, 7429.6, 7421.9, 7384.9, 7348.1, 7311.3, 7274.7, 7238.3, 7202.0, 7165.7, 7129.7, 7093.7, 7057.8, 7022.1, 6986.4, 6950.8, 6915.4, 6880.0, 6844.7, 6809.6, 6774.5, 6739.4, 6704.5, 6669.6, 6634.8, 6600.0, 6565.3, 6530.6, 6496.0, 6461.5, 6427.0, 6392.5, 6358.1, 6323.7, 6289.4, 6255.1, 6220.9, 6186.7, 6152.6, 6118.5, 6084.4, 6050.4, 6016.4, 5982.4, 5948.5, 5914.7, 5880.8, 5847.0, 5813.3, 5779.6, 5745.9, 5712.3, 5678.7, 5645.1, 5611.6, 5578.1, 5544.7, 5511.3, 5478.0, 5444.7, 5411.4, 5378.2, 5345.1, 5312.0, 5278.9, 5245.9, 5213.0, 5180.1, 5147.3, 5114.5, 5081.8, 5049.1, 5016.5, 4984.0, 4951.5, 4919.1, 4886.8, 4854.5, 4822.3, 4790.2, 4758.2, 4726.2, 4694.3, 4662.5, 4630.7, 4599.1, 4567.5, 4536.0, 4504.6, 4473.2, 4441.9, 4410.7, 4379.6, 4348.5, 4317.6, 4286.7, 4256.0, 4225.3, 4194.7, 4164.2, 4133.9, 4103.6, 4073.4, 4043.3, 4013.3, 3983.5, 3953.7, 3924.0, 3894.4, 3864.9, 3835.5, 3806.3, 3777.2, 3748.2, 3719.3, 3690.6, 3662.0, 3633.5, 3605.2, 3577.1, 3549.1, 3521.2, 3493.5, 3466.0, 3438.6, 3411.3, 3384.2, 3357.3, 3330.5, 3303.9, 3277.5, 3251.2, 3225.1, 3199.2, 3173.4, 3147.8, 3122.4, 3097.1, 3072.1, 3047.1, 3022.4, 2997.8, 2973.4, 2949.2, 2925.2, 2901.3, 2874.6, 2842.1, 2810.0, 2778.3, 2747.0, 2716.0, 2685.5, 2655.3, 2625.5, 2596.1, 2567.0, 2538.3, 2509.9, 2481.8, 2454.2, 2426.8, 2399.8, 2373.1, 2346.7, 2320.7, 2295.0, 2269.5, 2244.4, 2219.6, 2195.1, 2170.9, 2147.0, 2123.3, 2100.0, 2076.9, 2054.1, 2031.6, 2009.3, 1987.3, 1965.6, 1944.1, 1922.9, 1902.0, 1881.3, 1860.8, 1840.6, 1820.6, 1800.8, 1781.3, 1762.1, 1743.0, 1724.2, 1705.6, 1687.2, 1669.0, 1651.1, 1633.3, 1615.8, 1598.4, 1581.3, 1564.4, 1547.7, 1531.1, 1514.8, 1498.6, 1482.7, 1466.9, 1451.3, 1435.9, 1420.5, 1405.1, 1389.9, 1374.9, 1360.1, 1345.4, 1331.0, 1316.7, 1302.5, 1288.5, 1274.7, 1261.1, 1247.6, 1234.2, 1221.1, 1208.0, 1195.2, 1182.4, 1169.8, 1157.4, 1145.1, 1137.6, 4235.7, 4218.4, 4165.2, 4112.7, 4060.9, 4009.8, 3959.3, 3917.0, 5875.7, 5873.7, 5799.0, 5725.1, 5652.2, 5580.2, 5509.2, 5439.1, 5369.9, 5301.6, 5234.2, 5167.6, 5101.9, 5037.1, 4973.1, 4909.9, 4847.5, 4786.0, 4725.2, 4665.2, 4606.0, 4547.6, 4489.9, 4432.9, 4376.7, 4321.3, 4266.5, 4212.4, 4159.1, 4106.4, 4054.4, 4003.1, 3952.4, 3902.4, 3853.0, 3804.3, 3756.2, 3708.7, 3661.9, 3615.6, 3569.9, 3524.8, 3480.3, 3436.4, 3422.7, 4001.2, 3989.3, 3935.8, 3883.1, 3831.0, 3779.6, 3728.9, 3678.8, 3629.4, 3580.8, 3532.7, 3487.8, 3444.0, 3401.0, 3358.7, 3317.1, 3276.2, 3235.9, 3196.3, 3157.3, 3118.9, 3081.0, 3043.8, 3042.3, 3239.6, 3219.8, 3179.7, 3140.1, 3101.1, 3062.8, 3024.9, 2987.6, 2950.9, 2914.7, 2879.1, 2845.3, 2812.0, 2779.2, 2746.9, 2715.1, 2683.8, 2653.0, 2622.6, 2592.6, 2574.1, 2563.0, 2668.7, 2652.3, 2622.4, 2592.9, 2563.8, 2535.0, 2506.6, 2478.6, 2450.9, 2423.6, 2396.6, 2370.1, 2343.4, 2317.0, 2290.9, 2265.2, 2239.7, 2214.5, 2189.7, 2165.1, 2140.8, 2116.7, 2093.0, 2069.5, 2046.3, 2023.3, 2000.6, 1978.1, 1955.9, 1933.9, 1912.2, 1890.7, 1869.4, 1848.4, 1827.4, 1806.7, 1786.2, 1765.9, 1745.8, 1726.0, 1706.4, 1687.0, 1667.8, 1648.9, 1630.1, 1611.5, 1591.9, 1572.5, 1553.4, 1534.3, 1515.0, 1496.1, 1477.4, 1458.9, 1440.6, 1422.5, 1404.4, 1386.5, 1368.8, 1351.4, 1334.2, 1317.3, 1300.5, 1284.0, 1267.8, 1251.7, 1235.9, 1220.3, 1204.8, 1189.6, 1174.6, 1159.8, 1145.2, 1130.8, 1116.6, 1102.5, 1088.6, 1074.9, 1061.4, 1048.0, 1034.8, 1021.8, 1009.0, 996.3, 983.81, 971.49, 959.33, 947.34, 935.51, 923.78, 912.22, 900.8, 889.54, 878.43, 867.47, 856.66, 845.99, 835.46, 824.94, 814.42, 804.04, 793.81, 783.71, 750.78, 633.46, 533.81, 450.17, 379.91, 321.04, 271.66, 230.17, 194.55, 164.2, 138.76, 117.47, 107.0, 102.97, 101.82, 282.2, 277.91, 268.95, 225.67, 217.44, 208.21, 205.86, 284.24, 272.08, 264.46, 261.22, 252.98, 250.05, 285.11, 274.34, 253.45, 213.88, 180.15, 151.46, 127.0, 106.42, 89.17, 74.747, 62.595, 52.432, 43.875, 36.699, 30.723, 25.742, 21.413, 17.78, 14.776, 12.289, 10.228, 8.5168, 7.083, 5.889, 4.8798, 4.0421, 3.3479, 2.775, 2.5712, 2.4641, 2.4366, 12.89, 12.43, 12.414, 10.469, 8.7868, 7.3706, 6.175, 5.1554, 4.3047, 3.5949, 3.0026, 2.5081, 2.0954, 1.7439, 1.4509, 1.2072, 1.0046, 0.83605, 0.69584, 0.5792, 0.48215, 0.40139, 0.33419, 0.27826, 0.23216, 0.19457, 0.16308, 0.13669, 0.11458, 0.096057, 0.080531, 0.067518, 0.0],
                    'energies (keV)': [0.0063315, 0.006426, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.022932, 0.023283, 0.0233766, 0.023517, 0.0238073, 0.023868, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.0538295, 0.0540459, 0.0543705, 0.055182, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18476613, 0.18503387, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19791478, 0.19803888, 0.19828522, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34308435, 0.34391562, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39615652, 0.39724347, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41638364, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48646432, 0.48793566, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5275616, 1.5280383, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5758114, 1.5767887, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6742677, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8406875, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9475382, 1.9520618, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0439363, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.170436, 2.1755642, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3931119, 2.3976254, 2.4030879, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 8.764728, 8.898882, 8.934656, 8.988318, 9.030794, 9.122472, 9.653919, 9.778636, 9.928309, 9.968222, 10.02809, 10.17776, 10.27667, 10.32004, 10.43397, 10.47591, 10.53883, 10.69613, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 60.10565, 61.02564, 61.27097, 61.63896, 62.5287, 62.55894, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Dy': {'mass_absorption_coefficient (cm2/g)': [5196.6, 5185.5, 6417.8, 6690.1, 6993.9, 7331.1, 7703.5, 8113.0, 8561.3, 9050.0, 9578.4, 10146.0, 10753.0, 11398.0, 12079.0, 12796.0, 12936.0, 13105.0, 13150.0, 213830.0, 201470.0, 190470.0, 146720.0, 113230.0, 87701.0, 68914.0, 55446.0, 45988.0, 39462.0, 35034.0, 32089.0, 30178.0, 28983.0, 28278.0, 28155.0, 28063.0, 28041.0, 28117.0, 28053.0, 28018.0, 27886.0, 27895.0, 27927.0, 26850.0, 25747.0, 24610.0, 24017.0, 23930.0, 23842.0, 23753.0, 23665.0, 23576.0, 23488.0, 23399.0, 23309.0, 23220.0, 23131.0, 23041.0, 22951.0, 22861.0, 22771.0, 22680.0, 22590.0, 22499.0, 22408.0, 22317.0, 22226.0, 22135.0, 22043.0, 21952.0, 21860.0, 21768.0, 21676.0, 21584.0, 21492.0, 21400.0, 21307.0, 21215.0, 21122.0, 21029.0, 20936.0, 20843.0, 20750.0, 20657.0, 20564.0, 20471.0, 20377.0, 20284.0, 20190.0, 20097.0, 20003.0, 19909.0, 19816.0, 19722.0, 19628.0, 19534.0, 19440.0, 19346.0, 19252.0, 19158.0, 19064.0, 18970.0, 18876.0, 18782.0, 18688.0, 18594.0, 18500.0, 18406.0, 18312.0, 18218.0, 18124.0, 18030.0, 17936.0, 17842.0, 17748.0, 17654.0, 17561.0, 17467.0, 17374.0, 17280.0, 17187.0, 17093.0, 17000.0, 16907.0, 16814.0, 16721.0, 16628.0, 16535.0, 16442.0, 16350.0, 16257.0, 16165.0, 16072.0, 16003.0, 41462.0, 41305.0, 39675.0, 38138.0, 36690.0, 35323.0, 34035.0, 32819.0, 31672.0, 30589.0, 29566.0, 28601.0, 27688.0, 26826.0, 26011.0, 25240.0, 24510.0, 23820.0, 23166.0, 22547.0, 21960.0, 21408.0, 20895.0, 20416.0, 19970.0, 19552.0, 19160.0, 18792.0, 18445.0, 18118.0, 17809.0, 17517.0, 17240.0, 16976.0, 16726.0, 16487.0, 16258.0, 16040.0, 15831.0, 15630.0, 15437.0, 15252.0, 15073.0, 14901.0, 14734.0, 14573.0, 14417.0, 14266.0, 14119.0, 13976.0, 13838.0, 13703.0, 13571.0, 13443.0, 13318.0, 13196.0, 13076.0, 12960.0, 12845.0, 12733.0, 12623.0, 12516.0, 12410.0, 12307.0, 12205.0, 12105.0, 12007.0, 11910.0, 11815.0, 11721.0, 11629.0, 11538.0, 11449.0, 11361.0, 11274.0, 11189.0, 11104.0, 11021.0, 10939.0, 10858.0, 10778.0, 10699.0, 10621.0, 10544.0, 10468.0, 10393.0, 10319.0, 10246.0, 10174.0, 10102.0, 10032.0, 9962.0, 9893.1, 9825.0, 9757.6, 9691.1, 9625.3, 9560.3, 9496.0, 9432.5, 9369.6, 9307.6, 9246.2, 9185.5, 9125.5, 9066.2, 9007.5, 8949.6, 8892.2, 8835.6, 8779.6, 8724.2, 8669.5, 8615.3, 8561.8, 8508.9, 8456.7, 8405.0, 8353.9, 8303.4, 8253.5, 8204.2, 8155.4, 8107.2, 8059.6, 8012.5, 7966.0, 7920.0, 7874.5, 7829.6, 7817.0, 8811.5, 8795.8, 8750.6, 8705.9, 8661.7, 8618.0, 8574.8, 8532.2, 8490.0, 8448.2, 8407.0, 8366.2, 8325.9, 8286.1, 8246.7, 8207.8, 8169.3, 8131.2, 8093.5, 8056.3, 8019.5, 7983.1, 7947.0, 7911.4, 7876.1, 7841.1, 7832.1, 8077.1, 8066.2, 8032.0, 7998.1, 7964.5, 7931.3, 7898.3, 7865.7, 7833.4, 7801.4, 7769.7, 7738.2, 7707.1, 7676.2, 7645.5, 7615.2, 7585.0, 7555.2, 7525.5, 7496.1, 7466.9, 7437.9, 7409.1, 7380.5, 7352.1, 7323.9, 7295.9, 7268.0, 7240.3, 7212.8, 7185.4, 7158.2, 7131.1, 7104.1, 7077.3, 7050.5, 7023.9, 6997.4, 6971.0, 6944.7, 6918.5, 6892.3, 6866.3, 6840.3, 6814.4, 6788.5, 6770.8, 7087.7, 7081.4, 7061.0, 7034.4, 7007.8, 6981.3, 6954.8, 6928.3, 6901.9, 6875.4, 6849.0, 6822.6, 6796.2, 6769.8, 6743.4, 6717.0, 6690.6, 6664.2, 6637.7, 6611.3, 6584.8, 6558.3, 6531.8, 6505.2, 6478.5, 6451.8, 6425.1, 6398.3, 6371.5, 6344.6, 6317.6, 6290.6, 6263.5, 6236.4, 6209.2, 6181.9, 6154.6, 6127.1, 6099.6, 6072.1, 6044.4, 6016.7, 5989.0, 5961.2, 5933.3, 5905.4, 5877.4, 5849.3, 5821.2, 5793.0, 5764.7, 5736.4, 5708.1, 5679.6, 5651.2, 5622.6, 5594.1, 5565.4, 5536.8, 5508.0, 5479.3, 5450.4, 5421.6, 5392.7, 5363.8, 5334.8, 5305.8, 5276.7, 5247.7, 5218.6, 5189.4, 5160.3, 5131.1, 5101.9, 5072.7, 5043.5, 5014.3, 4985.0, 4955.8, 4926.5, 4897.3, 4868.0, 4838.7, 4809.3, 4779.9, 4750.5, 4721.1, 4691.7, 4662.2, 4632.8, 4603.3, 4573.9, 4544.5, 4515.1, 4485.7, 4456.3, 4426.9, 4397.6, 4368.3, 4339.1, 4309.9, 4280.7, 4251.6, 4222.5, 4193.5, 4164.6, 4135.7, 4106.8, 4077.9, 4049.0, 4020.3, 3991.6, 3963.0, 3934.5, 3906.1, 3877.8, 3849.6, 3821.5, 3793.4, 3765.5, 3737.7, 3710.0, 3682.4, 3654.9, 3627.5, 3600.2, 3573.1, 3546.1, 3519.2, 3492.4, 3465.7, 3439.2, 3412.8, 3386.6, 3360.4, 3334.4, 3308.6, 3282.8, 3257.3, 3231.8, 3206.5, 3181.4, 3156.3, 3131.5, 3106.7, 3082.1, 3057.7, 3033.4, 3009.3, 2985.3, 2961.4, 2937.7, 2914.2, 2890.8, 2867.5, 2844.4, 2821.5, 2798.7, 2776.1, 2753.6, 2731.3, 2709.1, 2687.1, 2665.2, 2643.5, 2621.9, 2600.5, 2579.2, 2558.1, 2537.2, 2516.4, 2495.7, 2475.2, 2454.8, 2434.7, 2414.6, 2394.7, 2373.0, 2347.6, 2322.5, 2297.6, 2273.1, 2248.8, 2224.8, 2201.1, 2177.6, 2154.4, 2131.5, 2108.8, 2086.4, 2064.2, 2042.3, 2020.6, 1999.2, 1978.0, 1957.0, 1936.3, 1915.8, 1895.6, 1875.5, 1855.7, 1836.2, 1816.8, 1797.7, 1778.7, 1760.0, 1741.5, 1723.2, 1705.2, 1687.0, 1668.9, 1651.0, 1633.3, 1615.9, 1598.6, 1581.5, 1564.6, 1547.9, 1531.3, 1515.0, 1498.9, 1482.9, 1467.1, 1451.5, 1436.1, 1420.8, 1405.8, 1390.9, 1376.1, 1369.4, 5296.5, 5263.6, 5197.3, 5131.7, 5067.0, 5003.2, 4940.1, 4929.0, 7421.9, 7352.4, 7258.7, 7166.1, 7074.8, 6984.6, 6895.6, 6807.8, 6721.1, 6635.5, 6551.0, 6467.6, 6385.2, 6304.0, 6223.8, 6144.6, 6066.4, 5989.3, 5913.1, 5837.9, 5763.7, 5690.5, 5618.2, 5546.8, 5476.4, 5406.8, 5338.2, 5270.4, 5203.5, 5137.5, 5072.3, 5007.9, 4944.4, 4881.7, 4819.8, 4758.7, 4698.4, 4638.9, 4580.1, 4522.1, 4464.9, 4408.3, 4352.5, 4297.4, 4243.1, 4189.4, 4138.0, 4136.3, 4828.9, 4787.6, 4724.6, 4662.4, 4601.1, 4540.6, 4480.9, 4422.0, 4363.8, 4306.3, 4250.2, 4197.3, 4145.2, 4094.0, 4043.6, 3994.0, 3945.1, 3897.0, 3849.6, 3806.5, 3802.9, 4053.8, 4019.5, 3969.7, 3920.7, 3872.4, 3824.7, 3777.8, 3731.6, 3686.0, 3640.9, 3596.9, 3554.6, 3513.0, 3472.0, 3431.6, 3391.8, 3352.7, 3314.1, 3276.0, 3238.5, 3201.6, 3167.6, 3165.2, 3291.8, 3278.1, 3241.2, 3204.9, 3169.1, 3133.7, 3098.8, 3064.3, 3030.3, 2996.7, 2963.5, 2930.9, 2898.7, 2866.8, 2834.6, 2802.8, 2771.4, 2740.3, 2709.6, 2679.3, 2649.4, 2619.7, 2590.5, 2561.5, 2532.9, 2504.7, 2476.7, 2449.1, 2421.7, 2394.7, 2368.0, 2341.6, 2315.4, 2289.2, 2263.3, 2237.7, 2212.4, 2187.4, 2162.7, 2138.2, 2114.0, 2090.1, 2066.4, 2043.0, 2019.9, 1997.0, 1974.4, 1952.0, 1929.7, 1907.4, 1885.4, 1863.6, 1842.1, 1820.9, 1799.6, 1778.5, 1757.7, 1737.1, 1716.8, 1696.7, 1676.8, 1657.2, 1637.9, 1618.7, 1599.8, 1581.1, 1562.7, 1544.5, 1526.5, 1508.7, 1491.1, 1473.5, 1456.1, 1438.9, 1422.0, 1405.2, 1388.7, 1372.3, 1354.7, 1337.4, 1320.3, 1303.5, 1286.8, 1270.4, 1254.3, 1238.3, 1222.6, 1207.0, 1191.7, 1176.6, 1161.7, 1147.0, 1132.5, 1118.2, 1104.1, 1090.1, 1076.4, 1062.8, 1049.5, 1036.3, 1023.0, 1009.9, 996.95, 984.18, 971.58, 959.15, 946.89, 934.8, 922.87, 911.1, 899.49, 888.04, 876.74, 865.59, 854.59, 843.74, 833.04, 822.48, 812.06, 801.64, 791.35, 781.2, 771.18, 761.3, 751.55, 741.94, 732.45, 723.09, 713.85, 704.74, 695.75, 686.88, 678.13, 669.5, 660.98, 633.2, 533.56, 450.14, 380.27, 321.67, 272.22, 229.42, 193.51, 163.48, 138.18, 127.27, 122.44, 121.2, 345.49, 335.49, 329.78, 279.01, 275.57, 267.9, 265.06, 363.6, 348.11, 335.3, 321.9, 319.06, 318.5, 362.74, 349.69, 312.48, 262.57, 218.76, 182.95, 153.14, 128.28, 107.55, 90.236, 75.524, 63.174, 52.741, 44.022, 36.777, 30.751, 25.736, 21.558, 17.931, 14.887, 12.37, 10.282, 8.5352, 7.0825, 5.8529, 4.8391, 4.0021, 3.3124, 3.0483, 2.9204, 2.8875, 15.873, 15.39, 15.285, 12.956, 10.872, 9.115, 7.6382, 6.3955, 5.3477, 4.458, 3.7168, 3.0992, 2.5845, 2.1477, 1.7838, 1.4817, 1.2309, 1.0227, 0.84973, 0.70609, 0.58678, 0.48767, 0.40533, 0.33691, 0.28046, 0.23431, 0.19577, 0.16358, 0.1367, 0.11424, 0.095471, 0.079794, 0.066695, 0.055749, 0.0],
                    'energies (keV)': [0.004221, 0.004284, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.025774, 0.0261685, 0.0262737, 0.0264315, 0.026826, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.061642, 0.0625855, 0.0628371, 0.0632145, 0.064158, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1, 0.1005, 0.1010025, 0.10150751, 0.10201505, 0.10252513, 0.10303775, 0.10355294, 0.1040707, 0.10459106, 0.10511401, 0.10563958, 0.10616778, 0.10669862, 0.10723211, 0.10776827, 0.10830712, 0.10884865, 0.10939289, 0.10993986, 0.11048956, 0.11104201, 0.11159722, 0.1121552, 0.11271598, 0.11327956, 0.11384596, 0.11441519, 0.11498726, 0.1155622, 0.11614001, 0.11672071, 0.11730431, 0.11789083, 0.11848029, 0.11907269, 0.11966805, 0.12026639, 0.12086772, 0.12147206, 0.12207942, 0.12268982, 0.12330327, 0.12391979, 0.12453939, 0.12516208, 0.12578789, 0.12641683, 0.12704892, 0.12768416, 0.12832258, 0.12896419, 0.12960902, 0.13025706, 0.13090835, 0.13156289, 0.1322207, 0.13288181, 0.13354621, 0.13421395, 0.13488502, 0.13555944, 0.13623724, 0.13691842, 0.13760302, 0.13829103, 0.13898249, 0.1396774, 0.14037579, 0.14107766, 0.14178305, 0.14249197, 0.14320443, 0.14392045, 0.14464005, 0.14536325, 0.14609007, 0.14682052, 0.14755462, 0.14829239, 0.14903386, 0.14977903, 0.15052792, 0.15128056, 0.15203696, 0.15279715, 0.15356113, 0.15414295, 0.15425706, 0.15432894, 0.15510058, 0.15587609, 0.15665547, 0.15743875, 0.15822594, 0.15901707, 0.15981215, 0.16061121, 0.16141427, 0.16222134, 0.16303245, 0.16384761, 0.16466685, 0.16549018, 0.16631763, 0.16714922, 0.16798497, 0.16882489, 0.16966902, 0.17051736, 0.17136995, 0.1722268, 0.17308793, 0.17395337, 0.17482314, 0.17569726, 0.17657574, 0.17745862, 0.17834591, 0.17923764, 0.18013383, 0.1810345, 0.18193967, 0.18284937, 0.18376362, 0.18468244, 0.18560585, 0.18653388, 0.18746655, 0.18840388, 0.1893459, 0.19029263, 0.19124409, 0.19220031, 0.19316131, 0.19412712, 0.19509776, 0.19607325, 0.19705361, 0.19803888, 0.19902907, 0.20002422, 0.20102434, 0.20202946, 0.20303961, 0.20405481, 0.20507508, 0.20610046, 0.20713096, 0.20816661, 0.20920745, 0.21025348, 0.21130475, 0.21236128, 0.21342308, 0.2144902, 0.21556265, 0.21664046, 0.21772366, 0.21881228, 0.21990634, 0.22100588, 0.2221109, 0.22322146, 0.22433757, 0.22545925, 0.22658655, 0.22771948, 0.22885808, 0.23000237, 0.23115238, 0.23230814, 0.23346969, 0.23463703, 0.23581022, 0.23698927, 0.23817422, 0.23936509, 0.24056191, 0.24176472, 0.24297355, 0.24418841, 0.24540936, 0.2466364, 0.24786959, 0.24910893, 0.25035448, 0.25160625, 0.25286428, 0.2541286, 0.25539925, 0.25667624, 0.25795962, 0.25924942, 0.26054567, 0.2618484, 0.26315764, 0.26447343, 0.26579579, 0.26712477, 0.2684604, 0.2698027, 0.27115171, 0.27250747, 0.27387001, 0.27523936, 0.27661556, 0.27799863, 0.27938863, 0.28078557, 0.2821895, 0.28360044, 0.28501845, 0.28644354, 0.28787576, 0.28931514, 0.29076171, 0.29221552, 0.29262731, 0.29317269, 0.2936766, 0.29514498, 0.29662071, 0.29810381, 0.29959433, 0.3010923, 0.30259776, 0.30411075, 0.3056313, 0.30715946, 0.30869526, 0.31023873, 0.31178993, 0.31334888, 0.31491562, 0.3164902, 0.31807265, 0.31966301, 0.32126133, 0.32286764, 0.32448197, 0.32610438, 0.32773491, 0.32937358, 0.33102045, 0.33144831, 0.33215172, 0.33267555, 0.33433893, 0.33601062, 0.33769068, 0.33937913, 0.34107602, 0.3427814, 0.34449531, 0.34621779, 0.34794888, 0.34968862, 0.35143706, 0.35319425, 0.35496022, 0.35673502, 0.3585187, 0.36031129, 0.36211285, 0.36392341, 0.36574303, 0.36757174, 0.3694096, 0.37125665, 0.37311293, 0.3749785, 0.37685339, 0.37873766, 0.38063135, 0.3825345, 0.38444718, 0.38636941, 0.38830126, 0.39024276, 0.39219398, 0.39415495, 0.39612572, 0.39810635, 0.40009688, 0.40209737, 0.40410785, 0.40612839, 0.40815904, 0.41019983, 0.41225083, 0.41431208, 0.41572967, 0.41638364, 0.41687033, 0.41846556, 0.42055789, 0.42266068, 0.42477398, 0.42689785, 0.42903234, 0.4311775, 0.43333339, 0.43550006, 0.43767756, 0.43986595, 0.44206528, 0.4442756, 0.44649698, 0.44872947, 0.45097311, 0.45322798, 0.45549412, 0.45777159, 0.46006045, 0.46236075, 0.46467255, 0.46699592, 0.4693309, 0.47167755, 0.47403594, 0.47640612, 0.47878815, 0.48118209, 0.483588, 0.48600594, 0.48843597, 0.49087815, 0.49333254, 0.4957992, 0.4982782, 0.50076959, 0.50327344, 0.5057898, 0.50831875, 0.51086035, 0.51341465, 0.51598172, 0.51856163, 0.52115444, 0.52376021, 0.52637901, 0.52901091, 0.53165596, 0.53431424, 0.53698581, 0.53967074, 0.5423691, 0.54508094, 0.54780635, 0.55054538, 0.5532981, 0.5560646, 0.55884492, 0.56163914, 0.56444734, 0.56726958, 0.57010592, 0.57295645, 0.57582123, 0.57870034, 0.58159384, 0.58450181, 0.58742432, 0.59036144, 0.59331325, 0.59627982, 0.59926122, 0.60225752, 0.60526881, 0.60829515, 0.61133663, 0.61439331, 0.61746528, 0.6205526, 0.62365537, 0.62677364, 0.62990751, 0.63305705, 0.63622234, 0.63940345, 0.64260046, 0.64581347, 0.64904253, 0.65228775, 0.65554919, 0.65882693, 0.66212107, 0.66543167, 0.66875883, 0.67210262, 0.67546314, 0.67884045, 0.68223466, 0.68564583, 0.68907406, 0.69251943, 0.69598202, 0.69946194, 0.70295924, 0.70647404, 0.71000641, 0.71355644, 0.71712423, 0.72070985, 0.7243134, 0.72793496, 0.73157464, 0.73523251, 0.73890867, 0.74260322, 0.74631623, 0.75004781, 0.75379805, 0.75756704, 0.76135488, 0.76516165, 0.76898746, 0.7728324, 0.77669656, 0.78058004, 0.78448294, 0.78840536, 0.79234738, 0.79630912, 0.80029067, 0.80429212, 0.80831358, 0.81235515, 0.81641693, 0.82049901, 0.8246015, 0.82872451, 0.83286813, 0.83703248, 0.84121764, 0.84542373, 0.84965084, 0.8538991, 0.85816859, 0.86245944, 0.86677173, 0.87110559, 0.87546112, 0.87983843, 0.88423762, 0.88865881, 0.8931021, 0.89756761, 0.90205545, 0.90656573, 0.91109856, 0.91565405, 0.92023232, 0.92483348, 0.92945765, 0.93410494, 0.93877546, 0.94346934, 0.94818668, 0.95292762, 0.95769226, 0.96248072, 0.96729312, 0.97212959, 0.97699023, 0.98187519, 0.98678456, 0.99171848, 0.99667708, 1.0016605, 1.0066688, 1.0117021, 1.0167606, 1.0218444, 1.0269536, 1.0320884, 1.0372489, 1.0424351, 1.0476473, 1.0528855, 1.0581499, 1.0634407, 1.0687579, 1.0741017, 1.0794722, 1.0848695, 1.0902939, 1.0957454, 1.1012241, 1.1067302, 1.1122639, 1.1178252, 1.1234143, 1.1290314, 1.1346765, 1.1403499, 1.1460517, 1.1517819, 1.1575408, 1.1633285, 1.1691452, 1.1749909, 1.1808659, 1.1867702, 1.192704, 1.1986676, 1.2046609, 1.2106842, 1.2167376, 1.2228213, 1.2289354, 1.2350801, 1.2412555, 1.2474618, 1.2536991, 1.2599676, 1.2662674, 1.2725988, 1.2789618, 1.2853566, 1.2917833, 1.294729, 1.2950709, 1.2982423, 1.3047335, 1.3112571, 1.3178134, 1.3244025, 1.3310245, 1.3321988, 1.3328011, 1.3376796, 1.344368, 1.3510899, 1.3578453, 1.3646345, 1.3714577, 1.378315, 1.3852066, 1.3921326, 1.3990933, 1.4060887, 1.4131192, 1.4201848, 1.4272857, 1.4344221, 1.4415942, 1.4488022, 1.4560462, 1.4633265, 1.4706431, 1.4779963, 1.4853863, 1.4928132, 1.5002773, 1.5077787, 1.5153176, 1.5228942, 1.5305086, 1.5381612, 1.545852, 1.5535812, 1.5613491, 1.5691559, 1.5770017, 1.5848867, 1.5928111, 1.6007752, 1.608779, 1.6168229, 1.624907, 1.6330316, 1.6411967, 1.6494027, 1.6576497, 1.665938, 1.6740015, 1.6742677, 1.6771986, 1.682639, 1.6910522, 1.6995075, 1.708005, 1.716545, 1.7251278, 1.7337534, 1.7424222, 1.7511343, 1.7598899, 1.7686894, 1.7775328, 1.7864205, 1.7953526, 1.8043294, 1.813351, 1.8224178, 1.8315299, 1.8399858, 1.8406875, 1.8436141, 1.8498909, 1.8591404, 1.8684361, 1.8777783, 1.8871672, 1.896603, 1.906086, 1.9156165, 1.9251945, 1.9348205, 1.9444946, 1.9542171, 1.9639882, 1.9738081, 1.9836772, 1.9935955, 2.0035635, 2.0135813, 2.0236492, 2.0337675, 2.0432385, 2.0439363, 2.0503613, 2.054156, 2.0644268, 2.0747489, 2.0851227, 2.0955483, 2.106026, 2.1165562, 2.1271389, 2.1377746, 2.1484635, 2.1592058, 2.1700018, 2.1808519, 2.1917561, 2.2027149, 2.2137285, 2.2247971, 2.2359211, 2.2471007, 2.2583362, 2.2696279, 2.280976, 2.2923809, 2.3038428, 2.315362, 2.3269388, 2.3385735, 2.3502664, 2.3620177, 2.3738278, 2.385697, 2.3976254, 2.4096136, 2.4216616, 2.4337699, 2.4459388, 2.4581685, 2.4704593, 2.4828116, 2.4952257, 2.5077018, 2.5202403, 2.5328415, 2.5455057, 2.5582333, 2.5710244, 2.5838796, 2.596799, 2.6097829, 2.6228319, 2.635946, 2.6491257, 2.6623714, 2.6756832, 2.6890617, 2.702507, 2.7160195, 2.7295996, 2.7432476, 2.7569638, 2.7707486, 2.7846024, 2.7985254, 2.812518, 2.8265806, 2.8407135, 2.8549171, 2.8691917, 2.8835376, 2.8979553, 2.9124451, 2.9270073, 2.9416424, 2.9563506, 2.9711323, 2.985988, 3.0009179, 3.0159225, 3.0310021, 3.0461571, 3.0613879, 3.0766949, 3.0920783, 3.1075387, 3.1230764, 3.1386918, 3.1543853, 3.1701572, 3.186008, 3.201938, 3.2179477, 3.2340374, 3.2502076, 3.2664587, 3.282791, 3.2992049, 3.3157009, 3.3322794, 3.3489408, 3.3656856, 3.382514, 3.3994265, 3.4164237, 3.4335058, 3.4506733, 3.4679267, 3.4852663, 3.5026927, 3.5202061, 3.5378072, 3.5554962, 3.5732737, 3.59114, 3.6090957, 3.6271412, 3.6452769, 3.6635033, 3.6818208, 3.7002299, 3.7187311, 3.7373247, 3.7560114, 3.7747914, 3.7936654, 3.8126337, 3.8316969, 3.8508554, 3.8701096, 3.8894602, 3.9089075, 3.928452, 3.9480943, 3.9678347, 3.9876739, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.634298, 7.75115, 7.78231, 7.829051, 7.902609, 7.945902, 8.408988, 8.44789, 8.537697, 8.572019, 8.623503, 8.752212, 8.864884, 9.000571, 9.030794, 9.036754, 9.091029, 9.226716, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 52.71273, 53.51956, 53.73471, 54.05744, 54.71721, 54.86427, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'I': {'mass_absorption_coefficient (cm2/g)': [4174.4, 5362.5, 11846.0, 34289.0, 70404.0, 106260.0, 126140.0, 124730.0, 107770.0, 84689.0, 62528.0, 44535.0, 31247.0, 21949.0, 15625.0, 14294.0, 13287.0, 13036.0, 15503.0, 14611.0, 14130.0, 11072.0, 8972.6, 7526.4, 6516.6, 5801.8, 5504.5, 5393.9, 5366.0, 6003.7, 5967.0, 5907.8, 5593.0, 5315.5, 5098.2, 4920.1, 4766.3, 4626.0, 4490.7, 4354.0, 4211.1, 4058.3, 3893.5, 3715.9, 3525.8, 3324.7, 3114.9, 2898.8, 2680.3, 2563.3, 2513.9, 2501.5, 2500.9, 15194.0, 14950.0, 14809.0, 14642.0, 22843.0, 22563.0, 21605.0, 19301.0, 15964.0, 13439.0, 11438.0, 10237.0, 9880.9, 9782.1, 11017.0, 10669.0, 10173.0, 9844.0, 9758.9, 10193.0, 10173.0, 9858.5, 8846.5, 7924.9, 7641.0, 7585.2, 7829.8, 7566.9, 6856.4, 5881.4, 5046.0, 4331.0, 3714.9, 3176.6, 2712.6, 2317.0, 1980.1, 1693.3, 1448.6, 1239.1, 1058.0, 899.45, 765.9, 646.62, 541.83, 454.43, 379.79, 317.22, 265.39, 245.19, 235.52, 233.03, 772.32, 743.58, 736.21, 684.04, 653.24, 645.7, 888.21, 847.42, 784.94, 752.39, 744.14, 847.83, 814.85, 689.97, 585.14, 493.85, 415.52, 349.17, 293.42, 246.73, 207.3, 172.7, 143.66, 119.28, 99.085, 82.363, 68.524, 57.062, 47.56, 39.676, 33.102, 27.632, 23.067, 19.222, 15.995, 13.274, 11.026, 9.0797, 7.4598, 6.134, 5.9045, 5.6482, 5.5824, 34.603, 33.275, 32.095, 26.9, 22.54, 18.883, 15.787, 13.175, 10.991, 9.1664, 7.6433, 6.3726, 5.3109, 4.4114, 3.6646, 3.0398, 2.5128, 2.0774, 1.7175, 1.4202, 1.1744, 0.97118, 0.80321, 0.66434, 0.54961, 0.4548, 0.37637, 0.31148, 0.2578, 0.21338, 0.17663, 0.14621, 0.12104, 0.10021, 0.082965, 0.068693, 0.056879, 0.047099, 0.039003, 0.032299, 0.02675, 0.0],
                   'energies (keV)': [0.049848, 0.050592, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.120246, 0.1220865, 0.1225773, 0.1233135, 0.125154, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.182672, 0.185468, 0.1862136, 0.187332, 0.1883732, 0.190128, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.607012, 0.616303, 0.618674, 0.6187806, 0.622497, 0.6260625, 0.6281435, 0.6306687, 0.631788, 0.6344565, 0.643926, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.857108, 0.870227, 0.8739896, 0.878973, 0.892092, 0.91189, 0.9258475, 0.9295695, 0.9342948, 0.9351525, 0.94911, 0.9987612, 1.050658, 1.067676, 1.071028, 1.077461, 1.093542, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.465958, 4.534314, 4.552543, 4.579885, 4.633924, 4.648242, 4.755058, 4.827839, 4.847248, 4.87636, 4.953664, 5.084338, 5.162159, 5.182912, 5.21404, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 32.50601, 33.00355, 33.13623, 33.33525, 33.83279, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'U': {'mass_absorption_coefficient (cm2/g)': [43925.0, 41045.0, 39435.0, 29057.0, 21398.0, 15774.0, 14353.0, 13401.0, 13161.0, 32671.0, 30575.0, 29776.0, 22128.0, 16612.0, 12684.0, 9820.9, 7691.3, 6080.4, 4844.2, 4833.3, 4594.0, 4533.1, 5139.6, 4877.5, 4452.1, 3540.3, 2844.2, 2308.0, 2028.0, 1938.5, 1915.7, 19377.0, 19300.0, 18422.0, 15922.0, 15716.0, 15182.0, 14993.0, 24864.0, 23825.0, 21701.0, 17431.0, 13494.0, 10162.0, 7564.9, 5639.3, 4251.6, 3264.1, 2563.1, 2436.6, 2316.9, 2286.8, 3201.2, 3074.8, 2979.5, 2522.5, 2177.6, 1916.1, 1811.7, 1767.0, 1755.6, 2175.3, 2134.9, 2110.0, 1876.6, 1676.1, 1547.9, 1521.6, 1516.3, 1508.3, 1614.3, 1585.2, 1514.3, 1411.8, 1389.0, 1369.0, 1363.9, 1479.0, 1480.2, 1492.9, 1495.6, 1501.2, 1600.2, 1606.8, 1663.6, 2032.3, 3145.3, 4893.0, 6908.5, 8681.4, 9836.3, 10262.0, 10059.0, 9425.1, 9300.3, 9110.0, 9058.2, 9862.1, 9664.5, 9441.1, 9228.6, 9171.9, 9595.9, 9386.1, 9006.1, 8067.7, 7177.0, 6363.8, 6069.6, 5895.8, 5850.6, 6143.4, 5983.8, 5965.1, 5283.3, 4660.9, 4471.3, 4338.7, 4304.3, 4317.1, 4191.3, 4151.4, 3622.4, 3530.0, 3422.1, 3394.1, 3417.5, 3316.9, 3224.0, 2799.3, 2417.7, 2091.8, 1811.6, 1570.9, 1362.4, 1183.8, 1030.7, 898.57, 784.88, 673.78, 568.62, 504.62, 485.81, 480.87, 1034.7, 1048.9, 1057.9, 1076.3, 1081.6, 1485.8, 1473.1, 1470.3, 1321.2, 1187.8, 1134.8, 1120.9, 1281.3, 1272.8, 1226.7, 1041.5, 862.65, 806.29, 774.13, 765.9, 803.66, 773.79, 770.22, 720.65, 693.92, 687.04, 707.14, 681.68, 581.12, 496.29, 423.79, 360.45, 305.56, 259.4, 219.58, 183.77, 154.11, 129.18, 108.34, 90.992, 76.545, 64.461, 54.329, 45.715, 43.232, 41.572, 41.145, 100.09, 96.295, 95.016, 79.607, 66.409, 62.806, 60.262, 59.608, 83.498, 80.775, 80.34, 79.051, 77.647, 76.841, 87.479, 84.333, 77.249, 65.211, 55.04, 46.237, 38.734, 32.47, 27.242, 22.806, 19.111, 16.032, 13.407, 11.199, 9.3624, 7.8328, 6.5581, 5.4951, 4.6078, 3.8666, 3.2449, 2.7155, 2.261, 1.8829, 1.5639, 1.2994, 1.0988, 1.0803, 1.0537, 1.0421, 4.4898, 4.3242, 3.9778, 3.3558, 2.8286, 2.3833, 2.008, 1.6908, 1.4232, 1.198, 1.0085, 0.84913, 0.71501, 0.60273, 0.50826, 0.42865, 0.36155, 0.30499, 0.2573, 0.21709, 0.18318, 0.15459, 0.0],
                   'energies (keV)': [0.0324615, 0.032946, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.041454, 0.0420885, 0.0422577, 0.0425115, 0.043146, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.069286, 0.0703465, 0.0706293, 0.0710535, 0.072114, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.094374, 0.0958185, 0.0962037, 0.09665893, 0.0967815, 0.098226, 0.1029, 0.1033284, 0.104475, 0.104895, 0.105525, 0.1071, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.191198, 0.1941245, 0.1949049, 0.1960755, 0.199002, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.254114, 0.2580035, 0.2590407, 0.2605965, 0.2629708, 0.264486, 0.2811158, 0.3005128, 0.317226, 0.3212482, 0.3220815, 0.3233763, 0.3253185, 0.330174, 0.3434143, 0.3671099, 0.373282, 0.3789955, 0.3805191, 0.3828045, 0.383474, 0.388518, 0.3893435, 0.3909087, 0.3924405, 0.3932565, 0.399126, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.722946, 0.7340115, 0.7369623, 0.7413885, 0.752454, 0.7648052, 0.776498, 0.7796196, 0.784302, 0.796008, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.024002, 1.039675, 1.043855, 1.050124, 1.065798, 1.067676, 1.141345, 1.220098, 1.247148, 1.266237, 1.271327, 1.278963, 1.298052, 1.304285, 1.394281, 1.411984, 1.433596, 1.439359, 1.448004, 1.469616, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.480666, 3.533942, 3.548445, 3.569459, 3.622734, 3.653048, 3.708962, 3.723872, 3.746238, 3.793288, 3.802152, 4.055024, 4.217332, 4.281883, 4.299097, 4.324917, 4.334821, 4.389468, 4.633924, 4.953664, 5.078556, 5.156289, 5.177018, 5.208111, 5.285844, 5.295467, 5.43704, 5.52026, 5.542452, 5.57574, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 16.82297, 17.08047, 17.14913, 17.25213, 17.50963, 17.59961, 18.81398, 20.11215, 20.52865, 20.84286, 20.92665, 21.05234, 21.32225, 21.36655, 21.49988, 21.64861, 21.73564, 21.86619, 22.19255, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.294, 113.9931, 115.0281, 115.4905, 116.1841, 117.9182, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Y': {'mass_absorption_coefficient (cm2/g)': [182340.0, 171650.0, 145230.0, 110490.0, 82879.0, 61580.0, 45632.0, 33917.0, 25402.0, 19240.0, 17412.0, 16396.0, 16140.0, 16639.0, 15782.0, 15676.0, 12540.0, 10275.0, 8616.2, 7385.9, 6458.7, 5746.6, 5188.1, 4739.8, 4371.4, 4061.5, 3795.1, 3561.6, 3353.6, 3165.3, 2992.3, 2831.3, 2679.9, 2536.1, 2535.4, 2506.4, 2503.6, 2495.3, 5307.8, 5383.7, 5464.7, 7485.8, 7519.3, 8048.2, 8577.0, 12440.0, 17530.0, 22816.0, 27501.0, 30974.0, 32933.0, 33387.0, 32557.0, 31412.0, 30952.0, 30825.0, 33670.0, 33532.0, 33051.0, 33034.0, 32514.0, 32369.0, 33361.0, 32806.0, 32494.0, 29792.0, 26955.0, 24856.0, 24221.0, 24135.0, 24054.0, 24864.0, 24242.0, 22444.0, 19876.0, 17523.0, 15386.0, 13468.0, 11760.0, 10246.0, 8906.9, 7725.7, 6688.4, 5780.9, 4989.6, 4301.4, 3704.6, 3144.4, 2670.6, 2267.6, 1915.1, 1618.0, 1368.9, 1159.7, 982.89, 834.19, 708.95, 633.97, 611.17, 605.29, 2581.2, 2547.2, 2471.9, 2441.3, 2366.6, 2339.6, 3228.6, 3097.2, 3000.5, 2667.0, 2563.8, 2537.3, 2896.1, 2876.2, 2772.1, 2456.7, 2089.7, 1772.8, 1495.4, 1255.5, 1054.9, 887.08, 746.59, 626.29, 523.06, 436.29, 363.74, 303.52, 253.22, 211.4, 176.66, 147.77, 123.65, 103.57, 86.612, 71.579, 59.158, 48.724, 40.167, 33.141, 27.37, 22.625, 18.719, 15.502, 14.898, 14.275, 14.114, 102.2, 97.831, 94.262, 78.414, 65.883, 55.496, 46.596, 38.982, 32.586, 27.138, 22.576, 18.783, 15.618, 12.904, 10.663, 8.8118, 7.2824, 6.0182, 4.973, 4.107, 3.3921, 2.8018, 2.3143, 1.9118, 1.5759, 1.295, 1.0621, 0.87111, 0.71451, 0.58608, 0.48076, 0.39438, 0.32354, 0.26543, 0.21777, 0.17867, 0.1466, 0.12028, 0.098699, 0.08099, 0.066461, 0.05454, 0.044758, 0.036732, 0.030147, 0.024742, 0.020307, 0.016668, 0.013681, 0.01123, 0.0092179, 0.0],
                   'energies (keV)': [0.025728, 0.026112, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.044492, 0.045173, 0.0453546, 0.045627, 0.046308, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.154252, 0.156408, 0.156613, 0.1572426, 0.158187, 0.158802, 0.1594404, 0.160398, 0.160548, 0.162792, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.294294, 0.2987985, 0.2999997, 0.3005128, 0.3018015, 0.306152, 0.306306, 0.310838, 0.3120876, 0.313962, 0.318648, 0.3212482, 0.3434143, 0.3671099, 0.385728, 0.391632, 0.3924405, 0.3932064, 0.395568, 0.401472, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.0384, 2.0696, 2.07792, 2.080733, 2.0904, 2.11239, 2.1216, 2.144722, 2.153344, 2.166277, 2.19861, 2.224304, 2.32505, 2.360637, 2.370127, 2.377781, 2.384362, 2.41995, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 16.69763, 16.95321, 17.02136, 17.12359, 17.37917, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ac': {'mass_absorption_coefficient (cm2/g)': [86550.0, 81955.0, 71371.0, 55808.0, 43547.0, 33941.0, 29665.0, 28031.0, 27615.0, 64526.0, 63126.0, 60808.0, 48347.0, 37260.0, 29222.0, 23247.0, 18700.0, 15172.0, 13300.0, 12705.0, 12552.0, 13514.0, 13446.0, 12837.0, 10987.0, 8973.7, 7369.4, 6076.4, 5025.5, 4167.0, 3463.8, 2887.1, 2414.0, 2298.5, 2208.5, 2185.4, 36115.0, 35415.0, 35033.0, 33710.0, 33044.0, 32871.0, 51408.0, 50787.0, 50659.0, 45962.0, 38708.0, 29961.0, 21873.0, 15428.0, 10729.0, 7479.9, 5293.4, 3836.7, 3253.5, 3047.4, 2996.0, 4114.5, 4045.4, 3906.7, 3242.3, 2666.8, 2253.2, 2235.6, 2159.5, 2140.2, 2726.7, 2625.0, 2477.0, 2125.6, 1861.5, 1735.0, 1692.0, 1681.1, 1805.2, 1801.0, 1766.3, 1641.9, 1585.1, 1556.6, 1549.3, 1660.2, 1660.9, 1664.4, 1665.3, 1668.9, 1672.6, 1771.1, 1819.3, 2021.9, 2895.2, 4459.6, 6542.8, 8742.3, 10612.0, 11851.0, 12260.0, 12290.0, 12316.0, 12338.0, 12357.0, 12372.0, 12384.0, 12391.0, 12396.0, 12397.0, 12394.0, 12389.0, 12380.0, 12368.0, 12353.0, 12335.0, 12315.0, 12291.0, 12265.0, 12236.0, 12204.0, 12170.0, 12134.0, 12095.0, 12054.0, 12010.0, 11965.0, 11917.0, 11868.0, 11817.0, 11763.0, 11708.0, 11652.0, 11594.0, 11534.0, 11473.0, 11410.0, 11346.0, 11281.0, 11215.0, 11147.0, 11079.0, 11009.0, 10939.0, 10867.0, 10795.0, 10722.0, 10648.0, 10574.0, 10541.0, 11406.0, 11381.0, 11308.0, 11233.0, 11159.0, 11083.0, 11008.0, 10932.0, 10855.0, 10779.0, 10702.0, 10625.0, 10548.0, 10546.0, 11037.0, 10980.0, 10905.0, 10829.0, 10753.0, 10677.0, 10601.0, 10525.0, 10449.0, 10373.0, 10297.0, 10221.0, 10146.0, 10070.0, 9994.3, 9918.8, 9843.5, 9768.3, 9693.3, 9618.5, 9544.0, 9469.5, 9395.3, 9321.3, 9247.4, 9173.7, 9100.3, 9027.1, 8954.2, 8881.6, 8809.3, 8737.2, 8665.5, 8594.2, 8523.1, 8452.5, 8382.1, 8312.2, 8242.7, 8173.5, 8104.7, 8036.4, 7968.5, 7901.0, 7833.9, 7767.3, 7701.1, 7635.4, 7570.1, 7505.3, 7441.0, 7377.0, 7313.2, 7249.9, 7187.0, 7124.6, 7098.0, 7523.7, 7510.5, 7447.1, 7384.2, 7321.7, 7259.7, 7198.2, 7137.2, 7076.6, 7016.6, 6957.0, 6897.9, 6839.3, 6781.1, 6723.5, 6666.3, 6609.6, 6553.4, 6497.7, 6442.5, 6387.7, 6333.5, 6279.6, 6226.3, 6173.3, 6117.8, 6062.6, 6007.9, 5953.5, 5899.6, 5846.0, 5792.9, 5740.2, 5688.0, 5636.1, 5584.6, 5533.6, 5483.0, 5432.9, 5382.7, 5372.1, 5430.3, 5409.8, 5358.2, 5307.1, 5256.5, 5206.3, 5156.5, 5107.2, 5058.4, 5010.0, 4962.0, 4914.8, 4867.2, 4819.6, 4772.4, 4725.7, 4679.4, 4633.6, 4588.2, 4540.5, 4492.5, 4445.1, 4398.2, 4351.8, 4306.0, 4258.5, 4211.2, 4164.5, 4118.3, 4072.8, 4027.8, 3983.4, 3939.5, 3917.3, 3976.4, 3975.2, 3932.0, 3889.4, 3847.3, 3805.8, 3764.7, 3724.1, 3684.0, 3644.4, 3605.3, 3566.6, 3528.4, 3490.6, 3453.3, 3416.5, 3380.1, 3344.1, 3308.5, 3273.4, 3238.7, 3204.4, 3170.3, 3136.7, 3103.4, 3070.5, 3038.1, 3005.9, 2973.9, 2942.4, 2911.1, 2880.3, 2849.8, 2819.7, 2789.9, 2760.4, 2731.0, 2702.0, 2673.3, 2644.9, 2616.9, 2589.2, 2561.8, 2534.6, 2507.7, 2481.1, 2454.8, 2428.8, 2403.1, 2377.7, 2352.6, 2327.8, 2303.3, 2279.0, 2255.0, 2231.3, 2207.8, 2184.6, 2161.7, 2139.0, 2116.6, 2094.4, 2072.5, 2050.9, 2029.5, 2008.3, 1987.4, 1966.7, 1946.3, 1926.0, 1906.1, 1886.3, 1866.8, 1847.4, 1828.3, 1809.5, 1790.8, 1772.3, 1754.1, 1736.0, 1718.2, 1700.6, 1683.1, 1665.9, 1648.8, 1632.0, 1615.3, 1598.8, 1582.5, 1566.4, 1550.5, 1534.7, 1519.2, 1503.8, 1488.5, 1473.5, 1458.6, 1443.8, 1429.3, 1414.9, 1400.6, 1386.6, 1372.6, 1358.9, 1345.2, 1331.8, 1318.5, 1305.3, 1292.2, 1279.3, 1266.4, 1253.8, 1241.2, 1228.8, 1216.6, 1204.4, 1192.4, 1180.6, 1168.8, 1157.2, 1145.7, 1134.4, 1123.2, 1112.1, 1101.1, 1090.2, 1079.5, 1068.8, 1058.3, 1047.9, 1037.6, 1027.4, 1017.4, 1007.4, 997.55, 987.81, 978.17, 968.63, 959.2, 949.87, 940.63, 931.21, 921.64, 912.18, 902.82, 893.57, 884.41, 875.37, 866.42, 857.57, 848.82, 840.17, 831.61, 822.87, 814.19, 805.62, 797.14, 788.76, 780.47, 772.28, 764.18, 756.17, 748.26, 740.43, 732.69, 725.03, 717.46, 709.98, 702.58, 695.27, 688.03, 680.88, 673.81, 666.81, 658.78, 650.47, 642.28, 634.2, 626.23, 618.34, 610.57, 602.9, 595.34, 587.87, 580.51, 573.25, 566.09, 559.02, 556.81, 1449.7, 1438.8, 1419.7, 1400.9, 1382.3, 1364.0, 1346.0, 1328.2, 1310.6, 1293.3, 1284.5, 1800.7, 1793.9, 1775.1, 1756.5, 1738.2, 1720.1, 1702.2, 1684.6, 1667.2, 1650.0, 1633.0, 1614.1, 1594.6, 1575.3, 1556.0, 1536.8, 1517.6, 1498.7, 1479.8, 1461.0, 1442.4, 1423.9, 1405.5, 1387.3, 1369.3, 1351.4, 1333.6, 1316.0, 1298.6, 1281.3, 1264.2, 1263.2, 1466.2, 1458.1, 1439.7, 1421.5, 1403.5, 1385.7, 1368.1, 1350.7, 1333.5, 1316.5, 1299.7, 1283.0, 1266.5, 1250.2, 1234.1, 1218.0, 1202.0, 1186.3, 1170.8, 1155.5, 1140.3, 1125.4, 1110.7, 1096.1, 1081.9, 1067.9, 1054.0, 1040.4, 1026.9, 1013.6, 1000.5, 987.53, 974.76, 962.17, 949.74, 937.48, 936.59, 989.83, 985.82, 973.45, 961.24, 949.18, 937.29, 925.55, 913.98, 902.55, 891.28, 880.15, 869.2, 858.39, 847.72, 837.2, 834.0, 863.2, 861.23, 852.77, 842.48, 832.32, 822.2, 812.22, 802.37, 792.64, 783.04, 773.57, 764.2, 754.94, 745.79, 736.76, 727.85, 719.04, 710.35, 701.77, 693.3, 684.93, 676.66, 668.48, 660.4, 652.42, 644.54, 636.76, 629.08, 621.49, 613.99, 606.59, 599.27, 592.05, 584.93, 577.89, 570.94, 564.07, 557.29, 550.6, 543.99, 537.41, 530.91, 524.5, 518.16, 511.9, 505.72, 499.62, 493.59, 487.63, 481.76, 475.95, 470.22, 464.5, 458.81, 453.2, 447.65, 442.18, 436.77, 431.43, 426.15, 420.95, 415.77, 410.61, 405.52, 400.49, 395.53, 390.63, 385.8, 381.03, 376.33, 371.68, 367.09, 362.57, 358.1, 353.69, 349.34, 345.04, 340.8, 336.62, 332.49, 328.41, 324.39, 320.41, 316.49, 312.62, 308.8, 305.03, 301.31, 297.64, 294.01, 290.43, 286.87, 283.34, 279.86, 276.42, 273.03, 269.68, 266.37, 263.11, 259.89, 256.72, 253.58, 250.48, 247.43, 244.41, 241.43, 238.5, 235.59, 232.73, 202.38, 169.39, 141.84, 118.89, 99.818, 83.883, 70.559, 59.367, 49.901, 48.642, 46.769, 46.287, 114.01, 109.7, 105.0, 87.803, 74.396, 73.187, 71.369, 70.59, 98.374, 94.911, 94.635, 91.215, 90.264, 102.81, 100.63, 99.087, 85.014, 71.664, 60.409, 50.945, 42.701, 35.744, 29.933, 25.029, 20.95, 17.535, 14.628, 12.204, 10.189, 8.514, 7.1195, 5.9579, 4.9895, 4.1817, 3.5033, 2.9349, 2.4542, 2.0377, 1.689, 1.401, 1.2265, 1.1756, 1.163, 1.1626, 5.174, 4.9827, 4.4331, 3.7368, 3.1459, 2.6476, 2.228, 1.873, 1.5741, 1.3229, 1.1118, 0.93459, 0.78569, 0.66107, 0.55629, 0.46817, 0.39405, 0.3317, 0.27925, 0.23511, 0.19797, 0.16672, 0.14041, 0.0],
                    'energies (keV)': [0.0184941, 0.01877013, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.0246814, 0.02505918, 0.02515992, 0.02531103, 0.02545001, 0.0256888, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.03965432, 0.04026127, 0.04042313, 0.04060054, 0.04066591, 0.04127286, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07540014, 0.07655423, 0.07686198, 0.07732361, 0.0784777, 0.07912411, 0.08147337, 0.08272042, 0.08305296, 0.08355178, 0.08458368, 0.08479882, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1599698, 0.1624183, 0.1630713, 0.1640507, 0.1648404, 0.1664992, 0.1762144, 0.1883732, 0.2013709, 0.202048, 0.2051405, 0.2059652, 0.2072023, 0.2102948, 0.2152655, 0.2301188, 0.245997, 0.2560302, 0.259949, 0.260994, 0.2625616, 0.2629708, 0.2664804, 0.2811158, 0.2891658, 0.2935918, 0.294772, 0.2965424, 0.2978648, 0.3005128, 0.3009684, 0.302424, 0.3036397, 0.3054634, 0.3100226, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.63664076, 0.63735929, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.674518, 0.67528199, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.88919009, 0.89080989, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0789287, 1.0810714, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.2675407, 1.2704594, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2180698, 3.2199304, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3691316, 3.3712683, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9040746, 3.9139253, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6489696, 4.6630307, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 4.9909955, 5.0083023, 5.0130043, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 15.55358, 15.79165, 15.85513, 15.95036, 16.18842, 16.46362, 17.59961, 18.70154, 18.81398, 18.98778, 19.06412, 19.17862, 19.4432, 19.46486, 19.7408, 19.82016, 19.9392, 20.11215, 20.2368, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 104.6202, 106.2215, 106.6353, 106.6485, 107.2891, 108.8904, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ag': {'mass_absorption_coefficient (cm2/g)': [167750.0, 167440.0, 166510.0, 164950.0, 162680.0, 159630.0, 155860.0, 151450.0, 146470.0, 141040.0, 135220.0, 129130.0, 122840.0, 116450.0, 110030.0, 103640.0, 97352.0, 91213.0, 85263.0, 79537.0, 74059.0, 68847.0, 63911.0, 59258.0, 54888.0, 52849.0, 51925.0, 51683.0, 73446.0, 71677.0, 70527.0, 60486.0, 58750.0, 56700.0, 56150.0, 65461.0, 62625.0, 60099.0, 50409.0, 43330.0, 37899.0, 33503.0, 29815.0, 28273.0, 27562.0, 27378.0, 27884.0, 27434.0, 27235.0, 24722.0, 22339.0, 20224.0, 18336.0, 16642.0, 15118.0, 13743.0, 12500.0, 11372.0, 10348.0, 9416.5, 8566.8, 7790.7, 7079.9, 6428.0, 5829.5, 5280.0, 4775.7, 4313.3, 4021.0, 3927.1, 3919.1, 3902.6, 8289.7, 8334.0, 8411.0, 8460.3, 11600.0, 11641.0, 12017.0, 12917.0, 15159.0, 16867.0, 17647.0, 17521.0, 16675.0, 16282.0, 15984.0, 15902.0, 17939.0, 17591.0, 17474.0, 17279.0, 16901.0, 16799.0, 17523.0, 17132.0, 16630.0, 14823.0, 13510.0, 13117.0, 13062.0, 13014.0, 13424.0, 13042.0, 11948.0, 10421.0, 9057.1, 7855.1, 6802.0, 5840.7, 5004.5, 4283.9, 3662.6, 3130.6, 2672.5, 2264.0, 1920.9, 1632.5, 1389.7, 1185.0, 1012.2, 863.1, 733.38, 623.57, 530.78, 446.12, 382.06, 370.95, 366.4, 362.37, 1204.9, 1173.4, 1152.2, 1121.6, 1113.0, 1500.8, 1494.4, 1454.2, 1337.2, 1287.1, 1281.5, 1274.0, 1443.7, 1391.2, 1243.2, 1041.5, 872.75, 732.83, 615.57, 517.77, 435.86, 367.06, 308.61, 258.63, 216.63, 181.48, 151.8, 125.97, 104.63, 86.957, 72.289, 60.144, 50.09, 41.731, 34.689, 28.812, 23.84, 19.741, 16.362, 13.574, 11.271, 9.3665, 8.9233, 8.5567, 8.4624, 54.529, 52.35, 51.042, 42.957, 36.138, 30.117, 25.038, 20.863, 17.386, 14.491, 12.079, 10.069, 8.3924, 6.9525, 5.7602, 4.7727, 3.9549, 3.2774, 2.7159, 2.2474, 1.8534, 1.5286, 1.2608, 1.0399, 0.85741, 0.70652, 0.58222, 0.47981, 0.39543, 0.32591, 0.26863, 0.22142, 0.18252, 0.15046, 0.12404, 0.10226, 0.084306, 0.069508, 0.057311, 0.047255, 0.038965, 0.032131, 0.026496, 0.02185, 0.01802, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.054782, 0.0556205, 0.0558441, 0.0561795, 0.05667876, 0.057018, 0.06058959, 0.061348, 0.062287, 0.0625374, 0.062913, 0.063852, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.093296, 0.094724, 0.0951048, 0.095676, 0.09665893, 0.097104, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.359366, 0.3648665, 0.365344, 0.3663333, 0.3671099, 0.3685335, 0.370936, 0.3724272, 0.374034, 0.374664, 0.380256, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.559972, 0.568543, 0.5708286, 0.574257, 0.582828, 0.5856525, 0.590352, 0.599388, 0.6017976, 0.605412, 0.614448, 0.6260625, 0.6692609, 0.70315, 0.7139125, 0.7154399, 0.7167825, 0.7210875, 0.73185, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.284078, 3.319406, 3.334344, 3.347749, 3.367855, 3.418122, 3.453226, 3.506081, 3.520176, 3.541318, 3.548445, 3.594174, 3.729684, 3.786771, 3.793288, 3.801994, 3.824829, 3.881916, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 25.00372, 25.38643, 25.48849, 25.64157, 26.02428, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ir': {'mass_absorption_coefficient (cm2/g)': [25921.0, 25050.0, 19380.0, 19072.0, 19006.0, 48342.0, 46942.0, 46273.0, 52931.0, 61738.0, 72476.0, 84772.0, 98015.0, 111330.0, 123640.0, 133750.0, 140580.0, 143310.0, 141570.0, 135500.0, 125720.0, 113210.0, 99084.0, 84454.0, 70284.0, 57254.0, 45806.0, 36121.0, 28168.0, 21794.0, 16925.0, 16780.0, 15941.0, 15690.0, 31770.0, 30081.0, 27041.0, 21149.0, 17894.0, 16910.0, 16660.0, 18390.0, 18155.0, 17195.0, 17164.0, 16771.0, 16235.0, 15999.0, 22217.0, 21946.0, 22760.0, 22184.0, 21764.0, 21661.0, 17803.0, 14744.0, 12272.0, 10350.0, 8948.4, 8458.3, 8257.3, 8208.1, 8329.8, 8218.1, 8171.3, 7734.3, 7646.8, 7919.3, 8516.8, 9408.6, 10541.0, 11854.0, 13280.0, 14726.0, 16103.0, 17325.0, 18317.0, 19020.0, 19397.0, 19409.0, 19050.0, 18801.0, 18642.0, 18598.0, 18961.0, 18809.0, 18798.0, 18628.0, 18437.0, 18385.0, 18617.0, 18422.0, 18267.0, 17258.0, 16135.0, 14954.0, 13760.0, 12589.0, 11463.0, 11293.0, 11047.0, 10983.0, 11595.0, 11489.0, 11408.0, 11328.0, 11247.0, 11168.0, 11088.0, 11009.0, 10930.0, 10852.0, 10774.0, 10697.0, 10620.0, 10543.0, 10467.0, 10391.0, 10316.0, 10241.0, 10166.0, 10092.0, 10018.0, 9945.1, 9872.1, 9799.5, 9727.3, 9655.5, 9584.1, 9513.1, 9442.5, 9372.2, 9339.9, 9443.6, 9440.6, 9374.2, 9305.1, 9236.5, 9168.2, 9100.3, 9032.9, 8965.8, 8899.1, 8832.8, 8766.9, 8701.4, 8636.2, 8571.5, 8507.1, 8443.1, 8379.6, 8316.3, 8253.5, 8191.1, 8129.0, 8067.3, 8006.0, 7945.1, 7884.5, 7824.3, 7764.5, 7705.0, 7645.9, 7587.2, 7528.8, 7470.8, 7413.2, 7355.9, 7298.9, 7242.4, 7226.3, 7361.1, 7357.0, 7300.5, 7244.4, 7188.7, 7133.3, 7078.2, 7023.5, 6969.2, 6915.2, 6861.5, 6808.2, 6755.3, 6702.6, 6650.4, 6598.4, 6546.8, 6495.6, 6444.6, 6394.0, 6343.8, 6293.8, 6244.2, 6194.9, 6145.9, 6097.3, 6049.0, 6000.9, 5953.2, 5905.9, 5858.8, 5812.0, 5765.6, 5719.5, 5673.6, 5628.1, 5582.9, 5538.0, 5493.4, 5449.1, 5404.8, 5360.9, 5317.2, 5273.9, 5230.8, 5188.0, 5145.6, 5103.4, 5061.5, 5019.9, 4978.5, 4937.5, 4896.8, 4856.3, 4816.1, 4776.2, 4736.6, 4697.3, 4658.2, 4619.5, 4581.0, 4542.8, 4504.8, 4467.1, 4429.8, 4392.6, 4355.7, 4319.1, 4282.8, 4246.7, 4210.9, 4175.3, 4139.9, 4104.8, 4070.0, 4035.3, 3996.4, 3957.9, 3919.7, 3881.9, 3844.4, 3807.3, 3770.5, 3734.0, 3697.9, 3662.1, 3626.7, 3591.6, 3556.8, 3522.4, 3488.3, 3454.5, 3421.0, 3387.9, 3355.1, 3322.6, 3290.4, 3258.5, 3226.9, 3195.7, 3164.7, 3133.3, 3101.3, 3069.7, 3038.4, 3007.4, 2976.8, 2946.4, 2916.4, 2885.1, 2853.8, 2821.8, 2790.3, 2759.1, 2728.3, 2697.9, 2667.9, 2638.2, 2609.0, 2580.0, 2550.4, 2521.1, 2492.2, 2463.7, 2435.5, 2407.6, 2380.2, 2353.0, 2326.3, 2299.8, 2273.7, 2247.9, 2222.4, 2197.3, 2172.5, 2148.0, 2123.7, 2099.8, 2076.2, 2052.9, 2029.9, 2007.1, 1984.7, 1962.5, 1940.6, 1919.0, 1897.6, 1876.5, 1855.7, 1835.1, 1814.7, 1794.7, 1774.8, 1755.2, 1735.9, 1716.8, 1697.9, 1679.2, 1660.8, 1642.6, 1624.6, 1606.9, 1589.3, 1572.0, 1554.9, 1538.0, 1521.2, 1504.7, 1488.4, 1472.3, 1456.4, 1440.7, 1425.1, 1409.8, 1394.6, 1379.6, 1364.8, 1350.2, 1335.7, 1321.4, 1307.3, 1293.3, 1279.6, 1265.9, 1252.5, 1239.2, 1226.0, 1213.0, 1200.2, 1187.5, 1175.0, 1162.6, 1150.3, 1138.2, 1126.3, 1114.4, 1102.7, 1091.2, 1079.8, 1068.5, 1057.3, 1046.3, 1035.4, 1024.6, 1014.0, 1003.4, 993.04, 982.76, 972.59, 962.54, 952.61, 942.79, 933.01, 923.2, 913.51, 903.92, 894.45, 885.09, 876.63, 2749.2, 2748.9, 2716.2, 2683.6, 2651.4, 2619.6, 2588.2, 2557.2, 2526.5, 2520.7, 3710.2, 3680.3, 3635.6, 3591.5, 3547.9, 3504.8, 3462.3, 3420.3, 3378.8, 3337.9, 3297.4, 3257.5, 3218.0, 3179.0, 3140.6, 3102.5, 3065.0, 3027.9, 2991.3, 2955.0, 2919.2, 2883.8, 2848.9, 2814.4, 2780.3, 2746.7, 2713.4, 2680.6, 2648.2, 2616.1, 2584.5, 2553.3, 2522.4, 2491.9, 2461.8, 2432.1, 2402.8, 2373.8, 2358.5, 2755.9, 2752.6, 2718.4, 2684.7, 2651.4, 2618.5, 2586.0, 2553.9, 2522.3, 2490.7, 2459.2, 2429.1, 2400.0, 2371.4, 2343.3, 2315.6, 2288.2, 2260.9, 2234.0, 2207.4, 2181.2, 2155.4, 2129.9, 2104.7, 2079.9, 2055.4, 2031.2, 2012.9, 2007.3, 2137.7, 2120.0, 2093.7, 2067.8, 2042.2, 2016.9, 1991.9, 1967.0, 1942.5, 1918.4, 1894.7, 1871.5, 1848.6, 1826.0, 1803.7, 1781.7, 1760.0, 1738.6, 1736.1, 1795.1, 1793.9, 1772.5, 1751.3, 1730.4, 1709.7, 1689.2, 1669.0, 1649.0, 1629.3, 1609.6, 1590.2, 1571.0, 1552.0, 1533.2, 1514.6, 1496.2, 1478.1, 1460.1, 1442.3, 1424.8, 1407.5, 1390.3, 1373.4, 1356.6, 1340.1, 1323.7, 1307.5, 1291.6, 1275.8, 1260.2, 1244.8, 1229.5, 1214.5, 1199.7, 1185.0, 1170.6, 1156.4, 1142.4, 1128.5, 1114.9, 1101.4, 1088.1, 1074.9, 1062.0, 1049.2, 1036.5, 1024.0, 1011.7, 999.51, 987.49, 975.59, 963.43, 951.43, 939.55, 927.82, 916.25, 904.83, 893.56, 882.24, 871.0, 859.91, 848.98, 838.2, 827.56, 817.06, 806.71, 796.5, 786.42, 776.49, 766.68, 757.01, 747.47, 738.06, 728.77, 719.61, 710.58, 701.66, 692.87, 684.19, 675.63, 667.18, 658.85, 650.63, 642.52, 634.51, 626.62, 618.83, 611.14, 603.55, 596.07, 588.69, 581.4, 574.21, 567.12, 560.12, 553.16, 546.17, 539.27, 532.46, 525.75, 519.12, 512.59, 506.14, 499.78, 493.5, 487.31, 481.2, 475.17, 469.22, 463.35, 457.55, 451.84, 446.17, 440.57, 435.04, 429.59, 424.21, 418.9, 413.67, 408.5, 403.4, 398.37, 393.34, 388.34, 383.42, 378.56, 373.76, 369.03, 364.36, 359.75, 355.21, 350.73, 346.3, 341.94, 337.63, 333.38, 329.19, 325.05, 320.97, 316.93, 312.94, 309.0, 305.11, 301.27, 297.48, 293.75, 290.06, 286.42, 282.83, 279.29, 275.79, 272.34, 268.94, 265.58, 262.26, 258.99, 255.77, 252.58, 249.44, 246.33, 243.27, 240.25, 237.27, 234.32, 231.42, 228.55, 225.72, 222.93, 220.18, 217.46, 214.77, 212.12, 209.51, 206.93, 204.38, 201.86, 199.38, 196.93, 194.52, 192.13, 189.77, 187.45, 185.15, 182.89, 180.65, 178.45, 176.27, 174.12, 172.0, 169.9, 167.83, 165.79, 163.77, 161.78, 159.82, 157.88, 155.97, 154.08, 152.21, 132.3, 110.37, 92.191, 77.929, 77.156, 74.796, 73.984, 194.96, 187.23, 172.29, 144.69, 143.45, 138.75, 137.22, 188.88, 181.45, 178.86, 171.64, 169.78, 193.91, 193.6, 186.43, 163.53, 137.54, 115.63, 97.114, 81.511, 68.445, 57.503, 48.304, 40.554, 34.061, 28.356, 23.55, 19.575, 16.285, 13.559, 11.298, 9.4223, 7.864, 6.5679, 5.4793, 4.5729, 3.8121, 3.1664, 2.6312, 2.1865, 1.9415, 1.8617, 1.8412, 9.1237, 9.0923, 8.7628, 7.705, 6.4619, 5.4198, 4.5469, 3.8029, 3.181, 2.6612, 2.2267, 1.8633, 1.5594, 1.3029, 1.0876, 0.90808, 0.75823, 0.63316, 0.52878, 0.44164, 0.3689, 0.30816, 0.25744, 0.21509, 0.17984, 0.15158, 0.12777, 0.10771, 0.090804, 0.0],
                    'energies (keV)': [0.00688883, 0.006991648, 0.007901491, 0.008022432, 0.008054683, 0.008103059, 0.008224, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04949, 0.04959809, 0.0502475, 0.0504495, 0.0507525, 0.05151, 0.05302035, 0.05667876, 0.05929, 0.0601975, 0.0604395, 0.06058959, 0.0608025, 0.06171, 0.06174, 0.062132, 0.062685, 0.062937, 0.063083, 0.0633366, 0.063717, 0.06426, 0.064668, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.093296, 0.094724, 0.0951048, 0.095676, 0.09665893, 0.097104, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.289002, 0.2934255, 0.2946051, 0.2963745, 0.3005128, 0.300798, 0.305172, 0.309843, 0.3110886, 0.312957, 0.317628, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.484414, 0.4918285, 0.4938057, 0.4967715, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57626318, 0.57781099, 0.57793677, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.68899585, 0.69120417, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0399144, 2.0407952, 2.0408856, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1153256, 2.1168746, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5483176, 2.5530823, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9045696, 2.9079692, 2.9128303, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1671623, 3.1802379, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4282291, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 10.9909, 11.03212, 11.15912, 11.20399, 11.27128, 11.4395, 11.79334, 12.56762, 12.60708, 12.75998, 12.81128, 12.88822, 13.08058, 13.15013, 13.35141, 13.40508, 13.47697, 13.48559, 13.68687, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 74.58878, 75.73045, 76.03489, 76.38578, 76.49156, 77.63322, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Al': {'mass_absorption_coefficient (cm2/g)': [19119.0, 16513.0, 2677.3, 2054.0, 1744.8, 1609.9, 1586.4, 1645.1, 1772.8, 1963.6, 2215.0, 2524.7, 2888.8, 3300.5, 3748.8, 4218.6, 4691.0, 5144.2, 5555.8, 5904.6, 6162.5, 6305.1, 6334.2, 6259.1, 6095.1, 5853.5, 5538.7, 5180.1, 4795.5, 4400.5, 4008.1, 3812.2, 3726.1, 3703.6, 83378.0, 84589.0, 85797.0, 96319.0, 108400.0, 116930.0, 121370.0, 121850.0, 118890.0, 115460.0, 114020.0, 113620.0, 124430.0, 124250.0, 122650.0, 116650.0, 107640.0, 97963.0, 88119.0, 78493.0, 69358.0, 60883.0, 53154.0, 46198.0, 40004.0, 34534.0, 29734.0, 25545.0, 21903.0, 18741.0, 16006.0, 13647.0, 11619.0, 9878.3, 8388.4, 7115.2, 6028.2, 5101.6, 4313.1, 3643.4, 3075.3, 2594.3, 2187.5, 1843.9, 1553.9, 1309.5, 1103.7, 918.78, 765.33, 638.09, 532.48, 444.15, 369.28, 344.6, 330.52, 326.9, 4035.9, 3954.9, 3946.3, 3483.8, 2941.0, 2445.6, 2033.6, 1704.1, 1430.3, 1201.8, 1009.7, 847.65, 709.06, 587.62, 486.76, 403.24, 334.05, 276.75, 229.29, 189.98, 157.41, 130.43, 108.08, 89.558, 74.022, 60.881, 50.073, 41.186, 33.814, 27.577, 22.491, 18.343, 14.961, 12.202, 9.9528, 8.118, 6.6216, 5.401, 4.4056, 3.5936, 2.9314, 2.3912, 1.9506, 1.5912, 1.298, 1.0542, 0.85493, 0.69335, 0.56128, 0.45343, 0.3663, 0.29591, 0.23905, 0.19312, 0.15602, 0.12603, 0.1018, 0.082227, 0.066417, 0.053647, 0.043333, 0.035002, 0.028272, 0.022837, 0.018447, 0.0149, 0.012036, 0.009722, 0.007853, 0.0063434, 0.0051239, 0.0041389, 0.0033433, 0.0027006, 0.0021815, 0.0017622, 0.0014234, 0.0011498, 0.0009288, 0.00075026, 0.00060605, 0.00048956, 0.00039546, 0.00031945, 0.00025805, 0.00020845, 0.00016838, 0.0],
                    'energies (keV)': [0.008417543, 0.008543178, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.071638, 0.0727345, 0.0730269, 0.0734655, 0.07401695, 0.074562, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.115346, 0.1171115, 0.1175823, 0.1180797, 0.1182885, 0.120054, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.528408, 1.551802, 1.55804, 1.567398, 1.590792, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'As': {'mass_absorption_coefficient (cm2/g)': [9196.7, 9709.9, 10929.0, 13940.0, 17489.0, 21481.0, 25836.0, 30438.0, 35139.0, 39773.0, 44166.0, 48146.0, 51564.0, 54293.0, 56248.0, 57381.0, 57686.0, 57192.0, 55963.0, 54086.0, 53405.0, 52862.0, 52715.0, 54328.0, 53823.0, 53784.0, 53595.0, 53245.0, 53100.0, 53660.0, 53134.0, 51947.0, 49280.0, 46334.0, 43165.0, 40359.0, 39878.0, 39604.0, 39405.0, 40753.0, 40010.0, 38189.0, 34892.0, 31684.0, 28609.0, 25702.0, 22984.0, 20471.0, 18165.0, 16067.0, 14170.0, 12465.0, 10940.0, 9581.0, 8375.4, 7309.1, 6368.1, 5538.5, 4809.0, 4169.7, 3611.1, 3105.4, 2665.2, 2491.8, 2463.4, 2435.4, 2407.7, 2380.3, 2353.2, 2326.4, 2300.0, 2273.8, 2247.9, 2222.4, 2197.1, 2172.1, 2147.4, 2123.0, 2098.9, 2075.1, 2051.5, 2028.2, 2005.2, 1982.4, 1959.9, 1934.6, 1909.2, 1884.1, 1859.4, 1835.1, 1811.0, 1787.3, 1763.9, 1740.9, 1718.2, 1695.7, 1673.6, 1651.8, 1630.3, 1609.1, 1588.2, 1567.6, 1547.2, 1527.1, 1507.4, 1487.8, 1468.6, 1449.6, 1430.8, 1412.4, 1394.1, 1376.2, 1358.4, 1340.9, 1323.7, 1306.7, 1289.9, 1273.3, 1257.0, 1240.9, 1225.0, 1209.3, 1193.8, 1178.5, 1163.5, 1148.6, 1134.0, 1119.5, 1105.3, 1091.2, 1077.3, 1063.6, 1050.1, 1036.8, 1023.6, 1010.6, 997.84, 985.2, 972.74, 960.45, 948.31, 945.4, 4967.0, 4920.6, 4856.9, 4794.1, 4732.1, 4671.0, 4637.6, 6569.7, 6534.6, 6450.3, 6367.1, 6285.0, 6204.0, 6124.0, 6045.1, 5967.2, 5890.3, 5814.4, 5739.4, 5665.5, 5592.5, 5520.4, 5449.3, 5379.1, 5309.9, 5241.5, 5174.0, 5107.4, 5041.6, 4976.7, 4912.7, 4865.0, 5546.6, 5539.0, 5478.3, 5410.7, 5344.1, 5278.2, 5213.2, 5149.0, 5085.6, 5023.0, 4961.2, 4900.3, 4840.4, 4781.3, 4722.9, 4665.2, 4608.3, 4552.1, 4496.6, 4441.9, 4387.8, 4334.5, 4281.8, 4229.7, 4178.4, 4127.6, 4077.0, 4027.1, 3977.8, 3929.2, 3881.1, 3833.4, 3786.3, 3739.8, 3693.8, 3648.4, 3603.6, 3559.4, 3515.6, 3472.5, 3429.8, 3387.7, 3346.1, 3305.0, 3264.5, 3224.4, 3184.8, 3145.8, 3107.2, 3069.0, 3031.4, 2994.2, 2957.5, 2921.2, 2885.2, 2849.4, 2814.1, 2779.2, 2744.7, 2710.7, 2677.1, 2643.9, 2611.1, 2578.7, 2546.7, 2515.1, 2483.9, 2453.1, 2422.6, 2392.5, 2362.8, 2333.5, 2304.5, 2275.9, 2247.6, 2219.7, 2192.2, 2164.9, 2138.0, 2111.5, 2085.2, 2059.3, 2033.7, 2008.5, 1983.5, 1958.9, 1934.5, 1910.5, 1886.8, 1863.3, 1840.2, 1817.3, 1794.7, 1772.4, 1750.4, 1728.7, 1707.2, 1686.0, 1665.1, 1644.4, 1624.0, 1603.8, 1583.9, 1564.3, 1544.8, 1525.7, 1506.7, 1488.0, 1469.6, 1451.4, 1433.4, 1415.5, 1397.7, 1380.0, 1362.5, 1345.2, 1328.2, 1311.3, 1294.5, 1278.0, 1261.6, 1245.5, 1229.5, 1213.8, 1198.2, 1182.9, 1167.8, 1152.8, 1138.1, 1123.5, 1109.2, 1095.0, 1081.0, 1067.2, 1053.6, 1040.2, 1026.9, 1013.3, 999.62, 986.12, 972.79, 959.47, 946.33, 933.38, 920.61, 908.02, 895.61, 883.37, 871.3, 859.4, 847.67, 836.1, 824.69, 813.45, 802.36, 791.42, 780.64, 770.01, 759.53, 749.19, 739.0, 728.95, 719.04, 709.27, 699.64, 690.14, 680.77, 671.53, 662.42, 653.44, 644.58, 635.85, 627.24, 618.75, 610.37, 602.12, 593.97, 585.94, 578.02, 570.22, 562.51, 554.92, 547.43, 540.05, 532.77, 525.58, 518.49, 511.49, 504.58, 497.77, 491.06, 484.44, 477.91, 471.47, 465.12, 458.86, 452.69, 446.6, 440.59, 434.67, 428.83, 423.07, 417.38, 411.78, 406.26, 400.81, 395.43, 390.13, 384.91, 379.75, 374.67, 369.65, 364.71, 359.83, 355.02, 350.28, 345.6, 340.98, 336.43, 331.94, 327.52, 323.15, 318.84, 314.6, 310.41, 306.27, 302.2, 298.18, 294.21, 290.3, 286.45, 282.64, 278.89, 275.19, 271.54, 267.94, 264.39, 260.88, 257.43, 254.02, 250.66, 247.34, 244.07, 240.84, 237.66, 234.52, 231.43, 228.37, 225.36, 222.39, 219.46, 216.56, 213.71, 210.9, 208.12, 205.38, 202.68, 200.02, 197.39, 194.8, 192.24, 189.72, 187.23, 184.77, 182.35, 179.96, 177.6, 175.23, 172.88, 170.56, 168.27, 166.02, 163.78, 161.56, 159.37, 157.21, 155.08, 152.98, 150.9, 148.86, 146.85, 144.87, 142.91, 140.98, 139.08, 137.2, 135.36, 133.53, 131.74, 129.96, 128.22, 126.49, 124.8, 123.12, 121.47, 106.01, 88.123, 73.327, 61.073, 50.733, 41.642, 34.214, 28.137, 24.125, 23.162, 23.082, 22.814, 179.33, 171.27, 151.5, 126.52, 106.54, 89.994, 75.367, 62.988, 52.558, 43.81, 36.504, 30.42, 25.315, 21.035, 17.391, 14.354, 11.849, 9.7755, 8.0645, 6.6535, 5.4897, 4.5297, 3.7379, 3.0846, 2.5315, 2.0767, 1.7038, 1.3978, 1.1469, 0.94102, 0.77126, 0.63052, 0.51548, 0.42145, 0.34459, 0.28175, 0.23039, 0.18839, 0.15405, 0.12598, 0.10303, 0.08426, 0.068913, 0.056363, 0.0461, 0.037707, 0.030844, 0.02523, 0.020639, 0.016883, 0.013812, 0.0113, 0.0092445, 0.0075634, 0.0061882, 0.0050632, 0.0],
                    'energies (keV)': [0.041406, 0.042024, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.13769, 0.1397975, 0.1403595, 0.1412025, 0.14331, 0.143472, 0.1442475, 0.145668, 0.1462536, 0.147132, 0.149328, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.19943, 0.2013709, 0.2024825, 0.2032965, 0.2045175, 0.20757, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9, 0.9045, 0.9090225, 0.91356761, 0.91813545, 0.92272613, 0.92733976, 0.93197646, 0.93663634, 0.94131952, 0.94602612, 0.95075625, 0.95551003, 0.96028758, 0.96508902, 0.96991446, 0.97476404, 0.97963786, 0.98453605, 0.98945873, 0.99440602, 0.99937805, 1.0043749, 1.0093968, 1.0144438, 1.019516, 1.0246136, 1.0297367, 1.0348853, 1.0400598, 1.0452601, 1.0504864, 1.0557388, 1.0610175, 1.0663226, 1.0716542, 1.0770125, 1.0823975, 1.0878095, 1.0932486, 1.0987148, 1.1042084, 1.1097294, 1.1152781, 1.1208545, 1.1264587, 1.132091, 1.1377515, 1.1434402, 1.1491574, 1.1549032, 1.1606777, 1.1664811, 1.1723135, 1.1781751, 1.184066, 1.1899863, 1.1959362, 1.2019159, 1.2079255, 1.2139651, 1.220035, 1.2261351, 1.2322658, 1.2384271, 1.2446193, 1.2508424, 1.2570966, 1.2633821, 1.269699, 1.2760475, 1.2824277, 1.2888399, 1.295284, 1.3017605, 1.3082693, 1.3148106, 1.3213847, 1.3229793, 1.3232206, 1.3279916, 1.3346316, 1.3413047, 1.3480112, 1.3547513, 1.3584739, 1.3587261, 1.361525, 1.3683327, 1.3751743, 1.3820502, 1.3889605, 1.3959053, 1.4028848, 1.4098992, 1.4169487, 1.4240335, 1.4311536, 1.4383094, 1.4455009, 1.4527284, 1.4599921, 1.467292, 1.4746285, 1.4820016, 1.4894117, 1.4968587, 1.504343, 1.5118647, 1.519424, 1.5251383, 1.5270212, 1.5278616, 1.5346563, 1.5423295, 1.5500412, 1.5577914, 1.5655804, 1.5734083, 1.5812753, 1.5891817, 1.5971276, 1.6051132, 1.6131388, 1.6212045, 1.6293105, 1.6374571, 1.6456443, 1.6538726, 1.6621419, 1.6704526, 1.6788049, 1.6871989, 1.6956349, 1.7041131, 1.7126337, 1.7211968, 1.7298028, 1.7384518, 1.7471441, 1.7558798, 1.7646592, 1.7734825, 1.7823499, 1.7912617, 1.800218, 1.8092191, 1.8182652, 1.8273565, 1.8364933, 1.8456757, 1.8549041, 1.8641786, 1.8734995, 1.882867, 1.8922814, 1.9017428, 1.9112515, 1.9208077, 1.9304118, 1.9400638, 1.9497642, 1.959513, 1.9693105, 1.9791571, 1.9890529, 1.9989981, 2.0089931, 2.0190381, 2.0291333, 2.039279, 2.0494754, 2.0597227, 2.0700213, 2.0803714, 2.0907733, 2.1012272, 2.1117333, 2.122292, 2.1329034, 2.143568, 2.1542858, 2.1650572, 2.1758825, 2.1867619, 2.1976957, 2.2086842, 2.2197276, 2.2308263, 2.2419804, 2.2531903, 2.2644562, 2.2757785, 2.2871574, 2.2985932, 2.3100862, 2.3216366, 2.3332448, 2.344911, 2.3566356, 2.3684187, 2.3802608, 2.3921621, 2.404123, 2.4161436, 2.4282243, 2.4403654, 2.4525672, 2.4648301, 2.4771542, 2.48954, 2.5019877, 2.5144976, 2.5270701, 2.5397055, 2.552404, 2.565166, 2.5779919, 2.5908818, 2.6038362, 2.6168554, 2.6299397, 2.6430894, 2.6563048, 2.6695863, 2.6829343, 2.6963489, 2.7098307, 2.7233798, 2.7369967, 2.7506817, 2.7644351, 2.7782573, 2.7921486, 2.8061093, 2.8201399, 2.8342406, 2.8484118, 2.8626539, 2.8769671, 2.891352, 2.9058087, 2.9203378, 2.9349394, 2.9496141, 2.9643622, 2.979184, 2.9940799, 3.0090503, 3.0240956, 3.0392161, 3.0544122, 3.0696842, 3.0850326, 3.1004578, 3.1159601, 3.1315399, 3.1471976, 3.1629336, 3.1787482, 3.194642, 3.2106152, 3.2266683, 3.2428016, 3.2590156, 3.2753107, 3.2916873, 3.3081457, 3.3246864, 3.3413099, 3.3580164, 3.3748065, 3.3916805, 3.4086389, 3.4256821, 3.4428105, 3.4600246, 3.4773247, 3.4947113, 3.5121849, 3.5297458, 3.5473945, 3.5651315, 3.5829572, 3.6008719, 3.6188763, 3.6369707, 3.6551555, 3.6734313, 3.6917985, 3.7102575, 3.7288088, 3.7474528, 3.7661901, 3.785021, 3.8039461, 3.8229659, 3.8420807, 3.8612911, 3.8805975, 3.9000005, 3.9195005, 3.939098, 3.9587935, 3.9785875, 3.9984804, 4.0184728, 4.0385652, 4.058758, 4.0790518, 4.0994471, 4.1199443, 4.140544, 4.1612467, 4.182053, 4.2029632, 4.2239781, 4.245098, 4.2663234, 4.2876551, 4.3090933, 4.3306388, 4.352292, 4.3740535, 4.3959237, 4.4179033, 4.4399929, 4.4621928, 4.4845038, 4.5069263, 4.5294609, 4.5521082, 4.5748688, 4.5977431, 4.6207318, 4.6438355, 4.6670547, 4.69039, 4.7138419, 4.7374111, 4.7610982, 4.7849037, 4.8088282, 4.8328723, 4.8570367, 4.8813219, 4.9057285, 4.9302571, 4.9549084, 4.9796829, 5.0045814, 5.0296043, 5.0547523, 5.080026, 5.1054262, 5.1309533, 5.1566081, 5.1823911, 5.2083031, 5.2343446, 5.2605163, 5.2868189, 5.313253, 5.3398192, 5.3665183, 5.3933509, 5.4203177, 5.4474193, 5.4746564, 5.5020297, 5.5295398, 5.5571875, 5.5849734, 5.6128983, 5.6409628, 5.6691676, 5.6975135, 5.726001, 5.754631, 5.7834042, 5.8123212, 5.8413828, 5.8705897, 5.8999427, 5.9294424, 5.9590896, 5.988885, 6.0188295, 6.0489236, 6.0791682, 6.1095641, 6.1401119, 6.1708125, 6.2016665, 6.2326749, 6.2638382, 6.2951574, 6.3266332, 6.3582664, 6.3900577, 6.422008, 6.454118, 6.4863886, 6.5188206, 6.5514147, 6.5841717, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.62937, 11.79334, 11.80737, 11.85483, 11.92603, 12.10403, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Ar': {'mass_absorption_coefficient (cm2/g)': [382460.0, 421040.0, 518140.0, 788460.0, 1014100.0, 1089500.0, 1015000.0, 847230.0, 651470.0, 472570.0, 329920.0, 225410.0, 177940.0, 162850.0, 159080.0, 153110.0, 141280.0, 104440.0, 72397.0, 51499.0, 37927.0, 29122.0, 23402.0, 19670.0, 17210.0, 15559.0, 14413.0, 13591.0, 12972.0, 12475.0, 12051.0, 11674.0, 11328.0, 11006.0, 10700.0, 10407.0, 10123.0, 9841.2, 9555.8, 9261.8, 8955.1, 8632.4, 8291.4, 7931.2, 7552.4, 7157.1, 6748.8, 6331.6, 5910.7, 5491.2, 5152.7, 5081.9, 5026.9, 4993.9, 50586.0, 50555.0, 50384.0, 50089.0, 71651.0, 70615.0, 69233.0, 62860.0, 53864.0, 46247.0, 41978.0, 40555.0, 40188.0, 44257.0, 44154.0, 42784.0, 38405.0, 33317.0, 28854.0, 24936.0, 21499.0, 18491.0, 15861.0, 13572.0, 11587.0, 9870.7, 8391.7, 7121.1, 6032.8, 5103.1, 4310.9, 3637.2, 3065.6, 2555.2, 2130.9, 1778.5, 1483.8, 1235.2, 1029.1, 858.28, 716.47, 598.67, 500.72, 419.2, 351.3, 294.68, 247.42, 207.95, 174.94, 145.81, 141.37, 135.35, 133.81, 1323.6, 1275.1, 1225.1, 1032.6, 868.48, 729.77, 611.83, 512.14, 428.45, 358.36, 299.68, 250.55, 209.12, 173.6, 144.12, 119.66, 99.352, 82.371, 67.929, 56.022, 46.204, 38.109, 31.432, 25.927, 21.307, 17.461, 14.309, 11.726, 9.6104, 7.8765, 6.4556, 5.2912, 4.3369, 3.5549, 2.8963, 2.355, 1.915, 1.5572, 1.2663, 1.0297, 0.8374, 0.68099, 0.5538, 0.45038, 0.36627, 0.29787, 0.24225, 0.19702, 0.1597, 0.12925, 0.10459, 0.084595, 0.068425, 0.055347, 0.044768, 0.036212, 0.029291, 0.023693, 0.019165, 0.015503, 0.01254, 0.010144, 0.0082055, 0.0066376, 0.0053693, 0.0043433, 0.0035134, 0.0028421, 0.0022991, 0.0018598, 0.0015045, 0.0012171, 0.00098455, 0.00079646, 0.0006443, 0.00052121, 0.0],
                    'energies (keV)': [0.012462, 0.012648, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.024794, 0.0251735, 0.0252747, 0.02545001, 0.025806, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.240296, 0.242354, 0.243974, 0.2449548, 0.245997, 0.2460635, 0.246426, 0.2470527, 0.2485365, 0.250104, 0.252246, 0.2629708, 0.2811158, 0.3005128, 0.3136, 0.3184, 0.31968, 0.3212482, 0.3216, 0.3264, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.138842, 3.186885, 3.199697, 3.218914, 3.266958, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Au': {'mass_absorption_coefficient (cm2/g)': [42705.0, 41481.0, 32469.0, 32352.0, 32341.0, 57837.0, 56718.0, 59861.0, 67392.0, 77054.0, 88504.0, 101290.0, 114780.0, 128180.0, 140530.0, 150790.0, 158010.0, 161410.0, 160580.0, 155490.0, 146550.0, 134520.0, 120340.0, 105070.0, 89725.0, 75109.0, 61791.0, 50114.0, 40190.0, 31965.0, 25284.0, 20477.0, 19938.0, 19396.0, 19120.0, 34412.0, 32653.0, 28930.0, 22850.0, 18036.0, 14260.0, 13546.0, 12851.0, 12673.0, 17817.0, 17073.0, 16498.0, 13697.0, 12769.0, 12228.0, 12088.0, 13428.0, 12854.0, 12797.0, 12757.0, 12191.0, 12044.0, 12810.0, 12253.0, 11335.0, 9286.4, 7773.8, 7375.5, 7129.4, 7068.0, 7166.9, 6959.8, 6900.0, 6215.1, 5861.8, 5834.1, 6093.0, 6623.8, 7423.2, 8456.3, 9678.9, 11029.0, 12425.0, 13774.0, 14979.0, 15954.0, 16631.0, 16972.0, 16964.0, 16902.0, 16833.0, 16812.0, 17137.0, 17061.0, 17011.0, 16983.0, 16876.0, 16845.0, 17051.0, 16934.0, 16734.0, 15983.0, 15052.0, 14006.0, 12905.0, 12203.0, 12120.0, 12037.0, 11954.0, 11871.0, 11788.0, 11706.0, 11624.0, 11542.0, 11460.0, 11378.0, 11296.0, 11215.0, 11134.0, 11053.0, 10972.0, 10892.0, 10811.0, 10798.0, 11427.0, 11401.0, 11319.0, 11237.0, 11156.0, 11074.0, 10994.0, 10913.0, 10833.0, 10753.0, 10673.0, 10594.0, 10515.0, 10437.0, 10359.0, 10281.0, 10203.0, 10126.0, 10049.0, 9973.1, 9897.2, 9821.6, 9746.3, 9671.5, 9597.0, 9522.9, 9449.3, 9376.0, 9303.0, 9230.5, 9158.4, 9086.7, 9015.4, 8944.4, 8918.6, 9005.2, 9000.6, 8930.5, 8860.7, 8791.4, 8722.5, 8653.9, 8585.8, 8518.1, 8450.8, 8383.9, 8317.4, 8251.4, 8185.7, 8120.5, 8055.6, 7991.2, 7927.2, 7863.6, 7800.4, 7737.6, 7675.3, 7613.3, 7551.7, 7490.6, 7429.8, 7369.5, 7309.5, 7250.0, 7190.8, 7132.1, 7073.8, 7015.8, 6958.3, 6940.2, 7054.5, 7051.8, 6994.5, 6937.7, 6881.2, 6825.1, 6769.5, 6714.2, 6659.3, 6604.8, 6550.6, 6496.9, 6443.5, 6390.6, 6338.0, 6285.7, 6233.9, 6182.4, 6131.3, 6080.6, 6030.3, 5980.3, 5930.6, 5881.4, 5832.5, 5783.9, 5735.7, 5687.8, 5640.3, 5593.2, 5546.4, 5499.9, 5453.8, 5408.0, 5362.6, 5317.5, 5272.7, 5228.3, 5184.2, 5140.5, 5097.0, 5053.8, 5010.8, 4968.2, 4925.9, 4883.9, 4842.3, 4801.0, 4759.9, 4719.3, 4678.9, 4638.8, 4599.1, 4559.6, 4520.5, 4481.7, 4443.0, 4399.0, 4355.3, 4312.0, 4269.1, 4226.7, 4184.6, 4143.0, 4101.8, 4061.1, 4020.7, 3980.7, 3941.1, 3901.9, 3863.1, 3824.7, 3786.7, 3749.1, 3711.6, 3674.5, 3637.8, 3601.5, 3565.5, 3529.9, 3494.7, 3459.8, 3425.2, 3391.0, 3357.2, 3323.7, 3290.5, 3257.7, 3225.2, 3193.1, 3161.2, 3129.7, 3098.5, 3067.7, 3037.1, 3006.9, 2977.0, 2947.4, 2918.1, 2889.0, 2860.3, 2831.9, 2803.8, 2776.0, 2748.5, 2721.2, 2694.2, 2667.5, 2640.9, 2614.7, 2588.8, 2563.1, 2537.7, 2512.5, 2487.7, 2461.6, 2435.9, 2410.4, 2385.2, 2360.3, 2335.6, 2311.3, 2287.2, 2263.3, 2239.8, 2216.1, 2192.2, 2168.6, 2145.3, 2122.2, 2099.4, 2076.9, 2054.6, 2032.5, 2010.8, 1989.2, 1968.0, 1946.9, 1926.1, 1905.6, 1885.2, 1865.1, 1845.3, 1825.6, 1806.2, 1786.6, 1766.9, 1747.4, 1728.1, 1709.1, 1690.3, 1671.7, 1653.4, 1635.2, 1616.8, 1598.6, 1580.6, 1562.9, 1545.4, 1528.0, 1511.0, 1494.1, 1477.4, 1460.9, 1444.7, 1428.6, 1412.8, 1397.1, 1381.7, 1366.4, 1351.3, 1336.4, 1321.7, 1307.2, 1292.8, 1278.6, 1264.6, 1250.8, 1237.1, 1223.6, 1210.3, 1197.1, 1184.1, 1171.2, 1158.5, 1146.0, 1133.6, 1121.3, 1109.3, 1097.3, 1085.5, 1073.8, 1062.3, 1050.9, 1039.7, 1028.6, 1017.6, 1006.7, 996.0, 985.39, 974.92, 964.57, 954.34, 944.23, 934.25, 924.38, 914.62, 904.98, 895.46, 886.05, 876.74, 867.55, 858.47, 849.37, 840.32, 835.59, 2503.0, 2491.8, 2461.6, 2431.7, 2402.2, 2373.1, 2344.4, 2316.0, 2287.9, 2284.0, 3345.4, 3314.7, 3274.0, 3233.8, 3194.1, 3154.9, 3116.2, 3078.0, 3040.3, 3003.1, 2966.3, 2930.0, 2894.1, 2858.7, 2823.7, 2789.2, 2755.1, 2721.4, 2688.1, 2655.3, 2622.9, 2590.8, 2559.2, 2528.0, 2497.1, 2466.6, 2436.5, 2406.7, 2377.3, 2348.3, 2319.6, 2291.3, 2263.3, 2235.7, 2208.5, 2181.5, 2155.0, 2152.2, 2490.4, 2475.3, 2446.8, 2418.7, 2390.8, 2363.3, 2336.2, 2309.3, 2282.8, 2256.6, 2230.2, 2204.1, 2178.3, 2152.7, 2127.5, 2102.6, 2078.0, 2053.6, 2029.2, 2003.8, 1978.3, 1953.1, 1928.2, 1903.6, 1879.3, 1855.3, 1831.6, 1808.3, 1794.5, 1903.2, 1898.8, 1879.0, 1855.1, 1831.5, 1808.3, 1785.3, 1762.6, 1740.2, 1718.0, 1696.2, 1674.8, 1653.8, 1633.2, 1612.8, 1592.7, 1572.9, 1553.4, 1545.9, 1601.8, 1597.4, 1582.3, 1563.2, 1544.2, 1525.6, 1507.1, 1488.9, 1471.0, 1453.3, 1435.6, 1418.1, 1400.9, 1383.9, 1367.1, 1350.6, 1334.2, 1318.1, 1302.2, 1286.4, 1270.9, 1255.6, 1240.5, 1225.6, 1210.8, 1196.3, 1181.9, 1167.8, 1153.8, 1140.0, 1126.3, 1112.9, 1099.6, 1086.4, 1073.5, 1060.7, 1048.1, 1035.5, 1023.0, 1010.7, 998.57, 986.57, 974.71, 963.01, 951.45, 940.03, 928.75, 917.61, 906.62, 895.76, 885.03, 874.43, 863.8, 853.09, 842.49, 832.03, 821.7, 811.5, 801.44, 791.5, 781.5, 771.6, 761.83, 752.18, 742.67, 733.28, 724.02, 714.89, 705.87, 696.98, 688.2, 679.54, 671.0, 662.57, 654.25, 646.04, 637.94, 629.95, 622.07, 614.29, 606.61, 599.03, 591.56, 584.18, 576.9, 569.72, 562.64, 555.64, 548.74, 541.93, 535.22, 528.58, 522.04, 515.59, 509.21, 502.93, 496.61, 490.35, 484.16, 478.06, 472.04, 466.1, 460.24, 454.45, 448.75, 443.12, 437.56, 432.08, 426.67, 421.33, 416.06, 410.87, 405.74, 400.68, 395.69, 390.76, 385.9, 381.1, 376.37, 371.7, 367.09, 362.54, 358.05, 353.59, 349.14, 344.76, 340.43, 336.16, 331.94, 327.78, 323.68, 319.63, 315.63, 311.68, 307.77, 303.92, 300.11, 296.36, 292.65, 288.99, 285.38, 281.81, 278.28, 274.79, 271.36, 267.96, 264.62, 261.31, 258.06, 254.84, 251.67, 248.53, 245.44, 242.39, 239.38, 236.41, 233.48, 230.59, 227.73, 224.91, 222.13, 219.39, 216.68, 214.0, 211.36, 208.76, 206.19, 203.65, 201.15, 198.68, 196.24, 193.83, 191.45, 189.11, 186.79, 184.51, 182.25, 180.02, 177.83, 175.66, 173.52, 171.4, 169.31, 167.25, 165.22, 143.66, 120.3, 100.52, 84.034, 72.211, 70.399, 69.374, 68.636, 179.11, 171.88, 155.38, 129.77, 129.3, 124.47, 123.1, 169.97, 163.25, 161.45, 154.91, 153.23, 175.29, 174.74, 168.27, 147.84, 124.38, 104.63, 87.922, 73.837, 62.033, 52.143, 43.824, 36.825, 30.736, 25.548, 21.235, 17.664, 14.705, 12.252, 10.216, 8.5253, 7.12, 5.9502, 4.966, 4.1473, 3.4596, 2.8765, 2.3924, 1.9904, 1.8073, 1.7326, 1.7127, 8.2842, 8.1479, 7.9759, 6.8623, 5.7711, 4.8446, 4.0647, 3.4096, 2.8537, 2.3879, 1.998, 1.6718, 1.399, 1.1705, 0.97838, 0.81787, 0.68376, 0.5717, 0.47805, 0.39978, 0.33435, 0.27966, 0.23393, 0.1957, 0.16372, 0.13699, 0.11462, 0.095918, 0.0],
                    'energies (keV)': [0.006824268, 0.006926123, 0.008142217, 0.008266843, 0.008300076, 0.008349926, 0.008474552, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.052626, 0.05302035, 0.0534315, 0.0536463, 0.0539685, 0.054774, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.070266, 0.0713415, 0.0716283, 0.0720585, 0.073134, 0.07401695, 0.07912411, 0.081144, 0.082386, 0.0827172, 0.083214, 0.084456, 0.08458368, 0.084672, 0.085968, 0.0863136, 0.086832, 0.088128, 0.09041995, 0.09665893, 0.1033284, 0.105644, 0.107261, 0.1076922, 0.108339, 0.109956, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.327222, 0.3322305, 0.3335661, 0.3355695, 0.340578, 0.3434143, 0.34496, 0.35024, 0.351648, 0.35376, 0.35904, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4794098, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.5334931, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54469646, 0.54610359, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64278595, 0.64461406, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.75759354, 0.76000652, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.8872931, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0408331, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2051132, 2.2062866, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.2904585, 2.2917415, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7404353, 2.7455647, 2.7527269, 2.7664905, 2.780323, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1431727, 3.1495376, 3.1524272, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.417742, 3.4282291, 3.4320581, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3122972, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.68033, 11.79334, 11.85911, 11.90678, 11.97829, 12.15707, 12.60708, 13.45893, 13.47697, 13.66493, 13.71987, 13.80227, 14.00827, 14.06574, 14.28104, 14.33845, 14.40688, 14.42456, 14.63986, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 79.1104, 80.32127, 80.64417, 81.12852, 81.6564, 82.3394, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'At': {'mass_absorption_coefficient (cm2/g)': [181600.0, 176050.0, 92600.0, 90020.0, 89349.0, 180270.0, 176140.0, 138860.0, 123960.0, 109980.0, 96900.0, 84748.0, 73553.0, 63344.0, 54135.0, 45921.0, 41591.0, 39984.0, 39568.0, 46307.0, 45929.0, 44278.0, 37503.0, 30568.0, 24895.0, 20251.0, 16456.0, 13359.0, 10839.0, 8792.2, 7134.0, 6333.5, 6040.9, 5966.0, 8879.9, 8979.1, 9378.2, 13473.0, 13960.0, 16157.0, 16835.0, 19804.0, 23207.0, 29438.0, 54527.0, 84849.0, 110030.0, 121800.0, 118240.0, 103300.0, 83163.0, 63030.0, 45819.0, 32464.0, 22725.0, 15892.0, 11201.0, 9713.8, 9001.0, 8823.0, 11443.0, 10757.0, 10697.0, 8017.1, 6103.8, 4775.4, 4679.7, 4444.4, 4385.3, 5885.5, 5595.8, 5220.3, 4232.6, 3498.2, 2949.0, 2737.5, 2645.8, 2622.5, 2747.1, 2740.5, 2693.4, 2666.4, 2658.2, 2637.3, 2807.7, 2784.8, 2769.1, 2751.0, 2743.9, 2876.3, 2885.9, 2888.1, 3165.9, 3857.6, 4954.1, 6394.9, 8047.6, 9735.9, 11281.0, 12536.0, 13410.0, 13869.0, 13928.0, 13637.0, 13340.0, 13199.0, 13160.0, 13900.0, 13868.0, 13760.0, 13441.0, 13385.0, 13329.0, 13273.0, 13215.0, 13157.0, 13098.0, 13038.0, 12977.0, 12916.0, 12855.0, 12792.0, 12729.0, 12681.0, 13101.0, 13099.0, 13039.0, 12978.0, 12915.0, 12852.0, 12789.0, 12725.0, 12660.0, 12595.0, 12530.0, 12464.0, 12398.0, 12331.0, 12264.0, 12197.0, 12129.0, 12061.0, 11993.0, 11925.0, 11856.0, 11787.0, 11718.0, 11649.0, 11579.0, 11509.0, 11439.0, 11369.0, 11298.0, 11227.0, 11157.0, 11086.0, 11015.0, 10943.0, 10872.0, 10801.0, 10729.0, 10658.0, 10587.0, 10515.0, 10444.0, 10372.0, 10301.0, 10229.0, 10158.0, 10087.0, 10015.0, 9944.0, 9872.9, 9801.9, 9731.1, 9660.4, 9589.9, 9519.6, 9449.4, 9379.5, 9309.7, 9240.2, 9170.9, 9101.8, 9032.9, 8964.3, 8896.0, 8828.0, 8760.2, 8692.7, 8625.5, 8604.7, 9103.6, 9096.6, 9027.9, 8959.4, 8891.3, 8823.6, 8756.2, 8689.1, 8622.3, 8555.9, 8489.8, 8423.9, 8358.5, 8293.4, 8228.6, 8164.2, 8100.2, 8036.6, 7971.2, 7905.9, 7841.0, 7776.4, 7712.2, 7648.3, 7584.8, 7521.7, 7459.0, 7396.6, 7334.7, 7273.1, 7212.0, 7151.2, 7090.9, 7031.0, 6971.6, 6912.5, 6853.9, 6831.4, 6888.9, 6887.3, 6831.1, 6773.8, 6716.9, 6659.4, 6602.1, 6545.2, 6488.8, 6432.9, 6377.3, 6322.2, 6267.6, 6213.3, 6159.6, 6106.3, 6053.4, 6001.0, 5949.1, 5897.6, 5846.5, 5796.0, 5745.9, 5696.2, 5647.0, 5597.9, 5535.4, 5473.7, 5412.7, 5352.5, 5293.0, 5234.2, 5176.2, 5120.8, 5118.8, 5196.5, 5167.1, 5110.7, 5055.0, 4999.9, 4945.6, 4891.8, 4838.8, 4786.4, 4734.6, 4683.4, 4632.8, 4582.9, 4533.5, 4484.7, 4436.5, 4388.9, 4341.9, 4295.4, 4249.5, 4204.1, 4159.3, 4115.0, 4071.2, 4028.0, 3985.2, 3943.0, 3901.3, 3860.0, 3819.3, 3779.0, 3739.3, 3699.9, 3661.1, 3622.7, 3584.8, 3547.3, 3510.1, 3473.1, 3436.6, 3400.4, 3364.7, 3329.4, 3294.5, 3260.1, 3226.0, 3192.3, 3159.0, 3126.1, 3093.6, 3061.5, 3029.7, 2998.3, 2967.2, 2936.5, 2906.1, 2876.0, 2846.3, 2817.0, 2787.9, 2759.2, 2730.9, 2702.8, 2675.1, 2647.7, 2620.6, 2593.8, 2567.3, 2541.2, 2515.3, 2489.7, 2464.4, 2439.4, 2414.7, 2390.1, 2365.8, 2341.7, 2317.9, 2294.4, 2271.2, 2248.2, 2225.4, 2203.0, 2180.7, 2158.8, 2137.0, 2115.6, 2094.3, 2073.3, 2052.5, 2032.0, 2011.7, 1991.6, 1971.7, 1952.0, 1932.6, 1913.4, 1894.4, 1875.6, 1857.0, 1838.6, 1820.5, 1802.5, 1784.7, 1767.1, 1749.7, 1732.5, 1715.5, 1698.7, 1682.1, 1665.6, 1649.3, 1633.2, 1617.3, 1601.5, 1586.0, 1570.6, 1555.3, 1540.2, 1525.3, 1510.6, 1495.8, 1480.4, 1465.2, 1450.2, 1435.3, 1420.6, 1406.0, 1391.7, 1377.4, 1363.4, 1349.5, 1335.7, 1322.1, 1308.7, 1295.4, 1282.2, 1269.2, 1256.3, 1243.6, 1230.9, 1218.4, 1206.1, 1193.8, 1181.7, 1169.1, 1156.8, 1144.5, 1132.4, 1120.4, 1108.6, 1096.9, 1085.4, 1073.9, 1062.6, 1051.5, 1040.4, 1029.5, 1018.7, 1008.0, 997.46, 987.02, 976.7, 966.49, 956.4, 946.43, 936.56, 926.81, 917.16, 907.62, 898.19, 888.87, 879.65, 870.53, 861.51, 852.59, 843.78, 835.06, 826.43, 817.91, 809.48, 801.14, 792.89, 784.74, 776.67, 768.68, 760.78, 752.97, 745.24, 737.6, 730.04, 722.57, 715.18, 707.87, 700.64, 693.49, 686.42, 679.42, 676.63, 1869.1, 1857.4, 1833.5, 1809.9, 1786.6, 1763.7, 1741.0, 1718.7, 1696.6, 1674.8, 2455.5, 2424.5, 2390.0, 2356.1, 2322.7, 2289.7, 2257.2, 2224.4, 2191.8, 2159.8, 2128.7, 2098.9, 2069.7, 2041.0, 2012.8, 1985.1, 1958.0, 1931.3, 1905.0, 1879.2, 1853.9, 1828.9, 1804.4, 1780.3, 1756.6, 1733.2, 1710.3, 1687.6, 1665.4, 1643.4, 1621.8, 1600.6, 1579.6, 1566.4, 1840.1, 1837.6, 1815.5, 1791.3, 1767.4, 1743.8, 1720.6, 1697.7, 1675.1, 1652.8, 1630.8, 1609.6, 1589.1, 1568.5, 1548.3, 1528.4, 1508.8, 1489.5, 1470.5, 1451.7, 1433.3, 1415.0, 1396.7, 1378.8, 1361.0, 1343.6, 1326.4, 1309.4, 1292.7, 1276.2, 1260.0, 1244.0, 1228.2, 1227.4, 1306.7, 1300.0, 1283.0, 1266.3, 1249.8, 1233.5, 1217.5, 1201.6, 1186.0, 1170.6, 1155.5, 1141.0, 1126.7, 1112.7, 1098.9, 1087.9, 1085.3, 1124.7, 1119.7, 1106.1, 1092.8, 1079.7, 1066.7, 1053.9, 1041.2, 1028.5, 1016.0, 1003.6, 991.39, 979.35, 967.46, 955.73, 944.16, 932.74, 921.47, 910.34, 899.36, 888.53, 877.83, 867.27, 856.84, 846.55, 836.4, 826.37, 816.46, 806.69, 797.04, 787.51, 778.09, 768.8, 759.63, 750.56, 741.61, 732.78, 724.05, 715.42, 706.76, 698.2, 689.75, 681.4, 673.15, 665.01, 656.96, 649.02, 641.17, 633.41, 625.75, 618.19, 610.72, 603.23, 595.75, 588.34, 581.04, 573.82, 566.7, 559.67, 552.72, 545.87, 539.01, 532.23, 525.54, 518.94, 512.42, 505.99, 499.65, 493.38, 487.2, 481.1, 475.08, 469.14, 463.27, 457.49, 451.78, 446.14, 440.58, 435.09, 429.67, 424.32, 419.05, 413.84, 408.7, 403.63, 398.63, 393.69, 388.82, 384.01, 379.26, 374.58, 369.96, 365.4, 360.89, 356.39, 351.95, 347.57, 343.24, 338.98, 334.77, 330.61, 326.51, 322.47, 318.47, 314.53, 310.64, 306.81, 303.02, 299.28, 295.6, 291.96, 288.37, 284.82, 281.32, 277.87, 274.46, 271.1, 267.78, 264.51, 261.28, 258.09, 254.94, 251.84, 248.77, 245.75, 242.74, 239.77, 236.84, 233.95, 231.09, 228.27, 225.49, 222.74, 220.03, 217.35, 214.71, 212.11, 209.53, 182.11, 152.29, 127.53, 106.94, 89.828, 75.433, 63.285, 58.063, 55.806, 55.225, 139.04, 135.93, 133.68, 113.61, 94.68, 91.045, 90.05, 124.91, 120.09, 119.67, 114.94, 113.72, 129.59, 129.24, 124.84, 109.1, 91.848, 77.321, 65.082, 54.783, 46.142, 38.643, 32.254, 26.936, 22.502, 18.745, 15.612, 13.013, 10.855, 9.0616, 7.5702, 6.3289, 5.2952, 4.431, 3.7042, 3.0994, 2.5915, 2.1559, 1.7842, 1.4777, 1.4555, 1.3946, 1.3789, 6.3594, 6.1242, 5.7996, 4.8876, 4.1131, 3.4579, 2.9062, 2.4405, 2.0473, 1.7173, 1.4406, 1.2086, 1.014, 0.85087, 0.71405, 0.59929, 0.50303, 0.42228, 0.35453, 0.29768, 0.24997, 0.20993, 0.17632, 0.1481, 0.12441, 0.0],
                    'energies (keV)': [0.006275726, 0.006369394, 0.008850419, 0.008985884, 0.009022009, 0.009076195, 0.00921166, 0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.0189522, 0.01924229, 0.01931964, 0.01943568, 0.01948844, 0.01972576, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03690857, 0.0374735, 0.03762415, 0.03785012, 0.03797993, 0.03841505, 0.04060054, 0.04076232, 0.04138623, 0.04155261, 0.04180217, 0.04242608, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1062575, 0.1078839, 0.1083176, 0.1089681, 0.1104581, 0.1105945, 0.1180797, 0.1262272, 0.1349368, 0.1357294, 0.1378069, 0.1383609, 0.1391919, 0.1412694, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1819046, 0.1846888, 0.1854313, 0.186545, 0.1867657, 0.1883732, 0.1893292, 0.1896243, 0.1903866, 0.1915301, 0.1931341, 0.1943887, 0.1960902, 0.1968785, 0.198061, 0.2010171, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.4484657, 0.4658769, 0.4730077, 0.4749092, 0.4777615, 0.4794098, 0.4848923, 0.5, 0.5025, 0.5050125, 0.50753756, 0.51007525, 0.51262563, 0.51518875, 0.5177647, 0.52035352, 0.52295529, 0.52557007, 0.52819792, 0.53083891, 0.53281612, 0.5334931, 0.53358393, 0.53616057, 0.53884137, 0.54153558, 0.54424325, 0.54696447, 0.54969929, 0.55244779, 0.55521003, 0.55798608, 0.56077601, 0.56357989, 0.56639779, 0.56922978, 0.57207593, 0.5749363, 0.57781099, 0.58070004, 0.58360354, 0.58652156, 0.58945417, 0.59240144, 0.59536345, 0.59834026, 0.60133196, 0.60433862, 0.60736032, 0.61039712, 0.6134491, 0.61651635, 0.61959893, 0.62269693, 0.62581041, 0.62893946, 0.63208416, 0.63524458, 0.6384208, 0.64161291, 0.64482097, 0.64804508, 0.6512853, 0.65454173, 0.65781444, 0.66110351, 0.66440903, 0.66773107, 0.67106973, 0.67442508, 0.6777972, 0.68118619, 0.68459212, 0.68801508, 0.69145515, 0.69491243, 0.69838699, 0.70187893, 0.70538832, 0.70891526, 0.71245984, 0.71602214, 0.71960225, 0.72320026, 0.72681626, 0.73045034, 0.7341026, 0.73777311, 0.73891221, 0.74108781, 0.74146197, 0.74516928, 0.74889513, 0.75263961, 0.7564028, 0.76018482, 0.76398574, 0.76780567, 0.7716447, 0.77550292, 0.77938044, 0.78327734, 0.78719373, 0.79112969, 0.79508534, 0.79906077, 0.80305607, 0.80707135, 0.81110671, 0.81516224, 0.81923806, 0.82333425, 0.82745092, 0.83158817, 0.83574611, 0.83992484, 0.84412447, 0.84834509, 0.85258682, 0.85684975, 0.861134, 0.86543967, 0.86976687, 0.8741157, 0.87848628, 0.88287871, 0.88458238, 0.8872931, 0.88741758, 0.89172957, 0.89618822, 0.90066916, 0.9051725, 0.90969837, 0.91424686, 0.91881809, 0.92341218, 0.92802924, 0.93266939, 0.93733274, 0.9420194, 0.9467295, 0.95146315, 0.95622046, 0.96100156, 0.96580657, 0.9706356, 0.97548878, 0.98036623, 0.98526806, 0.9901944, 0.99514537, 1.0001211, 1.0051217, 1.0101473, 1.015198, 1.020274, 1.0253754, 1.0305023, 1.0356548, 1.0406559, 1.0408331, 1.0433442, 1.0460372, 1.0512674, 1.0565238, 1.0618064, 1.0671154, 1.072451, 1.0778132, 1.0832023, 1.0886183, 1.0940614, 1.0995317, 1.1050294, 1.1105545, 1.1161073, 1.1216878, 1.1272963, 1.1329328, 1.1385974, 1.1442904, 1.1500119, 1.1557619, 1.1615407, 1.1673484, 1.1731852, 1.1790511, 1.1849464, 1.1908711, 1.1968254, 1.2028096, 1.2088236, 1.2148677, 1.2209421, 1.2270468, 1.233182, 1.2393479, 1.2455447, 1.2517724, 1.2580312, 1.2643214, 1.270643, 1.2769962, 1.2833812, 1.2897981, 1.2962471, 1.3027283, 1.309242, 1.3157882, 1.3223671, 1.328979, 1.3356239, 1.342302, 1.3490135, 1.3557586, 1.3625374, 1.36935, 1.3761968, 1.3830778, 1.3899932, 1.3969431, 1.4039278, 1.4109475, 1.4180022, 1.4250922, 1.4322177, 1.4393788, 1.4465757, 1.4538086, 1.4610776, 1.468383, 1.4757249, 1.4831035, 1.490519, 1.4979716, 1.5054615, 1.5129888, 1.5205537, 1.5281565, 1.5357973, 1.5434763, 1.5511937, 1.5589496, 1.5667444, 1.5745781, 1.582451, 1.5903633, 1.5983151, 1.6063066, 1.6143382, 1.6224099, 1.6305219, 1.6386745, 1.6468679, 1.6551022, 1.6633777, 1.6716946, 1.6800531, 1.6884534, 1.6968956, 1.7053801, 1.713907, 1.7224766, 1.7310889, 1.7397444, 1.7484431, 1.7571853, 1.7659712, 1.7748011, 1.7836751, 1.7925935, 1.8015565, 1.8105642, 1.8196171, 1.8287151, 1.8378587, 1.847048, 1.8562833, 1.8655647, 1.8748925, 1.884267, 1.8936883, 1.9031567, 1.9126725, 1.9222359, 1.9318471, 1.9415063, 1.9512138, 1.9609699, 1.9707747, 1.9806286, 1.9905318, 2.0004844, 2.0104868, 2.0205393, 2.030642, 2.0407952, 2.0509992, 2.0612542, 2.0715604, 2.0819182, 2.0923278, 2.1027895, 2.1133034, 2.1238699, 2.1344893, 2.1451617, 2.1558875, 2.166667, 2.1775003, 2.1883878, 2.1993297, 2.2103264, 2.221378, 2.2324849, 2.2436473, 2.2548656, 2.2661399, 2.2774706, 2.2888579, 2.3003022, 2.3118037, 2.3233628, 2.3349796, 2.3466545, 2.3583878, 2.3701797, 2.3820306, 2.3939407, 2.4059104, 2.41794, 2.4300297, 2.4421798, 2.4543907, 2.4666627, 2.478996, 2.491391, 2.5038479, 2.5163672, 2.528949, 2.5415938, 2.5543017, 2.5670732, 2.5799086, 2.5928082, 2.6057722, 2.6188011, 2.6318951, 2.6450545, 2.6582798, 2.6715712, 2.6849291, 2.6983537, 2.7118455, 2.7254047, 2.7390317, 2.7527269, 2.7664905, 2.780323, 2.7859225, 2.7874775, 2.7942246, 2.8081957, 2.8222367, 2.8363479, 2.8505296, 2.8647823, 2.8791062, 2.8935017, 2.9079692, 2.9095697, 2.9225091, 2.9371216, 2.9518072, 2.9665662, 2.9813991, 2.9963061, 3.0112876, 3.026344, 3.0414758, 3.0566831, 3.0719666, 3.0873264, 3.102763, 3.1182768, 3.1338682, 3.1495376, 3.1652853, 3.1811117, 3.1970172, 3.2130023, 3.2290673, 3.2452127, 3.2614387, 3.2777459, 3.2941347, 3.3106053, 3.3271584, 3.3437941, 3.3605131, 3.3773157, 3.3942023, 3.4111733, 3.4220602, 3.4282291, 3.42994, 3.4453703, 3.4625971, 3.4799101, 3.4973097, 3.5147962, 3.5323702, 3.5500321, 3.5677822, 3.5856211, 3.6035492, 3.621567, 3.6396748, 3.6578732, 3.6761626, 3.6945434, 3.7130161, 3.7315812, 3.7502391, 3.7689903, 3.7878352, 3.8067744, 3.8258083, 3.8449373, 3.864162, 3.8834828, 3.9029002, 3.9224147, 3.9420268, 3.9617369, 3.9815456, 4.0014533, 4.0023486, 4.0136512, 4.0214606, 4.0415679, 4.0617757, 4.0820846, 4.102495, 4.1230075, 4.1436226, 4.1643407, 4.1851624, 4.2060882, 4.2271186, 4.2482542, 4.2694955, 4.290843, 4.3080637, 4.3122972, 4.3259361, 4.3338587, 4.355528, 4.3773056, 4.3991921, 4.4211881, 4.443294, 4.4655105, 4.4878381, 4.5102772, 4.5328286, 4.5554928, 4.5782702, 4.6011616, 4.6241674, 4.6472882, 4.6705247, 4.6938773, 4.7173467, 4.7409334, 4.7646381, 4.7884613, 4.8124036, 4.8364656, 4.8606479, 4.8849512, 4.9093759, 4.9339228, 4.9585924, 4.9833854, 5.0083023, 5.0333438, 5.0585105, 5.0838031, 5.1092221, 5.1347682, 5.1604421, 5.1862443, 5.2121755, 5.2382364, 5.2644276, 5.2907497, 5.3172034, 5.3437895, 5.3705084, 5.3973609, 5.4243477, 5.4514695, 5.4787268, 5.5061205, 5.5336511, 5.5613193, 5.5891259, 5.6170716, 5.6451569, 5.6733827, 5.7017496, 5.7302584, 5.7589096, 5.7877042, 5.8166427, 5.8457259, 5.8749546, 5.9043293, 5.933851, 5.9635202, 5.9933378, 6.0233045, 6.053421, 6.0836882, 6.1141066, 6.1446771, 6.1754005, 6.2062775, 6.2373089, 6.2684954, 6.2998379, 6.3313371, 6.3629938, 6.3948088, 6.4267828, 6.4589167, 6.4912113, 6.5236674, 6.5562857, 6.5890671, 6.6220125, 6.6551225, 6.6883981, 6.7218401, 6.7554493, 6.7892266, 6.8231727, 6.8572886, 6.891575, 6.9260329, 6.9606631, 6.9954664, 7.0304437, 7.0655959, 7.1009239, 7.1364285, 7.1721107, 7.2079712, 7.2440111, 7.2802311, 7.3166323, 7.3532155, 7.3899815, 7.4269314, 7.4640661, 7.5013864, 7.5388934, 7.5765878, 7.6144708, 7.6525431, 7.6908058, 7.7292599, 7.7679062, 7.8067457, 7.8457794, 7.8850083, 7.9244334, 7.9640555, 8.0038758, 8.0438952, 8.0841147, 8.1245352, 8.1651579, 8.2059837, 8.2470136, 8.2882487, 8.3296899, 8.3713384, 8.4131951, 8.455261, 8.4975373, 8.540025, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 13.92923, 14.14243, 14.19929, 14.28457, 14.40688, 14.49777, 15.40095, 16.46362, 16.70078, 16.76792, 16.86862, 17.12039, 17.14314, 17.40554, 17.47551, 17.58047, 17.59961, 17.84286, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 93.8153, 95.25125, 95.63417, 96.20855, 97.64449, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'In': {'mass_absorption_coefficient (cm2/g)': [43466.0, 43615.0, 43934.0, 44767.0, 47567.0, 52566.0, 59521.0, 68209.0, 78321.0, 89394.0, 100800.0, 111760.0, 121440.0, 129040.0, 133940.0, 135730.0, 134330.0, 129940.0, 123010.0, 114140.0, 104000.0, 93237.0, 82413.0, 71968.0, 62231.0, 58880.0, 56867.0, 56344.0, 66368.0, 63716.0, 63326.0, 52700.0, 44030.0, 37066.0, 31393.0, 26740.0, 22910.0, 22315.0, 21567.0, 21375.0, 21902.0, 21226.0, 20568.0, 17971.0, 15813.0, 14007.0, 12486.0, 11195.0, 10090.0, 9134.7, 8301.0, 7565.4, 6909.6, 6319.1, 5782.7, 5291.7, 4858.9, 4460.1, 4087.4, 3738.9, 3412.9, 3252.9, 3184.2, 3175.1, 3166.2, 14531.0, 14448.0, 14446.0, 14400.0, 22034.0, 21992.0, 21736.0, 21032.0, 19833.0, 18282.0, 16548.0, 14788.0, 13790.0, 13412.0, 13314.0, 14983.0, 14919.0, 14601.0, 14210.0, 13834.0, 13736.0, 14330.0, 13996.0, 13969.0, 12428.0, 11104.0, 10871.0, 10766.0, 10679.0, 11028.0, 10705.0, 9931.9, 8672.7, 7570.4, 6504.6, 5582.9, 4777.9, 4084.9, 3493.3, 2985.0, 2550.0, 2179.6, 1858.7, 1576.2, 1338.7, 1138.9, 970.33, 828.02, 706.54, 600.98, 505.04, 420.25, 349.81, 322.52, 309.44, 306.08, 1056.8, 1019.4, 1010.1, 967.28, 923.79, 913.3, 1252.8, 1200.4, 1168.3, 1092.3, 1047.9, 1036.6, 1178.8, 1135.1, 1126.7, 953.36, 807.57, 681.12, 573.05, 481.42, 404.37, 339.74, 285.63, 239.8, 201.2, 168.26, 139.56, 115.87, 96.285, 80.086, 66.667, 55.505, 46.244, 38.567, 32.147, 26.734, 22.197, 18.389, 15.248, 12.654, 10.511, 8.7392, 7.7493, 7.4078, 7.3202, 46.316, 46.303, 44.496, 38.732, 32.433, 27.171, 22.753, 18.985, 15.834, 13.2, 11.001, 9.166, 7.6367, 6.3415, 5.2583, 4.3605, 3.6163, 2.9993, 2.4839, 2.05, 1.692, 1.3966, 1.1528, 0.95167, 0.78562, 0.6482, 0.53485, 0.44135, 0.36421, 0.30057, 0.24806, 0.20473, 0.16898, 0.13948, 0.11514, 0.095043, 0.07846, 0.064773, 0.053476, 0.044151, 0.036453, 0.030099, 0.024853, 0.020522, 0.0],
                    'energies (keV)': [0.016281, 0.016524, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.06477028, 0.06923942, 0.07401695, 0.075852, 0.077013, 0.0773226, 0.077787, 0.078948, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.119462, 0.1212905, 0.1217781, 0.1225095, 0.124338, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.2301188, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.3924405, 0.4195189, 0.434238, 0.4408845, 0.441784, 0.4426569, 0.4453155, 0.4484657, 0.448546, 0.4503492, 0.451962, 0.453054, 0.459816, 0.4794098, 0.5124891, 0.5478508, 0.5856525, 0.6260625, 0.651014, 0.6609785, 0.6636357, 0.6676215, 0.6692609, 0.677586, 0.688156, 0.698689, 0.7014978, 0.705711, 0.7154399, 0.716244, 0.7648052, 0.809088, 0.8175768, 0.821472, 0.8247744, 0.829728, 0.842112, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.541848, 2.717235, 2.904724, 3.10515, 3.319406, 3.548445, 3.655498, 3.711449, 3.72637, 3.74875, 3.793288, 3.804702, 3.85924, 3.91831, 3.934062, 3.95769, 4.01676, 4.055024, 4.15275, 4.216313, 4.233263, 4.258688, 4.32225, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 20.11215, 21.49988, 22.98338, 24.56923, 26.2645, 27.3811, 27.8002, 27.91196, 28.07676, 28.0796, 28.4987, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]},
             'Mo': {'mass_absorption_coefficient (cm2/g)': [173430.0, 167340.0, 160950.0, 154290.0, 147410.0, 140360.0, 133210.0, 126000.0, 118800.0, 111660.0, 104640.0, 97787.0, 91140.0, 84736.0, 78604.0, 72768.0, 67243.0, 62040.0, 59921.0, 58489.0, 58115.0, 149980.0, 141270.0, 110500.0, 87909.0, 71394.0, 58993.0, 49441.0, 41912.0, 35857.0, 30904.0, 29929.0, 29671.0, 30231.0, 29332.0, 27778.0, 24404.0, 21550.0, 19109.0, 17008.0, 15187.0, 13601.0, 12212.0, 10992.0, 9915.4, 8962.5, 8116.2, 7362.1, 6687.2, 6081.0, 5534.7, 5040.7, 4592.6, 4184.9, 3997.5, 3917.9, 3913.7, 3891.9, 6998.8, 7068.6, 7137.8, 9370.5, 9382.6, 9865.0, 11817.0, 15689.0, 19607.0, 22799.0, 24811.0, 25514.0, 25047.0, 24184.0, 23826.0, 23726.0, 26442.0, 26317.0, 25900.0, 25801.0, 25344.0, 25219.0, 26172.0, 25690.0, 25561.0, 23236.0, 20819.0, 19705.0, 19166.0, 19025.0, 19643.0, 19268.0, 19117.0, 16990.0, 14902.0, 13020.0, 11344.0, 9855.4, 8542.3, 7393.9, 6389.6, 5514.3, 4754.7, 4031.2, 3420.2, 2904.7, 2469.7, 2102.3, 1791.8, 1527.6, 1296.6, 1100.4, 935.2, 795.29, 676.58, 576.26, 526.24, 507.52, 502.69, 1928.7, 1909.3, 1845.6, 1768.2, 1748.3, 2399.9, 2304.9, 2215.8, 2033.5, 1956.5, 1936.7, 2194.8, 2149.1, 2116.9, 1821.7, 1537.7, 1292.1, 1084.6, 911.21, 766.02, 644.24, 542.28, 454.78, 380.28, 317.51, 265.19, 221.7, 185.5, 155.19, 129.92, 108.62, 90.127, 74.827, 62.152, 51.472, 42.598, 35.156, 29.042, 24.013, 19.871, 16.459, 13.644, 12.168, 11.663, 11.533, 79.499, 76.366, 66.041, 55.42, 46.603, 39.141, 32.644, 27.187, 22.646, 18.866, 15.718, 13.097, 10.855, 8.9758, 7.4226, 6.1386, 5.077, 4.1989, 3.4719, 2.8696, 2.3719, 1.9607, 1.6186, 1.3318, 1.0941, 0.89895, 0.73863, 0.60693, 0.49874, 0.40985, 0.33682, 0.27681, 0.22751, 0.18699, 0.1537, 0.12634, 0.10385, 0.08537, 0.07018, 0.057695, 0.047433, 0.038997, 0.032063, 0.026362, 0.021676, 0.017823, 0.014656, 0.012051, 0.0],
                    'energies (keV)': [0.01069, 0.01142761, 0.01221612, 0.01305903, 0.0139601, 0.01492335, 0.01595306, 0.01705382, 0.01823053, 0.01948844, 0.02083314, 0.02227063, 0.0238073, 0.02545001, 0.02720606, 0.02908327, 0.03109002, 0.03323523, 0.034104, 0.034626, 0.0347652, 0.034974, 0.03552846, 0.03797993, 0.04060054, 0.04340198, 0.04639671, 0.04959809, 0.05302035, 0.05667876, 0.06058959, 0.061491, 0.0617382, 0.062109, 0.063036, 0.06477028, 0.06923942, 0.07401695, 0.07912411, 0.08458368, 0.09041995, 0.09665893, 0.1033284, 0.1104581, 0.1180797, 0.1262272, 0.1349368, 0.1442475, 0.1542005, 0.1648404, 0.1762144, 0.1883732, 0.2013709, 0.2152655, 0.22246, 0.225694, 0.225865, 0.226773, 0.228135, 0.2291485, 0.2301188, 0.2314515, 0.23154, 0.234906, 0.245997, 0.2629708, 0.2811158, 0.3005128, 0.3212482, 0.3434143, 0.3671099, 0.384454, 0.3903385, 0.3919077, 0.3924405, 0.3942615, 0.400146, 0.401506, 0.4076515, 0.4092903, 0.4117485, 0.417894, 0.4195189, 0.4484657, 0.4794098, 0.494508, 0.502077, 0.5040954, 0.507123, 0.5124891, 0.514692, 0.5478508, 0.5856525, 0.6260625, 0.6692609, 0.7154399, 0.7648052, 0.8175768, 0.8739896, 0.9342948, 0.9987612, 1.067676, 1.141345, 1.220098, 1.304285, 1.394281, 1.490486, 1.593329, 1.703269, 1.820795, 1.94643, 2.080733, 2.224304, 2.377781, 2.469796, 2.507599, 2.51768, 2.532801, 2.541848, 2.572598, 2.611974, 2.622475, 2.638225, 2.677602, 2.717235, 2.80819, 2.851172, 2.862634, 2.879827, 2.904724, 2.92281, 3.10515, 3.319406, 3.548445, 3.793288, 4.055024, 4.334821, 4.633924, 4.953664, 5.295467, 5.660855, 6.051453, 6.469004, 6.915365, 7.392525, 7.902609, 8.44789, 9.030794, 9.653919, 10.32004, 11.03212, 11.79334, 12.60708, 13.47697, 14.40688, 15.40095, 16.46362, 17.59961, 18.81398, 19.59951, 19.8995, 19.9795, 20.11215, 20.39949, 21.49988, 22.98338, 24.56923, 26.2645, 28.07676, 30.01405, 32.08502, 34.29889, 36.66551, 39.19543, 41.89992, 44.79101, 47.88159, 51.18542, 54.71721, 58.4927, 62.5287, 66.84318, 71.45536, 76.38578, 81.6564, 87.29069, 93.31374, 99.75239, 106.6353, 113.9931, 121.8587, 130.2669, 139.2553, 148.864, 159.1356, 170.1159, 181.8539, 194.4018, 207.8156, 222.1548, 237.4835, 253.8699, 271.3869, 290.1126, 310.1304, 331.5294, 354.4049, 378.8588, 405.0001, 432.9451, 0.0]}}

ffast_mac_db = utils.DictionaryTreeBrowser(ffast_mac)
