import numpy as np
import matplotlib.pyplot as plt
import Pyro5.api

TT = Pyro5.api.Proxy("PYRO:TimeTagger@localhost:23000")

# Create Time Tagger
tagger = TT.createTimeTagger()
tagger.setTestSignal(1, True)
tagger.setTestSignal(2, True)

print('Time Tagger serial:', tagger.getSerial())

hist = TT.Correlation(tagger, 1, 2, binwidth=5, n_bins=2000)
hist.startFor(int(10e12), clear=True)

fig, ax = plt.subplots()
h, = ax.plot([], [])
# the time vector is fixed. No need to read it on every iteration
x = hist.getIndex()
while hist.isRunning():
    plt.pause(0.1)
    y = hist.getData()
    h.set_data(x, y)
    ax.set_xlim(np.min(x), np.max(x))
    ax.set_ylim(np.min(y), np.max(y))

# Cleanup
TT.freeTimeTagger(tagger)
del hist
del tagger
del TT