/*!
 * Copyright (c) 2012 - 2022, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
const main = (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.lenght-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
/* main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(2) /* ./index */, exports);
    // TODO: remove this when models are split up from core
    require(70) /* ./models/main */;
},
/* tslib/tslib.es6.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) {
                for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p];
            };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    exports.__extends = __extends;
    var __assign = function () {
        exports.__assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return exports.__assign.apply(this, arguments);
    };
    exports.__assign = __assign;
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    exports.__rest = __rest;
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    exports.__decorate = __decorate;
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    exports.__param = __param;
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    exports.__metadata = __metadata;
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
                try {
                    step(generator.next(value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function rejected(value) {
                try {
                    step(generator["throw"](value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    exports.__awaiter = __awaiter;
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () {
                if (t[0] & 1)
                    throw t[1];
                return t[1];
            }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    exports.__generator = __generator;
    exports.__createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                (0, exports.__createBinding)(o, m, p);
    }
    exports.__exportStar = __exportStar;
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    exports.__values = __values;
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    exports.__read = __read;
    /** @deprecated */
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    exports.__spread = __spread;
    /** @deprecated */
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    exports.__spreadArrays = __spreadArrays;
    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    }
    exports.__spreadArray = __spreadArray;
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    exports.__await = __await;
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) {
            if (g[n])
                i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); };
        }
        function resume(n, v) {
            try {
                step(g[n](v));
            }
            catch (e) {
                settle(q[0][3], e);
            }
        }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) {
            if (f(v), q.shift(), q.length)
                resume(q[0][0], q[0][1]);
        }
    }
    exports.__asyncGenerator = __asyncGenerator;
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }
    exports.__asyncDelegator = __asyncDelegator;
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    exports.__asyncValues = __asyncValues;
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    exports.__makeTemplateObject = __makeTemplateObject;
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    (0, exports.__createBinding)(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    exports.__importStar = __importStar;
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    exports.__importDefault = __importDefault;
    function __classPrivateFieldGet(receiver, state, kind, f) {
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    }
    exports.__classPrivateFieldGet = __classPrivateFieldGet;
    function __classPrivateFieldSet(receiver, state, value, kind, f) {
        if (kind === "m")
            throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    }
    exports.__classPrivateFieldSet = __classPrivateFieldSet;
    function __classPrivateFieldIn(state, receiver) {
        if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function"))
            throw new TypeError("Cannot use 'in' operator on non-object");
        return typeof state === "function" ? receiver === state : state.has(receiver);
    }
    exports.__classPrivateFieldIn = __classPrivateFieldIn;
},
/* index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var version_1 = require(3) /* ./version */;
    __esExport("version", version_1.version);
    var embed_1 = require(4) /* ./embed */;
    __esExport("index", embed_1.index);
    exports.embed = tslib_1.__importStar(require(4) /* ./embed */);
    exports.protocol = tslib_1.__importStar(require(67) /* ./protocol */);
    exports._testing = tslib_1.__importStar(require(68) /* ./testing */);
    var logging_1 = require(18) /* ./core/logging */;
    __esExport("logger", logging_1.logger);
    __esExport("set_log_level", logging_1.set_log_level);
    var settings_1 = require(28) /* ./core/settings */;
    __esExport("settings", settings_1.settings);
    var base_1 = require(7) /* ./base */;
    __esExport("Models", base_1.default_resolver);
    var document_1 = require(5) /* ./document */;
    __esExport("documents", document_1.documents);
    var safely_1 = require(69) /* ./safely */;
    __esExport("safely", safely_1.safely);
},
/* version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.version = "3.0.2";
},
/* embed/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const document_1 = require(5) /* ../document */;
    const logging_1 = require(18) /* ../core/logging */;
    const string_1 = require(38) /* ../core/util/string */;
    const object_1 = require(9) /* ../core/util/object */;
    const types_1 = require(8) /* ../core/util/types */;
    const defer_1 = require(16) /* ../core/util/defer */;
    const standalone_1 = require(53) /* ./standalone */;
    const server_1 = require(60) /* ./server */;
    const dom_1 = require(65) /* ./dom */;
    var standalone_2 = require(53) /* ./standalone */;
    __esExport("add_document_standalone", standalone_2.add_document_standalone);
    __esExport("index", standalone_2.index);
    var server_2 = require(60) /* ./server */;
    __esExport("add_document_from_session", server_2.add_document_from_session);
    var notebook_1 = require(66) /* ./notebook */;
    __esExport("embed_items_notebook", notebook_1.embed_items_notebook);
    __esExport("kernels", notebook_1.kernels);
    async function embed_item(item, target) {
        const docs_json = {};
        const doc_id = (0, string_1.uuid4)();
        docs_json[doc_id] = item.doc;
        if (target == null)
            target = item.target_id;
        const roots = { [item.root_id]: target };
        const render_item = { roots, root_ids: [item.root_id], docid: doc_id };
        await (0, defer_1.defer)();
        const [views] = await _embed_items(docs_json, [render_item]);
        return views;
    }
    exports.embed_item = embed_item;
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    async function embed_items(docs_json, render_items, app_path, absolute_url) {
        await (0, defer_1.defer)();
        return _embed_items(docs_json, render_items, app_path, absolute_url);
    }
    exports.embed_items = embed_items;
    async function _embed_items(docs_json, render_items, app_path, absolute_url) {
        if ((0, types_1.isString)(docs_json))
            docs_json = JSON.parse((0, string_1.unescape)(docs_json));
        const docs = {};
        for (const [docid, doc_json] of (0, object_1.entries)(docs_json)) {
            docs[docid] = document_1.Document.from_json(doc_json);
        }
        const views = [];
        for (const item of render_items) {
            const element = (0, dom_1._resolve_element)(item);
            const roots = (0, dom_1._resolve_root_elements)(item);
            if (item.docid != null) {
                views.push(await (0, standalone_1.add_document_standalone)(docs[item.docid], element, roots, item.use_for_title));
            }
            else if (item.token != null) {
                const websocket_url = (0, server_1._get_ws_url)(app_path, absolute_url);
                logging_1.logger.debug(`embed: computed ws url: ${websocket_url}`);
                try {
                    views.push(await (0, server_1.add_document_from_session)(websocket_url, item.token, element, roots, item.use_for_title));
                    console.log("Bokeh items were rendered successfully");
                }
                catch (error) {
                    console.log("Error rendering Bokeh items:", error);
                }
            }
            else
                throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");
        }
        return views;
    }
},
/* document/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(6) /* ./document */, exports);
    tslib_1.__exportStar(require(39) /* ./events */, exports);
},
/* document/document.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const base_1 = require(7) /* ../base */;
    const version_1 = require(3) /* ../version */;
    const logging_1 = require(18) /* ../core/logging */;
    const bokeh_events_1 = require(46) /* ../core/bokeh_events */;
    const resolvers_1 = require(45) /* ../core/resolvers */;
    const serialization_1 = require(30) /* ../core/serialization */;
    const deserializer_1 = require(47) /* ../core/serialization/deserializer */;
    const version_2 = require(50) /* ../core/util/version */;
    const signaling_1 = require(15) /* ../core/signaling */;
    const eq_1 = require(25) /* ../core/util/eq */;
    const array_1 = require(10) /* ../core/util/array */;
    const sets = tslib_1.__importStar(require(43) /* ../core/util/set */);
    const model_1 = require(51) /* ../model */;
    const defs_1 = require(52) /* ./defs */;
    const events_1 = require(39) /* ./events */;
    deserializer_1.Deserializer.register("model", defs_1.decode_def);
    // Dispatches events to the subscribed models
    class EventManager {
        constructor(document) {
            this.document = document;
            this.subscribed_models = new Set();
        }
        send_event(bokeh_event) {
            const event = new events_1.MessageSentEvent(this.document, "bokeh_event", bokeh_event);
            this.document._trigger_on_change(event);
        }
        trigger(event) {
            for (const model of this.subscribed_models) {
                if (event.origin != null && event.origin != model)
                    continue;
                model._process_event(event);
            }
        }
    }
    exports.EventManager = EventManager;
    EventManager.__name__ = "EventManager";
    exports.documents = [];
    exports.DEFAULT_TITLE = "Bokeh Application";
    // This class should match the API of the Python Document class
    // as much as possible.
    class Document {
        constructor(options) {
            var _a;
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._resolver = (_a = options === null || options === void 0 ? void 0 : options.resolver) !== null && _a !== void 0 ? _a : new resolvers_1.ModelResolver(base_1.default_resolver);
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = new Map();
            this._new_models = new Set();
            this._all_models_freeze_count = 0;
            this._callbacks = new Map();
            this._message_callbacks = new Map();
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, "idle");
            this._idle_roots = new WeakSet();
            this._interactive_timestamp = null;
            this._interactive_plot = null;
        }
        [eq_1.equals](that, _cmp) {
            return this == that;
        }
        get is_idle() {
            // TODO: models without views, e.g. data models
            for (const root of this._roots) {
                if (!this._idle_roots.has(root))
                    return false;
            }
            return true;
        }
        notify_idle(model) {
            this._idle_roots.add(model);
            if (this.is_idle) {
                logging_1.logger.info(`document idle at ${Date.now() - this._init_timestamp} ms`);
                this.event_manager.send_event(new bokeh_events_1.DocumentReady());
                this.idle.emit();
            }
        }
        clear() {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            }
            finally {
                this._pop_all_models_freeze();
            }
        }
        interactive_start(plot, finalize = null) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_1.LODStart());
            }
            this._interactive_finalize = finalize;
            this._interactive_timestamp = Date.now();
        }
        interactive_stop() {
            if (this._interactive_plot != null) {
                this._interactive_plot.trigger_event(new bokeh_events_1.LODEnd());
                if (this._interactive_finalize != null) {
                    this._interactive_finalize();
                }
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
            this._interactive_finalize = null;
        }
        interactive_duration() {
            if (this._interactive_timestamp == null)
                return -1;
            else
                return Date.now() - this._interactive_timestamp;
        }
        destructively_move(dest_doc) {
            if (dest_doc === this) {
                throw new Error("Attempted to overwrite a document with itself");
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            const roots = (0, array_1.copy)(this._roots);
            this.clear();
            for (const root of roots) {
                if (root.document != null)
                    throw new Error(`Somehow we didn't detach ${root}`);
            }
            if (this._all_models.size != 0) {
                throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);
            }
            for (const root of roots) {
                dest_doc.add_root(root);
            }
            dest_doc.set_title(this._title);
        }
        // TODO other fields of doc
        _push_all_models_freeze() {
            this._all_models_freeze_count += 1;
        }
        _pop_all_models_freeze() {
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        }
        /*protected*/ _invalidate_all_models() {
            logging_1.logger.debug("invalidating document models");
            // if freeze count is > 0, we'll recompute on unfreeze
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        }
        _recompute_all_models() {
            let new_all_models_set = new Set();
            for (const r of this._roots) {
                new_all_models_set = sets.union(new_all_models_set, r.references());
            }
            const old_all_models_set = new Set(this._all_models.values());
            const to_detach = sets.difference(old_all_models_set, new_all_models_set);
            const to_attach = sets.difference(new_all_models_set, old_all_models_set);
            const recomputed = new Map();
            for (const model of new_all_models_set) {
                recomputed.set(model.id, model);
            }
            for (const d of to_detach) {
                d.detach_document();
            }
            for (const model of to_attach) {
                model.attach_document(this);
                this._new_models.add(model);
            }
            this._all_models = recomputed; // XXX
        }
        roots() {
            return this._roots;
        }
        _add_root(model) {
            if ((0, array_1.includes)(this._roots, model))
                return false;
            this._push_all_models_freeze();
            try {
                this._roots.push(model);
            }
            finally {
                this._pop_all_models_freeze();
            }
            return true;
        }
        _remove_root(model) {
            const i = this._roots.indexOf(model);
            if (i < 0)
                return false;
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            }
            finally {
                this._pop_all_models_freeze();
            }
            return true;
        }
        _set_title(title) {
            const new_title = title != this._title;
            if (new_title)
                this._title = title;
            return new_title;
        }
        add_root(model) {
            if (this._add_root(model))
                this._trigger_on_change(new events_1.RootAddedEvent(this, model));
        }
        remove_root(model) {
            if (this._remove_root(model))
                this._trigger_on_change(new events_1.RootRemovedEvent(this, model));
        }
        set_title(title) {
            if (this._set_title(title))
                this._trigger_on_change(new events_1.TitleChangedEvent(this, title));
        }
        title() {
            return this._title;
        }
        get_model_by_id(model_id) {
            var _a;
            return (_a = this._all_models.get(model_id)) !== null && _a !== void 0 ? _a : null;
        }
        get_model_by_name(name) {
            const found = [];
            for (const model of this._all_models.values()) {
                if (model instanceof model_1.Model && model.name == name)
                    found.push(model);
            }
            switch (found.length) {
                case 0:
                    return null;
                case 1:
                    return found[0];
                default:
                    throw new Error(`Multiple models are named '${name}'`);
            }
        }
        on_message(msg_type, callback) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks == null)
                this._message_callbacks.set(msg_type, new Set([callback]));
            else
                message_callbacks.add(callback);
        }
        remove_on_message(msg_type, callback) {
            var _a;
            (_a = this._message_callbacks.get(msg_type)) === null || _a === void 0 ? void 0 : _a.delete(callback);
        }
        _trigger_on_message(msg_type, msg_data) {
            const message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks != null) {
                for (const cb of message_callbacks) {
                    cb(msg_data);
                }
            }
        }
        on_change(callback, allow_batches = false) {
            if (!this._callbacks.has(callback)) {
                this._callbacks.set(callback, allow_batches);
            }
        }
        remove_on_change(callback) {
            this._callbacks.delete(callback);
        }
        _trigger_on_change(event) {
            for (const [callback, allow_batches] of this._callbacks) {
                if (!allow_batches && event instanceof events_1.DocumentEventBatch) {
                    for (const ev of event.events) {
                        callback(ev);
                    }
                }
                else {
                    callback(event); // TODO
                }
            }
        }
        to_json_string(include_defaults = true) {
            return JSON.stringify(this.to_json(include_defaults));
        }
        to_json(include_defaults = true) {
            const serializer = new serialization_1.Serializer({ include_defaults });
            const roots = serializer.encode(this._roots);
            return {
                version: version_1.version,
                title: this._title,
                roots,
            };
        }
        static from_json_string(s, events) {
            const json = JSON.parse(s);
            return Document.from_json(json, events);
        }
        static _handle_version(json) {
            if (json.version != null) {
                const py_version = json.version;
                const is_dev = py_version.indexOf("+") !== -1 || py_version.indexOf("-") !== -1;
                const versions_string = `Library versions: JS (${version_1.version}) / Python (${py_version})`;
                if (!is_dev && (0, version_2.pyify_version)(version_1.version) != py_version) {
                    logging_1.logger.warn("JS/Python version mismatch");
                    logging_1.logger.warn(versions_string);
                }
                else
                    logging_1.logger.debug(versions_string);
            }
            else
                logging_1.logger.warn("'version' field is missing");
        }
        static from_json(doc_json, events) {
            logging_1.logger.debug("Creating Document from JSON");
            Document._handle_version(doc_json);
            const resolver = new resolvers_1.ModelResolver(base_1.default_resolver);
            if (doc_json.defs != null) {
                const deserializer = new deserializer_1.Deserializer(resolver);
                deserializer.decode(doc_json.defs);
            }
            const doc = new Document({ resolver });
            doc._push_all_models_freeze();
            const listener = (event) => events === null || events === void 0 ? void 0 : events.push(event);
            doc.on_change(listener, true);
            const deserializer = new deserializer_1.Deserializer(resolver, doc._all_models, (obj) => obj.attach_document(doc));
            const roots = deserializer.decode(doc_json.roots);
            doc.remove_on_change(listener);
            for (const root of roots) {
                doc.add_root(root);
            }
            if (doc_json.title != null)
                doc.set_title(doc_json.title);
            doc._pop_all_models_freeze();
            return doc;
        }
        replace_with_json(json) {
            const replacement = Document.from_json(json);
            replacement.destructively_move(this);
        }
        create_json_patch(events) {
            for (const event of events) {
                if (event.document != this)
                    throw new Error("Cannot create a patch using events from a different document");
            }
            const references = new Map();
            for (const model of this._all_models.values()) {
                if (!this._new_models.has(model)) {
                    references.set(model, model.ref());
                }
            }
            const serializer = new serialization_1.Serializer({ references, binary: true });
            const patch = { events: serializer.encode(events) };
            this._new_models.clear();
            return patch;
        }
        apply_json_patch(patch, buffers = new Map()) {
            this._push_all_models_freeze();
            const deserializer = new deserializer_1.Deserializer(this._resolver, this._all_models, (obj) => obj.attach_document(this));
            const events = deserializer.decode(patch.events, buffers);
            for (const event of events) {
                switch (event.kind) {
                    case "MessageSent": {
                        const { msg_type, msg_data } = event;
                        this._trigger_on_message(msg_type, msg_data);
                        break;
                    }
                    case "ModelChanged": {
                        const { model, attr, new: value } = event;
                        model.setv({ [attr]: value }, { sync: false });
                        break;
                    }
                    case "ColumnDataChanged": {
                        const { model, attr, cols, data } = event;
                        if (cols != null) {
                            const current_data = model.property(attr).get_value();
                            for (const k in current_data) {
                                if (!(k in data)) {
                                    data[k] = current_data[k];
                                }
                            }
                        }
                        model.setv({ data }, { sync: false, check_eq: false });
                        break;
                    }
                    case "ColumnsStreamed": {
                        const { model, attr, data, rollover } = event;
                        const prop = model.property(attr);
                        model.stream_to(prop, data, rollover, { sync: false });
                        break;
                    }
                    case "ColumnsPatched": {
                        const { model, attr, patches } = event;
                        const prop = model.property(attr);
                        model.patch_to(prop, patches, { sync: false });
                        break;
                    }
                    case "RootAdded": {
                        this._add_root(event.model);
                        break;
                    }
                    case "RootRemoved": {
                        this._remove_root(event.model);
                        break;
                    }
                    case "TitleChanged": {
                        this._set_title(event.title);
                        break;
                    }
                    default:
                        throw new Error(`unknown patch event type '${event.kind}'`); // XXX
                }
            }
            this._pop_all_models_freeze();
        }
    }
    exports.Document = Document;
    Document.__name__ = "Document";
},
/* base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(9) /* ./core/util/object */;
    const has_props_1 = require(14) /* ./core/has_props */;
    const resolvers_1 = require(45) /* ./core/resolvers */;
    exports.default_resolver = new resolvers_1.ModelResolver(null);
    function is_HasProps(obj) {
        return (0, types_1.isObject)(obj) && obj.prototype instanceof has_props_1.HasProps;
    }
    function register_models(models, force = false) {
        for (const model of (0, types_1.isArray)(models) ? models : (0, object_1.values)(models)) {
            if (is_HasProps(model)) {
                exports.default_resolver.register(model, force);
            }
        }
    }
    exports.register_models = register_models;
},
/* core/util/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const toString = Object.prototype.toString;
    function is_undefined(obj) {
        return typeof obj === "undefined";
    }
    exports.is_undefined = is_undefined;
    function is_defined(obj) {
        return typeof obj !== "undefined";
    }
    exports.is_defined = is_defined;
    // XXX: use only to work around strict conditional expressions
    function is_nullish(obj) {
        return obj == null;
    }
    exports.is_nullish = is_nullish;
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === "[object Boolean]";
    }
    exports.isBoolean = isBoolean;
    function isNumber(obj) {
        return toString.call(obj) === "[object Number]";
    }
    exports.isNumber = isNumber;
    function isInteger(obj) {
        return isNumber(obj) && Number.isInteger(obj);
    }
    exports.isInteger = isInteger;
    function isString(obj) {
        return toString.call(obj) === "[object String]";
    }
    exports.isString = isString;
    function isSymbol(obj) {
        return typeof obj === "symbol";
    }
    exports.isSymbol = isSymbol;
    function isPrimitive(obj) {
        return obj === null || isBoolean(obj) || isNumber(obj) || isString(obj) || isSymbol(obj);
    }
    exports.isPrimitive = isPrimitive;
    function isFunction(obj) {
        const rep = toString.call(obj);
        return rep === "[object Function]" || rep === "[object AsyncFunction]";
    }
    exports.isFunction = isFunction;
    function isArray(obj) {
        return Array.isArray(obj);
    }
    exports.isArray = isArray;
    function isArrayOf(array, predicate) {
        for (const item of array) {
            if (!predicate(item))
                return false;
        }
        return true;
    }
    exports.isArrayOf = isArrayOf;
    function isArrayableOf(array, predicate) {
        for (const item of array) {
            if (!predicate(item))
                return false;
        }
        return true;
    }
    exports.isArrayableOf = isArrayableOf;
    function isTypedArray(obj) {
        return ArrayBuffer.isView(obj) && !(obj instanceof DataView);
    }
    exports.isTypedArray = isTypedArray;
    function isObject(obj) {
        const tp = typeof obj;
        return tp === "function" || tp === "object" && !!obj;
    }
    exports.isObject = isObject;
    function isBasicObject(obj) {
        return isObject(obj) && is_nullish(obj.constructor);
    }
    exports.isBasicObject = isBasicObject;
    function isPlainObject(obj) {
        return isObject(obj) && (is_nullish(obj.constructor) || obj.constructor === Object);
    }
    exports.isPlainObject = isPlainObject;
    function isIterable(obj) {
        return isObject(obj) && Symbol.iterator in obj;
    }
    exports.isIterable = isIterable;
    function isArrayable(obj) {
        return isIterable(obj) && "length" in obj;
    }
    exports.isArrayable = isArrayable;
},
/* core/util/object.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const array_1 = require(10) /* ./array */;
    const { hasOwnProperty } = Object.prototype;
    exports.keys = Object.keys, exports.values = Object.values, exports.entries = Object.entries, exports.assign = Object.assign, exports.to_object = Object.fromEntries;
    exports.extend = exports.assign;
    function fields(obj) {
        return (0, exports.keys)(obj);
    }
    exports.fields = fields;
    function clone(obj) {
        return Object.assign({}, obj);
    }
    exports.clone = clone;
    function merge(obj1, obj2) {
        /*
         * Returns an object with the array values for obj1 and obj2 unioned by key.
         */
        const result = Object.create(Object.prototype);
        const keys = (0, array_1.concat)([Object.keys(obj1), Object.keys(obj2)]);
        for (const key of keys) {
            const arr1 = hasOwnProperty.call(obj1, key) ? obj1[key] : [];
            const arr2 = hasOwnProperty.call(obj2, key) ? obj2[key] : [];
            result[key] = (0, array_1.union)(arr1, arr2);
        }
        return result;
    }
    exports.merge = merge;
    function size(obj) {
        return Object.keys(obj).length;
    }
    exports.size = size;
    function is_empty(obj) {
        return size(obj) == 0;
    }
    exports.is_empty = is_empty;
    class Dict {
        constructor(obj) {
            this.obj = obj;
            this[_a] = "Dict";
        }
        clear() {
            for (const key of (0, exports.keys)(this.obj)) {
                delete this.obj[key];
            }
        }
        delete(key) {
            const had = key in this;
            delete this.obj[key];
            return had;
        }
        get(key) {
            return key in this.obj ? this.obj[key] : undefined;
        }
        has(key) {
            return key in this.obj;
        }
        set(key, value) {
            this.obj[key] = value;
            return this;
        }
        get size() {
            return size(this.obj);
        }
        get is_empty() {
            return this.size == 0;
        }
        [(_a = Symbol.toStringTag, Symbol.iterator)]() {
            return this.entries();
        }
        *keys() {
            yield* (0, exports.keys)(this.obj);
        }
        *values() {
            yield* (0, exports.values)(this.obj);
        }
        *entries() {
            yield* (0, exports.entries)(this.obj);
        }
        forEach(callback, that) {
            for (const [key, value] of this.entries()) {
                callback.call(that, value, key, this);
            }
        }
    }
    exports.Dict = Dict;
    Dict.__name__ = "Dict";
    function dict(o) {
        return new Dict(o);
    }
    exports.dict = dict;
},
/* core/util/array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    const math_1 = require(11) /* ./math */;
    const assert_1 = require(12) /* ./assert */;
    const arrayable_1 = require(13) /* ./arrayable */;
    __esExport("map", arrayable_1.map);
    __esExport("reduce", arrayable_1.reduce);
    __esExport("min", arrayable_1.min);
    __esExport("min_by", arrayable_1.min_by);
    __esExport("max", arrayable_1.max);
    __esExport("max_by", arrayable_1.max_by);
    __esExport("sum", arrayable_1.sum);
    __esExport("cumsum", arrayable_1.cumsum);
    __esExport("every", arrayable_1.every);
    __esExport("some", arrayable_1.some);
    __esExport("find", arrayable_1.find);
    __esExport("find_last", arrayable_1.find_last);
    __esExport("find_index", arrayable_1.find_index);
    __esExport("find_last_index", arrayable_1.find_last_index);
    __esExport("sorted_index", arrayable_1.sorted_index);
    __esExport("is_empty", arrayable_1.is_empty);
    const slice = Array.prototype.slice;
    function head(array) {
        return array[0];
    }
    exports.head = head;
    function tail(array) {
        return array[array.length - 1];
    }
    exports.tail = tail;
    function last(array) {
        return array[array.length - 1];
    }
    exports.last = last;
    function copy(array) {
        return slice.call(array);
    }
    exports.copy = copy;
    function concat(arrays) {
        return [].concat(...arrays);
    }
    exports.concat = concat;
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.includes = includes;
    exports.contains = includes;
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    exports.nth = nth;
    function zip(...arrays) {
        if (arrays.length == 0)
            return [];
        const n = (0, arrayable_1.min)(arrays.map((a) => a.length));
        const k = arrays.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = new Array(k);
            for (let j = 0; j < k; j++)
                result[i][j] = arrays[j][i];
        }
        return result;
    }
    exports.zip = zip;
    function unzip(array) {
        const n = array.length;
        const k = (0, arrayable_1.min)(array.map((a) => a.length));
        const results = Array(k);
        for (let j = 0; j < k; j++)
            results[j] = new Array(n);
        for (let i = 0; i < n; i++) {
            for (let j = 0; j < k; j++)
                results[j][i] = array[i][j];
        }
        return results;
    }
    exports.unzip = unzip;
    function range(start, stop, step = 1) {
        (0, assert_1.assert)(step > 0, "'step' must be a positive number");
        if (stop == null) {
            stop = start;
            start = 0;
        }
        const { max, ceil, abs } = Math;
        const delta = start <= stop ? step : -step;
        const length = max(ceil(abs(stop - start) / step), 0);
        const range = new Array(length);
        for (let i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    exports.range = range;
    function linspace(start, stop, num = 100) {
        const step = (stop - start) / (num - 1);
        const array = new Array(num);
        for (let i = 0; i < num; i++) {
            array[i] = start + step * i;
        }
        return array;
    }
    exports.linspace = linspace;
    function transpose(array) {
        const rows = array.length;
        const cols = array[0].length;
        const transposed = [];
        for (let j = 0; j < cols; j++) {
            transposed[j] = [];
            for (let i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    exports.transpose = transpose;
    function argmin(array) {
        return (0, arrayable_1.min_by)(range(array.length), (i) => array[i]);
    }
    exports.argmin = argmin;
    function argmax(array) {
        return (0, arrayable_1.max_by)(range(array.length), (i) => array[i]);
    }
    exports.argmax = argmax;
    function sort_by(array, key) {
        const tmp = array.map((value, index) => {
            return { value, index, key: key(value) };
        });
        tmp.sort((left, right) => {
            const a = left.key;
            const b = right.key;
            if (a !== b) {
                if (a > b)
                    return 1;
                if (a < b)
                    return -1;
            }
            return left.index - right.index;
        });
        return tmp.map((item) => item.value);
    }
    exports.sort_by = sort_by;
    function uniq(array) {
        const result = new Set();
        for (const value of array) {
            result.add(value);
        }
        return [...result];
    }
    exports.uniq = uniq;
    function uniq_by(array, key) {
        const result = [];
        const seen = [];
        for (const value of array) {
            const computed = key(value);
            if (!includes(seen, computed)) {
                seen.push(computed);
                result.push(value);
            }
        }
        return result;
    }
    exports.uniq_by = uniq_by;
    function union(...arrays) {
        const result = new Set();
        for (const array of arrays) {
            for (const value of array) {
                result.add(value);
            }
        }
        return [...result];
    }
    exports.union = union;
    function intersection(array, ...arrays) {
        const result = [];
        top: for (const item of array) {
            if (includes(result, item))
                continue;
            for (const other of arrays) {
                if (!includes(other, item))
                    continue top;
            }
            result.push(item);
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(array, ...arrays) {
        const rest = concat(arrays);
        return array.filter((value) => !includes(rest, value));
    }
    exports.difference = difference;
    function remove_at(array, i) {
        const result = copy(array);
        result.splice(i, 1);
        return result;
    }
    exports.remove_at = remove_at;
    function remove_by(array, key) {
        for (let i = 0; i < array.length;) {
            if (key(array[i]))
                array.splice(i, 1);
            else
                i++;
        }
    }
    exports.remove_by = remove_by;
    function clear(array) {
        array.splice(0, array.length);
    }
    exports.clear = clear;
    function split(array, separator) {
        const chunks = [];
        const n = array.length;
        let i = 0;
        let j = 0;
        while (j < n) {
            if (array[j] === separator) {
                chunks.push(array.slice(i, j));
                i = ++j;
            }
            else
                ++j;
        }
        chunks.push(array.slice(i));
        return chunks;
    }
    exports.split = split;
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        const length = array.length;
        const shuffled = new Array(length);
        for (let i = 0; i < length; i++) {
            const rand = (0, math_1.randomIn)(0, i);
            if (rand !== i)
                shuffled[i] = shuffled[rand];
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    exports.shuffle = shuffle;
    function pairwise(array, fn) {
        const n = array.length;
        const result = new Array(n - 1);
        for (let i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    exports.pairwise = pairwise;
    function reversed(array) {
        const n = array.length;
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    exports.reversed = reversed;
    function repeat(value, n) {
        const result = new Array(n);
        for (let i = 0; i < n; i++) {
            result[i] = value;
        }
        return result;
    }
    exports.repeat = repeat;
},
/* core/util/math.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    const assert_1 = require(12) /* ./assert */;
    const { PI, abs, sign } = Math;
    function angle_norm(angle) {
        if (angle == 0) {
            return 0;
        }
        while (angle <= 0) {
            angle += 2 * PI;
        }
        while (angle > 2 * PI) {
            angle -= 2 * PI;
        }
        return angle;
    }
    exports.angle_norm = angle_norm;
    function angle_dist(lhs, rhs) {
        return angle_norm(lhs - rhs);
    }
    exports.angle_dist = angle_dist;
    function angle_between(mid, lhs, rhs, anticlock = false) {
        const d = angle_dist(lhs, rhs);
        if (d == 0)
            return false;
        if (d == 2 * PI)
            return true;
        const norm_mid = angle_norm(mid);
        const cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        return !anticlock ? cond : !cond;
    }
    exports.angle_between = angle_between;
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    exports.randomIn = randomIn;
    function atan2(start, end) {
        /*
         * Calculate the angle between a line containing start and end points (composed
         * of [x, y] arrays) and the positive x-axis.
         */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    exports.atan2 = atan2;
    function radians(degrees) {
        return degrees * (PI / 180);
    }
    exports.radians = radians;
    function degrees(radians) {
        return radians / (PI / 180);
    }
    exports.degrees = degrees;
    function resolve_angle(angle, units) {
        /** Convert CCW angle with units to CW radians (canvas). */
        return -to_radians_coeff(units) * angle;
    }
    exports.resolve_angle = resolve_angle;
    function to_radians_coeff(units) {
        switch (units) {
            case "deg": return PI / 180;
            case "rad": return 1;
            case "grad": return PI / 200;
            case "turn": return 2 * PI;
        }
    }
    exports.to_radians_coeff = to_radians_coeff;
    function clamp(val, min, max) {
        return val < min ? min : (val > max ? max : val);
    }
    exports.clamp = clamp;
    function log(x, base = Math.E) {
        return Math.log(x) / Math.log(base);
    }
    exports.log = log;
    function gcd(a, b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            [a, b] = [b, a % b];
        }
        return a;
    }
    exports.gcd = gcd;
    function lcm(a, ...rest) {
        for (const b of rest) {
            a = Math.floor((a * b) / gcd(a, b));
        }
        return a;
    }
    exports.lcm = lcm;
    exports.float = Symbol("float");
    function is_Floating(obj) {
        return (0, types_1.isObject)(obj) && exports.float in obj;
    }
    exports.is_Floating = is_Floating;
    class Fraction {
        constructor(numer, denom) {
            (0, assert_1.assert)(denom != 0, "Zero divisor");
            const div = gcd(numer, denom);
            const sgn = sign(numer) * sign(denom);
            this.numer = sgn * abs(numer) / div;
            this.denom = abs(denom) / div;
        }
        [exports.float]() {
            return this.numer / this.denom;
        }
        toString() {
            return `${this.numer}/${this.denom}`;
        }
    }
    exports.Fraction = Fraction;
    Fraction.__name__ = "Fraction";
    exports.float32_epsilon = 1.1920928955078125e-7; // IEEE-754
    function factorial(x) {
        let y = 1;
        for (let i = 2; i <= x; i++) {
            y *= i;
        }
        return y;
    }
    exports.factorial = factorial;
    function hermite(n) {
        const poly = new Array(n + 1);
        poly.fill(0);
        const fn = factorial(n);
        for (let k = 0; k <= Math.floor(n / 2); k++) {
            const c = (-1) ** k * fn / (factorial(k) * factorial(n - 2 * k)) * 2 ** (n - 2 * k);
            poly[2 * k] = c;
        }
        return poly;
    }
    exports.hermite = hermite;
    function eval_poly(poly, x) {
        const n = poly.length - 1;
        let y = 0;
        let x_n = 1;
        for (let i = n; i >= 0; i--) {
            y += x_n * poly[i];
            x_n *= x;
        }
        return y;
    }
    exports.eval_poly = eval_poly;
},
/* core/util/assert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class AssertionError extends Error {
    }
    exports.AssertionError = AssertionError;
    AssertionError.__name__ = "AssertionError";
    function assert(condition, message) {
        if (condition === true || (condition !== false && condition()))
            return;
        throw new AssertionError(message !== null && message !== void 0 ? message : "Assertion failed");
    }
    exports.assert = assert;
    function unreachable() {
        throw new Error("unreachable code");
    }
    exports.unreachable = unreachable;
},
/* core/util/arrayable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const math_1 = require(11) /* ./math */;
    function is_empty(array) {
        return array.length == 0;
    }
    exports.is_empty = is_empty;
    function copy(array) {
        if (Array.isArray(array))
            return array.slice();
        else
            return new array.constructor(array);
    }
    exports.copy = copy;
    function splice(array, start, k, ...items) {
        const len = array.length;
        if (start < 0)
            start += len;
        if (start < 0)
            start = 0;
        else if (start > len)
            start = len;
        if (k == null || k > len - start)
            k = len - start;
        else if (k < 0)
            k = 0;
        const n = len - k + items.length;
        const result = new array.constructor(n);
        let i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        for (const item of items) {
            result[i++] = item;
        }
        for (let j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    exports.splice = splice;
    function head(array, n) {
        return splice(array, n, array.length - n);
    }
    exports.head = head;
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    exports.insert = insert;
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    exports.append = append;
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    exports.prepend = prepend;
    function indexOf(array, item) {
        for (let i = 0, n = array.length; i < n; i++) {
            if (array[i] === item)
                return i;
        }
        return -1;
    }
    exports.indexOf = indexOf;
    function subselect(array, indices) {
        const n = indices.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[indices[i]];
        }
        return result;
    }
    exports.subselect = subselect;
    function mul(array, coeff, output) {
        const n = array.length;
        const result = output !== null && output !== void 0 ? output : new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = array[i] * coeff;
        }
        return result;
    }
    exports.mul = mul;
    function map(array, fn) {
        const n = array.length;
        const result = new array.constructor(n);
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    exports.map = map;
    function inplace_map(array, fn, output) {
        const n = array.length;
        const result = output !== null && output !== void 0 ? output : array;
        for (let i = 0; i < n; i++) {
            result[i] = fn(array[i], i);
        }
    }
    exports.inplace_map = inplace_map;
    function filter(array, pred) {
        const n = array.length;
        const result = new array.constructor(n);
        let k = 0;
        for (let i = 0; i < n; i++) {
            const value = array[i];
            if (pred(value, i, array))
                result[k++] = value;
        }
        return head(result, k);
    }
    exports.filter = filter;
    function reduce(array, fn, initial) {
        const n = array.length;
        if (initial === undefined && n == 0)
            throw new Error("can't reduce an empty array without an initial value");
        let value;
        let i;
        if (initial === undefined) {
            value = array[0];
            i = 1;
        }
        else {
            value = initial;
            i = 0;
        }
        for (; i < n; i++) {
            value = fn(value, array[i], i, array);
        }
        return value;
    }
    exports.reduce = reduce;
    function min(array) {
        let value;
        let result = Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value < result) {
                result = value;
            }
        }
        return result;
    }
    exports.min = min;
    function max(array) {
        let value;
        let result = -Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value > result) {
                result = value;
            }
        }
        return result;
    }
    exports.max = max;
    function minmax(array) {
        let value;
        let min = +Infinity;
        let max = -Infinity;
        for (let i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value)) {
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
            }
        }
        return [min, max];
    }
    exports.minmax = minmax;
    function minmax2(arr, brr) {
        let a;
        let b;
        let a_min = +Infinity;
        let a_max = -Infinity;
        let b_min = +Infinity;
        let b_max = -Infinity;
        const n = Math.min(arr.length, brr.length);
        for (let i = 0; i < n; i++) {
            a = arr[i];
            b = brr[i];
            if (!isNaN(a) && !isNaN(b)) {
                if (a < a_min)
                    a_min = a;
                if (a > a_max)
                    a_max = a;
                if (b < b_min)
                    b_min = b;
                if (b > b_max)
                    b_max = b;
            }
        }
        return [a_min, a_max, b_min, b_max];
    }
    exports.minmax2 = minmax2;
    function min_by(array, key) {
        if (array.length == 0)
            throw new Error("min_by() called with an empty array");
        let result = array[0];
        let resultComputed = key(result);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value);
            if (computed < resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.min_by = min_by;
    function max_by(array, key) {
        if (array.length == 0)
            throw new Error("max_by() called with an empty array");
        let result = array[0];
        let resultComputed = key(result);
        for (let i = 1, length = array.length; i < length; i++) {
            const value = array[i];
            const computed = key(value);
            if (computed > resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.max_by = max_by;
    function sum(array) {
        let result = 0;
        for (let i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    exports.sum = sum;
    function cumsum(array) {
        const result = new array.constructor(array.length);
        reduce(array, (a, b, i) => result[i] = a + b, 0);
        return result;
    }
    exports.cumsum = cumsum;
    function every(iter, predicate) {
        for (const item of iter) {
            if (!predicate(item))
                return false;
        }
        return true;
    }
    exports.every = every;
    function some(iter, predicate) {
        for (const item of iter) {
            if (predicate(item))
                return true;
        }
        return false;
    }
    exports.some = some;
    function index_of(array, value) {
        for (let i = 0, length = array.length; i < length; i++) {
            if (array[i] === value)
                return i;
        }
        return -1;
    }
    exports.index_of = index_of;
    function _find_index(dir) {
        return function (array, predicate) {
            const length = array.length;
            let index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index]))
                    return index;
            }
            return -1;
        };
    }
    exports.find_index = _find_index(1);
    exports.find_last_index = _find_index(-1);
    function find(array, predicate) {
        const index = (0, exports.find_index)(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find = find;
    function find_last(array, predicate) {
        const index = (0, exports.find_last_index)(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find_last = find_last;
    function sorted_index(array, value) {
        let low = 0;
        let high = array.length;
        while (low < high) {
            const mid = Math.floor((low + high) / 2);
            if (array[mid] < value)
                low = mid + 1;
            else
                high = mid;
        }
        return low;
    }
    exports.sorted_index = sorted_index;
    function bin_counts(data, bin_edges) {
        const nbins = bin_edges.length - 1;
        const counts = Array(nbins).fill(0);
        for (let i = 0; i < data.length; i++) {
            const sample = data[i];
            const index = sorted_index(bin_edges, sample);
            const bin = (0, math_1.clamp)(index - 1, 0, nbins - 1);
            counts[bin] += 1;
        }
        return counts;
    }
    exports.bin_counts = bin_counts;
    function interpolate(points, x_values, y_values) {
        // Implementation ported from np.interp
        const n = points.length;
        const results = new Array(n);
        for (let i = 0; i < n; i++) {
            const point = points[i];
            if (isNaN(point)) {
                results[i] = point;
                continue;
            }
            const index = left_edge_index(point, x_values);
            if (index == -1)
                results[i] = y_values[0];
            else if (index == x_values.length)
                results[i] = y_values[y_values.length - 1];
            else if (index == x_values.length - 1 || x_values[index] == point) {
                results[i] = y_values[index];
            }
            else {
                const x0 = x_values[index];
                const y0 = y_values[index];
                const x1 = x_values[index + 1];
                const y1 = y_values[index + 1];
                results[i] = lerp(point, x0, y0, x1, y1);
            }
        }
        return results;
    }
    exports.interpolate = interpolate;
    function lerp(x, x0, y0, x1, y1) {
        const slope = (y1 - y0) / (x1 - x0);
        let res = slope * (x - x0) + y0;
        if (!isFinite(res)) {
            res = slope * (x - x1) + y1;
            if (!isFinite(res) && (y0 == y1))
                res = y0;
        }
        return res;
    }
    function left_edge_index(point, intervals) {
        if (point < intervals[0])
            return -1;
        if (point > intervals[intervals.length - 1])
            return intervals.length;
        let leftEdgeIndex = 0;
        let rightEdgeIndex = intervals.length - 1;
        while (rightEdgeIndex - leftEdgeIndex != 1) {
            const indexOfNumberToCompare = leftEdgeIndex + Math.floor((rightEdgeIndex - leftEdgeIndex) / 2);
            if (point >= intervals[indexOfNumberToCompare])
                leftEdgeIndex = indexOfNumberToCompare;
            else
                rightEdgeIndex = indexOfNumberToCompare;
        }
        return leftEdgeIndex;
    }
    exports.left_edge_index = left_edge_index;
    function norm(array, start, end) {
        const span = end - start;
        return map(array, (x) => (x - start) / span);
    }
    exports.norm = norm;
},
/* core/has_props.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const signaling_1 = require(15) /* ./signaling */;
    const p = tslib_1.__importStar(require(17) /* ./properties */);
    const k = tslib_1.__importStar(require(20) /* ./kinds */);
    const assert_1 = require(12) /* ./util/assert */;
    const string_1 = require(38) /* ./util/string */;
    const object_1 = require(9) /* ./util/object */;
    const types_1 = require(8) /* ./util/types */;
    const eq_1 = require(25) /* ./util/eq */;
    const serialization_1 = require(30) /* ./serialization */;
    const events_1 = require(39) /* ../document/events */;
    const eq_2 = require(25) /* ./util/eq */;
    const pretty_1 = require(40) /* ./util/pretty */;
    const cloneable_1 = require(41) /* ./util/cloneable */;
    const kinds = tslib_1.__importStar(require(20) /* ./kinds */);
    const vectorization_1 = require(27) /* ./vectorization */;
    const patching_1 = require(42) /* ./patching */;
    const _qualified_names = new WeakMap();
    class HasProps extends (0, signaling_1.Signalable)() {
        constructor(attrs = {}) {
            super();
            this.document = null;
            this.destroyed = new signaling_1.Signal0(this, "destroyed");
            this.change = new signaling_1.Signal0(this, "change");
            this.transformchange = new signaling_1.Signal0(this, "transformchange");
            this.exprchange = new signaling_1.Signal0(this, "exprchange");
            this.streaming = new signaling_1.Signal0(this, "streaming");
            this.patching = new signaling_1.Signal(this, "patching");
            this.properties = {};
            this._watchers = new WeakMap();
            this._pending = false;
            this._changing = false;
            const deferred = (0, types_1.isPlainObject)(attrs) && "id" in attrs;
            this.id = deferred ? attrs.id : (0, string_1.unique_id)();
            for (const [name, { type, default_value, options }] of (0, object_1.entries)(this._props)) {
                let property;
                if (type instanceof p.PropertyAlias) {
                    Object.defineProperty(this.properties, name, {
                        get: () => this.properties[type.attr],
                        configurable: false,
                        enumerable: false,
                    });
                }
                else {
                    if (type instanceof k.Kind)
                        property = new p.PrimitiveProperty(this, name, type, default_value, options);
                    else
                        property = new type(this, name, k.Any, default_value, options);
                    this.properties[name] = property;
                }
            }
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (deferred) {
                (0, assert_1.assert)((0, object_1.keys)(attrs).length == 1, "'id' cannot be used together with property initializers");
            }
            else {
                const vals = attrs instanceof Map ? attrs : new object_1.Dict(attrs);
                this.initialize_props(vals);
                this.finalize();
                this.connect_signals();
            }
        }
        get is_syncable() {
            return true;
        }
        get type() {
            return this.constructor.__qualified__;
        }
        static get __qualified__() {
            let qualified = _qualified_names.get(this);
            if (qualified == null) {
                const { __module__, __name__ } = this;
                qualified = __module__ != null ? `${__module__}.${__name__}` : __name__;
                _qualified_names.set(this, qualified);
            }
            return qualified;
        }
        static set __qualified__(qualified) {
            _qualified_names.set(this, qualified);
        }
        get [Symbol.toStringTag]() {
            return this.constructor.__qualified__;
        }
        static _fix_default(default_value, _attr) {
            if (default_value === undefined)
                return () => p.unset;
            else if ((0, types_1.isFunction)(default_value))
                return default_value;
            else if ((0, types_1.isPrimitive)(default_value))
                return () => default_value;
            else {
                const cloner = new cloneable_1.Cloner();
                return () => cloner.clone(default_value);
            }
        }
        // TODO: don't use Partial<>, but exclude inherited properties
        static define(obj) {
            for (const [name, prop] of (0, object_1.entries)((0, types_1.isFunction)(obj) ? obj(kinds) : obj)) {
                if (name in this.prototype._props)
                    throw new Error(`attempted to redefine property '${this.prototype.type}.${name}'`);
                if (name in this.prototype)
                    throw new Error(`attempted to redefine attribute '${this.prototype.type}.${name}'`);
                Object.defineProperty(this.prototype, name, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get() {
                        const value = this.properties[name].get_value();
                        return value;
                    },
                    set(value) {
                        this.setv({ [name]: value });
                        return this;
                    },
                    configurable: false,
                    enumerable: true,
                });
                const [type, default_value, options = {}] = prop;
                const refined_prop = {
                    type,
                    default_value: this._fix_default(default_value, name),
                    options,
                };
                const props = Object.assign({}, this.prototype._props);
                props[name] = refined_prop;
                this.prototype._props = props;
            }
        }
        static internal(obj) {
            const _object = {};
            for (const [name, prop] of (0, object_1.entries)((0, types_1.isFunction)(obj) ? obj(kinds) : obj)) {
                const [type, default_value, options = {}] = prop;
                _object[name] = [type, default_value, Object.assign(Object.assign({}, options), { internal: true })];
            }
            this.define(_object);
        }
        static mixins(defs) {
            function rename(prefix, mixin) {
                const result = {};
                for (const [name, prop] of (0, object_1.entries)(mixin)) {
                    result[prefix + name] = prop;
                }
                return result;
            }
            const mixin_defs = {};
            const mixins = [];
            for (const def of (0, types_1.isArray)(defs) ? defs : [defs]) {
                if ((0, types_1.isArray)(def)) {
                    const [prefix, mixin] = def;
                    (0, object_1.extend)(mixin_defs, rename(prefix, mixin));
                    mixins.push([prefix, mixin]);
                }
                else {
                    const mixin = def;
                    (0, object_1.extend)(mixin_defs, mixin);
                    mixins.push(["", mixin]);
                }
            }
            this.define(mixin_defs);
            this.prototype._mixins = [...this.prototype._mixins, ...mixins];
        }
        static override(obj) {
            for (const [name, prop] of (0, object_1.entries)(obj)) {
                const default_value = this._fix_default(prop, name);
                if (!(name in this.prototype._props))
                    throw new Error(`attempted to override nonexistent '${this.prototype.type}.${name}'`);
                const value = this.prototype._props[name];
                const props = Object.assign({}, this.prototype._props);
                props[name] = Object.assign(Object.assign({}, value), { default_value });
                this.prototype._props = props;
            }
        }
        static toString() {
            return this.__qualified__;
        }
        toString() {
            return `${this.type}(${this.id})`;
        }
        property(name) {
            if (name in this.properties)
                return this.properties[name];
            else
                throw new Error(`unknown property ${this.type}.${name}`);
        }
        get attributes() {
            const attrs = {};
            for (const prop of this) {
                if (!prop.is_unset)
                    attrs[prop.attr] = prop.get_value();
            }
            return attrs;
        }
        [cloneable_1.clone](cloner) {
            const attrs = new Map();
            for (const prop of this) {
                if (prop.dirty) {
                    attrs.set(prop.attr, cloner.clone(prop.get_value()));
                }
            }
            return new this.constructor(attrs);
        }
        [eq_2.equals](that, cmp) {
            for (const p0 of this) {
                const p1 = that.property(p0.attr);
                if (!cmp.eq(p0.get_value(), p1.get_value()))
                    return false;
            }
            return true;
        }
        [pretty_1.pretty](printer) {
            const T = printer.token;
            const items = [];
            for (const prop of this) {
                if (prop.dirty) {
                    const value = prop.get_value();
                    items.push(`${prop.attr}${T(":")} ${printer.to_string(value)}`);
                }
            }
            const cls = this.constructor.__qualified__;
            return `${cls}${T("(")}${T("{")}${items.join(`${T(",")} `)}${T("}")}${T(")")}`;
        }
        [serialization_1.serialize](serializer) {
            const ref = this.ref();
            serializer.add_ref(this, ref);
            const attributes = {};
            for (const prop of this) {
                if (prop.syncable && (serializer.include_defaults || prop.dirty)) {
                    const value = prop.get_value();
                    attributes[prop.attr] = serializer.encode(value);
                }
            }
            const { type: name, id } = this;
            const rep = { type: "object", name, id };
            return (0, object_1.is_empty)(attributes) ? rep : Object.assign(Object.assign({}, rep), { attributes });
        }
        initialize_props(vals) {
            const visited = new Set();
            for (const prop of this) {
                const val = vals.get(prop.attr);
                prop.initialize(val);
                visited.add(prop.attr);
            }
            for (const attr of vals.keys()) {
                if (!visited.has(attr))
                    this.property(attr);
            }
        }
        finalize() {
            this.initialize();
        }
        initialize() { }
        connect_signals() {
            for (const prop of this) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                    continue;
                if (prop.is_unset)
                    continue;
                const value = prop.get_value();
                if (value.transform != null)
                    this.connect(value.transform.change, () => this.transformchange.emit());
                if ((0, vectorization_1.isExpr)(value))
                    this.connect(value.expr.change, () => this.exprchange.emit());
            }
        }
        disconnect_signals() {
            signaling_1.Signal.disconnect_receiver(this);
        }
        destroy() {
            this.disconnect_signals();
            this.destroyed.emit();
        }
        // Create a new model with exact attribute values to this one, but new identity.
        clone() {
            const cloner = new cloneable_1.Cloner();
            return cloner.clone(this);
        }
        _clear_watchers() {
            this._watchers = new WeakMap();
        }
        changed_for(obj) {
            const changed = this._watchers.get(obj);
            this._watchers.set(obj, false);
            return changed !== null && changed !== void 0 ? changed : true;
        }
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        _setv(changes, options) {
            var _b;
            // Extract attributes and options.
            const check_eq = options.check_eq;
            const changed = new Set();
            const changing = this._changing;
            this._changing = true;
            for (const [prop, value] of changes) {
                if (check_eq === false || prop.is_unset || !(0, eq_1.is_equal)(prop.get_value(), value)) {
                    prop.set_value(value);
                    changed.add(prop);
                }
            }
            // Trigger all relevant attribute changes.
            if (changed.size > 0) {
                this._clear_watchers();
                this._pending = true;
            }
            for (const prop of changed) {
                prop.change.emit();
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (!changing) {
                if (!((_b = options.no_change) !== null && _b !== void 0 ? _b : false)) {
                    while (this._pending) {
                        this._pending = false;
                        this.change.emit();
                    }
                }
                this._pending = false;
                this._changing = false;
            }
            return changed;
        }
        setv(changed_attrs, options = {}) {
            var _b, _c;
            const changes = (0, object_1.entries)(changed_attrs);
            if (changes.length == 0)
                return;
            if ((_b = options.silent) !== null && _b !== void 0 ? _b : false) {
                this._clear_watchers();
                for (const [attr, value] of changes) {
                    this.properties[attr].set_value(value);
                }
                return;
            }
            const changed = new Map();
            const previous = new Map();
            for (const [attr, value] of changes) {
                const prop = this.properties[attr];
                changed.set(prop, value);
                previous.set(prop, prop.is_unset ? undefined : prop.get_value());
            }
            const updated = this._setv(changed, options);
            const { document } = this;
            if (document != null) {
                const changed = [];
                for (const [prop, value] of previous) {
                    if (updated.has(prop))
                        changed.push([prop, value, prop.get_value()]);
                }
                for (const [, old_value, new_value] of changed) {
                    if (this._needs_invalidate(old_value, new_value)) {
                        document._invalidate_all_models();
                        break;
                    }
                }
                if ((_c = options.sync) !== null && _c !== void 0 ? _c : true)
                    this._push_changes(changed);
            }
        }
        ref() {
            return { id: this.id };
        }
        *[Symbol.iterator]() {
            yield* (0, object_1.values)(this.properties);
        }
        *syncable_properties() {
            for (const prop of this) {
                if (prop.syncable)
                    yield prop;
            }
        }
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        static _value_record_references(v, refs, options) {
            const { recursive } = options;
            if (v instanceof HasProps) {
                if (!refs.has(v)) {
                    refs.add(v);
                    if (recursive) {
                        for (const prop of v.syncable_properties()) {
                            if (!prop.is_unset) {
                                const value = prop.get_value();
                                HasProps._value_record_references(value, refs, { recursive });
                            }
                        }
                    }
                }
            }
            else if ((0, types_1.isArray)(v)) {
                for (const elem of v)
                    HasProps._value_record_references(elem, refs, { recursive });
            }
            else if ((0, types_1.isPlainObject)(v)) {
                for (const elem of (0, object_1.values)(v)) {
                    HasProps._value_record_references(elem, refs, { recursive });
                }
            }
        }
        references() {
            const refs = new Set();
            HasProps._value_record_references(this, refs, { recursive: true });
            return refs;
        }
        _doc_attached() { }
        _doc_detached() { }
        attach_document(doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null) {
                if (this.document == doc)
                    return;
                else
                    throw new Error("models must be owned by only a single document");
            }
            this.document = doc;
            this._doc_attached();
        }
        detach_document() {
            // This should only be called by the Document implementation to unset the document field
            this._doc_detached();
            this.document = null;
        }
        _needs_invalidate(old_value, new_value) {
            const new_refs = new Set();
            HasProps._value_record_references(new_value, new_refs, { recursive: false });
            const old_refs = new Set();
            HasProps._value_record_references(old_value, old_refs, { recursive: false });
            for (const new_id of new_refs) {
                if (!old_refs.has(new_id))
                    return true;
            }
            for (const old_id of old_refs) {
                if (!new_refs.has(old_id))
                    return true;
            }
            return false;
        }
        _push_changes(changes) {
            if (!this.is_syncable)
                return;
            const { document } = this;
            if (document == null)
                return;
            const events = [];
            for (const [prop, , new_value] of changes) {
                if (prop.syncable)
                    events.push(new events_1.ModelChangedEvent(document, this, prop.attr, new_value));
            }
            if (events.length != 0) {
                let event;
                if (events.length == 1)
                    [event] = events;
                else
                    event = new events_1.DocumentEventBatch(document, events);
                document._trigger_on_change(event);
            }
        }
        on_change(properties, fn) {
            for (const property of (0, types_1.isArray)(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
        stream_to(prop, new_data, rollover, { sync } = {}) {
            const data = prop.get_value();
            (0, patching_1.stream_to_columns)(data, new_data, rollover);
            this._clear_watchers();
            prop.set_value(data);
            this.streaming.emit();
            if (this.document != null && (sync !== null && sync !== void 0 ? sync : true)) {
                const event = new events_1.ColumnsStreamedEvent(this.document, this, prop.attr, new_data, rollover);
                this.document._trigger_on_change(event);
            }
        }
        patch_to(prop, patches, { sync } = {}) {
            const data = prop.get_value();
            const patched = (0, patching_1.patch_to_columns)(data, patches);
            this._clear_watchers();
            prop.set_value(data);
            this.patching.emit([...patched]);
            if (this.document != null && (sync !== null && sync !== void 0 ? sync : true)) {
                const event = new events_1.ColumnsPatchedEvent(this.document, this, prop.attr, patches);
                this.document._trigger_on_change(event);
            }
        }
    }
    exports.HasProps = HasProps;
    _a = HasProps;
    (() => {
        _a.prototype._props = {};
        _a.prototype._mixins = [];
    })();
},
/* core/signaling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Based on https://github.com/phosphorjs/phosphor/blob/master/packages/signaling/src/index.ts
    const defer_1 = require(16) /* ./util/defer */;
    const array_1 = require(10) /* ./util/array */;
    class Signal {
        constructor(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        connect(slot, context = null) {
            if (!exports.receivers_for_sender.has(this.sender)) {
                exports.receivers_for_sender.set(this.sender, []);
            }
            const receivers = exports.receivers_for_sender.get(this.sender);
            if (find_connection(receivers, this, slot, context) != null) {
                return false;
            }
            const receiver = context !== null && context !== void 0 ? context : slot;
            if (!senders_for_receiver.has(receiver)) {
                senders_for_receiver.set(receiver, []);
            }
            const senders = senders_for_receiver.get(receiver);
            const connection = { signal: this, slot, context };
            receivers.push(connection);
            senders.push(connection);
            return true;
        }
        disconnect(slot, context = null) {
            const receivers = exports.receivers_for_sender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            const connection = find_connection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            const receiver = context !== null && context !== void 0 ? context : slot;
            const senders = senders_for_receiver.get(receiver);
            connection.signal = null;
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
            return true;
        }
        emit(args) {
            var _a;
            const receivers = (_a = exports.receivers_for_sender.get(this.sender)) !== null && _a !== void 0 ? _a : [];
            for (const { signal, slot, context } of receivers) {
                if (signal === this) {
                    slot.call(context, args, this.sender);
                }
            }
        }
    }
    exports.Signal = Signal;
    Signal.__name__ = "Signal";
    class Signal0 extends Signal {
        emit() {
            super.emit(undefined);
        }
    }
    exports.Signal0 = Signal0;
    Signal0.__name__ = "Signal0";
    (function (Signal) {
        function disconnect_between(sender, receiver) {
            const receivers = exports.receivers_for_sender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            const senders = senders_for_receiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (const connection of senders) {
                if (connection.signal == null)
                    return;
                if (connection.signal.sender === sender)
                    connection.signal = null;
            }
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
        }
        Signal.disconnect_between = disconnect_between;
        function disconnect_sender(sender) {
            var _a;
            const receivers = exports.receivers_for_sender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            for (const connection of receivers) {
                if (connection.signal == null)
                    return;
                const receiver = (_a = connection.context) !== null && _a !== void 0 ? _a : connection.slot;
                connection.signal = null;
                schedule_cleanup(senders_for_receiver.get(receiver));
            }
            schedule_cleanup(receivers);
        }
        Signal.disconnect_sender = disconnect_sender;
        function disconnect_receiver(receiver, slot, except_senders) {
            const senders = senders_for_receiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (const connection of senders) {
                if (connection.signal == null)
                    return;
                if (slot != null && connection.slot != slot)
                    continue;
                const sender = connection.signal.sender;
                if (except_senders != null && except_senders.has(sender))
                    continue;
                connection.signal = null;
                schedule_cleanup(exports.receivers_for_sender.get(sender));
            }
            schedule_cleanup(senders);
        }
        Signal.disconnect_receiver = disconnect_receiver;
        function disconnect_all(obj) {
            const receivers = exports.receivers_for_sender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                for (const connection of receivers) {
                    connection.signal = null;
                }
                schedule_cleanup(receivers);
            }
            const senders = senders_for_receiver.get(obj);
            if (senders != null && senders.length !== 0) {
                for (const connection of senders) {
                    connection.signal = null;
                }
                schedule_cleanup(senders);
            }
        }
        Signal.disconnect_all = disconnect_all;
    })(Signal || (exports.Signal = Signal = {}));
    function Signalable() {
        return class {
            connect(signal, slot) {
                return signal.connect(slot, this);
            }
            disconnect(signal, slot) {
                return signal.disconnect(slot, this);
            }
        };
    }
    exports.Signalable = Signalable;
    /** @internal */
    exports.receivers_for_sender = new WeakMap();
    const senders_for_receiver = new WeakMap();
    function find_connection(conns, signal, slot, context) {
        return (0, array_1.find)(conns, conn => conn.signal === signal && conn.slot === slot && conn.context === context);
    }
    const dirty_set = new Set();
    function schedule_cleanup(connections) {
        if (dirty_set.size === 0) {
            (async () => {
                await (0, defer_1.defer)();
                cleanup_dirty_set();
            })();
        }
        dirty_set.add(connections);
    }
    function cleanup_dirty_set() {
        for (const connections of dirty_set) {
            (0, array_1.remove_by)(connections, (connection) => connection.signal == null);
        }
        dirty_set.clear();
    }
},
/* core/util/defer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const channel = new MessageChannel();
    const tasks = new Map();
    channel.port1.onmessage = (event) => {
        const handle = event.data;
        const fn = tasks.get(handle);
        if (fn != null) {
            try {
                fn();
            }
            finally {
                tasks.delete(handle);
            }
        }
    };
    let counter = 1;
    function defer() {
        return new Promise((resolve) => {
            const handle = counter++;
            tasks.set(handle, resolve);
            channel.port2.postMessage(handle);
        });
    }
    exports.defer = defer;
    function delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    exports.delay = delay;
    function paint() {
        return new Promise((resolve) => {
            requestAnimationFrame(() => resolve());
        });
    }
    exports.paint = paint;
    function idle() {
        return new Promise((resolve) => {
            requestIdleCallback(() => resolve());
        });
    }
    exports.idle = idle;
},
/* core/properties.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.TextBaselineSpec = exports.TextAlignSpec = exports.FontStyleSpec = exports.FontSizeSpec = exports.FontSpec = exports.LineDashSpec = exports.LineCapSpec = exports.LineJoinSpec = exports.MarkerSpec = exports.ArraySpec = exports.NullStringSpec = exports.StringSpec = void 0;
    const tslib_1 = require(1) /* tslib */;
    const signaling_1 = require(15) /* ./signaling */;
    const logging_1 = require(18) /* ./logging */;
    const enums = tslib_1.__importStar(require(19) /* ./enums */);
    const types_1 = require(23) /* ./types */;
    const array_1 = require(10) /* ./util/array */;
    const arrayable_1 = require(13) /* ./util/arrayable */;
    const math_1 = require(11) /* ./util/math */;
    const color_1 = require(21) /* ./util/color */;
    const platform_1 = require(26) /* ./util/platform */;
    const types_2 = require(8) /* ./util/types */;
    const vectorization_1 = require(27) /* ./vectorization */;
    const settings_1 = require(28) /* ./settings */;
    const ndarray_1 = require(29) /* ./util/ndarray */;
    const diagnostics_1 = require(36) /* ./diagnostics */;
    const assert_1 = require(12) /* ./util/assert */;
    const serialization_1 = require(30) /* ./serialization */;
    const uniforms_1 = require(37) /* ./uniforms */;
    __esExport("Uniform", uniforms_1.Uniform);
    __esExport("UniformScalar", uniforms_1.UniformScalar);
    __esExport("UniformVector", uniforms_1.UniformVector);
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        }
        catch (_a) {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return (0, types_2.isPlainObject)(obj) &&
            ((obj.value === undefined ? 0 : 1) +
                (obj.field === undefined ? 0 : 1) +
                (obj.expr === undefined ? 0 : 1) == 1); // garbage JS XOR
    }
    exports.isSpec = isSpec;
    let global_theme = null;
    function use_theme(theme = null) {
        global_theme = theme;
    }
    exports.use_theme = use_theme;
    exports.unset = Symbol("unset");
    class Property {
        constructor(obj, attr, kind, default_value, options = {}) {
            var _a;
            this.obj = obj;
            this.attr = attr;
            this.kind = kind;
            this.default_value = default_value;
            this._value = exports.unset;
            this._initialized = false;
            this._dirty = false;
            this.change = new signaling_1.Signal0(this.obj, "change");
            this.internal = (_a = options.internal) !== null && _a !== void 0 ? _a : false;
            this.convert = options.convert;
            this.on_update = options.on_update;
        }
        get syncable() {
            return !this.internal;
        }
        get is_unset() {
            return this._value === exports.unset;
        }
        get initialized() {
            return this._initialized;
        }
        initialize(initial_value = exports.unset) {
            if (this._initialized)
                throw new Error("already initialized");
            let attr_value = exports.unset;
            if (initial_value !== exports.unset) {
                attr_value = initial_value;
                this._dirty = true;
            }
            else {
                const value = this._default_override();
                if (value !== exports.unset)
                    attr_value = value;
                else {
                    let themed = false;
                    if (global_theme != null) {
                        const value = global_theme.get(this.obj, this.attr);
                        if (value !== undefined) {
                            attr_value = value;
                            themed = true;
                        }
                    }
                    if (!themed) {
                        attr_value = this.default_value(this.obj);
                    }
                }
            }
            if (attr_value !== exports.unset)
                this._update(attr_value);
            else
                this._value = exports.unset;
            this._initialized = true;
        }
        get_value() {
            if (this._value !== exports.unset)
                return this._value;
            else
                throw new Error(`${this.obj}.${this.attr} is unset`);
        }
        set_value(val) {
            if (!this._initialized)
                this.initialize(val);
            else {
                this._update(val);
                this._dirty = true;
            }
            diagnostics_1.diagnostics.report(this);
        }
        // abstract _intrinsic_default(): T
        _default_override() {
            return exports.unset;
        }
        get dirty() {
            return this._dirty;
        }
        //protected abstract _update(attr_value: T): void
        _update(attr_value) {
            var _a;
            this.validate(attr_value);
            if (this.convert != null) {
                const converted = this.convert(attr_value);
                if (converted !== undefined)
                    attr_value = converted;
            }
            this._value = attr_value;
            (_a = this.on_update) === null || _a === void 0 ? void 0 : _a.call(this, attr_value, this.obj);
        }
        toString() {
            /*${this.name}*/
            return `Prop(${this.obj}.${this.attr}, value: ${valueToString(this._value)})`;
        }
        // ----- customizable policies
        normalize(values) {
            return values;
        }
        validate(value) {
            if (!this.valid(value))
                throw new Error(`${this.obj}.${this.attr} given invalid value: ${valueToString(value)}`);
        }
        valid(value) {
            return this.kind.valid(value);
        }
    }
    exports.Property = Property;
    Property.__name__ = "Property";
    class PropertyAlias {
        constructor(attr) {
            this.attr = attr;
        }
    }
    exports.PropertyAlias = PropertyAlias;
    PropertyAlias.__name__ = "PropertyAlias";
    function Alias(attr) {
        return new PropertyAlias(attr);
    }
    exports.Alias = Alias;
    //
    // Primitive Properties
    //
    class PrimitiveProperty extends Property {
    }
    exports.PrimitiveProperty = PrimitiveProperty;
    PrimitiveProperty.__name__ = "PrimitiveProperty";
    class Font extends PrimitiveProperty {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.Font = Font;
    Font.__name__ = "Font";
    //
    // DataSpec properties
    //
    class ScalarSpec extends Property {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        get_value() {
            if (this._value !== exports.unset)
                return this._value;
            else
                throw new Error(`${this.obj}.${this.attr} is unset`);
        }
        _update(attr_value) {
            if (isSpec(attr_value))
                this._value = attr_value;
            else {
                this._value = { value: attr_value }; // Value<T>
            }
            if ((0, types_2.isPlainObject)(this._value)) {
                const { _value } = this;
                this._value[serialization_1.serialize] = (serializer) => {
                    const { value, field, expr, transform, units } = _value;
                    return serializer.encode_struct((() => {
                        if (value !== undefined)
                            return { type: "value", value, transform, units };
                        else if (field !== undefined)
                            return { type: "field", field, transform, units };
                        else
                            return { type: "expr", expr, transform, units };
                    })());
                };
            }
            if ((0, vectorization_1.isValue)(this._value))
                this.validate(this._value.value);
        }
        materialize(value) {
            return value;
        }
        scalar(value, n) {
            return new uniforms_1.UniformScalar(value, n);
        }
        uniform(source) {
            var _a;
            const obj = this.get_value();
            const n = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if ((0, vectorization_1.isExpr)(obj)) {
                const { expr, transform } = obj;
                let result = expr.compute(source);
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else {
                const { value, transform } = obj;
                let result = value;
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        }
    }
    exports.ScalarSpec = ScalarSpec;
    ScalarSpec.__name__ = "ScalarSpec";
    class AnyScalar extends ScalarSpec {
    }
    exports.AnyScalar = AnyScalar;
    AnyScalar.__name__ = "AnyScalar";
    class ColorScalar extends ScalarSpec {
    }
    exports.ColorScalar = ColorScalar;
    ColorScalar.__name__ = "ColorScalar";
    class NumberScalar extends ScalarSpec {
    }
    exports.NumberScalar = NumberScalar;
    NumberScalar.__name__ = "NumberScalar";
    class StringScalar extends ScalarSpec {
    }
    exports.StringScalar = StringScalar;
    StringScalar.__name__ = "StringScalar";
    class NullStringScalar extends ScalarSpec {
    }
    exports.NullStringScalar = NullStringScalar;
    NullStringScalar.__name__ = "NullStringScalar";
    class ArrayScalar extends ScalarSpec {
    }
    exports.ArrayScalar = ArrayScalar;
    ArrayScalar.__name__ = "ArrayScalar";
    class LineJoinScalar extends ScalarSpec {
    }
    exports.LineJoinScalar = LineJoinScalar;
    LineJoinScalar.__name__ = "LineJoinScalar";
    class LineCapScalar extends ScalarSpec {
    }
    exports.LineCapScalar = LineCapScalar;
    LineCapScalar.__name__ = "LineCapScalar";
    class LineDashScalar extends ScalarSpec {
    }
    exports.LineDashScalar = LineDashScalar;
    LineDashScalar.__name__ = "LineDashScalar";
    class FontScalar extends ScalarSpec {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.FontScalar = FontScalar;
    FontScalar.__name__ = "FontScalar";
    class FontSizeScalar extends ScalarSpec {
    }
    exports.FontSizeScalar = FontSizeScalar;
    FontSizeScalar.__name__ = "FontSizeScalar";
    class FontStyleScalar extends ScalarSpec {
    }
    exports.FontStyleScalar = FontStyleScalar;
    FontStyleScalar.__name__ = "FontStyleScalar";
    class TextAlignScalar extends ScalarSpec {
    }
    exports.TextAlignScalar = TextAlignScalar;
    TextAlignScalar.__name__ = "TextAlignScalar";
    class TextBaselineScalar extends ScalarSpec {
    }
    exports.TextBaselineScalar = TextBaselineScalar;
    TextBaselineScalar.__name__ = "TextBaselineScalar";
    class VectorSpec extends Property {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        get_value() {
            if (this._value !== exports.unset)
                return this._value;
            else
                throw new Error(`${this.obj}.${this.attr} is unset`);
        }
        _update(attr_value) {
            if (isSpec(attr_value))
                this._value = attr_value;
            else
                this._value = { value: attr_value }; // Value<T>
            if ((0, types_2.isPlainObject)(this._value)) {
                const { _value } = this;
                this._value[serialization_1.serialize] = (serializer) => {
                    const { value, field, expr, transform, units } = _value;
                    return serializer.encode_struct((() => {
                        if (value !== undefined)
                            return { type: "value", value, transform, units };
                        else if (field !== undefined)
                            return { type: "field", field, transform, units };
                        else
                            return { type: "expr", expr, transform, units };
                    })());
                };
            }
            if ((0, vectorization_1.isValue)(this._value))
                this.validate(this._value.value);
        }
        materialize(value) {
            return value;
        }
        v_materialize(values) {
            return values;
        }
        scalar(value, n) {
            return new uniforms_1.UniformScalar(value, n);
        }
        vector(values) {
            return new uniforms_1.UniformVector(values);
        }
        uniform(source) {
            var _a;
            const obj = this.get_value();
            const n = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if ((0, vectorization_1.isField)(obj)) {
                const { field, transform } = obj;
                let array = source.get_column(field);
                if (array != null) {
                    if (transform != null)
                        array = transform.v_compute(array);
                    array = this.v_materialize(array);
                    return this.vector(array);
                }
                else {
                    logging_1.logger.warn(`attempted to retrieve property array for nonexistent field '${field}'`);
                    return this.scalar(null, n);
                }
            }
            else if ((0, vectorization_1.isExpr)(obj)) {
                const { expr, transform } = obj;
                let array = expr.v_compute(source);
                if (transform != null)
                    array = transform.v_compute(array);
                array = this.v_materialize(array);
                return this.vector(array);
            }
            else if ((0, vectorization_1.isValue)(obj)) {
                const { value, transform } = obj;
                let result = value;
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else
                (0, assert_1.unreachable)();
        }
        array(source) {
            var _a;
            let array;
            const length = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            const obj = this.get_value();
            if ((0, vectorization_1.isField)(obj)) {
                const { field } = obj;
                const column = source.get_column(field);
                if (column != null)
                    array = this.normalize(column);
                else {
                    logging_1.logger.warn(`attempted to retrieve property array for nonexistent field '${field}'`);
                    const missing = new Float64Array(length);
                    missing.fill(NaN);
                    array = missing;
                }
            }
            else if ((0, vectorization_1.isExpr)(obj)) {
                const { expr } = obj;
                array = this.normalize(expr.v_compute(source));
            }
            else {
                const value = this.normalize([obj.value])[0];
                if ((0, types_2.isNumber)(value)) {
                    const values = new Float64Array(length);
                    values.fill(value);
                    array = values;
                }
                else
                    array = (0, array_1.repeat)(value, length);
            }
            const { transform } = obj;
            if (transform != null)
                array = transform.v_compute(array);
            return array;
        }
    }
    exports.VectorSpec = VectorSpec;
    VectorSpec.__name__ = "VectorSpec";
    class DataSpec extends VectorSpec {
    }
    exports.DataSpec = DataSpec;
    DataSpec.__name__ = "DataSpec";
    class UnitsSpec extends VectorSpec {
        constructor() {
            super(...arguments);
            this._value = exports.unset;
        }
        _update(attr_value) {
            super._update(attr_value);
            if (this._value !== exports.unset) {
                const { units } = this._value;
                if (units != null && !(0, array_1.includes)(this.valid_units, units)) {
                    throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${units}`);
                }
            }
        }
        get units() {
            var _a;
            return this._value !== exports.unset ? (_a = this._value.units) !== null && _a !== void 0 ? _a : this.default_units : this.default_units;
        }
        set units(units) {
            if (this._value !== exports.unset) {
                if (units != this.default_units)
                    this._value.units = units;
                else
                    delete this._value.units;
            }
            else
                throw new Error(`${this.obj}.${this.attr} is unset`);
        }
    }
    exports.UnitsSpec = UnitsSpec;
    UnitsSpec.__name__ = "UnitsSpec";
    class NumberUnitsSpec extends UnitsSpec {
        array(source) {
            return new Float64Array(super.array(source));
        }
    }
    exports.NumberUnitsSpec = NumberUnitsSpec;
    NumberUnitsSpec.__name__ = "NumberUnitsSpec";
    class BaseCoordinateSpec extends DataSpec {
    }
    exports.BaseCoordinateSpec = BaseCoordinateSpec;
    BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
    class CoordinateSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSpec = CoordinateSpec;
    CoordinateSpec.__name__ = "CoordinateSpec";
    class CoordinateSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSpec = CoordinateSeqSpec;
    CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
    class CoordinateSeqSeqSeqSpec extends BaseCoordinateSpec {
    }
    exports.CoordinateSeqSeqSeqSpec = CoordinateSeqSeqSeqSpec;
    CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
    class XCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSpec = XCoordinateSpec;
    XCoordinateSpec.__name__ = "XCoordinateSpec";
    class YCoordinateSpec extends CoordinateSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSpec = YCoordinateSpec;
    YCoordinateSpec.__name__ = "YCoordinateSpec";
    class XCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSpec = XCoordinateSeqSpec;
    XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
    class YCoordinateSeqSpec extends CoordinateSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSpec = YCoordinateSeqSpec;
    YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
    class XCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "x";
        }
    }
    exports.XCoordinateSeqSeqSeqSpec = XCoordinateSeqSeqSeqSpec;
    XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
    class YCoordinateSeqSeqSeqSpec extends CoordinateSeqSeqSeqSpec {
        constructor() {
            super(...arguments);
            this.dimension = "y";
        }
    }
    exports.YCoordinateSeqSeqSeqSpec = YCoordinateSeqSeqSeqSpec;
    YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
    class AngleSpec extends NumberUnitsSpec {
        get default_units() { return "rad"; }
        get valid_units() { return [...enums.AngleUnits]; }
        materialize(value) {
            const coeff = -(0, math_1.to_radians_coeff)(this.units);
            return value * coeff;
        }
        v_materialize(values) {
            const coeff = -(0, math_1.to_radians_coeff)(this.units);
            const result = new Float32Array(values.length);
            (0, arrayable_1.mul)(values, coeff, result); // TODO: in-place?
            return result;
        }
        array(_source) {
            throw new Error("not supported");
        }
    }
    exports.AngleSpec = AngleSpec;
    AngleSpec.__name__ = "AngleSpec";
    class DistanceSpec extends NumberUnitsSpec {
        get default_units() { return "data"; }
        get valid_units() { return [...enums.SpatialUnits]; }
    }
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.__name__ = "DistanceSpec";
    class NullDistanceSpec extends DistanceSpec {
        materialize(value) {
            return value !== null && value !== void 0 ? value : NaN;
        }
    }
    exports.NullDistanceSpec = NullDistanceSpec;
    NullDistanceSpec.__name__ = "NullDistanceSpec";
    class BooleanSpec extends DataSpec {
        v_materialize(values) {
            return new Uint8Array(values);
        }
        array(source) {
            return new Uint8Array(super.array(source));
        }
    }
    exports.BooleanSpec = BooleanSpec;
    BooleanSpec.__name__ = "BooleanSpec";
    class IntSpec extends DataSpec {
        v_materialize(values) {
            return (0, types_2.isTypedArray)(values) ? values : new Int32Array(values);
        }
        array(source) {
            return new Int32Array(super.array(source));
        }
    }
    exports.IntSpec = IntSpec;
    IntSpec.__name__ = "IntSpec";
    class NumberSpec extends DataSpec {
        v_materialize(values) {
            return (0, types_2.isTypedArray)(values) ? values : new Float64Array(values);
        }
        array(source) {
            return new Float64Array(super.array(source));
        }
    }
    exports.NumberSpec = NumberSpec;
    NumberSpec.__name__ = "NumberSpec";
    class ScreenSizeSpec extends NumberSpec {
        valid(value) {
            return (0, types_2.isNumber)(value) && value >= 0;
        }
    }
    exports.ScreenSizeSpec = ScreenSizeSpec;
    ScreenSizeSpec.__name__ = "ScreenSizeSpec";
    class ColorSpec extends DataSpec {
        materialize(color) {
            return (0, color_1.encode_rgba)((0, color_1.color2rgba)(color));
        }
        v_materialize(colors) {
            if ((0, ndarray_1.is_NDArray)(colors)) {
                if (colors.dtype == "uint32" && colors.dimension == 1) {
                    return (0, platform_1.to_big_endian)(colors);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 1) {
                    const [n] = colors.shape;
                    const array = new types_1.RGBAArray(4 * n);
                    let j = 0;
                    for (const gray of colors) {
                        array[j++] = gray;
                        array[j++] = gray;
                        array[j++] = gray;
                        array[j++] = 255;
                    }
                    return new types_1.ColorArray(array.buffer);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 2) {
                    const [n, d] = colors.shape;
                    if (d == 4) {
                        return new types_1.ColorArray(colors.buffer);
                    }
                    else if (d == 3) {
                        const array = new types_1.RGBAArray(4 * n);
                        for (let i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if ((colors.dtype == "float32" || colors.dtype == "float64") && colors.dimension == 2) {
                    const [n, d] = colors.shape;
                    if (d == 3 || d == 4) {
                        const array = new types_1.RGBAArray(4 * n);
                        for (let i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = (d == 3 ? 1 : colors[i++]) * 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if (colors.dtype == "object" && colors.dimension == 1) {
                    return this._from_css_array(colors);
                }
            }
            else {
                return this._from_css_array(colors);
            }
            throw new Error("invalid color array");
        }
        _from_css_array(colors) {
            const n = colors.length;
            const array = new types_1.RGBAArray(4 * n);
            let j = 0;
            for (const color of colors) {
                const [r, g, b, a] = (0, color_1.color2rgba)(color);
                array[j++] = r;
                array[j++] = g;
                array[j++] = b;
                array[j++] = a;
            }
            return new types_1.ColorArray(array.buffer);
        }
        vector(values) {
            return new uniforms_1.ColorUniformVector(values);
        }
    }
    exports.ColorSpec = ColorSpec;
    ColorSpec.__name__ = "ColorSpec";
    class NDArraySpec extends DataSpec {
    }
    exports.NDArraySpec = NDArraySpec;
    NDArraySpec.__name__ = "NDArraySpec";
    class AnySpec extends DataSpec {
    }
    exports.AnySpec = AnySpec;
    AnySpec.__name__ = "AnySpec";
    class StringSpec extends DataSpec {
    }
    exports.StringSpec = StringSpec;
    StringSpec.__name__ = "StringSpec";
    class NullStringSpec extends DataSpec {
    }
    exports.NullStringSpec = NullStringSpec;
    NullStringSpec.__name__ = "NullStringSpec";
    class ArraySpec extends DataSpec {
    }
    exports.ArraySpec = ArraySpec;
    ArraySpec.__name__ = "ArraySpec";
    class MarkerSpec extends DataSpec {
    }
    exports.MarkerSpec = MarkerSpec;
    MarkerSpec.__name__ = "MarkerSpec";
    class LineJoinSpec extends DataSpec {
    }
    exports.LineJoinSpec = LineJoinSpec;
    LineJoinSpec.__name__ = "LineJoinSpec";
    class LineCapSpec extends DataSpec {
    }
    exports.LineCapSpec = LineCapSpec;
    LineCapSpec.__name__ = "LineCapSpec";
    class LineDashSpec extends DataSpec {
    }
    exports.LineDashSpec = LineDashSpec;
    LineDashSpec.__name__ = "LineDashSpec";
    class FontSpec extends DataSpec {
        _default_override() {
            return settings_1.settings.dev ? "Bokeh" : exports.unset;
        }
    }
    exports.FontSpec = FontSpec;
    FontSpec.__name__ = "FontSpec";
    class FontSizeSpec extends DataSpec {
    }
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.__name__ = "FontSizeSpec";
    class FontStyleSpec extends DataSpec {
    }
    exports.FontStyleSpec = FontStyleSpec;
    FontStyleSpec.__name__ = "FontStyleSpec";
    class TextAlignSpec extends DataSpec {
    }
    exports.TextAlignSpec = TextAlignSpec;
    TextAlignSpec.__name__ = "TextAlignSpec";
    class TextBaselineSpec extends DataSpec {
    }
    exports.TextBaselineSpec = TextBaselineSpec;
    TextBaselineSpec.__name__ = "TextBaselineSpec";
},
/* core/logging.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // This is based on https://github.com/pimterry/loglevel
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const _loggers = {};
    class LogLevel {
        constructor(name, level) {
            this.name = name;
            this.level = level;
        }
    }
    exports.LogLevel = LogLevel;
    LogLevel.__name__ = "LogLevel";
    class Logger {
        constructor(name, level = Logger.INFO) {
            this._name = name;
            this.set_level(level);
        }
        static get levels() {
            return Object.keys(Logger.log_levels);
        }
        static get(name, level = Logger.INFO) {
            if (name.length > 0) {
                if (name in _loggers)
                    return _loggers[name];
                else
                    return _loggers[name] = new Logger(name, level);
            }
            else
                throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
        }
        get level() {
            return this.get_level();
        }
        get_level() {
            return this._log_level;
        }
        set_level(log_level) {
            if (log_level instanceof LogLevel)
                this._log_level = log_level;
            else if ((0, types_1.isString)(log_level) && log_level in Logger.log_levels)
                this._log_level = Logger.log_levels[log_level];
            else
                throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
            const logger_name = `[${this._name}]`;
            for (const [name, log_level] of (0, object_1.entries)(Logger.log_levels)) {
                if (log_level.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
                    this[name] = function () { };
                else
                    this[name] = _method_factory(name, logger_name);
            }
        }
        trace(..._args) { }
        debug(..._args) { }
        info(..._args) { }
        warn(..._args) { }
        error(..._args) { }
    }
    exports.Logger = Logger;
    Logger.__name__ = "Logger";
    Logger.TRACE = new LogLevel("trace", 0);
    Logger.DEBUG = new LogLevel("debug", 1);
    Logger.INFO = new LogLevel("info", 2);
    Logger.WARN = new LogLevel("warn", 6);
    Logger.ERROR = new LogLevel("error", 7);
    Logger.FATAL = new LogLevel("fatal", 8);
    Logger.OFF = new LogLevel("off", 9);
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF,
    };
    function _method_factory(method_name, logger_name) {
        if (console[method_name] != null)
            return console[method_name].bind(console, logger_name);
        else
            return console.log.bind(console, logger_name);
    }
    exports.logger = Logger.get("bokeh");
    function set_log_level(level) {
        const previous_level = exports.logger.level;
        if ((0, types_1.isString)(level) && !(level in Logger.log_levels)) {
            console.log(`[bokeh] unrecognized logging level '${level}' passed to Bokeh.set_log_level(), ignoring`);
            console.log(`[bokeh] valid log levels are: ${Logger.levels.join(", ")}`);
        }
        else {
            console.log(`[bokeh] setting log level to: '${(0, types_1.isString)(level) ? level : level.level}'`);
            exports.logger.set_level(level);
        }
        return previous_level;
    }
    exports.set_log_level = set_log_level;
    function with_log_level(level, fn) {
        const original = set_log_level(level);
        try {
            fn();
        }
        finally {
            set_log_level(original);
        }
    }
    exports.with_log_level = with_log_level;
},
/* core/enums.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.ToolIcon = exports.VerticalAlign = exports.UpdateMode = exports.TooltipAttachment = exports.TickLabelOrientation = exports.TextureRepetition = exports.TextBaseline = exports.TextAlign = exports.TapBehavior = void 0;
    const kinds_1 = require(20) /* ./kinds */;
    exports.Align = (0, kinds_1.Enum)("start", "center", "end");
    exports.HAlign = (0, kinds_1.Enum)("left", "center", "right");
    exports.VAlign = (0, kinds_1.Enum)("top", "center", "bottom");
    exports.Anchor = (0, kinds_1.Enum)("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom");
    exports.AngleUnits = (0, kinds_1.Enum)("deg", "rad", "grad", "turn");
    exports.BoxOrigin = (0, kinds_1.Enum)("corner", "center");
    exports.ButtonType = (0, kinds_1.Enum)("default", "primary", "success", "warning", "danger", "light");
    exports.CalendarPosition = (0, kinds_1.Enum)("auto", "above", "below");
    exports.CoordinateUnits = (0, kinds_1.Enum)("canvas", "screen", "data");
    exports.ContextWhich = (0, kinds_1.Enum)("start", "center", "end", "all");
    exports.Dimension = (0, kinds_1.Enum)("width", "height");
    exports.Dimensions = (0, kinds_1.Enum)("width", "height", "both");
    exports.Direction = (0, kinds_1.Enum)("clock", "anticlock");
    exports.Distribution = (0, kinds_1.Enum)("uniform", "normal");
    exports.FlowMode = (0, kinds_1.Enum)("block", "inline");
    exports.FontStyle = (0, kinds_1.Enum)("normal", "italic", "bold", "bold italic");
    exports.HatchPatternType = (0, kinds_1.Enum)("blank", "dot", "ring", "horizontal_line", "vertical_line", "cross", "horizontal_dash", "vertical_dash", "spiral", "right_diagonal_line", "left_diagonal_line", "diagonal_cross", "right_diagonal_dash", "left_diagonal_dash", "horizontal_wave", "vertical_wave", "criss_cross", " ", ".", "o", "-", "|", "+", '"', ":", "@", "/", "\\", "x", ",", "`", "v", ">", "*");
    exports.HTTPMethod = (0, kinds_1.Enum)("POST", "GET");
    exports.HexTileOrientation = (0, kinds_1.Enum)("pointytop", "flattop");
    exports.HoverMode = (0, kinds_1.Enum)("mouse", "hline", "vline");
    exports.ImageOrigin = (0, kinds_1.Enum)("bottom_left", "top_left", "bottom_right", "top_right");
    exports.LatLon = (0, kinds_1.Enum)("lat", "lon");
    exports.LegendClickPolicy = (0, kinds_1.Enum)("none", "hide", "mute");
    exports.LegendLocation = exports.Anchor;
    exports.LineCap = (0, kinds_1.Enum)("butt", "round", "square");
    exports.LineDash = (0, kinds_1.Enum)("solid", "dashed", "dotted", "dotdash", "dashdot");
    exports.LineJoin = (0, kinds_1.Enum)("miter", "round", "bevel");
    exports.LinePolicy = (0, kinds_1.Enum)("prev", "next", "nearest", "interp", "none");
    exports.Location = (0, kinds_1.Enum)("above", "below", "left", "right");
    exports.Logo = (0, kinds_1.Enum)("normal", "grey");
    exports.MapType = (0, kinds_1.Enum)("satellite", "roadmap", "terrain", "hybrid");
    exports.MarkerType = (0, kinds_1.Enum)("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y");
    exports.MutedPolicy = (0, kinds_1.Enum)("show", "ignore");
    exports.Orientation = (0, kinds_1.Enum)("vertical", "horizontal");
    exports.OutputBackend = (0, kinds_1.Enum)("canvas", "svg", "webgl");
    exports.PaddingUnits = (0, kinds_1.Enum)("percent", "absolute");
    exports.Place = (0, kinds_1.Enum)("above", "below", "left", "right", "center");
    exports.PointPolicy = (0, kinds_1.Enum)("snap_to_data", "follow_mouse", "none");
    exports.RadiusDimension = (0, kinds_1.Enum)("x", "y", "max", "min");
    exports.RenderLevel = (0, kinds_1.Enum)("image", "underlay", "glyph", "guide", "annotation", "overlay");
    exports.ResetPolicy = (0, kinds_1.Enum)("standard", "event_only");
    exports.RoundingFunction = (0, kinds_1.Enum)("round", "nearest", "floor", "rounddown", "ceil", "roundup");
    exports.ScrollbarPolicy = (0, kinds_1.Enum)("auto", "visible", "hidden");
    exports.SelectionMode = (0, kinds_1.Enum)("replace", "append", "intersect", "subtract");
    exports.Side = (0, kinds_1.Enum)("above", "below", "left", "right");
    exports.SizingMode = (0, kinds_1.Enum)("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed", "inherit");
    exports.Sort = (0, kinds_1.Enum)("ascending", "descending");
    exports.SpatialUnits = (0, kinds_1.Enum)("screen", "data");
    exports.StartEnd = (0, kinds_1.Enum)("start", "end");
    exports.StepMode = (0, kinds_1.Enum)("after", "before", "center");
    exports.TapBehavior = (0, kinds_1.Enum)("select", "inspect");
    exports.TextAlign = (0, kinds_1.Enum)("left", "right", "center");
    exports.TextBaseline = (0, kinds_1.Enum)("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
    exports.TextureRepetition = (0, kinds_1.Enum)("repeat", "repeat_x", "repeat_y", "no_repeat");
    exports.TickLabelOrientation = (0, kinds_1.Enum)("vertical", "horizontal", "parallel", "normal");
    exports.TooltipAttachment = (0, kinds_1.Enum)("horizontal", "vertical", "left", "right", "above", "below");
    exports.UpdateMode = (0, kinds_1.Enum)("replace", "append");
    exports.VerticalAlign = (0, kinds_1.Enum)("top", "middle", "bottom");
    exports.ToolIcon = (0, kinds_1.Enum)("append_mode", "box_edit", "box_select", "box_zoom", "clear_selection", "copy", "crosshair", "freehand_draw", "help", "hover", "intersect_mode", "lasso_select", "line_edit", "pan", "point_draw", "poly_draw", "poly_edit", "polygon_select", "range", "redo", "replace_mode", "reset", "save", "subtract_mode", "tap_select", "undo", "wheel_pan", "wheel_zoom", "xpan", "ypan", "zoom_in", "zoom_out");
},
/* core/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const tp = tslib_1.__importStar(require(8) /* ./util/types */);
    const color_1 = require(21) /* ./util/color */;
    const object_1 = require(9) /* ./util/object */;
    const ESMap = globalThis.Map;
    const ESSet = globalThis.Set;
    const { hasOwnProperty } = Object.prototype;
    class Kind {
    }
    exports.Kind = Kind;
    Kind.__name__ = "Kind";
    (function (Kinds) {
        var _a;
        class Any extends Kind {
            constructor() {
                super(...arguments);
                this[_a] = "Any";
            }
            valid(_value) {
                return true;
            }
            toString() {
                return "Any";
            }
        }
        _a = Symbol.toStringTag;
        Any.__name__ = "Any";
        Kinds.Any = Any;
        class Unknown extends Kind {
            valid(_value) {
                return true;
            }
            toString() {
                return "Unknown";
            }
        }
        Unknown.__name__ = "Unknown";
        Kinds.Unknown = Unknown;
        class Boolean extends Kind {
            valid(value) {
                return tp.isBoolean(value);
            }
            toString() {
                return "Boolean";
            }
        }
        Boolean.__name__ = "Boolean";
        Kinds.Boolean = Boolean;
        class Ref extends Kind {
            constructor(obj_type) {
                super();
                this.obj_type = obj_type;
            }
            valid(value) {
                return value instanceof this.obj_type;
            }
            toString() {
                var _b;
                const tp = this.obj_type;
                // NOTE: `__name__` is injected by a compiler transform
                const name = (_b = tp.__name__) !== null && _b !== void 0 ? _b : tp.toString();
                return `Ref(${name})`;
            }
        }
        Ref.__name__ = "Ref";
        Kinds.Ref = Ref;
        class AnyRef extends Kind {
            valid(value) {
                return tp.isObject(value);
            }
            toString() {
                return "AnyRef";
            }
        }
        AnyRef.__name__ = "AnyRef";
        Kinds.AnyRef = AnyRef;
        class Number extends Kind {
            valid(value) {
                return tp.isNumber(value);
            }
            toString() {
                return "Number";
            }
        }
        Number.__name__ = "Number";
        Kinds.Number = Number;
        class Int extends Number {
            valid(value) {
                return super.valid(value) && tp.isInteger(value);
            }
            toString() {
                return "Int";
            }
        }
        Int.__name__ = "Int";
        Kinds.Int = Int;
        class Percent extends Number {
            valid(value) {
                return super.valid(value) && 0 <= value && value <= 1;
            }
            toString() {
                return "Percent";
            }
        }
        Percent.__name__ = "Percent";
        Kinds.Percent = Percent;
        class Or extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                return this.types.some((type) => type.valid(value));
            }
            toString() {
                return `Or(${this.types.map((type) => type.toString()).join(", ")})`;
            }
        }
        Or.__name__ = "Or";
        Kinds.Or = Or;
        class Tuple extends Kind {
            constructor(types) {
                super();
                this.types = types;
                this.types = types;
            }
            valid(value) {
                if (!tp.isArray(value))
                    return false;
                for (let i = 0; i < this.types.length; i++) {
                    const type = this.types[i];
                    const item = value[i];
                    if (!type.valid(item))
                        return false;
                }
                return true;
            }
            toString() {
                return `Tuple(${this.types.map((type) => type.toString()).join(", ")})`;
            }
        }
        Tuple.__name__ = "Tuple";
        Kinds.Tuple = Tuple;
        class Struct extends Kind {
            constructor(struct_type) {
                super();
                this.struct_type = struct_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value))
                    return false;
                const { struct_type } = this;
                for (const key of (0, object_1.keys)(value)) {
                    if (!hasOwnProperty.call(struct_type, key))
                        return false;
                }
                for (const key in struct_type) {
                    if (hasOwnProperty.call(struct_type, key)) {
                        const item_type = struct_type[key];
                        const item = value[key];
                        if (!item_type.valid(item))
                            return false;
                    }
                }
                return true;
            }
            toString() {
                const items = (0, object_1.entries)(this.struct_type).map(([key, kind]) => `${key}: ${kind}`).join(", ");
                return `Struct({${items}})`;
            }
        }
        Struct.__name__ = "Struct";
        Kinds.Struct = Struct;
        class Arrayable extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isArray(value) || tp.isTypedArray(value); // TODO: too specific
            }
            toString() {
                return `Arrayable(${this.item_type.toString()})`;
            }
        }
        Arrayable.__name__ = "Arrayable";
        Kinds.Arrayable = Arrayable;
        class Array extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                return tp.isArray(value) && value.every((item) => this.item_type.valid(item));
            }
            toString() {
                return `Array(${this.item_type.toString()})`;
            }
        }
        Array.__name__ = "Array";
        Kinds.Array = Array;
        class Null extends Kind {
            valid(value) {
                return value === null;
            }
            toString() {
                return "Null";
            }
        }
        Null.__name__ = "Null";
        Kinds.Null = Null;
        class Nullable extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === null || this.base_type.valid(value);
            }
            toString() {
                return `Nullable(${this.base_type.toString()})`;
            }
        }
        Nullable.__name__ = "Nullable";
        Kinds.Nullable = Nullable;
        class Opt extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return value === undefined || this.base_type.valid(value);
            }
            toString() {
                return `Opt(${this.base_type.toString()})`;
            }
        }
        Opt.__name__ = "Opt";
        Kinds.Opt = Opt;
        class Bytes extends Kind {
            valid(value) {
                return value instanceof ArrayBuffer;
            }
            toString() {
                return "Bytes";
            }
        }
        Bytes.__name__ = "Bytes";
        Kinds.Bytes = Bytes;
        class String extends Kind {
            valid(value) {
                return tp.isString(value);
            }
            toString() {
                return "String";
            }
        }
        String.__name__ = "String";
        Kinds.String = String;
        class Regex extends String {
            constructor(regex) {
                super();
                this.regex = regex;
            }
            valid(value) {
                return super.valid(value) && this.regex.test(value);
            }
            toString() {
                return `Regex(${this.regex.toString()})`;
            }
        }
        Regex.__name__ = "Regex";
        Kinds.Regex = Regex;
        class Enum extends Kind {
            constructor(values) {
                super();
                this.values = new ESSet(values);
            }
            valid(value) {
                return this.values.has(value);
            }
            *[Symbol.iterator]() {
                yield* this.values;
            }
            toString() {
                return `Enum(${[...this.values].map((v) => v.toString()).join(", ")})`;
            }
        }
        Enum.__name__ = "Enum";
        Kinds.Enum = Enum;
        class Dict extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                if (!tp.isPlainObject(value))
                    return false;
                for (const key in value) {
                    if (hasOwnProperty.call(value, key)) {
                        const item = value[key];
                        if (!this.item_type.valid(item))
                            return false;
                    }
                }
                return true;
            }
            toString() {
                return `Dict(${this.item_type.toString()})`;
            }
        }
        Dict.__name__ = "Dict";
        Kinds.Dict = Dict;
        class Map extends Kind {
            constructor(key_type, item_type) {
                super();
                this.key_type = key_type;
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESMap))
                    return false;
                for (const [key, item] of value.entries()) {
                    if (!(this.key_type.valid(key) && this.item_type.valid(item)))
                        return false;
                }
                return true;
            }
            toString() {
                return `Map(${this.key_type.toString()}, ${this.item_type.toString()})`;
            }
        }
        Map.__name__ = "Map";
        Kinds.Map = Map;
        class Set extends Kind {
            constructor(item_type) {
                super();
                this.item_type = item_type;
            }
            valid(value) {
                if (!(value instanceof ESSet))
                    return false;
                for (const item of value) {
                    if (!this.item_type.valid(item))
                        return false;
                }
                return true;
            }
            toString() {
                return `Set(${this.item_type.toString()})`;
            }
        }
        Set.__name__ = "Set";
        Kinds.Set = Set;
        class Color extends Kind {
            valid(value) {
                return (0, color_1.is_Color)(value);
            }
            toString() {
                return "Color";
            }
        }
        Color.__name__ = "Color";
        Kinds.Color = Color;
        class CSSLength extends String {
            /*
            override valid(value: unknown): value is string {
              return super.valid(value) // TODO: && this._parse(value)
            }
            */
            toString() {
                return "CSSLength";
            }
        }
        CSSLength.__name__ = "CSSLength";
        Kinds.CSSLength = CSSLength;
        class Function extends Kind {
            valid(value) {
                return tp.isFunction(value);
            }
            toString() {
                return "Function(...)";
            }
        }
        Function.__name__ = "Function";
        Kinds.Function = Function;
        class NonNegative extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return this.base_type.valid(value) && value >= 0;
            }
            toString() {
                return `NonNegative(${this.base_type.toString()})`;
            }
        }
        NonNegative.__name__ = "NonNegative";
        Kinds.NonNegative = NonNegative;
        class Positive extends Kind {
            constructor(base_type) {
                super();
                this.base_type = base_type;
            }
            valid(value) {
                return this.base_type.valid(value) && value > 0;
            }
            toString() {
                return `Positive(${this.base_type.toString()})`;
            }
        }
        Positive.__name__ = "Positive";
        Kinds.Positive = Positive;
        class DOMNode extends Kind {
            valid(value) {
                return value instanceof Node;
            }
            toString() {
                return "DOMNode";
            }
        }
        DOMNode.__name__ = "DOMNode";
        Kinds.DOMNode = DOMNode;
    })(exports.Kinds || (exports.Kinds = {}));
    exports.Any = new exports.Kinds.Any();
    exports.Unknown = new exports.Kinds.Unknown();
    exports.Boolean = new exports.Kinds.Boolean();
    exports.Number = new exports.Kinds.Number();
    exports.Int = new exports.Kinds.Int();
    exports.Bytes = new exports.Kinds.Bytes();
    exports.String = new exports.Kinds.String();
    const Regex = (regex) => new exports.Kinds.Regex(regex);
    exports.Regex = Regex;
    exports.Null = new exports.Kinds.Null();
    const Nullable = (base_type) => new exports.Kinds.Nullable(base_type);
    exports.Nullable = Nullable;
    const Opt = (base_type) => new exports.Kinds.Opt(base_type);
    exports.Opt = Opt;
    const Or = (...types) => new exports.Kinds.Or(types);
    exports.Or = Or;
    const Tuple = (...types) => new exports.Kinds.Tuple(types);
    exports.Tuple = Tuple;
    const Struct = (struct_type) => new exports.Kinds.Struct(struct_type);
    exports.Struct = Struct;
    const Arrayable = (item_type) => new exports.Kinds.Arrayable(item_type);
    exports.Arrayable = Arrayable;
    const Array = (item_type) => new exports.Kinds.Array(item_type);
    exports.Array = Array;
    const Dict = (item_type) => new exports.Kinds.Dict(item_type);
    exports.Dict = Dict;
    const Map = (key_type, item_type) => new exports.Kinds.Map(key_type, item_type);
    exports.Map = Map;
    const Set = (item_type) => new exports.Kinds.Set(item_type);
    exports.Set = Set;
    const Enum = (...values) => new exports.Kinds.Enum(values);
    exports.Enum = Enum;
    const Ref = (obj_type) => new exports.Kinds.Ref(obj_type);
    exports.Ref = Ref;
    const AnyRef = () => new exports.Kinds.AnyRef();
    exports.AnyRef = AnyRef;
    const Function = () => new exports.Kinds.Function();
    exports.Function = Function;
    exports.DOMNode = new exports.Kinds.DOMNode();
    const NonNegative = (base_type) => new exports.Kinds.NonNegative(base_type);
    exports.NonNegative = NonNegative;
    const Positive = (base_type) => new exports.Kinds.Positive(base_type);
    exports.Positive = Positive;
    exports.Percent = new exports.Kinds.Percent();
    exports.Alpha = exports.Percent;
    exports.Color = new exports.Kinds.Color();
    exports.Auto = (0, exports.Enum)("auto");
    exports.CSSLength = new exports.Kinds.CSSLength();
    exports.FontSize = exports.String;
    exports.Font = exports.String;
    exports.Angle = exports.Number;
},
/* core/util/color.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const svg_colors_1 = require(22) /* ./svg_colors */;
    const math_1 = require(11) /* ./math */;
    const types_1 = require(8) /* ./types */;
    const { round, sqrt } = Math;
    function byte(v) {
        return (0, math_1.clamp)(round(v), 0, 255);
    }
    function transparent() {
        return [0, 0, 0, 0];
    }
    exports.transparent = transparent;
    function encode_rgba([r, g, b, a]) {
        return r << 24 | g << 16 | b << 8 | a;
    }
    exports.encode_rgba = encode_rgba;
    function decode_rgba(rgba) {
        const r = (rgba >> 24) & 0xff;
        const g = (rgba >> 16) & 0xff;
        const b = (rgba >> 8) & 0xff;
        const a = rgba & 0xff;
        return [r, g, b, a];
    }
    exports.decode_rgba = decode_rgba;
    function color2rgba(color, alpha = 1.0) {
        const [r, g, b, a] = (() => {
            var _a;
            if (color == null)
                return transparent();
            else if ((0, types_1.isInteger)(color))
                return decode_rgba(color);
            else if ((0, types_1.isString)(color))
                return (_a = css4_parse(color)) !== null && _a !== void 0 ? _a : transparent();
            else {
                if (color.length == 2) {
                    const [name, alpha] = color;
                    return color2rgba(name, alpha);
                }
                else {
                    const [r, g, b, a = 1.0] = color;
                    return [r, g, b, byte(a * 255)];
                }
            }
        })();
        return [r, g, b, byte(alpha * a)];
    }
    exports.color2rgba = color2rgba;
    const _hex_table = {
        0: "0", 1: "1", 2: "2", 3: "3", 4: "4", 5: "5", 6: "6", 7: "7", 8: "8", 9: "9",
        10: "a", 11: "b", 12: "c", 13: "d", 14: "e", 15: "f",
    };
    function hex(v) {
        return _hex_table[v >> 4] + _hex_table[v & 0xf];
    }
    function color2css(color, alpha) {
        const [r, g, b, a] = color2rgba(color, alpha);
        return `rgba(${r}, ${g}, ${b}, ${a / 255})`;
    }
    exports.color2css = color2css;
    function color2hex(color, alpha) {
        const [r, g, b, a] = color2rgba(color, alpha);
        const rgb = `#${hex(r)}${hex(g)}${hex(b)}`;
        return a == 255 ? rgb : `${rgb}${hex(a)}`;
    }
    exports.color2hex = color2hex;
    function color2hexrgb(color) {
        const [r, g, b] = color2rgba(color);
        return `#${hex(r)}${hex(g)}${hex(b)}`;
    }
    exports.color2hexrgb = color2hexrgb;
    /*
    let _last_color = "transparent"
    let _last_alpha = 1.0
    let _last_rgba = transparent()
    
    export function _color2rgba(color: string | null, alpha: number = 1.0): RGBA {
      if (color == _last_color && alpha == _last_alpha)
        return [..._last_rgba]
    
      const [r, g, b, a] = parsed
      const rgba: RGBA = [r, g, b, a == 255 ? byte(alpha*255) : a]
      _last_color = color
      _last_alpha = alpha
      _last_rgba = rgba
      return rgba
    }
    */
    const rgb_modern = /^rgba?\(\s*(?<r>[^\s,]+?)\s+(?<g>[^\s,]+?)\s+(?<b>[^\s,]+?)(?:\s*\/\s*(?<a>[^\s,]+?))?\s*\)$/;
    const rgb_legacy = /^rgba?\(\s*(?<r>[^\s,]+?)\s*,\s*(?<g>[^\s,]+?)\s*,\s*(?<b>[^\s,]+?)(?:\s*,\s*(?<a>[^\s,]+?))?\s*\)$/;
    const css4_normalize = (() => {
        const canvas = document.createElement("canvas");
        canvas.width = 1;
        canvas.height = 1;
        const ctx = canvas.getContext("2d");
        const gradient = ctx.createLinearGradient(0, 0, 1, 1);
        return (color) => {
            ctx.fillStyle = gradient; // lgtm [js/useless-assignment-to-property]
            ctx.fillStyle = color;
            const style = ctx.fillStyle;
            return style != gradient ? style : null;
        };
    })();
    function css4_parse(color) {
        var _a;
        /**
          Parses CSS4 color strings:
      
          - transparent
          - named color
          - #RRGGBB[AA]
          - #RGB[A]
          - rgb[a](R G B[ / A])
          - rgb[a](R, G, B[, A])
          - other CSS4 syntax (browser dependent)
      
        */
        color = color.trim().toLowerCase();
        if (!color)
            return null;
        else if (color == "transparent")
            return transparent();
        else if ((0, svg_colors_1.is_named_color)(color)) {
            return decode_rgba(svg_colors_1.named_colors[color]);
        }
        else if (color[0] == "#") {
            const v = Number(`0x${color.substring(1)}`);
            if (isNaN(v))
                return null;
            switch (color.length - 1) {
                case 3: {
                    const r = (v >> 8) & 0xf;
                    const g = (v >> 4) & 0xf;
                    const b = (v >> 0) & 0xf;
                    const rr = (r << 4) | r;
                    const gg = (g << 4) | g;
                    const bb = (b << 4) | b;
                    return [rr, gg, bb, 255];
                }
                case 4: {
                    const r = (v >> 12) & 0xf;
                    const g = (v >> 8) & 0xf;
                    const b = (v >> 4) & 0xf;
                    const a = (v >> 0) & 0xf;
                    const rr = (r << 4) | r;
                    const gg = (g << 4) | g;
                    const bb = (b << 4) | b;
                    const aa = (a << 4) | a;
                    return [rr, gg, bb, aa];
                }
                case 6: {
                    const rr = (v >> 16) & 0xff;
                    const gg = (v >> 8) & 0xff;
                    const bb = (v >> 0) & 0xff;
                    return [rr, gg, bb, 255];
                }
                case 8: {
                    const rr = (v >> 24) & 0xff;
                    const gg = (v >> 16) & 0xff;
                    const bb = (v >> 8) & 0xff;
                    const aa = (v >> 0) & 0xff;
                    return [rr, gg, bb, aa];
                }
            }
        }
        else if (color.startsWith("rgb")) {
            const result = (_a = color.match(rgb_modern)) !== null && _a !== void 0 ? _a : color.match(rgb_legacy);
            if ((result === null || result === void 0 ? void 0 : result.groups) != null) {
                let { r, g, b, a = "1" } = result.groups;
                const rp = r.endsWith("%");
                const gp = g.endsWith("%");
                const bp = b.endsWith("%");
                const ap = a.endsWith("%");
                if (!(rp && gp && bp || (!rp && !gp && !bp)))
                    return null;
                if (rp)
                    r = r.slice(0, -1);
                if (gp)
                    g = g.slice(0, -1);
                if (bp)
                    b = b.slice(0, -1);
                if (ap)
                    a = a.slice(0, -1);
                let R = Number(r);
                let G = Number(g);
                let B = Number(b);
                let A = Number(a);
                if (isNaN(R + G + B + A))
                    return null;
                if (rp)
                    R = 255 * (R / 100);
                if (gp)
                    G = 255 * (G / 100);
                if (bp)
                    B = 255 * (B / 100);
                A = 255 * (ap ? A / 100 : A);
                R = byte(R);
                G = byte(G);
                B = byte(B);
                A = byte(A);
                return [R, G, B, A];
            }
        }
        else {
            const style = css4_normalize(color);
            if (style != null)
                return css4_parse(style);
        }
        return null;
    }
    exports.css4_parse = css4_parse;
    function is_Color(value) {
        if ((0, types_1.isInteger)(value))
            return true;
        if ((0, types_1.isString)(value) && css4_parse(value) != null)
            return true;
        if ((0, types_1.isArray)(value) && (value.length == 3 || value.length == 4))
            return true;
        return false;
    }
    exports.is_Color = is_Color;
    function is_dark([r, g, b]) {
        const l = 1 - (0.299 * r + 0.587 * g + 0.114 * b) / 255;
        return l >= 0.6;
    }
    exports.is_dark = is_dark;
    function brightness(color) {
        // Perceived brightness of a color in [0, 1] range.
        // http://alienryderflex.com/hsp.html
        const [r, g, b] = color2rgba(color);
        return sqrt(0.299 * r ** 2 + 0.587 * g ** 2 + 0.114 * b ** 2) / 255;
    }
    exports.brightness = brightness;
},
/* core/util/svg_colors.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const _named_colors = {
        aliceblue: 0xf0f8ffff,
        antiquewhite: 0xfaebd7ff,
        aqua: 0x00ffffff,
        aquamarine: 0x7fffd4ff,
        azure: 0xf0ffffff,
        beige: 0xf5f5dcff,
        bisque: 0xffe4c4ff,
        black: 0x000000ff,
        blanchedalmond: 0xffebcdff,
        blue: 0x0000ffff,
        blueviolet: 0x8a2be2ff,
        brown: 0xa52a2aff,
        burlywood: 0xdeb887ff,
        cadetblue: 0x5f9ea0ff,
        chartreuse: 0x7fff00ff,
        chocolate: 0xd2691eff,
        coral: 0xff7f50ff,
        cornflowerblue: 0x6495edff,
        cornsilk: 0xfff8dcff,
        crimson: 0xdc143cff,
        cyan: 0x00ffffff,
        darkblue: 0x00008bff,
        darkcyan: 0x008b8bff,
        darkgoldenrod: 0xb8860bff,
        darkgray: 0xa9a9a9ff,
        darkgreen: 0x006400ff,
        darkgrey: 0xa9a9a9ff,
        darkkhaki: 0xbdb76bff,
        darkmagenta: 0x8b008bff,
        darkolivegreen: 0x556b2fff,
        darkorange: 0xff8c00ff,
        darkorchid: 0x9932ccff,
        darkred: 0x8b0000ff,
        darksalmon: 0xe9967aff,
        darkseagreen: 0x8fbc8fff,
        darkslateblue: 0x483d8bff,
        darkslategray: 0x2f4f4fff,
        darkslategrey: 0x2f4f4fff,
        darkturquoise: 0x00ced1ff,
        darkviolet: 0x9400d3ff,
        deeppink: 0xff1493ff,
        deepskyblue: 0x00bfffff,
        dimgray: 0x696969ff,
        dimgrey: 0x696969ff,
        dodgerblue: 0x1e90ffff,
        firebrick: 0xb22222ff,
        floralwhite: 0xfffaf0ff,
        forestgreen: 0x228b22ff,
        fuchsia: 0xff00ffff,
        gainsboro: 0xdcdcdcff,
        ghostwhite: 0xf8f8ffff,
        gold: 0xffd700ff,
        goldenrod: 0xdaa520ff,
        gray: 0x808080ff,
        green: 0x008000ff,
        greenyellow: 0xadff2fff,
        grey: 0x808080ff,
        honeydew: 0xf0fff0ff,
        hotpink: 0xff69b4ff,
        indianred: 0xcd5c5cff,
        indigo: 0x4b0082ff,
        ivory: 0xfffff0ff,
        khaki: 0xf0e68cff,
        lavender: 0xe6e6faff,
        lavenderblush: 0xfff0f5ff,
        lawngreen: 0x7cfc00ff,
        lemonchiffon: 0xfffacdff,
        lightblue: 0xadd8e6ff,
        lightcoral: 0xf08080ff,
        lightcyan: 0xe0ffffff,
        lightgoldenrodyellow: 0xfafad2ff,
        lightgray: 0xd3d3d3ff,
        lightgreen: 0x90ee90ff,
        lightgrey: 0xd3d3d3ff,
        lightpink: 0xffb6c1ff,
        lightsalmon: 0xffa07aff,
        lightseagreen: 0x20b2aaff,
        lightskyblue: 0x87cefaff,
        lightslategray: 0x778899ff,
        lightslategrey: 0x778899ff,
        lightsteelblue: 0xb0c4deff,
        lightyellow: 0xffffe0ff,
        lime: 0x00ff00ff,
        limegreen: 0x32cd32ff,
        linen: 0xfaf0e6ff,
        magenta: 0xff00ffff,
        maroon: 0x800000ff,
        mediumaquamarine: 0x66cdaaff,
        mediumblue: 0x0000cdff,
        mediumorchid: 0xba55d3ff,
        mediumpurple: 0x9370dbff,
        mediumseagreen: 0x3cb371ff,
        mediumslateblue: 0x7b68eeff,
        mediumspringgreen: 0x00fa9aff,
        mediumturquoise: 0x48d1ccff,
        mediumvioletred: 0xc71585ff,
        midnightblue: 0x191970ff,
        mintcream: 0xf5fffaff,
        mistyrose: 0xffe4e1ff,
        moccasin: 0xffe4b5ff,
        navajowhite: 0xffdeadff,
        navy: 0x000080ff,
        oldlace: 0xfdf5e6ff,
        olive: 0x808000ff,
        olivedrab: 0x6b8e23ff,
        orange: 0xffa500ff,
        orangered: 0xff4500ff,
        orchid: 0xda70d6ff,
        palegoldenrod: 0xeee8aaff,
        palegreen: 0x98fb98ff,
        paleturquoise: 0xafeeeeff,
        palevioletred: 0xdb7093ff,
        papayawhip: 0xffefd5ff,
        peachpuff: 0xffdab9ff,
        peru: 0xcd853fff,
        pink: 0xffc0cbff,
        plum: 0xdda0ddff,
        powderblue: 0xb0e0e6ff,
        purple: 0x800080ff,
        rebeccapurple: 0x663399ff,
        red: 0xff0000ff,
        rosybrown: 0xbc8f8fff,
        royalblue: 0x4169e1ff,
        saddlebrown: 0x8b4513ff,
        salmon: 0xfa8072ff,
        sandybrown: 0xf4a460ff,
        seagreen: 0x2e8b57ff,
        seashell: 0xfff5eeff,
        sienna: 0xa0522dff,
        silver: 0xc0c0c0ff,
        skyblue: 0x87ceebff,
        slateblue: 0x6a5acdff,
        slategray: 0x708090ff,
        slategrey: 0x708090ff,
        snow: 0xfffafaff,
        springgreen: 0x00ff7fff,
        steelblue: 0x4682b4ff,
        tan: 0xd2b48cff,
        teal: 0x008080ff,
        thistle: 0xd8bfd8ff,
        tomato: 0xff6347ff,
        turquoise: 0x40e0d0ff,
        violet: 0xee82eeff,
        wheat: 0xf5deb3ff,
        white: 0xffffffff,
        whitesmoke: 0xf5f5f5ff,
        yellow: 0xffff00ff,
        yellowgreen: 0x9acd32ff,
    };
    exports.named_colors = _named_colors;
    function is_named_color(color) {
        return color in exports.named_colors;
    }
    exports.is_named_color = is_named_color;
},
/* core/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.GeneratorFunction = Object.getPrototypeOf(function* () { }).constructor;
    exports.ColorArray = Uint32Array;
    exports.RGBAArray = Uint8ClampedArray;
    function infer_type(a0, a1) {
        if (a0 instanceof Float64Array || a0 instanceof Array)
            return Float64Array;
        if (a1 instanceof Float64Array || a1 instanceof Array)
            return Float64Array;
        return Float32Array;
    }
    exports.infer_type = infer_type;
    exports.ScreenArray = Float32Array;
    function to_screen(array) {
        if (!(array instanceof Float32Array))
            return Float32Array.from(array);
        else
            return array;
    }
    exports.to_screen = to_screen;
    var bitset_1 = require(24) /* ./util/bitset */;
    __esExport("Indices", bitset_1.BitSet);
},
/* core/util/bitset.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const eq_1 = require(25) /* ./eq */;
    const assert_1 = require(12) /* ./assert */;
    class BitSet {
        constructor(size, init = 0) {
            this.size = size;
            this[_a] = "BitSet";
            this._count = null;
            this._nwords = Math.ceil(size / 32);
            if (init == 0 || init == 1) {
                this._array = new Uint32Array(this._nwords);
                if (init == 1) {
                    this._array.fill(0xffffffff);
                }
            }
            else {
                (0, assert_1.assert)(init.length == this._nwords, "Initializer size mismatch");
                this._array = init;
            }
        }
        clone() {
            return new BitSet(this.size, new Uint32Array(this._array));
        }
        [(_a = Symbol.toStringTag, eq_1.equals)](that, cmp) {
            if (!cmp.eq(this.size, that.size))
                return false;
            const { _nwords } = this;
            const trailing = this.size % _nwords;
            const n = trailing == 0 ? _nwords : _nwords - 1;
            for (let i = 0; i < n; i++) {
                if (this._array[i] != that._array[i])
                    return false;
            }
            if (trailing == 0)
                return true;
            else {
                const msb = 1 << (trailing - 1);
                const mask = (msb - 1) ^ msb;
                return (this._array[n] & mask) == (that._array[n] & mask);
            }
        }
        static all_set(size) {
            return new BitSet(size, 1);
        }
        static all_unset(size) {
            return new BitSet(size, 0);
        }
        static from_indices(size, indices) {
            const bits = new BitSet(size);
            for (const i of indices) {
                bits.set(i);
            }
            return bits;
        }
        static from_booleans(size, booleans) {
            const bits = new BitSet(size);
            const n = Math.min(size, booleans.length);
            for (let i = 0; i < n; i++) {
                if (booleans[i])
                    bits.set(i);
            }
            return bits;
        }
        _check_bounds(k) {
            (0, assert_1.assert)(0 <= k && k < this.size, `Out of bounds: 0 <= ${k} < ${this.size}`);
        }
        get(k) {
            this._check_bounds(k);
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            return !!((this._array[i] >> j) & 0x1);
        }
        set(k, v = true) {
            this._check_bounds(k);
            this._count = null;
            const i = k >>> 5; // Math.floor(k/32)
            const j = k & 0x1f; // k % 32
            if (v)
                this._array[i] |= 0x1 << j;
            else
                this._array[i] &= ~(0x1 << j);
        }
        unset(k) {
            this.set(k, false);
        }
        *[Symbol.iterator]() {
            yield* this.ones();
        }
        get count() {
            let count = this._count;
            if (count == null)
                this._count = count = this._get_count();
            return count;
        }
        _get_count() {
            const { _array, _nwords, size } = this;
            let c = 0;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += 32;
                }
                else {
                    for (let j = 0; j < 32 && k < size; j++, k++) {
                        if ((word >>> j) & 0x1)
                            c += 1;
                    }
                }
            }
            return c;
        }
        *ones() {
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0) {
                    k += 32;
                    continue;
                }
                for (let j = 0; j < 32 && k < size; j++, k++) {
                    if ((word >>> j) & 0x1)
                        yield k;
                }
            }
        }
        *zeros() {
            const { _array, _nwords, size } = this;
            for (let k = 0, i = 0; i < _nwords; i++) {
                const word = _array[i];
                if (word == 0xffffffff) {
                    k += 32;
                    continue;
                }
                for (let j = 0; j < 32 && k < size; j++, k++) {
                    if (!((word >>> j) & 0x1))
                        yield k;
                }
            }
        }
        _check_size(other) {
            (0, assert_1.assert)(this.size == other.size, `Size mismatch (${this.size} != ${other.size})`);
        }
        invert() {
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] = ~this._array[i] >>> 0;
            }
        }
        add(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] |= other._array[i];
            }
        }
        intersect(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] &= other._array[i];
            }
        }
        subtract(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                const a = this._array[i];
                const b = other._array[i];
                this._array[i] = (a ^ b) & a;
            }
        }
        symmetric_subtract(other) {
            this._check_size(other);
            for (let i = 0; i < this._nwords; i++) {
                this._array[i] ^= other._array[i];
            }
        }
        inversion() {
            const result = this.clone();
            result.invert();
            return result;
        }
        union(other) {
            const result = this.clone();
            result.add(other);
            return result;
        }
        intersection(other) {
            const result = this.clone();
            result.intersect(other);
            return result;
        }
        difference(other) {
            const result = this.clone();
            result.subtract(other);
            return result;
        }
        symmetric_difference(other) {
            const result = this.clone();
            result.symmetric_subtract(other);
            return result;
        }
        select(array) {
            (0, assert_1.assert)(this.size <= array.length, "Size mismatch");
            const n = this.count;
            const result = new array.constructor(n);
            let i = 0;
            for (const j of this) {
                result[i++] = array[j];
            }
            return result;
        }
    }
    exports.BitSet = BitSet;
    BitSet.__name__ = "BitSet";
},
/* core/util/eq.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Based on Underscore.js 1.8.3 (http://underscorejs.org)
    const types_1 = require(8) /* ./types */;
    const { hasOwnProperty } = Object.prototype;
    exports.equals = Symbol("equals");
    function is_Equatable(obj) {
        return (0, types_1.isObject)(obj) && exports.equals in obj;
    }
    exports.wildcard = Symbol("wildcard");
    const toString = Object.prototype.toString;
    class Comparator {
        constructor(options) {
            var _a;
            this.a_stack = [];
            this.b_stack = [];
            this.structural = (_a = options === null || options === void 0 ? void 0 : options.structural) !== null && _a !== void 0 ? _a : false;
        }
        eq(a, b) {
            if (Object.is(a, b))
                return true;
            if (a === exports.wildcard || b === exports.wildcard)
                return true;
            if (a == null || b == null)
                return a === b;
            const class_name = toString.call(a);
            if (class_name != toString.call(b))
                return false;
            switch (class_name) {
                case "[object Number]":
                    return this.numbers(a, b);
                case "[object Symbol]":
                    return a === b;
                case "[object RegExp]":
                case "[object String]":
                    return `${a}` == `${b}`;
                case "[object Date]":
                case "[object Boolean]":
                    return +a === +b;
            }
            // Assume equality for cyclic structures. The algorithm for detecting cyclic
            // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
            // Initializing stack of traversed objects.
            // It's done here since we only need them for objects and arrays comparison.
            const { a_stack, b_stack } = this;
            let length = a_stack.length;
            while (length--) {
                // Linear search. Performance is inversely proportional to the number of
                // unique nested structures.
                if (a_stack[length] === a)
                    return b_stack[length] === b;
            }
            a_stack.push(a);
            b_stack.push(b);
            const result = (() => {
                if (is_Equatable(a) && is_Equatable(b)) {
                    return a[exports.equals](b, this);
                }
                switch (class_name) {
                    case "[object Array]":
                    case "[object Uint8Array]":
                    case "[object Int8Array]":
                    case "[object Uint16Array]":
                    case "[object Int16Array]":
                    case "[object Uint32Array]":
                    case "[object Int32Array]":
                    case "[object Float32Array]":
                    case "[object Float64Array]": {
                        return this.arrays(a, b);
                    }
                    case "[object Map]":
                        return this.maps(a, b);
                    case "[object Set]":
                        return this.sets(a, b);
                    case "[object Object]": {
                        if (a.constructor == b.constructor && (a.constructor == null || a.constructor === Object)) {
                            return this.objects(a, b);
                        }
                    }
                    case "[object Function]": {
                        if (a.constructor == b.constructor && a.constructor === Function) {
                            return this.eq(`${a}`, `${b}`);
                        }
                    }
                }
                if (typeof Node !== "undefined" && a instanceof Node) {
                    return this.nodes(a, b);
                }
                throw Error(`can't compare objects of type ${class_name}`);
            })();
            a_stack.pop();
            b_stack.pop();
            return result;
        }
        numbers(a, b) {
            return Object.is(a, b);
        }
        arrays(a, b) {
            const { length } = a;
            if (length != b.length)
                return false;
            for (let i = 0; i < length; i++) {
                if (!this.eq(a[i], b[i]))
                    return false;
            }
            return true;
        }
        iterables(a, b) {
            var _a, _b;
            const ai = a[Symbol.iterator]();
            const bi = b[Symbol.iterator]();
            while (true) {
                const an = ai.next();
                const bn = bi.next();
                const an_done = (_a = an.done) !== null && _a !== void 0 ? _a : false;
                const bn_done = (_b = bn.done) !== null && _b !== void 0 ? _b : false;
                if (an_done && bn_done)
                    return true;
                if (an_done || bn_done)
                    return false;
                if (!this.eq(an.value, bn.value))
                    return false;
            }
        }
        maps(a, b) {
            if (a.size != b.size)
                return false;
            if (this.structural)
                return this.iterables(a.entries(), b.entries());
            else {
                for (const [key, val] of a) {
                    if (!b.has(key) || !this.eq(val, b.get(key)))
                        return false;
                }
                return true;
            }
        }
        sets(a, b) {
            if (a.size != b.size)
                return false;
            if (this.structural)
                return this.iterables(a.entries(), b.entries());
            else {
                for (const key of a) {
                    if (!b.has(key))
                        return false;
                }
                return true;
            }
        }
        objects(a, b) {
            const keys = Object.keys(a);
            if (keys.length != Object.keys(b).length)
                return false;
            for (const key of keys) {
                if (!hasOwnProperty.call(b, key) || !this.eq(a[key], b[key]))
                    return false;
            }
            return true;
        }
        nodes(a, b) {
            if (a.nodeType != b.nodeType)
                return false;
            if (a.textContent != b.textContent)
                return false;
            if (!this.iterables(a.childNodes, b.childNodes))
                return false;
            return true;
        }
    }
    exports.Comparator = Comparator;
    Comparator.__name__ = "Comparator";
    const { abs } = Math;
    class SimilarComparator extends Comparator {
        constructor(tolerance = 1e-4) {
            super();
            this.tolerance = tolerance;
        }
        numbers(a, b) {
            return super.numbers(a, b) || abs(a - b) < this.tolerance;
        }
    }
    exports.SimilarComparator = SimilarComparator;
    SimilarComparator.__name__ = "SimilarComparator";
    function is_equal(a, b) {
        const comparator = new Comparator();
        return comparator.eq(a, b);
    }
    exports.is_equal = is_equal;
    function is_structurally_equal(a, b) {
        const comparator = new Comparator({ structural: true });
        return comparator.eq(a, b);
    }
    exports.is_structurally_equal = is_structurally_equal;
    function is_similar(a, b, tolerance) {
        const comparator = new SimilarComparator(tolerance);
        return comparator.eq(a, b);
    }
    exports.is_similar = is_similar;
},
/* core/util/platform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.is_mobile = (() => {
        return "ontouchstart" in globalThis || (typeof navigator !== "undefined" && navigator.maxTouchPoints > 0);
    })();
    exports.is_little_endian = (() => {
        const buf = new ArrayBuffer(4);
        const buf8 = new Uint8Array(buf);
        const buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        let little_endian = true;
        if (buf8[4] == 0x0a && buf8[5] == 0x0b && buf8[6] == 0x0c && buf8[7] == 0x0d) {
            little_endian = false;
        }
        return little_endian;
    })();
    exports.BYTE_ORDER = exports.is_little_endian ? "little" : "big";
    function to_big_endian(values) {
        if (exports.is_little_endian) {
            const result = new Uint32Array(values.length);
            const view = new DataView(result.buffer);
            let j = 0;
            for (const color of values) {
                view.setUint32(j, color);
                j += 4;
            }
            return result;
        }
        else
            return values;
    }
    exports.to_big_endian = to_big_endian;
},
/* core/vectorization.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./util/types */;
    function isValue(obj) {
        return (0, types_1.isPlainObject)(obj) && "value" in obj;
    }
    exports.isValue = isValue;
    function isField(obj) {
        return (0, types_1.isPlainObject)(obj) && "field" in obj;
    }
    exports.isField = isField;
    function isExpr(obj) {
        return (0, types_1.isPlainObject)(obj) && "expr" in obj;
    }
    exports.isExpr = isExpr;
},
/* core/settings.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Settings {
        constructor() {
            this._dev = false;
            this._wireframe = false;
            this._force_webgl = false;
        }
        set dev(dev) {
            this._dev = dev;
        }
        get dev() {
            return this._dev;
        }
        set wireframe(wireframe) {
            this._wireframe = wireframe;
        }
        get wireframe() {
            return this._wireframe;
        }
        set force_webgl(force_webgl) {
            this._force_webgl = force_webgl;
        }
        get force_webgl() {
            return this._force_webgl;
        }
    }
    exports.Settings = Settings;
    Settings.__name__ = "Settings";
    exports.settings = new Settings();
},
/* core/util/ndarray.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    const types_1 = require(8) /* ./types */;
    const platform_1 = require(26) /* ./platform */;
    const eq_1 = require(25) /* ./eq */;
    const serialization_1 = require(30) /* ../serialization */;
    const __ndarray__ = Symbol("__ndarray__");
    function encode_NDArray(array, serializer) {
        const encoded = serializer.encode(array.dtype == "object" ? Array.from(array) : array.buffer);
        return {
            type: "ndarray",
            array: encoded,
            order: platform_1.BYTE_ORDER,
            dtype: array.dtype,
            shape: array.shape,
        };
    }
    class BoolNDArray extends Uint8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_a] = true;
            this.dtype = "bool";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_a = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.BoolNDArray = BoolNDArray;
    BoolNDArray.__name__ = "BoolNDArray";
    class Uint8NDArray extends Uint8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_b] = true;
            this.dtype = "uint8";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_b = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.Uint8NDArray = Uint8NDArray;
    Uint8NDArray.__name__ = "Uint8NDArray";
    class Int8NDArray extends Int8Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_c] = true;
            this.dtype = "int8";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_c = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.Int8NDArray = Int8NDArray;
    Int8NDArray.__name__ = "Int8NDArray";
    class Uint16NDArray extends Uint16Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_d] = true;
            this.dtype = "uint16";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_d = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.Uint16NDArray = Uint16NDArray;
    Uint16NDArray.__name__ = "Uint16NDArray";
    class Int16NDArray extends Int16Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_e] = true;
            this.dtype = "int16";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_e = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.Int16NDArray = Int16NDArray;
    Int16NDArray.__name__ = "Int16NDArray";
    class Uint32NDArray extends Uint32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_f] = true;
            this.dtype = "uint32";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_f = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.Uint32NDArray = Uint32NDArray;
    Uint32NDArray.__name__ = "Uint32NDArray";
    class Int32NDArray extends Int32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_g] = true;
            this.dtype = "int32";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_g = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.Int32NDArray = Int32NDArray;
    Int32NDArray.__name__ = "Int32NDArray";
    class Float32NDArray extends Float32Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_h] = true;
            this.dtype = "float32";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_h = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.Float32NDArray = Float32NDArray;
    Float32NDArray.__name__ = "Float32NDArray";
    class Float64NDArray extends Float64Array {
        constructor(init, shape) {
            super(init); // XXX: typescript bug?
            this[_j] = true;
            this.dtype = "float64";
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_j = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.Float64NDArray = Float64NDArray;
    Float64NDArray.__name__ = "Float64NDArray";
    class ObjectNDArray extends Array {
        constructor(init_, shape) {
            const init = init_ instanceof ArrayBuffer ? new Float64Array(init_) : init_;
            const size = (0, types_1.isNumber)(init) ? init : init.length;
            super(size);
            this[_k] = true;
            this.dtype = "object";
            if (!(0, types_1.isNumber)(init)) {
                for (let i = 0; i < init.length; i++) {
                    this[i] = init[i];
                }
            }
            this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(init) ? init.shape : [this.length]);
            this.dimension = this.shape.length;
        }
        [(_k = __ndarray__, eq_1.equals)](that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        }
        [serialization_1.serialize](serializer) {
            return encode_NDArray(this, serializer);
        }
    }
    exports.ObjectNDArray = ObjectNDArray;
    ObjectNDArray.__name__ = "ObjectNDArray";
    function is_NDArray(v) {
        return (0, types_1.isObject)(v) && __ndarray__ in v;
    }
    exports.is_NDArray = is_NDArray;
    function ndarray(init, { dtype, shape } = {}) {
        if (dtype == null) {
            dtype = (() => {
                switch (true) {
                    case init instanceof Uint8Array: return "uint8";
                    case init instanceof Int8Array: return "int8";
                    case init instanceof Uint16Array: return "uint16";
                    case init instanceof Int16Array: return "int16";
                    case init instanceof Uint32Array: return "uint32";
                    case init instanceof Int32Array: return "int32";
                    case init instanceof Float32Array: return "float32";
                    case init instanceof ArrayBuffer:
                    case init instanceof Float64Array: return "float64";
                    default: return "object";
                }
            })();
        }
        switch (dtype) {
            case "bool": return new BoolNDArray(init, shape);
            case "uint8": return new Uint8NDArray(init, shape);
            case "int8": return new Int8NDArray(init, shape);
            case "uint16": return new Uint16NDArray(init, shape);
            case "int16": return new Int16NDArray(init, shape);
            case "uint32": return new Uint32NDArray(init, shape);
            case "int32": return new Int32NDArray(init, shape);
            case "float32": return new Float32NDArray(init, shape);
            case "float64": return new Float64NDArray(init, shape);
            case "object": return new ObjectNDArray(init, shape);
        }
    }
    exports.ndarray = ndarray;
},
/* core/serialization/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var serializer_1 = require(31) /* ./serializer */;
    __esExport("Serializer", serializer_1.Serializer);
    __esExport("SerializationError", serializer_1.SerializationError);
    __esExport("serialize", serializer_1.serialize);
    var buffer_1 = require(33) /* ./buffer */;
    __esExport("Buffer", buffer_1.Buffer);
    __esExport("Base64Buffer", buffer_1.Base64Buffer);
    tslib_1.__exportStar(require(35) /* ./reps */, exports);
},
/* core/serialization/serializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const assert_1 = require(12) /* ../util/assert */;
    const object_1 = require(9) /* ../util/object */;
    const types_1 = require(8) /* ../util/types */;
    const iterator_1 = require(32) /* ../util/iterator */;
    const platform_1 = require(26) /* ../util/platform */;
    const buffer_1 = require(33) /* ./buffer */;
    // TypedArray?
    exports.serialize = Symbol("serialize");
    function is_Serializable(obj) {
        return (0, types_1.isObject)(obj) && exports.serialize in obj;
    }
    class SerializationError extends Error {
    }
    exports.SerializationError = SerializationError;
    SerializationError.__name__ = "SerializationError";
    class Serialized {
        constructor(value) {
            this.value = value;
        }
        to_json() {
            return JSON.stringify(this.value);
        }
    }
    Serialized.__name__ = "Serialized";
    class Serializer {
        constructor(options) {
            var _a, _b;
            this._circular = new WeakSet();
            this.binary = (_a = options === null || options === void 0 ? void 0 : options.binary) !== null && _a !== void 0 ? _a : false;
            this.include_defaults = (_b = options === null || options === void 0 ? void 0 : options.include_defaults) !== null && _b !== void 0 ? _b : false;
            const references = options === null || options === void 0 ? void 0 : options.references;
            this._references = references != null ? new Map(references) : new Map();
        }
        get_ref(obj) {
            return this._references.get(obj);
        }
        add_ref(obj, ref) {
            (0, assert_1.assert)(!this._references.has(obj));
            this._references.set(obj, ref);
        }
        to_serializable(obj) {
            return new Serialized(this.encode(obj));
        }
        encode(obj) {
            const ref = this.get_ref(obj);
            if (ref != null) {
                return ref;
            }
            if (!(0, types_1.isObject)(obj)) {
                return this._encode(obj);
            }
            else {
                if (this._circular.has(obj)) {
                    this.error("circular reference");
                }
                this._circular.add(obj);
                try {
                    return this._encode(obj);
                }
                finally {
                    this._circular.delete(obj);
                }
            }
        }
        _encode(obj) {
            if (is_Serializable(obj))
                return obj[exports.serialize](this);
            else if ((0, types_1.isArray)(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.encode(value);
                }
                return result;
            }
            else if ((0, types_1.isTypedArray)(obj)) {
                return this._encode_typed_array(obj);
            }
            else if (obj instanceof ArrayBuffer) {
                const data = this.binary ? new buffer_1.Buffer(obj) : new buffer_1.Base64Buffer(obj);
                return { type: "bytes", data };
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                const items = (0, object_1.entries)(obj);
                if (items.length == 0)
                    return { type: "map" };
                else
                    return { type: "map", entries: [...(0, iterator_1.map)(items, ([key, val]) => [this.encode(key), this.encode(val)])] };
                /*
                } else if (isBasicObject(obj)) {
                  return {type: "map", entries: [...map(entries(obj), ([key, val]) => [this.encode(key), this.encode(val)])]}
                } else if (isPlainObject(obj)) {
                  const result: {[key: string]: unknown} = {}
                  for (const [key, value] of entries(obj)) {
                    result[key] = this.encode(value)
                  }
                  return result
                */
            }
            else if (obj === null || (0, types_1.isBoolean)(obj) || (0, types_1.isString)(obj)) {
                return obj;
            }
            else if ((0, types_1.isNumber)(obj)) {
                if (isNaN(obj))
                    return { type: "number", value: "nan" };
                else if (!isFinite(obj))
                    return { type: "number", value: `${obj < 0 ? "-" : "+"}inf` };
                else
                    return obj;
            }
            else if (obj instanceof Set) {
                if (obj.size == 0)
                    return { type: "set" };
                else
                    return { type: "set", entries: [...(0, iterator_1.map)(obj.values(), (val) => this.encode(val))] };
            }
            else if (obj instanceof Map) {
                if (obj.size == 0)
                    return { type: "map" };
                else
                    return { type: "map", entries: [...(0, iterator_1.map)(obj.entries(), ([key, val]) => [this.encode(key), this.encode(val)])] };
            }
            else if ((0, types_1.isSymbol)(obj) && obj.description != null) {
                return { type: "symbol", name: obj.description };
            }
            else
                throw new SerializationError(`${Object.prototype.toString.call(obj)} is not serializable`);
        }
        encode_struct(struct) {
            const result = {};
            for (const [key, val] of (0, object_1.entries)(struct)) {
                if (val !== undefined)
                    result[key] = this.encode(val);
            }
            return result;
        }
        error(message) {
            throw new SerializationError(message);
        }
        _encode_typed_array(obj) {
            const array = this.encode(obj.buffer);
            const dtype = (() => {
                switch (obj.constructor) {
                    case Uint8Array: return "uint8";
                    case Int8Array: return "int8";
                    case Uint16Array: return "uint16";
                    case Int16Array: return "int16";
                    case Uint32Array: return "uint32";
                    case Int32Array: return "int32";
                    // case BigUint64Array: return "uint64"
                    // case BigInt64Array: return "int64"
                    case Float32Array: return "float32";
                    case Float64Array: return "float64";
                    default:
                        this.error(`can't serialize typed array of type '${obj[Symbol.toStringTag]}'`);
                }
            })();
            return {
                type: "typed_array",
                array,
                order: platform_1.BYTE_ORDER,
                dtype,
            };
        }
    }
    exports.Serializer = Serializer;
    Serializer.__name__ = "Serializer";
},
/* core/util/iterator.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(10) /* ./array */;
    const assert_1 = require(12) /* ./assert */;
    const { abs, ceil, max } = Math;
    function* range(start, stop, step = 1) {
        (0, assert_1.assert)(step > 0);
        if (stop == null) {
            stop = start;
            start = 0;
        }
        const delta = start <= stop ? step : -step;
        const length = max(ceil(abs(stop - start) / step), 0);
        for (let i = 0; i < length; i++, start += delta) {
            yield start;
        }
    }
    exports.range = range;
    function* reverse(array) {
        const n = array.length;
        for (let i = 0; i < n; i++) {
            yield array[n - i - 1];
        }
    }
    exports.reverse = reverse;
    function* enumerate(seq) {
        let i = 0;
        for (const item of seq) {
            yield [item, i++];
        }
    }
    exports.enumerate = enumerate;
    function* take(seq, n) {
        (0, assert_1.assert)(n >= 0);
        let i = 0;
        for (const item of seq) {
            if (i++ < n)
                yield item;
            else
                break;
        }
    }
    exports.take = take;
    function* skip(seq, n) {
        (0, assert_1.assert)(n >= 0);
        for (const value of seq) {
            if (n == 0)
                yield value;
            else
                n -= 1;
        }
    }
    exports.skip = skip;
    function* tail(seq) {
        yield* skip(seq, 1);
    }
    exports.tail = tail;
    function* join(seq, separator) {
        let first = true;
        for (const entry of seq) {
            if (first)
                first = false;
            else if (separator != null)
                yield separator();
            yield* entry;
        }
    }
    exports.join = join;
    function* interleave(seq, separator) {
        let first = true;
        for (const entry of seq) {
            if (first)
                first = false;
            else
                yield separator();
            yield entry;
        }
    }
    exports.interleave = interleave;
    function* map(iterable, fn) {
        let i = 0;
        for (const item of iterable) {
            yield fn(item, i++);
        }
    }
    exports.map = map;
    function* flat_map(iterable, fn) {
        let i = 0;
        for (const item of iterable) {
            yield* fn(item, i++);
        }
    }
    exports.flat_map = flat_map;
    function every(iterable, predicate) {
        for (const item of iterable) {
            if (!predicate(item))
                return false;
        }
        return true;
    }
    exports.every = every;
    function some(iterable, predicate) {
        for (const item of iterable) {
            if (predicate(item))
                return true;
        }
        return false;
    }
    exports.some = some;
    // https://docs.python.org/3.8/library/itertools.html#itertools.combinations
    function* combinations(seq, r) {
        const n = seq.length;
        if (r > n)
            return;
        const indices = (0, array_1.range)(r);
        yield indices.map((i) => seq[i]);
        while (true) {
            let k;
            for (const i of reverse((0, array_1.range)(r))) {
                if (indices[i] != i + n - r) {
                    k = i;
                    break;
                }
            }
            if (k == null)
                return;
            indices[k] += 1;
            for (const j of (0, array_1.range)(k + 1, r)) {
                indices[j] = indices[j - 1] + 1;
            }
            yield indices.map((i) => seq[i]);
        }
    }
    exports.combinations = combinations;
    function* subsets(seq) {
        for (const k of (0, array_1.range)(seq.length + 1)) {
            yield* combinations(seq, k);
        }
    }
    exports.subsets = subsets;
},
/* core/serialization/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const buffer_1 = require(34) /* ../util/buffer */;
    const eq_1 = require(25) /* ../util/eq */;
    class Buffer {
        constructor(buffer) {
            this.buffer = buffer;
        }
        to_base64() {
            return (0, buffer_1.buffer_to_base64)(this.buffer);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.buffer, that.buffer);
        }
    }
    exports.Buffer = Buffer;
    Buffer.__name__ = "Buffer";
    class Base64Buffer extends Buffer {
        toJSON() {
            return this.to_base64();
        }
    }
    exports.Base64Buffer = Base64Buffer;
    Base64Buffer.__name__ = "Base64Buffer";
},
/* core/util/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function buffer_to_base64(buffer) {
        const bytes = new Uint8Array(buffer);
        const chars = Array.from(bytes).map((b) => String.fromCharCode(b));
        return btoa(chars.join(""));
    }
    exports.buffer_to_base64 = buffer_to_base64;
    function base64_to_buffer(base64) {
        const binary_string = atob(base64);
        const len = binary_string.length;
        const bytes = new Uint8Array(len);
        for (let i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    }
    exports.base64_to_buffer = base64_to_buffer;
    // NOTE: swap{16,32,64} assume byteOffset == 0
    function swap16(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 2) {
            const t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
    }
    function swap32(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 4) {
            let t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
    }
    function swap64(buffer) {
        const x = new Uint8Array(buffer);
        for (let i = 0, end = x.length; i < end; i += 8) {
            let t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
    }
    function swap(buffer, dtype) {
        switch (dtype) {
            case "uint16":
            case "int16":
                swap16(buffer);
                break;
            case "uint32":
            case "int32":
            case "float32":
                swap32(buffer);
                break;
            case "float64":
                swap64(buffer);
                break;
        }
    }
    exports.swap = swap;
},
/* core/serialization/reps.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
},
/* core/diagnostics.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class Diagnostics {
        constructor() {
            this.listeners = new Set();
        }
        connect(listener) {
            this.listeners.add(listener);
        }
        disconnect(listener) {
            this.listeners.delete(listener);
        }
        report(obj) {
            for (const listener of this.listeners) {
                listener(obj);
            }
        }
    }
    exports.Diagnostics = Diagnostics;
    Diagnostics.__name__ = "Diagnostics";
    exports.diagnostics = new Diagnostics();
},
/* core/uniforms.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const eq_1 = require(25) /* ./util/eq */;
    class Uniform {
        is_Scalar() { return this.is_scalar; }
        is_Vector() { return !this.is_scalar; }
    }
    exports.Uniform = Uniform;
    Uniform.__name__ = "Uniform";
    class UniformScalar extends Uniform {
        constructor(value, length) {
            super();
            this.value = value;
            this.length = length;
            this.is_scalar = true;
        }
        get(_i) {
            return this.value;
        }
        *[Symbol.iterator]() {
            const { length, value } = this;
            for (let i = 0; i < length; i++) {
                yield value;
            }
        }
        select(indices) {
            return new UniformScalar(this.value, indices.count);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.value, that.value);
        }
    }
    exports.UniformScalar = UniformScalar;
    UniformScalar.__name__ = "UniformScalar";
    class UniformVector extends Uniform {
        constructor(array) {
            super();
            this.array = array;
            this.is_scalar = false;
            this.length = this.array.length;
        }
        get(i) {
            return this.array[i];
        }
        *[Symbol.iterator]() {
            yield* this.array;
        }
        select(indices) {
            const array = indices.select(this.array);
            return new this.constructor(array);
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.array, that.array);
        }
    }
    exports.UniformVector = UniformVector;
    UniformVector.__name__ = "UniformVector";
    class ColorUniformVector extends UniformVector {
        constructor(array) {
            super(array);
            this.array = array;
            this._view = new DataView(array.buffer);
        }
        get(i) {
            return this._view.getUint32(4 * i);
        }
        *[Symbol.iterator]() {
            const n = this.length;
            for (let i = 0; i < n; i++)
                yield this.get(i);
        }
    }
    exports.ColorUniformVector = ColorUniformVector;
    ColorUniformVector.__name__ = "ColorUniformVector";
},
/* core/util/string.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const settings_1 = require(28) /* ../settings */;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        const s = new Array(32);
        const hex_digits = "0123456789ABCDEF";
        for (let i = 0; i < 32; i++) {
            s[i] = hex_digits[Math.floor(Math.random() * 0x10)];
        }
        s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hex_digits[(s[16].charCodeAt(0) & 0x3) | 0x8]; // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join("");
    }
    exports.uuid4 = uuid4;
    let counter = 1000;
    function unique_id(prefix) {
        const id = settings_1.settings.dev ? `j${counter++}` : uuid4();
        if (prefix != null)
            return `${prefix}-${id}`;
        else
            return id;
    }
    exports.unique_id = unique_id;
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, (ch) => {
            switch (ch) {
                case "&": return "&amp;";
                case "<": return "&lt;";
                case ">": return "&gt;";
                case '"': return "&quot;";
                case "'": return "&#x27;";
                case "`": return "&#x60;";
                default: return ch;
            }
        });
    }
    exports.escape = escape;
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, (_, entity) => {
            switch (entity) {
                case "amp": return "&";
                case "lt": return "<";
                case "gt": return ">";
                case "quot": return '"';
                case "#x27": return "'";
                case "#x60": return "`";
                default: return entity;
            }
        });
    }
    exports.unescape = unescape;
    function use_strict(code) {
        return `'use strict';\n${code}`;
    }
    exports.use_strict = use_strict;
    function to_fixed(val, precision) {
        return val.toFixed(precision).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
    }
    exports.to_fixed = to_fixed;
    function insert_text_on_position(destination, position, text_to_be_inserted) {
        const result_text = [];
        result_text.push(destination.slice(0, position));
        result_text.push(text_to_be_inserted);
        result_text.push(destination.slice(position));
        return result_text.join("");
    }
    exports.insert_text_on_position = insert_text_on_position;
},
/* document/events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const eq_1 = require(25) /* ../core/util/eq */;
    const serialization_1 = require(30) /* ../core/serialization */;
    class DocumentEvent {
        constructor(document) {
            this.document = document;
        }
        get [Symbol.toStringTag]() {
            return this.constructor.__name__;
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.document, that.document);
        }
    }
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    class DocumentEventBatch extends DocumentEvent {
        constructor(document, events) {
            super(document);
            this.events = events;
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.events, that.events);
        }
    }
    exports.DocumentEventBatch = DocumentEventBatch;
    DocumentEventBatch.__name__ = "DocumentEventBatch";
    class DocumentChangedEvent extends DocumentEvent {
    }
    exports.DocumentChangedEvent = DocumentChangedEvent;
    DocumentChangedEvent.__name__ = "DocumentChangedEvent";
    class MessageSentEvent extends DocumentChangedEvent {
        constructor(document, msg_type, msg_data) {
            super(document);
            this.msg_type = msg_type;
            this.msg_data = msg_data;
            this.kind = "MessageSent";
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.msg_type, that.msg_type) &&
                cmp.eq(this.msg_data, that.msg_data);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                msg_type: this.msg_type,
                msg_data: serializer.encode(this.msg_data),
            };
        }
    }
    exports.MessageSentEvent = MessageSentEvent;
    MessageSentEvent.__name__ = "MessageSentEvent";
    class ModelChangedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, value) {
            super(document);
            this.model = model;
            this.attr = attr;
            this.value = value;
            this.kind = "ModelChanged";
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.value, that.value);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                new: serializer.encode(this.value),
            };
        }
    }
    exports.ModelChangedEvent = ModelChangedEvent;
    ModelChangedEvent.__name__ = "ModelChangedEvent";
    class ColumnDataChangedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, data, cols) {
            super(document);
            this.model = model;
            this.attr = attr;
            this.data = data;
            this.cols = cols;
            this.kind = "ColumnDataChanged";
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.data, that.data) &&
                cmp.eq(this.cols, that.cols);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                data: serializer.encode(this.data),
                cols: this.cols,
            };
        }
    }
    exports.ColumnDataChangedEvent = ColumnDataChangedEvent;
    ColumnDataChangedEvent.__name__ = "ColumnDataChangedEvent";
    class ColumnsStreamedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, data, rollover) {
            super(document);
            this.model = model;
            this.attr = attr;
            this.data = data;
            this.rollover = rollover;
            this.kind = "ColumnsStreamed";
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.data, that.data) &&
                cmp.eq(this.rollover, that.rollover);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
                attr: this.attr,
                data: serializer.encode(this.data),
                rollover: this.rollover,
            };
        }
    }
    exports.ColumnsStreamedEvent = ColumnsStreamedEvent;
    ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
    class ColumnsPatchedEvent extends DocumentChangedEvent {
        constructor(document, model, attr, patches) {
            super(document);
            this.model = model;
            this.attr = attr;
            this.patches = patches;
            this.kind = "ColumnsPatched";
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model) &&
                cmp.eq(this.attr, that.attr) &&
                cmp.eq(this.patches, that.patches);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                attr: this.attr,
                model: this.model.ref(),
                patches: serializer.encode(this.patches),
            };
        }
    }
    exports.ColumnsPatchedEvent = ColumnsPatchedEvent;
    ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
    class TitleChangedEvent extends DocumentChangedEvent {
        constructor(document, title) {
            super(document);
            this.title = title;
            this.kind = "TitleChanged";
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.title, that.title);
        }
        [serialization_1.serialize](_serializer) {
            return {
                kind: this.kind,
                title: this.title,
            };
        }
    }
    exports.TitleChangedEvent = TitleChangedEvent;
    TitleChangedEvent.__name__ = "TitleChangedEvent";
    class RootAddedEvent extends DocumentChangedEvent {
        constructor(document, model) {
            super(document);
            this.model = model;
            this.kind = "RootAdded";
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model);
        }
        [serialization_1.serialize](serializer) {
            return {
                kind: this.kind,
                model: serializer.encode(this.model),
            };
        }
    }
    exports.RootAddedEvent = RootAddedEvent;
    RootAddedEvent.__name__ = "RootAddedEvent";
    class RootRemovedEvent extends DocumentChangedEvent {
        constructor(document, model) {
            super(document);
            this.model = model;
            this.kind = "RootRemoved";
        }
        [eq_1.equals](that, cmp) {
            return super[eq_1.equals](that, cmp) &&
                cmp.eq(this.model, that.model);
        }
        [serialization_1.serialize](_serializer) {
            return {
                kind: this.kind,
                model: this.model.ref(),
            };
        }
    }
    exports.RootRemovedEvent = RootRemovedEvent;
    RootRemovedEvent.__name__ = "RootRemovedEvent";
},
/* core/util/pretty.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    const object_1 = require(9) /* ./object */;
    exports.pretty = Symbol("pretty");
    function is_Printable(obj) {
        return (0, types_1.isObject)(obj) && exports.pretty in obj;
    }
    class Printer {
        constructor(options) {
            this.visited = new Set();
            this.precision = options === null || options === void 0 ? void 0 : options.precision;
        }
        to_string(obj) {
            if ((0, types_1.isObject)(obj)) {
                if (this.visited.has(obj))
                    return "<circular>";
                else
                    this.visited.add(obj);
            }
            if (is_Printable(obj))
                return obj[exports.pretty](this);
            else if ((0, types_1.isBoolean)(obj))
                return this.boolean(obj);
            else if ((0, types_1.isNumber)(obj))
                return this.number(obj);
            else if ((0, types_1.isString)(obj))
                return this.string(obj);
            else if ((0, types_1.isArray)(obj))
                return this.array(obj);
            else if ((0, types_1.isIterable)(obj))
                return this.iterable(obj);
            else if ((0, types_1.isPlainObject)(obj))
                return this.object(obj);
            else if ((0, types_1.isSymbol)(obj))
                return this.symbol(obj);
            else if (obj instanceof ArrayBuffer)
                return this.array_buffer(obj);
            else
                return `${obj}`;
        }
        token(val) {
            return val;
        }
        boolean(val) {
            return `${val}`;
        }
        number(val) {
            if (this.precision != null)
                return val.toFixed(this.precision);
            else
                return `${val}`;
        }
        string(val) {
            const sq = val.includes("'");
            const dq = val.includes('"');
            if (sq && dq)
                return `\`${val.replace(/`/g, "\\`")}\``;
            else if (dq)
                return `'${val}'`;
            else
                return `"${val}"`;
        }
        symbol(val) {
            return val.toString();
        }
        array(obj) {
            const T = this.token;
            const items = [];
            for (const entry of obj) {
                items.push(this.to_string(entry));
            }
            return `${T("[")}${items.join(`${T(",")} `)}${T("]")}`;
        }
        iterable(obj) {
            var _a;
            const T = this.token;
            const tag = (_a = Object(obj)[Symbol.toStringTag]) !== null && _a !== void 0 ? _a : "Object";
            const items = this.array(obj);
            return `${tag}${T("(")}${items}${T(")")}`;
        }
        object(obj) {
            const T = this.token;
            const items = [];
            for (const [key, val] of (0, object_1.entries)(obj)) {
                items.push(`${key}${T(":")} ${this.to_string(val)}`);
            }
            return `${T("{")}${items.join(`${T(",")} `)}${T("}")}`;
        }
        array_buffer(obj) {
            return `ArrayBuffer(#${obj.byteLength})`;
        }
    }
    exports.Printer = Printer;
    Printer.__name__ = "Printer";
    function to_string(obj, options) {
        const printer = new Printer(options);
        return printer.to_string(obj);
    }
    exports.to_string = to_string;
},
/* core/util/cloneable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const object_1 = require(9) /* ./object */;
    const types_1 = require(8) /* ./types */;
    exports.clone = Symbol("clone");
    function is_Cloneable(obj) {
        return (0, types_1.isObject)(obj) && exports.clone in obj;
    }
    exports.is_Cloneable = is_Cloneable;
    class CloningError extends Error {
    }
    exports.CloningError = CloningError;
    CloningError.__name__ = "CloningError";
    class Cloner {
        constructor() { }
        clone(obj) {
            if (is_Cloneable(obj)) {
                return obj[exports.clone](this);
            }
            else if ((0, types_1.isPrimitive)(obj)) {
                return obj;
            }
            else if ((0, types_1.isArray)(obj)) {
                const n = obj.length;
                const result = new Array(n);
                for (let i = 0; i < n; i++) {
                    const value = obj[i];
                    result[i] = this.clone(value);
                }
                return result;
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                const result = {};
                for (const [key, value] of (0, object_1.entries)(obj)) {
                    result[key] = this.clone(value);
                }
                return result;
            }
            else if (obj instanceof Map) {
                return new Map([...obj].map(([k, v]) => [this.clone(k), this.clone(v)]));
            }
            else if (obj instanceof Set) {
                return new Set([...obj].map((v) => this.clone(v)));
            }
            else
                throw new CloningError(`${Object.prototype.toString.call(obj)} is not cloneable`);
        }
    }
    exports.Cloner = Cloner;
    Cloner.__name__ = "Cloner";
},
/* core/patching.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const set_1 = require(43) /* ./util/set */;
    const typed_array = tslib_1.__importStar(require(44) /* ./util/typed_array */);
    //exported for testing
    function stream_to_column(col, new_col, rollover) {
        if ((0, types_1.isArray)(col)) {
            const result = col.concat(new_col);
            if (rollover != null && result.length > rollover)
                return result.slice(-rollover);
            else
                return result;
        }
        else if ((0, types_1.isTypedArray)(col)) {
            const total_len = col.length + new_col.length;
            // handle rollover case for typed arrays
            if (rollover != null && total_len > rollover) {
                const start = total_len - rollover;
                const end = col.length;
                // resize col if it is shorter than the rollover length
                let result;
                if (col.length < rollover) {
                    result = new col.constructor(rollover);
                    result.set(col, 0);
                }
                else
                    result = col;
                // shift values in original col to accommodate new_col
                for (let i = start, endi = end; i < endi; i++) {
                    result[i - start] = result[i];
                }
                // update end values in col with new_col
                for (let i = 0, endi = new_col.length; i < endi; i++) {
                    result[i + (end - start)] = new_col[i];
                }
                return result;
            }
            else {
                const tmp = new col.constructor(new_col);
                return typed_array.concat(col, tmp);
            }
        }
        else
            throw new Error("unsupported array types");
    }
    exports.stream_to_column = stream_to_column;
    // exported for testing
    function slice(ind, length) {
        let start, step, stop;
        if ((0, types_1.isNumber)(ind)) {
            start = ind;
            stop = ind + 1;
            step = 1;
        }
        else {
            start = ind.start != null ? ind.start : 0;
            stop = ind.stop != null ? ind.stop : length;
            step = ind.step != null ? ind.step : 1;
        }
        return [start, stop, step];
    }
    exports.slice = slice;
    // exported for testing
    function patch_to_column(col, patch) {
        const patched = new Set();
        let patched_range = false;
        for (const [ind, val] of patch) {
            // make the single index case look like the length-3 multi-index case
            let shape;
            let item;
            let index;
            let value;
            if ((0, types_1.isArray)(ind)) {
                const [i] = ind;
                patched.add(i);
                shape = col[i].shape;
                item = col[i];
                value = val;
                // this is basically like NumPy's "newaxis", inserting an empty dimension
                // makes length 2 and 3 multi-index cases uniform, so that the same code
                // can handle both
                if (ind.length === 2) {
                    shape = [1, shape[0]];
                    index = [ind[0], 0, ind[1]];
                }
                else
                    index = ind;
            }
            else {
                if ((0, types_1.isNumber)(ind)) {
                    value = [val];
                    patched.add(ind);
                }
                else {
                    value = val;
                    patched_range = true;
                }
                index = [0, 0, ind];
                shape = [1, col.length];
                item = col;
            }
            // now this one nested loop handles all cases
            let flat_index = 0;
            const [istart, istop, istep] = slice(index[1], shape[0]);
            const [jstart, jstop, jstep] = slice(index[2], shape[1]);
            for (let i = istart; i < istop; i += istep) {
                for (let j = jstart; j < jstop; j += jstep) {
                    if (patched_range) {
                        patched.add(j);
                    }
                    item[i * shape[1] + j] = value[flat_index];
                    flat_index++;
                }
            }
        }
        return patched;
    }
    exports.patch_to_column = patch_to_column;
    function stream_to_columns(data, new_data, rollover) {
        for (const [name, new_column] of (0, object_1.entries)(new_data)) {
            data[name] = stream_to_column(data[name], new_column, rollover);
        }
    }
    exports.stream_to_columns = stream_to_columns;
    function patch_to_columns(data, patches) {
        let patched = new Set();
        for (const [column, patch] of (0, object_1.entries)(patches)) {
            patched = (0, set_1.union)(patched, patch_to_column(data[column], patch)); // XXX
        }
        return patched;
    }
    exports.patch_to_columns = patch_to_columns;
},
/* core/util/set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function union(...sets) {
        const result = new Set();
        for (const set of sets) {
            for (const item of set) {
                result.add(item);
            }
        }
        return result;
    }
    exports.union = union;
    function intersection(set, ...sets) {
        const result = new Set();
        top: for (const item of set) {
            for (const other of sets) {
                if (!other.has(item))
                    continue top;
            }
            result.add(item);
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(set, ...sets) {
        const result = new Set(set);
        for (const item of union(...sets)) {
            result.delete(item);
        }
        return result;
    }
    exports.difference = difference;
},
/* core/util/typed_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function concat(array0, ...arrays) {
        let n = array0.length;
        for (const array of arrays)
            n += array.length;
        const result = new array0.constructor(n);
        result.set(array0, 0);
        let i = array0.length;
        for (const array of arrays) {
            result.set(array, i);
            i += array.length;
        }
        return result;
    }
    exports.concat = concat;
},
/* core/resolvers.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class ModelResolver {
        constructor(parent, models = []) {
            this.parent = parent;
            this._known_models = new Map();
            for (const model of models) {
                this.register(model);
            }
        }
        get(name) {
            var _a, _b, _c;
            return (_c = (_a = this._known_models.get(name)) !== null && _a !== void 0 ? _a : (_b = this.parent) === null || _b === void 0 ? void 0 : _b.get(name)) !== null && _c !== void 0 ? _c : null;
        }
        register(model, force = false) {
            const name = model.__qualified__;
            if (force || this.get(name) == null)
                this._known_models.set(name, model);
            else
                console.warn(`Model '${name}' was already registered with this resolver`);
        }
        get names() {
            return [...this._known_models.keys()];
        }
    }
    exports.ModelResolver = ModelResolver;
    ModelResolver.__name__ = "ModelResolver";
},
/* core/bokeh_events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    const serialization_1 = require(30) /* ./serialization */;
    const eq_1 = require(25) /* ./util/eq */;
    function event(event_name) {
        return (cls) => {
            cls.prototype.event_name = event_name;
        };
    }
    class BokehEvent {
        [serialization_1.serialize](serializer) {
            const { event_name: name, event_values } = this;
            const values = serializer.encode(event_values);
            return { type: "event", name, values };
        }
        [eq_1.equals](that, cmp) {
            return this.event_name == that.event_name && cmp.eq(this.event_values, that.event_values);
        }
    }
    exports.BokehEvent = BokehEvent;
    BokehEvent.__name__ = "BokehEvent";
    class ModelEvent extends BokehEvent {
        constructor() {
            super(...arguments);
            this.origin = null;
        }
        get event_values() {
            return { model: this.origin };
        }
    }
    exports.ModelEvent = ModelEvent;
    ModelEvent.__name__ = "ModelEvent";
    let DocumentReady = class DocumentReady extends BokehEvent {
        get event_values() {
            return {};
        }
    };
    exports.DocumentReady = DocumentReady;
    DocumentReady.__name__ = "DocumentReady";
    exports.DocumentReady = DocumentReady = __decorate([
        event("document_ready")
    ], DocumentReady);
    let ButtonClick = class ButtonClick extends ModelEvent {
    };
    exports.ButtonClick = ButtonClick;
    ButtonClick.__name__ = "ButtonClick";
    exports.ButtonClick = ButtonClick = __decorate([
        event("button_click")
    ], ButtonClick);
    let MenuItemClick = class MenuItemClick extends ModelEvent {
        constructor(item) {
            super();
            this.item = item;
        }
        get event_values() {
            const { item } = this;
            return Object.assign(Object.assign({}, super.event_values), { item });
        }
    };
    exports.MenuItemClick = MenuItemClick;
    MenuItemClick.__name__ = "MenuItemClick";
    exports.MenuItemClick = MenuItemClick = __decorate([
        event("menu_item_click")
    ], MenuItemClick);
    // A UIEvent is an event originating on a canvas this includes.
    // DOM events such as keystrokes as well as hammer, LOD, and range events.
    class UIEvent extends ModelEvent {
    }
    exports.UIEvent = UIEvent;
    UIEvent.__name__ = "UIEvent";
    let LODStart = class LODStart extends UIEvent {
    };
    exports.LODStart = LODStart;
    LODStart.__name__ = "LODStart";
    exports.LODStart = LODStart = __decorate([
        event("lodstart")
    ], LODStart);
    let LODEnd = class LODEnd extends UIEvent {
    };
    exports.LODEnd = LODEnd;
    LODEnd.__name__ = "LODEnd";
    exports.LODEnd = LODEnd = __decorate([
        event("lodend")
    ], LODEnd);
    let RangesUpdate = class RangesUpdate extends UIEvent {
        constructor(x0, x1, y0, y1) {
            super();
            this.x0 = x0;
            this.x1 = x1;
            this.y0 = y0;
            this.y1 = y1;
        }
        get event_values() {
            const { x0, x1, y0, y1 } = this;
            return Object.assign(Object.assign({}, super.event_values), { x0, x1, y0, y1 });
        }
    };
    exports.RangesUpdate = RangesUpdate;
    RangesUpdate.__name__ = "RangesUpdate";
    exports.RangesUpdate = RangesUpdate = __decorate([
        event("rangesupdate")
    ], RangesUpdate);
    let SelectionGeometry = class SelectionGeometry extends UIEvent {
        constructor(geometry, final) {
            super();
            this.geometry = geometry;
            this.final = final;
        }
        get event_values() {
            const { geometry, final } = this;
            return Object.assign(Object.assign({}, super.event_values), { geometry, final });
        }
    };
    exports.SelectionGeometry = SelectionGeometry;
    SelectionGeometry.__name__ = "SelectionGeometry";
    exports.SelectionGeometry = SelectionGeometry = __decorate([
        event("selectiongeometry")
    ], SelectionGeometry);
    let Reset = class Reset extends UIEvent {
    };
    exports.Reset = Reset;
    Reset.__name__ = "Reset";
    exports.Reset = Reset = __decorate([
        event("reset")
    ], Reset);
    class PointEvent extends UIEvent {
        constructor(sx, sy, x, y) {
            super();
            this.sx = sx;
            this.sy = sy;
            this.x = x;
            this.y = y;
        }
        get event_values() {
            const { sx, sy, x, y } = this;
            return Object.assign(Object.assign({}, super.event_values), { sx, sy, x, y });
        }
    }
    exports.PointEvent = PointEvent;
    PointEvent.__name__ = "PointEvent";
    let Pan = class Pan extends PointEvent {
        /* TODO: direction: -1 | 1 */
        constructor(sx, sy, x, y, delta_x, delta_y) {
            super(sx, sy, x, y);
            this.delta_x = delta_x;
            this.delta_y = delta_y;
        }
        get event_values() {
            const { delta_x, delta_y /*, direction*/ } = this;
            return Object.assign(Object.assign({}, super.event_values), { delta_x, delta_y /*, direction*/ });
        }
    };
    exports.Pan = Pan;
    Pan.__name__ = "Pan";
    exports.Pan = Pan = __decorate([
        event("pan")
    ], Pan);
    let Pinch = class Pinch extends PointEvent {
        constructor(sx, sy, x, y, scale) {
            super(sx, sy, x, y);
            this.scale = scale;
        }
        get event_values() {
            const { scale } = this;
            return Object.assign(Object.assign({}, super.event_values), { scale });
        }
    };
    exports.Pinch = Pinch;
    Pinch.__name__ = "Pinch";
    exports.Pinch = Pinch = __decorate([
        event("pinch")
    ], Pinch);
    let Rotate = class Rotate extends PointEvent {
        constructor(sx, sy, x, y, rotation) {
            super(sx, sy, x, y);
            this.rotation = rotation;
        }
        get event_values() {
            const { rotation } = this;
            return Object.assign(Object.assign({}, super.event_values), { rotation });
        }
    };
    exports.Rotate = Rotate;
    Rotate.__name__ = "Rotate";
    exports.Rotate = Rotate = __decorate([
        event("rotate")
    ], Rotate);
    let MouseWheel = class MouseWheel extends PointEvent {
        constructor(sx, sy, x, y, delta) {
            super(sx, sy, x, y);
            this.delta = delta;
        }
        get event_values() {
            const { delta } = this;
            return Object.assign(Object.assign({}, super.event_values), { delta });
        }
    };
    exports.MouseWheel = MouseWheel;
    MouseWheel.__name__ = "MouseWheel";
    exports.MouseWheel = MouseWheel = __decorate([
        event("wheel")
    ], MouseWheel);
    let MouseMove = class MouseMove extends PointEvent {
    };
    exports.MouseMove = MouseMove;
    MouseMove.__name__ = "MouseMove";
    exports.MouseMove = MouseMove = __decorate([
        event("mousemove")
    ], MouseMove);
    let MouseEnter = class MouseEnter extends PointEvent {
    };
    exports.MouseEnter = MouseEnter;
    MouseEnter.__name__ = "MouseEnter";
    exports.MouseEnter = MouseEnter = __decorate([
        event("mouseenter")
    ], MouseEnter);
    let MouseLeave = class MouseLeave extends PointEvent {
    };
    exports.MouseLeave = MouseLeave;
    MouseLeave.__name__ = "MouseLeave";
    exports.MouseLeave = MouseLeave = __decorate([
        event("mouseleave")
    ], MouseLeave);
    let Tap = class Tap extends PointEvent {
    };
    exports.Tap = Tap;
    Tap.__name__ = "Tap";
    exports.Tap = Tap = __decorate([
        event("tap")
    ], Tap);
    let DoubleTap = class DoubleTap extends PointEvent {
    };
    exports.DoubleTap = DoubleTap;
    DoubleTap.__name__ = "DoubleTap";
    exports.DoubleTap = DoubleTap = __decorate([
        event("doubletap")
    ], DoubleTap);
    let Press = class Press extends PointEvent {
    };
    exports.Press = Press;
    Press.__name__ = "Press";
    exports.Press = Press = __decorate([
        event("press")
    ], Press);
    let PressUp = class PressUp extends PointEvent {
    };
    exports.PressUp = PressUp;
    PressUp.__name__ = "PressUp";
    exports.PressUp = PressUp = __decorate([
        event("pressup")
    ], PressUp);
    let PanStart = class PanStart extends PointEvent {
    };
    exports.PanStart = PanStart;
    PanStart.__name__ = "PanStart";
    exports.PanStart = PanStart = __decorate([
        event("panstart")
    ], PanStart);
    let PanEnd = class PanEnd extends PointEvent {
    };
    exports.PanEnd = PanEnd;
    PanEnd.__name__ = "PanEnd";
    exports.PanEnd = PanEnd = __decorate([
        event("panend")
    ], PanEnd);
    let PinchStart = class PinchStart extends PointEvent {
    };
    exports.PinchStart = PinchStart;
    PinchStart.__name__ = "PinchStart";
    exports.PinchStart = PinchStart = __decorate([
        event("pinchstart")
    ], PinchStart);
    let PinchEnd = class PinchEnd extends PointEvent {
    };
    exports.PinchEnd = PinchEnd;
    PinchEnd.__name__ = "PinchEnd";
    exports.PinchEnd = PinchEnd = __decorate([
        event("pinchend")
    ], PinchEnd);
    let RotateStart = class RotateStart extends PointEvent {
    };
    exports.RotateStart = RotateStart;
    RotateStart.__name__ = "RotateStart";
    exports.RotateStart = RotateStart = __decorate([
        event("rotatestart")
    ], RotateStart);
    let RotateEnd = class RotateEnd extends PointEvent {
    };
    exports.RotateEnd = RotateEnd;
    RotateEnd.__name__ = "RotateEnd";
    exports.RotateEnd = RotateEnd = __decorate([
        event("rotateend")
    ], RotateEnd);
},
/* core/serialization/deserializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const refs_1 = require(48) /* ../util/refs */;
    const ndarray_1 = require(29) /* ../util/ndarray */;
    const object_1 = require(9) /* ../util/object */;
    const array_1 = require(10) /* ../util/array */;
    const platform_1 = require(26) /* ../util/platform */;
    const buffer_1 = require(34) /* ../util/buffer */;
    const types_1 = require(8) /* ../util/types */;
    const slice_1 = require(49) /* ../util/slice */;
    const _decoders = new Map();
    class DeserializationError extends Error {
    }
    exports.DeserializationError = DeserializationError;
    DeserializationError.__name__ = "DeserializationError";
    class Deserializer {
        constructor(resolver, references = new Map(), finalize) {
            this.resolver = resolver;
            this.references = references;
            this.finalize = finalize;
            this._decoding = false;
            this._buffers = new Map();
            this._finalizable = new Set();
        }
        static register(type, decoder) {
            if (!_decoders.has(type))
                _decoders.set(type, decoder);
            else
                throw new Error(`'${type}' already registered for decoding`);
        }
        decode(obj /*AnyVal*/, buffers) {
            var _a;
            if (buffers != null) {
                for (const [id, buffer] of buffers) {
                    this._buffers.set(id, buffer);
                }
            }
            if (this._decoding) {
                return this._decode(obj);
            }
            this._decoding = true;
            let finalizable;
            const decoded = (() => {
                try {
                    return this._decode(obj);
                }
                finally {
                    finalizable = new Set(this._finalizable);
                    this._decoding = false;
                    this._buffers.clear();
                    this._finalizable.clear();
                }
            })();
            for (const instance of finalizable) {
                (_a = this.finalize) === null || _a === void 0 ? void 0 : _a.call(this, instance);
                instance.finalize();
            }
            // `connect_signals` has to be executed last because it may rely on properties
            // of dependencies that are initialized only in `finalize`. It's a problem
            // that appears when there are circular references, e.g. as in
            // CDS -> CustomJS (on data change) -> GlyphRenderer (in args) -> CDS.
            for (const instance of finalizable) {
                instance.connect_signals();
            }
            return decoded;
        }
        _decode(obj /*AnyVal*/) {
            if ((0, types_1.isArray)(obj)) {
                return this._decode_plain_array(obj);
            }
            else if ((0, types_1.isPlainObject)(obj)) {
                if ((0, types_1.isString)(obj.type)) {
                    const decoder = _decoders.get(obj.type);
                    if (decoder != null) {
                        return decoder(obj, this);
                    }
                    switch (obj.type) {
                        case "ref":
                            return this._decode_ref(obj);
                        case "symbol":
                            return this._decode_symbol(obj);
                        case "number":
                            return this._decode_number(obj);
                        case "array":
                            return this._decode_array(obj);
                        case "set":
                            return this._decode_set(obj);
                        case "map":
                            return this._decode_map(obj);
                        case "bytes":
                            return this._decode_bytes(obj);
                        case "slice":
                            return this._decode_slice(obj);
                        case "value":
                            return this._decode_value(obj);
                        case "field":
                            return this._decode_field(obj);
                        case "expr":
                            return this._decode_expr(obj);
                        case "typed_array":
                            return this._decode_typed_array(obj);
                        case "ndarray":
                            return this._decode_ndarray(obj);
                        case "object": {
                            if ((0, types_1.isString)(obj.id)) {
                                return this._decode_object_ref(obj);
                            }
                            else {
                                return this._decode_object(obj);
                            }
                        }
                        default: {
                            this.error(`unable to decode an object of type '${obj.type}'`);
                        }
                    }
                }
                else if ((0, types_1.isString)(obj.id)) {
                    return this._decode_ref(obj);
                }
                else {
                    return this._decode_plain_object(obj);
                }
            }
            else
                return obj;
        }
        _decode_symbol(obj) {
            this.error(`can't resolve named symbol '${obj.name}'`); // TODO: implement symbol resolution
        }
        _decode_number(obj) {
            if ("value" in obj) {
                const { value } = obj;
                if ((0, types_1.isString)(value)) {
                    switch (value) {
                        case "nan": return NaN;
                        case "+inf": return +Infinity;
                        case "-inf": return -Infinity;
                    }
                }
                else if ((0, types_1.isNumber)(value))
                    return value;
            }
            this.error(`invalid number representation '${obj}'`);
        }
        _decode_plain_array(obj) {
            return (0, array_1.map)(obj, (item) => this._decode(item));
        }
        _decode_plain_object(obj) {
            const decoded = {};
            for (const [key, val] of (0, object_1.entries)(obj)) {
                decoded[key] = this._decode(val);
            }
            return decoded;
        }
        _decode_array(obj) {
            var _a;
            const decoded = [];
            for (const entry of (_a = obj.entries) !== null && _a !== void 0 ? _a : []) {
                decoded.push(this._decode(entry));
            }
            return decoded;
        }
        _decode_set(obj) {
            var _a;
            const decoded = new Set();
            for (const entry of (_a = obj.entries) !== null && _a !== void 0 ? _a : []) {
                decoded.add(this._decode(entry));
            }
            return decoded;
        }
        _decode_map(obj) {
            var _a;
            const decoded = (0, array_1.map)((_a = obj.entries) !== null && _a !== void 0 ? _a : [], ([key, val]) => [this._decode(key), this._decode(val)]);
            const is_str = (0, array_1.every)(decoded, ([key]) => (0, types_1.isString)(key));
            if (is_str) {
                const obj = {}; // Object.create(null)
                for (const [key, val] of decoded) {
                    obj[key] = val;
                }
                return obj;
            }
            else
                return new Map(decoded);
        }
        _decode_bytes(obj) {
            const { data } = obj;
            if ((0, refs_1.is_ref)(data)) {
                const buffer = this._buffers.get(data.id);
                if (buffer != null)
                    return buffer;
                else
                    this.error(`buffer for id=${data.id} not found`);
            }
            else if ((0, types_1.isString)(data))
                return (0, buffer_1.base64_to_buffer)(data);
            else
                return data.buffer;
        }
        _decode_slice(obj) {
            const start = this._decode(obj.start);
            const stop = this._decode(obj.stop);
            const step = this._decode(obj.step);
            return new slice_1.Slice({ start, stop, step });
        }
        _decode_value(obj) {
            const value = this._decode(obj.value);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { value, transform, units };
        }
        _decode_field(obj) {
            const field = this._decode(obj.field);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { field, transform, units };
        }
        _decode_expr(obj) {
            const expr = this._decode(obj.expr);
            const transform = obj.transform != null ? this._decode(obj.transform) : undefined;
            const units = obj.units != null ? this._decode(obj.units) : undefined;
            return { expr, transform, units };
        }
        _decode_typed_array(obj) {
            const { array, order, dtype } = obj;
            const buffer = this._decode(array);
            if (order != platform_1.BYTE_ORDER) {
                (0, buffer_1.swap)(buffer, dtype);
            }
            switch (dtype) {
                case "uint8": return new Uint8Array(buffer);
                case "int8": return new Int8Array(buffer);
                case "uint16": return new Uint16Array(buffer);
                case "int16": return new Int16Array(buffer);
                case "uint32": return new Uint32Array(buffer);
                case "int32": return new Int32Array(buffer);
                // case "uint64": return new BigInt64Array(buffer)
                // case "int64":  return new BigInt64Array(buffer)
                case "float32": return new Float32Array(buffer);
                case "float64": return new Float64Array(buffer);
                default:
                    this.error(`unsupported dtype '${dtype}'`);
            }
        }
        _decode_ndarray(obj) {
            const { array, order, dtype, shape } = obj;
            const decoded = this._decode(array);
            if (decoded instanceof ArrayBuffer && order != platform_1.BYTE_ORDER) {
                (0, buffer_1.swap)(decoded, dtype);
            }
            return (0, ndarray_1.ndarray)(decoded /*XXX*/, { dtype, shape });
        }
        _decode_object(obj) {
            const { type, attributes } = obj;
            const cls = this._resolve_type(type);
            if (attributes != null)
                return new cls(this._decode(attributes));
            else
                return new cls();
        }
        _decode_ref(obj) {
            const instance = this.references.get(obj.id);
            if (instance != null)
                return instance;
            else
                this.error(`reference ${obj.id} isn't known`);
        }
        _decode_object_ref(obj) {
            if (this.references.has(obj.id))
                this.error(`reference already known '${obj.id}'`);
            const { id, name: type, attributes } = obj;
            const cls = this._resolve_type(type);
            const instance = new cls({ id });
            this.references.set(id, instance);
            const decoded_attributes = this._decode(attributes !== null && attributes !== void 0 ? attributes : {});
            instance.initialize_props(new object_1.Dict(decoded_attributes));
            this._finalizable.add(instance);
            return instance;
        }
        error(message) {
            throw new DeserializationError(message);
        }
        _resolve_type(type) {
            const cls = this.resolver.get(type);
            if (cls != null)
                return cls;
            else
                this.error(`could not resolve type '${type}', which could be due to a widget or a custom model not being registered before first usage`);
        }
    }
    exports.Deserializer = Deserializer;
    Deserializer.__name__ = "Deserializer";
},
/* core/util/refs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(8) /* ./types */;
    function is_ref(obj) {
        return (0, types_1.isPlainObject)(obj) && "id" in obj && !("type" in obj);
    }
    exports.is_ref = is_ref;
},
/* core/util/slice.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const serialization_1 = require(30) /* ../serialization */;
    class Slice {
        constructor({ start, stop, step } = {}) {
            this.start = start !== null && start !== void 0 ? start : null;
            this.stop = stop !== null && stop !== void 0 ? stop : null;
            this.step = step !== null && step !== void 0 ? step : null;
        }
        [serialization_1.serialize](serializer) {
            return {
                type: "slice",
                start: serializer.encode(this.start),
                stop: serializer.encode(this.stop),
                step: serializer.encode(this.step),
            };
        }
    }
    exports.Slice = Slice;
    Slice.__name__ = "Slice";
},
/* core/util/version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function pyify_version(version) {
        return version.replace(/-(dev|rc)\./, ".$1");
    }
    exports.pyify_version = pyify_version;
},
/* model.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const has_props_1 = require(14) /* ./core/has_props */;
    const types_1 = require(8) /* ./core/util/types */;
    const object_1 = require(9) /* ./core/util/object */;
    const eq_1 = require(25) /* ./core/util/eq */;
    const logging_1 = require(18) /* ./core/logging */;
    class Model extends has_props_1.HasProps {
        constructor(attrs) {
            super(attrs);
        }
        get is_syncable() {
            return this.syncable;
        }
        [eq_1.equals](that, cmp) {
            return (cmp.structural ? true : cmp.eq(this.id, that.id)) && super[eq_1.equals](that, cmp);
        }
        initialize() {
            super.initialize();
            this._js_callbacks = new Map();
        }
        connect_signals() {
            super.connect_signals();
            this._update_property_callbacks();
            this.connect(this.properties.js_property_callbacks.change, () => this._update_property_callbacks());
            this.connect(this.properties.js_event_callbacks.change, () => this._update_event_callbacks());
            this.connect(this.properties.subscribed_events.change, () => this._update_event_callbacks());
        }
        /*protected*/ _process_event(event) {
            var _b;
            for (const callback of (_b = (0, object_1.dict)(this.js_event_callbacks).get(event.event_name)) !== null && _b !== void 0 ? _b : [])
                callback.execute(event);
            if (this.document != null && this.subscribed_events.has(event.event_name))
                this.document.event_manager.send_event(event);
        }
        trigger_event(event) {
            if (this.document != null) {
                event.origin = this;
                this.document.event_manager.trigger(event);
            }
        }
        _update_event_callbacks() {
            if (this.document == null) {
                logging_1.logger.warn("WARNING: Document not defined for updating event callbacks");
                return;
            }
            this.document.event_manager.subscribed_models.add(this);
        }
        _update_property_callbacks() {
            const signal_for = (event) => {
                const [evt, attr = null] = event.split(":");
                return attr != null ? this.properties[attr][evt] : this[evt];
            };
            for (const [event, callbacks] of this._js_callbacks) {
                const signal = signal_for(event);
                for (const cb of callbacks)
                    this.disconnect(signal, cb);
            }
            this._js_callbacks.clear();
            for (const [event, callbacks] of (0, object_1.dict)(this.js_property_callbacks)) {
                const wrappers = callbacks.map((cb) => () => cb.execute(this));
                this._js_callbacks.set(event, wrappers);
                const signal = signal_for(event);
                for (const cb of wrappers)
                    this.connect(signal, cb);
            }
        }
        _doc_attached() {
            if (!(0, object_1.dict)(this.js_event_callbacks).is_empty || this.subscribed_events.size != 0)
                this._update_event_callbacks();
        }
        _doc_detached() {
            this.document.event_manager.subscribed_models.delete(this);
        }
        select(selector) {
            if ((0, types_1.isString)(selector))
                return [...this.references()].filter((ref) => ref instanceof Model && ref.name === selector);
            else if ((0, types_1.isPlainObject)(selector) && "type" in selector)
                return [...this.references()].filter((ref) => ref.type == selector.type);
            else if (selector.prototype instanceof has_props_1.HasProps)
                return [...this.references()].filter((ref) => ref instanceof selector);
            else
                throw new Error("invalid selector");
        }
        select_one(selector) {
            const result = this.select(selector);
            switch (result.length) {
                case 0:
                    return null;
                case 1:
                    return result[0];
                default:
                    throw new Error("found more than one object matching given selector");
            }
        }
        on_event(event, callback) {
            var _b;
            const name = (0, types_1.isString)(event) ? event : event.prototype.event_name;
            this.js_event_callbacks[name] = [
                ...(_b = (0, object_1.dict)(this.js_event_callbacks).get(name)) !== null && _b !== void 0 ? _b : [],
                (0, types_1.isFunction)(callback) ? { execute: callback } : callback,
            ];
        }
    }
    exports.Model = Model;
    _a = Model;
    Model.__name__ = "Model";
    (() => {
        _a.define(({ Any, Unknown, Boolean, String, Array, Set, Dict, Nullable }) => ({
            tags: [Array(Unknown), []],
            name: [Nullable(String), null],
            js_property_callbacks: [Dict(Array(Any /*TODO*/)), {}],
            js_event_callbacks: [Dict(Array(Any /*TODO*/)), {}],
            subscribed_events: [Set(String), new globalThis.Set()],
            syncable: [Boolean, true],
        }));
    })();
},
/* document/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const model_1 = require(51) /* ../model */;
    const kinds = tslib_1.__importStar(require(20) /* ../core/kinds */);
    const types_1 = require(8) /* ../core/util/types */;
    const object_1 = require(9) /* ../core/util/object */;
    function decode_def(def, deserializer) {
        var _b, _c;
        var _a;
        function kind_of(ref) {
            if ((0, types_1.isString)(ref)) {
                switch (ref) {
                    case "Any": return kinds.Any;
                    case "Unknown": return kinds.Unknown;
                    case "Boolean": return kinds.Boolean;
                    case "Number": return kinds.Number;
                    case "Int": return kinds.Int;
                    case "Bytes": return kinds.Bytes;
                    case "String": return kinds.String;
                    case "Null": return kinds.Null;
                }
            }
            else {
                switch (ref[0]) {
                    case "Regex": {
                        const [, regex, flags] = ref;
                        return kinds.Regex(new RegExp(regex, flags));
                    }
                    case "Nullable": {
                        const [, subref] = ref;
                        return kinds.Nullable(kind_of(subref));
                    }
                    case "Or": {
                        const [, subref, ...subrefs] = ref;
                        return kinds.Or(kind_of(subref), ...subrefs.map(kind_of));
                    }
                    case "Tuple": {
                        const [, subref, ...subrefs] = ref;
                        return kinds.Tuple(kind_of(subref), ...subrefs.map(kind_of));
                    }
                    case "Array": {
                        const [, subref] = ref;
                        return kinds.Array(kind_of(subref));
                    }
                    case "Struct": {
                        const [, ...entryrefs] = ref;
                        const entries = entryrefs.map(([key, valref]) => [key, kind_of(valref)]);
                        return kinds.Struct((0, object_1.to_object)(entries));
                    }
                    case "Dict": {
                        const [, valref] = ref;
                        return kinds.Dict(kind_of(valref));
                    }
                    case "Map": {
                        const [, keyref, valref] = ref;
                        return kinds.Map(kind_of(keyref), kind_of(valref));
                    }
                    case "Enum": {
                        const [, ...items] = ref;
                        return kinds.Enum(...items);
                    }
                    case "Ref": {
                        const [, modelref] = ref;
                        const model = deserializer.resolver.get(modelref.id);
                        if (model != null)
                            return kinds.Ref(model);
                        else
                            throw new Error(`${modelref.id} wasn't defined before referencing it`);
                    }
                    case "AnyRef": {
                        return kinds.AnyRef();
                    }
                }
            }
        }
        const base = (() => {
            var _b, _c;
            const name = (_c = (_b = def.extends) === null || _b === void 0 ? void 0 : _b.id) !== null && _c !== void 0 ? _c : "Model";
            if (name == "Model") // TODO: support base classes in general
                return model_1.Model;
            const base = deserializer.resolver.get(name);
            if (base != null)
                return base;
            else
                throw new Error(`base model ${name} of ${def.name} is not defined`);
        })();
        const model = (_a = class extends base {
        },
            _a.__qualified__ = def.name,
            _a);
        function decode(value) {
            if (value === undefined)
                return value;
            else
                return deserializer.decode(value);
        }
        for (const prop of (_b = def.properties) !== null && _b !== void 0 ? _b : []) {
            const kind = kind_of(prop.kind);
            model.define({ [prop.name]: [kind, decode(prop.default)] });
        }
        for (const prop of (_c = def.overrides) !== null && _c !== void 0 ? _c : []) {
            model.override({ [prop.name]: decode(prop.default) });
        }
        deserializer.resolver.register(model);
        return model;
    }
    exports.decode_def = decode_def;
},
/* embed/standalone.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const document_1 = require(5) /* ../document */;
    const view_1 = require(54) /* ../core/view */;
    const dom_view_1 = require(55) /* ../core/dom_view */;
    const build_views_1 = require(59) /* ../core/build_views */;
    // A map from the root model IDs to their views.
    exports.index = {};
    async function add_document_standalone(document, element, roots = [], use_for_title = false) {
        // this is a LOCAL index of views used only by this particular rendering
        // call, so we can remove the views we create.
        const views = new view_1.ViewManager();
        async function render_view(model) {
            var _a;
            const view = await (0, build_views_1.build_view)(model, { parent: null, owner: views });
            if (view instanceof dom_view_1.DOMView) {
                const i = document.roots().indexOf(model);
                const root_el = (_a = roots[i]) !== null && _a !== void 0 ? _a : element;
                view.render_to(root_el);
            }
            views.add(view);
            exports.index[model.id] = view;
        }
        async function render_model(model) {
            if (model.default_view != null)
                await render_view(model);
            else
                document.notify_idle(model);
        }
        function unrender_model(model) {
            const view = views.get(model);
            if (view != null) {
                view.remove();
                views.delete(view);
                delete exports.index[model.id];
            }
        }
        for (const model of document.roots())
            await render_model(model);
        if (use_for_title)
            window.document.title = document.title();
        document.on_change((event) => {
            if (event instanceof document_1.RootAddedEvent)
                render_model(event.model);
            else if (event instanceof document_1.RootRemovedEvent)
                unrender_model(event.model);
            else if (use_for_title && event instanceof document_1.TitleChangedEvent)
                window.document.title = event.title;
        });
        return views;
    }
    exports.add_document_standalone = add_document_standalone;
},
/* core/view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const signaling_1 = require(15) /* ./signaling */;
    const types_1 = require(8) /* ./util/types */;
    class View {
        constructor(options) {
            this.removed = new signaling_1.Signal0(this, "removed");
            this._ready = Promise.resolve(undefined);
            /** @internal */
            this._slots = new WeakMap();
            this._removed = false;
            this._idle_notified = false;
            const { model, parent, owner } = options;
            this.model = model;
            this.parent = parent;
            if (parent == null) {
                this.root = this;
                this.owner = owner !== null && owner !== void 0 ? owner : new ViewManager([this]);
            }
            else {
                this.root = parent.root;
                this.owner = this.root.owner;
            }
        }
        get ready() {
            return this._ready;
        }
        *children() { }
        connect(signal, slot) {
            let new_slot = this._slots.get(slot);
            if (new_slot == null) {
                new_slot = (args, sender) => {
                    const promise = Promise.resolve(slot.call(this, args, sender));
                    this._ready = this._ready.then(() => promise);
                    if (this.root != this) {
                        this.root._ready = this.root._ready.then(() => this._ready);
                    }
                };
                this._slots.set(slot, new_slot);
            }
            return signal.connect(new_slot, this);
        }
        disconnect(signal, slot) {
            return signal.disconnect(slot, this);
        }
        initialize() {
            this._has_finished = false;
        }
        async lazy_initialize() { }
        remove() {
            this.disconnect_signals();
            this.removed.emit();
            this._removed = true;
        }
        toString() {
            return `${this.model.type}View(${this.model.id})`;
        }
        serializable_state() {
            return { type: this.model.type };
        }
        get is_root() {
            return this.parent == null;
        }
        has_finished() {
            return this._has_finished;
        }
        get is_idle() {
            return this.has_finished();
        }
        connect_signals() { }
        disconnect_signals() {
            signaling_1.Signal.disconnect_receiver(this);
        }
        on_change(properties, fn) {
            for (const property of (0, types_1.isArray)(properties) ? properties : [properties]) {
                this.connect(property.change, fn);
            }
        }
        cursor(_sx, _sy) {
            return null;
        }
        notify_finished() {
            if (!this.is_root)
                this.root.notify_finished();
            else {
                if (!this._idle_notified && this.has_finished()) {
                    if (this.model.document != null) {
                        this._idle_notified = true;
                        this.model.document.notify_idle(this.model);
                    }
                }
            }
        }
    }
    exports.View = View;
    View.__name__ = "View";
    class ViewManager {
        constructor(roots = []) {
            this.roots = new Set(roots);
        }
        get(model) {
            for (const view of this.roots) {
                if (view.model == model)
                    return view;
            }
            return null;
        }
        add(view) {
            this.roots.add(view);
        }
        delete(view) {
            this.roots.delete(view);
        }
        *[Symbol.iterator]() {
            yield* this.roots;
        }
        *query(fn) {
            function* descend(view) {
                if (fn(view)) {
                    yield view;
                }
                else {
                    for (const child of view.children()) {
                        yield* descend(child);
                    }
                }
            }
            for (const root of this.roots) {
                yield* descend(root);
            }
        }
        *find(model) {
            yield* this.query((view) => view.model == model);
        }
        get_one(model) {
            const view = this.find_one(model);
            if (view != null)
                return view;
            else
                throw new Error(`cannot find a view for ${model}`);
        }
        find_one(model) {
            for (const view of this.find(model)) {
                return view;
            }
            return null;
        }
        find_all(model) {
            return [...this.find(model)];
        }
    }
    exports.ViewManager = ViewManager;
    ViewManager.__name__ = "ViewManager";
},
/* core/dom_view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const view_1 = require(54) /* ./view */;
    const dom_1 = require(56) /* ./dom */;
    const types_1 = require(8) /* ./util/types */;
    const base_css_1 = tslib_1.__importDefault(require(58) /* ../styles/base.css */);
    class DOMView extends view_1.View {
        get children_el() {
            var _a;
            return (_a = this.shadow_el) !== null && _a !== void 0 ? _a : this.el;
        }
        initialize() {
            super.initialize();
            this.el = this._createElement();
        }
        remove() {
            (0, dom_1.remove)(this.el);
            super.remove();
        }
        css_classes() {
            return [];
        }
        styles() {
            return [];
        }
        render_to(element) {
            element.appendChild(this.el);
            this.render();
        }
        finish() {
            this._has_finished = true;
            this.notify_finished();
        }
        _createElement() {
            return (0, dom_1.createElement)(this.constructor.tag_name, { class: this.css_classes() });
        }
    }
    exports.DOMView = DOMView;
    DOMView.__name__ = "DOMView";
    DOMView.tag_name = "div";
    class DOMElementView extends DOMView {
        initialize() {
            super.initialize();
            this.class_list = new dom_1.ClassList(this.el.classList);
        }
    }
    exports.DOMElementView = DOMElementView;
    DOMElementView.__name__ = "DOMElementView";
    class DOMComponentView extends DOMElementView {
        initialize() {
            super.initialize();
            this.shadow_el = this.el.attachShadow({ mode: "open" });
        }
        styles() {
            return [...super.styles(), base_css_1.default];
        }
        empty() {
            (0, dom_1.empty)(this.shadow_el);
            this.class_list.clear();
        }
        render() {
            this.empty();
            this._apply_stylesheets(this.styles());
            this._apply_classes(this.css_classes());
        }
        _apply_stylesheets(stylesheets) {
            /*
            if (supports_adopted_stylesheets) {
              const sheets: CSSStyleSheet[] = []
              for (const style of this.styles()) {
                const sheet = new CSSStyleSheet()
                sheet.replaceSync(style)
                sheets.push(sheet)
              }
              this.shadow_el.adoptedStyleSheets = sheets
            } else {
            */
            for (const style of stylesheets) {
                const stylesheet = (0, types_1.isString)(style) ? new dom_1.StyleSheet(style) : style;
                this.shadow_el.appendChild(stylesheet.el);
            }
        }
        _apply_classes(classes) {
            this.class_list.add(...classes);
        }
    }
    exports.DOMComponentView = DOMComponentView;
    DOMComponentView.__name__ = "DOMComponentView";
},
/* core/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.supports_adopted_stylesheets = exports.px = void 0;
    const types_1 = require(8) /* ./util/types */;
    const object_1 = require(9) /* ./util/object */;
    const bbox_1 = require(57) /* ./util/bbox */;
    const _createElement = (tag) => {
        return (attrs = {}, ...children) => {
            const element = document.createElement(tag);
            if (!(0, types_1.isPlainObject)(attrs)) {
                children = [attrs, ...children];
                attrs = {};
            }
            for (let [attr, value] of (0, object_1.entries)(attrs)) {
                if (value == null || (0, types_1.isBoolean)(value) && !value)
                    continue;
                if (attr === "class") {
                    if ((0, types_1.isString)(value))
                        value = value.split(/\s+/);
                    if ((0, types_1.isArray)(value)) {
                        for (const cls of value) {
                            if (cls != null)
                                element.classList.add(cls);
                        }
                        continue;
                    }
                }
                if (attr === "style" && (0, types_1.isPlainObject)(value)) {
                    for (const [prop, data] of (0, object_1.entries)(value)) {
                        element.style[prop] = data;
                    }
                    continue;
                }
                if (attr === "data" && (0, types_1.isPlainObject)(value)) {
                    for (const [key, data] of (0, object_1.entries)(value)) {
                        element.dataset[key] = data; // XXX: attrs needs a better type
                    }
                    continue;
                }
                element.setAttribute(attr, value);
            }
            function append(child) {
                if ((0, types_1.isString)(child))
                    element.appendChild(document.createTextNode(child));
                else if (child instanceof Node)
                    element.appendChild(child);
                else if (child instanceof NodeList || child instanceof HTMLCollection) {
                    for (const el of child) {
                        element.appendChild(el);
                    }
                }
                else if (child != null && child !== false)
                    throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
            }
            for (const child of children) {
                if ((0, types_1.isArray)(child)) {
                    for (const _child of child)
                        append(_child);
                }
                else
                    append(child);
            }
            return element;
        };
    };
    function createElement(tag, attrs, ...children) {
        return _createElement(tag)(attrs, ...children);
    }
    exports.createElement = createElement;
    exports.div = _createElement("div"), exports.span = _createElement("span"), exports.canvas = _createElement("canvas"), exports.link = _createElement("link"), exports.style = _createElement("style"), exports.a = _createElement("a"), exports.p = _createElement("p"), exports.i = _createElement("i"), exports.pre = _createElement("pre"), exports.button = _createElement("button"), exports.label = _createElement("label"), exports.legend = _createElement("legend"), exports.fieldset = _createElement("fieldset"), exports.input = _createElement("input"), exports.select = _createElement("select"), exports.option = _createElement("option"), exports.optgroup = _createElement("optgroup"), exports.textarea = _createElement("textarea");
    function createSVGElement(tag, attrs = null, ...children) {
        const element = document.createElementNS("http://www.w3.org/2000/svg", tag);
        for (const [attr, value] of (0, object_1.entries)(attrs !== null && attrs !== void 0 ? attrs : {})) {
            if (value == null || value === false)
                continue;
            element.setAttribute(attr, value);
        }
        function append(child) {
            if ((0, types_1.isString)(child))
                element.appendChild(document.createTextNode(child));
            else if (child instanceof Node)
                element.appendChild(child);
            else if (child instanceof NodeList || child instanceof HTMLCollection) {
                for (const el of child) {
                    element.appendChild(el);
                }
            }
            else if (child != null && child !== false)
                throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(child)}`);
        }
        for (const child of children) {
            if ((0, types_1.isArray)(child)) {
                for (const _child of child)
                    append(_child);
            }
            else
                append(child);
        }
        return element;
    }
    exports.createSVGElement = createSVGElement;
    function text(str) {
        return document.createTextNode(str);
    }
    exports.text = text;
    function nbsp() {
        return text("\u00a0");
    }
    exports.nbsp = nbsp;
    function append(element, ...children) {
        for (const child of children)
            element.appendChild(child);
    }
    exports.append = append;
    function remove(element) {
        const parent = element.parentNode;
        if (parent != null) {
            parent.removeChild(element);
        }
    }
    exports.remove = remove;
    function replaceWith(element, replacement) {
        const parent = element.parentNode;
        if (parent != null) {
            parent.replaceChild(replacement, element);
        }
    }
    exports.replaceWith = replaceWith;
    function prepend(element, ...nodes) {
        const first = element.firstChild;
        for (const node of nodes) {
            element.insertBefore(node, first);
        }
    }
    exports.prepend = prepend;
    function empty(node, attrs = false) {
        let child;
        while (child = node.firstChild) {
            node.removeChild(child);
        }
        if (attrs && node instanceof Element) {
            for (const attr of node.attributes) {
                node.removeAttributeNode(attr);
            }
        }
    }
    exports.empty = empty;
    function contains(element, child) {
        /**
         * Like Node.contains(), but traverses Shadow DOM boundaries.
         */
        let current = child;
        while (current.parentNode != null) {
            const parent = current.parentNode;
            if (parent == element) {
                return true;
            }
            else if (parent instanceof ShadowRoot) {
                current = parent.host;
            }
            else {
                current = parent;
            }
        }
        return false;
    }
    exports.contains = contains;
    function display(element, display = true) {
        element.style.display = display ? "" : "none";
    }
    exports.display = display;
    function undisplay(element) {
        element.style.display = "none";
    }
    exports.undisplay = undisplay;
    function show(element) {
        element.style.visibility = "";
    }
    exports.show = show;
    function hide(element) {
        element.style.visibility = "hidden";
    }
    exports.hide = hide;
    function offset_bbox(element) {
        const { top, left, width, height } = element.getBoundingClientRect();
        return new bbox_1.BBox({
            left: left + scrollX - document.documentElement.clientLeft,
            top: top + scrollY - document.documentElement.clientTop,
            width,
            height,
        });
    }
    exports.offset_bbox = offset_bbox;
    function parent(el, selector) {
        let node = el;
        while (node = node.parentElement) {
            if (node.matches(selector))
                return node;
        }
        return null;
    }
    exports.parent = parent;
    function num(value) {
        return parseFloat(value) || 0;
    }
    function extents(el) {
        const style = getComputedStyle(el);
        return {
            border: {
                top: num(style.borderTopWidth),
                bottom: num(style.borderBottomWidth),
                left: num(style.borderLeftWidth),
                right: num(style.borderRightWidth),
            },
            margin: {
                top: num(style.marginTop),
                bottom: num(style.marginBottom),
                left: num(style.marginLeft),
                right: num(style.marginRight),
            },
            padding: {
                top: num(style.paddingTop),
                bottom: num(style.paddingBottom),
                left: num(style.paddingLeft),
                right: num(style.paddingRight),
            },
        };
    }
    exports.extents = extents;
    function size(el) {
        const rect = el.getBoundingClientRect();
        return {
            width: Math.ceil(rect.width),
            height: Math.ceil(rect.height),
        };
    }
    exports.size = size;
    function scroll_size(el) {
        return {
            width: Math.ceil(el.scrollWidth),
            height: Math.ceil(el.scrollHeight),
        };
    }
    exports.scroll_size = scroll_size;
    function outer_size(el) {
        const { margin: { left, right, top, bottom } } = extents(el);
        const { width, height } = size(el);
        return {
            width: Math.ceil(width + left + right),
            height: Math.ceil(height + top + bottom),
        };
    }
    exports.outer_size = outer_size;
    function content_size(el) {
        var _a;
        const { left, top } = el.getBoundingClientRect();
        const { padding } = extents(el);
        let width = 0;
        let height = 0;
        for (const child of ((_a = el.shadowRoot) !== null && _a !== void 0 ? _a : el).children) {
            const rect = child.getBoundingClientRect();
            width = Math.max(width, Math.ceil(rect.left - left - padding.left + rect.width));
            height = Math.max(height, Math.ceil(rect.top - top - padding.top + rect.height));
        }
        return { width, height };
    }
    exports.content_size = content_size;
    function bounding_box(el) {
        const { x, y, width, height } = el.getBoundingClientRect();
        return new bbox_1.BBox({ x, y, width, height });
    }
    exports.bounding_box = bounding_box;
    function position(el, box, margin) {
        const { style } = el;
        style.left = `${box.x}px`;
        style.top = `${box.y}px`;
        style.width = `${box.width}px`;
        style.height = `${box.height}px`;
        if (margin == null)
            style.margin = "";
        else {
            const { top, right, bottom, left } = margin;
            style.margin = `${top}px ${right}px ${bottom}px ${left}px`;
        }
    }
    exports.position = position;
    class ClassList {
        constructor(class_list) {
            this.class_list = class_list;
        }
        get values() {
            const values = [];
            for (let i = 0; i < this.class_list.length; i++) {
                const item = this.class_list.item(i);
                if (item != null)
                    values.push(item);
            }
            return values;
        }
        has(cls) {
            return this.class_list.contains(cls);
        }
        add(...classes) {
            for (const cls of classes)
                this.class_list.add(cls);
            return this;
        }
        remove(...classes) {
            for (const cls of classes) {
                if ((0, types_1.isArray)(cls)) {
                    cls.forEach((cls) => this.class_list.remove(cls));
                }
                else {
                    this.class_list.remove(cls);
                }
            }
            return this;
        }
        clear() {
            for (const cls of this.values) {
                this.class_list.remove(cls);
            }
            return this;
        }
        toggle(cls, activate) {
            const add = activate != null ? activate : !this.has(cls);
            if (add)
                this.add(cls);
            else
                this.remove(cls);
            return this;
        }
    }
    exports.ClassList = ClassList;
    ClassList.__name__ = "ClassList";
    function classes(el) {
        return new ClassList(el.classList);
    }
    exports.classes = classes;
    function toggle_attribute(el, attr, state) {
        if (state == null) {
            state = !el.hasAttribute(attr);
        }
        if (state)
            el.setAttribute(attr, "true");
        else
            el.removeAttribute(attr);
    }
    exports.toggle_attribute = toggle_attribute;
    (function (MouseButton) {
        MouseButton[MouseButton["None"] = 0] = "None";
        MouseButton[MouseButton["Primary"] = 1] = "Primary";
        MouseButton[MouseButton["Secondary"] = 2] = "Secondary";
        MouseButton[MouseButton["Auxiliary"] = 4] = "Auxiliary";
        MouseButton[MouseButton["Left"] = 1] = "Left";
        MouseButton[MouseButton["Right"] = 2] = "Right";
        MouseButton[MouseButton["Middle"] = 4] = "Middle";
    })(exports.MouseButton || (exports.MouseButton = {}));
    class StyleSheet {
        constructor(css) {
            this.el = (0, exports.style)({ type: "text/css" }, css);
        }
        clear() {
            this.replace("");
        }
        *_to_rules(styles) {
            // TODO: prefixing
            for (const [attr, value] of (0, object_1.entries)(styles)) {
                if (value != null) {
                    const name = attr.replace(/_/g, "-");
                    yield `${name}: ${value};`;
                }
            }
        }
        _to_css(css, styles) {
            if (styles == null)
                return css;
            else
                return `${css}{${[...this._to_rules(styles)].join("")}}`;
        }
        replace(css, styles) {
            this.el.textContent = this._to_css(css, styles);
        }
        prepend(css, styles) {
            var _a;
            const text = (_a = this.el.textContent) !== null && _a !== void 0 ? _a : "";
            this.el.textContent = `${this._to_css(css, styles)}\n${text}`;
        }
        append(css, styles) {
            var _a;
            const text = (_a = this.el.textContent) !== null && _a !== void 0 ? _a : "";
            this.el.textContent = `${text}\n${this._to_css(css, styles)}`;
        }
        remove() {
            remove(this.el);
        }
    }
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    class GlobalStyleSheet extends StyleSheet {
        initialize() {
            if (!this.el.isConnected) {
                document.head.appendChild(this.el);
            }
        }
    }
    exports.GlobalStyleSheet = GlobalStyleSheet;
    GlobalStyleSheet.__name__ = "GlobalStyleSheet";
    class ImportedStyleSheet {
        constructor(url) {
            this.el = (0, exports.link)({ rel: "stylesheet", href: url });
        }
        replace(url) {
            this.el.href = url;
        }
        remove() {
            remove(this.el);
        }
    }
    exports.ImportedStyleSheet = ImportedStyleSheet;
    ImportedStyleSheet.__name__ = "ImportedStyleSheet";
    class GlobalImportedStyleSheet extends StyleSheet {
        initialize() {
            if (!this.el.isConnected) {
                document.head.appendChild(this.el);
            }
        }
    }
    exports.GlobalImportedStyleSheet = GlobalImportedStyleSheet;
    GlobalImportedStyleSheet.__name__ = "GlobalImportedStyleSheet";
    async function dom_ready() {
        if (document.readyState == "loading") {
            return new Promise((resolve, _reject) => {
                document.addEventListener("DOMContentLoaded", () => resolve(), { once: true });
            });
        }
    }
    exports.dom_ready = dom_ready;
    function px(value) {
        return `${value}px`;
    }
    exports.px = px;
    exports.supports_adopted_stylesheets = "adoptedStyleSheets" in ShadowRoot.prototype;
},
/* core/util/bbox.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(23) /* ../types */;
    const eq_1 = require(25) /* ./eq */;
    const { min, max } = Math;
    function empty() {
        return {
            x0: Infinity,
            y0: Infinity,
            x1: -Infinity,
            y1: -Infinity,
        };
    }
    exports.empty = empty;
    function positive_x() {
        return {
            x0: Number.MIN_VALUE,
            y0: -Infinity,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_x = positive_x;
    function positive_y() {
        return {
            x0: -Infinity,
            y0: Number.MIN_VALUE,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_y = positive_y;
    function union(a, b) {
        return {
            x0: min(a.x0, b.x0),
            x1: max(a.x1, b.x1),
            y0: min(a.y0, b.y0),
            y1: max(a.y1, b.y1),
        };
    }
    exports.union = union;
    class BBox {
        constructor(box, correct = false) {
            if (box == null) {
                this.x0 = 0;
                this.y0 = 0;
                this.x1 = 0;
                this.y1 = 0;
            }
            else if ("x0" in box) {
                const { x0, y0, x1, y1 } = box;
                if (!(x0 <= x1 && y0 <= y1))
                    throw new Error(`invalid bbox {x0: ${x0}, y0: ${y0}, x1: ${x1}, y1: ${y1}}`);
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }
            else if ("x" in box) {
                const { x, y, width, height } = box;
                if (!(width >= 0 && height >= 0))
                    throw new Error(`invalid bbox {x: ${x}, y: ${y}, width: ${width}, height: ${height}}`);
                this.x0 = x;
                this.y0 = y;
                this.x1 = x + width;
                this.y1 = y + height;
            }
            else {
                let left, right;
                let top, bottom;
                if ("width" in box) {
                    if ("left" in box) {
                        left = box.left;
                        right = left + box.width;
                    }
                    else if ("right" in box) {
                        right = box.right;
                        left = right - box.width;
                    }
                    else {
                        const w2 = box.width / 2;
                        left = box.hcenter - w2;
                        right = box.hcenter + w2;
                    }
                }
                else {
                    left = box.left;
                    right = box.right;
                }
                if ("height" in box) {
                    if ("top" in box) {
                        top = box.top;
                        bottom = top + box.height;
                    }
                    else if ("bottom" in box) {
                        bottom = box.bottom;
                        top = bottom - box.height;
                    }
                    else {
                        const h2 = box.height / 2;
                        top = box.vcenter - h2;
                        bottom = box.vcenter + h2;
                    }
                }
                else {
                    top = box.top;
                    bottom = box.bottom;
                }
                if (left > right || top > bottom) {
                    if (correct) {
                        if (left > right)
                            left = right;
                        if (top > bottom)
                            top = bottom;
                    }
                    else
                        throw new Error(`invalid bbox {left: ${left}, top: ${top}, right: ${right}, bottom: ${bottom}}`);
                }
                this.x0 = left;
                this.y0 = top;
                this.x1 = right;
                this.y1 = bottom;
            }
        }
        static from_lrtb({ left, right, top, bottom }) {
            return new BBox({
                x0: Math.min(left, right),
                y0: Math.min(top, bottom),
                x1: Math.max(left, right),
                y1: Math.max(top, bottom),
            });
        }
        clone() {
            return new BBox(this);
        }
        equals(that) {
            return this.x0 == that.x0 && this.y0 == that.y0 &&
                this.x1 == that.x1 && this.y1 == that.y1;
        }
        [eq_1.equals](that, cmp) {
            return cmp.eq(this.x0, that.x0) && cmp.eq(this.y0, that.y0) &&
                cmp.eq(this.x1, that.x1) && cmp.eq(this.y1, that.y1);
        }
        toString() {
            return `BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`;
        }
        get is_empty() {
            const { x0, x1, y0, y1 } = this;
            return x0 == 0 && x1 == 0 && y0 == 0 && y1 == 0;
        }
        get left() { return this.x0; }
        get top() { return this.y0; }
        get right() { return this.x1; }
        get bottom() { return this.y1; }
        get p0() { return [this.x0, this.y0]; }
        get p1() { return [this.x1, this.y1]; }
        get x() { return this.x0; }
        get y() { return this.y0; }
        get width() { return this.x1 - this.x0; }
        get height() { return this.y1 - this.y0; }
        get size() { return { width: this.width, height: this.height }; }
        get rect() {
            const { x0, y0, x1, y1 } = this;
            return {
                p0: { x: x0, y: y0 },
                p1: { x: x1, y: y0 },
                p2: { x: x1, y: y1 },
                p3: { x: x0, y: y1 },
            };
        }
        get box() {
            const { x, y, width, height } = this;
            return { x, y, width, height };
        }
        get lrtb() {
            const { left, right, top, bottom } = this;
            return { left, right, top, bottom };
        }
        get h_range() { return { start: this.x0, end: this.x1 }; }
        get v_range() { return { start: this.y0, end: this.y1 }; }
        get ranges() { return [this.h_range, this.v_range]; }
        get aspect() { return this.width / this.height; }
        get hcenter() { return (this.left + this.right) / 2; }
        get vcenter() { return (this.top + this.bottom) / 2; }
        get area() { return this.width * this.height; }
        relative() {
            const { width, height } = this;
            return new BBox({ x: 0, y: 0, width, height });
        }
        translate(tx, ty) {
            const { x, y, width, height } = this;
            return new BBox({ x: tx + x, y: ty + y, width, height });
        }
        relativize(x, y) {
            return [x - this.x, y - this.y];
        }
        contains(x, y) {
            return this.x0 <= x && x <= this.x1 && this.y0 <= y && y <= this.y1;
        }
        clip(x, y) {
            if (x < this.x0)
                x = this.x0;
            else if (x > this.x1)
                x = this.x1;
            if (y < this.y0)
                y = this.y0;
            else if (y > this.y1)
                y = this.y1;
            return [x, y];
        }
        grow_by(size) {
            return new BBox({
                left: this.left - size,
                right: this.right + size,
                top: this.top - size,
                bottom: this.bottom + size,
            });
        }
        shrink_by(size) {
            return new BBox({
                left: this.left + size,
                right: this.right - size,
                top: this.top + size,
                bottom: this.bottom - size,
            }, true);
        }
        union(that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1),
            });
        }
        intersection(that) {
            if (!this.intersects(that))
                return null;
            else {
                return new BBox({
                    x0: max(this.x0, that.x0),
                    y0: max(this.y0, that.y0),
                    x1: min(this.x1, that.x1),
                    y1: min(this.y1, that.y1),
                });
            }
        }
        intersects(that) {
            return !(that.x1 < this.x0 || that.x0 > this.x1 ||
                that.y1 < this.y0 || that.y0 > this.y1);
        }
        get xview() {
            return {
                compute: (x) => {
                    return this.left + x;
                },
                v_compute: (xx) => {
                    const sxx = new types_1.ScreenArray(xx.length);
                    const left = this.left;
                    for (let i = 0; i < xx.length; i++) {
                        sxx[i] = left + xx[i];
                    }
                    return sxx;
                },
                invert: (sx) => {
                    return sx - this.left;
                },
                v_invert: (sxx) => {
                    const xx = new types_1.ScreenArray(sxx.length);
                    const left = this.left;
                    for (let i = 0; i < sxx.length; i++) {
                        xx[i] = sxx[i] - left;
                    }
                    return xx;
                },
            };
        }
        get yview() {
            return {
                compute: (y) => {
                    return this.bottom - y;
                },
                v_compute: (yy) => {
                    const syy = new types_1.ScreenArray(yy.length);
                    const bottom = this.bottom;
                    for (let i = 0; i < yy.length; i++) {
                        syy[i] = bottom - yy[i];
                    }
                    return syy;
                },
                invert: (sy) => {
                    return this.bottom - sy;
                },
                v_invert: (syy) => {
                    const yy = new types_1.ScreenArray(syy.length);
                    const bottom = this.bottom;
                    for (let i = 0; i < syy.length; i++) {
                        yy[i] = bottom - syy[i];
                    }
                    return yy;
                },
            };
        }
    }
    exports.BBox = BBox;
    BBox.__name__ = "BBox";
},
/* styles/base.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = `:host{--base-font:var(--bokeh-base-font, Helvetica, Arial, sans-serif);--mono-font:var(--bokeh-mono-font, monospace);--font-size:12px;--line-height:calc(20 / 14);--line-height-computed:calc(var(--font-size) * var(--line-height));--border-radius:4px;--padding-vertical:6px;--padding-horizontal:12px;}:host{box-sizing:border-box;font-family:var(--base-font);font-size:13px;line-height:var(--line-height);}*,*:before,*:after{box-sizing:inherit;font-family:inherit;}pre{font-family:var(--mono-font);margin:0;}`;
},
/* core/build_views.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const array_1 = require(10) /* ./util/array */;
    const assert_1 = require(12) /* ./util/assert */;
    async function _build_view(view_cls, model, options) {
        (0, assert_1.assert)(view_cls != null, "model doesn't implement a view");
        const view = new view_cls(Object.assign(Object.assign({}, options), { model }));
        view.initialize();
        await view.lazy_initialize();
        return view;
    }
    async function build_view(model, options = { parent: null }, cls = (model) => model.default_view) {
        const view = await _build_view(cls(model), model, options);
        view.connect_signals();
        return view;
    }
    exports.build_view = build_view;
    async function build_views(view_storage, models, options = { parent: null }, cls = (model) => model.default_view) {
        const to_remove = (0, array_1.difference)([...view_storage.keys()], models);
        const removed_views = [];
        for (const model of to_remove) {
            const view = view_storage.get(model);
            if (view != null) {
                view_storage.delete(model);
                removed_views.push(view);
                view.remove();
            }
        }
        const created_views = [];
        const new_models = models.filter((model) => !view_storage.has(model));
        for (const model of new_models) {
            const view = await _build_view(cls(model), model, options);
            view_storage.set(model, view);
            created_views.push(view);
        }
        for (const view of created_views)
            view.connect_signals();
        return {
            created: created_views,
            removed: removed_views,
        };
    }
    exports.build_views = build_views;
    function remove_views(view_storage) {
        for (const [model, view] of view_storage) {
            view.remove();
            view_storage.delete(model);
        }
    }
    exports.remove_views = remove_views;
},
/* embed/server.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const connection_1 = require(61) /* ../client/connection */;
    const logging_1 = require(18) /* ../core/logging */;
    const standalone_1 = require(53) /* ./standalone */;
    // @internal
    function _get_ws_url(app_path, absolute_url) {
        let protocol = "ws:";
        if (window.location.protocol == "https:")
            protocol = "wss:";
        let loc;
        if (absolute_url != null) {
            loc = document.createElement("a");
            loc.href = absolute_url;
        }
        else
            loc = window.location;
        if (app_path != null) {
            if (app_path == "/")
                app_path = "";
        }
        else
            app_path = loc.pathname.replace(/\/+$/, "");
        return `${protocol}//${loc.host}${app_path}/ws`;
    }
    exports._get_ws_url = _get_ws_url;
    const _sessions = new Map();
    function _get_session(websocket_url, token, args_string) {
        const session_id = (0, connection_1.parse_token)(token).session_id;
        if (!_sessions.has(websocket_url))
            _sessions.set(websocket_url, new Map());
        const subsessions = _sessions.get(websocket_url);
        if (!subsessions.has(session_id))
            subsessions.set(session_id, (0, connection_1.pull_session)(websocket_url, token, args_string));
        return subsessions.get(session_id);
    }
    // Fill element with the roots from token
    async function add_document_from_session(websocket_url, token, element, roots = [], use_for_title = false) {
        const args_string = window.location.search.substring(1);
        let session;
        try {
            session = await _get_session(websocket_url, token, args_string);
        }
        catch (error) {
            const session_id = (0, connection_1.parse_token)(token).session_id;
            logging_1.logger.error(`Failed to load Bokeh session ${session_id}: ${error}`);
            throw error;
        }
        return (0, standalone_1.add_document_standalone)(session.document, element, roots, use_for_title);
    }
    exports.add_document_from_session = add_document_from_session;
},
/* client/connection.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const logging_1 = require(18) /* ../core/logging */;
    const document_1 = require(5) /* ../document */;
    const message_1 = require(62) /* ../protocol/message */;
    const receiver_1 = require(63) /* ../protocol/receiver */;
    const session_1 = require(64) /* ./session */;
    exports.DEFAULT_SERVER_WEBSOCKET_URL = "ws://localhost:5006/ws";
    exports.DEFAULT_TOKEN = "eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";
    let _connection_count = 0;
    function parse_token(token) {
        let payload = token.split(".")[0];
        const mod = payload.length % 4;
        if (mod != 0)
            payload = payload + "=".repeat(4 - mod);
        return JSON.parse(atob(payload.replace(/_/g, "/").replace(/-/g, "+")));
    }
    exports.parse_token = parse_token;
    class ClientConnection {
        constructor(url = exports.DEFAULT_SERVER_WEBSOCKET_URL, token = exports.DEFAULT_TOKEN, args_string = null) {
            this.url = url;
            this.token = token;
            this.args_string = args_string;
            this._number = _connection_count++;
            this.socket = null;
            this.session = null;
            this.closed_permanently = false;
            this._current_handler = null;
            this._pending_replies = new Map();
            this._pending_messages = [];
            this._receiver = new receiver_1.Receiver();
            this.id = parse_token(token).session_id.split(".")[0];
            logging_1.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`);
        }
        async connect() {
            if (this.closed_permanently)
                throw new Error("Cannot connect() a closed ClientConnection");
            if (this.socket != null)
                throw new Error("Already connected");
            this._current_handler = null;
            this._pending_replies.clear();
            this._pending_messages = [];
            try {
                let versioned_url = `${this.url}`;
                if (this.args_string != null && this.args_string.length > 0)
                    versioned_url += `?${this.args_string}`;
                this.socket = new WebSocket(versioned_url, ["bokeh", this.token]);
                return new Promise((resolve, reject) => {
                    // "arraybuffer" gives us binary data we can look at;
                    // if we just needed an opaque blob we could use "blob"
                    this.socket.binaryType = "arraybuffer";
                    this.socket.onopen = () => this._on_open(resolve, reject);
                    this.socket.onmessage = (event) => this._on_message(event);
                    this.socket.onclose = (event) => this._on_close(event, reject);
                    this.socket.onerror = () => this._on_error(reject);
                });
            }
            catch (error) {
                logging_1.logger.error(`websocket creation failed to url: ${this.url}`);
                logging_1.logger.error(` - ${error}`);
                throw error;
            }
        }
        close() {
            if (!this.closed_permanently) {
                logging_1.logger.debug(`Permanently closing websocket connection ${this._number}`);
                this.closed_permanently = true;
                if (this.socket != null)
                    this.socket.close(1000, `close method called on ClientConnection ${this._number}`);
                this.session._connection_closed();
            }
        }
        _schedule_reconnect(milliseconds) {
            const retry = () => {
                // TODO commented code below until we fix reconnection to repull
                // the document when required. Otherwise, we get a lot of
                // confusing errors that are causing trouble when debugging.
                /*
                if (this.closed_permanently) {
                */
                if (!this.closed_permanently)
                    logging_1.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`);
                return;
                /*
                } else {
                  logger.debug(`Attempting to reconnect websocket ${this._number}`)
                  this.connect()
                }
                */
            };
            setTimeout(retry, milliseconds);
        }
        send(message) {
            if (this.socket != null)
                message.send(this.socket);
            else
                logging_1.logger.error("not connected so cannot send", message);
        }
        async send_with_reply(message) {
            const reply = await new Promise((resolve, reject) => {
                this._pending_replies.set(message.msgid(), { resolve, reject });
                this.send(message);
            });
            if (reply.msgtype() == "ERROR")
                throw new Error(`Error reply ${reply.content.text}`);
            else
                return reply;
        }
        async _pull_doc_json() {
            const message = message_1.Message.create("PULL-DOC-REQ", {}, {});
            const reply = await this.send_with_reply(message);
            if (!("doc" in reply.content))
                throw new Error("No 'doc' field in PULL-DOC-REPLY");
            return reply.content.doc;
        }
        async _repull_session_doc(resolve, reject) {
            logging_1.logger.debug(this.session ? "Repulling session" : "Pulling session for first time");
            try {
                const doc_json = await this._pull_doc_json();
                if (this.session == null) {
                    if (this.closed_permanently) {
                        logging_1.logger.debug("Got new document after connection was already closed");
                        reject(new Error("The connection has been closed"));
                    }
                    else {
                        const events = [];
                        const document = document_1.Document.from_json(doc_json, events);
                        this.session = new session_1.ClientSession(this, document);
                        // Send back change events that happend during model initialization.
                        for (const event of events) {
                            document._trigger_on_change(event);
                        }
                        for (const msg of this._pending_messages) {
                            this.session.handle(msg);
                        }
                        this._pending_messages = [];
                        logging_1.logger.debug("Created a new session from new pulled doc");
                        resolve(this.session);
                    }
                }
                else {
                    this.session.document.replace_with_json(doc_json);
                    logging_1.logger.debug("Updated existing session with new pulled doc");
                    // Since the session already exists, we don't need to call `resolve` again.
                }
            }
            catch (error) {
                console.trace(error);
                logging_1.logger.error(`Failed to repull session ${error}`);
                reject(error instanceof Error ? error : `${error}`);
            }
        }
        _on_open(resolve, reject) {
            logging_1.logger.info(`Websocket connection ${this._number} is now open`);
            this._current_handler = (message) => {
                this._awaiting_ack_handler(message, resolve, reject);
            };
        }
        _on_message(event) {
            if (this._current_handler == null)
                logging_1.logger.error("Got a message with no current handler set");
            try {
                this._receiver.consume(event.data);
            }
            catch (e) {
                this._close_bad_protocol(`${e}`);
            }
            const msg = this._receiver.message;
            if (msg != null) {
                const problem = msg.problem();
                if (problem != null)
                    this._close_bad_protocol(problem);
                this._current_handler(msg);
            }
        }
        _on_close(event, reject) {
            logging_1.logger.info(`Lost websocket ${this._number} connection, ${event.code} (${event.reason})`);
            this.socket = null;
            this._pending_replies.forEach((pr) => pr.reject("Disconnected"));
            this._pending_replies.clear();
            if (!this.closed_permanently)
                this._schedule_reconnect(2000);
            reject(new Error(`Lost websocket connection, ${event.code} (${event.reason})`));
        }
        _on_error(reject) {
            logging_1.logger.debug(`Websocket error on socket ${this._number}`);
            const msg = "Could not open websocket";
            logging_1.logger.error(`Failed to connect to Bokeh server: ${msg}`);
            reject(new Error(msg));
        }
        _close_bad_protocol(detail) {
            logging_1.logger.error(`Closing connection: ${detail}`);
            if (this.socket != null)
                this.socket.close(1002, detail); // 1002 = protocol error
        }
        _awaiting_ack_handler(message, resolve, reject) {
            if (message.msgtype() === "ACK") {
                this._current_handler = (message) => this._steady_state_handler(message);
                // Reload any sessions
                this._repull_session_doc(resolve, reject);
            }
            else
                this._close_bad_protocol("First message was not an ACK");
        }
        _steady_state_handler(message) {
            const reqid = message.reqid();
            const pr = this._pending_replies.get(reqid);
            if (pr) {
                this._pending_replies.delete(reqid);
                pr.resolve(message);
            }
            else if (this.session) {
                this.session.handle(message);
            }
            else if (message.msgtype() != "PATCH-DOC") {
                // This branch can be executed only before we get the document.
                // When we get the document, all of the patches will already be incorporated.
                // In general, it's not possible to apply patches received before the document,
                // since they may change some models that were removed before serving the document.
                this._pending_messages.push(message);
            }
        }
    }
    exports.ClientConnection = ClientConnection;
    ClientConnection.__name__ = "ClientConnection";
    function pull_session(url, token, args_string) {
        const connection = new ClientConnection(url, token, args_string);
        return connection.connect();
    }
    exports.pull_session = pull_session;
},
/* protocol/message.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const serialization_1 = require(30) /* ../core/serialization */;
    const string_1 = require(38) /* ../core/util/string */;
    const assert_1 = require(12) /* ../core/util/assert */;
    class Message {
        constructor(header, metadata, content) {
            this.header = header;
            this.metadata = metadata;
            this.content = content;
            this._buffers = new Map();
        }
        get buffers() {
            return this._buffers;
        }
        static assemble(header_json, metadata_json, content_json) {
            const header = JSON.parse(header_json);
            const metadata = JSON.parse(metadata_json);
            const content = JSON.parse(content_json);
            return new Message(header, metadata, content);
        }
        assemble_buffer(buf_header, buf_payload) {
            var _a;
            const nb = (_a = this.header.num_buffers) !== null && _a !== void 0 ? _a : 0;
            if (nb <= this._buffers.size)
                throw new Error(`too many buffers received, expecting ${nb}`);
            const { id } = JSON.parse(buf_header);
            this._buffers.set(id, buf_payload);
        }
        static create(msgtype, metadata, content) {
            const header = Message.create_header(msgtype);
            return new Message(header, metadata, content);
        }
        static create_header(msgtype) {
            return {
                msgid: (0, string_1.unique_id)(),
                msgtype,
            };
        }
        complete() {
            const { num_buffers } = this.header;
            return num_buffers == null || this._buffers.size == num_buffers;
        }
        send(socket) {
            (0, assert_1.assert)(this.header.num_buffers == null);
            const buffers = [];
            const content_json = JSON.stringify(this.content, (_, val) => {
                if (val instanceof serialization_1.Buffer) {
                    const ref = { id: `${buffers.length}` };
                    buffers.push([ref, val.buffer]);
                    return ref;
                }
                else
                    return val;
            });
            const num_buffers = buffers.length;
            if (num_buffers > 0) {
                this.header.num_buffers = num_buffers;
            }
            const header_json = JSON.stringify(this.header);
            const metadata_json = JSON.stringify(this.metadata);
            socket.send(header_json);
            socket.send(metadata_json);
            socket.send(content_json);
            for (const [ref, buffer] of buffers) {
                socket.send(JSON.stringify(ref));
                socket.send(buffer);
            }
        }
        msgid() {
            return this.header.msgid;
        }
        msgtype() {
            return this.header.msgtype;
        }
        reqid() {
            return this.header.reqid;
        }
        // return the reason we should close on bad protocol, if there is one
        problem() {
            if (!("msgid" in this.header))
                return "No msgid in header";
            else if (!("msgtype" in this.header))
                return "No msgtype in header";
            else
                return null;
        }
    }
    exports.Message = Message;
    Message.__name__ = "Message";
},
/* protocol/receiver.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const message_1 = require(62) /* ./message */;
    const types_1 = require(8) /* ../core/util/types */;
    const assert_1 = require(12) /* ../core/util/assert */;
    class Receiver {
        constructor() {
            this.message = null;
            this._partial = null;
            this._fragments = [];
            this._buf_header = null;
            this._current_consumer = this._HEADER;
        }
        consume(fragment) {
            this._current_consumer(fragment);
        }
        _HEADER(fragment) {
            this._assume_text(fragment);
            this.message = null;
            this._partial = null;
            this._fragments = [fragment];
            this._buf_header = null;
            this._current_consumer = this._METADATA;
        }
        _METADATA(fragment) {
            this._assume_text(fragment);
            this._fragments.push(fragment);
            this._current_consumer = this._CONTENT;
        }
        _CONTENT(fragment) {
            this._assume_text(fragment);
            this._fragments.push(fragment);
            const [header_json, metadata_json, content_json] = this._fragments;
            (0, assert_1.assert)(header_json != null && metadata_json != null && content_json != null);
            this._partial = message_1.Message.assemble(header_json, metadata_json, content_json);
            this._check_complete();
        }
        _BUFFER_HEADER(fragment) {
            this._assume_text(fragment);
            this._buf_header = fragment;
            this._current_consumer = this._BUFFER_PAYLOAD;
        }
        _BUFFER_PAYLOAD(fragment) {
            this._assume_binary(fragment);
            (0, assert_1.assert)(this._partial != null && this._buf_header != null);
            this._partial.assemble_buffer(this._buf_header, fragment);
            this._check_complete();
        }
        _assume_text(fragment) {
            if (!(0, types_1.isString)(fragment))
                throw new Error("Expected text fragment but received binary fragment");
        }
        _assume_binary(fragment) {
            if (!(fragment instanceof ArrayBuffer))
                throw new Error("Expected binary fragment but received text fragment");
        }
        _check_complete() {
            if (this._partial.complete()) {
                this.message = this._partial;
                this._current_consumer = this._HEADER;
            }
            else
                this._current_consumer = this._BUFFER_HEADER;
        }
    }
    exports.Receiver = Receiver;
    Receiver.__name__ = "Receiver";
},
/* client/session.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const document_1 = require(5) /* ../document */;
    const message_1 = require(62) /* ../protocol/message */;
    const logging_1 = require(18) /* ../core/logging */;
    class ClientSession {
        constructor(_connection, document) {
            this._connection = _connection;
            this.document = document;
            this._document_listener = (event) => {
                this._document_changed(event);
            };
            this.document.on_change(this._document_listener, true);
        }
        // XXX: this is only needed in tests
        get id() {
            return this._connection.id;
        }
        handle(message) {
            const msgtype = message.msgtype();
            switch (msgtype) {
                case "PATCH-DOC": {
                    this._handle_patch(message);
                    break;
                }
                case "OK": {
                    this._handle_ok(message);
                    break;
                }
                case "ERROR": {
                    this._handle_error(message);
                    break;
                }
                default:
                    logging_1.logger.debug(`Doing nothing with message '${msgtype}'`);
            }
        }
        close() {
            this._connection.close();
        }
        /*protected*/ _connection_closed() {
            this.document.remove_on_change(this._document_listener);
        }
        // Sends a request to the server for info about the server, such as its Bokeh
        // version. Returns a promise, the value of the promise is a free-form dictionary
        // of server details.
        async request_server_info() {
            const message = message_1.Message.create("SERVER-INFO-REQ", {}, {});
            const reply = await this._connection.send_with_reply(message);
            return reply.content;
        }
        // Sends some request to the server (no guarantee about which one) and returns
        // a promise which is completed when the server replies. The purpose of this
        // is that if you wait for the promise to be completed, you know the server
        // has processed the request. This is useful when writing tests because once
        // the server has processed this request it should also have processed any
        // events or requests you sent previously, which means you can check for the
        // results of that processing without a race condition. (This assumes the
        // server processes events in sequence, which it mostly has to semantically,
        // since reordering events might change the final state.)
        async force_roundtrip() {
            await this.request_server_info();
        }
        _document_changed(event) {
            const events = event instanceof document_1.DocumentEventBatch ? event.events : [event];
            const patch = this.document.create_json_patch(events);
            // TODO (havocp) the connection may be closed here, which will
            // cause this send to throw an error - need to deal with it more cleanly.
            const message = message_1.Message.create("PATCH-DOC", {}, patch);
            this._connection.send(message);
        }
        _handle_patch(message) {
            this.document.apply_json_patch(message.content, message.buffers);
        }
        _handle_ok(message) {
            logging_1.logger.trace(`Unhandled OK reply to ${message.reqid()}`);
        }
        _handle_error(message) {
            logging_1.logger.error(`Unhandled ERROR reply to ${message.reqid()}: ${message.content.text}`);
        }
    }
    exports.ClientSession = ClientSession;
    ClientSession.__name__ = "ClientSession";
},
/* embed/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const dom_1 = require(56) /* ../core/dom */;
    const types_1 = require(8) /* ../core/util/types */;
    function _get_element(target) {
        let element = (0, types_1.isString)(target) ? document.getElementById(target) : target;
        if (element == null)
            throw new Error(`Error rendering Bokeh model: could not find ${(0, types_1.isString)(target) ? `#${target}` : target} HTML tag`);
        if (!(0, dom_1.contains)(document.body, element))
            throw new Error(`Error rendering Bokeh model: element ${(0, types_1.isString)(target) ? `#${target}` : target} must be under <body>`);
        // If autoload script, replace script tag with div for embedding.
        if (element instanceof HTMLElement && element.tagName == "SCRIPT") {
            const root_el = (0, dom_1.div)();
            (0, dom_1.replaceWith)(element, root_el);
            element = root_el;
        }
        return element;
    }
    function _resolve_element(item) {
        const { elementid } = item;
        if (elementid != null)
            return _get_element(elementid);
        else
            return document.body;
    }
    exports._resolve_element = _resolve_element;
    function _resolve_root_elements(item) {
        const roots = [];
        if (item.root_ids != null && item.roots != null) {
            for (const root_id of item.root_ids)
                roots.push(_get_element(item.roots[root_id]));
        }
        return roots;
    }
    exports._resolve_root_elements = _resolve_root_elements;
},
/* embed/notebook.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const document_1 = require(5) /* ../document */;
    const receiver_1 = require(63) /* ../protocol/receiver */;
    const logging_1 = require(18) /* ../core/logging */;
    const object_1 = require(9) /* ../core/util/object */;
    const standalone_1 = require(53) /* ./standalone */;
    const dom_1 = require(65) /* ./dom */;
    // This exists to allow the @bokeh/jupyter_bokeh extension to store the
    // notebook kernel so that _init_comms can register the comms target.
    // This has to be available at Bokeh.embed.kernels in JupyterLab.
    exports.kernels = {};
    function _handle_notebook_comms(receiver, comm_msg) {
        if (comm_msg.buffers.length > 0)
            receiver.consume(comm_msg.buffers[0].buffer);
        else
            receiver.consume(comm_msg.content.data);
        const msg = receiver.message;
        if (msg != null)
            this.apply_json_patch(msg.content, msg.buffers);
    }
    function _init_comms(target, doc) {
        if (typeof Jupyter !== "undefined" && Jupyter.notebook.kernel != null) {
            logging_1.logger.info(`Registering Jupyter comms for target ${target}`);
            const comm_manager = Jupyter.notebook.kernel.comm_manager;
            try {
                comm_manager.register_target(target, (comm) => {
                    logging_1.logger.info(`Registering Jupyter comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    comm.on_msg(_handle_notebook_comms.bind(doc, r));
                });
            }
            catch (e) {
                logging_1.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else if (doc.roots()[0].id in exports.kernels) {
            logging_1.logger.info(`Registering JupyterLab comms for target ${target}`);
            const kernel = exports.kernels[doc.roots()[0].id];
            try {
                kernel.registerCommTarget(target, (comm) => {
                    logging_1.logger.info(`Registering JupyterLab comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    comm.onMsg = _handle_notebook_comms.bind(doc, r);
                });
            }
            catch (e) {
                logging_1.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else if (typeof google != "undefined" && google.colab.kernel != null) {
            logging_1.logger.info(`Registering Google Colab comms for target ${target}`);
            const comm_manager = google.colab.kernel.comms;
            try {
                comm_manager.registerTarget(target, async (comm) => {
                    var e_1, _a;
                    var _b;
                    logging_1.logger.info(`Registering Google Colab comms for target ${target}`);
                    const r = new receiver_1.Receiver();
                    try {
                        for (var _c = tslib_1.__asyncValues(comm.messages), _d; _d = await _c.next(), !_d.done;) {
                            const message = _d.value;
                            const content = { data: message.data };
                            const buffers = [];
                            for (const buffer of (_b = message.buffers) !== null && _b !== void 0 ? _b : []) {
                                buffers.push(new DataView(buffer));
                            }
                            const msg = { content, buffers };
                            _handle_notebook_comms.bind(doc)(r, msg);
                        }
                    }
                    catch (e_1_1) {
                        e_1 = { error: e_1_1 };
                    }
                    finally {
                        try {
                            if (_d && !_d.done && (_a = _c.return))
                                await _a.call(_c);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                    }
                });
            }
            catch (e) {
                logging_1.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`);
            }
        }
        else {
            console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.");
        }
    }
    function embed_items_notebook(docs_json, render_items) {
        if ((0, object_1.size)(docs_json) != 1)
            throw new Error("embed_items_notebook expects exactly one document in docs_json");
        const document = document_1.Document.from_json((0, object_1.values)(docs_json)[0]);
        for (const item of render_items) {
            if (item.notebook_comms_target != null)
                _init_comms(item.notebook_comms_target, document);
            const element = (0, dom_1._resolve_element)(item);
            const roots = (0, dom_1._resolve_root_elements)(item);
            (0, standalone_1.add_document_standalone)(document, element, roots);
            for (const root of roots) {
                if (root instanceof HTMLElement) {
                    root.removeAttribute("id");
                }
            }
        }
    }
    exports.embed_items_notebook = embed_items_notebook;
},
/* protocol/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(62) /* ./message */, exports);
    tslib_1.__exportStar(require(63) /* ./receiver */, exports);
},
/* testing.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Just a dumb key/value record for collecting arbitrary info for tests
    exports.results = {};
    // Selenium has race conditions that make it difficult to read out the
    // results structure. This function deletes/creates a div that can act as
    // a semaphore. Tests should wait for the previous div to be stale, then
    // find the new div. At that point the results should be available
    function update_test_div() {
        const body = document.getElementsByTagName("body")[0];
        const col = document.getElementsByClassName("bokeh-test-div");
        if (col.length == 1) {
            body.removeChild(col[0]);
            delete col[0];
        }
        const box = document.createElement("div");
        box.classList.add("bokeh-test-div");
        box.style.display = "none";
        body.insertBefore(box, body.firstChild);
    }
    function init() {
        update_test_div();
    }
    exports.init = init;
    function record0(key, value) {
        exports.results[key] = value;
    }
    exports.record0 = record0;
    function record(key, value) {
        exports.results[key] = value;
        update_test_div();
    }
    exports.record = record;
    function count(key) {
        if (exports.results[key] == undefined)
            exports.results[key] = 0;
        exports.results[key] += 1;
        update_test_div();
    }
    exports.count = count;
},
/* safely.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // Keep this code as terse and as close to vanila JS as possible. If we
    // arrived here, it means we should trust no one and need to act properly.
    function _burst_into_flames(error) {
        // Make box
        const box = document.createElement("div");
        box.style.backgroundColor = "#f2dede";
        box.style.border = "1px solid #a94442";
        box.style.borderRadius = "4px";
        box.style.display = "inline-block";
        box.style.fontFamily = "sans-serif";
        box.style.marginTop = "5px";
        box.style.minWidth = "200px";
        box.style.padding = "5px 5px 5px 10px";
        box.classList.add("bokeh-error-box-into-flames");
        // Make button
        const button = document.createElement("span");
        button.style.backgroundColor = "#a94442";
        button.style.borderRadius = "0px 4px 0px 0px";
        button.style.color = "white";
        button.style.cursor = "pointer";
        button.style.cssFloat = "right";
        button.style.fontSize = "0.8em";
        button.style.margin = "-6px -6px 0px 0px";
        button.style.padding = "2px 5px 4px 5px";
        button.title = "close";
        button.setAttribute("aria-label", "close");
        button.appendChild(document.createTextNode("x"));
        button.addEventListener("click", () => body.removeChild(box));
        // Make title
        const title = document.createElement("h3");
        title.style.color = "#a94442";
        title.style.margin = "8px 0px 0px 0px";
        title.style.padding = "0px";
        title.appendChild(document.createTextNode("Bokeh Error"));
        // Make message
        const message = document.createElement("pre");
        message.style.whiteSpace = "unset";
        message.style.overflowX = "auto";
        message.appendChild(document.createTextNode(error));
        // Add pieces to box
        box.appendChild(button);
        box.appendChild(title);
        box.appendChild(message);
        // Put box in doc
        const body = document.getElementsByTagName("body")[0];
        body.insertBefore(box, body.firstChild);
    }
    function safely(fn, silent = false) {
        try {
            return fn();
        }
        catch (error) {
            const text = error instanceof Error && error.stack != null ? error.stack : `${error}`;
            _burst_into_flames(text);
            if (!silent)
                throw error;
            else
                return;
        }
    }
    exports.safely = safely;
},
/* models/main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const base_1 = require(7) /* ../base */;
    const AllModels = tslib_1.__importStar(require(71) /* ./ */);
    (0, base_1.register_models)(AllModels);
    const DOMModels = tslib_1.__importStar(require(487) /* ./dom */);
    (0, base_1.register_models)(DOMModels);
},
/* models/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(72) /* ./annotations */, exports);
    tslib_1.__exportStar(require(158) /* ./axes */, exports);
    tslib_1.__exportStar(require(279) /* ./callbacks */, exports);
    tslib_1.__exportStar(require(284) /* ./canvas */, exports);
    tslib_1.__exportStar(require(290) /* ./coordinates */, exports);
    tslib_1.__exportStar(require(291) /* ./expressions */, exports);
    tslib_1.__exportStar(require(300) /* ./filters */, exports);
    tslib_1.__exportStar(require(219) /* ./formatters */, exports);
    tslib_1.__exportStar(require(309) /* ./glyphs */, exports);
    tslib_1.__exportStar(require(342) /* ./graphics */, exports);
    tslib_1.__exportStar(require(343) /* ./graphs */, exports);
    tslib_1.__exportStar(require(347) /* ./grids */, exports);
    tslib_1.__exportStar(require(349) /* ./layouts */, exports);
    tslib_1.__exportStar(require(234) /* ./mappers */, exports);
    tslib_1.__exportStar(require(368) /* ./menus */, exports);
    tslib_1.__exportStar(require(374) /* ./text */, exports);
    tslib_1.__exportStar(require(375) /* ./transforms */, exports);
    tslib_1.__exportStar(require(384) /* ./plots */, exports);
    tslib_1.__exportStar(require(396) /* ./policies */, exports);
    tslib_1.__exportStar(require(397) /* ./random */, exports);
    tslib_1.__exportStar(require(225) /* ./ranges */, exports);
    tslib_1.__exportStar(require(399) /* ./renderers */, exports);
    tslib_1.__exportStar(require(223) /* ./scales */, exports);
    tslib_1.__exportStar(require(402) /* ./selections */, exports);
    tslib_1.__exportStar(require(403) /* ./selectors */, exports);
    tslib_1.__exportStar(require(409) /* ./sources */, exports);
    tslib_1.__exportStar(require(192) /* ./tickers */, exports);
    tslib_1.__exportStar(require(414) /* ./tiles */, exports);
    tslib_1.__exportStar(require(424) /* ./textures */, exports);
    tslib_1.__exportStar(require(428) /* ./ui */, exports);
    tslib_1.__exportStar(require(443) /* ./tools */, exports);
},
/* models/annotations/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var annotation_1 = require(73) /* ./annotation */;
    __esExport("Annotation", annotation_1.Annotation);
    var arrow_1 = require(97) /* ./arrow */;
    __esExport("Arrow", arrow_1.Arrow);
    var arrow_head_1 = require(139) /* ./arrow_head */;
    __esExport("ArrowHead", arrow_head_1.ArrowHead);
    var arrow_head_2 = require(139) /* ./arrow_head */;
    __esExport("OpenHead", arrow_head_2.OpenHead);
    var arrow_head_3 = require(139) /* ./arrow_head */;
    __esExport("NormalHead", arrow_head_3.NormalHead);
    var arrow_head_4 = require(139) /* ./arrow_head */;
    __esExport("TeeHead", arrow_head_4.TeeHead);
    var arrow_head_5 = require(139) /* ./arrow_head */;
    __esExport("VeeHead", arrow_head_5.VeeHead);
    var base_color_bar_1 = require(141) /* ./base_color_bar */;
    __esExport("BaseColorBar", base_color_bar_1.BaseColorBar);
    var band_1 = require(230) /* ./band */;
    __esExport("Band", band_1.Band);
    var box_annotation_1 = require(232) /* ./box_annotation */;
    __esExport("BoxAnnotation", box_annotation_1.BoxAnnotation);
    var color_bar_1 = require(233) /* ./color_bar */;
    __esExport("ColorBar", color_bar_1.ColorBar);
    var contour_color_bar_1 = require(242) /* ./contour_color_bar */;
    __esExport("ContourColorBar", contour_color_bar_1.ContourColorBar);
    var label_1 = require(243) /* ./label */;
    __esExport("Label", label_1.Label);
    var label_set_1 = require(244) /* ./label_set */;
    __esExport("LabelSet", label_set_1.LabelSet);
    var legend_1 = require(245) /* ./legend */;
    __esExport("Legend", legend_1.Legend);
    var legend_item_1 = require(246) /* ./legend_item */;
    __esExport("LegendItem", legend_item_1.LegendItem);
    var poly_annotation_1 = require(247) /* ./poly_annotation */;
    __esExport("PolyAnnotation", poly_annotation_1.PolyAnnotation);
    var slope_1 = require(248) /* ./slope */;
    __esExport("Slope", slope_1.Slope);
    var span_1 = require(249) /* ./span */;
    __esExport("Span", span_1.Span);
    var text_annotation_1 = require(143) /* ./text_annotation */;
    __esExport("TextAnnotation", text_annotation_1.TextAnnotation);
    var title_1 = require(142) /* ./title */;
    __esExport("Title", title_1.Title);
    var toolbar_panel_1 = require(250) /* ./toolbar_panel */;
    __esExport("ToolbarPanel", toolbar_panel_1.ToolbarPanel);
    var whisker_1 = require(273) /* ./whisker */;
    __esExport("Whisker", whisker_1.Whisker);
    tslib_1.__exportStar(require(274) /* ./html */, exports);
},
/* models/annotations/annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const renderer_1 = require(74) /* ../renderers/renderer */;
    class AnnotationView extends renderer_1.RendererView {
        get_size() {
            if (this.displayed) {
                const { width, height } = this._get_size();
                return { width: Math.round(width), height: Math.round(height) };
            }
            else
                return { width: 0, height: 0 };
        }
        _get_size() {
            throw new Error("not implemented");
        }
        connect_signals() {
            super.connect_signals();
            const p = this.model.properties;
            this.on_change(p.visible, () => {
                if (this.layout != null) {
                    this.layout.visible = this.model.visible;
                    this.plot_view.request_layout();
                }
            });
        }
        get needs_clip() {
            return this.layout == null; // TODO: change this, when center layout is fully implemented
        }
        serializable_state() {
            const state = super.serializable_state();
            return this.layout == null ? state : Object.assign(Object.assign({}, state), { bbox: this.layout.bbox.box });
        }
    }
    exports.AnnotationView = AnnotationView;
    AnnotationView.__name__ = "AnnotationView";
    class Annotation extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Annotation = Annotation;
    _a = Annotation;
    Annotation.__name__ = "Annotation";
    (() => {
        _a.override({
            level: "annotation",
        });
    })();
},
/* models/renderers/renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a, _b;
    const view_1 = require(54) /* ../../core/view */;
    const visuals = tslib_1.__importStar(require(75) /* ../../core/visuals */);
    const enums_1 = require(19) /* ../../core/enums */;
    const model_1 = require(51) /* ../../model */;
    const coordinate_mapping_1 = require(84) /* ../coordinates/coordinate_mapping */;
    class RendererGroup extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.RendererGroup = RendererGroup;
    _a = RendererGroup;
    RendererGroup.__name__ = "RendererGroup";
    (() => {
        _a.define(({ Boolean }) => ({
            visible: [Boolean, true],
        }));
    })();
    class RendererView extends view_1.View {
        get coordinates() {
            const { _coordinates } = this;
            if (_coordinates != null)
                return _coordinates;
            else
                return this._coordinates = this._initialize_coordinates();
        }
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
            this.needs_webgl_blit = false;
        }
        connect_signals() {
            super.connect_signals();
            const { group } = this.model;
            if (group != null) {
                this.on_change(group.properties.visible, () => {
                    this.model.visible = group.visible;
                });
            }
            const { x_range_name, y_range_name } = this.model.properties;
            this.on_change([x_range_name, y_range_name], () => delete this._coordinates);
            this.connect(this.plot_view.frame.change, () => delete this._coordinates);
        }
        _initialize_coordinates() {
            const { coordinates } = this.model;
            const { frame } = this.plot_view;
            if (coordinates != null) {
                return coordinates.get_transform(frame);
            }
            else {
                const { x_range_name, y_range_name } = this.model;
                const x_scale = frame.x_scales.get(x_range_name);
                const y_scale = frame.y_scales.get(y_range_name);
                return new coordinate_mapping_1.CoordinateTransform(x_scale, y_scale);
            }
        }
        get plot_view() {
            return this.parent;
        }
        get plot_model() {
            return this.parent.model;
        }
        get layer() {
            const { overlays, primary } = this.canvas;
            return this.model.level == "overlay" ? overlays : primary;
        }
        get canvas() {
            return this.plot_view.canvas_view;
        }
        request_render() {
            this.request_paint();
        }
        request_paint() {
            this.plot_view.request_paint(this);
        }
        request_layout() {
            this.plot_view.request_layout();
        }
        notify_finished() {
            this.plot_view.notify_finished();
        }
        notify_finished_after_paint() {
            this.plot_view.notify_finished_after_paint();
        }
        get needs_clip() {
            return false;
        }
        get has_webgl() {
            return false;
        }
        /*
        get visible(): boolean {
          const {visible, group} = this.model
          return !visible ? false : (group?.visible ?? true)
        }
        */
        get displayed() {
            return this.model.visible;
        }
        render() {
            if (this.displayed) {
                this._render();
            }
            this._has_finished = true;
        }
        renderer_view(_renderer) {
            return undefined;
        }
    }
    exports.RendererView = RendererView;
    RendererView.__name__ = "RendererView";
    class Renderer extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Renderer = Renderer;
    _b = Renderer;
    Renderer.__name__ = "Renderer";
    (() => {
        _b.define(({ Boolean, String, Ref, Nullable }) => ({
            group: [Nullable(Ref(RendererGroup)), null],
            level: [enums_1.RenderLevel, "image"],
            visible: [Boolean, true],
            x_range_name: [String, "default"],
            y_range_name: [String, "default"],
            coordinates: [Nullable(Ref(coordinate_mapping_1.CoordinateMapping)), null],
        }));
    })();
},
/* core/visuals/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const line_1 = require(76) /* ./line */;
    __esExport("Line", line_1.Line);
    __esExport("LineScalar", line_1.LineScalar);
    __esExport("LineVector", line_1.LineVector);
    const fill_1 = require(79) /* ./fill */;
    __esExport("Fill", fill_1.Fill);
    __esExport("FillScalar", fill_1.FillScalar);
    __esExport("FillVector", fill_1.FillVector);
    const text_1 = require(80) /* ./text */;
    __esExport("Text", text_1.Text);
    __esExport("TextScalar", text_1.TextScalar);
    __esExport("TextVector", text_1.TextVector);
    const hatch_1 = require(81) /* ./hatch */;
    __esExport("Hatch", hatch_1.Hatch);
    __esExport("HatchScalar", hatch_1.HatchScalar);
    __esExport("HatchVector", hatch_1.HatchVector);
    const image_1 = require(83) /* ./image */;
    __esExport("Image", image_1.Image);
    __esExport("ImageScalar", image_1.ImageScalar);
    __esExport("ImageVector", image_1.ImageVector);
    const mixins = tslib_1.__importStar(require(78) /* ../property_mixins */);
    const visual_1 = require(77) /* ./visual */;
    __esExport("VisualProperties", visual_1.VisualProperties);
    __esExport("VisualUniforms", visual_1.VisualUniforms);
    class Visuals {
        constructor(view) {
            this._visuals = [];
            for (const [prefix, mixin] of view.model._mixins) {
                const visual = (() => {
                    switch (mixin) {
                        case mixins.Line: return new line_1.Line(view, prefix);
                        case mixins.LineScalar: return new line_1.LineScalar(view, prefix);
                        case mixins.LineVector: return new line_1.LineVector(view, prefix);
                        case mixins.Fill: return new fill_1.Fill(view, prefix);
                        case mixins.FillScalar: return new fill_1.FillScalar(view, prefix);
                        case mixins.FillVector: return new fill_1.FillVector(view, prefix);
                        case mixins.Text: return new text_1.Text(view, prefix);
                        case mixins.TextScalar: return new text_1.TextScalar(view, prefix);
                        case mixins.TextVector: return new text_1.TextVector(view, prefix);
                        case mixins.Hatch: return new hatch_1.Hatch(view, prefix);
                        case mixins.HatchScalar: return new hatch_1.HatchScalar(view, prefix);
                        case mixins.HatchVector: return new hatch_1.HatchVector(view, prefix);
                        case mixins.Image: return new image_1.Image(view, prefix);
                        case mixins.ImageScalar: return new image_1.ImageScalar(view, prefix);
                        case mixins.ImageVector: return new image_1.ImageVector(view, prefix);
                        default:
                            throw new Error("unknown visual");
                    }
                })();
                if (visual instanceof visual_1.VisualProperties)
                    visual.update();
                this._visuals.push(visual);
                Object.defineProperty(this, prefix + visual.type, {
                    get() { return visual; },
                    configurable: false,
                    enumerable: true,
                });
            }
        }
        *[Symbol.iterator]() {
            yield* this._visuals;
        }
    }
    exports.Visuals = Visuals;
    Visuals.__name__ = "Visuals";
},
/* core/visuals/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(77) /* ./visual */;
    const mixins = tslib_1.__importStar(require(78) /* ../property_mixins */);
    const color_1 = require(21) /* ../util/color */;
    const types_1 = require(8) /* ../util/types */;
    function resolve_line_dash(line_dash) {
        if ((0, types_1.isArray)(line_dash))
            return line_dash;
        else {
            switch (line_dash) {
                case "solid": return [];
                case "dashed": return [6];
                case "dotted": return [2, 4];
                case "dotdash": return [2, 4, 6, 4];
                case "dashdot": return [6, 4, 2, 4];
                default:
                    return line_dash.split(" ").map(Number).filter(types_1.isInteger);
            }
        }
    }
    exports.resolve_line_dash = resolve_line_dash;
    class Line extends visual_1.VisualProperties {
        get doit() {
            const color = this.line_color.get_value();
            const alpha = this.line_alpha.get_value();
            const width = this.line_width.get_value();
            return !(color == null || alpha == 0 || width == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.stroke();
            }
            return doit;
        }
        values() {
            return {
                color: this.line_color.get_value(),
                alpha: this.line_alpha.get_value(),
                width: this.line_width.get_value(),
                join: this.line_join.get_value(),
                cap: this.line_cap.get_value(),
                dash: this.line_dash.get_value(),
                offset: this.line_dash_offset.get_value(),
            };
        }
        set_value(ctx) {
            const color = this.line_color.get_value();
            const alpha = this.line_alpha.get_value();
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = this.line_width.get_value();
            ctx.lineJoin = this.line_join.get_value();
            ctx.lineCap = this.line_cap.get_value();
            ctx.lineDash = resolve_line_dash(this.line_dash.get_value());
            ctx.lineDashOffset = this.line_dash_offset.get_value();
        }
    }
    exports.Line = Line;
    Line.__name__ = "Line";
    class LineScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.line_color.value;
            const alpha = this.line_alpha.value;
            const width = this.line_width.value;
            return !(color == 0 || alpha == 0 || width == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.stroke();
            }
            return doit;
        }
        values() {
            return {
                color: this.line_color.value,
                alpha: this.line_alpha.value,
                width: this.line_width.value,
                join: this.line_join.value,
                cap: this.line_cap.value,
                dash: this.line_dash.value,
                offset: this.line_dash_offset.value,
            };
        }
        set_value(ctx) {
            const color = this.line_color.value;
            const alpha = this.line_alpha.value;
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = this.line_width.value;
            ctx.lineJoin = this.line_join.value;
            ctx.lineCap = this.line_cap.value;
            ctx.lineDash = resolve_line_dash(this.line_dash.value);
            ctx.lineDashOffset = this.line_dash_offset.value;
        }
    }
    exports.LineScalar = LineScalar;
    LineScalar.__name__ = "LineScalar";
    class LineVector extends visual_1.VisualUniforms {
        get doit() {
            const { line_color } = this;
            if (line_color.is_Scalar() && line_color.value == 0)
                return false;
            const { line_alpha } = this;
            if (line_alpha.is_Scalar() && line_alpha.value == 0)
                return false;
            const { line_width } = this;
            if (line_width.is_Scalar() && line_width.value == 0)
                return false;
            return true;
        }
        v_doit(i) {
            if (this.line_color.get(i) == 0)
                return false;
            if (this.line_alpha.get(i) == 0)
                return false;
            if (this.line_width.get(i) == 0)
                return false;
            return true;
        }
        apply(ctx, i) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.stroke();
            }
            return doit;
        }
        values(i) {
            return {
                color: this.line_color.get(i),
                alpha: this.line_alpha.get(i),
                width: this.line_width.get(i),
                join: this.line_join.get(i),
                cap: this.line_cap.get(i),
                dash: this.line_dash.get(i),
                offset: this.line_dash_offset.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const color = this.line_color.get(i);
            const alpha = this.line_alpha.get(i);
            const width = this.line_width.get(i);
            const join = this.line_join.get(i);
            const cap = this.line_cap.get(i);
            const dash = this.line_dash.get(i);
            const offset = this.line_dash_offset.get(i);
            ctx.strokeStyle = (0, color_1.color2css)(color, alpha);
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.lineDash = resolve_line_dash(dash);
            ctx.lineDashOffset = offset;
        }
    }
    exports.LineVector = LineVector;
    LineVector.__name__ = "LineVector";
    Line.prototype.type = "line";
    Line.prototype.attrs = Object.keys(mixins.Line);
    LineScalar.prototype.type = "line";
    LineScalar.prototype.attrs = Object.keys(mixins.LineScalar);
    LineVector.prototype.type = "line";
    LineVector.prototype.attrs = Object.keys(mixins.LineVector);
},
/* core/visuals/visual.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class VisualProperties {
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            const self = this;
            this._props = [];
            for (const attr of this.attrs) {
                const prop = obj.model.properties[prefix + attr];
                prop.change.connect(() => this.update());
                self[attr] = prop;
                this._props.push(prop);
            }
        }
        *[Symbol.iterator]() {
            yield* this._props;
        }
        update() { }
    }
    exports.VisualProperties = VisualProperties;
    VisualProperties.__name__ = "VisualProperties";
    class VisualUniforms {
        constructor(obj, prefix = "") {
            this.obj = obj;
            this.prefix = prefix;
            for (const attr of this.attrs) {
                Object.defineProperty(this, attr, {
                    get() {
                        return obj[prefix + attr];
                    },
                });
            }
        }
        *[Symbol.iterator]() {
            for (const attr of this.attrs) {
                yield this.obj.model.properties[this.prefix + attr];
            }
        }
        update() { }
    }
    exports.VisualUniforms = VisualUniforms;
    VisualUniforms.__name__ = "VisualUniforms";
},
/* core/property_mixins.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const p = tslib_1.__importStar(require(17) /* ./properties */);
    const enums_1 = require(19) /* ./enums */;
    const k = tslib_1.__importStar(require(20) /* ./kinds */);
    const object_1 = require(9) /* ./util/object */;
    exports.Line = {
        line_color: [k.Nullable(k.Color), "black"],
        line_alpha: [k.Alpha, 1.0],
        line_width: [k.Number, 1],
        line_join: [enums_1.LineJoin, "bevel"],
        line_cap: [enums_1.LineCap, "butt"],
        line_dash: [k.Or(enums_1.LineDash, k.Array(k.Number)), []],
        line_dash_offset: [k.Number, 0],
    };
    exports.Fill = {
        fill_color: [k.Nullable(k.Color), "gray"],
        fill_alpha: [k.Alpha, 1.0],
    };
    exports.Image = {
        global_alpha: [k.Alpha, 1.0],
    };
    exports.Hatch = {
        hatch_color: [k.Nullable(k.Color), "black"],
        hatch_alpha: [k.Alpha, 1.0],
        hatch_scale: [k.Number, 12.0],
        hatch_pattern: [k.Nullable(k.Or(enums_1.HatchPatternType, k.String)), null],
        hatch_weight: [k.Number, 1.0],
        hatch_extra: [k.Dict(k.AnyRef()), {}], // XXX: recursive imports
    };
    exports.Text = {
        text_color: [k.Nullable(k.Color), "#444444"],
        text_outline_color: [k.Nullable(k.Color), null],
        text_alpha: [k.Alpha, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [k.FontSize, "16px"],
        text_font_style: [enums_1.FontStyle, "normal"],
        text_align: [enums_1.TextAlign, "left"],
        text_baseline: [enums_1.TextBaseline, "bottom"],
        text_line_height: [k.Number, 1.2],
    };
    exports.LineScalar = {
        line_color: [p.ColorScalar, "black"],
        line_alpha: [p.NumberScalar, 1.0],
        line_width: [p.NumberScalar, 1],
        line_join: [p.LineJoinScalar, "bevel"],
        line_cap: [p.LineCapScalar, "butt"],
        line_dash: [p.LineDashScalar, []],
        line_dash_offset: [p.NumberScalar, 0],
    };
    exports.FillScalar = {
        fill_color: [p.ColorScalar, "gray"],
        fill_alpha: [p.NumberScalar, 1.0],
    };
    exports.ImageScalar = {
        global_alpha: [p.NumberScalar, 1.0],
    };
    exports.HatchScalar = {
        hatch_color: [p.ColorScalar, "black"],
        hatch_alpha: [p.NumberScalar, 1.0],
        hatch_scale: [p.NumberScalar, 12.0],
        hatch_pattern: [p.NullStringScalar, null],
        hatch_weight: [p.NumberScalar, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextScalar = {
        text_color: [p.ColorScalar, "#444444"],
        text_outline_color: [p.ColorScalar, null],
        text_alpha: [p.NumberScalar, 1.0],
        text_font: [p.FontScalar, "helvetica"],
        text_font_size: [p.FontSizeScalar, "16px"],
        text_font_style: [p.FontStyleScalar, "normal"],
        text_align: [p.TextAlignScalar, "left"],
        text_baseline: [p.TextBaselineScalar, "bottom"],
        text_line_height: [p.NumberScalar, 1.2],
    };
    exports.LineVector = {
        line_color: [p.ColorSpec, "black"],
        line_alpha: [p.NumberSpec, 1.0],
        line_width: [p.NumberSpec, 1],
        line_join: [p.LineJoinSpec, "bevel"],
        line_cap: [p.LineCapSpec, "butt"],
        line_dash: [p.LineDashSpec, []],
        line_dash_offset: [p.NumberSpec, 0],
    };
    exports.FillVector = {
        fill_color: [p.ColorSpec, "gray"],
        fill_alpha: [p.NumberSpec, 1.0],
    };
    exports.ImageVector = {
        global_alpha: [p.NumberSpec, 1.0],
    };
    exports.HatchVector = {
        hatch_color: [p.ColorSpec, "black"],
        hatch_alpha: [p.NumberSpec, 1.0],
        hatch_scale: [p.NumberSpec, 12.0],
        hatch_pattern: [p.NullStringSpec, null],
        hatch_weight: [p.NumberSpec, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextVector = {
        text_color: [p.ColorSpec, "#444444"],
        text_outline_color: [p.ColorSpec, null],
        text_alpha: [p.NumberSpec, 1.0],
        text_font: [p.FontSpec, "helvetica"],
        text_font_size: [p.FontSizeSpec, "16px"],
        text_font_style: [p.FontStyleSpec, "normal"],
        text_align: [p.TextAlignSpec, "left"],
        text_baseline: [p.TextBaselineSpec, "bottom"],
        text_line_height: [p.NumberSpec, 1.2],
    };
    function attrs_of(model, prefix, mixin, prefixed = false) {
        const attrs = {};
        for (const attr of (0, object_1.keys)(mixin)) {
            const prefixed_attr = `${prefix}${attr}`;
            const value = model[prefixed_attr];
            attrs[prefixed ? prefixed_attr : attr] = value;
        }
        return attrs;
    }
    exports.attrs_of = attrs_of;
},
/* core/visuals/fill.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(77) /* ./visual */;
    const mixins = tslib_1.__importStar(require(78) /* ../property_mixins */);
    const color_1 = require(21) /* ../util/color */;
    class Fill extends visual_1.VisualProperties {
        get doit() {
            const color = this.fill_color.get_value();
            const alpha = this.fill_alpha.get_value();
            return !(color == null || alpha == 0);
        }
        apply(ctx, rule) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.fill(rule);
            }
            return doit;
        }
        values() {
            return {
                color: this.fill_color.get_value(),
                alpha: this.fill_alpha.get_value(),
            };
        }
        set_value(ctx) {
            const color = this.fill_color.get_value();
            const alpha = this.fill_alpha.get_value();
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.Fill = Fill;
    Fill.__name__ = "Fill";
    class FillScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.fill_color.value;
            const alpha = this.fill_alpha.value;
            return !(color == 0 || alpha == 0);
        }
        apply(ctx, rule) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.fill(rule);
            }
            return doit;
        }
        values() {
            return {
                color: this.fill_color.value,
                alpha: this.fill_alpha.value,
            };
        }
        set_value(ctx) {
            const color = this.fill_color.value;
            const alpha = this.fill_alpha.value;
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.FillScalar = FillScalar;
    FillScalar.__name__ = "FillScalar";
    class FillVector extends visual_1.VisualUniforms {
        get doit() {
            const { fill_color } = this;
            if (fill_color.is_Scalar() && fill_color.value == 0)
                return false;
            const { fill_alpha } = this;
            if (fill_alpha.is_Scalar() && fill_alpha.value == 0)
                return false;
            return true;
        }
        v_doit(i) {
            if (this.fill_color.get(i) == 0)
                return false;
            if (this.fill_alpha.get(i) == 0)
                return false;
            return true;
        }
        apply(ctx, i, rule) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.fill(rule);
            }
            return doit;
        }
        values(i) {
            return {
                color: this.fill_color.get(i),
                alpha: this.fill_alpha.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const color = this.fill_color.get(i);
            const alpha = this.fill_alpha.get(i);
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
        }
    }
    exports.FillVector = FillVector;
    FillVector.__name__ = "FillVector";
    Fill.prototype.type = "fill";
    Fill.prototype.attrs = Object.keys(mixins.Fill);
    FillScalar.prototype.type = "fill";
    FillScalar.prototype.attrs = Object.keys(mixins.FillScalar);
    FillVector.prototype.type = "fill";
    FillVector.prototype.attrs = Object.keys(mixins.FillVector);
},
/* core/visuals/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(77) /* ./visual */;
    const mixins = tslib_1.__importStar(require(78) /* ../property_mixins */);
    const color_1 = require(21) /* ../util/color */;
    const _font_cache = new Map();
    function load_font(font, obj) {
        const objs = _font_cache.get(font);
        if (objs == null) {
            const objs = new WeakSet([obj]);
            _font_cache.set(font, objs);
        }
        else if (!objs.has(obj)) {
            objs.add(obj);
        }
        else {
            return;
        }
        const { fonts } = document;
        if (!fonts.check(font)) {
            fonts.load(font).then(() => obj.request_render());
        }
    }
    class Text extends visual_1.VisualProperties {
        get doit() {
            const color = this.text_color.get_value();
            const alpha = this.text_alpha.get_value();
            return !(color == null || alpha == 0);
        }
        update() {
            if (!this.doit)
                return;
            const font = this.font_value();
            load_font(font, this.obj);
        }
        values() {
            return {
                color: this.text_color.get_value(),
                outline_color: this.text_outline_color.get_value(),
                alpha: this.text_alpha.get_value(),
                font: this.text_font.get_value(),
                font_size: this.text_font_size.get_value(),
                font_style: this.text_font_style.get_value(),
                align: this.text_align.get_value(),
                baseline: this.text_baseline.get_value(),
                line_height: this.text_line_height.get_value(),
            };
        }
        set_value(ctx) {
            const color = this.text_color.get_value();
            const outline_color = this.text_outline_color.get_value();
            const alpha = this.text_alpha.get_value();
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.strokeStyle = (0, color_1.color2css)(outline_color, alpha);
            ctx.font = this.font_value();
            ctx.textAlign = this.text_align.get_value();
            ctx.textBaseline = this.text_baseline.get_value();
        }
        font_value() {
            const style = this.text_font_style.get_value();
            const size = this.text_font_size.get_value();
            const face = this.text_font.get_value();
            return `${style} ${size} ${face}`;
        }
    }
    exports.Text = Text;
    Text.__name__ = "Text";
    class TextScalar extends visual_1.VisualUniforms {
        get doit() {
            const color = this.text_color.value;
            const alpha = this.text_alpha.value;
            return !(color == 0 || alpha == 0);
        }
        update() {
            if (!this.doit)
                return;
            const font = this.font_value();
            load_font(font, this.obj);
        }
        values() {
            return {
                color: this.text_color.value,
                outline_color: this.text_outline_color.value,
                alpha: this.text_alpha.value,
                font: this.text_font.value,
                font_size: this.text_font_size.value,
                font_style: this.text_font_style.value,
                align: this.text_align.value,
                baseline: this.text_baseline.value,
                line_height: this.text_line_height.value,
            };
        }
        set_value(ctx) {
            const color = this.text_color.value;
            const alpha = this.text_alpha.value;
            const outline_color = this.text_outline_color.value;
            const font = this.font_value();
            const align = this.text_align.value;
            const baseline = this.text_baseline.value;
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.strokeStyle = (0, color_1.color2css)(outline_color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
        font_value() {
            const style = this.text_font_style.value;
            const size = this.text_font_size.value;
            const face = this.text_font.value;
            return `${style} ${size} ${face}`;
        }
    }
    exports.TextScalar = TextScalar;
    TextScalar.__name__ = "TextScalar";
    class TextVector extends visual_1.VisualUniforms {
        _assert_font(i) {
            const font = this.font_value(i);
            load_font(font, this.obj);
        }
        values(i) {
            this._assert_font(i);
            return {
                color: this.text_color.get(i),
                outline_color: this.text_outline_color.get(i),
                alpha: this.text_alpha.get(i),
                font: this.text_font.get(i),
                font_size: this.text_font_size.get(i),
                font_style: this.text_font_style.get(i),
                align: this.text_align.get(i),
                baseline: this.text_baseline.get(i),
                line_height: this.text_line_height.get(i),
            };
        }
        get doit() {
            const { text_color } = this;
            if (text_color.is_Scalar() && text_color.value == 0)
                return false;
            const { text_alpha } = this;
            if (text_alpha.is_Scalar() && text_alpha.value == 0)
                return false;
            return true;
        }
        v_doit(i) {
            if (this.text_color.get(i) == 0)
                return false;
            if (this.text_alpha.get(i) == 0)
                return false;
            return true;
        }
        apply(ctx, i) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
            }
            return doit;
        }
        set_vectorize(ctx, i) {
            this._assert_font(i);
            const color = this.text_color.get(i);
            const outline_color = this.text_outline_color.get(i);
            const alpha = this.text_alpha.get(i);
            const font = this.font_value(i);
            const align = this.text_align.get(i);
            const baseline = this.text_baseline.get(i);
            ctx.fillStyle = (0, color_1.color2css)(color, alpha);
            ctx.strokeStyle = (0, color_1.color2css)(outline_color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        }
        font_value(i) {
            const style = this.text_font_style.get(i);
            const size = this.text_font_size.get(i);
            const face = this.text_font.get(i);
            return `${style} ${size} ${face}`;
        }
    }
    exports.TextVector = TextVector;
    TextVector.__name__ = "TextVector";
    Text.prototype.type = "text";
    Text.prototype.attrs = Object.keys(mixins.Text);
    TextScalar.prototype.type = "text";
    TextScalar.prototype.attrs = Object.keys(mixins.TextScalar);
    TextVector.prototype.type = "text";
    TextVector.prototype.attrs = Object.keys(mixins.TextVector);
},
/* core/visuals/hatch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(77) /* ./visual */;
    const patterns_1 = require(82) /* ./patterns */;
    const p = tslib_1.__importStar(require(17) /* ../properties */);
    const mixins = tslib_1.__importStar(require(78) /* ../property_mixins */);
    class Hatch extends visual_1.VisualProperties {
        constructor() {
            super(...arguments);
            this._update_iteration = 0;
        }
        update() {
            this._update_iteration++;
            this._hatch_image = null;
            if (!this.doit)
                return;
            const color = this.hatch_color.get_value();
            const alpha = this.hatch_alpha.get_value();
            const scale = this.hatch_scale.get_value();
            const pattern = this.hatch_pattern.get_value();
            const weight = this.hatch_weight.get_value();
            const finalize = (image) => {
                this._hatch_image = image;
            };
            const textures = this.hatch_extra.get_value();
            const texture = textures[pattern];
            if (texture != null) {
                const image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    const { _update_iteration } = this;
                    image.then((image) => {
                        if (this._update_iteration == _update_iteration) {
                            finalize(image);
                            this.obj.request_render();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                const layer = this.obj.canvas.create_layer();
                const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        }
        get doit() {
            const color = this.hatch_color.get_value();
            const alpha = this.hatch_alpha.get_value();
            const pattern = this.hatch_pattern.get_value();
            return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        }
        apply(ctx, rule) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(() => ctx.fill(rule));
            }
            return doit;
        }
        set_value(ctx) {
            const pattern = this.pattern(ctx);
            ctx.fillStyle = pattern !== null && pattern !== void 0 ? pattern : "transparent";
        }
        pattern(ctx) {
            const image = this._hatch_image;
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition());
        }
        repetition() {
            const pattern = this.hatch_pattern.get_value();
            const texture = this.hatch_extra.get_value()[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        }
    }
    exports.Hatch = Hatch;
    Hatch.__name__ = "Hatch";
    class HatchScalar extends visual_1.VisualUniforms {
        constructor() {
            super(...arguments);
            this._static_doit = false;
            this._update_iteration = 0;
        }
        _compute_static_doit() {
            const color = this.hatch_color.value;
            const alpha = this.hatch_alpha.value;
            const pattern = this.hatch_pattern.value;
            return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        }
        update() {
            this._update_iteration++;
            const n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit)
                return;
            const color = this.hatch_color.value;
            const alpha = this.hatch_alpha.value;
            const scale = this.hatch_scale.value;
            const pattern = this.hatch_pattern.value;
            const weight = this.hatch_weight.value;
            const finalize = (image) => {
                this._hatch_image = new p.UniformScalar(image, n);
            };
            const textures = this.hatch_extra.value;
            const texture = textures[pattern];
            if (texture != null) {
                const image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    const { _update_iteration } = this;
                    image.then((image) => {
                        if (this._update_iteration == _update_iteration) {
                            finalize(image);
                            this.obj.request_render();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                const layer = this.obj.canvas.create_layer();
                const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        }
        get doit() {
            return this._static_doit;
        }
        apply(ctx, rule) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
                ctx.layer.undo_transform(() => ctx.fill(rule));
            }
            return doit;
        }
        set_value(ctx) {
            var _a;
            ctx.fillStyle = (_a = this.pattern(ctx)) !== null && _a !== void 0 ? _a : "transparent";
        }
        pattern(ctx) {
            const image = this._hatch_image.value;
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition());
        }
        repetition() {
            const pattern = this.hatch_pattern.value;
            const texture = this.hatch_extra.value[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        }
    }
    exports.HatchScalar = HatchScalar;
    HatchScalar.__name__ = "HatchScalar";
    class HatchVector extends visual_1.VisualUniforms {
        constructor() {
            super(...arguments);
            this._static_doit = false;
            this._update_iteration = 0;
        }
        _compute_static_doit() {
            const { hatch_color } = this;
            if (hatch_color.is_Scalar() && hatch_color.value == 0)
                return false;
            const { hatch_alpha } = this;
            if (hatch_alpha.is_Scalar() && hatch_alpha.value == 0)
                return false;
            const { hatch_pattern } = this;
            if (hatch_pattern.is_Scalar()) {
                const pattern = hatch_pattern.value;
                if (pattern == " " || pattern == "blank" || pattern == null)
                    return false;
            }
            return true;
        }
        update() {
            this._update_iteration++;
            const n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit)
                return;
            const resolve_image = (pattern, color, alpha, scale, weight, finalize) => {
                const textures = this.hatch_extra.value;
                const texture = textures[pattern];
                if (texture != null) {
                    const image = texture.get_pattern(color, alpha, scale, weight);
                    if (image instanceof Promise) {
                        const { _update_iteration } = this;
                        image.then((image) => {
                            if (this._update_iteration == _update_iteration) {
                                finalize(image);
                                this.obj.request_render();
                            }
                        });
                    }
                    else {
                        finalize(image);
                    }
                }
                else {
                    const layer = this.obj.canvas.create_layer();
                    const image = (0, patterns_1.get_pattern)(layer, pattern, color, alpha, scale, weight);
                    finalize(image);
                }
            };
            if (this.hatch_color.is_Scalar() &&
                this.hatch_alpha.is_Scalar() &&
                this.hatch_scale.is_Scalar() &&
                this.hatch_pattern.is_Scalar() &&
                this.hatch_weight.is_Scalar()) {
                const color = this.hatch_color.value;
                const alpha = this.hatch_alpha.value;
                const scale = this.hatch_scale.value;
                const pattern = this.hatch_pattern.value;
                const weight = this.hatch_weight.value;
                resolve_image(pattern, color, alpha, scale, weight, (image) => {
                    this._hatch_image = new p.UniformScalar(image, n);
                });
            }
            else {
                const images = new Array(n);
                images.fill(null);
                this._hatch_image = new p.UniformVector(images);
                for (let i = 0; i < n; i++) {
                    const color = this.hatch_color.get(i);
                    const alpha = this.hatch_alpha.get(i);
                    const scale = this.hatch_scale.get(i);
                    const pattern = this.hatch_pattern.get(i);
                    const weight = this.hatch_weight.get(i);
                    resolve_image(pattern, color, alpha, scale, weight, (image) => {
                        images[i] = image;
                    });
                }
            }
        }
        get doit() {
            return this._static_doit;
        }
        v_doit(i) {
            if (!this.doit)
                return false;
            if (this.hatch_color.get(i) == 0)
                return false;
            if (this.hatch_alpha.get(i) == 0)
                return false;
            const pattern = this.hatch_pattern.get(i);
            if (pattern == " " || pattern == "blank" || pattern == null)
                return false;
            return true;
        }
        apply(ctx, i, rule) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
                ctx.layer.undo_transform(() => ctx.fill(rule));
            }
            return doit;
        }
        set_vectorize(ctx, i) {
            var _a;
            ctx.fillStyle = (_a = this.pattern(ctx, i)) !== null && _a !== void 0 ? _a : "transparent";
        }
        pattern(ctx, i) {
            const image = this._hatch_image.get(i);
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition(i));
        }
        repetition(i) {
            const pattern = this.hatch_pattern.get(i);
            const texture = this.hatch_extra.value[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        }
    }
    exports.HatchVector = HatchVector;
    HatchVector.__name__ = "HatchVector";
    Hatch.prototype.type = "hatch";
    Hatch.prototype.attrs = Object.keys(mixins.Hatch);
    HatchScalar.prototype.type = "hatch";
    HatchScalar.prototype.attrs = Object.keys(mixins.HatchScalar);
    HatchVector.prototype.type = "hatch";
    HatchVector.prototype.attrs = Object.keys(mixins.HatchVector);
},
/* core/visuals/patterns.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const color_1 = require(21) /* ../util/color */;
    function _horz(ctx, h, h2) {
        ctx.moveTo(0, h2 + 0.5);
        ctx.lineTo(h, h2 + 0.5);
        ctx.stroke();
    }
    function _vert(ctx, h, h2) {
        ctx.moveTo(h2 + 0.5, 0);
        ctx.lineTo(h2 + 0.5, h);
        ctx.stroke();
    }
    function _x(ctx, h) {
        ctx.moveTo(0, h);
        ctx.lineTo(h, 0);
        ctx.stroke();
        ctx.moveTo(0, 0);
        ctx.lineTo(h, h);
        ctx.stroke();
    }
    exports.hatch_aliases = {
        " ": "blank",
        ".": "dot",
        o: "ring",
        "-": "horizontal_line",
        "|": "vertical_line",
        "+": "cross",
        "\"": "horizontal_dash",
        ":": "vertical_dash",
        "@": "spiral",
        "/": "right_diagonal_line",
        "\\": "left_diagonal_line",
        x: "diagonal_cross",
        ",": "right_diagonal_dash",
        "`": "left_diagonal_dash",
        v: "horizontal_wave",
        ">": "vertical_wave",
        "*": "criss_cross",
    };
    function get_pattern(layer, pattern, color, alpha, scale, weight) {
        layer.resize(scale, scale);
        layer.prepare();
        create_hatch_canvas(layer.ctx, pattern, color, alpha, scale, weight);
        return layer.canvas;
    }
    exports.get_pattern = get_pattern;
    function create_hatch_canvas(ctx, hatch_pattern, hatch_color, hatch_alpha, hatch_scale, hatch_weight) {
        var _a;
        const h = hatch_scale;
        const h2 = h / 2;
        const h4 = h2 / 2;
        const color = (0, color_1.color2css)(hatch_color, hatch_alpha);
        ctx.strokeStyle = color;
        ctx.fillStyle = color;
        ctx.lineCap = "square";
        ctx.lineWidth = hatch_weight;
        switch ((_a = exports.hatch_aliases[hatch_pattern]) !== null && _a !== void 0 ? _a : hatch_pattern) {
            // we should not need these if code conditions on hatch.doit, but
            // include them here just for completeness
            case "blank":
                break;
            case "dot":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.fill();
                break;
            case "ring":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.stroke();
                break;
            case "horizontal_line":
                _horz(ctx, h, h2);
                break;
            case "vertical_line":
                _vert(ctx, h, h2);
                break;
            case "cross":
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            case "horizontal_dash":
                _horz(ctx, h2, h2);
                break;
            case "vertical_dash":
                _vert(ctx, h2, h2);
                break;
            case "spiral": {
                const h30 = h / 30;
                ctx.moveTo(h2, h2);
                for (let i = 0; i < 360; i++) {
                    const angle = 0.1 * i;
                    const x = h2 + (h30 * angle) * Math.cos(angle);
                    const y = h2 + (h30 * angle) * Math.sin(angle);
                    ctx.lineTo(x, y);
                }
                ctx.stroke();
                break;
            }
            case "right_diagonal_line":
                ctx.moveTo(-h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(5 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "left_diagonal_line":
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(-h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(5 * h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "diagonal_cross":
                _x(ctx, h);
                break;
            case "right_diagonal_dash":
                ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
                ctx.stroke();
                break;
            case "left_diagonal_dash":
                ctx.moveTo(h4 + 0.5, h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
                ctx.stroke();
                break;
            case "horizontal_wave":
                ctx.moveTo(0, h4);
                ctx.lineTo(h2, 3 * h4);
                ctx.lineTo(h, h4);
                ctx.stroke();
                break;
            case "vertical_wave":
                ctx.moveTo(h4, 0);
                ctx.lineTo(3 * h4, h2);
                ctx.lineTo(h4, h);
                ctx.stroke();
                break;
            case "criss_cross":
                _x(ctx, h);
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
        }
    }
},
/* core/visuals/image.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const visual_1 = require(77) /* ./visual */;
    const mixins = tslib_1.__importStar(require(78) /* ../property_mixins */);
    class Image extends visual_1.VisualProperties {
        get doit() {
            const alpha = this.global_alpha.get_value();
            return !(alpha == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
            }
            return doit;
        }
        values() {
            return {
                global_alpha: this.global_alpha.get_value(),
            };
        }
        set_value(ctx) {
            const alpha = this.global_alpha.get_value();
            ctx.globalAlpha = alpha;
        }
    }
    exports.Image = Image;
    Image.__name__ = "Image";
    class ImageScalar extends visual_1.VisualUniforms {
        get doit() {
            const alpha = this.global_alpha.value;
            return !(alpha == 0);
        }
        apply(ctx) {
            const { doit } = this;
            if (doit) {
                this.set_value(ctx);
            }
            return doit;
        }
        values() {
            return {
                global_alpha: this.global_alpha.value,
            };
        }
        set_value(ctx) {
            const alpha = this.global_alpha.value;
            ctx.globalAlpha = alpha;
        }
    }
    exports.ImageScalar = ImageScalar;
    ImageScalar.__name__ = "ImageScalar";
    class ImageVector extends visual_1.VisualUniforms {
        get doit() {
            const { global_alpha } = this;
            if (global_alpha.is_Scalar() && global_alpha.value == 0)
                return false;
            return true;
        }
        v_doit(i) {
            if (this.global_alpha.get(i) == 0)
                return false;
            return true;
        }
        apply(ctx, i) {
            const doit = this.v_doit(i);
            if (doit) {
                this.set_vectorize(ctx, i);
            }
            return doit;
        }
        values(i) {
            return {
                alpha: this.global_alpha.get(i),
            };
        }
        set_vectorize(ctx, i) {
            const alpha = this.global_alpha.get(i);
            ctx.globalAlpha = alpha;
        }
    }
    exports.ImageVector = ImageVector;
    ImageVector.__name__ = "ImageVector";
    Image.prototype.type = "image";
    Image.prototype.attrs = Object.keys(mixins.Image);
    ImageScalar.prototype.type = "image";
    ImageScalar.prototype.attrs = Object.keys(mixins.ImageScalar);
    ImageVector.prototype.type = "image";
    ImageVector.prototype.attrs = Object.keys(mixins.ImageVector);
},
/* models/coordinates/coordinate_mapping.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a, _b;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    const model_1 = require(51) /* ../../model */;
    const scale_1 = require(85) /* ../scales/scale */;
    const linear_scale_1 = require(89) /* ../scales/linear_scale */;
    const log_scale_1 = require(91) /* ../scales/log_scale */;
    const categorical_scale_1 = require(92) /* ../scales/categorical_scale */;
    const range_1 = require(87) /* ../ranges/range */;
    const data_range1d_1 = require(93) /* ../ranges/data_range1d */;
    const factor_range_1 = require(96) /* ../ranges/factor_range */;
    class CoordinateTransform {
        constructor(x_scale, y_scale) {
            this.x_scale = x_scale;
            this.y_scale = y_scale;
            this.x_source = this.x_scale.source_range;
            this.y_source = this.y_scale.source_range;
            this.ranges = [this.x_source, this.y_source];
            this.scales = [this.x_scale, this.y_scale];
        }
        map_to_screen(xs, ys) {
            const sxs = this.x_scale.v_compute(xs);
            const sys = this.y_scale.v_compute(ys);
            return [sxs, sys];
        }
        map_from_screen(sxs, sys) {
            const xs = this.x_scale.v_invert(sxs);
            const ys = this.y_scale.v_invert(sys);
            return [xs, ys];
        }
    }
    exports.CoordinateTransform = CoordinateTransform;
    CoordinateTransform.__name__ = "CoordinateTransform";
    class CoordinateMapping extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get x_ranges() {
            return new Map([["default", this.x_source]]);
        }
        get y_ranges() {
            return new Map([["default", this.y_source]]);
        }
        _get_scale(range, scale, target) {
            const factor_range = range instanceof factor_range_1.FactorRange;
            const categorical_scale = scale instanceof categorical_scale_1.CategoricalScale;
            if (factor_range != categorical_scale) {
                throw new Error(`Range ${range.type} is incompatible is Scale ${scale.type}`);
            }
            if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                range.scale_hint = "log";
            const derived_scale = scale.clone();
            derived_scale.setv({ source_range: range, target_range: target });
            return derived_scale;
        }
        get_transform(frame) {
            const { x_source, x_scale, x_target } = this;
            const x_source_scale = this._get_scale(x_source, x_scale, x_target);
            const { y_source, y_scale, y_target } = this;
            const y_source_scale = this._get_scale(y_source, y_scale, y_target);
            const xscale = new CompositeScale({
                source_scale: x_source_scale, source_range: x_source_scale.source_range,
                target_scale: frame.x_scale, target_range: frame.x_target,
            });
            const yscale = new CompositeScale({
                source_scale: y_source_scale, source_range: y_source_scale.source_range,
                target_scale: frame.y_scale, target_range: frame.y_target,
            });
            return new CoordinateTransform(xscale, yscale);
        }
    }
    exports.CoordinateMapping = CoordinateMapping;
    _a = CoordinateMapping;
    CoordinateMapping.__name__ = "CoordinateMapping";
    (() => {
        _a.define(({ Ref }) => ({
            x_source: [Ref(range_1.Range), () => new data_range1d_1.DataRange1d()],
            y_source: [Ref(range_1.Range), () => new data_range1d_1.DataRange1d()],
            x_scale: [Ref(scale_1.Scale), () => new linear_scale_1.LinearScale()],
            y_scale: [Ref(scale_1.Scale), () => new linear_scale_1.LinearScale()],
            x_target: [Ref(range_1.Range)],
            y_target: [Ref(range_1.Range)],
        }));
    })();
    class CompositeScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const source_compute = this.source_scale.s_compute;
            const target_compute = this.target_scale.s_compute;
            return (x) => target_compute(source_compute(x));
        }
        get s_invert() {
            const source_invert = this.source_scale.s_invert;
            const target_invert = this.target_scale.s_invert;
            return (sx) => source_invert(target_invert(sx));
        }
        compute(x) {
            return this.s_compute(x);
        }
        v_compute(xs) {
            const { s_compute } = this;
            return (0, arrayable_1.map)(xs, s_compute); // XXX
        }
        invert(sx) {
            return this.s_invert(sx);
        }
        v_invert(sxs) {
            const { s_invert } = this;
            return (0, arrayable_1.map)(sxs, s_invert); // XXX
        }
    }
    exports.CompositeScale = CompositeScale;
    _b = CompositeScale;
    CompositeScale.__name__ = "CompositeScale";
    (() => {
        _b.internal(({ Ref }) => ({
            source_scale: [Ref(scale_1.Scale)],
            target_scale: [Ref(scale_1.Scale)],
        }));
    })();
},
/* models/scales/scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const transform_1 = require(86) /* ../transforms/transform */;
    const range_1 = require(87) /* ../ranges/range */;
    const range1d_1 = require(88) /* ../ranges/range1d */;
    const types_1 = require(23) /* ../../core/types */;
    class Scale extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        compute(x) {
            return this.s_compute(x);
        }
        v_compute(xs) {
            const result = new types_1.ScreenArray(xs.length);
            const { s_compute } = this;
            for (let i = 0; i < xs.length; i++) {
                result[i] = s_compute(xs[i]);
            }
            return result;
        }
        invert(sx) {
            return this.s_invert(sx);
        }
        v_invert(sxs) {
            const result = new Float64Array(sxs.length);
            const { s_invert } = this;
            for (let i = 0; i < sxs.length; i++) {
                result[i] = s_invert(sxs[i]);
            }
            return result;
        }
        r_compute(x0, x1) {
            const { s_compute } = this;
            if (this.target_range.is_reversed)
                return [s_compute(x1), s_compute(x0)];
            else
                return [s_compute(x0), s_compute(x1)];
        }
        r_invert(sx0, sx1) {
            const { s_invert } = this;
            if (this.target_range.is_reversed)
                return [s_invert(sx1), s_invert(sx0)];
            else
                return [s_invert(sx0), s_invert(sx1)];
        }
    }
    exports.Scale = Scale;
    _a = Scale;
    Scale.__name__ = "Scale";
    (() => {
        _a.internal(({ Ref }) => ({
            source_range: [Ref(range_1.Range)],
            target_range: [Ref(range1d_1.Range1d)],
        }));
    })();
},
/* models/transforms/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class Transform extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Transform = Transform;
    Transform.__name__ = "Transform";
},
/* models/ranges/range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(51) /* ../../model */;
    class Range extends model_1.Model {
        constructor(attrs) {
            super(attrs);
            this.have_updated_interactively = false;
        }
        get is_reversed() {
            return this.start > this.end;
        }
        get is_valid() {
            return isFinite(this.min) && isFinite(this.max);
        }
        get span() {
            return Math.abs(this.end - this.start);
        }
    }
    exports.Range = Range;
    _a = Range;
    Range.__name__ = "Range";
    (() => {
        _a.define(({ Number, Tuple, Or, Auto, Nullable }) => ({
            bounds: [Nullable(Or(Tuple(Nullable(Number), Nullable(Number)), Auto)), null],
            min_interval: [Nullable(Number), null],
            max_interval: [Nullable(Number), null],
        }));
    })();
},
/* models/ranges/range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const range_1 = require(87) /* ./range */;
    class Range1d extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
        _set_auto_bounds() {
            if (this.bounds == "auto") {
                const min = Math.min(this._reset_start, this._reset_end);
                const max = Math.max(this._reset_start, this._reset_end);
                this.setv({ bounds: [min, max] }, { silent: true });
            }
        }
        initialize() {
            super.initialize();
            this._set_auto_bounds();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        reset() {
            this._set_auto_bounds();
            const { _reset_start, _reset_end } = this;
            if (this.start != _reset_start || this.end != _reset_end)
                this.setv({ start: _reset_start, end: _reset_end });
            else
                this.change.emit();
        }
        map(fn) {
            return new Range1d({ start: fn(this.start), end: fn(this.end) });
        }
        widen(v) {
            let { start, end } = this;
            if (this.is_reversed) {
                start += v;
                end -= v;
            }
            else {
                start -= v;
                end += v;
            }
            return new Range1d({ start, end });
        }
    }
    exports.Range1d = Range1d;
    _a = Range1d;
    Range1d.__name__ = "Range1d";
    (() => {
        _a.define(({ Number, Nullable }) => ({
            start: [Number, 0],
            end: [Number, 1],
            reset_start: [Nullable(Number), null, {
                    on_update(reset_start, self) {
                        self._reset_start = reset_start !== null && reset_start !== void 0 ? reset_start : self.start;
                    },
                }],
            reset_end: [Nullable(Number), null, {
                    on_update(reset_end, self) {
                        self._reset_end = reset_end !== null && reset_end !== void 0 ? reset_end : self.end;
                    },
                }],
        }));
    })();
},
/* models/scales/linear_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(90) /* ./continuous_scale */;
    class LinearScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset] = this._linear_compute_state();
            return (x) => factor * x + offset;
        }
        get s_invert() {
            const [factor, offset] = this._linear_compute_state();
            return (sx) => (sx - offset) / factor;
        }
        /*protected*/ _linear_compute_state() {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const factor = (target_end - target_start) / (source_end - source_start);
            const offset = -(factor * source_start) + target_start;
            return [factor, offset];
        }
    }
    exports.LinearScale = LinearScale;
    LinearScale.__name__ = "LinearScale";
},
/* models/scales/continuous_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(85) /* ./scale */;
    class ContinuousScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ContinuousScale = ContinuousScale;
    ContinuousScale.__name__ = "ContinuousScale";
},
/* models/scales/log_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_scale_1 = require(90) /* ./continuous_scale */;
    class LogScale extends continuous_scale_1.ContinuousScale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            return (x) => {
                if (inter_factor == 0)
                    return 0;
                else {
                    const _x = (Math.log(x) - inter_offset) / inter_factor;
                    return isFinite(_x) ? _x * factor + offset : NaN;
                }
            };
        }
        get s_invert() {
            const [factor, offset, inter_factor, inter_offset] = this._compute_state();
            return (xprime) => {
                const value = (xprime - offset) / factor;
                return Math.exp(inter_factor * value + inter_offset);
            };
        }
        _get_safe_factor(orig_start, orig_end) {
            let start = orig_start < 0 ? 0 : orig_start;
            let end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0)
                    [start, end] = [1, 10];
                else {
                    const log_val = Math.log10(start);
                    start = 10 ** Math.floor(log_val);
                    if (Math.ceil(log_val) != Math.floor(log_val))
                        end = 10 ** Math.ceil(log_val);
                    else
                        end = 10 ** (Math.ceil(log_val) + 1);
                }
            }
            return [start, end];
        }
        /*protected*/ _compute_state() {
            const source_start = this.source_range.start;
            const source_end = this.source_range.end;
            const target_start = this.target_range.start;
            const target_end = this.target_range.end;
            const screen_range = target_end - target_start;
            const [start, end] = this._get_safe_factor(source_start, source_end);
            let inter_factor;
            let inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            }
            else {
                inter_factor = Math.log(end / start);
                inter_offset = Math.log(start);
            }
            const factor = screen_range;
            const offset = target_start;
            return [factor, offset, inter_factor, inter_offset];
        }
    }
    exports.LogScale = LogScale;
    LogScale.__name__ = "LogScale";
},
/* models/scales/categorical_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const scale_1 = require(85) /* ./scale */;
    const linear_scale_1 = require(89) /* ./linear_scale */;
    const { _linear_compute_state } = linear_scale_1.LinearScale.prototype;
    class CategoricalScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        get s_compute() {
            const [factor, offset] = _linear_compute_state.call(this);
            const range = this.source_range;
            return (x) => factor * range.synthetic(x) + offset;
        }
        get s_invert() {
            const [factor, offset] = _linear_compute_state.call(this);
            return (sx) => (sx - offset) / factor;
        }
    }
    exports.CategoricalScale = CategoricalScale;
    CategoricalScale.__name__ = "CategoricalScale";
},
/* models/ranges/data_range1d.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const data_range_1 = require(94) /* ./data_range */;
    const enums_1 = require(19) /* ../../core/enums */;
    const iterator_1 = require(32) /* ../../core/util/iterator */;
    const logging_1 = require(18) /* ../../core/logging */;
    const bbox = tslib_1.__importStar(require(57) /* ../../core/util/bbox */);
    const util_1 = require(95) /* ../util */;
    class DataRange1d extends data_range_1.DataRange {
        constructor(attrs) {
            super(attrs);
            this.plots = new Set();
            this.have_updated_interactively = false;
        }
        initialize() {
            super.initialize();
            this._initial_start = isNaN(this.start) ? null : this.start;
            this._initial_end = isNaN(this.end) ? null : this.end;
            this._initial_range_padding = this.range_padding;
            this._initial_range_padding_units = this.range_padding_units;
            this._initial_follow = this.follow;
            this._initial_follow_interval = this.follow_interval;
            this._initial_default_span = this.default_span;
            this._plot_bounds = new Map();
        }
        get min() {
            return Math.min(this.start, this.end);
        }
        get max() {
            return Math.max(this.start, this.end);
        }
        computed_renderers() {
            // TODO (bev) check that renderers actually configured with this range
            const { renderers } = this;
            const all_renderers = (0, iterator_1.flat_map)(this.plots, (plot) => plot.data_renderers);
            return (0, util_1.compute_renderers)(renderers.length == 0 ? "auto" : renderers, [...all_renderers]);
        }
        /*protected*/ _compute_plot_bounds(renderers, bounds) {
            let result = bbox.empty();
            for (const r of renderers) {
                const rect = bounds.get(r);
                if (rect != null && (r.visible || !this.only_visible)) {
                    result = bbox.union(result, rect);
                }
            }
            return result;
        }
        adjust_bounds_for_aspect(bounds, ratio) {
            const result = bbox.empty();
            let width = bounds.x1 - bounds.x0;
            if (width <= 0) {
                width = 1.0;
            }
            let height = bounds.y1 - bounds.y0;
            if (height <= 0) {
                height = 1.0;
            }
            const xcenter = 0.5 * (bounds.x1 + bounds.x0);
            const ycenter = 0.5 * (bounds.y1 + bounds.y0);
            if (width < ratio * height) {
                width = ratio * height;
            }
            else {
                height = width / ratio;
            }
            result.x1 = xcenter + 0.5 * width;
            result.x0 = xcenter - 0.5 * width;
            result.y1 = ycenter + 0.5 * height;
            result.y0 = ycenter - 0.5 * height;
            return result;
        }
        /*protected*/ _compute_min_max(plot_bounds, dimension) {
            let overall = bbox.empty();
            for (const [plot, rect] of plot_bounds) {
                if (plot.visible)
                    overall = bbox.union(overall, rect);
            }
            let min, max;
            if (dimension == 0)
                [min, max] = [overall.x0, overall.x1];
            else
                [min, max] = [overall.y0, overall.y1];
            return [min, max];
        }
        /*protected*/ _compute_range(min, max) {
            const range_padding = this.range_padding; // XXX: ? 0
            let start, end;
            if (this._initial_start != null)
                min = this._initial_start;
            if (this._initial_end != null)
                max = this._initial_end;
            if (this.scale_hint == "log") {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0)
                        min = 0.1;
                    else
                        min = max / 100;
                    logging_1.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${min}`);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0)
                        max = 10;
                    else
                        max = min * 100;
                    logging_1.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${max}`);
                }
                let center, span;
                if (max == min) {
                    span = this.default_span + 0.001;
                    center = Math.log10(min);
                }
                else {
                    let log_min, log_max;
                    if (this.range_padding_units == "percent") {
                        log_min = Math.log10(min);
                        log_max = Math.log10(max);
                        span = (log_max - log_min) * (1 + range_padding);
                    }
                    else {
                        log_min = Math.log10(min - range_padding);
                        log_max = Math.log10(max + range_padding);
                        span = log_max - log_min;
                    }
                    center = (log_min + log_max) / 2.0;
                }
                start = 10 ** (center - span / 2.0);
                end = 10 ** (center + span / 2.0);
            }
            else {
                let span;
                if (max == min)
                    span = this.default_span;
                else {
                    if (this.range_padding_units == "percent")
                        span = (max - min) * (1 + range_padding);
                    else
                        span = (max - min) + 2 * range_padding;
                }
                const center = (max + min) / 2.0;
                start = center - span / 2.0;
                end = center + span / 2.0;
            }
            let follow_sign = +1;
            if (this.flipped) {
                [start, end] = [end, start];
                follow_sign = -1;
            }
            const follow_interval = this.follow_interval;
            if (follow_interval != null && Math.abs(start - end) > follow_interval) {
                if (this.follow == "start")
                    end = start + follow_sign * follow_interval;
                else if (this.follow == "end")
                    start = end - follow_sign * follow_interval;
            }
            return [start, end];
        }
        update(bounds, dimension, plot, ratio) {
            if (this.have_updated_interactively)
                return;
            const renderers = this.computed_renderers();
            // update the raw data bounds for all renderers we care about
            let total_bounds = this._compute_plot_bounds(renderers, bounds);
            if (ratio != null)
                total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
            this._plot_bounds.set(plot, total_bounds);
            // compute the min/mix for our specified dimension
            const [min, max] = this._compute_min_max(this._plot_bounds.entries(), dimension);
            // derive start, end from bounds and data range config
            let [start, end] = this._compute_range(min, max);
            if (this._initial_start != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_start > 0)
                        start = this._initial_start;
                }
                else
                    start = this._initial_start;
            }
            if (this._initial_end != null) {
                if (this.scale_hint == "log") {
                    if (this._initial_end > 0)
                        end = this._initial_end;
                }
                else
                    end = this._initial_end;
            }
            let needs_emit = false;
            if (this.bounds == "auto") {
                this.setv({ bounds: [start, end] }, { silent: true });
                needs_emit = true;
            }
            // only trigger updates when there are changes
            const [_start, _end] = [this.start, this.end];
            if (start != _start || end != _end) {
                const new_range = {};
                if (start != _start)
                    new_range.start = start;
                if (end != _end)
                    new_range.end = end;
                this.setv(new_range);
                needs_emit = false;
            }
            if (needs_emit)
                this.change.emit();
        }
        reset() {
            this.have_updated_interactively = false;
            // change events silenced as PlotView.update_dataranges triggers property callbacks
            this.setv({
                range_padding: this._initial_range_padding,
                range_padding_units: this._initial_range_padding_units,
                follow: this._initial_follow,
                follow_interval: this._initial_follow_interval,
                default_span: this._initial_default_span,
            }, { silent: true });
            this.change.emit();
        }
    }
    exports.DataRange1d = DataRange1d;
    _a = DataRange1d;
    DataRange1d.__name__ = "DataRange1d";
    (() => {
        _a.define(({ Boolean, Number, Nullable }) => ({
            start: [Number, NaN],
            end: [Number, NaN],
            range_padding: [Number, 0.1],
            range_padding_units: [enums_1.PaddingUnits, "percent"],
            flipped: [Boolean, false],
            follow: [Nullable(enums_1.StartEnd), null],
            follow_interval: [Nullable(Number), null],
            default_span: [Number, 2.0],
            only_visible: [Boolean, false],
        }));
        _a.internal(({ Enum }) => ({
            scale_hint: [Enum("log", "auto"), "auto"],
        }));
    })();
},
/* models/ranges/data_range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const range_1 = require(87) /* ./range */;
    class DataRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataRange = DataRange;
    _a = DataRange;
    DataRange.__name__ = "DataRange";
    (() => {
        _a.define(({ Array, AnyRef, Or, Auto }) => ({
            renderers: [Or(Array(AnyRef()), Auto), []],
        }));
    })();
},
/* models/util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function compute_renderers(renderers, all_renderers) {
        return renderers == "auto" ? all_renderers : renderers !== null && renderers !== void 0 ? renderers : [];
    }
    exports.compute_renderers = compute_renderers;
},
/* models/ranges/factor_range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const range_1 = require(87) /* ./range */;
    const enums_1 = require(19) /* ../../core/enums */;
    const kinds_1 = require(20) /* ../../core/kinds */;
    const types_1 = require(23) /* ../../core/types */;
    const array_1 = require(10) /* ../../core/util/array */;
    const types_2 = require(8) /* ../../core/util/types */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    exports.Factor = (0, kinds_1.Or)(kinds_1.String, (0, kinds_1.Tuple)(kinds_1.String, kinds_1.String), (0, kinds_1.Tuple)(kinds_1.String, kinds_1.String, kinds_1.String));
    exports.FactorSeq = (0, kinds_1.Or)((0, kinds_1.Array)(kinds_1.String), (0, kinds_1.Array)((0, kinds_1.Tuple)(kinds_1.String, kinds_1.String)), (0, kinds_1.Array)((0, kinds_1.Tuple)(kinds_1.String, kinds_1.String, kinds_1.String)));
    function map_one_level(factors, padding, offset = 0) {
        const mapping = new Map();
        for (let i = 0; i < factors.length; i++) {
            const factor = factors[i];
            if (!mapping.has(factor))
                mapping.set(factor, { value: 0.5 + i * (1 + padding) + offset });
            else
                throw new Error(`duplicate factor or subfactor: ${factor}`);
        }
        return [mapping, (factors.length - 1) * padding];
    }
    exports.map_one_level = map_one_level;
    function map_two_levels(factors, outer_pad, factor_pad, offset = 0) {
        var _b;
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1] of factors) {
            const top = (_b = tops.get(f0)) !== null && _b !== void 0 ? _b : [];
            tops.set(f0, [...top, f1]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const [submap, subpad] = map_one_level(top, factor_pad, suboffset);
            total_subpad += subpad;
            const subtot = (0, array_1.sum)(top.map((f1) => submap.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_two_levels = map_two_levels;
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset = 0) {
        var _b;
        const mapping = new Map();
        const tops = new Map();
        for (const [f0, f1, f2] of factors) {
            const top = (_b = tops.get(f0)) !== null && _b !== void 0 ? _b : [];
            tops.set(f0, [...top, [f1, f2]]);
        }
        let suboffset = offset;
        let total_subpad = 0;
        for (const [f0, top] of tops) {
            const n = top.length;
            const [submap, subpad] = map_two_levels(top, inner_pad, factor_pad, suboffset);
            total_subpad += subpad;
            const subtot = (0, array_1.sum)(top.map(([f1]) => submap.get(f1).value));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_three_levels = map_three_levels;
    class FactorRange extends range_1.Range {
        constructor(attrs) {
            super(attrs);
        }
        get min() {
            return this.start;
        }
        get max() {
            return this.end;
        }
        initialize() {
            super.initialize();
            this._init(true);
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.properties.factors.change, () => this.reset());
            this.connect(this.properties.factor_padding.change, () => this.reset());
            this.connect(this.properties.group_padding.change, () => this.reset());
            this.connect(this.properties.subgroup_padding.change, () => this.reset());
            this.connect(this.properties.range_padding.change, () => this.reset());
            this.connect(this.properties.range_padding_units.change, () => this.reset());
        }
        reset() {
            this._init(false);
            this.change.emit();
        }
        _lookup(x) {
            switch (x.length) {
                case 1: {
                    const [f0] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    return y0 != null ? y0.value : NaN;
                }
                case 2: {
                    const [f0, f1] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    if (y0 != null) {
                        const y1 = y0.mapping.get(f1);
                        if (y1 != null)
                            return y1.value;
                    }
                    return NaN;
                }
                case 3: {
                    const [f0, f1, f2] = x;
                    const mapping = this._mapping;
                    const y0 = mapping.get(f0);
                    if (y0 != null) {
                        const y1 = y0.mapping.get(f1);
                        if (y1 != null) {
                            const y2 = y1.mapping.get(f2);
                            if (y2 != null)
                                return y2.value;
                        }
                    }
                    return NaN;
                }
                default:
                    (0, assert_1.unreachable)();
            }
        }
        // convert a string factor into a synthetic coordinate
        synthetic(x) {
            if ((0, types_2.isNumber)(x))
                return x;
            if ((0, types_2.isString)(x))
                return this._lookup([x]);
            let offset = 0;
            const off = x[x.length - 1];
            if ((0, types_2.isNumber)(off)) {
                offset = off;
                x = x.slice(0, -1);
            }
            return this._lookup(x) + offset;
        }
        // convert an array of string factors into synthetic coordinates
        v_synthetic(xs) {
            const n = xs.length;
            const array = new types_1.ScreenArray(n);
            for (let i = 0; i < n; i++) {
                array[i] = this.synthetic(xs[i]);
            }
            return array;
        }
        _init(silent) {
            const { levels, mapping, tops, mids, inside_padding } = (() => {
                if ((0, array_1.every)(this.factors, types_2.isString)) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_one_level(factors, this.factor_padding);
                    const tops = null;
                    const mids = null;
                    return { levels: 1, mapping, tops, mids, inside_padding };
                }
                else if ((0, array_1.every)(this.factors, (x) => (0, types_2.isArray)(x) && x.length == 2 && (0, types_2.isString)(x[0]) && (0, types_2.isString)(x[1]))) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_two_levels(factors, this.group_padding, this.factor_padding);
                    const tops = [...mapping.keys()];
                    const mids = null;
                    return { levels: 2, mapping, tops, mids, inside_padding };
                }
                else if ((0, array_1.every)(this.factors, (x) => (0, types_2.isArray)(x) && x.length == 3 && (0, types_2.isString)(x[0]) && (0, types_2.isString)(x[1]) && (0, types_2.isString)(x[2]))) {
                    const factors = this.factors;
                    const [mapping, inside_padding] = map_three_levels(factors, this.group_padding, this.subgroup_padding, this.factor_padding);
                    const tops = [...mapping.keys()];
                    const mids = [];
                    for (const [f0, L2] of mapping) {
                        for (const f1 of L2.mapping.keys()) {
                            mids.push([f0, f1]);
                        }
                    }
                    return { levels: 3, mapping, tops, mids, inside_padding };
                }
                else
                    (0, assert_1.unreachable)();
            })();
            this._mapping = mapping;
            this.tops = tops;
            this.mids = mids;
            let start = 0;
            let end = this.factors.length + inside_padding;
            if (this.range_padding_units == "percent") {
                const half_span = (end - start) * this.range_padding / 2;
                start -= half_span;
                end += half_span;
            }
            else {
                start -= this.range_padding;
                end += this.range_padding;
            }
            this.setv({ start, end, levels }, { silent });
            if (this.bounds == "auto")
                this.setv({ bounds: [start, end] }, { silent: true });
        }
    }
    exports.FactorRange = FactorRange;
    _a = FactorRange;
    FactorRange.__name__ = "FactorRange";
    (() => {
        _a.define(({ Number }) => ({
            factors: [exports.FactorSeq, []],
            factor_padding: [Number, 0],
            subgroup_padding: [Number, 0.8],
            group_padding: [Number, 1.4],
            range_padding: [Number, 0],
            range_padding_units: [enums_1.PaddingUnits, "percent"],
            start: [Number, NaN],
            end: [Number, NaN],
        }));
        _a.internal(({ Number, String, Array, Tuple, Nullable }) => ({
            levels: [Number],
            mids: [Nullable(Array(Tuple(String, String))), null],
            tops: [Nullable(Array(String)), null], // top level factors (whether 2 or 3 total levels)
        }));
    })();
},
/* models/annotations/arrow.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const data_annotation_1 = require(98) /* ./data_annotation */;
    const arrow_head_1 = require(139) /* ./arrow_head */;
    const property_mixins_1 = require(78) /* ../../core/property_mixins */;
    const enums_1 = require(19) /* ../../core/enums */;
    const types_1 = require(23) /* ../../core/types */;
    const build_views_1 = require(59) /* ../../core/build_views */;
    const types_2 = require(23) /* ../../core/types */;
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    const math_1 = require(11) /* ../../core/util/math */;
    class ArrowView extends data_annotation_1.DataAnnotationView {
        *children() {
            yield* super.children();
            const { start, end } = this;
            if (start != null)
                yield start;
            if (end != null)
                yield end;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const { start, end } = this.model;
            if (start != null)
                this.start = await (0, build_views_1.build_view)(start, { parent: this });
            if (end != null)
                this.end = await (0, build_views_1.build_view)(end, { parent: this });
        }
        set_data(source) {
            var _b, _c;
            super.set_data(source);
            const indices = types_2.Indices.all_set(this._x_start.length);
            (_b = this.start) === null || _b === void 0 ? void 0 : _b.set_data(source, indices);
            (_c = this.end) === null || _c === void 0 ? void 0 : _c.set_data(source, indices);
        }
        remove() {
            var _b, _c;
            (_b = this.start) === null || _b === void 0 ? void 0 : _b.remove();
            (_c = this.end) === null || _c === void 0 ? void 0 : _c.remove();
            super.remove();
        }
        map_data() {
            const { frame } = this.plot_view;
            const [sx_start, sy_start] = (() => {
                switch (this.model.start_units) {
                    case "canvas": {
                        return [
                            new types_1.ScreenArray(this._x_start),
                            new types_1.ScreenArray(this._y_start),
                        ];
                    }
                    case "screen": {
                        return [
                            frame.bbox.xview.v_compute(this._x_start),
                            frame.bbox.yview.v_compute(this._y_start),
                        ];
                    }
                    case "data": {
                        return [
                            this.coordinates.x_scale.v_compute(this._x_start),
                            this.coordinates.y_scale.v_compute(this._y_start),
                        ];
                    }
                }
            })();
            const [sx_end, sy_end] = (() => {
                switch (this.model.end_units) {
                    case "canvas": {
                        return [
                            new types_1.ScreenArray(this._x_end),
                            new types_1.ScreenArray(this._y_end),
                        ];
                    }
                    case "screen": {
                        return [
                            frame.bbox.xview.v_compute(this._x_end),
                            frame.bbox.yview.v_compute(this._y_end),
                        ];
                    }
                    case "data": {
                        return [
                            this.coordinates.x_scale.v_compute(this._x_end),
                            this.coordinates.y_scale.v_compute(this._y_end),
                        ];
                    }
                }
            })();
            this._sx_start = sx_start;
            this._sy_start = sy_start;
            this._sx_end = sx_end;
            this._sy_end = sy_end;
            const n = sx_start.length;
            const angles = this._angles = new types_1.ScreenArray(n);
            for (let i = 0; i < n; i++) {
                // arrow head runs orthogonal to arrow body (???)
                angles[i] = Math.PI / 2 + (0, math_1.atan2)([sx_start[i], sy_start[i]], [sx_end[i], sy_end[i]]);
            }
        }
        paint(ctx) {
            const { start, end } = this;
            const { _sx_start, _sy_start, _sx_end, _sy_end, _angles } = this;
            const { x, y, width, height } = this.plot_view.frame.bbox;
            for (let i = 0, n = _sx_start.length; i < n; i++) {
                if (end != null) {
                    ctx.save();
                    ctx.translate(_sx_end[i], _sy_end[i]);
                    ctx.rotate(_angles[i]);
                    end.render(ctx, i);
                    ctx.restore();
                }
                if (start != null) {
                    ctx.save();
                    ctx.translate(_sx_start[i], _sy_start[i]);
                    ctx.rotate(_angles[i] + Math.PI);
                    start.render(ctx, i);
                    ctx.restore();
                }
                if (!this.visuals.line.doit)
                    continue;
                ctx.save();
                if (start != null || end != null) {
                    ctx.beginPath();
                    ctx.rect(x, y, width, height);
                    if (end != null) {
                        ctx.save();
                        ctx.translate(_sx_end[i], _sy_end[i]);
                        ctx.rotate(_angles[i]);
                        end.clip(ctx, i);
                        ctx.restore();
                    }
                    if (start != null) {
                        ctx.save();
                        ctx.translate(_sx_start[i], _sy_start[i]);
                        ctx.rotate(_angles[i] + Math.PI);
                        start.clip(ctx, i);
                        ctx.restore();
                    }
                    ctx.closePath();
                    ctx.clip();
                }
                ctx.beginPath();
                ctx.moveTo(_sx_start[i], _sy_start[i]);
                ctx.lineTo(_sx_end[i], _sy_end[i]);
                this.visuals.line.apply(ctx, i);
                ctx.restore();
            }
        }
    }
    exports.ArrowView = ArrowView;
    ArrowView.__name__ = "ArrowView";
    class Arrow extends data_annotation_1.DataAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Arrow = Arrow;
    _a = Arrow;
    Arrow.__name__ = "Arrow";
    (() => {
        _a.prototype.default_view = ArrowView;
        _a.mixins(property_mixins_1.LineVector);
        _a.define(({ Ref, Nullable }) => ({
            x_start: [p.XCoordinateSpec, { field: "x_start" }],
            y_start: [p.YCoordinateSpec, { field: "y_start" }],
            start_units: [enums_1.CoordinateUnits, "data"],
            start: [Nullable(Ref(arrow_head_1.ArrowHead)), null],
            x_end: [p.XCoordinateSpec, { field: "x_end" }],
            y_end: [p.YCoordinateSpec, { field: "y_end" }],
            end_units: [enums_1.CoordinateUnits, "data"],
            end: [Nullable(Ref(arrow_head_1.ArrowHead)), () => new arrow_head_1.OpenHead()],
        }));
    })();
},
/* models/annotations/data_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(73) /* ./annotation */;
    const columnar_data_source_1 = require(99) /* ../sources/columnar_data_source */;
    const column_data_source_1 = require(104) /* ../sources/column_data_source */;
    const projections_1 = require(105) /* ../../core/util/projections */;
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    class DataAnnotationView extends annotation_1.AnnotationView {
        constructor() {
            super(...arguments);
            this._initial_set_data = false;
        }
        connect_signals() {
            super.connect_signals();
            const update = () => {
                this.set_data(this.model.source);
                this._rerender();
            };
            this.connect(this.model.change, update);
            this.connect(this.model.source.streaming, update);
            this.connect(this.model.source.patching, update);
            this.connect(this.model.source.change, update);
        }
        _rerender() {
            this.request_render();
        }
        set_data(source) {
            const self = this;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                    continue;
                if (prop instanceof p.BaseCoordinateSpec) {
                    const array = prop.array(source);
                    self[`_${prop.attr}`] = array;
                }
                else {
                    const uniform = prop.uniform(source);
                    self[`${prop.attr}`] = uniform;
                }
            }
            if (this.plot_model.use_map) {
                if (self._x != null)
                    projections_1.inplace.project_xy(self._x, self._y);
                if (self._xs != null)
                    projections_1.inplace.project_xsys(self._xs, self._ys);
            }
            for (const visual of this.visuals) {
                visual.update();
            }
        }
        _render() {
            if (!this._initial_set_data) {
                this.set_data(this.model.source);
                this._initial_set_data = true;
            }
            this.map_data();
            this.paint(this.layer.ctx);
        }
    }
    exports.DataAnnotationView = DataAnnotationView;
    DataAnnotationView.__name__ = "DataAnnotationView";
    class DataAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataAnnotation = DataAnnotation;
    _a = DataAnnotation;
    DataAnnotation.__name__ = "DataAnnotation";
    (() => {
        _a.define(({ Ref }) => ({
            source: [Ref(columnar_data_source_1.ColumnarDataSource), () => new column_data_source_1.ColumnDataSource()],
        }));
    })();
},
/* models/sources/columnar_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const logging_1 = require(18) /* ../../core/logging */;
    const selection_manager_1 = require(100) /* ../../core/selection_manager */;
    const signaling_1 = require(15) /* ../../core/signaling */;
    const array_1 = require(10) /* ../../core/util/array */;
    const ndarray_1 = require(29) /* ../../core/util/ndarray */;
    const object_1 = require(9) /* ../../core/util/object */;
    const types_1 = require(8) /* ../../core/util/types */;
    const interaction_policy_1 = require(102) /* ../selections/interaction_policy */;
    const selection_1 = require(101) /* ../selections/selection */;
    const data_source_1 = require(103) /* ./data_source */;
    class ColumnarDataSource extends data_source_1.DataSource {
        constructor(attrs) {
            super(attrs);
            this.selection_manager = new selection_manager_1.SelectionManager(this);
        }
        get_array(key) {
            let column = this.data[key];
            if (column == null)
                this.data[key] = column = [];
            else if (!(0, types_1.isArray)(column))
                this.data[key] = column = Array.from(column);
            return column;
        }
        initialize() {
            super.initialize();
            this._select = new signaling_1.Signal0(this, "select");
            this.inspect = new signaling_1.Signal(this, "inspect");
        }
        get_column(name) {
            return name in this.data ? this.data[name] : null;
        }
        columns() {
            // return the column names in this data source
            return (0, object_1.keys)(this.data);
        }
        get_length(soft = true) {
            const lengths = (0, array_1.uniq)((0, object_1.values)(this.data).map((v) => (0, ndarray_1.is_NDArray)(v) ? v.shape[0] : v.length));
            switch (lengths.length) {
                case 0: {
                    return null; // XXX: don't guess, treat on case-by-case basis
                }
                case 1: {
                    return lengths[0];
                }
                default: {
                    const msg = "data source has columns of inconsistent lengths";
                    if (soft) {
                        logging_1.logger.warn(msg);
                        return lengths.sort()[0];
                    }
                    else
                        throw new Error(msg);
                }
            }
        }
        get length() {
            var _b;
            return (_b = this.get_length()) !== null && _b !== void 0 ? _b : 0;
        }
        clear() {
            const empty = {};
            for (const col of this.columns()) {
                empty[col] = new this.data[col].constructor(0);
            }
            this.data = empty;
        }
    }
    exports.ColumnarDataSource = ColumnarDataSource;
    _a = ColumnarDataSource;
    ColumnarDataSource.__name__ = "ColumnarDataSource";
    (() => {
        _a.define(({ Ref }) => ({
            selection_policy: [Ref(interaction_policy_1.SelectionPolicy), () => new interaction_policy_1.UnionRenderers()],
        }));
        _a.internal(({ AnyRef }) => ({
            inspected: [AnyRef(), () => new selection_1.Selection()],
        }));
    })();
},
/* core/selection_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const selection_1 = require(101) /* ../models/selections/selection */;
    // XXX: this is needed to cut circular dependency between this, models/renderers/* and models/sources/*
    function is_GlyphRendererView(renderer_view) {
        return renderer_view.model.type == "GlyphRenderer";
    }
    function is_GraphRendererView(renderer_view) {
        return renderer_view.model.type == "GraphRenderer";
    }
    class SelectionManager {
        constructor(source) {
            this.source = source;
            this.inspectors = new Map();
        }
        select(renderer_views, geometry, final, mode = "replace") {
            // divide renderers into glyph_renderers or graph_renderers
            const glyph_renderer_views = [];
            const graph_renderer_views = [];
            for (const r of renderer_views) {
                if (is_GlyphRendererView(r))
                    glyph_renderer_views.push(r);
                else if (is_GraphRendererView(r))
                    graph_renderer_views.push(r);
            }
            let did_hit = false;
            // graph renderer case
            for (const r of graph_renderer_views) {
                const hit_test_result = r.model.selection_policy.hit_test(geometry, r);
                did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, mode);
            }
            // glyph renderers
            if (glyph_renderer_views.length > 0) {
                const hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
                did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, mode);
            }
            return did_hit;
        }
        inspect(renderer_view, geometry) {
            let did_hit = false;
            if (is_GlyphRendererView(renderer_view)) {
                const hit_test_result = renderer_view.hit_test(geometry);
                if (hit_test_result != null) {
                    did_hit = !hit_test_result.is_empty();
                    const inspection = this.get_or_create_inspector(renderer_view.model);
                    inspection.update(hit_test_result, true, "replace");
                    this.source.setv({ inspected: inspection }, { silent: true });
                    this.source.inspect.emit([renderer_view.model, { geometry }]);
                }
            }
            else if (is_GraphRendererView(renderer_view)) {
                const hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
                did_hit = renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, "replace");
            }
            return did_hit;
        }
        clear(rview) {
            this.source.selected.clear();
            if (rview != null)
                this.get_or_create_inspector(rview.model).clear();
        }
        get_or_create_inspector(renderer) {
            let selection = this.inspectors.get(renderer);
            if (selection == null) {
                selection = new selection_1.Selection();
                this.inspectors.set(renderer, selection);
            }
            return selection;
        }
    }
    exports.SelectionManager = SelectionManager;
    SelectionManager.__name__ = "SelectionManager";
},
/* models/selections/selection.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(51) /* ../../model */;
    const array_1 = require(10) /* ../../core/util/array */;
    const object_1 = require(9) /* ../../core/util/object */;
    class Selection extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        get_view() {
            return this.view;
        }
        get selected_glyph() {
            return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
        }
        add_to_selected_glyphs(glyph) {
            this.selected_glyphs.push(glyph);
        }
        update(selection, _final = true, mode = "replace") {
            switch (mode) {
                case "replace": {
                    this.indices = selection.indices;
                    this.line_indices = selection.line_indices;
                    this.multiline_indices = selection.multiline_indices;
                    this.image_indices = selection.image_indices;
                    this.view = selection.view;
                    this.selected_glyphs = selection.selected_glyphs;
                    break;
                }
                case "append": {
                    this.update_through_union(selection);
                    break;
                }
                case "intersect": {
                    this.update_through_intersection(selection);
                    break;
                }
                case "subtract": {
                    this.update_through_subtraction(selection);
                    break;
                }
            }
        }
        clear() {
            this.indices = [];
            this.line_indices = [];
            this.multiline_indices = {};
            this.image_indices = [];
            this.view = null;
            this.selected_glyphs = [];
        }
        map(mapper) {
            return new Selection(Object.assign(Object.assign({}, this.attributes), { indices: this.indices.map(mapper),
                // NOTE: line_indices don't support subset indexing
                multiline_indices: (0, object_1.to_object)((0, object_1.entries)(this.multiline_indices).map(([index, line_indices]) => [mapper(Number(index)), line_indices])), image_indices: this.image_indices.map((ndx) => (Object.assign(Object.assign({}, ndx), { index: mapper(ndx.index) }))) }));
        }
        is_empty() {
            return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
        }
        update_through_union(other) {
            this.indices = (0, array_1.union)(this.indices, other.indices);
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
        update_through_intersection(other) {
            this.indices = (0, array_1.intersection)(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
        update_through_subtraction(other) {
            this.indices = (0, array_1.difference)(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = (0, array_1.union)(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = (0, array_1.union)(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = (0, object_1.merge)(other.multiline_indices, this.multiline_indices);
        }
    }
    exports.Selection = Selection;
    _a = Selection;
    Selection.__name__ = "Selection";
    (() => {
        _a.define(({ Int, Array, Dict, Struct }) => ({
            indices: [Array(Int), []],
            line_indices: [Array(Int), []],
            multiline_indices: [Dict(Array(Int)), {}],
            image_indices: [Array(Struct({ index: Int, i: Int, j: Int, flat_index: Int })), []],
        }));
        _a.internal(({ Array, AnyRef, Nullable }) => ({
            selected_glyphs: [Array(AnyRef()), []],
            view: [Nullable(AnyRef()), null],
        }));
    })();
},
/* models/selections/interaction_policy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class SelectionPolicy extends model_1.Model {
        do_selection(hit_test_result, source, final, mode) {
            if (hit_test_result == null) {
                return false;
            }
            else {
                source.selected.update(hit_test_result, final, mode);
                source._select.emit();
                return !source.selected.is_empty();
            }
        }
    }
    exports.SelectionPolicy = SelectionPolicy;
    SelectionPolicy.__name__ = "SelectionPolicy";
    class IntersectRenderers extends SelectionPolicy {
        hit_test(geometry, renderer_views) {
            const hit_test_result_renderers = [];
            for (const r of renderer_views) {
                const result = r.hit_test(geometry);
                if (result != null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                const hit_test_result = hit_test_result_renderers[0];
                for (const hit_test_result_other of hit_test_result_renderers) {
                    hit_test_result.update_through_intersection(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        }
    }
    exports.IntersectRenderers = IntersectRenderers;
    IntersectRenderers.__name__ = "IntersectRenderers";
    class UnionRenderers extends SelectionPolicy {
        hit_test(geometry, renderer_views) {
            const hit_test_result_renderers = [];
            for (const r of renderer_views) {
                const result = r.hit_test(geometry);
                if (result != null)
                    hit_test_result_renderers.push(result);
            }
            if (hit_test_result_renderers.length > 0) {
                const hit_test_result = hit_test_result_renderers[0];
                for (const hit_test_result_other of hit_test_result_renderers) {
                    hit_test_result.update_through_union(hit_test_result_other);
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        }
    }
    exports.UnionRenderers = UnionRenderers;
    UnionRenderers.__name__ = "UnionRenderers";
},
/* models/sources/data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(51) /* ../../model */;
    const selection_1 = require(101) /* ../selections/selection */;
    class DataSource extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DataSource = DataSource;
    _a = DataSource;
    DataSource.__name__ = "DataSource";
    (() => {
        _a.define(({ Ref }) => ({
            selected: [Ref(selection_1.Selection), () => new selection_1.Selection()],
        }));
    })();
},
/* models/sources/column_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const columnar_data_source_1 = require(99) /* ./columnar_data_source */;
    class ColumnDataSource extends columnar_data_source_1.ColumnarDataSource {
        constructor(attrs) {
            super(attrs);
        }
        stream(new_data, rollover, { sync } = {}) {
            this.stream_to(this.properties.data, new_data, rollover, { sync });
        }
        patch(patches, { sync } = {}) {
            this.patch_to(this.properties.data, patches, { sync });
        }
    }
    exports.ColumnDataSource = ColumnDataSource;
    _a = ColumnDataSource;
    ColumnDataSource.__name__ = "ColumnDataSource";
    (() => {
        _a.define(({ Any, Dict, Arrayable }) => ({
            data: [Dict(Arrayable(Any)), {}],
        }));
    })();
},
/* core/util/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const core_1 = tslib_1.__importDefault(require(106) /* proj4/lib/core */);
    const Proj_1 = tslib_1.__importDefault(require(107) /* proj4/lib/Proj */);
    const types_1 = require(23) /* ../types */;
    const mercator = new Proj_1.default("GOOGLE");
    const wgs84 = new Proj_1.default("WGS84");
    const _wgs84_mercator = (0, core_1.default)(wgs84, mercator);
    exports.wgs84_mercator = {
        compute(x, y) {
            if (isFinite(x) && isFinite(y))
                return _wgs84_mercator.forward([x, y]);
            else
                return [NaN, NaN];
        },
        invert(merc_x, merc_y) {
            if (isFinite(merc_x) && isFinite(merc_y))
                return _wgs84_mercator.inverse([merc_x, merc_y]);
            else
                return [NaN, NaN];
        },
    };
    const mercator_bounds = {
        lon: [-20026376.39, 20026376.39],
        lat: [-20048966.10, 20048966.10],
    };
    const latlon_bounds = {
        lon: [-180, 180],
        lat: [-85.06, 85.06],
    };
    const { min, max } = Math;
    function clip_mercator(low, high, dimension) {
        const [vmin, vmax] = mercator_bounds[dimension];
        return [max(low, vmin), min(high, vmax)];
    }
    exports.clip_mercator = clip_mercator;
    function in_bounds(value, dimension) {
        const [min, max] = latlon_bounds[dimension];
        return min < value && value < max;
    }
    exports.in_bounds = in_bounds;
    (function (inplace) {
        function project_xy(x, y, merc_x, merc_y) {
            const n = min(x.length, y.length);
            merc_x = merc_x !== null && merc_x !== void 0 ? merc_x : x;
            merc_y = merc_y !== null && merc_y !== void 0 ? merc_y : y;
            for (let i = 0; i < n; i++) {
                const xi = x[i];
                const yi = y[i];
                const [merc_xi, merc_yi] = exports.wgs84_mercator.compute(xi, yi);
                merc_x[i] = merc_xi;
                merc_y[i] = merc_yi;
            }
        }
        inplace.project_xy = project_xy;
        function project_xsys(xs, ys, merc_xs, merc_ys) {
            const n = min(xs.length, ys.length);
            merc_xs = merc_xs !== null && merc_xs !== void 0 ? merc_xs : xs;
            merc_ys = merc_ys !== null && merc_ys !== void 0 ? merc_ys : ys;
            for (let i = 0; i < n; i++) {
                project_xy(xs[i], ys[i], merc_xs[i], merc_ys[i]);
            }
        }
        inplace.project_xsys = project_xsys;
    })(exports.inplace || (exports.inplace = {}));
    function project_xy(x, y) {
        const n = min(x.length, y.length);
        const ArrayType = (0, types_1.infer_type)(x, y);
        const merc_x = new ArrayType(n);
        const merc_y = new ArrayType(n);
        exports.inplace.project_xy(x, y, merc_x, merc_y);
        return [merc_x, merc_y];
    }
    exports.project_xy = project_xy;
    function project_xsys(xs, ys) {
        const n = min(xs.length, ys.length);
        const merc_xs = new Array(n);
        const merc_ys = new Array(n);
        for (let i = 0; i < n; i++) {
            const [merc_x, merc_y] = project_xy(xs[i], ys[i]);
            merc_xs[i] = merc_x;
            merc_ys[i] = merc_y;
        }
        return [merc_xs, merc_ys];
    }
    exports.project_xsys = project_xsys;
},
/* proj4/lib/core.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const Proj_1 = tslib_1.__importDefault(require(107) /* ./Proj */);
    const transform_1 = tslib_1.__importDefault(require(133) /* ./transform */);
    var wgs84 = (0, Proj_1.default)('WGS84');
    function transformer(from, to, coords, enforceAxis) {
        var transformedArray, out, keys;
        if (Array.isArray(coords)) {
            transformedArray = (0, transform_1.default)(from, to, coords, enforceAxis) || { x: NaN, y: NaN };
            if (coords.length > 2) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (typeof transformedArray.z === 'number') {
                        return [transformedArray.x, transformedArray.y, transformedArray.z].concat(coords.splice(3));
                    }
                    else {
                        return [transformedArray.x, transformedArray.y, coords[2]].concat(coords.splice(3));
                    }
                }
                else {
                    return [transformedArray.x, transformedArray.y].concat(coords.splice(2));
                }
            }
            else {
                return [transformedArray.x, transformedArray.y];
            }
        }
        else {
            out = (0, transform_1.default)(from, to, coords, enforceAxis);
            keys = Object.keys(coords);
            if (keys.length === 2) {
                return out;
            }
            keys.forEach(function (key) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (key === 'x' || key === 'y' || key === 'z') {
                        return;
                    }
                }
                else {
                    if (key === 'x' || key === 'y') {
                        return;
                    }
                }
                out[key] = coords[key];
            });
            return out;
        }
    }
    function checkProj(item) {
        if (item instanceof Proj_1.default) {
            return item;
        }
        if (item.oProj) {
            return item.oProj;
        }
        return (0, Proj_1.default)(item);
    }
    function proj4(fromProj, toProj, coord) {
        fromProj = checkProj(fromProj);
        var single = false;
        var obj;
        if (typeof toProj === 'undefined') {
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        else if (typeof toProj.x !== 'undefined' || Array.isArray(toProj)) {
            coord = toProj;
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        toProj = checkProj(toProj);
        if (coord) {
            return transformer(fromProj, toProj, coord);
        }
        else {
            obj = {
                forward: function (coords, enforceAxis) {
                    return transformer(fromProj, toProj, coords, enforceAxis);
                },
                inverse: function (coords, enforceAxis) {
                    return transformer(toProj, fromProj, coords, enforceAxis);
                }
            };
            if (single) {
                obj.oProj = toProj;
            }
            return obj;
        }
    }
    exports.default = proj4;
},
/* proj4/lib/Proj.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const parseCode_1 = tslib_1.__importDefault(require(108) /* ./parseCode */);
    const extend_1 = tslib_1.__importDefault(require(119) /* ./extend */);
    const projections_1 = tslib_1.__importDefault(require(120) /* ./projections */);
    const deriveConstants_1 = require(128) /* ./deriveConstants */;
    const Datum_1 = tslib_1.__importDefault(require(130) /* ./constants/Datum */);
    const datum_1 = tslib_1.__importDefault(require(131) /* ./datum */);
    const match_1 = tslib_1.__importDefault(require(115) /* ./match */);
    const nadgrid_1 = require(132) /* ./nadgrid */;
    function Projection(srsCode, callback) {
        if (!(this instanceof Projection)) {
            return new Projection(srsCode);
        }
        callback = callback || function (error) {
            if (error) {
                throw error;
            }
        };
        var json = (0, parseCode_1.default)(srsCode);
        if (typeof json !== 'object') {
            callback(srsCode);
            return;
        }
        var ourProj = Projection.projections.get(json.projName);
        if (!ourProj) {
            callback(srsCode);
            return;
        }
        if (json.datumCode && json.datumCode !== 'none') {
            var datumDef = (0, match_1.default)(Datum_1.default, json.datumCode);
            if (datumDef) {
                json.datum_params = json.datum_params || (datumDef.towgs84 ? datumDef.towgs84.split(',') : null);
                json.ellps = datumDef.ellipse;
                json.datumName = datumDef.datumName ? datumDef.datumName : json.datumCode;
            }
        }
        json.k0 = json.k0 || 1.0;
        json.axis = json.axis || 'enu';
        json.ellps = json.ellps || 'wgs84';
        json.lat1 = json.lat1 || json.lat0; // Lambert_Conformal_Conic_1SP, for example, needs this
        var sphere_ = (0, deriveConstants_1.sphere)(json.a, json.b, json.rf, json.ellps, json.sphere);
        var ecc = (0, deriveConstants_1.eccentricity)(sphere_.a, sphere_.b, sphere_.rf, json.R_A);
        var nadgrids = (0, nadgrid_1.getNadgrids)(json.nadgrids);
        var datumObj = json.datum || (0, datum_1.default)(json.datumCode, json.datum_params, sphere_.a, sphere_.b, ecc.es, ecc.ep2, nadgrids);
        (0, extend_1.default)(this, json); // transfer everything over from the projection because we don't know what we'll need
        (0, extend_1.default)(this, ourProj); // transfer all the methods from the projection
        // copy the 4 things over we calculated in deriveConstants.sphere
        this.a = sphere_.a;
        this.b = sphere_.b;
        this.rf = sphere_.rf;
        this.sphere = sphere_.sphere;
        // copy the 3 things we calculated in deriveConstants.eccentricity
        this.es = ecc.es;
        this.e = ecc.e;
        this.ep2 = ecc.ep2;
        // add in the datum object
        this.datum = datumObj;
        // init the projection
        this.init();
        // legecy callback from back in the day when it went to spatialreference.org
        callback(null, this);
    }
    Projection.projections = projections_1.default;
    Projection.projections.start();
    exports.default = Projection;
},
/* proj4/lib/parseCode.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const defs_1 = tslib_1.__importDefault(require(109) /* ./defs */);
    const wkt_parser_1 = tslib_1.__importDefault(require(116) /* wkt-parser */);
    const projString_1 = tslib_1.__importDefault(require(111) /* ./projString */);
    const match_1 = tslib_1.__importDefault(require(115) /* ./match */);
    function testObj(code) {
        return typeof code === 'string';
    }
    function testDef(code) {
        return code in defs_1.default;
    }
    var codeWords = ['PROJECTEDCRS', 'PROJCRS', 'GEOGCS', 'GEOCCS', 'PROJCS', 'LOCAL_CS', 'GEODCRS', 'GEODETICCRS', 'GEODETICDATUM', 'ENGCRS', 'ENGINEERINGCRS'];
    function testWKT(code) {
        return codeWords.some(function (word) {
            return code.indexOf(word) > -1;
        });
    }
    var codes = ['3857', '900913', '3785', '102113'];
    function checkMercator(item) {
        var auth = (0, match_1.default)(item, 'authority');
        if (!auth) {
            return;
        }
        var code = (0, match_1.default)(auth, 'epsg');
        return code && codes.indexOf(code) > -1;
    }
    function checkProjStr(item) {
        var ext = (0, match_1.default)(item, 'extension');
        if (!ext) {
            return;
        }
        return (0, match_1.default)(ext, 'proj4');
    }
    function testProj(code) {
        return code[0] === '+';
    }
    function parse(code) {
        if (testObj(code)) {
            //check to see if this is a WKT string
            if (testDef(code)) {
                return defs_1.default[code];
            }
            if (testWKT(code)) {
                var out = (0, wkt_parser_1.default)(code);
                // test of spetial case, due to this being a very common and often malformed
                if (checkMercator(out)) {
                    return defs_1.default['EPSG:3857'];
                }
                var maybeProjStr = checkProjStr(out);
                if (maybeProjStr) {
                    return (0, projString_1.default)(maybeProjStr);
                }
                return out;
            }
            if (testProj(code)) {
                return (0, projString_1.default)(code);
            }
        }
        else {
            return code;
        }
    }
    exports.default = parse;
},
/* proj4/lib/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const global_1 = tslib_1.__importDefault(require(110) /* ./global */);
    const projString_1 = tslib_1.__importDefault(require(111) /* ./projString */);
    const wkt_parser_1 = tslib_1.__importDefault(require(116) /* wkt-parser */);
    function defs(name) {
        /*global console*/
        var that = this;
        if (arguments.length === 2) {
            var def = arguments[1];
            if (typeof def === 'string') {
                if (def.charAt(0) === '+') {
                    defs[name] = (0, projString_1.default)(arguments[1]);
                }
                else {
                    defs[name] = (0, wkt_parser_1.default)(arguments[1]);
                }
            }
            else {
                defs[name] = def;
            }
        }
        else if (arguments.length === 1) {
            if (Array.isArray(name)) {
                return name.map(function (v) {
                    if (Array.isArray(v)) {
                        defs.apply(that, v);
                    }
                    else {
                        defs(v);
                    }
                });
            }
            else if (typeof name === 'string') {
                if (name in defs) {
                    return defs[name];
                }
            }
            else if ('EPSG' in name) {
                defs['EPSG:' + name.EPSG] = name;
            }
            else if ('ESRI' in name) {
                defs['ESRI:' + name.ESRI] = name;
            }
            else if ('IAU2000' in name) {
                defs['IAU2000:' + name.IAU2000] = name;
            }
            else {
                console.log(name);
            }
            return;
        }
    }
    (0, global_1.default)(defs);
    exports.default = defs;
},
/* proj4/lib/global.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(defs) {
        defs('EPSG:4326', "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        defs('EPSG:4269', "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees");
        defs('EPSG:3857', "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");
        defs.WGS84 = defs['EPSG:4326'];
        defs['EPSG:3785'] = defs['EPSG:3857']; // maintain backward compat, official code is 3857
        defs.GOOGLE = defs['EPSG:3857'];
        defs['EPSG:900913'] = defs['EPSG:3857'];
        defs['EPSG:102113'] = defs['EPSG:3857'];
    }
    exports.default = default_1;
},
/* proj4/lib/projString.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(112) /* ./constants/values */;
    const PrimeMeridian_1 = tslib_1.__importDefault(require(113) /* ./constants/PrimeMeridian */);
    const units_1 = tslib_1.__importDefault(require(114) /* ./constants/units */);
    const match_1 = tslib_1.__importDefault(require(115) /* ./match */);
    function default_1(defData) {
        var self = {};
        var paramObj = defData.split('+').map(function (v) {
            return v.trim();
        }).filter(function (a) {
            return a;
        }).reduce(function (p, a) {
            var split = a.split('=');
            split.push(true);
            p[split[0].toLowerCase()] = split[1];
            return p;
        }, {});
        var paramName, paramVal, paramOutname;
        var params = {
            proj: 'projName',
            datum: 'datumCode',
            rf: function (v) {
                self.rf = parseFloat(v);
            },
            lat_0: function (v) {
                self.lat0 = v * values_1.D2R;
            },
            lat_1: function (v) {
                self.lat1 = v * values_1.D2R;
            },
            lat_2: function (v) {
                self.lat2 = v * values_1.D2R;
            },
            lat_ts: function (v) {
                self.lat_ts = v * values_1.D2R;
            },
            lon_0: function (v) {
                self.long0 = v * values_1.D2R;
            },
            lon_1: function (v) {
                self.long1 = v * values_1.D2R;
            },
            lon_2: function (v) {
                self.long2 = v * values_1.D2R;
            },
            alpha: function (v) {
                self.alpha = parseFloat(v) * values_1.D2R;
            },
            gamma: function (v) {
                self.rectified_grid_angle = parseFloat(v);
            },
            lonc: function (v) {
                self.longc = v * values_1.D2R;
            },
            x_0: function (v) {
                self.x0 = parseFloat(v);
            },
            y_0: function (v) {
                self.y0 = parseFloat(v);
            },
            k_0: function (v) {
                self.k0 = parseFloat(v);
            },
            k: function (v) {
                self.k0 = parseFloat(v);
            },
            a: function (v) {
                self.a = parseFloat(v);
            },
            b: function (v) {
                self.b = parseFloat(v);
            },
            r_a: function () {
                self.R_A = true;
            },
            zone: function (v) {
                self.zone = parseInt(v, 10);
            },
            south: function () {
                self.utmSouth = true;
            },
            towgs84: function (v) {
                self.datum_params = v.split(",").map(function (a) {
                    return parseFloat(a);
                });
            },
            to_meter: function (v) {
                self.to_meter = parseFloat(v);
            },
            units: function (v) {
                self.units = v;
                var unit = (0, match_1.default)(units_1.default, v);
                if (unit) {
                    self.to_meter = unit.to_meter;
                }
            },
            from_greenwich: function (v) {
                self.from_greenwich = v * values_1.D2R;
            },
            pm: function (v) {
                var pm = (0, match_1.default)(PrimeMeridian_1.default, v);
                self.from_greenwich = (pm ? pm : parseFloat(v)) * values_1.D2R;
            },
            nadgrids: function (v) {
                if (v === '@null') {
                    self.datumCode = 'none';
                }
                else {
                    self.nadgrids = v;
                }
            },
            axis: function (v) {
                var legalAxis = "ewnsud";
                if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
                    self.axis = v;
                }
            },
            approx: function () {
                self.approx = true;
            }
        };
        for (paramName in paramObj) {
            paramVal = paramObj[paramName];
            if (paramName in params) {
                paramOutname = params[paramName];
                if (typeof paramOutname === 'function') {
                    paramOutname(paramVal);
                }
                else {
                    self[paramOutname] = paramVal;
                }
            }
            else {
                self[paramName] = paramVal;
            }
        }
        if (typeof self.datumCode === 'string' && self.datumCode !== "WGS84") {
            self.datumCode = self.datumCode.toLowerCase();
        }
        return self;
    }
    exports.default = default_1;
},
/* proj4/lib/constants/values.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.PJD_3PARAM = 1;
    exports.PJD_7PARAM = 2;
    exports.PJD_GRIDSHIFT = 3;
    exports.PJD_WGS84 = 4; // WGS84 or equivalent
    exports.PJD_NODATUM = 5; // WGS84 or equivalent
    exports.SRS_WGS84_SEMIMAJOR = 6378137.0; // only used in grid shift transforms
    exports.SRS_WGS84_SEMIMINOR = 6356752.314; // only used in grid shift transforms
    exports.SRS_WGS84_ESQUARED = 0.0066943799901413165; // only used in grid shift transforms
    exports.SEC_TO_RAD = 4.84813681109535993589914102357e-6;
    exports.HALF_PI = Math.PI / 2;
    // ellipoid pj_set_ell.c
    exports.SIXTH = 0.1666666666666666667;
    /* 1/6 */
    exports.RA4 = 0.04722222222222222222;
    /* 17/360 */
    exports.RA6 = 0.02215608465608465608;
    exports.EPSLN = 1.0e-10;
    // you'd think you could use Number.EPSILON above but that makes
    // Mollweide get into an infinate loop.
    exports.D2R = 0.01745329251994329577;
    exports.R2D = 57.29577951308232088;
    exports.FORTPI = Math.PI / 4;
    exports.TWO_PI = Math.PI * 2;
    // SPI is slightly greater than Math.PI, so values that exceed the -180..180
    // degree range by a tiny amount don't get wrapped. This prevents points that
    // have drifted from their original location along the 180th meridian (due to
    // floating point error) from changing their sign.
    exports.SPI = 3.14159265359;
},
/* proj4/lib/constants/PrimeMeridian.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.greenwich = 0.0; //"0dE",
    exports$1.lisbon = -9.131906111111; //"9d07'54.862\"W",
    exports$1.paris = 2.337229166667; //"2d20'14.025\"E",
    exports$1.bogota = -74.080916666667; //"74d04'51.3\"W",
    exports$1.madrid = -3.687938888889; //"3d41'16.58\"W",
    exports$1.rome = 12.452333333333; //"12d27'8.4\"E",
    exports$1.bern = 7.439583333333; //"7d26'22.5\"E",
    exports$1.jakarta = 106.807719444444; //"106d48'27.79\"E",
    exports$1.ferro = -17.666666666667; //"17d40'W",
    exports$1.brussels = 4.367975; //"4d22'4.71\"E",
    exports$1.stockholm = 18.058277777778; //"18d3'29.8\"E",
    exports$1.athens = 23.7163375; //"23d42'58.815\"E",
    exports$1.oslo = 10.722916666667; //"10d43'22.5\"E"
},
/* proj4/lib/constants/units.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = {
        ft: { to_meter: 0.3048 },
        'us-ft': { to_meter: 1200 / 3937 }
    };
},
/* proj4/lib/match.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var ignoredChar = /[\s_\-\/\(\)]/g;
    function match(obj, key) {
        if (obj[key]) {
            return obj[key];
        }
        var keys = Object.keys(obj);
        var lkey = key.toLowerCase().replace(ignoredChar, '');
        var i = -1;
        var testkey, processedKey;
        while (++i < keys.length) {
            testkey = keys[i];
            processedKey = testkey.toLowerCase().replace(ignoredChar, '');
            if (processedKey === lkey) {
                return obj[testkey];
            }
        }
    }
    exports.default = match;
},
/* wkt-parser/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var D2R = 0.01745329251994329577;
    const parser_1 = tslib_1.__importDefault(require(117) /* ./parser */);
    const process_1 = require(118) /* ./process */;
    function rename(obj, params) {
        var outName = params[0];
        var inName = params[1];
        if (!(outName in obj) && (inName in obj)) {
            obj[outName] = obj[inName];
            if (params.length === 3) {
                obj[outName] = params[2](obj[outName]);
            }
        }
    }
    function d2r(input) {
        return input * D2R;
    }
    function cleanWKT(wkt) {
        if (wkt.type === 'GEOGCS') {
            wkt.projName = 'longlat';
        }
        else if (wkt.type === 'LOCAL_CS') {
            wkt.projName = 'identity';
            wkt.local = true;
        }
        else {
            if (typeof wkt.PROJECTION === 'object') {
                wkt.projName = Object.keys(wkt.PROJECTION)[0];
            }
            else {
                wkt.projName = wkt.PROJECTION;
            }
        }
        if (wkt.AXIS) {
            var axisOrder = '';
            for (var i = 0, ii = wkt.AXIS.length; i < ii; ++i) {
                var axis = [wkt.AXIS[i][0].toLowerCase(), wkt.AXIS[i][1].toLowerCase()];
                if (axis[0].indexOf('north') !== -1 || ((axis[0] === 'y' || axis[0] === 'lat') && axis[1] === 'north')) {
                    axisOrder += 'n';
                }
                else if (axis[0].indexOf('south') !== -1 || ((axis[0] === 'y' || axis[0] === 'lat') && axis[1] === 'south')) {
                    axisOrder += 's';
                }
                else if (axis[0].indexOf('east') !== -1 || ((axis[0] === 'x' || axis[0] === 'lon') && axis[1] === 'east')) {
                    axisOrder += 'e';
                }
                else if (axis[0].indexOf('west') !== -1 || ((axis[0] === 'x' || axis[0] === 'lon') && axis[1] === 'west')) {
                    axisOrder += 'w';
                }
            }
            if (axisOrder.length === 2) {
                axisOrder += 'u';
            }
            if (axisOrder.length === 3) {
                wkt.axis = axisOrder;
            }
        }
        if (wkt.UNIT) {
            wkt.units = wkt.UNIT.name.toLowerCase();
            if (wkt.units === 'metre') {
                wkt.units = 'meter';
            }
            if (wkt.UNIT.convert) {
                if (wkt.type === 'GEOGCS') {
                    if (wkt.DATUM && wkt.DATUM.SPHEROID) {
                        wkt.to_meter = wkt.UNIT.convert * wkt.DATUM.SPHEROID.a;
                    }
                }
                else {
                    wkt.to_meter = wkt.UNIT.convert;
                }
            }
        }
        var geogcs = wkt.GEOGCS;
        if (wkt.type === 'GEOGCS') {
            geogcs = wkt;
        }
        if (geogcs) {
            //if(wkt.GEOGCS.PRIMEM&&wkt.GEOGCS.PRIMEM.convert){
            //  wkt.from_greenwich=wkt.GEOGCS.PRIMEM.convert*D2R;
            //}
            if (geogcs.DATUM) {
                wkt.datumCode = geogcs.DATUM.name.toLowerCase();
            }
            else {
                wkt.datumCode = geogcs.name.toLowerCase();
            }
            if (wkt.datumCode.slice(0, 2) === 'd_') {
                wkt.datumCode = wkt.datumCode.slice(2);
            }
            if (wkt.datumCode === 'new_zealand_geodetic_datum_1949' || wkt.datumCode === 'new_zealand_1949') {
                wkt.datumCode = 'nzgd49';
            }
            if (wkt.datumCode === 'wgs_1984' || wkt.datumCode === 'world_geodetic_system_1984') {
                if (wkt.PROJECTION === 'Mercator_Auxiliary_Sphere') {
                    wkt.sphere = true;
                }
                wkt.datumCode = 'wgs84';
            }
            if (wkt.datumCode.slice(-6) === '_ferro') {
                wkt.datumCode = wkt.datumCode.slice(0, -6);
            }
            if (wkt.datumCode.slice(-8) === '_jakarta') {
                wkt.datumCode = wkt.datumCode.slice(0, -8);
            }
            if (~wkt.datumCode.indexOf('belge')) {
                wkt.datumCode = 'rnb72';
            }
            if (geogcs.DATUM && geogcs.DATUM.SPHEROID) {
                wkt.ellps = geogcs.DATUM.SPHEROID.name.replace('_19', '').replace(/[Cc]larke\_18/, 'clrk');
                if (wkt.ellps.toLowerCase().slice(0, 13) === 'international') {
                    wkt.ellps = 'intl';
                }
                wkt.a = geogcs.DATUM.SPHEROID.a;
                wkt.rf = parseFloat(geogcs.DATUM.SPHEROID.rf, 10);
            }
            if (geogcs.DATUM && geogcs.DATUM.TOWGS84) {
                wkt.datum_params = geogcs.DATUM.TOWGS84;
            }
            if (~wkt.datumCode.indexOf('osgb_1936')) {
                wkt.datumCode = 'osgb36';
            }
            if (~wkt.datumCode.indexOf('osni_1952')) {
                wkt.datumCode = 'osni52';
            }
            if (~wkt.datumCode.indexOf('tm65')
                || ~wkt.datumCode.indexOf('geodetic_datum_of_1965')) {
                wkt.datumCode = 'ire65';
            }
            if (wkt.datumCode === 'ch1903+') {
                wkt.datumCode = 'ch1903';
            }
            if (~wkt.datumCode.indexOf('israel')) {
                wkt.datumCode = 'isr93';
            }
        }
        if (wkt.b && !isFinite(wkt.b)) {
            wkt.b = wkt.a;
        }
        function toMeter(input) {
            var ratio = wkt.to_meter || 1;
            return input * ratio;
        }
        var renamer = function (a) {
            return rename(wkt, a);
        };
        var list = [
            ['standard_parallel_1', 'Standard_Parallel_1'],
            ['standard_parallel_1', 'Latitude of 1st standard parallel'],
            ['standard_parallel_2', 'Standard_Parallel_2'],
            ['standard_parallel_2', 'Latitude of 2nd standard parallel'],
            ['false_easting', 'False_Easting'],
            ['false_easting', 'False easting'],
            ['false-easting', 'Easting at false origin'],
            ['false_northing', 'False_Northing'],
            ['false_northing', 'False northing'],
            ['false_northing', 'Northing at false origin'],
            ['central_meridian', 'Central_Meridian'],
            ['central_meridian', 'Longitude of natural origin'],
            ['central_meridian', 'Longitude of false origin'],
            ['latitude_of_origin', 'Latitude_Of_Origin'],
            ['latitude_of_origin', 'Central_Parallel'],
            ['latitude_of_origin', 'Latitude of natural origin'],
            ['latitude_of_origin', 'Latitude of false origin'],
            ['scale_factor', 'Scale_Factor'],
            ['k0', 'scale_factor'],
            ['latitude_of_center', 'Latitude_Of_Center'],
            ['latitude_of_center', 'Latitude_of_center'],
            ['lat0', 'latitude_of_center', d2r],
            ['longitude_of_center', 'Longitude_Of_Center'],
            ['longitude_of_center', 'Longitude_of_center'],
            ['longc', 'longitude_of_center', d2r],
            ['x0', 'false_easting', toMeter],
            ['y0', 'false_northing', toMeter],
            ['long0', 'central_meridian', d2r],
            ['lat0', 'latitude_of_origin', d2r],
            ['lat0', 'standard_parallel_1', d2r],
            ['lat1', 'standard_parallel_1', d2r],
            ['lat2', 'standard_parallel_2', d2r],
            ['azimuth', 'Azimuth'],
            ['alpha', 'azimuth', d2r],
            ['srsCode', 'name']
        ];
        list.forEach(renamer);
        if (!wkt.long0 && wkt.longc && (wkt.projName === 'Albers_Conic_Equal_Area' || wkt.projName === 'Lambert_Azimuthal_Equal_Area')) {
            wkt.long0 = wkt.longc;
        }
        if (!wkt.lat_ts && wkt.lat1 && (wkt.projName === 'Stereographic_South_Pole' || wkt.projName === 'Polar Stereographic (variant B)')) {
            wkt.lat0 = d2r(wkt.lat1 > 0 ? 90 : -90);
            wkt.lat_ts = wkt.lat1;
        }
    }
    function default_1(wkt) {
        var lisp = (0, parser_1.default)(wkt);
        var type = lisp.shift();
        var name = lisp.shift();
        lisp.unshift(['name', name]);
        lisp.unshift(['type', type]);
        var obj = {};
        (0, process_1.sExpr)(lisp, obj);
        cleanWKT(obj);
        return obj;
    }
    exports.default = default_1;
},
/* wkt-parser/parser.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = parseString;
    var NEUTRAL = 1;
    var KEYWORD = 2;
    var NUMBER = 3;
    var QUOTED = 4;
    var AFTERQUOTE = 5;
    var ENDED = -1;
    var whitespace = /\s/;
    var latin = /[A-Za-z]/;
    var keyword = /[A-Za-z84_]/;
    var endThings = /[,\]]/;
    var digets = /[\d\.E\-\+]/;
    // const ignoredChar = /[\s_\-\/\(\)]/g;
    function Parser(text) {
        if (typeof text !== 'string') {
            throw new Error('not a string');
        }
        this.text = text.trim();
        this.level = 0;
        this.place = 0;
        this.root = null;
        this.stack = [];
        this.currentObject = null;
        this.state = NEUTRAL;
    }
    Parser.prototype.readCharicter = function () {
        var char = this.text[this.place++];
        if (this.state !== QUOTED) {
            while (whitespace.test(char)) {
                if (this.place >= this.text.length) {
                    return;
                }
                char = this.text[this.place++];
            }
        }
        switch (this.state) {
            case NEUTRAL:
                return this.neutral(char);
            case KEYWORD:
                return this.keyword(char);
            case QUOTED:
                return this.quoted(char);
            case AFTERQUOTE:
                return this.afterquote(char);
            case NUMBER:
                return this.number(char);
            case ENDED:
                return;
        }
    };
    Parser.prototype.afterquote = function (char) {
        if (char === '"') {
            this.word += '"';
            this.state = QUOTED;
            return;
        }
        if (endThings.test(char)) {
            this.word = this.word.trim();
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in afterquote yet, index ' + this.place);
    };
    Parser.prototype.afterItem = function (char) {
        if (char === ',') {
            if (this.word !== null) {
                this.currentObject.push(this.word);
            }
            this.word = null;
            this.state = NEUTRAL;
            return;
        }
        if (char === ']') {
            this.level--;
            if (this.word !== null) {
                this.currentObject.push(this.word);
                this.word = null;
            }
            this.state = NEUTRAL;
            this.currentObject = this.stack.pop();
            if (!this.currentObject) {
                this.state = ENDED;
            }
            return;
        }
    };
    Parser.prototype.number = function (char) {
        if (digets.test(char)) {
            this.word += char;
            return;
        }
        if (endThings.test(char)) {
            this.word = parseFloat(this.word);
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in number yet, index ' + this.place);
    };
    Parser.prototype.quoted = function (char) {
        if (char === '"') {
            this.state = AFTERQUOTE;
            return;
        }
        this.word += char;
        return;
    };
    Parser.prototype.keyword = function (char) {
        if (keyword.test(char)) {
            this.word += char;
            return;
        }
        if (char === '[') {
            var newObjects = [];
            newObjects.push(this.word);
            this.level++;
            if (this.root === null) {
                this.root = newObjects;
            }
            else {
                this.currentObject.push(newObjects);
            }
            this.stack.push(this.currentObject);
            this.currentObject = newObjects;
            this.state = NEUTRAL;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in keyword yet, index ' + this.place);
    };
    Parser.prototype.neutral = function (char) {
        if (latin.test(char)) {
            this.word = char;
            this.state = KEYWORD;
            return;
        }
        if (char === '"') {
            this.word = '';
            this.state = QUOTED;
            return;
        }
        if (digets.test(char)) {
            this.word = char;
            this.state = NUMBER;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in neutral yet, index ' + this.place);
    };
    Parser.prototype.output = function () {
        while (this.place < this.text.length) {
            this.readCharicter();
        }
        if (this.state === ENDED) {
            return this.root;
        }
        throw new Error('unable to parse string "' + this.text + '". State is ' + this.state);
    };
    function parseString(txt) {
        var parser = new Parser(txt);
        return parser.output();
    }
},
/* wkt-parser/process.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function mapit(obj, key, value) {
        if (Array.isArray(key)) {
            value.unshift(key);
            key = null;
        }
        var thing = key ? {} : obj;
        var out = value.reduce(function (newObj, item) {
            sExpr(item, newObj);
            return newObj;
        }, thing);
        if (key) {
            obj[key] = out;
        }
    }
    function sExpr(v, obj) {
        if (!Array.isArray(v)) {
            obj[v] = true;
            return;
        }
        var key = v.shift();
        if (key === 'PARAMETER') {
            key = v.shift();
        }
        if (v.length === 1) {
            if (Array.isArray(v[0])) {
                obj[key] = {};
                sExpr(v[0], obj[key]);
                return;
            }
            obj[key] = v[0];
            return;
        }
        if (!v.length) {
            obj[key] = true;
            return;
        }
        if (key === 'TOWGS84') {
            obj[key] = v;
            return;
        }
        if (key === 'AXIS') {
            if (!(key in obj)) {
                obj[key] = [];
            }
            obj[key].push(v);
            return;
        }
        if (!Array.isArray(key)) {
            obj[key] = {};
        }
        var i;
        switch (key) {
            case 'UNIT':
            case 'PRIMEM':
            case 'VERT_DATUM':
                obj[key] = {
                    name: v[0].toLowerCase(),
                    convert: v[1]
                };
                if (v.length === 3) {
                    sExpr(v[2], obj[key]);
                }
                return;
            case 'SPHEROID':
            case 'ELLIPSOID':
                obj[key] = {
                    name: v[0],
                    a: v[1],
                    rf: v[2]
                };
                if (v.length === 4) {
                    sExpr(v[3], obj[key]);
                }
                return;
            case 'PROJECTEDCRS':
            case 'PROJCRS':
            case 'GEOGCS':
            case 'GEOCCS':
            case 'PROJCS':
            case 'LOCAL_CS':
            case 'GEODCRS':
            case 'GEODETICCRS':
            case 'GEODETICDATUM':
            case 'EDATUM':
            case 'ENGINEERINGDATUM':
            case 'VERT_CS':
            case 'VERTCRS':
            case 'VERTICALCRS':
            case 'COMPD_CS':
            case 'COMPOUNDCRS':
            case 'ENGINEERINGCRS':
            case 'ENGCRS':
            case 'FITTED_CS':
            case 'LOCAL_DATUM':
            case 'DATUM':
                v[0] = ['name', v[0]];
                mapit(obj, key, v);
                return;
            default:
                i = -1;
                while (++i < v.length) {
                    if (!Array.isArray(v[i])) {
                        return sExpr(v, obj[key]);
                    }
                }
                return mapit(obj, key, v);
        }
    }
    exports.sExpr = sExpr;
},
/* proj4/lib/extend.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(destination, source) {
        destination = destination || {};
        var value, property;
        if (!source) {
            return destination;
        }
        for (property in source) {
            value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }
        return destination;
    }
    exports.default = default_1;
},
/* proj4/lib/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const merc_1 = tslib_1.__importDefault(require(121) /* ./projections/merc */);
    const longlat_1 = tslib_1.__importDefault(require(127) /* ./projections/longlat */);
    var projs = [merc_1.default, longlat_1.default];
    var names = {};
    var projStore = [];
    function add(proj, i) {
        var len = projStore.length;
        if (!proj.names) {
            console.log(i);
            return true;
        }
        projStore[len] = proj;
        proj.names.forEach(function (n) {
            names[n.toLowerCase()] = len;
        });
        return this;
    }
    exports.add = add;
    function get(name) {
        if (!name) {
            return false;
        }
        var n = name.toLowerCase();
        if (typeof names[n] !== 'undefined' && projStore[names[n]]) {
            return projStore[names[n]];
        }
    }
    exports.get = get;
    function start() {
        projs.forEach(add);
    }
    exports.start = start;
    exports.default = {
        start: start,
        add: add,
        get: get
    };
},
/* proj4/lib/projections/merc.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const msfnz_1 = tslib_1.__importDefault(require(122) /* ../common/msfnz */);
    const adjust_lon_1 = tslib_1.__importDefault(require(123) /* ../common/adjust_lon */);
    const tsfnz_1 = tslib_1.__importDefault(require(125) /* ../common/tsfnz */);
    const phi2z_1 = tslib_1.__importDefault(require(126) /* ../common/phi2z */);
    const values_1 = require(112) /* ../constants/values */;
    function init() {
        var con = this.b / this.a;
        this.es = 1 - con * con;
        if (!('x0' in this)) {
            this.x0 = 0;
        }
        if (!('y0' in this)) {
            this.y0 = 0;
        }
        this.e = Math.sqrt(this.es);
        if (this.lat_ts) {
            if (this.sphere) {
                this.k0 = Math.cos(this.lat_ts);
            }
            else {
                this.k0 = (0, msfnz_1.default)(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts));
            }
        }
        else {
            if (!this.k0) {
                if (this.k) {
                    this.k0 = this.k;
                }
                else {
                    this.k0 = 1;
                }
            }
        }
    }
    exports.init = init;
    /* Mercator forward equations--mapping lat,long to x,y
      --------------------------------------------------*/
    function forward(p) {
        var lon = p.x;
        var lat = p.y;
        // convert to radians
        if (lat * values_1.R2D > 90 && lat * values_1.R2D < -90 && lon * values_1.R2D > 180 && lon * values_1.R2D < -180) {
            return null;
        }
        var x, y;
        if (Math.abs(Math.abs(lat) - values_1.HALF_PI) <= values_1.EPSLN) {
            return null;
        }
        else {
            if (this.sphere) {
                x = this.x0 + this.a * this.k0 * (0, adjust_lon_1.default)(lon - this.long0);
                y = this.y0 + this.a * this.k0 * Math.log(Math.tan(values_1.FORTPI + 0.5 * lat));
            }
            else {
                var sinphi = Math.sin(lat);
                var ts = (0, tsfnz_1.default)(this.e, lat, sinphi);
                x = this.x0 + this.a * this.k0 * (0, adjust_lon_1.default)(lon - this.long0);
                y = this.y0 - this.a * this.k0 * Math.log(ts);
            }
            p.x = x;
            p.y = y;
            return p;
        }
    }
    exports.forward = forward;
    /* Mercator inverse equations--mapping x,y to lat/long
      --------------------------------------------------*/
    function inverse(p) {
        var x = p.x - this.x0;
        var y = p.y - this.y0;
        var lon, lat;
        if (this.sphere) {
            lat = values_1.HALF_PI - 2 * Math.atan(Math.exp(-y / (this.a * this.k0)));
        }
        else {
            var ts = Math.exp(-y / (this.a * this.k0));
            lat = (0, phi2z_1.default)(this.e, ts);
            if (lat === -9999) {
                return null;
            }
        }
        lon = (0, adjust_lon_1.default)(this.long0 + x / (this.a * this.k0));
        p.x = lon;
        p.y = lat;
        return p;
    }
    exports.inverse = inverse;
    exports.names = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
    exports.default = {
        init: init,
        forward: forward,
        inverse: inverse,
        names: exports.names
    };
},
/* proj4/lib/common/msfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(eccent, sinphi, cosphi) {
        var con = eccent * sinphi;
        return cosphi / (Math.sqrt(1 - con * con));
    }
    exports.default = default_1;
},
/* proj4/lib/common/adjust_lon.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(112) /* ../constants/values */;
    const sign_1 = tslib_1.__importDefault(require(124) /* ./sign */);
    function default_1(x) {
        return (Math.abs(x) <= values_1.SPI) ? x : (x - ((0, sign_1.default)(x) * values_1.TWO_PI));
    }
    exports.default = default_1;
},
/* proj4/lib/common/sign.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(x) {
        return x < 0 ? -1 : 1;
    }
    exports.default = default_1;
},
/* proj4/lib/common/tsfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(112) /* ../constants/values */;
    function default_1(eccent, phi, sinphi) {
        var con = eccent * sinphi;
        var com = 0.5 * eccent;
        con = Math.pow(((1 - con) / (1 + con)), com);
        return (Math.tan(0.5 * (values_1.HALF_PI - phi)) / con);
    }
    exports.default = default_1;
},
/* proj4/lib/common/phi2z.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(112) /* ../constants/values */;
    function default_1(eccent, ts) {
        var eccnth = 0.5 * eccent;
        var con, dphi;
        var phi = values_1.HALF_PI - 2 * Math.atan(ts);
        for (var i = 0; i <= 15; i++) {
            con = eccent * Math.sin(phi);
            dphi = values_1.HALF_PI - 2 * Math.atan(ts * (Math.pow(((1 - con) / (1 + con)), eccnth))) - phi;
            phi += dphi;
            if (Math.abs(dphi) <= 0.0000000001) {
                return phi;
            }
        }
        //console.log("phi2z has NoConvergence");
        return -9999;
    }
    exports.default = default_1;
},
/* proj4/lib/projections/longlat.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function init() {
        //no-op for longlat
    }
    exports.init = init;
    function identity(pt) {
        return pt;
    }
    exports.forward = identity;
    exports.inverse = identity;
    exports.names = ["longlat", "identity"];
    exports.default = {
        init: init,
        forward: identity,
        inverse: identity,
        names: exports.names
    };
},
/* proj4/lib/deriveConstants.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(112) /* ./constants/values */;
    const Ellipsoid_1 = tslib_1.__importStar(require(129) /* ./constants/Ellipsoid */);
    const match_1 = tslib_1.__importDefault(require(115) /* ./match */);
    function eccentricity(a, b, rf, R_A) {
        var a2 = a * a; // used in geocentric
        var b2 = b * b; // used in geocentric
        var es = (a2 - b2) / a2; // e ^ 2
        var e = 0;
        if (R_A) {
            a *= 1 - es * (values_1.SIXTH + es * (values_1.RA4 + es * values_1.RA6));
            a2 = a * a;
            es = 0;
        }
        else {
            e = Math.sqrt(es); // eccentricity
        }
        var ep2 = (a2 - b2) / b2; // used in geocentric
        return {
            es: es,
            e: e,
            ep2: ep2
        };
    }
    exports.eccentricity = eccentricity;
    function sphere(a, b, rf, ellps, sphere) {
        if (!a) { // do we have an ellipsoid?
            var ellipse = (0, match_1.default)(Ellipsoid_1.default, ellps);
            if (!ellipse) {
                ellipse = Ellipsoid_1.WGS84;
            }
            a = ellipse.a;
            b = ellipse.b;
            rf = ellipse.rf;
        }
        if (rf && !b) {
            b = (1.0 - 1.0 / rf) * a;
        }
        if (rf === 0 || Math.abs(a - b) < values_1.EPSLN) {
            sphere = true;
            b = a;
        }
        return {
            a: a,
            b: b,
            rf: rf,
            sphere: sphere
        };
    }
    exports.sphere = sphere;
},
/* proj4/lib/constants/Ellipsoid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.MERIT = {
        a: 6378137.0,
        rf: 298.257,
        ellipseName: "MERIT 1983"
    };
    exports$1.SGS85 = {
        a: 6378136.0,
        rf: 298.257,
        ellipseName: "Soviet Geodetic System 85"
    };
    exports$1.GRS80 = {
        a: 6378137.0,
        rf: 298.257222101,
        ellipseName: "GRS 1980(IUGG, 1980)"
    };
    exports$1.IAU76 = {
        a: 6378140.0,
        rf: 298.257,
        ellipseName: "IAU 1976"
    };
    exports$1.airy = {
        a: 6377563.396,
        b: 6356256.910,
        ellipseName: "Airy 1830"
    };
    exports$1.APL4 = {
        a: 6378137,
        rf: 298.25,
        ellipseName: "Appl. Physics. 1965"
    };
    exports$1.NWL9D = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "Naval Weapons Lab., 1965"
    };
    exports$1.mod_airy = {
        a: 6377340.189,
        b: 6356034.446,
        ellipseName: "Modified Airy"
    };
    exports$1.andrae = {
        a: 6377104.43,
        rf: 300.0,
        ellipseName: "Andrae 1876 (Den., Iclnd.)"
    };
    exports$1.aust_SA = {
        a: 6378160.0,
        rf: 298.25,
        ellipseName: "Australian Natl & S. Amer. 1969"
    };
    exports$1.GRS67 = {
        a: 6378160.0,
        rf: 298.2471674270,
        ellipseName: "GRS 67(IUGG 1967)"
    };
    exports$1.bessel = {
        a: 6377397.155,
        rf: 299.1528128,
        ellipseName: "Bessel 1841"
    };
    exports$1.bess_nam = {
        a: 6377483.865,
        rf: 299.1528128,
        ellipseName: "Bessel 1841 (Namibia)"
    };
    exports$1.clrk66 = {
        a: 6378206.4,
        b: 6356583.8,
        ellipseName: "Clarke 1866"
    };
    exports$1.clrk80 = {
        a: 6378249.145,
        rf: 293.4663,
        ellipseName: "Clarke 1880 mod."
    };
    exports$1.clrk58 = {
        a: 6378293.645208759,
        rf: 294.2606763692654,
        ellipseName: "Clarke 1858"
    };
    exports$1.CPM = {
        a: 6375738.7,
        rf: 334.29,
        ellipseName: "Comm. des Poids et Mesures 1799"
    };
    exports$1.delmbr = {
        a: 6376428.0,
        rf: 311.5,
        ellipseName: "Delambre 1810 (Belgium)"
    };
    exports$1.engelis = {
        a: 6378136.05,
        rf: 298.2566,
        ellipseName: "Engelis 1985"
    };
    exports$1.evrst30 = {
        a: 6377276.345,
        rf: 300.8017,
        ellipseName: "Everest 1830"
    };
    exports$1.evrst48 = {
        a: 6377304.063,
        rf: 300.8017,
        ellipseName: "Everest 1948"
    };
    exports$1.evrst56 = {
        a: 6377301.243,
        rf: 300.8017,
        ellipseName: "Everest 1956"
    };
    exports$1.evrst69 = {
        a: 6377295.664,
        rf: 300.8017,
        ellipseName: "Everest 1969"
    };
    exports$1.evrstSS = {
        a: 6377298.556,
        rf: 300.8017,
        ellipseName: "Everest (Sabah & Sarawak)"
    };
    exports$1.fschr60 = {
        a: 6378166.0,
        rf: 298.3,
        ellipseName: "Fischer (Mercury Datum) 1960"
    };
    exports$1.fschr60m = {
        a: 6378155.0,
        rf: 298.3,
        ellipseName: "Fischer 1960"
    };
    exports$1.fschr68 = {
        a: 6378150.0,
        rf: 298.3,
        ellipseName: "Fischer 1968"
    };
    exports$1.helmert = {
        a: 6378200.0,
        rf: 298.3,
        ellipseName: "Helmert 1906"
    };
    exports$1.hough = {
        a: 6378270.0,
        rf: 297.0,
        ellipseName: "Hough"
    };
    exports$1.intl = {
        a: 6378388.0,
        rf: 297.0,
        ellipseName: "International 1909 (Hayford)"
    };
    exports$1.kaula = {
        a: 6378163.0,
        rf: 298.24,
        ellipseName: "Kaula 1961"
    };
    exports$1.lerch = {
        a: 6378139.0,
        rf: 298.257,
        ellipseName: "Lerch 1979"
    };
    exports$1.mprts = {
        a: 6397300.0,
        rf: 191.0,
        ellipseName: "Maupertius 1738"
    };
    exports$1.new_intl = {
        a: 6378157.5,
        b: 6356772.2,
        ellipseName: "New International 1967"
    };
    exports$1.plessis = {
        a: 6376523.0,
        rf: 6355863.0,
        ellipseName: "Plessis 1817 (France)"
    };
    exports$1.krass = {
        a: 6378245.0,
        rf: 298.3,
        ellipseName: "Krassovsky, 1942"
    };
    exports$1.SEasia = {
        a: 6378155.0,
        b: 6356773.3205,
        ellipseName: "Southeast Asia"
    };
    exports$1.walbeck = {
        a: 6376896.0,
        b: 6355834.8467,
        ellipseName: "Walbeck"
    };
    exports$1.WGS60 = {
        a: 6378165.0,
        rf: 298.3,
        ellipseName: "WGS 60"
    };
    exports$1.WGS66 = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "WGS 66"
    };
    exports$1.WGS7 = {
        a: 6378135.0,
        rf: 298.26,
        ellipseName: "WGS 72"
    };
    exports.WGS84 = exports$1.WGS84 = {
        a: 6378137.0,
        rf: 298.257223563,
        ellipseName: "WGS 84"
    };
    exports$1.sphere = {
        a: 6370997.0,
        b: 6370997.0,
        ellipseName: "Normal Sphere (r=6370997)"
    };
},
/* proj4/lib/constants/Datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.wgs84 = {
        towgs84: "0,0,0",
        ellipse: "WGS84",
        datumName: "WGS84"
    };
    exports$1.ch1903 = {
        towgs84: "674.374,15.056,405.346",
        ellipse: "bessel",
        datumName: "swiss"
    };
    exports$1.ggrs87 = {
        towgs84: "-199.87,74.79,246.62",
        ellipse: "GRS80",
        datumName: "Greek_Geodetic_Reference_System_1987"
    };
    exports$1.nad83 = {
        towgs84: "0,0,0",
        ellipse: "GRS80",
        datumName: "North_American_Datum_1983"
    };
    exports$1.nad27 = {
        nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
        ellipse: "clrk66",
        datumName: "North_American_Datum_1927"
    };
    exports$1.potsdam = {
        towgs84: "598.1,73.7,418.2,0.202,0.045,-2.455,6.7",
        ellipse: "bessel",
        datumName: "Potsdam Rauenberg 1950 DHDN"
    };
    exports$1.carthage = {
        towgs84: "-263.0,6.0,431.0",
        ellipse: "clark80",
        datumName: "Carthage 1934 Tunisia"
    };
    exports$1.hermannskogel = {
        towgs84: "577.326,90.129,463.919,5.137,1.474,5.297,2.4232",
        ellipse: "bessel",
        datumName: "Hermannskogel"
    };
    exports$1.osni52 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "airy",
        datumName: "Irish National"
    };
    exports$1.ire65 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "mod_airy",
        datumName: "Ireland 1965"
    };
    exports$1.rassadiran = {
        towgs84: "-133.63,-157.5,-158.62",
        ellipse: "intl",
        datumName: "Rassadiran"
    };
    exports$1.nzgd49 = {
        towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
        ellipse: "intl",
        datumName: "New Zealand Geodetic Datum 1949"
    };
    exports$1.osgb36 = {
        towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
        ellipse: "airy",
        datumName: "Airy 1830"
    };
    exports$1.s_jtsk = {
        towgs84: "589,76,480",
        ellipse: 'bessel',
        datumName: 'S-JTSK (Ferro)'
    };
    exports$1.beduaram = {
        towgs84: '-106,-87,188',
        ellipse: 'clrk80',
        datumName: 'Beduaram'
    };
    exports$1.gunung_segara = {
        towgs84: '-403,684,41',
        ellipse: 'bessel',
        datumName: 'Gunung Segara Jakarta'
    };
    exports$1.rnb72 = {
        towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
        ellipse: "intl",
        datumName: "Reseau National Belge 1972"
    };
},
/* proj4/lib/datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(112) /* ./constants/values */;
    function datum(datumCode, datum_params, a, b, es, ep2, nadgrids) {
        var out = {};
        if (datumCode === undefined || datumCode === 'none') {
            out.datum_type = values_1.PJD_NODATUM;
        }
        else {
            out.datum_type = values_1.PJD_WGS84;
        }
        if (datum_params) {
            out.datum_params = datum_params.map(parseFloat);
            if (out.datum_params[0] !== 0 || out.datum_params[1] !== 0 || out.datum_params[2] !== 0) {
                out.datum_type = values_1.PJD_3PARAM;
            }
            if (out.datum_params.length > 3) {
                if (out.datum_params[3] !== 0 || out.datum_params[4] !== 0 || out.datum_params[5] !== 0 || out.datum_params[6] !== 0) {
                    out.datum_type = values_1.PJD_7PARAM;
                    out.datum_params[3] *= values_1.SEC_TO_RAD;
                    out.datum_params[4] *= values_1.SEC_TO_RAD;
                    out.datum_params[5] *= values_1.SEC_TO_RAD;
                    out.datum_params[6] = (out.datum_params[6] / 1000000.0) + 1.0;
                }
            }
        }
        if (nadgrids) {
            out.datum_type = values_1.PJD_GRIDSHIFT;
            out.grids = nadgrids;
        }
        out.a = a; //datum object also uses these values
        out.b = b;
        out.es = es;
        out.ep2 = ep2;
        return out;
    }
    exports.default = datum;
},
/* proj4/lib/nadgrid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var loadedNadgrids = {};
    /**
     * Load a binary NTv2 file (.gsb) to a key that can be used in a proj string like +nadgrids=<key>. Pass the NTv2 file
     * as an ArrayBuffer.
     */
    function nadgrid(key, data) {
        var view = new DataView(data);
        var isLittleEndian = detectLittleEndian(view);
        var header = readHeader(view, isLittleEndian);
        if (header.nSubgrids > 1) {
            console.log('Only single NTv2 subgrids are currently supported, subsequent sub grids are ignored');
        }
        var subgrids = readSubgrids(view, header, isLittleEndian);
        var nadgrid = { header: header, subgrids: subgrids };
        loadedNadgrids[key] = nadgrid;
        return nadgrid;
    }
    exports.default = nadgrid;
    /**
     * Given a proj4 value for nadgrids, return an array of loaded grids
     */
    function getNadgrids(nadgrids) {
        // Format details: http://proj.maptools.org/gen_parms.html
        if (nadgrids === undefined) {
            return null;
        }
        var grids = nadgrids.split(',');
        return grids.map(parseNadgridString);
    }
    exports.getNadgrids = getNadgrids;
    function parseNadgridString(value) {
        if (value.length === 0) {
            return null;
        }
        var optional = value[0] === '@';
        if (optional) {
            value = value.slice(1);
        }
        if (value === 'null') {
            return { name: 'null', mandatory: !optional, grid: null, isNull: true };
        }
        return {
            name: value,
            mandatory: !optional,
            grid: loadedNadgrids[value] || null,
            isNull: false
        };
    }
    function secondsToRadians(seconds) {
        return (seconds / 3600) * Math.PI / 180;
    }
    function detectLittleEndian(view) {
        var nFields = view.getInt32(8, false);
        if (nFields === 11) {
            return false;
        }
        nFields = view.getInt32(8, true);
        if (nFields !== 11) {
            console.warn('Failed to detect nadgrid endian-ness, defaulting to little-endian');
        }
        return true;
    }
    function readHeader(view, isLittleEndian) {
        return {
            nFields: view.getInt32(8, isLittleEndian),
            nSubgridFields: view.getInt32(24, isLittleEndian),
            nSubgrids: view.getInt32(40, isLittleEndian),
            shiftType: decodeString(view, 56, 56 + 8).trim(),
            fromSemiMajorAxis: view.getFloat64(120, isLittleEndian),
            fromSemiMinorAxis: view.getFloat64(136, isLittleEndian),
            toSemiMajorAxis: view.getFloat64(152, isLittleEndian),
            toSemiMinorAxis: view.getFloat64(168, isLittleEndian),
        };
    }
    function decodeString(view, start, end) {
        return String.fromCharCode.apply(null, new Uint8Array(view.buffer.slice(start, end)));
    }
    function readSubgrids(view, header, isLittleEndian) {
        var gridOffset = 176;
        var grids = [];
        for (var i = 0; i < header.nSubgrids; i++) {
            var subHeader = readGridHeader(view, gridOffset, isLittleEndian);
            var nodes = readGridNodes(view, gridOffset, subHeader, isLittleEndian);
            var lngColumnCount = Math.round(1 + (subHeader.upperLongitude - subHeader.lowerLongitude) / subHeader.longitudeInterval);
            var latColumnCount = Math.round(1 + (subHeader.upperLatitude - subHeader.lowerLatitude) / subHeader.latitudeInterval);
            // Proj4 operates on radians whereas the coordinates are in seconds in the grid
            grids.push({
                ll: [secondsToRadians(subHeader.lowerLongitude), secondsToRadians(subHeader.lowerLatitude)],
                del: [secondsToRadians(subHeader.longitudeInterval), secondsToRadians(subHeader.latitudeInterval)],
                lim: [lngColumnCount, latColumnCount],
                count: subHeader.gridNodeCount,
                cvs: mapNodes(nodes)
            });
        }
        return grids;
    }
    function mapNodes(nodes) {
        return nodes.map(function (r) { return [secondsToRadians(r.longitudeShift), secondsToRadians(r.latitudeShift)]; });
    }
    function readGridHeader(view, offset, isLittleEndian) {
        return {
            name: decodeString(view, offset + 8, offset + 16).trim(),
            parent: decodeString(view, offset + 24, offset + 24 + 8).trim(),
            lowerLatitude: view.getFloat64(offset + 72, isLittleEndian),
            upperLatitude: view.getFloat64(offset + 88, isLittleEndian),
            lowerLongitude: view.getFloat64(offset + 104, isLittleEndian),
            upperLongitude: view.getFloat64(offset + 120, isLittleEndian),
            latitudeInterval: view.getFloat64(offset + 136, isLittleEndian),
            longitudeInterval: view.getFloat64(offset + 152, isLittleEndian),
            gridNodeCount: view.getInt32(offset + 168, isLittleEndian)
        };
    }
    function readGridNodes(view, offset, gridHeader, isLittleEndian) {
        var nodesOffset = offset + 176;
        var gridRecordLength = 16;
        var gridShiftRecords = [];
        for (var i = 0; i < gridHeader.gridNodeCount; i++) {
            var record = {
                latitudeShift: view.getFloat32(nodesOffset + i * gridRecordLength, isLittleEndian),
                longitudeShift: view.getFloat32(nodesOffset + i * gridRecordLength + 4, isLittleEndian),
                latitudeAccuracy: view.getFloat32(nodesOffset + i * gridRecordLength + 8, isLittleEndian),
                longitudeAccuracy: view.getFloat32(nodesOffset + i * gridRecordLength + 12, isLittleEndian),
            };
            gridShiftRecords.push(record);
        }
        return gridShiftRecords;
    }
},
/* proj4/lib/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(112) /* ./constants/values */;
    const datum_transform_1 = tslib_1.__importDefault(require(134) /* ./datum_transform */);
    const adjust_axis_1 = tslib_1.__importDefault(require(136) /* ./adjust_axis */);
    const Proj_1 = tslib_1.__importDefault(require(107) /* ./Proj */);
    const toPoint_1 = tslib_1.__importDefault(require(137) /* ./common/toPoint */);
    const checkSanity_1 = tslib_1.__importDefault(require(138) /* ./checkSanity */);
    function checkNotWGS(source, dest) {
        return ((source.datum.datum_type === values_1.PJD_3PARAM || source.datum.datum_type === values_1.PJD_7PARAM) && dest.datumCode !== 'WGS84') || ((dest.datum.datum_type === values_1.PJD_3PARAM || dest.datum.datum_type === values_1.PJD_7PARAM) && source.datumCode !== 'WGS84');
    }
    function transform(source, dest, point, enforceAxis) {
        var wgs84;
        if (Array.isArray(point)) {
            point = (0, toPoint_1.default)(point);
        }
        (0, checkSanity_1.default)(point);
        // Workaround for datum shifts towgs84, if either source or destination projection is not wgs84
        if (source.datum && dest.datum && checkNotWGS(source, dest)) {
            wgs84 = new Proj_1.default('WGS84');
            point = transform(source, wgs84, point, enforceAxis);
            source = wgs84;
        }
        // DGR, 2010/11/12
        if (enforceAxis && source.axis !== 'enu') {
            point = (0, adjust_axis_1.default)(source, false, point);
        }
        // Transform source points to long/lat, if they aren't already.
        if (source.projName === 'longlat') {
            point = {
                x: point.x * values_1.D2R,
                y: point.y * values_1.D2R,
                z: point.z || 0
            };
        }
        else {
            if (source.to_meter) {
                point = {
                    x: point.x * source.to_meter,
                    y: point.y * source.to_meter,
                    z: point.z || 0
                };
            }
            point = source.inverse(point); // Convert Cartesian to longlat
            if (!point) {
                return;
            }
        }
        // Adjust for the prime meridian if necessary
        if (source.from_greenwich) {
            point.x += source.from_greenwich;
        }
        // Convert datums if needed, and if possible.
        point = (0, datum_transform_1.default)(source.datum, dest.datum, point);
        if (!point) {
            return;
        }
        // Adjust for the prime meridian if necessary
        if (dest.from_greenwich) {
            point = {
                x: point.x - dest.from_greenwich,
                y: point.y,
                z: point.z || 0
            };
        }
        if (dest.projName === 'longlat') {
            // convert radians to decimal degrees
            point = {
                x: point.x * values_1.R2D,
                y: point.y * values_1.R2D,
                z: point.z || 0
            };
        }
        else { // else project
            point = dest.forward(point);
            if (dest.to_meter) {
                point = {
                    x: point.x / dest.to_meter,
                    y: point.y / dest.to_meter,
                    z: point.z || 0
                };
            }
        }
        // DGR, 2010/11/12
        if (enforceAxis && dest.axis !== 'enu') {
            return (0, adjust_axis_1.default)(dest, true, point);
        }
        return point;
    }
    exports.default = transform;
},
/* proj4/lib/datum_transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const values_1 = require(112) /* ./constants/values */;
    const datumUtils_1 = require(135) /* ./datumUtils */;
    const adjust_lon_1 = tslib_1.__importDefault(require(123) /* ./common/adjust_lon */);
    function checkParams(type) {
        return (type === values_1.PJD_3PARAM || type === values_1.PJD_7PARAM);
    }
    function default_1(source, dest, point) {
        // Short cut if the datums are identical.
        if ((0, datumUtils_1.compareDatums)(source, dest)) {
            return point; // in this case, zero is sucess,
            // whereas cs_compare_datums returns 1 to indicate TRUE
            // confusing, should fix this
        }
        // Explicitly skip datum transform by setting 'datum=none' as parameter for either source or dest
        if (source.datum_type === values_1.PJD_NODATUM || dest.datum_type === values_1.PJD_NODATUM) {
            return point;
        }
        // If this datum requires grid shifts, then apply it to geodetic coordinates.
        var source_a = source.a;
        var source_es = source.es;
        if (source.datum_type === values_1.PJD_GRIDSHIFT) {
            var gridShiftCode = applyGridShift(source, false, point);
            if (gridShiftCode !== 0) {
                return undefined;
            }
            source_a = values_1.SRS_WGS84_SEMIMAJOR;
            source_es = values_1.SRS_WGS84_ESQUARED;
        }
        var dest_a = dest.a;
        var dest_b = dest.b;
        var dest_es = dest.es;
        if (dest.datum_type === values_1.PJD_GRIDSHIFT) {
            dest_a = values_1.SRS_WGS84_SEMIMAJOR;
            dest_b = values_1.SRS_WGS84_SEMIMINOR;
            dest_es = values_1.SRS_WGS84_ESQUARED;
        }
        // Do we need to go through geocentric coordinates?
        if (source_es === dest_es && source_a === dest_a && !checkParams(source.datum_type) && !checkParams(dest.datum_type)) {
            return point;
        }
        // Convert to geocentric coordinates.
        point = (0, datumUtils_1.geodeticToGeocentric)(point, source_es, source_a);
        // Convert between datums
        if (checkParams(source.datum_type)) {
            point = (0, datumUtils_1.geocentricToWgs84)(point, source.datum_type, source.datum_params);
        }
        if (checkParams(dest.datum_type)) {
            point = (0, datumUtils_1.geocentricFromWgs84)(point, dest.datum_type, dest.datum_params);
        }
        point = (0, datumUtils_1.geocentricToGeodetic)(point, dest_es, dest_a, dest_b);
        if (dest.datum_type === values_1.PJD_GRIDSHIFT) {
            var destGridShiftResult = applyGridShift(dest, true, point);
            if (destGridShiftResult !== 0) {
                return undefined;
            }
        }
        return point;
    }
    exports.default = default_1;
    function applyGridShift(source, inverse, point) {
        if (source.grids === null || source.grids.length === 0) {
            console.log('Grid shift grids not found');
            return -1;
        }
        var input = { x: -point.x, y: point.y };
        var output = { x: Number.NaN, y: Number.NaN };
        var onlyMandatoryGrids = false;
        var attemptedGrids = [];
        for (var i = 0; i < source.grids.length; i++) {
            var grid = source.grids[i];
            attemptedGrids.push(grid.name);
            if (grid.isNull) {
                output = input;
                break;
            }
            onlyMandatoryGrids = grid.mandatory;
            if (grid.grid === null) {
                if (grid.mandatory) {
                    console.log("Unable to find mandatory grid '" + grid.name + "'");
                    return -1;
                }
                continue;
            }
            var subgrid = grid.grid.subgrids[0];
            // skip tables that don't match our point at all
            var epsilon = (Math.abs(subgrid.del[1]) + Math.abs(subgrid.del[0])) / 10000.0;
            var minX = subgrid.ll[0] - epsilon;
            var minY = subgrid.ll[1] - epsilon;
            var maxX = subgrid.ll[0] + (subgrid.lim[0] - 1) * subgrid.del[0] + epsilon;
            var maxY = subgrid.ll[1] + (subgrid.lim[1] - 1) * subgrid.del[1] + epsilon;
            if (minY > input.y || minX > input.x || maxY < input.y || maxX < input.x) {
                continue;
            }
            output = applySubgridShift(input, inverse, subgrid);
            if (!isNaN(output.x)) {
                break;
            }
        }
        if (isNaN(output.x)) {
            console.log("Failed to find a grid shift table for location '" +
                -input.x * values_1.R2D + " " + input.y * values_1.R2D + " tried: '" + attemptedGrids + "'");
            return -1;
        }
        point.x = -output.x;
        point.y = output.y;
        return 0;
    }
    exports.applyGridShift = applyGridShift;
    function applySubgridShift(pin, inverse, ct) {
        var val = { x: Number.NaN, y: Number.NaN };
        if (isNaN(pin.x)) {
            return val;
        }
        var tb = { x: pin.x, y: pin.y };
        tb.x -= ct.ll[0];
        tb.y -= ct.ll[1];
        tb.x = (0, adjust_lon_1.default)(tb.x - Math.PI) + Math.PI;
        var t = nadInterpolate(tb, ct);
        if (inverse) {
            if (isNaN(t.x)) {
                return val;
            }
            t.x = tb.x - t.x;
            t.y = tb.y - t.y;
            var i = 9, tol = 1e-12;
            var dif, del;
            do {
                del = nadInterpolate(t, ct);
                if (isNaN(del.x)) {
                    console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");
                    break;
                }
                dif = { x: tb.x - (del.x + t.x), y: tb.y - (del.y + t.y) };
                t.x += dif.x;
                t.y += dif.y;
            } while (i-- && Math.abs(dif.x) > tol && Math.abs(dif.y) > tol);
            if (i < 0) {
                console.log("Inverse grid shift iterator failed to converge.");
                return val;
            }
            val.x = (0, adjust_lon_1.default)(t.x + ct.ll[0]);
            val.y = t.y + ct.ll[1];
        }
        else {
            if (!isNaN(t.x)) {
                val.x = pin.x + t.x;
                val.y = pin.y + t.y;
            }
        }
        return val;
    }
    function nadInterpolate(pin, ct) {
        var t = { x: pin.x / ct.del[0], y: pin.y / ct.del[1] };
        var indx = { x: Math.floor(t.x), y: Math.floor(t.y) };
        var frct = { x: t.x - 1.0 * indx.x, y: t.y - 1.0 * indx.y };
        var val = { x: Number.NaN, y: Number.NaN };
        var inx;
        if (indx.x < 0 || indx.x >= ct.lim[0]) {
            return val;
        }
        if (indx.y < 0 || indx.y >= ct.lim[1]) {
            return val;
        }
        inx = (indx.y * ct.lim[0]) + indx.x;
        var f00 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx++;
        var f10 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx += ct.lim[0];
        var f11 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        inx--;
        var f01 = { x: ct.cvs[inx][0], y: ct.cvs[inx][1] };
        var m11 = frct.x * frct.y, m10 = frct.x * (1.0 - frct.y), m00 = (1.0 - frct.x) * (1.0 - frct.y), m01 = (1.0 - frct.x) * frct.y;
        val.x = (m00 * f00.x + m10 * f10.x + m01 * f01.x + m11 * f11.x);
        val.y = (m00 * f00.y + m10 * f10.y + m01 * f01.y + m11 * f11.y);
        return val;
    }
},
/* proj4/lib/datumUtils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const values_1 = require(112) /* ./constants/values */;
    function compareDatums(source, dest) {
        if (source.datum_type !== dest.datum_type) {
            return false; // false, datums are not equal
        }
        else if (source.a !== dest.a || Math.abs(source.es - dest.es) > 0.000000000050) {
            // the tolerance for es is to ensure that GRS80 and WGS84
            // are considered identical
            return false;
        }
        else if (source.datum_type === values_1.PJD_3PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2]);
        }
        else if (source.datum_type === values_1.PJD_7PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2] && source.datum_params[3] === dest.datum_params[3] && source.datum_params[4] === dest.datum_params[4] && source.datum_params[5] === dest.datum_params[5] && source.datum_params[6] === dest.datum_params[6]);
        }
        else {
            return true; // datums are equal
        }
    } // cs_compare_datums()
    exports.compareDatums = compareDatums;
    /*
     * The function Convert_Geodetic_To_Geocentric converts geodetic coordinates
     * (latitude, longitude, and height) to geocentric coordinates (X, Y, Z),
     * according to the current ellipsoid parameters.
     *
     *    Latitude  : Geodetic latitude in radians                     (input)
     *    Longitude : Geodetic longitude in radians                    (input)
     *    Height    : Geodetic height, in meters                       (input)
     *    X         : Calculated Geocentric X coordinate, in meters    (output)
     *    Y         : Calculated Geocentric Y coordinate, in meters    (output)
     *    Z         : Calculated Geocentric Z coordinate, in meters    (output)
     *
     */
    function geodeticToGeocentric(p, es, a) {
        var Longitude = p.x;
        var Latitude = p.y;
        var Height = p.z ? p.z : 0; //Z value not always supplied
        var Rn; /*  Earth radius at location  */
        var Sin_Lat; /*  Math.sin(Latitude)  */
        var Sin2_Lat; /*  Square of Math.sin(Latitude)  */
        var Cos_Lat; /*  Math.cos(Latitude)  */
        /*
         ** Don't blow up if Latitude is just a little out of the value
         ** range as it may just be a rounding issue.  Also removed longitude
         ** test, it should be wrapped by Math.cos() and Math.sin().  NFW for PROJ.4, Sep/2001.
         */
        if (Latitude < -values_1.HALF_PI && Latitude > -1.001 * values_1.HALF_PI) {
            Latitude = -values_1.HALF_PI;
        }
        else if (Latitude > values_1.HALF_PI && Latitude < 1.001 * values_1.HALF_PI) {
            Latitude = values_1.HALF_PI;
        }
        else if (Latitude < -values_1.HALF_PI) {
            /* Latitude out of range */
            //..reportError('geocent:lat out of range:' + Latitude);
            return { x: -Infinity, y: -Infinity, z: p.z };
        }
        else if (Latitude > values_1.HALF_PI) {
            /* Latitude out of range */
            return { x: Infinity, y: Infinity, z: p.z };
        }
        if (Longitude > Math.PI) {
            Longitude -= (2 * Math.PI);
        }
        Sin_Lat = Math.sin(Latitude);
        Cos_Lat = Math.cos(Latitude);
        Sin2_Lat = Sin_Lat * Sin_Lat;
        Rn = a / (Math.sqrt(1.0e0 - es * Sin2_Lat));
        return {
            x: (Rn + Height) * Cos_Lat * Math.cos(Longitude),
            y: (Rn + Height) * Cos_Lat * Math.sin(Longitude),
            z: ((Rn * (1 - es)) + Height) * Sin_Lat
        };
    } // cs_geodetic_to_geocentric()
    exports.geodeticToGeocentric = geodeticToGeocentric;
    function geocentricToGeodetic(p, es, a, b) {
        /* local defintions and variables */
        /* end-criterium of loop, accuracy of sin(Latitude) */
        var genau = 1e-12;
        var genau2 = (genau * genau);
        var maxiter = 30;
        var P; /* distance between semi-minor axis and location */
        var RR; /* distance between center and location */
        var CT; /* sin of geocentric latitude */
        var ST; /* cos of geocentric latitude */
        var RX;
        var RK;
        var RN; /* Earth radius at location */
        var CPHI0; /* cos of start or old geodetic latitude in iterations */
        var SPHI0; /* sin of start or old geodetic latitude in iterations */
        var CPHI; /* cos of searched geodetic latitude */
        var SPHI; /* sin of searched geodetic latitude */
        var SDPHI; /* end-criterium: addition-theorem of sin(Latitude(iter)-Latitude(iter-1)) */
        var iter; /* # of continous iteration, max. 30 is always enough (s.a.) */
        var X = p.x;
        var Y = p.y;
        var Z = p.z ? p.z : 0.0; //Z value not always supplied
        var Longitude;
        var Latitude;
        var Height;
        P = Math.sqrt(X * X + Y * Y);
        RR = Math.sqrt(X * X + Y * Y + Z * Z);
        /*      special cases for latitude and longitude */
        if (P / a < genau) {
            /*  special case, if P=0. (X=0., Y=0.) */
            Longitude = 0.0;
            /*  if (X,Y,Z)=(0.,0.,0.) then Height becomes semi-minor axis
             *  of ellipsoid (=center of mass), Latitude becomes PI/2 */
            if (RR / a < genau) {
                Latitude = values_1.HALF_PI;
                Height = -b;
                return {
                    x: p.x,
                    y: p.y,
                    z: p.z
                };
            }
        }
        else {
            /*  ellipsoidal (geodetic) longitude
             *  interval: -PI < Longitude <= +PI */
            Longitude = Math.atan2(Y, X);
        }
        /* --------------------------------------------------------------
         * Following iterative algorithm was developped by
         * "Institut for Erdmessung", University of Hannover, July 1988.
         * Internet: www.ife.uni-hannover.de
         * Iterative computation of CPHI,SPHI and Height.
         * Iteration of CPHI and SPHI to 10**-12 radian resp.
         * 2*10**-7 arcsec.
         * --------------------------------------------------------------
         */
        CT = Z / RR;
        ST = P / RR;
        RX = 1.0 / Math.sqrt(1.0 - es * (2.0 - es) * ST * ST);
        CPHI0 = ST * (1.0 - es) * RX;
        SPHI0 = CT * RX;
        iter = 0;
        /* loop to find sin(Latitude) resp. Latitude
         * until |sin(Latitude(iter)-Latitude(iter-1))| < genau */
        do {
            iter++;
            RN = a / Math.sqrt(1.0 - es * SPHI0 * SPHI0);
            /*  ellipsoidal (geodetic) height */
            Height = P * CPHI0 + Z * SPHI0 - RN * (1.0 - es * SPHI0 * SPHI0);
            RK = es * RN / (RN + Height);
            RX = 1.0 / Math.sqrt(1.0 - RK * (2.0 - RK) * ST * ST);
            CPHI = ST * (1.0 - RK) * RX;
            SPHI = CT * RX;
            SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
            CPHI0 = CPHI;
            SPHI0 = SPHI;
        } while (SDPHI * SDPHI > genau2 && iter < maxiter);
        /*      ellipsoidal (geodetic) latitude */
        Latitude = Math.atan(SPHI / Math.abs(CPHI));
        return {
            x: Longitude,
            y: Latitude,
            z: Height
        };
    } // cs_geocentric_to_geodetic()
    exports.geocentricToGeodetic = geocentricToGeodetic;
    /****************************************************************/
    // pj_geocentic_to_wgs84( p )
    //  p = point to transform in geocentric coordinates (x,y,z)
    /** point object, nothing fancy, just allows values to be
        passed back and forth by reference rather than by value.
        Other point classes may be used as long as they have
        x and y properties, which will get modified in the transform method.
    */
    function geocentricToWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x + datum_params[0],
                y: p.y + datum_params[1],
                z: p.z + datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: M_BF * (p.x - Rz_BF * p.y + Ry_BF * p.z) + Dx_BF,
                y: M_BF * (Rz_BF * p.x + p.y - Rx_BF * p.z) + Dy_BF,
                z: M_BF * (-Ry_BF * p.x + Rx_BF * p.y + p.z) + Dz_BF
            };
        }
    } // cs_geocentric_to_wgs84
    exports.geocentricToWgs84 = geocentricToWgs84;
    /****************************************************************/
    // pj_geocentic_from_wgs84()
    //  coordinate system definition,
    //  point to transform in geocentric coordinates (x,y,z)
    function geocentricFromWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x - datum_params[0],
                y: p.y - datum_params[1],
                z: p.z - datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            var x_tmp = (p.x - Dx_BF) / M_BF;
            var y_tmp = (p.y - Dy_BF) / M_BF;
            var z_tmp = (p.z - Dz_BF) / M_BF;
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp,
                y: -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp,
                z: Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp
            };
        } //cs_geocentric_from_wgs84()
    }
    exports.geocentricFromWgs84 = geocentricFromWgs84;
},
/* proj4/lib/adjust_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(crs, denorm, point) {
        var xin = point.x, yin = point.y, zin = point.z || 0.0;
        var v, t, i;
        var out = {};
        for (i = 0; i < 3; i++) {
            if (denorm && i === 2 && point.z === undefined) {
                continue;
            }
            if (i === 0) {
                v = xin;
                if ("ew".indexOf(crs.axis[i]) !== -1) {
                    t = 'x';
                }
                else {
                    t = 'y';
                }
            }
            else if (i === 1) {
                v = yin;
                if ("ns".indexOf(crs.axis[i]) !== -1) {
                    t = 'y';
                }
                else {
                    t = 'x';
                }
            }
            else {
                v = zin;
                t = 'z';
            }
            switch (crs.axis[i]) {
                case 'e':
                    out[t] = v;
                    break;
                case 'w':
                    out[t] = -v;
                    break;
                case 'n':
                    out[t] = v;
                    break;
                case 's':
                    out[t] = -v;
                    break;
                case 'u':
                    if (point[t] !== undefined) {
                        out.z = v;
                    }
                    break;
                case 'd':
                    if (point[t] !== undefined) {
                        out.z = -v;
                    }
                    break;
                default:
                    //console.log("ERROR: unknow axis ("+crs.axis[i]+") - check definition of "+crs.projName);
                    return null;
            }
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/common/toPoint.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(array) {
        var out = {
            x: array[0],
            y: array[1]
        };
        if (array.length > 2) {
            out.z = array[2];
        }
        if (array.length > 3) {
            out.m = array[3];
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/checkSanity.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(point) {
        checkCoord(point.x);
        checkCoord(point.y);
    }
    exports.default = default_1;
    function checkCoord(num) {
        if (typeof Number.isFinite === 'function') {
            if (Number.isFinite(num)) {
                return;
            }
            throw new TypeError('coordinates must be finite numbers');
        }
        if (typeof num !== 'number' || num !== num || !isFinite(num)) {
            throw new TypeError('coordinates must be finite numbers');
        }
    }
},
/* models/annotations/arrow_head.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a, _b, _c, _d, _e;
    const marking_1 = require(140) /* ../graphics/marking */;
    const property_mixins_1 = require(78) /* ../../core/property_mixins */;
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    class ArrowHeadView extends marking_1.MarkingView {
    }
    exports.ArrowHeadView = ArrowHeadView;
    ArrowHeadView.__name__ = "ArrowHeadView";
    class ArrowHead extends marking_1.Marking {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ArrowHead = ArrowHead;
    _a = ArrowHead;
    ArrowHead.__name__ = "ArrowHead";
    (() => {
        _a.define(() => ({
            size: [p.NumberSpec, 25],
        }));
    })();
    class OpenHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        render(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            this.visuals.line.apply(ctx, i);
        }
    }
    exports.OpenHeadView = OpenHeadView;
    OpenHeadView.__name__ = "OpenHeadView";
    class OpenHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.OpenHead = OpenHead;
    _b = OpenHead;
    OpenHead.__name__ = "OpenHead";
    (() => {
        _b.prototype.default_view = OpenHeadView;
        _b.mixins(property_mixins_1.LineVector);
    })();
    class NormalHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        render(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.closePath();
            this.visuals.fill.apply(ctx, i);
            this.visuals.line.apply(ctx, i);
        }
    }
    exports.NormalHeadView = NormalHeadView;
    NormalHeadView.__name__ = "NormalHeadView";
    class NormalHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.NormalHead = NormalHead;
    _c = NormalHead;
    NormalHead.__name__ = "NormalHead";
    (() => {
        _c.prototype.default_view = NormalHeadView;
        _c.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
        _c.override({
            fill_color: "black",
        });
    })();
    class VeeHeadView extends ArrowHeadView {
        clip(ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            const size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        }
        render(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.closePath();
            this.visuals.fill.apply(ctx, i);
            this.visuals.line.apply(ctx, i);
        }
    }
    exports.VeeHeadView = VeeHeadView;
    VeeHeadView.__name__ = "VeeHeadView";
    class VeeHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.VeeHead = VeeHead;
    _d = VeeHead;
    VeeHead.__name__ = "VeeHead";
    (() => {
        _d.prototype.default_view = VeeHeadView;
        _d.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
        _d.override({
            fill_color: "black",
        });
    })();
    class TeeHeadView extends ArrowHeadView {
        render(ctx, i) {
            const size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, 0);
            ctx.lineTo(-0.5 * size_i, 0);
            this.visuals.line.apply(ctx, i);
        }
        clip(_ctx, _i) { }
    }
    exports.TeeHeadView = TeeHeadView;
    TeeHeadView.__name__ = "TeeHeadView";
    class TeeHead extends ArrowHead {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TeeHead = TeeHead;
    _e = TeeHead;
    TeeHead.__name__ = "TeeHead";
    (() => {
        _e.prototype.default_view = TeeHeadView;
        _e.mixins(property_mixins_1.LineVector);
    })();
},
/* models/graphics/marking.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const model_1 = require(51) /* ../../model */;
    const view_1 = require(54) /* ../../core/view */;
    const visuals = tslib_1.__importStar(require(75) /* ../../core/visuals */);
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    class MarkingView extends view_1.View {
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
        }
        request_render() {
            this.parent.request_render();
        }
        get canvas() {
            return this.parent.canvas;
        }
        set_data(source, indices) {
            const self = this;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                    continue;
                const uniform = prop.uniform(source).select(indices);
                self[`${prop.attr}`] = uniform;
            }
        }
    }
    exports.MarkingView = MarkingView;
    MarkingView.__name__ = "MarkingView";
    class Marking extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Marking = Marking;
    _a = Marking;
    Marking.__name__ = "Marking";
    (() => {
        _a.define(({}) => ({}));
    })();
},
/* models/annotations/base_color_bar.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(73) /* ./annotation */;
    const title_1 = require(142) /* ./title */;
    const cartesian_frame_1 = require(157) /* ../canvas/cartesian_frame */;
    const axes_1 = require(158) /* ../axes */;
    const ticker_1 = require(161) /* ../tickers/ticker */;
    const tickers_1 = require(192) /* ../tickers */;
    const tick_formatter_1 = require(162) /* ../formatters/tick_formatter */;
    const formatters_1 = require(219) /* ../formatters */;
    const labeling_1 = require(163) /* ../policies/labeling */;
    const scales_1 = require(223) /* ../scales */;
    const ranges_1 = require(225) /* ../ranges */;
    const base_text_1 = require(147) /* ../text/base_text */;
    const enums_1 = require(19) /* ../../core/enums */;
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    const layout_1 = require(226) /* ../../core/layout */;
    const alignments_1 = require(227) /* ../../core/layout/alignments */;
    const border_1 = require(229) /* ../../core/layout/border */;
    const side_panel_1 = require(144) /* ../../core/layout/side_panel */;
    const build_views_1 = require(59) /* ../../core/build_views */;
    const bbox_1 = require(57) /* ../../core/util/bbox */;
    const types_1 = require(8) /* ../../core/util/types */;
    const object_1 = require(9) /* ../../core/util/object */;
    const MINOR_DIM = 25;
    const MAJOR_DIM_MIN_SCALAR = 0.3;
    const MAJOR_DIM_MAX_SCALAR = 0.8;
    class BaseColorBarView extends annotation_1.AnnotationView {
        get orientation() {
            return this._orientation;
        }
        *children() {
            yield* super.children();
            yield this._axis_view;
            yield this._title_view;
        }
        initialize() {
            super.initialize();
            const { ticker, formatter } = this.model;
            this._ticker = ticker != "auto" ? ticker : this._create_ticker();
            this._formatter = formatter != "auto" ? formatter : this._create_formatter();
            this._major_range = this._create_major_range();
            this._major_scale = this._create_major_scale();
            this._minor_range = new ranges_1.Range1d({ start: 0, end: 1 });
            this._minor_scale = new scales_1.LinearScale();
            // configure some frame, update when the layout is know
            this._frame = new cartesian_frame_1.CartesianFrame(this._major_scale, this._minor_scale, this._major_range, this._minor_range);
            this._axis = this._create_axis();
            this._apply_axis_properties();
            this._title = new title_1.Title();
            this._apply_title_properties();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            const self = this;
            const parent = {
                get parent() {
                    return self.parent;
                },
                get root() {
                    return self.root;
                },
                get frame() {
                    return self._frame;
                },
                get canvas_view() {
                    return self.parent.canvas_view;
                },
                request_layout() {
                    self.parent.request_layout();
                },
                request_paint() {
                    self.parent.request_paint(self);
                },
                request_render() {
                    self.request_paint();
                },
            };
            this._axis_view = await (0, build_views_1.build_view)(this._axis, { parent });
            this._title_view = await (0, build_views_1.build_view)(this._title, { parent });
        }
        remove() {
            this._title_view.remove();
            this._axis_view.remove();
            super.remove();
        }
        _apply_axis_properties() {
            const attrs = Object.assign(Object.assign(Object.assign({ ticker: this._ticker, formatter: this._formatter, major_label_standoff: this.model.label_standoff, axis_line_color: null, major_tick_in: this.model.major_tick_in, major_tick_out: this.model.major_tick_out, minor_tick_in: this.model.minor_tick_in, minor_tick_out: this.model.minor_tick_out, major_label_overrides: this.model.major_label_overrides, major_label_policy: this.model.major_label_policy }, mixins.attrs_of(this.model, "major_label_", mixins.Text, true)), mixins.attrs_of(this.model, "major_tick_", mixins.Line, true)), mixins.attrs_of(this.model, "minor_tick_", mixins.Line, true));
            this._axis.setv(attrs);
        }
        _apply_title_properties() {
            var _b;
            const attrs = Object.assign({ text: (_b = this.model.title) !== null && _b !== void 0 ? _b : "", standoff: this.model.title_standoff }, mixins.attrs_of(this.model, "title_", mixins.Text, false));
            this._title.setv(attrs);
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => {
                this._apply_title_properties();
                this._apply_axis_properties();
                // TODO?: this.plot_view.invalidate_layout()
            });
            this.connect(this._ticker.change, () => this.request_render());
            this.connect(this._formatter.change, () => this.request_render());
        }
        _update_frame() {
            const [x_scale, y_scale, x_range, y_range] = (() => {
                if (this.orientation == "horizontal")
                    return [this._major_scale, this._minor_scale, this._major_range, this._minor_range];
                else
                    return [this._minor_scale, this._major_scale, this._minor_range, this._major_range];
            })();
            this._frame.in_x_scale = x_scale;
            this._frame.in_y_scale = y_scale;
            this._frame.x_range = x_range;
            this._frame.y_range = y_range;
            this._frame.configure_scales();
        }
        update_layout() {
            const { location, width: w, height: h, padding, margin } = this.model;
            const [valign, halign] = (() => {
                if ((0, types_1.isString)(location)) {
                    switch (location) {
                        case "top_left":
                            return ["start", "start"];
                        case "top":
                        case "top_center":
                            return ["start", "center"];
                        case "top_right":
                            return ["start", "end"];
                        case "bottom_left":
                            return ["end", "start"];
                        case "bottom":
                        case "bottom_center":
                            return ["end", "center"];
                        case "bottom_right":
                            return ["end", "end"];
                        case "left":
                        case "center_left":
                            return ["center", "start"];
                        case "center":
                        case "center_center":
                            return ["center", "center"];
                        case "right":
                        case "center_right":
                            return ["center", "end"];
                    }
                }
                else
                    return ["end", "start"]; // "bottom_left"
            })();
            const orientation = this._orientation = (() => {
                const { orientation } = this.model;
                if (orientation == "auto") {
                    if (this.panel != null)
                        return this.panel.is_horizontal ? "horizontal" : "vertical";
                    else {
                        if (halign == "start" || halign == "end" || ( /*halign == "center" &&*/valign == "center"))
                            return "vertical";
                        else
                            return "horizontal";
                    }
                }
                else
                    return orientation;
            })();
            this._update_frame();
            const center_panel = new alignments_1.NodeLayout();
            const top_panel = new alignments_1.VStack();
            const bottom_panel = new alignments_1.VStack();
            const left_panel = new alignments_1.HStack();
            const right_panel = new alignments_1.HStack();
            center_panel.absolute = true;
            top_panel.absolute = true;
            bottom_panel.absolute = true;
            left_panel.absolute = true;
            right_panel.absolute = true;
            center_panel.on_resize((bbox) => this._frame.set_geometry(bbox));
            const layout = new border_1.BorderLayout();
            this._inner_layout = layout;
            layout.absolute = true;
            layout.center_panel = center_panel;
            layout.top_panel = top_panel;
            layout.bottom_panel = bottom_panel;
            layout.left_panel = left_panel;
            layout.right_panel = right_panel;
            const padding_box = { left: padding, right: padding, top: padding, bottom: padding };
            const margin_box = (() => {
                if (this.panel == null) {
                    if ((0, types_1.isString)(location))
                        return { left: margin, right: margin, top: margin, bottom: margin };
                    else {
                        const [left, bottom] = location;
                        return { left, right: margin, top: margin, bottom };
                    }
                }
                else {
                    /**
                     * XXX: alignment is broken in Grid, which is used to govern positioning of a ColorBar
                     * in side panels. Earlier attempts at fixing this failed and resulted in a multitude
                     * or regressions in various places in the layout. So instead of this, let's assume that
                     * the positioning is always at "start" regardless of configuration, and fix this here
                     * by manually computing "center" and "end" alignment.
                     */
                    if ((0, types_1.isString)(location)) {
                        layout.fixup_geometry = (outer, inner) => {
                            const origin = outer;
                            if (orientation == "horizontal") {
                                const { top, width, height } = outer;
                                if (halign == "end") {
                                    const { right } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ right, top, width, height });
                                }
                                else if (halign == "center") {
                                    const { hcenter } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ hcenter: Math.round(hcenter), top, width, height });
                                }
                            }
                            else {
                                const { left, width, height } = outer;
                                if (valign == "end") {
                                    const { bottom } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ left, bottom, width, height });
                                }
                                else if (valign == "center") {
                                    const { vcenter } = this.layout.bbox;
                                    outer = new bbox_1.BBox({ left, vcenter: Math.round(vcenter), width, height });
                                }
                            }
                            if (inner != null) {
                                const dh = outer.left - origin.left;
                                const dv = outer.top - origin.top;
                                const { left, top, width, height } = inner;
                                inner = new bbox_1.BBox({ left: left + dh, top: top + dv, width, height });
                            }
                            return [outer, inner];
                        };
                        return undefined;
                    }
                    else {
                        const [left, bottom] = location;
                        layout.fixup_geometry = (outer, inner) => {
                            const origin = outer;
                            const grid = this.layout.bbox;
                            const { width, height } = outer;
                            outer = new bbox_1.BBox({ left: grid.left + left, bottom: grid.bottom - bottom, width, height });
                            if (inner != null) {
                                const dh = outer.left - origin.left;
                                const dv = outer.top - origin.top;
                                const { left, top, width, height } = inner;
                                inner = new bbox_1.BBox({ left: left + dh, top: top + dv, width, height });
                            }
                            return [outer, inner];
                        };
                        return { left, right: 0, top: 0, bottom };
                    }
                }
            })();
            layout.padding = padding_box;
            let major_policy;
            let major_size;
            let min_major_size;
            let max_major_size;
            if (this.panel != null) {
                major_policy = "max";
                major_size = undefined;
                min_major_size = undefined;
                max_major_size = undefined;
            }
            else {
                if ((orientation == "horizontal" ? w : h) == "auto") {
                    major_policy = "fixed";
                    const major_size_factor = this._get_major_size_factor();
                    if (major_size_factor != null)
                        major_size = major_size_factor * MINOR_DIM;
                    min_major_size = { percent: MAJOR_DIM_MIN_SCALAR };
                    max_major_size = { percent: MAJOR_DIM_MAX_SCALAR };
                }
                else {
                    major_policy = "fit";
                    major_size = undefined;
                }
            }
            if (orientation == "horizontal") {
                const width = w == "auto" ? undefined : w;
                const height = h == "auto" ? MINOR_DIM : h;
                layout.set_sizing({
                    width_policy: major_policy, height_policy: "min",
                    width: major_size, min_width: min_major_size, max_width: max_major_size,
                    halign, valign, margin: margin_box,
                });
                layout.center_panel.set_sizing({ width_policy: w == "auto" ? "fit" : "fixed", height_policy: "fixed", width, height });
            }
            else {
                const width = w == "auto" ? MINOR_DIM : w;
                const height = h == "auto" ? undefined : h;
                layout.set_sizing({
                    width_policy: "min", height_policy: major_policy,
                    height: major_size, min_height: min_major_size, max_height: max_major_size,
                    halign, valign, margin: margin_box,
                });
                layout.center_panel.set_sizing({ width_policy: "fixed", height_policy: h == "auto" ? "fit" : "fixed", width, height });
            }
            top_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
            bottom_panel.set_sizing({ width_policy: "fit", height_policy: "min" });
            left_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
            right_panel.set_sizing({ width_policy: "min", height_policy: "fit" });
            const { _title_view } = this;
            if (orientation == "horizontal") {
                _title_view.panel = new side_panel_1.Panel("above");
                _title_view.update_layout();
                top_panel.children.push(_title_view.layout);
            }
            else {
                _title_view.panel = new side_panel_1.Panel("left");
                _title_view.update_layout();
                left_panel.children.push(_title_view.layout);
            }
            const { panel } = this;
            const side = (() => {
                if (panel != null && orientation == panel.orientation)
                    return panel.side;
                else
                    return orientation == "horizontal" ? "below" : "right";
            })();
            const stack = (() => {
                switch (side) {
                    case "above":
                        return top_panel;
                    case "below":
                        return bottom_panel;
                    case "left":
                        return left_panel;
                    case "right":
                        return right_panel;
                }
            })();
            const { _axis_view } = this;
            _axis_view.panel = new side_panel_1.Panel(side);
            _axis_view.update_layout();
            stack.children.push(_axis_view.layout);
            if (this.panel != null) {
                const outer = new layout_1.Grid([{ layout, row: 0, col: 0 }]);
                outer.absolute = true;
                if (orientation == "horizontal") {
                    outer.set_sizing({ width_policy: "max", height_policy: "min" });
                }
                else {
                    outer.set_sizing({ width_policy: "min", height_policy: "max" });
                }
                this.layout = outer;
            }
            else {
                this.layout = this._inner_layout;
            }
            const { visible } = this.model;
            this.layout.sizing.visible = visible;
        }
        _create_axis() {
            return new axes_1.LinearAxis();
        }
        _create_formatter() {
            return new formatters_1.BasicTickFormatter();
        }
        _create_major_range() {
            return new ranges_1.Range1d({ start: 0, end: 1 });
        }
        _create_major_scale() {
            return new scales_1.LinearScale();
        }
        _create_ticker() {
            return new tickers_1.BasicTicker();
        }
        _get_major_size_factor() {
            return null;
        }
        _render() {
            const { ctx } = this.layer;
            ctx.save();
            this._paint_bbox(ctx, this._inner_layout.bbox);
            this._paint_colors(ctx, this._inner_layout.center_panel.bbox);
            this._title_view.render();
            this._axis_view.render();
            ctx.restore();
        }
        _paint_bbox(ctx, bbox) {
            const { x, y } = bbox;
            let { width, height } = bbox;
            // XXX: shrink outline region by 1px to make right and bottom lines visible
            // if they are on the edge of the canvas.
            if (x + width >= this.parent.canvas_view.bbox.width) {
                width -= 1;
            }
            if (y + height >= this.parent.canvas_view.bbox.height) {
                height -= 1;
            }
            ctx.save();
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(x, y, width, height);
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.strokeRect(x, y, width, height);
            }
            ctx.restore();
        }
        serializable_state() {
            const _b = super.serializable_state(), { children = [] } = _b, state = tslib_1.__rest(_b, ["children"]);
            children.push(this._title_view.serializable_state());
            children.push(this._axis_view.serializable_state());
            return Object.assign(Object.assign({}, state), { children });
        }
    }
    exports.BaseColorBarView = BaseColorBarView;
    BaseColorBarView.__name__ = "BaseColorBarView";
    class BaseColorBar extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BaseColorBar = BaseColorBar;
    _a = BaseColorBar;
    BaseColorBar.__name__ = "BaseColorBar";
    (() => {
        _a.mixins([
            ["major_label_", mixins.Text],
            ["title_", mixins.Text],
            ["major_tick_", mixins.Line],
            ["minor_tick_", mixins.Line],
            ["border_", mixins.Line],
            ["bar_", mixins.Line],
            ["background_", mixins.Fill],
        ]);
        _a.define(({ Alpha, Number, String, Tuple, Map, Or, Ref, Auto, Nullable }) => ({
            location: [Or(enums_1.Anchor, Tuple(Number, Number)), "top_right"],
            orientation: [Or(enums_1.Orientation, Auto), "auto"],
            title: [Nullable(String), null],
            title_standoff: [Number, 2],
            width: [Or(Number, Auto), "auto"],
            height: [Or(Number, Auto), "auto"],
            scale_alpha: [Alpha, 1.0],
            ticker: [Or(Ref(ticker_1.Ticker), Auto), "auto"],
            formatter: [Or(Ref(tick_formatter_1.TickFormatter), Auto), "auto"],
            major_label_overrides: [Map(Or(String, Number), Or(String, Ref(base_text_1.BaseText))), new globalThis.Map(), {
                    convert(v) {
                        return (0, types_1.isPlainObject)(v) ? new object_1.Dict(v) : v;
                    },
                }],
            major_label_policy: [Ref(labeling_1.LabelingPolicy), () => new labeling_1.NoOverlap()],
            label_standoff: [Number, 5],
            margin: [Number, 30],
            padding: [Number, 10],
            major_tick_in: [Number, 5],
            major_tick_out: [Number, 0],
            minor_tick_in: [Number, 0],
            minor_tick_out: [Number, 0],
        }));
        _a.override({
            background_fill_color: "#ffffff",
            background_fill_alpha: 0.95,
            bar_line_color: null,
            border_line_color: null,
            major_label_text_font_size: "11px",
            major_tick_line_color: "#ffffff",
            minor_tick_line_color: null,
            title_text_font_size: "13px",
            title_text_font_style: "italic",
        });
    })();
},
/* models/annotations/title.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const text_annotation_1 = require(143) /* ./text_annotation */;
    const enums_1 = require(19) /* ../../core/enums */;
    class TitleView extends text_annotation_1.TextAnnotationView {
        _get_position() {
            const hmargin = this.model.offset;
            const vmargin = this.model.standoff / 2;
            const { align, vertical_align } = this.model;
            let sx, sy;
            const { bbox } = this.layout;
            switch (this.panel.side) {
                case "above":
                case "below": {
                    switch (vertical_align) {
                        case "top":
                            sy = bbox.top + vmargin;
                            break;
                        case "middle":
                            sy = bbox.vcenter;
                            break;
                        case "bottom":
                            sy = bbox.bottom - vmargin;
                            break;
                    }
                    switch (align) {
                        case "left":
                            sx = bbox.left + hmargin;
                            break;
                        case "center":
                            sx = bbox.hcenter;
                            break;
                        case "right":
                            sx = bbox.right - hmargin;
                            break;
                    }
                    break;
                }
                case "left": {
                    switch (vertical_align) {
                        case "top":
                            sx = bbox.left + vmargin;
                            break;
                        case "middle":
                            sx = bbox.hcenter;
                            break;
                        case "bottom":
                            sx = bbox.right - vmargin;
                            break;
                    }
                    switch (align) {
                        case "left":
                            sy = bbox.bottom - hmargin;
                            break;
                        case "center":
                            sy = bbox.vcenter;
                            break;
                        case "right":
                            sy = bbox.top + hmargin;
                            break;
                    }
                    break;
                }
                case "right": {
                    switch (vertical_align) {
                        case "top":
                            sx = bbox.right - vmargin;
                            break;
                        case "middle":
                            sx = bbox.hcenter;
                            break;
                        case "bottom":
                            sx = bbox.left + vmargin;
                            break;
                    }
                    switch (align) {
                        case "left":
                            sy = bbox.top + hmargin;
                            break;
                        case "center":
                            sy = bbox.vcenter;
                            break;
                        case "right":
                            sy = bbox.bottom - hmargin;
                            break;
                    }
                    break;
                }
            }
            const x_anchor = align;
            const y_anchor = vertical_align == "middle" ? "center" : vertical_align;
            return { sx, sy, x_anchor, y_anchor };
        }
        _render() {
            const position = this._get_position();
            const angle = this.panel.get_label_angle_heuristic("parallel");
            this._paint(this.layer.ctx, position, angle);
        }
        _get_size() {
            if (!this.displayed)
                return { width: 0, height: 0 };
            const graphics = this._text_view.graphics();
            graphics.visuals = this.visuals.text.values();
            const { width, height } = graphics._size();
            // XXX: The magic 2px is for backwards compatibility. This will be removed at
            // some point, but currently there is no point breaking half of visual tests.
            return { width, height: height == 0 ? 0 : 2 + height + this.model.standoff };
        }
    }
    exports.TitleView = TitleView;
    TitleView.__name__ = "TitleView";
    class Title extends text_annotation_1.TextAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Title = Title;
    _a = Title;
    Title.__name__ = "Title";
    (() => {
        _a.prototype.default_view = TitleView;
        _a.define(({ Number }) => ({
            vertical_align: [enums_1.VerticalAlign, "bottom"],
            align: [enums_1.TextAlign, "left"],
            offset: [Number, 0],
            standoff: [Number, 10],
        }));
        _a.override({
            text_font_size: "13px",
            text_font_style: "bold",
            text_line_height: 1.0,
        });
    })();
},
/* models/annotations/text_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(73) /* ./annotation */;
    const side_panel_1 = require(144) /* ../../core/layout/side_panel */;
    const base_text_1 = require(147) /* ../text/base_text */;
    const build_views_1 = require(59) /* ../../core/build_views */;
    const types_1 = require(8) /* ../../core/util/types */;
    const utils_1 = require(148) /* ../text/utils */;
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    class TextAnnotationView extends annotation_1.AnnotationView {
        *children() {
            yield* super.children();
            yield this._text_view;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._init_text();
        }
        async _init_text() {
            const { text } = this.model;
            const _text = (0, types_1.isString)(text) ? (0, utils_1.parse_delimited_string)(text) : text;
            this._text_view = await (0, build_views_1.build_view)(_text, { parent: this });
        }
        update_layout() {
            const { panel } = this;
            if (panel != null)
                this.layout = new side_panel_1.SideLayout(panel, () => this.get_size(), true);
            else
                this.layout = undefined;
        }
        connect_signals() {
            super.connect_signals();
            const { text } = this.model.properties;
            this.on_change(text, async () => {
                this._text_view.remove();
                await this._init_text();
            });
            this.connect(this.model.change, () => this.request_render());
        }
        remove() {
            this._text_view.remove();
            super.remove();
        }
        has_finished() {
            if (!super.has_finished())
                return false;
            if (!this._text_view.has_finished())
                return false;
            return true;
        }
        get displayed() {
            return super.displayed && this._text_view.model.text != "" && this.visuals.text.doit;
        }
        _paint(ctx, position, angle) {
            const graphics = this._text_view.graphics();
            graphics.angle = angle;
            graphics.position = position;
            graphics.align = "auto";
            graphics.visuals = this.visuals.text.values();
            const { background_fill, border_line } = this.visuals;
            if (background_fill.doit || border_line.doit) {
                const { p0, p1, p2, p3 } = graphics.rect();
                ctx.beginPath();
                ctx.moveTo(p0.x, p0.y);
                ctx.lineTo(p1.x, p1.y);
                ctx.lineTo(p2.x, p2.y);
                ctx.lineTo(p3.x, p3.y);
                ctx.closePath();
                this.visuals.background_fill.apply(ctx);
                this.visuals.border_line.apply(ctx);
            }
            if (this.visuals.text.doit)
                graphics.paint(ctx);
        }
    }
    exports.TextAnnotationView = TextAnnotationView;
    TextAnnotationView.__name__ = "TextAnnotationView";
    class TextAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TextAnnotation = TextAnnotation;
    _a = TextAnnotation;
    TextAnnotation.__name__ = "TextAnnotation";
    (() => {
        _a.mixins([
            mixins.Text,
            ["border_", mixins.Line],
            ["background_", mixins.Fill],
        ]);
        _a.define(({ String, Or, Ref }) => ({
            text: [Or(String, Ref(base_text_1.BaseText)), ""],
        }));
        _a.override({
            background_fill_color: null,
            border_line_color: null,
        });
    })();
},
/* core/layout/side_panel.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(145) /* ./types */;
    const layoutable_1 = require(146) /* ./layoutable */;
    const types_2 = require(8) /* ../util/types */;
    // This table lays out the rules for configuring the baseline, alignment, etc. of
    // title text, based on it's location and orientation
    //
    // side    orient        baseline   align     angle   normal-dist
    // ------------------------------------------------------------------------------
    // above   parallel      bottom     center    0       height
    //         normal        middle     left      -90     width
    //         horizontal    bottom     center    0       height
    //         [angle > 0]   middle     left              width * sin + height * cos
    //         [angle < 0]   middle     right             width * sin + height * cos
    //
    // below   parallel      top        center    0       height
    //         normal        middle     right     90      width
    //         horizontal    top        center    0       height
    //         [angle > 0]   middle     right             width * sin + height * cos
    //         [angle < 0]   middle     left              width * sin + height * cos
    //
    // left    parallel      bottom     center    90      height
    //         normal        middle     right     0       width
    //         horizontal    middle     right     0       width
    //         [angle > 0]   middle     right             width * cos + height * sin
    //         [angle < 0]   middle     right             width * cos + height + sin
    //
    // right   parallel      bottom     center   -90      height
    //         normal        middle     left     0        width
    //         horizontal    middle     left     0        width
    //         [angle > 0]   middle     left              width * cos + height * sin
    //         [angle < 0]   middle     left              width * cos + height + sin
    const pi2 = Math.PI / 2;
    const _angle_lookup = {
        above: {
            parallel: 0,
            normal: -pi2,
            horizontal: 0,
            vertical: -pi2,
        },
        below: {
            parallel: 0,
            normal: pi2,
            horizontal: 0,
            vertical: pi2,
        },
        left: {
            parallel: -pi2,
            normal: 0,
            horizontal: 0,
            vertical: -pi2,
        },
        right: {
            parallel: pi2,
            normal: 0,
            horizontal: 0,
            vertical: pi2,
        },
    };
    const _vertical_align_lookup = {
        above: {
            parallel: "bottom",
            normal: "center",
            horizontal: "bottom",
            vertical: "center",
        },
        below: {
            parallel: "top",
            normal: "center",
            horizontal: "top",
            vertical: "center",
        },
        left: {
            parallel: "bottom",
            normal: "center",
            horizontal: "center",
            vertical: "bottom",
        },
        right: {
            parallel: "bottom",
            normal: "center",
            horizontal: "center",
            vertical: "bottom",
        },
    };
    const _align_lookup = {
        above: {
            parallel: "center",
            normal: "left",
            horizontal: "center",
            vertical: "left",
        },
        below: {
            parallel: "center",
            normal: "left",
            horizontal: "center",
            vertical: "left",
        },
        left: {
            parallel: "center",
            normal: "right",
            horizontal: "right",
            vertical: "center",
        },
        right: {
            parallel: "center",
            normal: "left",
            horizontal: "left",
            vertical: "center",
        },
    };
    const _align_lookup_negative = {
        above: "right",
        below: "left",
        left: "right",
        right: "left",
    };
    const _align_lookup_positive = {
        above: "left",
        below: "right",
        left: "right",
        right: "left",
    };
    class Panel {
        constructor(side) {
            this.side = side;
        }
        get dimension() {
            return this.side == "above" || this.side == "below" ? 0 : 1;
        }
        get normals() {
            switch (this.side) {
                case "above": return [0, -1];
                case "below": return [0, 1];
                case "left": return [-1, 0];
                case "right": return [1, 0];
            }
        }
        get orientation() {
            return this.is_horizontal ? "horizontal" : "vertical";
        }
        get is_horizontal() {
            return this.dimension == 0;
        }
        get is_vertical() {
            return this.dimension == 1;
        }
        get_label_text_heuristics(orient) {
            const { side } = this;
            if ((0, types_2.isString)(orient)) {
                return {
                    vertical_align: _vertical_align_lookup[side][orient],
                    align: _align_lookup[side][orient],
                };
            }
            else {
                return {
                    vertical_align: "center",
                    align: (orient < 0 ? _align_lookup_negative : _align_lookup_positive)[side],
                };
            }
        }
        get_label_angle_heuristic(orient) {
            if ((0, types_2.isString)(orient))
                return _angle_lookup[this.side][orient];
            else
                return -orient;
        }
    }
    exports.Panel = Panel;
    Panel.__name__ = "Panel";
    class SideLayout extends layoutable_1.ContentLayoutable {
        constructor(panel, get_size, rotate = false) {
            super();
            this.panel = panel;
            this.get_size = get_size;
            this.rotate = rotate;
            if (this.panel.is_horizontal)
                this.set_sizing({ width_policy: "max", height_policy: "fixed" });
            else
                this.set_sizing({ width_policy: "fixed", height_policy: "max" });
        }
        _content_size() {
            const { width, height } = this.get_size();
            if (!this.rotate || this.panel.is_horizontal)
                return new types_1.Sizeable({ width, height });
            else
                return new types_1.Sizeable({ width: height, height: width });
        }
        has_size_changed() {
            const { width, height } = this._content_size();
            if (this.panel.is_horizontal)
                return this.bbox.height != height;
            else
                return this.bbox.width != width;
        }
    }
    exports.SideLayout = SideLayout;
    SideLayout.__name__ = "SideLayout";
},
/* core/layout/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const kinds_1 = require(20) /* ../kinds */;
    const { min, max } = Math;
    class Sizeable {
        constructor(size = {}) {
            this.width = size.width != null ? size.width : 0;
            this.height = size.height != null ? size.height : 0;
        }
        bounded_to({ width, height }) {
            return new Sizeable({
                width: this.width == Infinity && width != null ? width : this.width,
                height: this.height == Infinity && height != null ? height : this.height,
            });
        }
        expanded_to({ width, height }) {
            return new Sizeable({
                width: width != Infinity ? max(this.width, width) : this.width,
                height: height != Infinity ? max(this.height, height) : this.height,
            });
        }
        expand_to({ width, height }) {
            this.width = max(this.width, width);
            this.height = max(this.height, height);
        }
        narrowed_to({ width, height }) {
            return new Sizeable({
                width: min(this.width, width),
                height: min(this.height, height),
            });
        }
        narrow_to({ width, height }) {
            this.width = min(this.width, width);
            this.height = min(this.height, height);
        }
        grow_by({ left, right, top, bottom }) {
            const width = this.width + left + right;
            const height = this.height + top + bottom;
            return new Sizeable({ width, height });
        }
        shrink_by({ left, right, top, bottom }) {
            const width = max(this.width - left - right, 0);
            const height = max(this.height - top - bottom, 0);
            return new Sizeable({ width, height });
        }
        map(w_fn, h_fn) {
            return new Sizeable({
                width: w_fn(this.width),
                height: (h_fn != null ? h_fn : w_fn)(this.height),
            });
        }
    }
    exports.Sizeable = Sizeable;
    Sizeable.__name__ = "Sizeable";
    exports.SizingPolicy = (0, kinds_1.Enum)("fixed", "fit", "min", "max");
},
/* core/layout/layoutable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(145) /* ./types */;
    const bbox_1 = require(57) /* ../util/bbox */;
    const types_2 = require(8) /* ../util/types */;
    const { min, max, round } = Math;
    class Layoutable {
        constructor() {
            this.absolute = false;
            this._bbox = new bbox_1.BBox();
            this._inner_bbox = new bbox_1.BBox();
            this._dirty = false;
            this._handlers = [];
        }
        *[Symbol.iterator]() { }
        get bbox() {
            return this._bbox;
        }
        get inner_bbox() {
            return this._inner_bbox;
        }
        get sizing() {
            return this._sizing;
        }
        set visible(visible) {
            this._sizing.visible = visible;
            this._dirty = true;
        }
        set_sizing(sizing = {}) {
            var _a, _b, _c, _d, _e, _f;
            const width_policy = (_a = sizing.width_policy) !== null && _a !== void 0 ? _a : "fit";
            const width = sizing.width;
            const min_width = sizing.min_width;
            const max_width = sizing.max_width;
            const height_policy = (_b = sizing.height_policy) !== null && _b !== void 0 ? _b : "fit";
            const height = sizing.height;
            const min_height = sizing.min_height;
            const max_height = sizing.max_height;
            const aspect = sizing.aspect;
            const margin = (_c = sizing.margin) !== null && _c !== void 0 ? _c : { top: 0, right: 0, bottom: 0, left: 0 };
            const visible = (_d = sizing.visible) !== null && _d !== void 0 ? _d : true;
            const halign = (_e = sizing.halign) !== null && _e !== void 0 ? _e : "start";
            const valign = (_f = sizing.valign) !== null && _f !== void 0 ? _f : "start";
            this._sizing = {
                width_policy, min_width, width, max_width,
                height_policy, min_height, height, max_height,
                aspect,
                margin,
                visible,
                halign,
                valign,
                size: { width, height },
            };
            this._init();
        }
        _init() { }
        _set_geometry(outer, inner) {
            this._bbox = outer;
            this._inner_bbox = inner;
        }
        set_geometry(outer, inner) {
            const { fixup_geometry } = this;
            if (fixup_geometry != null) {
                [outer, inner] = fixup_geometry(outer, inner);
            }
            this._set_geometry(outer, inner !== null && inner !== void 0 ? inner : outer);
            for (const handler of this._handlers) {
                handler(this._bbox, this._inner_bbox);
            }
        }
        on_resize(handler) {
            this._handlers.push(handler);
        }
        is_width_expanding() {
            return this.sizing.width_policy == "max";
        }
        is_height_expanding() {
            return this.sizing.height_policy == "max";
        }
        apply_aspect(viewport, { width, height }) {
            const { aspect } = this.sizing;
            if (aspect != null) {
                const { width_policy, height_policy } = this.sizing;
                const gt = (width, height) => {
                    const policies = { max: 4, fit: 3, min: 2, fixed: 1 };
                    return policies[width] > policies[height];
                };
                if (width_policy != "fixed" && height_policy != "fixed") {
                    if (width_policy == height_policy) {
                        const w_width = width;
                        const w_height = round(width / aspect);
                        const h_width = round(height * aspect);
                        const h_height = height;
                        const w_diff = Math.abs(viewport.width - w_width) + Math.abs(viewport.height - w_height);
                        const h_diff = Math.abs(viewport.width - h_width) + Math.abs(viewport.height - h_height);
                        if (w_diff <= h_diff) {
                            width = w_width;
                            height = w_height;
                        }
                        else {
                            width = h_width;
                            height = h_height;
                        }
                    }
                    else if (gt(width_policy, height_policy)) {
                        height = round(width / aspect);
                    }
                    else {
                        width = round(height * aspect);
                    }
                }
                else if (width_policy == "fixed") {
                    height = round(width / aspect);
                }
                else if (height_policy == "fixed") {
                    width = round(height * aspect);
                }
            }
            return { width, height };
        }
        measure(viewport_size) {
            if (!this.sizing.visible)
                return { width: 0, height: 0 };
            const exact_width = (width) => {
                return this.sizing.width_policy == "fixed" && this.sizing.width != null ? this.sizing.width : width;
            };
            const exact_height = (height) => {
                return this.sizing.height_policy == "fixed" && this.sizing.height != null ? this.sizing.height : height;
            };
            const viewport = new types_1.Sizeable(viewport_size)
                .shrink_by(this.sizing.margin)
                .map(exact_width, exact_height);
            const computed = this._measure(viewport);
            const clipped = this.clip_size(computed, viewport);
            const width = exact_width(clipped.width);
            const height = exact_height(clipped.height);
            const size = this.apply_aspect(viewport, { width, height });
            return Object.assign(Object.assign({}, computed), size);
        }
        compute(viewport = {}) {
            const size_hint = this.measure({
                width: viewport.width != null && this.is_width_expanding() ? viewport.width : Infinity,
                height: viewport.height != null && this.is_height_expanding() ? viewport.height : Infinity,
            });
            const { width, height } = size_hint;
            const outer = new bbox_1.BBox({ left: 0, top: 0, width, height });
            let inner = undefined;
            if (size_hint.inner != null) {
                const { left, top, right, bottom } = size_hint.inner;
                inner = new bbox_1.BBox({ left, top, right: width - right, bottom: height - bottom });
            }
            this.set_geometry(outer, inner);
        }
        get xview() {
            return this.bbox.xview;
        }
        get yview() {
            return this.bbox.yview;
        }
        clip_size(size, viewport) {
            function clip(size, vsize, min_size, max_size) {
                if (min_size == null)
                    min_size = 0;
                else if (!(0, types_2.isNumber)(min_size))
                    min_size = Math.round(min_size.percent * vsize);
                if (max_size == null)
                    max_size = Infinity;
                else if (!(0, types_2.isNumber)(max_size))
                    max_size = Math.round(max_size.percent * vsize);
                return max(min_size, min(size, max_size));
            }
            return {
                width: clip(size.width, viewport.width, this.sizing.min_width, this.sizing.max_width),
                height: clip(size.height, viewport.height, this.sizing.min_height, this.sizing.max_height),
            };
        }
        has_size_changed() {
            const { _dirty } = this;
            this._dirty = false;
            return _dirty;
        }
    }
    exports.Layoutable = Layoutable;
    Layoutable.__name__ = "Layoutable";
    class ContentLayoutable extends Layoutable {
        _measure(viewport) {
            const content_size = this._content_size();
            const bounds = viewport
                .bounded_to(this.sizing.size)
                .bounded_to(content_size);
            const width = (() => {
                switch (this.sizing.width_policy) {
                    case "fixed":
                        return this.sizing.width != null ? this.sizing.width : content_size.width;
                    case "min":
                        return content_size.width;
                    case "fit":
                        return bounds.width;
                    case "max":
                        return Math.max(content_size.width, bounds.width);
                }
            })();
            const height = (() => {
                switch (this.sizing.height_policy) {
                    case "fixed":
                        return this.sizing.height != null ? this.sizing.height : content_size.height;
                    case "min":
                        return content_size.height;
                    case "fit":
                        return bounds.height;
                    case "max":
                        return Math.max(content_size.height, bounds.height);
                }
            })();
            return { width, height };
        }
    }
    exports.ContentLayoutable = ContentLayoutable;
    ContentLayoutable.__name__ = "ContentLayoutable";
},
/* models/text/base_text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(51) /* ../../model */;
    const view_1 = require(54) /* ../../core/view */;
    class BaseTextView extends view_1.View {
    }
    exports.BaseTextView = BaseTextView;
    BaseTextView.__name__ = "BaseTextView";
    class BaseText extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BaseText = BaseText;
    _a = BaseText;
    BaseText.__name__ = "BaseText";
    (() => {
        _a.define(({ String }) => ({
            text: [String],
        }));
    })();
},
/* models/text/utils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const math_text_1 = require(149) /* ./math_text */;
    const plain_text_1 = require(156) /* ./plain_text */;
    const delimiters = [
        { start: "$$", end: "$$", inline: false },
        { start: "\\[", end: "\\]", inline: false },
        { start: "\\(", end: "\\)", inline: true },
    ];
    function parse_delimited_string(text) {
        for (const delim of delimiters) {
            const n0 = text.indexOf(delim.start);
            const m0 = n0 + delim.start.length;
            if (n0 == 0) {
                const n1 = text.indexOf(delim.end, m0);
                const m1 = n1;
                if (n1 == text.length - delim.end.length)
                    return new math_text_1.TeX({ text: text.slice(m0, m1), inline: delim.inline });
                else
                    break;
            }
        }
        return new plain_text_1.PlainText({ text });
    }
    exports.parse_delimited_string = parse_delimited_string;
},
/* models/text/math_text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a, _b, _c;
    const types_1 = require(8) /* ../../core/util/types */;
    const image_1 = require(150) /* ../../core/util/image */;
    const color_1 = require(21) /* ../../core/util/color */;
    const graphics_1 = require(151) /* ../../core/graphics */;
    const text_1 = require(152) /* ../../core/util/text */;
    const string_1 = require(38) /* ../../core/util/string */;
    const affine_1 = require(153) /* ../../core/util/affine */;
    const bbox_1 = require(57) /* ../../core/util/bbox */;
    const base_text_1 = require(147) /* ./base_text */;
    const providers_1 = require(154) /* ./providers */;
    /**
     * Helper class for rendering MathText into Canvas
     */
    class MathTextView extends base_text_1.BaseTextView {
        constructor() {
            super(...arguments);
            this._position = { sx: 0, sy: 0 };
            // Align does nothing, needed to maintain compatibility with TextBox,
            // to align you need to use TeX Macros.
            // http://docs.mathjax.org/en/latest/input/tex/macros/index.html?highlight=align
            this.align = "left";
            this._x_anchor = "left";
            this._y_anchor = "center";
            this._base_font_size = 13; // the same as :host's font-size (13px)
            this.font_size_scale = 1.0;
            this.svg_image = null;
        }
        graphics() {
            return this;
        }
        // Same for infer_text_height
        infer_text_height() {
            return "ascent_descent";
        }
        set base_font_size(v) {
            if (v != null)
                this._base_font_size = v;
        }
        get base_font_size() {
            return this._base_font_size;
        }
        _rect() {
            const { width, height } = this._size();
            const { x, y } = this._computed_position();
            const bbox = new bbox_1.BBox({ x, y, width, height });
            return bbox.rect;
        }
        set position(p) {
            this._position = p;
        }
        get position() {
            return this._position;
        }
        get text() {
            return this.model.text;
        }
        get provider() {
            return providers_1.default_provider;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            if (this.provider.status == "not_started")
                await this.provider.fetch();
        }
        connect_signals() {
            super.connect_signals();
            this.on_change(this.model.properties.text, () => this.load_image());
        }
        set visuals(v) {
            const color = v.color;
            const alpha = v.alpha;
            const style = v.font_style;
            let size = v.font_size;
            const face = v.font;
            const { font_size_scale, _base_font_size } = this;
            const res = (0, text_1.parse_css_font_size)(size);
            if (res != null) {
                let { value, unit } = res;
                value *= font_size_scale;
                if (unit == "em" && _base_font_size) {
                    value *= _base_font_size;
                    unit = "px";
                }
                size = `${value}${unit}`;
            }
            const font = `${style} ${size} ${face}`;
            this.font = font;
            this.color = (0, color_1.color2css)(color, alpha);
            const align = v.align;
            //this._visual_align = align
            this._x_anchor = align;
            const baseline = v.baseline;
            this._y_anchor = (() => {
                switch (baseline) {
                    case "top": return "top";
                    case "middle": return "center";
                    case "bottom": return "bottom";
                    default: return "baseline";
                }
            })();
        }
        /**
         * Calculates position of element after considering
         * anchor and dimensions
         */
        _computed_position() {
            const { width, height } = this._size();
            const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
            const metrics = (0, text_1.font_metrics)(this.font);
            const x = sx - (() => {
                if ((0, types_1.isNumber)(x_anchor))
                    return x_anchor * width;
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            const y = sy - (() => {
                if ((0, types_1.isNumber)(y_anchor))
                    return y_anchor * height;
                else {
                    switch (y_anchor) {
                        case "top":
                            if (metrics.height > height)
                                return (height - (-this.valign - metrics.descent) - metrics.height);
                            else
                                return 0;
                        case "center": return 0.5 * height;
                        case "bottom":
                            if (metrics.height > height)
                                return (height + metrics.descent + this.valign);
                            else
                                return height;
                        case "baseline": return 0.5 * height;
                    }
                }
            })();
            return { x, y };
        }
        /**
         * Uses the width, height and given angle to calculate the size
        */
        size() {
            const { width, height } = this._size();
            const { angle } = this;
            if (angle == null || angle == 0)
                return { width, height };
            else {
                const c = Math.cos(Math.abs(angle));
                const s = Math.sin(Math.abs(angle));
                return {
                    width: Math.abs(width * c + height * s),
                    height: Math.abs(width * s + height * c),
                };
            }
        }
        get_image_dimensions() {
            var _d;
            const fmetrics = (0, text_1.font_metrics)(this.font);
            // XXX: perhaps use getComputedStyle()?
            const svg_styles = (_d = this.svg_element.getAttribute("style")) === null || _d === void 0 ? void 0 : _d.split(";");
            if (svg_styles) {
                const rules_map = new Map();
                svg_styles.forEach(property => {
                    const [rule, value] = property.split(":");
                    if (rule)
                        rules_map.set(rule.trim(), value.trim());
                });
                const v_align = (0, text_1.parse_css_length)(rules_map.get("vertical-align"));
                if ((v_align === null || v_align === void 0 ? void 0 : v_align.unit) == "ex") {
                    this.valign = v_align.value * fmetrics.x_height;
                }
                else if ((v_align === null || v_align === void 0 ? void 0 : v_align.unit) == "px") {
                    this.valign = v_align.value;
                }
            }
            const ex = (() => {
                const width = this.svg_element.getAttribute("width");
                const height = this.svg_element.getAttribute("height");
                return {
                    width: width != null && width.endsWith("ex") ? parseFloat(width) : 1,
                    height: height != null && height.endsWith("ex") ? parseFloat(height) : 1,
                };
            })();
            return {
                width: fmetrics.x_height * ex.width,
                height: fmetrics.x_height * ex.height,
            };
        }
        get truncated_text() {
            return this.model.text.length > 6
                ? `${this.model.text.substring(0, 6)}...`
                : this.model.text;
        }
        _size() {
            var _d, _e;
            if (!this.svg_image) {
                if (this.provider.status == "failed" || this.provider.status == "not_started") {
                    return {
                        width: (0, graphics_1.text_width)(this.truncated_text, this.font),
                        height: (0, text_1.font_metrics)(this.font).height,
                    };
                }
                else {
                    return { width: this._base_font_size, height: this._base_font_size };
                }
            }
            const fmetrics = (0, text_1.font_metrics)(this.font);
            let { width, height } = this.get_image_dimensions();
            height = Math.max(height, fmetrics.height);
            const w_scale = ((_d = this.width) === null || _d === void 0 ? void 0 : _d.unit) == "%" ? this.width.value : 1;
            const h_scale = ((_e = this.height) === null || _e === void 0 ? void 0 : _e.unit) == "%" ? this.height.value : 1;
            return { width: width * w_scale, height: height * h_scale };
        }
        bbox() {
            const { p0, p1, p2, p3 } = this.rect();
            const left = Math.min(p0.x, p1.x, p2.x, p3.x);
            const top = Math.min(p0.y, p1.y, p2.y, p3.y);
            const right = Math.max(p0.x, p1.x, p2.x, p3.x);
            const bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
            return new bbox_1.BBox({ left, right, top, bottom });
        }
        rect() {
            const rect = this._rect();
            const { angle } = this;
            if (angle == null || angle == 0)
                return rect;
            else {
                const { sx, sy } = this.position;
                const tr = new affine_1.AffineTransform();
                tr.translate(sx, sy);
                tr.rotate(angle);
                tr.translate(-sx, -sy);
                return tr.apply_rect(rect);
            }
        }
        paint_rect(ctx) {
            const { p0, p1, p2, p3 } = this.rect();
            ctx.save();
            ctx.strokeStyle = "red";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(p0.x), round(p0.y));
            ctx.lineTo(round(p1.x), round(p1.y));
            ctx.lineTo(round(p2.x), round(p2.y));
            ctx.lineTo(round(p3.x), round(p3.y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        paint_bbox(ctx) {
            const { x, y, width, height } = this.bbox();
            ctx.save();
            ctx.strokeStyle = "blue";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(x), round(y));
            ctx.lineTo(round(x), round(y + height));
            ctx.lineTo(round(x + width), round(y + height));
            ctx.lineTo(round(x + width), round(y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        async load_image() {
            if (this.provider.MathJax == null)
                return null;
            const mathjax_element = this._process_text();
            if (mathjax_element == null) {
                this._has_finished = true;
                return null;
            }
            const svg_element = mathjax_element.children[0];
            this.svg_element = svg_element;
            svg_element.setAttribute("font", this.font);
            svg_element.setAttribute("stroke", this.color);
            const svg = svg_element.outerHTML;
            const src = `data:image/svg+xml;utf-8,${encodeURIComponent(svg)}`;
            this.svg_image = await (0, image_1.load_image)(src);
            this.parent.request_layout();
            return this.svg_image;
        }
        /**
         * Takes a Canvas' Context2d and if the image has already
         * been loaded draws the image in it otherwise draws the model's text.
        */
        paint(ctx) {
            if (!this.svg_image) {
                if (this.provider.status == "not_started" || this.provider.status == "loading")
                    this.provider.ready.connect(() => this.load_image());
                if (this.provider.status == "loaded")
                    this.load_image();
            }
            ctx.save();
            const { sx, sy } = this.position;
            const { angle } = this;
            if (angle != null && angle != 0) {
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            const { x, y } = this._computed_position();
            if (this.svg_image) {
                const { width, height } = this.get_image_dimensions();
                ctx.drawImage(this.svg_image, x, y, width, height);
            }
            else if (this.provider.status == "failed" || this.provider.status == "not_started") {
                ctx.fillStyle = this.color;
                ctx.font = this.font;
                ctx.textAlign = "left";
                ctx.textBaseline = "alphabetic";
                ctx.fillText(this.truncated_text, x, y + (0, text_1.font_metrics)(this.font).ascent);
            }
            ctx.restore();
            if (!this._has_finished && (this.provider.status == "failed" || this.svg_image)) {
                this._has_finished = true;
                this.parent.notify_finished_after_paint();
            }
        }
    }
    exports.MathTextView = MathTextView;
    MathTextView.__name__ = "MathTextView";
    class MathText extends base_text_1.BaseText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MathText = MathText;
    MathText.__name__ = "MathText";
    class AsciiView extends MathTextView {
        // TODO: Color ascii
        get styled_text() {
            return this.text;
        }
        _process_text() {
            return undefined; // TODO: this.provider.MathJax?.ascii2svg(text)
        }
        _size() {
            return {
                width: (0, graphics_1.text_width)(this.text, this.font),
                height: (0, text_1.font_metrics)(this.font).height,
            };
        }
        paint(ctx) {
            ctx.save();
            const { sx, sy } = this.position;
            const { angle } = this;
            if (angle != null && angle != 0) {
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            const { x, y } = this._computed_position();
            ctx.fillStyle = this.color;
            ctx.font = this.font;
            ctx.textAlign = "left";
            ctx.textBaseline = "alphabetic";
            ctx.fillText(this.text, x, y + (0, text_1.font_metrics)(this.font).ascent);
            ctx.restore();
            this._has_finished = true;
            this.parent.notify_finished_after_paint();
        }
    }
    exports.AsciiView = AsciiView;
    AsciiView.__name__ = "AsciiView";
    class Ascii extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Ascii = Ascii;
    _a = Ascii;
    Ascii.__name__ = "Ascii";
    (() => {
        _a.prototype.default_view = AsciiView;
    })();
    class MathMLView extends MathTextView {
        get styled_text() {
            let styled = this.text.trim();
            let matchs = styled.match(/<math(.*?[^?])?>/s);
            if (!matchs)
                return this.text.trim();
            styled = (0, string_1.insert_text_on_position)(styled, styled.indexOf(matchs[0]) + matchs[0].length, `<mstyle displaystyle="true" mathcolor="${(0, color_1.color2hexrgb)(this.color)}" ${this.font.includes("bold") ? 'mathvariant="bold"' : ""}>`);
            matchs = styled.match(/<\/[^>]*?math.*?>/s);
            if (!matchs)
                return this.text.trim();
            return (0, string_1.insert_text_on_position)(styled, styled.indexOf(matchs[0]), "</mstyle>");
        }
        _process_text() {
            var _d;
            const fmetrics = (0, text_1.font_metrics)(this.font);
            return (_d = this.provider.MathJax) === null || _d === void 0 ? void 0 : _d.mathml2svg(this.styled_text, {
                em: this.base_font_size,
                ex: fmetrics.x_height,
            });
        }
    }
    exports.MathMLView = MathMLView;
    MathMLView.__name__ = "MathMLView";
    class MathML extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MathML = MathML;
    _b = MathML;
    MathML.__name__ = "MathML";
    (() => {
        _b.prototype.default_view = MathMLView;
    })();
    class TeXView extends MathTextView {
        get styled_text() {
            const [r, g, b] = (0, color_1.color2rgba)(this.color);
            return `\\color[RGB]{${r}, ${g}, ${b}} ${this.font.includes("bold") ? `\\pmb{${this.text}}` : this.text}`;
        }
        _process_text() {
            var _d;
            // TODO: allow plot/document level configuration of macros
            const fmetrics = (0, text_1.font_metrics)(this.font);
            return (_d = this.provider.MathJax) === null || _d === void 0 ? void 0 : _d.tex2svg(this.styled_text, {
                display: !this.model.inline,
                em: this.base_font_size,
                ex: fmetrics.x_height,
            }, this.model.macros);
        }
    }
    exports.TeXView = TeXView;
    TeXView.__name__ = "TeXView";
    class TeX extends MathText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.TeX = TeX;
    _c = TeX;
    TeX.__name__ = "TeX";
    (() => {
        _c.prototype.default_view = TeXView;
        _c.define(({ Boolean, Number, String, Dict, Tuple, Or }) => ({
            macros: [Dict(Or(String, Tuple(String, Number))), {}],
            inline: [Boolean, false],
        }));
    })();
},
/* core/util/image.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const logging_1 = require(18) /* ../logging */;
    async function load_image(url, options) {
        return new ImageLoader(url, options).promise;
    }
    exports.load_image = load_image;
    class ImageLoader {
        constructor(url, config = {}) {
            this.image = new Image();
            this._finished = false;
            const { attempts = 1, timeout = 1 } = config;
            this.promise = new Promise((resolve, _reject) => {
                this.image.crossOrigin = "anonymous";
                let retries = 0;
                this.image.onerror = () => {
                    if (++retries == attempts) {
                        const message = `unable to load ${url} image after ${attempts} attempts`;
                        logging_1.logger.warn(message);
                        if (this.image.crossOrigin != null) {
                            logging_1.logger.warn(`attempting to load ${url} without a cross origin policy`);
                            this.image.crossOrigin = null;
                            retries = 0;
                        }
                        else {
                            if (config.failed != null)
                                config.failed();
                            return; // XXX reject(new Error(message))
                        }
                    }
                    setTimeout(() => this.image.src = url, timeout);
                };
                this.image.onload = () => {
                    this._finished = true;
                    if (config.loaded != null)
                        config.loaded(this.image);
                    resolve(this.image);
                };
                this.image.src = url;
            });
        }
        get finished() {
            return this._finished;
        }
    }
    exports.ImageLoader = ImageLoader;
    ImageLoader.__name__ = "ImageLoader";
},
/* core/graphics.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const bbox_1 = require(57) /* ./util/bbox */;
    const text_1 = require(152) /* ./util/text */;
    const array_1 = require(10) /* ./util/array */;
    const types_1 = require(8) /* ./util/types */;
    const affine_1 = require(153) /* ./util/affine */;
    const color_1 = require(21) /* ./util/color */;
    exports.text_width = (() => {
        const canvas = document.createElement("canvas");
        const ctx = canvas.getContext("2d");
        let current_font = "";
        return (text, font) => {
            if (font != current_font) {
                current_font = font;
                ctx.font = font;
            }
            return ctx.measureText(text).width;
        };
    })();
    class GraphicsBox {
        constructor() {
            this._position = { sx: 0, sy: 0 };
            this.font_size_scale = 1.0;
            this.align = "left";
            this._base_font_size = 13; // the same as :host's font-size (13px)
            this._x_anchor = "left";
            this._y_anchor = "center";
        }
        set base_font_size(v) {
            if (v != null)
                this._base_font_size = v;
        }
        get base_font_size() {
            return this._base_font_size;
        }
        set position(p) {
            this._position = p;
        }
        get position() {
            return this._position;
        }
        infer_text_height() {
            return "ascent_descent";
        }
        bbox() {
            const { p0, p1, p2, p3 } = this.rect();
            const left = Math.min(p0.x, p1.x, p2.x, p3.x);
            const top = Math.min(p0.y, p1.y, p2.y, p3.y);
            const right = Math.max(p0.x, p1.x, p2.x, p3.x);
            const bottom = Math.max(p0.y, p1.y, p2.y, p3.y);
            return new bbox_1.BBox({ left, right, top, bottom });
        }
        size() {
            const { width, height } = this._size();
            const { angle } = this;
            if (angle == null || angle == 0)
                return { width, height };
            else {
                const c = Math.cos(Math.abs(angle));
                const s = Math.sin(Math.abs(angle));
                return {
                    width: Math.abs(width * c + height * s),
                    height: Math.abs(width * s + height * c),
                };
            }
        }
        rect() {
            const rect = this._rect();
            const { angle } = this;
            if (angle == null || angle == 0)
                return rect;
            else {
                const { sx, sy } = this.position;
                const tr = new affine_1.AffineTransform();
                tr.translate(sx, sy);
                tr.rotate(angle);
                tr.translate(-sx, -sy);
                return tr.apply_rect(rect);
            }
        }
        paint_rect(ctx) {
            const { p0, p1, p2, p3 } = this.rect();
            ctx.save();
            ctx.strokeStyle = "red";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(p0.x), round(p0.y));
            ctx.lineTo(round(p1.x), round(p1.y));
            ctx.lineTo(round(p2.x), round(p2.y));
            ctx.lineTo(round(p3.x), round(p3.y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
        paint_bbox(ctx) {
            const { x, y, width, height } = this.bbox();
            ctx.save();
            ctx.strokeStyle = "blue";
            ctx.lineWidth = 1;
            ctx.beginPath();
            const { round } = Math;
            ctx.moveTo(round(x), round(y));
            ctx.lineTo(round(x), round(y + height));
            ctx.lineTo(round(x + width), round(y + height));
            ctx.lineTo(round(x + width), round(y));
            ctx.closePath();
            ctx.stroke();
            ctx.restore();
        }
    }
    exports.GraphicsBox = GraphicsBox;
    GraphicsBox.__name__ = "GraphicsBox";
    class TextBox extends GraphicsBox {
        constructor({ text }) {
            super();
            //padding: Padding
            this._visual_align = "left";
            this.text = text;
        }
        set visuals(v) {
            const color = v.color;
            const alpha = v.alpha;
            const outline_color = v.outline_color;
            const style = v.font_style;
            let size = v.font_size;
            const face = v.font;
            const { font_size_scale, base_font_size } = this;
            const res = (0, text_1.parse_css_font_size)(size);
            if (res != null) {
                let { value, unit } = res;
                value *= font_size_scale;
                if (unit == "em" && base_font_size) {
                    value *= base_font_size;
                    unit = "px";
                }
                size = `${value}${unit}`;
            }
            const font = `${style} ${size} ${face}`;
            this.font = font;
            this.color = (0, color_1.color2css)(color, alpha);
            this.outline_color = (0, color_1.color2css)(outline_color, alpha);
            this.line_height = v.line_height;
            const align = v.align;
            this._visual_align = align;
            this._x_anchor = align;
            const baseline = v.baseline;
            this._y_anchor = (() => {
                switch (baseline) {
                    case "top": return "top";
                    case "middle": return "center";
                    case "bottom": return "bottom";
                    default: return "baseline";
                }
            })();
        }
        infer_text_height() {
            if (this.text.includes("\n"))
                return "ascent_descent";
            else {
                function is_math_like(text) {
                    for (const c of new Set(text)) {
                        if ("0" <= c && c <= "9")
                            continue;
                        switch (c) {
                            case ",":
                            case ".":
                            case "+":
                            case "-":
                            case "\u2212":
                            case "e":
                                continue;
                            default:
                                return false;
                        }
                    }
                    return true;
                }
                if (is_math_like(this.text))
                    return "cap";
                else
                    return "ascent_descent";
            }
        }
        _text_line(fmetrics) {
            var _a;
            const metric = (_a = this.text_height_metric) !== null && _a !== void 0 ? _a : this.infer_text_height();
            const ascent = (() => {
                switch (metric) {
                    case "x":
                    case "x_descent":
                        return fmetrics.x_height;
                    case "cap":
                    case "cap_descent":
                        return fmetrics.cap_height;
                    case "ascent":
                    case "ascent_descent":
                        return fmetrics.ascent;
                }
            })();
            const descent = (() => {
                switch (metric) {
                    case "x":
                    case "cap":
                    case "ascent":
                        return 0;
                    case "x_descent":
                    case "cap_descent":
                    case "ascent_descent":
                        return fmetrics.descent;
                }
            })();
            return { height: ascent + descent, ascent, descent };
        }
        get nlines() {
            const lines = this.text.split("\n");
            return lines.length;
        }
        _size() {
            var _a, _b;
            const { font } = this;
            const fmetrics = (0, text_1.font_metrics)(font);
            const line_spacing = (this.line_height - 1) * fmetrics.height; // TODO: max(trailing(L[n-1]), leading(L[n]))
            const empty = this.text == "";
            const lines = this.text.split("\n");
            const nlines = lines.length;
            const widths = lines.map((line) => (0, exports.text_width)(line, font));
            const text_line = this._text_line(fmetrics);
            const text_height = text_line.height * nlines;
            /*
            const heights: number[] = []
            const ascents: number[] = []
            const descents: number[] = []
        
            for (const line of lines) {
              const metrics = [...line].map((c) => glyph_metrics(c, font))
              const max_ascent = Math.max(max(metrics.map((m) => m.ascent)), fmetrics.cap_height)
              const max_descent = max(metrics.map((m) => m.descent))
              ascents.push(max_ascent)
              descents.push(max_descent)
              heights.push(max_ascent + max_descent)
            }
        
            const text_height = sum(heights)
            */
            const w_scale = ((_a = this.width) === null || _a === void 0 ? void 0 : _a.unit) == "%" ? this.width.value : 1;
            const h_scale = ((_b = this.height) === null || _b === void 0 ? void 0 : _b.unit) == "%" ? this.height.value : 1;
            const width = (0, array_1.max)(widths) * w_scale;
            const height = empty ? 0 : (text_height + line_spacing * (nlines - 1)) * h_scale;
            return { width, height, metrics: fmetrics };
        }
        _computed_position(size, metrics, nlines) {
            const { width, height } = size;
            const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
            const x = sx - (() => {
                if ((0, types_1.isNumber)(x_anchor))
                    return x_anchor * width;
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            const y = sy - (() => {
                var _a;
                if ((0, types_1.isNumber)(y_anchor))
                    return y_anchor * height;
                else {
                    switch (y_anchor) {
                        case "top": return 0;
                        case "center": return 0.5 * height;
                        case "bottom": return height;
                        case "baseline": {
                            if (nlines == 1) {
                                const metric = (_a = this.text_height_metric) !== null && _a !== void 0 ? _a : this.infer_text_height();
                                switch (metric) {
                                    case "x":
                                    case "x_descent":
                                        return metrics.x_height;
                                    case "cap":
                                    case "cap_descent":
                                        return metrics.cap_height;
                                    case "ascent":
                                    case "ascent_descent":
                                        return metrics.ascent;
                                }
                            }
                            else
                                return 0.5 * height;
                        }
                    }
                }
            })();
            return { x, y };
        }
        _rect() {
            const { width, height, metrics } = this._size();
            const nlines = this.text.split("\n").length;
            const { x, y } = this._computed_position({ width, height }, metrics, nlines);
            const bbox = new bbox_1.BBox({ x, y, width, height });
            return bbox.rect;
        }
        paint(ctx) {
            var _a, _b;
            const { font } = this;
            const fmetrics = (0, text_1.font_metrics)(font);
            const line_spacing = (this.line_height - 1) * fmetrics.height; // TODO: see above
            const lines = this.text.split("\n");
            const nlines = lines.length;
            const widths = lines.map((line) => (0, exports.text_width)(line, font));
            const text_line = this._text_line(fmetrics);
            const text_height = text_line.height * nlines;
            /*
            const heights: number[] = []
            const ascents: number[] = []
            const descents: number[] = []
        
            for (const line of lines) {
              const metrics = [...line].map((c) => glyph_metrics(c, font))
              const max_ascent = Math.max(max(metrics.map((m) => m.ascent)), fmetrics.cap_height)
              const max_descent = max(metrics.map((m) => m.descent))
              ascents.push(max_ascent)
              descents.push(max_descent)
              heights.push(max_ascent + max_descent)
            }
            */
            const w_scale = ((_a = this.width) === null || _a === void 0 ? void 0 : _a.unit) == "%" ? this.width.value : 1;
            const h_scale = ((_b = this.height) === null || _b === void 0 ? void 0 : _b.unit) == "%" ? this.height.value : 1;
            const width = (0, array_1.max)(widths) * w_scale;
            const height = (text_height + line_spacing * (nlines - 1)) * h_scale;
            ctx.save();
            ctx.fillStyle = this.color;
            ctx.strokeStyle = this.outline_color;
            ctx.font = this.font;
            ctx.textAlign = "left";
            ctx.textBaseline = "alphabetic";
            const { sx, sy } = this.position;
            const { align } = this;
            const { angle } = this;
            if (angle != null && angle != 0) {
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            let { x, y } = this._computed_position({ width, height }, fmetrics, nlines);
            if (align == "justify") {
                for (let i = 0; i < nlines; i++) {
                    let xij = x;
                    const line = lines[i];
                    const words = line.split(" ");
                    const nwords = words.length;
                    const word_widths = words.map((word) => (0, exports.text_width)(word, font));
                    const word_spacing = (width - (0, array_1.sum)(word_widths)) / (nwords - 1);
                    for (let j = 0; j < nwords; j++) {
                        ctx.fillText(words[j], xij, y);
                        ctx.strokeText(words[j], xij, y);
                        xij += word_widths[j] + word_spacing;
                    }
                    y += /*heights[i]*/ text_line.height + line_spacing;
                }
            }
            else {
                for (let i = 0; i < nlines; i++) {
                    const xi = x + (() => {
                        switch (align == "auto" ? this._visual_align : align) {
                            case "left": return 0;
                            case "center": return 0.5 * (width - widths[i]);
                            case "right": return width - widths[i];
                        }
                    })();
                    const linei = lines[i];
                    const yi = y + /*ascents[i]*/ text_line.ascent;
                    ctx.fillText(linei, xi, yi);
                    ctx.strokeText(linei, xi, yi);
                    y += /*heights[i]*/ text_line.height + line_spacing;
                }
            }
            ctx.restore();
        }
    }
    exports.TextBox = TextBox;
    TextBox.__name__ = "TextBox";
    class BaseExpo extends GraphicsBox {
        constructor(base, expo) {
            super();
            this.base = base;
            this.expo = expo;
        }
        get children() {
            return [this.base, this.expo];
        }
        set base_font_size(v) {
            super.base_font_size = v;
            this.base.base_font_size = v;
            this.expo.base_font_size = v;
        }
        set position(p) {
            this._position = p;
            const bs = this.base.size();
            const es = this.expo.size();
            const shift = this._shift_scale() * bs.height;
            const height = Math.max(bs.height, shift + es.height);
            this.base.position = {
                sx: 0, x_anchor: "left",
                sy: height, y_anchor: "bottom",
            };
            this.expo.position = {
                sx: bs.width, x_anchor: "left",
                sy: shift, y_anchor: "bottom",
            };
        }
        get position() {
            return this._position;
        }
        set visuals(v) {
            this.expo.font_size_scale = 0.7;
            this.base.visuals = v;
            this.expo.visuals = v;
        }
        _shift_scale() {
            if (this.base instanceof TextBox && this.base.nlines == 1) {
                const { x_height, cap_height } = (0, text_1.font_metrics)(this.base.font);
                return x_height / cap_height;
            }
            else {
                return 2 / 3;
            }
        }
        infer_text_height() {
            return this.base.infer_text_height();
        }
        _rect() {
            const bb = this.base.bbox();
            const eb = this.expo.bbox();
            const bbox = bb.union(eb);
            const { x, y } = this._computed_position();
            return bbox.translate(x, y).rect;
        }
        _size() {
            const bs = this.base.size();
            const es = this.expo.size();
            return {
                width: bs.width + es.width,
                height: Math.max(bs.height, this._shift_scale() * bs.height + es.height),
            };
        }
        paint(ctx) {
            ctx.save();
            const { angle } = this;
            if (angle != null && angle != 0) {
                const { sx, sy } = this.position;
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.translate(-sx, -sy);
            }
            const { x, y } = this._computed_position();
            ctx.translate(x, y);
            this.base.paint(ctx);
            this.expo.paint(ctx);
            ctx.restore();
        }
        // paint_rect ...
        paint_bbox(ctx) {
            super.paint_bbox(ctx);
            const { x, y } = this._computed_position();
            ctx.save();
            ctx.translate(x, y);
            for (const child of this.children) {
                child.paint_bbox(ctx);
            }
            ctx.restore();
        }
        _computed_position() {
            const { width, height } = this._size();
            const { sx, sy, x_anchor = this._x_anchor, y_anchor = this._y_anchor } = this.position;
            const x = sx - (() => {
                if ((0, types_1.isNumber)(x_anchor))
                    return x_anchor * width;
                else {
                    switch (x_anchor) {
                        case "left": return 0;
                        case "center": return 0.5 * width;
                        case "right": return width;
                    }
                }
            })();
            const y = sy - (() => {
                if ((0, types_1.isNumber)(y_anchor))
                    return y_anchor * height;
                else {
                    switch (y_anchor) {
                        case "top": return 0;
                        case "center": return 0.5 * height;
                        case "bottom": return height;
                        case "baseline": return 0.5 * height; /* TODO */
                    }
                }
            })();
            return { x, y };
        }
    }
    exports.BaseExpo = BaseExpo;
    BaseExpo.__name__ = "BaseExpo";
    class GraphicsBoxes {
        constructor(items) {
            this.items = items;
        }
        set base_font_size(v) {
            for (const item of this.items) {
                item.base_font_size = v;
            }
        }
        get length() {
            return this.items.length;
        }
        set visuals(v) {
            for (const item of this.items) {
                item.visuals = v;
            }
            const metric_map = { x: 0, cap: 1, ascent: 2, x_descent: 3, cap_descent: 4, ascent_descent: 5 };
            const common = (0, array_1.max_by)(this.items.map((item) => item.infer_text_height()), (metric) => metric_map[metric]);
            for (const item of this.items) {
                item.text_height_metric = common;
            }
        }
        set angle(a) {
            for (const item of this.items) {
                item.angle = a;
            }
        }
        max_size() {
            let width = 0;
            let height = 0;
            for (const item of this.items) {
                const size = item.size();
                width = Math.max(width, size.width);
                height = Math.max(height, size.height);
            }
            return { width, height };
        }
    }
    exports.GraphicsBoxes = GraphicsBoxes;
    GraphicsBoxes.__name__ = "GraphicsBoxes";
},
/* core/util/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const assert_1 = require(12) /* ./assert */;
    const types_1 = require(8) /* ./types */;
    const has_OffscreenCanvas = (() => {
        try {
            return typeof OffscreenCanvas !== "undefined" && new OffscreenCanvas(0, 0).getContext("2d") != null;
        }
        catch (_a) {
            return false;
        }
    })();
    const _offscreen_canvas = (() => {
        if (has_OffscreenCanvas)
            return (w, h) => new OffscreenCanvas(w, h);
        else {
            return (w, h) => {
                const canvas = document.createElement("canvas");
                canvas.width = w;
                canvas.height = h;
                return canvas;
            };
        }
    })();
    const _native_font_metrics = (() => {
        const canvas = _offscreen_canvas(0, 0);
        const ctx = canvas.getContext("2d");
        return (font) => {
            ctx.font = font;
            const cap_metrics = ctx.measureText("M");
            const x_metrics = ctx.measureText("x");
            const metrics = ctx.measureText("ÅŚg|");
            const font_ascent = metrics.fontBoundingBoxAscent;
            const font_descent = metrics.fontBoundingBoxDescent;
            if ((0, types_1.is_defined)(font_ascent) && (0, types_1.is_defined)(font_descent)) {
                return {
                    height: font_ascent + font_descent,
                    ascent: font_ascent,
                    descent: font_descent,
                    cap_height: cap_metrics.actualBoundingBoxAscent,
                    x_height: x_metrics.actualBoundingBoxAscent,
                };
            }
            const text_ascent = metrics.actualBoundingBoxAscent;
            const text_descent = metrics.actualBoundingBoxDescent;
            if ((0, types_1.is_defined)(text_ascent) && (0, types_1.is_defined)(text_descent)) {
                return {
                    height: text_ascent + text_descent,
                    ascent: text_ascent,
                    descent: text_descent,
                    cap_height: cap_metrics.actualBoundingBoxAscent,
                    x_height: x_metrics.actualBoundingBoxAscent,
                };
            }
            (0, assert_1.unreachable)();
        };
    })();
    const _internal_font_metrics = (() => {
        const canvas = document.createElement("canvas");
        const ctx = canvas.getContext("2d");
        let cwidth = -1;
        let cheight = -1;
        return (font, scale = 1) => {
            ctx.font = font;
            const { width: _em } = ctx.measureText("M");
            const em = _em * scale;
            const width = Math.ceil(em);
            const height = Math.ceil(2.0 * em);
            const baseline = Math.ceil(1.5 * em);
            if (cwidth < width) {
                cwidth = width;
                canvas.width = width;
            }
            if (cheight < height) {
                cheight = height;
                canvas.height = height;
            }
            ctx.save();
            ctx.scale(scale, scale);
            ctx.fillStyle = "#f00";
            ctx.fillRect(0, 0, width, height);
            const measure_ascent = (data) => {
                let k = 0;
                for (let i = 0; i <= baseline; i++) {
                    for (let j = 0; j < width; j++, k += 4)
                        if (data[k] != 255)
                            return baseline - i;
                }
                return 0;
            };
            const measure_descent = (data) => {
                let k = data.length - 4;
                for (let i = height; i >= baseline; i--) {
                    for (let j = 0; j < width; j++, k -= 4)
                        if (data[k] != 255)
                            return i - baseline;
                }
                return 0;
            };
            ctx.font = font;
            ctx.fillStyle = "#000";
            for (const c of "xa") {
                ctx.fillText(c, 0, baseline / scale);
            }
            const { data: data0 } = ctx.getImageData(0, 0, width, height);
            const x_height = measure_ascent(data0) / scale;
            for (const c of "ASQ") {
                ctx.fillText(c, 0, baseline / scale);
            }
            const { data: data1 } = ctx.getImageData(0, 0, width, height);
            const cap_height = measure_ascent(data1) / scale;
            for (const c of "ÅŚgy") {
                ctx.fillText(c, 0, baseline / scale);
            }
            const { data: data2 } = ctx.getImageData(0, 0, width, height);
            const ascent = measure_ascent(data2) / scale;
            const descent = measure_descent(data2) / scale;
            ctx.restore();
            return { height: ascent + descent, ascent, cap_height, x_height, descent };
        };
    })();
    const _font_metrics = (() => {
        try {
            _native_font_metrics("normal 10px sans-serif");
            return _native_font_metrics;
        }
        catch (_a) {
            return _internal_font_metrics;
        }
    })();
    const _metrics_cache = new Map();
    function font_metrics(font) {
        let metrics = _metrics_cache.get(font);
        if (metrics == null) {
            const loaded = document.fonts.check(font);
            metrics = { font: _font_metrics(font) };
            if (loaded) {
                _metrics_cache.set(font, metrics);
            }
        }
        return metrics.font;
    }
    exports.font_metrics = font_metrics;
    function parse_css_font_size(size) {
        const match = size.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);
        if (match != null) {
            const [, value, , unit] = match;
            const number = Number(value);
            if (isFinite(number))
                return { value: number, unit };
        }
        return null;
    }
    exports.parse_css_font_size = parse_css_font_size;
    function parse_css_length(size) {
        const match = size.match(/^\s*(-?\d+(\.\d+)?)(\w+)\s*$/);
        if (match != null) {
            const [, value, , unit] = match;
            const number = Number(value);
            if (isFinite(number))
                return { value: number, unit };
        }
        return null;
    }
    exports.parse_css_length = parse_css_length;
},
/* core/util/affine.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const { sin, cos } = Math;
    class AffineTransform {
        constructor(a = 1, b = 0, c = 0, d = 1, e = 0, f = 0) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }
        toString() {
            const { a, b, c, d, e, f } = this;
            return `matrix(${a}, ${b}, ${c}, ${d}, ${e}, ${f})`;
        }
        static from_DOMMatrix(matrix) {
            const { a, b, c, d, e, f } = matrix;
            return new AffineTransform(a, b, c, d, e, f);
        }
        to_DOMMatrix() {
            const { a, b, c, d, e, f } = this;
            return new DOMMatrix([a, b, c, d, e, f]);
        }
        clone() {
            const { a, b, c, d, e, f } = this;
            return new AffineTransform(a, b, c, d, e, f);
        }
        get is_identity() {
            const { a, b, c, d, e, f } = this;
            return a == 1 && b == 0 && c == 0 && d == 1 && e == 0 && f == 0;
        }
        apply_point(p) {
            const [x, y] = this.apply(p.x, p.y);
            return { x, y };
        }
        apply_rect(rect) {
            const p0 = this.apply_point(rect.p0);
            const p1 = this.apply_point(rect.p1);
            const p2 = this.apply_point(rect.p2);
            const p3 = this.apply_point(rect.p3);
            return { p0, p1, p2, p3 };
        }
        apply(x, y) {
            const { a, b, c, d, e, f } = this;
            return [
                a * x + c * y + e,
                b * x + d * y + f,
            ];
        }
        iv_apply(xs, ys) {
            const { a, b, c, d, e, f } = this;
            const n = xs.length;
            for (let i = 0; i < n; i++) {
                const x = xs[i];
                const y = ys[i];
                xs[i] = a * x + c * y + e;
                ys[i] = b * x + d * y + f;
            }
        }
        transform(A, B, C, D, E, F) {
            const { a, b, c, d, e, f } = this;
            this.a = a * A + c * B;
            this.c = a * C + c * D;
            this.e = a * E + c * F + e;
            this.b = b * A + d * B;
            this.d = b * C + d * D;
            this.f = b * E + d * F + f;
            return this;
        }
        translate(tx, ty) {
            return this.transform(1, 0, 0, 1, tx, ty);
        }
        scale(cx, cy) {
            return this.transform(cx, 0, 0, cy, 0, 0);
        }
        skew(sx, sy) {
            return this.transform(1, sy, sx, 1, 0, 0);
        }
        rotate(angle) {
            const s = sin(angle);
            const c = cos(angle);
            return this.transform(c, s, -s, c, 0, 0);
        }
        rotate_ccw(angle) {
            return this.rotate(-angle);
        }
        translate_x(tx) {
            return this.translate(tx, 0);
        }
        translate_y(ty) {
            return this.translate(0, ty);
        }
        flip() {
            return this.scale(-1, -1);
        }
        flip_x() {
            return this.scale(1, -1);
        }
        flip_y() {
            return this.scale(-1, 1);
        }
    }
    exports.AffineTransform = AffineTransform;
    AffineTransform.__name__ = "AffineTransform";
},
/* models/text/providers.js */ function _(require, module, exports, __esModule, __esExport) {
    var __createBinding = (this && this.__createBinding) || (Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    }));
    var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    });
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    };
    __esModule();
    const signaling_1 = require(15) /* ../../core/signaling */;
    const modules_1 = require(155) /* ../../core/util/modules */;
    class MathJaxProvider {
        constructor() {
            this.ready = new signaling_1.Signal0(this, "ready");
            this.status = "not_started";
        }
    }
    exports.MathJaxProvider = MathJaxProvider;
    MathJaxProvider.__name__ = "MathJaxProvider";
    class NoProvider extends MathJaxProvider {
        get MathJax() {
            return null;
        }
        async fetch() {
            this.status = "failed";
        }
    }
    exports.NoProvider = NoProvider;
    NoProvider.__name__ = "NoProvider";
    class CDNProvider extends MathJaxProvider {
        get MathJax() {
            return typeof MathJax !== "undefined" ? MathJax : null;
        }
        async fetch() {
            const script = document.createElement("script");
            script.src = "https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js";
            script.onload = () => {
                this.status = "loaded";
                this.ready.emit();
            };
            script.onerror = () => {
                this.status = "failed";
            };
            this.status = "loading";
            document.head.appendChild(script);
        }
    }
    exports.CDNProvider = CDNProvider;
    CDNProvider.__name__ = "CDNProvider";
    class BundleProvider extends MathJaxProvider {
        get MathJax() {
            return this._mathjax;
        }
        async fetch() {
            this.status = "loading";
            try {
                const mathjax = await (0, modules_1.load_module)(Promise.resolve().then(() => __importStar(require(629) /* ./mathjax */)));
                this._mathjax = mathjax;
                this.status = "loaded";
                this.ready.emit();
            }
            catch (error) {
                this.status = "failed";
            }
        }
    }
    exports.BundleProvider = BundleProvider;
    BundleProvider.__name__ = "BundleProvider";
    exports.default_provider = new BundleProvider();
},
/* core/util/modules.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function is_ModuleError(error) {
        return error instanceof Error && "code" in error;
    }
    /** T is of import("some/module/path") type */
    async function load_module(module) {
        try {
            return await module;
        }
        catch (e) {
            // XXX: this exposes the underyling module system and hinders
            // interoperability with other module systems and bundlers
            if (is_ModuleError(e) && e.code === "MODULE_NOT_FOUND")
                return null;
            else
                throw e;
        }
    }
    exports.load_module = load_module;
},
/* models/text/plain_text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const base_text_1 = require(147) /* ./base_text */;
    const graphics_1 = require(151) /* ../../core/graphics */;
    class PlainTextView extends base_text_1.BaseTextView {
        initialize() {
            super.initialize();
            this._has_finished = true;
        }
        graphics() {
            return new graphics_1.TextBox({ text: this.model.text });
        }
    }
    exports.PlainTextView = PlainTextView;
    PlainTextView.__name__ = "PlainTextView";
    class PlainText extends base_text_1.BaseText {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.PlainText = PlainText;
    _a = PlainText;
    PlainText.__name__ = "PlainText";
    (() => {
        _a.prototype.default_view = PlainTextView;
    })();
},
/* models/canvas/cartesian_frame.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const categorical_scale_1 = require(92) /* ../scales/categorical_scale */;
    const log_scale_1 = require(91) /* ../scales/log_scale */;
    const range1d_1 = require(88) /* ../ranges/range1d */;
    const data_range1d_1 = require(93) /* ../ranges/data_range1d */;
    const factor_range_1 = require(96) /* ../ranges/factor_range */;
    const bbox_1 = require(57) /* ../../core/util/bbox */;
    const object_1 = require(9) /* ../../core/util/object */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    const signaling_1 = require(15) /* ../../core/signaling */;
    class CartesianFrame {
        constructor(in_x_scale, in_y_scale, x_range, y_range, extra_x_ranges = {}, extra_y_ranges = {}, extra_x_scales = {}, extra_y_scales = {}) {
            this.in_x_scale = in_x_scale;
            this.in_y_scale = in_y_scale;
            this.x_range = x_range;
            this.y_range = y_range;
            this.extra_x_ranges = extra_x_ranges;
            this.extra_y_ranges = extra_y_ranges;
            this.extra_x_scales = extra_x_scales;
            this.extra_y_scales = extra_y_scales;
            this._bbox = new bbox_1.BBox();
            this.change = new signaling_1.Signal0(this, "change");
            (0, assert_1.assert)(in_x_scale.properties.source_range.is_unset && in_x_scale.properties.target_range.is_unset);
            (0, assert_1.assert)(in_y_scale.properties.source_range.is_unset && in_y_scale.properties.target_range.is_unset);
            this._configure_scales();
        }
        get bbox() {
            return this._bbox;
        }
        _get_ranges(range, extra_ranges) {
            return new Map((0, object_1.entries)(Object.assign(Object.assign({}, extra_ranges), { default: range })));
        }
        /*protected*/ _get_scales(scale, extra_scales, ranges, frame_range) {
            var _a;
            const in_scales = new Map((0, object_1.entries)(Object.assign(Object.assign({}, extra_scales), { default: scale })));
            const scales = new Map();
            for (const [name, range] of ranges) {
                const factor_range = range instanceof factor_range_1.FactorRange;
                const categorical_scale = scale instanceof categorical_scale_1.CategoricalScale;
                if (factor_range != categorical_scale) {
                    throw new Error(`Range ${range.type} is incompatible is Scale ${scale.type}`);
                }
                if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                    range.scale_hint = "log";
                const derived_scale = ((_a = in_scales.get(name)) !== null && _a !== void 0 ? _a : scale).clone();
                derived_scale.setv({ source_range: range, target_range: frame_range });
                scales.set(name, derived_scale);
            }
            return scales;
        }
        _configure_frame_ranges() {
            // data to/from screen space transform (left-bottom <-> left-top origin)
            const { bbox } = this;
            this._x_target = new range1d_1.Range1d({ start: bbox.left, end: bbox.right });
            this._y_target = new range1d_1.Range1d({ start: bbox.bottom, end: bbox.top });
        }
        _configure_scales() {
            this._configure_frame_ranges();
            this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges);
            this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges);
            this._x_scales = this._get_scales(this.in_x_scale, this.extra_x_scales, this._x_ranges, this._x_target);
            this._y_scales = this._get_scales(this.in_y_scale, this.extra_y_scales, this._y_ranges, this._y_target);
        }
        configure_scales() {
            this._configure_scales();
            this.change.emit();
        }
        _update_scales() {
            this._configure_frame_ranges();
            for (const [, scale] of this._x_scales) {
                scale.target_range = this._x_target;
            }
            for (const [, scale] of this._y_scales) {
                scale.target_range = this._y_target;
            }
        }
        set_geometry(bbox) {
            this._bbox = bbox;
            this._update_scales();
        }
        get x_target() {
            return this._x_target;
        }
        get y_target() {
            return this._y_target;
        }
        get x_ranges() {
            return this._x_ranges;
        }
        get y_ranges() {
            return this._y_ranges;
        }
        get ranges() {
            return new Set([...this.x_ranges.values(), ...this.y_ranges.values()]);
        }
        get x_scales() {
            return this._x_scales;
        }
        get y_scales() {
            return this._y_scales;
        }
        get scales() {
            return new Set([...this.x_scales.values(), ...this.y_scales.values()]);
        }
        get x_scale() {
            return this._x_scales.get("default");
        }
        get y_scale() {
            return this._y_scales.get("default");
        }
    }
    exports.CartesianFrame = CartesianFrame;
    CartesianFrame.__name__ = "CartesianFrame";
},
/* models/axes/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var axis_1 = require(159) /* ./axis */;
    __esExport("Axis", axis_1.Axis);
    var categorical_axis_1 = require(164) /* ./categorical_axis */;
    __esExport("CategoricalAxis", categorical_axis_1.CategoricalAxis);
    var continuous_axis_1 = require(167) /* ./continuous_axis */;
    __esExport("ContinuousAxis", continuous_axis_1.ContinuousAxis);
    var datetime_axis_1 = require(168) /* ./datetime_axis */;
    __esExport("DatetimeAxis", datetime_axis_1.DatetimeAxis);
    var linear_axis_1 = require(184) /* ./linear_axis */;
    __esExport("LinearAxis", linear_axis_1.LinearAxis);
    var log_axis_1 = require(186) /* ./log_axis */;
    __esExport("LogAxis", log_axis_1.LogAxis);
    var mercator_axis_1 = require(189) /* ./mercator_axis */;
    __esExport("MercatorAxis", mercator_axis_1.MercatorAxis);
},
/* models/axes/axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const guide_renderer_1 = require(160) /* ../renderers/guide_renderer */;
    const ticker_1 = require(161) /* ../tickers/ticker */;
    const tick_formatter_1 = require(162) /* ../formatters/tick_formatter */;
    const labeling_1 = require(163) /* ../policies/labeling */;
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    const enums_1 = require(19) /* ../../core/enums */;
    const types_1 = require(23) /* ../../core/types */;
    const side_panel_1 = require(144) /* ../../core/layout/side_panel */;
    const array_1 = require(10) /* ../../core/util/array */;
    const object_1 = require(9) /* ../../core/util/object */;
    const types_2 = require(8) /* ../../core/util/types */;
    const graphics_1 = require(151) /* ../../core/graphics */;
    const factor_range_1 = require(96) /* ../ranges/factor_range */;
    const base_text_1 = require(147) /* ../text/base_text */;
    const build_views_1 = require(59) /* ../../core/build_views */;
    const assert_1 = require(12) /* ../../core/util/assert */;
    const types_3 = require(8) /* ../../core/util/types */;
    const utils_1 = require(148) /* ../text/utils */;
    const { abs } = Math;
    class AxisView extends guide_renderer_1.GuideRendererView {
        constructor() {
            super(...arguments);
            /*private*/ this._axis_label_view = null;
            /*private*/ this._major_label_views = new Map();
        }
        *children() {
            yield* super.children();
            if (this._axis_label_view != null)
                yield this._axis_label_view;
            yield* this._major_label_views.values();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await this._init_axis_label();
            await this._init_major_labels();
        }
        async _init_axis_label() {
            const { axis_label } = this.model;
            if (axis_label != null) {
                const _axis_label = (0, types_3.isString)(axis_label) ? (0, utils_1.parse_delimited_string)(axis_label) : axis_label;
                this._axis_label_view = await (0, build_views_1.build_view)(_axis_label, { parent: this });
            }
            else
                this._axis_label_view = null;
        }
        async _init_major_labels() {
            for (const [label, label_text] of this.model.major_label_overrides) {
                const _label_text = (0, types_3.isString)(label_text) ? (0, utils_1.parse_delimited_string)(label_text) : label_text;
                this._major_label_views.set(label, await (0, build_views_1.build_view)(_label_text, { parent: this }));
            }
        }
        update_layout() {
            this.layout = new side_panel_1.SideLayout(this.panel, () => this.get_size(), true);
            this.layout.on_resize(() => this._coordinates = undefined);
        }
        get_size() {
            const { visible, fixed_location } = this.model;
            if (visible && fixed_location == null && this.is_renderable) {
                const { extents } = this;
                const height = Math.round(extents.tick + extents.tick_label + extents.axis_label);
                return { width: 0, height };
            }
            else
                return { width: 0, height: 0 };
        }
        get is_renderable() {
            const [range, cross_range] = this.ranges;
            return range.is_valid && cross_range.is_valid && range.span > 0 && cross_range.span > 0;
        }
        _render() {
            var _b;
            if (!this.is_renderable)
                return;
            const { tick_coords, extents } = this;
            const ctx = this.layer.ctx;
            ctx.save();
            this._draw_rule(ctx, extents);
            this._draw_major_ticks(ctx, extents, tick_coords);
            this._draw_minor_ticks(ctx, extents, tick_coords);
            this._draw_major_labels(ctx, extents, tick_coords);
            this._draw_axis_label(ctx, extents, tick_coords);
            (_b = this._paint) === null || _b === void 0 ? void 0 : _b.call(this, ctx, extents, tick_coords);
            ctx.restore();
        }
        connect_signals() {
            super.connect_signals();
            const { axis_label, major_label_overrides } = this.model.properties;
            this.on_change(axis_label, async () => {
                var _b;
                (_b = this._axis_label_view) === null || _b === void 0 ? void 0 : _b.remove();
                await this._init_axis_label();
            });
            this.on_change(major_label_overrides, async () => {
                for (const label_view of this._major_label_views.values()) {
                    label_view.remove();
                }
                await this._init_major_labels();
            });
            this.connect(this.model.change, () => this.plot_view.request_layout());
        }
        get needs_clip() {
            return this.model.fixed_location != null;
        }
        // drawing sub functions -----------------------------------------------------
        _draw_rule(ctx, _extents) {
            if (!this.visuals.axis_line.doit)
                return;
            const [xs, ys] = this.rule_coords;
            const [sxs, sys] = this.coordinates.map_to_screen(xs, ys);
            const [nx, ny] = this.normals;
            const [xoff, yoff] = this.offsets;
            this.visuals.axis_line.set_value(ctx);
            ctx.beginPath();
            for (let i = 0; i < sxs.length; i++) {
                const sx = Math.round(sxs[i] + nx * xoff);
                const sy = Math.round(sys[i] + ny * yoff);
                ctx.lineTo(sx, sy);
            }
            ctx.stroke();
        }
        _draw_major_ticks(ctx, _extents, tick_coords) {
            const tin = this.model.major_tick_in;
            const tout = this.model.major_tick_out;
            const visuals = this.visuals.major_tick_line;
            this._draw_ticks(ctx, tick_coords.major, tin, tout, visuals);
        }
        _draw_minor_ticks(ctx, _extents, tick_coords) {
            const tin = this.model.minor_tick_in;
            const tout = this.model.minor_tick_out;
            const visuals = this.visuals.minor_tick_line;
            this._draw_ticks(ctx, tick_coords.minor, tin, tout, visuals);
        }
        _draw_major_labels(ctx, extents, tick_coords) {
            const coords = tick_coords.major;
            const labels = this.compute_labels(coords[this.dimension]);
            const orient = this.model.major_label_orientation;
            const standoff = extents.tick + this.model.major_label_standoff;
            const visuals = this.visuals.major_label_text;
            this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
        }
        _axis_label_extent() {
            if (this._axis_label_view == null)
                return 0;
            const axis_label_graphics = this._axis_label_view.graphics();
            const padding = 3;
            axis_label_graphics.visuals = this.visuals.axis_label_text.values();
            axis_label_graphics.angle = this.panel.get_label_angle_heuristic("parallel");
            if ((0, types_2.isNumber)(this.plot_view.base_font_size))
                axis_label_graphics.base_font_size = this.plot_view.base_font_size;
            const size = axis_label_graphics.size();
            const extent = this.dimension == 0 ? size.height : size.width;
            const standoff = this.model.axis_label_standoff;
            return extent > 0 ? standoff + extent + padding : 0;
        }
        _draw_axis_label(ctx, extents, _tick_coords) {
            if (this._axis_label_view == null || this.model.fixed_location != null)
                return;
            const [sx, sy] = (() => {
                const { bbox } = this.layout;
                switch (this.panel.side) {
                    case "above":
                        return [bbox.hcenter, bbox.bottom];
                    case "below":
                        return [bbox.hcenter, bbox.top];
                    case "left":
                        return [bbox.right, bbox.vcenter];
                    case "right":
                        return [bbox.left, bbox.vcenter];
                }
            })();
            const [nx, ny] = this.normals;
            const standoff = extents.tick + extents.tick_label + this.model.axis_label_standoff;
            const { vertical_align, align } = this.panel.get_label_text_heuristics("parallel");
            const position = {
                sx: sx + nx * standoff,
                sy: sy + ny * standoff,
                x_anchor: align,
                y_anchor: vertical_align,
            };
            const axis_label_graphics = this._axis_label_view.graphics();
            axis_label_graphics.visuals = this.visuals.axis_label_text.values();
            axis_label_graphics.angle = this.panel.get_label_angle_heuristic("parallel");
            if (this.plot_view.base_font_size != null)
                axis_label_graphics.base_font_size = this.plot_view.base_font_size;
            axis_label_graphics.position = position;
            axis_label_graphics.align = align;
            axis_label_graphics.paint(ctx);
        }
        _draw_ticks(ctx, coords, tin, tout, visuals) {
            if (!visuals.doit)
                return;
            const [x, y] = coords;
            const [sxs, sys] = this.coordinates.map_to_screen(x, y);
            const [nx, ny] = this.normals;
            const [xoff, yoff] = this.offsets;
            const [nxin, nyin] = [nx * (xoff - tin), ny * (yoff - tin)];
            const [nxout, nyout] = [nx * (xoff + tout), ny * (yoff + tout)];
            visuals.set_value(ctx);
            ctx.beginPath();
            for (let i = 0; i < sxs.length; i++) {
                const sx0 = Math.round(sxs[i] + nxout);
                const sy0 = Math.round(sys[i] + nyout);
                const sx1 = Math.round(sxs[i] + nxin);
                const sy1 = Math.round(sys[i] + nyin);
                ctx.moveTo(sx0, sy0);
                ctx.lineTo(sx1, sy1);
            }
            ctx.stroke();
        }
        _draw_oriented_labels(ctx, labels, coords, orient, _side, standoff, visuals) {
            if (!visuals.doit || labels.length == 0)
                return;
            const [dxs, dys] = coords;
            const [sxs, sys] = this.coordinates.map_to_screen(dxs, dys);
            const [xoff, yoff] = this.offsets;
            const [nx, ny] = this.normals;
            const nxd = nx * (xoff + standoff);
            const nyd = ny * (yoff + standoff);
            const { vertical_align, align } = this.panel.get_label_text_heuristics(orient);
            const angle = this.panel.get_label_angle_heuristic(orient);
            labels.visuals = visuals.values();
            labels.angle = angle;
            labels.base_font_size = this.plot_view.base_font_size;
            for (let i = 0; i < labels.length; i++) {
                const label = labels.items[i];
                label.position = {
                    sx: sxs[i] + nxd,
                    sy: sys[i] + nyd,
                    x_anchor: align,
                    y_anchor: vertical_align,
                };
                if (label instanceof graphics_1.TextBox)
                    label.align = align;
            }
            const n = labels.length;
            const indices = types_1.Indices.all_set(n);
            const { items } = labels;
            const bboxes = items.map((l) => l.bbox());
            const dist = (() => {
                const [range] = this.ranges;
                if (!range.is_reversed)
                    return this.dimension == 0 ? (i, j) => bboxes[j].left - bboxes[i].right
                        : (i, j) => bboxes[i].top - bboxes[j].bottom;
                else
                    return this.dimension == 0 ? (i, j) => bboxes[i].left - bboxes[j].right
                        : (i, j) => bboxes[j].top - bboxes[i].bottom;
            })();
            const { major_label_policy } = this.model;
            const selected = major_label_policy.filter(indices, bboxes, dist);
            const ids = [...selected.ones()];
            if (ids.length != 0) {
                const cbox = this.parent.canvas_view.bbox;
                const correct_x = (k) => {
                    const bbox = bboxes[k];
                    if (bbox.left < 0) {
                        const offset = -bbox.left;
                        const { position } = items[k];
                        items[k].position = Object.assign(Object.assign({}, position), { sx: position.sx + offset });
                    }
                    else if (bbox.right > cbox.width) {
                        const offset = bbox.right - cbox.width;
                        const { position } = items[k];
                        items[k].position = Object.assign(Object.assign({}, position), { sx: position.sx - offset });
                    }
                };
                const correct_y = (k) => {
                    const bbox = bboxes[k];
                    if (bbox.top < 0) {
                        const offset = -bbox.top;
                        const { position } = items[k];
                        items[k].position = Object.assign(Object.assign({}, position), { sy: position.sy + offset });
                    }
                    else if (bbox.bottom > cbox.height) {
                        const offset = bbox.bottom - cbox.height;
                        const { position } = items[k];
                        items[k].position = Object.assign(Object.assign({}, position), { sy: position.sy - offset });
                    }
                };
                const i = ids[0];
                const j = ids[ids.length - 1];
                if (this.dimension == 0) {
                    correct_x(i);
                    correct_x(j);
                }
                else {
                    correct_y(i);
                    correct_y(j);
                }
            }
            for (const i of selected) {
                const label = items[i];
                label.paint(ctx);
            }
        }
        // extents sub functions -----------------------------------------------------
        /*protected*/ _tick_extent() {
            return this.model.major_tick_out;
        }
        _tick_label_extents() {
            const coords = this.tick_coords.major;
            const labels = this.compute_labels(coords[this.dimension]);
            const orient = this.model.major_label_orientation;
            const standoff = this.model.major_label_standoff;
            const visuals = this.visuals.major_label_text;
            return [this._oriented_labels_extent(labels, orient, standoff, visuals)];
        }
        get extents() {
            const tick_labels = this._tick_label_extents();
            return {
                tick: this._tick_extent(),
                tick_labels,
                tick_label: (0, array_1.sum)(tick_labels),
                axis_label: this._axis_label_extent(),
            };
        }
        _oriented_labels_extent(labels, orient, standoff, visuals) {
            if (labels.length == 0 || !visuals.doit)
                return 0;
            const angle = this.panel.get_label_angle_heuristic(orient);
            labels.visuals = visuals.values();
            labels.angle = angle;
            labels.base_font_size = this.plot_view.base_font_size;
            const size = labels.max_size();
            const extent = this.dimension == 0 ? size.height : size.width;
            const padding = 3;
            return extent > 0 ? standoff + extent + padding : 0;
        }
        // {{{ TODO: state
        get normals() {
            return this.panel.normals;
        }
        get dimension() {
            return this.panel.dimension;
        }
        compute_labels(ticks) {
            const labels = this.model.formatter.format_graphics(ticks, this);
            const { _major_label_views } = this;
            const visited = new Set();
            for (let i = 0; i < ticks.length; i++) {
                const override = _major_label_views.get(ticks[i]);
                if (override != null) {
                    visited.add(override);
                    labels[i] = override.graphics();
                }
            }
            // XXX: make sure unused overrides don't prevent document idle
            for (const label_view of this._major_label_views.values()) {
                if (!visited.has(label_view)) {
                    label_view._has_finished = true;
                }
            }
            return new graphics_1.GraphicsBoxes(labels);
        }
        get offsets() {
            // If we have a fixed_position then we should respect that exactly and
            // not apply any offsets (https://github.com/bokeh/bokeh/issues/8552)
            if (this.model.fixed_location != null)
                return [0, 0];
            const { frame } = this.plot_view;
            let [xoff, yoff] = [0, 0];
            switch (this.panel.side) {
                case "below":
                    yoff = abs(this.layout.bbox.top - frame.bbox.bottom);
                    break;
                case "above":
                    yoff = abs(this.layout.bbox.bottom - frame.bbox.top);
                    break;
                case "right":
                    xoff = abs(this.layout.bbox.left - frame.bbox.right);
                    break;
                case "left":
                    xoff = abs(this.layout.bbox.right - frame.bbox.left);
                    break;
            }
            return [xoff, yoff];
        }
        get ranges() {
            const i = this.dimension;
            const j = 1 - i;
            const { ranges } = this.coordinates;
            return [ranges[i], ranges[j]];
        }
        get computed_bounds() {
            const [range] = this.ranges;
            const user_bounds = this.model.bounds;
            const range_bounds = [range.min, range.max];
            if (user_bounds == "auto")
                return [range.min, range.max];
            else {
                let start;
                let end;
                const [user_start, user_end] = user_bounds;
                const [range_start, range_end] = range_bounds;
                const { min, max } = Math;
                if (abs(user_start - user_end) > abs(range_start - range_end)) {
                    start = max(min(user_start, user_end), range_start);
                    end = min(max(user_start, user_end), range_end);
                }
                else {
                    start = min(user_start, user_end);
                    end = max(user_start, user_end);
                }
                return [start, end];
            }
        }
        get rule_coords() {
            const i = this.dimension;
            const j = 1 - i;
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            const xs = new Array(2);
            const ys = new Array(2);
            const coords = [xs, ys];
            coords[i][0] = Math.max(start, range.min);
            coords[i][1] = Math.min(end, range.max);
            if (coords[i][0] > coords[i][1])
                coords[i][0] = coords[i][1] = NaN;
            coords[j][0] = this.loc;
            coords[j][1] = this.loc;
            return coords;
        }
        get tick_coords() {
            const i = this.dimension;
            const j = 1 - i;
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            const ticks = this.model.ticker.get_ticks(start, end, range, this.loc);
            const majors = ticks.major;
            const minors = ticks.minor;
            const xs = [];
            const ys = [];
            const coords = [xs, ys];
            const minor_xs = [];
            const minor_ys = [];
            const minor_coords = [minor_xs, minor_ys];
            const [range_min, range_max] = [range.min, range.max];
            for (let ii = 0; ii < majors.length; ii++) {
                if (majors[ii] < range_min || majors[ii] > range_max)
                    continue;
                coords[i].push(majors[ii]);
                coords[j].push(this.loc);
            }
            for (let ii = 0; ii < minors.length; ii++) {
                if (minors[ii] < range_min || minors[ii] > range_max)
                    continue;
                minor_coords[i].push(minors[ii]);
                minor_coords[j].push(this.loc);
            }
            return {
                major: coords,
                minor: minor_coords,
            };
        }
        get loc() {
            const { fixed_location } = this.model;
            if (fixed_location != null) {
                if ((0, types_2.isNumber)(fixed_location))
                    return fixed_location;
                const [, cross_range] = this.ranges;
                if (cross_range instanceof factor_range_1.FactorRange)
                    return cross_range.synthetic(fixed_location);
                (0, assert_1.unreachable)();
            }
            const [, cross_range] = this.ranges;
            switch (this.panel.side) {
                case "left":
                case "below":
                    return cross_range.start;
                case "right":
                case "above":
                    return cross_range.end;
            }
        }
        // }}}
        serializable_state() {
            return Object.assign(Object.assign({}, super.serializable_state()), { bbox: this.layout.bbox.box });
        }
        remove() {
            var _b;
            (_b = this._axis_label_view) === null || _b === void 0 ? void 0 : _b.remove();
            for (const label_view of this._major_label_views.values()) {
                label_view.remove();
            }
            super.remove();
        }
        has_finished() {
            if (!super.has_finished())
                return false;
            if (this._axis_label_view != null) {
                if (!this._axis_label_view.has_finished())
                    return false;
            }
            for (const label_view of this._major_label_views.values()) {
                if (!label_view.has_finished())
                    return false;
            }
            return true;
        }
    }
    exports.AxisView = AxisView;
    AxisView.__name__ = "AxisView";
    class Axis extends guide_renderer_1.GuideRenderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Axis = Axis;
    _a = Axis;
    Axis.__name__ = "Axis";
    (() => {
        _a.prototype.default_view = AxisView;
        _a.mixins([
            ["axis_", mixins.Line],
            ["major_tick_", mixins.Line],
            ["minor_tick_", mixins.Line],
            ["major_label_", mixins.Text],
            ["axis_label_", mixins.Text],
        ]);
        _a.define(({ Any, Int, Number, String, Ref, Map, Tuple, Or, Nullable, Auto }) => ({
            bounds: [Or(Tuple(Number, Number), Auto), "auto"],
            ticker: [Ref(ticker_1.Ticker)],
            formatter: [Ref(tick_formatter_1.TickFormatter)],
            axis_label: [Nullable(Or(String, Ref(base_text_1.BaseText))), null],
            axis_label_standoff: [Int, 5],
            major_label_standoff: [Int, 5],
            major_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "horizontal"],
            major_label_overrides: [Map(Or(String, Number), Or(String, Ref(base_text_1.BaseText))), new globalThis.Map(), {
                    convert(v) {
                        return (0, types_2.isPlainObject)(v) ? new object_1.Dict(v) : v;
                    },
                }],
            major_label_policy: [Ref(labeling_1.LabelingPolicy), () => new labeling_1.AllLabels()],
            major_tick_in: [Number, 2],
            major_tick_out: [Number, 6],
            minor_tick_in: [Number, 0],
            minor_tick_out: [Number, 4],
            fixed_location: [Nullable(Or(Number, Any)), null],
        }));
        _a.override({
            axis_line_color: "black",
            major_tick_line_color: "black",
            minor_tick_line_color: "black",
            major_label_text_font_size: "11px",
            major_label_text_align: "center",
            major_label_text_baseline: "alphabetic",
            axis_label_text_font_size: "13px",
            axis_label_text_font_style: "italic",
        });
    })();
},
/* models/renderers/guide_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const renderer_1 = require(74) /* ./renderer */;
    class GuideRendererView extends renderer_1.RendererView {
    }
    exports.GuideRendererView = GuideRendererView;
    GuideRendererView.__name__ = "GuideRendererView";
    class GuideRenderer extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.GuideRenderer = GuideRenderer;
    _a = GuideRenderer;
    GuideRenderer.__name__ = "GuideRenderer";
    (() => {
        _a.override({
            level: "guide",
        });
    })();
},
/* models/tickers/ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class Ticker extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Ticker = Ticker;
    Ticker.__name__ = "Ticker";
},
/* models/formatters/tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    const graphics_1 = require(151) /* ../../core/graphics */;
    class TickFormatter extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        format_graphics(ticks, opts) {
            return this.doFormat(ticks, opts).map((text) => new graphics_1.TextBox({ text }));
        }
        compute(tick, opts) {
            return this.doFormat([tick], opts !== null && opts !== void 0 ? opts : { loc: 0 })[0];
        }
        v_compute(tick, opts) {
            return this.doFormat(tick, opts !== null && opts !== void 0 ? opts : { loc: 0 });
        }
    }
    exports.TickFormatter = TickFormatter;
    TickFormatter.__name__ = "TickFormatter";
},
/* models/policies/labeling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a, _b;
    const model_1 = require(51) /* ../../model */;
    const object_1 = require(9) /* ../../core/util/object */;
    const string_1 = require(38) /* ../../core/util/string */;
    const types_1 = require(8) /* ../../core/util/types */;
    const types_2 = require(23) /* ../../core/types */;
    class LabelingPolicy extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LabelingPolicy = LabelingPolicy;
    LabelingPolicy.__name__ = "LabelingPolicy";
    class AllLabels extends LabelingPolicy {
        constructor(attrs) {
            super(attrs);
        }
        filter(indices, _bboxes, _distance) {
            return indices;
        }
    }
    exports.AllLabels = AllLabels;
    AllLabels.__name__ = "AllLabels";
    class NoOverlap extends LabelingPolicy {
        constructor(attrs) {
            super(attrs);
        }
        filter(indices, _bboxes, distance) {
            const { min_distance } = this;
            let k = null;
            for (const i of indices) {
                if (k != null && distance(k, i) < min_distance)
                    indices.unset(i);
                else
                    k = i;
            }
            return indices;
        }
    }
    exports.NoOverlap = NoOverlap;
    _a = NoOverlap;
    NoOverlap.__name__ = "NoOverlap";
    (() => {
        _a.define(({ Number }) => ({
            min_distance: [Number, 5],
        }));
    })();
    class CustomLabelingPolicy extends LabelingPolicy {
        constructor(attrs) {
            super(attrs);
        }
        get names() {
            return (0, object_1.keys)(this.args);
        }
        get values() {
            return (0, object_1.values)(this.args);
        }
        get func() {
            const code = (0, string_1.use_strict)(this.code);
            return new types_2.GeneratorFunction("indices", "bboxes", "distance", ...this.names, code);
        }
        filter(indices, bboxes, distance) {
            var _c, _d;
            const obj = Object.create(null);
            const generator = this.func.call(obj, indices, bboxes, distance, ...this.values);
            let result = generator.next();
            if (((_c = result.done) !== null && _c !== void 0 ? _c : false) && result.value !== undefined) {
                const { value } = result;
                if (value instanceof types_2.Indices)
                    return value;
                else if (value === undefined)
                    return indices;
                else if ((0, types_1.isIterable)(value))
                    return types_2.Indices.from_indices(indices.size, value);
                else
                    return types_2.Indices.all_unset(indices.size);
            }
            else {
                const array = [];
                do {
                    array.push(result.value);
                    result = generator.next();
                } while (!((_d = result.done) !== null && _d !== void 0 ? _d : false));
                return types_2.Indices.from_indices(indices.size, array);
            }
        }
    }
    exports.CustomLabelingPolicy = CustomLabelingPolicy;
    _b = CustomLabelingPolicy;
    CustomLabelingPolicy.__name__ = "CustomLabelingPolicy";
    (() => {
        _b.define(({ Unknown, String, Dict }) => ({
            args: [Dict(Unknown), {}],
            code: [String, ""],
        }));
    })();
},
/* models/axes/categorical_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const axis_1 = require(159) /* ./axis */;
    const categorical_ticker_1 = require(165) /* ../tickers/categorical_ticker */;
    const categorical_tick_formatter_1 = require(166) /* ../formatters/categorical_tick_formatter */;
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    const enums_1 = require(19) /* ../../core/enums */;
    const graphics_1 = require(151) /* ../../core/graphics */;
    const types_1 = require(8) /* ../../core/util/types */;
    class CategoricalAxisView extends axis_1.AxisView {
        _paint(ctx, extents, tick_coords) {
            this._draw_group_separators(ctx, extents, tick_coords);
        }
        _draw_group_separators(ctx, _extents, _tick_coords) {
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            if (!range.tops || range.tops.length < 2 || !this.visuals.separator_line.doit)
                return;
            const dim = this.dimension;
            const alt = 1 - dim;
            const coords = [[], []];
            let ind = 0;
            for (let i = 0; i < range.tops.length - 1; i++) {
                let first, last;
                for (let j = ind; j < range.factors.length; j++) {
                    if (range.factors[j][0] == range.tops[i + 1]) {
                        [first, last] = [range.factors[j - 1], range.factors[j]];
                        ind = j;
                        break;
                    }
                }
                const pt = (range.synthetic(first) + range.synthetic(last)) / 2;
                if (pt > start && pt < end) {
                    coords[dim].push(pt);
                    coords[alt].push(this.loc);
                }
            }
            const tex = this.extents.tick_label;
            this._draw_ticks(ctx, coords, -3, tex - 6, this.visuals.separator_line);
        }
        _draw_major_labels(ctx, extents, _tick_coords) {
            const info = this._get_factor_info();
            let standoff = extents.tick + this.model.major_label_standoff;
            for (let i = 0; i < info.length; i++) {
                const [labels, coords, orient, visuals] = info[i];
                this._draw_oriented_labels(ctx, labels, coords, orient, this.panel.side, standoff, visuals);
                standoff += extents.tick_labels[i];
            }
        }
        _tick_label_extents() {
            const info = this._get_factor_info();
            const extents = [];
            for (const [labels, , orient, visuals] of info) {
                const extent = this._oriented_labels_extent(labels, orient, this.model.major_label_standoff, visuals);
                extents.push(extent);
            }
            return extents;
        }
        _get_factor_info() {
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            const loc = this.loc;
            const ticks = this.model.ticker.get_ticks(start, end, range, loc);
            const coords = this.tick_coords;
            const info = [];
            const map = (labels) => {
                return new graphics_1.GraphicsBoxes(labels.map((label) => (0, types_1.isString)(label) ? new graphics_1.TextBox({ text: label }) : label));
            };
            const format = (ticks) => {
                return map(this.model.formatter.doFormat(ticks, this));
            };
            if (range.levels == 1) {
                const major = ticks.major;
                const labels = format(major);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
            }
            else if (range.levels == 2) {
                const major = ticks.major.map((x) => x[1]);
                const labels = format(major);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
                info.push([map(ticks.tops), coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
            }
            else if (range.levels == 3) {
                const major = ticks.major.map((x) => x[2]);
                const labels = format(major);
                const mid_labels = ticks.mids.map((x) => x[1]);
                info.push([labels, coords.major, this.model.major_label_orientation, this.visuals.major_label_text]);
                info.push([map(mid_labels), coords.mids, this.model.subgroup_label_orientation, this.visuals.subgroup_text]);
                info.push([map(ticks.tops), coords.tops, this.model.group_label_orientation, this.visuals.group_text]);
            }
            return info;
        }
        get tick_coords() {
            const i = this.dimension;
            const j = 1 - i;
            const [range] = this.ranges;
            const [start, end] = this.computed_bounds;
            const ticks = this.model.ticker.get_ticks(start, end, range, this.loc);
            const coords = {
                major: [[], []],
                mids: [[], []],
                tops: [[], []],
                minor: [[], []],
            };
            coords.major[i] = ticks.major;
            coords.major[j] = ticks.major.map(() => this.loc);
            if (range.levels == 3) {
                coords.mids[i] = ticks.mids;
                coords.mids[j] = ticks.mids.map(() => this.loc);
            }
            if (range.levels > 1) {
                coords.tops[i] = ticks.tops;
                coords.tops[j] = ticks.tops.map(() => this.loc);
            }
            return coords;
        }
    }
    exports.CategoricalAxisView = CategoricalAxisView;
    CategoricalAxisView.__name__ = "CategoricalAxisView";
    class CategoricalAxis extends axis_1.Axis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.CategoricalAxis = CategoricalAxis;
    _a = CategoricalAxis;
    CategoricalAxis.__name__ = "CategoricalAxis";
    (() => {
        _a.prototype.default_view = CategoricalAxisView;
        _a.mixins([
            ["separator_", mixins.Line],
            ["group_", mixins.Text],
            ["subgroup_", mixins.Text],
        ]);
        _a.define(({ Number, Or }) => ({
            group_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "parallel"],
            subgroup_label_orientation: [Or(enums_1.TickLabelOrientation, Number), "parallel"],
        }));
        _a.override({
            ticker: () => new categorical_ticker_1.CategoricalTicker(),
            formatter: () => new categorical_tick_formatter_1.CategoricalTickFormatter(),
            separator_line_color: "lightgrey",
            separator_line_width: 2,
            group_text_font_style: "bold",
            group_text_font_size: "11px",
            group_text_color: "grey",
            subgroup_text_font_style: "bold",
            subgroup_text_font_size: "11px",
        });
    })();
},
/* models/tickers/categorical_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const ticker_1 = require(161) /* ./ticker */;
    class CategoricalTicker extends ticker_1.Ticker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks(start, end, range, _cross_loc) {
            var _a, _b;
            const majors = this._collect(range.factors, range, start, end);
            const tops = this._collect((_a = range.tops) !== null && _a !== void 0 ? _a : [], range, start, end);
            const mids = this._collect((_b = range.mids) !== null && _b !== void 0 ? _b : [], range, start, end);
            return {
                major: majors,
                minor: [],
                tops,
                mids,
            };
        }
        _collect(factors, range, start, end) {
            const result = [];
            for (const factor of factors) {
                const coord = range.synthetic(factor);
                if (coord > start && coord < end)
                    result.push(factor);
            }
            return result;
        }
    }
    exports.CategoricalTicker = CategoricalTicker;
    CategoricalTicker.__name__ = "CategoricalTicker";
},
/* models/formatters/categorical_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tick_formatter_1 = require(162) /* ./tick_formatter */;
    const array_1 = require(10) /* ../../core/util/array */;
    class CategoricalTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        doFormat(ticks, _opts) {
            return (0, array_1.copy)(ticks);
        }
    }
    exports.CategoricalTickFormatter = CategoricalTickFormatter;
    CategoricalTickFormatter.__name__ = "CategoricalTickFormatter";
},
/* models/axes/continuous_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const axis_1 = require(159) /* ./axis */;
    class ContinuousAxisView extends axis_1.AxisView {
    }
    exports.ContinuousAxisView = ContinuousAxisView;
    ContinuousAxisView.__name__ = "ContinuousAxisView";
    class ContinuousAxis extends axis_1.Axis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.ContinuousAxis = ContinuousAxis;
    ContinuousAxis.__name__ = "ContinuousAxis";
},
/* models/axes/datetime_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_axis_1 = require(167) /* ./continuous_axis */;
    const datetime_tick_formatter_1 = require(169) /* ../formatters/datetime_tick_formatter */;
    const datetime_ticker_1 = require(175) /* ../tickers/datetime_ticker */;
    class DatetimeAxisView extends continuous_axis_1.ContinuousAxisView {
    }
    exports.DatetimeAxisView = DatetimeAxisView;
    DatetimeAxisView.__name__ = "DatetimeAxisView";
    class DatetimeAxis extends continuous_axis_1.ContinuousAxis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DatetimeAxis = DatetimeAxis;
    _a = DatetimeAxis;
    DatetimeAxis.__name__ = "DatetimeAxis";
    (() => {
        _a.prototype.default_view = DatetimeAxisView;
        _a.override({
            ticker: () => new datetime_ticker_1.DatetimeTicker(),
            formatter: () => new datetime_tick_formatter_1.DatetimeTickFormatter(),
        });
    })();
},
/* models/formatters/datetime_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const enums_1 = require(19) /* ../../core/enums */;
    const iterator_1 = require(32) /* ../../core/util/iterator */;
    const templating_1 = require(170) /* ../../core/util/templating */;
    const types_1 = require(8) /* ../../core/util/types */;
    const tick_formatter_1 = require(162) /* ./tick_formatter */;
    const util_1 = require(174) /* ../tickers/util */;
    const timezone_1 = tslib_1.__importDefault(require(173) /* timezone */);
    // Labels of time units, from finest to coarsest.
    exports.resolution_order = [
        "microseconds", "milliseconds", "seconds", "minsec", "minutes", "hourmin", "hours", "days", "months", "years",
    ];
    // This dictionary maps the name of a time resolution (in @resolution_order)
    // to its index in a time.localtime() timetuple.  The default is to map
    // everything to index 0, which is year.  This is not ideal; it might cause
    // a problem with the tick at midnight, january 1st, 0 a.d. being incorrectly
    // promoted at certain tick resolutions.
    exports.tm_index_for_resolution = new Map();
    for (const fmt of exports.resolution_order) {
        exports.tm_index_for_resolution.set(fmt, 0);
    }
    exports.tm_index_for_resolution.set("seconds", 5);
    exports.tm_index_for_resolution.set("minsec", 4);
    exports.tm_index_for_resolution.set("minutes", 4);
    exports.tm_index_for_resolution.set("hourmin", 3);
    exports.tm_index_for_resolution.set("hours", 3);
    function _get_resolution(resolution_secs, span_secs) {
        // Our resolution boundaries should not be round numbers, because we want
        // them to fall between the possible tick intervals (which *are* round
        // numbers, as we've worked hard to ensure).  Consequently, we adjust the
        // resolution upwards a small amount (less than any possible step in
        // scales) to make the effective boundaries slightly lower.
        const adjusted_ms = resolution_secs * 1.1 * 1000;
        const span_ms = span_secs * 1000;
        if (adjusted_ms < util_1.ONE_MILLI)
            return "microseconds";
        if (adjusted_ms < util_1.ONE_SECOND)
            return "milliseconds";
        if (adjusted_ms < util_1.ONE_MINUTE)
            return span_ms >= util_1.ONE_MINUTE ? "minsec" : "seconds";
        if (adjusted_ms < util_1.ONE_HOUR)
            return span_ms >= util_1.ONE_HOUR ? "hourmin" : "minutes";
        if (adjusted_ms < util_1.ONE_DAY)
            return "hours";
        if (adjusted_ms < util_1.ONE_MONTH)
            return "days";
        if (adjusted_ms < util_1.ONE_YEAR)
            return "months";
        return "years";
    }
    exports._get_resolution = _get_resolution;
    function _mktime(t) {
        return (0, timezone_1.default)(t, "%Y %m %d %H %M %S").split(/\s+/).map(e => parseInt(e, 10));
    }
    exports._mktime = _mktime;
    function _strftime(t, format) {
        // Python's datetime library augments the microsecond directive %f, which is not
        // supported by the javascript library timezone: http://bigeasy.github.io/timezone/.
        // Use a regular expression to replace %f directive with microseconds.
        // TODO: what should we do for negative microsecond strings?
        const microsecond_replacement_string = (0, templating_1.sprintf)("$1%06d", _us(t));
        format = format.replace(/((^|[^%])(%%)*)%f/, microsecond_replacement_string);
        // timezone seems to ignore any strings without any formatting directives,
        // and just return the time argument back instead of the string argument.
        // But we want the string argument, in case a user supplies a format string
        // which doesn't contain a formatting directive or is only using %f.
        if (format.indexOf("%") == -1) {
            return format;
        }
        return (0, timezone_1.default)(t, format);
    }
    exports._strftime = _strftime;
    function _us(t) {
        // From double-precision unix (millisecond) timestamp, get microseconds since
        // last second. Precision seems to run out around the hundreds of nanoseconds
        // scale, so rounding to the nearest microsecond should round to a nice
        // microsecond / millisecond tick.
        return Math.round(((t / 1000) % 1) * 1000000);
    }
    exports._us = _us;
    class DatetimeTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        doFormat(ticks, _opts, _resolution) {
            if (ticks.length == 0)
                return [];
            const span = Math.abs(ticks[ticks.length - 1] - ticks[0]) / 1000.0;
            const r = span / (ticks.length - 1);
            const resolution = (0, types_1.is_undefined)(_resolution) ? _get_resolution(r, span) : _resolution;
            const labels = [];
            for (const [tick, i] of (0, iterator_1.enumerate)(ticks)) {
                const base_label = this._compute_label(tick, resolution);
                const full_label = this._add_context(tick, base_label, i, ticks.length, resolution);
                labels.push(full_label);
            }
            return labels;
        }
        _compute_label(t, resolution) {
            const s0 = _strftime(t, this[resolution]);
            const tm = _mktime(t);
            const resolution_index = exports.resolution_order.indexOf(resolution);
            let s = s0;
            let hybrid_handled = false;
            let next_index = resolution_index;
            let next_resolution;
            // As we format each tick, check to see if we are at a boundary of the
            // next higher unit of time. If so, replace the current format with one
            // from that resolution. This is not the best heuristic but it works.
            while (tm[exports.tm_index_for_resolution.get(exports.resolution_order[next_index])] == 0) {
                next_index += 1;
                if (next_index == exports.resolution_order.length)
                    break;
                // The way to check that we are at the boundary of the next unit of
                // time is by checking that we have 0 units of the resolution, i.e.
                // we are at zero minutes, so display hours, or we are at zero seconds,
                // so display minutes (and if that is zero as well, then display hours).
                if ((resolution == "minsec" || resolution == "hourmin") && !hybrid_handled) {
                    if ((resolution == "minsec" && tm[4] == 0 && tm[5] != 0) || (resolution == "hourmin" && tm[3] == 0 && tm[4] != 0)) {
                        next_resolution = exports.resolution_order[resolution_index - 1];
                        s = _strftime(t, this[next_resolution]);
                        break;
                    }
                    else {
                        hybrid_handled = true;
                    }
                }
                next_resolution = exports.resolution_order[next_index];
                s = _strftime(t, this[next_resolution]);
            }
            if (this.strip_leading_zeros) {
                const ss = s.replace(/^0+/g, "");
                if (ss != s && isNaN(parseInt(ss))) {
                    // If the string can now be parsed as starting with an integer, then
                    // leave all zeros stripped, otherwise start with a zero.
                    return `0${ss}`;
                }
                return ss;
            }
            return s;
        }
        _add_context(tick, label, i, N, resolution) {
            const loc = this.context_location;
            const which = this.context_which;
            if (this.context == null)
                return label;
            if ((which == "start" && i == 0) ||
                (which == "end" && i == N - 1) ||
                (which == "center" && i == Math.floor(N / 2)) ||
                (which == "all")) {
                const context = (0, types_1.isString)(this.context) ?
                    _strftime(tick, this.context) : this.context.doFormat([tick], { loc: 0 }, resolution)[0];
                if (context == "")
                    return label;
                if (loc == "above")
                    return `${context}\n${label}`;
                if (loc == "below")
                    return `${label}\n${context}`;
                if (loc == "left")
                    return `${context} ${label}`;
                if (loc == "right")
                    return `${label} ${context}`;
            }
            return label;
        }
    }
    exports.DatetimeTickFormatter = DatetimeTickFormatter;
    _a = DatetimeTickFormatter;
    DatetimeTickFormatter.__name__ = "DatetimeTickFormatter";
    (() => {
        _a.define(({ Boolean, Nullable, Or, Ref, String }) => ({
            microseconds: [String, "%fus"],
            milliseconds: [String, "%3Nms"],
            seconds: [String, "%Ss"],
            minsec: [String, ":%M:%S"],
            minutes: [String, ":%M"],
            hourmin: [String, "%H:%M"],
            hours: [String, "%Hh"],
            days: [String, "%m/%d"],
            months: [String, "%m/%Y"],
            years: [String, "%Y"],
            strip_leading_zeros: [Boolean, true],
            context: [Nullable(Or(String, Ref(DatetimeTickFormatter))), null],
            context_which: [enums_1.ContextWhich, "start"],
            context_location: [enums_1.Location, "below"],
        }));
    })();
},
/* core/util/templating.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const Numbro = tslib_1.__importStar(require(171) /* @bokeh/numbro */);
    const sprintf_js_1 = require(172) /* sprintf-js */;
    const timezone_1 = tslib_1.__importDefault(require(173) /* timezone */);
    const kinds_1 = require(20) /* ../kinds */;
    const types_1 = require(8) /* ./types */;
    exports.FormatterType = (0, kinds_1.Enum)("numeral", "printf", "datetime");
    exports.DEFAULT_FORMATTERS = {
        numeral: (value, format, _special_vars) => Numbro.format(value, format),
        datetime: (value, format, _special_vars) => (0, timezone_1.default)(value, format),
        printf: (value, format, _special_vars) => sprintf(format, value),
    };
    function sprintf(format, ...args) {
        return (0, sprintf_js_1.sprintf)(format, ...args);
    }
    exports.sprintf = sprintf;
    function basic_formatter(value, _format, _special_vars) {
        if ((0, types_1.isNumber)(value)) {
            const format = (() => {
                switch (false) {
                    case Math.floor(value) != value:
                        return "%d";
                    case !(Math.abs(value) > 0.1) || !(Math.abs(value) < 1000):
                        return "%0.3f";
                    default:
                        return "%0.3e";
                }
            })();
            return sprintf(format, value);
        }
        else
            return `${value}`; // get strings for categorical types
    }
    exports.basic_formatter = basic_formatter;
    function get_formatter(raw_spec, format, formatters) {
        // no format, use default built in formatter
        if (format == null)
            return basic_formatter;
        // format spec in the formatters dict, use that
        if (formatters != null && raw_spec in formatters) {
            const formatter = formatters[raw_spec];
            if ((0, types_1.isString)(formatter)) {
                if (formatter in exports.DEFAULT_FORMATTERS)
                    return exports.DEFAULT_FORMATTERS[formatter];
                else
                    throw new Error(`Unknown tooltip field formatter type '${formatter}'`);
            }
            return function (value, format, special_vars) {
                return formatter.format(value, format, special_vars);
            };
        }
        // otherwise use "numeral" as default
        return exports.DEFAULT_FORMATTERS.numeral;
    }
    exports.get_formatter = get_formatter;
    function _get_special_value(name, special_vars) {
        if (name in special_vars)
            return special_vars[name];
        else
            throw new Error(`Unknown special variable '\$${name}'`);
    }
    function _get_column_value(name, data_source, ind) {
        const column = data_source.get_column(name);
        // missing column
        if (column == null)
            return null;
        // null index (e.g for patch)
        if (ind == null)
            return null;
        // typical (non-image) index
        if ((0, types_1.isNumber)(ind))
            return column[ind];
        // image index
        const data = column[ind.index];
        if ((0, types_1.isTypedArray)(data) || (0, types_1.isArray)(data)) {
            // inspect array of arrays
            if ((0, types_1.isArray)(data[0])) {
                const row = data[ind.j];
                return row[ind.i];
            }
            else
                return data[ind.flat_index]; // inspect flat array
        }
        else
            return data; // inspect per-image scalar data
    }
    exports._get_column_value = _get_column_value;
    function get_value(raw_name, data_source, i, special_vars) {
        if (raw_name[0] == "$") {
            const name = raw_name.substring(1);
            return _get_special_value(name, special_vars);
        }
        else {
            const name = raw_name.substring(1).replace(/[{}]/g, "");
            return _get_column_value(name, data_source, i);
        }
    }
    exports.get_value = get_value;
    function replace_placeholders(content, data_source, i, formatters, special_vars = {}, encode) {
        let str;
        let has_html;
        if ((0, types_1.isString)(content)) {
            str = content;
            has_html = false;
        }
        else {
            str = content.html;
            has_html = true;
        }
        // this handles the special case @$name, replacing it with an @var corresponding to special_vars.name
        str = str.replace(/@\$name/g, (_match) => `@{${special_vars.name}}`);
        //
        // (?:\$\w+) - special vars: $x
        // (?:@\w+) - simple names: @foo
        // (?:@{(?:[^{}]+)})) - full names: @{one two}
        //
        // (?:{([^{}]+)})? - (optional) format for all of the above: @foo{fmt}
        //
        str = str.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g, (_match, spec, format) => {
            const value = get_value(spec, data_source, i, special_vars);
            // missing value, return ???
            if (value == null)
                return encode ? encode("???") : "???";
            // 'safe' format, return the value as-is
            if (format == "safe") {
                has_html = true;
                return `${value}`;
            }
            // format and escape everything else
            const formatter = get_formatter(spec, format, formatters);
            const result = `${formatter(value, format, special_vars)}`;
            return encode ? encode(result) : result;
        });
        if (!has_html)
            return str;
        else {
            const parser = new DOMParser();
            const document = parser.parseFromString(str, "text/html");
            return [...document.body.childNodes];
        }
    }
    exports.replace_placeholders = replace_placeholders;
},
/* @bokeh/numbro/numbro.js */ function _(require, module, exports, __esModule, __esExport) {
    /*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
    /************************************
        Constants
    ************************************/
    var numbro, VERSION = '1.6.2', 
    // internal storage for culture config files
    cultures = {}, 
    // Todo: Remove in 2.0.0
    languages = cultures, currentCulture = 'en-US', zeroFormat = null, defaultFormat = '0,0', defaultCurrencyFormat = '0$', 
    // check for nodeJS
    hasModule = (typeof module !== 'undefined' && module.exports), 
    // default culture
    enUS = {
        delimiters: {
            thousands: ',',
            decimal: '.'
        },
        abbreviations: {
            thousand: 'k',
            million: 'm',
            billion: 'b',
            trillion: 't'
        },
        ordinal: function (number) {
            var b = number % 10;
            return (~~(number % 100 / 10) === 1) ? 'th' :
                (b === 1) ? 'st' :
                    (b === 2) ? 'nd' :
                        (b === 3) ? 'rd' : 'th';
        },
        currency: {
            symbol: '$',
            position: 'prefix'
        },
        defaults: {
            currencyFormat: ',0000 a'
        },
        formats: {
            fourDigits: '0000 a',
            fullWithTwoDecimals: '$ ,0.00',
            fullWithTwoDecimalsNoCurrency: ',0.00'
        }
    };
    /************************************
        Constructors
    ************************************/
    // Numbro prototype object
    function Numbro(number) {
        this._value = number;
    }
    function zeroes(count) {
        var i, ret = '';
        for (i = 0; i < count; i++) {
            ret += '0';
        }
        return ret;
    }
    /**
     * Implementation of toFixed() for numbers with exponent > 21
     *
     *
     */
    function toFixedLarge(value, precision) {
        var mantissa, beforeDec, afterDec, exponent, str;
        str = value.toString();
        mantissa = str.split('e')[0];
        exponent = str.split('e')[1];
        beforeDec = mantissa.split('.')[0];
        afterDec = mantissa.split('.')[1] || '';
        str = beforeDec + afterDec + zeroes(exponent - afterDec.length);
        if (precision > 0) {
            str += '.' + zeroes(precision);
        }
        return str;
    }
    /**
     * Implementation of toFixed() that treats floats more like decimals
     *
     * Fixes binary rounding issues (eg. (0.615).toFixed(2) === '0.61') that present
     * problems for accounting- and finance-related software.
     */
    function toFixed(value, precision, roundingFunction, optionals) {
        var power = Math.pow(10, precision), optionalsRegExp, output;
        if (value.toFixed(0).search('e') > -1) {
            // Above 1e21, toFixed returns scientific notation, which
            // is useless and unexpected
            output = toFixedLarge(value, precision);
        }
        else {
            //roundingFunction = (roundingFunction !== undefined ? roundingFunction : Math.round);
            // Multiply up by precision, round accurately, then divide and use native toFixed():
            output = (roundingFunction(value * power) / power).toFixed(precision);
        }
        if (optionals) {
            optionalsRegExp = new RegExp('0{1,' + optionals + '}$');
            output = output.replace(optionalsRegExp, '');
        }
        return output;
    }
    /************************************
        Formatting
    ************************************/
    // determine what type of formatting we need to do
    function formatNumbro(value, format, roundingFunction) {
        var output;
        // TODO: do something with `language`
        // figure out what kind of format we are dealing with
        if (format.indexOf('$') > -1) { // currency!!!!!
            output = formatCurrency(value, format, roundingFunction);
        }
        else if (format.indexOf('%') > -1) { // percentage
            output = formatPercentage(value, format, roundingFunction);
        }
        else if (format.indexOf(':') > -1) { // time
            output = formatTime(value);
        }
        else { // plain ol' numbers or bytes
            output = formatNumber(value, format, roundingFunction);
        }
        // return string
        return output;
    }
    function formatCurrency(value, originalFormat, roundingFunction) {
        var format = originalFormat, symbolIndex = format.indexOf('$'), openParenIndex = format.indexOf('('), plusSignIndex = format.indexOf('+'), minusSignIndex = format.indexOf('-'), space = '', decimalSeparator = '', spliceIndex, output;
        if (format.indexOf('$') === -1) {
            // Use defaults instead of the format provided
            if (cultures[currentCulture].currency.position === 'infix') {
                decimalSeparator = cultures[currentCulture].currency.symbol;
                if (cultures[currentCulture].currency.spaceSeparated) {
                    decimalSeparator = ' ' + decimalSeparator + ' ';
                }
            }
            else if (cultures[currentCulture].currency.spaceSeparated) {
                space = ' ';
            }
        }
        else {
            // check for space before or after currency
            if (format.indexOf(' $') > -1) {
                space = ' ';
                format = format.replace(' $', '');
            }
            else if (format.indexOf('$ ') > -1) {
                space = ' ';
                format = format.replace('$ ', '');
            }
            else {
                format = format.replace('$', '');
            }
        }
        // Format The Number
        output = formatNumber(value, format, roundingFunction, decimalSeparator);
        if (originalFormat.indexOf('$') === -1) {
            // Use defaults instead of the format provided
            switch (cultures[currentCulture].currency.position) {
                case 'postfix':
                    if (output.indexOf(')') > -1) {
                        output = output.split('');
                        output.splice(-1, 0, space + cultures[currentCulture].currency.symbol);
                        output = output.join('');
                    }
                    else {
                        output = output + space + cultures[currentCulture].currency.symbol;
                    }
                    break;
                case 'infix':
                    break;
                case 'prefix':
                    if (output.indexOf('(') > -1 || output.indexOf('-') > -1) {
                        output = output.split('');
                        spliceIndex = Math.max(openParenIndex, minusSignIndex) + 1;
                        output.splice(spliceIndex, 0, cultures[currentCulture].currency.symbol + space);
                        output = output.join('');
                    }
                    else {
                        output = cultures[currentCulture].currency.symbol + space + output;
                    }
                    break;
                default:
                    throw Error('Currency position should be among ["prefix", "infix", "postfix"]');
            }
        }
        else {
            // position the symbol
            if (symbolIndex <= 1) {
                if (output.indexOf('(') > -1 || output.indexOf('+') > -1 || output.indexOf('-') > -1) {
                    output = output.split('');
                    spliceIndex = 1;
                    if (symbolIndex < openParenIndex || symbolIndex < plusSignIndex || symbolIndex < minusSignIndex) {
                        // the symbol appears before the "(", "+" or "-"
                        spliceIndex = 0;
                    }
                    output.splice(spliceIndex, 0, cultures[currentCulture].currency.symbol + space);
                    output = output.join('');
                }
                else {
                    output = cultures[currentCulture].currency.symbol + space + output;
                }
            }
            else {
                if (output.indexOf(')') > -1) {
                    output = output.split('');
                    output.splice(-1, 0, space + cultures[currentCulture].currency.symbol);
                    output = output.join('');
                }
                else {
                    output = output + space + cultures[currentCulture].currency.symbol;
                }
            }
        }
        return output;
    }
    function formatPercentage(value, format, roundingFunction) {
        var space = '', output;
        value = value * 100;
        // check for space before %
        if (format.indexOf(' %') > -1) {
            space = ' ';
            format = format.replace(' %', '');
        }
        else {
            format = format.replace('%', '');
        }
        output = formatNumber(value, format, roundingFunction);
        if (output.indexOf(')') > -1) {
            output = output.split('');
            output.splice(-1, 0, space + '%');
            output = output.join('');
        }
        else {
            output = output + space + '%';
        }
        return output;
    }
    function formatTime(value) {
        var hours = Math.floor(value / 60 / 60), minutes = Math.floor((value - (hours * 60 * 60)) / 60), seconds = Math.round(value - (hours * 60 * 60) - (minutes * 60));
        return hours + ':' +
            ((minutes < 10) ? '0' + minutes : minutes) + ':' +
            ((seconds < 10) ? '0' + seconds : seconds);
    }
    function formatNumber(value, format, roundingFunction, sep) {
        var negP = false, signed = false, optDec = false, abbr = '', i, abbrK = false, // force abbreviation to thousands
        abbrM = false, // force abbreviation to millions
        abbrB = false, // force abbreviation to billions
        abbrT = false, // force abbreviation to trillions
        abbrForce = false, // force abbreviation
        bytes = '', ord = '', abs = Math.abs(value), binarySuffixes = ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'], decimalSuffixes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'], min, max, power, totalLength, length, minimumPrecision, pow, w, intPrecision, precision, prefix, postfix, thousands, d = '', forcedNeg = false, neg = false, indexOpenP, size, indexMinus, paren = '', minlen;
        // check if number is zero and a custom zero format has been set
        if (value === 0 && zeroFormat !== null) {
            return zeroFormat;
        }
        if (!isFinite(value)) {
            return '' + value;
        }
        if (format.indexOf('{') === 0) {
            var end = format.indexOf('}');
            if (end === -1) {
                throw Error('Format should also contain a "}"');
            }
            prefix = format.slice(1, end);
            format = format.slice(end + 1);
        }
        else {
            prefix = '';
        }
        if (format.indexOf('}') === format.length - 1) {
            var start = format.indexOf('{');
            if (start === -1) {
                throw Error('Format should also contain a "{"');
            }
            postfix = format.slice(start + 1, -1);
            format = format.slice(0, start + 1);
        }
        else {
            postfix = '';
        }
        // check for min length
        var info;
        if (format.indexOf('.') === -1) {
            info = format.match(/([0-9]+).*/);
        }
        else {
            info = format.match(/([0-9]+)\..*/);
        }
        minlen = info === null ? -1 : info[1].length;
        // see if we should use parentheses for negative number or if we should prefix with a sign
        // if both are present we default to parentheses
        if (format.indexOf('-') !== -1) {
            forcedNeg = true;
        }
        if (format.indexOf('(') > -1) {
            negP = true;
            format = format.slice(1, -1);
        }
        else if (format.indexOf('+') > -1) {
            signed = true;
            format = format.replace(/\+/g, '');
        }
        // see if abbreviation is wanted
        if (format.indexOf('a') > -1) {
            intPrecision = format.split('.')[0].match(/[0-9]+/g) || ['0'];
            intPrecision = parseInt(intPrecision[0], 10);
            // check if abbreviation is specified
            abbrK = format.indexOf('aK') >= 0;
            abbrM = format.indexOf('aM') >= 0;
            abbrB = format.indexOf('aB') >= 0;
            abbrT = format.indexOf('aT') >= 0;
            abbrForce = abbrK || abbrM || abbrB || abbrT;
            // check for space before abbreviation
            if (format.indexOf(' a') > -1) {
                abbr = ' ';
                format = format.replace(' a', '');
            }
            else {
                format = format.replace('a', '');
            }
            totalLength = Math.floor(Math.log(abs) / Math.LN10) + 1;
            minimumPrecision = totalLength % 3;
            minimumPrecision = minimumPrecision === 0 ? 3 : minimumPrecision;
            if (intPrecision && abs !== 0) {
                length = Math.floor(Math.log(abs) / Math.LN10) + 1 - intPrecision;
                pow = 3 * ~~((Math.min(intPrecision, totalLength) - minimumPrecision) / 3);
                abs = abs / Math.pow(10, pow);
                if (format.indexOf('.') === -1 && intPrecision > 3) {
                    format += '[.]';
                    size = length === 0 ? 0 : 3 * ~~(length / 3) - length;
                    size = size < 0 ? size + 3 : size;
                    for (i = 0; i < size; i++) {
                        format += '0';
                    }
                }
            }
            if (Math.floor(Math.log(Math.abs(value)) / Math.LN10) + 1 !== intPrecision) {
                if (abs >= Math.pow(10, 12) && !abbrForce || abbrT) {
                    // trillion
                    abbr = abbr + cultures[currentCulture].abbreviations.trillion;
                    value = value / Math.pow(10, 12);
                }
                else if (abs < Math.pow(10, 12) && abs >= Math.pow(10, 9) && !abbrForce || abbrB) {
                    // billion
                    abbr = abbr + cultures[currentCulture].abbreviations.billion;
                    value = value / Math.pow(10, 9);
                }
                else if (abs < Math.pow(10, 9) && abs >= Math.pow(10, 6) && !abbrForce || abbrM) {
                    // million
                    abbr = abbr + cultures[currentCulture].abbreviations.million;
                    value = value / Math.pow(10, 6);
                }
                else if (abs < Math.pow(10, 6) && abs >= Math.pow(10, 3) && !abbrForce || abbrK) {
                    // thousand
                    abbr = abbr + cultures[currentCulture].abbreviations.thousand;
                    value = value / Math.pow(10, 3);
                }
            }
        }
        // see if we are formatting binary bytes
        if (format.indexOf('b') > -1) {
            // check for space before
            if (format.indexOf(' b') > -1) {
                bytes = ' ';
                format = format.replace(' b', '');
            }
            else {
                format = format.replace('b', '');
            }
            for (power = 0; power <= binarySuffixes.length; power++) {
                min = Math.pow(1024, power);
                max = Math.pow(1024, power + 1);
                if (value >= min && value < max) {
                    bytes = bytes + binarySuffixes[power];
                    if (min > 0) {
                        value = value / min;
                    }
                    break;
                }
            }
        }
        // see if we are formatting decimal bytes
        if (format.indexOf('d') > -1) {
            // check for space before
            if (format.indexOf(' d') > -1) {
                bytes = ' ';
                format = format.replace(' d', '');
            }
            else {
                format = format.replace('d', '');
            }
            for (power = 0; power <= decimalSuffixes.length; power++) {
                min = Math.pow(1000, power);
                max = Math.pow(1000, power + 1);
                if (value >= min && value < max) {
                    bytes = bytes + decimalSuffixes[power];
                    if (min > 0) {
                        value = value / min;
                    }
                    break;
                }
            }
        }
        // see if ordinal is wanted
        if (format.indexOf('o') > -1) {
            // check for space before
            if (format.indexOf(' o') > -1) {
                ord = ' ';
                format = format.replace(' o', '');
            }
            else {
                format = format.replace('o', '');
            }
            if (cultures[currentCulture].ordinal) {
                ord = ord + cultures[currentCulture].ordinal(value);
            }
        }
        if (format.indexOf('[.]') > -1) {
            optDec = true;
            format = format.replace('[.]', '.');
        }
        w = value.toString().split('.')[0];
        precision = format.split('.')[1];
        thousands = format.indexOf(',');
        if (precision) {
            if (precision.indexOf('*') !== -1) {
                d = toFixed(value, value.toString().split('.')[1].length, roundingFunction);
            }
            else {
                if (precision.indexOf('[') > -1) {
                    precision = precision.replace(']', '');
                    precision = precision.split('[');
                    d = toFixed(value, (precision[0].length + precision[1].length), roundingFunction, precision[1].length);
                }
                else {
                    d = toFixed(value, precision.length, roundingFunction);
                }
            }
            w = d.split('.')[0];
            if (d.split('.')[1].length) {
                var p = sep ? abbr + sep : cultures[currentCulture].delimiters.decimal;
                d = p + d.split('.')[1];
            }
            else {
                d = '';
            }
            if (optDec && Number(d.slice(1)) === 0) {
                d = '';
            }
        }
        else {
            w = toFixed(value, null, roundingFunction);
        }
        // format number
        if (w.indexOf('-') > -1) {
            w = w.slice(1);
            neg = true;
        }
        if (w.length < minlen) {
            w = new Array(minlen - w.length + 1).join('0') + w;
        }
        if (thousands > -1) {
            w = w.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1' +
                cultures[currentCulture].delimiters.thousands);
        }
        if (format.indexOf('.') === 0) {
            w = '';
        }
        indexOpenP = format.indexOf('(');
        indexMinus = format.indexOf('-');
        if (indexOpenP < indexMinus) {
            paren = ((negP && neg) ? '(' : '') + (((forcedNeg && neg) || (!negP && neg)) ? '-' : '');
        }
        else {
            paren = (((forcedNeg && neg) || (!negP && neg)) ? '-' : '') + ((negP && neg) ? '(' : '');
        }
        return prefix +
            paren + ((!neg && signed && value !== 0) ? '+' : '') +
            w + d +
            ((ord) ? ord : '') +
            ((abbr && !sep) ? abbr : '') +
            ((bytes) ? bytes : '') +
            ((negP && neg) ? ')' : '') +
            postfix;
    }
    /************************************
        Top Level Functions
    ************************************/
    numbro = function (input) {
        if (numbro.isNumbro(input)) {
            input = input.value();
        }
        else if (input === 0 || typeof input === 'undefined') {
            input = 0;
        }
        else if (!Number(input)) {
            input = numbro.fn.unformat(input);
        }
        return new Numbro(Number(input));
    };
    // version number
    numbro.version = VERSION;
    // compare numbro object
    numbro.isNumbro = function (obj) {
        return obj instanceof Numbro;
    };
    /**
     * This function allow the user to set a new language with a fallback if
     * the language does not exist. If no fallback language is provided,
     * it fallbacks to english.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `setCulture` should be used instead.
     */
    numbro.setLanguage = function (newLanguage, fallbackLanguage) {
        console.warn('`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead');
        var key = newLanguage, prefix = newLanguage.split('-')[0], matchingLanguage = null;
        if (!languages[key]) {
            Object.keys(languages).forEach(function (language) {
                if (!matchingLanguage && language.split('-')[0] === prefix) {
                    matchingLanguage = language;
                }
            });
            key = matchingLanguage || fallbackLanguage || 'en-US';
        }
        chooseCulture(key);
    };
    /**
     * This function allow the user to set a new culture with a fallback if
     * the culture does not exist. If no fallback culture is provided,
     * it fallbacks to "en-US".
     */
    numbro.setCulture = function (newCulture, fallbackCulture) {
        var key = newCulture, suffix = newCulture.split('-')[1], matchingCulture = null;
        if (!cultures[key]) {
            if (suffix) {
                Object.keys(cultures).forEach(function (language) {
                    if (!matchingCulture && language.split('-')[1] === suffix) {
                        matchingCulture = language;
                    }
                });
            }
            key = matchingCulture || fallbackCulture || 'en-US';
        }
        chooseCulture(key);
    };
    /**
     * This function will load languages and then set the global language.  If
     * no arguments are passed in, it will simply return the current global
     * language key.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `culture` should be used instead.
     */
    numbro.language = function (key, values) {
        console.warn('`language` is deprecated since version 1.6.0. Use `culture` instead');
        if (!key) {
            return currentCulture;
        }
        if (key && !values) {
            if (!languages[key]) {
                throw new Error('Unknown language : ' + key);
            }
            chooseCulture(key);
        }
        if (values || !languages[key]) {
            setCulture(key, values);
        }
        return numbro;
    };
    /**
     * This function will load cultures and then set the global culture.  If
     * no arguments are passed in, it will simply return the current global
     * culture code.
     */
    numbro.culture = function (code, values) {
        if (!code) {
            return currentCulture;
        }
        if (code && !values) {
            if (!cultures[code]) {
                throw new Error('Unknown culture : ' + code);
            }
            chooseCulture(code);
        }
        if (values || !cultures[code]) {
            setCulture(code, values);
        }
        return numbro;
    };
    /**
     * This function provides access to the loaded language data.  If
     * no arguments are passed in, it will simply return the current
     * global language object.
     *
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `culture` should be used instead.
     */
    numbro.languageData = function (key) {
        console.warn('`languageData` is deprecated since version 1.6.0. Use `cultureData` instead');
        if (!key) {
            return languages[currentCulture];
        }
        if (!languages[key]) {
            throw new Error('Unknown language : ' + key);
        }
        return languages[key];
    };
    /**
     * This function provides access to the loaded culture data.  If
     * no arguments are passed in, it will simply return the current
     * global culture object.
     */
    numbro.cultureData = function (code) {
        if (!code) {
            return cultures[currentCulture];
        }
        if (!cultures[code]) {
            throw new Error('Unknown culture : ' + code);
        }
        return cultures[code];
    };
    numbro.culture('en-US', enUS);
    /**
     * @deprecated Since in version 1.6.0. It will be deleted in version 2.0
     * `cultures` should be used instead.
     */
    numbro.languages = function () {
        console.warn('`languages` is deprecated since version 1.6.0. Use `cultures` instead');
        return languages;
    };
    numbro.cultures = function () {
        return cultures;
    };
    numbro.zeroFormat = function (format) {
        zeroFormat = typeof (format) === 'string' ? format : null;
    };
    numbro.defaultFormat = function (format) {
        defaultFormat = typeof (format) === 'string' ? format : '0.0';
    };
    numbro.defaultCurrencyFormat = function (format) {
        defaultCurrencyFormat = typeof (format) === 'string' ? format : '0$';
    };
    numbro.validate = function (val, culture) {
        var _decimalSep, _thousandSep, _currSymbol, _valArray, _abbrObj, _thousandRegEx, cultureData, temp;
        //coerce val to string
        if (typeof val !== 'string') {
            val += '';
            if (console.warn) {
                console.warn('Numbro.js: Value is not string. It has been co-erced to: ', val);
            }
        }
        //trim whitespaces from either sides
        val = val.trim();
        //if val is just digits return true
        if (!!val.match(/^\d+$/)) {
            return true;
        }
        //if val is empty return false
        if (val === '') {
            return false;
        }
        //get the decimal and thousands separator from numbro.cultureData
        try {
            //check if the culture is understood by numbro. if not, default it to current culture
            cultureData = numbro.cultureData(culture);
        }
        catch (e) {
            cultureData = numbro.cultureData(numbro.culture());
        }
        //setup the delimiters and currency symbol based on culture
        _currSymbol = cultureData.currency.symbol;
        _abbrObj = cultureData.abbreviations;
        _decimalSep = cultureData.delimiters.decimal;
        if (cultureData.delimiters.thousands === '.') {
            _thousandSep = '\\.';
        }
        else {
            _thousandSep = cultureData.delimiters.thousands;
        }
        // validating currency symbol
        temp = val.match(/^[^\d]+/);
        if (temp !== null) {
            val = val.substr(1);
            if (temp[0] !== _currSymbol) {
                return false;
            }
        }
        //validating abbreviation symbol
        temp = val.match(/[^\d]+$/);
        if (temp !== null) {
            val = val.slice(0, -1);
            if (temp[0] !== _abbrObj.thousand && temp[0] !== _abbrObj.million &&
                temp[0] !== _abbrObj.billion && temp[0] !== _abbrObj.trillion) {
                return false;
            }
        }
        _thousandRegEx = new RegExp(_thousandSep + '{2}');
        if (!val.match(/[^\d.,]/g)) {
            _valArray = val.split(_decimalSep);
            if (_valArray.length > 2) {
                return false;
            }
            else {
                if (_valArray.length < 2) {
                    return (!!_valArray[0].match(/^\d+.*\d$/) && !_valArray[0].match(_thousandRegEx));
                }
                else {
                    if (_valArray[0].length === 1) {
                        return (!!_valArray[0].match(/^\d+$/) &&
                            !_valArray[0].match(_thousandRegEx) &&
                            !!_valArray[1].match(/^\d+$/));
                    }
                    else {
                        return (!!_valArray[0].match(/^\d+.*\d$/) &&
                            !_valArray[0].match(_thousandRegEx) &&
                            !!_valArray[1].match(/^\d+$/));
                    }
                }
            }
        }
        return false;
    };
    /************************************
        Helpers
    ************************************/
    function setCulture(code, values) {
        cultures[code] = values;
    }
    function chooseCulture(code) {
        currentCulture = code;
        var defaults = cultures[code].defaults;
        if (defaults && defaults.format) {
            numbro.defaultFormat(defaults.format);
        }
        if (defaults && defaults.currencyFormat) {
            numbro.defaultCurrencyFormat(defaults.currencyFormat);
        }
    }
    function format(input, formatString, language, roundingFunction) {
        if (language != null && language !== numbro.culture()) {
            numbro.setCulture(language);
        }
        return formatNumbro(Number(input), formatString != null ? formatString : defaultFormat, roundingFunction == null ? Math.round : roundingFunction);
    }
    module.exports = { "format": format };
},
/* sprintf-js/src/sprintf.js */ function _(require, module, exports, __esModule, __esExport) {
    /* global window, exports, define */
    !function () {
        'use strict';
        var re = {
            not_string: /[^s]/,
            not_bool: /[^t]/,
            not_type: /[^T]/,
            not_primitive: /[^v]/,
            number: /[diefg]/,
            numeric_arg: /[bcdiefguxX]/,
            json: /[j]/,
            not_json: /[^j]/,
            text: /^[^\x25]+/,
            modulo: /^\x25{2}/,
            placeholder: /^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,
            key: /^([a-z_][a-z_\d]*)/i,
            key_access: /^\.([a-z_][a-z_\d]*)/i,
            index_access: /^\[(\d+)\]/,
            sign: /^[+-]/
        };
        function sprintf(key) {
            // `arguments` is not an array, but should be fine for this call
            return sprintf_format(sprintf_parse(key), arguments);
        }
        function vsprintf(fmt, argv) {
            return sprintf.apply(null, [fmt].concat(argv || []));
        }
        function sprintf_format(parse_tree, argv) {
            var cursor = 1, tree_length = parse_tree.length, arg, output = '', i, k, ph, pad, pad_character, pad_length, is_positive, sign;
            for (i = 0; i < tree_length; i++) {
                if (typeof parse_tree[i] === 'string') {
                    output += parse_tree[i];
                }
                else if (typeof parse_tree[i] === 'object') {
                    ph = parse_tree[i]; // convenience purposes only
                    if (ph.keys) { // keyword argument
                        arg = argv[cursor];
                        for (k = 0; k < ph.keys.length; k++) {
                            if (arg == undefined) {
                                throw new Error(sprintf('[sprintf] Cannot access property "%s" of undefined value "%s"', ph.keys[k], ph.keys[k - 1]));
                            }
                            arg = arg[ph.keys[k]];
                        }
                    }
                    else if (ph.param_no) { // positional argument (explicit)
                        arg = argv[ph.param_no];
                    }
                    else { // positional argument (implicit)
                        arg = argv[cursor++];
                    }
                    if (re.not_type.test(ph.type) && re.not_primitive.test(ph.type) && arg instanceof Function) {
                        arg = arg();
                    }
                    if (re.numeric_arg.test(ph.type) && (typeof arg !== 'number' && isNaN(arg))) {
                        throw new TypeError(sprintf('[sprintf] expecting number but found %T', arg));
                    }
                    if (re.number.test(ph.type)) {
                        is_positive = arg >= 0;
                    }
                    switch (ph.type) {
                        case 'b':
                            arg = parseInt(arg, 10).toString(2);
                            break;
                        case 'c':
                            arg = String.fromCharCode(parseInt(arg, 10));
                            break;
                        case 'd':
                        case 'i':
                            arg = parseInt(arg, 10);
                            break;
                        case 'j':
                            arg = JSON.stringify(arg, null, ph.width ? parseInt(ph.width) : 0);
                            break;
                        case 'e':
                            arg = ph.precision ? parseFloat(arg).toExponential(ph.precision) : parseFloat(arg).toExponential();
                            break;
                        case 'f':
                            arg = ph.precision ? parseFloat(arg).toFixed(ph.precision) : parseFloat(arg);
                            break;
                        case 'g':
                            arg = ph.precision ? String(Number(arg.toPrecision(ph.precision))) : parseFloat(arg);
                            break;
                        case 'o':
                            arg = (parseInt(arg, 10) >>> 0).toString(8);
                            break;
                        case 's':
                            arg = String(arg);
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 't':
                            arg = String(!!arg);
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'T':
                            arg = Object.prototype.toString.call(arg).slice(8, -1).toLowerCase();
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'u':
                            arg = parseInt(arg, 10) >>> 0;
                            break;
                        case 'v':
                            arg = arg.valueOf();
                            arg = (ph.precision ? arg.substring(0, ph.precision) : arg);
                            break;
                        case 'x':
                            arg = (parseInt(arg, 10) >>> 0).toString(16);
                            break;
                        case 'X':
                            arg = (parseInt(arg, 10) >>> 0).toString(16).toUpperCase();
                            break;
                    }
                    if (re.json.test(ph.type)) {
                        output += arg;
                    }
                    else {
                        if (re.number.test(ph.type) && (!is_positive || ph.sign)) {
                            sign = is_positive ? '+' : '-';
                            arg = arg.toString().replace(re.sign, '');
                        }
                        else {
                            sign = '';
                        }
                        pad_character = ph.pad_char ? ph.pad_char === '0' ? '0' : ph.pad_char.charAt(1) : ' ';
                        pad_length = ph.width - (sign + arg).length;
                        pad = ph.width ? (pad_length > 0 ? pad_character.repeat(pad_length) : '') : '';
                        output += ph.align ? sign + arg + pad : (pad_character === '0' ? sign + pad + arg : pad + sign + arg);
                    }
                }
            }
            return output;
        }
        var sprintf_cache = Object.create(null);
        function sprintf_parse(fmt) {
            if (sprintf_cache[fmt]) {
                return sprintf_cache[fmt];
            }
            var _fmt = fmt, match, parse_tree = [], arg_names = 0;
            while (_fmt) {
                if ((match = re.text.exec(_fmt)) !== null) {
                    parse_tree.push(match[0]);
                }
                else if ((match = re.modulo.exec(_fmt)) !== null) {
                    parse_tree.push('%');
                }
                else if ((match = re.placeholder.exec(_fmt)) !== null) {
                    if (match[2]) {
                        arg_names |= 1;
                        var field_list = [], replacement_field = match[2], field_match = [];
                        if ((field_match = re.key.exec(replacement_field)) !== null) {
                            field_list.push(field_match[1]);
                            while ((replacement_field = replacement_field.substring(field_match[0].length)) !== '') {
                                if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                                    field_list.push(field_match[1]);
                                }
                                else if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                                    field_list.push(field_match[1]);
                                }
                                else {
                                    throw new SyntaxError('[sprintf] failed to parse named argument key');
                                }
                            }
                        }
                        else {
                            throw new SyntaxError('[sprintf] failed to parse named argument key');
                        }
                        match[2] = field_list;
                    }
                    else {
                        arg_names |= 2;
                    }
                    if (arg_names === 3) {
                        throw new Error('[sprintf] mixing positional and named placeholders is not (yet) supported');
                    }
                    parse_tree.push({
                        placeholder: match[0],
                        param_no: match[1],
                        keys: match[2],
                        sign: match[3],
                        pad_char: match[4],
                        align: match[5],
                        width: match[6],
                        precision: match[7],
                        type: match[8]
                    });
                }
                else {
                    throw new SyntaxError('[sprintf] unexpected placeholder');
                }
                _fmt = _fmt.substring(match[0].length);
            }
            return sprintf_cache[fmt] = parse_tree;
        }
        /**
         * export to either browser or node.js
         */
        /* eslint-disable quote-props */
        if (typeof exports !== 'undefined') {
            exports['sprintf'] = sprintf;
            exports['vsprintf'] = vsprintf;
        }
        if (typeof window !== 'undefined') {
            window['sprintf'] = sprintf;
            window['vsprintf'] = vsprintf;
            if (typeof define === 'function' && define['amd']) {
                define(function () {
                    return {
                        'sprintf': sprintf,
                        'vsprintf': vsprintf
                    };
                });
            }
        }
        /* eslint-enable quote-props */
    }(); // eslint-disable-line
},
/* timezone/index.js */ function _(require, module, exports, __esModule, __esExport) {
    !function (definition) {
        if (typeof module == "object" && module.exports)
            module.exports = definition();
        else if (typeof define == "function")
            define(definition);
        else
            this.tz = definition();
    }(function () {
        /*
          function die () {
            console.log.apply(console, __slice.call(arguments, 0));
            return process.exit(1);
          }
        
          function say () { return console.log.apply(console, __slice.call(arguments, 0)) }
        */
        function actualize(entry, rule, year) {
            var actualized, date = rule.day[1];
            do {
                actualized = new Date(Date.UTC(year, rule.month, Math.abs(date++)));
            } while (rule.day[0] < 7 && actualized.getUTCDay() != rule.day[0]);
            actualized = {
                clock: rule.clock,
                sort: actualized.getTime(),
                rule: rule,
                save: rule.save * 6e4,
                offset: entry.offset
            };
            actualized[actualized.clock] = actualized.sort + rule.time * 6e4;
            if (actualized.posix) {
                actualized.wallclock = actualized[actualized.clock] + (entry.offset + rule.saved);
            }
            else {
                actualized.posix = actualized[actualized.clock] - (entry.offset + rule.saved);
            }
            return actualized;
        }
        function find(request, clock, time) {
            var i, I, entry, found, zone = request[request.zone], actualized = [], abbrev, rules, j, year = new Date(time).getUTCFullYear(), off = 1;
            for (i = 1, I = zone.length; i < I; i++)
                if (zone[i][clock] <= time)
                    break;
            entry = zone[i];
            if (entry.rules) {
                rules = request[entry.rules];
                for (j = year + 1; j >= year - off; --j)
                    for (i = 0, I = rules.length; i < I; i++)
                        if (rules[i].from <= j && j <= rules[i].to)
                            actualized.push(actualize(entry, rules[i], j));
                        else if (rules[i].to < j && off == 1)
                            off = j - rules[i].to;
                actualized.sort(function (a, b) { return a.sort - b.sort; });
                for (i = 0, I = actualized.length; i < I; i++) {
                    if (time >= actualized[i][clock] && actualized[i][actualized[i].clock] > entry[actualized[i].clock])
                        found = actualized[i];
                }
            }
            if (found) {
                if (abbrev = /^(.*)\/(.*)$/.exec(entry.format)) {
                    found.abbrev = abbrev[found.save ? 2 : 1];
                }
                else {
                    found.abbrev = entry.format.replace(/%s/, found.rule.letter);
                }
            }
            return found || entry;
        }
        function convertToWallclock(request, posix) {
            if (request.zone == "UTC")
                return posix;
            request.entry = find(request, "posix", posix);
            return posix + request.entry.offset + request.entry.save;
        }
        function convertToPOSIX(request, wallclock) {
            if (request.zone == "UTC")
                return wallclock;
            var entry, diff;
            request.entry = entry = find(request, "wallclock", wallclock);
            diff = wallclock - entry.wallclock;
            return 0 < diff && diff < entry.save ? null : wallclock - entry.offset - entry.save;
        }
        function adjust(request, posix, match) {
            var increment = +(match[1] + 1) // conversion necessary for week day addition
            , offset = match[2] * increment, index = UNITS.indexOf(match[3].toLowerCase()), date;
            if (index > 9) {
                posix += offset * TIME[index - 10];
            }
            else {
                date = new Date(convertToWallclock(request, posix));
                if (index < 7) {
                    while (offset) {
                        date.setUTCDate(date.getUTCDate() + increment);
                        if (date.getUTCDay() == index)
                            offset -= increment;
                    }
                }
                else if (index == 7) {
                    date.setUTCFullYear(date.getUTCFullYear() + offset);
                }
                else if (index == 8) {
                    date.setUTCMonth(date.getUTCMonth() + offset);
                }
                else {
                    date.setUTCDate(date.getUTCDate() + offset);
                }
                if ((posix = convertToPOSIX(request, date.getTime())) == null) {
                    posix = convertToPOSIX(request, date.getTime() + 864e5 * increment) - 864e5 * increment;
                }
            }
            return posix;
        }
        function convert(vargs) {
            if (!vargs.length)
                return "1.0.23";
            var request = Object.create(this), adjustments = [], i, I, $, argument, date;
            for (i = 0; i < vargs.length; i++) { // leave the for loop alone, it works.
                argument = vargs[i];
                // https://twitter.com/bigeasy/status/215112186572439552
                if (Array.isArray(argument)) {
                    if (!i && !isNaN(argument[1])) {
                        date = argument;
                    }
                    else {
                        argument.splice.apply(vargs, [i--, 1].concat(argument));
                    }
                }
                else if (isNaN(argument)) {
                    $ = typeof argument;
                    if ($ == "string") {
                        if (~argument.indexOf("%")) {
                            request.format = argument;
                        }
                        else if (!i && argument == "*") {
                            date = argument;
                        }
                        else if (!i && ($ = /^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(argument))) {
                            date = [];
                            date.push.apply(date, $.slice(1, 8));
                            if ($[9]) {
                                date.push($[10] + 1);
                                date.push.apply(date, $[11].split(/:/));
                            }
                            else if ($[8]) {
                                date.push(1);
                            }
                        }
                        else if (/^\w{2,3}_\w{2}$/.test(argument)) {
                            request.locale = argument;
                        }
                        else if ($ = UNIT_RE.exec(argument)) {
                            adjustments.push($);
                        }
                        else {
                            request.zone = argument;
                        }
                    }
                    else if ($ == "function") {
                        if ($ = argument.call(request))
                            return $;
                    }
                    else if (/^\w{2,3}_\w{2}$/.test(argument.name)) {
                        request[argument.name] = argument;
                    }
                    else if (argument.zones) {
                        for ($ in argument.zones)
                            request[$] = argument.zones[$];
                        for ($ in argument.rules)
                            request[$] = argument.rules[$];
                    }
                }
                else if (!i) {
                    date = argument;
                }
            }
            if (!request[request.locale])
                delete request.locale;
            if (!request[request.zone])
                delete request.zone;
            if (date != null) {
                if (date == "*") {
                    date = request.clock();
                }
                else if (Array.isArray(date)) {
                    $ = [];
                    I = !date[7];
                    for (i = 0; i < 11; i++)
                        $[i] = +(date[i] || 0); // conversion necessary for decrement
                    --$[1]; // Grr..
                    date = Date.UTC.apply(Date.UTC, $) + -$[7] * ($[8] * 36e5 + $[9] * 6e4 + $[10] * 1e3);
                }
                else {
                    date = Math.floor(date);
                }
                if (!isNaN(date)) {
                    if (I)
                        date = convertToPOSIX(request, date);
                    if (date == null)
                        return date;
                    for (i = 0, I = adjustments.length; i < I; i++) {
                        date = adjust(request, date, adjustments[i]);
                    }
                    if (!request.format)
                        return date;
                    $ = new Date(convertToWallclock(request, date));
                    return request.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g, function (value, flag, colons, padding, specifier) {
                        var f, fill = "0", pad;
                        if (f = request[specifier]) {
                            value = String(f.call(request, $, date, flag, colons.length));
                            if ((flag || f.style) == "_")
                                fill = " ";
                            pad = flag == "-" ? 0 : f.pad || 0;
                            while (value.length < pad)
                                value = fill + value;
                            pad = flag == "-" ? 0 : padding || f.pad;
                            while (value.length < pad)
                                value = fill + value;
                            if (specifier == "N" && pad < value.length)
                                value = value.slice(0, pad);
                            if (flag == "^")
                                value = value.toUpperCase();
                        }
                        return value;
                    });
                }
            }
            return function () { return request.convert(arguments); };
        }
        var context = { clock: function () { return +(new Date()); },
            zone: "UTC",
            entry: { abbrev: "UTC", offset: 0, save: 0 },
            UTC: 1,
            z: function (date, posix, flag, delimiters) {
                var offset = this.entry.offset + this.entry.save, seconds = Math.abs(offset / 1000), parts = [], part = 3600, i, z;
                for (i = 0; i < 3; i++) {
                    parts.push(("0" + Math.floor(seconds / part)).slice(-2));
                    seconds %= part;
                    part /= 60;
                }
                if (flag == "^" && !offset)
                    return "Z";
                if (flag == "^")
                    delimiters = 3;
                if (delimiters == 3) {
                    z = parts.join(":");
                    z = z.replace(/:00$/, "");
                    if (flag != "^")
                        z = z.replace(/:00$/, "");
                }
                else if (delimiters) {
                    z = parts.slice(0, delimiters + 1).join(":");
                    if (flag == "^")
                        z = z.replace(/:00$/, "");
                }
                else {
                    z = parts.slice(0, 2).join("");
                }
                z = (offset < 0 ? "-" : "+") + z;
                z = z.replace(/([-+])(0)/, { "_": " $1", "-": "$1" }[flag] || "$1$2");
                return z;
            },
            "%": function (date) { return "%"; },
            n: function (date) { return "\n"; },
            t: function (date) { return "\t"; },
            U: function (date) { return weekOfYear(date, 0); },
            W: function (date) { return weekOfYear(date, 1); },
            V: function (date) { return isoWeek(date)[0]; },
            G: function (date) { return isoWeek(date)[1]; },
            g: function (date) { return isoWeek(date)[1] % 100; },
            j: function (date) { return Math.floor((date.getTime() - Date.UTC(date.getUTCFullYear(), 0)) / 864e5) + 1; },
            s: function (date) { return Math.floor(date.getTime() / 1000); },
            C: function (date) { return Math.floor(date.getUTCFullYear() / 100); },
            N: function (date) { return date.getTime() % 1000 * 1000000; },
            m: function (date) { return date.getUTCMonth() + 1; },
            Y: function (date) { return date.getUTCFullYear(); },
            y: function (date) { return date.getUTCFullYear() % 100; },
            H: function (date) { return date.getUTCHours(); },
            M: function (date) { return date.getUTCMinutes(); },
            S: function (date) { return date.getUTCSeconds(); },
            e: function (date) { return date.getUTCDate(); },
            d: function (date) { return date.getUTCDate(); },
            u: function (date) { return date.getUTCDay() || 7; },
            w: function (date) { return date.getUTCDay(); },
            l: function (date) { return date.getUTCHours() % 12 || 12; },
            I: function (date) { return date.getUTCHours() % 12 || 12; },
            k: function (date) { return date.getUTCHours(); },
            Z: function (date) { return this.entry.abbrev; },
            a: function (date) { return this[this.locale].day.abbrev[date.getUTCDay()]; },
            A: function (date) { return this[this.locale].day.full[date.getUTCDay()]; },
            h: function (date) { return this[this.locale].month.abbrev[date.getUTCMonth()]; },
            b: function (date) { return this[this.locale].month.abbrev[date.getUTCMonth()]; },
            B: function (date) { return this[this.locale].month.full[date.getUTCMonth()]; },
            P: function (date) { return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)].toLowerCase(); },
            p: function (date) { return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)]; },
            R: function (date, posix) { return this.convert([posix, "%H:%M"]); },
            T: function (date, posix) { return this.convert([posix, "%H:%M:%S"]); },
            D: function (date, posix) { return this.convert([posix, "%m/%d/%y"]); },
            F: function (date, posix) { return this.convert([posix, "%Y-%m-%d"]); },
            x: function (date, posix) { return this.convert([posix, this[this.locale].date]); },
            r: function (date, posix) { return this.convert([posix, this[this.locale].time12 || '%I:%M:%S']); },
            X: function (date, posix) { return this.convert([posix, this[this.locale].time24]); },
            c: function (date, posix) { return this.convert([posix, this[this.locale].dateTime]); },
            convert: convert,
            locale: "en_US",
            en_US: {
                date: "%m/%d/%Y",
                time24: "%I:%M:%S %p",
                time12: "%I:%M:%S %p",
                dateTime: "%a %d %b %Y %I:%M:%S %p %Z",
                meridiem: ["AM", "PM"],
                month: {
                    abbrev: "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),
                    full: "January|February|March|April|May|June|July|August|September|October|November|December".split("|")
                },
                day: {
                    abbrev: "Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),
                    full: "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")
                }
            }
        };
        var UNITS = "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond", UNIT_RE = new RegExp("^\\s*([+-])(\\d+)\\s+(" + UNITS + ")s?\\s*$", "i"), TIME = [36e5, 6e4, 1e3, 1];
        UNITS = UNITS.toLowerCase().split("|");
        "delmHMSUWVgCIky".replace(/./g, function (e) { context[e].pad = 2; });
        context.N.pad = 9;
        context.j.pad = 3;
        context.k.style = "_";
        context.l.style = "_";
        context.e.style = "_";
        function weekOfYear(date, startOfWeek) {
            var diff, nyd, weekStart;
            nyd = new Date(Date.UTC(date.getUTCFullYear(), 0));
            diff = Math.floor((date.getTime() - nyd.getTime()) / 864e5);
            if (nyd.getUTCDay() == startOfWeek) {
                weekStart = 0;
            }
            else {
                weekStart = 7 - nyd.getUTCDay() + startOfWeek;
                if (weekStart == 8) {
                    weekStart = 1;
                }
            }
            return diff >= weekStart ? Math.floor((diff - weekStart) / 7) + 1 : 0;
        }
        function isoWeek(date) {
            var nyd, nyy, week;
            nyy = date.getUTCFullYear();
            nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
            week = weekOfYear(date, 1) + (nyd > 1 && nyd <= 4 ? 1 : 0);
            if (!week) {
                nyy = date.getUTCFullYear() - 1;
                nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
                week = nyd == 4 || (nyd == 3 && new Date(nyy, 1, 29).getDate() == 29) ? 53 : 52;
                return [week, date.getUTCFullYear() - 1];
            }
            else if (week == 53 && !(nyd == 4 || (nyd == 3 && new Date(nyy, 1, 29).getDate() == 29))) {
                return [1, date.getUTCFullYear() + 1];
            }
            else {
                return [week, date.getUTCFullYear()];
            }
        }
        return function () { return context.convert(arguments); };
    });
},
/* models/tickers/util.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    // TODO Clear out debugging code, etc.
    // TODO Organize helper functions.
    // TODO The years ticker doesn't always use the roundest numbers; it should
    // probably use a special ticker.
    // TODO Add tests.
    // TODO There used to be a TODO: restore memoization.  So.... do that?
    // TODO Instead of a get_ticks() method, there used to be an auto_ticks()
    // function that took a lot of fancy arguments, but those arguments weren't
    // used anywhere.  Should we restore them?
    // Some time constants, in milliseconds.
    exports.ONE_MILLI = 1.0;
    exports.ONE_SECOND = 1000.0;
    exports.ONE_MINUTE = 60.0 * exports.ONE_SECOND;
    exports.ONE_HOUR = 60 * exports.ONE_MINUTE;
    exports.ONE_DAY = 24 * exports.ONE_HOUR;
    exports.ONE_MONTH = 30 * exports.ONE_DAY; // An approximation, obviously.
    exports.ONE_YEAR = 365 * exports.ONE_DAY;
    // ---------------------------------------------------------------------------
    // Date/time utility functions
    // ---------------------------------------------------------------------------
    // Makes a copy of a date object.
    function copy_date(date) {
        return new Date(date.getTime());
    }
    exports.copy_date = copy_date;
    // Rounds a date down to the month.
    function last_month_no_later_than(date) {
        const new_date = copy_date(date);
        new_date.setUTCDate(1);
        new_date.setUTCHours(0);
        new_date.setUTCMinutes(0);
        new_date.setUTCSeconds(0);
        new_date.setUTCMilliseconds(0);
        return new_date;
    }
    exports.last_month_no_later_than = last_month_no_later_than;
    // Rounds a date down to the year.
    function last_year_no_later_than(date) {
        const new_date = last_month_no_later_than(date);
        new_date.setUTCMonth(0);
        return new_date;
    }
    exports.last_year_no_later_than = last_year_no_later_than;
},
/* models/tickers/datetime_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const array_1 = require(10) /* ../../core/util/array */;
    const adaptive_ticker_1 = require(176) /* ./adaptive_ticker */;
    const composite_ticker_1 = require(178) /* ./composite_ticker */;
    const days_ticker_1 = require(179) /* ./days_ticker */;
    const months_ticker_1 = require(181) /* ./months_ticker */;
    const years_ticker_1 = require(182) /* ./years_ticker */;
    const util_1 = require(174) /* ./util */;
    class DatetimeTicker extends composite_ticker_1.CompositeTicker {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.DatetimeTicker = DatetimeTicker;
    _a = DatetimeTicker;
    DatetimeTicker.__name__ = "DatetimeTicker";
    (() => {
        _a.override({
            num_minor_ticks: 0,
            tickers: () => [
                // Sub-second.
                new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 5],
                    base: 10,
                    min_interval: 0,
                    max_interval: 500 * util_1.ONE_MILLI,
                    num_minor_ticks: 0,
                }),
                // Seconds, minutes.
                new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 5, 10, 15, 20, 30],
                    base: 60,
                    min_interval: util_1.ONE_SECOND,
                    max_interval: 30 * util_1.ONE_MINUTE,
                    num_minor_ticks: 0,
                }),
                // Hours.
                new adaptive_ticker_1.AdaptiveTicker({
                    mantissas: [1, 2, 4, 6, 8, 12],
                    base: 24.0,
                    min_interval: util_1.ONE_HOUR,
                    max_interval: 12 * util_1.ONE_HOUR,
                    num_minor_ticks: 0,
                }),
                // Days.
                new days_ticker_1.DaysTicker({ days: (0, array_1.range)(1, 32) }),
                new days_ticker_1.DaysTicker({ days: (0, array_1.range)(1, 31, 3) }),
                new days_ticker_1.DaysTicker({ days: [1, 8, 15, 22] }),
                new days_ticker_1.DaysTicker({ days: [1, 15] }),
                // Months.
                new months_ticker_1.MonthsTicker({ months: (0, array_1.range)(0, 12, 1) }),
                new months_ticker_1.MonthsTicker({ months: (0, array_1.range)(0, 12, 2) }),
                new months_ticker_1.MonthsTicker({ months: (0, array_1.range)(0, 12, 4) }),
                new months_ticker_1.MonthsTicker({ months: (0, array_1.range)(0, 12, 6) }),
                // Years
                new years_ticker_1.YearsTicker({}),
            ],
        });
    })();
},
/* models/tickers/adaptive_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_ticker_1 = require(177) /* ./continuous_ticker */;
    const array_1 = require(10) /* ../../core/util/array */;
    const math_1 = require(11) /* ../../core/util/math */;
    class AdaptiveTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_min_interval() {
            return this.min_interval;
        }
        get_max_interval() {
            var _b;
            return (_b = this.max_interval) !== null && _b !== void 0 ? _b : Infinity;
        }
        // These arguments control the range of possible intervals.  The interval I
        // returned by get_interval() will be the one that most closely matches the
        // desired number of ticks, subject to the following constraints:
        // I = (M * B^N), where
        // M is a member of mantissas,
        // B is base,
        // and N is an integer;
        // and min_interval <= I <= max_interval.
        initialize() {
            super.initialize();
            const prefix_mantissa = (0, array_1.nth)(this.mantissas, -1) / this.base;
            const suffix_mantissa = (0, array_1.nth)(this.mantissas, 0) * this.base;
            this.extended_mantissas = [prefix_mantissa, ...this.mantissas, suffix_mantissa];
            this.base_factor = this.get_min_interval() === 0.0 ? 1.0 : this.get_min_interval();
        }
        get_interval(data_low, data_high, desired_n_ticks) {
            const data_range = data_high - data_low;
            const ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
            const interval_exponent = Math.floor((0, math_1.log)(ideal_interval / this.base_factor, this.base));
            const ideal_magnitude = this.base ** interval_exponent * this.base_factor;
            // An untested optimization.
            //   const ideal_mantissa = ideal_interval / ideal_magnitude
            //   index = sorted_index(this.extended_mantissas, ideal_mantissa)
            //   candidate_mantissas = this.extended_mantissas[index..index + 1]
            const candidate_mantissas = this.extended_mantissas;
            const errors = candidate_mantissas.map((mantissa) => {
                return Math.abs(desired_n_ticks - (data_range / (mantissa * ideal_magnitude)));
            });
            const best_mantissa = candidate_mantissas[(0, array_1.argmin)(errors)];
            const interval = best_mantissa * ideal_magnitude;
            return (0, math_1.clamp)(interval, this.get_min_interval(), this.get_max_interval());
        }
    }
    exports.AdaptiveTicker = AdaptiveTicker;
    _a = AdaptiveTicker;
    AdaptiveTicker.__name__ = "AdaptiveTicker";
    (() => {
        _a.define(({ Number, Array, Nullable }) => ({
            base: [Number, 10.0],
            mantissas: [Array(Number), [1, 2, 5]],
            min_interval: [Number, 0.0],
            max_interval: [Nullable(Number), null],
        }));
    })();
},
/* models/tickers/continuous_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const ticker_1 = require(161) /* ./ticker */;
    const array_1 = require(10) /* ../../core/util/array */;
    class ContinuousTicker extends ticker_1.Ticker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks(data_low, data_high, _range, cross_loc) {
            return this.get_ticks_no_defaults(data_low, data_high, cross_loc, this.desired_num_ticks);
        }
        // The version of get_ticks() that does the work (and the version that
        // should be overridden in subclasses).
        get_ticks_no_defaults(data_low, data_high, _cross_loc, desired_n_ticks) {
            const interval = this.get_interval(data_low, data_high, desired_n_ticks);
            const start_factor = Math.floor(data_low / interval);
            const end_factor = Math.ceil(data_high / interval);
            let factors;
            if (!isFinite(start_factor) || !isFinite(end_factor))
                factors = [];
            else
                factors = (0, array_1.range)(start_factor, end_factor + 1);
            const ticks = factors
                .map((factor) => factor * interval)
                .filter((tick) => data_low <= tick && tick <= data_high);
            const num_minor_ticks = this.num_minor_ticks;
            const minor_ticks = [];
            if (num_minor_ticks > 0 && ticks.length > 0) {
                const minor_interval = interval / num_minor_ticks;
                const minor_offsets = (0, array_1.range)(0, num_minor_ticks).map((i) => i * minor_interval);
                for (const x of minor_offsets.slice(1)) {
                    const mt = ticks[0] - x;
                    if (data_low <= mt && mt <= data_high) {
                        minor_ticks.push(mt);
                    }
                }
                for (const tick of ticks) {
                    for (const x of minor_offsets) {
                        const mt = tick + x;
                        if (data_low <= mt && mt <= data_high) {
                            minor_ticks.push(mt);
                        }
                    }
                }
            }
            return {
                major: ticks,
                minor: minor_ticks,
            };
        }
        // Returns the interval size that would produce exactly the number of
        // desired ticks.  (In general we won't use exactly this interval, because
        // we want the ticks to be round numbers.)
        get_ideal_interval(data_low, data_high, desired_n_ticks) {
            const data_range = data_high - data_low;
            return data_range / desired_n_ticks;
        }
    }
    exports.ContinuousTicker = ContinuousTicker;
    _a = ContinuousTicker;
    ContinuousTicker.__name__ = "ContinuousTicker";
    (() => {
        _a.define(({ Int }) => ({
            num_minor_ticks: [Int, 5],
            desired_num_ticks: [Int, 6],
        }));
    })();
},
/* models/tickers/composite_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_ticker_1 = require(177) /* ./continuous_ticker */;
    const array_1 = require(10) /* ../../core/util/array */;
    class CompositeTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        // The tickers should be in order of increasing interval size; specifically,
        // if S comes before T, then it should be the case that
        // S.get_max_interval() < T.get_min_interval().
        // FIXME Enforce this automatically.
        get min_intervals() {
            return this.tickers.map((ticker) => ticker.get_min_interval());
        }
        get max_intervals() {
            return this.tickers.map((ticker) => ticker.get_max_interval());
        }
        get_min_interval() {
            return this.min_intervals[0];
        }
        get_max_interval() {
            return this.max_intervals[0];
        }
        get_best_ticker(data_low, data_high, desired_n_ticks) {
            const data_range = data_high - data_low;
            const ideal_interval = this.get_ideal_interval(data_low, data_high, desired_n_ticks);
            const ticker_ndxs = [
                (0, array_1.sorted_index)(this.min_intervals, ideal_interval) - 1,
                (0, array_1.sorted_index)(this.max_intervals, ideal_interval),
            ];
            const intervals = [
                this.min_intervals[ticker_ndxs[0]],
                this.max_intervals[ticker_ndxs[1]],
            ];
            const errors = intervals.map((interval) => {
                return Math.abs(desired_n_ticks - (data_range / interval));
            });
            let best_ticker;
            if ((0, array_1.is_empty)(errors.filter((e) => !isNaN(e)))) {
                // this can happen if the data isn't loaded yet, we just default to the first scale
                best_ticker = this.tickers[0];
            }
            else {
                const best_index = (0, array_1.argmin)(errors);
                const best_ticker_ndx = ticker_ndxs[best_index];
                best_ticker = this.tickers[best_ticker_ndx];
            }
            return best_ticker;
        }
        get_interval(data_low, data_high, desired_n_ticks) {
            const best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
            return best_ticker.get_interval(data_low, data_high, desired_n_ticks);
        }
        get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
            const best_ticker = this.get_best_ticker(data_low, data_high, desired_n_ticks);
            return best_ticker.get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks);
        }
    }
    exports.CompositeTicker = CompositeTicker;
    _a = CompositeTicker;
    CompositeTicker.__name__ = "CompositeTicker";
    (() => {
        _a.define(({ Array, Ref }) => ({
            tickers: [Array(Ref(continuous_ticker_1.ContinuousTicker)), []],
        }));
    })();
},
/* models/tickers/days_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const single_interval_ticker_1 = require(180) /* ./single_interval_ticker */;
    const util_1 = require(174) /* ./util */;
    const array_1 = require(10) /* ../../core/util/array */;
    // Given a start and end time in millis, returns the shortest array of
    // consecutive months (as Dates) that surrounds both times.
    function date_range_by_month(start_time, end_time) {
        const start_date = (0, util_1.last_month_no_later_than)(new Date(start_time));
        const end_date = (0, util_1.last_month_no_later_than)(new Date(end_time));
        // XXX This is not a reliable technique in general, but it should be
        // safe when the day of the month is 1.  (The problem case is this:
        // Mar 31 -> Apr 31, which becomes May 1.)
        end_date.setUTCMonth(end_date.getUTCMonth() + 1);
        const dates = [];
        const date = start_date;
        while (true) {
            dates.push((0, util_1.copy_date)(date));
            date.setUTCMonth(date.getUTCMonth() + 1);
            if (date > end_date)
                break;
        }
        return dates;
    }
    class DaysTicker extends single_interval_ticker_1.SingleIntervalTicker {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            const days = this.days;
            if (days.length > 1)
                this.interval = (days[1] - days[0]) * util_1.ONE_DAY;
            else
                this.interval = 31 * util_1.ONE_DAY;
        }
        get_ticks_no_defaults(data_low, data_high, _cross_loc, _desired_n_ticks) {
            const month_dates = date_range_by_month(data_low, data_high);
            const days = this.days;
            const days_of_month = (month_date, interval) => {
                const current_month = month_date.getUTCMonth();
                const dates = [];
                for (const day of days) {
                    const day_date = (0, util_1.copy_date)(month_date);
                    day_date.setUTCDate(day);
                    // We can't use all of the values in this.days, because they may not
                    // fall within the current month.  In fact, if, e.g., our month is 28 days
                    // and we're marking every third day, we don't want day 28 to show up
                    // because it'll be right next to the 1st of the next month.  So we
                    // make sure we have a bit of room before we include a day.
                    // TODO (bev) The above description does not exactly work because JS Date
                    // is broken and will happily consider "Feb 28 + 3*ONE_DAY" to have month "2"
                    const future_date = new Date(day_date.getTime() + (interval / 2));
                    if (future_date.getUTCMonth() == current_month)
                        dates.push(day_date);
                }
                return dates;
            };
            const interval = this.interval;
            const day_dates = (0, array_1.concat)(month_dates.map((date) => days_of_month(date, interval)));
            const all_ticks = day_dates.map((day_date) => day_date.getTime());
            const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
            return {
                major: ticks_in_range,
                minor: [],
            };
        }
    }
    exports.DaysTicker = DaysTicker;
    _a = DaysTicker;
    DaysTicker.__name__ = "DaysTicker";
    (() => {
        _a.define(({ Int, Array }) => ({
            days: [Array(Int), []],
        }));
        _a.override({
            num_minor_ticks: 0,
        });
    })();
},
/* models/tickers/single_interval_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_ticker_1 = require(177) /* ./continuous_ticker */;
    class SingleIntervalTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_interval(_data_low, _data_high, _n_desired_ticks) {
            return this.interval;
        }
        get_min_interval() {
            return this.interval;
        }
        get_max_interval() {
            return this.interval;
        }
    }
    exports.SingleIntervalTicker = SingleIntervalTicker;
    _a = SingleIntervalTicker;
    SingleIntervalTicker.__name__ = "SingleIntervalTicker";
    (() => {
        _a.define(({ Number }) => ({
            interval: [Number],
        }));
    })();
},
/* models/tickers/months_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const single_interval_ticker_1 = require(180) /* ./single_interval_ticker */;
    const util_1 = require(174) /* ./util */;
    const array_1 = require(10) /* ../../core/util/array */;
    // Given a start and end time in millis, returns the shortest array of
    // consecutive years (as Dates) that surrounds both times.
    function date_range_by_year(start_time, end_time) {
        const start_date = (0, util_1.last_year_no_later_than)(new Date(start_time));
        const end_date = (0, util_1.last_year_no_later_than)(new Date(end_time));
        end_date.setUTCFullYear(end_date.getUTCFullYear() + 1);
        const dates = [];
        const date = start_date;
        while (true) {
            dates.push((0, util_1.copy_date)(date));
            date.setUTCFullYear(date.getUTCFullYear() + 1);
            if (date > end_date)
                break;
        }
        return dates;
    }
    class MonthsTicker extends single_interval_ticker_1.SingleIntervalTicker {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            const months = this.months;
            if (months.length > 1)
                this.interval = (months[1] - months[0]) * util_1.ONE_MONTH;
            else
                this.interval = 12 * util_1.ONE_MONTH;
        }
        get_ticks_no_defaults(data_low, data_high, _cross_loc, _desired_n_ticks) {
            const year_dates = date_range_by_year(data_low, data_high);
            const months = this.months;
            const months_of_year = (year_date) => {
                return months.map((month) => {
                    const month_date = (0, util_1.copy_date)(year_date);
                    month_date.setUTCMonth(month);
                    return month_date;
                });
            };
            const month_dates = (0, array_1.concat)(year_dates.map(months_of_year));
            const all_ticks = month_dates.map((month_date) => month_date.getTime());
            const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
            return {
                major: ticks_in_range,
                minor: [],
            };
        }
    }
    exports.MonthsTicker = MonthsTicker;
    _a = MonthsTicker;
    MonthsTicker.__name__ = "MonthsTicker";
    (() => {
        _a.define(({ Int, Array }) => ({
            months: [Array(Int), []],
        }));
    })();
},
/* models/tickers/years_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const basic_ticker_1 = require(183) /* ./basic_ticker */;
    const single_interval_ticker_1 = require(180) /* ./single_interval_ticker */;
    const util_1 = require(174) /* ./util */;
    class YearsTicker extends single_interval_ticker_1.SingleIntervalTicker {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.interval = util_1.ONE_YEAR;
            this.basic_ticker = new basic_ticker_1.BasicTicker({ num_minor_ticks: 0 });
        }
        get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
            const start_year = (0, util_1.last_year_no_later_than)(new Date(data_low)).getUTCFullYear();
            const end_year = (0, util_1.last_year_no_later_than)(new Date(data_high)).getUTCFullYear();
            const years = this.basic_ticker.get_ticks_no_defaults(start_year, end_year, cross_loc, desired_n_ticks).major;
            const all_ticks = years.map((year) => Date.UTC(year, 0, 1));
            const ticks_in_range = all_ticks.filter((tick) => data_low <= tick && tick <= data_high);
            return {
                major: ticks_in_range,
                minor: [],
            };
        }
    }
    exports.YearsTicker = YearsTicker;
    YearsTicker.__name__ = "YearsTicker";
},
/* models/tickers/basic_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const adaptive_ticker_1 = require(176) /* ./adaptive_ticker */;
    class BasicTicker extends adaptive_ticker_1.AdaptiveTicker {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.BasicTicker = BasicTicker;
    BasicTicker.__name__ = "BasicTicker";
},
/* models/axes/linear_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_axis_1 = require(167) /* ./continuous_axis */;
    const basic_tick_formatter_1 = require(185) /* ../formatters/basic_tick_formatter */;
    const basic_ticker_1 = require(183) /* ../tickers/basic_ticker */;
    class LinearAxisView extends continuous_axis_1.ContinuousAxisView {
    }
    exports.LinearAxisView = LinearAxisView;
    LinearAxisView.__name__ = "LinearAxisView";
    class LinearAxis extends continuous_axis_1.ContinuousAxis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LinearAxis = LinearAxis;
    _a = LinearAxis;
    LinearAxis.__name__ = "LinearAxis";
    (() => {
        _a.prototype.default_view = LinearAxisView;
        _a.override({
            ticker: () => new basic_ticker_1.BasicTicker(),
            formatter: () => new basic_tick_formatter_1.BasicTickFormatter(),
        });
    })();
},
/* models/formatters/basic_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const tick_formatter_1 = require(162) /* ./tick_formatter */;
    const string_1 = require(38) /* ../../core/util/string */;
    function unicode_replace(input) {
        let output = "";
        for (const c of input) {
            if (c == "-")
                output += "\u2212";
            else
                output += c;
        }
        return output;
    }
    exports.unicode_replace = unicode_replace;
    class BasicTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
            this.last_precision = 3;
        }
        get scientific_limit_low() {
            return 10.0 ** this.power_limit_low;
        }
        get scientific_limit_high() {
            return 10.0 ** this.power_limit_high;
        }
        _need_sci(ticks) {
            if (!this.use_scientific)
                return false;
            const { scientific_limit_high } = this;
            const { scientific_limit_low } = this;
            const zeroish = ticks.length < 2 ? 0 : Math.abs(ticks[1] - ticks[0]) / 10000;
            for (const tick of ticks) {
                const tick_abs = Math.abs(tick);
                if (tick_abs <= zeroish)
                    continue;
                if (tick_abs >= scientific_limit_high || tick_abs <= scientific_limit_low) {
                    return true;
                }
            }
            return false;
        }
        _format_with_precision(ticks, need_sci, precision) {
            if (need_sci) {
                return ticks.map((tick) => unicode_replace(tick.toExponential(precision)));
            }
            else {
                return ticks.map((tick) => unicode_replace((0, string_1.to_fixed)(tick, precision)));
            }
        }
        _auto_precision(ticks, need_sci) {
            const labels = new Array(ticks.length);
            const asc = this.last_precision <= 15;
            outer: for (let x = this.last_precision; asc ? x <= 15 : x >= 1; asc ? x++ : x--) {
                if (need_sci) {
                    labels[0] = ticks[0].toExponential(x);
                    for (let i = 1; i < ticks.length; i++) {
                        if (labels[i] == labels[i - 1]) {
                            continue outer;
                        }
                    }
                    this.last_precision = x;
                    break;
                }
                else {
                    labels[0] = (0, string_1.to_fixed)(ticks[0], x);
                    for (let i = 1; i < ticks.length; i++) {
                        labels[i] = (0, string_1.to_fixed)(ticks[i], x);
                        if (labels[i] == labels[i - 1]) {
                            continue outer;
                        }
                    }
                    this.last_precision = x;
                    break;
                }
            }
            return this.last_precision;
        }
        doFormat(ticks, _opts) {
            if (ticks.length == 0)
                return [];
            const need_sci = this._need_sci(ticks);
            const precision = this.precision == "auto" ? this._auto_precision(ticks, need_sci) : this.precision;
            return this._format_with_precision(ticks, need_sci, precision);
        }
    }
    exports.BasicTickFormatter = BasicTickFormatter;
    _a = BasicTickFormatter;
    BasicTickFormatter.__name__ = "BasicTickFormatter";
    (() => {
        _a.define(({ Boolean, Int, Auto, Or }) => ({
            precision: [Or(Int, Auto), "auto"],
            use_scientific: [Boolean, true],
            power_limit_high: [Int, 5],
            power_limit_low: [Int, -3],
        }));
    })();
},
/* models/axes/log_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_axis_1 = require(167) /* ./continuous_axis */;
    const log_tick_formatter_1 = require(187) /* ../formatters/log_tick_formatter */;
    const log_ticker_1 = require(188) /* ../tickers/log_ticker */;
    class LogAxisView extends continuous_axis_1.ContinuousAxisView {
    }
    exports.LogAxisView = LogAxisView;
    LogAxisView.__name__ = "LogAxisView";
    class LogAxis extends continuous_axis_1.ContinuousAxis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.LogAxis = LogAxis;
    _a = LogAxis;
    LogAxis.__name__ = "LogAxis";
    (() => {
        _a.prototype.default_view = LogAxisView;
        _a.override({
            ticker: () => new log_ticker_1.LogTicker(),
            formatter: () => new log_tick_formatter_1.LogTickFormatter(),
        });
    })();
},
/* models/formatters/log_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const tick_formatter_1 = require(162) /* ./tick_formatter */;
    const basic_tick_formatter_1 = require(185) /* ./basic_tick_formatter */;
    const log_ticker_1 = require(188) /* ../tickers/log_ticker */;
    const graphics_1 = require(151) /* ../../core/graphics */;
    const { abs, log, round } = Math;
    class LogTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.basic_formatter = new basic_tick_formatter_1.BasicTickFormatter();
        }
        format_graphics(ticks, opts) {
            var _b, _c;
            if (ticks.length == 0)
                return [];
            const base = (_c = (_b = this.ticker) === null || _b === void 0 ? void 0 : _b.base) !== null && _c !== void 0 ? _c : 10;
            const expos = this._exponents(ticks, base);
            if (expos == null)
                return this.basic_formatter.format_graphics(ticks, opts);
            else {
                return expos.map((expo) => {
                    if (abs(expo) < this.min_exponent) {
                        const b = new graphics_1.TextBox({ text: (0, basic_tick_formatter_1.unicode_replace)(`${base ** expo}`) });
                        const e = new graphics_1.TextBox({ text: "" });
                        return new graphics_1.BaseExpo(b, e);
                    }
                    else {
                        const b = new graphics_1.TextBox({ text: (0, basic_tick_formatter_1.unicode_replace)(`${base}`) });
                        const e = new graphics_1.TextBox({ text: (0, basic_tick_formatter_1.unicode_replace)(`${expo}`) });
                        return new graphics_1.BaseExpo(b, e);
                    }
                });
            }
        }
        _exponents(ticks, base) {
            let last_exponent = null;
            const exponents = [];
            for (const tick of ticks) {
                const exponent = round(log(tick) / log(base));
                if (last_exponent != exponent) {
                    last_exponent = exponent;
                    exponents.push(exponent);
                }
                else
                    return null;
            }
            return exponents;
        }
        doFormat(ticks, opts) {
            var _b, _c;
            if (ticks.length == 0)
                return [];
            const base = (_c = (_b = this.ticker) === null || _b === void 0 ? void 0 : _b.base) !== null && _c !== void 0 ? _c : 10;
            const expos = this._exponents(ticks, base);
            if (expos == null)
                return this.basic_formatter.doFormat(ticks, opts);
            else
                return expos.map((expo) => {
                    if (abs(expo) < this.min_exponent)
                        return (0, basic_tick_formatter_1.unicode_replace)(`${base ** expo}`);
                    else
                        return (0, basic_tick_formatter_1.unicode_replace)(`${base}^${expo}`);
                });
        }
    }
    exports.LogTickFormatter = LogTickFormatter;
    _a = LogTickFormatter;
    LogTickFormatter.__name__ = "LogTickFormatter";
    (() => {
        _a.define(({ Int, Ref, Nullable }) => ({
            ticker: [Nullable(Ref(log_ticker_1.LogTicker)), null],
            min_exponent: [Int, 0],
        }));
    })();
},
/* models/tickers/log_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const adaptive_ticker_1 = require(176) /* ./adaptive_ticker */;
    const array_1 = require(10) /* ../../core/util/array */;
    class LogTicker extends adaptive_ticker_1.AdaptiveTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks_no_defaults(data_low, data_high, _cross_loc, desired_n_ticks) {
            const num_minor_ticks = this.num_minor_ticks;
            const minor_ticks = [];
            const base = this.base;
            const log_low = Math.log(data_low) / Math.log(base);
            const log_high = Math.log(data_high) / Math.log(base);
            const log_interval = log_high - log_low;
            let ticks;
            if (!isFinite(log_interval) || log_interval == 0) {
                ticks = [];
            }
            else if (log_interval < 2) { // treat as linear ticker
                const interval = this.get_interval(data_low, data_high, desired_n_ticks);
                const start_factor = Math.floor(data_low / interval);
                const end_factor = Math.ceil(data_high / interval);
                ticks = (0, array_1.range)(start_factor, end_factor + 1)
                    .filter((factor) => factor != 0)
                    .map((factor) => factor * interval)
                    .filter((tick) => data_low <= tick && tick <= data_high);
                if (num_minor_ticks > 0 && ticks.length > 0) {
                    const minor_interval = interval / num_minor_ticks;
                    const minor_offsets = (0, array_1.range)(0, num_minor_ticks).map((i) => i * minor_interval);
                    for (const x of minor_offsets.slice(1)) {
                        minor_ticks.push(ticks[0] - x);
                    }
                    for (const tick of ticks) {
                        for (const x of minor_offsets) {
                            minor_ticks.push(tick + x);
                        }
                    }
                }
            }
            else {
                const startlog = Math.ceil(log_low * 0.999999);
                const endlog = Math.floor(log_high * 1.000001);
                const interval = Math.ceil((endlog - startlog) / 9.0);
                ticks = (0, array_1.range)(startlog - 1, endlog + 1, interval)
                    .map((i) => base ** i);
                if (num_minor_ticks > 0 && ticks.length > 0) {
                    const minor_interval = base ** interval / num_minor_ticks;
                    const minor_offsets = (0, array_1.range)(1, num_minor_ticks + 1).map((i) => i * minor_interval);
                    for (const x of minor_offsets) {
                        minor_ticks.push(ticks[0] / x);
                    }
                    minor_ticks.push(ticks[0]);
                    for (const tick of ticks) {
                        for (const x of minor_offsets) {
                            minor_ticks.push(tick * x);
                        }
                    }
                }
            }
            return {
                major: ticks.filter((tick) => data_low <= tick && tick <= data_high),
                minor: minor_ticks.filter((tick) => data_low <= tick && tick <= data_high),
            };
        }
    }
    exports.LogTicker = LogTicker;
    _a = LogTicker;
    LogTicker.__name__ = "LogTicker";
    (() => {
        _a.override({
            mantissas: [1, 5],
        });
    })();
},
/* models/axes/mercator_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const axis_1 = require(159) /* ./axis */;
    const linear_axis_1 = require(184) /* ./linear_axis */;
    const mercator_tick_formatter_1 = require(190) /* ../formatters/mercator_tick_formatter */;
    const mercator_ticker_1 = require(191) /* ../tickers/mercator_ticker */;
    class MercatorAxisView extends axis_1.AxisView {
    }
    exports.MercatorAxisView = MercatorAxisView;
    MercatorAxisView.__name__ = "MercatorAxisView";
    class MercatorAxis extends linear_axis_1.LinearAxis {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.MercatorAxis = MercatorAxis;
    _a = MercatorAxis;
    MercatorAxis.__name__ = "MercatorAxis";
    (() => {
        _a.prototype.default_view = MercatorAxisView;
        _a.override({
            ticker: () => new mercator_ticker_1.MercatorTicker({ dimension: "lat" }),
            formatter: () => new mercator_tick_formatter_1.MercatorTickFormatter({ dimension: "lat" }),
        });
    })();
},
/* models/formatters/mercator_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const basic_tick_formatter_1 = require(185) /* ./basic_tick_formatter */;
    const enums_1 = require(19) /* ../../core/enums */;
    const projections_1 = require(105) /* ../../core/util/projections */;
    class MercatorTickFormatter extends basic_tick_formatter_1.BasicTickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        doFormat(ticks, opts) {
            if (this.dimension == null)
                throw new Error("MercatorTickFormatter.dimension not configured");
            if (ticks.length == 0)
                return [];
            const n = ticks.length;
            const proj_ticks = new Array(n);
            if (this.dimension == "lon") {
                for (let i = 0; i < n; i++) {
                    const [lon] = projections_1.wgs84_mercator.invert(ticks[i], opts.loc);
                    proj_ticks[i] = lon;
                }
            }
            else {
                for (let i = 0; i < n; i++) {
                    const [, lat] = projections_1.wgs84_mercator.invert(opts.loc, ticks[i]);
                    proj_ticks[i] = lat;
                }
            }
            return super.doFormat(proj_ticks, opts);
        }
    }
    exports.MercatorTickFormatter = MercatorTickFormatter;
    _a = MercatorTickFormatter;
    MercatorTickFormatter.__name__ = "MercatorTickFormatter";
    (() => {
        _a.define(({ Nullable }) => ({
            dimension: [Nullable(enums_1.LatLon), null],
        }));
    })();
},
/* models/tickers/mercator_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const basic_ticker_1 = require(183) /* ./basic_ticker */;
    const enums_1 = require(19) /* ../../core/enums */;
    const projections_1 = require(105) /* ../../core/util/projections */;
    class MercatorTicker extends basic_ticker_1.BasicTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks_no_defaults(data_low, data_high, cross_loc, desired_n_ticks) {
            if (this.dimension == null) {
                throw new Error(`${this}.dimension wasn't configured`);
            }
            [data_low, data_high] = (0, projections_1.clip_mercator)(data_low, data_high, this.dimension);
            if (this.dimension == "lon")
                return this._get_ticks_lon(data_low, data_high, cross_loc, desired_n_ticks);
            else
                return this._get_ticks_lat(data_low, data_high, cross_loc, desired_n_ticks);
        }
        _get_ticks_lon(data_low, data_high, cross_loc, desired_n_ticks) {
            const [proj_low] = projections_1.wgs84_mercator.invert(data_low, cross_loc);
            const [proj_high, proj_cross_loc] = projections_1.wgs84_mercator.invert(data_high, cross_loc);
            const proj_ticks = super.get_ticks_no_defaults(proj_low, proj_high, cross_loc, desired_n_ticks);
            const major = [];
            for (const tick of proj_ticks.major) {
                if ((0, projections_1.in_bounds)(tick, "lon")) {
                    const [lon] = projections_1.wgs84_mercator.compute(tick, proj_cross_loc);
                    major.push(lon);
                }
            }
            const minor = [];
            for (const tick of proj_ticks.minor) {
                if ((0, projections_1.in_bounds)(tick, "lon")) {
                    const [lon] = projections_1.wgs84_mercator.compute(tick, proj_cross_loc);
                    minor.push(lon);
                }
            }
            return { major, minor };
        }
        _get_ticks_lat(data_low, data_high, cross_loc, desired_n_ticks) {
            const [, proj_low] = projections_1.wgs84_mercator.invert(cross_loc, data_low);
            const [proj_cross_loc, proj_high] = projections_1.wgs84_mercator.invert(cross_loc, data_high);
            const proj_ticks = super.get_ticks_no_defaults(proj_low, proj_high, cross_loc, desired_n_ticks);
            const major = [];
            for (const tick of proj_ticks.major) {
                if ((0, projections_1.in_bounds)(tick, "lat")) {
                    const [, lat] = projections_1.wgs84_mercator.compute(proj_cross_loc, tick);
                    major.push(lat);
                }
            }
            const minor = [];
            for (const tick of proj_ticks.minor) {
                if ((0, projections_1.in_bounds)(tick, "lat")) {
                    const [, lat] = projections_1.wgs84_mercator.compute(proj_cross_loc, tick);
                    minor.push(lat);
                }
            }
            return { major, minor };
        }
    }
    exports.MercatorTicker = MercatorTicker;
    _a = MercatorTicker;
    MercatorTicker.__name__ = "MercatorTicker";
    (() => {
        _a.define(({ Nullable }) => ({
            dimension: [Nullable(enums_1.LatLon), null],
        }));
    })();
},
/* models/tickers/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var adaptive_ticker_1 = require(176) /* ./adaptive_ticker */;
    __esExport("AdaptiveTicker", adaptive_ticker_1.AdaptiveTicker);
    var basic_ticker_1 = require(183) /* ./basic_ticker */;
    __esExport("BasicTicker", basic_ticker_1.BasicTicker);
    var categorical_ticker_1 = require(165) /* ./categorical_ticker */;
    __esExport("CategoricalTicker", categorical_ticker_1.CategoricalTicker);
    var composite_ticker_1 = require(178) /* ./composite_ticker */;
    __esExport("CompositeTicker", composite_ticker_1.CompositeTicker);
    var continuous_ticker_1 = require(177) /* ./continuous_ticker */;
    __esExport("ContinuousTicker", continuous_ticker_1.ContinuousTicker);
    var datetime_ticker_1 = require(175) /* ./datetime_ticker */;
    __esExport("DatetimeTicker", datetime_ticker_1.DatetimeTicker);
    var days_ticker_1 = require(179) /* ./days_ticker */;
    __esExport("DaysTicker", days_ticker_1.DaysTicker);
    var fixed_ticker_1 = require(193) /* ./fixed_ticker */;
    __esExport("FixedTicker", fixed_ticker_1.FixedTicker);
    var log_ticker_1 = require(188) /* ./log_ticker */;
    __esExport("LogTicker", log_ticker_1.LogTicker);
    var mercator_ticker_1 = require(191) /* ./mercator_ticker */;
    __esExport("MercatorTicker", mercator_ticker_1.MercatorTicker);
    var months_ticker_1 = require(181) /* ./months_ticker */;
    __esExport("MonthsTicker", months_ticker_1.MonthsTicker);
    var single_interval_ticker_1 = require(180) /* ./single_interval_ticker */;
    __esExport("SingleIntervalTicker", single_interval_ticker_1.SingleIntervalTicker);
    var ticker_1 = require(161) /* ./ticker */;
    __esExport("Ticker", ticker_1.Ticker);
    var years_ticker_1 = require(182) /* ./years_ticker */;
    __esExport("YearsTicker", years_ticker_1.YearsTicker);
    var binned_ticker_1 = require(194) /* ./binned_ticker */;
    __esExport("BinnedTicker", binned_ticker_1.BinnedTicker);
},
/* models/tickers/fixed_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const continuous_ticker_1 = require(177) /* ./continuous_ticker */;
    class FixedTicker extends continuous_ticker_1.ContinuousTicker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks_no_defaults(_data_low, _data_high, _cross_loc, _desired_n_ticks) {
            return {
                major: [...this.ticks],
                minor: [...this.minor_ticks],
            };
        }
        // XXX: whatever, because FixedTicker needs to fulfill the interface somehow
        get_interval(_data_low, _data_high, _desired_n_ticks) {
            return 0;
        }
        get_min_interval() {
            return 0;
        }
        get_max_interval() {
            return 0;
        }
    }
    exports.FixedTicker = FixedTicker;
    _a = FixedTicker;
    FixedTicker.__name__ = "FixedTicker";
    (() => {
        _a.define(({ Number, Arrayable }) => ({
            ticks: [Arrayable(Number), []],
            minor_ticks: [Arrayable(Number), []],
        }));
    })();
},
/* models/tickers/binned_ticker.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const ticker_1 = require(161) /* ./ticker */;
    const scanning_color_mapper_1 = require(195) /* ../mappers/scanning_color_mapper */;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    class BinnedTicker extends ticker_1.Ticker {
        constructor(attrs) {
            super(attrs);
        }
        get_ticks(data_low, data_high, _range, _cross_loc) {
            const { binning } = this.mapper.metrics;
            const k_low = Math.max(0, (0, arrayable_1.left_edge_index)(data_low, binning));
            const k_high = Math.min((0, arrayable_1.left_edge_index)(data_high, binning) + 1, binning.length - 1);
            const _major = [];
            for (let k = k_low; k <= k_high; k++) {
                _major.push(binning[k]);
            }
            const { num_major_ticks } = this;
            const major = [];
            const n = num_major_ticks == "auto" ? _major.length : num_major_ticks;
            const step = Math.max(1, Math.floor(_major.length / n));
            for (let i = 0; i < _major.length; i += step) {
                major.push(_major[i]);
            }
            return {
                major,
                minor: [],
            };
        }
    }
    exports.BinnedTicker = BinnedTicker;
    _a = BinnedTicker;
    BinnedTicker.__name__ = "BinnedTicker";
    (() => {
        _a.define(({ Number, Ref, Or, Auto }) => ({
            mapper: [Ref(scanning_color_mapper_1.ScanningColorMapper)],
            num_major_ticks: [Or(Number, Auto), 8],
        }));
    })();
},
/* models/mappers/scanning_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const continuous_color_mapper_1 = require(196) /* ./continuous_color_mapper */;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    class ScanningColorMapper extends continuous_color_mapper_1.ContinuousColorMapper {
        constructor(attrs) {
            super(attrs);
        }
        index_to_value(index) {
            const scan_data = this._scan_data;
            return scan_data.binning[index];
        }
        value_to_index(value, palette_length) {
            const scan_data = this._scan_data;
            if (value < scan_data.binning[0])
                return -1;
            else if (value > scan_data.binning[scan_data.binning.length - 1])
                return palette_length;
            else
                return (0, arrayable_1.left_edge_index)(value, scan_data.binning);
        }
    }
    exports.ScanningColorMapper = ScanningColorMapper;
    ScanningColorMapper.__name__ = "ScanningColorMapper";
},
/* models/mappers/continuous_color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const color_mapper_1 = require(197) /* ./color_mapper */;
    const glyph_renderer_1 = require(199) /* ../renderers/glyph_renderer */;
    const array_1 = require(10) /* ../../core/util/array */;
    const types_1 = require(8) /* ../../core/util/types */;
    class ContinuousColorMapper extends color_mapper_1.ColorMapper {
        constructor(attrs) {
            super(attrs);
            this._scan_data = null;
        }
        connect_signals() {
            super.connect_signals();
            const connect_renderers = () => {
                // TODO: if already connected this will bail. However, it won't remove old connections.
                for (const [renderer] of this.domain) {
                    this.connect(renderer.view.change, () => this.update_data());
                    this.connect(renderer.data_source.selected.change, () => this.update_data());
                }
            };
            const { high, low, high_color, low_color, palette, nan_color } = this.properties;
            this.on_change([high, low, high_color, low_color, palette, nan_color], () => this.update_data());
            this.connect(this.properties.domain.change, () => connect_renderers());
            connect_renderers();
        }
        update_data() {
            const { domain, palette } = this;
            const all_data = [...this._collect(domain)];
            this._scan_data = this.scan(all_data, palette.length);
            this.metrics_change.emit();
            this.change.emit();
        }
        get metrics() {
            if (this._scan_data == null) {
                this.update_data();
            }
            return this._scan_data;
        }
        *_collect(domain) {
            for (const [renderer, fields] of domain) {
                for (const field of (0, types_1.isArray)(fields) ? fields : [fields]) {
                    if (renderer.view.properties.indices.is_unset)
                        continue;
                    const column = renderer.data_source.get_column(field);
                    if (column == null)
                        continue;
                    let array = renderer.view.indices.select(column);
                    const masked = renderer.view.masked;
                    const selected = renderer.data_source.selected.indices;
                    let subset;
                    if (masked != null && selected.length > 0)
                        subset = (0, array_1.intersection)([...masked], selected);
                    else if (masked != null)
                        subset = [...masked];
                    else if (selected.length > 0)
                        subset = selected;
                    if (subset != null) {
                        array = (0, array_1.map)(subset, (i) => array[i]);
                    }
                    if (array.length > 0 && !(0, types_1.isNumber)(array[0])) {
                        for (const subarray of array) {
                            yield* subarray;
                        }
                    }
                    else {
                        yield* array;
                    }
                }
            }
        }
        _v_compute(data, values, palette, colors) {
            const { nan_color } = colors;
            let { low_color, high_color } = colors;
            if (low_color == null)
                low_color = palette[0];
            if (high_color == null)
                high_color = palette[palette.length - 1];
            const { domain } = this;
            const all_data = !(0, array_1.is_empty)(domain) ? [...this._collect(domain)] : data;
            this._scan_data = this.scan(all_data, palette.length);
            this.metrics_change.emit();
            for (let i = 0, end = data.length; i < end; i++) {
                const d = data[i];
                if (isNaN(d))
                    values[i] = nan_color;
                else
                    values[i] = this.cmap(d, palette, low_color, high_color);
            }
        }
        _colors(conv) {
            return Object.assign(Object.assign({}, super._colors(conv)), { low_color: this.low_color != null ? conv(this.low_color) : undefined, high_color: this.high_color != null ? conv(this.high_color) : undefined });
        }
        cmap(value, palette, low_color, high_color) {
            const index = this.value_to_index(value, palette.length);
            if (index < 0)
                return low_color;
            else if (index >= palette.length)
                return high_color;
            else
                return palette[index];
        }
    }
    exports.ContinuousColorMapper = ContinuousColorMapper;
    _a = ContinuousColorMapper;
    ContinuousColorMapper.__name__ = "ContinuousColorMapper";
    (() => {
        _a.define(({ Number, String, Ref, Color, Or, Tuple, Array, Nullable }) => {
            return {
                high: [Nullable(Number), null],
                low: [Nullable(Number), null],
                high_color: [Nullable(Color), null],
                low_color: [Nullable(Color), null],
                domain: [Array(Tuple(Ref(glyph_renderer_1.GlyphRenderer), Or(String, Array(String)))), []],
            };
        });
    })();
},
/* models/mappers/color_mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const mapper_1 = require(198) /* ./mapper */;
    const signaling_1 = require(15) /* ../../core/signaling */;
    const types_1 = require(23) /* ../../core/types */;
    const color_1 = require(21) /* ../../core/util/color */;
    const platform_1 = require(26) /* ../../core/util/platform */;
    // export for testing
    function _convert_color(color) {
        return (0, color_1.encode_rgba)((0, color_1.color2rgba)(color));
    }
    exports._convert_color = _convert_color;
    // export for testing
    function _convert_palette(palette) {
        const new_palette = new Uint32Array(palette.length);
        for (let i = 0, end = palette.length; i < end; i++)
            new_palette[i] = _convert_color(palette[i]);
        return new_palette;
    }
    exports._convert_palette = _convert_palette;
    class ColorMapper extends mapper_1.Mapper {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            this.metrics_change = new signaling_1.Signal0(this, "metrics_change");
        }
        v_compute(xs) {
            const values = new Array(xs.length);
            this._v_compute(xs, values, this.palette, this._colors((c) => c));
            return values;
        }
        get rgba_mapper() {
            const self = this;
            const palette = _convert_palette(this.palette);
            const colors = this._colors(_convert_color);
            return {
                v_compute(xs) {
                    const values = new types_1.ColorArray(xs.length);
                    self._v_compute(xs, values, palette, colors);
                    return new Uint8ClampedArray((0, platform_1.to_big_endian)(values).buffer);
                },
            };
        }
        _colors(conv) {
            return { nan_color: conv(this.nan_color) };
        }
    }
    exports.ColorMapper = ColorMapper;
    _a = ColorMapper;
    ColorMapper.__name__ = "ColorMapper";
    (() => {
        _a.define(({ Color, Array }) => ({
            palette: [Array(Color)],
            nan_color: [Color, "gray"],
        }));
    })();
},
/* models/mappers/mapper.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const transform_1 = require(86) /* ../transforms/transform */;
    class Mapper extends transform_1.Transform {
        constructor(attrs) {
            super(attrs);
        }
        compute(_x) {
            // If it's just a single value, then a mapper doesn't really make sense.
            throw new Error("mapping single values is not supported");
        }
    }
    exports.Mapper = Mapper;
    Mapper.__name__ = "Mapper";
},
/* models/renderers/glyph_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const data_renderer_1 = require(200) /* ./data_renderer */;
    const line_1 = require(201) /* ../glyphs/line */;
    const patch_1 = require(211) /* ../glyphs/patch */;
    const harea_1 = require(212) /* ../glyphs/harea */;
    const varea_1 = require(214) /* ../glyphs/varea */;
    const glyph_1 = require(203) /* ../glyphs/glyph */;
    const columnar_data_source_1 = require(99) /* ../sources/columnar_data_source */;
    const cds_view_1 = require(215) /* ../sources/cds_view */;
    const types_1 = require(23) /* ../../core/types */;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    const object_1 = require(9) /* ../../core/util/object */;
    const build_views_1 = require(59) /* ../../core/build_views */;
    const eq_1 = require(25) /* ../../core/util/eq */;
    const factor_range_1 = require(96) /* ../ranges/factor_range */;
    const decoration_1 = require(208) /* ../graphics/decoration */;
    const selection_defaults = {
        fill: {},
        line: {},
    };
    const decimated_defaults = {
        fill: { fill_alpha: 0.3, fill_color: "grey" },
        line: { line_alpha: 0.3, line_color: "grey" },
    };
    const nonselection_defaults = {
        fill: { fill_alpha: 0.2 },
        line: {},
    };
    const muted_defaults = {
        fill: { fill_alpha: 0.2 },
        line: {},
    };
    class GlyphRendererView extends data_renderer_1.DataRendererView {
        get glyph_view() {
            return this.glyph;
        }
        *children() {
            yield* super.children();
            yield this.cds_view;
            yield this.glyph;
            yield this.selection_glyph;
            yield this.nonselection_glyph;
            if (this.hover_glyph != null)
                yield this.hover_glyph;
            yield this.muted_glyph;
            yield this.decimated_glyph;
        }
        get data_source() {
            return this.model.properties.data_source;
        }
        async lazy_initialize() {
            var _b;
            await super.lazy_initialize();
            this.cds_view = await (0, build_views_1.build_view)(this.model.view, { parent: this });
            const base_glyph = this.model.glyph;
            this.glyph = await this.build_glyph_view(base_glyph);
            const has_fill = "fill" in this.glyph.visuals;
            const has_line = "line" in this.glyph.visuals;
            const glyph_attrs = Object.assign({}, base_glyph.attributes);
            delete glyph_attrs.id;
            function mk_glyph(defaults) {
                const attrs = (0, object_1.clone)(glyph_attrs);
                if (has_fill)
                    (0, object_1.extend)(attrs, defaults.fill);
                if (has_line)
                    (0, object_1.extend)(attrs, defaults.line);
                return new base_glyph.constructor(attrs);
            }
            function glyph_from_mode(defaults, glyph) {
                if (glyph instanceof glyph_1.Glyph) {
                    return glyph;
                }
                else if (glyph == "auto") {
                    return mk_glyph(defaults);
                }
                return mk_glyph({ fill: {}, line: {} });
            }
            let { selection_glyph, nonselection_glyph, hover_glyph, muted_glyph } = this.model;
            selection_glyph = glyph_from_mode(selection_defaults, selection_glyph);
            this.selection_glyph = await this.build_glyph_view(selection_glyph);
            nonselection_glyph = glyph_from_mode(nonselection_defaults, nonselection_glyph);
            this.nonselection_glyph = await this.build_glyph_view(nonselection_glyph);
            if (hover_glyph != null)
                this.hover_glyph = await this.build_glyph_view(hover_glyph);
            muted_glyph = glyph_from_mode(muted_defaults, muted_glyph);
            this.muted_glyph = await this.build_glyph_view(muted_glyph);
            const decimated_glyph = glyph_from_mode(decimated_defaults, "auto");
            this.decimated_glyph = await this.build_glyph_view(decimated_glyph);
            this.selection_glyph.set_base(this.glyph);
            this.nonselection_glyph.set_base(this.glyph);
            (_b = this.hover_glyph) === null || _b === void 0 ? void 0 : _b.set_base(this.glyph);
            this.muted_glyph.set_base(this.glyph);
            this.decimated_glyph.set_base(this.glyph);
            this.set_data();
        }
        async build_glyph_view(glyph) {
            return (0, build_views_1.build_view)(glyph, { parent: this });
        }
        remove() {
            var _b;
            this.cds_view.remove();
            this.glyph.remove();
            this.selection_glyph.remove();
            this.nonselection_glyph.remove();
            (_b = this.hover_glyph) === null || _b === void 0 ? void 0 : _b.remove();
            this.muted_glyph.remove();
            this.decimated_glyph.remove();
            super.remove();
        }
        connect_signals() {
            super.connect_signals();
            const render = () => this.request_render();
            const update = () => this.update_data();
            this.connect(this.model.change, render);
            this.connect(this.glyph.model.change, update);
            this.connect(this.selection_glyph.model.change, update);
            this.connect(this.nonselection_glyph.model.change, update);
            if (this.hover_glyph != null)
                this.connect(this.hover_glyph.model.change, update);
            this.connect(this.muted_glyph.model.change, update);
            this.connect(this.decimated_glyph.model.change, update);
            this.connect(this.model.data_source.change, update);
            this.connect(this.model.data_source.streaming, update);
            this.connect(this.model.data_source.patching, (indices) => this.update_data(indices));
            this.connect(this.model.data_source.selected.change, render);
            this.connect(this.model.data_source._select, render);
            if (this.hover_glyph != null)
                this.connect(this.model.data_source.inspect, () => {
                    // XXX: hoping for the best, assuming no in-place mutation
                    const { inspected } = this.model.data_source;
                    const current_inspected = {
                        indices: inspected.indices,
                        line_indices: inspected.line_indices,
                        multiline_indices: inspected.multiline_indices,
                        image_indices: inspected.image_indices,
                        selected_glyphs: inspected.selected_glyphs,
                    };
                    if (!(0, eq_1.is_equal)(this._previous_inspected, current_inspected)) {
                        this._previous_inspected = current_inspected;
                        render();
                    }
                });
            this.connect(this.model.properties.view.change, async () => {
                this.cds_view.remove();
                this.cds_view = await (0, build_views_1.build_view)(this.model.view, { parent: this });
                update();
            });
            this.connect(this.model.view.properties.indices.change, update);
            this.connect(this.model.view.properties.masked.change, () => this.set_visuals());
            this.connect(this.model.properties.visible.change, () => this.plot_view.invalidate_dataranges = true);
            const { x_ranges, y_ranges } = this.plot_view.frame;
            for (const [, range] of x_ranges) {
                if (range instanceof factor_range_1.FactorRange)
                    this.connect(range.change, update);
            }
            for (const [, range] of y_ranges) {
                if (range instanceof factor_range_1.FactorRange)
                    this.connect(range.change, update);
            }
            const { transformchange, exprchange } = this.model.glyph;
            this.connect(transformchange, update);
            this.connect(exprchange, update);
        }
        _update_masked_indices() {
            const masked = this.glyph.mask_data();
            this.model.view.masked = masked;
            return masked;
        }
        update_data(indices) {
            this.set_data(indices);
            this.request_render();
        }
        // in case of partial updates like patching, the list of indices that actually
        // changed may be passed as the "indices" parameter to afford any optional optimizations
        set_data(indices) {
            const source = this.model.data_source;
            this.all_indices = this.model.view.indices;
            const { all_indices } = this;
            this.glyph.set_data(source, all_indices, indices);
            this.set_visuals();
            this._update_masked_indices();
            const { lod_factor } = this.plot_model;
            const n = this.all_indices.count;
            this.decimated = new types_1.Indices(n);
            for (let i = 0; i < n; i += lod_factor) {
                this.decimated.set(i);
            }
            this.plot_view.invalidate_dataranges = true;
        }
        set_visuals() {
            var _b;
            const source = this.model.data_source;
            const { all_indices } = this;
            this.glyph.set_visuals(source, all_indices);
            this.decimated_glyph.set_visuals(source, all_indices);
            this.selection_glyph.set_visuals(source, all_indices);
            this.nonselection_glyph.set_visuals(source, all_indices);
            (_b = this.hover_glyph) === null || _b === void 0 ? void 0 : _b.set_visuals(source, all_indices);
            this.muted_glyph.set_visuals(source, all_indices);
        }
        get has_webgl() {
            return this.glyph.has_webgl;
        }
        _render() {
            const glsupport = this.has_webgl;
            this.glyph.map_data();
            // all_indices is in full data space, indices is converted to subset space by mask_data (that may use the spatial index)
            const all_indices = [...this.all_indices];
            let indices = [...this._update_masked_indices()];
            const { ctx } = this.layer;
            ctx.save();
            // selected is in full set space
            const { selected } = this.model.data_source;
            let selected_full_indices;
            if (selected.is_empty())
                selected_full_indices = [];
            else {
                if (this.glyph instanceof line_1.LineView && selected.selected_glyph === this.glyph.model)
                    selected_full_indices = this.model.view.convert_indices_from_subset(indices);
                else
                    selected_full_indices = selected.indices;
            }
            // inspected is in full set space
            const { inspected } = this.model.data_source;
            this._previous_inspected = {
                indices: inspected.indices,
                line_indices: inspected.line_indices,
                multiline_indices: inspected.multiline_indices,
                image_indices: inspected.image_indices,
                selected_glyphs: inspected.selected_glyphs,
            };
            const inspected_full_indices = new Set((() => {
                if (inspected.is_empty())
                    return [];
                else {
                    if (inspected.selected_glyph)
                        return this.model.view.convert_indices_from_subset(indices);
                    else if (inspected.indices.length > 0)
                        return inspected.indices;
                    else {
                        // TODO: return inspected.multiline_indices.keys()
                        return Object.keys(inspected.multiline_indices).map((i) => parseInt(i));
                    }
                }
            })());
            // inspected is transformed to subset space
            const inspected_subset_indices = (0, arrayable_1.filter)(indices, (i) => inspected_full_indices.has(all_indices[i]));
            const { lod_threshold } = this.plot_model;
            let glyph;
            let nonselection_glyph;
            let selection_glyph;
            if ((this.model.document != null ? this.model.document.interactive_duration() > 0 : false)
                && !glsupport && lod_threshold != null && all_indices.length > lod_threshold) {
                // Render decimated during interaction if too many elements and not using GL
                indices = [...this.decimated];
                glyph = this.decimated_glyph;
                nonselection_glyph = this.decimated_glyph;
                selection_glyph = this.selection_glyph;
            }
            else {
                glyph = this.model.muted ? this.muted_glyph : this.glyph;
                nonselection_glyph = this.nonselection_glyph;
                selection_glyph = this.selection_glyph;
            }
            if (this.hover_glyph != null && inspected_subset_indices.length) {
                // TODO: keep working on Indices instead of converting back and forth
                const set = new Set(indices);
                for (const i of inspected_subset_indices) {
                    set.delete(i);
                }
                indices = [...set];
            }
            // Render with no selection
            if (!selected_full_indices.length) {
                if (this.glyph instanceof line_1.LineView) {
                    if (this.hover_glyph != null && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices));
                    else
                        glyph.render(ctx, all_indices);
                }
                else if (this.glyph instanceof patch_1.PatchView || this.glyph instanceof harea_1.HAreaView || this.glyph instanceof varea_1.VAreaView) {
                    if (inspected.selected_glyphs.length == 0 || this.hover_glyph == null) {
                        glyph.render(ctx, all_indices);
                    }
                    else {
                        for (const sglyph of inspected.selected_glyphs) {
                            if (sglyph == this.glyph.model)
                                this.hover_glyph.render(ctx, all_indices);
                        }
                    }
                }
                else {
                    glyph.render(ctx, indices);
                    if (this.hover_glyph != null && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, inspected_subset_indices);
                }
                // Render with selection
            }
            else {
                // reset the selection mask
                const selected_mask = new Set(selected_full_indices);
                // intersect/different selection with render mask
                const selected_subset_indices = new Array();
                const nonselected_subset_indices = new Array();
                // now, selected is changed to subset space, except for Line glyph
                if (this.glyph instanceof line_1.LineView) {
                    for (const i of all_indices) {
                        if (selected_mask.has(i))
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                else {
                    for (const i of indices) {
                        if (selected_mask.has(all_indices[i]))
                            selected_subset_indices.push(i);
                        else
                            nonselected_subset_indices.push(i);
                    }
                }
                nonselection_glyph.render(ctx, nonselected_subset_indices);
                selection_glyph.render(ctx, selected_subset_indices);
                if (this.hover_glyph != null) {
                    if (this.glyph instanceof line_1.LineView)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices));
                    else
                        this.hover_glyph.render(ctx, inspected_subset_indices);
                }
            }
            ctx.restore();
        }
        get_reference_point(field, value) {
            if (field != null) {
                const array = this.model.data_source.get_column(field);
                if (array != null) {
                    for (const [key, index] of (0, object_1.entries)(this.model.view.indices_map)) {
                        if (array[parseInt(key)] == value)
                            return index;
                    }
                }
            }
            return 0;
        }
        draw_legend(ctx, x0, x1, y0, y1, field, label, index) {
            if (this.glyph.data_size == 0)
                return;
            if (index == null)
                index = this.get_reference_point(field, label);
            this.glyph.draw_legend_for_index(ctx, { x0, x1, y0, y1 }, index);
        }
        hit_test(geometry) {
            if (!this.model.visible)
                return null;
            const hit_test_result = this.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result == null)
                return null;
            return this.model.view.convert_selection_from_subset(hit_test_result);
        }
    }
    exports.GlyphRendererView = GlyphRendererView;
    GlyphRendererView.__name__ = "GlyphRendererView";
    class GlyphRenderer extends data_renderer_1.DataRenderer {
        constructor(attrs) {
            super(attrs);
        }
        get_selection_manager() {
            return this.data_source.selection_manager;
        }
        add_decoration(marking, node) {
            const decoration = new decoration_1.Decoration({ marking, node });
            const glyphs = [
                this.glyph,
                this.selection_glyph,
                this.nonselection_glyph,
                this.hover_glyph,
                this.muted_glyph,
            ];
            for (const glyph of glyphs) {
                if (glyph instanceof glyph_1.Glyph)
                    glyph.decorations = [...glyph.decorations, decoration];
            }
            return decoration;
        }
    }
    exports.GlyphRenderer = GlyphRenderer;
    _a = GlyphRenderer;
    GlyphRenderer.__name__ = "GlyphRenderer";
    (() => {
        _a.prototype.default_view = GlyphRendererView;
        _a.define(({ Boolean, Auto, Or, Ref, Null, Nullable }) => ({
            data_source: [Ref(columnar_data_source_1.ColumnarDataSource)],
            view: [Ref(cds_view_1.CDSView), () => new cds_view_1.CDSView()],
            glyph: [Ref(glyph_1.Glyph)],
            hover_glyph: [Nullable(Ref(glyph_1.Glyph)), null],
            nonselection_glyph: [Or(Ref(glyph_1.Glyph), Auto, Null), "auto"],
            selection_glyph: [Or(Ref(glyph_1.Glyph), Auto, Null), "auto"],
            muted_glyph: [Or(Ref(glyph_1.Glyph), Auto, Null), "auto"],
            muted: [Boolean, false],
        }));
    })();
},
/* models/renderers/data_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const renderer_1 = require(74) /* ./renderer */;
    class DataRendererView extends renderer_1.RendererView {
        get xscale() {
            return this.coordinates.x_scale;
        }
        get yscale() {
            return this.coordinates.y_scale;
        }
    }
    exports.DataRendererView = DataRendererView;
    DataRendererView.__name__ = "DataRendererView";
    class DataRenderer extends renderer_1.Renderer {
        constructor(attrs) {
            super(attrs);
        }
        get selection_manager() {
            return this.get_selection_manager();
        }
    }
    exports.DataRenderer = DataRenderer;
    _a = DataRenderer;
    DataRenderer.__name__ = "DataRenderer";
    (() => {
        _a.override({
            level: "glyph",
        });
    })();
},
/* models/glyphs/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const xy_glyph_1 = require(202) /* ./xy_glyph */;
    const utils_1 = require(209) /* ./utils */;
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    const hittest = tslib_1.__importStar(require(210) /* ../../core/hittest */);
    const selection_1 = require(101) /* ../selections/selection */;
    class LineView extends xy_glyph_1.XYGlyphView {
        async lazy_initialize() {
            await super.lazy_initialize();
            const { webgl } = this.renderer.plot_view.canvas_view;
            if (webgl != null && webgl.regl_wrapper.has_webgl) {
                const { LineGL } = await Promise.resolve().then(() => tslib_1.__importStar(require(512) /* ./webgl/line_gl */));
                this.glglyph = new LineGL(webgl.regl_wrapper, this);
            }
        }
        _render(ctx, indices, data) {
            const { sx, sy } = data !== null && data !== void 0 ? data : this;
            const nonselection = this.parent.nonselection_glyph == this;
            let iprev = null;
            const gap = (i) => iprev != null && i - iprev != 1;
            let move = true;
            ctx.beginPath();
            for (const i of indices) {
                const sx_i = sx[i];
                const sy_i = sy[i];
                if (nonselection && !move && iprev != null && i - iprev > 1 && isFinite(sx[iprev + 1] + sy[iprev + 1]))
                    ctx.lineTo(sx[iprev + 1], sy[iprev + 1]); // End of previous line
                if (!isFinite(sx_i + sy_i))
                    move = true;
                else {
                    if (move || gap(i)) {
                        if (nonselection && i > 0 && isFinite(sx[i - 1] + sy[i - 1])) {
                            ctx.moveTo(sx[i - 1], sy[i - 1]); // Start of new line
                            ctx.lineTo(sx_i, sy_i);
                        }
                        else
                            ctx.moveTo(sx_i, sy_i);
                        move = false;
                    }
                    else
                        ctx.lineTo(sx_i, sy_i);
                    iprev = i;
                }
            }
            if (nonselection && !move && iprev != null) {
                const n = sx.length;
                if (iprev < n - 1 && isFinite(sx[iprev + 1] + sy[iprev + 1]))
                    ctx.lineTo(sx[iprev + 1], sy[iprev + 1]); // End of final line
            }
            this.visuals.line.set_value(ctx);
            ctx.stroke();
        }
        _hit_point(geometry) {
            /* Check if the point geometry hits this line glyph and return an object
            that describes the hit result:
              Args:
                * geometry (object): object with the following keys
                  * sx (float): screen x coordinate of the point
                  * sy (float): screen y coordinate of the point
                  * type (str): type of geometry (in this case it's a point)
            */
            const result = new selection_1.Selection();
            const point = { x: geometry.sx, y: geometry.sy };
            let shortest = 9999;
            const threshold = Math.max(2, this.line_width.value / 2);
            for (let i = 0, end = this.sx.length - 1; i < end; i++) {
                const p0 = { x: this.sx[i], y: this.sy[i] };
                const p1 = { x: this.sx[i + 1], y: this.sy[i + 1] };
                const dist = hittest.dist_to_segment(point, p0, p1);
                if (dist < threshold && dist < shortest) {
                    shortest = dist;
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices = [i];
                }
            }
            return result;
        }
        _hit_span(geometry) {
            const { sx, sy } = geometry;
            const result = new selection_1.Selection();
            let val;
            let values;
            if (geometry.direction == "v") {
                val = this.renderer.yscale.invert(sy);
                values = this._y;
            }
            else {
                val = this.renderer.xscale.invert(sx);
                values = this._x;
            }
            for (let i = 0, end = values.length - 1; i < end; i++) {
                if ((values[i] <= val && val <= values[i + 1]) || (values[i + 1] <= val && val <= values[i])) {
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices.push(i);
                }
            }
            return result;
        }
        get_interpolation_hit(i, geometry) {
            const [x2, y2, x3, y3] = [this._x[i], this._y[i], this._x[i + 1], this._y[i + 1]];
            return (0, utils_1.line_interpolation)(this.renderer, geometry, x2, y2, x3, y3);
        }
        draw_legend_for_index(ctx, bbox, _index) {
            (0, utils_1.generic_line_scalar_legend)(this.visuals, ctx, bbox);
        }
    }
    exports.LineView = LineView;
    LineView.__name__ = "LineView";
    class Line extends xy_glyph_1.XYGlyph {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Line = Line;
    _a = Line;
    Line.__name__ = "Line";
    (() => {
        _a.prototype.default_view = LineView;
        _a.mixins(mixins.LineScalar);
    })();
},
/* models/glyphs/xy_glyph.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const projections_1 = require(105) /* ../../core/util/projections */;
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    const glyph_1 = require(203) /* ./glyph */;
    class XYGlyphView extends glyph_1.GlyphView {
        _project_data() {
            projections_1.inplace.project_xy(this._x, this._y);
        }
        _index_data(index) {
            const { _x, _y, data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x = _x[i];
                const y = _y[i];
                index.add_point(x, y);
            }
        }
        scenterxy(i) {
            return [this.sx[i], this.sy[i]];
        }
    }
    exports.XYGlyphView = XYGlyphView;
    XYGlyphView.__name__ = "XYGlyphView";
    class XYGlyph extends glyph_1.Glyph {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.XYGlyph = XYGlyph;
    _a = XYGlyph;
    XYGlyph.__name__ = "XYGlyph";
    (() => {
        _a.define(({}) => ({
            x: [p.XCoordinateSpec, { field: "x" }],
            y: [p.YCoordinateSpec, { field: "y" }],
        }));
    })();
},
/* models/glyphs/glyph.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    const bbox = tslib_1.__importStar(require(57) /* ../../core/util/bbox */);
    const visuals = tslib_1.__importStar(require(75) /* ../../core/visuals */);
    const view_1 = require(54) /* ../../core/view */;
    const model_1 = require(51) /* ../../model */;
    const build_views_1 = require(59) /* ../../core/build_views */;
    const logging_1 = require(18) /* ../../core/logging */;
    const types_1 = require(23) /* ../../core/types */;
    const types_2 = require(8) /* ../../core/util/types */;
    const ragged_array_1 = require(204) /* ../../core/util/ragged_array */;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    const eq_1 = require(25) /* ../../core/util/eq */;
    const spatial_1 = require(205) /* ../../core/util/spatial */;
    const factor_range_1 = require(96) /* ../ranges/factor_range */;
    const selection_1 = require(101) /* ../selections/selection */;
    const decoration_1 = require(208) /* ../graphics/decoration */;
    const { abs, ceil } = Math;
    class GlyphView extends view_1.View {
        constructor() {
            super(...arguments);
            this._index = null;
            this._data_size = null;
            this._nohit_warned = new Set();
            this.decorations = new Map();
        }
        get renderer() {
            return this.parent;
        }
        get has_webgl() {
            return this.glglyph != null;
        }
        get index() {
            const { _index } = this;
            if (_index != null)
                return _index;
            else
                throw new Error(`${this}.index_data() wasn't called`);
        }
        get data_size() {
            const { _data_size } = this;
            if (_data_size != null)
                return _data_size;
            else
                throw new Error(`${this}.set_data() wasn't called`);
        }
        initialize() {
            super.initialize();
            this.visuals = new visuals.Visuals(this);
        }
        *children() {
            yield* super.children();
            yield* this.decorations.values();
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            await (0, build_views_1.build_views)(this.decorations, this.model.decorations, { parent: this.parent });
        }
        request_render() {
            this.parent.request_render();
        }
        get canvas() {
            return this.renderer.parent.canvas_view;
        }
        render(ctx, indices, data) {
            var _b;
            if (this.glglyph != null) {
                this.renderer.needs_webgl_blit = this.glglyph.render(ctx, indices, (_b = this.base) !== null && _b !== void 0 ? _b : this);
                if (this.renderer.needs_webgl_blit)
                    return;
            }
            this._render(ctx, indices, data !== null && data !== void 0 ? data : this.base);
        }
        has_finished() {
            return true;
        }
        notify_finished() {
            this.renderer.notify_finished();
        }
        _bounds(bounds) {
            return bounds;
        }
        bounds() {
            return this._bounds(this.index.bbox);
        }
        log_bounds() {
            const { x0, x1 } = this.index.bounds(bbox.positive_x());
            const { y0, y1 } = this.index.bounds(bbox.positive_y());
            return this._bounds({ x0, y0, x1, y1 });
        }
        get_anchor_point(anchor, i, [sx, sy]) {
            switch (anchor) {
                case "center":
                case "center_center": {
                    const [x, y] = this.scenterxy(i, sx, sy);
                    return { x, y };
                }
                default:
                    return null;
            }
        }
        sdist(scale, pts, spans, pts_location = "edge", dilate = false) {
            const n = pts.length;
            const sdist = new types_1.ScreenArray(n);
            const compute = scale.s_compute;
            if (pts_location == "center") {
                for (let i = 0; i < n; i++) {
                    const pts_i = pts[i];
                    const halfspan_i = spans.get(i) / 2;
                    const spt0 = compute(pts_i - halfspan_i);
                    const spt1 = compute(pts_i + halfspan_i);
                    sdist[i] = abs(spt1 - spt0);
                }
            }
            else {
                for (let i = 0; i < n; i++) {
                    const pts_i = pts[i];
                    const spt0 = compute(pts_i);
                    const spt1 = compute(pts_i + spans.get(i));
                    sdist[i] = abs(spt1 - spt0);
                }
            }
            if (dilate)
                (0, arrayable_1.inplace_map)(sdist, (sd) => ceil(sd));
            return sdist;
        }
        draw_legend_for_index(_ctx, _bbox, _index) { }
        hit_test(geometry) {
            switch (geometry.type) {
                case "point":
                    if (this._hit_point != null)
                        return this._hit_point(geometry);
                    break;
                case "span":
                    if (this._hit_span != null)
                        return this._hit_span(geometry);
                    break;
                case "rect":
                    if (this._hit_rect != null)
                        return this._hit_rect(geometry);
                    break;
                case "poly":
                    if (this._hit_poly != null)
                        return this._hit_poly(geometry);
                    break;
            }
            if (!this._nohit_warned.has(geometry.type)) {
                logging_1.logger.debug(`'${geometry.type}' selection not available for ${this.model.type}`);
                this._nohit_warned.add(geometry.type);
            }
            return null;
        }
        _hit_rect_against_index(geometry) {
            const { sx0, sx1, sy0, sy1 } = geometry;
            const [x0, x1] = this.renderer.coordinates.x_scale.r_invert(sx0, sx1);
            const [y0, y1] = this.renderer.coordinates.y_scale.r_invert(sy0, sy1);
            const indices = [...this.index.indices({ x0, x1, y0, y1 })];
            return new selection_1.Selection({ indices });
        }
        _project_data() { }
        *_iter_visuals() {
            for (const visual of this.visuals) {
                for (const prop of visual) {
                    if (prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec)
                        yield prop;
                }
            }
        }
        set_base(base) {
            if (base != this && base instanceof this.constructor)
                this.base = base;
        }
        _configure(prop, descriptor) {
            Object.defineProperty(this, (0, types_2.isString)(prop) ? prop : prop.attr, Object.assign({ configurable: true, enumerable: true }, descriptor));
        }
        set_visuals(source, indices) {
            var _b;
            for (const prop of this._iter_visuals()) {
                const { base } = this;
                if (base != null) {
                    const base_prop = base.model.properties[prop.attr];
                    if (base_prop != null && (0, eq_1.is_equal)(prop.get_value(), base_prop.get_value())) {
                        this._configure(prop, {
                            get() { return base[`${prop.attr}`]; },
                        });
                        continue;
                    }
                }
                const uniform = prop.uniform(source).select(indices);
                this._configure(prop, { value: uniform });
            }
            for (const visual of this.visuals) {
                visual.update();
            }
            (_b = this.glglyph) === null || _b === void 0 ? void 0 : _b.set_visuals_changed();
        }
        set_data(source, indices, indices_to_update) {
            var _b;
            const { x_source, y_source } = this.renderer.coordinates;
            const visual_props = new Set(this._iter_visuals());
            this._data_size = indices.count;
            for (const prop of this.model) {
                if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                    continue;
                if (visual_props.has(prop)) // let set_visuals() do the work, at least for now
                    continue;
                if (prop instanceof p.BaseCoordinateSpec) {
                    const base_array = prop.array(source);
                    let array = indices.select(base_array);
                    const range = prop.dimension == "x" ? x_source : y_source;
                    if (range instanceof factor_range_1.FactorRange) {
                        if (prop instanceof p.CoordinateSpec) {
                            array = range.v_synthetic(array);
                        }
                        else if (prop instanceof p.CoordinateSeqSpec) {
                            for (let i = 0; i < array.length; i++) {
                                array[i] = range.v_synthetic(array[i]);
                            }
                        }
                    }
                    let final_array;
                    if (prop instanceof p.CoordinateSeqSpec) {
                        // TODO: infer precision
                        final_array = ragged_array_1.RaggedArray.from(array, Float64Array);
                    }
                    else
                        final_array = array;
                    this._configure(`_${prop.attr}`, { value: final_array });
                }
                else {
                    const uniform = prop.uniform(source).select(indices);
                    this._configure(prop, { value: uniform });
                    if (prop instanceof p.DistanceSpec) {
                        const max_value = uniform.is_Scalar() ? uniform.value : (0, arrayable_1.max)(uniform.array);
                        this._configure(`max_${prop.attr}`, { value: max_value });
                    }
                }
            }
            if (this.renderer.plot_view.model.use_map) {
                this._project_data();
            }
            this._set_data(indices_to_update !== null && indices_to_update !== void 0 ? indices_to_update : null); // TODO doesn't take subset indices into account
            for (const decoration of this.decorations.values()) {
                decoration.marking.set_data(source, indices);
            }
            (_b = this.glglyph) === null || _b === void 0 ? void 0 : _b.set_data_changed();
            this.index_data();
        }
        _set_data(_indices) { }
        get _index_size() {
            return this.data_size;
        }
        index_data() {
            const index = new spatial_1.SpatialIndex(this._index_size);
            this._index_data(index);
            index.finish();
            this._index = index;
        }
        mask_data() {
            /** Returns subset indices in the viewport. */
            if (this._mask_data == null)
                return types_1.Indices.all_set(this.data_size);
            else
                return this._mask_data();
        }
        map_data() {
            var _b;
            const self = this;
            const { x_scale, y_scale } = this.renderer.coordinates;
            for (const prop of this.model) {
                if (prop instanceof p.BaseCoordinateSpec) {
                    const scale = prop.dimension == "x" ? x_scale : y_scale;
                    let array = self[`_${prop.attr}`];
                    if (array instanceof ragged_array_1.RaggedArray) {
                        const screen = scale.v_compute(array.array);
                        array = new ragged_array_1.RaggedArray(array.offsets, screen);
                    }
                    else {
                        array = scale.v_compute(array);
                    }
                    this[`s${prop.attr}`] = array;
                }
            }
            this._map_data();
            (_b = this.glglyph) === null || _b === void 0 ? void 0 : _b.set_data_changed();
        }
        // This is where specs not included in coords are computed, e.g. radius.
        _map_data() { }
    }
    exports.GlyphView = GlyphView;
    GlyphView.__name__ = "GlyphView";
    class Glyph extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Glyph = Glyph;
    _a = Glyph;
    Glyph.__name__ = "Glyph";
    (() => {
        _a.define(({ Array, Ref }) => ({
            decorations: [Array(Ref(decoration_1.Decoration)), []],
        }));
    })();
},
/* core/util/ragged_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const eq_1 = require(25) /* ./eq */;
    const assert_1 = require(12) /* ./assert */;
    class RaggedArray {
        constructor(offsets, array) {
            this.offsets = offsets;
            this.array = array;
        }
        [(_a = Symbol.toStringTag, eq_1.equals)](that, cmp) {
            return cmp.arrays(this.offsets, that.offsets) && cmp.arrays(this.array, that.array);
        }
        get length() {
            return this.offsets.length;
        }
        clone() {
            return new RaggedArray(this.offsets.slice(), this.array.slice());
        }
        static from(items, ctor) {
            const n = items.length;
            let offset = 0;
            const offsets = (() => {
                const offsets = new Uint32Array(n);
                for (let i = 0; i < n; i++) {
                    const length = items[i].length;
                    offsets[i] = offset;
                    offset += length;
                }
                if (offset < 256)
                    return new Uint8Array(offsets);
                else if (offset < 65536)
                    return new Uint16Array(offsets);
                else
                    return offsets;
            })();
            const array = new ctor(offset);
            for (let i = 0; i < n; i++) {
                array.set(items[i], offsets[i]);
            }
            return new RaggedArray(offsets, array);
        }
        *[Symbol.iterator]() {
            const { offsets, length } = this;
            for (let i = 0; i < length; i++) {
                yield this.array.subarray(offsets[i], offsets[i + 1]);
            }
        }
        _check_bounds(i) {
            (0, assert_1.assert)(0 <= i && i < this.length, `Out of bounds: 0 <= ${i} < ${this.length}`);
        }
        get(i) {
            this._check_bounds(i);
            const { offsets } = this;
            return this.array.subarray(offsets[i], offsets[i + 1]);
        }
        set(i, array) {
            this._check_bounds(i);
            this.array.set(array, this.offsets[i]);
        }
    }
    exports.RaggedArray = RaggedArray;
    RaggedArray.__name__ = "RaggedArray";
    RaggedArray[_a] = "RaggedArray";
},
/* core/util/spatial.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const flatbush_1 = tslib_1.__importDefault(require(206) /* flatbush */);
    const types_1 = require(23) /* ../types */;
    const bbox_1 = require(57) /* ./bbox */;
    function upperBound(value, arr) {
        let i = 0;
        let j = arr.length - 1;
        while (i < j) {
            const m = (i + j) >> 1;
            if (arr[m] > value) {
                j = m;
            }
            else {
                i = m + 1;
            }
        }
        return arr[i];
    }
    class _FlatBush extends flatbush_1.default {
        get boxes() {
            return this._boxes;
        }
        search_indices(minX, minY, maxX, maxY) {
            if (this._pos !== this._boxes.length) {
                throw new Error("Data not yet indexed - call index.finish().");
            }
            let nodeIndex = this._boxes.length - 4;
            const queue = [];
            const results = new types_1.Indices(this.numItems);
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // search through child nodes
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    const index = this._indices[pos >> 2] | 0;
                    // check if node bbox intersects with query bbox
                    const nodeMinX = this._boxes[pos + 0];
                    const nodeMinY = this._boxes[pos + 1];
                    const nodeMaxX = this._boxes[pos + 2];
                    const nodeMaxY = this._boxes[pos + 3];
                    if (maxX < nodeMinX)
                        continue;
                    if (maxY < nodeMinY)
                        continue;
                    if (minX > nodeMaxX)
                        continue;
                    if (minY > nodeMaxY)
                        continue;
                    if (nodeIndex < this.numItems * 4) {
                        results.set(index); // leaf item
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                    }
                }
                nodeIndex = queue.pop();
            }
            return results;
        }
    }
    _FlatBush.__name__ = "_FlatBush";
    class SpatialIndex {
        constructor(size) {
            this.index = null;
            if (size > 0) {
                this.index = new _FlatBush(size);
            }
        }
        add_rect(x0, y0, x1, y1) {
            var _a;
            if (!isFinite(x0 + y0 + x1 + y1))
                this.add_empty();
            else
                (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(x0, y0, x1, y1);
        }
        add_point(x, y) {
            var _a;
            if (!isFinite(x + y))
                this.add_empty();
            else
                (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(x, y, x, y);
        }
        add_empty() {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(Infinity, Infinity, -Infinity, -Infinity);
        }
        finish() {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.finish();
        }
        _normalize(rect) {
            let { x0, y0, x1, y1 } = rect;
            if (x0 > x1)
                [x0, x1] = [x1, x0];
            if (y0 > y1)
                [y0, y1] = [y1, y0];
            return { x0, y0, x1, y1 };
        }
        get bbox() {
            if (this.index == null)
                return (0, bbox_1.empty)();
            else {
                const { minX, minY, maxX, maxY } = this.index;
                return { x0: minX, y0: minY, x1: maxX, y1: maxY };
            }
        }
        indices(rect) {
            if (this.index == null)
                return new types_1.Indices(0);
            else {
                const { x0, y0, x1, y1 } = this._normalize(rect);
                return this.index.search_indices(x0, y0, x1, y1);
            }
        }
        bounds(rect) {
            const bounds = (0, bbox_1.empty)();
            if (this.index == null)
                return bounds;
            const { boxes } = this.index;
            for (const i of this.indices(rect)) {
                const x0 = boxes[4 * i + 0];
                const y0 = boxes[4 * i + 1];
                const x1 = boxes[4 * i + 2];
                const y1 = boxes[4 * i + 3];
                if (x0 >= rect.x0 && x0 < bounds.x0)
                    bounds.x0 = x0;
                if (x1 <= rect.x1 && x1 > bounds.x1)
                    bounds.x1 = x1;
                if (y0 >= rect.y0 && y0 < bounds.y0)
                    bounds.y0 = y0;
                if (y1 <= rect.y1 && y1 > bounds.y1)
                    bounds.y1 = y1;
            }
            return bounds;
        }
    }
    exports.SpatialIndex = SpatialIndex;
    SpatialIndex.__name__ = "SpatialIndex";
},
/* flatbush/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const flatqueue_1 = tslib_1.__importDefault(require(207) /* flatqueue */);
    const ARRAY_TYPES = [
        Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array,
        Int32Array, Uint32Array, Float32Array, Float64Array
    ];
    const VERSION = 3; // serialized format version
    class Flatbush {
        static from(data) {
            if (!(data instanceof ArrayBuffer)) {
                throw new Error('Data must be an instance of ArrayBuffer.');
            }
            const [magic, versionAndType] = new Uint8Array(data, 0, 2);
            if (magic !== 0xfb) {
                throw new Error('Data does not appear to be in a Flatbush format.');
            }
            if (versionAndType >> 4 !== VERSION) {
                throw new Error(`Got v${versionAndType >> 4} data when expected v${VERSION}.`);
            }
            const [nodeSize] = new Uint16Array(data, 2, 1);
            const [numItems] = new Uint32Array(data, 4, 1);
            return new Flatbush(numItems, nodeSize, ARRAY_TYPES[versionAndType & 0x0f], data);
        }
        constructor(numItems, nodeSize = 16, ArrayType = Float64Array, data) {
            if (numItems === undefined)
                throw new Error('Missing required argument: numItems.');
            if (isNaN(numItems) || numItems <= 0)
                throw new Error(`Unpexpected numItems value: ${numItems}.`);
            this.numItems = +numItems;
            this.nodeSize = Math.min(Math.max(+nodeSize, 2), 65535);
            // calculate the total number of nodes in the R-tree to allocate space for
            // and the index of each tree level (used in search later)
            let n = numItems;
            let numNodes = n;
            this._levelBounds = [n * 4];
            do {
                n = Math.ceil(n / this.nodeSize);
                numNodes += n;
                this._levelBounds.push(numNodes * 4);
            } while (n !== 1);
            this.ArrayType = ArrayType || Float64Array;
            this.IndexArrayType = numNodes < 16384 ? Uint16Array : Uint32Array;
            const arrayTypeIndex = ARRAY_TYPES.indexOf(this.ArrayType);
            const nodesByteSize = numNodes * 4 * this.ArrayType.BYTES_PER_ELEMENT;
            if (arrayTypeIndex < 0) {
                throw new Error(`Unexpected typed array class: ${ArrayType}.`);
            }
            if (data && (data instanceof ArrayBuffer)) {
                this.data = data;
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = numNodes * 4;
                this.minX = this._boxes[this._pos - 4];
                this.minY = this._boxes[this._pos - 3];
                this.maxX = this._boxes[this._pos - 2];
                this.maxY = this._boxes[this._pos - 1];
            }
            else {
                this.data = new ArrayBuffer(8 + nodesByteSize + numNodes * this.IndexArrayType.BYTES_PER_ELEMENT);
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = 0;
                this.minX = Infinity;
                this.minY = Infinity;
                this.maxX = -Infinity;
                this.maxY = -Infinity;
                new Uint8Array(this.data, 0, 2).set([0xfb, (VERSION << 4) + arrayTypeIndex]);
                new Uint16Array(this.data, 2, 1)[0] = nodeSize;
                new Uint32Array(this.data, 4, 1)[0] = numItems;
            }
            // a priority queue for k-nearest-neighbors queries
            this._queue = new flatqueue_1.default();
        }
        add(minX, minY, maxX, maxY) {
            const index = this._pos >> 2;
            this._indices[index] = index;
            this._boxes[this._pos++] = minX;
            this._boxes[this._pos++] = minY;
            this._boxes[this._pos++] = maxX;
            this._boxes[this._pos++] = maxY;
            if (minX < this.minX)
                this.minX = minX;
            if (minY < this.minY)
                this.minY = minY;
            if (maxX > this.maxX)
                this.maxX = maxX;
            if (maxY > this.maxY)
                this.maxY = maxY;
            return index;
        }
        finish() {
            if (this._pos >> 2 !== this.numItems) {
                throw new Error(`Added ${this._pos >> 2} items when expected ${this.numItems}.`);
            }
            if (this.numItems <= this.nodeSize) {
                // only one node, skip sorting and just fill the root box
                this._boxes[this._pos++] = this.minX;
                this._boxes[this._pos++] = this.minY;
                this._boxes[this._pos++] = this.maxX;
                this._boxes[this._pos++] = this.maxY;
                return;
            }
            const width = (this.maxX - this.minX) || 1;
            const height = (this.maxY - this.minY) || 1;
            const hilbertValues = new Uint32Array(this.numItems);
            const hilbertMax = (1 << 16) - 1;
            // map item centers into Hilbert coordinate space and calculate Hilbert values
            for (let i = 0; i < this.numItems; i++) {
                let pos = 4 * i;
                const minX = this._boxes[pos++];
                const minY = this._boxes[pos++];
                const maxX = this._boxes[pos++];
                const maxY = this._boxes[pos++];
                const x = Math.floor(hilbertMax * ((minX + maxX) / 2 - this.minX) / width);
                const y = Math.floor(hilbertMax * ((minY + maxY) / 2 - this.minY) / height);
                hilbertValues[i] = hilbert(x, y);
            }
            // sort items by their Hilbert value (for packing later)
            sort(hilbertValues, this._boxes, this._indices, 0, this.numItems - 1, this.nodeSize);
            // generate nodes at each tree level, bottom-up
            for (let i = 0, pos = 0; i < this._levelBounds.length - 1; i++) {
                const end = this._levelBounds[i];
                // generate a parent node for each block of consecutive <nodeSize> nodes
                while (pos < end) {
                    const nodeIndex = pos;
                    // calculate bbox for the new node
                    let nodeMinX = Infinity;
                    let nodeMinY = Infinity;
                    let nodeMaxX = -Infinity;
                    let nodeMaxY = -Infinity;
                    for (let i = 0; i < this.nodeSize && pos < end; i++) {
                        nodeMinX = Math.min(nodeMinX, this._boxes[pos++]);
                        nodeMinY = Math.min(nodeMinY, this._boxes[pos++]);
                        nodeMaxX = Math.max(nodeMaxX, this._boxes[pos++]);
                        nodeMaxY = Math.max(nodeMaxY, this._boxes[pos++]);
                    }
                    // add the new node to the tree data
                    this._indices[this._pos >> 2] = nodeIndex;
                    this._boxes[this._pos++] = nodeMinX;
                    this._boxes[this._pos++] = nodeMinY;
                    this._boxes[this._pos++] = nodeMaxX;
                    this._boxes[this._pos++] = nodeMaxY;
                }
            }
        }
        search(minX, minY, maxX, maxY, filterFn) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            let nodeIndex = this._boxes.length - 4;
            const queue = [];
            const results = [];
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // search through child nodes
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    // check if node bbox intersects with query bbox
                    if (maxX < this._boxes[pos])
                        continue; // maxX < nodeMinX
                    if (maxY < this._boxes[pos + 1])
                        continue; // maxY < nodeMinY
                    if (minX > this._boxes[pos + 2])
                        continue; // minX > nodeMaxX
                    if (minY > this._boxes[pos + 3])
                        continue; // minY > nodeMaxY
                    const index = this._indices[pos >> 2] | 0;
                    if (nodeIndex < this.numItems * 4) {
                        if (filterFn === undefined || filterFn(index)) {
                            results.push(index); // leaf item
                        }
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                    }
                }
                nodeIndex = queue.pop();
            }
            return results;
        }
        neighbors(x, y, maxResults = Infinity, maxDistance = Infinity, filterFn) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            let nodeIndex = this._boxes.length - 4;
            const q = this._queue;
            const results = [];
            const maxDistSquared = maxDistance * maxDistance;
            while (nodeIndex !== undefined) {
                // find the end index of the node
                const end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // add child nodes to the queue
                for (let pos = nodeIndex; pos < end; pos += 4) {
                    const index = this._indices[pos >> 2] | 0;
                    const dx = axisDist(x, this._boxes[pos], this._boxes[pos + 2]);
                    const dy = axisDist(y, this._boxes[pos + 1], this._boxes[pos + 3]);
                    const dist = dx * dx + dy * dy;
                    if (nodeIndex < this.numItems * 4) { // leaf node
                        if (filterFn === undefined || filterFn(index)) {
                            // put an odd index if it's an item rather than a node, to recognize later
                            q.push((index << 1) + 1, dist);
                        }
                    }
                    else {
                        q.push(index << 1, dist);
                    }
                }
                // pop items from the queue
                while (q.length && (q.peek() & 1)) {
                    const dist = q.peekValue();
                    if (dist > maxDistSquared) {
                        q.clear();
                        return results;
                    }
                    results.push(q.pop() >> 1);
                    if (results.length === maxResults) {
                        q.clear();
                        return results;
                    }
                }
                nodeIndex = q.pop() >> 1;
            }
            q.clear();
            return results;
        }
    }
    exports.default = Flatbush;
    function axisDist(k, min, max) {
        return k < min ? min - k : k <= max ? 0 : k - max;
    }
    // binary search for the first value in the array bigger than the given
    function upperBound(value, arr) {
        let i = 0;
        let j = arr.length - 1;
        while (i < j) {
            const m = (i + j) >> 1;
            if (arr[m] > value) {
                j = m;
            }
            else {
                i = m + 1;
            }
        }
        return arr[i];
    }
    // custom quicksort that partially sorts bbox data alongside the hilbert values
    function sort(values, boxes, indices, left, right, nodeSize) {
        if (Math.floor(left / nodeSize) >= Math.floor(right / nodeSize))
            return;
        const pivot = values[(left + right) >> 1];
        let i = left - 1;
        let j = right + 1;
        while (true) {
            do
                i++;
            while (values[i] < pivot);
            do
                j--;
            while (values[j] > pivot);
            if (i >= j)
                break;
            swap(values, boxes, indices, i, j);
        }
        sort(values, boxes, indices, left, j, nodeSize);
        sort(values, boxes, indices, j + 1, right, nodeSize);
    }
    // swap two values and two corresponding boxes
    function swap(values, boxes, indices, i, j) {
        const temp = values[i];
        values[i] = values[j];
        values[j] = temp;
        const k = 4 * i;
        const m = 4 * j;
        const a = boxes[k];
        const b = boxes[k + 1];
        const c = boxes[k + 2];
        const d = boxes[k + 3];
        boxes[k] = boxes[m];
        boxes[k + 1] = boxes[m + 1];
        boxes[k + 2] = boxes[m + 2];
        boxes[k + 3] = boxes[m + 3];
        boxes[m] = a;
        boxes[m + 1] = b;
        boxes[m + 2] = c;
        boxes[m + 3] = d;
        const e = indices[i];
        indices[i] = indices[j];
        indices[j] = e;
    }
    // Fast Hilbert curve algorithm by http://threadlocalmutex.com/
    // Ported from C++ https://github.com/rawrunprotected/hilbert_curves (public domain)
    function hilbert(x, y) {
        let a = x ^ y;
        let b = 0xFFFF ^ a;
        let c = 0xFFFF ^ (x | y);
        let d = x & (y ^ 0xFFFF);
        let A = a | (b >> 1);
        let B = (a >> 1) ^ a;
        let C = ((c >> 1) ^ (b & (d >> 1))) ^ c;
        let D = ((a & (c >> 1)) ^ (d >> 1)) ^ d;
        a = A;
        b = B;
        c = C;
        d = D;
        A = ((a & (a >> 2)) ^ (b & (b >> 2)));
        B = ((a & (b >> 2)) ^ (b & ((a ^ b) >> 2)));
        C ^= ((a & (c >> 2)) ^ (b & (d >> 2)));
        D ^= ((b & (c >> 2)) ^ ((a ^ b) & (d >> 2)));
        a = A;
        b = B;
        c = C;
        d = D;
        A = ((a & (a >> 4)) ^ (b & (b >> 4)));
        B = ((a & (b >> 4)) ^ (b & ((a ^ b) >> 4)));
        C ^= ((a & (c >> 4)) ^ (b & (d >> 4)));
        D ^= ((b & (c >> 4)) ^ ((a ^ b) & (d >> 4)));
        a = A;
        b = B;
        c = C;
        d = D;
        C ^= ((a & (c >> 8)) ^ (b & (d >> 8)));
        D ^= ((b & (c >> 8)) ^ ((a ^ b) & (d >> 8)));
        a = C ^ (C >> 1);
        b = D ^ (D >> 1);
        let i0 = x ^ y;
        let i1 = b | (0xFFFF ^ (i0 | a));
        i0 = (i0 | (i0 << 8)) & 0x00FF00FF;
        i0 = (i0 | (i0 << 4)) & 0x0F0F0F0F;
        i0 = (i0 | (i0 << 2)) & 0x33333333;
        i0 = (i0 | (i0 << 1)) & 0x55555555;
        i1 = (i1 | (i1 << 8)) & 0x00FF00FF;
        i1 = (i1 | (i1 << 4)) & 0x0F0F0F0F;
        i1 = (i1 | (i1 << 2)) & 0x33333333;
        i1 = (i1 | (i1 << 1)) & 0x55555555;
        return ((i1 << 1) | i0) >>> 0;
    }
},
/* flatqueue/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    class FlatQueue {
        constructor() {
            this.ids = [];
            this.values = [];
            this.length = 0;
        }
        clear() {
            this.length = 0;
        }
        push(id, value) {
            let pos = this.length++;
            while (pos > 0) {
                const parent = (pos - 1) >> 1;
                const parentValue = this.values[parent];
                if (value >= parentValue)
                    break;
                this.ids[pos] = this.ids[parent];
                this.values[pos] = parentValue;
                pos = parent;
            }
            this.ids[pos] = id;
            this.values[pos] = value;
        }
        pop() {
            if (this.length === 0)
                return undefined;
            const top = this.ids[0];
            this.length--;
            if (this.length > 0) {
                const id = this.ids[0] = this.ids[this.length];
                const value = this.values[0] = this.values[this.length];
                const halfLength = this.length >> 1;
                let pos = 0;
                while (pos < halfLength) {
                    let left = (pos << 1) + 1;
                    const right = left + 1;
                    let bestIndex = this.ids[left];
                    let bestValue = this.values[left];
                    const rightValue = this.values[right];
                    if (right < this.length && rightValue < bestValue) {
                        left = right;
                        bestIndex = this.ids[right];
                        bestValue = rightValue;
                    }
                    if (bestValue >= value)
                        break;
                    this.ids[pos] = bestIndex;
                    this.values[pos] = bestValue;
                    pos = left;
                }
                this.ids[pos] = id;
                this.values[pos] = value;
            }
            return top;
        }
        peek() {
            if (this.length === 0)
                return undefined;
            return this.ids[0];
        }
        peekValue() {
            if (this.length === 0)
                return undefined;
            return this.values[0];
        }
        shrink() {
            this.ids.length = this.values.length = this.length;
        }
    }
    exports.default = FlatQueue;
},
/* models/graphics/decoration.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const marking_1 = require(140) /* ./marking */;
    const model_1 = require(51) /* ../../model */;
    const view_1 = require(54) /* ../../core/view */;
    const build_views_1 = require(59) /* ../../core/build_views */;
    class DecorationView extends view_1.View {
        *children() {
            yield* super.children();
            yield this.marking;
        }
        async lazy_initialize() {
            await super.lazy_initialize();
            this.marking = await (0, build_views_1.build_view)(this.model.marking, { parent: this.parent });
        }
    }
    exports.DecorationView = DecorationView;
    DecorationView.__name__ = "DecorationView";
    class Decoration extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Decoration = Decoration;
    _a = Decoration;
    Decoration.__name__ = "Decoration";
    (() => {
        _a.prototype.default_view = DecorationView;
        _a.define(({ Enum, Ref }) => ({
            marking: [Ref(marking_1.Marking)],
            node: [Enum("start", "middle", "end")],
        }));
    })();
},
/* models/glyphs/utils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    const hittest = tslib_1.__importStar(require(210) /* ../../core/hittest */);
    function generic_line_scalar_legend(visuals, ctx, { x0, x1, y0, y1 }) {
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        visuals.line.apply(ctx);
        ctx.restore();
    }
    exports.generic_line_scalar_legend = generic_line_scalar_legend;
    function generic_line_vector_legend(visuals, ctx, { x0, x1, y0, y1 }, i) {
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        visuals.line.apply(ctx, i);
        ctx.restore();
    }
    exports.generic_line_vector_legend = generic_line_vector_legend;
    exports.generic_line_legend = generic_line_vector_legend;
    function generic_area_scalar_legend(visuals, ctx, { x0, x1, y0, y1 }) {
        var _a, _b;
        const w = Math.abs(x1 - x0);
        const dw = w * 0.1;
        const h = Math.abs(y1 - y0);
        const dh = h * 0.1;
        const sx0 = x0 + dw;
        const sx1 = x1 - dw;
        const sy0 = y0 + dh;
        const sy1 = y1 - dh;
        ctx.beginPath();
        ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        visuals.fill.apply(ctx);
        (_a = visuals.hatch) === null || _a === void 0 ? void 0 : _a.apply(ctx);
        (_b = visuals.line) === null || _b === void 0 ? void 0 : _b.apply(ctx);
    }
    exports.generic_area_scalar_legend = generic_area_scalar_legend;
    function generic_area_vector_legend(visuals, ctx, { x0, x1, y0, y1 }, i) {
        var _a, _b;
        const w = Math.abs(x1 - x0);
        const dw = w * 0.1;
        const h = Math.abs(y1 - y0);
        const dh = h * 0.1;
        const sx0 = x0 + dw;
        const sx1 = x1 - dw;
        const sy0 = y0 + dh;
        const sy1 = y1 - dh;
        ctx.beginPath();
        ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        visuals.fill.apply(ctx, i);
        (_a = visuals.hatch) === null || _a === void 0 ? void 0 : _a.apply(ctx, i);
        (_b = visuals.line) === null || _b === void 0 ? void 0 : _b.apply(ctx, i);
    }
    exports.generic_area_vector_legend = generic_area_vector_legend;
    exports.generic_area_legend = generic_area_vector_legend;
    function line_interpolation(renderer, geometry, x2, y2, x3, y3) {
        const { sx, sy } = geometry;
        let x0, x1;
        let y0, y1;
        if (geometry.type == "point") {
            // The +/- adjustments here are to dilate the hit point into a virtual "segment" to use below
            [y0, y1] = renderer.yscale.r_invert(sy - 1, sy + 1);
            [x0, x1] = renderer.xscale.r_invert(sx - 1, sx + 1);
        }
        else {
            // The +/- adjustments here are to handle cases such as purely horizontal or vertical lines
            if (geometry.direction == "v") {
                [y0, y1] = renderer.yscale.r_invert(sy, sy);
                [x0, x1] = [Math.min(x2 - 1, x3 - 1), Math.max(x2 + 1, x3 + 1)];
            }
            else {
                [x0, x1] = renderer.xscale.r_invert(sx, sx);
                [y0, y1] = [Math.min(y2 - 1, y3 - 1), Math.max(y2 + 1, y3 + 1)];
            }
        }
        const { x, y } = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3);
        return [x, y]; // XXX: null is not handled at use sites
    }
    exports.line_interpolation = line_interpolation;
},
/* core/hittest.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function point_in_poly(x, y, px, py) {
        let inside = false;
        let x1 = px[px.length - 1];
        let y1 = py[py.length - 1];
        for (let i = 0; i < px.length; i++) {
            const x2 = px[i];
            const y2 = py[i];
            if ((y1 < y) != (y2 < y)) {
                if ((x1 + (y - y1) / (y2 - y1) * (x2 - x1)) < x)
                    inside = !inside;
            }
            x1 = x2;
            y1 = y2;
        }
        return inside;
    }
    exports.point_in_poly = point_in_poly;
    function point_in_ellipse(x, y, angle, b, a, x0, y0) {
        const A = ((Math.cos(angle) / a) ** 2 + (Math.sin(angle) / b) ** 2);
        const B = 2 * Math.cos(angle) * Math.sin(angle) * ((1 / a) ** 2 - (1 / b) ** 2);
        const C = ((Math.cos(angle) / b) ** 2 + (Math.sin(angle) / a) ** 2);
        const eqn = A * (x - x0) ** 2 + B * (x - x0) * (y - y0) + C * (y - y0) ** 2;
        const inside = eqn <= 1;
        return inside;
    }
    exports.point_in_ellipse = point_in_ellipse;
    function dist_2_pts(p0, p1) {
        return (p0.x - p1.x) ** 2 + (p0.y - p1.y) ** 2;
    }
    exports.dist_2_pts = dist_2_pts;
    function dist_to_segment_squared(p, v, w) {
        const l2 = dist_2_pts(v, w);
        if (l2 == 0)
            return dist_2_pts(p, v);
        const t = ((p.x - v.x) * (w.x - v.x) + (p.y - v.y) * (w.y - v.y)) / l2;
        if (t < 0)
            return dist_2_pts(p, v);
        if (t > 1)
            return dist_2_pts(p, w);
        const q = { x: v.x + t * (w.x - v.x), y: v.y + t * (w.y - v.y) };
        return dist_2_pts(p, q);
    }
    exports.dist_to_segment_squared = dist_to_segment_squared;
    function dist_to_segment(p, v, w) {
        return Math.sqrt(dist_to_segment_squared(p, v, w));
    }
    exports.dist_to_segment = dist_to_segment;
    function check_2_segments_intersect(l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
        /*
         *  Check if 2 segments (l0 and l1) intersect. Returns a structure with
         *  the following attributes:
         *   * hit (boolean): whether the 2 segments intersect
         *   * x (float): x coordinate of the intersection point
         *   * y (float): y coordinate of the intersection point
         */
        const den = ((l1_y1 - l1_y0) * (l0_x1 - l0_x0)) - ((l1_x1 - l1_x0) * (l0_y1 - l0_y0));
        if (den == 0) {
            return { hit: false, x: null, y: null };
        }
        else {
            let a = l0_y0 - l1_y0;
            let b = l0_x0 - l1_x0;
            const num1 = ((l1_x1 - l1_x0) * a) - ((l1_y1 - l1_y0) * b);
            const num2 = ((l0_x1 - l0_x0) * a) - ((l0_y1 - l0_y0) * b);
            a = num1 / den;
            b = num2 / den;
            const x = l0_x0 + (a * (l0_x1 - l0_x0));
            const y = l0_y0 + (a * (l0_y1 - l0_y0));
            return { hit: (a > 0 && a < 1) && (b > 0 && b < 1), x, y };
        }
    }
    exports.check_2_segments_intersect = check_2_segments_intersect;
},
/* models/glyphs/patch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const xy_glyph_1 = require(202) /* ./xy_glyph */;
    const utils_1 = require(209) /* ./utils */;
    const hittest = tslib_1.__importStar(require(210) /* ../../core/hittest */);
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    const selection_1 = require(101) /* ../selections/selection */;
    class PatchView extends xy_glyph_1.XYGlyphView {
        _render(ctx, indices, data) {
            const { sx, sy } = data !== null && data !== void 0 ? data : this;
            let move = true;
            ctx.beginPath();
            for (const i of indices) {
                const sx_i = sx[i];
                const sy_i = sy[i];
                if (!isFinite(sx_i + sy_i)) {
                    ctx.closePath();
                    move = true;
                }
                else {
                    if (move) {
                        ctx.moveTo(sx_i, sy_i);
                        move = false;
                    }
                    else
                        ctx.lineTo(sx_i, sy_i);
                }
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
            this.visuals.line.apply(ctx);
        }
        draw_legend_for_index(ctx, bbox, _index) {
            (0, utils_1.generic_area_scalar_legend)(this.visuals, ctx, bbox);
        }
        _hit_point(geometry) {
            const result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, this.sx, this.sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        }
    }
    exports.PatchView = PatchView;
    PatchView.__name__ = "PatchView";
    class Patch extends xy_glyph_1.XYGlyph {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Patch = Patch;
    _a = Patch;
    Patch.__name__ = "Patch";
    (() => {
        _a.prototype.default_view = PatchView;
        _a.mixins([mixins.LineScalar, mixins.FillScalar, mixins.HatchScalar]);
    })();
},
/* models/glyphs/harea.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const area_1 = require(213) /* ./area */;
    const hittest = tslib_1.__importStar(require(210) /* ../../core/hittest */);
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    const selection_1 = require(101) /* ../selections/selection */;
    class HAreaView extends area_1.AreaView {
        _index_data(index) {
            const { min, max } = Math;
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x1 = this._x1[i];
                const x2 = this._x2[i];
                const y = this._y[i];
                index.add_rect(min(x1, x2), y, max(x1, x2), y);
            }
        }
        _render(ctx, _indices, data) {
            const { sx1, sx2, sy } = data !== null && data !== void 0 ? data : this;
            ctx.beginPath();
            for (let i = 0, end = sx1.length; i < end; i++) {
                ctx.lineTo(sx1[i], sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = sx2.length - 1; i >= 0; i--) {
                ctx.lineTo(sx2[i], sy[i]);
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
        }
        _hit_point(geometry) {
            const L = this.sy.length;
            const result = new selection_1.Selection();
            for (let i = 0, end = L - 1; i < end; i++) {
                const sx = [this.sx1[i], this.sx1[i + 1], this.sx2[i + 1], this.sx2[i]];
                const sy = [this.sy[i], this.sy[i + 1], this.sy[i + 1], this.sy[i]];
                if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices = [i];
                    break;
                }
            }
            return result;
        }
        scenterxy(i) {
            const scx = (this.sx1[i] + this.sx2[i]) / 2;
            const scy = this.sy[i];
            return [scx, scy];
        }
        _map_data() {
            this.sx1 = this.renderer.xscale.v_compute(this._x1);
            this.sx2 = this.renderer.xscale.v_compute(this._x2);
            this.sy = this.renderer.yscale.v_compute(this._y);
        }
    }
    exports.HAreaView = HAreaView;
    HAreaView.__name__ = "HAreaView";
    class HArea extends area_1.Area {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.HArea = HArea;
    _a = HArea;
    HArea.__name__ = "HArea";
    (() => {
        _a.prototype.default_view = HAreaView;
        _a.define(({}) => ({
            x1: [p.XCoordinateSpec, { field: "x1" }],
            x2: [p.XCoordinateSpec, { field: "x2" }],
            y: [p.YCoordinateSpec, { field: "y" }],
        }));
    })();
},
/* models/glyphs/area.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const glyph_1 = require(203) /* ./glyph */;
    const utils_1 = require(209) /* ./utils */;
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    class AreaView extends glyph_1.GlyphView {
        draw_legend_for_index(ctx, bbox, _index) {
            (0, utils_1.generic_area_scalar_legend)(this.visuals, ctx, bbox);
        }
    }
    exports.AreaView = AreaView;
    AreaView.__name__ = "AreaView";
    class Area extends glyph_1.Glyph {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Area = Area;
    _a = Area;
    Area.__name__ = "Area";
    (() => {
        _a.mixins([mixins.FillScalar, mixins.HatchScalar]);
    })();
},
/* models/glyphs/varea.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const area_1 = require(213) /* ./area */;
    const hittest = tslib_1.__importStar(require(210) /* ../../core/hittest */);
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    const selection_1 = require(101) /* ../selections/selection */;
    class VAreaView extends area_1.AreaView {
        _index_data(index) {
            const { min, max } = Math;
            const { data_size } = this;
            for (let i = 0; i < data_size; i++) {
                const x = this._x[i];
                const y1 = this._y1[i];
                const y2 = this._y2[i];
                index.add_rect(x, min(y1, y2), x, max(y1, y2));
            }
        }
        _render(ctx, _indices, data) {
            const { sx, sy1, sy2 } = data !== null && data !== void 0 ? data : this;
            ctx.beginPath();
            for (let i = 0, end = sy1.length; i < end; i++) {
                ctx.lineTo(sx[i], sy1[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = sy2.length - 1; i >= 0; i--) {
                ctx.lineTo(sx[i], sy2[i]);
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
        }
        scenterxy(i) {
            const scx = this.sx[i];
            const scy = (this.sy1[i] + this.sy2[i]) / 2;
            return [scx, scy];
        }
        _hit_point(geometry) {
            const L = this.sx.length;
            const result = new selection_1.Selection();
            for (let i = 0, end = L - 1; i < end; i++) {
                const sx = [this.sx[i], this.sx[i + 1], this.sx[i + 1], this.sx[i]];
                const sy = [this.sy1[i], this.sy1[i + 1], this.sy2[i + 1], this.sy2[i]];
                if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices = [i];
                    break;
                }
            }
            return result;
        }
        _map_data() {
            this.sx = this.renderer.xscale.v_compute(this._x);
            this.sy1 = this.renderer.yscale.v_compute(this._y1);
            this.sy2 = this.renderer.yscale.v_compute(this._y2);
        }
    }
    exports.VAreaView = VAreaView;
    VAreaView.__name__ = "VAreaView";
    class VArea extends area_1.Area {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.VArea = VArea;
    _a = VArea;
    VArea.__name__ = "VArea";
    (() => {
        _a.prototype.default_view = VAreaView;
        _a.define(({}) => ({
            x: [p.XCoordinateSpec, { field: "x" }],
            y1: [p.YCoordinateSpec, { field: "y1" }],
            y2: [p.YCoordinateSpec, { field: "y2" }],
        }));
    })();
},
/* models/sources/cds_view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const model_1 = require(51) /* ../../model */;
    const view_1 = require(54) /* ../../core/view */;
    const types_1 = require(23) /* ../../core/types */;
    const filter_1 = require(216) /* ../filters/filter */;
    const all_indices_1 = require(217) /* ../filters/all_indices */;
    const intersection_filter_1 = require(218) /* ../filters/intersection_filter */;
    class CDSViewView extends view_1.View {
        initialize() {
            super.initialize();
            this.compute_indices();
        }
        connect_signals() {
            super.connect_signals();
            const { filter } = this.model.properties;
            this.on_change(filter, () => this.compute_indices());
            const connect_listeners = () => {
                const fn = () => this.compute_indices();
                const source = this.parent.data_source.get_value();
                this.connect(source.change, fn);
                this.connect(source.streaming, fn);
                this.connect(source.patching, fn);
            };
            connect_listeners();
            const { data_source } = this.parent;
            this.on_change(data_source, () => {
                // TODO: disconnect
                connect_listeners();
            });
        }
        compute_indices() {
            var _b;
            // XXX: if the data source is empty, there still may be one
            // index originating from glyph's scalar values.
            const source = this.parent.data_source.get_value();
            const size = (_b = source.get_length()) !== null && _b !== void 0 ? _b : 1;
            const indices = types_1.Indices.all_set(size);
            const filtered = this.model.filter.compute_indices(source);
            indices.intersect(filtered);
            this.model.indices = indices;
            this.model._indices_map_to_subset();
        }
    }
    exports.CDSViewView = CDSViewView;
    CDSViewView.__name__ = "CDSViewView";
    class CDSView extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
        _indices_map_to_subset() {
            this._indices = [...this.indices];
            this.indices_map = {};
            for (let i = 0; i < this._indices.length; i++) {
                this.indices_map[this._indices[i]] = i;
            }
        }
        convert_selection_from_subset(selection_subset) {
            return selection_subset.map((i) => this._indices[i]);
        }
        convert_selection_to_subset(selection_full) {
            return selection_full.map((i) => this.indices_map[i]);
        }
        convert_indices_from_subset(indices) {
            return indices.map((i) => this._indices[i]);
        }
        /** @deprecated */
        get filters() {
            const { filter } = this;
            if (filter instanceof intersection_filter_1.IntersectionFilter) {
                return filter.operands;
            }
            else if (filter instanceof all_indices_1.AllIndices) {
                return [];
            }
            else {
                return [filter];
            }
        }
        /** @deprecated */
        set filters(filters) {
            if (filters.length == 0) {
                this.filter = new all_indices_1.AllIndices();
            }
            else if (filters.length == 1) {
                this.filter = filters[0];
            }
            else {
                this.filter = new intersection_filter_1.IntersectionFilter({ operands: filters });
            }
        }
    }
    exports.CDSView = CDSView;
    _a = CDSView;
    CDSView.__name__ = "CDSView";
    (() => {
        _a.prototype.default_view = CDSViewView;
        _a.define(({ Ref }) => ({
            filter: [Ref(filter_1.Filter), () => new all_indices_1.AllIndices()],
        }));
        _a.internal(({ Int, Dict, Ref, Nullable }) => ({
            indices: [Ref(types_1.Indices)],
            indices_map: [Dict(Int), {}],
            masked: [Nullable(Ref(types_1.Indices)), null],
        }));
    })();
},
/* models/filters/filter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const model_1 = require(51) /* ../../model */;
    class Filter extends model_1.Model {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Filter = Filter;
    Filter.__name__ = "Filter";
},
/* models/filters/all_indices.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const filter_1 = require(216) /* ./filter */;
    const types_1 = require(23) /* ../../core/types */;
    class AllIndices extends filter_1.Filter {
        constructor(attrs) {
            super(attrs);
        }
        compute_indices(source) {
            var _a;
            const size = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            return types_1.Indices.all_set(size);
        }
    }
    exports.AllIndices = AllIndices;
    AllIndices.__name__ = "AllIndices";
},
/* models/filters/intersection_filter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const filter_1 = require(216) /* ./filter */;
    const types_1 = require(23) /* ../../core/types */;
    class IntersectionFilter extends filter_1.Filter {
        constructor(attrs) {
            super(attrs);
        }
        compute_indices(source) {
            var _b;
            const { operands } = this;
            if (operands.length == 0) {
                const size = (_b = source.get_length()) !== null && _b !== void 0 ? _b : 1;
                return types_1.Indices.all_set(size);
            }
            else {
                const [index, ...rest] = operands.map((op) => op.compute_indices(source));
                for (const op of rest) {
                    index.intersect(op);
                }
                return index;
            }
        }
    }
    exports.IntersectionFilter = IntersectionFilter;
    _a = IntersectionFilter;
    IntersectionFilter.__name__ = "IntersectionFilter";
    (() => {
        _a.define(({ Array, Ref }) => ({
            operands: [Array(Ref(filter_1.Filter))],
        }));
    })();
},
/* models/formatters/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var basic_tick_formatter_1 = require(185) /* ./basic_tick_formatter */;
    __esExport("BasicTickFormatter", basic_tick_formatter_1.BasicTickFormatter);
    var categorical_tick_formatter_1 = require(166) /* ./categorical_tick_formatter */;
    __esExport("CategoricalTickFormatter", categorical_tick_formatter_1.CategoricalTickFormatter);
    var datetime_tick_formatter_1 = require(169) /* ./datetime_tick_formatter */;
    __esExport("DatetimeTickFormatter", datetime_tick_formatter_1.DatetimeTickFormatter);
    var customjs_tick_formatter_1 = require(220) /* ./customjs_tick_formatter */;
    __esExport("CustomJSTickFormatter", customjs_tick_formatter_1.CustomJSTickFormatter);
    var log_tick_formatter_1 = require(187) /* ./log_tick_formatter */;
    __esExport("LogTickFormatter", log_tick_formatter_1.LogTickFormatter);
    var mercator_tick_formatter_1 = require(190) /* ./mercator_tick_formatter */;
    __esExport("MercatorTickFormatter", mercator_tick_formatter_1.MercatorTickFormatter);
    var numeral_tick_formatter_1 = require(221) /* ./numeral_tick_formatter */;
    __esExport("NumeralTickFormatter", numeral_tick_formatter_1.NumeralTickFormatter);
    var printf_tick_formatter_1 = require(222) /* ./printf_tick_formatter */;
    __esExport("PrintfTickFormatter", printf_tick_formatter_1.PrintfTickFormatter);
    var tick_formatter_1 = require(162) /* ./tick_formatter */;
    __esExport("TickFormatter", tick_formatter_1.TickFormatter);
},
/* models/formatters/customjs_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const tick_formatter_1 = require(162) /* ./tick_formatter */;
    const object_1 = require(9) /* ../../core/util/object */;
    const string_1 = require(38) /* ../../core/util/string */;
    class CustomJSTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        get names() {
            return (0, object_1.keys)(this.args);
        }
        get values() {
            return (0, object_1.values)(this.args);
        }
        /*protected*/ _make_func() {
            const code = (0, string_1.use_strict)(this.code);
            return new Function("tick", "index", "ticks", ...this.names, code);
        }
        doFormat(ticks, _opts) {
            const cache = {};
            const func = this._make_func().bind(cache);
            return ticks.map((tick, index, ticks) => `${func(tick, index, ticks, ...this.values)}`);
        }
    }
    exports.CustomJSTickFormatter = CustomJSTickFormatter;
    _a = CustomJSTickFormatter;
    CustomJSTickFormatter.__name__ = "CustomJSTickFormatter";
    (() => {
        _a.define(({ Unknown, String, Dict }) => ({
            args: [Dict(Unknown), {}],
            code: [String, ""],
        }));
    })();
},
/* models/formatters/numeral_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const Numbro = tslib_1.__importStar(require(171) /* @bokeh/numbro */);
    const tick_formatter_1 = require(162) /* ./tick_formatter */;
    const enums_1 = require(19) /* ../../core/enums */;
    class NumeralTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        get _rounding_fn() {
            switch (this.rounding) {
                case "round":
                case "nearest":
                    return Math.round;
                case "floor":
                case "rounddown":
                    return Math.floor;
                case "ceil":
                case "roundup":
                    return Math.ceil;
            }
        }
        doFormat(ticks, _opts) {
            const { format, language, _rounding_fn } = this;
            return ticks.map((tick) => Numbro.format(tick, format, language, _rounding_fn));
        }
    }
    exports.NumeralTickFormatter = NumeralTickFormatter;
    _a = NumeralTickFormatter;
    NumeralTickFormatter.__name__ = "NumeralTickFormatter";
    (() => {
        _a.define(({ String }) => ({
            // TODO (bev) all of these could be tightened up
            format: [String, "0,0"],
            language: [String, "en"],
            rounding: [enums_1.RoundingFunction, "round"],
        }));
    })();
},
/* models/formatters/printf_tick_formatter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const tick_formatter_1 = require(162) /* ./tick_formatter */;
    const templating_1 = require(170) /* ../../core/util/templating */;
    class PrintfTickFormatter extends tick_formatter_1.TickFormatter {
        constructor(attrs) {
            super(attrs);
        }
        doFormat(ticks, _opts) {
            return ticks.map((tick) => (0, templating_1.sprintf)(this.format, tick));
        }
    }
    exports.PrintfTickFormatter = PrintfTickFormatter;
    _a = PrintfTickFormatter;
    PrintfTickFormatter.__name__ = "PrintfTickFormatter";
    (() => {
        _a.define(({ String }) => ({
            format: [String, "%s"],
        }));
    })();
},
/* models/scales/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var categorical_scale_1 = require(92) /* ./categorical_scale */;
    __esExport("CategoricalScale", categorical_scale_1.CategoricalScale);
    var continuous_scale_1 = require(90) /* ./continuous_scale */;
    __esExport("ContinuousScale", continuous_scale_1.ContinuousScale);
    var linear_scale_1 = require(89) /* ./linear_scale */;
    __esExport("LinearScale", linear_scale_1.LinearScale);
    var linear_interpolation_scale_1 = require(224) /* ./linear_interpolation_scale */;
    __esExport("LinearInterpolationScale", linear_interpolation_scale_1.LinearInterpolationScale);
    var log_scale_1 = require(91) /* ./log_scale */;
    __esExport("LogScale", log_scale_1.LogScale);
    var scale_1 = require(85) /* ./scale */;
    __esExport("Scale", scale_1.Scale);
},
/* models/scales/linear_interpolation_scale.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _a;
    const scale_1 = require(85) /* ./scale */;
    const linear_scale_1 = require(89) /* ./linear_scale */;
    const arrayable_1 = require(13) /* ../../core/util/arrayable */;
    class LinearInterpolationScale extends scale_1.Scale {
        constructor(attrs) {
            super(attrs);
        }
        initialize() {
            super.initialize();
            const { source_range, target_range } = this.properties;
            if (!source_range.is_unset && !target_range.is_unset) {
                this.linear_scale = new linear_scale_1.LinearScale({
                    source_range: source_range.get_value(),
                    target_range: target_range.get_value(),
                });
            }
        }
        connect_signals() {
            super.connect_signals();
            const { source_range, target_range } = this.properties;
            this.on_change([source_range, target_range], () => {
                this.linear_scale = new linear_scale_1.LinearScale({
                    source_range: this.source_range,
                    target_range: this.target_range,
                });
            });
        }
        get s_compute() {
            throw new Error("not implemented");
        }
        get s_invert() {
            throw new Error("not implemented");
        }
        compute(x) {
            return x;
        }
        v_compute(vs) {
            const { binning } = this;
            const { start, end } = this.source_range;
            const min_val = start;
            const max_val = end;
            const n = binning.length;
            const step = (end - start) / (n - 1);
            const mapping = new Float64Array(n);
            for (let i = 0; i < n; i++) {
                mapping[i] = start + i * step;
            }
            const vvs = (0, arrayable_1.map)(vs, (v) => {
                if (v < min_val)
                    return min_val;
                if (v > max_val)
                    return max_val;
                const k = (0, arrayable_1.left_edge_index)(v, binning);
                if (k == -1)
                    return min_val;
                if (k >= n - 1)
                    return max_val;
                const b0 = binning[k];
                const b1 = binning[k + 1];
                const c = (v - b0) / (b1 - b0);
                const m0 = mapping[k];
                const m1 = mapping[k + 1];
                return m0 + c * (m1 - m0);
            });
            return this.linear_scale.v_compute(vvs);
        }
        invert(xprime) {
            return xprime;
        }
        v_invert(xprimes) {
            return new Float64Array(xprimes);
        }
    }
    exports.LinearInterpolationScale = LinearInterpolationScale;
    _a = LinearInterpolationScale;
    LinearInterpolationScale.__name__ = "LinearInterpolationScale";
    (() => {
        _a.internal(({ Number, Arrayable, Ref }) => ({
            binning: [Arrayable(Number)],
            linear_scale: [Ref(linear_scale_1.LinearScale)],
        }));
    })();
},
/* models/ranges/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var data_range_1 = require(94) /* ./data_range */;
    __esExport("DataRange", data_range_1.DataRange);
    var data_range1d_1 = require(93) /* ./data_range1d */;
    __esExport("DataRange1d", data_range1d_1.DataRange1d);
    var factor_range_1 = require(96) /* ./factor_range */;
    __esExport("FactorRange", factor_range_1.FactorRange);
    var range_1 = require(87) /* ./range */;
    __esExport("Range", range_1.Range);
    var range1d_1 = require(88) /* ./range1d */;
    __esExport("Range1d", range1d_1.Range1d);
},
/* core/layout/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var types_1 = require(145) /* ./types */;
    __esExport("Sizeable", types_1.Sizeable);
    __esExport("SizingPolicy", types_1.SizingPolicy);
    var layoutable_1 = require(146) /* ./layoutable */;
    __esExport("Layoutable", layoutable_1.Layoutable);
    var alignments_1 = require(227) /* ./alignments */;
    __esExport("HStack", alignments_1.HStack);
    __esExport("VStack", alignments_1.VStack);
    var grid_1 = require(228) /* ./grid */;
    __esExport("Grid", grid_1.Grid);
    __esExport("Row", grid_1.Row);
    __esExport("Column", grid_1.Column);
},
/* core/layout/alignments.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const layoutable_1 = require(146) /* ./layoutable */;
    const bbox_1 = require(57) /* ../util/bbox */;
    class Stack extends layoutable_1.Layoutable {
        constructor() {
            super(...arguments);
            this.children = [];
        }
        *[Symbol.iterator]() {
            yield* this.children;
        }
    }
    exports.Stack = Stack;
    Stack.__name__ = "Stack";
    class HStack extends Stack {
        _measure(_viewport) {
            let width = 0;
            let height = 0;
            for (const child of this.children) {
                const size_hint = child.measure({ width: 0, height: 0 });
                width += size_hint.width;
                height = Math.max(height, size_hint.height);
            }
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            if (outer.is_empty) {
                for (const child of this.children) {
                    child.set_geometry(new bbox_1.BBox());
                }
            }
            else {
                const top = this.absolute ? outer.top : 0;
                let left = this.absolute ? outer.left : 0;
                const { height } = outer;
                for (const child of this.children) {
                    const { width } = child.measure({ width: 0, height: 0 });
                    child.set_geometry(new bbox_1.BBox({ left, width, top, height }));
                    left += width;
                }
            }
        }
    }
    exports.HStack = HStack;
    HStack.__name__ = "HStack";
    class VStack extends Stack {
        _measure(_viewport) {
            let width = 0;
            let height = 0;
            for (const child of this.children) {
                const size_hint = child.measure({ width: 0, height: 0 });
                width = Math.max(width, size_hint.width);
                height += size_hint.height;
            }
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            if (outer.is_empty) {
                for (const child of this.children) {
                    child.set_geometry(new bbox_1.BBox());
                }
            }
            else {
                const left = this.absolute ? outer.left : 0;
                let top = this.absolute ? outer.top : 0;
                const { width } = outer;
                for (const child of this.children) {
                    const { height } = child.measure({ width: 0, height: 0 });
                    child.set_geometry(new bbox_1.BBox({ top, height, left, width }));
                    top += height;
                }
            }
        }
    }
    exports.VStack = VStack;
    VStack.__name__ = "VStack";
    class NodeLayout extends layoutable_1.Layoutable {
        constructor() {
            super(...arguments);
            this.children = [];
        }
        *[Symbol.iterator]() {
            yield* this.children;
        }
        _measure(viewport) {
            const { width_policy, height_policy } = this.sizing;
            const { min, max } = Math;
            let max_width = 0;
            let max_height = 0;
            for (const layout of this.children) {
                const { width, height } = layout.measure(viewport);
                max_width = max(max_width, width);
                max_height = max(max_height, height);
            }
            const width = (() => {
                const { width } = this.sizing;
                if (viewport.width == Infinity) {
                    return width_policy == "fixed" ? width !== null && width !== void 0 ? width : max_width : max_width;
                }
                else {
                    switch (width_policy) {
                        case "fixed": return width !== null && width !== void 0 ? width : max_width;
                        case "min": return /*width != null ? min(viewport.width, width) :*/ max_width;
                        case "fit": return width != null ? min(viewport.width, width) : viewport.width;
                        case "max": return width != null ? max(viewport.width, width) : viewport.width;
                    }
                }
            })();
            const height = (() => {
                const { height } = this.sizing;
                if (viewport.height == Infinity) {
                    return height_policy == "fixed" ? height !== null && height !== void 0 ? height : max_height : max_height;
                }
                else {
                    switch (height_policy) {
                        case "fixed": return height !== null && height !== void 0 ? height : max_height;
                        case "min": return /*height != null ? min(viewport.height, height) :*/ max_height;
                        case "fit": return height != null ? min(viewport.height, height) : viewport.height;
                        case "max": return height != null ? max(viewport.height, height) : viewport.height;
                    }
                }
            })();
            return { width, height };
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            if (outer.is_empty) {
                for (const child of this.children) {
                    child.set_geometry(new bbox_1.BBox());
                }
            }
            else {
                const bbox = this.absolute ? outer : outer.relative();
                const { left, right, top, bottom } = bbox;
                const vcenter = Math.round(bbox.vcenter);
                const hcenter = Math.round(bbox.hcenter);
                for (const layout of this.children) {
                    const { margin, halign = "start", valign = "start" } = layout.sizing;
                    const { width, height, inner } = layout.measure(outer);
                    const bbox = (() => {
                        const anchor = `${valign}_${halign}`;
                        switch (anchor) {
                            case "start_start": // "top_left"
                                return new bbox_1.BBox({ left: left + margin.left, top: top + margin.top, width, height });
                            case "start_center": // "top_center"
                                return new bbox_1.BBox({ hcenter, top: top + margin.top, width, height });
                            case "start_end": // "top_right"
                                return new bbox_1.BBox({ right: right - margin.right, top: top + margin.top, width, height });
                            case "center_start": // "center_left"
                                return new bbox_1.BBox({ left: left + margin.left, vcenter, width, height });
                            case "center_center": // "center"
                                return new bbox_1.BBox({ hcenter, vcenter, width, height });
                            case "center_end": // "center_right"
                                return new bbox_1.BBox({ right: right - margin.right, vcenter, width, height });
                            case "end_start": // "bottom_left"
                                return new bbox_1.BBox({ left: left + margin.left, bottom: bottom - margin.bottom, width, height });
                            case "end_center": // "bottom_center"
                                return new bbox_1.BBox({ hcenter, bottom: bottom - margin.bottom, width, height });
                            case "end_end": // "bottom_right"
                                return new bbox_1.BBox({ right: right - margin.right, bottom: bottom - margin.bottom, width, height });
                        }
                    })();
                    const inner_bbox = inner == null ? bbox : new bbox_1.BBox({
                        left: bbox.left + inner.left,
                        top: bbox.top + inner.top,
                        right: bbox.right - inner.right,
                        bottom: bbox.bottom - inner.bottom,
                    });
                    layout.set_geometry(bbox, inner_bbox);
                }
            }
        }
    }
    exports.NodeLayout = NodeLayout;
    NodeLayout.__name__ = "NodeLayout";
},
/* core/layout/grid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(145) /* ./types */;
    const layoutable_1 = require(146) /* ./layoutable */;
    const types_2 = require(8) /* ../util/types */;
    const bbox_1 = require(57) /* ../util/bbox */;
    const array_1 = require(10) /* ../util/array */;
    const { max, round } = Math;
    class DefaultMap {
        constructor(def) {
            this.def = def;
            this._map = new Map();
        }
        get(key) {
            let value = this._map.get(key);
            if (value === undefined) {
                value = this.def();
                this._map.set(key, value);
            }
            return value;
        }
        apply(key, fn) {
            const value = this.get(key);
            this._map.set(key, fn(value));
        }
    }
    exports.DefaultMap = DefaultMap;
    DefaultMap.__name__ = "DefaultMap";
    class Container {
        constructor() {
            this._items = [];
            this._nrows = 0;
            this._ncols = 0;
        }
        get size() {
            return this._items.length;
        }
        get nrows() {
            return this._nrows;
        }
        get ncols() {
            return this._ncols;
        }
        add(span, data) {
            const { r1, c1 } = span;
            this._nrows = max(this._nrows, r1 + 1);
            this._ncols = max(this._ncols, c1 + 1);
            this._items.push({ span, data });
        }
        at(r, c) {
            const selected = this._items.filter(({ span }) => {
                return span.r0 <= r && r <= span.r1 &&
                    span.c0 <= c && c <= span.c1;
            });
            return selected.map(({ data }) => data);
        }
        row(r) {
            const selected = this._items.filter(({ span }) => span.r0 <= r && r <= span.r1);
            return selected.map(({ data }) => data);
        }
        col(c) {
            const selected = this._items.filter(({ span }) => span.c0 <= c && c <= span.c1);
            return selected.map(({ data }) => data);
        }
        *[Symbol.iterator]() {
            yield* this._items;
        }
        foreach(fn) {
            for (const { span, data } of this._items) {
                fn(span, data);
            }
        }
        map(fn) {
            const result = new Container();
            for (const { span, data } of this._items) {
                result.add(span, fn(span, data));
            }
            return result;
        }
    }
    exports.Container = Container;
    Container.__name__ = "Container";
    class Grid extends layoutable_1.Layoutable {
        constructor(items = []) {
            super();
            this.items = items;
            this.rows = "auto";
            this.cols = "auto";
            this.spacing = 0;
        }
        *[Symbol.iterator]() {
            for (const { layout } of this.items) {
                yield layout;
            }
        }
        is_width_expanding() {
            if (super.is_width_expanding())
                return true;
            if (this.sizing.width_policy == "fixed")
                return false;
            const { cols } = this._state;
            return (0, array_1.some)(cols, (col) => col.policy == "max");
        }
        is_height_expanding() {
            if (super.is_height_expanding())
                return true;
            if (this.sizing.height_policy == "fixed")
                return false;
            const { rows } = this._state;
            return (0, array_1.some)(rows, (row) => row.policy == "max");
        }
        _init() {
            var _a, _b, _c, _d;
            super._init();
            const items = new Container();
            for (const { layout, row, col, row_span = 1, col_span = 1 } of this.items) {
                if (layout.sizing.visible) {
                    const r0 = row;
                    const c0 = col;
                    const r1 = row + row_span - 1;
                    const c1 = col + col_span - 1;
                    items.add({ r0, c0, r1, c1 }, layout);
                }
            }
            const { nrows, ncols } = items;
            const rows = new Array(nrows);
            for (let y = 0; y < nrows; y++) {
                const row = (() => {
                    var _a;
                    const sizing = (0, types_2.isPlainObject)(this.rows) ? (_a = this.rows[y]) !== null && _a !== void 0 ? _a : this.rows["*"] : this.rows;
                    if (sizing == null)
                        return { policy: "auto" };
                    else if ((0, types_2.isNumber)(sizing))
                        return { policy: "fixed", height: sizing };
                    else if ((0, types_2.isString)(sizing))
                        return { policy: sizing };
                    else
                        return sizing;
                })();
                const align = (_a = row.align) !== null && _a !== void 0 ? _a : "auto";
                if (row.policy == "fixed")
                    rows[y] = { policy: "fixed", height: row.height, align };
                else if (row.policy == "min")
                    rows[y] = { policy: "min", align };
                else if (row.policy == "fit" || row.policy == "max")
                    rows[y] = { policy: row.policy, flex: (_b = row.flex) !== null && _b !== void 0 ? _b : 1, align };
                else {
                    if ((0, array_1.some)(items.row(y), (layout) => layout.is_height_expanding()))
                        rows[y] = { policy: "max", flex: 1, align };
                    else
                        rows[y] = { policy: "min", align };
                }
            }
            const cols = new Array(ncols);
            for (let x = 0; x < ncols; x++) {
                const col = (() => {
                    var _a;
                    const sizing = (0, types_2.isPlainObject)(this.cols) ? (_a = this.cols[x]) !== null && _a !== void 0 ? _a : this.cols["*"] : this.cols;
                    if (sizing == null)
                        return { policy: "auto" };
                    else if ((0, types_2.isNumber)(sizing))
                        return { policy: "fixed", width: sizing };
                    else if ((0, types_2.isString)(sizing))
                        return { policy: sizing };
                    else
                        return sizing;
                })();
                const align = (_c = col.align) !== null && _c !== void 0 ? _c : "auto";
                if (col.policy == "fixed")
                    cols[x] = { policy: "fixed", width: col.width, align };
                else if (col.policy == "min")
                    cols[x] = { policy: "min", align };
                else if (col.policy == "fit" || col.policy == "max")
                    cols[x] = { policy: col.policy, flex: (_d = col.flex) !== null && _d !== void 0 ? _d : 1, align };
                else {
                    if ((0, array_1.some)(items.col(x), (layout) => layout.is_width_expanding()))
                        cols[x] = { policy: "max", flex: 1, align };
                    else
                        cols[x] = { policy: "min", align };
                }
            }
            const [rspacing, cspacing] = (0, types_2.isNumber)(this.spacing) ? [this.spacing, this.spacing] : this.spacing;
            this._state = { items, nrows, ncols, rows, cols, rspacing, cspacing };
        }
        _measure_totals(row_heights, col_widths) {
            const { nrows, ncols, rspacing, cspacing } = this._state;
            return {
                height: (0, array_1.sum)(row_heights) + (nrows - 1) * rspacing,
                width: (0, array_1.sum)(col_widths) + (ncols - 1) * cspacing,
            };
        }
        _measure_cells(cell_viewport) {
            const { items, nrows, ncols, rows, cols, rspacing, cspacing } = this._state;
            const row_heights = new Array(nrows);
            for (let r = 0; r < nrows; r++) {
                const row = rows[r];
                row_heights[r] = row.policy == "fixed" ? row.height : 0;
            }
            const col_widths = new Array(ncols);
            for (let c = 0; c < ncols; c++) {
                const col = cols[c];
                col_widths[c] = col.policy == "fixed" ? col.width : 0;
            }
            const size_hints = new Container();
            items.foreach((span, layout) => {
                const { r0, c0, r1, c1 } = span;
                const rspace = (r1 - r0) * rspacing;
                const cspace = (c1 - c0) * cspacing;
                let height = 0;
                for (let r = r0; r <= r1; r++) {
                    height += cell_viewport(r, c0).height;
                }
                height += rspace;
                let width = 0;
                for (let c = c0; c <= c1; c++) {
                    width += cell_viewport(r0, c).width;
                }
                width += cspace;
                const size_hint = layout.measure({ width, height });
                size_hints.add(span, { layout, size_hint });
                const size = new types_1.Sizeable(size_hint).grow_by(layout.sizing.margin);
                size.height -= rspace;
                size.width -= cspace;
                const radjustable = [];
                for (let r = r0; r <= r1; r++) {
                    const row = rows[r];
                    if (row.policy == "fixed")
                        size.height -= row.height;
                    else
                        radjustable.push(r);
                }
                if (size.height > 0) {
                    const rheight = round(size.height / radjustable.length);
                    for (const r of radjustable) {
                        row_heights[r] = max(row_heights[r], rheight);
                    }
                }
                const cadjustable = [];
                for (let c = c0; c <= c1; c++) {
                    const col = cols[c];
                    if (col.policy == "fixed")
                        size.width -= col.width;
                    else
                        cadjustable.push(c);
                }
                if (size.width > 0) {
                    const cwidth = round(size.width / cadjustable.length);
                    for (const c of cadjustable) {
                        col_widths[c] = max(col_widths[c], cwidth);
                    }
                }
            });
            const size = this._measure_totals(row_heights, col_widths);
            return { size, row_heights, col_widths, size_hints };
        }
        _measure_grid(viewport) {
            const { nrows, ncols, rows, cols, rspacing, cspacing } = this._state;
            const preferred = this._measure_cells((y, x) => {
                const row = rows[y];
                const col = cols[x];
                return {
                    width: col.policy == "fixed" ? col.width : Infinity,
                    height: row.policy == "fixed" ? row.height : Infinity,
                };
            });
            let available_height;
            if (this.sizing.height_policy == "fixed" && this.sizing.height != null)
                available_height = this.sizing.height;
            else if (viewport.height != Infinity && this.is_height_expanding())
                available_height = viewport.height;
            else
                available_height = preferred.size.height;
            let height_flex = 0;
            for (let y = 0; y < nrows; y++) {
                const row = rows[y];
                if (row.policy == "fit" || row.policy == "max")
                    height_flex += row.flex;
                else
                    available_height -= preferred.row_heights[y];
            }
            available_height -= (nrows - 1) * rspacing;
            if (height_flex != 0 && available_height > 0) {
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy == "fit" || row.policy == "max") {
                        const height = round(available_height * (row.flex / height_flex));
                        available_height -= height;
                        preferred.row_heights[y] = height;
                        height_flex -= row.flex;
                    }
                }
            }
            else if (available_height < 0) {
                let nadjustable = 0;
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy != "fixed")
                        nadjustable++;
                }
                let overflow_height = -available_height;
                for (let y = 0; y < nrows; y++) {
                    const row = rows[y];
                    if (row.policy != "fixed") {
                        const height = preferred.row_heights[y];
                        const cutoff = round(overflow_height / nadjustable);
                        preferred.row_heights[y] = max(height - cutoff, 0);
                        overflow_height -= cutoff > height ? height : cutoff;
                        nadjustable--;
                    }
                }
            }
            let available_width;
            if (this.sizing.width_policy == "fixed" && this.sizing.width != null)
                available_width = this.sizing.width;
            else if (viewport.width != Infinity && this.is_width_expanding())
                available_width = viewport.width;
            else
                available_width = preferred.size.width;
            let width_flex = 0;
            for (let x = 0; x < ncols; x++) {
                const col = cols[x];
                if (col.policy == "fit" || col.policy == "max")
                    width_flex += col.flex;
                else
                    available_width -= preferred.col_widths[x];
            }
            available_width -= (ncols - 1) * cspacing;
            if (width_flex != 0 && available_width > 0) {
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy == "fit" || col.policy == "max") {
                        const width = round(available_width * (col.flex / width_flex));
                        available_width -= width;
                        preferred.col_widths[x] = width;
                        width_flex -= col.flex;
                    }
                }
            }
            else if (available_width < 0) {
                let nadjustable = 0;
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy != "fixed")
                        nadjustable++;
                }
                let overflow_width = -available_width;
                for (let x = 0; x < ncols; x++) {
                    const col = cols[x];
                    if (col.policy != "fixed") {
                        const width = preferred.col_widths[x];
                        const cutoff = round(overflow_width / nadjustable);
                        preferred.col_widths[x] = max(width - cutoff, 0);
                        overflow_width -= cutoff > width ? width : cutoff;
                        nadjustable--;
                    }
                }
            }
            const { row_heights, col_widths, size_hints } = this._measure_cells((y, x) => {
                return {
                    width: preferred.col_widths[x],
                    height: preferred.row_heights[y],
                };
            });
            const size = this._measure_totals(row_heights, col_widths);
            return { size, row_heights, col_widths, size_hints };
        }
        _measure(viewport) {
            const { size } = this._measure_grid(viewport);
            return size;
        }
        _set_geometry(outer, inner) {
            super._set_geometry(outer, inner);
            const { nrows, ncols, rspacing, cspacing } = this._state;
            const { row_heights, col_widths, size_hints } = this._measure_grid(outer);
            const rows = this._state.rows.map((row, r) => {
                return Object.assign(Object.assign({}, row), { top: 0, height: row_heights[r], get bottom() { return this.top + this.height; } });
            });
            const cols = this._state.cols.map((col, c) => {
                return Object.assign(Object.assign({}, col), { left: 0, width: col_widths[c], get right() { return this.left + this.width; } });
            });
            const items = size_hints.map((_, item) => {
                return Object.assign(Object.assign({}, item), { outer: new bbox_1.BBox(), inner: new bbox_1.BBox() });
            });
            for (let r = 0, top = !this.absolute ? 0 : outer.top; r < nrows; r++) {
                const row = rows[r];
                row.top = top;
                top += row.height + rspacing;
            }
            for (let c = 0, left = !this.absolute ? 0 : outer.left; c < ncols; c++) {
                const col = cols[c];
                col.left = left;
                left += col.width + cspacing;
            }
            function span_width(c0, c1) {
                let width = (c1 - c0) * cspacing;
                for (let c = c0; c <= c1; c++) {
                    width += cols[c].width;
                }
                return width;
            }
            function span_height(r0, r1) {
                let height = (r1 - r0) * rspacing;
                for (let r = r0; r <= r1; r++) {
                    height += rows[r].height;
                }
                return height;
            }
            items.foreach(({ r0, c0, r1, c1 }, item) => {
                const { layout, size_hint } = item;
                const { sizing } = layout;
                const { width, height } = size_hint;
                const span = {
                    width: span_width(c0, c1),
                    height: span_height(r0, r1),
                };
                const halign = c0 == c1 && cols[c0].align != "auto" ? cols[c0].align : sizing.halign;
                const valign = r0 == r1 && rows[r0].align != "auto" ? rows[r0].align : sizing.valign;
                let left = cols[c0].left;
                if (halign == "start")
                    left += sizing.margin.left;
                else if (halign == "center")
                    left += round((span.width - width) / 2);
                else if (halign == "end")
                    left += span.width - sizing.margin.right - width;
                let top = rows[r0].top;
                if (valign == "start")
                    top += sizing.margin.top;
                else if (valign == "center")
                    top += round((span.height - height) / 2);
                else if (valign == "end")
                    top += span.height - sizing.margin.bottom - height;
                item.outer = new bbox_1.BBox({ left, top, width, height });
            });
            const row_aligns = rows.map(() => {
                return {
                    start: new DefaultMap(() => 0),
                    end: new DefaultMap(() => 0),
                };
            });
            const col_aligns = cols.map(() => {
                return {
                    start: new DefaultMap(() => 0),
                    end: new DefaultMap(() => 0),
                };
            });
            items.foreach(({ r0, c0, r1, c1 }, { size_hint, outer }) => {
                const { inner } = size_hint;
                if (inner != null) {
                    row_aligns[r0].start.apply(outer.top, (v) => max(v, inner.top));
                    row_aligns[r1].end.apply(rows[r1].bottom - outer.bottom, (v) => max(v, inner.bottom));
                    col_aligns[c0].start.apply(outer.left, (v) => max(v, inner.left));
                    col_aligns[c1].end.apply(cols[c1].right - outer.right, (v) => max(v, inner.right));
                }
            });
            items.foreach(({ r0, c0, r1, c1 }, item) => {
                const { size_hint, outer } = item;
                const inner_bbox = (extents) => {
                    const outer_bbox = this.absolute ? outer : outer.relative();
                    const left = outer_bbox.left + extents.left;
                    const top = outer_bbox.top + extents.top;
                    const right = outer_bbox.right - extents.right;
                    const bottom = outer_bbox.bottom - extents.bottom;
                    return new bbox_1.BBox({ left, top, right, bottom });
                };
                if (size_hint.inner != null) {
                    let inner = inner_bbox(size_hint.inner);
                    //if (size_hint.align !== false) {
                    const top = row_aligns[r0].start.get(outer.top);
                    const bottom = row_aligns[r1].end.get(rows[r1].bottom - outer.bottom);
                    const left = col_aligns[c0].start.get(outer.left);
                    const right = col_aligns[c1].end.get(cols[c1].right - outer.right);
                    try {
                        inner = inner_bbox({ top, bottom, left, right });
                    }
                    catch (_a) { }
                    //}
                    item.inner = inner;
                }
                else
                    item.inner = outer;
            });
            items.foreach((_, { layout, outer, inner }) => {
                layout.set_geometry(outer, inner);
            });
        }
    }
    exports.Grid = Grid;
    Grid.__name__ = "Grid";
    class Row extends Grid {
        constructor(items) {
            super();
            this.items = items.map((item, i) => ({ layout: item, row: 0, col: i }));
            this.rows = "fit";
        }
    }
    exports.Row = Row;
    Row.__name__ = "Row";
    class Column extends Grid {
        constructor(items) {
            super();
            this.items = items.map((item, i) => ({ layout: item, row: i, col: 0 }));
            this.cols = "fit";
        }
    }
    exports.Column = Column;
    Column.__name__ = "Column";
},
/* core/layout/border.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const types_1 = require(145) /* ./types */;
    const layoutable_1 = require(146) /* ./layoutable */;
    const bbox_1 = require(57) /* ../util/bbox */;
    class BorderLayout extends layoutable_1.Layoutable {
        constructor() {
            super(...arguments);
            this.aligns = { left: true, right: true, top: true, bottom: true };
            this.min_border = { left: 0, top: 0, right: 0, bottom: 0 };
            this.padding = { left: 0, top: 0, right: 0, bottom: 0 };
            this.center_border_width = 0;
        }
        *[Symbol.iterator]() {
            yield this.top_panel;
            yield this.bottom_panel;
            yield this.left_panel;
            yield this.right_panel;
            yield this.center_panel;
        }
        _measure(viewport) {
            viewport = new types_1.Sizeable({
                width: this.sizing.width_policy == "fixed" || viewport.width == Infinity ? this.sizing.width : viewport.width,
                height: this.sizing.height_policy == "fixed" || viewport.height == Infinity ? this.sizing.height : viewport.height,
            });
            const left_hint = this.left_panel.measure({ width: 0, height: viewport.height });
            const left = Math.max(left_hint.width, this.min_border.left) + this.padding.left;
            const right_hint = this.right_panel.measure({ width: 0, height: viewport.height });
            const right = Math.max(right_hint.width, this.min_border.right) + this.padding.right;
            const top_hint = this.top_panel.measure({ width: viewport.width, height: 0 });
            const top = Math.max(top_hint.height, this.min_border.top) + this.padding.top;
            const bottom_hint = this.bottom_panel.measure({ width: viewport.width, height: 0 });
            const bottom = Math.max(bottom_hint.height, this.min_border.bottom) + this.padding.bottom;
            const center_viewport = new types_1.Sizeable(viewport).shrink_by({ left, right, top, bottom });
            const center = this.center_panel.measure(center_viewport);
            const width = left + center.width + right;
            const height = top + center.height + bottom;
            const align = (() => {
                const { width_policy, height_policy } = this.center_panel.sizing;
                return Object.assign(Object.assign({}, this.aligns), { fixed_width: width_policy == "fixed", fixed_height: height_policy == "fixed" });
            })();
            return { width, height, inner: { left, right, top, bottom }, align };
        }
        _set_geometry(outer, inner) {
            var _a, _b, _c, _d;
            super._set_geometry(outer, inner);
            if (this.sizing.visible) {
                this.center_panel.set_geometry(inner);
                const left_hint = this.left_panel.measure({ width: 0, height: outer.height });
                const right_hint = this.right_panel.measure({ width: 0, height: outer.height });
                const top_hint = this.top_panel.measure({ width: outer.width, height: 0 });
                const bottom_hint = this.bottom_panel.measure({ width: outer.width, height: 0 });
                const { left, top, right, bottom } = inner;
                this.top_panel.set_geometry(new bbox_1.BBox({ left, right, bottom: top, height: top_hint.height }));
                this.bottom_panel.set_geometry(new bbox_1.BBox({ left, right, top: bottom, height: bottom_hint.height }));
                this.left_panel.set_geometry(new bbox_1.BBox({ top, bottom, right: left, width: left_hint.width }));
                this.right_panel.set_geometry(new bbox_1.BBox({ top, bottom, left: right, width: right_hint.width }));
                const adjusted_inner = inner.shrink_by(this.center_border_width);
                if (this.inner_top_panel != null) {
                    const { left, right, top, width } = adjusted_inner;
                    const inner_top_hint = this.inner_top_panel.measure({ width, height: 0 });
                    this.inner_top_panel.set_geometry(new bbox_1.BBox({ left, right, top, height: inner_top_hint.height }));
                }
                if (this.inner_bottom_panel != null) {
                    const { left, right, bottom, width } = adjusted_inner;
                    const inner_bottom_hint = this.inner_bottom_panel.measure({ width, height: 0 });
                    this.inner_bottom_panel.set_geometry(new bbox_1.BBox({ left, right, bottom, height: inner_bottom_hint.height }));
                }
                if (this.inner_left_panel != null) {
                    const { top, bottom, left, height } = adjusted_inner;
                    const inner_left_hint = this.inner_left_panel.measure({ width: 0, height });
                    this.inner_left_panel.set_geometry(new bbox_1.BBox({ top, bottom, left, width: inner_left_hint.width }));
                }
                if (this.inner_right_panel != null) {
                    const { top, bottom, right, height } = adjusted_inner;
                    const inner_right_hint = this.inner_right_panel.measure({ width: 0, height });
                    this.inner_right_panel.set_geometry(new bbox_1.BBox({ top, bottom, right, width: inner_right_hint.width }));
                }
            }
            else {
                this.center_panel.set_geometry(new bbox_1.BBox());
                this.top_panel.set_geometry(new bbox_1.BBox());
                this.bottom_panel.set_geometry(new bbox_1.BBox());
                this.left_panel.set_geometry(new bbox_1.BBox());
                this.right_panel.set_geometry(new bbox_1.BBox());
                (_a = this.inner_top_panel) === null || _a === void 0 ? void 0 : _a.set_geometry(new bbox_1.BBox());
                (_b = this.inner_bottom_panel) === null || _b === void 0 ? void 0 : _b.set_geometry(new bbox_1.BBox());
                (_c = this.inner_left_panel) === null || _c === void 0 ? void 0 : _c.set_geometry(new bbox_1.BBox());
                (_d = this.inner_right_panel) === null || _d === void 0 ? void 0 : _d.set_geometry(new bbox_1.BBox());
            }
        }
    }
    exports.BorderLayout = BorderLayout;
    BorderLayout.__name__ = "BorderLayout";
},
/* models/annotations/band.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const upper_lower_1 = require(231) /* ./upper_lower */;
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    class BandView extends upper_lower_1.UpperLowerView {
        paint(ctx) {
            // Draw the band body
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (let i = this._upper_sx.length - 1; i >= 0; i--) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            ctx.closePath();
            this.visuals.fill.apply(ctx);
            // Draw the lower band edge
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            this.visuals.line.apply(ctx);
            // Draw the upper band edge
            ctx.beginPath();
            ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
            for (let i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            this.visuals.line.apply(ctx);
        }
    }
    exports.BandView = BandView;
    BandView.__name__ = "BandView";
    class Band extends upper_lower_1.UpperLower {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.Band = Band;
    _a = Band;
    Band.__name__ = "Band";
    (() => {
        _a.prototype.default_view = BandView;
        _a.mixins([mixins.Line, mixins.Fill]);
        _a.override({
            fill_color: "#fff9ba",
            fill_alpha: 0.4,
            line_color: "#cccccc",
            line_alpha: 0.3,
        });
    })();
},
/* models/annotations/upper_lower.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const data_annotation_1 = require(98) /* ./data_annotation */;
    const types_1 = require(23) /* ../../core/types */;
    const enums_1 = require(19) /* ../../core/enums */;
    const p = tslib_1.__importStar(require(17) /* ../../core/properties */);
    class UpperLowerView extends data_annotation_1.DataAnnotationView {
        map_data() {
            const { frame } = this.plot_view;
            const dim = this.model.dimension;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const limit_scale = dim == "height" ? yscale : xscale;
            const base_scale = dim == "height" ? xscale : yscale;
            const limit_view = dim == "height" ? frame.bbox.yview : frame.bbox.xview;
            const base_view = dim == "height" ? frame.bbox.xview : frame.bbox.yview;
            const _lower_sx = (() => {
                switch (this.model.properties.lower.units) {
                    case "canvas":
                        return new types_1.ScreenArray(this._lower);
                    case "screen":
                        return limit_view.v_compute(this._lower);
                    case "data":
                        return limit_scale.v_compute(this._lower);
                }
            })();
            const _upper_sx = (() => {
                switch (this.model.properties.upper.units) {
                    case "canvas":
                        return new types_1.ScreenArray(this._upper);
                    case "screen":
                        return limit_view.v_compute(this._upper);
                    case "data":
                        return limit_scale.v_compute(this._upper);
                }
            })();
            const _base_sx = (() => {
                switch (this.model.properties.base.units) {
                    case "canvas":
                        return new types_1.ScreenArray(this._base);
                    case "screen":
                        return base_view.v_compute(this._base);
                    case "data":
                        return base_scale.v_compute(this._base);
                }
            })();
            const [i, j] = dim == "height" ? [1, 0] : [0, 1];
            const _lower = [_lower_sx, _base_sx];
            const _upper = [_upper_sx, _base_sx];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        }
    }
    exports.UpperLowerView = UpperLowerView;
    UpperLowerView.__name__ = "UpperLowerView";
    class XOrYCoordinateSpec extends p.CoordinateSpec {
        constructor() {
            super(...arguments);
            this._value = p.unset;
        }
        get dimension() {
            return this.obj.dimension == "width" ? "x" : "y";
        }
        // XXX: a hack to make a coordinate & unit spec
        get units() {
            var _b;
            return this._value === p.unset ? "data" : (_b = this._value.units) !== null && _b !== void 0 ? _b : "data";
        }
    }
    exports.XOrYCoordinateSpec = XOrYCoordinateSpec;
    XOrYCoordinateSpec.__name__ = "XOrYCoordinateSpec";
    class UpperLower extends data_annotation_1.DataAnnotation {
        constructor(attrs) {
            super(attrs);
        }
    }
    exports.UpperLower = UpperLower;
    _a = UpperLower;
    UpperLower.__name__ = "UpperLower";
    (() => {
        _a.define(() => ({
            dimension: [enums_1.Dimension, "height"],
            lower: [XOrYCoordinateSpec, { field: "lower" }],
            upper: [XOrYCoordinateSpec, { field: "upper" }],
            base: [XOrYCoordinateSpec, { field: "base" }],
        }));
    })();
},
/* models/annotations/box_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    const tslib_1 = require(1) /* tslib */;
    var _a;
    const annotation_1 = require(73) /* ./annotation */;
    const mixins = tslib_1.__importStar(require(78) /* ../../core/property_mixins */);
    const enums_1 = require(19) /* ../../core/enums */;
    const bbox_1 = require(57) /* ../../core/util/bbox */;
    exports.EDGE_TOLERANCE = 2.5;
    class BoxAnnotationView extends annotation_1.AnnotationView {
        constructor() {
            super(...arguments);
            this.bbox = new bbox_1.BBox();
        }
        connect_signals() {
            super.connect_signals();
            this.connect(this.model.change, () => this.request_render());
        }
        _render() {
            const { left, right, top, bottom } = this.model;
            const { frame } = this.plot_view;
            const xscale = this.coordinates.x_scale;
            const yscale = this.coordinates.y_scale;
            const _calc_dim = (dim, dim_units, scale, view, frame_extrema) => {
                if (dim == null)
                    return frame_extrema;
                else {
                    switch (dim_units) {
                        case "canvas":
                            return dim;
                        case "screen":
                            return view.compute(dim);
                        case "data":
                            return scale.compute(dim);
                    }
                }
            };
            this.bbox = bbox_1.BBox.from_lrtb({
                left: _calc_dim(left, this.model.left_units, xscale, frame.bbox.xview, frame.bbox.left),
                right: _calc_dim(right, this.model.right_units, xscale, frame.bbox.xview, frame.bbox.right),
                top: _calc_dim(top, this.model.top_units, yscale, frame.bbox.yview, frame.bbox.top),
                bottom: _calc_dim(bottom, this.model.bottom_units, yscale, frame.bbox.yview, frame.bbox.bottom),
            });
            this._paint_box();
        }
        _paint_box() {
            const { ctx } = this.layer;
            ctx.save();
            const { left, top, width, height } = this.bbox;
            ctx.beginPath();
            ctx.rect(left, top, width, height);
            this.visuals.fill.apply(ctx);
            this.visuals.hatch.apply(ctx);
            this.visuals.line.apply(ctx);
            ctx.restore();
        }
        interactive_bbox() {
            const tolerance = this.model.line_width + exports.EDGE_TOLERANCE;
            return this.bbox.grow_by(tolerance);
        }
        interactive_hit(sx, sy) {
            if (this.model.in_cursor == null)
                return false;
            const bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        }
        cursor(sx, sy) {
            const tol = 3;
            const { left, right, bottom, top } = this.bbox;
            if (Math.abs(sx - left) < tol || Math.abs(sx - right) < tol)
                return this.model.ew_cursor;
            else if (Math.abs(sy - bottom) < tol || Math.abs(sy - top) < tol)
                return this.model.ns_cursor;
            else if (this.bbox.contains(sx, sy))
                return this.model.in_cursor;
            else
                return null;
        }
    }
    exports.BoxAnnotationView = BoxAnnotationView;
    BoxAnnotationView.__name__ = "BoxAnnotationView";
    class BoxAnnotation extends annotation_1.Annotation {
        constructor(attrs) {
            super(attrs);
        }
        update({ left, right, top, bottom }) {
            this.setv({ left, right, top, bottom, visible: true });
        }
        clear() {
            this.visible = false;
        }
    }
    exports.BoxAnnotation = BoxAnnotation;
    _a = BoxAnnotation;
    BoxAnnotation.__name__ = "BoxAnnotation";
    (() => {
        _a.prototype.default_view = BoxAnnotationView;
        _a.mixins([mixins.Line, mixins.Fill, mixins.Hatch]);
        _a.define(({ Number, Nullable }) => ({
            top: [Nullable(Number), null],
            bottom: [Nullable(Number), null],
            left: [Nullable(Number), null],
            right: [Nullable(Number), null],
            top_units: [enums_1.CoordinateUnits, "data"],
            bottom_units: [enums_1.CoordinateUnits, "data"],
            left_units: [enums_1.CoordinateUnits, "data"],
            right_units: [enums_1.CoordinateUnits, "data"],
        }));
        _a.internal(({ String, Nullable }) => ({
            ew_cursor: [Nullable(String), null],
            ns_cursor: [Nullable(String), null],
            in_cursor: [Nullable(String), null],
        }));
        _a.override({
            fill_color: "#ff