# Generated by Django 3.2.13 on 2022-06-23 12:32

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import huscy.project_design.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('projects', '0002_alter_membership_options'),
    ]

    operations = [
        migrations.CreateModel(
            name='DataAcquisitionMethod',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveSmallIntegerField()),
                ('type', models.CharField(choices=[('behav', 'Behavioral'), ('bio', 'Biological samples'), ('eeg', 'Electroencephalography'), ('meg', 'Magnetoencephalography'), ('micro', 'Microscopy data'), ('mri', 'Magnetic resonance imaging'), ('nirs', 'Near-Infrared Spectroscopy'), ('pause', 'Pause'), ('pet', 'Positron-emission tomography'), ('phys', 'Physiological measures'), ('quest', 'Questionnaire'), ('screen', 'Screening')], max_length=16)),
                ('location', models.CharField(max_length=126)),
            ],
        ),
        migrations.CreateModel(
            name='Experiment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64)),
                ('description', models.TextField(blank=True, default='')),
                ('order', models.PositiveSmallIntegerField()),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='experiments', to='projects.project')),
            ],
        ),
        migrations.CreateModel(
            name='Stimulus',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.PositiveSmallIntegerField(choices=[(0, 'auditive'), (1, 'gustatory'), (2, 'haptic'), (3, 'olfactory'), (4, 'visual')])),
            ],
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64)),
                ('order', models.PositiveSmallIntegerField()),
                ('setup_time', models.DurationField(default=datetime.timedelta(0))),
                ('duration', models.DurationField()),
                ('teardown_time', models.DurationField(default=datetime.timedelta(0))),
                ('max_number_of_participants', models.PositiveIntegerField(default=1)),
                ('experiment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sessions', to='project_design.experiment')),
                ('operator', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Screening',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='screenings', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='Questionnaire',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filehandle', models.FileField(upload_to=huscy.project_design.models.Questionnaire.get_upload_path)),
                ('filename', models.CharField(max_length=255)),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('uploaded_by', models.CharField(editable=False, max_length=128)),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questionnaires', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='Physiological',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='physiologicals', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='PET',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pet', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='Pause',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pause', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='NIRS',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='nirs', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='MRI',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='mri', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='Microscopy',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='microscopys', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='MEG',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='meg', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='EEG',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='eeg', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.AddField(
            model_name='dataacquisitionmethod',
            name='session',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='project_design.session'),
        ),
        migrations.AddField(
            model_name='dataacquisitionmethod',
            name='stimulus',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='project_design.stimulus'),
        ),
        migrations.CreateModel(
            name='Biological',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='biologicals', to='project_design.dataacquisitionmethod')),
            ],
        ),
        migrations.CreateModel(
            name='Behavioral',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='behaviorals', to='project_design.dataacquisitionmethod')),
            ],
        ),
    ]
