import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::IoTWireless::Destination`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html
 * @external
 */
export interface CfnDestinationProps {
    /**
     * `AWS::IoTWireless::Destination.Expression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-expression
     * @external
     */
    readonly expression: string;
    /**
     * `AWS::IoTWireless::Destination.ExpressionType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-expressiontype
     * @external
     */
    readonly expressionType: string;
    /**
     * `AWS::IoTWireless::Destination.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::IoTWireless::Destination.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::IoTWireless::Destination.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::IoTWireless::Destination.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-nexttoken
     * @external
     */
    readonly nextToken?: string;
    /**
     * `AWS::IoTWireless::Destination.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTWireless::Destination`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html
 * @external
 * @cloudformationResource AWS::IoTWireless::Destination
 */
export declare class CfnDestination extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::Destination";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDestination;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::IoTWireless::Destination.Expression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-expression
     * @external
     */
    expression: string;
    /**
     * `AWS::IoTWireless::Destination.ExpressionType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-expressiontype
     * @external
     */
    expressionType: string;
    /**
     * `AWS::IoTWireless::Destination.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-name
     * @external
     */
    name: string;
    /**
     * `AWS::IoTWireless::Destination.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::IoTWireless::Destination.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::IoTWireless::Destination.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-nexttoken
     * @external
     */
    nextToken: string | undefined;
    /**
     * `AWS::IoTWireless::Destination.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTWireless::Destination`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDestinationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoTWireless::DeviceProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html
 * @external
 */
export interface CfnDeviceProfileProps {
    /**
     * `AWS::IoTWireless::DeviceProfile.LoRaWANDeviceProfile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile
     * @external
     */
    readonly loRaWanDeviceProfile?: CfnDeviceProfile.LoRaWANDeviceProfileProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::DeviceProfile.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::IoTWireless::DeviceProfile.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-nexttoken
     * @external
     */
    readonly nextToken?: string;
    /**
     * `AWS::IoTWireless::DeviceProfile.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTWireless::DeviceProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html
 * @external
 * @cloudformationResource AWS::IoTWireless::DeviceProfile
 */
export declare class CfnDeviceProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::DeviceProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeviceProfile;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoTWireless::DeviceProfile.LoRaWANDeviceProfile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile
     * @external
     */
    loRaWanDeviceProfile: CfnDeviceProfile.LoRaWANDeviceProfileProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTWireless::DeviceProfile.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::IoTWireless::DeviceProfile.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-nexttoken
     * @external
     */
    nextToken: string | undefined;
    /**
     * `AWS::IoTWireless::DeviceProfile.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTWireless::DeviceProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDeviceProfileProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTWireless::DeviceProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html
 * @external
 * @cloudformationResource AWS::IoTWireless::DeviceProfile
 */
export declare namespace CfnDeviceProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html
     * @external
     */
    interface LoRaWANDeviceProfileProperty {
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.ClassBTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-classbtimeout
         * @external
         */
        readonly classBTimeout?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.ClassCTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-classctimeout
         * @external
         */
        readonly classCTimeout?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.MacVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-macversion
         * @external
         */
        readonly macVersion?: string;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.MaxDutyCycle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-maxdutycycle
         * @external
         */
        readonly maxDutyCycle?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.MaxEirp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-maxeirp
         * @external
         */
        readonly maxEirp?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.PingSlotDr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotdr
         * @external
         */
        readonly pingSlotDr?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.PingSlotFreq`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotfreq
         * @external
         */
        readonly pingSlotFreq?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.PingSlotPeriod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotperiod
         * @external
         */
        readonly pingSlotPeriod?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.RegParamsRevision`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-regparamsrevision
         * @external
         */
        readonly regParamsRevision?: string;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.RfRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rfregion
         * @external
         */
        readonly rfRegion?: string;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.Supports32BitFCnt`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supports32bitfcnt
         * @external
         */
        readonly supports32BitFCnt?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.SupportsClassB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsclassb
         * @external
         */
        readonly supportsClassB?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.SupportsClassC`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsclassc
         * @external
         */
        readonly supportsClassC?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.SupportsJoin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsjoin
         * @external
         */
        readonly supportsJoin?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::IoTWireless::ServiceProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html
 * @external
 */
export interface CfnServiceProfileProps {
    /**
     * `AWS::IoTWireless::ServiceProfile.LoRaWANGetServiceProfileInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo
     * @external
     */
    readonly loRaWanGetServiceProfileInfo?: CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::ServiceProfile.LoRaWANServiceProfile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile
     * @external
     */
    readonly loRaWanServiceProfile?: CfnServiceProfile.LoRaWANServiceProfileProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::ServiceProfile.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::IoTWireless::ServiceProfile.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-nexttoken
     * @external
     */
    readonly nextToken?: string;
    /**
     * `AWS::IoTWireless::ServiceProfile.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTWireless::ServiceProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html
 * @external
 * @cloudformationResource AWS::IoTWireless::ServiceProfile
 */
export declare class CfnServiceProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::ServiceProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnServiceProfile;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoTWireless::ServiceProfile.LoRaWANGetServiceProfileInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo
     * @external
     */
    loRaWanGetServiceProfileInfo: CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTWireless::ServiceProfile.LoRaWANServiceProfile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile
     * @external
     */
    loRaWanServiceProfile: CfnServiceProfile.LoRaWANServiceProfileProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTWireless::ServiceProfile.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::IoTWireless::ServiceProfile.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-nexttoken
     * @external
     */
    nextToken: string | undefined;
    /**
     * `AWS::IoTWireless::ServiceProfile.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTWireless::ServiceProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnServiceProfileProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTWireless::ServiceProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html
 * @external
 * @cloudformationResource AWS::IoTWireless::ServiceProfile
 */
export declare namespace CfnServiceProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html
     * @external
     */
    interface LoRaWANGetServiceProfileInfoProperty {
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.AddGwMetadata`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-addgwmetadata
         * @external
         */
        readonly addGwMetadata?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.ChannelMask`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-channelmask
         * @external
         */
        readonly channelMask?: string;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.DevStatusReqFreq`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-devstatusreqfreq
         * @external
         */
        readonly devStatusReqFreq?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.DlBucketSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-dlbucketsize
         * @external
         */
        readonly dlBucketSize?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.DlRate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-dlrate
         * @external
         */
        readonly dlRate?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.DlRatePolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-dlratepolicy
         * @external
         */
        readonly dlRatePolicy?: string;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.DrMax`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-drmax
         * @external
         */
        readonly drMax?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.DrMin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-drmin
         * @external
         */
        readonly drMin?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.HrAllowed`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-hrallowed
         * @external
         */
        readonly hrAllowed?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.MinGwDiversity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-mingwdiversity
         * @external
         */
        readonly minGwDiversity?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.NwkGeoLoc`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-nwkgeoloc
         * @external
         */
        readonly nwkGeoLoc?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.PrAllowed`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-prallowed
         * @external
         */
        readonly prAllowed?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.RaAllowed`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-raallowed
         * @external
         */
        readonly raAllowed?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.ReportDevStatusBattery`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-reportdevstatusbattery
         * @external
         */
        readonly reportDevStatusBattery?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.ReportDevStatusMargin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-reportdevstatusmargin
         * @external
         */
        readonly reportDevStatusMargin?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.TargetPer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-targetper
         * @external
         */
        readonly targetPer?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.UlBucketSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-ulbucketsize
         * @external
         */
        readonly ulBucketSize?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.UlRate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-ulrate
         * @external
         */
        readonly ulRate?: number;
        /**
         * `CfnServiceProfile.LoRaWANGetServiceProfileInfoProperty.UlRatePolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawangetserviceprofileinfo.html#cfn-iotwireless-serviceprofile-lorawangetserviceprofileinfo-ulratepolicy
         * @external
         */
        readonly ulRatePolicy?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::ServiceProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html
 * @external
 * @cloudformationResource AWS::IoTWireless::ServiceProfile
 */
export declare namespace CfnServiceProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html
     * @external
     */
    interface LoRaWANServiceProfileProperty {
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.AddGwMetadata`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-addgwmetadata
         * @external
         */
        readonly addGwMetadata?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 */
export interface CfnWirelessDeviceProps {
    /**
     * `AWS::IoTWireless::WirelessDevice.DestinationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-destinationname
     * @external
     */
    readonly destinationName: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.LoRaWANDevice`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lorawandevice
     * @external
     */
    readonly loRaWanDevice?: CfnWirelessDevice.LoRaWANDeviceProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::WirelessDevice.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-nexttoken
     * @external
     */
    readonly nextToken?: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 */
export declare class CfnWirelessDevice extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::WirelessDevice";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWirelessDevice;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute ThingArn
     */
    readonly attrThingArn: string;
    /**
     * @external
     * @cloudformationAttribute ThingName
     */
    readonly attrThingName: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.DestinationName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-destinationname
     * @external
     */
    destinationName: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-type
     * @external
     */
    type: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessDevice.LoRaWANDevice`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lorawandevice
     * @external
     */
    loRaWanDevice: CfnWirelessDevice.LoRaWANDeviceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTWireless::WirelessDevice.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessDevice.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-nexttoken
     * @external
     */
    nextToken: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessDevice.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTWireless::WirelessDevice`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWirelessDeviceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 */
export declare namespace CfnWirelessDevice {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv10x.html
     * @external
     */
    interface AbpV10XProperty {
        /**
         * `CfnWirelessDevice.AbpV10XProperty.DevAddr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv10x.html#cfn-iotwireless-wirelessdevice-abpv10x-devaddr
         * @external
         */
        readonly devAddr: string;
        /**
         * `CfnWirelessDevice.AbpV10XProperty.SessionKeys`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv10x.html#cfn-iotwireless-wirelessdevice-abpv10x-sessionkeys
         * @external
         */
        readonly sessionKeys: CfnWirelessDevice.SessionKeysAbpV10XProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 */
export declare namespace CfnWirelessDevice {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv11.html
     * @external
     */
    interface AbpV11Property {
        /**
         * `CfnWirelessDevice.AbpV11Property.DevAddr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv11.html#cfn-iotwireless-wirelessdevice-abpv11-devaddr
         * @external
         */
        readonly devAddr: string;
        /**
         * `CfnWirelessDevice.AbpV11Property.SessionKeys`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv11.html#cfn-iotwireless-wirelessdevice-abpv11-sessionkeys
         * @external
         */
        readonly sessionKeys: CfnWirelessDevice.SessionKeysAbpV11Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 */
export declare namespace CfnWirelessDevice {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html
     * @external
     */
    interface LoRaWANDeviceProperty {
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.AbpV10X`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-abpv10x
         * @external
         */
        readonly abpV10X?: CfnWirelessDevice.AbpV10XProperty | cdk.IResolvable;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.AbpV11`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-abpv11
         * @external
         */
        readonly abpV11?: CfnWirelessDevice.AbpV11Property | cdk.IResolvable;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.DevEui`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-deveui
         * @external
         */
        readonly devEui?: string;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.DeviceProfileId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-deviceprofileid
         * @external
         */
        readonly deviceProfileId?: string;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.OtaaV10X`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-otaav10x
         * @external
         */
        readonly otaaV10X?: CfnWirelessDevice.OtaaV10XProperty | cdk.IResolvable;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.OtaaV11`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-otaav11
         * @external
         */
        readonly otaaV11?: CfnWirelessDevice.OtaaV11Property | cdk.IResolvable;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.ServiceProfileId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-serviceprofileid
         * @external
         */
        readonly serviceProfileId?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 */
export declare namespace CfnWirelessDevice {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav10x.html
     * @external
     */
    interface OtaaV10XProperty {
        /**
         * `CfnWirelessDevice.OtaaV10XProperty.AppEui`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav10x.html#cfn-iotwireless-wirelessdevice-otaav10x-appeui
         * @external
         */
        readonly appEui: string;
        /**
         * `CfnWirelessDevice.OtaaV10XProperty.AppKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav10x.html#cfn-iotwireless-wirelessdevice-otaav10x-appkey
         * @external
         */
        readonly appKey: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 */
export declare namespace CfnWirelessDevice {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav11.html
     * @external
     */
    interface OtaaV11Property {
        /**
         * `CfnWirelessDevice.OtaaV11Property.AppKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav11.html#cfn-iotwireless-wirelessdevice-otaav11-appkey
         * @external
         */
        readonly appKey: string;
        /**
         * `CfnWirelessDevice.OtaaV11Property.JoinEui`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav11.html#cfn-iotwireless-wirelessdevice-otaav11-joineui
         * @external
         */
        readonly joinEui: string;
        /**
         * `CfnWirelessDevice.OtaaV11Property.NwkKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav11.html#cfn-iotwireless-wirelessdevice-otaav11-nwkkey
         * @external
         */
        readonly nwkKey: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 */
export declare namespace CfnWirelessDevice {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv10x.html
     * @external
     */
    interface SessionKeysAbpV10XProperty {
        /**
         * `CfnWirelessDevice.SessionKeysAbpV10XProperty.AppSKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv10x.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv10x-appskey
         * @external
         */
        readonly appSKey: string;
        /**
         * `CfnWirelessDevice.SessionKeysAbpV10XProperty.NwkSKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv10x.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv10x-nwkskey
         * @external
         */
        readonly nwkSKey: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 */
export declare namespace CfnWirelessDevice {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html
     * @external
     */
    interface SessionKeysAbpV11Property {
        /**
         * `CfnWirelessDevice.SessionKeysAbpV11Property.AppSKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv11-appskey
         * @external
         */
        readonly appSKey: string;
        /**
         * `CfnWirelessDevice.SessionKeysAbpV11Property.FNwkSIntKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv11-fnwksintkey
         * @external
         */
        readonly fNwkSIntKey: string;
        /**
         * `CfnWirelessDevice.SessionKeysAbpV11Property.NwkSEncKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv11-nwksenckey
         * @external
         */
        readonly nwkSEncKey: string;
        /**
         * `CfnWirelessDevice.SessionKeysAbpV11Property.SNwkSIntKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv11-snwksintkey
         * @external
         */
        readonly sNwkSIntKey: string;
    }
}
/**
 * Properties for defining a `AWS::IoTWireless::WirelessGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html
 * @external
 */
export interface CfnWirelessGatewayProps {
    /**
     * `AWS::IoTWireless::WirelessGateway.LoRaWANGateway`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-lorawangateway
     * @external
     */
    readonly loRaWanGateway: CfnWirelessGateway.LoRaWANGatewayProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::WirelessGateway.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::IoTWireless::WirelessGateway.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::IoTWireless::WirelessGateway.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-nexttoken
     * @external
     */
    readonly nextToken?: string;
    /**
     * `AWS::IoTWireless::WirelessGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::IoTWireless::WirelessGateway.ThingName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-thingname
     * @external
     */
    readonly thingName?: string;
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessGateway
 */
export declare class CfnWirelessGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::WirelessGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWirelessGateway;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute ThingArn
     */
    readonly attrThingArn: string;
    /**
     * `AWS::IoTWireless::WirelessGateway.LoRaWANGateway`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-lorawangateway
     * @external
     */
    loRaWanGateway: CfnWirelessGateway.LoRaWANGatewayProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::WirelessGateway.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessGateway.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessGateway.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-nexttoken
     * @external
     */
    nextToken: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessGateway.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::IoTWireless::WirelessGateway.ThingName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-thingname
     * @external
     */
    thingName: string | undefined;
    /**
     * Create a new `AWS::IoTWireless::WirelessGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWirelessGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessGateway`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessGateway
 */
export declare namespace CfnWirelessGateway {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessgateway-lorawangateway.html
     * @external
     */
    interface LoRaWANGatewayProperty {
        /**
         * `CfnWirelessGateway.LoRaWANGatewayProperty.GatewayEui`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessgateway-lorawangateway.html#cfn-iotwireless-wirelessgateway-lorawangateway-gatewayeui
         * @external
         */
        readonly gatewayEui: string;
        /**
         * `CfnWirelessGateway.LoRaWANGatewayProperty.RfRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessgateway-lorawangateway.html#cfn-iotwireless-wirelessgateway-lorawangateway-rfregion
         * @external
         */
        readonly rfRegion: string;
    }
}
