# generated by datamodel-codegen:
#   filename:  model.json
#   timestamp: 2021-04-11T02:21:44+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import List, Optional
from uuid import UUID

from pydantic import AnyUrl, BaseModel, Field


class Interval(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    year = 'year'


class ProductType(Enum):
    DISCORD_ROLE = 'DISCORD_ROLE'
    SHOP_PRODUCT = 'SHOP_PRODUCT'


class Product(BaseModel):
    uuid: Optional[UUID] = None
    checkout_uri: Optional[AnyUrl] = Field(None, description='Direct Link to Product')
    name: Optional[str] = None
    account_id: Optional[float] = None
    price: Optional[float] = None
    interval: Optional[Interval] = None
    interval_count: Optional[int] = None
    free_trial_length: Optional[float] = None
    description: Optional[str] = None
    image_link: Optional[str] = None
    variable_price: Optional[bool] = None
    is_time_limited: Optional[bool] = None
    limited_inventory: Optional[bool] = None
    available_stock: Optional[float] = None
    shippable: Optional[bool] = None
    paymentless_trial: Optional[bool] = None
    product_types: Optional[List[ProductType]] = None
    created: Optional[datetime] = None
    updated: Optional[datetime] = None
    deleted: Optional[datetime] = None

class Model(BaseModel):
    data: Product

    def __str__(self):
        return f"<Product {self.data.uuid}>"
