import torchvision
import numpy as np
import torch
import sys


if sys.version_info < (3, 6):
    sys.exit('Sorry, For Lightwood Python < 3.6 is not supported')

from lightwood.__about__ import __package_name__ as name, __version__
from lightwood.api.predictor import Predictor
import lightwood.model_building
import lightwood.constants.lightwood as CONST
from lightwood.helpers.device import get_devices
from lightwood.config.config import CONFIG


COLUMN_DATA_TYPES = CONST.COLUMN_DATA_TYPES

# fix random seed for reproducibility
seed = 42
np.random.seed(seed)
torch.manual_seed(seed)
if CONFIG.USE_CUDA:
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
