# _spyrograph_: elegant mathematics and geometries

<p align="center">
  <img src="media/sample_drawing.gif" alt="Sample hypotrochoid drawing showing a circle rolling around the interior of another circle drawing a geometric shape">
</p>

## What is it?
_spyrograph_ is a lightweight Python package that provides an expressive and flexible set of tools for drawing beautiful mathematically driven art. With just a few lines of easy-to-read code you can start analyzing, visualizing, and exploring elegant mathematics 

[![Issues](https://img.shields.io/github/issues/chris-greening/spyrograph)](https://github.com/chris-greening/spyrograph/issues)
[![License](https://img.shields.io/github/license/chris-greening/spyrograph)](LICENSE)
[![Version](https://img.shields.io/pypi/v/spyrograph?color=brightgreen)](https://pypi.org/project/spyrograph/)

[Official website](https://chris-greening.github.io/spyrograph/)

[Official docs](https://spyrograph.readthedocs.io/en/latest/)

## Key Features
- Expressive and consistent syntax 
- Robust underlying mathematics
- No third-party installations required
- Clear visualizations and animations
- Flexible to a wide range of usecases
- Lightweight, just plug and play

---

## Table of Contents
* [Installation](#installation)
* [Contributing](#contributing)
* [Documentation](#documentation)
* [License](#license)
* [Support](#support)

---

## :computer: Installation <a name="installation"></a>

### pip
Install from PyPI using
```shell
$ pip3 install spyrograph
```

or clone from GitHub 
```shell
$ git clone https://github.com/chris-greening/spyrograph.git
```

---

## :pray: Contributing <a name="contributing"></a>
All contributions, bug reports, bug fixes, documentation improvements, enhancements, and ideas are welcome!

Feel free to [open an Issue](https://github.com/chris-greening/spyrograph/issues/new/choose), check out existing [Issues](https://github.com/chris-greening/spyrograph/issues), or [start a discussion](https://github.com/chris-greening/spyrograph/discussions). 

Beginners to open source are highly encouraged to participate and ask questions if you're unsure what to do/where to start

---

## :books: Documentation <a name="documentation"></a>
The official documentation can be found on [Read The Docs](https://spyrograph.readthedocs.io/en/latest/index.html)

---

## :credit_card: License <a name="license"></a>
This library operates under the [MIT](LICENSE) license.

---

## :grey_question: Support <a name="support"></a>

Reach out to me if you want to connect or have any questions and I will do my best to get back to you
* Email:
  * chris@christophergreening.com
* Twitter:
  * [@ChrisGreening](https://twitter.com/ChrisGreening)
* LinkedIn
  * [Chris Greening](https://www.linkedin.com/in/chris-greening-646411139/)
* Personal contact form: 
  * [www.christophergreening.com](https://www.christophergreening.com/contact)
