"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoundaryProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary boundary}
*/
class BoundaryProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary boundary} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BoundaryProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'boundary',
            terraformGeneratorMetadata: {
                providerName: 'boundary',
                providerVersion: '1.1.2',
                providerVersionConstraint: '~> 1.0'
            },
            terraformProviderSource: 'boundary'
        });
        this._addr = config.addr;
        this._authMethodId = config.authMethodId;
        this._passwordAuthMethodLoginName = config.passwordAuthMethodLoginName;
        this._passwordAuthMethodPassword = config.passwordAuthMethodPassword;
        this._pluginExecutionDir = config.pluginExecutionDir;
        this._recoveryKmsHcl = config.recoveryKmsHcl;
        this._tlsInsecure = config.tlsInsecure;
        this._token = config.token;
        this._alias = config.alias;
    }
    get addr() {
        return this._addr;
    }
    set addr(value) {
        this._addr = value;
    }
    // Temporarily expose input value. Use with caution.
    get addrInput() {
        return this._addr;
    }
    get authMethodId() {
        return this._authMethodId;
    }
    set authMethodId(value) {
        this._authMethodId = value;
    }
    resetAuthMethodId() {
        this._authMethodId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authMethodIdInput() {
        return this._authMethodId;
    }
    get passwordAuthMethodLoginName() {
        return this._passwordAuthMethodLoginName;
    }
    set passwordAuthMethodLoginName(value) {
        this._passwordAuthMethodLoginName = value;
    }
    resetPasswordAuthMethodLoginName() {
        this._passwordAuthMethodLoginName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAuthMethodLoginNameInput() {
        return this._passwordAuthMethodLoginName;
    }
    get passwordAuthMethodPassword() {
        return this._passwordAuthMethodPassword;
    }
    set passwordAuthMethodPassword(value) {
        this._passwordAuthMethodPassword = value;
    }
    resetPasswordAuthMethodPassword() {
        this._passwordAuthMethodPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordAuthMethodPasswordInput() {
        return this._passwordAuthMethodPassword;
    }
    get pluginExecutionDir() {
        return this._pluginExecutionDir;
    }
    set pluginExecutionDir(value) {
        this._pluginExecutionDir = value;
    }
    resetPluginExecutionDir() {
        this._pluginExecutionDir = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pluginExecutionDirInput() {
        return this._pluginExecutionDir;
    }
    get recoveryKmsHcl() {
        return this._recoveryKmsHcl;
    }
    set recoveryKmsHcl(value) {
        this._recoveryKmsHcl = value;
    }
    resetRecoveryKmsHcl() {
        this._recoveryKmsHcl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recoveryKmsHclInput() {
        return this._recoveryKmsHcl;
    }
    get tlsInsecure() {
        return this._tlsInsecure;
    }
    set tlsInsecure(value) {
        this._tlsInsecure = value;
    }
    resetTlsInsecure() {
        this._tlsInsecure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsInsecureInput() {
        return this._tlsInsecure;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            addr: cdktf.stringToTerraform(this._addr),
            auth_method_id: cdktf.stringToTerraform(this._authMethodId),
            password_auth_method_login_name: cdktf.stringToTerraform(this._passwordAuthMethodLoginName),
            password_auth_method_password: cdktf.stringToTerraform(this._passwordAuthMethodPassword),
            plugin_execution_dir: cdktf.stringToTerraform(this._pluginExecutionDir),
            recovery_kms_hcl: cdktf.stringToTerraform(this._recoveryKmsHcl),
            tls_insecure: cdktf.booleanToTerraform(this._tlsInsecure),
            token: cdktf.stringToTerraform(this._token),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.BoundaryProvider = BoundaryProvider;
_a = JSII_RTTI_SYMBOL_1;
BoundaryProvider[_a] = { fqn: "@cdktf/provider-boundary.provider.BoundaryProvider", version: "2.0.0" };
// =================
// STATIC PROPERTIES
// =================
BoundaryProvider.tfResourceType = "boundary";
//# sourceMappingURL=data:application/json;base64,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