import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialStoreStaticConfig extends cdktf.TerraformMetaArguments {
    /**
    * The static credential store description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_static#description CredentialStoreStatic#description}
    */
    readonly description?: string;
    /**
    * The static credential store name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_static#name CredentialStoreStatic#name}
    */
    readonly name?: string;
    /**
    * The scope for this credential store.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_static#scope_id CredentialStoreStatic#scope_id}
    */
    readonly scopeId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_static boundary_credential_store_static}
*/
export declare class CredentialStoreStatic extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_credential_store_static";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/credential_store_static boundary_credential_store_static} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialStoreStaticConfig
    */
    constructor(scope: Construct, id: string, config: CredentialStoreStaticConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
