import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialJsonConfig extends cdktf.TerraformMetaArguments {
    /**
    * The credential store in which to save this json credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_json#credential_store_id CredentialJson#credential_store_id}
    */
    readonly credentialStoreId: string;
    /**
    * The description of this json credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_json#description CredentialJson#description}
    */
    readonly description?: string;
    /**
    * The name of this json credential. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_json#name CredentialJson#name}
    */
    readonly name?: string;
    /**
    * The object for the this json credential. Either values encoded with the "jsonencode" function, pre-escaped JSON string, or a file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_json#object CredentialJson#object}
    */
    readonly object: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/credential_json boundary_credential_json}
*/
export declare class CredentialJson extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_credential_json";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/credential_json boundary_credential_json} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialJsonConfig
    */
    constructor(scope: Construct, id: string, config: CredentialJsonConfig);
    private _credentialStoreId?;
    get credentialStoreId(): string;
    set credentialStoreId(value: string);
    get credentialStoreIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
    get objectHmac(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
