import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceGithubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_github#id ServiceGithub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the project you want to activate integration on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_github#project ServiceGithub#project}
    */
    readonly project: string;
    /**
    * The URL of the GitHub repo to integrate with, e,g, https://github.com/gitlabhq/terraform-provider-gitlab.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_github#repository_url ServiceGithub#repository_url}
    */
    readonly repositoryUrl: string;
    /**
    * Append instance name instead of branch to the status. Must enable to set a GitLab status check as _required_ in GitHub. See [Static / dynamic status check names] to learn more.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_github#static_context ServiceGithub#static_context}
    */
    readonly staticContext?: boolean | cdktf.IResolvable;
    /**
    * A GitHub personal access token with at least `repo:status` scope.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_github#token ServiceGithub#token}
    */
    readonly token: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_github gitlab_service_github}
*/
export declare class ServiceGithub extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_service_github";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_github gitlab_service_github} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceGithubConfig
    */
    constructor(scope: Construct, id: string, config: ServiceGithubConfig);
    get active(): cdktf.IResolvable;
    get createdAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _repositoryUrl?;
    get repositoryUrl(): string;
    set repositoryUrl(value: string);
    get repositoryUrlInput(): string | undefined;
    private _staticContext?;
    get staticContext(): boolean | cdktf.IResolvable;
    set staticContext(value: boolean | cdktf.IResolvable);
    resetStaticContext(): void;
    get staticContextInput(): boolean | cdktf.IResolvable | undefined;
    get title(): string;
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
