# Field Day log aggregating server

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg?style=for-the-badge)](https://www.gnu.org/licenses/gpl-3.0)
[![Python: 3.9+](https://img.shields.io/badge/python-3.9+-blue.svg?logo=python&style=for-the-badge)](https://www.python.org/downloads/)
![Made With: Ancient Technology](https://img.shields.io/badge/Made%20with-Ancient%20technology-red?style=for-the-badge)
![PyPI - Downloads](https://img.shields.io/pypi/dm/fdserver?label=PYPI-Downloads&logo=pypi&style=for-the-badge)

![logo](https://github.com/mbridak/fdserver/raw/master/fdserver/data/k6gte.fdserver-128.png)

## TOC

- [Field Day log aggregating server](#field-day-log-aggregating-server)
  - [TOC](#toc)
  - [What is it](#what-is-it)
  - [No really what is it](#no-really-what-is-it)
  - [Screenshot](#screenshot)
  - [Installation](#installation)
  - [Configuration and first run](#configuration-and-first-run)

## What is it

[ARRL Field Day](http://field-day.arrl.org/) is a once a year 24hr emergency
preparidness event for radio amateurs (Hams). During the event, we try and
make as many radio contacts with other Hams in a 24 hour period. You can find
out more about amateur radio by visiting the [ARRL](https://www.arrl.org/).

## No really what is it

This server listens to multicast logging packets generated by multiple [fdlogger](https://github.com/mbridak/FieldDayLogger)
clients. So a group or club can submit a group cabrillo log.

## Screenshot

![main display](https://github.com/mbridak/fdserver/raw/master/pics/server_pic.png)

## Installation

```bash
pip install fdserver
```

```text
usage: fdserver [-h] [-l]

Field Day aggregation server.

options:
  -h, --help  show this help message and exit
  -l, --log   Generate log
```

## Configuration and first run

When executed for the first time, the server will not find a configuration file.
When this happens, the server will place a fresh copy in the local directory.
Press CTRL-C to end the program then edit the configuration file now found at
`./server_preferences.json`. Unless you have good reason to, don't change the
multicast settings.

```json
{
    "ourcall": "W1AW",
    "ourclass": "3A",
    "oursection": "ORG",
    "bonus": {
        "emergency_power": {
            "bool": 0,
            "station_count": 0
        },
        "media_publicity": 0,
        "public_location": 0,
        "public_info_table": 0,
        "message_to_section_manager": 0,
        "message_handling": {
            "bool": 0,
            "message_count": 0
        },
        "satellite_qso": 0,
        "w1aw_bulletin": 0,
        "educational_activity": 0,
        "elected_official_visit": 0,
        "agency_representative_visit": 0,
        "gota": 0,
        "web_submission": 0,
        "youth_participation": {
            "bool": 0,
            "youth_count": 0
        },
        "social_media": 0,
        "safety_officer": 0
    },
    "batterypower": 0,
    "name": "Hiram Maxim",
    "address": "225 Main Street",
    "city": "Newington",
    "state": "CT",
    "postalcode": "06111",
    "country": "USA",
    "email": "Hiram.Maxim@arrl.net",
    "mullticast_group": "224.1.1.1",
    "multicast_port": 2239,
    "interface_ip": "0.0.0.0",
    "node_red_server_ip": "127.0.0.1",
    "node_red_server_port": 12062
}
```

Under the bonus section, if your group qualifies for a bonus, put `true` or `1` next
to the type of bonus.

Save the file and relaunch the fdserver application.
