import hashlib
import datetime as dt
import rsa
from cryptography.fernet import Fernet
import pandas as pd

KEYS_RSA = rsa.newkeys(512)

class LIB:
    def __init__(self):
        pass

    @staticmethod
    def hash(word: str, pattern: str = "md5"):
        pattern_list = ["md5", "sha1", "sha224", "sha256", "sha384", "sha512"]
        h, msg, error = None, None, None
        try:
            #value = b'{word}'
            if pattern == pattern_list[0]:
                h = hashlib.md5()
            elif pattern == pattern_list[1]:
                h = hashlib.sha1()
            elif pattern == pattern_list[2]:
                h = hashlib.sha224()
            elif pattern == pattern_list[3]:
                h = hashlib.sha256()
            elif pattern == pattern_list[4]:
                h = hashlib.sha384()
            elif pattern == pattern_list[5]:
                h = hashlib.sha512()
            h.update({word.encode()})
            msg = h.hexdigest()
        except Exception as error:
            msg = f"""Erro ao tentar montar o HASH. Erro: {error}"""
        finally:
            return msg

    @staticmethod
    def rsa_encrypt(word: str):
        msg = None
        try:
            PUBLIC_KEY = KEYS_RSA[0]
            msg = rsa.encrypt(word.encode(), PUBLIC_KEY)
            print(type(msg))
        except Exception as error:
            msg = f"""Falha ao tentar encriptografar a palavra {word}. Erro: {error}"""
        finally:
            return msg

    @staticmethod
    def rsa_decrypt(word: str):
        msg = None
        try:
            PRIVATE_KEY = KEYS_RSA[1]
            msg = rsa.decrypt(word.encode(), PRIVATE_KEY).decode()
        except Exception as error:
            msg = f"""Falha ao tentar Descriptografar a palavra {word}. Erro: {error}"""
        finally:
            return msg

    @staticmethod
    def Date_to_DateAsLong(value):
        try:
            dataaslong = int(dt.datetime.timestamp(value) * 1e3)
            return dataaslong
        except Exception as error:
            msgerro = f"""Falha ao tentar transformar um DATA em um LONG: "{value}". {error}"""
            raise Exception(msgerro)

    @staticmethod
    def DateAsLong_to_Date(value):
        try:
            date = dt.datetime.fromtimestamp(value / 1e3)
            return date
        except Exception as error:
            msgerro = f"""Falha ao tentar transformar um LONG em uma data: "{value}". {error}"""
            raise Exception(msgerro)

    @staticmethod
    def TimeAsLong_to_Time(value: dt.timedelta):
        try:
            horas_total = round((value.days * 24) + int(value.seconds / 60 / 60), 2)
            minutos = round(((value.seconds / 60 / 60) - int((value.seconds / 60) / 60)) * 60, 2)
            seg = round(((minutos - int(minutos)) * 60), 2)
            hora = f"""{horas_total}:{int(minutos):02}:{int(round(seg)):02}"""
            return hora
        except Exception as error:
            msgerro = f"""Falha ao tentar converter um timedelta para um tempo (HH:mm:ss) "{value}". {error}"""
            raise Exception(msgerro)

    @staticmethod
    def Time_to_TimeAsLong(value):
        try:
            td = value.split(":")
            h = round(int(td[0]) * 60 * 60 * 1000)
            m = round(int(td[1]) * 60 * 1000)
            s = round(int(td[2]) * 1000)
            tempo = h + m + s
            return tempo
        except Exception as error:
            msgerro = f"""Falha ao tentar converter um horario em LONG "{value}". {error}"""
            raise Exception(msgerro)

    @staticmethod
    def ifnull(var, val):
        if (var is None or var == 'None'):
            value = val
        else:
            value = var
        return value

    @staticmethod
    def iif(condicao: bool, value_true, value_false):
        if condicao:
            value = value_true
        else:
            value = value_false
        return value

    @staticmethod
    def Crud(sql: str=None, values: list=None, conexao=None):
        msg, result, linhas_afetadas = None, [], 0
        try:
            if not isinstance(sql, str) or sql is None:
                raise Exception(f"""Comando sql não foi definido {sql}""")
            if conexao is None:
                raise Exception(f"""Conexão não foi informada {conexao}""")
            if not isinstance(values, list) or dict is None:
                raise Exception(f"""Lista de valores não foi informada {values}""")
            cursor = conexao.cursor()
            cursor.executemany(sql, values)
            linhas_afetadas = cursor.rowcount
            conexao.commit()
            conexao.close()
            msg = f"""Comando SQL executado com sucesso!"""
        except Exception as error:
            msg = f"""Falha ao tentar executar o comando SQL! Erro: {error}"""
            result = msg
        finally:
            result = {"linhas_afetadas": linhas_afetadas, "mensagem": msg, "sql": sql}
            return result

    @staticmethod
    def CRYPTOGRAPHY(word, action: str = "D", token: str = None):
        # D=Decrypt, E=Encrypt
        result = None
        try:
            if word is None:
                raise Exception(f"""Parametro "word" é obrigatorio!""")
            if token is None:
                raise Exception(f"""Parametro "token" é obrigatório""")
            if isinstance(word, str):
                word = word.encode()
            CIPHER = Fernet(token)
            if action == "E":
                if type(word == "str"):
                    result = CIPHER.encrypt(word)
            else:
                result = CIPHER.decrypt(word)
        except Exception as error:
            result = error
        finally:
            return result.decode()

    @staticmethod
    def get_parametros_geral(conexao) -> pd.DataFrame:
        df = None
        try:
            sql = f"""
                   SELECT *
                     FROM Parametros
                    where flg_status = 'A'
                    order by handle_parent, handle, num_ordem
                   """
            df = pd.read_sql(con=conexao, sql=sql)
        except Exception as error:
            df = error
        finally:
            return df

    @staticmethod
    def get_parametro_valor(df, value) -> list:
        result = []
        try:
            result.append(df.loc[df["nom_variavel"] == value].index[0])
            result.append(df.loc[result[0], "val_parametro"])
        except Exception as error:
            result = None
        finally:
            return result

    @staticmethod
    def get_parametros_grupo(df, value) -> pd.DataFrame:
        result = None
        try:
            result = df.loc[df["grupo_parametro"] == value]
        except Exception as error:
            result = error
        finally:
            return result
        
    @staticmethod
    def parametro_set(conexao, nom_parametro, val_parametro):
        result = None
        try:
            sql = f"""
                    Update Parametros
                       set val_parametro = '{val_parametro}'
                     where nom_variavel = = '{nom_parametro}'   
                  """
            cursor = conexao.cursor()
            cursor.execute(sql)
            conexao.commit()
            conexao.close()
        except Exception as error:
            msg = f"""Falha ao tentar gravar o parametro [{nom_parametro}, com o valor [{val_parametro}], nesta conexão [{conexao}]. Erro: {error}"""
            result = msg
            if conexao.isopen():
                conexao.close()
        finally:
            return result

    @staticmethod
    def cores_ansi() -> dict:
        cores = {"Preto": ["\033[1;30m", "\033[1;40m"],
                 "Vermelho": ["\033[1;31m", "\033[1;41m"],
                 "Verde": ["\033[1;32m", "\033[1;42m"],
                 "Amarelo": ["\033[1;33m", "\033[1;43m"],
                 "Azul": ["\033[1;34m", "\033[1;44m"],
                 "Magenta": ["\033[1;35m", "\033[1;45m"],
                 "Cyan": ["\033[1;36m", "\033[1;46m"],
                 "Cinza Claro": ["\033[1;37m", "\033[1;47m"],
                 "Cinza Escuro": ["\033[1;90m", "\033[1;100m"],
                 "Vermelho Claro": ["\033[1;91m", "\033[1;101m"],
                 "Verde Claro": ["\033[1;92m", "\033[1;102m"],
                 "Amarelo Claro": ["\033[1;93m", "\033[1;103m"],
                 "Azul Claro": ["\033[1;94m", "\033[1;104m"],
                 "Magenta Claro": ["\033[1;95m", "\033[1;105m"],
                 "Cyan Claro": ["\033[1;96m", "\033[1;106m"],
                 "Branco": ["\033[1;97m", "\033[1;107m"],
                 "Negrito": ["\033[;1m", None],
                 "Inverte": ["\033[;7m", None],
                 "Reset (remove formatação)": ["\033[0;0m", None]}
        return cores

if __name__ == "__main__":
    pass

