# sysnet-pyutils

SYSNET Python Utilities

Knihovna obsahuje záklaní, v aplikacích hojně používané, utility.

## sysnet-pyutils.utils

Hlavní modul

### Třídy

* **Singleton**: Vzor všech singletonů. 

        class ConfigFlag(object, metaclass=Singleton):

* **ConfigFlag**: Pomocný singleton. Používá se pro inicializaci konfigurace.
* **Config**: Singleton konfigurace aplikace. Konfigurace se ukládá do souboru YAML.

        from sysnet_pyutils import utils as pu
        ...
        CC = pu.Config(config_path=CONFIG_FILE_PATH, config_dict=CONFIG_INIT)
        if CC.loaded:
            LOG.logger.info("CONFIG loaded")
        CONFIG = CC.config    # konfigurační dictionary

* **ConfigError**: Chyba konfigurace
* **Log**: Logovací singleton. Centralizuje logování v aplikaci. Umožňuje použití externího loggeru (např. pro Django nebo Flask)


### Funkce
----------------------------------------------------------------
#### api_key_generate(length: int):
Vygeneruje API klíč
* param length: Dělka API klíče
* return: API Key
----------------------------------------------------------------
#### api_key_next(name, length=16):
Vygeneruje slovník API key {API Key: name}
* param name:    Název API klíče
* param length:  Délka API klíče
* return:    Slovník {API Key: name}
----------------------------------------------------------------
#### api_keys_init(agenda='main', amount=4):
Vygeneruje klíče pro API
* param agenda: Název agendy, pro kterou se klíče generují
* param amount: Počet vygenerovaných klíčů
* return: seznam vygenerovaných klíčů
--------------------------------------------------------
#### convert_hex_to_int(id_hex):
Konvertuje hex string na int
* param id_hex:  Hexadecimální string
* return: int
--------------------------------------------------------
#### cron_to_dict(cron):
Konvertuje cron text do do slovníku
* param cron: cron text (například '35 21 * * *')
* return:    dict of cron
--------------------------------------------------------
#### cs_bool(value=None):
Vrátí českou textovou hodnotu 'ano'/'ne' pokud je bool(value) True/False
* param value:  Obecný objekt
* return:    'ano' or 'ne'
----------------------------------------------------------------
#### id12_next(three_char_prefix=None):
Vygeneruje korektní 12místný alfanumerický identifikátor s pevným prefixem
* param three_char_prefix:   Tříznakový prefix identifikátoru
* return:    12místný alfanumerický identifikátor 
----------------------------------------------------------------
#### increment_date(date_str=None, days=1):
Inkrementuje datum v textovém formátu ISO o daný počet dní
* param date_str:    ISO datum v textovém formátu ISO
* param days:        počet dní
* return:        ISO datum v textovém formátu ISO
----------------------------------------------------------------
#### iso_to_local_datetime(isodate):
ISO string datum do lokálního datetime
* param isodate: Textové datum v ISO
* return: lokální datetime
----------------------------------------------------------------    
#### pid_check(pid):
Zkontroluje korektnost PID
* param pid: Vstupní PID
* return: True/False
----------------------------------------------------------------
#### pid_correct(pid):
Opraví PID
* param pid: Vstupní PID 
* return: Opravený PID
----------------------------------------------------------------    
#### pid_next():
Vygeneruje korektní PID
* return:    PID 
----------------------------------------------------------------
#### today():
Vrací ISO 8601 text datum dnešního dne
* return:    ISO 8601 datum dnešního dne
----------------------------------------------------------------
#### tomorrow():
Vrací ISO 8601 datum zítřejšího dne
* return:    ISO 8601 datum
----------------------------------------------------------------
#### unique_list(input_list):
Vyřadí opakující se položky ze seznamu
* param input_list:   Vstupní seznam
* return: Unikátní seznam
----------------------------------------------------------------
#### url_safe(url):
Upraví URL, aby neobsahovalo nepovolené znaky
* param url: Vstupní URL
* return: Upravené URL
--------------------------------------------------------------------------------------------------------------------------------
#### uuid_next(uuid_type=1):
Vygeneruje UUID
* param uuid_type: Lze použít pouze typ 1 nebo 4
* return: uuid
--------------------------------------------------------------------------------------------------------------------------------
#### who_am_i():
Vrátí název aktuální funkce
* return: název funkce, odkud je voláno  
* například:   `__name__ = who_am_i()`  


## Systémové proměnné

* **TZ**: Časová zóna. Implicitně 'Europe/Prague'
* **DEBUG**: Debug mode. Implictně `True`
* **LOG_FORMAT**: Formát logování. Implicitně `'%(asctime)s - %(levelname)s in %(module)s: %(message)s'`
* **LOG_DATE_FORMAT**: Formát data pro logování. Implicitně `'%d.%m.%Y %H:%M:%S'`
* **PID_PREFIX**: PID prefix. Implicitně `'SNT'`
