[TOC]



# 如何理解GCN

## 什么是离散卷积？CNN中卷积发挥什么作用？

CNN中的卷积本质是利用共享参数的过滤器（kernel），通过计算中心像素点以及相邻像素点的加权和构成feature map实现**空间特征**的提取，加权系数就是卷积核的权重系数

卷积核的系数如何确定？

随机化初始值，根据误差函数通过反向传播梯度下降进行迭代优化

卷积核的参数通过优化求出才能实现特征提取的作用，GCN的理论很大一部分工作就是为了引入可以优化的卷积参数

## GCN中的Graph指什么？为什么要研究GCN？

CNN处理的图像或视频数据中像素点（pixel）是排列成很整齐的矩阵

![preview](https://pic4.zhimg.com/v2-85d93d60cb11dddd64a288bff6688cfc_r.jpg?source=1940ef5c)

科学研究中还有很多non Euclidean structure，就是图论中抽象意义上的拓扑图

![img](https://pic1.zhimg.com/80/v2-f940bce70fb412c75c43ec239b76ee88_720w.jpg?source=1940ef5c)

Graph Convolutional Network中的Graph是指数学图论中的用顶点和边建立相应关系的拓扑图。

为什么要研究GCN？原因有三：

（1）CNN无法处理Non Euclidean Structure的数据，学术表达为传统的离散卷积在Non Euclidean Structure的数据上无法保持平移不变性。通俗来讲就是拓扑图中每个顶点的想领顶点数目可能都不同，无法用同样尺寸的卷积核进行卷积运算

（2）希望在拓扑上有效提取空间特征进行机器学习

（3）广义来讲任何数据在赋范空间内都可以建立拓扑关联，谱聚类就是应用了这样的思想，所以拓扑连接是一种广义的数据结构，GCN有很大的应用空间。

## 提取拓扑图空间特征的两种方式

### vertex domain

提取拓扑图上的空间特征，就把每个顶点相邻的neighbors找出来

a 按照什么条件去找中心vertex的neighbors，也就是如何确定receptive field？

b 确定receptive filed，按照什么方式处理包含不同数目neighbors的特征？

![img](https://pic4.zhimg.com/80/v2-22e5b58b959d22eaf838ed4238ec2716_720w.jpg?source=1940ef5c)

vertex domain提取空间特征示意图

这种方法的主要缺点如下：

c 每个顶点提取出来的neighbors不同，使得计算处理必须针对每个顶点

d 提取特征的效果可能没有卷积好

### spectral domain

GCN的理论基础。这种思路就是借助图谱的理论来实现拓扑图上的卷积操作。

首先，研究GSP（graph signal processing）的学者定义了graph上的Fourier Transformation，进而定义了graph上的convolution，最后与深度学习结合提出了Graph Convolutional Network

Q1：什么是Spectral graph theory？

借助图的拉普拉斯矩阵的特征值和特征向量来研究图的性质

Q2：GCN为什么要利用Septral graph theory?

## 什么是拉普拉斯矩阵？为什么GCN要用拉普拉斯矩阵？

对于图G=(V,E),其Laplacian矩阵的定义为L=D-A，其中L为Laplacian矩阵，D是顶点的度矩阵（对角矩阵），对角线上元素依次为各个顶点的度，A是图的邻接矩阵。

a 拉普拉斯矩阵是对称矩阵，可以进行特征分解（谱分解），和GCN的spetral domian对应

b 拉普拉斯矩阵只在中心顶点和一阶相连的顶点上有非0元素，其余均为0

c 通过拉普拉斯算子与拉普拉斯矩阵进行类比

## 拉普拉斯矩阵的谱分解（特征分解）

矩阵的谱分解，特征分解，对角化都是同一个概念

矩阵可以特征分解的充要条件n阶矩阵存在n个线性无关的特征向量

拉普拉斯矩阵是半正定矩阵，有如下三个性质：

1. 实对称矩阵一定有n个线性无关的特征向量
2. 半正定矩阵的特征值一定非负
3. 实对称矩阵的特征向量可以华为两两相互正交的正交矩阵

## 如何从传统的傅里叶变换，卷积类比到Graph上的傅里叶变换和卷积？

核心工作是把拉普拉斯算子的特征函数变为Graph对应的拉普拉斯矩阵的特征向量

**拉普拉斯矩阵就是离散拉普拉斯算子**

------

拉普拉斯算子：二阶求导

## 两种空间下的傅里叶分解/特征分解对比（卷积为什么能从欧式空间推广到Graph空间）

$$
首先在欧式空间上，迭代求解的核心算子\Delta的特征函数是：e^{-jwt}，因为：\\\Delta e^{-jwt}=w^2e^{-jwt}\\
其次在Graph空间上对应L的不是特征函数，而是它的特征值和特征向量，分别对应\\上面的w^2和e^{-jwt}
$$

##### 特征函数（概率论）

在概率论中，任何随机变量的特征函数完全定义了它的概率分布。

###### 如何理解矩

$$
期望E[X]=\sum_ip_ix_i
$$

x为一次幂，所以被称为“一阶矩”。
$$
方差：Var(X)=E[(X-\mu)^2]=\sum_ip_i(x_i-\mu)^2
$$
“二阶矩”

各阶矩相等=》各个特征相等=》分布相同

###### 特征函数

$$
随机变量X的特征函数定义为：\varphi_X(t)=E[e^{itX}]\\
首先，e^{itX}的泰勒级数为：e^{itX}=1+\frac{itX}{1}-\frac{t^2X^2}{2!}+...+\frac{(it)^nX^n}{n!}\\
代入可以推出：\varphi_X(t)=E[e^itX]=E(1+\frac{itX}{1}-\frac{t^2X^2}{2!}+...+\frac{(it)^nX^n}{n!})\\=E(1)+E()
$$

