# Static Number Sequence

<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-refresh-toc -->
**Table of Contents**

- [About This Challenge](#about-this-challenge)
    - [Rules of Level Increase or Decrease](#rules-of-level-increase-or-decrease)
- [Memorization Techniques](#memorization-techniques)
- [The Number Shape System (single digits to objects or animals)](#the-number-shape-system-single-digits-to-objects-or-animals)
- [The People-Action System (four digits to a person and an action)](#the-people-action-system-four-digits-to-a-person-and-an-action)
- [The Major System (digits to letters)](#the-major-system-digits-to-letters)
- [The Memory Palace, aka. Method of Loci (items to locations)](#the-memory-palace-aka-method-of-loci-items-to-locations)

<!-- markdown-toc end -->

## About This Challenge

Memorize the sequence of numbers before the timer ends, then type them in the order they were given.

Primes are red, when that setting is enabled.

With each successive level, both the sequence and the time is increased.

Use the Preferences menu to customize the challenge such as how many digits are included, or how many seconds per level are given.

To disable the timer, set the seconds per level to 0.

### Rules of Level Increase or Decrease

You can customize how many challenges you have to succeed per level. On success, either the challenge counter or the level is increased.

The rules are:

- Correct answer on first try: increase counter/level.
- Wrong answer on first try, but correct answer eventually: stay on same level, reset the counter.
- Show correct answer: decrease level.
- New challenge without correct answer: decrease level.

## Memorization Techniques

Memorization relies on encoding the given information in some way.

Verbally repeating the numbers to oneself is one method of encoding, sufficient up to about 4-5 items.

Studies have shown that human short-term working memory capacity is about 5 to 9 items if the material is familiar, and 3-4 if the material is unfamiliar.

If you haven't been memorizing often, practice will extend your working memory capacity a bit, but this effect is limited to an unused, "rusty" mental faculty becoming active and "oiled". There is much greater potential in improving the method of encoding, aka. mnemonic techniques. 

The keys to extend one's capacity to memorize are:

- 1. __Suitable format__: Presenting the information in a format more suitable for the brain. Images, sounds, locations are easier to remember than digits.

- 2. __Efficient encoding__: Fitting more information into the working memory slots. One letter to one digit is more efficient than one word (e.g. "eight") to one digit.

- 3. __Chunking__: Breaking up the information into smaller fragments. 20 numbers can be memorized in 5 chunks, 4 numbers at a time, then linking the 5 chunks.

Image- or location-based associations are easier to remember, but it can take a few seconds to come with new images on the fly.

Phonetic- or letter-based associations are more automatic and faster to encode, but not so distinct, and too many in a sequence is hard to recall correctly.

The following examples can be used as-is, but feel free to mix-and-match methods and use your own images. The easiest associations to remember are the funny, weird, shocking images which pop into your head.

## The Number Shape System (single digits to objects or animals)

Associate the digit to an animal or object based on shape or value.

Johannes Mallow's:

0 - egg  
1 - candle  
2 - swan  
3 - trident  
4 - chair  
5 - hand  
6 - curled snake  
7 - scythe  
8 - hourglass  
9 - balloon on a string

- Single digits: https://artofmemory.com/wiki/Number_Shape_System
- For two digits: https://artofmemory.com/wiki/The_Shaper_System

## The People-Action System (four digits to a person and an action)

(Invented by Dominic O'Brien)

4 digits are encoded as compound images of a __person__ and an __action__.

If there is an easy number-to-image association, use that. Else, convert the digits to letters and a person.

11 => AA => Andre Agassi playing tennis  
33 => CC => Charlie Chaplin swinging a cane

1133 => Andre Agassi swinging a cane  
3311 => Charlie Chaplin playing tennis

Long numbers: chunk the numbers to 4, and create a story.

1 = A  
2 = B  
3 = C  
4 = D  
5 = E  
6 = S  
7 = G  
8 = H  
9 = N  
0 = O

- https://artofmemory.com/wiki/Dominic_System

## The Major System (digits to letters)

Each digit is a associated to a consonant and vowel, used in alternating sequence, creating pronounceable syllables which are associated to images.

John Cohen's consonant system (which is a modified Ben system):

0 = s/z  
1 = t  
2 = n  
3 = m  
4 = r  
5 = l  
6 = b  
7 = k  
8 = f/v  
9 = p

00 = SO  
01 = SI  
02 = SU  
03 = SAA  
etc.

Yanjaa Wintersoul's consonant system:

0 = p  
1 = t  
2 = n  
3 = m  
4 = r  
5 = s  
6 = b  
7 = L  
8 = f/v  
9 = g

- https://artofmemory.com/wiki/Josh_Cohen
- https://artofmemory.com/files/pdf/memory-system-key.pdf
- https://artofmemory.com/wiki/Ben_System
- https://artofmemory.com/wiki/Major_System#cite_ref-7

## The Memory Palace, aka. Method of Loci (items to locations)

An item is associated to a location, in a place one is already familiar with, placed in order as a sequence on a walk-though in that place, such as door -> corridor -> potted plant -> window -> painting on wall -> staircase, etc.

This technique is excellent for memorizing long lists of items (such as topics for a public speech), but needs more time for one to come up with and memorize the associations.

In memorizing digits, it can be useful to link chunks of digits. E.g. encode the chunks 101 434 to SOS (asking for help) RAR (dinosaur roaring), the place them at locations on a path.

- https://artofmemory.com/blog/how-to-build-a-memory-palace/

