# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 3
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isi_sdk_8_0.models.report_subreport_phase import ReportSubreportPhase  # noqa: F401,E501


class TargetReport(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'str',
        'ads_streams_replicated': 'int',
        'block_specs_replicated': 'int',
        'bytes_recoverable': 'int',
        'bytes_transferred': 'int',
        'char_specs_replicated': 'int',
        'corrected_lins': 'int',
        'dead_node': 'bool',
        'directories_replicated': 'int',
        'dirs_changed': 'int',
        'dirs_deleted': 'int',
        'dirs_moved': 'int',
        'dirs_new': 'int',
        'duration': 'int',
        'end_time': 'int',
        'error': 'str',
        'error_checksum_files_skipped': 'int',
        'error_io_files_skipped': 'int',
        'error_net_files_skipped': 'int',
        'errors': 'list[str]',
        'failed_chunks': 'int',
        'fifos_replicated': 'int',
        'file_data_bytes': 'int',
        'files_changed': 'int',
        'files_linked': 'int',
        'files_new': 'int',
        'files_selected': 'int',
        'files_transferred': 'int',
        'files_unlinked': 'int',
        'files_with_ads_replicated': 'int',
        'flipped_lins': 'int',
        'hard_links_replicated': 'int',
        'hash_exceptions_fixed': 'int',
        'hash_exceptions_found': 'int',
        'id': 'str',
        'job_id': 'int',
        'lins_total': 'int',
        'network_bytes_to_source': 'int',
        'network_bytes_to_target': 'int',
        'new_files_replicated': 'int',
        'num_retransmitted_files': 'int',
        'phases': 'list[ReportSubreportPhase]',
        'policy_id': 'str',
        'policy_name': 'str',
        'regular_files_replicated': 'int',
        'resynced_lins': 'int',
        'retransmitted_files': 'list[str]',
        'retry': 'int',
        'running_chunks': 'int',
        'sockets_replicated': 'int',
        'source_bytes_recovered': 'int',
        'source_directories_created': 'int',
        'source_directories_deleted': 'int',
        'source_directories_linked': 'int',
        'source_directories_unlinked': 'int',
        'source_directories_visited': 'int',
        'source_files_deleted': 'int',
        'source_files_linked': 'int',
        'source_files_unlinked': 'int',
        'source_host': 'str',
        'sparse_data_bytes': 'int',
        'start_time': 'int',
        'state': 'str',
        'subreport_count': 'int',
        'succeeded_chunks': 'int',
        'symlinks_replicated': 'int',
        'sync_type': 'str',
        'target_bytes_recovered': 'int',
        'target_directories_created': 'int',
        'target_directories_deleted': 'int',
        'target_directories_linked': 'int',
        'target_directories_unlinked': 'int',
        'target_files_deleted': 'int',
        'target_files_linked': 'int',
        'target_files_unlinked': 'int',
        'target_path': 'str',
        'target_snapshots': 'list[str]',
        'total_chunks': 'int',
        'total_data_bytes': 'int',
        'total_files': 'int',
        'total_network_bytes': 'int',
        'total_phases': 'int',
        'unchanged_data_bytes': 'int',
        'up_to_date_files_skipped': 'int',
        'updated_files_replicated': 'int',
        'user_conflict_files_skipped': 'int',
        'warnings': 'list[str]'
    }

    attribute_map = {
        'action': 'action',
        'ads_streams_replicated': 'ads_streams_replicated',
        'block_specs_replicated': 'block_specs_replicated',
        'bytes_recoverable': 'bytes_recoverable',
        'bytes_transferred': 'bytes_transferred',
        'char_specs_replicated': 'char_specs_replicated',
        'corrected_lins': 'corrected_lins',
        'dead_node': 'dead_node',
        'directories_replicated': 'directories_replicated',
        'dirs_changed': 'dirs_changed',
        'dirs_deleted': 'dirs_deleted',
        'dirs_moved': 'dirs_moved',
        'dirs_new': 'dirs_new',
        'duration': 'duration',
        'end_time': 'end_time',
        'error': 'error',
        'error_checksum_files_skipped': 'error_checksum_files_skipped',
        'error_io_files_skipped': 'error_io_files_skipped',
        'error_net_files_skipped': 'error_net_files_skipped',
        'errors': 'errors',
        'failed_chunks': 'failed_chunks',
        'fifos_replicated': 'fifos_replicated',
        'file_data_bytes': 'file_data_bytes',
        'files_changed': 'files_changed',
        'files_linked': 'files_linked',
        'files_new': 'files_new',
        'files_selected': 'files_selected',
        'files_transferred': 'files_transferred',
        'files_unlinked': 'files_unlinked',
        'files_with_ads_replicated': 'files_with_ads_replicated',
        'flipped_lins': 'flipped_lins',
        'hard_links_replicated': 'hard_links_replicated',
        'hash_exceptions_fixed': 'hash_exceptions_fixed',
        'hash_exceptions_found': 'hash_exceptions_found',
        'id': 'id',
        'job_id': 'job_id',
        'lins_total': 'lins_total',
        'network_bytes_to_source': 'network_bytes_to_source',
        'network_bytes_to_target': 'network_bytes_to_target',
        'new_files_replicated': 'new_files_replicated',
        'num_retransmitted_files': 'num_retransmitted_files',
        'phases': 'phases',
        'policy_id': 'policy_id',
        'policy_name': 'policy_name',
        'regular_files_replicated': 'regular_files_replicated',
        'resynced_lins': 'resynced_lins',
        'retransmitted_files': 'retransmitted_files',
        'retry': 'retry',
        'running_chunks': 'running_chunks',
        'sockets_replicated': 'sockets_replicated',
        'source_bytes_recovered': 'source_bytes_recovered',
        'source_directories_created': 'source_directories_created',
        'source_directories_deleted': 'source_directories_deleted',
        'source_directories_linked': 'source_directories_linked',
        'source_directories_unlinked': 'source_directories_unlinked',
        'source_directories_visited': 'source_directories_visited',
        'source_files_deleted': 'source_files_deleted',
        'source_files_linked': 'source_files_linked',
        'source_files_unlinked': 'source_files_unlinked',
        'source_host': 'source_host',
        'sparse_data_bytes': 'sparse_data_bytes',
        'start_time': 'start_time',
        'state': 'state',
        'subreport_count': 'subreport_count',
        'succeeded_chunks': 'succeeded_chunks',
        'symlinks_replicated': 'symlinks_replicated',
        'sync_type': 'sync_type',
        'target_bytes_recovered': 'target_bytes_recovered',
        'target_directories_created': 'target_directories_created',
        'target_directories_deleted': 'target_directories_deleted',
        'target_directories_linked': 'target_directories_linked',
        'target_directories_unlinked': 'target_directories_unlinked',
        'target_files_deleted': 'target_files_deleted',
        'target_files_linked': 'target_files_linked',
        'target_files_unlinked': 'target_files_unlinked',
        'target_path': 'target_path',
        'target_snapshots': 'target_snapshots',
        'total_chunks': 'total_chunks',
        'total_data_bytes': 'total_data_bytes',
        'total_files': 'total_files',
        'total_network_bytes': 'total_network_bytes',
        'total_phases': 'total_phases',
        'unchanged_data_bytes': 'unchanged_data_bytes',
        'up_to_date_files_skipped': 'up_to_date_files_skipped',
        'updated_files_replicated': 'updated_files_replicated',
        'user_conflict_files_skipped': 'user_conflict_files_skipped',
        'warnings': 'warnings'
    }

    def __init__(self, action=None, ads_streams_replicated=None, block_specs_replicated=None, bytes_recoverable=None, bytes_transferred=None, char_specs_replicated=None, corrected_lins=None, dead_node=None, directories_replicated=None, dirs_changed=None, dirs_deleted=None, dirs_moved=None, dirs_new=None, duration=None, end_time=None, error=None, error_checksum_files_skipped=None, error_io_files_skipped=None, error_net_files_skipped=None, errors=None, failed_chunks=None, fifos_replicated=None, file_data_bytes=None, files_changed=None, files_linked=None, files_new=None, files_selected=None, files_transferred=None, files_unlinked=None, files_with_ads_replicated=None, flipped_lins=None, hard_links_replicated=None, hash_exceptions_fixed=None, hash_exceptions_found=None, id=None, job_id=None, lins_total=None, network_bytes_to_source=None, network_bytes_to_target=None, new_files_replicated=None, num_retransmitted_files=None, phases=None, policy_id=None, policy_name=None, regular_files_replicated=None, resynced_lins=None, retransmitted_files=None, retry=None, running_chunks=None, sockets_replicated=None, source_bytes_recovered=None, source_directories_created=None, source_directories_deleted=None, source_directories_linked=None, source_directories_unlinked=None, source_directories_visited=None, source_files_deleted=None, source_files_linked=None, source_files_unlinked=None, source_host=None, sparse_data_bytes=None, start_time=None, state=None, subreport_count=None, succeeded_chunks=None, symlinks_replicated=None, sync_type=None, target_bytes_recovered=None, target_directories_created=None, target_directories_deleted=None, target_directories_linked=None, target_directories_unlinked=None, target_files_deleted=None, target_files_linked=None, target_files_unlinked=None, target_path=None, target_snapshots=None, total_chunks=None, total_data_bytes=None, total_files=None, total_network_bytes=None, total_phases=None, unchanged_data_bytes=None, up_to_date_files_skipped=None, updated_files_replicated=None, user_conflict_files_skipped=None, warnings=None):  # noqa: E501
        """TargetReport - a model defined in Swagger"""  # noqa: E501

        self._action = None
        self._ads_streams_replicated = None
        self._block_specs_replicated = None
        self._bytes_recoverable = None
        self._bytes_transferred = None
        self._char_specs_replicated = None
        self._corrected_lins = None
        self._dead_node = None
        self._directories_replicated = None
        self._dirs_changed = None
        self._dirs_deleted = None
        self._dirs_moved = None
        self._dirs_new = None
        self._duration = None
        self._end_time = None
        self._error = None
        self._error_checksum_files_skipped = None
        self._error_io_files_skipped = None
        self._error_net_files_skipped = None
        self._errors = None
        self._failed_chunks = None
        self._fifos_replicated = None
        self._file_data_bytes = None
        self._files_changed = None
        self._files_linked = None
        self._files_new = None
        self._files_selected = None
        self._files_transferred = None
        self._files_unlinked = None
        self._files_with_ads_replicated = None
        self._flipped_lins = None
        self._hard_links_replicated = None
        self._hash_exceptions_fixed = None
        self._hash_exceptions_found = None
        self._id = None
        self._job_id = None
        self._lins_total = None
        self._network_bytes_to_source = None
        self._network_bytes_to_target = None
        self._new_files_replicated = None
        self._num_retransmitted_files = None
        self._phases = None
        self._policy_id = None
        self._policy_name = None
        self._regular_files_replicated = None
        self._resynced_lins = None
        self._retransmitted_files = None
        self._retry = None
        self._running_chunks = None
        self._sockets_replicated = None
        self._source_bytes_recovered = None
        self._source_directories_created = None
        self._source_directories_deleted = None
        self._source_directories_linked = None
        self._source_directories_unlinked = None
        self._source_directories_visited = None
        self._source_files_deleted = None
        self._source_files_linked = None
        self._source_files_unlinked = None
        self._source_host = None
        self._sparse_data_bytes = None
        self._start_time = None
        self._state = None
        self._subreport_count = None
        self._succeeded_chunks = None
        self._symlinks_replicated = None
        self._sync_type = None
        self._target_bytes_recovered = None
        self._target_directories_created = None
        self._target_directories_deleted = None
        self._target_directories_linked = None
        self._target_directories_unlinked = None
        self._target_files_deleted = None
        self._target_files_linked = None
        self._target_files_unlinked = None
        self._target_path = None
        self._target_snapshots = None
        self._total_chunks = None
        self._total_data_bytes = None
        self._total_files = None
        self._total_network_bytes = None
        self._total_phases = None
        self._unchanged_data_bytes = None
        self._up_to_date_files_skipped = None
        self._updated_files_replicated = None
        self._user_conflict_files_skipped = None
        self._warnings = None
        self.discriminator = None

        self.action = action
        self.ads_streams_replicated = ads_streams_replicated
        self.block_specs_replicated = block_specs_replicated
        self.bytes_recoverable = bytes_recoverable
        self.bytes_transferred = bytes_transferred
        self.char_specs_replicated = char_specs_replicated
        self.corrected_lins = corrected_lins
        self.dead_node = dead_node
        self.directories_replicated = directories_replicated
        self.dirs_changed = dirs_changed
        self.dirs_deleted = dirs_deleted
        self.dirs_moved = dirs_moved
        self.dirs_new = dirs_new
        if duration is not None:
            self.duration = duration
        if end_time is not None:
            self.end_time = end_time
        self.error = error
        self.error_checksum_files_skipped = error_checksum_files_skipped
        self.error_io_files_skipped = error_io_files_skipped
        self.error_net_files_skipped = error_net_files_skipped
        self.errors = errors
        self.failed_chunks = failed_chunks
        self.fifos_replicated = fifos_replicated
        self.file_data_bytes = file_data_bytes
        self.files_changed = files_changed
        self.files_linked = files_linked
        self.files_new = files_new
        self.files_selected = files_selected
        self.files_transferred = files_transferred
        self.files_unlinked = files_unlinked
        self.files_with_ads_replicated = files_with_ads_replicated
        self.flipped_lins = flipped_lins
        self.hard_links_replicated = hard_links_replicated
        self.hash_exceptions_fixed = hash_exceptions_fixed
        self.hash_exceptions_found = hash_exceptions_found
        self.id = id
        if job_id is not None:
            self.job_id = job_id
        self.lins_total = lins_total
        self.network_bytes_to_source = network_bytes_to_source
        self.network_bytes_to_target = network_bytes_to_target
        self.new_files_replicated = new_files_replicated
        self.num_retransmitted_files = num_retransmitted_files
        self.phases = phases
        self.policy_id = policy_id
        self.policy_name = policy_name
        self.regular_files_replicated = regular_files_replicated
        self.resynced_lins = resynced_lins
        self.retransmitted_files = retransmitted_files
        self.retry = retry
        self.running_chunks = running_chunks
        self.sockets_replicated = sockets_replicated
        self.source_bytes_recovered = source_bytes_recovered
        self.source_directories_created = source_directories_created
        self.source_directories_deleted = source_directories_deleted
        self.source_directories_linked = source_directories_linked
        self.source_directories_unlinked = source_directories_unlinked
        self.source_directories_visited = source_directories_visited
        self.source_files_deleted = source_files_deleted
        self.source_files_linked = source_files_linked
        self.source_files_unlinked = source_files_unlinked
        self.source_host = source_host
        self.sparse_data_bytes = sparse_data_bytes
        if start_time is not None:
            self.start_time = start_time
        self.state = state
        self.subreport_count = subreport_count
        self.succeeded_chunks = succeeded_chunks
        self.symlinks_replicated = symlinks_replicated
        self.sync_type = sync_type
        self.target_bytes_recovered = target_bytes_recovered
        self.target_directories_created = target_directories_created
        self.target_directories_deleted = target_directories_deleted
        self.target_directories_linked = target_directories_linked
        self.target_directories_unlinked = target_directories_unlinked
        self.target_files_deleted = target_files_deleted
        self.target_files_linked = target_files_linked
        self.target_files_unlinked = target_files_unlinked
        self.target_path = target_path
        self.target_snapshots = target_snapshots
        self.total_chunks = total_chunks
        self.total_data_bytes = total_data_bytes
        self.total_files = total_files
        self.total_network_bytes = total_network_bytes
        self.total_phases = total_phases
        self.unchanged_data_bytes = unchanged_data_bytes
        self.up_to_date_files_skipped = up_to_date_files_skipped
        self.updated_files_replicated = updated_files_replicated
        self.user_conflict_files_skipped = user_conflict_files_skipped
        self.warnings = warnings

    @property
    def action(self):
        """Gets the action of this TargetReport.  # noqa: E501

        The action to be taken by this job.  # noqa: E501

        :return: The action of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this TargetReport.

        The action to be taken by this job.  # noqa: E501

        :param action: The action of this TargetReport.  # noqa: E501
        :type: str
        """
        if action is None:
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        allowed_values = ["resync_prep", "allow_write", "allow_write_revert", "test", "run"]  # noqa: E501
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def ads_streams_replicated(self):
        """Gets the ads_streams_replicated of this TargetReport.  # noqa: E501

        The number of ads streams replicated by this job.  # noqa: E501

        :return: The ads_streams_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._ads_streams_replicated

    @ads_streams_replicated.setter
    def ads_streams_replicated(self, ads_streams_replicated):
        """Sets the ads_streams_replicated of this TargetReport.

        The number of ads streams replicated by this job.  # noqa: E501

        :param ads_streams_replicated: The ads_streams_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if ads_streams_replicated is None:
            raise ValueError("Invalid value for `ads_streams_replicated`, must not be `None`")  # noqa: E501

        self._ads_streams_replicated = ads_streams_replicated

    @property
    def block_specs_replicated(self):
        """Gets the block_specs_replicated of this TargetReport.  # noqa: E501

        The number of block specs replicated by this job.  # noqa: E501

        :return: The block_specs_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._block_specs_replicated

    @block_specs_replicated.setter
    def block_specs_replicated(self, block_specs_replicated):
        """Sets the block_specs_replicated of this TargetReport.

        The number of block specs replicated by this job.  # noqa: E501

        :param block_specs_replicated: The block_specs_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if block_specs_replicated is None:
            raise ValueError("Invalid value for `block_specs_replicated`, must not be `None`")  # noqa: E501

        self._block_specs_replicated = block_specs_replicated

    @property
    def bytes_recoverable(self):
        """Gets the bytes_recoverable of this TargetReport.  # noqa: E501

        The number of bytes recoverable by this job.  # noqa: E501

        :return: The bytes_recoverable of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._bytes_recoverable

    @bytes_recoverable.setter
    def bytes_recoverable(self, bytes_recoverable):
        """Sets the bytes_recoverable of this TargetReport.

        The number of bytes recoverable by this job.  # noqa: E501

        :param bytes_recoverable: The bytes_recoverable of this TargetReport.  # noqa: E501
        :type: int
        """
        if bytes_recoverable is None:
            raise ValueError("Invalid value for `bytes_recoverable`, must not be `None`")  # noqa: E501

        self._bytes_recoverable = bytes_recoverable

    @property
    def bytes_transferred(self):
        """Gets the bytes_transferred of this TargetReport.  # noqa: E501

        The number of bytes that have been transferred by this job.  # noqa: E501

        :return: The bytes_transferred of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._bytes_transferred

    @bytes_transferred.setter
    def bytes_transferred(self, bytes_transferred):
        """Sets the bytes_transferred of this TargetReport.

        The number of bytes that have been transferred by this job.  # noqa: E501

        :param bytes_transferred: The bytes_transferred of this TargetReport.  # noqa: E501
        :type: int
        """
        if bytes_transferred is None:
            raise ValueError("Invalid value for `bytes_transferred`, must not be `None`")  # noqa: E501

        self._bytes_transferred = bytes_transferred

    @property
    def char_specs_replicated(self):
        """Gets the char_specs_replicated of this TargetReport.  # noqa: E501

        The number of char specs replicated by this job.  # noqa: E501

        :return: The char_specs_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._char_specs_replicated

    @char_specs_replicated.setter
    def char_specs_replicated(self, char_specs_replicated):
        """Sets the char_specs_replicated of this TargetReport.

        The number of char specs replicated by this job.  # noqa: E501

        :param char_specs_replicated: The char_specs_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if char_specs_replicated is None:
            raise ValueError("Invalid value for `char_specs_replicated`, must not be `None`")  # noqa: E501

        self._char_specs_replicated = char_specs_replicated

    @property
    def corrected_lins(self):
        """Gets the corrected_lins of this TargetReport.  # noqa: E501

        The number of LINs corrected by this job.  # noqa: E501

        :return: The corrected_lins of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._corrected_lins

    @corrected_lins.setter
    def corrected_lins(self, corrected_lins):
        """Sets the corrected_lins of this TargetReport.

        The number of LINs corrected by this job.  # noqa: E501

        :param corrected_lins: The corrected_lins of this TargetReport.  # noqa: E501
        :type: int
        """
        if corrected_lins is None:
            raise ValueError("Invalid value for `corrected_lins`, must not be `None`")  # noqa: E501

        self._corrected_lins = corrected_lins

    @property
    def dead_node(self):
        """Gets the dead_node of this TargetReport.  # noqa: E501

        This field is true if the node running this job is dead.  # noqa: E501

        :return: The dead_node of this TargetReport.  # noqa: E501
        :rtype: bool
        """
        return self._dead_node

    @dead_node.setter
    def dead_node(self, dead_node):
        """Sets the dead_node of this TargetReport.

        This field is true if the node running this job is dead.  # noqa: E501

        :param dead_node: The dead_node of this TargetReport.  # noqa: E501
        :type: bool
        """
        if dead_node is None:
            raise ValueError("Invalid value for `dead_node`, must not be `None`")  # noqa: E501

        self._dead_node = dead_node

    @property
    def directories_replicated(self):
        """Gets the directories_replicated of this TargetReport.  # noqa: E501

        The number of directories replicated.  # noqa: E501

        :return: The directories_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._directories_replicated

    @directories_replicated.setter
    def directories_replicated(self, directories_replicated):
        """Sets the directories_replicated of this TargetReport.

        The number of directories replicated.  # noqa: E501

        :param directories_replicated: The directories_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if directories_replicated is None:
            raise ValueError("Invalid value for `directories_replicated`, must not be `None`")  # noqa: E501

        self._directories_replicated = directories_replicated

    @property
    def dirs_changed(self):
        """Gets the dirs_changed of this TargetReport.  # noqa: E501

        The number of directories changed by this job.  # noqa: E501

        :return: The dirs_changed of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._dirs_changed

    @dirs_changed.setter
    def dirs_changed(self, dirs_changed):
        """Sets the dirs_changed of this TargetReport.

        The number of directories changed by this job.  # noqa: E501

        :param dirs_changed: The dirs_changed of this TargetReport.  # noqa: E501
        :type: int
        """
        if dirs_changed is None:
            raise ValueError("Invalid value for `dirs_changed`, must not be `None`")  # noqa: E501

        self._dirs_changed = dirs_changed

    @property
    def dirs_deleted(self):
        """Gets the dirs_deleted of this TargetReport.  # noqa: E501

        The number of directories deleted by this job.  # noqa: E501

        :return: The dirs_deleted of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._dirs_deleted

    @dirs_deleted.setter
    def dirs_deleted(self, dirs_deleted):
        """Sets the dirs_deleted of this TargetReport.

        The number of directories deleted by this job.  # noqa: E501

        :param dirs_deleted: The dirs_deleted of this TargetReport.  # noqa: E501
        :type: int
        """
        if dirs_deleted is None:
            raise ValueError("Invalid value for `dirs_deleted`, must not be `None`")  # noqa: E501

        self._dirs_deleted = dirs_deleted

    @property
    def dirs_moved(self):
        """Gets the dirs_moved of this TargetReport.  # noqa: E501

        The number of directories moved by this job.  # noqa: E501

        :return: The dirs_moved of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._dirs_moved

    @dirs_moved.setter
    def dirs_moved(self, dirs_moved):
        """Sets the dirs_moved of this TargetReport.

        The number of directories moved by this job.  # noqa: E501

        :param dirs_moved: The dirs_moved of this TargetReport.  # noqa: E501
        :type: int
        """
        if dirs_moved is None:
            raise ValueError("Invalid value for `dirs_moved`, must not be `None`")  # noqa: E501

        self._dirs_moved = dirs_moved

    @property
    def dirs_new(self):
        """Gets the dirs_new of this TargetReport.  # noqa: E501

        The number of directories created by this job.  # noqa: E501

        :return: The dirs_new of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._dirs_new

    @dirs_new.setter
    def dirs_new(self, dirs_new):
        """Sets the dirs_new of this TargetReport.

        The number of directories created by this job.  # noqa: E501

        :param dirs_new: The dirs_new of this TargetReport.  # noqa: E501
        :type: int
        """
        if dirs_new is None:
            raise ValueError("Invalid value for `dirs_new`, must not be `None`")  # noqa: E501

        self._dirs_new = dirs_new

    @property
    def duration(self):
        """Gets the duration of this TargetReport.  # noqa: E501

        The amount of time in seconds between when the job was started and when it ended.  If the job has not yet ended, this is the amount of time since the job started.  This field is null if the job has not yet started.  # noqa: E501

        :return: The duration of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this TargetReport.

        The amount of time in seconds between when the job was started and when it ended.  If the job has not yet ended, this is the amount of time since the job started.  This field is null if the job has not yet started.  # noqa: E501

        :param duration: The duration of this TargetReport.  # noqa: E501
        :type: int
        """

        self._duration = duration

    @property
    def end_time(self):
        """Gets the end_time of this TargetReport.  # noqa: E501

        The time the job ended in unix epoch seconds. The field is null if the job hasn't ended.  # noqa: E501

        :return: The end_time of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this TargetReport.

        The time the job ended in unix epoch seconds. The field is null if the job hasn't ended.  # noqa: E501

        :param end_time: The end_time of this TargetReport.  # noqa: E501
        :type: int
        """

        self._end_time = end_time

    @property
    def error(self):
        """Gets the error of this TargetReport.  # noqa: E501

        The primary error message for this job.  # noqa: E501

        :return: The error of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this TargetReport.

        The primary error message for this job.  # noqa: E501

        :param error: The error of this TargetReport.  # noqa: E501
        :type: str
        """
        if error is None:
            raise ValueError("Invalid value for `error`, must not be `None`")  # noqa: E501

        self._error = error

    @property
    def error_checksum_files_skipped(self):
        """Gets the error_checksum_files_skipped of this TargetReport.  # noqa: E501

        The number of files with checksum errors skipped by this job.  # noqa: E501

        :return: The error_checksum_files_skipped of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._error_checksum_files_skipped

    @error_checksum_files_skipped.setter
    def error_checksum_files_skipped(self, error_checksum_files_skipped):
        """Sets the error_checksum_files_skipped of this TargetReport.

        The number of files with checksum errors skipped by this job.  # noqa: E501

        :param error_checksum_files_skipped: The error_checksum_files_skipped of this TargetReport.  # noqa: E501
        :type: int
        """
        if error_checksum_files_skipped is None:
            raise ValueError("Invalid value for `error_checksum_files_skipped`, must not be `None`")  # noqa: E501

        self._error_checksum_files_skipped = error_checksum_files_skipped

    @property
    def error_io_files_skipped(self):
        """Gets the error_io_files_skipped of this TargetReport.  # noqa: E501

        The number of files with io errors skipped by this job.  # noqa: E501

        :return: The error_io_files_skipped of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._error_io_files_skipped

    @error_io_files_skipped.setter
    def error_io_files_skipped(self, error_io_files_skipped):
        """Sets the error_io_files_skipped of this TargetReport.

        The number of files with io errors skipped by this job.  # noqa: E501

        :param error_io_files_skipped: The error_io_files_skipped of this TargetReport.  # noqa: E501
        :type: int
        """
        if error_io_files_skipped is None:
            raise ValueError("Invalid value for `error_io_files_skipped`, must not be `None`")  # noqa: E501

        self._error_io_files_skipped = error_io_files_skipped

    @property
    def error_net_files_skipped(self):
        """Gets the error_net_files_skipped of this TargetReport.  # noqa: E501

        The number of files with network errors skipped by this job.  # noqa: E501

        :return: The error_net_files_skipped of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._error_net_files_skipped

    @error_net_files_skipped.setter
    def error_net_files_skipped(self, error_net_files_skipped):
        """Sets the error_net_files_skipped of this TargetReport.

        The number of files with network errors skipped by this job.  # noqa: E501

        :param error_net_files_skipped: The error_net_files_skipped of this TargetReport.  # noqa: E501
        :type: int
        """
        if error_net_files_skipped is None:
            raise ValueError("Invalid value for `error_net_files_skipped`, must not be `None`")  # noqa: E501

        self._error_net_files_skipped = error_net_files_skipped

    @property
    def errors(self):
        """Gets the errors of this TargetReport.  # noqa: E501

        A list of error messages for this job.  # noqa: E501

        :return: The errors of this TargetReport.  # noqa: E501
        :rtype: list[str]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this TargetReport.

        A list of error messages for this job.  # noqa: E501

        :param errors: The errors of this TargetReport.  # noqa: E501
        :type: list[str]
        """
        if errors is None:
            raise ValueError("Invalid value for `errors`, must not be `None`")  # noqa: E501

        self._errors = errors

    @property
    def failed_chunks(self):
        """Gets the failed_chunks of this TargetReport.  # noqa: E501

        Tyhe number of data chunks that failed transmission.  # noqa: E501

        :return: The failed_chunks of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._failed_chunks

    @failed_chunks.setter
    def failed_chunks(self, failed_chunks):
        """Sets the failed_chunks of this TargetReport.

        Tyhe number of data chunks that failed transmission.  # noqa: E501

        :param failed_chunks: The failed_chunks of this TargetReport.  # noqa: E501
        :type: int
        """
        if failed_chunks is None:
            raise ValueError("Invalid value for `failed_chunks`, must not be `None`")  # noqa: E501

        self._failed_chunks = failed_chunks

    @property
    def fifos_replicated(self):
        """Gets the fifos_replicated of this TargetReport.  # noqa: E501

        The number of fifos replicated by this job.  # noqa: E501

        :return: The fifos_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._fifos_replicated

    @fifos_replicated.setter
    def fifos_replicated(self, fifos_replicated):
        """Sets the fifos_replicated of this TargetReport.

        The number of fifos replicated by this job.  # noqa: E501

        :param fifos_replicated: The fifos_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if fifos_replicated is None:
            raise ValueError("Invalid value for `fifos_replicated`, must not be `None`")  # noqa: E501

        self._fifos_replicated = fifos_replicated

    @property
    def file_data_bytes(self):
        """Gets the file_data_bytes of this TargetReport.  # noqa: E501

        The number of bytes transferred that belong to files.  # noqa: E501

        :return: The file_data_bytes of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._file_data_bytes

    @file_data_bytes.setter
    def file_data_bytes(self, file_data_bytes):
        """Sets the file_data_bytes of this TargetReport.

        The number of bytes transferred that belong to files.  # noqa: E501

        :param file_data_bytes: The file_data_bytes of this TargetReport.  # noqa: E501
        :type: int
        """
        if file_data_bytes is None:
            raise ValueError("Invalid value for `file_data_bytes`, must not be `None`")  # noqa: E501

        self._file_data_bytes = file_data_bytes

    @property
    def files_changed(self):
        """Gets the files_changed of this TargetReport.  # noqa: E501

        The number of files changed by this job.  # noqa: E501

        :return: The files_changed of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._files_changed

    @files_changed.setter
    def files_changed(self, files_changed):
        """Sets the files_changed of this TargetReport.

        The number of files changed by this job.  # noqa: E501

        :param files_changed: The files_changed of this TargetReport.  # noqa: E501
        :type: int
        """
        if files_changed is None:
            raise ValueError("Invalid value for `files_changed`, must not be `None`")  # noqa: E501

        self._files_changed = files_changed

    @property
    def files_linked(self):
        """Gets the files_linked of this TargetReport.  # noqa: E501

        The number of files linked by this job.  # noqa: E501

        :return: The files_linked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._files_linked

    @files_linked.setter
    def files_linked(self, files_linked):
        """Sets the files_linked of this TargetReport.

        The number of files linked by this job.  # noqa: E501

        :param files_linked: The files_linked of this TargetReport.  # noqa: E501
        :type: int
        """
        if files_linked is None:
            raise ValueError("Invalid value for `files_linked`, must not be `None`")  # noqa: E501

        self._files_linked = files_linked

    @property
    def files_new(self):
        """Gets the files_new of this TargetReport.  # noqa: E501

        The number of files created by this job.  # noqa: E501

        :return: The files_new of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._files_new

    @files_new.setter
    def files_new(self, files_new):
        """Sets the files_new of this TargetReport.

        The number of files created by this job.  # noqa: E501

        :param files_new: The files_new of this TargetReport.  # noqa: E501
        :type: int
        """
        if files_new is None:
            raise ValueError("Invalid value for `files_new`, must not be `None`")  # noqa: E501

        self._files_new = files_new

    @property
    def files_selected(self):
        """Gets the files_selected of this TargetReport.  # noqa: E501

        The number of files selected by this job.  # noqa: E501

        :return: The files_selected of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._files_selected

    @files_selected.setter
    def files_selected(self, files_selected):
        """Sets the files_selected of this TargetReport.

        The number of files selected by this job.  # noqa: E501

        :param files_selected: The files_selected of this TargetReport.  # noqa: E501
        :type: int
        """
        if files_selected is None:
            raise ValueError("Invalid value for `files_selected`, must not be `None`")  # noqa: E501

        self._files_selected = files_selected

    @property
    def files_transferred(self):
        """Gets the files_transferred of this TargetReport.  # noqa: E501

        The number of files transferred by this job.  # noqa: E501

        :return: The files_transferred of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._files_transferred

    @files_transferred.setter
    def files_transferred(self, files_transferred):
        """Sets the files_transferred of this TargetReport.

        The number of files transferred by this job.  # noqa: E501

        :param files_transferred: The files_transferred of this TargetReport.  # noqa: E501
        :type: int
        """
        if files_transferred is None:
            raise ValueError("Invalid value for `files_transferred`, must not be `None`")  # noqa: E501

        self._files_transferred = files_transferred

    @property
    def files_unlinked(self):
        """Gets the files_unlinked of this TargetReport.  # noqa: E501

        The number of files unlinked by this job.  # noqa: E501

        :return: The files_unlinked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._files_unlinked

    @files_unlinked.setter
    def files_unlinked(self, files_unlinked):
        """Sets the files_unlinked of this TargetReport.

        The number of files unlinked by this job.  # noqa: E501

        :param files_unlinked: The files_unlinked of this TargetReport.  # noqa: E501
        :type: int
        """
        if files_unlinked is None:
            raise ValueError("Invalid value for `files_unlinked`, must not be `None`")  # noqa: E501

        self._files_unlinked = files_unlinked

    @property
    def files_with_ads_replicated(self):
        """Gets the files_with_ads_replicated of this TargetReport.  # noqa: E501

        The number of files with ads replicated by this job.  # noqa: E501

        :return: The files_with_ads_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._files_with_ads_replicated

    @files_with_ads_replicated.setter
    def files_with_ads_replicated(self, files_with_ads_replicated):
        """Sets the files_with_ads_replicated of this TargetReport.

        The number of files with ads replicated by this job.  # noqa: E501

        :param files_with_ads_replicated: The files_with_ads_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if files_with_ads_replicated is None:
            raise ValueError("Invalid value for `files_with_ads_replicated`, must not be `None`")  # noqa: E501

        self._files_with_ads_replicated = files_with_ads_replicated

    @property
    def flipped_lins(self):
        """Gets the flipped_lins of this TargetReport.  # noqa: E501

        The number of LINs flipped by this job.  # noqa: E501

        :return: The flipped_lins of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._flipped_lins

    @flipped_lins.setter
    def flipped_lins(self, flipped_lins):
        """Sets the flipped_lins of this TargetReport.

        The number of LINs flipped by this job.  # noqa: E501

        :param flipped_lins: The flipped_lins of this TargetReport.  # noqa: E501
        :type: int
        """
        if flipped_lins is None:
            raise ValueError("Invalid value for `flipped_lins`, must not be `None`")  # noqa: E501

        self._flipped_lins = flipped_lins

    @property
    def hard_links_replicated(self):
        """Gets the hard_links_replicated of this TargetReport.  # noqa: E501

        The number of hard links replicated by this job.  # noqa: E501

        :return: The hard_links_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._hard_links_replicated

    @hard_links_replicated.setter
    def hard_links_replicated(self, hard_links_replicated):
        """Sets the hard_links_replicated of this TargetReport.

        The number of hard links replicated by this job.  # noqa: E501

        :param hard_links_replicated: The hard_links_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if hard_links_replicated is None:
            raise ValueError("Invalid value for `hard_links_replicated`, must not be `None`")  # noqa: E501

        self._hard_links_replicated = hard_links_replicated

    @property
    def hash_exceptions_fixed(self):
        """Gets the hash_exceptions_fixed of this TargetReport.  # noqa: E501

        The number of hash exceptions fixed by this job.  # noqa: E501

        :return: The hash_exceptions_fixed of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._hash_exceptions_fixed

    @hash_exceptions_fixed.setter
    def hash_exceptions_fixed(self, hash_exceptions_fixed):
        """Sets the hash_exceptions_fixed of this TargetReport.

        The number of hash exceptions fixed by this job.  # noqa: E501

        :param hash_exceptions_fixed: The hash_exceptions_fixed of this TargetReport.  # noqa: E501
        :type: int
        """
        if hash_exceptions_fixed is None:
            raise ValueError("Invalid value for `hash_exceptions_fixed`, must not be `None`")  # noqa: E501

        self._hash_exceptions_fixed = hash_exceptions_fixed

    @property
    def hash_exceptions_found(self):
        """Gets the hash_exceptions_found of this TargetReport.  # noqa: E501

        The number of hash exceptions found by this job.  # noqa: E501

        :return: The hash_exceptions_found of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._hash_exceptions_found

    @hash_exceptions_found.setter
    def hash_exceptions_found(self, hash_exceptions_found):
        """Sets the hash_exceptions_found of this TargetReport.

        The number of hash exceptions found by this job.  # noqa: E501

        :param hash_exceptions_found: The hash_exceptions_found of this TargetReport.  # noqa: E501
        :type: int
        """
        if hash_exceptions_found is None:
            raise ValueError("Invalid value for `hash_exceptions_found`, must not be `None`")  # noqa: E501

        self._hash_exceptions_found = hash_exceptions_found

    @property
    def id(self):
        """Gets the id of this TargetReport.  # noqa: E501

        A unique identifier for this object.  # noqa: E501

        :return: The id of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TargetReport.

        A unique identifier for this object.  # noqa: E501

        :param id: The id of this TargetReport.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def job_id(self):
        """Gets the job_id of this TargetReport.  # noqa: E501

        The ID of the job.  # noqa: E501

        :return: The job_id of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this TargetReport.

        The ID of the job.  # noqa: E501

        :param job_id: The job_id of this TargetReport.  # noqa: E501
        :type: int
        """

        self._job_id = job_id

    @property
    def lins_total(self):
        """Gets the lins_total of this TargetReport.  # noqa: E501

        The number of LINs transferred by this job.  # noqa: E501

        :return: The lins_total of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._lins_total

    @lins_total.setter
    def lins_total(self, lins_total):
        """Sets the lins_total of this TargetReport.

        The number of LINs transferred by this job.  # noqa: E501

        :param lins_total: The lins_total of this TargetReport.  # noqa: E501
        :type: int
        """
        if lins_total is None:
            raise ValueError("Invalid value for `lins_total`, must not be `None`")  # noqa: E501

        self._lins_total = lins_total

    @property
    def network_bytes_to_source(self):
        """Gets the network_bytes_to_source of this TargetReport.  # noqa: E501

        The total number of bytes sent to the source by this job.  # noqa: E501

        :return: The network_bytes_to_source of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._network_bytes_to_source

    @network_bytes_to_source.setter
    def network_bytes_to_source(self, network_bytes_to_source):
        """Sets the network_bytes_to_source of this TargetReport.

        The total number of bytes sent to the source by this job.  # noqa: E501

        :param network_bytes_to_source: The network_bytes_to_source of this TargetReport.  # noqa: E501
        :type: int
        """
        if network_bytes_to_source is None:
            raise ValueError("Invalid value for `network_bytes_to_source`, must not be `None`")  # noqa: E501

        self._network_bytes_to_source = network_bytes_to_source

    @property
    def network_bytes_to_target(self):
        """Gets the network_bytes_to_target of this TargetReport.  # noqa: E501

        The total number of bytes sent to the target by this job.  # noqa: E501

        :return: The network_bytes_to_target of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._network_bytes_to_target

    @network_bytes_to_target.setter
    def network_bytes_to_target(self, network_bytes_to_target):
        """Sets the network_bytes_to_target of this TargetReport.

        The total number of bytes sent to the target by this job.  # noqa: E501

        :param network_bytes_to_target: The network_bytes_to_target of this TargetReport.  # noqa: E501
        :type: int
        """
        if network_bytes_to_target is None:
            raise ValueError("Invalid value for `network_bytes_to_target`, must not be `None`")  # noqa: E501

        self._network_bytes_to_target = network_bytes_to_target

    @property
    def new_files_replicated(self):
        """Gets the new_files_replicated of this TargetReport.  # noqa: E501

        The number of new files replicated by this job.  # noqa: E501

        :return: The new_files_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._new_files_replicated

    @new_files_replicated.setter
    def new_files_replicated(self, new_files_replicated):
        """Sets the new_files_replicated of this TargetReport.

        The number of new files replicated by this job.  # noqa: E501

        :param new_files_replicated: The new_files_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if new_files_replicated is None:
            raise ValueError("Invalid value for `new_files_replicated`, must not be `None`")  # noqa: E501

        self._new_files_replicated = new_files_replicated

    @property
    def num_retransmitted_files(self):
        """Gets the num_retransmitted_files of this TargetReport.  # noqa: E501

        The number of files that have been retransmitted by this job.  # noqa: E501

        :return: The num_retransmitted_files of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._num_retransmitted_files

    @num_retransmitted_files.setter
    def num_retransmitted_files(self, num_retransmitted_files):
        """Sets the num_retransmitted_files of this TargetReport.

        The number of files that have been retransmitted by this job.  # noqa: E501

        :param num_retransmitted_files: The num_retransmitted_files of this TargetReport.  # noqa: E501
        :type: int
        """
        if num_retransmitted_files is None:
            raise ValueError("Invalid value for `num_retransmitted_files`, must not be `None`")  # noqa: E501

        self._num_retransmitted_files = num_retransmitted_files

    @property
    def phases(self):
        """Gets the phases of this TargetReport.  # noqa: E501

        Data for each phase of this job.  # noqa: E501

        :return: The phases of this TargetReport.  # noqa: E501
        :rtype: list[ReportSubreportPhase]
        """
        return self._phases

    @phases.setter
    def phases(self, phases):
        """Sets the phases of this TargetReport.

        Data for each phase of this job.  # noqa: E501

        :param phases: The phases of this TargetReport.  # noqa: E501
        :type: list[ReportSubreportPhase]
        """
        if phases is None:
            raise ValueError("Invalid value for `phases`, must not be `None`")  # noqa: E501

        self._phases = phases

    @property
    def policy_id(self):
        """Gets the policy_id of this TargetReport.  # noqa: E501

        The ID of the policy.  # noqa: E501

        :return: The policy_id of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._policy_id

    @policy_id.setter
    def policy_id(self, policy_id):
        """Sets the policy_id of this TargetReport.

        The ID of the policy.  # noqa: E501

        :param policy_id: The policy_id of this TargetReport.  # noqa: E501
        :type: str
        """
        if policy_id is None:
            raise ValueError("Invalid value for `policy_id`, must not be `None`")  # noqa: E501

        self._policy_id = policy_id

    @property
    def policy_name(self):
        """Gets the policy_name of this TargetReport.  # noqa: E501

        The name of the policy.  # noqa: E501

        :return: The policy_name of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._policy_name

    @policy_name.setter
    def policy_name(self, policy_name):
        """Sets the policy_name of this TargetReport.

        The name of the policy.  # noqa: E501

        :param policy_name: The policy_name of this TargetReport.  # noqa: E501
        :type: str
        """
        if policy_name is None:
            raise ValueError("Invalid value for `policy_name`, must not be `None`")  # noqa: E501

        self._policy_name = policy_name

    @property
    def regular_files_replicated(self):
        """Gets the regular_files_replicated of this TargetReport.  # noqa: E501

        The number of regular files replicated by this job.  # noqa: E501

        :return: The regular_files_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._regular_files_replicated

    @regular_files_replicated.setter
    def regular_files_replicated(self, regular_files_replicated):
        """Sets the regular_files_replicated of this TargetReport.

        The number of regular files replicated by this job.  # noqa: E501

        :param regular_files_replicated: The regular_files_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if regular_files_replicated is None:
            raise ValueError("Invalid value for `regular_files_replicated`, must not be `None`")  # noqa: E501

        self._regular_files_replicated = regular_files_replicated

    @property
    def resynced_lins(self):
        """Gets the resynced_lins of this TargetReport.  # noqa: E501

        The number of LINs resynched by this job.  # noqa: E501

        :return: The resynced_lins of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._resynced_lins

    @resynced_lins.setter
    def resynced_lins(self, resynced_lins):
        """Sets the resynced_lins of this TargetReport.

        The number of LINs resynched by this job.  # noqa: E501

        :param resynced_lins: The resynced_lins of this TargetReport.  # noqa: E501
        :type: int
        """
        if resynced_lins is None:
            raise ValueError("Invalid value for `resynced_lins`, must not be `None`")  # noqa: E501

        self._resynced_lins = resynced_lins

    @property
    def retransmitted_files(self):
        """Gets the retransmitted_files of this TargetReport.  # noqa: E501

        The files that have been retransmitted by this job.  # noqa: E501

        :return: The retransmitted_files of this TargetReport.  # noqa: E501
        :rtype: list[str]
        """
        return self._retransmitted_files

    @retransmitted_files.setter
    def retransmitted_files(self, retransmitted_files):
        """Sets the retransmitted_files of this TargetReport.

        The files that have been retransmitted by this job.  # noqa: E501

        :param retransmitted_files: The retransmitted_files of this TargetReport.  # noqa: E501
        :type: list[str]
        """
        if retransmitted_files is None:
            raise ValueError("Invalid value for `retransmitted_files`, must not be `None`")  # noqa: E501

        self._retransmitted_files = retransmitted_files

    @property
    def retry(self):
        """Gets the retry of this TargetReport.  # noqa: E501

        The number of times the job has been retried.  # noqa: E501

        :return: The retry of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._retry

    @retry.setter
    def retry(self, retry):
        """Sets the retry of this TargetReport.

        The number of times the job has been retried.  # noqa: E501

        :param retry: The retry of this TargetReport.  # noqa: E501
        :type: int
        """
        if retry is None:
            raise ValueError("Invalid value for `retry`, must not be `None`")  # noqa: E501

        self._retry = retry

    @property
    def running_chunks(self):
        """Gets the running_chunks of this TargetReport.  # noqa: E501

        The number of data chunks currently being transmitted.  # noqa: E501

        :return: The running_chunks of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._running_chunks

    @running_chunks.setter
    def running_chunks(self, running_chunks):
        """Sets the running_chunks of this TargetReport.

        The number of data chunks currently being transmitted.  # noqa: E501

        :param running_chunks: The running_chunks of this TargetReport.  # noqa: E501
        :type: int
        """
        if running_chunks is None:
            raise ValueError("Invalid value for `running_chunks`, must not be `None`")  # noqa: E501

        self._running_chunks = running_chunks

    @property
    def sockets_replicated(self):
        """Gets the sockets_replicated of this TargetReport.  # noqa: E501

        The number of sockets replicated by this job.  # noqa: E501

        :return: The sockets_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._sockets_replicated

    @sockets_replicated.setter
    def sockets_replicated(self, sockets_replicated):
        """Sets the sockets_replicated of this TargetReport.

        The number of sockets replicated by this job.  # noqa: E501

        :param sockets_replicated: The sockets_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if sockets_replicated is None:
            raise ValueError("Invalid value for `sockets_replicated`, must not be `None`")  # noqa: E501

        self._sockets_replicated = sockets_replicated

    @property
    def source_bytes_recovered(self):
        """Gets the source_bytes_recovered of this TargetReport.  # noqa: E501

        The number of bytes recovered on the source.  # noqa: E501

        :return: The source_bytes_recovered of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_bytes_recovered

    @source_bytes_recovered.setter
    def source_bytes_recovered(self, source_bytes_recovered):
        """Sets the source_bytes_recovered of this TargetReport.

        The number of bytes recovered on the source.  # noqa: E501

        :param source_bytes_recovered: The source_bytes_recovered of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_bytes_recovered is None:
            raise ValueError("Invalid value for `source_bytes_recovered`, must not be `None`")  # noqa: E501

        self._source_bytes_recovered = source_bytes_recovered

    @property
    def source_directories_created(self):
        """Gets the source_directories_created of this TargetReport.  # noqa: E501

        The number of directories created on the source.  # noqa: E501

        :return: The source_directories_created of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_directories_created

    @source_directories_created.setter
    def source_directories_created(self, source_directories_created):
        """Sets the source_directories_created of this TargetReport.

        The number of directories created on the source.  # noqa: E501

        :param source_directories_created: The source_directories_created of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_directories_created is None:
            raise ValueError("Invalid value for `source_directories_created`, must not be `None`")  # noqa: E501

        self._source_directories_created = source_directories_created

    @property
    def source_directories_deleted(self):
        """Gets the source_directories_deleted of this TargetReport.  # noqa: E501

        The number of directories deleted on the source.  # noqa: E501

        :return: The source_directories_deleted of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_directories_deleted

    @source_directories_deleted.setter
    def source_directories_deleted(self, source_directories_deleted):
        """Sets the source_directories_deleted of this TargetReport.

        The number of directories deleted on the source.  # noqa: E501

        :param source_directories_deleted: The source_directories_deleted of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_directories_deleted is None:
            raise ValueError("Invalid value for `source_directories_deleted`, must not be `None`")  # noqa: E501

        self._source_directories_deleted = source_directories_deleted

    @property
    def source_directories_linked(self):
        """Gets the source_directories_linked of this TargetReport.  # noqa: E501

        The number of directories linked on the source.  # noqa: E501

        :return: The source_directories_linked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_directories_linked

    @source_directories_linked.setter
    def source_directories_linked(self, source_directories_linked):
        """Sets the source_directories_linked of this TargetReport.

        The number of directories linked on the source.  # noqa: E501

        :param source_directories_linked: The source_directories_linked of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_directories_linked is None:
            raise ValueError("Invalid value for `source_directories_linked`, must not be `None`")  # noqa: E501

        self._source_directories_linked = source_directories_linked

    @property
    def source_directories_unlinked(self):
        """Gets the source_directories_unlinked of this TargetReport.  # noqa: E501

        The number of directories unlinked on the source.  # noqa: E501

        :return: The source_directories_unlinked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_directories_unlinked

    @source_directories_unlinked.setter
    def source_directories_unlinked(self, source_directories_unlinked):
        """Sets the source_directories_unlinked of this TargetReport.

        The number of directories unlinked on the source.  # noqa: E501

        :param source_directories_unlinked: The source_directories_unlinked of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_directories_unlinked is None:
            raise ValueError("Invalid value for `source_directories_unlinked`, must not be `None`")  # noqa: E501

        self._source_directories_unlinked = source_directories_unlinked

    @property
    def source_directories_visited(self):
        """Gets the source_directories_visited of this TargetReport.  # noqa: E501

        The number of directories visited on the source.  # noqa: E501

        :return: The source_directories_visited of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_directories_visited

    @source_directories_visited.setter
    def source_directories_visited(self, source_directories_visited):
        """Sets the source_directories_visited of this TargetReport.

        The number of directories visited on the source.  # noqa: E501

        :param source_directories_visited: The source_directories_visited of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_directories_visited is None:
            raise ValueError("Invalid value for `source_directories_visited`, must not be `None`")  # noqa: E501

        self._source_directories_visited = source_directories_visited

    @property
    def source_files_deleted(self):
        """Gets the source_files_deleted of this TargetReport.  # noqa: E501

        The number of files deleted on the source.  # noqa: E501

        :return: The source_files_deleted of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_files_deleted

    @source_files_deleted.setter
    def source_files_deleted(self, source_files_deleted):
        """Sets the source_files_deleted of this TargetReport.

        The number of files deleted on the source.  # noqa: E501

        :param source_files_deleted: The source_files_deleted of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_files_deleted is None:
            raise ValueError("Invalid value for `source_files_deleted`, must not be `None`")  # noqa: E501

        self._source_files_deleted = source_files_deleted

    @property
    def source_files_linked(self):
        """Gets the source_files_linked of this TargetReport.  # noqa: E501

        The number of files linked on the source.  # noqa: E501

        :return: The source_files_linked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_files_linked

    @source_files_linked.setter
    def source_files_linked(self, source_files_linked):
        """Sets the source_files_linked of this TargetReport.

        The number of files linked on the source.  # noqa: E501

        :param source_files_linked: The source_files_linked of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_files_linked is None:
            raise ValueError("Invalid value for `source_files_linked`, must not be `None`")  # noqa: E501

        self._source_files_linked = source_files_linked

    @property
    def source_files_unlinked(self):
        """Gets the source_files_unlinked of this TargetReport.  # noqa: E501

        The number of files unlinked on the source.  # noqa: E501

        :return: The source_files_unlinked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._source_files_unlinked

    @source_files_unlinked.setter
    def source_files_unlinked(self, source_files_unlinked):
        """Sets the source_files_unlinked of this TargetReport.

        The number of files unlinked on the source.  # noqa: E501

        :param source_files_unlinked: The source_files_unlinked of this TargetReport.  # noqa: E501
        :type: int
        """
        if source_files_unlinked is None:
            raise ValueError("Invalid value for `source_files_unlinked`, must not be `None`")  # noqa: E501

        self._source_files_unlinked = source_files_unlinked

    @property
    def source_host(self):
        """Gets the source_host of this TargetReport.  # noqa: E501

        Hostname or IP address of sync source cluster.  # noqa: E501

        :return: The source_host of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._source_host

    @source_host.setter
    def source_host(self, source_host):
        """Sets the source_host of this TargetReport.

        Hostname or IP address of sync source cluster.  # noqa: E501

        :param source_host: The source_host of this TargetReport.  # noqa: E501
        :type: str
        """
        if source_host is None:
            raise ValueError("Invalid value for `source_host`, must not be `None`")  # noqa: E501

        self._source_host = source_host

    @property
    def sparse_data_bytes(self):
        """Gets the sparse_data_bytes of this TargetReport.  # noqa: E501

        The number of sparse data bytes transferred by this job.  # noqa: E501

        :return: The sparse_data_bytes of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._sparse_data_bytes

    @sparse_data_bytes.setter
    def sparse_data_bytes(self, sparse_data_bytes):
        """Sets the sparse_data_bytes of this TargetReport.

        The number of sparse data bytes transferred by this job.  # noqa: E501

        :param sparse_data_bytes: The sparse_data_bytes of this TargetReport.  # noqa: E501
        :type: int
        """
        if sparse_data_bytes is None:
            raise ValueError("Invalid value for `sparse_data_bytes`, must not be `None`")  # noqa: E501

        self._sparse_data_bytes = sparse_data_bytes

    @property
    def start_time(self):
        """Gets the start_time of this TargetReport.  # noqa: E501

        The time the job started in unix epoch seconds. The field is null if the job hasn't started.  # noqa: E501

        :return: The start_time of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this TargetReport.

        The time the job started in unix epoch seconds. The field is null if the job hasn't started.  # noqa: E501

        :param start_time: The start_time of this TargetReport.  # noqa: E501
        :type: int
        """

        self._start_time = start_time

    @property
    def state(self):
        """Gets the state of this TargetReport.  # noqa: E501

        The state of the job.  # noqa: E501

        :return: The state of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this TargetReport.

        The state of the job.  # noqa: E501

        :param state: The state of this TargetReport.  # noqa: E501
        :type: str
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501
        allowed_values = ["scheduled", "running", "paused", "finished", "failed", "canceled", "needs_attention", "skipped", "pending", "unknown"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def subreport_count(self):
        """Gets the subreport_count of this TargetReport.  # noqa: E501

        The number of subreports that are available for this job report.  # noqa: E501

        :return: The subreport_count of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._subreport_count

    @subreport_count.setter
    def subreport_count(self, subreport_count):
        """Sets the subreport_count of this TargetReport.

        The number of subreports that are available for this job report.  # noqa: E501

        :param subreport_count: The subreport_count of this TargetReport.  # noqa: E501
        :type: int
        """
        if subreport_count is None:
            raise ValueError("Invalid value for `subreport_count`, must not be `None`")  # noqa: E501

        self._subreport_count = subreport_count

    @property
    def succeeded_chunks(self):
        """Gets the succeeded_chunks of this TargetReport.  # noqa: E501

        The number of data chunks that have been transmitted successfully.  # noqa: E501

        :return: The succeeded_chunks of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._succeeded_chunks

    @succeeded_chunks.setter
    def succeeded_chunks(self, succeeded_chunks):
        """Sets the succeeded_chunks of this TargetReport.

        The number of data chunks that have been transmitted successfully.  # noqa: E501

        :param succeeded_chunks: The succeeded_chunks of this TargetReport.  # noqa: E501
        :type: int
        """
        if succeeded_chunks is None:
            raise ValueError("Invalid value for `succeeded_chunks`, must not be `None`")  # noqa: E501

        self._succeeded_chunks = succeeded_chunks

    @property
    def symlinks_replicated(self):
        """Gets the symlinks_replicated of this TargetReport.  # noqa: E501

        The number of symlinks replicated by this job.  # noqa: E501

        :return: The symlinks_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._symlinks_replicated

    @symlinks_replicated.setter
    def symlinks_replicated(self, symlinks_replicated):
        """Sets the symlinks_replicated of this TargetReport.

        The number of symlinks replicated by this job.  # noqa: E501

        :param symlinks_replicated: The symlinks_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if symlinks_replicated is None:
            raise ValueError("Invalid value for `symlinks_replicated`, must not be `None`")  # noqa: E501

        self._symlinks_replicated = symlinks_replicated

    @property
    def sync_type(self):
        """Gets the sync_type of this TargetReport.  # noqa: E501

        The type of sync being performed by this job.  # noqa: E501

        :return: The sync_type of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._sync_type

    @sync_type.setter
    def sync_type(self, sync_type):
        """Sets the sync_type of this TargetReport.

        The type of sync being performed by this job.  # noqa: E501

        :param sync_type: The sync_type of this TargetReport.  # noqa: E501
        :type: str
        """
        if sync_type is None:
            raise ValueError("Invalid value for `sync_type`, must not be `None`")  # noqa: E501
        allowed_values = ["invalid", "legacy", "initial", "incremental", "upgrade", "fofb", "domainmark"]  # noqa: E501
        if sync_type not in allowed_values:
            raise ValueError(
                "Invalid value for `sync_type` ({0}), must be one of {1}"  # noqa: E501
                .format(sync_type, allowed_values)
            )

        self._sync_type = sync_type

    @property
    def target_bytes_recovered(self):
        """Gets the target_bytes_recovered of this TargetReport.  # noqa: E501

        The number of bytes recovered on the target.  # noqa: E501

        :return: The target_bytes_recovered of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._target_bytes_recovered

    @target_bytes_recovered.setter
    def target_bytes_recovered(self, target_bytes_recovered):
        """Sets the target_bytes_recovered of this TargetReport.

        The number of bytes recovered on the target.  # noqa: E501

        :param target_bytes_recovered: The target_bytes_recovered of this TargetReport.  # noqa: E501
        :type: int
        """
        if target_bytes_recovered is None:
            raise ValueError("Invalid value for `target_bytes_recovered`, must not be `None`")  # noqa: E501

        self._target_bytes_recovered = target_bytes_recovered

    @property
    def target_directories_created(self):
        """Gets the target_directories_created of this TargetReport.  # noqa: E501

        The number of directories created on the target.  # noqa: E501

        :return: The target_directories_created of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._target_directories_created

    @target_directories_created.setter
    def target_directories_created(self, target_directories_created):
        """Sets the target_directories_created of this TargetReport.

        The number of directories created on the target.  # noqa: E501

        :param target_directories_created: The target_directories_created of this TargetReport.  # noqa: E501
        :type: int
        """
        if target_directories_created is None:
            raise ValueError("Invalid value for `target_directories_created`, must not be `None`")  # noqa: E501

        self._target_directories_created = target_directories_created

    @property
    def target_directories_deleted(self):
        """Gets the target_directories_deleted of this TargetReport.  # noqa: E501

        The number of directories deleted on the target.  # noqa: E501

        :return: The target_directories_deleted of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._target_directories_deleted

    @target_directories_deleted.setter
    def target_directories_deleted(self, target_directories_deleted):
        """Sets the target_directories_deleted of this TargetReport.

        The number of directories deleted on the target.  # noqa: E501

        :param target_directories_deleted: The target_directories_deleted of this TargetReport.  # noqa: E501
        :type: int
        """
        if target_directories_deleted is None:
            raise ValueError("Invalid value for `target_directories_deleted`, must not be `None`")  # noqa: E501

        self._target_directories_deleted = target_directories_deleted

    @property
    def target_directories_linked(self):
        """Gets the target_directories_linked of this TargetReport.  # noqa: E501

        The number of directories linked on the target.  # noqa: E501

        :return: The target_directories_linked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._target_directories_linked

    @target_directories_linked.setter
    def target_directories_linked(self, target_directories_linked):
        """Sets the target_directories_linked of this TargetReport.

        The number of directories linked on the target.  # noqa: E501

        :param target_directories_linked: The target_directories_linked of this TargetReport.  # noqa: E501
        :type: int
        """
        if target_directories_linked is None:
            raise ValueError("Invalid value for `target_directories_linked`, must not be `None`")  # noqa: E501

        self._target_directories_linked = target_directories_linked

    @property
    def target_directories_unlinked(self):
        """Gets the target_directories_unlinked of this TargetReport.  # noqa: E501

        The number of directories unlinked on the target.  # noqa: E501

        :return: The target_directories_unlinked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._target_directories_unlinked

    @target_directories_unlinked.setter
    def target_directories_unlinked(self, target_directories_unlinked):
        """Sets the target_directories_unlinked of this TargetReport.

        The number of directories unlinked on the target.  # noqa: E501

        :param target_directories_unlinked: The target_directories_unlinked of this TargetReport.  # noqa: E501
        :type: int
        """
        if target_directories_unlinked is None:
            raise ValueError("Invalid value for `target_directories_unlinked`, must not be `None`")  # noqa: E501

        self._target_directories_unlinked = target_directories_unlinked

    @property
    def target_files_deleted(self):
        """Gets the target_files_deleted of this TargetReport.  # noqa: E501

        The number of files deleted on the target.  # noqa: E501

        :return: The target_files_deleted of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._target_files_deleted

    @target_files_deleted.setter
    def target_files_deleted(self, target_files_deleted):
        """Sets the target_files_deleted of this TargetReport.

        The number of files deleted on the target.  # noqa: E501

        :param target_files_deleted: The target_files_deleted of this TargetReport.  # noqa: E501
        :type: int
        """
        if target_files_deleted is None:
            raise ValueError("Invalid value for `target_files_deleted`, must not be `None`")  # noqa: E501

        self._target_files_deleted = target_files_deleted

    @property
    def target_files_linked(self):
        """Gets the target_files_linked of this TargetReport.  # noqa: E501

        The number of files linked on the target.  # noqa: E501

        :return: The target_files_linked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._target_files_linked

    @target_files_linked.setter
    def target_files_linked(self, target_files_linked):
        """Sets the target_files_linked of this TargetReport.

        The number of files linked on the target.  # noqa: E501

        :param target_files_linked: The target_files_linked of this TargetReport.  # noqa: E501
        :type: int
        """
        if target_files_linked is None:
            raise ValueError("Invalid value for `target_files_linked`, must not be `None`")  # noqa: E501

        self._target_files_linked = target_files_linked

    @property
    def target_files_unlinked(self):
        """Gets the target_files_unlinked of this TargetReport.  # noqa: E501

        The number of files unlinked on the target.  # noqa: E501

        :return: The target_files_unlinked of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._target_files_unlinked

    @target_files_unlinked.setter
    def target_files_unlinked(self, target_files_unlinked):
        """Sets the target_files_unlinked of this TargetReport.

        The number of files unlinked on the target.  # noqa: E501

        :param target_files_unlinked: The target_files_unlinked of this TargetReport.  # noqa: E501
        :type: int
        """
        if target_files_unlinked is None:
            raise ValueError("Invalid value for `target_files_unlinked`, must not be `None`")  # noqa: E501

        self._target_files_unlinked = target_files_unlinked

    @property
    def target_path(self):
        """Gets the target_path of this TargetReport.  # noqa: E501

        Absolute filesystem path on the target cluster for the sync destination.  # noqa: E501

        :return: The target_path of this TargetReport.  # noqa: E501
        :rtype: str
        """
        return self._target_path

    @target_path.setter
    def target_path(self, target_path):
        """Sets the target_path of this TargetReport.

        Absolute filesystem path on the target cluster for the sync destination.  # noqa: E501

        :param target_path: The target_path of this TargetReport.  # noqa: E501
        :type: str
        """
        if target_path is None:
            raise ValueError("Invalid value for `target_path`, must not be `None`")  # noqa: E501

        self._target_path = target_path

    @property
    def target_snapshots(self):
        """Gets the target_snapshots of this TargetReport.  # noqa: E501

        The target snapshots created by this job.  # noqa: E501

        :return: The target_snapshots of this TargetReport.  # noqa: E501
        :rtype: list[str]
        """
        return self._target_snapshots

    @target_snapshots.setter
    def target_snapshots(self, target_snapshots):
        """Sets the target_snapshots of this TargetReport.

        The target snapshots created by this job.  # noqa: E501

        :param target_snapshots: The target_snapshots of this TargetReport.  # noqa: E501
        :type: list[str]
        """
        if target_snapshots is None:
            raise ValueError("Invalid value for `target_snapshots`, must not be `None`")  # noqa: E501

        self._target_snapshots = target_snapshots

    @property
    def total_chunks(self):
        """Gets the total_chunks of this TargetReport.  # noqa: E501

        The total number of data chunks transmitted by this job.  # noqa: E501

        :return: The total_chunks of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._total_chunks

    @total_chunks.setter
    def total_chunks(self, total_chunks):
        """Sets the total_chunks of this TargetReport.

        The total number of data chunks transmitted by this job.  # noqa: E501

        :param total_chunks: The total_chunks of this TargetReport.  # noqa: E501
        :type: int
        """
        if total_chunks is None:
            raise ValueError("Invalid value for `total_chunks`, must not be `None`")  # noqa: E501

        self._total_chunks = total_chunks

    @property
    def total_data_bytes(self):
        """Gets the total_data_bytes of this TargetReport.  # noqa: E501

        The total number of bytes transferred by this job.  # noqa: E501

        :return: The total_data_bytes of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._total_data_bytes

    @total_data_bytes.setter
    def total_data_bytes(self, total_data_bytes):
        """Sets the total_data_bytes of this TargetReport.

        The total number of bytes transferred by this job.  # noqa: E501

        :param total_data_bytes: The total_data_bytes of this TargetReport.  # noqa: E501
        :type: int
        """
        if total_data_bytes is None:
            raise ValueError("Invalid value for `total_data_bytes`, must not be `None`")  # noqa: E501

        self._total_data_bytes = total_data_bytes

    @property
    def total_files(self):
        """Gets the total_files of this TargetReport.  # noqa: E501

        The number of files affected by this job.  # noqa: E501

        :return: The total_files of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._total_files

    @total_files.setter
    def total_files(self, total_files):
        """Sets the total_files of this TargetReport.

        The number of files affected by this job.  # noqa: E501

        :param total_files: The total_files of this TargetReport.  # noqa: E501
        :type: int
        """
        if total_files is None:
            raise ValueError("Invalid value for `total_files`, must not be `None`")  # noqa: E501

        self._total_files = total_files

    @property
    def total_network_bytes(self):
        """Gets the total_network_bytes of this TargetReport.  # noqa: E501

        The total number of bytes sent over the network by this job.  # noqa: E501

        :return: The total_network_bytes of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._total_network_bytes

    @total_network_bytes.setter
    def total_network_bytes(self, total_network_bytes):
        """Sets the total_network_bytes of this TargetReport.

        The total number of bytes sent over the network by this job.  # noqa: E501

        :param total_network_bytes: The total_network_bytes of this TargetReport.  # noqa: E501
        :type: int
        """
        if total_network_bytes is None:
            raise ValueError("Invalid value for `total_network_bytes`, must not be `None`")  # noqa: E501

        self._total_network_bytes = total_network_bytes

    @property
    def total_phases(self):
        """Gets the total_phases of this TargetReport.  # noqa: E501

        The total number of phases for this job.  # noqa: E501

        :return: The total_phases of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._total_phases

    @total_phases.setter
    def total_phases(self, total_phases):
        """Sets the total_phases of this TargetReport.

        The total number of phases for this job.  # noqa: E501

        :param total_phases: The total_phases of this TargetReport.  # noqa: E501
        :type: int
        """
        if total_phases is None:
            raise ValueError("Invalid value for `total_phases`, must not be `None`")  # noqa: E501

        self._total_phases = total_phases

    @property
    def unchanged_data_bytes(self):
        """Gets the unchanged_data_bytes of this TargetReport.  # noqa: E501

        The number of bytes unchanged by this job.  # noqa: E501

        :return: The unchanged_data_bytes of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._unchanged_data_bytes

    @unchanged_data_bytes.setter
    def unchanged_data_bytes(self, unchanged_data_bytes):
        """Sets the unchanged_data_bytes of this TargetReport.

        The number of bytes unchanged by this job.  # noqa: E501

        :param unchanged_data_bytes: The unchanged_data_bytes of this TargetReport.  # noqa: E501
        :type: int
        """
        if unchanged_data_bytes is None:
            raise ValueError("Invalid value for `unchanged_data_bytes`, must not be `None`")  # noqa: E501

        self._unchanged_data_bytes = unchanged_data_bytes

    @property
    def up_to_date_files_skipped(self):
        """Gets the up_to_date_files_skipped of this TargetReport.  # noqa: E501

        The number of up-to-date files skipped by this job.  # noqa: E501

        :return: The up_to_date_files_skipped of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._up_to_date_files_skipped

    @up_to_date_files_skipped.setter
    def up_to_date_files_skipped(self, up_to_date_files_skipped):
        """Sets the up_to_date_files_skipped of this TargetReport.

        The number of up-to-date files skipped by this job.  # noqa: E501

        :param up_to_date_files_skipped: The up_to_date_files_skipped of this TargetReport.  # noqa: E501
        :type: int
        """
        if up_to_date_files_skipped is None:
            raise ValueError("Invalid value for `up_to_date_files_skipped`, must not be `None`")  # noqa: E501

        self._up_to_date_files_skipped = up_to_date_files_skipped

    @property
    def updated_files_replicated(self):
        """Gets the updated_files_replicated of this TargetReport.  # noqa: E501

        The number of updated files replicated by this job.  # noqa: E501

        :return: The updated_files_replicated of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._updated_files_replicated

    @updated_files_replicated.setter
    def updated_files_replicated(self, updated_files_replicated):
        """Sets the updated_files_replicated of this TargetReport.

        The number of updated files replicated by this job.  # noqa: E501

        :param updated_files_replicated: The updated_files_replicated of this TargetReport.  # noqa: E501
        :type: int
        """
        if updated_files_replicated is None:
            raise ValueError("Invalid value for `updated_files_replicated`, must not be `None`")  # noqa: E501

        self._updated_files_replicated = updated_files_replicated

    @property
    def user_conflict_files_skipped(self):
        """Gets the user_conflict_files_skipped of this TargetReport.  # noqa: E501

        The number of files with user conflicts skipped by this job.  # noqa: E501

        :return: The user_conflict_files_skipped of this TargetReport.  # noqa: E501
        :rtype: int
        """
        return self._user_conflict_files_skipped

    @user_conflict_files_skipped.setter
    def user_conflict_files_skipped(self, user_conflict_files_skipped):
        """Sets the user_conflict_files_skipped of this TargetReport.

        The number of files with user conflicts skipped by this job.  # noqa: E501

        :param user_conflict_files_skipped: The user_conflict_files_skipped of this TargetReport.  # noqa: E501
        :type: int
        """
        if user_conflict_files_skipped is None:
            raise ValueError("Invalid value for `user_conflict_files_skipped`, must not be `None`")  # noqa: E501

        self._user_conflict_files_skipped = user_conflict_files_skipped

    @property
    def warnings(self):
        """Gets the warnings of this TargetReport.  # noqa: E501

        A list of warning messages for this job.  # noqa: E501

        :return: The warnings of this TargetReport.  # noqa: E501
        :rtype: list[str]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this TargetReport.

        A list of warning messages for this job.  # noqa: E501

        :param warnings: The warnings of this TargetReport.  # noqa: E501
        :type: list[str]
        """
        if warnings is None:
            raise ValueError("Invalid value for `warnings`, must not be `None`")  # noqa: E501

        self._warnings = warnings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TargetReport):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
