# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 3
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isi_sdk_8_0.api_client import ApiClient


class CloudApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_cloud_access_item(self, cloud_access_item, **kwargs):  # noqa: E501
        """create_cloud_access_item  # noqa: E501

        Add a cluster identifier to access list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cloud_access_item(cloud_access_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudAccessItem cloud_access_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_cloud_access_item_with_http_info(cloud_access_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_access_item_with_http_info(cloud_access_item, **kwargs)  # noqa: E501
            return data

    def create_cloud_access_item_with_http_info(self, cloud_access_item, **kwargs):  # noqa: E501
        """create_cloud_access_item  # noqa: E501

        Add a cluster identifier to access list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cloud_access_item_with_http_info(cloud_access_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudAccessItem cloud_access_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_access_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_access_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_access_item' is set
        if ('cloud_access_item' not in params or
                params['cloud_access_item'] is None):
            raise ValueError("Missing the required parameter `cloud_access_item` when calling `create_cloud_access_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_access_item' in params:
            body_params = params['cloud_access_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/access', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_account(self, cloud_account, **kwargs):  # noqa: E501
        """create_cloud_account  # noqa: E501

        Create a new account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cloud_account(cloud_account, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudAccountCreateParams cloud_account: (required)
        :return: CreateCloudAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_cloud_account_with_http_info(cloud_account, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_account_with_http_info(cloud_account, **kwargs)  # noqa: E501
            return data

    def create_cloud_account_with_http_info(self, cloud_account, **kwargs):  # noqa: E501
        """create_cloud_account  # noqa: E501

        Create a new account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cloud_account_with_http_info(cloud_account, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudAccountCreateParams cloud_account: (required)
        :return: CreateCloudAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_account']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_account' is set
        if ('cloud_account' not in params or
                params['cloud_account'] is None):
            raise ValueError("Missing the required parameter `cloud_account` when calling `create_cloud_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_account' in params:
            body_params = params['cloud_account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/accounts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCloudAccountResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_job(self, cloud_job, **kwargs):  # noqa: E501
        """create_cloud_job  # noqa: E501

        Create a new job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cloud_job(cloud_job, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudJobCreateParams cloud_job: (required)
        :return: CreateCloudJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_cloud_job_with_http_info(cloud_job, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_job_with_http_info(cloud_job, **kwargs)  # noqa: E501
            return data

    def create_cloud_job_with_http_info(self, cloud_job, **kwargs):  # noqa: E501
        """create_cloud_job  # noqa: E501

        Create a new job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cloud_job_with_http_info(cloud_job, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudJobCreateParams cloud_job: (required)
        :return: CreateCloudJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_job']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_job' is set
        if ('cloud_job' not in params or
                params['cloud_job'] is None):
            raise ValueError("Missing the required parameter `cloud_job` when calling `create_cloud_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_job' in params:
            body_params = params['cloud_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCloudJobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_pool(self, cloud_pool, **kwargs):  # noqa: E501
        """create_cloud_pool  # noqa: E501

        Create a new pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cloud_pool(cloud_pool, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudPoolCreateParams cloud_pool: (required)
        :return: CreateCloudPoolResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_cloud_pool_with_http_info(cloud_pool, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_pool_with_http_info(cloud_pool, **kwargs)  # noqa: E501
            return data

    def create_cloud_pool_with_http_info(self, cloud_pool, **kwargs):  # noqa: E501
        """create_cloud_pool  # noqa: E501

        Create a new pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_cloud_pool_with_http_info(cloud_pool, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudPoolCreateParams cloud_pool: (required)
        :return: CreateCloudPoolResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_pool']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_pool' is set
        if ('cloud_pool' not in params or
                params['cloud_pool'] is None):
            raise ValueError("Missing the required parameter `cloud_pool` when calling `create_cloud_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_pool' in params:
            body_params = params['cloud_pool']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/pools', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCloudPoolResponse',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_settings_encryption_key_item(self, **kwargs):  # noqa: E501
        """create_settings_encryption_key_item  # noqa: E501

        Regenerate master encryption key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_settings_encryption_key_item(async=True)
        >>> result = thread.get()

        :param async bool
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_settings_encryption_key_item_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_settings_encryption_key_item_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_settings_encryption_key_item_with_http_info(self, **kwargs):  # noqa: E501
        """create_settings_encryption_key_item  # noqa: E501

        Regenerate master encryption key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_settings_encryption_key_item_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_settings_encryption_key_item" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings/encryption-key', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_settings_reporting_eula_item(self, settings_reporting_eula_item, **kwargs):  # noqa: E501
        """create_settings_reporting_eula_item  # noqa: E501

        Accept telemetry collection EULA.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_settings_reporting_eula_item(settings_reporting_eula_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param SettingsReportingEulaItem settings_reporting_eula_item: (required)
        :return: SettingsReportingEulaItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_settings_reporting_eula_item_with_http_info(settings_reporting_eula_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_settings_reporting_eula_item_with_http_info(settings_reporting_eula_item, **kwargs)  # noqa: E501
            return data

    def create_settings_reporting_eula_item_with_http_info(self, settings_reporting_eula_item, **kwargs):  # noqa: E501
        """create_settings_reporting_eula_item  # noqa: E501

        Accept telemetry collection EULA.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_settings_reporting_eula_item_with_http_info(settings_reporting_eula_item, async=True)
        >>> result = thread.get()

        :param async bool
        :param SettingsReportingEulaItem settings_reporting_eula_item: (required)
        :return: SettingsReportingEulaItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_reporting_eula_item']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_settings_reporting_eula_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_reporting_eula_item' is set
        if ('settings_reporting_eula_item' not in params or
                params['settings_reporting_eula_item'] is None):
            raise ValueError("Missing the required parameter `settings_reporting_eula_item` when calling `create_settings_reporting_eula_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_reporting_eula_item' in params:
            body_params = params['settings_reporting_eula_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings/reporting-eula', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsReportingEulaItem',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_access_guid(self, cloud_access_guid, **kwargs):  # noqa: E501
        """delete_cloud_access_guid  # noqa: E501

        Delete cloud access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_cloud_access_guid(cloud_access_guid, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_access_guid: Delete cloud access. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_cloud_access_guid_with_http_info(cloud_access_guid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_access_guid_with_http_info(cloud_access_guid, **kwargs)  # noqa: E501
            return data

    def delete_cloud_access_guid_with_http_info(self, cloud_access_guid, **kwargs):  # noqa: E501
        """delete_cloud_access_guid  # noqa: E501

        Delete cloud access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_cloud_access_guid_with_http_info(cloud_access_guid, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_access_guid: Delete cloud access. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_access_guid']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_access_guid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_access_guid' is set
        if ('cloud_access_guid' not in params or
                params['cloud_access_guid'] is None):
            raise ValueError("Missing the required parameter `cloud_access_guid` when calling `delete_cloud_access_guid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_access_guid' in params:
            path_params['CloudAccessGuid'] = params['cloud_access_guid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/access/{CloudAccessGuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_account(self, cloud_account_id, **kwargs):  # noqa: E501
        """delete_cloud_account  # noqa: E501

        Delete cloud account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_cloud_account(cloud_account_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_account_id: Delete cloud account. (required)
        :param str acknowledge_force_delete: A value of 1 acknowledges that the user is deleting data.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_cloud_account_with_http_info(cloud_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_account_with_http_info(cloud_account_id, **kwargs)  # noqa: E501
            return data

    def delete_cloud_account_with_http_info(self, cloud_account_id, **kwargs):  # noqa: E501
        """delete_cloud_account  # noqa: E501

        Delete cloud account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_cloud_account_with_http_info(cloud_account_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_account_id: Delete cloud account. (required)
        :param str acknowledge_force_delete: A value of 1 acknowledges that the user is deleting data.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_account_id', 'acknowledge_force_delete']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_account_id' is set
        if ('cloud_account_id' not in params or
                params['cloud_account_id'] is None):
            raise ValueError("Missing the required parameter `cloud_account_id` when calling `delete_cloud_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_account_id' in params:
            path_params['CloudAccountId'] = params['cloud_account_id']  # noqa: E501

        query_params = []
        if 'acknowledge_force_delete' in params:
            query_params.append(('acknowledge_force_delete', params['acknowledge_force_delete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/accounts/{CloudAccountId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_pool(self, cloud_pool_id, **kwargs):  # noqa: E501
        """delete_cloud_pool  # noqa: E501

        Delete a cloud pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_cloud_pool(cloud_pool_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_pool_id: Delete a cloud pool. (required)
        :param str acknowledge_force_delete: A value of 1 acknowledges that the user is deleting data.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_cloud_pool_with_http_info(cloud_pool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_pool_with_http_info(cloud_pool_id, **kwargs)  # noqa: E501
            return data

    def delete_cloud_pool_with_http_info(self, cloud_pool_id, **kwargs):  # noqa: E501
        """delete_cloud_pool  # noqa: E501

        Delete a cloud pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_cloud_pool_with_http_info(cloud_pool_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_pool_id: Delete a cloud pool. (required)
        :param str acknowledge_force_delete: A value of 1 acknowledges that the user is deleting data.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_pool_id', 'acknowledge_force_delete']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_pool_id' is set
        if ('cloud_pool_id' not in params or
                params['cloud_pool_id'] is None):
            raise ValueError("Missing the required parameter `cloud_pool_id` when calling `delete_cloud_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pool_id' in params:
            path_params['CloudPoolId'] = params['cloud_pool_id']  # noqa: E501

        query_params = []
        if 'acknowledge_force_delete' in params:
            query_params.append(('acknowledge_force_delete', params['acknowledge_force_delete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/pools/{CloudPoolId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_settings_reporting_eula(self, **kwargs):  # noqa: E501
        """delete_settings_reporting_eula  # noqa: E501

        Revoke acceptance of telemetry collection EULA.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_settings_reporting_eula(async=True)
        >>> result = thread.get()

        :param async bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_settings_reporting_eula_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_settings_reporting_eula_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_settings_reporting_eula_with_http_info(self, **kwargs):  # noqa: E501
        """delete_settings_reporting_eula  # noqa: E501

        Revoke acceptance of telemetry collection EULA.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_settings_reporting_eula_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_settings_reporting_eula" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings/reporting-eula', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_access_guid(self, cloud_access_guid, **kwargs):  # noqa: E501
        """get_cloud_access_guid  # noqa: E501

        Retrieve cloud access information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_access_guid(cloud_access_guid, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_access_guid: Retrieve cloud access information. (required)
        :return: CloudAccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cloud_access_guid_with_http_info(cloud_access_guid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_access_guid_with_http_info(cloud_access_guid, **kwargs)  # noqa: E501
            return data

    def get_cloud_access_guid_with_http_info(self, cloud_access_guid, **kwargs):  # noqa: E501
        """get_cloud_access_guid  # noqa: E501

        Retrieve cloud access information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_access_guid_with_http_info(cloud_access_guid, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_access_guid: Retrieve cloud access information. (required)
        :return: CloudAccess
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_access_guid']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_access_guid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_access_guid' is set
        if ('cloud_access_guid' not in params or
                params['cloud_access_guid'] is None):
            raise ValueError("Missing the required parameter `cloud_access_guid` when calling `get_cloud_access_guid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_access_guid' in params:
            path_params['CloudAccessGuid'] = params['cloud_access_guid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/access/{CloudAccessGuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudAccess',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_account(self, cloud_account_id, **kwargs):  # noqa: E501
        """get_cloud_account  # noqa: E501

        Retrieve cloud account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_account(cloud_account_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_account_id: Retrieve cloud account information. (required)
        :return: CloudAccounts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cloud_account_with_http_info(cloud_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_account_with_http_info(cloud_account_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_account_with_http_info(self, cloud_account_id, **kwargs):  # noqa: E501
        """get_cloud_account  # noqa: E501

        Retrieve cloud account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_account_with_http_info(cloud_account_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_account_id: Retrieve cloud account information. (required)
        :return: CloudAccounts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_account_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_account_id' is set
        if ('cloud_account_id' not in params or
                params['cloud_account_id'] is None):
            raise ValueError("Missing the required parameter `cloud_account_id` when calling `get_cloud_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_account_id' in params:
            path_params['CloudAccountId'] = params['cloud_account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/accounts/{CloudAccountId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudAccounts',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_job(self, cloud_job_id, **kwargs):  # noqa: E501
        """get_cloud_job  # noqa: E501

        Retrieve cloudpool job information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_job(cloud_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_job_id: Retrieve cloudpool job information. (required)
        :return: CloudJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cloud_job_with_http_info(cloud_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_job_with_http_info(cloud_job_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_job_with_http_info(self, cloud_job_id, **kwargs):  # noqa: E501
        """get_cloud_job  # noqa: E501

        Retrieve cloudpool job information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_job_with_http_info(cloud_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_job_id: Retrieve cloudpool job information. (required)
        :return: CloudJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_job_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_job_id' is set
        if ('cloud_job_id' not in params or
                params['cloud_job_id'] is None):
            raise ValueError("Missing the required parameter `cloud_job_id` when calling `get_cloud_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_job_id' in params:
            path_params['CloudJobId'] = params['cloud_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs/{CloudJobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudJobs',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_jobs_file(self, cloud_jobs_file_id, **kwargs):  # noqa: E501
        """get_cloud_jobs_file  # noqa: E501

        Retrieve files associated with a cloudpool job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_jobs_file(cloud_jobs_file_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_jobs_file_id: Retrieve files associated with a cloudpool job. (required)
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool batch: If true, only \"limit\" and \"page\" arguments are honored.  Query will return all results, unsorted, as quickly as possible.
        :param int limit: Return no more than this many results at once (see resume).
        :param int page: Works only when \"batch\" parameter and \"limit\" parameters are specified.  Indicates which the page index of results to be returned
        :param str dir: The direction of the sort.
        :return: CloudJobsFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cloud_jobs_file_with_http_info(cloud_jobs_file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_jobs_file_with_http_info(cloud_jobs_file_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_jobs_file_with_http_info(self, cloud_jobs_file_id, **kwargs):  # noqa: E501
        """get_cloud_jobs_file  # noqa: E501

        Retrieve files associated with a cloudpool job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_jobs_file_with_http_info(cloud_jobs_file_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_jobs_file_id: Retrieve files associated with a cloudpool job. (required)
        :param str sort: The field that will be used for sorting.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param bool batch: If true, only \"limit\" and \"page\" arguments are honored.  Query will return all results, unsorted, as quickly as possible.
        :param int limit: Return no more than this many results at once (see resume).
        :param int page: Works only when \"batch\" parameter and \"limit\" parameters are specified.  Indicates which the page index of results to be returned
        :param str dir: The direction of the sort.
        :return: CloudJobsFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_jobs_file_id', 'sort', 'resume', 'batch', 'limit', 'page', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_jobs_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_jobs_file_id' is set
        if ('cloud_jobs_file_id' not in params or
                params['cloud_jobs_file_id'] is None):
            raise ValueError("Missing the required parameter `cloud_jobs_file_id` when calling `get_cloud_jobs_file`")  # noqa: E501

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_cloud_jobs_file`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'cloud_jobs_file_id' in params:
            path_params['CloudJobsFileId'] = params['cloud_jobs_file_id']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'batch' in params:
            query_params.append(('batch', params['batch']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs-files/{CloudJobsFileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudJobsFiles',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_pool(self, cloud_pool_id, **kwargs):  # noqa: E501
        """get_cloud_pool  # noqa: E501

        Retrieve cloud pool information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_pool(cloud_pool_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_pool_id: Retrieve cloud pool information (required)
        :return: CloudPools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cloud_pool_with_http_info(cloud_pool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_pool_with_http_info(cloud_pool_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_pool_with_http_info(self, cloud_pool_id, **kwargs):  # noqa: E501
        """get_cloud_pool  # noqa: E501

        Retrieve cloud pool information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_pool_with_http_info(cloud_pool_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str cloud_pool_id: Retrieve cloud pool information (required)
        :return: CloudPools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_pool_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_pool_id' is set
        if ('cloud_pool_id' not in params or
                params['cloud_pool_id'] is None):
            raise ValueError("Missing the required parameter `cloud_pool_id` when calling `get_cloud_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pool_id' in params:
            path_params['CloudPoolId'] = params['cloud_pool_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/pools/{CloudPoolId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudPools',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_settings(self, **kwargs):  # noqa: E501
        """get_cloud_settings  # noqa: E501

        List all cloud settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_settings(async=True)
        >>> result = thread.get()

        :param async bool
        :return: CloudSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_cloud_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cloud_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_cloud_settings  # noqa: E501

        List all cloud settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_cloud_settings_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: CloudSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudSettings',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_access(self, **kwargs):  # noqa: E501
        """list_cloud_access  # noqa: E501

        List all accessible cluster identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cloud_access(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: CloudAccessExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_cloud_access_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_access_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_access_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_access  # noqa: E501

        List all accessible cluster identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cloud_access_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: CloudAccessExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_access" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_access`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudAccessExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_accounts(self, **kwargs):  # noqa: E501
        """list_cloud_accounts  # noqa: E501

        List all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cloud_accounts(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: CloudAccountsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_cloud_accounts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_accounts_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_accounts_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_accounts  # noqa: E501

        List all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cloud_accounts_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: CloudAccountsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_accounts" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_accounts`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/accounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudAccountsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_jobs(self, **kwargs):  # noqa: E501
        """list_cloud_jobs  # noqa: E501

        List all cloudpools jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cloud_jobs(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: CloudJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_cloud_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_jobs  # noqa: E501

        List all cloudpools jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cloud_jobs_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: CloudJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_jobs`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudJobsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_pools(self, **kwargs):  # noqa: E501
        """list_cloud_pools  # noqa: E501

        List all pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cloud_pools(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: CloudPoolsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_cloud_pools_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_pools_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_pools_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_pools  # noqa: E501

        List all pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_cloud_pools_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param str sort: The field that will be used for sorting.
        :param int limit: Return no more than this many results at once (see resume).
        :param str dir: The direction of the sort.
        :return: CloudPoolsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort', 'limit', 'dir']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_pools" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_pools`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/pools', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudPoolsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_settings_reporting_eula(self, **kwargs):  # noqa: E501
        """list_settings_reporting_eula  # noqa: E501

        View telemetry collection EULA acceptance and content URI.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_settings_reporting_eula(async=True)
        >>> result = thread.get()

        :param async bool
        :return: SettingsReportingEulaItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_settings_reporting_eula_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_settings_reporting_eula_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_settings_reporting_eula_with_http_info(self, **kwargs):  # noqa: E501
        """list_settings_reporting_eula  # noqa: E501

        View telemetry collection EULA acceptance and content URI.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_settings_reporting_eula_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: SettingsReportingEulaItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_settings_reporting_eula" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings/reporting-eula', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsReportingEulaItem',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_account(self, cloud_account, cloud_account_id, **kwargs):  # noqa: E501
        """update_cloud_account  # noqa: E501

        Modify cloud account.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cloud_account(cloud_account, cloud_account_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudAccount cloud_account: (required)
        :param str cloud_account_id: Modify cloud account.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cloud_account_with_http_info(cloud_account, cloud_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_account_with_http_info(cloud_account, cloud_account_id, **kwargs)  # noqa: E501
            return data

    def update_cloud_account_with_http_info(self, cloud_account, cloud_account_id, **kwargs):  # noqa: E501
        """update_cloud_account  # noqa: E501

        Modify cloud account.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cloud_account_with_http_info(cloud_account, cloud_account_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudAccount cloud_account: (required)
        :param str cloud_account_id: Modify cloud account.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_account', 'cloud_account_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_account' is set
        if ('cloud_account' not in params or
                params['cloud_account'] is None):
            raise ValueError("Missing the required parameter `cloud_account` when calling `update_cloud_account`")  # noqa: E501
        # verify the required parameter 'cloud_account_id' is set
        if ('cloud_account_id' not in params or
                params['cloud_account_id'] is None):
            raise ValueError("Missing the required parameter `cloud_account_id` when calling `update_cloud_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_account_id' in params:
            path_params['CloudAccountId'] = params['cloud_account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_account' in params:
            body_params = params['cloud_account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/accounts/{CloudAccountId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_job(self, cloud_job, cloud_job_id, **kwargs):  # noqa: E501
        """update_cloud_job  # noqa: E501

        Modify a cloud job or operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cloud_job(cloud_job, cloud_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudJob cloud_job: (required)
        :param str cloud_job_id: Modify a cloud job or operation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cloud_job_with_http_info(cloud_job, cloud_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_job_with_http_info(cloud_job, cloud_job_id, **kwargs)  # noqa: E501
            return data

    def update_cloud_job_with_http_info(self, cloud_job, cloud_job_id, **kwargs):  # noqa: E501
        """update_cloud_job  # noqa: E501

        Modify a cloud job or operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cloud_job_with_http_info(cloud_job, cloud_job_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudJob cloud_job: (required)
        :param str cloud_job_id: Modify a cloud job or operation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_job', 'cloud_job_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_job' is set
        if ('cloud_job' not in params or
                params['cloud_job'] is None):
            raise ValueError("Missing the required parameter `cloud_job` when calling `update_cloud_job`")  # noqa: E501
        # verify the required parameter 'cloud_job_id' is set
        if ('cloud_job_id' not in params or
                params['cloud_job_id'] is None):
            raise ValueError("Missing the required parameter `cloud_job_id` when calling `update_cloud_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_job_id' in params:
            path_params['CloudJobId'] = params['cloud_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_job' in params:
            body_params = params['cloud_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs/{CloudJobId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_pool(self, cloud_pool, cloud_pool_id, **kwargs):  # noqa: E501
        """update_cloud_pool  # noqa: E501

        Modify a cloud pool.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cloud_pool(cloud_pool, cloud_pool_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudPool cloud_pool: (required)
        :param str cloud_pool_id: Modify a cloud pool.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cloud_pool_with_http_info(cloud_pool, cloud_pool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_pool_with_http_info(cloud_pool, cloud_pool_id, **kwargs)  # noqa: E501
            return data

    def update_cloud_pool_with_http_info(self, cloud_pool, cloud_pool_id, **kwargs):  # noqa: E501
        """update_cloud_pool  # noqa: E501

        Modify a cloud pool.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cloud_pool_with_http_info(cloud_pool, cloud_pool_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudPool cloud_pool: (required)
        :param str cloud_pool_id: Modify a cloud pool.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_pool', 'cloud_pool_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_pool' is set
        if ('cloud_pool' not in params or
                params['cloud_pool'] is None):
            raise ValueError("Missing the required parameter `cloud_pool` when calling `update_cloud_pool`")  # noqa: E501
        # verify the required parameter 'cloud_pool_id' is set
        if ('cloud_pool_id' not in params or
                params['cloud_pool_id'] is None):
            raise ValueError("Missing the required parameter `cloud_pool_id` when calling `update_cloud_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pool_id' in params:
            path_params['CloudPoolId'] = params['cloud_pool_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_pool' in params:
            body_params = params['cloud_pool']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/pools/{CloudPoolId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_settings(self, cloud_settings, **kwargs):  # noqa: E501
        """update_cloud_settings  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cloud_settings(cloud_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudSettingsSettings cloud_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_cloud_settings_with_http_info(cloud_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_settings_with_http_info(cloud_settings, **kwargs)  # noqa: E501
            return data

    def update_cloud_settings_with_http_info(self, cloud_settings, **kwargs):  # noqa: E501
        """update_cloud_settings  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_cloud_settings_with_http_info(cloud_settings, async=True)
        >>> result = thread.get()

        :param async bool
        :param CloudSettingsSettings cloud_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_settings']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_settings' is set
        if ('cloud_settings' not in params or
                params['cloud_settings'] is None):
            raise ValueError("Missing the required parameter `cloud_settings` when calling `update_cloud_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_settings' in params:
            body_params = params['cloud_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
