# KEN-MCP 🏗️ - Universal MCP Server Generator

KEN-MCP is a powerful MCP (Model Context Protocol) server generator that creates complete, production-ready MCP servers from natural language descriptions. It works for ANY type of MCP - not just APIs!

## Features

- 🎯 **Universal Generation**: Creates MCP servers for any purpose - productivity tools, data processing, utilities, creative tools, and more
- 🤖 **AI-Powered**: Uses Claude's capabilities to understand requirements and generate appropriate implementations
- 📦 **Complete Projects**: Generates full project structure with server code, documentation, and configuration
- ✅ **Production Ready**: Includes proper error handling, type hints, and validation
- 📚 **Well Documented**: Auto-generates comprehensive README and documentation

## Installation

KEN-MCP is an MCP server that runs within Claude Desktop. To install:

1. Add to your Claude Desktop configuration:

```json
{
  "mcpServers": {
    "KEN-MCP": {
      "command": "python",
      "args": ["/path/to/KEN-MCP/server.py"]
    }
  }
}
```

2. Restart Claude Desktop

## Usage

Simply describe what kind of MCP server you want:

```
Generate an MCP server that:
- Manages todo lists with priorities
- Tracks deadlines
- Can mark items as complete
```

KEN-MCP will create a complete MCP server with all the necessary tools, proper error handling, and documentation.

### Examples

- **Productivity**: "I want an MCP that manages todo lists with priorities and deadlines"
- **Development**: "Create an MCP for generating git commit messages based on code changes"
- **Data**: "Build an MCP that can analyze CSV files and generate statistics"
- **Utilities**: "I need an MCP for converting between different text encodings"
- **Creative**: "Make an MCP that generates creative writing prompts"

## How It Works

1. **Analyze Requirements**: KEN-MCP uses AI to understand your natural language description
2. **Plan Implementation**: Creates a detailed plan with tools, resources, and prompts
3. **Generate Code**: Produces complete, working FastMCP server implementation
4. **Create Documentation**: Generates README, usage guides, and configuration instructions
5. **Validate**: Ensures the generated code is syntactically correct and complete

## Generated Projects

Each generated MCP server includes:
- `server.py` - The main MCP server implementation
- `README.md` - Comprehensive documentation
- `mcp.md` - Technical details and architecture
- `pyproject.toml` - Python package configuration
- `.gitignore` - Version control setup

## Requirements

- Python 3.10+
- FastMCP framework (automatically included in generated projects)

## License

MIT

---
Generated by KEN-MCP