# -*- coding: utf-8 -*-

kb = 1.3807e-23             # J K**-1
h = 6.6262e-34              # J s
hbar = 1.0546e-34           # J s

me = 9.1095e-31             # kg
qe = -1.6022e-19            # C
mp = 1.6726485e-27          # kg

c = 2.99792458e8            # m s**-1

NA = 6.0220e23              # mol**-1
R = kb*NA

T0 = -273.15                # degree C
u = 1.66056e-27             # kg (atomic mass unit)

g = 9.80665                 # m s**-2
G = 6.672e-11               # m**3 kg**-1 s**-2
mu0 = 1.256637e-6           # V s A**-1 m**-1
epsilon0 = 8.854187e-12     # A s V**-1 m**-1

sigma = 56.6961e-9          # W m**-2 K**-4

# Time units:
minute = 60.                # s
hour = 60.*minute
day = 24.*hour
week = 7.*day
year = 365.25*day

# Pressure units:
torr = 101325. / 760.       # Pa

# Textile stuff
Ne = 1.693e3                # m/kg
Nm = 1e3                    # m/kg
tex = 1e-3/1e3              # kg/m
denier = 1e-3/9e3           # kg/m

# English units
inch = 25.4e-3              # m
thou = mil = 25.4e-6
foot = 30.48e-2
yard = 91.44e-2
furlong = 201.168
mile = 1609.344
fathom = 6*foot
cable = 608*foot
nautical_mile = 6080*foot

perch = 272.25*foot**2      # m**2
rood = 10890*foot**2
acre = 43560*foot**2

gallon = 4.54609e-3         # m**3
pint = 1./8.*gallon
quart = 2*pint
gill = 1./4.*pint
fluid_ounce = 1./20.*pint

pound = 453.59237e-3        # kg
grain = 1./700.*pound
drachm = 1./256.*pound
ounce = 1./16.*pound
stone = 14*pound
quarter = 28*pound
hundredweight = 112*pound
ton = 2240*pound
