[![Build Status](https://travis-ci.org/circuits/circuits.svg)](https://travis-ci.org/circuits/circuits)

[![codecov](https://codecov.io/gh/circuits/circuits/branch/master/graph/badge.svg)](https://codecov.io/gh/circuits/circuits)

[![Quality](https://landscape.io/github/circuits/circuits/master/landscape.png)](https://landscape.io/github/circuits/circuits/master)

[![Stories Ready](https://badge.waffle.io/circuits/circuits.png?label=ready&title=Ready)](https://waffle.io/circuits/circuits)

circuits is a **Lightweight** **Event** driven and **Asynchronous** **Application Framework** for the [Python Programming Language](http://www.python.org/) with a strong **Component** Architecture.

circuits also includes a lightweight, high performance and scalable HTTP/WSGI compliant web server as well as various I/O and Networking components.

-   [Website](http://circuitsframework.com/)
-   [Downloads](https://github.com/circuits/circuits/releases)
-   [Documentation](http://circuits.readthedocs.org/en/latest/)

Got questions?

-   [Ask a Question](http://stackoverflow.com/questions/ask) (Tag it: `circuits-framework`)

Examples
========

Features
========

-   event driven
-   concurrency support
-   component architecture
-   asynchronous I/O components
-   no required external dependencies
-   full featured web framework (circuits.web)
-   coroutine based synchronization primitives

Requirements
============

-   circuits has no dependencies beyond the [Python Standard Library](http://docs.python.org/library/).

Supported Platforms
===================

-   Linux, FreeBSD, Mac OS X, Windows
-   Python 2.7, 3.4, 3.5, 3.6
-   pypy (the newer the better)

Installation
============

The simplest and recommended way to install circuits is with pip. You may install the latest stable release from PyPI with pip:

    $ pip install circuits

If you do not have pip, you may use easy\_install:

    $ easy_install circuits

Alternatively, you may download the source package from the [PyPi](http://pypi.python.org/pypi/circuits) or the [Downloads](https://github.com/circuits/circuits/releases) extract it and install using:

    $ python setup.py install

> **note**
>
> You can install the [development version](https://github.com/circuits/circuits/archive/master.zip#egg=circuits-dev)  
> via `pip install circuits==dev`.
>
License
=======

circuits is licensed under the [MIT License](http://www.opensource.org/licenses/mit-license.php).

Feedback
========

We welcome any questions or feedback about bugs and suggestions on how to improve circuits.

Let us know what you think about circuits. [@pythoncircuits](http://twitter.com/pythoncircuits).

Do you have suggestions for improvement? Then please [Create an Issue](https://github.com/circuits/circuits/issues/new) with details of what you would like to see. I'll take a look at it and work with you to either incorporate the idea or find a better solution.

Community
=========

There are also several places you can reach out to the circuits community:

-   [Mailing List](http://groups.google.com/group/circuits-users)
-   [Google+ Group](https://plus.google.com/communities/107775112577294599973)
-   [\#circuits IRC Channel](http://webchat.freenode.net/?randomnick=1&channels=circuits&uio=d4) on the [FreeNode IRC Network](http://freenode.net)
-   [Ask a Question](http://stackoverflow.com/questions/ask) on [Stackoverflow](http://stackoverflow.com/) (Tag it: `circuits-framework`)

------------------------------------------------------------------------

Disclaimer
==========

Whilst I (James Mills) continue to contribute and maintain the circuits project I do not represent the interests or business of my employer Facebook Inc. The contributions I make are of my own free time and have no bearing or relevance to Facebook Inc.
