# generated by datamodel-codegen:
#   filename:  https://api.quantum.ibm.com/runtime/api-json
#   timestamp: 2025-04-24T14:16:50+00:00

# mypy: ignore-errors

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any

from pydantic import BaseModel, Field, PositiveFloat, confloat, conint


class Instance(BaseModel):
    name: str = Field(..., example="ibm-q/open/main")
    plan: str = Field(..., example="premium")


class GetUserMeResponse(BaseModel):
    email: str = Field(..., example="user@ibm.com")
    instances: list[Instance]


class GenericError(BaseModel):
    code: float = Field(..., example=1000)
    message: str = Field(..., example="message")
    solution: str = Field(..., example="This is a possible solution")
    more_info: str


class GenericErrorDto(BaseModel):
    errors: list[GenericError]


class Plan(Enum):
    premium = "premium"
    open = "open"
    internal = "internal"


class FindInstancesInstanceResponse(BaseModel):
    name: str = Field(..., example="ibm-q/open/main")
    plan: Plan


class FindInstancesResponse(BaseModel):
    instances: list[FindInstancesInstanceResponse]


class BlockUsersByDomainResponse(BaseModel):
    blockedUsersCount: float = Field(..., example=2)
    deletedAccessTokens: float = Field(..., example=2)
    dplUserReportsUpdated: float = Field(..., example=1)
    dplUserReportsCreated: float = Field(..., example=1)


class LogLevel(Enum):
    critical = "critical"
    error = "error"
    warning = "warning"
    info = "info"
    debug = "debug"


class SequenceType(Enum):
    XX = "XX"
    XpXm = "XpXm"
    XY4 = "XY4"


class ExtraSlackDistribution(Enum):
    middle = "middle"
    edges = "edges"


class SchedulingMethod(Enum):
    alap = "alap"
    asap = "asap"


class DynamicalDecoupling(BaseModel):
    enable: bool | None = Field(
        None,
        description="Whether to enable DD as specified by the other options in this class",
    )
    sequence_type: SequenceType | None = Field(None, description="Which dynamical decoupling sequence to use")
    extra_slack_distribution: ExtraSlackDistribution | None = Field(
        None, description="Where to put extra timing delays due to rounding issues"
    )
    scheduling_method: SchedulingMethod | None = Field(
        None,
        description="Whether to schedule gates as soon as ('asap') or as late as ('alap') possible",
    )


class MeasType(Enum):
    classified = "classified"
    kerneled = "kerneled"
    avg_kerneled = "avg_kerneled"


class Execution(BaseModel):
    init_qubits: bool | None = Field(
        None,
        description="Whether to reset the qubits to the ground state for each shot",
    )
    rep_delay: float | None = Field(
        None,
        description="The delay between a measurement and the subsequent quantum circuit",
    )
    meas_type: MeasType | None = Field(None, description="How to process and return measurement results")


class Options(BaseModel):
    default_shots: int | None = Field(
        None,
        description="The default number of shots to use if none are specified in the PUBs",
    )
    dynamical_decoupling: DynamicalDecoupling | None = Field(None, description="Suboptions for dynamical decoupling")
    execution: Execution | None = Field(None, description="Execution options")


class Version(Enum):
    int_2 = 2


class SamplerV2Schema(BaseModel):
    pubs: list[list] = Field(
        ...,
        description="Primitive Unit Blocs of data. Each PUB is of the form (Circuit, Parameters, Shots) where the circuit is required, parameters should be passed only for parametrized circuits, and shots is optional",
    )
    options: Options | None = Field(None, description="Options for V2 Sampler")
    shots: int | None = Field(
        None,
        description="Default number of shots which applies to all pubs without shots",
    )
    support_qiskit: bool | None = Field(
        None,
        description="If True, returns a qiskit-style output, meant to be parsed using the runtime result decoder, or resort to returning pure JSON results (resulting in larger objects)",
    )
    version: Version | None = Field(None, description="For SamplerV2, version should always be 2")


class DynamicalDecoupling1(BaseModel):
    enable: bool | None = Field(None, description="Whether to enable dynamical decoupling.")
    sequence_type: SequenceType | None = Field(None, description="Which dynamical decoupling sequence to use")
    extra_slack_distribution: ExtraSlackDistribution | None = Field(
        None, description="Where to put extra timing delays due to rounding issues"
    )
    scheduling_method: SchedulingMethod | None = Field(
        None,
        description="Whether to schedule gates as soon as ('asap') or as late as ('alap') possible",
    )


class OptimizationLevel(Enum):
    integer_0 = 0
    integer_1 = 1


class Transpilation(BaseModel):
    optimization_level: OptimizationLevel | None = Field(
        None, description="How much optimization to perform on the circuits"
    )


class ShotsPerRandomization(Enum):
    auto = "auto"


class MeasureNoiseLearning(BaseModel):
    num_randomizations: conint(ge=1) | None = Field(
        None,
        description="The number of random circuits to draw for the measurement learning experiment",
    )
    shots_per_randomization: conint(ge=1) | ShotsPerRandomization | None = Field(
        None,
        description="The number of shots to use for the learning experiment per random circuit.",
    )


class ExtrapolatorEnum(Enum):
    linear = "linear"
    exponential = "exponential"
    double_exponential = "double_exponential"
    polynomial_degree_1 = "polynomial_degree_1"
    polynomial_degree_2 = "polynomial_degree_2"
    polynomial_degree_3 = "polynomial_degree_3"
    polynomial_degree_4 = "polynomial_degree_4"
    polynomial_degree_5 = "polynomial_degree_5"
    polynomial_degree_6 = "polynomial_degree_6"
    polynomial_degree_7 = "polynomial_degree_7"


class Extrapolator(Enum):
    linear = "linear"
    exponential = "exponential"
    double_exponential = "double_exponential"
    polynomial_degree_1 = "polynomial_degree_1"
    polynomial_degree_2 = "polynomial_degree_2"
    polynomial_degree_3 = "polynomial_degree_3"
    polynomial_degree_4 = "polynomial_degree_4"
    polynomial_degree_5 = "polynomial_degree_5"
    polynomial_degree_6 = "polynomial_degree_6"
    polynomial_degree_7 = "polynomial_degree_7"


class Zne(BaseModel):
    noise_factors: list[float] | None = Field(None, description="Noise factors to use for noise amplification")
    extrapolator: list[ExtrapolatorEnum] | Extrapolator | None = Field(
        None,
        description="Extrapolator(s) to try (in order) for extrapolating to zero noise",
    )


class NoiseGain(Enum):
    auto = "auto"


class Pec(BaseModel):
    max_overhead: PositiveFloat | None = Field(None, description="The maximum circuit sampling overhead allowed")
    noise_gain: confloat(ge=0.0) | NoiseGain | None = Field(None, description="The amount by which to scale the noise")


class LayerNoiseLearning(BaseModel):
    max_layers_to_learn: conint(ge=0) | None = Field(None, description="The max number of unique layers to learn")
    shots_per_randomization: conint(ge=1) | None = Field(
        None, description="The total number of shots to use per random learning circuit"
    )
    num_randomizations: conint(ge=1) | None = Field(
        None,
        description="The number of random circuits to use per learning circuit configuration",
    )
    layer_pair_depths: list[conint(ge=0)] | None = Field(
        None,
        description="The circuit depths (measured in number of pairs) to use in learning experiments",
    )


class Resilience(BaseModel):
    measure_mitigation: bool | None = Field(None, description="Whether to enable measurement error mitigation method")
    measure_noise_learning: MeasureNoiseLearning | None = Field(
        None, description="Additional measurement noise learning options"
    )
    zne_mitigation: bool | None = Field(
        None,
        description="Whether to turn on Zero Noise Extrapolation error mitigation method",
    )
    zne: Zne | None = Field(None, description="Additional zero noise extrapolation mitigation options")
    pec_mitigation: bool | None = Field(
        None,
        description="Whether to turn on Probabilistic Error Cancellation error mitigation method",
    )
    pec: Pec | None = Field(
        None,
        description="Additional probabilistic error cancellation mitigation options",
    )
    layer_noise_learning: LayerNoiseLearning | None = Field(None, description="Layer noise learning options")


class Execution1(BaseModel):
    init_qubits: bool | None = Field(
        None,
        description="Whether to reset the qubits to the ground state for each shot",
    )
    rep_delay: float | None = Field(
        None,
        description="The delay between a measurement and the subsequent quantum circuit",
    )


class NumRandomizations(Enum):
    auto = "auto"


class Strategy(Enum):
    active = "active"
    active_circuit = "active-circuit"
    active_accum = "active-accum"
    all = "all"


class Twirling(BaseModel):
    enable_gates: bool | None = Field(None, description="Whether to apply 2-qubit gate twirling")
    enable_measure: bool | None = Field(None, description="Whether to apply measurement twirling")
    num_randomizations: conint(ge=1) | NumRandomizations | None = Field(
        None,
        description="The number of random samples to use when twirling or performing sampled mitigation",
    )
    shots_per_randomization: conint(ge=1) | ShotsPerRandomization | None = Field(
        None, description="The number of shots to run for each random sample"
    )
    strategy: Strategy | None = Field(
        None,
        description="The strategy of twirling qubits in identified layers of 2-qubit twirled gates",
    )


class Options1(BaseModel):
    seed_estimator: int | None = Field(None, description="Seed used to control sampling")
    default_precision: PositiveFloat | None = Field(
        None,
        description="The default precision to use for any PUB that does not specify one",
    )
    default_shots: conint(ge=0) | None = Field(
        None,
        description="The total number of shots to use per circuit per configuration. If set, this value overrides default_precision.",
    )
    dynamical_decoupling: DynamicalDecoupling1 | None = Field(None, description="Suboptions for dynamical decoupling")
    transpilation: Transpilation | None = Field(None, description="Transpilation settings")
    resilience: Resilience | None = Field(
        None,
        description="Advanced resilience options to fine tune the resilience strategy",
    )
    execution: Execution1 | None = Field(None, description="Execution options")
    twirling: Twirling | None = Field(None, description="Twirling options")


class ResilienceLevel(Enum):
    integer_0 = 0
    integer_1 = 1
    integer_2 = 2


class EstimatorV2Schema(BaseModel):
    pubs: list[list] = Field(
        ...,
        description="Primitive Unit Blocs of data. Each PUB is of the form (Circuit, Observables, Parameters, Precision) where the circuit and observables are required, parameters should be passed only for parametrized circuits, and precision is optional",
    )
    options: Options1 | None = Field(None, description="Options for V2 Estimator")
    resilience_level: ResilienceLevel | None = Field(None, description="How much resilience to build against errors")
    precision: float | None = Field(
        None,
        description="Default precision level which applies to all pubs without precision",
    )
    support_qiskit: bool | None = Field(
        None,
        description="If True, returns a qiskit-style output, meant to be parsed using the runtime result decoder, or resort to returning pure JSON results (resulting in larger objects)",
    )
    version: Version | None = Field(None, description="For EstimatorV2, version should always be 2")


class CreateJobResponse(BaseModel):
    id: str = Field(..., example="ci8fo2g4mgo3p0c53uc0")
    backend: str = Field(..., example="ibmq_toronto")
    session_id: str = Field(..., example="ci8fo2g4mgo3p0c53uc0")
    messages: list[str] = Field(
        ...,
        example=[
            {
                "level": "warn",
                "data": "Your current pending jobs are estimated to consume 200 quantum seconds, but you only have 100 quantum seconds left in your monthly quota; therefore, it is likely this job will be canceled",
            }
        ],
    )


class Status(Enum):
    Completed = "Completed"
    Cancelled = "Cancelled"
    Failed = "Failed"
    Queued = "Queued"
    Running = "Running"


class JobStateResponse(BaseModel):
    status: Status = Field(..., example="Cancelled")
    reason: str | None = Field(None, example="Ran too long")
    reason_code: float | None = Field(None, example=1010)


class JobResponse(BaseModel):
    id: str = Field(..., example="ch8b1ok4k9li68vm059r")
    hub: str = Field(..., example="ibmq")
    group: str = Field(..., example="open")
    project: str = Field(..., example="main")
    backend: str = Field(..., example="ibm_seattle")
    state: JobStateResponse = Field(
        ...,
        example={"status": "Cancelled", "reason": "Ran too long", "reason_code": 1234},
    )
    status: Status = Field(
        ...,
        description='Job status, if cancelled, the reason is included in the status field like "Cancelled - Ran too long"',
        example="Completed",
    )
    params: dict[str, Any] = Field(..., example={})
    program: dict[str, Any] = Field(..., example={"id": "ch8b1ok4k9li68vm059r"})
    created: datetime = Field(..., example="2021-05-05 00:56:04.569709")
    ended: datetime = Field(..., example="2021-05-05 00:56:04.569709")
    runtime: str
    cost: float = Field(..., example=0)
    tags: list[str] = Field(..., example=["test-job"])
    session_id: str = Field(..., example="ch8b1ok4k9li68vm059r")
    usage: dict[str, Any] = Field(..., example={"seconds": 1})
    estimated_running_time_seconds: float = Field(..., example=123)
    estimated_max_running_time_seconds: float = Field(..., example=123)
    private: bool = Field(..., example=False)
    user_id: str = Field(..., example="66b151c0456fa30442933700")


class PaginationRuntimeJobResponse(BaseModel):
    jobs: list[JobResponse]
    count: float = Field(..., example=5)
    limit: float = Field(..., example=5)
    offset: float = Field(..., example=0)


class Mode(Enum):
    job = "job"
    session = "session"
    batch = "batch"


class Status2(Enum):
    completed = "completed"
    canceled = "canceled"
    failed = "failed"
    pending = "pending"
    in_progress = "in_progress"
    unknown = "unknown"


class WorkloadResponse(BaseModel):
    id: str = Field(
        ...,
        description="Workload id (job and session id)",
        example="ch8b1ok4k9li68vm059r",
    )
    created: str = Field(..., description="Creation date", example="2024-07-04T16:13:56.562Z")
    ended: str | None = Field(None, description="End date", example="2024-07-04T16:13:56.562Z")
    backend: str = Field(..., description="Backend name", example="ibm_seattle")
    instance: str = Field(..., description="Instance as hub/group/project", example="ibmq/open/main")
    user_id: str = Field(..., description="User id", example="65f0478ed32a1891af0a8d31")
    accepting_jobs: float | None = Field(
        None,
        description="true if the session accepts jobs, false otherwise. Only for sessions, null for jobs",
        example=True,
    )
    mode: Mode = Field(..., description="Workload mode: job, session or batch", example="job")
    status: Status2 = Field(..., description="State for the workload.", example="in_progress")
    status_reason: str | None = Field(
        None,
        description="Jobs only, status reason for the job",
        example="Error occurred for job circuit-runner_ckodgbs1fc4b8ufrjsd0_d35e_2. Stale payload, retry maximum reached.",
    )
    tags: list[str] | None = Field(None, description="Tags for the jobs", example=["test-job", "foo", "bar"])
    usage_seconds: float | None = Field(
        None,
        description="Usage in seconds. Can be null for ongoing workloads.",
        example=1,
    )
    estimated_running_time_seconds: float | None = Field(
        None,
        description="Estimated running time in seconds. Only for jobs, null for sessions",
        example=123,
    )
    estimated_start_time_seconds: float | None = Field(
        None,
        description="Estimated start time in seconds. Only for jobs, null for sessions",
        example=123,
    )


class PaginationWorkloadsResponse(BaseModel):
    workloads: list[WorkloadResponse]
    count: float = Field(..., example=5)
    limit: float = Field(..., example=5)
    previous: str | None = Field(None, example=0)
    next: str | None = Field(None, example=0)


class GetBackendDefaultsResponse(BaseModel):
    pass


class GetBackendPropertiesResponse(BaseModel):
    pass


class UpdateTagsRequest(BaseModel):
    tags: list[str] = Field(..., example=["job-1"])


class GetBackendStatusResponse(BaseModel):
    state: bool = Field(..., example=True)
    status: str = Field(..., example="open")
    message: str = Field(..., example="available")
    length_queue: float = Field(..., example=8)
    backend_version: str = Field(..., example="1.2.1")


class GetBackendConfigurationResponse(BaseModel):
    pass


class UpdateSessionRequest(BaseModel):
    accepting_jobs: bool = Field(..., description="Whether the session accepts new jobs or not", example=False)


class State(Enum):
    canceled = "canceled"
    closed = "closed"
    open = "open"
    active = "active"
    inactive = "inactive"


class Mode1(Enum):
    batch = "batch"
    dedicated = "dedicated"


class GetSessionDetailsResponse(BaseModel):
    id: str = Field(..., example="11111111111111111111")
    backend_name: str = Field(..., example="ibm-tenerife")
    started_at: str | None = Field(
        None,
        description="The timestamp when the first job of the session started (activated the first time)",
        example="2023-10-01T00:00:00.000Z",
    )
    created_at: str | None = Field(
        None,
        description="The timestamp when the session was created",
        example="2023-10-01T00:00:00.000Z",
    )
    activated_at: str | None = Field(
        None,
        description="The timestamp when the session started was activated",
        example="2023-10-01T00:00:00.000Z",
    )
    closed_at: str | None = Field(
        None,
        description="The timestamp when the session was closed",
        example="2023-10-01T00:00:00.000Z",
    )
    last_job_started: str | None = Field(None, example="2023-10-01T00:00:00.000Z")
    last_job_completed: str | None = Field(None, example="2023-10-01T00:00:00.000Z")
    interactive_ttl: float = Field(..., example=100)
    max_ttl: float = Field(..., example=1000)
    active_ttl: float = Field(..., example=1000)
    state: State = Field(
        ...,
        description="The state of the session.\n- **open**: The session has been created but no jobs have been dequeued in it.\n- **active**: Jobs are being dequeued for the session.\n- **inactive**: The interactiveSessionTTL expired before more jobs were available.\n- **closed**: The maxSessionTTL expired or the session was explicitly closed.\n- **canceled**: The session was canceled by some reason.",
        example="active",
    )
    accepting_jobs: bool = Field(
        ...,
        description="If true, the session is actively accepting new jobs to be queued. If false, jobs will be rejected on create and the session will be immediately closed when there are no more jobs to run in the session.",
        example=True,
    )
    mode: Mode1 | None = Field(None, description="The session mode", example="batch")
    elapsed_time: float | None = Field(None, description="The session usage time in seconds", example=1000)


class TimeStamp(BaseModel):
    status: Status2 = Field(
        ...,
        description="The status of the session in this timestamps",
        example="pending",
    )
    date: datetime = Field(
        ...,
        description="The moment when the session has changed",
        example="2023-10-01T00:00:00.000Z",
    )


class GetSessionDetailsExtendedResponse(BaseModel):
    id: str = Field(..., example="11111111111111111111")
    user_id: str = Field(..., example="123456")
    backend_name: str = Field(..., example="ibm-tenerife")
    instance: str = Field(..., example="aHub/aGroup/aProject")
    started_at: str | None = Field(
        None,
        description="The timestamp when the first job of the session started (activated the first time)",
        example="2023-10-01T00:00:00.000Z",
    )
    created_at: str | None = Field(
        None,
        description="The timestamp when the session was created",
        example="2023-10-01T00:00:00.000Z",
    )
    activated_at: str | None = Field(
        None,
        description="The timestamp when the session started was activated",
        example="2023-10-01T00:00:00.000Z",
    )
    closed_at: str | None = Field(
        None,
        description="The timestamp when the session was closed",
        example="2023-10-01T00:00:00.000Z",
    )
    last_job_started: str | None = Field(None, example="2023-10-01T00:00:00.000Z")
    last_job_completed: str | None = Field(None, example="2023-10-01T00:00:00.000Z")
    interactive_ttl: float = Field(..., example=100)
    max_ttl: float = Field(..., example=1000)
    active_ttl: float = Field(..., example=1000)
    status: Status2 = Field(..., description="The status of the session", example="active")
    status_reason: str | None = Field(
        None,
        description="The status cause of the current.",
        example="session_inactivated_by_interactive_ttl",
    )
    accepting_jobs: bool = Field(
        ...,
        description="If true, the session is actively accepting new jobs to be queued. If false, jobs will be rejected on create and the session will be immediately closed when there are no more jobs to run in the session.",
        example=True,
    )
    mode: Mode1 | None = Field(None, description="The session mode", example="batch")
    elapsed_time: float | None = Field(None, description="The session usage time in seconds", example=1000)
    session_remaining_time_seconds: float | None = Field(
        None, description="The session remaining time in seconds", example=12000
    )
    timestamps: list[TimeStamp] | None = Field(None, description="The session events")


class HubUsageStatsDto(BaseModel):
    instance: str = Field(..., example="defaultHub/defaultGroup/defaultProject")
    quota: float = Field(..., example=10)
    usage: float = Field(..., example=7)
    pendingJobs: float = Field(..., example=2)
    maxPendingJobs: float = Field(..., example=3)


class UsageStatsDto(BaseModel):
    period: dict[str, Any] = Field(
        ...,
        example={
            "start": "2023-09-01T00:00:00.000Z",
            "end": "2023-09-30T23:59:59.999Z",
        },
    )
    byInstance: list[HubUsageStatsDto] = Field(
        ...,
        example=[
            {
                "instance": "defaultHub/defaultGroup/defaultProject",
                "usage": 10,
                "quota": 600,
                "pendingJobs": 2,
                "maxPendingJobs": 3,
            }
        ],
    )


class CreateSessionRequest(BaseModel):
    backend: str = Field(
        ...,
        description="Name that identifies the system on which to run the job",
        example="ibmq_wellington",
    )
    instance: str = Field(
        ...,
        description="The instance were session will be created",
        example="hub/group/project",
    )
    max_session_ttl: confloat(ge=60.0) | None = Field(
        None, description="Max allowed time for session to run in seconds.", example=450
    )
    mode: Mode1 | None = Field("dedicated", description="The session mode", example="batch")


class CreateSessionResponse(BaseModel):
    id: str = Field(..., example="ci8fo2g4mgo3p0c53uc0")
    messages: list[str] | None = Field(
        None,
        example=[
            {
                "level": "warn",
                "data": "Dedicated session execution mode is not supported in the open plan. Jobs will run in job mode instead..",
            }
        ],
    )


class GetAnalyticsUsageResponse(BaseModel):
    usage: float = Field(..., description="Total usage (in milliseconds)", example=10)
    jobs: float = Field(..., description="Total number of jobs", example=10)
    sessions: float = Field(..., description="Total number of sessions", example=10)
    sessionsUsage: float = Field(..., description="Total sessions usage (in milliseconds)", example=10)
    avgSessionsUsage: float = Field(..., description="Average sessions usage (in milliseconds)", example=10)
    maxSessionsUsage: float = Field(..., description="Max sessions usage (in milliseconds)", example=10)
    batchSessions: float = Field(..., description="Total number of batch sessions", example=10)
    batchSessionsUsage: float = Field(..., description="Total batch sessions usage (in milliseconds)", example=10)
    avgBatchSessionsUsage: float = Field(..., description="Average batch sessions usage (in milliseconds)", example=10)
    maxBatchSessionsUsage: float = Field(..., description="Max batch sessions usage (in milliseconds)", example=10)
    dedicatedSessions: float = Field(..., description="Total number of dedicated sessions", example=10)
    dedicatedSessionsUsage: float = Field(
        ..., description="Total dedicated sessions usage (in milliseconds)", example=10
    )
    avgDedicatedSessionsUsage: float = Field(
        ...,
        description="Average dedicated sessions usage (in milliseconds)",
        example=10,
    )
    maxDedicatedSessionsUsage: float = Field(
        ..., description="Max dedicated sessions usage (in milliseconds)", example=10
    )
    individualJobs: float = Field(..., description="Total number of individual jobs", example=10)
    individualJobsUsage: float = Field(..., description="Total individual jobs usage  (in milliseconds)", example=10)
    avgIndividualJobsUsage: float = Field(
        ..., description="Average individual jobs usage  (in milliseconds)", example=10
    )
    maxIndividualJobsUsage: float = Field(
        ..., description="Average individual jobs usage (in milliseconds)", example=10
    )
    queueTime: float = Field(..., description="Total queue time (in milliseconds)", example=10)
    avgQueueTime: float = Field(..., description="Average queue time (in milliseconds)", example=10)
    maxQueueTime: float = Field(..., description="Max queue time  (in milliseconds)", example=10)


class BackendFilter(BaseModel):
    name: str = Field(..., example="simulator")
    deleted: bool


class UserFilter(BaseModel):
    id: str = Field(..., example="123")
    firstName: str = Field(..., example="John")
    lastName: str = Field(..., example="Doe")
    email: str = Field(..., example="john.doe@ibm.com")
    deleted: bool


class CountryFilter(BaseModel):
    label: str = Field(..., description="Country name", example="United States of America")
    code: str = Field(..., description="ISO 3166-1 Alpha-2. XX for unknown", example="US")


class InstanceFilter(BaseModel):
    id: str = Field(..., example="hub/group")
    deleted: bool


class GetAnalyticsFiltersResponse(BaseModel):
    backends: list[BackendFilter]
    users: list[UserFilter] | None = None
    countries: list[CountryFilter]
    instances: list[InstanceFilter]


class GetAnalyticsUsageGroupedResponseData(BaseModel):
    key: str = Field(..., description="Grouping key", example="ibm-q/main/open")
    usage: float = Field(..., description="Total usage (in milliseconds)", example=10)
    jobs: float = Field(..., description="Total number of jobs", example=10)
    sessions: float = Field(..., description="Total number of sessions", example=10)
    sessionsUsage: float = Field(..., description="Total sessions usage (in milliseconds)", example=10)
    avgSessionsUsage: float = Field(..., description="Average sessions usage (in milliseconds)", example=10)
    maxSessionsUsage: float = Field(..., description="Max sessions usage (in milliseconds)", example=10)
    batchSessions: float = Field(..., description="Total number of batch sessions", example=10)
    batchSessionsUsage: float = Field(..., description="Total batch sessions usage (in milliseconds)", example=10)
    avgBatchSessionsUsage: float = Field(..., description="Average batch sessions usage (in milliseconds)", example=10)
    maxBatchSessionsUsage: float = Field(..., description="Max batch sessions usage (in milliseconds)", example=10)
    dedicatedSessions: float = Field(..., description="Total number of dedicated sessions", example=10)
    dedicatedSessionsUsage: float = Field(
        ..., description="Total dedicated sessions usage (in milliseconds)", example=10
    )
    avgDedicatedSessionsUsage: float = Field(
        ...,
        description="Average dedicated sessions usage (in milliseconds)",
        example=10,
    )
    maxDedicatedSessionsUsage: float = Field(
        ..., description="Max dedicated sessions usage (in milliseconds)", example=10
    )
    individualJobs: float = Field(..., description="Total number of individual jobs", example=10)
    individualJobsUsage: float = Field(..., description="Total individual jobs usage  (in milliseconds)", example=10)
    avgIndividualJobsUsage: float = Field(
        ..., description="Average individual jobs usage  (in milliseconds)", example=10
    )
    maxIndividualJobsUsage: float = Field(
        ..., description="Average individual jobs usage (in milliseconds)", example=10
    )
    queueTime: float = Field(..., description="Total queue time (in milliseconds)", example=10)
    avgQueueTime: float = Field(..., description="Average queue time (in milliseconds)", example=10)
    maxQueueTime: float = Field(..., description="Max queue time  (in milliseconds)", example=10)


class GetAnalyticsUsageGroupedResponse(BaseModel):
    data: list[GetAnalyticsUsageGroupedResponseData] = Field(..., description="Data")


class GetAnalyticsUsageGroupedByDateResponseData(BaseModel):
    key: str = Field(
        ...,
        description="Group key. Depends on the groupBy query params.",
        example="ibm-q/open/main",
    )
    intervalStart: str = Field(..., description="Interval start", example="2024-01-01T00:00:00.000Z")
    intervalEnd: str = Field(..., description="Interval end", example="2024-01-01T00:00:00.000Z")
    usage: float = Field(..., description="Total usage (in milliseconds)", example=10)
    jobs: float = Field(..., description="Total number of jobs", example=10)
    sessions: float = Field(..., description="Total number of sessions", example=10)
    sessionsUsage: float = Field(..., description="Total sessions usage (in milliseconds)", example=10)
    avgSessionsUsage: float = Field(..., description="Average sessions usage (in milliseconds)", example=10)
    maxSessionsUsage: float = Field(..., description="Max sessions usage (in milliseconds)", example=10)
    batchSessions: float = Field(..., description="Total number of batch sessions", example=10)
    batchSessionsUsage: float = Field(..., description="Total batch sessions usage (in milliseconds)", example=10)
    avgBatchSessionsUsage: float = Field(..., description="Average batch sessions usage (in milliseconds)", example=10)
    maxBatchSessionsUsage: float = Field(..., description="Max batch sessions usage (in milliseconds)", example=10)
    dedicatedSessions: float = Field(..., description="Total number of dedicated sessions", example=10)
    dedicatedSessionsUsage: float = Field(
        ..., description="Total dedicated sessions usage (in milliseconds)", example=10
    )
    avgDedicatedSessionsUsage: float = Field(
        ...,
        description="Average dedicated sessions usage (in milliseconds)",
        example=10,
    )
    maxDedicatedSessionsUsage: float = Field(
        ..., description="Max dedicated sessions usage (in milliseconds)", example=10
    )
    individualJobs: float = Field(..., description="Total number of individual jobs", example=10)
    individualJobsUsage: float = Field(..., description="Total individual jobs usage  (in milliseconds)", example=10)
    avgIndividualJobsUsage: float = Field(
        ..., description="Average individual jobs usage  (in milliseconds)", example=10
    )
    maxIndividualJobsUsage: float = Field(
        ..., description="Average individual jobs usage (in milliseconds)", example=10
    )
    queueTime: float = Field(..., description="Total queue time (in milliseconds)", example=10)
    avgQueueTime: float = Field(..., description="Average queue time (in milliseconds)", example=10)
    maxQueueTime: float = Field(..., description="Max queue time  (in milliseconds)", example=10)


class GetAnalyticsUsageGroupedByDateResponse(BaseModel):
    intervalStart: str = Field(..., description="Interval start", example="2024-01-01T00:00:00.000Z")
    intervalEnd: str = Field(..., description="Interval end", example="2024-01-01T00:00:00.000Z")
    data: list[GetAnalyticsUsageGroupedByDateResponseData] = Field(..., description="Results")


class ProviderClass(Enum):
    Internal = "Internal"
    Premium = "Premium"
    Community = "Community"
    Community_Startup = "Community-Startup"
    Open = "Open"
    Unclassified_Hub = "Unclassified Hub"


class GetInstanceSharesResponseItem(BaseModel):
    providerClass: ProviderClass = Field(..., description="Provider class", example="Internal")
    hubId: str = Field(..., description="Hub", example="hub")
    groupId: str = Field(..., description="Group", example="group")
    projectId: str = Field(..., description="Project", example="project")
    hubShare: float = Field(..., description="Hub share", example=10)
    groupShare: float = Field(..., description="Group share", example=10)
    projectShare: float = Field(..., description="Project share", example=10)
    hubCapacityLimit: dict[str, Any] = Field(..., description="Hub capacity limit (in seconds)", example=10)
    groupCapacityLimit: dict[str, Any] = Field(..., description="Group capacity limit (in seconds)", example=10)
    projectCapacityLimit: dict[str, Any] = Field(..., description="Project capacity limit (in seconds)", example=10)
    groupCapacityReserved: dict[str, Any] = Field(..., description="Group reserved capacity (in seconds)", example=10)
    projectCapacityReserved: dict[str, Any] = Field(
        ..., description="Project reserved capacity (in seconds)", example=10
    )


class GetInstanceSharesResponse(BaseModel):
    shares: list[GetInstanceSharesResponseItem] = Field(..., description="Shares")


class CreateRefundRequest(BaseModel):
    refundTime: float = Field(..., description="Time to refund (in seconds)", example=450)
    incidentOccurredAt: datetime = Field(..., description="Date the incident happened", example="2024-01-01T00:00:00Z")
    expiresAt: datetime = Field(..., description="Date the refund will expires", example="2024-01-01T00:00:00Z")
    reason: str = Field(
        ...,
        description="The reason of the refund",
        example="There was a hardware problem and some jobs failed",
    )
    instance: str = Field(
        ...,
        description="The instance were the refund will be applied",
        example="hub/group/project",
    )


class AdminRefundUserResponse(BaseModel):
    id: str = Field(..., description="User id", example="123")
    email: str = Field(..., description="User email", example="user@domain.com")
    firstName: str = Field(..., description="User first name", example="John")
    lastName: str = Field(..., description="User last name", example="Doe")


class AdminRefundResponse(BaseModel):
    id: float = Field(..., description="Refund id", example=123)
    createdAt: datetime = Field(
        ...,
        description="Date when the refund was created",
        example="2024-01-01T00:00:00Z",
    )
    createdBy: AdminRefundUserResponse = Field(..., description="User who created the refund")
    refundTime: float = Field(..., description="Time to refund (in seconds)", example=450)
    incidentOccurredAt: datetime = Field(..., description="Date the incident happened", example="2024-01-01T00:00:00Z")
    expiresAt: datetime = Field(..., description="Date the refund will expires", example="2024-01-01T00:00:00Z")
    reason: str = Field(
        ...,
        description="The reason of the refund",
        example="There was a hardware problem and some jobs failed",
    )
    instance: str = Field(
        ...,
        description="The instance were the refund will be applied",
        example="hub/group/project",
    )


class FindAdminRefundsResponse(BaseModel):
    refunds: list[AdminRefundResponse]


class Bss(BaseModel):
    seconds: float | None = Field(
        None,
        description="Total billed time for the job - quantum seconds only.",
        example=10,
    )


class Usage(BaseModel):
    quantum_seconds: float | None = Field(None, description="Total quantum seconds used by the instance", example=10)
    seconds: float | None = Field(
        None,
        description="Total billed time for the job - quantum seconds only.",
        example=10,
    )


class Timestamps(BaseModel):
    created: str | None = Field(
        None,
        description="Timestamp of when the job create request was received",
        example="2022-06-20T12:55:20.268427Z",
    )
    finished: str | None = Field(
        None,
        description="Timestamp of when the job finished",
        example="2022-06-20T12:55:20.268427Z",
    )
    running: str | None = Field(
        None,
        description="Timestamp of when the job started running",
        example="2022-06-20T12:55:20.268427Z",
    )


class AdminJobMetricsResponse(BaseModel):
    bss: Bss | None = Field(
        None,
        description="Contains information about billing metrics",
        example={"seconds": 1},
    )
    usage: Usage | None = Field(
        None,
        description="Contains information about job usage metrics",
        example={"quantum_seconds": 10, "seconds": 10},
    )
    timestamps: Timestamps = Field(
        ...,
        description="A map of status transitions to timestamps",
        example={
            "created": "2022-06-20T12:55:20.268427Z",
            "finished": "2022-06-20T12:55:20.268427Z",
            "running": "2022-06-20T12:55:20.268427Z",
        },
    )
    executions: float | None = Field(None, description="Number of executions during job", example=10)
    num_circuits: float | None = Field(None, description="Number of circuits executed on quantum backend", example=10)
    num_qubits: list[str] | None = Field(None, description="Number of qubits on quantum backend", example=[1, 2, 3])
    circuit_depths: list[str] | None = Field(None, description="An array of circuit depths", example=[1, 2, 3])
    qiskit_version: str | None = Field(
        None,
        description="Qiskit version used during execution of the job",
        example="0.36.2",
    )
    estimated_start_time: str | None = Field(
        None,
        description="UTC timestamp for when the job will start",
        example="2022-06-20T12:55:20.268427Z",
    )
    estimated_completion_time: str | None = Field(
        None,
        description="UTC timestamp for when the job will complete",
        example="2022-06-20T12:55:20.268427Z",
    )
    position_in_queue: float | None = Field(None, description="Current position of job in queue", example=10)
    position_in_provider: float | None = Field(None, description="Current position of job in provider", example=10)


class Type(Enum):
    RUNTIME = "RUNTIME"
    IQX = "IQX"


class GetJobTypeResponse(BaseModel):
    id: str = Field(..., example="ch8b1ok4k9li68vm059r")
    type: Type = Field(..., example="IQX")


class VersionResponse(BaseModel):
    version: str = Field(..., example="0.0.2")


class CreateJobRequest(BaseModel):
    program_id: str = Field(..., description="ID of the primitive to be executed", example="sampler")
    hub: str = Field(..., description="The hub of the instance", example="ibm-q")
    group: str = Field(..., description="The group of the instance", example="open")
    project: str = Field(..., description="The project of the instance", example="main")
    backend: str = Field(
        ...,
        description="Name that identifies the system on which to run the job",
        example="ibm_sherbrooke",
    )
    params: SamplerV2Schema | EstimatorV2Schema | None = Field(
        None,
        description="Parameters to inject into the primitive as key-value pairs",
        example={
            "pubs": [
                [
                    'OPENQASM 3.0; include \\"stdgates.inc\\"; bit[1] c; x $0; c[0] = measure $0;',
                    [],
                    128,
                ]
            ],
            "support_qiskit": False,
            "version": 2,
        },
    )
    log_level: LogLevel | None = Field(None, description="Logging level of the job", example="info")
    session_id: str | None = Field(
        None,
        description="Identifier of the session that the job is a part of",
        example="example_session_id",
    )
    tags: list[str] | None = Field(None, description="List of job tags", example=["job-1"])
    cost: float | None = Field(
        None,
        description="Cost of the job as the estimated time it should take to complete (in seconds). Should not exceed the cost of the primitive",
        example=450,
    )
    private: bool | None = Field(
        None,
        description="When set to true, input parameters are not returned, and the results can only be read once. After the job is completed, input parameters are deleted from the service. After the results are read or after a specified time after the job is completed, the results are deleted from the service. When set to false, the input parameters and results follow the standard retention behavior of the API.",
        example=False,
    )
