"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TransactionGiftCardTypedDict(TypedDict):
    bin: str
    r"""The first 6 digits of the full gift card number."""
    sub_bin: str
    r"""The 3 digits after the `bin` of the full gift card number."""
    last4: str
    r"""The last 4 digits for the gift card."""
    type: Literal["gift-card"]
    r"""Always `gift-card`."""
    id: NotRequired[Nullable[str]]
    r"""The ID for the gift card."""


class TransactionGiftCard(BaseModel):
    bin: str
    r"""The first 6 digits of the full gift card number."""

    sub_bin: str
    r"""The 3 digits after the `bin` of the full gift card number."""

    last4: str
    r"""The last 4 digits for the gift card."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["gift-card"]], AfterValidator(validate_const("gift-card"))
        ],
        pydantic.Field(alias="type"),
    ] = "gift-card"
    r"""Always `gift-card`."""

    id: OptionalNullable[str] = UNSET
    r"""The ID for the gift card."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "id"]
        nullable_fields = ["id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
