"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .googlepaypaymentoptioncontext import (
    GooglePayPaymentOptionContext,
    GooglePayPaymentOptionContextTypedDict,
)
from .mode import Mode
from .paymentoptioncontext import PaymentOptionContext, PaymentOptionContextTypedDict
from .walletpaymentoptioncontext import (
    WalletPaymentOptionContext,
    WalletPaymentOptionContextTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


ContextTypedDict = TypeAliasType(
    "ContextTypedDict",
    Union[
        WalletPaymentOptionContextTypedDict,
        GooglePayPaymentOptionContextTypedDict,
        PaymentOptionContextTypedDict,
    ],
)


Context = TypeAliasType(
    "Context",
    Union[
        WalletPaymentOptionContext, GooglePayPaymentOptionContext, PaymentOptionContext
    ],
)


class PaymentOptionTypedDict(TypedDict):
    method: str
    mode: Mode
    can_store_payment_method: bool
    can_delay_capture: bool
    type: Literal["payment-option"]
    icon_url: NotRequired[Nullable[str]]
    label: NotRequired[Nullable[str]]
    context: NotRequired[Nullable[ContextTypedDict]]


class PaymentOption(BaseModel):
    method: str

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]

    can_store_payment_method: bool

    can_delay_capture: bool

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-option"]],
            AfterValidator(validate_const("payment-option")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-option"

    icon_url: OptionalNullable[str] = UNSET

    label: OptionalNullable[str] = UNSET

    context: OptionalNullable[Context] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "icon_url", "label", "context"]
        nullable_fields = ["icon_url", "label", "context"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
