"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cartitem import CartItem, CartItemTypedDict
from .paymentlinkstatus import PaymentLinkStatus
from .shippingdetails import ShippingDetails, ShippingDetailsTypedDict
from .statementdescriptor import StatementDescriptor, StatementDescriptorTypedDict
from .transactionbuyer import TransactionBuyer, TransactionBuyerTypedDict
from .transactionintent import TransactionIntent
from .transactionpaymentsource import TransactionPaymentSource
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Any, Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkTypedDict(TypedDict):
    id: str
    r"""The unique identifier for the payment link."""
    url: str
    r"""The URL for the payment link."""
    amount: int
    r"""The amount for the payment link."""
    country: str
    r"""The country code for the payment link."""
    currency: str
    r"""The currency code for the payment link."""
    intent: TransactionIntent
    cart_items: Nullable[List[CartItemTypedDict]]
    r"""The cart items for the payment link."""
    payment_source: TransactionPaymentSource
    r"""The way payment method information made it to this transaction."""
    created_at: datetime
    r"""The date and time the payment link was created."""
    updated_at: datetime
    r"""The date and time the payment link was last updated."""
    status: PaymentLinkStatus
    type: Literal["payment-link"]
    r"""Always `payment-link`."""
    expires_at: NotRequired[Nullable[datetime]]
    r"""The expiration date and time for the payment link."""
    external_identifier: NotRequired[Nullable[str]]
    r"""The merchant reference for the payment link."""
    statement_descriptor: NotRequired[Nullable[StatementDescriptorTypedDict]]
    r"""The statement descriptor for the payment link."""
    locale: NotRequired[Nullable[str]]
    r"""The locale for the payment link."""
    merchant_name: NotRequired[Nullable[str]]
    r"""The merchant's display name."""
    merchant_url: NotRequired[Nullable[str]]
    r"""The merchant's website URL."""
    merchant_banner_url: NotRequired[Nullable[str]]
    r"""The merchant's banner image URL."""
    merchant_color: NotRequired[Nullable[str]]
    r"""The merchant's brand color."""
    merchant_message: NotRequired[Nullable[str]]
    r"""A message from the merchant."""
    merchant_terms_and_conditions_url: NotRequired[Nullable[str]]
    r"""URL to the merchant's terms and conditions."""
    merchant_favicon_url: NotRequired[Nullable[str]]
    r"""URL to the merchant's favicon."""
    return_url: NotRequired[Nullable[str]]
    r"""The return URL after payment completion."""
    metadata: NotRequired[Nullable[Dict[str, Any]]]
    r"""Arbitrary metadata for the payment link."""
    buyer: NotRequired[Nullable[TransactionBuyerTypedDict]]
    r"""The buyer associated with the payment link."""
    shipping_details: NotRequired[Nullable[ShippingDetailsTypedDict]]
    r"""The shipping details for the payment link."""


class PaymentLink(BaseModel):
    id: str
    r"""The unique identifier for the payment link."""

    url: str
    r"""The URL for the payment link."""

    amount: int
    r"""The amount for the payment link."""

    country: str
    r"""The country code for the payment link."""

    currency: str
    r"""The currency code for the payment link."""

    intent: Annotated[TransactionIntent, PlainValidator(validate_open_enum(False))]

    cart_items: Nullable[List[CartItem]]
    r"""The cart items for the payment link."""

    payment_source: Annotated[
        TransactionPaymentSource, PlainValidator(validate_open_enum(False))
    ]
    r"""The way payment method information made it to this transaction."""

    created_at: datetime
    r"""The date and time the payment link was created."""

    updated_at: datetime
    r"""The date and time the payment link was last updated."""

    status: Annotated[PaymentLinkStatus, PlainValidator(validate_open_enum(False))]

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-link"]],
            AfterValidator(validate_const("payment-link")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-link"
    r"""Always `payment-link`."""

    expires_at: OptionalNullable[datetime] = UNSET
    r"""The expiration date and time for the payment link."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant reference for the payment link."""

    statement_descriptor: OptionalNullable[StatementDescriptor] = UNSET
    r"""The statement descriptor for the payment link."""

    locale: OptionalNullable[str] = UNSET
    r"""The locale for the payment link."""

    merchant_name: OptionalNullable[str] = UNSET
    r"""The merchant's display name."""

    merchant_url: OptionalNullable[str] = UNSET
    r"""The merchant's website URL."""

    merchant_banner_url: OptionalNullable[str] = UNSET
    r"""The merchant's banner image URL."""

    merchant_color: OptionalNullable[str] = UNSET
    r"""The merchant's brand color."""

    merchant_message: OptionalNullable[str] = UNSET
    r"""A message from the merchant."""

    merchant_terms_and_conditions_url: OptionalNullable[str] = UNSET
    r"""URL to the merchant's terms and conditions."""

    merchant_favicon_url: OptionalNullable[str] = UNSET
    r"""URL to the merchant's favicon."""

    return_url: OptionalNullable[str] = UNSET
    r"""The return URL after payment completion."""

    metadata: OptionalNullable[Dict[str, Any]] = UNSET
    r"""Arbitrary metadata for the payment link."""

    buyer: OptionalNullable[TransactionBuyer] = UNSET
    r"""The buyer associated with the payment link."""

    shipping_details: OptionalNullable[ShippingDetails] = UNSET
    r"""The shipping details for the payment link."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "expires_at",
            "external_identifier",
            "statement_descriptor",
            "locale",
            "merchant_name",
            "merchant_url",
            "merchant_banner_url",
            "merchant_color",
            "merchant_message",
            "merchant_terms_and_conditions_url",
            "merchant_favicon_url",
            "return_url",
            "metadata",
            "buyer",
            "shipping_details",
        ]
        nullable_fields = [
            "expires_at",
            "external_identifier",
            "statement_descriptor",
            "locale",
            "merchant_name",
            "merchant_url",
            "merchant_banner_url",
            "merchant_color",
            "merchant_message",
            "merchant_terms_and_conditions_url",
            "merchant_favicon_url",
            "return_url",
            "cart_items",
            "metadata",
            "buyer",
            "shipping_details",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
